﻿'use strict'; // always use strict mode!

// Declare the sunburst object in the global scope so we can reference it in
// event handlers, debug it in the browser console, etc.

var mySunburst;
WijmoPeriodicSunburst.ElementDataLoader.generateElementCollectionView(function (elementCollectionView) {

    // Initialize the property tile
    var myPropTile = WijmoPeriodicSunburst.PropertiesTile;
    myPropTile.attachToDom(document.getElementById('properties-tile'));

    // Here we hook up PropertyTile's centerInParent() method to the window's resize event
    window.onresize = function () {
        myPropTile.centerInParent();
    };

    mySunburst = new wijmo.chart.hierarchical.Sunburst('#periodic-sunburst'); // initialize!

    // Let the Sunburst Chart know we're going to start making changes
    mySunburst.beginUpdate();

    // Set some stylistic properties for the chart
    mySunburst.legend.position = 'None'; // hide the legend
    mySunburst.innerRadius = 0.3; // set up a relatively large space for displaying info
    mySunburst.selectionMode = 'Point';
    mySunburst.dataLabel.position = 'Center'; // center panel labels
    mySunburst.dataLabel.content = '{name}'; // the panel should display its name (derived from bindingName property)

    mySunburst.itemsSource = elementCollectionView.groups; // set the items source to the array generated by the DataSourceAdapter
    mySunburst.binding = 'value'; // bind each item to the constant 'value' property to get equal arc angles for all element panels
    mySunburst.bindingName = ['name', 'name', 'symbol']; // set the property that gives the name we want to display for each chart level
    mySunburst.childItemsPath = ['groups', 'items']; // set the property names that hold the children for each level (remember our data structure is Group.subGroups.elements)

    /* Logic to handle all chart clicks and associated functions */

    // Set up a function to listen for click events on the Sunburst Chart's parent DOM element
    mySunburst.hostElement.addEventListener('click', function (e) {

        // If a panel is clicked, visually select it
        markSelectedPanel(e.clientX, e.clientY);

        // Perform a hit test to get a clicked panel's name then use it to set up the info panel via the ViewAdapter
        var ht = mySunburst.hitTest(e.pageX, e.pageY);
        myPropTile.showInfoPanel(ht.item);
    });

    // Set selected element variables in this outer scope to preserve them
    var lastSelectedEle;
    var lastSelectedEleFillColor;

    // Keep track of any hidden text elements using an array
    // This has to be able to store multiple hidden text elements for the case
    // where labels overlap
    var hiddenTextElements = [];

    /**
     * Visually marks a panel at the given coordinates as selected
     *
     * @param {number} panelX the X coordinate of the panel to mark
     * @param {number} panelY the Y coordinate of the panel to mark
     */
    function markSelectedPanel(panelX, panelY) {

        // First, 'unselect' (restore the fill color of) the element that was selected last, if there is one
        if (typeof (lastSelectedEle) !== 'undefined' && typeof (lastSelectedEleFillColor) !== 'undefined') {
            lastSelectedEle.setAttribute('fill', lastSelectedEleFillColor);
        }

        // Define our selected element and check to see if it's a panel that we can fill
        var selectedElement = document.elementFromPoint(panelX, panelY);

        if (typeof (selectedElement) !== 'undefined' && selectedElement.hasAttribute('fill') && selectedElement.tagName === 'path') {

            // Reset the lastSelectedEle and then change the fill color of the clicked panel
            lastSelectedEle = selectedElement;
            var fillColor = selectedElement.getAttribute('fill');
            lastSelectedEleFillColor = fillColor;
            var rgbaValues = fillColor.replace('rgba(', '').replace(')', '').split(',');
            rgbaValues[3] = '1.0';
            selectedElement.setAttribute('fill', 'rgba(' + rgbaValues.join(',') + ')');

            while (hiddenTextElements.length > 0) { // if we hid any text elements in the process, reshow them
                hiddenTextElements.pop().style.display = 'block';
            }

        } else if (typeof (selectedElement) !== 'undefined' && selectedElement.tagName === 'text') { // super hacky way to get the right panel if a data label is clicked

            // Hide the data label
            selectedElement.style.display = 'none';

            // Keep track of hidden text elements
            hiddenTextElements.push(selectedElement);

            // Run the method again with the data label hidden
            markSelectedPanel(panelX, panelY);
        }
        return false;
    }

    // Let the chart know that everything is updated now
    mySunburst.endUpdate();
});
