﻿/*!@license
* Infragistics.Web.ClientUI Combo 15.2.20152.1033
*
* Copyright (c) 2011-2015 Infragistics Inc.
*
* http://www.infragistics.com/
*
* Depends on:
* jquery-1.8.3.js
* jquery.ui.core.js
* jquery.ui.widget.js
* infragistics.templating.js
* infragistics.util.js
* infragistics.dataSource.js
*
* Example to use:
*   <script type="text/javascript">
*   $(function () {
*       $('#combo').igCombo();
*   });
*   </script>
*   <input id="combo" />
*/

/*global jQuery*/
(function ($) {
    /*
		igCombo is a widget based on jQuery UI that provides ability to edit text and show drop-down list.
		Drop-down list supports multiple selection, filtering, templating, rendering matching items, active item, etc.
		Editing of field supports auto-complete, editing multiple items, synchronization with selection in drop-down list, clear button, etc.
	*/
    $.widget('ui.igCombo', {
        options: {
            /* type="number|string" Gets sets width of combo. The numeric and string values (valid html units for size) are supported. It includes %, px, em and other units. */
            width: null,
            /* type="number|string" Gets sets height of combo. The numeric and string values (valid html units for size) are supported. It includes %, px, em and other units. */
            height: null,
            /* type="number|string" Gets sets width of drop down list in pixels */
            dropDownWidth: null,
            /* type="object" Gets sets a valid data source accepted by $.ig.DataSource, or an instance of an $.ig.DataSource itself.
				Note: if it is set to string and "dataSourceType" option is not set, then $.ig.JSONDataSource is used.
			*/
            dataSource: null,
            /* type="string" Gets sets data source type (such as "json", "xml", etc). Please refer to the documentation of $.ig.DataSource and its type property */
            dataSourceType: null,
            /* type="string" Gets sets url which is used for sending JSON on request for remote filtering (MVC for example). That option is required when load on demand is enabled and its type is remote. */
            dataSourceUrl: null,
            /* type="string" see $.ig.DataSource. property in the response specifying the total number of records on the server. */
            responseTotalRecCountKey: null,
            /* type="string" see $.ig.DataSource. This is basically the property in the responses where data records are held, if the response is wrapped. */
            responseDataKey: null,
            /* 
				type="json|xml|html|script|jsonp|text" Response type when a URL is set as the data source. See http://api.jquery.com/jQuery.ajax/ => dataType 
				json type="string"
				xml type="string"
				html type="string"
				script type="string"
				jsonp type="string"
				text type="string"
			*/
            responseDataType: null,
            /* type="string" content type of the response. See http://api.jquery.com/jQuery.ajax/ => contentType */
            responseContentType: null,
            /* type="string" specifies the HTTP verb to be used to issue the request */
            requestType: "GET",
            /* type="string" Gets sets name of column which contains the "value". If it is missing, then name of first column will be used. */
            valueKey: null,
            /* type="string" Gets sets name of column which contains the displayed text. If it is missing, then "valueKey" option will be used. */
            textKey: null,
            /* type="string" Gets sets template used to render an item in list. The igCombo utilizes igTemplating for generating node content templates.
			    More info on the templating engine can be found here: http://www.igniteui.com/help/infragistics-templating-engine
			*/
            itemTemplate: null,
            /* type="string" Gets sets template used to render header in drop-down list. The template is rendered inside of DIV html element. */
            headerTemplate: null,
            /* type="string" Gets sets template used to render footer in drop-down list. 
				Notes:
					1. The template is rendered inside of DIV html element.
					2. The following variables can be used: 
						- {0}: Number of records in igCombo (view of dataSource)
						- {1}: Number of records in dataSource
						- {2}: Number of (filtered) records on server
						- {3}: Number of all records on server
			*/
            footerTemplate: null,
            /* type="null|string" Gets sets name of the hidden INPUT element, which is used when submiting data. Its value will be set to values of selected items valueKeys separated by ', ' character on any change in igCombo. If the combo element has 'name' attribute and this option is not set, the 'name' attribute will be used for the input name */
            inputName: null,
            /* type="number" Gets sets show drop-down list animation duration in milliseconds. */
            animationShowDuration: 100,
            /* type="number" Gets sets hide drop-down list animation duration in milliseconds. */
            animationHideDuration: 100,
            /* type="bool" Gets sets ability to append container of drop-down list to the body or to the parent of combo. */
            dropDownAttachedToBody: true,
            /* type="remote|local|none" Gets sets type of filtering.
				Note:
				If this option is set to "remote", then the "css.waitFiltering" is applied to combo and its drop-down list.
				remote type="string" filtering is performed by server
				local type="string" filtering is performed by $.ig.DataSource
				none type="string" filtering is disabled
			*/
            filteringType: "local",
            /* type="string" Gets sets url key name that specifies how the remote filtering expressions will be encoded for remote requests, e.g. &filter('col') = startsWith. Default is OData */
            filterExprUrlKey: null,
            /* type="contains|doesNotContain|startsWith|endsWith|greaterThan|lessThan|greaterThanOrEqualTo|lessThanOrEqualTo|equals|doesNotEqual" Gets sets condition used for filtering.
				Note: When auto complete is enabled, the filtering condition is always "startsWith" */
            filteringCondition: "contains",
            /* type="OR|AND" Gets sets filtering logic. */
            filteringLogic: "OR",
            /* type="string" Gets sets text of list item for condition when "filteringType" option is enabled and no match was found. That is an override for the $.ig.Combo.locale.noMatchFoundText. */
            noMatchFoundText: null,
            /* type="object" Gets sets container of variables which define load on demand functionality.
				Notes:
				That option has effect only when data is loaded remotely using dataSourceUrl.
				Selection is supported only for already loaded items.
			*/
            loadOnDemandSettings: {
                /* type="bool" Gets sets option to enable load on demand.  */
                enabled: false,
                /* type="number" Gets sets number of records loaded on each request.  */
                pageSize: 16
            },
            /* type="number" Gets sets how many items should be shown at once. 
			   Notes:
			   That options is used for virtualization in order to render initial list items. 
			*/
            visibleItemsCount: 15,
            /* type="string" Gets sets value that is displayed when input field is empty. That is an override for the $.ig.Combo.locale.placeHolder. */
            placeHolder: null,
            /* type="editable|dropdown|readonlylist|readonly" Sets gets functionality mode.
				editable type="string" Allows to modify value by edit field and drop-down list.
				dropdown type="string" Allows to modify value by drop-down list only.
				readonlylist type="string" Allows to open list, but does not allow any changes in field or selection in drop-down list. If selection is not set, then first item in dataSource is automatically selected.
				readonly type="string" Does not allow to open list or change value in field. If selection is not set, then first item in dataSource is automatically selected.
			*/
            mode: 'editable',
            /* type="bool" Gets sets ability to use virtual rendering for drop-down list. Enable to boost performance when combo has lots of records.
				If that option is enabled, then only visible items are created and top edge of first visible item in list is aligned to the top edge of list.  */
            virtualization: false,
            /* type="object" Gets sets object specifying multi selection feature options. The object has following properties enabled, addWithKeyModifier, showCheckboxes and itemSeparator. Note showCheckboxes and itemSeparator has effect only if multi selection is enabled. */
            multiSelection: {
                /* type="bool" Set enabled to true to turn multi selection on. Set to true by default when target element for the combo is a select with the multiple attribute set. */
                enabled: false,
                /* type="bool" Set addWithKeyModifier to true to disable the additive selection, then additive selection can be done by ctrl + mouse click / enter. */
                addWithKeyModifier: false,
                /* type="bool" Set showCheckboxes to true to render check boxes in front of each drop down item.  */
                showCheckboxes: false,
                /* type="bool" Use itemSeparator to set what string to be rendered between items in field. */
                itemSeparator: ', '
            },
            /* type="object" Gets sets object specifying grouping feature options. The option has key and dir properties */
            grouping: {
                /* type="string" Gets sets name of column by which the records to be grouped. Setting this option enables the grouping. */
                key: null,
                /* type="asc|desc" Specifies the sort order - ascending or descending */
                dir: 'asc'
            },
            /* type="object" Gets or sets object which contains options supported by igValidator.
				Notes: in order for validator to work, application should ensure that igValidator is loaded (ig.ui.validator.js/css files).
				Example:
				$('#combo1').igCombo({ validatorOptions: { required: true } }); */
            validatorOptions: null,
            /* type="multi|contains|startsWith|full|null" Gets sets condition used for highlighting of matching parts in items of drop-down list.
				multi type="string" multiple matches in a single item are rendered
				contains type="string" match at any position in item is rendered
				startsWith type="string" only match which starts from the beginning of text is rendered
				full type="string" only fully matched items are rendered
				null type="object" matches are not rendered
			*/
            highlightMatchesMode: 'multi',
            /* type="bool" Gets sets whether filtering and auto selection should be case sensitive */
            caseSensitive: false,
            /* type="bool" Gets sets whether the first matching item should be auto selected when typing in input. When multi selection is enabled this option will instead put the active item on the matching element. */
            autoSelectFirstMatch: true,
            /* type="bool" Gets sets ability to autocomplete field from first matching item in list.
				Note: When "autoComplete" option is enabled, then the "startsWith" is used for "filteringCondition" option */
            autoComplete: false,
			/* type="bool" Gets sets the ability to enter and keep custom value in the input field.
				Notes for enabled:
				1. Allows custom value input only with single selection.
				2. Custom values will be auto completed to the closest value if autoComplete is enabled.
			*/
			allowCustomValue: false,
            /* type="bool" Gets sets ability to close drop-down list when control loses focus. */
            closeDropDownOnBlur: true,
            /* type="number" Specifies the delay duration before processing the changes in the input. Useful to boost performance by lowering the count of selection, filtering, auto complete and highlighting operations executed on each input change. */
            delayInputChangeProcessing: 250,
            /* type="number" Gets sets tabIndex for field of combo. */
            tabIndex: null,
            /* type="bool" Gets sets ability to show drop down list when combo gets focus. This option has effect only if mode is 'editable' */
            dropDownOnFocus: false,
            /* type="bool" Gets sets ability to close drop down list when single item in the list is selected with mouse click or enter press. The default value when multi selection is enabled will be false. This option will not close the drop down when multiple selection is enabled and additive selection is performed. */
            closeDropDownOnSelect: true,
            /* type="bool" Gets sets ability to select items by space button press */
            selectItemBySpaceKey: false,
            /* type="array" Gets sets list of items to be selected when combo is initialized. It should contain array of objects with index or value property, then on initialization matching items will be selected. When mode is drop down with single selection, readonly, readonlylist or combo is initialized on select element the first item will be selected if this option is not set.
				Note: Only items loaded on initialization can be selected. When load-on-demand attempt to select not loaded item will fail.
			*/
            initialSelectedItems: [{
                /* type="number" optional="true" Index of item in list. Value should be larger than -1 and less than number of items in list (rows in  dataSource)  */
                index: -1,
                /* type="object" optional="true" Value matching the valueKey property of the item */
                value: null
            }],
            /* type="bool" Gets sets ability to prevent form submitting on enter key press */
            preventSubmitOnEnter: true,
            /* type="string" Gets or sets the format string that is used to format the text display values in the combo. 
				Valid options are:
				"auto" (default) - uses automatic formatting for Date and number objects.
				"none", "", or null - will disable formatting

				Custom values can be something like "currency", "percent", "dateLong", "time", "MMM-dd-yyyy H:mm tt", etc.

				Custom format strings should match the data type in "textKey" column.
			*/
            format: "auto",
            /* type="boolean" Specifies whether the clear button should be rendered. When mode is drop down with single selection, readonly or readonlylist this option will default to false. It can still be enabled when it is specifically set to true. */
            enableClearButton: true,
            /* type="string" Gets sets title for html element which represend drop-down button. That is an override for the $.ig.Combo.locale.dropDownButtonTitle. */
            dropDownButtonTitle: null,
            /* type="string" Gets sets title for html element which represend clear button. That is an override for the $.ig.Combo.locale.clearButtonTitle. */
            clearButtonTitle: null,
            /* type="auto|bottom|top" Gets sets drop down opening orientation for the dorp down list when open button is clicked 
			   'auto' type="string"
			   'bottom' type="string"
			   'top' type="string"
			*/
            dropDownOrientation: "auto"
        },
        events: {
            /* cancel="false" Event which is raised after rendering of the combo completes.
				Function takes arguments evt and ui.
				Use ui.owner to get a reference to the combo performing rendering.
				Use ui.element to get a reference to the main/top combo element.
			*/
            rendered: 'rendered',
            /* cancel="true" Event which is raised before data binding is performed.
				Function takes arguments evt and ui.
				Use ui.owner to get a reference to igCombo performing the databinding.
				Use ui.dataSource to get a reference to the $.ig.DataSource combo is to be databound to. */
            dataBinding: 'dataBinding',
            /* cancel="false" Event which is raised after data binding is complete.
				Function takes arguments evt and ui.
				Use ui.owner to obtain reference to igCombo performing the data binding.
				Use ui.dataSource to get a reference to the $.ig.DataSource combo is databound to.
				Use ui.success to see if the databinding was performed correctly.
				Use ui.errorMessage to get the error message if the databinding failed. */
            dataBound: 'dataBound',
            /* cancel="true" Event which is raised before data filtering.
				Function takes arguments evt and ui.
				Use ui.owner to obtain reference to igCombo.
				Use ui.expression to obtain reference to array which contains expressions supported by $.ig.DataSource.
				Each expression-item contains following members: fieldName (textKey), cond (filteringCondition), expr (value/string to filter). */
            filtering: 'filtering',
            /* cancel="false" Event which is raised after filtering.
				Function takes arguments evt and ui.
				Use evt.originalEvent to obtain reference to event of browser. That can be null.
				Use ui.owner to obtain reference to igCombo.
				Use ui.elements to obtain a jquery reference to the rendered filtered elements.
			*/
            filtered: 'filtered',
            /* cancel="true" Event which is raised before rendering of the combo items is performed.
				Function takes arguments evt and ui.
				Use ui.owner to get a reference to the combo performing rendering.
				Use ui.dataSource to get a reference to the $.ig.DataSource combo is databound to.
			*/
            itemsRendering: 'itemsRendering',
            /* cancel="false" Event which is raised after rendering of the combo items completes.
				Function takes arguments evt and ui.
				Use ui.owner to get a reference to the combo performing rendering.
				Use ui.dataSource to get a reference to the $.ig.DataSource combo is databound to.
			*/
            itemsRendered: 'itemsRendered',
            /* cancel="true" Event which is raised before drop-down list is opened.
				Return false in order to cancel drop-down action.
				Function takes arguments evt and ui.
				Use ui.owner to obtain reference to igCombo.
				Use ui.list to obtain reference to jquery DOM element which represents drop down list container.
			*/
            dropDownOpening: 'dropDownOpening',
            /* cancel="false" Event which is raised after drop-down list was opened.
				Function takes arguments evt and ui.
				Use ui.owner to obtain reference to igCombo.
				Use ui.list to obtain reference to jquery DOM element which represents drop down list container.
			*/
            dropDownOpened: 'dropDownOpened',
            /* cancel="true" Event which is raised before drop-down list is closed.
				Return false in order to cancel hide action.
				Function takes arguments evt and ui.
				Use ui.owner to obtain reference to igCombo.
				Use ui.list to obtain reference to jquery DOM element which represents drop down list container.
			*/
            dropDownClosing: 'dropDownClosing',
            /* cancel="false" Event which is raised after drop-down list was closed.
				Function takes arguments evt and ui.
				Use evt.originalEvent to obtain reference to event of browser.
				Use ui.owner to obtain reference to igCombo.
				Use ui.list to obtain reference to jquery DOM element which represents drop down list container.
			*/
            dropDownClosed: 'dropDownClosed',
            /* cancel="true" Event which is raised before selection change.
				Return false in order to cancel change.
				Function takes arguments evt and ui.
				Use ui.owner to obtain reference to igCombo.
				Use ui.currentItems to obtain reference to array of the selected items before the new selection has happened. That can be null.
				Use ui.items to obtain reference to array of all items that will be selected after the selection finish. That can be null.
			*/
            selectionChanging: 'selectionChanging',
            /* cancel="false" Event which is raised after selection change.
				Function takes arguments evt and ui.
				Use ui.owner to obtain reference to igCombo.
				Use ui.items to obtain reference to array of new selected items. That can be null.
				Use ui.oldItems to obtain reference to array of old selected items. That can be null.
			*/
            selectionChanged: 'selectionChanged'
        },
        css: {
            /* Class applied to the wrapper element. */
            comboWrapper: 'ui-igcombo-wrapper',
            /* Class applied to the combo element. */
            combo: 'ui-igcombo ui-widget ui-state-default ui-corner-all ui-unselectable',
            /* Class applied to the combo in drop down mode. */
            dropDownMode: 'ui-igcombo-mode-dropdown',
            /* Class applied to the combo in read only mode. */
            readOnlyMode: 'ui-igcombo-mode-readonly',
            /* Class applied to the combo in read only list mode. */
            readOnlyListMode: 'ui-igcombo-mode-readonlylist',
            /* Class applied to the text box container */
            textBox: 'ui-igcombo-textbox ui-state-default ui-corner-all',
            /* Class applied to the editing element. */
            field: 'ui-igcombo-field ui-corner-all',
            /* Class applied to the holder of editing element. */
            fieldHolder: 'ui-igcombo-fieldholder',
            /* Class applied to the holder of editing element when direction is left to right. */
            fieldHolderLTR: 'ui-igcombo-fieldholder-ltr ui-corner-left',
            /* Class applied to the holder of editing element when direction is right to left. */
            fieldHolderRTL: 'ui-igcombo-fieldholder-rtl ui-corner-right',
            /* Class applied to the drop down list when directino is right to left*/
            dropDownListRTL: 'ig-rtl',
            /* Class applied to the DIV element which represents the drop down button. */
            button: 'ui-igcombo-button ui-state-default ui-unselectable',
            /* Classes applied to the DIV element which represents image on drop down button. */
            buttonIcon: 'ui-igcombo-buttonicon ui-icon-triangle-1-s ui-icon',
            /* Class applied to the DIV element which represents drop down button when direction is left to right. */
            buttonLTR: 'ui-igcombo-button-ltr ui-corner-right',
            /* Class applied to the DIV element which represents drop down button when direction is right to left. */
            buttonRTL: 'ui-igcombo-button-rtl ui-corner-left',
            /* Class applied to the DIV element which represents clear button. */
            clear: 'ui-igcombo-clear ui-unselectable',
            /* Classes applied to the SPAN element of clear button in mouse-over state. */
            clearHover: 'ui-igcombo-clear-hover ui-state-hover',
            /* Class applied to the DIV element which represents image on clear button. */
            clearIcon: 'ui-igcombo-clearicon ui-icon-circle-close ui-icon',
            /* Class applied to the DIV element which represents the combo drop down. It contains the list, the header and the footer containers. */
            dropDown: 'ui-igcombo-dropdown ui-widget ui-widget-content ui-corner-all',
            /* Class applied to the DIV element which is used as container for drop down list. */
            list: 'ui-igcombo-list',
            /* Class applied to the drop down container element when virtualization is enabled. */
            listOverflow: 'ui-igcombo-list-overflow',
            /* Class applied to the UL element which is used as container for list items. */
            listItemHolder: 'ui-igcombo-listitemholder',
            /* Classes applied to the LI element which represents item in drop down list. */
            listItem: 'ui-igcombo-listitem ui-state-default ui-unselectable',
            /* Classes applied to the DIV element which represents header in combo drop down. */
            header: 'ui-igcombo-header',
            /* Classes applied to the DIV element which represents footer in combo drop down. */
            footer: 'ui-igcombo-footer',
            /* Classes applied to the element which holds group of list items in drop down list. */
            group: 'ui-igcombo-group',
            /* Classes applied to the header element of each group */
            groupHeader: 'ui-igcombo-group-header ui-state-default ui-unselectable',
            /* Class applied to the list item elements hover with mouse or navigated to by keyboard */
            itemInFocus: 'ui-igcombo-item-in-focus',
            /* Class applied to the text in LI element which represents highlighted text in dropdown list. */
            listItemHighlighted: 'ui-igcombo-highlight',
            /* Class applied to LI element that is shown when no matches are found while filtering */
            noMatchFound: 'ui-igcombo-nomatchfound',
            /* Class applied to the SPAN element which represents text of item in dropdown list when checkboxes are enabled. */
            listItemTextWithCheckbox: 'ui-igcombo-listitemtextwithcheckbox',
            /* Class applied to the SPAN element which represents checkbox in list item. */
            checkbox: 'ui-igcombo-checkbox ui-state-default ui-corner-all ui-igcheckbox-small',
            /* Class applied to the SPAN element which represents icon in unchecked checkbox. */
            checkboxOff: 'ui-icon ui-igcombo-checkbox-off ui-igcheckbox-small-off',
            /* Class applied to the SPAN element which represents icon in unchecked checkbox. */
            checkboxOn: 'ui-icon ui-icon-check ui-igcombo-checkbox-on ui-igcheckbox-small-on',
            /* Class applied to the hidden input field */
            hiddenField: 'ui-igcombo-hidden-field',
            /* Class applied to elements when hovered. */
            hover: 'ui-state-hover',
            /* Class applied to elements in active state. */
            active: 'ui-state-active',
            /* Class applied to unselectable elements */
            unselectable: 'ui-unselectable',
            /* Class applied to drop down element when it is closed. */
            noBorder: 'ui-igcombo-no-border',
            /* Class applied to the scroll holder element when virtualization is enabled. */
            scrollHolder: 'ui-igcombo-scrollholder ui-unselectable',
            /* Class applied to the scroll element when virtualization is enabled. */
            scroll: 'ui-igcombo-scroll ui-unselectable',
            /* Class applied to the span element in the footer that represents the number of records in data source view */
            recordsView: 'ui-igcombo-records-view',
            /* Class applied to the span element in the footer that represents the number of records in the data source */
            recordsData: 'ui-igcombo-records-data',
            /* Class applied to the span element in the footer that represents the number of filtered records on the server */
            recordsServer: 'ui-igcombo-records-server',
            /* Class applied to the span element in the footer that represents the number of total records on the server */
            recordsServerTotal: 'ui-igcombo-records-server-total',
            /* Class applied to the DIV which represents overlay over drop down list while data is retrieving. */
            loading: 'ui-igcombo-loading',
            /* Class applied to filtered list items to hide them */
            hidden: 'ui-helper-hidden',
            /* Class applied to combo top element when in readonly mode */
            disabled: 'ui-state-disabled',
            /* Class applied to combo drop down element when top orientation is used */
            orientationTop: 'ui-igcombo-orientation-top',
            /* Class applied to combo drop down element when bottom orientation is used */
            orientationBottom: 'ui-igcombo-orientation-bottom'
        },
        /* Number of records in igCombo (view of dataSource) */
        RECORDS_VIEW: '{0}',
        /* Number of records in dataSource */
        RECORDS_DATA: '{1}',
        /* Number of (filtered) records on server */
        RECORDS_SERVER: '{2}',
        /* Number of all records on server */
        RECORDS_SERVER_TOTAL: '{3}',
        _createWidget: function (options) {
            var mode;

            // Private variables
            this._options = {
                $window: $(window),
                $comboWrapper: null,
                $combo: null,
                $input: null,
                $hiddenInput: null,
                $fieldCont: null,
                $clearCont: null,
                $clearIcon: null,
                $dropDownBtnCont: null,
                $dropDownBtnIcon: null,
                $dropDownCont: null,
                $dropDownListCont: null,
                $dropDownList: null,
                $header: undefined,
                $footer: undefined,
                $dropDownScrollCont: null,
                $dropDownScroll: null,
                $loading: null,
                $noMatchFound: null,
                $itemsToSelectOnShiftUpDown: $(),
                $itemsToSelectOnShiftClick: $(),
                selectedData: [],
                keyNavItemData: null,
                autoSelectedItemData: null,
                autoCompleteItemData: null,
                inputVal: "",
                highlightElement: "span",
                ltr: true,
                dropDownOpened: false,
                deltaItemsForLoadOnDemand: 5,
                dataBinding: false,
                shiftKeyCode: 16,
                validator: null,
                shiftDown: false,
                // If the initial element is input or select, cache the name, remove it, set it to the hidden input for submit and upon destroy return it
                nameAttribute: "",
                // Subscribe to fire callbacks when selection is changed from api
                internalSelChangeSubs: null,
                initialDataBinding: true,
                remoteFilteringTriggerEvt: null,
                preventInputBlur: false,
                // Track whether mouse down started from any list item to highlight elements on mouse hover
                mouseDownStartedFromListItem: false,
                // We need to cache the records in order to have correct input values for remote filtering
                cachedData: [],
                strDataSource: null,
                updateInputValuesOnRemoteFilter: false,
                hasFooterVariables: false,
                // Tracks whether the input field had text selection when a key was pressed down,
                // to handle correctly backspace when auto complete is enabled
                hadInputSelectionOnKeydown: false,
                // The filtering expression
                expression: null,
                preventItemSeparatorOnFocus: false,
                preventDropDownOnFocus: false,
                keyUpTimeout: null,
                repositionInterval: null,
                disableScroll: false,
                cachedGroupLength: null,
                initialGroupHeaders: 1,
                // The string that will be used to match item's text when user types in drop down mode
                dropDownModeSearchBy: '',
                dropDownModeSearchByResetTimeout: null,
                dropDownModeSearchByResetDelay: 1000,
                originalOptions: options,
                // S.T. 6th July, 2015 #201924: Use template for checkbox markup
                checkboxItemTemplate: "<span class='{css.checkbox}'><span class='{css.checkboxOff}''></span></span><div class='{css.listItemTextWithCheckbox}'>{innerMarkup}</div>",
                scrollCallback: null
            };

            if (options) {
                mode = options.mode;

                // Default closeDropDownOnSelect to false when multi selection is enabled
                if (options.multiSelection && options.multiSelection.enabled &&
					options.closeDropDownOnSelect === undefined) {
                    options.closeDropDownOnSelect = false;
                }

                // Default enableClearButton to false when mode readonly, readonlylist or drop down with single selection
                if ((mode === 'readonly' || mode === 'readonlylist') ||
					(mode === 'dropdown' && !(options.multiSelection && options.multiSelection.enabled)) &&
					options.enableClearButton === undefined) {
                    options.enableClearButton = false;
                }
            }

            $.Widget.prototype._createWidget.apply(this, arguments);
        },
        _create: function () {
            // Event handlers
            this._handlers = {
                windowResize: $.proxy(this._windowResize, this),
                documentMouseUp: $.proxy(this._documentMouseUp, this),
                inputFocus: $.proxy(this._inputFocus, this),
                inputBlur: $.proxy(this._inputBlur, this),
                inputClick: $.proxy(this._inputClick, this),
                inputKeyDown: $.proxy(this._inputKeyDown, this),
                inputPaste: $.proxy(this._inputPaste, this),
                inputKeyUp: $.proxy(this._inputKeyUp, this),
                inputKeyPress: $.proxy(this._inputKeyPress, this),
                inputMouseDown: $.proxy(this._inputMouseDown, this)
            };

            this._analyzeOptions();
            this._analyzeInitialElem();
            this._render();
            this.validator();
            this._attachEvents();
            this.dataBind();
        },
        _analyzeOptions: function () {
            var key, firstDataItem,
				options = this.options,
				$combo = $(this.element),
				lod = options.loadOnDemandSettings;

            if (this.options.dataSource) {
                if ($.isArray(this.options.dataSource)) {
                    firstDataItem = this.options.dataSource[0];
                } else if (this.options.dataSource &&
					typeof this.options.dataSource._xmlToArray === "function" &&
					typeof this.options.dataSource._encodePkParams === "function") {
                    // if isIgDataSource
                    //isInstanceOfDs = ds && typeof ds._xmlToArray === "function" && typeof ds._encodePkParams === "function";
                    firstDataItem = this.options.dataSource.data()[0];
                }
            }

            // Mode
            if (options.mode !== 'editable' && options.mode !== 'dropdown' &&
				options.mode !== 'readonly' && options.mode !== 'readonlylist') {
                options.mode = 'editable';
            }

            // Page size
            if (lod && lod.enabled && lod.pageSize && options.loadOnDemandSettings.pageSize < 5) {
                lod.pageSize = 5;
            } else if (lod && lod.enabled && !lod.pageSize) {
                lod.pageSize = this.options.visibleItemsCount + 1;
            }

            // Text key
            if (!options.textKey) {
                if (options.valueKey) {
                    options.textKey = options.valueKey;
                } else if (firstDataItem && $.type(firstDataItem) === 'object') {
                    // Use first data source column
                    for (key in firstDataItem) {
                        if (firstDataItem.hasOwnProperty(key)) {
                            options.textKey = key;
                            break;
                        }
                    }
                }
            }

            // Value key
            if (!options.valueKey) {
                options.valueKey = options.textKey;
            }

            // Use default values when textKey/valueKey are still not set
            if (!options.textKey && !options.valueKey) {
                options.textKey = "text";
                options.valueKey = "value";
            }

            // Filtering type
            if (options.filteringType !== 'local' && options.filteringType !== 'remote' && options.filteringType !== 'none') {
                options.filteringType = 'none';
            }

            // Input name
            if ($combo.attr("name") && this._options.originalOptions.inputName === undefined) {
                options.inputName = $combo.attr("name");
            }

            // No match found text
            this.options.noMatchFoundText = this.options.noMatchFoundText ||
				$.ig.Combo && $.ig.Combo.locale && $.ig.Combo.locale.noMatchFoundText ||
				'No Results';

            // Place holder text
            // Z.K. September 16, 2015 Bug fix #206656 - When empty string is set as placeHolder, the default string "select..." is used
            if (this.options.placeHolder === '') {
                this.options.placeHolder = '';
            } else {
                this.options.placeHolder = this.options.placeHolder ||
                    $.ig.Combo && $.ig.Combo.locale && $.ig.Combo.locale.placeHolder ||
                    'select...';
            }

            // Clear button title
            this.options.clearButtonTitle = this.options.clearButtonTitle ||
				$.ig.Combo && $.ig.Combo.locale && $.ig.Combo.locale.clearButtonTitle ||
				'Clear value';

            // Drop down button title
            this.options.dropDownButtonTitle = this.options.dropDownButtonTitle ||
				$.ig.Combo && $.ig.Combo.locale && $.ig.Combo.locale.dropDownButtonTitle ||
				'Show drop-down';

            // Multiple attribute
            // JD 6/25/15 - Bug 201623 - The attribute should only apply if multiSelection.enabled was not
            // set by the developer.
            if ($combo.attr('multiple') === 'multiple' &&
				(this._options.originalOptions.multiSelection === undefined ||
				this._options.originalOptions.multiSelection.enabled === undefined)) {
                this.options.multiSelection.enabled = true;
            }

            // Right-to-left implementation
            // Z.K 25/08/15 Bug #189210 - When combo is initialized form input with dir="rtl", list is not aligned correct
            if ($combo.attr('dir') === 'rtl') {
                this._options.ltr = false;
            }

            if (this.options.grouping.key && firstDataItem && firstDataItem[this.options.grouping.key] === undefined) {
            	throw new Error($.ig.Combo.locale.errorIncorrectGroupingKey);
            }
        },
        _analyzeInitialElem: function () {
            var element = this.element,
				_options = this._options;

            if (element.is('div') || element.is('span')) {
                // Use the provided div/span as wrapper container
                _options.$comboWrapper = element;
            } else if (element.is('input')) {
                // Use the provided input field for combo's input
                _options.$input = element;
                _options.nameAttribute = element.attr("name");
                element.removeAttr("name");
            } else if (element.is('select')) {
                element.hide();
                _options.nameAttribute = element.attr("name");
                element.removeAttr("name");
            }
        },
        _setupInput: function () {
            var _options = this._options;

            // Add input's place holder
            _options.$input.attr('placeholder', this.options.placeHolder);

            if (this.options.mode !== 'editable') {
                // Disable editing and selection for non-editable modes
                _options.$input
					.attr({
					    'readonly': true,
					    'unselectable': 'on'
					})
					.addClass(this.css.unselectable);
            }
        },
        _render: function () {
            var $header, $footer, footerMarkup,
				css = this.css,
				options = this.options,
				_options = this._options,
				$comboWrapper = (_options.$comboWrapper || $('<div>')).addClass(css.comboWrapper),
				$combo = $('<div>').addClass(css.combo).attr('unselectable', 'on'),
				$input = (_options.$input || $('<input type="text">')).addClass(css.field).attr({ tabIndex: options.tabIndex, autocomplete: 'off' }),
				$hiddenInput = $('<input type="hidden">').addClass(css.hiddenField),
				$fieldCont = $('<div>').addClass(css.fieldHolder),
				$clearCont = $('<div>').addClass(css.clear).attr({ unselectable: 'on', title: options.clearButtonTitle }),
				$clearIcon = $('<div>').addClass(css.clearIcon),
				$dropDownBtnCont = $('<div>').addClass(css.button).attr({ unselectable: 'on', title: options.dropDownButtonTitle }),
				$dropDownBtnIcon = $('<div>').addClass(css.buttonIcon),
				$dropDownCont = $('<div>').addClass(css.dropDown).width(options.dropDownWidth),
				$dropDownListCont = $('<div>').addClass(css.list),
				$dropDownList = $('<ul>').addClass(css.listItemHolder),
				$dropDownScrollCont = $('<div>').addClass(css.scrollHolder).attr('unselectable', 'on'),
				$dropDownScroll = $('<div>').addClass(css.scroll).attr('unselectable', 'on'),
				$loading = $('<div>').addClass(css.loading);

            // Set combo mode class
            switch (options.mode) {
                case 'dropdown':
                    $combo.addClass(css.dropDownMode);
                    break;
                case 'readonlylist':
                    $combo.addClass(css.readOnlyListMode);
                    break;
                case 'readonly':
                    $combo.addClass(css.readOnlyMode);
                    $comboWrapper.addClass(css.disabled);
                    break;
            }

            // TO DO: Check where these classes are used and remove them
            $fieldCont.addClass(css.fieldHolderLTR);
            $dropDownBtnCont.addClass(css.buttonLTR);

            // Add ltr/rtl classes
            if (!_options.ltr) {
                // Z.K 25/08/15 Bug #189210 - When combo is initialized form input with dir="rtl", list is not aligned correct
                $dropDownList.addClass(css.dropDownListRTL);
            }

            if (options.grouping.key) {
                $dropDownList.addClass(css.group);
            }

            // Combine elements
            $clearIcon.appendTo($clearCont);
            $dropDownBtnIcon.appendTo($dropDownBtnCont);
            $dropDownList.appendTo($dropDownListCont);
            $dropDownListCont.appendTo($dropDownCont);

            // Header template
            if (typeof options.headerTemplate === 'string') {
                $header = $('<div>')
					.addClass(css.header)
					.html(options.headerTemplate);

                $header.prependTo($dropDownCont);
            }

            // Footer template
            if (typeof options.footerTemplate === 'string') {
                footerMarkup = options.footerTemplate
					.replace(this.RECORDS_VIEW, '<span class=' + css.recordsView + '></span>')
					.replace(this.RECORDS_DATA, '<span class=' + css.recordsData + '></span>')
					.replace(this.RECORDS_SERVER, '<span class=' + css.recordsServer + '></span>')
					.replace(this.RECORDS_SERVER_TOTAL, '<span class=' + css.recordsServerTotal + '></span>');

                _options.hasFooterVariables = footerMarkup !== options.footerTemplate;

                $footer = $('<div>')
					.addClass(css.footer)
					.html(footerMarkup);

                $footer.appendTo($dropDownCont);
            }

            if (options.virtualization) {
                $dropDownListCont.addClass(css.listOverflow);
                $dropDownScrollCont.insertBefore($dropDownList);
                $dropDownScroll.appendTo($dropDownScrollCont);
            }

            if (this.element.is('input')) {
                // When rendering on input element we reuse it and wrap all the content around it

                // Wrap the input. Then update the wrapper element's reference
                $input.wrap($fieldCont);
                $fieldCont = $input.parent();

                // Wrap the field container. Then update the wrapper element's reference
                $fieldCont.wrap($combo);
                $combo = $fieldCont.parent();

                // Wrap the combo. Then update the wrapper element's reference
                $combo.wrap($comboWrapper);
                $comboWrapper = $combo.parent();

                // Prepend elements to the main container to ensure the right markup order
                $clearCont.prependTo($combo);
                $dropDownBtnCont.prependTo($combo);
            } else {
                // Combine input and its container
                $input.appendTo($fieldCont);

                // Append the content to main container when rendering on div/span
                $dropDownBtnCont.appendTo($combo);
                $clearCont.appendTo($combo);
                $fieldCont.appendTo($combo);
                $combo.appendTo($comboWrapper);
            }

            $clearCont.hide();


            // Add the hidden input
            $hiddenInput
				.attr('name', options.inputName)
				.appendTo($combo);

            // Close drop down initially and move it out of the screen to avoid wierd bug where 1 px height is still rendered in FFox
            $dropDownCont
				.css({
				    height: 0,
				    top: -99999,
				    left: -99999,
				    overflow: 'hidden'
				})
				.addClass(css.noBorder);

            if (options.dropDownAttachedToBody) {
                $dropDownCont.appendTo($('body'));
            } else {
                $dropDownCont.appendTo($comboWrapper);
            }

            if (this.element.is('select')) {
                // Ensure adding the main combo element to the dom when initializing on select
                $comboWrapper.insertBefore(this.element);
            }

            // Set wrapper sizes
            // Do not chain these, when called with width of null it won't return the wrapper
            $comboWrapper.outerWidth(options.width);
            $comboWrapper.outerHeight(options.height);

            // Preserve the refenreces
            _options.$comboWrapper = $comboWrapper;
            _options.$combo = $combo;
            _options.$input = $input;
            _options.$hiddenInput = $hiddenInput;
            _options.$fieldCont = $fieldCont;
            _options.$clearCont = $clearCont;
            _options.$clearIcon = $clearIcon;
            _options.$dropDownBtnCont = $dropDownBtnCont;
            _options.$dropDownBtnIcon = $dropDownBtnIcon;
            _options.$dropDownCont = $dropDownCont;
            _options.$dropDownListCont = $dropDownListCont;
            _options.$dropDownList = $dropDownList;
            _options.$header = $header;
            _options.$footer = $footer;
            _options.$loading = $loading;

            // Update input val
            this._setInputVal($input.val());

            if (options.virtualization) {
                _options.$dropDownScrollCont = $dropDownScrollCont;
                _options.$dropDownScroll = $dropDownScroll;
            }

            // Setup input for different combo mode types
            this._setupInput();

            if (options.disabled) {
                this._disableCombo(true);
            }

            this._triggerRendered();
        },
        _itemInnerMarkup: function (data) {
            var unwrappedData, dataItem, unwrappedDataItem;

            // If the data or the data item are observables, we need to unwrap them.
            unwrappedData = this._unwrapData(data);
            dataItem = unwrappedData[this.options.textKey];
            unwrappedDataItem = this._unwrapData(dataItem);
            unwrappedDataItem = this._formatItem(unwrappedDataItem);

            return this.options.itemTemplate ?
				$.ig.tmpl(this.options.itemTemplate, data) : unwrappedDataItem;
        },
        _formatItem: function (item) {
            if ($.ig && $.ig.formatter) {
                if (this.options.format === "auto" && ($.type(item) === "date" || $.type(item) === "number")) {
                    item = $.ig.formatter(item, null, null);
                } else if (this._formatEnabled()) {
                    item = $.ig.formatter(item, null, this.options.format);
                }
            }

            return item;
        },
        _formatEnabled: function () {
            return !(this.options.format === "" ||
				this.options.format === null ||
				this.options.format === "none");
        },
        _itemsToRenderCount: function () {
            return this._isPossibleToVirtualize() ? this.options.visibleItemsCount : this.options.dataSource.dataView().length;
        },
        _sortDataSource: function () {
            var options = this.options;

            options.dataSource.sort([{
                fieldName: options.grouping.key
            }], options.grouping.dir);
        },
        // Returns records grouped in following structure:
        // [{
        //      name: 'group name'
        //      members: [data source items]
        // },
        // {
        //      name: 'group name 2'
        //      members: [data source items]
        // }]
        _groups: function (data) {
            var prevGroup, curGroup, curData, len, i,
				options = this.options,
				groupKey = options.grouping.key,
				groups = [];

            data = data || options.dataSource.dataView();

            for (i = 0, len = data.length; i < len; i++) {
            	curData = data[i];

            	// S.T. 7th September 2015, #205951: Add check for LOD in group method in case the key is not correct.
            	if (curData[groupKey] === undefined) {
            		throw new Error($.ig.Combo.locale.errorIncorrectGroupingKey);
            	}

                curGroup = curData[groupKey];

                if (prevGroup === curGroup) {
                    groups[groups.length - 1].members.push(curData);
                } else {
                    prevGroup = curGroup;

                    groups[groups.length] = {
                        name: curGroup,
                        members: [curData]
                    };
                }
            }

            return groups;
        },
        _itemMarkup: function (data) {
            var css = this.css,
				value = this._unwrapData(this._unwrapData(data)[this.options.valueKey]),
				innerMarkup = this._itemInnerMarkup(data),
				markup, escapedValue;

            // Z.K. 27/08/2015 Bug #205313 - Not possible to select item because of illegal special characters encoding
            escapedValue = $.ig.encode(value);
            markup = '<li class="' + css.listItem + '" data-value="' + escapedValue + '" unselectable="on">';

            if (this._checkBoxesEnabled()) {
                // S.T. 6th July, 2015 #201924: Construct checkboxes template with the css classes.
                markup += this._options.checkboxItemTemplate
                    .replace('{css.checkbox}', css.checkbox)
                    .replace('{css.checkboxOff}', css.checkboxOff)
                    .replace('{css.listItemTextWithCheckbox}', css.listItemTextWithCheckbox)
                    .replace('{innerMarkup}', innerMarkup);
            } else {
                markup += innerMarkup;
            }

            markup += '</li>';

            return markup;
        },
        _itemsMarkup: function () {
            var i,
				dataView = this.options.dataSource.dataView(),
				dataLen = this._itemsToRenderCount(),
				markup = "";

            // Generate <li>'s markup
            for (i = 0; i < dataLen; i++) {
                markup += this._itemMarkup(dataView[i]);
            }

            return markup;
        },
        _groupHeaderMarkup: function (groupName) {
            return '<li class="' + this.css.groupHeader + '">' + groupName + '</li>';
        },
        _groupMarkup: function (group) {
            var len, i,
				members = group.members,
				itemsMarkup = '';

            for (i = 0, len = members.length; i < len; i++) {
                itemsMarkup += this._itemMarkup(members[i]);
            }

            return this._groupHeaderMarkup(group.name) + itemsMarkup;
        },
        _groupsMarkup: function () {
            var groups, groupsLen, i,
				dataView = this.options.dataSource.dataView(),
				dataLen = this._itemsToRenderCount(),
				markup = "";

            // Sort the data source to extract all groups
            this._sortDataSource();

            // Cache the count of all groups in data source
            if (this.options.virtualization && !this._options.cachedGroupLength) {
                this._options.cachedGroupLength = this._groups(dataView).length;
            }

            dataView = dataView.slice(0, dataLen);
            groups = this._groups(dataView);

            // Get group headers count and subtract them from list items when virtualization is enabled
            if (this.options.virtualization) {
                for (i = 0; i < dataLen; i++) {
                    if (this._isBoundaryOfGroups(dataView, i)) {
                        this._options.initialGroupHeaders++;
                        i++;
                    }
                }

                dataView = dataView.slice(0, dataLen - this._options.initialGroupHeaders);
                groups = this._groups(dataView);
            }

            for (i = 0, groupsLen = groups.length; i < groupsLen; i++) {
                markup += this._groupMarkup(groups[i]);
            }

            return markup;
        },
        _noMatchMarkup: function () {
            return '<li unselectable="on" class="' + this.css.noMatchFound + '">' + this.options.noMatchFoundText + '</li>';
        },
        _renderItems: function (success, msg, data) {
            var markup, dropDownScrollHeight, schema, noCancel,
				options = this.options,
				_options = this._options,
				dataView = data.dataView(),
				dataLen = this._itemsToRenderCount();

            if (success !== null) {
                this._triggerDataBound(success, msg);
            }

            // Set schema when loading remote url because filtering cannot work withouth it
            if (!options.dataSource.settings.schema && options.dataSource && dataView.length > 0) {
                schema = this._initSchema(this._unwrapData(dataView)[0]);
                options.dataSource.schema(schema);
            }

            noCancel = this._triggerItemsRendering();
            if (noCancel) {
                if (dataLen > 0) {
                    if (options.grouping.key) {
                        markup = this._groupsMarkup();
                    } else {
                        markup = this._itemsMarkup();
                    }
                } else {
                    markup = this._noMatchMarkup();
                }

                // Render items
                _options.$dropDownList.html(markup);

                // K.D. March 3rd, 2015 Bug #188582 When filtering is remote the noMatchFoundText is not visible
                if (dataLen > 0) {
                    this._setListContMaxHeight();
                }

                // Set scroll container height
                if (options.virtualization) {
                    dropDownScrollHeight = data.totalLocalRecordsCount() * this._itemHeight();

                    _options.$dropDownScroll.height(dropDownScrollHeight);

                    // Scrollbar is not shown in IE, FF and some touch devices
                    // D.A. 19th March 2015, Bug #190783 In Nexus virtualization does not have scroll bar
                    _options.$dropDownScrollCont.width($.ig.util.getScrollWidth() + 1);
                    this._updateVirtualScrollVisibility();
                }

                this._updateFooterVariables();

                if (_options.initialDataBinding) {
                    this._handleInitialSelection();
                    _options.initialDataBinding = false;
                }

                this._triggerItemsRendered();
            }
        },
        _handleRemoteFiltering: function (success, msg, data) {
            var $items, selectedData,
				_options = this._options,
				event = _options.remoteFilteringTriggerEvt;

            // Rerender items with filtered data
            this._renderItems(success, msg, data);

            // Z.K. 5th June 2015, Bug #200749 When combo is in buttom of the page and filter ant then clear filter the page scroll is changed for a second
            this.positionDropDown();
            $items = this._$items();

            // Reapply selection
            selectedData = _options.selectedData;
            _options.selectedData = [];

            this._selectData(selectedData, {
                focusCombo: true,
                // Keep filtering to avoid triggering infinite filtering recursion
                keepFiltering: true,
                keepInputText: true,
                keepNavItem: true
            });

            // Apply auto selected item / active item
            this._updateSelection(event);
            this._updateAutoComplete();

            // Reapply navigation item
            if (_options.keyNavItemData && !this._isDataSelected(_options.keyNavItemData)) {
                this._setKeyNavigationItem({
                    data: _options.keyNavItemData,
                    addStyles: true,
                    resetDataOnNonFound: true
                });
            }

            // D.A., 9th March 2015, Bug #189997 When remote filtering is enabled, input values are not updated when closing the drop down
            if (_options.updateInputValuesOnRemoteFilter) {
                this._updateInputValues();
                // D.A. 12th May 2015, Bug #193546 When filtering is remote and close list and open it again items are still highlighted
                this._updateHighlighting();
                _options.updateInputValuesOnRemoteFilter = false;
            }

            if (_options.inputVal) {
                this._showClearButton();
            } else {
                this._hideClearButton();
            }

            this._updateFooterVariables();

            if (_options.validator) {
                _options.validator._validateInternal(this.element, event);
            }

            // Trigger filtered
            if (event) {
                this._triggerFiltered(event);
                _options.remoteFilteringTriggerEvt = null;
            }
        },
        _handleLocalFilteringWithVirt: function (data) {
            var $items, selectedData,
				_options = this._options;

            this._renderItems(null, null, data);

            // Z.K. 5th June 2015, Bug #200749 When combo is in buttom of the page and filter ant then clear filter the page scroll is changed for a second
            this.positionDropDown();
            $items = this._$items();

            // Reapply selection
            selectedData = _options.selectedData;
            _options.selectedData = [];

            this._selectData(selectedData, {
                focusCombo: true,
                // Keep filtering to avoid triggering infinite filtering recursion
                keepFiltering: true,
                keepInputText: true
            });

            // Reapply highlighting
            this._updateHighlighting();
        },
        _handleLoadOnDemand: function (err, success, data) {
            var $items, selectedData,
				_options = this._options;

            this._renderItems(err, success, data);

            // Z.K. 5th June 2015, Bug #200749 When combo is in buttom of the page and filter ant then clear filter the page scroll is changed for a second
            this.positionDropDown();
            $items = this._$items();

            // Reapply selection
            selectedData = _options.selectedData;
            _options.selectedData = [];

            this._selectData(selectedData, {
                focusCombo: true,
                // Keep filtering to avoid triggering infinite filtering recursion
                keepFiltering: true,
                keepInputText: true
            });

            // Reapply highlighting
            this._updateHighlighting();

            // Reapply navigation item
            if (this.options.multiSelection.enabled && _options.keyNavItemData &&
				!this._isDataSelected(_options.keyNavItemData)) {
                this._setKeyNavigationItem({
                    data: _options.keyNavItemData,
                    addStyles: true
                });
            }

            // D.A. 9th March 2015, Bug #190032 Filtering should not be reapplied if it was previously cleared
            // When filtering is remote the newly loaded items are loaded filtred
            if (this.options.filteringType !== 'remote' && _options.expression) {
                // Reapply filtering
                this._updateFiltering();
            }

            this._updateFooterVariables();
        },
        // Updates group header item according to new data
        _updateGroupHeader: function ($item, data) {
            if (this.options.grouping.key && this._isItem($item)) {
                this._setVisualStylesToGroupHeader($item);
            }

            this._updateMarkupForGroupHeader($item, data);
            $item.attr('data-value', null);
            return this;
        },
        // Updates item according to new data
        _updateItem: function ($item, data) {
            var unwrappedDataItem, unwrappedDataValue,
				innerMarkup = this._itemInnerMarkup(data);

            if (this.options.grouping.key && this._isGroupHeader($item)) {
                this._setVisualStylesToItem($item);

                // S.T. 6th July, 2015 #201924: If we the item was a group, we need to restore checkbox markup.
                if (this._checkBoxesEnabled()) {
                    $item.html(this._options.checkboxItemTemplate
                        .replace('{css.checkbox}', this.css.checkbox)
                        .replace('{css.checkboxOff}', this.css.checkboxOff)
                        .replace('{css.listItemTextWithCheckbox}', this.css.listItemTextWithCheckbox)
                        .replace('{innerMarkup}', "")
                    );
                }
            }

            this._updateMarkupForItem($item, innerMarkup);

            // Update data value
            unwrappedDataItem = this._unwrapData(data);
            unwrappedDataValue = this._unwrapData(unwrappedDataItem[this.options.valueKey]);
            $item.attr('data-value', unwrappedDataValue);

            return this;
        },
        // Z.K. 9th July 2015 Bug #202450 - "&nbsp;" displayed instead of blank value
        _removePlaceholderOnEmptyTextVal: function () {
            var _options = this._options,
				placeholderAttr = _options.$input.attr("placeholder");

            if (_options.inputVal === '' && _options.selectedData.length > 0 &&
                (typeof placeholderAttr !== typeof undefined || placeholderAttr !== false)) {
                _options.$input.removeAttr("placeholder");
            }

        },
        // Z.K. 9th July 2015 Bug #202450 - "&nbsp;" displayed instead of blank value
        _addPlaceholderWhenEmptyTextVal: function () {
            var _options = this._options,
                placeholderAttr = _options.$input.attr("placeholder");

            if (_options.inputVal === '' && _options.selectedData.length === 0 &&
                (typeof placeholderAttr === typeof undefined || placeholderAttr === false)) {
                _options.$input.attr("placeholder", this.options.placeHolder);
            }
        },
        _isGroupHeader: function ($item) {
            return $item.hasClass(this.css.groupHeader);
        },
        _isItem: function ($item) {
            return $item.hasClass(this.css.listItem);
        },
        _setVisualStylesToGroupHeader: function ($item) {
            $item.removeClass(this.css.listItem);
            $item.addClass(this.css.groupHeader);
        },
        _setVisualStylesToItem: function ($item) {
            $item.removeClass(this.css.groupHeader);
            $item.addClass(this.css.listItem);
        },
        _updateMarkupForGroupHeader: function ($item, data) {
            // S.T. 1th July 2015, Bug #201839: Check for undefined values.
            if (this.options.grouping.key && data[this.options.grouping.key] !== undefined) {
                $item.html(data[this.options.grouping.key]);
            }
        },
        _updateMarkupForItem: function ($item, innerMarkup) {
            // Update markup for item
            if (this._checkBoxesEnabled()) {
                $item.find("." + this.css.listItemTextWithCheckbox).html(innerMarkup);
            } else {
                $item.html(innerMarkup);
            }
        },
        _$items: function (includeGroupHeaders) {
            var selector = '.' + this.css.listItem.split(" ", 1)[0];

            if (this.options.grouping.key && includeGroupHeaders) {
                selector += ',.' + this.css.groupHeader.split(" ", 1)[0];
            }

            return this._options.$dropDownList.children(selector);
        },
        _$filteredItems: function () {
            return this._$items().not('.' + this.css.hidden);
        },
        // Returns jquery object with item/items by data or array of data
        _$elementFromData: function (data, $items) {
            var curData, i, len,
                valueKey = this.options.valueKey,
                values = [];

            $items = $items || this._$items();

            // Handle data as array
            if ($.type(data) !== 'array') {
                data = [data];
            }

            for (i = 0, len = data.length; i < len; i++) {
                curData = data[i];

                if (curData !== null && curData !== undefined) {
                    values.push(curData[valueKey]);
                }
            }

            return this._$elementFromValue(values, $items);
        },
        // Returns jquery object with item/items by value or array of values
        _$elementFromValue: function (value, $items) {
            var i,
                result = $();

            $items = $items || this._$items();

            // Handle value as array
            if ($.type(value) !== 'array') {
                value = [value];
            }

            for (i = 0; i < value.length; i++) {
                result = result.add($items.filter("[data-value='" + value[i] + "']"));
            }

            return result;
        },
        // Returns jquery object with all elements from item or array with items { element, data }
        _$elementsFromItems: function (items) {
            var i,
                result = $();

            if ($.type(items) !== 'array') {
                items = [items];
            }

            for (i = 0; i < items.length; i++) {
                result = result.add(items[i].element);
            }

            return result;
        },
        // Returns jQuery object with the rendered selected items
        _$selectedItems: function () {
            var i,
                selItems = this.selectedItems(),
                $selItems = $(),
                len = selItems.length;

            for (i = 0; i < len; i++) {
                $selItems = $selItems.add(selItems[i].element);
            }

            return $selItems;
        },
        _isDataEqual: function (data1, data2) {
            var data1Value, data2Value;

            if (data1 !== null && data1 !== undefined && data2 !== null && data2 !== undefined) {
                data1Value = this._unwrapData(this._unwrapData(data1)[this.options.valueKey]);
                data2Value = this._unwrapData(this._unwrapData(data2)[this.options.valueKey]);

                return data1Value === data2Value;
            }

            return false;
        },
        _isDataSelected: function (data) {
            return this.isValueSelected(data[this.options.valueKey]);
        },
        _filterData: function (data1, data2) {
            var data2Len,
                self = this;

            if ($.type(data1) !== 'array') {
                data1 = [data1];
            }

            if ($.type(data2) !== 'array') {
                data2 = [data2];
            }

            data2Len = data2.length;

            return data1.filter(function (data) {
                var i;

                for (i = 0; i < data2Len; i++) {
                    if (self._isDataEqual(data, data2[i])) {
                        return false;
                    }
                }

                return true;
            });
        },
        // Filters items2 from items1
        _filterItems: function (items1, items2) {
            var result,
                valKey = this.options.valueKey,
                self = this;

            result = items1.filter(function (item) {
                var i, unwrappedDataItem, unwrappedDataValue, unwrappedDataItemToCompare, unwrappedDataValueToCompare,
                    matchFound = false;

                unwrappedDataItem = self._unwrapData(item.data);
                unwrappedDataValue = self._unwrapData(unwrappedDataItem[valKey]);

                for (i = 0; i < items2.length && !matchFound; i++) {
                    unwrappedDataItemToCompare = self._unwrapData(items2[i].data);
                    unwrappedDataValueToCompare = self._unwrapData(unwrappedDataItemToCompare[valKey]);

                    if (unwrappedDataValue === unwrappedDataValueToCompare) {
                        matchFound = true;
                    }
                }

                return !matchFound;
            });

            return result;
        },
        // Returns array with values for the given data object
        _valuesFromData: function (data) {
            var unwrappedDataItem, unwrappedDataValue, i,
                len = data.length,
                valKey = this.options.valueKey,
                values = [];

            for (i = 0; i < len; i++) {
                unwrappedDataItem = this._unwrapData(data[i]);
                unwrappedDataValue = this._unwrapData(unwrappedDataItem[valKey]);

                values.push(unwrappedDataValue);
            }

            return values;
        },
        // Returns array of values for the specified jquery object with list items
        _valuesFromElements: function ($items) {
            var i,
                values = [];

            for (i = 0; i < $items.length; i++) {
                values.push($items.eq(i).attr('data-value'));
            }

            return values;
        },
        // Returns array of values from item or array of items { element, data }
        _valuesFromItems: function (item) {
            var i, unwrappedDataItem, unwrappedDataValue,
                values = [],
                valueKey = this.options.valueKey;

            if (!item) {
                return;
            }

            // Handle item as array
            if ($.type(item) !== 'array') {
                item = [item];
            }

            for (i = 0; i < item.length; i++) {
                unwrappedDataItem = this._unwrapData(item[i].data);
                unwrappedDataValue = this._unwrapData(unwrappedDataItem[valueKey]);
                values.push(unwrappedDataValue);
            }

            return values;
        },
        // Returns array with data from the given items { element, data }
        _dataFromItems: function (items) {
            var len, i,
                data = [];

            for (i = 0, len = items.length; i < len; i++) {
                data.push(items[i].data);
            }

            return data;
        },
        _dataFromIndex: function (index) {
            var data = this.options.dataSource.data();

            return data.length > index ? data[index] : null;
        },
        _dataForValues: function (value) {
            var data, i, len,
                result = [];

            if ($.type(value) !== 'array') {
                value = [value];
            }

            for (i = 0, len = value.length; i < len; i++) {
                data = this.dataForValue(value[i]);

                if (data !== null) {
                    result.push(data);
                }
            }

            return result;
        },
        // Finds index of data in data source by value
        _dataIndexByValue: function (value, searchDataViewOnly) {
            var unwrappedDataItem, unwrappedDataValue, i,
                result = -1,
                data = searchDataViewOnly ? this.options.dataSource.dataView() : this.options.dataSource.data(),
                len = data.length,
                valKey = this.options.valueKey;

            for (i = 0; i < len; i++) {
                unwrappedDataItem = this._unwrapData(data[i]);
                unwrappedDataValue = this._unwrapData(unwrappedDataItem[valKey]);

                if (this._areValuesEqual(unwrappedDataValue, value)) {
                    result = i;
                    break;
                }
            }

            return result;
        },
        // Keeping the function private to ensure always calling it with correct 
        // parameters and faster execution time for large amount of data
        // Param "data" can be single data or array of data
        _itemsFromData: function (data) {
            var curData, len, i,
                $items = this._$items(),
                result = [];

            // Handle data as array
            if ($.type(data) !== 'array') {
                data = [data];
            }

            for (i = 0, len = data.length; i < len; i++) {
                curData = data[i];

                if (curData !== null && curData !== undefined) {
                    result.push({
                        element: this._$elementFromData(curData, $items),
                        data: curData
                    });
                }
            }

            return result.length > 0 ? result : null;
        },
        _$keyNavItem: function () {
            return this._$elementFromData(this._options.keyNavItemData);
        },
        _updateFooterVariables: function () {
            var ds, recordsView, recordsData, recordsServer, recordsServerTotal;

            if (this._options.hasFooterVariables) {
                ds = this.options.dataSource;
                recordsView = ds.dataView().length;
                recordsData = ds.data().length;
                recordsServer = Math.max(ds.totalRecordsCount(), recordsData);
                recordsServerTotal = Math.max(recordsServer, parseInt(this._options.totalAll || 0, 10));

                this._options.$footer
                    .find('.' + this.css.recordsView)
                    .html(recordsView);

                this._options.$footer
                    .find('.' + this.css.recordsData)
                    .html(recordsData);

                this._options.$footer
                    .find('.' + this.css.recordsServer)
                    .html(recordsServer);

                this._options.$footer
                    .find('.' + this.css.recordsServerTotal)
                    .html(recordsServerTotal);
            }
        },
        // Focus combo and set carret to text input's end
        _moveCaretToInputEnd: function (preventItemSeparatorOnFocus) {
            var range,
                input = this._options.$input[0],
                readonly = this._options.$input.attr('readonly');

            // J.D. July 8, 2015 - Bug #193837 IME input does not function properly when filtering in Chrome.
            // D.A. 6th March 2015, Bug #190025 In IE typing in the input closes the list
            // Note: IE executes the blur handler after the method has finished and preventInputBlur is false
            // Blur is required for chrome to move the carret
            //if ($.ig.util.isWebKit && this._options.$input.is(':focus')) {
            //    this._options.preventInputBlur = true;
            //    input.blur();
            //}

            // D.A. 20th March 2015, Bug #190591 In Chrome when mode is dropdown and selecting an item, the carret is not moved and the selected element is not visible
            // Remove readonly during the focus
            if (readonly) {
                this._options.$input.removeAttr('readonly');
            }

            // Setting the range without focus won't work in most browsers
            this._safeFocusInput(preventItemSeparatorOnFocus);

			if (typeof input.selectionStart === "number" && !$.ig.util.isIE) {
                input.selectionStart = input.selectionEnd = input.value.length;
			}
			// JD Sept 1, 2015, TFS 205346 IE throws an unhandled exception whenever attempting to modify range when the input is not visible
			// JD Sept 2, 2015, TFS 201580 IE treats an input with a range specified as editable even if readonly is applied
			else if (typeof input.createTextRange !== "undefined" && $(input).is(':visible') && !readonly) {
                range = input.createTextRange();
                range.collapse(false);
                range.select();
            }

            // Reapply readonly attribute
            if (readonly) {
                this._options.$input.attr('readonly', readonly);
            }
        },
        _refreshVisualStylesForItem: function ($item, data) {
            var isSelected = this._isDataSelected(data);

            // Update selected style
            if (isSelected) {
                this._addItemSelectionStyles($item);
            } else {
                this._removeItemSelectionStyles($item);
            }

            if (this.options.multiSelection.enabled) {
                // Update active style
                if (this._isDataEqual(this._options.keyNavItemData, data) && !isSelected) {
                    $item.addClass(this.css.itemInFocus);
                } else {
                    $item.removeClass(this.css.itemInFocus);
                }
            }
        },
        _handleInitialSelection: function () {
            var curSelItem, selectOptions, selectedOptions, curIndex, i, curDataItem,
                selItems = this.options.initialSelectedItems,
                data = this.options.dataSource.data(),
                dataToSel = [],
                mode = this.options.mode;

            // Handle selectedItems option
            if ($.type(selItems) === 'array') {
                for (i = 0; i < selItems.length; i++) {
                    curSelItem = selItems[i];
                    curIndex = curSelItem.index;

                    if (curIndex >= 0 && data.length >= curIndex) {
                        curDataItem = data[curIndex];
                    } else if (curSelItem.value !== undefined && curSelItem.value !== null) {
						curDataItem = this.dataForValue(curSelItem.value);                    	
                    }

                	// JD Sept 2, 2015 TFS 202202 Prevent duplication of selected items by seeing if they are already in the array
                    if (curDataItem && dataToSel.indexOf(curDataItem) === -1) {
                    	dataToSel.push(curDataItem);
                    }
                }
            }

            // Handle select element with <option selected>
            if (this.element.is('select')) {
                selectOptions = this.element.find('option');

                // In select element the first value is selected by default. So this will always select value
                selectedOptions = selectOptions.filter(':selected');

                for (i = 0; i < selectedOptions.length; i++) {
                    dataToSel.push(data[selectOptions.index(selectedOptions.eq(i))]);
                }
            }

        	// S.T. 24th Sept 2015, Bug #207020: Extract a method for selecting.
            this._selectFirstItemInNonEditableModes(mode, dataToSel, data);
        },
        _selectFirstItemInNonEditableModes: function (mode, dataToSel, data) {
        	// Select first item when no items are selected in non editable modes
        	// D.A. 17th March 2015, Bug #190579 Initial item should be always selected when mode is drop down and selection is single
        	if (((mode === 'dropdown' && !this.options.multiSelection.enabled) ||
                mode === 'readonly' || mode === 'readonlylist') &&
                dataToSel.length === 0) {
        		// D.A. 17th March 2015, Bug #190600 Binding to null data source throws exception
        		if (data[0] !== null && data[0] !== undefined) {
        			dataToSel.push(data[0]);
        		}
        	}

        	if (dataToSel.length > 0) {
        		this._selectData(dataToSel, {
        			additive: true,
        			keepScrollPosition: true
        		});
        	}
        },
        _checkBoxesEnabled: function () {
            return this.options.multiSelection.enabled && this.options.multiSelection.showCheckboxes;
        },
        _isPossibleToVirtualize: function () {
            return this.options.virtualization && this.options.dataSource.dataView().length > this.options.visibleItemsCount;
        },
        _areItemsLowerInVir: function () {
            return this.options.virtualization && this.options.dataSource.dataView().length <= this.options.visibleItemsCount;
        },
        _dropDownHeight: function (itemHeight, allItemsCount) {
            return itemHeight * allItemsCount;
        },
        _itemHeight: function () {
            return this._$items().first().outerHeight();
        },
        _isFilteringEnabled: function () {
            return this.options.filteringType !== "none";
        },
        _updateItems: function (offset) {
            // elementIndex handles the index of the DOM element
            // itemIndex handles the index of the data value
            var elementIndex, lengthOfElements, itemIndex, $this, curData,
				self = this,
                options = this.options,
                dataView = options.dataSource.dataView(),
				$items = this._$items(true),
				realOffset = 0;

            offset = offset > 0 ? offset : 0;
            this._unhighlight();

            // For grouping we have group headers elements that are part of item elements
            // and we should be aware of that when items are iterating.
            for (elementIndex = 0, itemIndex = 0, lengthOfElements = $items.length; elementIndex < lengthOfElements; elementIndex++) {
                // Get element from list items
                $this = $items.eq(elementIndex);
                realOffset = itemIndex + offset;
                curData = dataView[realOffset];

                // We have to update the item to group header if it's between two groups.
                // First element in the list should be always a group header
                if (curData && this.options.grouping.key &&
					(self._isBoundaryOfGroups(dataView, realOffset) || self._isFirstItem(dataView, realOffset))) {
                    this
						._updateGroupHeader($this, curData)
						._refreshVisualStylesForItem($this, curData[options.grouping.key]);
                    elementIndex++;

                    // Get next DOM element from the list in order to update the item with data
                    $this = $items.eq(elementIndex);
                }

                if ($this) {
                    this
                        ._updateItem($this, curData)
                        ._refreshVisualStylesForItem($this, curData);
                }

                itemIndex++;
            }

            this._updateHighlighting();
        },
        _isFirstItem: function (data, itemIndex) {
            if (!data[itemIndex - 1]) {
                return true;
            }

            return false;
        },
        _isBoundaryOfGroups: function (data, itemIndex) {
            if (this.options.grouping.key && data[itemIndex - 1] &&
				(data[itemIndex - 1][this.options.grouping.key] !== data[itemIndex][this.options.grouping.key])) {
                return true;
            }

            return false;
        },
        _toggleDropDownState: function (event) {
            if (this._options.dropDownOpened) {
                this.closeDropDown(null, event);
            } else {
                this.openDropDown(null, true, event);
            }
        },
        _lastValAfterItemSep: function () {
            return this._options.inputVal.split(this.options.multiSelection.itemSeparator).pop();
        },
        _startsWith: function (text, fragment) {
            return fragment !== '' && text.indexOf(fragment) === 0;
        },
        // Returns number representing how many chars in the end of text match the item separator
        _endsPartialyWithItemSep: function (text) {
            var separator = this.options.multiSelection.itemSeparator,
                i = separator.length,
                matchFound = 0;

            for (; i > 0 && !matchFound; i--) {
                if (text.endsWith(separator.slice(0, i))) {
                    matchFound = i;
                }
            }

            return matchFound;
        },
        // Filters text ending with part of the item separator
        // E.g. item separator is ', '. Given text 'Jon,' returns 'Jon'
        _filterItemSeparator: function (text) {
            return text.slice(0, text.length - this._endsPartialyWithItemSep(text));
        },
        // Returns array with values filtered from item separator
        _separatedInputTexts: function () {
            var result = this._options.inputVal.split(this.options.multiSelection.itemSeparator);

            // Filter last item in case it ends partially with the item separator
            result[result.length - 1] = this._filterItemSeparator(result[result.length - 1]);

            return result;
        },
        _updateSelection: function (event) {
            var textsLen, dataLen, curText, curData, curDataValue, curDataText, setAsKeyNav, matchFound, isLastText, unwrappedData, i, j,
                options = this.options,
                _options = this._options,
                texts = _options.inputVal,
                data = options.dataSource.data(),
                textKey = options.textKey,
                valueKey = options.valueKey,
                justSelectedData = [],
                multiSelect = options.multiSelection.enabled;

            // When filtering is remote also look in the cached data
            if (options.filteringType === 'remote') {
                // D.A. June 15th, 2015 Bug #201117 Records that are duplicated both in cachedData and data, should be filtered
                data = this._filterData(_options.cachedData, data).concat(data);
            }

            dataLen = data.length;

            if (multiSelect) {
                texts = this._separatedInputTexts(texts);
            } else {
                texts = [texts];
            }

            if (options.autoSelectFirstMatch) {
                // Reset autoSelectedItem upon new auto selection
                _options.autoSelectedItemData = null;
            }

            unwrappedData = this._unwrapData(data);

            // Loop through all input texts
            for (i = 0, textsLen = texts.length; i < textsLen; i++) {
                curText = texts[i];
                matchFound = false;
                isLastText = i === textsLen - 1;

                if (!options.caseSensitive) {
                    curText = curText.toLowerCase();
                }

                // Loop through all items
                for (j = 0; j < dataLen && !matchFound; j++) {
                    curData = this._unwrapData(unwrappedData[j]);
                    curDataText = this._unwrapData(curData[textKey]).toString();
                    curDataValue = this._unwrapData(curData[valueKey]);
                    setAsKeyNav = isLastText && !this.isValueSelected(curDataValue);

                    if (!options.caseSensitive) {
                        curDataText = curDataText.toLowerCase();
                    }

                    if (options.autoSelectFirstMatch) {
                        if (this._startsWith(curDataText, curText)) {
                            if (multiSelect) {
                                // Select unselected matching item with multi selection enabled
                                if (this._filterData(curData, justSelectedData).length === 1) {
                                    if (setAsKeyNav) {
                                        // Navigate to the last matching item when
                                        // multi selection is enabled instead of selecting it
                                        this._setKeyNavigationItem({
                                            data: curData,
                                            addStyles: true,
                                            clearPrevItem: true,
                                            scrollToItem: true
                                        });
                                    } else {
                                        // Select the item, keep input text unchanged
                                        this._selectData(curData, {
                                            additive: true,
                                            focusCombo: true,
                                            keepInputText: true,
                                            keepHighlighting: true,
                                            keepFiltering: true
                                        }, event);
                                    }

                                    matchFound = true;

                                    // Z.K September 9, 2015 Bug #205950 - When multy selection is enabled auto complete does not match correct item
                                    if (curDataText !== curText) {
                                    	_options.autoSelectedItemData = curData;
                                    }
                                }

								// JD Sept 2, 2015 TFS194605 - Adding in the use of autoSelectedItemData so that values can be autocompleted
                                //if (curDataText !== curText) {
                                //	_options.autoSelectedItemData = curData;
                                //}

                                // Last text is not being selected
                                if (!setAsKeyNav) {
                                    justSelectedData.push(curData);
                                }
                            } else {
                                // Select the item, keep input text unchanged
                                this._selectData(curData, {
                                    focusCombo: true,
                                    keepInputText: true,
                                    keepHighlighting: true,
                                    keepFiltering: true
                                }, event);

                                // On full match the item shouldn't be considered as auto selected
                                if (curDataText !== curText) {
                                    _options.autoSelectedItemData = curData;
                                }

                                matchFound = true;
                                justSelectedData.push(curData);
                            }
                        }
                    } else if (curDataText === curText) {
                        if (multiSelect) {
                            // Select unselected matching item with multi selection enabled
                            if (this._filterData(curData, justSelectedData).length === 1) {
                                if (setAsKeyNav) {
                                    // Navigate to the last matching item when
                                    // multi selection is enabled instead of selecting it
                                    this._setKeyNavigationItem({
                                        data: curData,
                                        addStyles: true,
                                        clearPrevItem: true,
                                        scrollToItem: true
                                    });
                                } else {
                                    this._selectData(curData, {
                                        additive: true,
                                        focusCombo: true,
                                        keepInputText: true,
                                        keepHighlighting: true,
                                        keepFiltering: true
                                    }, event);
                                }

                                matchFound = true;
                            }

                            // Last text is not being selected
                            if (!setAsKeyNav) {
                                justSelectedData.push(curData);
                            }
                        } else {
                            this._selectData(curData, {
                                additive: true,
                                focusCombo: true,
                                keepInputText: true,
                                keepHighlighting: true,
                                keepFiltering: true
                            }, event);

                            matchFound = true;
                            justSelectedData.push(curData);
                        }
                    }
                }
            }

            // Deselect all remaining items
            this._deselectData(this._filterData(_options.selectedData, justSelectedData), {
                focusCombo: true,
                keepInputText: true
            }, event);

            // Update input values after inserting item separator
            if (multiSelect && _options.inputVal.endsWith(options.multiSelection.itemSeparator)) {
                this._updateInputValues(false);
            }

            this._updateHighlighting();
        },
        // Updates the auto complete according to the value in the text input
        _updateAutoComplete: function () {
            var text, curData, curDataText, unwrappedData, i,
                options = this.options,
                _options = this._options,
                texts = _options.inputVal,
                data = options.dataSource.data(),
                dataLen = data.length,
                textKey = options.textKey,
                multiSelect = options.multiSelection.enabled;

            if (multiSelect) {
                texts = this._options.inputVal.split(options.multiSelection.itemSeparator);
            } else {
                texts = [texts];
            }

            // Avoid auto completing a selected element
            if (texts.length > this._fullySelectedItemsLen()) {
                // Auto complete by the last text value
                text = texts[texts.length - 1];

                // D.A. 29th May, 2015 Bug #194604 When multiSelection is enabled and type "," after the text, autocomplete is not correct
                if (multiSelect && this._endsPartialyWithItemSep(text)) {
                    return;
                }

                if (!options.caseSensitive) {
                    text = text.toLowerCase();
                }

                if (_options.autoSelectedItemData) {
                    // Auto selected item matches the item that should be auto completed
                    _options.autoCompleteItemData = _options.autoSelectedItemData;
                    this._autoComplete(_options.autoCompleteItemData[textKey].toString().slice(text.length));
                } else {
                    // Handle autoSelectFirstMatch: false
                    // Auto complete should be handled separately when auto select first match is disabled, to avoid cases where we don't want
                    // to auto complete item with the first match when there is full match later on in the data source, that would be selected instead
                    for (i = 0; i < dataLen; i++) {
                        unwrappedData = this._unwrapData(data);
                        curData = this._unwrapData(unwrappedData[i]);
                        curDataText = this._unwrapData(curData[textKey]).toString();

                        if (!options.caseSensitive) {
                            curDataText = curDataText.toLowerCase();
                        }

                        if (!(curData !== _options.autoSelectedItemData && this._isDataSelected(curData)) &&
                            this._startsWith(curDataText, text)) {
                            _options.autoCompleteItemData = curData;

                            // Auto complete with non modified / non lower cased value
                            this._autoComplete(
                                this._unwrapData(curData[textKey]).toString().slice(text.length));
                            break;
                        }
                    }
                }
            }
        },
        // Auto completes the input value with given text
        _autoComplete: function (autoCompleteText) {
            var oldInputVal, newInputVal;

            if (this.options.autoComplete) {
                oldInputVal = this._options.inputVal;
                newInputVal = oldInputVal + autoCompleteText;

                // Set auto completed input value
                this._options.$input.val(newInputVal);

                // Select the auto completed part
                this._setInputSelection(oldInputVal.length, newInputVal.length);
            }
        },
        // Set selection to input text field
        _setInputSelection: function (start, end) {
            var selRange,
                field = this._options.$input[0];

            if (field.createTextRange) {
                selRange = field.createTextRange();
                selRange.collapse(true);
                selRange.moveStart('character', start);
                selRange.moveEnd('character', end);
                selRange.select();
                field.focus();
            } else if (field.setSelectionRange) {
                field.focus();
                field.setSelectionRange(start, end);
            } else if (typeof field.selectionStart !== 'undefined') {
                field.selectionStart = start;
                field.selectionEnd = end;
                field.focus();
            }
        },
        _hasInputSelection: function () {
            var field = this._options.$input[0],
                result = false;

            if (typeof field.selectionStart !== 'undefined') {
                result = field.selectionStart !== field.selectionEnd;
            }

            return result;
        },
        _scrollToItem: function (data) {
            var listContHeight, listContTop, listContScrollTop, itemTop, itemHeight, itemIndex,
                $item = this._$elementFromData(data);

            if (this._options.dropDownOpened) {
                if ($item.length > 0) {
                    listContHeight = this._options.$dropDownListCont.height();
                    listContTop = this._options.$dropDownListCont.offset().top;
                    listContScrollTop = this.listScrollTop();
                    itemTop = $item.offset().top;
                    itemHeight = $item.outerHeight();

                    // Change scroll top only when the item is not in the visible area
                    if (!(itemTop > listContTop &&
                        itemTop + itemHeight < listContHeight + listContTop)) {
                        this.listScrollTop(itemTop + listContScrollTop + itemHeight - listContTop - listContHeight);
                    }
                } else if (this.options.virtualization) {
                	itemIndex = this._dataIndexByValue(data[this.options.valueKey]);
                	// S.T. 1th Sept 2015, Bug 202891: Adjust position when scroll to item in virtualization.
                    this.listScrollTop((itemIndex - this.options.visibleItemsCount + 2) * this._itemHeight());
                }
            }
        },
        _scrollToLastSelItem: function () {
            if (this._options.keyNavItemData !== null) {
                this._scrollToItem(this._options.keyNavItemData);
            } else if (this._options.selectedData.length > 0) {
                this._scrollToItem(this._options.selectedData[this._options.selectedData.length - 1]);
            }
        },
        // Positions an item in the visible area when navigating with keyboard
        _positionItemInVisibleArea: function ($item) {
            var $listCont = this._options.$dropDownListCont,
                listContHeight = $listCont.height(),
                listContTop = $listCont.offset().top,
                listContScrollTop = this.listScrollTop(),
                itemTop = $item.offset().top,
                itemHeight = $item.outerHeight(true);

            // Item is hidden and is above visible area
            if (listContTop > itemTop) {
                this.listScrollTop(
                    this._$items().filter(':visible').index($item) * itemHeight);
            }

            // Item is hidden and is below visible area
            if (itemTop + itemHeight > listContHeight + listContTop) {
                this.listScrollTop(itemTop + itemHeight + listContScrollTop - listContHeight - listContTop);
            }
        },
        // Param "options":
        //  data - the data of the element or jQuery reference to the element
        //  addStyles - boolean Specifies whether key navigation style should be applied
        //  clearPrevItem - boolean Specifies whether key navigation style should be removed from prev key navigation items. Mainly for shift interactions.
        //  scrollToItem - boolean Specifies whether to scroll to the new key navigation element
        //  resetDataOnNonFound - boolean Specifies whether the keyNavItemData should be set to null when the item is not found.
        _setKeyNavigationItem: function (options) {
            var $item, $prevKeyNavItem,
                data = options.data,
                addStyles = options.addStyles,
                clearPrevItem = options.clearPrevItem,
                scrollToItem = options.scrollToItem,
                resetDataOnNonFound = options.resetDataOnNonFound;

            // Handle data as jQuery object
            if (data instanceof $) {
                $item = data;
                data = this.dataForValue($item.attr('data-value'));
            } else {
                $item = this._$elementFromData(data);
            }

            if (clearPrevItem) {
                $prevKeyNavItem = this._$elementFromData(this._options.keyNavItemData);

                if ($prevKeyNavItem.length > 0) {
                    $prevKeyNavItem.removeClass(this.css.itemInFocus);
                }
            }

            if (addStyles && $item.length > 0) {
                $item.addClass(this.css.itemInFocus);
            }

            if ($item.length === 0 && resetDataOnNonFound) {
                this._options.keyNavItemData = null;
            } else {
                this._options.keyNavItemData = data;
            }

            // D.A. 14th July, 2015 Bug #202197 The dropdown does not automatically scroll to the selected item.
            // Used to render the item when virtualization is enabled
            // The scroll calls _refreshVisualStylesForItem and updates the key nav item style
            if (scrollToItem) {
                this._scrollToItem(data);
            }
        },
        _navigateToItem: function ($item, addStyles, clearPrevItem, event, keepScrollPosition) {
            if ($item.length === 0) {
                return;
            }

            if (!this.options.multiSelection.enabled) {
                this.select($item, {
                    focusCombo: true,
                    keepFiltering: true,
                    keepScrollPosition: keepScrollPosition
                }, event);
            } else {
                this._setKeyNavigationItem({
                    data: $item,
                    addStyles: addStyles,
                    clearPrevItem: clearPrevItem
                });
            }

            this._positionItemInVisibleArea($item);
        },
        // Gets previous visible list item, while skipping grouping headers
        _prevVisibleItem: function ($item) {
            do {
                $item = $item.prev();
            } while ($item.length > 0 && (!$item.is('.' + this.css.listItem.split(" ", 1)[0]) || !$item.is(':visible')));

            return $item;
        },
        // Gets next visible list item, while skipping grouping headers
        _nextVisibleItem: function ($item) {
            do {
                $item = $item.next();
            } while ($item.length > 0 && (!$item.is('.' + this.css.listItem.split(" ", 1)[0]) || !$item.is(':visible')));

            return $item;
        },
        // Returns an item that is not filtered
        _visibleItemByIndex: function (index) {
            return this._$items().filter(':visible').eq(index);
        },
        _handleInputChange: function (openDropDown, event) {
            var options = this.options,
                _options = this._options,
                curVal = _options.$input.val();

            if (options.autoComplete &&
                event.which === 8 && // backspace
                _options.hadInputSelectionOnKeydown) {
                // Remove the character before the selection instead of removing the selection 
                // when backspace is pressed and there was selection done by the auto complete
                curVal = curVal.slice(0, curVal.length - 1);
                _options.$input.val(curVal);
            }

            // In rare cases keyup events can be timed to process the same input value
            // But when auto complete is enabled the first event modified the input value with auto complete text and set the selection
            // This selection is also presisted when the second event is executed, which should normally not happen, because typing anything removes the selection
            // We should avoid processing the next event in this case, because this value was already processed and the carret would be incorrectly set to the input's end
            if (options.autoComplete && this._hasInputSelection()) {
                return;
            }

            // Ignore keyups that don't change the value
            if (curVal !== _options.inputVal) {
                // Update input val
                this._setInputVal(curVal);

                if (options.filteringType === 'remote') {
                    this._updateFiltering(event);
                } else {
                    if (options.filteringType === 'local') {
                        // Disable scroll when typing and load on demand is enabled
                        // to prevent loading more items when items are filtered
                        _options.disableScroll = true;
                        this._updateFiltering(event);

                        // D.A. 16th June, 2015 Bug #201124 When filtering is local and loadOnDemand is enabled new items are loaded after filter
                        // Local filtering can trigger scroll event and the flag should be reset after the scroll event was triggered
                        setTimeout(function () {
                            _options.disableScroll = false;
                        }, 0);
                    }

                    if (curVal) {
                    	this._showClearButton();
                    } else {
                    	this._hideClearButton();
                    }

                    this._updateSelection(event);
                    this._updateAutoComplete();

                    if (_options.validator) {
                        _options.validator._validateInternal(this.element, event);
                    }
                }

                if (openDropDown) {
                    // D.A. 10th March 2015, Bug #189913 Entering IME in the combo does not work correctly the first time. Input should not be focused on open.
                    this.openDropDown(null, false, event);
                }
            }
        },
        _handleShiftNavigation: function ($itemToNavigate, event) {
            var _options = this._options,
                $keyNavItem = this._$keyNavItem();

            if ($itemToNavigate.is(_options.$itemsToSelectOnShiftUpDown)) {
                // The user is navigating backwards and we should restore the state of the previous item
                $keyNavItem.removeClass(this.css.itemInFocus);
                _options.$itemsToSelectOnShiftUpDown = _options.$itemsToSelectOnShiftUpDown.not($keyNavItem);
            } else {
                $itemToNavigate.addClass(this.css.itemInFocus);
                _options.$itemsToSelectOnShiftUpDown = _options.$itemsToSelectOnShiftUpDown.add($itemToNavigate);
            }

            this._navigateToItem($itemToNavigate, false, false, event);
        },
        _handleShiftUp: function (event) {
            var _options = this._options;

            if (_options.$itemsToSelectOnShiftUpDown.length > 1) {
                this.select(_options.$itemsToSelectOnShiftUpDown, {
                    additive: true,
                    focusCombo: true,
                    keepNavItem: true,
                    keepFiltering: true
                }, event);

                _options.$itemsToSelectOnShiftUpDown.removeClass(this.css.itemInFocus);
            }

            // Reset shift up/down selection
            _options.$itemsToSelectOnShiftUpDown = $();
            _options.shiftDown = false;
        },
        _handleShiftClick: function (event) {
            var _options = this._options;

            if (_options.$itemsToSelectOnShiftClick.length > 1) {
                this.select(_options.$itemsToSelectOnShiftClick, {
                    additive: true,
                    focusCombo: true,
                    keepNavItem: true,
                    keepFiltering: true
                }, event);

                _options.$itemsToSelectOnShiftClick.removeClass(this.css.itemInFocus);

                // Change key nav item to the one that was moused up on
                this._setKeyNavigationItem({
                    data: $(event.target),
                    clearPrevItem: true
                });
            }

            // Reset shift click selection
            _options.$itemsToSelectOnShiftClick = $();
        },
        _groupHeaderClass: function () {
            return '.' + this.css.groupHeader.split(" ", 1)[0];
        },
        _$groupHeaders: function () {
            return this._$items(true).filter(this._groupHeaderClass());
        },
        _handleKeyNavigation: function (event) {
            // if reorderingFunctionInvocationTimeout = 0, from time to time the order of invocation get broken
            var $item, index, multiSelect, closeDropDown, isAutoSelectedActive, $lastSelectedItem, visibleItemsCount,
                self = this,
                options = this.options,
                _options = this._options,
                multiSelection = options.multiSelection.enabled,
                $keyNavItem = this._$keyNavItem(),
                $visibleItems = this._$items().filter(':visible'),
                currentScrollTop = this.listScrollTop(),
                activeIndex = this.activeIndex(),
				itemHeight = this._itemHeight(),
				addScrollCallback = false;

            // Remove the last text the user typed that is not part of selection
            // Close drop down when input is empty on escape
            if (event.keyCode === $.ui.keyCode.ESCAPE) {
                if (options.multiSelection.enabled) {
                    if (this._lastValAfterItemSep().length === 0) {
                        this.closeDropDown(null, event);
                    } else {
                        this._updateInputValues();
                        this.clearFiltering(event);
                        this._unhighlight();
                    }
                } else {
                    if (_options.inputVal.length === 0) {
                        // Input is empty
                        this.closeDropDown(null, event);
                    } else if (_options.selectedData.length === 0) {
                        // There is text, but no selection
                        this._updateInputValues();
                        this.clearFiltering(event);
                        this._unhighlight();
                    } else if (_options.autoSelectedItemData) {
                        // There is selection, but the item was auto selected, then we should deselect it
                        this._deselectData(_options.autoSelectedItemData, null, event);
                        this.clearFiltering(event);
                        this._unhighlight();
                    } else {
                        // There is selected item, that is not auto selected
                        this.closeDropDown(null, event);
                    }
                }

                // Prevent fire fox from returning the input value on esc
                event.preventDefault();
            }

            // Handle arrow down
            if (event.keyCode === $.ui.keyCode.DOWN) {
                if (event.altKey || !_options.dropDownOpened) {
                    this.openDropDown(null, true, event);
                } else {
                    $item = $keyNavItem.length > 0 ? this._nextVisibleItem($keyNavItem) : $visibleItems.eq(0);

                    if (event.shiftKey && multiSelection && _options.dropDownOpened) {
                        this._handleShiftNavigation($item, event);
                    } else {
                        this._navigateToItem($item, true, true, event);
                    }

                    // S.T. June 26th, 2015 Bug #201716: In the matter when grouping is enabled, 
                    // the intial rendered header group count should be extrated from visibleItemsCount.
                    visibleItemsCount = options.visibleItemsCount - 1;
                    if (options.grouping) {
                        visibleItemsCount -= this._$groupHeaders().length;
                    }

                    // S.T. March 9th, 2015 Bug #188227: Handling DOWN arrow with virtualization.
                    if (options.virtualization && (activeIndex >= visibleItemsCount)) {
                        this.listScrollTop(currentScrollTop + itemHeight + 1);
                    }
                }

                // Prevent carret from moving to end of input text
                event.preventDefault();
            }

            // Handle arrow up
            if (event.keyCode === $.ui.keyCode.UP) {
                if (_options.dropDownOpened) {
                    // Close drop down on alt + up or on up when the top most item was the active one
                    if (event.altKey || $keyNavItem.length === 0 ||
                        // S.T. June 6th, 2015 Bug #201028: Use function to compare values.
                        this._isDataEqual(_options.keyNavItemData, options.dataSource.dataView()[0])) {
                        this.closeDropDown(null, event);
                    } else {
                        $item = this._prevVisibleItem($keyNavItem);

                        if (event.shiftKey && multiSelection && _options.dropDownOpened) {
                            this._handleShiftNavigation($item, event);
                        } else {
                            this._navigateToItem($item, true, true, event);
                        }

                        // S.T. March 9th, 2015 Bug #188227: Handling UP arrow with virtualization.
                        if (options.virtualization && (activeIndex - 1 < 0)) {
                            this.listScrollTop(currentScrollTop - itemHeight - 1);
                        }
                    }
                }

                // Prevent carret from moving to begining of input text
                event.preventDefault();
            }

            // Select the item on enter
            if (event.keyCode === $.ui.keyCode.ENTER || (options.selectItemBySpaceKey && event.keyCode === $.ui.keyCode.SPACE)) {
                // Select all items from last selectied item to the navigation item on shift + enter
                if (event.shiftKey && _options.$itemsToSelectOnShiftUpDown.length === 1) {
                    $lastSelectedItem = this._$elementFromData(_options.selectedData[_options.selectedData.length - 1]);
                    this.select(this._itemsBetweenTwoItems($keyNavItem, $lastSelectedItem), { additive: true });
                } else {
                    isAutoSelectedActive = $keyNavItem.is(_options.$autoSelectedItem);
                    multiSelect = multiSelection && (!options.multiSelection.addWithKeyModifier || event.ctrlKey || isAutoSelectedActive);

                    if (multiSelect && this.isSelected($keyNavItem) && !isAutoSelectedActive) {
                        this._deselectData(_options.keyNavItemData, { focusCombo: true }, event);
                    } else {
                        closeDropDown = multiSelect ? false : options.closeDropDownOnSelect;

                        if (options.autoComplete && $keyNavItem.length === 0 && _options.autoCompleteItemData) {
                            // Select auto completed item if there is no navigation item on enter press
                            this._selectData(_options.autoCompleteItemData, {
                                additive: multiSelect,
                                closeDropDown: closeDropDown,
                                focusCombo: true
                            }, event);
                        } else {
                            this._selectData(_options.keyNavItemData, {
                                additive: multiSelect,
                                closeDropDown: closeDropDown,
                                focusCombo: true
                            }, event);
                        }
                    }
                }

                // Prevent default form submit on enter. Prevent space being inserted
                if ((event.keyCode === $.ui.keyCode.ENTER && options.preventSubmitOnEnter) || event.keyCode === $.ui.keyCode.SPACE) {
                    event.preventDefault();
                }
            }

            // Select first item on home + ctrl
            if (event.keyCode === $.ui.keyCode.HOME && event.ctrlKey && _options.dropDownOpened) {
            	// S.T. 08-Sept-2015 #205955: Dropdown list does not scroll by Ctrl + Home, if virtualization is enabled.
            	if (options.virtualization) {
            		this.listScrollTop(0);
            		addScrollCallback = true;
            	}

            	if (addScrollCallback) {
            		this._options.scrollCallback = function () {
            			self._navigateToItem($visibleItems.first(), true, true, event);
            		};
            	} else {
            		this._navigateToItem($visibleItems.first(), true, true, event);
            	}

                // Prevent caret from moving to beginning of input text
                event.preventDefault();
            }

            // Select last item on ctrl + end
            if (event.keyCode === $.ui.keyCode.END && event.ctrlKey && _options.dropDownOpened) {
            	// S.T. 08-Sept-2015 #205955: Dropdown list does not scroll by Ctrl + End, if virtualization is enabled.
            	if (options.virtualization) {
            		this.listScrollTop(this.options.dataSource.totalLocalRecordsCount() * itemHeight);
            		addScrollCallback = true;
            	}

            	if (addScrollCallback) {
            		this._options.scrollCallback = function () {
            			self._navigateToItem($visibleItems.last(), true, true, event);
            		};
            	} else {
            		this._navigateToItem($visibleItems.last(), true, true, event);
            	}
            
                // Prevent caret from moving to the end of input text
                event.preventDefault();
            }

            // Move the navigation item with single page size to the top of the list on page up
            if (event.keyCode === $.ui.keyCode.PAGE_UP && _options.dropDownOpened) {
                index = -options.visibleItemsCount + 1;

                if ($keyNavItem.length > 0) {
                    index += $visibleItems.index($keyNavItem);
                }

                if (index < 0) {
                    // P.P. 15-Jul-2015 #202198: Dropdown list does not scroll by PageDown and PageUp keys if virtualization is enabled.
                    if (options.virtualization && currentScrollTop > 0) {
                        this.listScrollTop(currentScrollTop + itemHeight * index);
                        addScrollCallback = true;
                    }

                    index = 0;
                }

                // P.P. 15-Jul-2015 #202198: Dropdown list does not scroll by PageDown and PageUp keys if virtualization is enabled.
                if (addScrollCallback) {
                    this._options.scrollCallback = function () {
                        self._navigateToItem($visibleItems.eq(index), true, true, event, true);
                    };
                } else {
                    this._navigateToItem($visibleItems.eq(index), true, true, event, true);
                }

                // Prevent page from scrolling up
                event.preventDefault();
            }

            // Move the navigation item with single page size to the bottom of the list on page down
            if (event.keyCode === $.ui.keyCode.PAGE_DOWN && _options.dropDownOpened) {
                index = options.visibleItemsCount - 1;

                if ($keyNavItem.length > 0) {
                    index += $visibleItems.index($keyNavItem);
                }

                if (index > $visibleItems.length - 1) {
                    // P.P. 15-Jul-2015 #202198: Dropdown list does not scroll by PageDown and PageUp keys if virtualization is enabled.
                    if (options.virtualization) {
                        this.listScrollTop(currentScrollTop + itemHeight * index);
                        addScrollCallback = currentScrollTop < this.listScrollTop();
                    }

                    index = $visibleItems.length - 1;
                }

                // P.P. 15-Jul-2015 #202198: Dropdown list does not scroll by PageDown and PageUp keys if virtualization is enabled.
                if (addScrollCallback) {
                    this._options.scrollCallback = function () {
                        self._navigateToItem($visibleItems.eq(index), true, true, event);
                    };
                } else {
                    this._navigateToItem($visibleItems.eq(index), true, true, event);
                }

                // Prevent page from scrolling down
                event.preventDefault();
            }

            // Start multiple selection on shift press
            if (event.keyCode === _options.shiftKeyCode && multiSelection &&
                _options.dropDownOpened && !_options.shiftDown) {
                _options.shiftDown = true;

                _options.$itemsToSelectOnShiftUpDown = $keyNavItem;
                $keyNavItem.addClass(this.css.itemInFocus);
            }
        },
        _dropDownContHeight: function () {
            var _options = this._options,
                dropDownContainerHeight = parseInt(_options.$dropDownListCont.outerHeight(true), 10);

            // If header and footer templates are used
            if (_options.$header !== undefined) {
                dropDownContainerHeight += _options.$header.outerHeight(true);
            }

            if (_options.$footer !== undefined) {
                dropDownContainerHeight += _options.$footer.outerHeight(true);
            }

            return dropDownContainerHeight;
        },
        // Return jQuery object containing both items plus all items between them
        _itemsBetweenTwoItems: function ($item1, $item2) {
            var firstIndex, sndIndex, temp,
                $items = this._$items(),
                $result = $();

            firstIndex = $items.index($item1);
            sndIndex = $items.index($item2);

            // Swap values so firstIndex is the lower one
            if (firstIndex > sndIndex) {
                temp = firstIndex;
                firstIndex = sndIndex;
                sndIndex = temp;
            }

            for (; firstIndex <= sndIndex; firstIndex++) {
                $result = $result.add(this._visibleItemByIndex(firstIndex));
            }

            return $result;
        },
        // Focus the text input without changing combo state
        _safeFocusInput: function (preventItemSeparatorOnFocus) {
            var $input = this._options.$input,
                input = $input[0];

            // These flags should be reset in focusInput handler, because focus in IE is executed after this whole method has finished execution
            this._options.preventDropDownOnFocus = true;

            // Prevent input value from changing on select/deselect while analyzing selection in _updateSelection method
            this._options.preventItemSeparatorOnFocus = preventItemSeparatorOnFocus;

            if (!$input.is(':focus')) {
                input.focus();
            } else {
                // Trigger focus handler to reset the flags
                // $().focus() is not recommended when input is not focused, because it triggers focus handler twice in IE
                $input.focus();
            }
        },
        _windowResize: function () {
            this.positionDropDown();
        },
        _documentMouseUp: function () {
            var _options = this._options;

            if (_options.$itemsToSelectOnShiftClick.length > 0) {
                _options.$itemsToSelectOnShiftClick = $();
            }

            _options.mouseDownStartedFromListItem = false;
        },
        _inputFocus: function (event) {
            var mode = this.options.mode;

            if (this.options.disabled) {
                return;
            }

            if (mode === 'editable' || mode === 'dropdown') {
                this._options.$combo.addClass(this.css.active);
            }

            if (mode === 'editable') {
                if (this._options.preventItemSeparatorOnFocus) {
                    this._options.preventItemSeparatorOnFocus = false;
                } else {
                    this._addItemSeparatorToEnd();
                }
            }

            if (mode === 'editable' && this.options.dropDownOnFocus) {
                if (this._options.preventDropDownOnFocus) {
                    this._options.preventDropDownOnFocus = false;
                } else {
                    this.openDropDown(null, true, event);
                }
            }
        },
        _inputBlur: function (event) {
            var _options = this._options,
                $activeEl = $(document.activeElement);

            if (this.options.disabled) {
                return;
            }

            // In IE clicking on the drop down scrollbar triggers input's blur
            // Prevent the blur and focus the input
            // D.A. 16th March 2015, Bug #190542 Blur should be prevented also when clicking icon elements, because in IE8
            // clicking them triggers input blur, even when the element's mouse down event was called preventDefault()
            if ($activeEl.is(_options.$dropDownListCont) ||
                $activeEl.is(_options.$dropDownBtnIcon) ||
                $activeEl.is(_options.$clearIcon)) {
                _options.preventInputBlur = true;
                this._safeFocusInput(true);
            }

            if (!_options.preventInputBlur) {
                if (this.options.mode === 'editable' || this.options.mode === 'dropdown') {
                    _options.$combo.removeClass(this.css.active);
                }

                if (this.options.mode === 'editable') {
                    this._removeItemSeparatorFromEnd();
                }

                if (this.options.closeDropDownOnBlur) {
                    this.closeDropDown(null, event);
                }

                if (!_options.dropDownOpened) {
                    if (_options.validator) {
                        _options.validator._validateInternal(this.element, event, true);
                    }
                }
            } else {
                _options.preventInputBlur = false;
            }
        },
        _inputClick: function (event) {
            if (this.options.disabled) {
                return;
            }

            if (this.options.mode === 'dropdown' || this.options.mode === 'readonlylist') {
                this._toggleDropDownState(event);
            }
        },
        _inputKeyDown: function (event) {
            if (this.options.disabled) {
                return;
            }

            if (this.options.mode === 'editable' || this.options.mode === 'dropdown') {
                this._handleKeyNavigation(event);

                if (this.options.autoComplete) {
                    this._options.hadInputSelectionOnKeydown = this._hasInputSelection();
                }
            }
        },
        _inputPaste: function (event) {
            var self = this;

            if (this.options.disabled) {
                return;
            }

            if (this.options.mode === 'editable') {
                // On paste input value is not updated
                // We should wait after paste for input value to be populated
                setTimeout(function () {
                    self._handleInputChange(!self._options.dropDownOpened, event);
                }, 0);
            }
        },
        _handleDropDownModeKeypress: function (event) {
            var curText, curData, value, startValue, startIndex, i,
                options = this.options,
                _options = this._options,

                // Event.which should be used, it normalises event.keyCode/charCode
                curChar = String.fromCharCode(event.which),
                data = options.dataSource.dataView(),
                len = data.length,
                textKey = options.textKey;

            // New typing should clear the reset timeout
            clearTimeout(_options.dropDownModeSearchByResetTimeout);

            // Pressing the same single character multiple times should not be treated as whole string of characters
            // E.g Pressing fast 'a', 'a' should search 2 times by 'a', instead of 'a' and 'aa'
            if (_options.dropDownModeSearchBy !== curChar) {
                _options.dropDownModeSearchBy += curChar;
            }

            if (options.multiSelection.enabled) {
                startValue = _options.keyNavItemData;
            } else {
                startValue = _options.selectedData[_options.selectedData.length - 1][options.valueKey];
            }

            startIndex = this._dataIndexByValue(startValue, true);

            if (_options.dropDownModeSearchBy.length === 1) {
                // Start from next item when the search string is only single character long
                startIndex += 1;
            }

            // Search through all data for matching item, strating from the last selected item
            for (i = 0; i < len; i++) {
                curData = this._unwrapData(data[(i + startIndex) % len]);
                curText = this._unwrapData(curData[textKey]);

                if (!options.caseSensitive) {
                    curText = curText.toLowerCase();
                    _options.dropDownModeSearchBy = _options.dropDownModeSearchBy.toLowerCase();
                }

                if (curText.startsWith(_options.dropDownModeSearchBy)) {
                    if (options.multiSelection.enabled) {
                        this._setKeyNavigationItem({
                            data: curData,
                            addStyles: true,
                            clearPrevItem: true
                        });
                    } else {
                        this._selectData(curData, {}, event);
                    }

                    break;
                }
            }

            // Scroll to the new selected item when selection changed
            if (value !== undefined) {
                if (options.multiSelection.enabled) {
                    this._scrollToItem(_options.keyNavItemData);
                } else {
                    this._scrollToLastSelItem();
                }
            }

            // Reset search string if the user doesn't type anything next 1000 ms
            _options.dropDownModeSearchByResetTimeout = setTimeout(function () {
                _options.dropDownModeSearchBy = '';
            }, _options.dropDownModeSearchByResetDelay);
        },
        _inputKeyPress: function (event) {
            if (this.options.disabled) {
                return;
            }

            if (this.options.mode === 'dropdown') {
                this._handleDropDownModeKeypress(event);
            }
        },
        _inputKeyUp: function (event) {
            var self = this;

            if (this.options.disabled) {
                return;
            }

            if (this.options.mode === 'editable') {
                // Clear the timeout if previous timeout is still not executed
                clearTimeout(this._options.keyUpTimeout);
                this._options.autoCompleteItemData = null;

                this._options.keyUpTimeout = setTimeout(function () {
                    self._handleInputChange(!self._options.dropDownOpened, event);
                }, this.options.delayInputChangeProcessing);
            }

            if (this.options.mode === 'editable' || this.options.mode === 'dropdown') {
                if (event.keyCode === this._options.shiftKeyCode && this.options.multiSelection.enabled) {
                    this._handleShiftUp(event);
                }
            }
        },
        _inputMouseDown: function (event) {
            if (this.options.disabled) {
                return;
            }

            if (!this._options.$input.is(':focus')) {
                // Chrome does not move the carret if input wasn't focused initially
                // This happens when while the focus was in the input we have clicked somewhere inside the input to move the carret ourself
                this._options.$input.focus();
                this._moveCaretToInputEnd(true);

                // Prevent carret from being set to where user clicked
                event.preventDefault();
            }
        },
        _attachEvents: function () {
            var self = this,
                css = this.css,
                options = this.options,
                _options = this._options,
                _handlers = this._handlers;

            _options.$window.on({
                resize: _handlers.windowResize
            });

            $(document).on({
                mouseup: _handlers.documentMouseUp
            });

            // Combo events
            _options.$combo.on({
                mouseenter: function () {
                    if (options.disabled) {
                        return;
                    }

                    if (options.mode !== 'readonly') {
                        _options.$combo.addClass(css.hover);
                    }
                },
                mouseleave: function () {
                    if (options.disabled) {
                        return;
                    }

                    _options.$combo.removeClass(css.hover);

                    // Removes active class added when mousing down on the drop down button and leaving combo while holding mouse down
                    if (!((options.mode === 'editable' || options.mode === 'dropdown') && _options.$input.is(':focus'))) {
                        _options.$combo.removeClass(css.active);
                    }
                },
                mousedown: function () {
                    if (options.disabled) {
                        return;
                    }

                    if (options.mode !== 'readonly') {
                        _options.$combo.addClass(css.active);
                    }
                },
                mouseup: function () {
                    if (options.disabled) {
                        return;
                    }

                    if (options.mode === 'readonlylist') {
                        _options.$combo.removeClass(css.active);
                    }
                }
            });

            // Drop down button events
            _options.$dropDownBtnCont.on({
                mouseenter: function () {
                    if (options.disabled) {
                        return;
                    }

                    if (options.mode !== 'readonly') {
                        _options.$dropDownBtnCont.addClass(css.hover);
                    }
                },
                mouseleave: function () {
                    if (options.disabled) {
                        return;
                    }

                    if (options.mode !== 'readonly') {
                        _options.$dropDownBtnCont.removeClass(css.hover);
                    }
                },
                mousedown: function (event) {
                    if (options.disabled) {
                        return;
                    }

                    // Prevent mouse down from triggering blur on the combo input
                    event.preventDefault();
                },
                click: function (event) {
                    // Wait until items are added to the DOM
                    if (options.disabled ||
                        !(self._$items().length > 0 || _options.$dropDownListCont.find('.' + css.noMatchFound).length > 0)) {
                        return;
                    }

                    if (options.mode !== 'readonly') {
                        if (_options.dropDownOpened) {
                            self.closeDropDown(null, event);
                            self._moveCaretToInputEnd(true);
                        } else {
                            self.openDropDown(null, true, event);
                        }
                    }

                    // K.D. March 3rd, 2015 Bug #189454 When combo is in tileManager and click on expand button the list position is not correct.
                    // The event was propagated to the tile manager and so the tile was being expanded.
                    event.stopPropagation();
                }
            });

            // Clear button events
            _options.$clearCont.on({
                mouseenter: function () {
                    if (options.disabled) {
                        return;
                    }

                    if (options.mode !== 'readonly') {
                        _options.$clearCont.addClass(css.clearHover);
                    }
                },
                mouseleave: function () {
                    if (options.disabled) {
                        return;
                    }

                    if (options.mode !== 'readonly') {
                        _options.$clearCont.removeClass(css.clearHover);
                    }
                },
                mousedown: function (event) {
                    if (options.disabled) {
                        return;
                    }

                    // Prevent mouse down from triggering blur on the combo input
                    event.preventDefault();
                },
                click: function (event) {
                    if (options.disabled || _options.dataBinding) {
                        return;
                    }

                    if (options.mode === 'editable' || options.mode === 'dropdown') {
            			self._hideClearButton();
                        self.clearInput(event);
                        self._moveCaretToInputEnd(true);
                    }
                }
            });

            // Input events
            _options.$input.on({
                focus: _handlers.inputFocus,
                blur: _handlers.inputBlur,
                click: _handlers.inputClick,
                keydown: _handlers.inputKeyDown,
                paste: _handlers.inputPaste,
                keyup: _handlers.inputKeyUp,
                keypress: _handlers.inputKeyPress,
                mousedown: _handlers.inputMouseDown
            });

            // List items events
            _options.$dropDownListCont.on({
                mouseenter: function () {
                    var $this, $prevItems;

                    if (options.disabled) {
                        return;
                    }

                    if (options.mode === 'editable' || options.mode === 'dropdown') {
                        $this = $(this);

                        // Update shift + click selection when mouse is moved while shift is being held
                        if (_options.$itemsToSelectOnShiftClick.length > 0) {
                            $prevItems = _options.$itemsToSelectOnShiftClick;

                            // Get the new items to select
                            _options.$itemsToSelectOnShiftClick = self._itemsBetweenTwoItems(self._$keyNavItem(), $this);

                            // Remove styling from items in previous selection range, that are not in the new one
                            $prevItems
                                .not(_options.$itemsToSelectOnShiftClick)
                                    .removeClass(css.itemInFocus);

                            // Add styling to the new range of items
                            _options.$itemsToSelectOnShiftClick.addClass(css.itemInFocus);
                        } else {
                            $this.addClass(css.hover);

                            if (_options.mouseDownStartedFromListItem) {
                                // Add mouse down class on the item when user is holding
                                // the mouse button down while hovering over the item
                                $this.addClass(css.itemInFocus);
                            }
                        }
                    }
                },
                mouseleave: function () {
                    var $this;

                    if (options.disabled) {
                        return;
                    }

                    if (options.mode === 'editable' || options.mode === 'dropdown') {
                        $this = $(this);

                        // Clear hover
                        $this.removeClass(css.hover);

                        // Clear item in focus applied on mouse down
                        if (!($this.is(self._$keyNavItem()) || $this.is(_options.$itemsToSelectOnShiftUpDown))) {
                            $this.removeClass(css.itemInFocus);
                        }

                        // Clear shift + click selection styles
                        if (_options.$itemsToSelectOnShiftClick.length > 0) {
                            _options.$itemsToSelectOnShiftClick.removeClass(css.itemInFocus);
                        }
                    }
                },
                mousedown: function (event) {
                    var $this, $keyNavItem;

                    if (options.disabled) {
                        return;
                    }

                    if (options.mode === 'editable' || options.mode === 'dropdown') {
                        // Handle only left mouse button
                        if (event.which === 1) {
                            $this = $(this);
                            $keyNavItem = self._$keyNavItem();

                            if (event.shiftKey && options.multiSelection.enabled) {
                                if ($keyNavItem.length === 0) {
                                    $keyNavItem = self._$items().filter(':visible').eq(0);

                                    self._setKeyNavigationItem({
                                        data: $keyNavItem,
                                        addStyles: true
                                    });
                                }

                                _options.$itemsToSelectOnShiftClick = self._itemsBetweenTwoItems($this, $keyNavItem);

                                // Add styling to all items between current navigation item and the shift clicked item
                                _options.$itemsToSelectOnShiftClick.addClass(css.itemInFocus);
                            } else {
                                $this.addClass(css.itemInFocus);
                            }

                            _options.mouseDownStartedFromListItem = true;
                        }
                    }
                },
                mouseup: function (event) {
                    var $this, multiSelect, closeDropDown;

                    if (options.disabled) {
                        return;
                    }

                    if (options.mode === 'editable' || options.mode === 'dropdown') {
                        // Handle only on left mouse button
                        if (_options.mouseDownStartedFromListItem && event.which === 1) {
                            $this = $(this);

                            if (event.shiftKey && options.multiSelection.enabled) {
                                // Select all items between the navigation item 
                                // and the selected item upon shift + click
                                self._handleShiftClick(event);
                            } else {
                                multiSelect = options.multiSelection.enabled && (!options.multiSelection.addWithKeyModifier || event.ctrlKey);
                                closeDropDown = multiSelect ? false : options.closeDropDownOnSelect;

                                if (multiSelect && self.isSelected($this) &&
                                    !self._$keyNavItem().is(_options.$autoSelectedItem)) {
                                    self.deselect($this, { focusCombo: true }, event);
                                } else {
                                    self.select($this, {
                                        additive: multiSelect,
                                        closeDropDown: closeDropDown,
                                        focusCombo: true
                                    }, event);
                                }
                            }

                            // Remove class added on mouse down
                            $this.removeClass(css.itemInFocus);
                        }
                    }
                }
            }, '.' + css.listItem.split(" ", 1)[0]);

            // Drop down list container events
            _options.$dropDownListCont.on({
                mousedown: function (event) {
                    if (options.disabled) {
                        return;
                    }

                    // Prevent mouse down from triggering blur on the combo input
                    event.preventDefault();
                },
                scroll: function () {
                    if (options.disabled) {
                        return;
                    }

                    _options.$loading.css({
                        top: self.listScrollTop()
                    });

                    if (!(_options.dataBinding || _options.disableScroll)) {
                        self._callNextChunk(_options.$dropDownListCont, self._itemHeight());
                    }
                }
            });

            // Header and footer
            _options.$dropDownCont.on({
                mousedown: function (event) {
                    // Prevent mouse down from triggering blur on the combo input
                    event.preventDefault();
                }
            }, '.' + css.header + ', .' + css.footer);

            if (_options.$dropDownScrollCont) {
                _options.$dropDownScrollCont
                    .on('scroll', function () {
                        if (options.disabled) {
                            return;
                        }

                        self._scrollVirtualization($(this));

                        if (_options.scrollCallback) {
                            _options.scrollCallback();
                            _options.scrollCallback = null;
                        }
                    });

                _options.$dropDownListCont.on('mousewheel DOMMouseScroll', function (event) {
                    var currentScrollTop = self.listScrollTop(),
                        itemHeight = self._itemHeight();

                    if (options.disabled) {
                        return;
                    }

                    if (event.originalEvent.wheelDelta > 0 || event.originalEvent.detail < 0) {
                        self.listScrollTop(currentScrollTop - itemHeight);
                    } else {
                        self.listScrollTop(currentScrollTop + itemHeight);
                    }

                    // S.T. June 15th, 2015 Bug 194461: The event should not be propagated because the page is moved while scroll over the items with virtualization.
                    if (options.virtualization) {
                        return false;
                    }
                });
            }
        },
        _scrollVirtualization: function ($this) {
            var itemHeight, offset, dropDownScrollHeight,
                options = this.options,
                self = this,
                _options = this._options;

            if (!options.virtualization || _options.dataBinding) {
                return;
            }

            if (options.filteringType === "local" &&
                _options.inputVal !== "" &&
                _options.expression !== undefined &&
                _options.expression !== null) {
                options.dataSource.filter(_options.expression, options.filteringLogic, true);
            }

            itemHeight = this._itemHeight();
            offset = this._offsetItems(options.dataSource.dataView(), itemHeight);
            this._updateItems(offset);

            options.dataSource.settings.callback = function (err, success, data) {
                dropDownScrollHeight = data.totalLocalRecordsCount() * itemHeight;

                _options.$dropDownScroll.height(dropDownScrollHeight);

                // S.T. June 15th, 2015 Bug 194325: Update footer vars when virtualization is enabled with load on demand. The callback handler is different.
                self._updateFooterVariables();
            };

            this._callNextChunk($this, itemHeight);
        },
        _offsetItems: function (dataView, itemHeight) {
            var offset, containerRatio, itemRatio;

            containerRatio = this.listScrollTop() / this._options.$dropDownScrollCont.prop("scrollHeight");
            itemRatio = itemHeight / this._dropDownHeight(itemHeight, dataView.length);
            offset = parseInt(containerRatio / itemRatio, 10);

            return offset;
        },
        _callNextChunk: function ($element, itemHeight) {
            var delta = this._options.deltaItemsForLoadOnDemand * itemHeight;

            if (this.listScrollTop() + $element.innerHeight() + delta >= $element.prop('scrollHeight')) {
                this._nextChunk();
            }
        },
        _disableCombo: function (value) {
            // Applying jQuery UI default disable logic to the wrapper element
            this._options.$comboWrapper
                .toggleClass(this.widgetFullName + "-disabled ui-state-disabled", !!value)
                .attr("aria-disabled", value);

            this.hoverable.removeClass("ui-state-hover");
            this.focusable.removeClass("ui-state-focus");

            if (value) {
                this._options.$input.attr('readonly', true);
                this._options.$hiddenInput.attr('disabled', true);
            } else {
                this._options.$input.removeAttr('readonly');
                this._options.$hiddenInput.removeAttr('disabled');
            }
        },
        _setOption: function (option, value) {
            var options = this.options,
                _options = this._options;

            if (options[option] === value) {
                return;
            }

            // Z.K. Bug #201980 - When try to set 'mode' option, the option is changed and 'Operation not supported' exception is thrown
            if (option === 'dropDownAttachedToBody' || option === 'virtualization' ||
                    option === 'mode' || option === 'format') {
                throw new Error($.ig.Combo.locale.notSuported);
            }

            // D.A. 10th March 2015, Bug #190028 Enabling multi selection through set option causes item separator to be undefined
            if (option === 'multiSelection') {
                value = $.extend(true, {}, options.multiSelection, value);
            }

            if (option === 'loadOnDemandSettings') {
                value = $.extend(true, {}, options.loadOnDemandSettings, value);
            }

            if (option === 'disabled') {
                this._disableCombo(value);
            }

            // S.T. 1th July 2015, Bug #201925: Adding set option for grouping
            if (option === 'grouping') {
                value = $.extend(true, {}, options.grouping, value);
            }

        	// S.T. 3th Sept 2015, Bug #203257: Add support for changing option enableClearButton
            if (option === 'enableClearButton') {
            	if (_options.inputVal) {
            		if (value === true) {
            			this._showClearButton(true);
            		} else {
            			this._hideClearButton();
            		}
            	}
            }

            $.Widget.prototype._setOption.apply(this, arguments);

            this._analyzeOptions();

            switch (option) {
                case 'width':
                    _options.$comboWrapper.outerWidth(value);
                    this.positionDropDown();
                    break;
                case 'height':
                    _options.$comboWrapper.outerHeight(value);
                    this.positionDropDown();
                    break;
                case 'dropDownWidth':
                    this.positionDropDown();
                    break;
                case 'itemTemplate':
                    // S.T. March 11th, 2015 Bug #189915: Render items after change.
                    this._renderItems(null, null, this.options.dataSource);
                    break;
                case 'inputName':
                    _options.$hiddenInput.attr('name', value);
                    break;
                case 'visibleItemsCount':
                    this._setListContMaxHeight();
                    break;
                case 'placeHolder':
                    _options.$input.attr('placeholder', value);
                    break;
                case 'multiSelection':
                    // Update selection to the first selected item when switching from multi selection to single 
                    this._selectData(this._options.selectedData[0]);
                    // S.T. March 11th, 2015 Bug #190156: Render items after change.
                    this._renderItems(null, null, this.options.dataSource);
                    // S.T. March 17th, 2015 Bug #190263: Clear input after rendering.
                    this.clearInput();
                    break;
                case 'tabIndex':
                    this._options.$input.attr('tabIndex', value);
                    break;
                case 'validatorOptions':
                    this.validator();
                    break;
                case 'dropDownButtonTitle':
                    _options.$dropDownBtnCont.attr('title', value);
                    break;
                case 'clearButtonTitle':
                    _options.$clearCont.attr('title', value);
                    break;
                case 'dataSource':
                case 'dataSourceType':
                case 'dataSourceUrl':
                case 'responseTotalRecCountKey':
                case 'responseDataKey':
                case 'responseDataType':
                case 'responseContentType':
                case 'requestType':
                case 'filteringType':
                case 'filterExprUrlKey':
                case 'filteringCondition':
                case 'filteringLogic':
                case 'loadOnDemandSettings':
                case 'grouping':
                    this.dataBind();
                    break;
                    // S.T. April 24th , Bug #192958: Changing the textKey and valueKey should only update values.
                case 'valueKey':
                case 'textKey':
                    this._updateItems();
                    break;
            }
        },
        _initDataSource: function () {
            var dataSourceOptions, schema, pagingOptions, curData, len, i,
                self = this,
                lod = this.options.loadOnDemandSettings,
                options = this.options,
                isStringDataSource = $.type(options.dataSource) === "string",
                url = options.dataSourceUrl;

            // Set the data source that should be used
            if (!options.dataSource && this.element.is("select")) {
                options.dataSource = this.element[0];
                schema = this._initSelectSchema();
                // K.D. March 2nd, 2015 Bug #189514 Handling the case of dataSource not set and dataSourceUrl is provided as initial data source
            } else if (!options.dataSource && url) {
                options.dataSource = url;
                isStringDataSource = true;
            }

            // P.P. 29-June-2015 Bug #201942: We need to unwrap the data here, because of the following logic.
            if ($.type(options.dataSource) === "function") {
                options.dataSource = options.dataSource();
            }

            if (!(options.dataSource && this._isInstanceOfDataSource(options.dataSource))) {
                // When dataSource is array of primitives convert it to array of objects
                // S.T. March 11th, 2015 Bug #190266: Add date.
                if ($.type(options.dataSource) === 'array' && ($.type(options.dataSource[0]) === 'number' || $.type(options.dataSource[0]) === 'string' || $.type(options.dataSource[0]) === 'date')) {
                    for (i = 0, len = options.dataSource.length; i < len; i++) {
                        curData = options.dataSource[i];

                        options.dataSource[i] = {};
                        options.dataSource[i][options.textKey] = curData;
                        options.dataSource[i][options.valueKey] = curData;
                    }
                }

                // Analyze the schema only when the data source is array or function 
                if (!schema && options.dataSource && ($.isArray(options.dataSource) || $.isFunction(options.dataSource))) {
                    // N.A. 5/18/2015 Bug #193129: Unwrap before extracting the schema from the first field element.
                    schema = this._initSchema(this._unwrapData(options.dataSource)[0]);
                }

                dataSourceOptions = {
                    callback: this._renderItems,
                    callee: this,
                    dataSource: options.dataSource,
                    type: options.dataSourceType || undefined,
                    requestType: options.requestType || "GET",
                    responseContentType: options.responseContentType || null,
                    responseDataType: options.responseDataType || null,
                    responseDataKey: options.responseDataKey || null,
                    responseTotalRecCountKey: options.responseTotalRecCountKey || null,
                    localSchemaTransform: false,
                    schema: schema || null,
                    dataBinding: function () {
                        if (!self._options.dropDownOpened || self._options.dataBinding) {
                            return;
                        }

                        self._options.dataBinding = true;
                        self._options.$loading.insertBefore(self._options.$dropDownList);
                    },
                    dataBound: function () {
                        self._options.$loading.remove();
                        self._options.dataBinding = false;
                    }
                };

                // S.T. Feb 24th, 2015 Bug #189447: Enable LOD only for url and if data source is string
                if (lod && lod.enabled && (url || isStringDataSource)) {
                    pagingOptions = {
                        enabled: true,
                        appendPage: true,
                        pageSize: lod.pageSize,
                        pageIndex: 0,
                        // S.T. Feb 27th, 2015 Bug #189554: Handle when lod is from MVC wrapper.
                        pageSizeUrlKey: lod.pageSizeUrlKey || null,
                        pageIndexUrlKey: lod.pageIndexUrlKey || null
                    };

                    $.extend(dataSourceOptions, {
                        paging: pagingOptions
                    });
                }

                // S.T. Feb 24th, 2015 Bug #189447: Handle when data source is JSONP.
                if ($.type(options.dataSource) === "string" &&
                    !options.dataSourceType &&
                    $.ig.util.isJsonpUrl(options.dataSource)) {
                    // S.T. Feb 24th, 2015 Bug #189704: Save string data source url
                    this._options.strDataSource = options.dataSource;
                    options.dataSource = new $.ig.JSONPDataSource(dataSourceOptions);
                } else {
                    options.dataSource = new $.ig.DataSource(dataSourceOptions);
                }

                // S.T. Feb 24th, 2015 Bug #189447: Handle when data source url is set fo remote filtering with MVC wrapper.
                if (url) {
                    options.dataSource.settings.dataSource = url;
                    options.dataSource.settings.type = 'remoteUrl';
                    options.dataSource._runtimeType = options.dataSource.analyzeDataSource();
                    options.dataSource.settings.urlParamsEncoded = $.proxy(function (data, params) {
                        params = params ? params.filteringParams : null;
                        // set flag used by Mvc remote filtering
                        if (params) {
                            params.textKey = options.textKey || options.valueKey;
                            params.valueKey = options.valueKey;

                            if (!options.caseSensitive) {
                                params.toLower = "1";
                            }

                            if (options.compactData) {
                                params.compact = "1";
                            }
                        }
                    }, this);
                }

                // S.T. Feb 27th, 2015 Bug #189554: Support for loadOnDemand coming from Mvc
                var _aNull = function (v, nan) {
                    return v === null || v === undefined || (nan && typeof v === 'number' && isNaN(v));
                };

                options.dataSource._responseData = function (data) {
                    var len = data ? data.length : 0,
                        count = (len > 0) ? data[len - 1][':totals:'] : null;

                    if (count) {
                        data.pop();
                        count = count.split(':');
                        options.dataSource.totalRecordsCount(_aNull(len = parseInt(count[0], 10), true) ? 0 : len);
                        len = _aNull(len = parseInt(count[1], 10), true) ? 0 : len;

                        if (len) {
                            // The number of all total records on the server
                            self._options.totalAll = len;
                        }
                    }
                };
            }
        },
        _isInstanceOfDataSource: function (ds) {
            return typeof ds._xmlToArray === "function" &&
                typeof ds._encodePkParams === "function";
        },
        _nextChunk: function () {
            var lod = this.options.loadOnDemandSettings,
                ds = this.options.dataSource;

            if (lod && ds && lod.enabled) {
                ds.settings.paging.appendPage = true;

                if (!this.options.virtualization) {
                    this.options.dataSource.settings.callback = this._handleLoadOnDemand;
                }

                ds.nextPage();
            }

            return this;
        },
        _initSelectSchema: function () {
            var schema = {};

            schema.fields = [
                {
                    name: this.options.valueKey,
                    type: 'string'
                },
                {
                    name: this.options.textKey,
                    type: 'string'
                }
            ];

            return schema;
        },
        _initSchema: function (firstDsRow) {
            var field,
                schema = {
                    fields: []
                };

            for (field in firstDsRow) {
                if (firstDsRow.hasOwnProperty(field)) {
                    schema.fields.push({
                        name: field,
                        type: $.type(firstDsRow[field])
                    });
                }
            }

            return schema;
        },
        _filteringCondition: function () {
            return this.options.autoComplete ? "startsWith" : this.options.filteringCondition;
        },
        _generateExpressions: function (texts) {
            var i, expressions = [];

            if ($.type(texts) === "string") {
                // K.D. March 3rd, 2015 Bug #189365 When clearing the filter leave the array empty.
                if (texts.length > 0 || (this._options.expression && this._options.expression.length > 0)) {
                    expressions.push({
                        fieldName: this.options.textKey,
                        expr: texts,
                        cond: this._filteringCondition()
                    });
                }
            } else if ($.type(texts) === "array") {
                for (i = 0; i < texts.length; i++) {
                    if ($.type(texts[i]) === "string") {
                        expressions.push({
                            fieldName: this.options.textKey,
                            expr: texts[i],
                            cond: this._filteringCondition(),
                            logic: this.options.filteringLogic
                        });
                    } else {
                        throw new Error($.ig.igCombo.locale.errorNoSupportedTextType);
                    }
                }
            } else {
                throw new Error($.ig.igCombo.locale.errorNoSupportedTextsType);
            }

            return expressions;
        },
        _generateRegExpPattern: function (texts) {
            var pattern = null,
                types = {
                    "multi": function (texts) {
                        return "(" + texts.join("|") + ")";
                    },
                    "startsWith": function (texts) {
                        return "^(" + texts.join("|") + ")";
                    },
                    "full": function (texts) {
                        return "^" + texts.join("|") + "$";
                    },
                    "contains": function (texts) {
                        return texts.join("|");
                    }
                };

            if ($.type(texts) === "string") {
                texts = [texts];
            }

            // Filter empty strings
            texts = $.grep(texts, function (text) {
                return text !== "";
            });

            texts = $.map(texts, function (text) {
                return text.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
            });

            if (texts.length > 0) {
                if ($.type(types[this.options.highlightMatchesMode]) === "function") {
                    pattern = types[this.options.highlightMatchesMode](texts);
                } else {
                    throw new Error($.ig.igCombo.locale.errorUnrecognizedHighlightMatchesMode);
                }
            }

            return pattern;
        },
        _highlight: function (texts) {
            var pattern, regex, $curContents, $matchingTextNodes, filterMatches, highlighMatches, len, i,
                $items = this._$items(),
                highlightElement = this._options.highlightElement,
                highlightCssClass = this.css.listItemHighlighted,
                regExpFlag = this.options.caseSensitive ? "" : "i";

            // Disabled highlighting with item templates
            if (this.options.highlightMatchesMode === null || this.options.itemTemplate) {
                return;
            }

            // Contains should return only first match but "g" makes return all matches. We are adding for all other modes "g".
            if (this.options.highlightMatchesMode !== "contains") {
                regExpFlag += "g";
            }

            pattern = this._generateRegExpPattern(texts);

            if (pattern) {
                regex = new RegExp(pattern, regExpFlag);

                filterMatches = function () {
                    return this.nodeType === 3 && regex.test(this.nodeValue);
                };

                highlighMatches = function () {
                    return (this.nodeValue || "")
                        .replace(regex, function (match) {
                            return "<" + highlightElement + " class=\"" + highlightCssClass + "\">" + match + "</" + highlightElement + ">";
                        });
                };

                for (i = 0, len = $items.length; i < len; i++) {
                    if (this._checkBoxesEnabled()) {
                        $curContents = $items.eq(i).children('.' + this.css.listItemTextWithCheckbox).contents();
                    } else {
                        $curContents = $items.eq(i).contents();
                    }

                    $matchingTextNodes = $curContents.filter(filterMatches);

                    // Replace all matches
                    $matchingTextNodes.replaceWith(highlighMatches);
                }
            }
        },
        _unhighlight: function () {
            var $highlightedItems, curItem, curParent, len, i;

            if (this.options.highlightMatchesMode === null) {
                return this;
            }

            if (this._checkBoxesEnabled()) {
                $highlightedItems = this._$items()
                    .children("." + this.css.listItemTextWithCheckbox)
                        .children("." + this.css.listItemHighlighted);
            } else {
                $highlightedItems = this._$items().children("." + this.css.listItemHighlighted);
            }

            for (i = 0, len = $highlightedItems.length; i < len; i++) {
                curItem = $highlightedItems.eq(i)[0];
                curParent = curItem.parentNode;

                // Replace the highlighted element with the text it wraps
                curParent.replaceChild(curItem.firstChild, curItem);
                curParent.normalize();
            }
        },
        // Updates filtering to reflect current input text
        _updateFiltering: function (event) {
            var val = this._options.inputVal;

            // Use text after last item separator with multiple selection enabled
            if (this.options.multiSelection.enabled) {
                if (this._endsPartialyWithItemSep(val)) {
                    val = '';
                } else {
                    val = this._lastValAfterItemSep();
                }
            }

            this.filter(val, event);
        },
        // Updates highlighting to reflect current input text
        _updateHighlighting: function () {
            var val = this._options.inputVal,
                selItemsLen = this._fullySelectedItemsLen(),
                skipHighlight = false;

            if (!this.options.multiSelection.enabled) {
                // D.A. 20th March 2015, Bug #190151 When virtualization is enabled the selected item is highlighted on scroll
                if (selItemsLen === 1) {
                    skipHighlight = true;
                }
            } else {
                // D.A. 20th March 2015, Bug #190151 When virtualization is enabled the selected item is highlighted on scroll
                if (this._separatedInputTexts(val).length === selItemsLen) {
                    skipHighlight = true;
                } else {
                    // Use text after last item separator with multiple selection
                    val = this._lastValAfterItemSep(val);
                }
            }

            this._unhighlight();
            if (!skipHighlight) {
                this._highlight(val);
            }
        },
        // Updates input values to reflect the current selection
        _updateInputValues: function (keepInputText, selectedItems) {
            var curText, curData, len, i,
                options = this.options,
                _options = this._options,
                inputVal = "",
                hiddenInputVal = "",
                itemSeparator = options.multiSelection.itemSeparator;

            selectedItems = selectedItems || this.selectedItems();
            len = selectedItems ? selectedItems.length : 0;

			// K.D. This is the allowCustomValues feature
			if (options.allowCustomValue && !len) {
				inputVal = _options.$input.val();
				hiddenInputVal = inputVal;
			}

            for (i = 0; i < len; i++) {
                curData = this._unwrapData(selectedItems[i].data);
                curText = this._unwrapData(curData[options.textKey]);

                if (i !== 0) {
                    // Z.K. September 11, 2015 Bug #205954 - When dir=rtl and multiSelection is enabled intyp text is not correct when type in the input
                    if (!_options.ltr) {
                        inputVal = itemSeparator + inputVal;
                        hiddenInputVal = itemSeparator + hiddenInputVal;
                    } else {
                        inputVal += itemSeparator;
                        hiddenInputVal += itemSeparator;
                    }
                }

                if (!_options.ltr) {
                    if (curText !== '') {
                        inputVal = this._formatItem(curText) + inputVal;
                    }

                    hiddenInputVal = this._unwrapData(curData[options.valueKey]) + hiddenInputVal;
                } else {
                    // Z.K. 9th July 2015 Bug #202450 - "&nbsp;" displayed instead of blank value
                    if (curText !== '') {
                        inputVal += this._formatItem(curText);
                    }

                    hiddenInputVal += this._unwrapData(curData[options.valueKey]);
                }
            }

            if (!keepInputText) {
                // Append item separator when multi selection is enabled
                // When input is not focused we souldn't append it, this is to keep input value without item separator when combo is not focused
                if (options.multiSelection.enabled && len > 0 &&
                    options.mode === 'editable' && _options.$input.is(':focus')) {
                    inputVal += itemSeparator;
                }

                // Update input val
                _options.$input.val(inputVal);

                this._setInputVal(inputVal);

                // Reset auto selected item when the input value changes
                _options.autoSelectedItemData = null;
            }

            _options.$hiddenInput.val(hiddenInputVal);
        },
        // This can be used to initially select item that was not loaded in handleInitialSelection
        //_requestDataByValue: function (value) {
        //	var ds,
        //		options = this.options,
        //		dataSourceOptions = {
        //			callback: this._requestDataByValueCallback,
        //			callee: this,
        //			// S.T. Feb 24th, 2015 Bug #189704: use string data source url
        //			dataSource: this._options.strDataSource,
        //			type: "remoteUrl",
        //			filtering: {
        //				type: "remote",
        //				filterExprUrlKey: options.filterExprUrlKey,
        //				expressions: [{
        //					fieldName: this.options.valueKey,
        //					cond: "equals",
        //					expr: value
        //				}]
        //			}
        //		};

        //	ds = new $.ig.JSONPDataSource(dataSourceOptions);

        //	ds.dataBind();
        //},
        //_requestDataByValueCallback: function (success, msg, data) {
        //	return data;
        //},
        _handleLocalFilteringWithGrouping: function () {
            var groupsLen, i, $group,
                visibleItems = [],
                self = this,
                $groupHeaders = this._$groupHeaders(),
                filterVisible = function (index, item) {
					// JD Sept 3, 2015, TFS 205303 - Need to add a check to prevent noMatchFound giving a false positive
                    return !$(item).hasClass(self.css.hidden) && !$(item).hasClass(self.css.noMatchFound);
                };

            for (i = 0, groupsLen = $groupHeaders.length; i < groupsLen; i++) {
                $group = $($groupHeaders[i]);

                visibleItems = $group
                    .nextUntil(self._groupHeaderClass())
                    .filter(filterVisible);

                if (visibleItems.length === 0) {
                    $group.addClass(this.css.hidden);
                } else {
                    $group.removeClass(this.css.hidden);
                }
            }
        },
        _handleLocalFiltering: function (dataSource) {
            var $curItem, curKey, filterItem, dataLen, i, j, unwrappedDataViewItem, unwrappedDataViewValue,
                _options = this._options,
                valKey = this.options.valueKey,
                dataView = dataSource.dataView().slice(),
                initialDataLen = dataView.length,
                $items = this._$items(),
                len = $items.length,
                $keyNavItem = this._$keyNavItem(),
                cssHidden = this.css.hidden;

            // Filter items
            for (i = 0; i < len; i++) {
                $curItem = $items.eq(i);
                curKey = $curItem.attr('data-value');
                filterItem = true;

                for (j = 0, dataLen = dataView.length; j < dataLen && filterItem; j++) {
                    unwrappedDataViewItem = this._unwrapData(dataView[j]);
                    unwrappedDataViewValue = this._unwrapData(unwrappedDataViewItem[valKey]);

                    if (this._areValuesEqual(curKey, unwrappedDataViewValue)) {
                        filterItem = false;

                        // Remove the matching data item to skip cheking for it again
                        dataView.splice(j, 1);
                    }
                }

                if (filterItem) {
                    $curItem.addClass(cssHidden);
                } else {
                    $curItem.removeClass(cssHidden);
                }
            }

            // S.T. 14 th July, 2015 #Bug 201921: Hide empty groups
            if (this.options.grouping.key) {
                this._handleLocalFilteringWithGrouping();
            }

            if ($keyNavItem.length > 0 && $keyNavItem.hasClass(cssHidden)) {
                // Reset key navigation item when it is filtered
                this._setKeyNavigationItem({
                    data: $(),
                    clearPrevItem: true
                });
            }

            // Add/remove no match found
            if (initialDataLen === 0) {
                if (!_options.$noMatchFound) {
                    _options.$noMatchFound = $('<li>')
                        .addClass(this.css.noMatchFound)
                        .addClass(this.css.unselectable)
                        .attr('unselectable', 'on')
                        .html(this.options.noMatchFoundText);
                }

                if (_options.$noMatchFound.parent().length === 0) {
                    _options.$noMatchFound.appendTo(_options.$dropDownList);
                }
            } else if (_options.$noMatchFound && _options.$noMatchFound.parent().length > 0) {
                _options.$noMatchFound.detach();
            }
        },
        // Use this method as centralised place to change cached input value
        _setInputVal: function (val) {
            this._options.inputVal = val;
        },
        _setListContMaxHeight: function () {
            this._options.$dropDownListCont.css('maxHeight', this.options.visibleItemsCount * this._itemHeight());
        },
        _updateVirtualScrollVisibility: function () {
            if (this._isPossibleToVirtualize()) {
                this._options.$dropDownScrollCont.removeClass(this.css.hidden);
            } else if (this._areItemsLowerInVir()) {
                this._options.$dropDownScrollCont.addClass(this.css.hidden);
            }
        },
        _addItemSelectionStyles: function ($items) {
            var $curItem, len, i;

            for (i = 0, len = $items.length; i < len; i++) {
                $curItem = $items.eq(i);

                // S.T. 6th July, 2015 #201924: Skip adding selection on a group header.
                if (this._isGroupHeader($curItem)) {
                    continue;
                }

                $curItem.addClass(this.css.active);

                if (this._checkBoxesEnabled()) {
                    $curItem
                        .find('.ui-igcombo-checkbox .ui-icon')
                            .removeClass(this.css.checkboxOff)
                            .addClass(this.css.checkboxOn);
                }
            }
        },
        _removeItemSelectionStyles: function ($items) {
            var $curItem, len, i;

            for (i = 0, len = $items.length; i < len; i++) {
                $curItem = $items.eq(i);
                $curItem.removeClass(this.css.active);

                if (this._checkBoxesEnabled()) {
                    $curItem
                        .find('.ui-igcombo-checkbox .ui-icon')
                            .removeClass(this.css.checkboxOn)
                            .addClass(this.css.checkboxOff);
                }
            }
        },
        _addItemSeparatorToEnd: function () {
            var newVal,
                inputVal = this._options.inputVal,
                itemSep = this.options.multiSelection.itemSeparator,
                sepTexts = this._separatedInputTexts(inputVal),
                selItemsLen = this._fullySelectedItemsLen();

            if (inputVal.length > 0 &&
                this.options.multiSelection.enabled &&
                !inputVal.endsWith(itemSep) &&
                sepTexts.length === selItemsLen) { // To not add item separator to unfinished selection
                newVal = inputVal + itemSep;
                this._options.$input.val(newVal);
                this._setInputVal(newVal);
            }
        },
        _removeItemSeparatorFromEnd: function () {
            var newVal,
                inputVal = this._options.inputVal,
                itemSep = this.options.multiSelection.itemSeparator;

            if (this.options.multiSelection.enabled && inputVal.endsWith(itemSep)) {
                newVal = inputVal.slice(0, inputVal.length - itemSep.length);
                this._options.$input.val(newVal);
                this._setInputVal(newVal);
            }
        },
        // Fire callbacks when selection is changed from api
        _callInternalSelChangeSubs: function (event) {
            var curCallback, i,
                callbacks = this._options.internalSelChangeSubs;

            if ($.type(callbacks) === 'array') {
                for (i = 0; i < callbacks.length; i++) {
                    curCallback = callbacks[i];

                    if (typeof curCallback === 'function') {
                        curCallback();
                    }
                }
            }
            if (this._options.validator) {
                this._options.validator._validateInternal(this.element, event);
            }
        },
        _fullySelectedItemsLen: function () {
            var autoSelItemLen = this._options.autoSelectedItemData === null ? 0 : 1;

            return this._options.selectedData.length - autoSelItemLen;
        },
        _unwrapData: function (data) {
            if (typeof data === "function") {
                data = data();
            }

            return data;
        },
        _dropDownOrientation: function () {
            var dropDownAndComboHeight,
                _options = this._options,
                direction = this.options.dropDownOrientation,
                $combo = _options.$combo,
                comboOffset = $combo.offset(),
                comboTopOffset = comboOffset.top,
                comboOuterHeight = parseInt($combo.outerHeight(), 10),
                dropDownContainerHeight = this._dropDownContHeight(),
                windowHeight = _options.$window.height();

            dropDownAndComboHeight = parseInt((comboTopOffset + comboOuterHeight + dropDownContainerHeight), 10);

            // Determine drop down direction
            if (direction === "auto") {
                if (dropDownAndComboHeight < windowHeight + _options.$window.scrollTop()) {
                    direction = "bottom";
                } else if ((comboTopOffset - dropDownContainerHeight) > 0) {
                    direction = "top";
                } else {
                    direction = "bottom";
                }
            }

            // For the issue when drop down container is opened and page scroller is used
            if (direction === "top") {
                if (_options.$dropDownCont.hasClass(this.css.orientationBottom)) {
                    _options.$dropDownCont
                        .removeClass(this.css.orientationBottom)
                        .addClass(this.css.orientationTop);
                }
            } else {
                if (_options.$dropDownCont.hasClass(this.css.orientationTop)) {
                    _options.$dropDownCont
                        .removeClass(this.css.orientationTop)
                        .addClass(this.css.orientationBottom);
                }
            }

            return direction;
        },
        _startRepositionInterval: function () {
            var self = this;

            this._options.repositionInterval = setInterval(function () {
                self.positionDropDown();
            }, 200);
        },
        _clearRepositionInterval: function () {
            clearInterval(this._options.repositionInterval);
        },
        // Used to compare data-attribute value, which is always a string, to data source value, which may not be string
        _areValuesEqual: function (val1, val2) {
            // Z.K. 27/08/2015 Bug #205313 - Not possible to select item because of illegal special characters encoding
            return (val1 !== null && val1 !== undefined && val2 !== null && val2 !== undefined) ?
                $.ig.encode(val1.toString()) === $.ig.encode(val2.toString()) : false;
        },
        // Checks whether certain value is contained in array of values while converting the values to string, because of data-attributes always being a string
        // This should be unsed instead of $.inArray/indexOf to find if value is contained in an array
        _isValueInArray: function (val, vals) {
            var i = 0,
                len = vals.length;

            val = val && val.toString();

            for (; i < len; i++) {
                if (this._areValuesEqual(val, vals[i])) {
                    return i;
                }
            }

            return -1;
        },
        _triggerItemsRendering: function () {
            var args = {
                owner: this,
                dataSource: this.options.dataSource
            };

            return this._trigger(this.events.itemsRendering, null, args);
        },
        _triggerItemsRendered: function () {
            var args = {
                owner: this,
                dataSource: this.options.dataSource
            };

            this._trigger(this.events.itemsRendered, null, args);
        },
        _triggerRendered: function () {
            var args = {
                owner: this,
                element: this._options.$comboWrapper
            };

            this._trigger(this.events.rendered, null, args);
        },
        _triggerDataBinding: function () {
            var args = {
                owner: this,
                dataSource: this.options.dataSource
            };

            return this._trigger(this.events.dataBinding, null, args);
        },
        _triggerDataBound: function (success, msg) {
            var args = {
                owner: this,
                success: success,
                errorMessage: msg,
                dataSource: this.options.dataSource
            };

            this._trigger(this.events.dataBound, null, args);
        },
        _triggerFiltering: function (event) {
            var args = {
                owner: this,
                expression: this._options.expression
            };

            return this._trigger(this.events.filtering, event, args);
        },
        _triggerFiltered: function (event) {
            var args = {
                owner: this,
                // D.A. May 12, 2015 Bug #193415 Bad performance when loading many items
                // Changing the method to return jquery reference to the filtered items instead of item: { data, element },
                // because the "data" to "element" match is very slow for over 10 000 elements
                elements: this._$filteredItems()
            };

            this._trigger(this.events.filtered, event, args);
        },
        _triggerDropDownOpening: function (event) {
            var args = {
                owner: this,
                list: this._options.$dropDownCont
            };

            return this._trigger(this.events.dropDownOpening, event, args);
        },
        _triggerDropDownOpened: function (event) {
            var args = {
                owner: this,
                list: this._options.$dropDownCont
            };

            this._trigger(this.events.dropDownOpened, event, args);
        },
        _triggerDropDownClosing: function (event) {
            var args = {
                owner: this,
                list: this._options.$dropDownCont
            };

            return this._trigger(this.events.dropDownClosing, event, args);
        },
        _triggerDropDownClosed: function (event) {
            var args = {
                owner: this,
                list: this._options.$dropDownCont
            };

            this._trigger(this.events.dropDownClosed, event, args);
        },
        _triggerSelectionChanging: function (newSelItems, currentSelItems, event) {
            var args = {
                owner: this,
                items: newSelItems,
                currentItems: currentSelItems
            };

            return this._trigger(this.events.selectionChanging, event, args);
        },
        _triggerSelectionChanged: function (newSelItems, oldItems, event) {
            var args = {
                owner: this,
                items: newSelItems,
                oldItems: oldItems
            };

            this._trigger(this.events.selectionChanged, event, args);
        },
        dataBind: function () {
            /* Performs databinding on the combo box. The databinding event is always rised.
                returnType="object" Returns reference to this igCombo.
            */
            var noCancel;

            this._initDataSource();
            this._options.cachedData = [];
            noCancel = this._triggerDataBinding();

            if (noCancel) {
                if (!this._options.initialDataBinding) {
                    this.clearInput();

                    // Reset selectedData, because deselect() will not deselect non existent in data source values
                    this._options.selectedData = [];
                }

                this.options.dataSource.dataBind(this._renderItems, this);
            }

            return this;
        },
		refreshValue: function () {
			/* Forces an update of the igCombo value according to the current text in the igCombo input. 
				The refresh is primarily intended to be used with allowCustomValue=true. 
				The refresh will take the current text and, if no selection is applied, will set it as igCombo value provided that allowCustomValue=true.
			*/
			this._updateInputValues(true);
		},
        dataForValue: function (value) {
            /* Gets the associated data of an item by value matching it's valueKey property
                paramType="number|string" Value matching the valueKey property of item to be tested if it is selected
                returnType="object" The null or object - the associated data of the element
            */
            var data, unwrappedDataItem, unwrappedDataValue, len, i,
                valKey = this.options.valueKey,
                cachedData = this._options.cachedData,
                matchFound = false,
                result = null;

            if (!this.options.dataSource || value === null || value === undefined) {
                return null;
            }

            data = this.options.dataSource.data();

            for (i = 0, len = data.length; i < len && !matchFound; i++) {
                unwrappedDataItem = this._unwrapData(data[i]);
                unwrappedDataValue = this._unwrapData(unwrappedDataItem[valKey]);

                if (this._areValuesEqual(unwrappedDataValue, value)) {
                    result = data[i];
                    matchFound = true;
                }
            }

            // Search in the cached records when filtering is remote and record wasn't found in the data
            if (!matchFound && this.options.filteringType === "remote") {
                for (i = 0, len = cachedData.length; i < len && !matchFound; i++) {
                    unwrappedDataItem = this._unwrapData(cachedData[i]);
                    unwrappedDataValue = this._unwrapData(unwrappedDataItem[valKey]);

                    if (this._areValuesEqual(unwrappedDataValue, value)) {
                        result = cachedData[i];
                        matchFound = true;
                    }
                }
            }

            return result;
        },
        dataForElement: function ($element) {
            /* Gets the associated data of li element in the combo
                paramType="object" optional="false" jQuery element of item in the drop down list
                returnType="object" The null or object - the associated data of the element
            */
            if (!($element instanceof $ && $element.is(this._$items()))) {
                return null;
            }

            return this.dataForValue($element.attr('data-value'));
        },
        itemsFromElement: function ($element) {
            /* Gets object represening li element in the combo by element
                paramType="object" optional="false" jQuery object with drop down list item element or elements
                returnType="object" The null when no such item is found. Object when single element is provided or array with objects when multiple elements are provided containing following members: data - the associated data, element - the jquery element of the li
            */
            var i, result, $curElement;

            if (!($element instanceof $ && $element.is(this._$items()))) {
                return null;
            }

            if ($element.length === 1) {
                result = {
                    element: $element,
                    data: this.dataForElement($element)
                };
            } else {
                result = [];

                for (i = 0; i < $element.length; i++) {
                    $curElement = $element.eq(i);

                    result.push({
                        element: $curElement,
                        data: this.dataForElement($curElement)
                    });
                }
            }

            return result;
        },
        itemsFromValue: function (value) {
            /* Gets object represening li element in the combo by value
                paramType="number|string|array" optional="false" Value of item in the drop down list or array with values.
                returnType="object" The null when no such item is found. Object when single element is provided or array with objects when multiple elements are provided containing following members: data - the associated data, element - the jquery element of the li
            */
            var data, i, len,
                self = this,
                $items = this._$items(),
                result = null;

            if ($.type(value) === 'array') {
                // Filter duplicate values
                value = $.grep(value, function (val, index) {
                    return self._isValueInArray(val, value) === index;
                });

                for (i = 0, len = value.length; i < len; i++) {
                    data = this.dataForValue(value[i]);

                    if (data) {
                        // Keep result null when no data is found
                        if (!result) {
                            result = [];
                        }

                        result.push({
                            element: this._$elementFromValue(value[i], $items),
                            data: data
                        });
                    }
                }
            } else {
                data = this.dataForValue(value);

                if (data) {
                    result = {
                        element: this._$elementFromValue(value, $items),
                        data: data
                    };
                }
            }

            return result;
        },
        itemsFromIndex: function (index) {
            /* Gets object represening li element in the combo by index
                paramType="number" optional="false" Index or array of indexes of items in the drop down list
                returnType="object" The null when no such item is found. Object when single element is provided or array with objects when multiple elements are provided containing following members: data - the associated data, element - the jquery element of the li
            */
            var value, i,
                data = this.options.dataSource.data(),
                dataLen = data.length,
                valKey = this.options.valueKey;

            if ($.type(index) === 'array') {
                value = [];

                for (i = 0; i < index.length; i++) {
                    if (typeof index[i] === 'number' && index[i] >= 0 && index[i] < dataLen) {
                        value.push(data[index[i]][valKey]);
                    }
                }
            } else if (typeof index === 'number' && index >= 0 && index < dataLen) {
                value = this._unwrapData(this._unwrapData(data[index])[valKey]);
            }

            return this.itemsFromValue(value);
        },
        items: function () {
            /* Gets array with objects representing li elements in combo box 
                returnType="object" The null or array with objects containing following members: data - the associated data, element - the jquery element of the li
            */
            return this._itemsFromData(this.options.dataSource.data());
        },
        filteredItems: function () {
            /* Gets array with objects representing the filtered li elements in combo box 
                returnType="object" The null or array with objects containing following members: data - the associated data, element - the jquery element of the li
            */
            return this._itemsFromData(this.options.dataSource.dataView());
        },
        selectedItems: function () {
            /* Gets array with objects representing selected li elements in combo box 
                returnType="object" The null or array with objects containing following members: data - the associated data, element - the jquery element of the li
            */
            return this._options.selectedData.length > 0 ? this._itemsFromData(this._options.selectedData) : null;
        },
        filter: function (texts, event) {
            /* Trigger filtering.
                paramType="string|array" optional="true" Filter by string, or array of strings. 
                paramType="object" optional="true" Reference to browser event. 
                returnType="object" Returns reference to this igCombo.
            */
            var noCancel,
                ds = this.options.dataSource,
                type = this.options.filteringType,
                logic = this.options.filteringLogic,
                filterExprUrlKey = this.options.filterExprUrlKey,
                paging = ds.settings.paging,
                filtering = ds.settings.filtering,
                clearFiltering = texts === "";

            if (!this._isFilteringEnabled()) {
                return this;
            }

            noCancel = event ? this._triggerFiltering(event) : true;
            if (noCancel) {
                filtering.type = type;
                filtering.expressions = this._options.expression = this._generateExpressions(texts);
                filtering.caseSensitive = this.options.caseSensitive;

                // Handle local filtering
                if (type === 'local') {
                    if (clearFiltering) {
                        this._options.expression = null;
                        ds.clearLocalFilter();
                    } else {
                        ds.filter(filtering.expressions, logic, true);
                    }

                    if (this.options.virtualization) {
                        this._handleLocalFilteringWithVirt(ds);
                    } else {
                        this._handleLocalFiltering(ds);
                    }
                }

                // Handle remote filtering
                if (type === 'remote') {
                    if (paging) {
                        paging.pageIndex = 0;
                        paging.appendPage = false;
                    }

                    if (filterExprUrlKey) {
                        filtering.filterExprUrlKey = filterExprUrlKey;
                    }

                    // Cache the evt to use it when firing filtered
                    this._options.remoteFilteringTriggerEvt = event;
                    ds.dataBind(this._handleRemoteFiltering, this);
                }

                if (this._options.dropDownOpened) {
                    this.listScrollTop(0);
                }

                if (event && !this._options.remoteFilteringTriggerEvt) {
                    this._triggerFiltered(event);
                }
            }

            return this;
        },
        clearFiltering: function (event) {
            /* Clear filtering. 
                returnType="object" Returns reference to this igCombo.
            */
            var ds = this.options.dataSource,
                expression = this._options.expression;

            // K.D. March 3rd, 2015 Bug #189365 Filter should be cleared only if its applied.
            // D.A. May 12th, 2015 Bug #193431 Filtering should be skipped when empty ("") filter is applied
            if (!ds || !expression || expression.length <= 0 ||
                (expression.length === 1 && expression[0].expr === "")) {

                // S.T. June 18th 2015, Bug #200569: When filtering is remote closing the dropdown with value having partial item separator do not clear the input.
                // We should update the input here when we having remote filter and not applied filter because the clearFiltering function exit here and 
                // no further update is executed. 
            	if (this._options.updateInputValuesOnRemoteFilter && this._endsPartialyWithItemSep(this._options.inputVal)) {
                    this._updateInputValues();
                    this._hideClearButton();
                }

                // D.A. March 11th 2015, Bug #190152 When filtering is remote selecting an item and typing after it clears the input value
                this._options.updateInputValuesOnRemoteFilter = false;
                return;
            }

            this.filter("", event);
            // Z.K. July 1st 2015, Bug #201932 - When filtering is local and filter with no values after clear filtering the drop down is open in wrong location for a second
            this.positionDropDown();
            return this;
        },
        openDropDown: function (callback, focusCombo, event) {
            /* Opens the drop down
                paramType="function" optional="true" Specifies callback function to be executed when open animation is completed.
                paramType="object" optional="true" Indicates the browser event which triggered this action (not API). Calling the method with this param set to "true" will trigger drop down opened event.
                paramType="bool" optional="true" Set to false to not focus combo's text input after the drop down is opened. By default the combo's input is focused.
                returnType="object" Returns reference to this igCombo.
            */
            var offset, itemHeight, noCancel, newAnimationStyle,
                _options = this._options,
                borderWidth = parseInt(_options.$combo.css('borderTopWidth'), 10),
                topPosition = _options.$combo.offset().top - borderWidth,
                self = this,
                $ddCont = _options.$dropDownCont,
                orientation = this._dropDownOrientation(),
                autoHeight = this._dropDownContHeight();

            if (focusCombo === undefined) {
                focusCombo = true;
            }

            if (!_options.dropDownOpened) {
                noCancel = event ? this._triggerDropDownOpening(event) : true;

                if (noCancel) {
                    _options.dropDownOpened = true;
                    this.positionDropDown();

                    // D.A. 27th April 2015, Bug #192964 Scroll to last selected item when opening the drop down
                    this._scrollToLastSelItem();

                    if (orientation === "top") {
                        $ddCont
                            .addClass(this.css.orientationTop)
                            .removeClass(this.css.orientationBottom)
                                .css({
                                    top: parseInt($ddCont.css("top"), 10) - 1
                                });

                        if (this.options.dropDownAttachedToBody) {
                            newAnimationStyle = {
                                height: autoHeight,
                                top: topPosition - autoHeight
                            };
                        } else {
                            newAnimationStyle = {
                                height: autoHeight,
                                top: -autoHeight - borderWidth
                            };
                        }
                    } else {
                        $ddCont
                            .addClass(this.css.orientationBottom)
                            .removeClass(this.css.orientationTop);

                        newAnimationStyle = {
                            height: autoHeight
                        };
                    }

                    this._startRepositionInterval();

                    $ddCont
                        .stop()
                        .removeClass(this.css.noBorder)
                        .animate(newAnimationStyle, {
                            duration: this.options.animationShowDuration,
                            queue: false,
                            easing: 'swing',
                            complete: function () {
                                // Remove inline styles
                                $ddCont
                                    .height('')
                                    .css('overflow', '');

                                // S.T. April 27th, 2015 Bug #192899: The offet has to be calculated after animation is completed. Otherwise it's zero.
                                // If virtualization is enabled and scroll is moved, we need to go to scrolled items
                                if (self.options.virtualization) {
                                    itemHeight = self._itemHeight();
                                    offset = self._offsetItems(self.options.dataSource.dataView(), itemHeight);
                                    self._updateItems(offset);
                                }

                                if ($.type(callback) === 'function') {
                                    callback();
                                }

                                if (event) {
                                    self._triggerDropDownOpened(event);
                                }
                            }
                        });

                    if (focusCombo) {
                        this._moveCaretToInputEnd(false);
                    }
                }
            }

            return this;
        },
        closeDropDown: function (callback, event) {
            /* Closes the drop down
                paramType="function" optional="true" Specifies callback function to be executed when close animation is completed.
                paramType="object" optional="true" Indicates the browser event which triggered this action (not API). Calling the method with this param set to "true" will trigger drop down closed event.
                returnType="object" Returns reference to this igCombo.
            */
            var noCancel, newAnimationStyle,
                _options = this._options,
                self = this,
                borderWidth = parseInt(_options.$combo.css('borderTopWidth'), 10),
                orientation = this._dropDownOrientation();

            if (_options.dropDownOpened && !_options.dataBinding) {
                noCancel = event ? this._triggerDropDownClosing(event) : true;

                if (noCancel) {
                    this.positionDropDown();

                    if (orientation === "top") {
                        if (this.options.dropDownAttachedToBody) {
                            newAnimationStyle = {
                                height: 0,
                                top: _options.$combo.offset().top - borderWidth,
                                left: _options.$dropDownCont.offset().left
                            };
                        } else {
                            newAnimationStyle = {
                                height: 0,
                                top: 0
                            };
                        }
                    } else {
                        newAnimationStyle = {
                            height: 0
                        };
                    }

                    _options.$dropDownCont
                        .stop()
                        .css('overflow', 'hidden')
                        .animate(newAnimationStyle, {
                            duration: this.options.animationHideDuration,
                            queue: false,
                            easing: 'swing',
                            complete: function () {
                                self._clearRepositionInterval();

                                _options.$dropDownCont
                                    .addClass(self.css.noBorder)
                                    .removeClass(self.css.orientationBottom)
                                    .removeClass(self.css.orientationTop)
                                    .css({
                                        top: -99999,
                                        left: -99999
                                    });

                                if (self.options.filteringType !== 'remote') {
                                    self._updateInputValues();
                                    self._unhighlight();
                                    self.clearFiltering(event);

                                    if (self.options.multiSelection.enabled) {
                                        // Reset key navigation item
                                        self._setKeyNavigationItem({
                                            data: $(),
                                            clearPrevItem: true
                                        });
                                    }
                                    // K.D. August 25, 2015 Bug #205056 When allowCustomValue is true and type not existing text clear button is not visible
                                    if ((!self.options.allowCustomValue && _options.selectedData.length === 0) || (self.options.allowCustomValue && _options.$input.val() === "")) {
                                    	self._hideClearButton();
                                    }

                                    self._removePlaceholderOnEmptyTextVal();

                                    if (_options.validator) {
                                        _options.validator._validateInternal(this.element, event, true);
                                    }
                                } else {
                                    _options.updateInputValuesOnRemoteFilter = true;
                                    self.clearFiltering(event);
                                }

                                if ($.type(callback) === 'function') {
                                    callback();
                                }

                            	// S.T. 4th September 2015, #204981: The flag should be set to false at the end of closing.
                                _options.dropDownOpened = false;

                                if (event) {
                                    self._triggerDropDownClosed(event);
                                }
                            }
                        });
                }
            }

            return this;
        },
        clearInput: function (event) {
            /* Clears the input text, resets highlighting, filtering and selection.
                returnType="object" Returns reference to this igCombo.
            */

            this._options.$input.val('');
			this._options.$hiddenInput.val('');
            this._setInputVal('');
            this.deselectAll({ focusCombo: true }, event);
            this.clearFiltering(event);
            this._unhighlight();

            // Bug #189829 When changing dataSource, if there was selected item clear button stays
            this._hideClearButton();
            this._setKeyNavigationItem({
                data: $(),
                clearPrevItem: true
            });

            return this;
        },
        _hideClearButton: function () {
        	if (!this.options.enableClearButton) {
        		return;
        	}

        	this._options.$clearCont.hide();
        },
        _showClearButton: function (force) {
        	if (!force && !this.options.enableClearButton) {
        		return;
        	}

        	this._options.$clearCont.show();
        },
        isSelected: function ($item) {
            /* Verifies whether the specified li is selected 
                paramType="object" optional="false" jQuery object with item to verify whether it is selected.
                returnType="bool" Returns boolean representing whether the item is selected
            */
            return $item instanceof $ ? this.isValueSelected($item.attr('data-value')) : false;
        },
        isValueSelected: function (value) {
            /* Verifies whether the li with specified value is selected
                paramType="number|string" optional="false" Value matching the valueKey property of item to be tested if it is selected
                returnType="bool" Returns boolean representing whether the item is selected
            */
            return this._isValueInArray(value, this._valuesFromData(this._options.selectedData)) !== -1;
        },
        isIndexSelected: function (index) {
            /* Verifies whether the li representing the data source's record at the specified index is selected
                paramType="object" optional="false" Index of data source record
                returnType="bool" Returns boolean representing whether the item is selected
            */
            return this.isValueSelected(this.options.dataSource.data()[index][this.options.valueKey]);
        },
        // Keeping the function private to ensure always calling it with correct 
        // parameters and faster execution time for large amount of data
        _selectData: function (data, options, event) {
            /* Selects list item/items from the drop down list by specified value or array of values. When called witout params will return the value of the selected item or if multiple selection is enabled array of selected values.
                paramType="number|string|array" optional="true" Value or array of values matching the valueKey property of item/items to be selected
                paramType="object" optional="true" Object with set of options controling the behavior of this api method.
                    closeDropDown (boolean): Set to true to close the drop down list after the selection.
                    focusCombo (boolean): Set to true to focus combo after the selection.
                    additive (boolean): Set to true to select the item without losing other selection. Works only when multi selection is enabled.
                    keepFiltering (boolean): Set to true to keep filtering after the selection. By default the filtering is cleared.
                    keepInputText (boolean): Set to true to keep input text unchanged after the selection. By default input text is updated.
                    keepHighlighting (boolean): Set to true to keep highlighting unchanged after the selection. By default highlighting is removed.
                    keepNavItem (boolean): Set to true to keep current navigation item unchanged after the selection. By default the navigation item is changed to the new selected item.
                    keepScrollPosition (boolean): Set to true to keep current scroll position. By default the scroll position will change so that the last selected item is visible.
                paramType="object" optional="true" Indicates the browser event which triggered this action (not API). Calling the method with this param set to "true" will trigger selection changed event.
                returnType="object" Returns reference to this igCombo.
            */
            var items, itemsLen, selectedValues, newSelItems, selAutoSelectedItem, selChanged, additive, prevSelValues, newSelData, skipEventTrigger, noCancel, i,
                comboOptions = this.options,
                _options = this._options,
                multiSelEnabled = comboOptions.multiSelection.enabled,
                prevSelItems = this.selectedItems();

            // Use first data when multi selection is not enabled
            data = ($.type(data) === 'array' && !multiSelEnabled) ? data[0] : data;
            items = this._itemsFromData(data);

            options = options || {};

            if (items === null) {
                // Z.K. 30/06/2015 Bug #201518 - Selection is not initialized after clear viewmodel's collection when using knockoutjs
                if (!options.additive) {
                    this.deselectAll(options, event);
                }

                return this;
            }

            if ($.type(items) !== 'array') {
                items = [items];
            }

            additive = options.additive && multiSelEnabled;
            itemsLen = items.length;
            selectedValues = this._valuesFromItems(items);

            if (additive) {
                // When selection is additive, selection will change only when any of the new items is not selected
                for (i = 0; i < itemsLen && !selChanged; i++) {
                    if (!this.isValueSelected(items[i].data[comboOptions.valueKey])) {
                        selChanged = true;
                    }
                }
            } else {
                // When selection is not additive, selection will change only when new selection is not the same as the old selection
                prevSelValues = this._valuesFromItems(prevSelItems);

                // This compares the prev and new selected values for equality
                if (!($(selectedValues).not(prevSelValues).length === 0 &&
                    $(prevSelValues).not(selectedValues).length === 0)) {
                    selChanged = true;
                }
            }

            // Reset auto selected item
            if (this._isValueInArray(_options.autoSelectedItemData &&
                _options.autoSelectedItemData[comboOptions.valueKey], selectedValues) !== -1) {
                selAutoSelectedItem = true;

                // When only auto selected item is being selected we shouldn't trigger events,
                // because there is no real selection changing, the item was selected beforehand.
                skipEventTrigger = itemsLen === 1;
            }

            if (selChanged || selAutoSelectedItem) {
                if (additive && prevSelItems) {
                    newSelItems = prevSelItems.concat(this._filterItems(items, prevSelItems));
                    newSelData = this._dataFromItems(newSelItems);
                } else {
                    newSelItems = items;
                    newSelData = this._dataFromItems(newSelItems);
                }

                if (event && !skipEventTrigger) {
                    noCancel = this._triggerSelectionChanging(newSelItems, prevSelItems);
                } else {
                    noCancel = true;
                }

                if (noCancel) {
                    // Update selected data
                    _options.selectedData = newSelData;

                    // Remove styling from previously selected items
                    if (prevSelItems && prevSelItems.length > 0 && !additive) {
                        this._removeItemSelectionStyles(this._$elementsFromItems(this._filterItems(prevSelItems, items)));
                    }

                    // Add styling to the new selected items
                    this._addItemSelectionStyles(this._$elementsFromItems(newSelItems));
                    this._updateInputValues(options.keepInputText, newSelItems);

                    if (!options.keepHighlighting) {
                        this._unhighlight();
                    }

                    this._showClearButton();

                    if (options.focusCombo) {
                        // D.A. May 28th, 2015 Bug #194600 Avoid moving the carret when there is auto completed text, because this would lose the selection
                        if (!(options.autoComplete && this._hasInputSelection())) {
                            // Focus input and to set carret to end of the text input
                            this._moveCaretToInputEnd(true);
                        }
                    }

                    if (!options.keepNavItem) {
                        // Set new key nav to the last selected item or reset it if the last selected is null when virtialization or remote filtering is enabled
                    	this._setKeyNavigationItem({
                    		// S.T. 2th Sept 2015: #202979: The data should be provided instead of element.
                            data: items[itemsLen - 1].data ? items[itemsLen - 1].data : $(),
                            clearPrevItem: true
                        });
                    }

                    // Cache selected items when filtering is remote
                    if (comboOptions.filteringType === 'remote') {
                        this._options.cachedData = this._dataFromItems(newSelItems);
                    }

                    // D.A. 11th March 2015, Bug #190158 Close drop down should be called before clear filtering, because when filtering is remote the drop down does not close
                    if (options.closeDropDown) {
                        // Z.K. 25/08/2015 Bug #205191 - combo dropDownClosing event fired twice
                        // Close drop down. Trigger closing only when event is provided.
                        //noCancel = event ? this._triggerDropDownClosing(event) : true;
                        //if (noCancel) {
                            this.closeDropDown(null, event);
                        //}
                    }

                    if (!options.keepFiltering) {
                        this.clearFiltering(event);
                    }

                    this._removePlaceholderOnEmptyTextVal();

                    // D.A. 14th July, 2015 Bug #202197 The dropdown does not automatically scroll to the selected item.
                    if (!options.keepScrollPosition) {
                        this._scrollToLastSelItem();
                    }

                    // Execute subscribed callbacks
                    this._callInternalSelChangeSubs(event);

                    // When selecting single already auto selected item, no selection change is happening
                    if (event && !skipEventTrigger) {
                        this._triggerSelectionChanged(newSelItems, prevSelItems, event);
                    }
                }
            } else if (options.closeDropDown) {
                // D.A. 12th March 2015, Bug #190262 When selecting already selected item, the drop down is not closed
                noCancel = event ? this._triggerDropDownClosing(event) : true;
                if (noCancel) {
                    this.closeDropDown(null, event);
                }
            }

            return this;
        },
        value: function (value, options, event) {
            /* Selects list item/items from the drop down list by specified value or array of values. When called witout params will return the value of the selected item or if multiple selection is enabled array of selected values.
                paramType="number|string|array" optional="true" Value or array of values matching the valueKey property of item/items to be selected
                paramType="object" optional="true" Object with set of options controling the behavior of this api method.
                    closeDropDown (boolean): Set to true to close the drop down list after the selection.
                    focusCombo (boolean): Set to true to focus combo after the selection.
                    additive (boolean): Set to true to select the item without losing other selection. Works only when multi selection is enabled.
                    keepFiltering (boolean): Set to true to keep filtering after the selection. By default the filtering is cleared.
                    keepInputText (boolean): Set to true to keep input text unchanged after the selection. By default input text is updated.
                    keepHighlighting (boolean): Set to true to keep highlighting unchanged after the selection. By default highlighting is removed.
                    keepNavItem (boolean): Set to true to keep current navigation item unchanged after the selection. By default the navigation item is changed to the new selected item.
                    keepScrollPosition (boolean): Set to true to keep current scroll position. By default the scroll position will change so that the last selected item is visible.
                paramType="object" optional="true" Indicates the browser event which triggered this action (not API). Calling the method with this param set to "true" will trigger selection changed event.
                returnType="object" Returns reference to this igCombo, or array of values if the value parameter is provided.
            */
            var selectedValues, selectedItems, i;

            // Return value of the value input when called without params
            if (value === undefined) {
                selectedValues = [];
                selectedItems = this.selectedItems();

                if (selectedItems) {
                    for (i = 0; i < selectedItems.length; i++) {
                        selectedValues.push(selectedItems[i].data[this.options.valueKey]);
                    }
                } else if (this.options.allowCustomValue && this._options.$hiddenInput.val() !== "") {
					selectedValues.push(this._options.$hiddenInput.val());
				}

                if (!this.options.multiSelection.enabled && selectedItems) {
                    selectedValues = selectedValues.length > 0 ? selectedValues[0] : null;
                }

                return selectedValues;
            }

            this._selectData(this._dataForValues(value), options, event);
			if (this.options.allowCustomValue && !this.selectedItems()) {
				this._options.$input.val(value);
				this._updateInputValues();
				// K.D. September 8th, 2015 Bug #205881 Clear button is not shown after setting custom value through API.
				this._showClearButton();
			}
        },
        select: function ($items, options, event) {
            /* Selects a list item from the drop down list
                paramType="object" optional="false" jQuery object with item or items to be selected
                paramType="object" optional="true" Object with set of options controling the behavior of this api method.
                    closeDropDown (boolean): Set to true to close the drop down list after the selection.
                    focusCombo (boolean): Set to true to focus combo after the selection.
                    additive (boolean): Set to true to select the item without losing other selection. Works only when multi selection is enabled.
                    keepFiltering (boolean): Set to true to keep filtering after the selection. By default the filtering is cleared.
                    keepInputText (boolean): Set to true to keep input text unchanged after the selection. By default input text is updated.
                    keepHighlighting (boolean): Set to true to keep highlighting unchanged after the selection. By default highlighting is removed.
                    keepNavItem (boolean): Set to true to keep current navigation item unchanged after the selection. By default the navigation item is changed to the new selected item.
                    keepScrollPosition (boolean): Set to true to keep current scroll position. By default the scroll position will change so that the last selected item is visible.
                paramType="object" optional="true" Indicates the browser event which triggered this action (not API). Calling the method with this param set to "true" will trigger selection changed event.
                returnType="object" Returns reference to this igCombo.
            */
            if ($items instanceof $) {
                this.value(this._valuesFromElements($items), options, event);
            }

            return this;
        },
        index: function (index, options, event) {
            /* Selects a list item from the drop down list by specified index.
                paramType="number|array" optional="true" Index or array of indexes of items to be selected
                paramType="object" optional="true" Object with set of options controling the behavior of this api method.
                    closeDropDown (boolean): Set to true to close the drop down list after the selection.
                    focusCombo (boolean): Set to true to focus combo after the selection.
                    additive (boolean): Set to true to select the item without losing other selection. Works only when multi selection is enabled.
                    keepFiltering (boolean): Set to true to keep filtering after the selection. By default the filtering is cleared.
                    keepInputText (boolean): Set to true to keep input text unchanged after the selection. By default input text is updated.
                    keepHighlighting (boolean): Set to true to keep highlighting unchanged after the selection. By default highlighting is removed.
                    keepNavItem (boolean): Set to true to keep current navigation item unchanged after the selection. By default the navigation item is changed to the new selected item.
                    keepScrollPosition (boolean): Set to true to keep current scroll position. By default the scroll position will change so that the last selected item is visible.
                paramType="object" optional="true" Indicates the browser event which triggered this action (not API). Calling the method with this param set to "true" will trigger selection changed event.
                returnType="object" Returns reference to this igCombo, or array of indices if the index parameter is provided.
            */
            var selectedItems, indexes, unwrappedDataItem, unwrappedDataValue, i, len,
                dataToSel = [];

            // Return the selected index or array with selected indexes if more than one items are selected
            if (index === undefined) {
                selectedItems = this.selectedItems();

                if (selectedItems.length === 1) {
                    unwrappedDataItem = this._unwrapData(selectedItems[0].data);
                    unwrappedDataValue = this._unwrapData(unwrappedDataItem[this.options.valueKey]);
                    indexes = this._dataIndexByValue(unwrappedDataValue);
                } else {
                    indexes = [];

                    for (i = 0; i < selectedItems.length; i++) {
                        unwrappedDataItem = this._unwrapData(selectedItems[i].data);
                        unwrappedDataValue = this._unwrapData(unwrappedDataItem[this.options.valueKey]);
                        indexes.push(this._dataIndexByValue(unwrappedDataValue));
                    }
                }

                return indexes;
            }

            if ($.type(index) !== 'array') {
                index = [index];
            }

            for (i = 0, len = index.length; i < len; i++) {
                dataToSel.push(this._dataFromIndex(index[i]));
            }

            this._selectData(dataToSel, options, event);

            return this;
        },
        selectAll: function (options, event) {
            /* Selects all items from the drop down list
                paramType="object" optional="true" Object with set of options controling the behavior of this api method.
                    closeDropDown (boolean): Set to true to close the drop down list after the selection.
                    focusCombo (boolean): Set to true to focus combo after the selection.
                    keepFiltering (boolean): Set to true to keep filtering after the selection. By default the filtering is cleared.
                    keepInputText (boolean): Set to true to keep input text unchanged after the selection. By default input text is updated.
                    keepHighlighting (boolean): Set to true to keep highlighting unchanged after the selection. By default highlighting is removed.
                    keepNavItem (boolean): Set to true to keep current navigation item unchanged after the selection. By default the navigation item is changed to the new selected item.
                    keepScrollPosition (boolean): Set to true to keep current scroll position. By default the scroll position will change so that the last selected item is visible.
                paramType="object" optional="true" Indicates the browser event which triggered this action (not API). Calling the method with this param set to "true" will trigger selection changed event.
                returnType="object" Returns reference to this igCombo.
            */
            options = options || {};

            this._selectData(this.options.dataSource.data(), options, event);
            return this;
        },
        _deselectData: function (data, options, event) {
            /* Deselects a list item from the drop down list by value
                paramType="number|string|array" optional="false" Value or array of values matching the valueKey property of item/items to be deselected
                paramType="object" optional="true" Object with set of options controling the behavior of this api method.
                    focusCombo (boolean): Set to true to focus combo after the deselection.
                    keepInputText (boolean): Set to true to keep input text unchanged after the deselection. By default input text is updated.
                paramType="object" optional="true" Indicates the browser event which triggered this action (not API). Calling the method with this param set to "true" will trigger selection changed event.
                returnType="object" Returns reference to this igCombo.
            */
            var newSelItems, selChanged, noCancel, len, i,
                _options = this._options,
                items = this._itemsFromData(data),
                prevSelItems = this.selectedItems();

            options = options || {};

            if (items === null) {
                return this;
            }

            if ($.type(items) !== 'array') {
                items = [items];
            }

            // Selection will change when at least one of the given items was previously selected
            for (i = 0, len = items.length; i < len && !selChanged; i++) {
                if (this.isValueSelected(items[i].data[this.options.valueKey])) {
                    selChanged = true;
                }
            }

            if (selChanged) {
                newSelItems = this._filterItems(prevSelItems, items);
                noCancel = event ? this._triggerSelectionChanging(newSelItems, prevSelItems) : true;

                if (noCancel) {
                    // Update selected data
                    _options.selectedData = this._dataFromItems(newSelItems);

                    // Remove styling from deselected items
                    this._removeItemSelectionStyles(this._$elementsFromItems(items));
                    this._updateInputValues(options.keepInputText, newSelItems);
                    this._unhighlight();

                    if (_options.selectedData.length === 0) {
                        this._setKeyNavigationItem({
                            data: $(),
                            clearPrevItem: true
                        });
                    }

                    if (_options.inputVal === '') {
                    	this._hideClearButton();
                    }

                    if (options.focusCombo) {
                        // Focus combo and set carret to text input's end
                        this._moveCaretToInputEnd(true);
                    }

                    // Cache selected items when filtering is remote
                    if (this.options.filteringType === 'remote') {
                        this._options.cachedData = this._dataFromItems(newSelItems);
                    }

                    this._addPlaceholderWhenEmptyTextVal();

                    // Execute subscribed callbacks
                    this._callInternalSelChangeSubs(event);

                    if (event) {
                        this._triggerSelectionChanged(newSelItems, prevSelItems, event);
                    }
                }
            }

            return this;
        },
        deselectByValue: function (value, options, event) {
            /* Deselects a list item from the drop down list by value
                paramType="number|string|array" optional="false" Value or array of values matching the valueKey property of item/items to be deselected
                paramType="object" optional="true" Object with set of options controling the behavior of this api method.
                    focusCombo (boolean): Set to true to focus combo after the deselection.
                    keepInputText (boolean): Set to true to keep input text unchanged after the deselection. By default input text is updated.
                paramType="object" optional="true" Indicates the browser event which triggered this action (not API). Calling the method with this param set to "true" will trigger selection changed event.
                returnType="object" Returns reference to this igCombo.
            */
            options = options || {};

            // Deselect when there is single selected item and no value provided
            if (value === undefined && this._options.selectedData.length === 1) {
                value = this._options.selectedData[0][this.options.valueKey];
            }

            this._deselectData(this._dataForValues(value), options, event);
        },
        deselect: function ($items, options, event) {
            /* Deselects a list item from the drop down list
                paramType="object" optional="false" jQuery object with item or items to be deselected
                paramType="object" optional="true" Object with set of options controling the behavior of this api method.
                    focusCombo (boolean): Set to true to focus combo after the deselection.
                    keepInputText (boolean): Set to true to keep input text unchanged after the deselection. By default input text is updated.
                paramType="object" optional="true" Indicates the browser event which triggered this action (not API). Calling the method with this param set to "true" will trigger selection changed event.
                returnType="object" Returns reference to this igCombo.
            */
            if ($items === undefined) {
                // When single item is selected deselect it
                this.deselectByValue();
            }

            if ($items instanceof $) {
                $items = $items.filter(this._$items());
                this.deselectByValue(this._valuesFromElements($items), options, event);
            }

            return this;
        },
        deselectByIndex: function (index, options, event) {
            /* Deselects a list item from the drop down list by index
                paramType="number|array" optional="false" Index or array of indexes of items to be selected
                paramType="object" optional="true" Object with set of options controling the behavior of this api method.
                    focusCombo (boolean): Set to true to focus combo after the deselection.
                    keepInputText (boolean): Set to true to keep input text unchanged after the deselection. By default input text is updated.
                paramType="object" optional="true" Indicates the browser event which triggered this action (not API). Calling the method with this param set to "true" will trigger selection changed event.
                returnType="object" Returns reference to this igCombo.
            */
            var i, len,
                dataToDeselect = [];

            if ($.type(index) !== 'array') {
                index = [index];
            }

            for (i = 0, len = index.length; i < len; i++) {
                dataToDeselect.push(this._dataFromIndex(index[i]));
            }

            this._deselectData(dataToDeselect, options, event);
            return this;
        },
        deselectAll: function (options, event) {
            /* Deselects all selected items from the drop down list 
                paramType="object" optional="true" Object with set of options controling the behavior of this api method.
                    focusCombo (boolean): Set to true to focus combo after the deselection.
                    keepInputText (boolean): Set to true to keep input text unchanged after the deselection. By default input text is updated.
                paramType="object" optional="true" Indicates the browser event which triggered this action (not API). Calling the method with this param set to "true" will trigger selection changed event.
                returnType="object" Returns reference to this igCombo.
            */
        	this._deselectData(this._options.selectedData, options, event);

        	// S.T. 24th Sept 2015, Bug #207020: After deselection, should be check whether the mode is non editable and select first item.
        	this._selectFirstItemInNonEditableModes(this.options.mode, [], this.options.dataSource.dataView());

            return this;
        },
        activeIndex: function (index) {
            /* Gets sets index of active item in list.
                paramType="number" optional="true" New active index for list. In order to clear active item, use -1.
                returnType="number|object" Returns index of active item in list or -1, if parameter is undefined. Otherwise, it returns reference to this igCombo.
            */
            if (index === undefined) {
                return this._$items().index(this._$keyNavItem());
            }

            this._setKeyNavigationItem({
                data: this._dataFromIndex(index),
                addStyles: true,
                clearPrevItem: true
            });

            return this;
        },
        text: function (text) {
            /* Gets sets text in text input field.
                paramType="string" optional="true" New text value for combo's input field.
                returnType="string|object" If parameter is undefined, then current text in field is returned. Otherwise, it returns reference to this igCombo.
            */
            if (text === undefined) {
                return this._options.$input.val();
            }

            this._options.$input.val(text);
            this._handleInputChange(false);

            return this;
        },
        listScrollTop: function (value) {
            /* Gets sets scrollTop attribute of html element, which scrolls drop-down list of items.
                paramType="number" optional="true" New value for scroll top in list. Note: if list is closed and new value is provided, then openDropDown() is called automatically.
                returnType="number|object" If parameter is undefined, then scrollTop is returned. Otherwise, it returns reference to this igCombo.
            */
            var $listCont,
                _options = this._options;

            if (value !== undefined && !_options.dropDownOpened) {
                this.openDropDown();
            }

            $listCont = _options.$dropDownScrollCont || _options.$dropDownListCont;

            if (value === undefined) {
                return $listCont ? $listCont.prop('scrollTop') : 0;
            }

            if ($listCont) {
                $listCont.prop('scrollTop', value || 0);
            }

            return this;
        },
        listItems: function () {
            /* Gets jQuery objects representing all rendered list items in the combo drop down list
                returnType="object" Returns reference to jQuery objects representing all rendered list items in the combo drop down list
            */
            return this._$items();
        },
        comboWrapper: function () {
            /* Gets jQuery object of the outer element of the combo
                returnType="object" Returns reference to the jQuery outer element object
            */
            return this._options.$comboWrapper;
        },
        dropDown: function () {
            /* Gets jQuery object of the drop down associated with this combo widget
                returnType="object" Returns reference to the jQuery drop down object
            */
            return this._options.$dropDownCont;
        },
        list: function () {
            /* Gets jQuery object of the container that holds the list with items
                returnType="object" Returns reference to the jQuery list container object
            */
            return this._options.$dropDownListCont;
        },
        textInput: function () {
            /* Gets jQuery object of the text input associated with this combo widget
                returnType="object" Returns reference to the jQuery input object
            */
            return this._options.$input;
        },
        valueInput: function () {
            /* Gets jQuery object of the value input associated with this combo widget
                returnType="object" Returns reference to the jQuery input object
            */
            return this._options.$hiddenInput;
        },
        validator: function (destroy) {
            /* Gets reference to igValidator used by igCombo.
                paramType="bool" optional="true" Request to destroy validator.
                returnType="object" Returns reference to igValidator or null.
            */
            var validatorOptions = this.options.validatorOptions,
                validator = this._options.validator;

            if (validator && (destroy || !validatorOptions) && validator.owner === this) {
                validator.destroy();
                this._options.validator = validator = null;
            } else if (!validator && !destroy && validatorOptions && this.element.igValidator) {
                this._options.validator = validator = this.element.igValidator(validatorOptions).data('igValidator');
                this._options.validator.owner = this;
                // A.M. May 12th, 2015 Bug #193960 "The validatorOptions are not reflected when set at runtime"
            } else if (validator && !destroy && validatorOptions && this.element.igValidator) {
                this._options.validator = validator = this.element.igValidator(validatorOptions).data('igValidator');
            }

            return validator;
        },
        validate: function () {
            /* Trigger validation.
                returnType="bool" True if all checks have passed. Can be null in case validation is not enabled.
            */
            return this._options.validator ? this._options.validator.validate() : null;
        },
        dropDownOpened: function () {
            /* Returns boolean representing whether the combo drop down list is opened.
                returnType="bool" Returns boolean representing whether the combo drop down list is opened.
            */
            return this._options.dropDownOpened;
        },
        positionDropDown: function () {
            /* Repositions drop down under combo input. Has effect only when the drop down is attach to body. */
            var comboOffset, width,
                _options = this._options,
                $combo = _options.$combo,
                orientation = this.options.dropDownOrientation;

            if (orientation === "auto") {
                orientation = this._dropDownOrientation();
            }

            if (this.options.dropDownAttachedToBody) {
                comboOffset = $combo.offset();
                width = this.options.dropDownWidth || $combo.outerWidth();

                _options.$dropDownCont.outerWidth(width);

                if (orientation === "top") {
                    _options.$dropDownCont
                        .css({
                            left: comboOffset.left,
                            top: $combo.offset().top - _options.$dropDownCont.outerHeight()
                        });
                } else {
                    _options.$dropDownCont
                        .css({
                            left: comboOffset.left,
                            top: comboOffset.top + $combo.outerHeight()
                        });
                }
            } else {
                if (orientation === "top") {
                    _options.$dropDownCont
                        .css({
                            left: "",
                            top: -(_options.$dropDownCont.outerHeight())
                        });
                } else {
                    _options.$dropDownCont
                        .css({
                            left: "",
                            top: ""
                        });
                }
            }
        },
        _unsetupInput: function () {
            // Called only when the source element is an input
            var _handlers = this._handlers;

            this.element.insertAfter(this._options.$comboWrapper);
            this._options.$comboWrapper.remove();

            this.element
                .removeClass(this.css.field)
                .val("")
                .removeAttr("placeholder")
                .removeAttr("tabIndex")
                .attr("name", this._options.nameAttribute);

            if (this.options.mode !== 'editable') {
                // Disable editing and selection for non-editable modes
                this.element
                    .removeAttr("readonly")
                    .removeAttr("unselectable")
                    .removeClass(this.css.unselectable);
            }

            this.element.off({
                focus: _handlers.inputFocus,
                blur: _handlers.inputBlur,
                click: _handlers.inputClick,
                keydown: _handlers.inputKeyDown,
                paste: _handlers.inputPaste,
                keyup: _handlers.inputKeyUp,
                keypress: _handlers.inputKeyPress,
                mousedown: _handlers.inputMouseDown
            });
        },
        destroy: function () {
            /* Destroys the igCombo widget.
                returnType="object" Returns reference to this igCombo.
            */
            var _options = this._options,
                _handlers = this._handlers;

            this.validator(true);

            _options.$window.off("resize", _handlers.windowResize);
            $(document).off("mouseup", _handlers.documentMouseUp);
            this._clearRepositionInterval();
            _options.$dropDownCont.remove();

            if (this.element.is("input")) {
                this._unsetupInput();
            } else if (this.element.is("select")) {
                _options.$comboWrapper.remove();

                this.element
                    .show()
                    .attr("name", _options.nameAttribute);
            } else {
                this.element
                    .empty()
                    .removeClass(this.css.comboWrapper);
            }

            _options = null;
            $.Widget.prototype.destroy.apply(this, arguments);
            return this;
        }
    });

    $.extend($.ui.igCombo, { version: '15.2.20152.1033' });
}(jQuery));
/*!@license
* Infragistics.Web.ClientUI Dialog 15.2.20152.1033
*
* Copyright (c) 2011-2015 Infragistics Inc.
*
* http://www.infragistics.com/
*
* Depends on:
* jquery-1.6.1.js
* jqueryui/1.8.11/jquery-ui.js
* jquery.ui.core.js
* jquery.ui.widget.js
* jquery.ui.mouse.js
* jquery.ui.draggable.js
* jquery.ui.resizable.js
* Example to use:
*	<script type="text/javascript">
*	$(function () {
*		$("#dialog1").igDialog();
*	});
*	</script>
*	<div id="dialog1"></div>
*/

/*global jQuery, setTimeout, document, window*/
(function ($) {
	var _lastTop, _iframe,
		_visCount = 0,
		_modals = [],
		_lastZ = 0,
		_maxZ = 0,
		CLOSE = 0,
		OPEN = 1,
		MIN = 2,
		MAX = 3,
		PIN = 4,
		UNPIN = 5,
		RESTORE = 6,
		_pos = {
			// default position of dialog
			my: "center",
			at: "center",
			collision: "fit",
			of: window,
			using: function (pos) {
				if (pos.top < 0) {
					pos.top = 0;
				}
				if (pos.left < 0) {
					pos.left = 0;
				}
				var p = $(this).css(pos).offset();
				if (p.top < 0) {
					$(this).css("top", pos.top - p.top);
				}
				if (p.left < 0) {
					$(this).css("left", pos.left - p.left);
				}
			}
		},
		_isSrc = function (elem, src) {
			return elem && src && (elem.has(src).length > 0 || elem[0] === src);
		},
		_notab = function (elem) {
			return elem.attr("zIndex", -1).css("outline", 0).attr("unselectable", "on");
		},
		_toPx = function (elem, css) {
			// returns px value of style attribute
			var val = elem.css(css);
			if (!val) {
				return 0;
			}
			css = parseFloat(val);
			if (val.indexOf("px") > 0) {
				css += 0.7;
			} else if (val.indexOf("em") > 0) {
				css *= 12;
			} else {
				return 0;
			}
			return Math.floor(css);
		},
		_getPadding = function (elem, vert, margin) {
			// returns px value of vertical/horizontal padding and border style attributes
			return _toPx(elem, (margin || "padding") + (vert ? "Top" : "Left")) +
				_toPx(elem, (margin || "padding") + (vert ? "Bottom" : "Right")) +
				_toPx(elem, "border" + (vert ? "Top" : "Left") + "Width") +
				_toPx(elem, "border" + (vert ? "Bottom" : "Right") + "Width");
		},
		_stopEvt = function (e) {
			try {
				e.preventDefault();
				e.stopPropagation();
			} catch (ex) { }
		};
	/*
		igDialog is a widget based on jQuery UI that provides ability to show target element as the content of a dialog.
		Dialog provides common functionality such as ability to hide, show, minimize, maximize, pin and their combinations using
		buttons located in the header of dialog. It also supports modal state and may track focus.
		When igDialog is created, then target element is removed from its original parent and inserted into dynamically created html elements.
		The parent element of dialog can be form element (if target element is a child of that form) or body.
		When igDialog is destroyed, then original target html element is moved back into its original parent including position within original siblings.
		Note: if application uses tabIndex attributes for child elements of dialog-content, then it is not recommended to have mixed values of tabIndexes for
		elements located inside and outside of dialog.
	*/
	$.widget("ui.igDialog", {
		options: {
			/* type="dom" Sets gets jquery DIV object which is used as main container for dialog.
				Notes:
				1. That object is optional and it should not contain any children.
				2. It should not have parent.
				3. It should not contain attributes which might destroy laout or appearance of dialog.
				4. Change of that option is not supported.
			*/
			mainElement: null,
			/* type="opened|closed|minimized|maximized" Sets gets state of dialog.
				Note: when dialog is modal, then pinned and minimized states are not supported, because that will trigger misbehavior.
				opened type="string" Dialog is opened.
				minimized type="string" Dialog is minimized.
				maximized type="string" Dialog is maximized.
				closed type="string" Dialog is closed.
			*/
			state: "opened",
			/* type="bool" Sets gets pinned state of dialog.
				When dialog is pinned, then the html element of dialog is moved to the original container where target element was located and position:absolute is removed.
				Pinned dialog does not support modal state, maximized state and it can not be moved.
				Notes:
				1. If parent element of original target-element is invisible, then pinned dialog becomes invisible as well.
				2. Pinned state is not supported for modal dialog.
			*/
			pinned: false,
			/* type="bool" Sets gets ability to close dialog on Esc key. */
			closeOnEscape: true,
			/* type="bool" Sets gets visibility of close button in header. */
			showCloseButton: true,
			/* type="bool" Sets gets visibility of maximize button in header. */
			showMaximizeButton: false,
			/* type="bool" Sets gets visibility of minimize button in header. */
			showMinimizeButton: false,
			/* type="bool" Sets gets visibility of pin button in header. */
			showPinButton: false,
			/* type="bool" Sets gets ability to automatically pin dialog when dialog was minimized. */
			pinOnMinimized: false,
			/* type="string" Sets gets name of css class which is applied to the SPAN element located on the left side of header. */
			imageClass: null,
			/* type="string" Sets gets text which appears in header of dialog. */
			headerText: null,
			/* type="bool" Sets gets visibility of header. */
			showHeader: true,
			/* type="bool" Sets gets visibility of footer. */
			showFooter: false,
			/* type="string" Sets gets text which appears in footer of dialog. */
			footerText: null,
			/* type="string" Sets gets name of css class which is applied to the main DIV element of dialog. */
			dialogClass: null,
			/* type="object" Sets gets container html element for dialog.
				That can be reference to html element, jquery selector or jquery object.
				By default the parent form of original target element is used. If form is not found, then body is used.
				Note: If the "position" of container is not set or it is "static", then position is set to "relative".
			*/
			container: null,
			/* type="number" Sets gets initial height of dialog in pixels for normal state.
				Besides numeric values, following units are supported: "px", "em" and "%".
				In case of "%", the size of browser window is used and it has effect only on open action. */
			height: null,
			/* type="number" Sets gets initial width of dialog in pixels for normal state.
				Besides numeric values, following units are supported: "px", "em" and "%".
				In case of "%", the size of browser window is used and it has effect only on open action. */
			width: 300,
			/* type="number" Sets gets minimal height of dialog in normal state. */
			minHeight: 100,
			/* type="number" Sets gets minimal width of dialog in normal state. */
			minWidth: 150,
			/* type="number" Sets gets maximal height of dialog in normal state. Note: that option has effect only while resizing dialog by end user. */
			maxHeight: null,
			/* type="number" Sets gets maximal width of dialog in normal state. Note: that option has effect only while resizing dialog by end user. */
			maxWidth: null,
			/* type="bool" Sets gets ability to drag dialog by end user. */
			draggable: true,
			/* type="object" Sets gets initial position of dialog. That should be object, which contains "top" and "left" members or object
				supported by jquery.position(param) method. Examples: { left: 100, top: 200 }, { my: "left top", at: "left top", offset: "100 200" } */
			position: null,
			/* type="bool" Sets gets ability to resize dialog by end user. */
			resizable: true,
			/* type="number" Sets gets value for tabIndex attribute applied to main html element of dialog. */
			tabIndex: 0,
			/* type="object" Sets gets animation applied to dialog when it is opened. That can be any object supported by jquery show(param) method. */
			openAnimation: null,
			/* type="object" Sets gets animation applied to dialog when it is closed. That can be any object supported by jquery hide(param) method. */
			closeAnimation: null,
			/* type="number" Sets gets value of zIndex applied to the main html element of dialog. If value is not set, then 1000 is used. */
			zIndex: null,
			/* type="bool" Sets gets modal state of dialog.
				If there are more than 1 modal igDialog, then last opened dialog wins and becomes on the top.
				Note: modal functionality is not supported when dialog is minimized or pinned, because that will trigger misbehavior.
			*/
			modal: false,
			/* type="bool" Sets gets ability to process focus and blur events of child elements located in dialog in order to maintain focused state.
				Notes:
				If that option is enabled, then focus and blur event handlers are added to all child elements of dialog.
				If dialog is modal or it can be maximized, then it is not recommended to disable that option.
				If that option is modified after igDialog was already created, then depending on current state of dialog, it will be temporary closed-opened or opened-closed.
			*/
			trackFocus: true,
			/* type="string" Sets gets title/tooltip for close button in dialog. That is override for $.ig.Dialog.locale.closeButtonTitle. */
			closeButtonTitle: null,
			/* type="string" Sets gets title/tooltip for minimize button in dialog. That is override for $.ig.Dialog.locale.minimizeButtonTitle. */
			minimizeButtonTitle: null,
			/* type="string" Sets gets title/tooltip for maximize button in dialog. That is override for $.ig.Dialog.locale.maximizeButtonTitle. */
			maximizeButtonTitle: null,
			/* type="string" Sets gets title/tooltip for pin button in dialog. That is override for $.ig.Dialog.locale.pinButtonTitle. */
			pinButtonTitle: null,
			/* type="string" Sets gets title/tooltip for unpin button in dialog. That is override for $.ig.Dialog.locale.unpinButtonTitle. */
			unpinButtonTitle: null,
			/* type="string" Sets gets title/tooltip for restore button in dialog. That is override for $.ig.Dialog.locale.restoreButtonTitle. */
			restoreButtonTitle: null,
			/* type="string" Sets gets temporary value for src, which is used while changing parent of base element if it is instance of IFRAME. That is allows to get around possible javascript exceptions under IE. */
			temporaryUrl: null,
			/* type="bool" Sets gets ability to adjust state of header depending on focused and not-focused states. Note: the "trackFocus" option should be enabled. */
			enableHeaderFocus: true,
			/* type="auto|true|false" Sets gets processing dblclick on dialog-header.
				If option is not false and dialog was minimized, then its state will be set to normal.
				If option is set to "auto" and showMaximizeButton is enabled or if option is set to true, then dialog will be maximized when it was in normal state,
				and dialog-state will be set to normal if it was maximized. */
			enableDblclick: "auto"
		},
		events: {
			/* cancel="true" Event which is raised before state of dialog was changed.
				Return false in order to cancel action.
				Function takes arguments "evt" and "ui".
				Use evt to obtain browser event. That parameter can be null if state was modified from codes.
				Use ui.owner to obtain reference to igDialog.
				Use ui.button to obtain name of button, which triggered event. Note: if state was modified from codes, then "button" is undefined.
				Use ui.oldState to obtain old state of dialog, which can be one of following: "opened", "minimized", "maximized", "closed".
				Use ui.oldPinned to obtain boolean value of old pin state of dialog.
				Use ui.action to obtain name of action. That can be one of the following:
				"open" - request to open dialog
				"close" - request to close dialog
				"minimize" - request to minimize dialog
				"maximize" - request to maximize dialog
				"restore" - request to restore dialog from minimized or maximized state
				"pin" - request to pin dialog
				"unpin" - request to unpin dialog
			*/
			stateChanging: null,
			/* cancel="false" Event which is raised after state of dialog was changed.
				Function takes arguments "evt" and "ui".
				Use evt to obtain browser event. That parameter can be null if state was modified from codes.
				Use ui.owner to obtain reference to igDialog.
				Use ui.button to obtain name of button, which triggered event. Note: if state was modified from codes, then "button" is undefined.
				Use ui.oldState to obtain old state of dialog, which can be one of following: "opened", "minimized", "maximized", "closed".
				Use ui.oldPinned to obtain boolean value of old pin state of dialog.
				Use ui.action to obtain name of action. That can be one of the following:
				"open" - dialog was opened. Note: event is raised before possible "openAnimation" started.
				"close" - dialog was closed. Note: event is raised before possible "closeAnimation" started.
				"minimize" - dialog was minimized
				"maximize" - dialog was maximized
				"restore" - dialog was restored from minimized or maximized state
				"pin" - dialog was pinned
				"unpin" - dialog was unpinned
			*/
			stateChanged: null,
			/* cancel="false" Event which is raised after end animation when dialod was closed or opened.
				Function takes arguments "evt" and "ui".
				Use ui.owner to obtain reference to igDialog.
				Use ui.action to obtain name of action, which triggered animation.
				"open" - dialog was opened
				"close" - dialog was closed
			*/
			animationEnded: null,
			/* cancel="false" Event which is raised when dialog or its content gets focus.
				Function takes arguments "evt" and "ui".
				Use evt to obtain browser event.
				Use ui.owner to obtain reference to igDialog.
			*/
			focus: null,
			/* cancel="false" Event which is raised when dialog or its content loses focus.
				Function takes arguments "evt" and "ui".
				Use evt to obtain browser event.
				Use ui.owner to obtain reference to igDialog.
			*/
			blur: null
		},
		css: {
			/* Classes applied to the main/top element. */
			dialog: "ui-igdialog ui-dialog ui-widget ui-widget-content ui-corner-all",
			/* Classes applied to the header. */
			header: "ui-igdialog-header ui-dialog-titlebar ui-widget-header ui-corner-top ui-helper-clearfix",
			/* Classes applied to the header in focused state. */
			headerFocus: "ui-igdialog-header-focus ui-state-focus",
			/* Classes applied to the header in minimized state. */
			headerMinimized: "ui-corner-bottom",
			/* Classes applied to the header text. */
			headerText: "ui-igdialog-headertext ui-dialog-title",
			/* Extra class applied to SPAN which represents image in header, when "image" option is set. */
			headerImage: "ui-igdialog-headerimage",
			/* Classes applied to the header text when dialog is in minimized state. */
			headerTextMinimized: "ui-igdialog-headertext-minimized",
			/* Classes applied to the buttons located in header. */
			headerButton: "ui-igdialog-headerbutton ui-corner-all ui-state-default",
			/* Classes applied to the buttons located in header when mouse is moved over them. */
			headerButtonHover: "ui-igdialog-headerbutton-hover ui-state-hover",
			/* Classes applied to the close button located in header. */
			close: "ui-igdialog-buttonclose",
			/* Classes applied to the minimize button located in header. */
			minimize: "ui-igdialog-buttonminimize",
			/* Classes applied to the maximize button located in header. */
			maximize: "ui-igdialog-buttonmaximize",
			/* Classes applied to the pin button located in header. */
			pin: "ui-igdialog-buttonpin",
			/* Classes applied to the icon of close button. */
			closeIcon: "ui-igdialog-close-icon ui-icon ui-icon-close",
			/* Classes applied to the icon of minimize button. */
			minimizeIcon: "ui-igdialog-minimize-icon ui-icon ui-icon-minus",
			/* Classes applied to the icon of maximize button. */
			maximizeIcon: "ui-igdialog-maximize-icon ui-icon ui-icon-extlink",
			/* Classes applied to the icon of restore button. */
			restoreIcon: "ui-igdialog-restore-icon ui-icon ui-icon-copy",
			/* Classes applied to the icon of pin button. */
			pinIcon: "ui-igdialog-pin-icon ui-icon ui-icon-pin-s",
			/* Classes applied to the icon of unpin button. */
			unpinIcon: "ui-igdialog-unpin-icon ui-icon ui-icon-pin-w",
			/* Classes applied to the footer. */
			footer: "ui-igdialog-footer ui-widget-header ui-corner-bottom ui-helper-clearfix",
			/* Classes applied to dialog while resizing. */
			resizing: "ui-igdialog-resizing",
			/* Classes applied to dialog while dragging. */
			dragging: "ui-igdialog-dragging",
			/* Classes applied to header when dialog is in unmovable state such as maximized of pinned. */
			unmovable: "ui-igdialog-unmovable",
			/* Classes applied to the shell element when dialog is in modal state. */
			overlay: "ui-igdialog-overlay ui-widget-overlay",
			/* Classes applied to the content area of dialog when target element is IFRAME. */
			contentIframe: "ui-igdialog-content-iframe",
			/* Classes applied to the content area of dialog. */
			content: "ui-igdialog-content ui-widget-content ui-dialog-content"
		},
		_create: function () {
			var elem,
				self = this,
				elem0 = self.element,
				el = elem0[0],
				url = (el && el.nodeName === "IFRAME") ? el.src : null,
				o = self.options,
				state = o.state,
				parent,
				css = self.css;
			// K.D. December 20th, 2013 Bug #159961 We're no longer attaching the dialog to the body by default
			o.container = o.container || this.element.parent();
			parent = o.container;
			self._fixIE(elem0);
			self._old = {
				position: elem0.css("position"),
				left: elem0.css("left"),
				top: elem0.css("top"),
				display: elem0.css("display"),
				visibility: elem0.css("visibility"),
				width: el.style.width,
				height: el.style.height
			};
			if (url) {
				el.src = o.temporaryUrl || "";
			}
			self._min = state === "minimized" || state === MIN;
			self._max = state === "maximized" || state === MAX;
			self._opened = state && state !== "closed";
			self._oldDad = el.parentNode;
			// Note: elem0.next() fails to return #text object
			self._next = self._oldDad ? el.nextSibling : null;
			self._dad = parent;
			// K.D. January 14th, 2014 The dialog does not preserve attributes or properties for the top-most element
			elem0 = $('<div />');
			this.element.contents().appendTo(elem0);
			el = elem = this.element;
			elem.css({ zIndex: o.zIndex || 1000, outline: 0 }).attr("tabIndex", o.tabIndex)
				.keydown(function (e) {
					if (o.closeOnEscape && e.keyCode === $.ui.keyCode.ESCAPE) {
						self.close(e);
						e.preventDefault();
					}
					if (e.keyCode !== $.ui.keyCode.TAB) {
						return;
					}
					self._tabTime = new Date().getTime();
					if (!self._modal && !self._max) {
						return;
					}
					var min, max, ti, next,
						iNext = -1,
						big = 999999,
						iMin = big,
						iMax = -1,
						targ = e.target,
						ti0 = self._getTabIndex(targ),
						shift = e.shiftKey,
						tabs = $(":tabbable", elem[0]),
						len = tabs.length,
						i = len;
					// find first/min and last/max tabbable child elements
					while (i-- > 0) {
						ti = self._getTabIndex(el = tabs[i]);
						if (ti > iMax) {
							iMax = ti;
							max = el;
						}
						if (ti <= iMin) {
							iMin = ti;
							min = el;
						}
						// find next tabbable elem with same tabIndex as targ
						if (ti === ti0) {
							if (!next) {
								next = el === targ;
								if (!next) {
									iNext = i;
								}
							} else if (iNext < 0) {
								iNext = i;
							}
						}
					}
					// find next tabbable elem with closest tabIndex to targ
					if (iNext < 0) {
						i = len;
					}
					iMin = shift ? -1 : big;
					while (i-- > 0) {
						ti = self._getTabIndex(tabs[i]);
						if ((ti > ti0 && ti < iMin && !shift) || (ti < ti0 && ti > iMin && shift)) {
							iMin = ti;
							iNext = i;
						}
					}
					max = max || elem[0];
					min = min || max;
					// it used if page has mixed tabIndexes of elements on dialog and outside of it
					self._nextTabElem = (iNext >= 0) ? tabs[iNext] : (shift ? max : min);
					if (targ === elem[0] || (targ === min && shift) || (targ === max && !shift)) {
						_stopEvt(e);
						el = shift ? max : min;
						try { el.focus(); } catch (ex) { }
					}
				})
				.mousedown(function (e) { self.moveToTop(e); });
			el.addClass(css.dialog);
			if (o.dialogClass) {
				el.addClass(o.dialogClass);
			}
			elem0.show().addClass(css.content).appendTo(el);
			if (url !== null) {
				elem0[0].src = url;
				elem0.addClass(css.contentIframe);
			}
			self._modal = self._hasFocus = false;
			self._lastFoc = "blur";
			self._doHeader();
			self._doFooter();
			self._doDraggable();
			self._doResizable();
			if (self._min) {
				self._onMin(true, true, true);
			}
			if (self._max) {
				o.pinned = false;
				self._onMax(true, true, true);
			}
			if (o.pinned) {
				self._onPin(true, true, true);
			}
			if (self._opened) {
				self._open();
			} else {
				elem.hide();
			}
			self._created = true;
			self._save();
		},
		// get around combination of jQuery with IE7 and other versions of IE
		// IE may generate 2 nodes for <input></input>
		// node with tag </input> kills focus functionality
		// since jQuery raises exception for selectors like "/INPUT", there is no choice but remove elements manually
		_fixIE: function (elem) {
			elem = elem.find("*");
			var n, e, i = elem.length;
			while (i-- > 0) {
				e = elem[i];
				n = e.nodeName;
				if (n === "/INPUT" || n === "/IMG") {
					e.parentNode.removeChild(e);
				}
			}
		},
		destroy: function () {
			/* Destroys igDialog and moves target element to its original parent.
				returnType="object" Returns reference to this igDialog.
			*/
			// K.D. January 14th, 2014 The dialog does not preserve attributes or properties for the top-most element
			// Changing the destructor to accommodate for this.element being the top-most element
			var self = this,
				elem0 = this.element.children('.ui-igdialog-content');
			this._doClose(null, true);
			if (self._winResize) {
				$(window).unbind("resize", self._winResize);
			}
			this.element.children('.ui-igdialog-header').remove();
			this.element.children('.ui-igdialog-footer').remove();
			//elem0.parentNode.removeChild(elem0);
			elem0.contents().unwrap();
			//elem.remove();
			this.element.removeClass(self.css.dialog).css(self._old);
			if (this.options.draggable) {
				this.element.draggable('destroy');
			}
			if (this.options.resizable) {
				this.element.resizable('destroy');
			}
			this.element.unbind();
			// if (next && next.parentNode === dad) {
				// dad.insertBefore(elem0, next);
			// } else {
				// dad.appendChild(elem0);
			// }
			$.Widget.prototype.destroy.apply(this, arguments);
			return this;
		},
		state: function (state) {
			/* Gets sets state of editor.
				Note: If state of dialog changes, then stateChanging and stateChanged events are raised.
				paramType="string" optional="true" New state.
				returnType="string" Returns state.
			*/
			if (!arguments.length) {
				return this.options.state;
			}
			if ((state === "minimized" || state === MIN) && (!this._min || !this._opened)) {
				if (!this._min) {
					this._minimize();
				} else {
					this._open(null, 1);
				}
			}
			if ((state === "maximized" || state === MAX) && (!this._max || !this._opened)) {
				if (!this._max) {
					this._maximize();
				} else {
					this._open(null, 1);
				}
			}
			if ((state === "opened" || state === OPEN) && (this._min || this._max || !this._opened)) {
				this._onMin();
				this._onMax();
				this._open();
				this.options.state = state;
			}
			if ((state === "closed" || !state) && (this._min || this._max || this._opened)) {
				this._onMin();
				this._onMax();
				this.close();
			}
			return this;
		},
		mainElement: function () {
			/* Gets reference to dynamically created DIV element which represents dialog.
				returnType="dom" Returns reference jQuery object.
			*/
			return this.element;
		},
		close: function (e) {
			/* Closes dialog if it is opened.
				Notes:
				1. If state of dialog changes, then stateChanging and stateChanged events are raised.
				2. That method does not change minimized or maximized state of dialog.
				It means that method "open" will open dialog and keep previous minimized or maximized state.
				paramType="object" optional="true" Browser event: internal use only.
				returnType="object" Returns reference to this igDialog.
			*/
			if (this._opened) {
				this._doClose(e);
			}
			return this;
		},
		open: function () {
			/* Opens dialog if it is closed. Notes:
				1. If state of dialog changes, then stateChanging and stateChanged events are raised.
				2. That method does not change minimized or maximized state of dialog. It means that if dialog was closed by "close" method, then dialog and keep previous minimized or maximized state.
				returnType="object" Returns reference to this igDialog.
			*/
			return this._open(null, 1);
		},
		minimize: function () {
			/* Minimizes dialog if it is not minimized.
				Note: If state of dialog changes, then stateChanging and stateChanged events are raised.
				returnType="object" Returns reference to this igDialog.
			*/
			if (!this._min) {
				this._minimize();
			}
			return this;
		},
		maximize: function () {
			/* Maximizes dialog if it is not maximized.
				Note: If state of dialog changes, then stateChanging and stateChanged events are raised.
				returnType="object" Returns reference to this igDialog.
			*/
			if (!this._max) {
				this._maximize();
			}
			return this;
		},
		restore: function () {
			/* Sets normal state for dialog which was maximized or minimized.
				Note: If state of dialog changes, then stateChanging and stateChanged events are raised.
				returnType="object" Returns reference to this igDialog.
			*/
			if (this._max) {
				this._onMax();
			}
			if (this._min) {
				this._onMin();
			}
			return this;
		},
		pin: function () {
			/* Pins dialog if it is not pinned.
				When dialog is pinned, then the html element of dialog is moved to the original container where target element was located and position:absolute is removed.
				Pinned dialog does not support modal state, maximized state and it can not be moved.
				Notes:
				1. If parent element of original target-element is invisible, then pinned dialog becomes invisible as well.
				2. If state of dialog changes, then stateChanging and stateChanged events are raised.
				returnType="object" Returns reference to this igDialog.
			*/
			if (!this.options.pinned) {
				this._pin();
			}
			return this;
		},
		unpin: function () {
			/* Unpins dialog if it is pinned.
				Note: If state of dialog changes, then stateChanging and stateChanged events are raised.
				returnType="object" Returns reference to this igDialog.
			*/
			if (this.options.pinned) {
				this._pin();
			}
			return this;
		},
		getTopModal: function () {
			/* Gets reference to the top modal dialog.
				returnType="object" reference to igDialog or null.
			*/
			return _modals[_modals.length - 1];
		},
		isTopModal: function () {
			/* Checks if dialog is modal and it is currently active.
				returnType="bool" true: dialog is on top.
			*/
			return this.getTopModal() === this;
		},
		moveToTop: function (e) {
			/* Moves not modal dialog to the top.
				paramType="object" optional="true" Original event of browser.
				returnType="object" Returns reference to this igDialog.
			*/
			var src, name,
				self = this,
				o = self.options,
				zi = o.zIndex,
				elem = self.element,
				zi0 = self._created ? null : zi,
				modal = o.modal,
				elem0 = this.element[0],
				scrollTop = elem0.scrollTop,
				scrollLeft = elem0.scrollLeft;
			if ($.ig && $.ig.util && $.ig.util.evtButton(e)) {
				return;
			}
			zi = zi || 1000;
			// cancel mousedown for header and footer
			src = e ? e.target : null;
			if (_isSrc(self._header, src) || _isSrc(self._footer, src)) {
				name = src.nodeName;
				if (name !== "INPUT" && name !== "BUTTON") {
					_stopEvt(e);
					// ensure focus
					self._setFocus();
				}
			} else if (e && !this._hasFocus) {
				// ensure focus
				self._setFocus();
			}
			_maxZ = Math.max(zi0 || zi, _maxZ);
			if (o.pinned) {
				return self;
			}
			if (modal && self._lastZ) {
				// if it is modal dialog with hidden shell, then adjust shells
				elem = self._modalDiv;
				if (elem && elem[0].offsetWidth < 10) {
					self._onResize();
				}
				return self;
			}
			if (_lastTop === self && (zi0 || zi) >= _maxZ) {
				return self;
			}
			if (_lastTop && !zi0) {
				_lastTop.element.css("zIndex", _lastTop._lastZ || -1);
				_lastTop._save();
			}
			if (_lastZ >= _maxZ) {
				_maxZ++;
			}
			if (modal && !zi0) {
				_maxZ++;
				_maxZ++;
			}
			// bug:120224
			//if ((zi0 || zi) >= _lastZ) {
			_lastTop = self;
			//}
			self._lastZ = _lastZ = zi0 || ((modal || _modals.length > 0) ? _maxZ : zi);
			if (!zi0) {
				elem.css("zIndex", zi0 || _maxZ);
				self._save();
			}
			elem0.scrollTop = scrollTop;
			elem0.scrollLeft = scrollLeft;
			if (modal) {
				self._doModal(_maxZ);
			}
			return self;
		},
		content: function (newContent) {
			/* Retrieves the igDialog content container or sets its content to be the new content provided.
				paramType="string" optional="true" The new html content provided as a string. If the parameter is provided then the method acts as a setter.
				returnType="object" If no parameter is provided then the method returns the container carrying the igDialog content. This is the inner container of the dialog window excluding headers, resizing handlers, etc.
			*/
			if (arguments.length === 0) {
				return this.element.children(".ui-igdialog-content");
			}
			this.element.children(".ui-igdialog-content").html(newContent);
		},
		_save: function () {
			var str, input, pos, o = this.options, name = o.inputName;
			if (!name) {
				return;
			}
			input = $('input[name="' + name + '"]');
			if (input.length === 0) {
				input = input.parents("form")[0] || document.forms[0];
				if (!input) {
					return;
				}
				input = $('<input type="hidden" name="' + name + '" />').appendTo(input);
			}
			str = "s" + (o.pinned ? "1" : "") + (this._opened ? (this._min ? 2 : (this._max ? 3 : 1)) : 0) +
				(o.width ? ":w" + o.width : "") + (o.height ? ":h" + o.height : "") + (":z" + this.element.css("zIndex") || o.zIndex);
			pos = o.position;
			if (pos && pos.length === 2) {
				str += ":p" + pos[0] + "," + pos[1];
			}
			input.val(str);
		},
		_open: function (e, raiseEvt) {
			var self = this,
				o = self.options,
				elem = self.element,
				anim = self._min ? null : o.openAnimation,
				arg = { action: "open", owner: this };
			if ((self._opened && self._vis) || (raiseEvt && !self._fireState(e, true, arg))) {
				return self;
			}
			if (!o.pinned) {
				elem.css("position", "absolute");
			}
			//A.T. 9 July - Fix for bug #142753
			if (o.width !== null) {
				elem.show();
			}
			// adjust opened before _doSize, because _onResize may fail
			self._opened = true;
			self._doSize(1);
			if (anim) {
				elem.hide().show(anim, function () {
					self._trigger("animationEnded", e, arg);
				});
			}
			self._vis = true;
			_visCount++;
			// enable focus/blur processing
			self._trackFocus(elem);
			self.moveToTop(true);
			self._fixState();
			if (raiseEvt) {
				self._fireState(e, false, arg);
			}
			self._save();
			return self;
		},
		_initContainer: function (container, change) {
			if (container) {
				if (typeof container === "string") {
					container = $(container);
				}
				if (container && container[0]) {
					container = container[0];
				}
			}
			if (!container || !container.parentNode) {
				container = this.element.parents("form")[0] || document.body;
			} else if (container.nodeName !== "BODY") {
				var style = container.style, pos = style ? style.position : null;
				if (style && (!pos || pos === "static")) {
					style.position = "relative";
				}
			}
			if (change) {
				this.element.appendTo(container);
			}
			return container;
		},
		_fixState: function () {
			this.options.state = this._opened ? (this._min ? "minimized" : (this._max ? "maximized" : "opened")) : "closed";
		},
		_minimize: function (e) {
			return this._doState(e, { action: this._min ? "restore" : "minimize" }, e ? "minimize" : null, "_onMin", true);
		},
		_maximize: function (e) {
			return this._doState(e, { action: this._max ? "restore" : "maximize" }, e ? "maximize" : null, "_onMax", true);
		},
		_pin: function (e) {
			return this._doState(e, { action: this.options.pinned ? "unpin" : "pin" }, e ? "pin" : null, "_onPin");
		},
		_close: function (e) {
			return this._opened ? this.close(e) : this._open(e);
		},
		_getTabIndex: function (e) {
			return (isNaN(e = parseInt(e.tabIndex, 10)) || e < 1) ? 0 : e;
		},
		_doHeader: function () {
			var button, id, evts,
				i = 4,
				self = this,
				header = self._header,
				o = self.options,
				txt = o.headerText,
				css = self.css;
			if (header) {
				header.remove();
			}
			delete self._minHW;
			header = self._header = _notab($("<div />").addClass(css.header).css("display", "block").prependTo(self.element)).dblclick(function (e) {
				var dbl = o.enableDblclick;
				if (!dbl) {
					return;
				}
				if (self._min) {
					self._doState(e, { action: "restore" }, null, "_onMin", true);
				} else if (dbl === true || (dbl === "auto" && o.showMaximizeButton)) {
					self._doState(e, { action: self._max ? "restore" : "maximize" }, null, "_onMax", true);
				}
			});
			//
			if (o.imageClass) {
				self._img = $("<span />").addClass(css.headerImage).addClass(o.imageClass).html("&nbsp;").appendTo(header);
			}
			self._headerText = $("<span />").addClass(css.headerText).html(txt || "&nbsp;").appendTo(header);
			//
			evts = {
				mouseover: function () { $(this).addClass(css.headerButtonHover); },
				mouseleave: function () { $(this).removeClass(css.headerButtonHover); },
				mousedown: function (e) { this._mdb = $.ig && $.ig.util && $.ig.util.evtButton(e); },
				click: function (e) {
					if (!e || this._mdb) {
						return;
					}
					try {
						self["_" + $(this).attr("data-id")](e);
					} catch (ex) {}
					_stopEvt(e);
				},
				touchstart: function (e) { this._drag = null; _stopEvt(e); },
				touchmove: function (e) { this._drag = 1; _stopEvt(e); },
				touchend: function () { if (!this._drag) { $(this).trigger("click"); } }
			};
			// i=order of buttons in header:pin,min,max,close
			while (i-- >= 0) {
				if (i === 3 && o.showCloseButton) {
					id = "close";
				} else if (i === 2 && o.showMaximizeButton) {
					id = "maximize";
				} else if (i === 1 && o.showMinimizeButton) {
					id = "minimize";
				} else {
					id = (i === 0 && o.showPinButton) ? "pin" : null;
				}
				if (id) {
					button = $("<a />").addClass(css.headerButton + " " + css[id]).attr("data-id", id)
						.attr("href", "#").attr("role", "button").bind(evts).appendTo(header);
					$("<span />").addClass(css[id + "Icon"]).appendTo(button);
					// i=order of buttons in header:pin,min,max,close
					self._loc(button, i === 3 ? CLOSE : (i === 2 ? MAX : (i === 1 ? MIN : PIN)));
				}
			}
			if (!o.showHeader) {
				header.hide();
			}
		},
		_doFooter: function () {
			var self = this,
				o = self.options,
				txt = o.footerText,
				css = self.css;
			if (self._footer) {
				self._footer.remove();
				delete self._footer;
			}
			if (o.showFooter) {
				self._footer = _notab($("<div />").addClass(css.footer).css("display", "block").html(txt || "&nbsp").appendTo(self.element));
			}
		},
		_onMin: function (e, noSize, noFocus) {
			var but,
				o = this.options,
				bar = this._footer,
				css = this.css,
				header = this._header,
				min = (e && e.type) ? !this._min : !!e;
			if (min === this._min && this._created) {
				return;
			}
			this._min = min;
			if (min && o.pinOnMinimized) {
				this._onPin(min, true, true);
			}
			but = header.find("." + css.minimize);
			but.find("*").removeClass(min ? css.minimizeIcon : css.restoreIcon).addClass(min ? css.restoreIcon : css.minimizeIcon);
			if (e && e.type && min && this._max) {
				this._onMax(false, true, true);
			}
			this._loc(but, min ? RESTORE : MIN);
			if (min) {
				header.addClass(css.headerMinimized);
				if (bar) {
					bar.hide();
				}
			} else {
				header.removeClass(css.headerMinimized);
				if (bar) {
					bar.show();
				}
			}
			if (!noSize && this._vis) {
				this._doSize();
			}
			if (!noFocus && this._vis) {
				this._setFocus();
			}
			this._save();
		},
		_onMax: function (e, noSize, noFocus) {
			var but,
				o = this.options,
				header = this._header,
				css = this.css,
				max = (e && e.type) ? !this._max : !!e;
			if (max === this._max && this._created) {
				return;
			}
			this._max = max;
			if (!max) {
				this._restoreHtml();
			} else {
				// K.D. July 3rd, 2014 Bug #166685 Attaching the dialog to the body before maximize and restoring its
				// position in the DOM on minimize.
				this._originalParent = this.element.parent();
				this.element.appendTo(document.body);
			}
			but = header.find("." + css.maximize);
			but.find("*").removeClass(max ? css.maximizeIcon : css.restoreIcon).addClass(max ? css.restoreIcon : css.maximizeIcon);
			this._loc(but, max ? RESTORE : MAX);
			if (max) {
				if (this._min) {
					this._onMin(false, true, true);
				}
				if (o.pinned) {
					this._onPin(false, true, true);
				}
			}
			if (max) {
				header.addClass(css.unmovable);
			} else {
				header.removeClass(css.unmovable);
			}
			if (!noSize && this._vis) {
				this._doSize();
			}
			if (!noFocus && this._vis) {
				this._setFocus();
			}
			this._save();
		},
		_onPin: function (e, noSize, noFocus) {
			var but, elem, parent, dad, pos,
				old = this._old,
				next = this._next,
				css = this.css,
				header = this._header,
				o = this.options,
				pin = (e && e.type) ? !o.pinned : !!e;
			if (pin === o.pinned && this._created) {
				return;
			}
			o.pinned = pin;
			// fix icon on pin-button
			but = header.find("." + css.pin);
			but.find("*").removeClass(pin ? css.pinIcon : css.unpinIcon).addClass(pin ? css.unpinIcon : css.pinIcon);
			if (this._max && pin) {
				this._onMax(false, false, true);
			}
			this._loc(but, pin ? UNPIN : PIN);
			if (pin) {
				header.addClass(css.unmovable);
			} else {
				header.removeClass(css.unmovable);
			}
			// fix position of dialog
			elem = this.element;
			if (pin) {
				pos = old.position;
				if (this._resize && (pos === "static" || !pos)) {
					pos = "relative";
				}
				this._pinPos = pos = { position: pos, left: old.left, top: old.top };
			} else {
				pos = { position: "absolute" };
			}
			elem.css(pos);
			// fix parent
			parent = elem.parent()[0];
			dad = pin ? this._oldDad : this._dad;
			if (dad && dad !== parent) {
				if (pin && next && next.parentNode === dad) {
					elem.insertBefore(next);
				} else {
					elem.appendTo(dad);
				}
			}
			if (!noFocus && this._vis) {
				this._setFocus();
			}
			if (!noSize && this._vis) {
				if (!pin) {
					this._doSize(1);
				} else {
					this._doModal();
				}
			}
			this._save();
		},
		_doClose: function (e, destroy) {
			var i,
				self = this,
				elem = self.element,
				arg = { action: "close" },
				o = self.options,
				anim = (self._min || destroy) ? null : o.closeAnimation;
			if (!self._opened || (!destroy && !self._fireState(e, true, arg, e ? "close" : null))) {
				return;
			}
			// disable focus/blur processing
			self._trackFocus(elem, 1);
			self._restoreHtml();
			if (_lastTop === self) {
				_lastTop = null;
			}
			self._fireFoc(false);
			self._hasFocus = false;
			delete self._lastZ;
			self._vis = self._opened = false;
			if (destroy) {
				o.modal = false;
			}
			self._doModal();
			if (anim) {
				elem.hide(anim, function () {
					self._trigger("animationEnded", e, arg);
				});
			} else if (!destroy) {
				elem.hide();
			}
			if (!destroy) {
				self._fixState();
				self._fireState(e, false, arg);
			}
			if (--_visCount < 1) {
				_visCount = _lastZ = _maxZ = 0;
			} else if (_visCount === (i = _modals.length)) {
				_modals[i - 1]._setFocus();
			}
			self._save();
		},
		// fire stateChanging/ed event
		// e-browser event
		// before-cancelable before event (suffix ing or ed)
		// arg-ui argument
		// but-name of button or null
		_fireState: function (e, before, arg, but) {
			if (before) {
				var o = this.options;
				arg.oldState = o.state;
				arg.oldPinned = o.pinned;
				arg.owner = this;
				if (but) {
					arg.button = but;
				}
			}
			return this._created ? this._trigger("stateChang" + (before ? "ing" : "ed"), e, arg) : true;
		},
		// fire both stateChanging/ed events and call fnName function
		// e-browser event
		// arg-ui argument
		// but-name of button or null
		// fnName-name of function to call if before-event was not canceled
		// show-ensure that dialog is opened
		_doState: function (e, arg, but, fnName, show) {
			if (this._fireState(e, true, arg, but)) {
				this[fnName](e || { type: 1 });
				if (show && !this._opened) {
					this._open(null, true);
				}
				this._fixState();
				if (this._created) {
					this._trigger("stateChanged", e, arg);
				}
			}
			return this;
		},
		_fireFoc: function (foc, e) {
			var name = foc ? "focus" : "blur";
			if (name !== this._lastFoc) {
				// memorize last focus/blur state
				this._trigger(this._lastFoc = name, e, { owner: this });
				if (this.options.enableHeaderFocus) {
					name = this.css.headerFocus;
					if (foc) {
						this._header.addClass(name);
					} else {
						this._header.removeClass(name);
					}
				}
			}
		},
		// attach focus/blur event listeners to elem and all its children
		// remove: request to remove event listeners
		_trackFocus: function (elem, remove) {
			var self = this, focusEvt = self._focusEvt, track = self.options.trackFocus;
			if (!focusEvt && !track) {
				return;
			}
			if (remove) {
				if (self._focBind) {
					self._focBind.unbind(focusEvt);
					delete self._focBind;
				}
				return;
			}
			if (!focusEvt) {
				focusEvt = function (e) {
					var elems, old = self._focBind, foc = e.type === "focus";
					// N.A. 2/12/2015 Bug #188573 
					if (self._isDatePickerOpened()) {
						return;
					}
					if (!foc && old && elem) {
						// add focus listeners to new children (like editors in grid)
						elems = elem.find("*").not(old);
						if (elems.length) {
							self._focBind = old.add(elems);
							elems.bind(focusEvt);
						}
					}
					self._hasFocus = foc;
					// fire focus/blur events with delay with validation for last state
					setTimeout(function () {
						var focusTo = self.getTopModal(), elem = self.element;
						// do not allow lost focus for modal dialog
						if (elem && focusTo && !self._hasFocus && !foc && _lastTop === self) {
							// modal or maximized dialog lost focus
							if (self._max || focusTo === self) {
								focusTo = self._nextTabElem || elem[0];
							// not-modal-child-dialog of modal-dialog lost focus on tab
							} else {
								focusTo = (self._tabTime && (new Date().getTime() - self._tabTime) < 200) ? elem[0] : null;
							}
							if (focusTo) {
								self._setFocus(focusTo);
							}
						}
						// raise focus/blur events
						self._fireFoc(self._hasFocus, e);
					}, 50);
				};
				focusEvt = self._focusEvt = { focus: focusEvt, blur: focusEvt };
			}
			if (track && elem) {
				self._focBind = elem.find("*").add(elem).bind(focusEvt);
			}
		},
		// N.A. 2/12/2015 Bug #188573: The dialog gets the focus and therefore the month/year dropdown of the igDatePicker is closed.
		// There is similar bug in jQuery dialog http://bugs.jqueryui.com/ticket/8989, that is fixed https://github.com/jquery/jquery-ui/commit/c53198c2099d25e80887c86af6d0e624414cc2f7.
		// The dialog doesn't use focusin, but focus, that's why our context is always the dialog and we cannot make the same fix as jQuery.
		_isDatePickerOpened: function () {
			return $("#ui-datepicker-div")[0] && $("#ui-datepicker-div").css("display") === "block";
		},
		_setFocus: function (elem) {
			var self = this;
			setTimeout(function () {
				try {
					if (!self._hasFocus) {
						if (!self.options.trackFocus) {
							self._hasFocus = true;
						}
						elem = elem || self.element[0];
						elem.focus();
					}
				} catch (ex) {}
			}, 100);
		},
		// used after maximized off
		_restoreHtml: function () {
			var html, old = this._oldHtml, parent = this._originalParent;
			if (parent) {
				this.element.appendTo(parent);
				this._originalParent = null;
			}
			if (old) {
				html = old.html;
				if (html.style) {
					html.style.overflow = old.overflow;
				}
				html.scrollLeft = old.scrollLeft;
				html.scrollTop = old.scrollTop;
				delete this._oldHtml;
			}
		},
		_touch: function (elem, name) {
			var start, self = this, evt = function (evt, type) {
				var act, e = evt.originalEvent,
					touches = e ? e.touches : null,
					one = touches && touches.length === 1;
				// type: null-end
				if (one && type) {
					_stopEvt(evt);
				}
				// !one: scrolling should be ended
				one = one && type === "move";
				if (start) {
					start = one ? start : null;
					act = one ? "Drag" : "Stop";
				} else if (one) {
					start = true;
					elem.trigger("mouseover");
					act = "Start";
				}
				if (act) {
					e = self.element.data(name);
					act = "_mouse" + act;
					// explicitly call _mouseStart/Drag/Stop methods of draggable or resizable
					if (e && e[act]) {
						evt.pageX = one ? touches[0].pageX : 0;
						evt.pageY = one ? touches[0].pageY : 0;
						e[act](evt);
					}
				}
			};
			elem.bind({
				touchstart: function (e) { evt(e, "start"); },
				touchmove: function (e) { evt(e, "move"); },
				touchend: function (e) { evt(e); }
			});
		},
		_doDraggable: function () {
			var self = this, o = self.options, elem = self.element;
			if (elem.draggable && o.draggable) {
				self._touch(self._header, "draggable");
				elem.draggable({
					cancel: ".ui-igdialog-content, .ui-igdialog-headerbutton",
					handle: ".ui-igdialog-header",
					containment: "document",
					start: function () {
						if (o.pinned || self._max) {
							return false;
						}
						$(this).addClass(self.css.dragging);
					},
					stop: function (e, ui) {
						var doc = $(document);
						o.position = [ui.position.left - doc.scrollLeft(), ui.position.top - doc.scrollTop()];
						$(this).removeClass(self.css.dragging);
						self._save();
					}
				});
			}
		},
		_doResizable: function () {
			var elems, r, i = 0, self = this, o = self.options, elem = self.element;
			if (!elem.resizable) {
				return;
			}
			self._resize = o.resizable;
			if (!self._resize) {
				return;
			}
			elem.css("position", elem.css("position")).resizable({
				cancel: "." + self.css.content,
				containment: "document",
				alsoResize: self.element.children('.ui-igdialog-content'),
				maxWidth: o.maxWidth,
				maxHeight: o.maxHeight,
				minWidth: self._minWidth(),
				minHeight: o.minHeight,
				handles: (typeof o.resizable === "string") ? o.resizable : "n,e,s,w,se,sw,ne,nw",
				start: function () {
					// Note: cancel has no effect
					$(this).addClass(self.css.resizing);
				    // restore position, left and top, which were modified by resizing
				    // A.M. April 28th, 2015 Bug #190822 "Resizing is not working properly from the top border of the window"
				    // Dialog now can be resized by dragging the left or the top border of the window
					//pos = ui.originalPosition;
					if (o.pinned && self._pinPos) {
						elem.css(self._pinPos);
					}
				},
				resize: function () {
					// Note: cancel has no effect
					self._fixCaption();
					// K.D. December 20th, 2013 Bug #159961 Keeping the position because 
				    // resizable messes it if inside absolute or relative element.
				    // A.M. April 28th, 2015 Bug #190822 "Resizing is not working properly from the top border of the window"
                    // Dialog now can be resized by dragging the left or the top border of the window
					//elem.css(pos);
					// restore position, left and top, which were modified by resizing
					if (o.pinned && self._pinPos) {
						elem.css(self._pinPos);
					}
				},
				stop: function () {
					$(this).removeClass(self.css.resizing);
					o.height = $(this).height();
					o.width = $(this).width();
					self._save();
				}
			}).find(".ui-resizable-se").addClass("ui-icon ui-icon-grip-diagonal-se");
			r = elem.data("resizable") || elem.data("ui-resizable");
			if (r) {
				// get around bug in resizable related to bounds of container
				if (!r._dragFix) {
					r._dragFix = r._mouseDrag;
					r._mouseDrag = function (e) {
						var x, y, d = r.parentData;
						if (d && e) {
							x = e.pageX;
							y = e.pageY;
							if (x <= d.left || y <= d.top || x >= d.left + d.width || y >= d.top + d.height) {
								return false;
							}
						}
						return r._dragFix(e);
					};
				}
				elems = r._handles;
				i = elems.length;
			}
			while (i-- > 0) {
				self._touch($(elems[i]), "resizable");
			}
		},
		_toPx: function (val, height) {
			if (typeof val === "number") {
				return val;
			}
			if (!val) {
				return height ? val : 0;
			}
			val = val.toString();
			var elem, num = parseInt(val, 10);
			if (isNaN(num)) {
				return 0;
			}
			// check for em, ex, in, cm, mm, pt units
			if (val.indexOf("m") > 0 || val.indexOf("e") > 0 || val.indexOf("i") > 0 || val.indexOf("t") > 0) {
				elem = $("<div />").css({ visibility: "hidden", width: val }).appendTo(this._dad);
				num = elem.width();
				elem.remove();
			} else if (val.indexOf("%") > 0) {
				val = this._winRect(1);
				val = height ? val.height : val.width;
				return Math.floor(num * val / 100);
			}
			return num;
		},
		// fixPos: force adjust position
		// note: dialog should be already opened
		_doSize: function (fixPos) {
			// fix size
			var self = this,
				o = self.options,
				max = self._max,
				pos = max ? [0, 0] : o.position,
				resize = self._resize ? ".ui-resizable-handle" : null,
				elem0 = self.element.children('.ui-igdialog-content'),
				elem = self.element;
			if (resize) {
				// show/hide resizing handles
				if (self._min || max) {
					$(resize, elem).hide();
				} else {
					$(resize, elem).show();
				}
			}
			// temporary hide headerText, it will be adjusted by _fixCaption
			self._headerText.css("width", 0);
			if (self._min) {
				elem0.hide();
				self._fixCaption(elem);
			} else if (max) {
				elem0.show().css({ width: "auto", height: "auto" });
				// temporary collapse dialog: to correctly set position (any reasonable values)
				elem.css({ width: 100, height: 50 });
			//A.T. 9 July - Fix for bug #142753
			} else if (o.width !== null) {
				this._doSizePX(elem0,
					elem,
					Math.max(self._minWidth(), self._toPx(o.width)),
					self._toPx(o.height, true),
					o.minHeight);
				if (resize) {
					elem.resizable("option", "minHeight", o.minHeight);
				}
			}
			if (o.width === null) {
				this._fixCaption(elem);
				elem.show();
			}
			// fix position
			if (!o.pinned && (fixPos || max || self._oldMax)) {
				self._oldMax = max;
				if (max) {
					self._onResize();
				}
				if (elem.position) {
					if (pos) {
						if (pos.left !== undefined && pos.top !== undefined) {
							pos = [ pos.left, pos.top ];
						}
						if (pos && pos.length > 1) {
							if (typeof pos[0] !== "number") {
								pos[0] = parseInt(pos[0]);
							}
							if (typeof pos[1] !== "number") {
								pos[1] = parseInt(pos[1]);
							}
							if (isNaN(pos[0]) || isNaN(pos[1])) {
								pos = {};
							} else {
							// N.A. 10/17/2013 - Bug #155039: The property "offset" is deprecated in 1.9.
							if ($.ig.util.jQueryUIMainVersion <= 1 && $.ig.util.jQueryUISubVersion < 9) {
								pos = { my: "left top", at: "left top", offset: pos[0] + " " + pos[1] };
							} else {
								pos = { my: "left+" + pos[0] + " top+" + pos[1], at: "left top" };
							}
						}
						}
						pos = $.extend({}, _pos, pos);
					}
					elem.css({ top: 0, left: 0 }).position(pos || _pos);
				}
			}
			self._doModal();
			self._save();
		},
		// adjust px width and height of dialog (not minimized)
		_doSizePX: function (elem0, elem, width, height, minHeight) {
			// temporary collapse content in order to calculate height (minHeight) of header text and border/padding of content
			elem0.show().css({ width: "auto", height: 0, minHeight: 0 });
			var zeroHeight = elem.css({ width: width, height: "auto", display: "block" }).height();
			this._fixCaption(elem);
			if (typeof height === "string") {
				if (height.indexOf("px") > 0) {
					height = parseInt(height, 10);
				}
			}
			// auto size for height
			if (typeof height !== "number") {
				height = elem0.css("height", "auto").height() + zeroHeight;
			}
			height = Math.max(minHeight, height);
			elem0.height(Math.max(height - zeroHeight, 0));
			minHeight = height - elem[0].offsetHeight;
			if (minHeight > 0) {
				elem0.height(Math.max(height - zeroHeight + minHeight, 0));
			}
		},
		_onResize: function () {
			var rect, self = this, div = self.isTopModal() ? self._modalDiv : null;
			if (!self._winResize) {
				$(window).bind("resize", self._winResize = function () {
					setTimeout(function () {
						self._onResize();
					}, 50);
				});
			}
			if (!self._opened || self.options.pinned) {
				return;
			}
			// collapse modal DIV/IFRAME-shells
			if (div) {
				div.hide();
				self._doIframe(div, 1);
			}
			// adjust maximized dialog
			if (self._max) {
				self._doMaxSize(self.element);
			}
			// adjust modal DIV/IFRAME-shells
			if (div) {
				rect = self._winRect();
				div.css({ width: rect.maxWidth - 1, height: rect.maxHeight - 1 }).show();
				self._doIframe(div);
			}
		},
		_minHeaderWidth: function () {
			var outerWidth, elem,
				width = this._minHW,
				elems = this._header.children().not(this._headerText),
				i = elems.length;
			if (!width) {
				width = 3 + _getPadding(this._header);
				while (--i >= 0) {
					elem = elems[i];
					// get around bugs in jquery-1.4.4 (exception in Opera or huge elem.outerWidth in IE)
					try {
						outerWidth = $(elem).outerWidth(true);
					} catch (ex) {}
					width += 1 + ((outerWidth && outerWidth > 2 && outerWidth < 100) ? outerWidth : elem.offsetWidth);
				}
				this._minHW = width;
			}
			return width;
		},
		// minimal width of dialog in normal (not mimimized) state
		_minWidth: function () {
			if (!this._minW) {
				this._minW = this._minHeaderWidth();
			}
			return Math.max(this.options.minWidth, this._minW);
		},
		// adjust width of header text to fit into available width of header
		_fixCaption: function (elem) {
			var width, widths, top, len, topi,
				j = 0,
				i = -1,
				header = this._header,
				cap = this._headerText,
				minCss = this.css.headerTextMinimized;
			if (this._min) {
				cap.css("width", "").addClass(minCss);
				if (!elem) {
					return;
				}
				elem.css({ height: "auto", width: "auto", display: "inline-block" });
				// get around IE6/7 and draggable beyond right edge: check if width of header/dialog is not larger than widths of children
				widths = _getPadding(header) + 3;
				cap = header.children();
				len = cap.length;
				while (++i < len) {
					widths += cap[i].offsetWidth + _toPx($(cap[i]), "marginLeft") + _toPx($(cap[i]), "marginRight");
				}
				while (j++ < 2) {
					elem.css("width", widths);
					// verify that buttons did not jump on 2nd line
					widths += 2;
					i = len;
					while (i-- > 0) {
						topi = cap[i].offsetTop;
						if (i > 0 && i < len - 1 && Math.abs(top - topi) > 4) {
							break;
						}
						top = topi;
					}
					if (i < 0) {
						j = 4;
					}
				}
				return;
			}
			cap.removeClass(minCss);
			// get around bugs in jquery-1.4.4 (exception in Opera or huge elem.innerWidth in IE)
			try {
				width = header.innerWidth() - 3;
			} catch (ex) { }
			if (!width || width > 1000) {
				width = header[0].clientWidth - 4;
			}
			width = Math.max(1, width - this._minHeaderWidth());
			cap.css("width", "auto");
			// if themeroller is used, then fonts can change without notification:
			// assume jump from smallest to largest (very ~, but at least something)
			if (cap[0].offsetWidth * 1.3 > width) {
				cap.css("width", width);
			}
		},
		// stretch dialog to size of window
		_doMaxSize: function (elem) {
			var html,
				old = this._oldHtml,
				elem0 = this.element.children(".ui-igdialog-content"),
				rect = this._winRect(),
				paddingX = _getPadding(elem),
				paddingY = _getPadding(elem, 1);
			html = rect.html;
			if (!old) {
				// save old attributes of window before maximize
				this._oldHtml = old = {
					html: html,
					scrollLeft: html.scrollLeft,
					scrollTop: html.scrollTop
				};
				html.scrollLeft = html.scrollTop = 0;
				if (html.style) {
					old.overflow = html.style.overflow;
					html.style.overflow = "hidden";
					// if window had scrollbars, then recalculate size
					if (rect.maxWidth > rect.width || rect.maxHeight > rect.height) {
						rect = this._winRect(1);
					}
				}
			}
			this._doSizePX(elem0, elem, rect.width - paddingX - 1, rect.height - paddingY - 1, 0);
		},
		// returns properties of window/HTML { width, height, maxWidth, maxHeight, html }
		_winRect: function (sizeOnly) {
			var size, docElem, width, height, widthOk, heightOk,
				// container = this.options.container,
				maxWidth = 0,
				maxHeight = 0,
				big = 999999,
				win = window,
				doc = win.document,
				body = doc.body,
				html = body;
			// K.D. December 20th, 2013 Bug #159961 We're no longer attaching the dialog to the body by default
			// if (container) {
				// width = container.offsetWidth;
				// height = container.offsetHeight;
				// return { width: width, height: height, maxWidth: width, maxHeight: height, html: container };
			// }
			// find HTML
			while (html && html.nodeName !== "HTML") {
				html = html.parentNode;
			}
			if (!html) {
				html = body;
			}
			docElem = doc.documentElement || html;
			// check for quirks of IE
			size = ((doc.compatMode !== "CSS1Compat") && $.ig.util.isIE) ? body : html;
			width = size.clientWidth;
			height = size.clientHeight;
			if (sizeOnly) {
				return { width: width, height: height };
			}
			// any reasonable valid value
			if (width && width > 50) {
				maxWidth = width;
				maxHeight = height;
			} else {
				width = height = big;
			}
			widthOk = html.scrollWidth;
			heightOk = html.scrollHeight;
			if (widthOk && heightOk) {
				maxWidth = Math.max(maxWidth, widthOk);
				maxHeight = Math.max(maxHeight, heightOk);
			}
			maxWidth = Math.max(maxWidth, body.scrollWidth);
			maxHeight = Math.max(maxHeight, body.scrollHeight);
			widthOk = body.offsetWidth;
			heightOk = body.offsetHeight;
			maxWidth = Math.max(maxWidth, widthOk);
			maxHeight = Math.max(maxHeight, heightOk);
			return { width: (width === big) ? widthOk : width, height: (height === big) ? heightOk : height, maxWidth: maxWidth, maxHeight: maxHeight, html: html };
		},
		// create _iframe, adjust its parent and size
		// hide: request to temporary hide iframe (width/height:1px)
		_doIframe: function (div, hide) {
			// trick jslint validation for illegal "JavaScript URL" by hiding part in var
			var src = "javascript";
			if (!_iframe) {
				_iframe = _notab($("<iframe />").attr("frameBorder", 0).attr("scrolling", "no")
					.attr("src", src + ":''")
					.css({ position: "absolute", filter: "alpha(opacity=50)", opacity: 0 }));
			}
			if (_iframe.parent()[0] !== div.parent()[0]) {
				_iframe.css({ width: "1px", height: "1px", marginLeft: div.css("marginLeft"), marginTop: div.css("marginTop"),
					left: div.css("left"), top: div.css("top"), zIndex: div.attr("zIndex") - 1 }).insertBefore(div);
			}
			_iframe.css({ width: hide ? "1px" : div.css("width"), height: hide ? "1px" : div.css("height") });
		},
		// zi: zIndex used when modal shell is visible
		// implement all actions related to modal functionality: start/end modal depending on visibility/pin/minimized
		_doModal: function (zi) {
			var i, pos, on, obj,
				len = _modals.length,
				self = this, o = self.options,
				elem = self.element,
				div = self._modalDiv;
			on = o.modal && !o.pinned && !self._min && self._opened;
			i = $.inArray(self, _modals);
			if (self._modal === on) {
				if (zi && div) {
					div.css("zIndex", zi - 1);
					self._onResize();
				}
				// if that dialog is not modal, then ensure that last modal dialog in array is on top
				if (!on && !_lastTop && len > 0) {
					_modals[len - 1].moveToTop();
				}
				return;
			}
			// add new dialog to array
			if (i < 0 && on) {
				// hide shell of previous top dialog
				if (len > 0) {
					_modals[len - 1]._modalDiv.hide();
				}
				_modals.push(self);
			}
			// remove this dialog from array
			if (i >= 0 && !on) {
				// find last dialog in array, which will be moved on top
				if (i > 0 && i + 1 === len) {
					obj = _modals[i - 1];
				}
				_modals.splice(i, 1);
			}
			self._modal = on;
			if (on) {
				self._modalDiv = div = _notab($("<div />").css({ position: "absolute", left: 0, top: 0, zIndex: _maxZ - 1 })
					.addClass(self.css.overlay).mousedown(function (e) {
						self._setFocus();
						_stopEvt(e);
					})
					.insertBefore(elem));
				pos = div.offset();
				div.css({ marginLeft: -pos.left + "px", marginTop: -pos.top + "px" });
				self._onResize();
			} else {
				div.remove();
				_iframe.remove();
				delete self._modalDiv;
				if (obj) {
					obj.moveToTop();
				}
			}
		},
		_loc: function (but, state) {
			state = ((state === MIN) ? "minimize" : ((state === MAX) ? "maximize" : ((state === RESTORE) ?
					"restore" : ((state === CLOSE) ? "close" : ((state === PIN) ?
					"pin" : ((state === UNPIN) ? "unpin" : "open")))))) + "ButtonTitle";
			var val = this.options[state] || ($.ig && $.ig.Dialog && $.ig.Dialog.locale ? $.ig.Dialog.locale[state] : null) || "";
			but.attr("title", val).attr("longdesc", val);
		},
		_setOption: function (key, val) {
			var pos, size, drag, resize,
				elem = this.element, o = this.options, container = key === "container";
			if (!elem || !key || o[key] === val || key === "mainElement") {
				return this;
			}
			if (key === "state") {
				return this.state(val);
			}
			if (key === "pinned") {
				return this._pin();
			}
			if (container) {
				if (o.draggable && elem.draggable) {
					elem.draggable("destroy");
					drag = true;
				}
				if (o.resizable && elem.resizable) {
					elem.resizable("destroy");
					resize = true;
				}
			}
			$.Widget.prototype._setOption.apply(this, arguments);
			if (typeof val === "function") {
				return this;
			}
			if (container) {
				this._initContainer(val, 1);
				if (drag) {
					this._doDraggable();
				}
				if (resize) {
					this._doResizable();
				}
			}
			if (key === "draggable") {
				if (val) {
					this._doDraggable();
				} else if (elem.draggable) {
					elem.draggable("destroy");
				}
			}
			if (key === "resizable") {
				if (val) {
					this._doResizable();
				} else if (this._resize) {
					this._resize = val;
					elem.resizable("destroy");
				}
			}
			if (key === "modal") {
				this._doModal();
			}
			if (key.indexOf("Button") > 0 || key === "image" || key === "headerText" || key === "showHeader") {
				this._doHeader();
				size = true;
			}
			// check for showFooter and footerText
			if (key.indexOf("ooter") > 0) {
				this._doFooter();
				size = true;
			}
			if (key === "tabIndex") {
				elem.attr("tabIndex", val);
			}
			if (key === "zIndex") {
				elem.css("zIndex", val);
				this._save();
			}
			if (this._vis) {
				pos = key === "position";
				// check for height, width, minHeight, minWidth, maxHeight, maxWidth
				if (container || size || pos || key.indexOf("idth") > 0 || key.indexOf("eight") > 0) {
					this._doSize(pos || container);
				}
			}
			// check for trackFocus, enableHeaderFocus
			if (key.indexOf("Foc") > 0) {
				this._header.removeClass(this.css.headerFocus);
				if (key === "trackFocus" && val !== (this._focBind ? true : false)) {
					if (this._opened) {
						this._doClose();
						this._open();
					} else {
						this._open();
						this._doClose();
					}
				}
			}
			return this;
		}
	});
	$.extend($.ui.igDialog, { version: "15.2.20152.1033" });
}(jQuery));

/*!@license
 * Infragistics.Web.ClientUI jQuery Popover 15.2.20152.1033
 *
 * Copyright (c) 2013-2015 Infragistics Inc.
 *
 * http://www.infragistics.com/
 *
 * Depends on:
 *  jquery-1.4.2.js
 *  jquery.ui.core.js
 *  jquery.ui.widget.js
 *  infragistics.util.js
 */
/*global jQuery, HTMLElement */
if (typeof jQuery !== "function") {
	throw new Error("jQuery is undefined");
}
(function ($) {
	$.widget("ui.igPopover", {
		css: {
			/* classes applied to the main popover container */
			baseClasses: "ui-widget ui-igpopover",
			/* classes applied to the popover arrow (like ui-igpopover-arrow-top, ui-igpopover-arrow-left, etc)*/
			arrowBaseClass: "ui-igpopover-arrow ui-igpopover-arrow-",
			/* classes applied to the close button */
			closeButtonClass: "ui-icon ui-icon-closethick ui-igpopover-close-button",
			/* classes applied to the title container(if title is defined in options) */
			titleClass: "ui-igpopover-title"
		},
		options: {
			/* type="bool" controls whether the popover will close on blur or not */
			closeOnBlur: true,
			/* type="auto|left|right|top|bottom" controls the direction in which the control shows relative to the target element
				auto type="string" lets the control show on the side where enough space is available with the following priority top > bottom > right > left
				left type="string" shows popover on the left side of the target element
				right type="string" shows popover on the right side of the target element
				top type="string" shows popover on the top of the target element
				bottom type="string" shows popover on the bottom of the target element
			*/
			direction: "auto",
			/* type="auto|balanced|start|end" controls the position of the popover according to the target element in case the popover is larger than the target on the side we want to position, if the popover is smaller it should always be in the middle of the visible area
				auto type="string" lets the control choose a position depending on available space with the following priority balanced > end > start
				balanced type="string" the popover is positioned at the middle of the target element
				start type="string" the popover is positioned at the beginning of the target element
				end type="string" the popover is positioned at the end of the target element
			*/
			position: "auto",
			/* type="number|string" defines width for the popover. leave null for auto.
				number The width can be set as a number.
				string The width can be set in pixels (px).
			*/
			width: null,
			/* type="number|string" defines height for the popover. leave null for auto
				number The height can be set as a number.
				string The height can be set in pixels (px).
			*/
			height: null,
            /* type="number|string" defines width the popover won't go under the value even if no specific one is set.
				number The minWidth can be set as a number.
				string The minWidth can be set in pixels (px).
			*/
            minWidth: 60,
			/* type="number|string" defines width the popover won't exceed even if no specific one is set.
				number The maxWidth can be set as a number.
				string The maxWidth can be set in pixels (px).
			*/
			maxWidth: 200,
			/* type="number|string" defines height the popover won't exceed even if no specific one is set.
				number The max height can be set as a number.
				string The max height can be set in pixels (px).
			*/
			maxHeight: 200,
			/* type="number" sets the time popover fades in and out when showing/hiding */
			animationDuration: 150,
			/* type="string|function" sets the content for the popover container. If left null the content will be get from the target.
				string   String content of the popover container
				function Function which is a callback that can either return the content directly, or call the first argument, passing in the content
			*/
			contentTemplate: null,
			/* type="string" Selectors indicating which items should show popovers. The predefined value is [title]. Customize if you're using something other then the title attribute for the popover content, or if you need a different selector for event delegation. When changing this option, you likely need to also change the contentTemplate option
			*/
			selectors: null,
			/* type="object" sets the content for the popover header */
			headerTemplate: {
				/* type="bool" controls whether the popover renders a functional close button */
				closeButton: false,
				/* type="string" sets the content for the popover header */
				title: null
			},
			/* type="mouseenter|click|focus" sets the event on which the popover will be shown. Predefined values are "mouseenter", "click" and "focus"
				mouseenter   type="string" the popover is shown on mouse enter in the target element
				click        type="string" the popover is shown on click on the target element
				focus        type="string" the popover is shown on focusing the target element
			*/
			showOn: "mouseenter",
			/* type="object" sets the containment for the popover. Accepts a jQuery object */
			containment: null,
			/* type="string|object" Controls where the popover DOM should be attached to.
				string type="string" A valid jQuery selector for the element
				object type="object" A reference to the parent jQuery object
			*/
			appendTo: "body"
		},
		events: {
			/* cancel="true" Event fired before popover is shown.
			Function takes arguments evt and ui.
			Use ui.element to get the element the popover will show for.
			Use ui.content to get or set the content to be shown as a string.
			Use ui.popover to get the popover element showing.
			Use ui.owner to get reference to the igPopover widget
			*/
			showing: "showing",
			/* Event fired after popover is shown.
			Function takes arguments evt and ui.
			Use ui.element to get the element the popover showed for.
			Use ui.content to get the content that was shown as a string.
			Use ui.popover to get the popover element shown.
			Use ui.owner to get reference to the igPopover widget
			*/
			shown: "shown",
			/* cancel="true" Event fired before popover is hidden.
			Function takes arguments evt and ui.
			Use ui.element to get the element the popover will hide for.
			Use ui.content to get the current content displayed in the popover as a string.
			Use ui.popover to get the popover element hiding.
			Use ui.owner to get reference to the igPopover widget
			*/
			hiding: "hiding",
			/* Event fired after popover is hidden.
			Function takes arguments evt and ui.
			Use ui.element to get the element the popover is hidden for.
			Use ui.content to get the content displayed in the popover as a string.
			Use ui.popover to get the popover element hidden.
			Use ui.owner to get reference to the igPopover widget
			*/
			hidden: "hidden"
		},
		_create: function () {
			// T.G. 24 Jan 2014 Fix for bug 161249 - Target option is not obligatory because the user expects it to be the element on which the popover is initialized
			this._target = (this.options.selectors === null || this.options.selectors === undefined) ? this.element : null;
			this._priorityDir = ["bottom", "top", "right", "left"];
			this._arrowDir = ["top", "bottom", "left", "right"];
			this._positions = ["balanced", "start", "end"];
			this._directionIndex = -1;
			this._positionIndex = -1;
			this._forced = this.options.direction !== "auto" && this.options.position !== "auto";
            this._visible = false;
		},
		_createWidget: function (options, element) {
			$.Widget.prototype._createWidget.apply(this, arguments);
			this.element = $(element);
			if (element && element.nodeType !== undefined) {
				this._renderPopover();
			}
			if (this.options.direction !== "auto" || this.options.position !== "auto") {
				this._getPrioritiesIndex();
			}
		},
		_setOption: function (key, value) {
			switch (key) {
				case "direction":
					this.options.direction = value;
					if (this.options.direction !== "auto") {
						this._getPrioritiesIndex();
					}
					this._forced = this.options.direction !== "auto" && this.options.position !== "auto";
					break;
				case "position":
					this.options.position = value;
					if (this.options.position !== "auto") {
						this._getPrioritiesIndex();
					}
					this._forced = this.options.direction !== "auto" && this.options.position !== "auto";
					break;
				case "contentTemplate":
					if (typeof value === "string") {
						this.options.contentTemplate = value;
					}
					break;
				case "animationDuration":
					if (typeof value === "number") {
						this.options.animationDuration = value;
					}
					break;
				case "containment":
					if (value instanceof jQuery) {
						this.options.containment = value;
					}
					break;
                case "closeOnBlur":
                    this.options.closeOnBlur = value;
                    break;
				case "headerTemplate":
				case "selectors":
				case "width":
				case "height":
				case "maxWidth":
				case "maxHeight":
                case "minWidth":
				case "showOn":
					throw new Error($.ig.Popover.locale.popoverOptionChangeNotSupported + ' ' + key);
			}
		},
		destroy: function () {
			/* Destroys the popover widget.*/
			this._detachEventsFromTarget();
            this.popover.remove();
			$.Widget.prototype.destroy.call(this);
			return this;
		},
		id: function () {
			/* returns the ID of the element the popover is attached to
				returnType="string"
			*/
			return this.element[0].id;
		},
		container: function () {
			/* returns the container for the popover contents
				returnType="object"
			*/
            return this.contentInner;
		},
		show: function (trg, content) {
			/* shows the popover for the specified target
				paramType="dom" optional="true" The element to show popover for.
				paramType="string" optional="true" The string to set for the popover to show.
			*/
			var target = trg || this._target;
			if (content) {
				this._setNewContent(content);
			}
			//T.G. 23 Jan 2014 Fix for bug 162111 - An error is thrown when calling igPopover.show method when the igPopover.selectors is set
			if (target === null) {
				throw new Error($.ig.Popover.locale.popoverShowMethodWithoutTarget);
			}
			this._openPopover(target);
		},
		hide: function () {
			/* hides the popover for the specified target */
			this._closePopover();
		},
		getContent: function () {
			/* gets the currently set content for the popover container
				returnType="string" The popover content.
			*/
            return this.contentInner.html();
		},
		setContent: function (newCnt) {
			/* sets the content for the popover container
				paramType="string" The popover content to set.
			*/
			if (typeof newCnt === 'string') {
				this._setNewContent(newCnt);
			}
		},
		target: function () {
			/* gets the popover current target
				returnType="object" The current target.
			*/
			if (this._currentTarget) {
				return this._currentTarget;
			}
			return null;
		},
		getCoordinates: function () {
			/* gets the current coordinates of the popover
				returnType="object" The popover coordinates in pixels.
			*/
			var currPosition = { left: 0, top: 0 };
			currPosition.left = this.popover.css('left');
			currPosition.top = this.popover.css('top');
			return currPosition;
		},
		setCoordinates: function (pos) {
			/* set the currently coordinates of the popover
				paramType="object" The popover coordinates in pixels.
			*/
			this.popover.css({
				'top': pos.top,
				'left': pos.left
			});
		},
		_renderPopover: function () {
            this.popover = $('<div></div>').addClass(this.css.baseClasses);
            // D.P. Only assign ID if it's available
            if (this.id()) {
                this.popover.attr('id', this.id() + "_popover");
            }
			// T.G 12 Dec 2013 Fix 159000 - Arrow is separated from the inner frame
			if (this.options.direction !== "auto") {
				this._getPrioritiesIndex();
                this.arrow = $('<div></div>')
					.addClass(this.css.arrowBaseClass + this._arrowDir[this._directionIndex])
					.appendTo(this.popover);
                if (this.id()) {
                    this.arrow.attr('id', this.id() + "_popover_arrow");
			}
            }
			this.popover.appendTo(this.options.appendTo);
			this._attachEventsToTarget();
			this._createContentDiv();
		},
		_createContentDiv: function () {
		    var cnt, currContent, rightMargin, isTouchDeviceWithIE = this._isTouchDevice() && $.ig.util.isIE;
			cnt = $('<div></div>')
				.css('position', 'relative')
				.css('max-width', this.options.maxWidth)
				.css('max-height', this.options.maxHeight)
                .css('min-width', this.options.minWidth)
				.css('width', isTouchDeviceWithIE ? 'auto' : (this.options.width || 'auto'))
				.css('height', isTouchDeviceWithIE ? 'auto' : (this.options.height || 'auto'))
				.addClass("ui-widget-content ui-corner-all")
				.appendTo(this.popover);
            if (this.id()) {
                cnt.attr('id', this.id() + "_popover_contentFrame");
            }
			if (this.options.headerTemplate !== null) {
				if (this.options.headerTemplate.closeButton) {
                    var closeBtn = $('<div></div>')
						.addClass(this.css.closeButtonClass)
						.bind('click.popover', $.proxy(this._closeBtnClick, this))
						.appendTo(cnt);
                    if (this.id()) {
                        closeBtn.attr('id', this.id() + "_popover_closeBtn");
				}
                }
				if (this.options.headerTemplate.title !== null) {
                    var title = $('<div></div>')
						.addClass(this.css.titleClass)
						.html(this.options.headerTemplate.title)
						.appendTo(cnt);
                    if (this.id()) {
                        title.attr('id', this.id() + "_popover_title");
				}
			}
            }
			// if there is a single target and a content set, the inner html is set to depend on them
			currContent = this.options.contentTemplate;
			if ((typeof currContent === "string" || !currContent) && this._target) {
				// the content is with priority over the title in case when target is set
				currContent = this.options.contentTemplate || this._target[0].title || "";
			} else if (this.options.selectors !== null && !this._target && !currContent) {
				// if no target and content are set, and the selectors is set than the title of the element will be displayed
				this.options.contentTemplate = function () { return $(this).attr('title'); };
			} else if (typeof currContent === "function" && this._target) {
				currContent = this.options.contentTemplate.call(this._target[0], function () { return; });
			}
			rightMargin = (this.options.headerTemplate.closeButton && (this.options.headerTemplate.title === null || this.options.headerTemplate.title === "")) ? $('.ui-icon').width() : null;
            this.contentInner = $('<div></div>')
				.css('position', 'relative')
				.css('margin-right', rightMargin)
				.html(currContent)
				.appendTo(cnt);
            if (this.id()) {
                this.contentInner.attr('id', this.id() + "_popover_contentInner");
            }
			$('<div></div>')
			  .css('clear', 'both')
			  .appendTo(cnt);
		},
		_updateArrowDiv: function (nDir, idx, trg) {
            var conDiv = this.contentInner.parent(),
				dims;
            if (!this.arrow) {
				// T.G 12 Dec 2013 Fix 159000 - Arrow is separated from the inner frame
                this.arrow = $('<div></div>')
					.addClass(this.css.arrowBaseClass + this._arrowDir[idx])
					.appendTo(this.popover);
                if (this.id()) {
                    this.arrow.attr('id', this.id() + "_popover_arrow");
                }
			} else {
                this.arrow
					.removeClass("ui-igpopover-arrow-left ui-igpopover-arrow-right ui-igpopover-arrow-bottom ui-igpopover-arrow-top")
					.addClass(this.css.arrowBaseClass + this._arrowDir[idx]);
			}
            dims = this._getHiddenElementsDimensions([this.arrow, conDiv], trg);
			// Arrow should be positioned according to target, not according to content div.
			// T.G 12 Dec 2013 Fix 159000 - Arrow is separated from the inner frame
			switch (nDir) {
				case "top":
					conDiv.css({
						'left': '',
						'top': dims[0].height * -1,
						'float': ''
					});
                    this.arrow.css({
						'left': '',
						'top': '',
						'float': ''
					});
					break;
				case "bottom":
					conDiv.css({
						'left': '',
						'top': dims[0].height,
						'float': ''
					});
                    this.arrow.css({
						'left': '',
						'top': '',
						'float': ''
					});
					break;
				case "left":
					conDiv.css({
						'left': dims[0].width * -1,
						'top': '',
						'float': 'left'
					});
                    this.arrow.css({
						'left': '',
						'top': '',
						'float': 'left'
					});
					break;
				case "right":
					conDiv.css({
						'left': dims[0].width,
						'top': '',
						'float': 'left'
					});
                    this.arrow.css({
						'left': '',
						'top': '',
						'float': 'left'
					});
					break;
			}
			this.oDir = nDir;
		},
		_targetMouseLeave: function () {
			this._hoveredTarget = null;
			if (this.options.closeOnBlur === true) {
				this._closePopover();
			}
		},
		_targetMouseMove: function (trg) {
			var self = this;
			// if target is set , it is with higher priority than the selectors
			if (this._target) {
				this._openPopover($(this._target));
			} else {
				// T.G. Bug 150520 - (fix) set timeout for the mouseenter event
				// T.G  15.10.2013 Bug 154985 - Popover doesn't hide when the group of elements are shown fast
				// T.P. & M.H. Bug 154985 Previous fix has regressed the case when target element has no id.
				$(trg.currentTarget).addClass('is-hover');
				setTimeout(function () {
					if (self._hoveredTarget === trg.currentTarget) {
						self._openPopover($(trg.currentTarget));
						$(trg.currentTarget).removeClass('is-hover');
					}
				}, self.options.animationDuration);
				this._hoveredTarget = trg.currentTarget;
			}
		},
		_targetClick: function (trg) {
			var t = this._target || trg.currentTarget;
			if ($(t).data('onFocus') && this.container().is(':visible')) {
				this._closePopover();
				$(t).data('onFocus', false);
			} else {
				this._openPopover($(t));
				$(t).focus();
				$(t).data('onFocus', true);
			}
		},
		_targetBlur: function (trg) {
			var t = this._target || trg.currentTarget,
				self = this;
			setTimeout(function () {
				if ($(t).data('onFocus')) {
					// T.G. 24 Jan 2014, Bug 162268 - Clicking elements in the popover closes it.
					if (self.options.closeOnBlur === true) {
						self._closePopover();
						$(t).data('onFocus', false);
					}
				} else {
					$(t).focus();
				}
			}, 10);
		},
		_focusin: function (trg) {
			var t = this._target || trg.currentTarget;
			this._openPopover($(t));
		},
		_focusout: function () {
            if (this.options.closeOnBlur === true) {
			this._closePopover();
            }
		},
		_closeBtnClick: function (event) {
			this._closePopover();
			event.stopPropagation();
		},
		_attachEventsToTarget: function () {
			var self = this, t = this._target,
				showEvt, hideEvt, targetShowEvt, targetHideEvt;
			if (this.options.showOn && this.options.showOn.match(/click|focus|mouseenter/)) {
				switch (this.options.showOn) {
					case "click":
						showEvt = 'click.popover';
						hideEvt = 'blur.popover';
						targetShowEvt = self._targetClick;
						targetHideEvt = self._targetBlur;
						break;
					case "focus":
						showEvt = 'focusin.popover';
						hideEvt = 'focusout.popover';
						targetShowEvt = self._focusin;
						targetHideEvt = self._focusout;
						break;
					case "mouseenter":
						showEvt = 'mouseenter.popover';
						hideEvt = 'mouseleave.popover';
						targetShowEvt = self._targetMouseMove;
						targetHideEvt = self._targetMouseLeave;
						break;
				}
			}
			// K.D. July 18th, 2012 Bug #117374 The HTMLElement object is natively not defined in IE <= 8
			// Abstain from referring to "natively" defined objects as we're not sure in what cases they would
			// actually be undefined. Add to check if is jQuery object
			// D.K. checking the node type of the element as an alternative of "instanceof HTMLElement" for IE8
			// nodeType === 1 represents an elements
			if (t && ((window.HTMLElement !== undefined && (t instanceof HTMLElement || t instanceof jQuery) && showEvt) ||
				(typeof t[0] === "object") && (t[0].nodeType === 1) &&
				(typeof t[0].style === "object") && (typeof t[0].ownerDocument === "object"))) {
				$(t).unbind(showEvt).bind(showEvt, $.proxy(targetShowEvt, this));
				$(t).unbind(hideEvt).bind(hideEvt, $.proxy(targetHideEvt, this));
			} else if (this.options.selectors && showEvt) {
				this.element.find(self.options.selectors).addBack().each(function () {
					var target = $(this)[0];
					// verify that no popover should be shown for the original div
					if (target === self.element[0]) {
						return;
					}
					$(target).unbind(showEvt).bind(showEvt, $.proxy(targetShowEvt, self));
					$(target).unbind(hideEvt).bind(hideEvt, $.proxy(targetHideEvt, self));
				});
			}
		},
		_detachEventsFromTarget: function () {
			// T.G Sep 23th, 2013 Bug #152943 destroy of igPopover
			var t = this._target, self = this;
			// K.D. July 18th, 2012 Bug #117374 The HTMLElement object is natively not defined in IE <= 8
			// Abstain from referring to "natively" defined objects as we're not sure in what cases they would
			// actually be undefined. Add to check if is jQuery object
			// D.K. checking the node type of the element as an alternative of "instanceof HTMLElement" for IE8
			// nodeType === 1 represents an elements
			if (t && ((window.HTMLElement !== undefined && (t instanceof HTMLElement || t instanceof jQuery)) ||
				(typeof t[0] === "object") && (t[0].nodeType === 1) &&
				(typeof t[0].style === "object") && (typeof t[0].ownerDocument === "object"))) {
				$(t).unbind('.popover');
			} else if (this.options.selectors) {
				this.element.find(self.options.selectors).addBack().each(function () {
					var target = $(this);
					$(target).unbind('.popover');
				});
			}
		},
		_positionPopover: function (trg) {
			var i = 0, fn, fnRes;
			if (this.options.direction === "auto") {
				do {
					this._updateArrowDiv(this._priorityDir[i], i, trg);
					fn = "_" + this._priorityDir[i] + "Position";
					fnRes = this[fn](trg);
					i++;
				} while (fnRes === false && i < this._priorityDir.length);
				if (fnRes === false) {
					// "Couldn't find space anywhere. Please exceed screen dimensions"
					return;
				}
			} else {
				this._updateArrowDiv(this.options.direction, this._directionIndex, trg);
				fn = "_" + this.options.direction + "Position";
				if (!this[fn](trg)) {
					//&& (this.options.selectors || !this._target)
					//trying to find a place on the screen if there is no space to show with the position set
					this._forced = true;
					do {
						this._updateArrowDiv(this._priorityDir[i], i, trg);
						fn = "_" + this._priorityDir[i] + "Position";
						fnRes = this[fn](trg);
						i++;
					} while (fnRes === false && i < this._priorityDir.length);
					return;
				}
			}
		},
		_findProperPosition: function (dir, x, trg) {
			var fnRes, y, cDim, cPos, win = $(window),
				trgFDim, wScroll, boundary, countainmentBoundary, leftOffset,
				$containment, oParent = trg.offsetParent(), useParentOffset = false,
				rightOffset = trg.offset().left + trg.outerWidth(),
				parentRightOffset = oParent.offset().left + oParent.outerWidth();
			if (dir === "left") {
				cPos = "left";
				cDim = "outerWidth";
				wScroll = win.scrollLeft();
			} else {
				cPos = "top";
				cDim = "outerHeight";
				wScroll = win.scrollTop();
			}
			boundary = wScroll + (cDim === "outerWidth" ?
				win.width() : win.height());
			$containment = this.options.containment;
			if (this.options.containment) {
				countainmentBoundary = $containment.offset()[cPos];
				if (cDim === "outerWidth") {
					countainmentBoundary = countainmentBoundary + $containment.outerWidth();
				} else {
					countainmentBoundary = countainmentBoundary + $containment.outerHeight();
				}
				if (boundary > countainmentBoundary) {
					boundary = countainmentBoundary;
				}
			}
			// target element is not fully visible on the screen along the axis we need
			if (trg.offset()[cPos] + trg[cDim]() > boundary) {
				// we use a redux value to not create the popover outside the screen borders
				trgFDim = boundary - trg.offset()[cPos];
			} else if (cPos === "left" && trg.offset()[cPos] < oParent.offset()[cPos] && rightOffset > parentRightOffset) {
				//Fix for bug #189918 - Tooltip does not show at the correct position after some of the columns are fixed
				//both sides of the target are not visible, take parent dimensions
				trgFDim = oParent[cDim]();
				useParentOffset = true;
			} else if (cPos === "left" && trg.offset()[cPos] < parentRightOffset && rightOffset > parentRightOffset) {
				//Fix for bug #186400 - When only small part of the column is shown and style visibility is popover the tooltip does not show visible part of the cell
				//Change calculation for target final dimensions when target is partially visible
				//only right side is not visible
				trgFDim = parentRightOffset - trg.offset()[cPos];
			} else if (cPos === "left" && trg.offset()[cPos] < oParent.offset()[cPos] && oParent.offset()[cPos] < rightOffset) {
				//only left side is not visible
				trgFDim = rightOffset - oParent.offset()[cPos];
				useParentOffset = true;
			} else {
				trgFDim = trg[cDim]();
			}
			if (trgFDim > this.popover[cDim]()) {
				// if the popover is smaller on the side we want to position
				// it should always get in the middle of the visible area
				leftOffset = useParentOffset ? oParent.offset()[cPos] : trg.offset()[cPos];
				y = leftOffset + trgFDim / 2 - this.popover[cDim]() / 2;
				fnRes = dir === "left" ? this._checkCollision(x, y, trg) : this._checkCollision(y, x, trg);
			} else {
				fnRes = this._cyclePossiblePositions(trg, dir, cPos, cDim, trgFDim, useParentOffset, x);
			}
			// if the popover did't fit, try position it using as borders the whole page
			if (fnRes === false && !this.options.containment) {
				fnRes = this._cyclePossiblePositions(trg, dir, cPos, cDim, trgFDim, useParentOffset, x, true);
			}

			if (fnRes === true) {
				this._adjustArrowPosition(trg, dir, cPos, cDim, trgFDim, useParentOffset);
			}
			return fnRes;
		},
		_cyclePossiblePositions: function (trg, dir, cPos, cDim, trgFDim, useParentOffset, x, useDocument) {
			var i = 0, y, tPos, fnRes;
				// rotate between possible positions until the popover fits or it's clear it won't fit
				if (this.options.position === "auto") {
					do {
						tPos = this._positions[i];
						y = this._getCounterPosition(trg, trgFDim, tPos, cPos, cDim, useParentOffset);
					fnRes = dir === "left" ? this._checkCollision(x, y, trg, useDocument) : this._checkCollision(y, x, trg, useDocument);
					} while (fnRes === false && ++i < this._positions.length);
				} else {
					y = this._getCounterPosition(trg, trgFDim, this.options.position, cPos, cDim, useParentOffset);
				fnRes = dir === "left" ? this._checkCollision(x, y, trg, useDocument) : this._checkCollision(y, x, trg, useDocument);
			}
			return fnRes;
		},
		_getCounterPosition: function (trg, trgFDim, tPos, cPos, cDim, useParentOffset) {
			var y,
				offset = useParentOffset ? trg.offsetParent().offset()[cPos] : trg.offset()[cPos];
			switch (tPos) {
				case "balanced":
					y = offset + trgFDim / 2 - this.popover[cDim]() / 2;
					break;
				case "start":
					y = offset;
					break;
				case "end":
					y = offset - this.popover[cDim]() + trgFDim;
					break;
			}
			return y;
		},
		_topPosition: function (trg) {
			var top = trg.offset().top - this.popover.outerHeight(),
				parentTop = trg.offsetParent().offset().top - this.popover.outerHeight();
			//Fix for bug 185813 - Popover tooltip appears on the bottom of the cell even if the bottom part is hidden because of the grid's height.
			//If there are scrollbars offsetParent of the target should be smaller than the actual target
			if (top < parentTop) {
				top = parentTop;
			}
			// finds are proper left position for the popover if one exists
			return this._findProperPosition("left", top, trg);
		},
		_bottomPosition: function (trg) {
			var bottom = trg.offset().top + trg.outerHeight(),
			parentBottom = trg.offsetParent().offset().top + trg.offsetParent().outerHeight();
			//Fix for bug 185813 - Popover tooltip appears on the bottom of the cell even if the bottom part is hidden because of the grid's height.
			//If there are scrollbars offsetParent of the target should be smaller than the actual target
			if (bottom > parentBottom) {
				bottom = parentBottom;
			}
			return this._findProperPosition("left", bottom, trg);
		},
		_leftPosition: function (trg) {
			var left = trg.offset().left - this.popover.outerWidth(),
				parentLeft = trg.offsetParent().offset().left - this.popover.outerWidth();
			if (left < parentLeft) {
				left = parentLeft;
			}
			return this._findProperPosition("top", left, trg);
		},
		_rightPosition: function (trg) {
			var right = trg.offset().left + trg.outerWidth(),
				parentRight = trg.offsetParent().offset().right + trg.outerWidth();
			if (right > parentRight) {
				right = parentRight;
			}
			return this._findProperPosition("top", right, trg);
		},
		_checkCollision: function (top, left, trg, useDocument) {
			var tfullw = this.popover.outerWidth(),
				tfullh = this.popover.outerHeight(),
				win = $(window), wh, ww, os,
				$containment, rightBoundary, bottomBoundary, leftBoundary, topBoundary;
			ww = win.width() + win.scrollLeft();
			wh = win.height() + win.scrollTop();
			// M.H. 26 Sep 2013 Fix for bug #151629: The feature chooser for the last column is not rendered correctly on a mobile device.
			rightBoundary = ww;
			bottomBoundary = wh;
			leftBoundary = win.scrollLeft();
			topBoundary = win.scrollTop();
			$containment = this.options.containment;
			if (this.options.containment) {
				if (leftBoundary < $containment.offset().left) {
					leftBoundary = $containment.offset().left;
				}
				if ($containment.offset().left + $containment.outerWidth() < rightBoundary) {
					rightBoundary = $containment.offset().left + $containment.outerWidth();
				}
				if (bottomBoundary > $containment.offset().top + $containment.outerHeight()) {
					bottomBoundary = $containment.offset().top + $containment.outerHeight();
				}
				if (topBoundary < $containment.offset().top) {
					topBoundary = $containment.offset().top;
				}
			}
			if (useDocument) {
				leftBoundary = 0;
				rightBoundary = $(document).width();
				bottomBoundary = $(document).height();
				topBoundary = 0;
			}
			if (left < leftBoundary) {
				if (this.oDir === "left") {
					return false;
				}
				left = leftBoundary;
			}
			//D.K. 7 Apr 2015 Fix for bug #190611: When direction is right and mouse over the last column popover is shown to the cell on the left
			//When the direction is right, don't recalculate 'left', show it even if it is in the invisible area
			if (trg.offset().left + (tfullw / 2) > rightBoundary && this.options.direction !== "right") {
				left = rightBoundary - tfullw;
			}
            if (((trg.offset().top + tfullh + this.arrow.height() > bottomBoundary) && (this.oDir === "bottom")) ||
						((trg.offset().top - tfullh - this.arrow.height() < topBoundary) && (this.oDir === "top"))) {
				if (this.options.selectors) {
					return false;
				}
			}
			if (left < leftBoundary || left + tfullw > rightBoundary || top < topBoundary || top + tfullh > bottomBoundary) {
				//D.K. 16 Dec 2014 Fix 186350 - Popover tooltip appears below the grid even when there's not enough space on the page
				//if it is forced we can ignore collisions, otherwise they should be taken into account
				if (this._forced === false) {
					//  T.G. 29 Jan 2014 Fix 162164- When the element is relative in scrollable container the popover does not change its position when you scroll the container.
					return false;
				}
				// T.G. 7 Mar 2014 Fix 162110 - The popover does not change its position if there is no room on the left or right.
				//return false;
			}
			if (!$(this.options.appendTo).is("body") && this._target) {
				os = $.ig.util.getRelativeOffset(this.popover);
				top = top - os.top;
				left = left - os.left;
			}
			this.popover.css({
				'top': top,
				'left': left
			});
			return true;
		},
		_getPrioritiesIndex: function () {
			var i;
			if (this.options.direction !== "auto") {
				for (i = 0; i < this._priorityDir.length; i++) {
					if (this.options.direction === this._priorityDir[i]) {
						this._directionIndex = i;
						break;
					}
				}
			}
			if (this.options.position !== "auto") {
				for (i = 0; i < this._positions.length; i++) {
					if (this.options.position === this._positions[i]) {
						this._positionIndex = i;
						break;
					}
				}
			}
		},
		_openPopover: function (trg) {
			var args, noCancel, val = this.getContent(), self = this, contentFunc;
			args = {
				element: trg,
				content: val,
				popover: this.popover,
				owner: this
			};
			$(this.popover).data('isAnimating', true);
			noCancel = this._trigger(this.events.showing, this, args);
			if (noCancel === true) {
				self._restoreOriginalTitle(self._currentTarget);
				if (args.content !== val) {
					this._setNewContent(args.content);
				} else if (typeof this.options.contentTemplate === "function") {
					contentFunc = this.options.contentTemplate;
					args.content = contentFunc.call(trg[0], function () { return; });
					this._setNewContent(args.content || "");
				}
				this._positionPopover(trg);
				this._currentTarget = trg;
				$(this.popover).data('isAnimating', false);
                this.popover.stop(true, true).fadeIn(this.options.animationDuration, function () {
					self._trigger(self.events.shown, self, args);
				});
                this._visible = true;
				this._removeOriginalTitle(trg);
			}
		},
		_closePopover: function () {
			var args, noCancel, self = this;
			args = {
				element: this._currentTarget,
				content: this.getContent(),
				popover: this.popover,
				owner: this
			};
			$(this.popover).data('isAnimating', true);
			noCancel = this._trigger(this.events.hiding, this, args);
			if (noCancel === true) {
				$(this.popover).data('isAnimating', false);
                this.popover.stop(true, true).fadeOut(this.options.animationDuration, function () {
					self._trigger(self.events.hidden, self, args);
				});
                this._visible = false;
			}
		},
		_mouseenter: function (e) {
			this._removeOriginalTitle($(e._currentTarget));
		},
		_removeOriginalTitle: function (element) {
			while (element.length && !element.is("body")) {
				// if we have a title, clear it to prevent the native tooltip
				if (element.attr("title")) {
					element.data("popover-title", element.attr("title"));
					element.attr("title", "");
				}
				element = element.parent();
			}
		},
		_restoreOriginalTitle: function (element) {
			if (element && element.data("popover-title")) {
				element.attr("title", element.data("popover-title"));
				element.removeData("popover-title");
			}
		},
		_adjustArrowPosition: function (trg, dir, cPos, cDim, trgFDim, useParentOffset) {
            var offset = { left: 0, top: 0 }, left,
				leftOffset = useParentOffset ? trg.offsetParent().offset()[cPos] : trg.offset()[cPos];
            if (!$(this.options.appendTo).is("body") && this._target) {
				offset = $.ig.util.getRelativeOffset(this.popover);
			}
			if (dir === "top") {
                this.arrow.css({
                    "top": (trg.offset()[cPos] - parseInt(this.popover.css(cPos), 10) - offset.top) + (trgFDim / 2) - (this.arrow.height() / 2)
				});
			} else {
				//if (trgFDim < this.popover[cDim]()) {
				// T.G., 28 Jan 2014, Fix bug 162181 - The arrow does not stay in the containment element when the container is scrolled.
				left = (leftOffset - parseInt(this.popover.css(cPos), 10) - offset.left) + (trgFDim / 2);
                left = (left < parseInt(this.arrow.css("border-left-width"), 10)) ? parseInt(this.arrow.css("border-left-width"), 10) : left;
                this.arrow.css({
					// T.G., 18 June 2014, Fix bug 158915 - If igGrid is scrolled on the right the popover tooltip is misaligned and the arrow is not positioned correctly
					// T.G., 18 June 2014, Fix bug 166644 - The arrow and the container are displayed separately when the target is larger than the browser window and scroll is available
					"left": left
				});
				//}
			}
		},
		_getHiddenElementsDimensions: function (elArr, trg) {
            var dim = [], i, elem;
			//when don't have containment it popover should be positioned where it's target is,
			//this is done mainly for the scenarios with horizontal scrollbar
			if (this.options.containment === null) {
                this.popover.css("left", trg.position().left);
                this.popover.css("top", trg.position().top);
            }
            if (!this._visible) {
                this.popover.show();
			}
			for (i = 0; i < elArr.length; i++) {
				elem = elArr[i];
				dim.push({
					width: elem.outerWidth(),
					height: elem.outerHeight()
				});
			}
            if (!this._visible) {
                this.popover.hide();
            }
			return dim;
		},
		_setNewContent: function (nc) {
			var newContent = nc;
			if (nc instanceof jQuery) {
				newContent = nc.html();
			} else if (typeof nc === "object") {
				newContent = nc.innerHTML;
			}
            this.contentInner.html(newContent);
		},
		_isTouchDevice: function () {
             return (('ontouchstart' in window)
                  || (navigator.MaxTouchPoints > 0)
                  || (navigator.msMaxTouchPoints > 0));
        }
	});
	// support: jQuery <1.8
	if (!$.fn.addBack) {
		$.fn.addBack = function (selector) {
			return this.add((selector === null || selector === undefined) ?
				this.prevObject : this.prevObject.filter(selector)
			);
		};
	}
	$.extend($.ui.igPopover, {
	    version: '15.2.20152.1033'
	});
}(jQuery));

/*!@license
* Infragistics.Web.ClientUI jQuery Notifier 15.2.20152.1033
*
* Copyright (c) 2013-2015 Infragistics Inc.
*
* http://www.infragistics.com/
*
* Depends on:
*  jquery-1.4.2.js
*  jquery.ui.core.js
*  jquery.ui.widget.js
*  infragistics.util.js
*  infragistics.ui.popover.js
*/
/*global jQuery */
if (typeof jQuery !== "function") {
	throw new Error("jQuery is undefined");
}

(function ($) {
	$.widget("ui.igNotifier", $.ui.igPopover, {
		css: {
			/* classes applied to the main popover container */
			baseClasses: "ui-widget ui-igpopover ui-ignotify",
			/* classe applied to the inner notification container */
			contentInner: "ui-ignotify-content",
			/* class applied to the main container for inline notifications */
			inline: "ui-ignotify-inline",
			/* classes applied to the main popover container and target with information state */
			infoState: "ui-ignotify-info",
			/* jQuery UI Icon class for information state */
			infoIcon: "ui-icon ui-icon-info",
			/* classes applied to the main popover container and target with success state */
			successState: "ui-ignotify-success",
			/* jQuery UI Icon class for success state */
			successIcon: "ui-icon ui-icon-circle-check",
			/* classes applied to the main popover container and target with warning state */
			warningState: "ui-ignotify-warn",
			/* jQuery UI Icon class for success state */
			warningIcon: "ui-icon ui-icon-alert",
			/* classes applied to the main popover container and target with error state */
			errorState: "ui-ignotify-error",
			/* jQuery UI Icon class for error state */
			errorIcon: "ui-icon ui-icon-circle-close"
		},
		options: {
		    /* type="success|info|warning|error" Gets or sets the current state of the igNotifier messages. State controls what CSS classes are applied to the messages and target and has interactions with other options as well.
                success type="string" Messages and target CSS have success styles applied.
                info type="string" Messages have info applied. Target is unaffected.
                warning type="string" Messages and target CSS have warning styles applied.
                error type="string" Messages and target CSS have error styles applied.
            */
			state: "info",
			/* type="success|info|warning|error" Controls the level of notifications shown by automatic and manual messages using the notify() method. Use show() to ignore the level.
                success type="string" Show all types of messages
                info type="string" Show everything from info level messages up
                warning type="string" Show everything from warning level messages up
                error type="string" Show only error messages
            */
			notifyLevel: "success",
			/* type="string|object" Controls where the popover DOM should be attached to (only applies to popovers).
                string type="string" A valid jQuery selector for the element
                object type="object" A reference to the parent jQuery object
            */
			appendTo: "body",
		    /* type="auto|popover|inline" Controls the positioning mode of messages. Setting a mode will override the default behavior which is auto.
                Note: Inline element uses a block container as is always placed after the target
                auto type="string" Uses popover for info and warning messages and inline for errors and success.
                popover type="string" Displays messages in a configurable popover. 
                inline type="string" Displays messages in a simplified notification text under the target.
            */
			mode: "auto",
			/* type="bool" Allows setting the respective state CSS on the target element (used to apply border color by default) */
			allowCSSOnTarget: true,
			/* type="object" A set of default messages for each state */
			messages: {
				success: "Success",
				info: "",
				warning: "Warning",
				error:  "Error"
			},
		    /* type="bool" Allows rendering a span with the respective state CSS to display jQuery UI framework icons */
            showIcon: false,
			/* type="string|function" Sets the content for the popover container. Templated with two parameters by default: {0} - the icon class and {1} - message text.
                string   String content of the popover container
                function Function which is a callback that can either return the content directly, or call the first argument, passing in the content
            */
            contentTemplate: "<span class='ui-ignotify-icon-container'><span class='{0}'></span></span>{1}",
			/* type="object" sets the content for the popover header */
			headerTemplate: {
				/* type="bool" controls whether the popover renders a functional close button */
				closeButton: true,
				/* type="string" sets the content for the popover header. Must be null as the notifier does not support titles. */
				title: null
			},
			/* type="mouseenter|click|focus|manual" sets the event on which the notification will be shown. Predefined values are "mouseenter", "click" and "focus"
				mouseenter   type="string" the popover is shown on mouse enter in the target element
				click		type="string" the popover is shown on click on the target element
				focus		type="string" the popover is shown on focusing the target element
				manual	   type="string" the popover is shown manually
			*/
			showOn: "manual",
		    /* type="number" Gets or sets the time in milliseconds the notification fades in and out when showing/hiding */
			animationDuration: 250,
		    /* Gets or sets the distance in pixels a notification popover slides outwards as it's shown. */
			animationSlideDistance: 5
		},
        /* States that appear as inline in auto mode */
		inlineStates: ["success", "error"],
		_create: function () {
		    $.ui.igPopover.prototype._create.apply(this, arguments);
		    // D.P. Override position prio to top > bottom
			this._priorityDir = ["top", "left", "right", "bottom"];
			this._arrowDir = ["bottom", "right", "left", "top"];

			this._states = ["success", "info", "warning", "error"];
			this._modes = ["auto", "popover", "inline"];
			this._currentText = this.options.messages[this.options.state];
		},
		_createWidget: function (options/*, element*/) {
		    // ensure localized defaults
		    var messageDefaults = {
		        success: $.ig.Notifier && $.ig.Notifier.locale ? $.ig.Notifier.locale.successMsg : "Success",
		        info: "",
		        warning: $.ig.Notifier && $.ig.Notifier.locale ? $.ig.Notifier.locale.warningMsg : "Warning",
		        error: $.ig.Notifier && $.ig.Notifier.locale ? $.ig.Notifier.locale.errorMsg : "Error"
		    };
		    this.options.messages = $.extend(messageDefaults, (options && options.messages) || {});
		    $.ui.igPopover.prototype._createWidget.apply(this, arguments);
		},
		_setState: function (value, message/*, fireEvents*/) {
			if ($.inArray(value, this._states) === -1) {
				console.log("Supported states: " + this._states.join(", "));
				return;
			}
			//TODO:
			/*var args, noCancel, val = this.getContent(), self = this, contentFunc;
			args = {
				newState: value,
				oldState: this._previousState,
				element: trg,
				content: val,
				popover: this.popover,
				owner: this
			};
			noCancel = this._trigger(this.events.stateChanging, this, args);
			if (noCancel === true) {*/
			if (message !== undefined) {
				// must be able to handle text change without state
				this._currentText = message;
			}
			if (this.options.state !== value) {
				this._currentText = message !== undefined ? this._currentText : this.options.messages[value];
				this._previousState = this.options.state;
				this.options.state = value;
				if (this._visible) {
					// refresh target if visible (oherwise managed in open/close)
					this._setTargetState();
				}
				if (this._isInline(value) !== this._isInline(this._previousState)) {
					// force mode switch + rerender
					this._setMode(this.options.mode, true);
					return;
				}
			}
			this.popover
                .removeClass(this.css[this._previousState + "State"])
                .addClass(this.css[this.options.state + "State"]);
			this._setNewContent(this.options.contentTemplate);
			/*
				this._trigger(this.events.stateChanged, this, args);
			}*/
		},
		_setTargetState: function (clean) {
			//TODO: _target is null with selectors?
			this._target
				.removeClass(this.css[this._previousState + "State"])
				.removeClass(this.css[this.options.state + "State"]);
			if (this.options.allowCSSOnTarget && !clean) {
				this._target
				   .addClass(this.css[this.options.state + "State"]);
			}
		},
		_setOption: function (key, value) {
			switch (key) {
				case "state":
					this._setState(value);
					if (this._visible && !this._isInline()) {
					    this._positionPopover(this._target);
					    this._slide();
					}
					break;
				case "mode":
					if (typeof value === "string") {
						this._setMode(value);
					}
					break;
				case "contentTemplate":
					if (typeof value === "string") {
						this.options.contentTemplate = value;
						this._setNewContent(this.options.contentTemplate);
					}
					break;
				case "messages":
					if (typeof value === "object") {
						this.options.messages = $.extend(this.options.messages, value);
						this._currentText = this.options.messages[this.options.state];
						this._setNewContent(this.options.contentTemplate);
						if (this._visible && !this._isInline()) {
						    this._positionPopover(this._target);
						    this._slide();
						}
					}
					break;
				case "allowCSSOnTarget":
					this.options.allowCSSOnTarget = typeof value === "boolean" ? value : this.options.allowCSSOnTarget;
					if (this._visible) {
						this._setTargetState(!value);
					}
					break;
			    case "showIcon":
			        this.options.showIcon = value;
			        if (this._visible) {
			            this._setNewContent(this.options.contentTemplate);
			        }
			        break;
			}
			$.ui.igPopover.prototype._setOption.apply(this, arguments);
		},
		_setMode: function (value, force) {
			if ($.inArray(value, this._modes) === -1) {
				console.log("Supported modes: " + this._modes.join(", "));
				return;
			}
			if (this.options.mode !== value || force) {
				// cleanup current popover
				this.popover.remove();
				delete this.arrow;
				this.options.mode = value;
				this._renderPopover();
				if (this._visible) {
					// partial open:
					if (!this._isInline()) {
						this._positionPopover(this._target);
					}
					this.popover.show();
					this._slide();
				}
			}
		},
		_isInline: function (state) {
			var target = state || this.options.state;
			if (this.options.mode === "inline") {
				return true;
			} else {
				return this.options.mode === "auto" && $.inArray(target, this.inlineStates) > -1;
			}
		},
		notify: function (state, message) {
		    /* Triggers a notification with a certain state and optional message. The notifyLevel option determines if the notification will be displayed.
			  paramType="success|info|warning|error" optional="false" The state to show notification for.
			  paramType="string" optional="true" Optional message to show, overides defaults.
		   */
		    if ($.inArray(state, this._states) >= $.inArray(this.options.notifyLevel, this._states)) {
                // skip notify with same state/message if already visible
		        if (!this._visible || this.options.state !== state || this._currentText !== message) {
		            this._setState(state, message);
		            this.show();
		        }
		    } else {
		        this.hide();
		        this._setState(state, message);
		    }
		},
		isVisible: function () {
			/* Returns true if the notfication is currently visible */
			return this._visible;
		},
		_renderPopover: function () {
			if (this._isInline()) {
				this.popover = $('<div></div>').addClass(this.css.baseClasses).addClass(this.css.inline);
				this.contentInner = $('<div></div>').appendTo(this.popover);
				this.popover.insertAfter(this._target);
				this._attachEventsToTarget();
			} else {
			    $.ui.igPopover.prototype._renderPopover.apply(this, arguments);
				//this.popover.appendTo(this.options.appendTo);
			}

			this._setState(this.options.state);
			this.contentInner.addClass(this.css.contentInner);
		},
		_openPopover: function (/*trg*/) {
		    var initialState = this._visible;
		    // force false flag to check if _super really showed content
		    this._visible = false;
		    $.ui.igPopover.prototype._openPopover.apply(this, arguments);
		    if (this._visible) {
		        var change = this._visible !== initialState;
		        // extra animation must be called outside of _positionPopover after _openPopover base animation cancels
		        this._slide(!change);
		        if (change) {
		            // set target CSS when showing
		            this._setTargetState();
		        }
		    } else {
		        // restore flag if show was canceled:
		        this._visible = initialState;
		    }
		},
		_slide: function (quick) {
		    if (!this.options.animationSlideDistance || !this.oDir || this._isInline()) {
		        return;
		    }
		    //simultaneous slide animation,
		    var slideAnimation;
		    switch (this.oDir) {
		        case "top":
		            slideAnimation = { "top": "-=" + this.options.animationSlideDistance + "px" };
		            break;
		        case "bottom":
		            slideAnimation = { "top": "+=" + this.options.animationSlideDistance + "px" };
		            break;
		        case "left":
		            slideAnimation = { "left": "-=" + this.options.animationSlideDistance + "px" };
		            break;
		        case "right":
		            slideAnimation = { "left": "+=" + this.options.animationSlideDistance + "px" };
		            break;
		    }
		    this.popover.animate(slideAnimation, { queue: false, duration: quick ? 0 : this.options.animationDuration });
		},
		_attachEventsToTarget: function () {
		    if (this.options.showOn !== "manual") {
		        $.ui.igPopover.prototype._attachEventsToTarget.apply(this, arguments);
			}
		},
		_closePopover: function () {
		    var initialState = this._visible;
		    $.ui.igPopover.prototype._closePopover.apply(this, arguments);
			if (!this._visible && this._visible !== initialState) {
				// clean target CSS when hiding
				this._setTargetState(true);
			}
		},
		_positionPopover: function (/*trg*/) {
		    if (!this._isInline()) {
		        $.ui.igPopover.prototype._positionPopover.apply(this, arguments);
			}
		},
		_setNewContent: function (nc) {
			var newContent = nc;
			if (nc instanceof jQuery) {
				newContent = nc.html();
			} else if (typeof nc === "object") {
				newContent = nc.innerHTML;
			}
			newContent = newContent.replace("{0}", this.options.showIcon ? this.css[this.options.state + "Icon"] : "").replace("{1}", this._currentText);
			this.contentInner.html(newContent);
		},
		destroy: function () {
		    this._setTargetState(true);
		    $.ui.igPopover.prototype.destroy.apply(this, arguments);
			return this;
		}
	});
	$.extend($.ui.igNotifier, { version: '15.2.20152.1033' });
}(jQuery));

/*!@license
 * Infragistics.Web.ClientUI CountDown 15.2.20152.1033
 *
 * Copyright (c) 2011-2015 Infragistics Inc.
 *
 * http://www.infragistics.com/
 *
 * Depends on:
 *  jquery-1.9.1.js
 *	jquery.ui-1.9.0.js
 *	infragistics.util.js
 *	infragistics.ui.popover.js
 *	infragistics.ui.notifier.js
 */

/*global jQuery */
if (typeof jQuery !== "function") {
	throw new Error("jQuery is undefined");
}

(function ($) {
    /*
		igBaseEditor is a widget based on jQuery UI.
        
	*/
    $.widget('ui.igBaseEditor', {

        options: {
        	/* type="string|number|null Gets sets how the width of the control can be set."
                string The widget width can be set in pixels (px) and percentage (%).
                number The widget width can be set as a number in pixels.
                null type="object" will stretch to fit data, if no other widths are defined.
            */
        	width: null,
        	/* type="string|number|null Gets sets how the height of the control can be set."
                string The height can be set in pixels (px) and percentage (%).
                number The height can be set as a number in pixels.
                null type="object" will fit the editor inside its parent container, if no other heights are defined.
            */
        	height: null,
        	/* type="object" Gets sets value in editor. The effect of setting/getting that option depends on type of editor and on dataMode options. That can be string, number or Date depending on type of editor. If it is used on initialization and the type option is missing, then if 'value' is Number, then 'numeric' editor is created automatically and if 'value' is Date, then the 'date' editor is created. */
        	value: null,
        	/* type="number" Gets sets value in tabIndex for editor.  */
        	tabIndex: null,
        	/* type="bool" Sets gets ability to prevent null value.
				If that option is false, and editor has no value, then value is set to an empty string.
			*/
        	allowNullValue: false,
        	/* type="string|number|null" Sets gets the representation of null value. In case of default the value for the input is set to null, which makes the input to hold an empty string */
        	nullValue: null,
        	/* type="string" Sets the name attribute of the value input. This input is used to sent the value to the server. In case the target element is input and it has name attribute, but the developer has set the inputName option, so this option overwrites the value input and removes the attribute from the element. */
        	inputName: null,
        	/* type="bool" Sets the readonly attribute.Does not allow editing. Disables all the buttons and iteracitons applied. On submit the current value is sent into the request.*/
        	readOnly: false,
			/* type="bool" Sets the disabled attribute.Does not allow editing. Disables all the buttons and iteracitons applied. On submit the current value is not sent into the request*/
        	disabled: false,
            /* type="object" Sets gets options supported by the igValidator widget.
				Note: Validation rules of igValidator, such as min and max value/length are applied separately triggering errors, 
                while similar options of the editor work to prevent wrong values from being entered. 
            */
        	validatorOptions: null
        },
        css: {
            /* Class applied to the main/top element. Default value is 'ui-igedit-input' */
        	editor: 'ui-igedit-input',
            /* Class applied to the top element when editor is rendered in container. Default value is 'ui-igedit ui-igedit-container ui-widget ui-corner-all ui-state-default' */
        	container: 'ui-igedit ui-igedit-container ui-widget ui-corner-all ui-state-default',
        	/* Class applied to the top element when editor is hovered. Default value is 'ui-state-hover' */
        	hover: "ui-state-hover",
        	/* Class applied to the top element when editor is active. Default value is 'ui-state-active' */
        	active: "ui-state-active",
            /* Class applied to the top element when editor is on focus. Default value is 'ui-state-focus' */
        	focus: "ui-state-focus",
        	/* Classes applied to the editing element in disabled state. Default value is 'ui-igedit-disabled ui-state-disabled' */
        	disabled: 'ui-state-disabled'
        },
		events: {
			/* igWidget events go here */
			/* cancel="false" Event which is raised before rendering of the editor completes.
				Function takes arguments evt and ui.
				Use ui.owner to get a reference to the editor performing rendering.
				Use ui.element to get a reference to the editor element.
			*/
			rendering: "rendering",
			/* cancel="false" Event which is raised after rendering of the editor completes.
				Function takes arguments evt and ui.
				Use ui.owner to get a reference to the editor performing rendering.
				Use ui.element to get a reference to the editor element.
			*/
			rendered: "rendered",
			/* Event which is raised on mousedown at any part of editor including drop-down list.
				Function takes arguments evt and ui.
				Use evt.originalEvent to obtain reference to event of browser.
				Use ui.owner to obtain reference to igEditor.
				Use ui.elementType to obtain type of html element under mouse, such as field, button, spinUpper, spinLower or item#.
				Use ui.id and ui.elementType to obtain flag which represents html element under mouse. */
			mousedown: "mousedown",
			/* Event which is raised on mouseup at any part of editor including drop-down list.
				Function takes arguments evt and ui.
				Use evt.originalEvent to obtain reference to event of browser.
				Use ui.owner to obtain reference to igEditor.
				Use ui.elementType to obtain type of html element under mouse, such as field, button, spinUpper, spinLower or item#.
				Use ui.id and ui.elementType to obtain flag which represents html element under mouse. */
			mouseup: "mouseup",
			/* Event which is raised on mousemove at any part of editor including drop-down list.
				Function takes arguments evt and ui.
				Use evt.originalEvent to obtain reference to event of browser.
				Use ui.owner to obtain reference to igEditor.
				Use ui.elementType to obtain type of html element under mouse, such as field, button, spinUpper, spinLower or item#.
				Use ui.id and ui.elementType to obtain flag which represents html element under mouse. */
			mousemove: "mousemove",
			/* Event which is raised on mouseover at any part of editor including drop-down list.
				Function takes arguments evt and ui.
				Use evt.originalEvent to obtain reference to event of browser.
				Use ui.owner to obtain reference to igEditor.
				Use ui.elementType to obtain type of html element under mouse, such as field, button, spinUpper, spinLower or item#.
				Use ui.id and ui.elementType to obtain flag which represents html element under mouse. */
			mouseover: "mouseover",
			/* Event which is raised on mouseleave at any part of editor including drop-down list.
				Function takes arguments evt and ui.
				Use evt.originalEvent to obtain reference to event of browser.
				Use ui.owner to obtain reference to igEditor.
				Use ui.elementType to obtain type of html element under mouse, such as field, button, spinUpper, spinLower or item#.
				Use ui.id and ui.elementType to obtain flag which represents html element under mouse. */
			mouseout: "mouseout",
			/* Event which is raised when input field of editor loses focus.
				Function takes argument evt.
				Use ui.owner to obtain reference to igEditor.
				Use evt.originalEvent to obtain reference to event of browser. */
			blur: "blur",
			/* Event which is raised when input field of editor gets focus.
				Function takes argument evt.
				Use ui.owner to obtain reference to igEditor.
				Use evt.originalEvent to obtain reference to event of browser. */
			focus: "focus",
			/* cancel="true" Event which is raised before value in editor was changed.
				Return false in order to cancel change.
				It can be raised on lost focus or on spin events.
				Function takes arguments evt and ui.
				Use ui.owner to obtain reference to igEditor.
				Use ui.value to obtain new value and ui.oldValue to obtain old value. */
			valueChanging: "valueChanging",
			/* Event which is raised after value in editor was changed. It can be raised on lost focus or on spin events.
				Function takes arguments evt and ui.
				Use ui.owner to obtain reference to igEditor.
				Use ui.value to obtain new value and ui.oldValue to obtain old value. */
			valueChanged: "valueChanged"
		},
		_createWidget: function (options) {
			// Those are only the options that are defined by the user, before merged with the default ones.
			this._definedOptions = options;
			$.Widget.prototype._createWidget.apply(this, arguments);
		},
        _create: function () { //BaseEditor
        	/* igWidget constructor goes here */
        	this._initialize();
        	this._readAttributes();
        	this._saveDOMConent();
        	this._render();
        },
        _initialize: function () {
        	this._timeouts = [];
        },
        _readAttributes: function () {
        	this._saveAttributes();
        	this._removeAttributesAndSetThemAsOptions();
        },
        _saveAttributes: function () {
        	var i;
        	var element = this.element[0], attr;

        	this._initialAttributes = [];
        	attr = element.attributes;
        	for (i = 0; i < attr.length; i++) {
        		if (attr[i].name !== 'id') {
        			this._initialAttributes.push({ name: attr[i].name, attrValue: attr[i].value, propValue: element[attr[i].name] });
        		}
        	}
        },
        _removeAttributesAndSetThemAsOptions: function () {
        	var element = this.element,
				name = element.attr("name"),
				value = element.attr("value"),
				disabled = element.attr("disabled"),
				readOnly = element.attr("readOnly");

        	if (name) {
        		element.removeAttr("name");
        		if (this.options.inputName === null) {
        			this.options.inputName = name;
        		}
        	}
        	if (value) {
        		element.removeAttr("value");
        		if (this.options.value === null) {
        			this.options.value = value;
        		}
        	}
        	if (disabled) {
        		element.removeAttr("disabled");
				// If we have 'disabled' attribute, then it is applied only when 'disabled' options is not defined.
        		if (this._definedOptions === undefined || this._definedOptions.disabled === undefined) {
        			this.options.disabled = true;
        		}
        	}
        	if (readOnly) {
        		element.removeAttr("readonly");
        		// If we have 'readOnly' attribute, then it is applied only when 'readOnly' options is not defined.
        		if (this._definedOptions === undefined || this._definedOptions.readOnly === undefined) {
        			this.options.readOnly = true;
        		}
        	}
        	delete this._definedOptions;
        },
        _saveDOMConent: function () {
        	if (this.element.children().length > 0) {
        		// We use clone because we will preserve event binding to the elements(if any) if binging is through javascript.
        		// If we use innerHtml then it will be faster(better for performance) but will not preserve data binding to the element inside to the table(if any).
        		this._initialDOMContent = this.element.children().clone(true);
        		this.element.empty(); // Remove all element content before rendering it.
        	}
        },
        _render: function () {
            throw ($.ig.Editor.locale.renderErrMsg);
        },
        _applyOptions: function () {
        	if (this.options.tabIndex !== null) {
        		this._setTabIndex(this.options.tabIndex);
        	}
        	if (this.options.readOnly) {
        		this._setReadOnly(true);
        	}
        	if (this.options.disabled) {
        		this._setDisabled(true);
        	}
        	if (this.options.inputName) {
        		this.inputName(this.options.inputName);
        	}
        	if (this.options.validatorOptions) {
        	    this._setupValidator();
        	}
        },
        _attachEvents: function () {
        	var self = this;
        	this._editorContainer.on({
        		"mousedown.editor": function (event) {
        			self._triggerMouseDown(event);
        		},
        		"mouseup.editor": function (event) {

        			self._triggerMouseUp(event);
        		},
        		"mousemove.editor": function (event) {
        			self._triggerMouseMove(event);
        		},
        		"mouseover.editor": function (event) {
        			self._triggerMouseOver(event);
        		},
        		"mouseout.editor": function (event) {
        			self._triggerMouseOut(event);
        		}        		
        	});
        },
        _setupValidator: function () {
            if (this.element.igValidator) {
                this._validator = this.element.igValidator(this.options.validatorOptions).data("igValidator");
                this._validator.owner = this;
            }
        },
        _destroyValidator: function () {
            if (this._validator && this._validator.owner === this) {
                this._validator.destroy();
                this._validator = null;
            }
        },
        _applyAria: function () {
        	var ariaLabeledBy = this.element.attr("aria-labelledby");

        	if (ariaLabeledBy) {
        		this.element.removeAttr("aria-labelledby");
        		this._editorInput.attr("aria-labelledby", ariaLabeledBy);
        	}
        	if (this._dropDownButton) {
        		this._editorInput.attr("role", "combobox");
        	} else {
        		this._editorInput.attr("role", "textbox");
        	}
        },
        _triggerRendering: function () {
        	var args = {
        		element: this.element,
        		owner: this
        	};
        	return this._trigger(this.events.rendering, null, args);
        },
        _triggerRendered: function () {
        	var args = {
        		element: this.element,
				owner: this
        	};
        	this._trigger(this.events.rendered, null, args);
        },
        _triggerMouseMove: function (event) {
        	var args = {
        		owner: this,
        		element: event.target,
        		editorInput: this._editorInput
        	};
        	this._trigger(this.events.mousemove, event, args);
        },
        _triggerMouseDown: function (event) {
        	this._editorContainer.addClass(this.css.active);
        	var args = {
        		owner: this,
        		element: event.target,
				editorInput: this._editorInput
        	};
        	return this._trigger(this.events.mousedown, event, args);
        },
        _triggerMouseUp: function (event) {
        	this._editorContainer.removeClass(this.css.active);
        	var args = {
        		owner: this,
        		element: event.target,
        		editorInput: this._editorInput
        	};
        	this._trigger(this.events.mouseup, event, args);
        },
        _triggerMouseOver: function (event) {
        	this._editorContainer.addClass(this.css.hover);
        	var args = {
        		originalEvent: event,
        		owner: this,
        		element: event.target,
        		editorInput: this._editorInput
        	};
        	this._trigger(this.events.mouseover, event, args);
        },
        _triggerMouseOut: function (event) {
    		this._editorContainer.removeClass(this.css.hover);
        	var args = {
        		originalEvent: event,
        		owner: this,
        		element: event.target,
        		editorInput: this._editorInput
        	};
        	this._trigger(this.events.mouseout, event, args);
    	},
    	_triggerFocus: function (event) {
    		this._editorContainer.addClass(this.css.focus);
    		var args = {
    			originalEvent: event,
    			owner: this,
    			element: event.target,
    			editorInput: this._editorInput
    		};
    		this._trigger(this.events.focus, event, args);
    	},
    	_triggerBlur: function (event) {
    		this._editorContainer.removeClass(this.css.focus);
    		this._clearEditorNotifier();
    		var args = {
    			owner: this,
    			element: event.target,
    			editorInput: this._editorInput
    		};
    		this._trigger(this.events.blur, event, args);
    	},
        _setOption: function (option, value) { //Base editor
			/* igWidget custom setOption goes here */
			var prevValue = this.options[option];
			if (prevValue === value) {
				return;
			}
			// The following line applies the option value to the igWidget meaning you don't
			// have to perform this.options[option] = value;
			$.Widget.prototype._setOption.apply(this, arguments);
			switch (option) {
				case "readOnly":
					this._setReadOnly(value);
					break;
				case "disabled": 
					this._setDisabled(value);
					break;
				case "width":
					this._setWidth(value);
					break;
				case "height":
					this._setHeight(value);
					break;
				case "validatorOptions":
					this._setupValidator();
					break;
			    default:
			        break;
			}
        },
        _validateValue: function (val) {//Base editor
        	return val ? true : false;
        },
        _updateValue: function (value) { //Base Editor            
        	if (value === this.options.nullValue && this.options.nullValue === null) {
        		this._editorInput.val("");
        		this._valueInput.val("");
        	} else {
        		this._editorInput.val(value);
        		this._valueInput.val(value);
        	}
        	this.options.value = value;
        	
        }, //BaseEditor
		//This method sets the value to null, or empty string  depending on the nullable option.
        _clearValue: function () {
			//TODO use null, or 0 depending on the nullable option
        	if (this.options.allowNullValue) {
        		this._updateValue(this.options.nullValue);
        	} else {
        		this._updateValue("");
        	}
        },
        _detachEvents: function () {
        	if (this._detachButtonsEvents) {
        		this._detachButtonsEvents();
        	}
        	if (this._detachListEvents) {
        		this._detachListEvents();
        	}
        	// https://css-tricks.com/namespaced-events-jquery/
        	this._editorContainer.off("mousedown.editor mouseup.editor mouseover.editor mouseout.editor mouseout.editor");
			
        },
        _detachButtonsEvents: function () {
        	if (this._dropDownList) {
        		this._detachListEvents();
        	}
        	if (this._dropDownButton) {
        		this._detachButtonsEvents(this._dropDownButton);
        	}

        	if (this._clearButton) {
        		this._detachButtonsEvents(this._clearButton);
        	}
        	if (this._spinUpButton) {
        		this._detachButtonsEvents(this._spinUpButton);
        	}
        	if (this._spinDownButton) {
        		this._detachButtonsEvents(this._spinDownButton);
        	}
        },
        _restoreDOMStructure: function () {
        	this._removeDOM();
        	this._removeAttributes();
        	this._setPropsDefaults();
        	this._recoverInitialAttributes();
        	this._recoverInitialDOMContent();
        },
        _removeDOM: function () {
        	if (this._dropDownList) {
        		this._deleteList();
        	}
        	this._valueInput.remove();
        	if (this.element.is("input")) {
        		this.element.unwrap().unwrap();
        	} else if (this.element.is("div")) {
        		this.element.empty();
        	} else if (this.element.is("span")) {
        		this.element.empty();
        		this.element.unwrap().unwrap();
        	}
        },
        _removeAttributes: function () {
        	var element = this.element,
				attr = element[0].attributes,
				concatenatedAttr = "", i;

        	for (i = 0; i < attr.length; i++) {
        		if (attr[i].name !== "id") {
        			concatenatedAttr += (attr[i].name + " ") ;
        		}
        	}
        	element.removeAttr(concatenatedAttr.trim(" "));
        },
        _setPropsDefaults: function () {
        	var element = this.element[0];

        	element.disabled = false;
        	element.readOnly = false;
        	element.checked = false;
        	element.value = null;
        },
        _recoverInitialAttributes: function () {
        	var i;
        	if (this._initialAttributes) {
        		for (i = 0; i < this._initialAttributes.length; i++) {
        			if (this._initialAttributes[i].name !== 'id') {
        				this.element.attr(this._initialAttributes[i].name, this._initialAttributes[i].attrValue);
        				if (this._initialAttributes[i].propValue !== undefined) {
        					this.element.prop(this._initialAttributes[i].name, this._initialAttributes[i].propValue);
        				}
        			}
        		}
        		delete this._initialAttributes;
        	}
        },
        _recoverInitialDOMContent: function () {
        	if (this._initialDOMContent) {
        		this._initialDOMContent.appendTo(this.element);
        		delete this._initialDOMContent;
        	}
        },
        _clearStyling: function () {
        	this._editorContainer
				.removeClass(this.css.container)
				.removeClass(this.css.hover)
				.removeClass(this.css.active);

        	this._editorInput.removeClass(this.css.editor);
        },
        _deleteInternalProperties: function () {
        	delete this._editorInput;
        	delete this._editorContainer;
        		delete this._valueInput;
        	if (this._timeouts) {
        		delete this._timeouts;
        	}
        },
        _clearTimeouts: function() {
        	var i, timeouts = this._timeouts;
        	if(timeouts && timeouts instanceof Array) {
        		for (i = 0; i < timeouts.length; i++) {
        			clearTimeout(timeouts[i]);
        		}
        		this._timeouts = [];
        	}
        },
        _disableEditor: function () {
        	//In both readOnly and disabled state we have similar logic for making the editor disabled/readonly (detach event and remove classes)
        	this._editorContainer.addClass(this.css.disabled);
        	this._detachEvents();
        },
        _setEditableMode: function () {
        	//Default value we don't do anything unless we implement setOption related to that. 
        	this._editorInput.prop("readonly", false);
        	this._valueInput.prop("readonly", false);
        	this._editorInput.prop("disabled", false);
        	this._valueInput.prop("disabled", false);
        	this._editorContainer.removeClass(this.css.disabled);
        	this._attachEvents();
        },
        _setDisabled: function (activate) {
        	if (activate) {
        		this._editorInput.prop("disabled", true);
        		this._valueInput.prop("disabled", true);
        		this._disableEditor();
        	} else {
        		this._editorInput.prop("disabled", false);
        		this._valueInput.prop("disabled", false);
        		if (!this.options.readOnly) {
        			this._setEditableMode();
        		}
        	}
        },
        _setReadOnly: function (activate) {
        	if (activate) {
        		this._editorInput.prop("readonly", true);
        		this._valueInput.prop("readonly", true);
        		this._disableEditor();
        	} else {
        		this._editorInput.prop("readonly", false);
        		this._valueInput.prop("readonly", false);
        		if (!this.options.disabled) {
        			this._setEditableMode();

        		}
        		this._editorInput.off(".readonly");
        	}
        },
        _setWidth: function (width) {
        	if (width) {
        		this._editorContainer.css("width", this.options.width);
        	}
        },
        _setHeight: function (height) {
        	if (height) {
        		this._editorContainer.css("height", this.options.height);
        	}
        },
        _setTabIndex: function (index) {
        	this._editorInput.attr("tabIndex", index);
        },
        _setFocusDelay: function (delay) {
			var self = this;
			if (delay) {
				this._timeouts.push(setTimeout(function () { self._setFocus(); }, delay));
			} else {
				self._setFocus();
			}
		},
		_setFocus: function (event) {
			//getValue and set it to the input
			this._focused = true;
			this._enterEditMode();
            if (event) {
				this._triggerFocus(event);
			}
		},
		_setBlur: function (event) { //Base Editor
			var newValue;
			if (this._cancelBlurOnInput) {
				this._editorInput.focus();
				delete this._cancelBlurOnInput;
			} else {
				this._triggerBlur(event);
				newValue = $(event.target).val();
				this._currentInputTextValue = this._editorInput.val();
				this._processValueChanging(newValue);
				this._processTextChanged();
				this._exitEditMode();
				//In case our dropdown is opened we need to close it. 
				if (this._dropDownList && this._triggerDropDownClosing()) {
					this._hideDropDownList();
					this._triggerDropDownClosed();
				}
				this._focused = false;
				this._clearTimeouts();
				if (this._validator) { // TODO VERIFY
				    this._validator._validateInternal(this.element, event, true);
				}
			}
		},
		// igBaseEditor public methods
		inputName: function (newValue) {
			/* type="number" Gets sets name attribute applied to the editor element
			returnType="string" Current name */
			if (newValue) {
				this.options.inputName = newValue;
				this._valueInput.attr("name", newValue);
			} else {
				return this.options.inputName;
			}
		},
		value: function (newValue) {
			if (newValue !== undefined) {
				if (this._validateValue(newValue)) {
					this._updateValue(newValue);
					this._editorInput.val(this._getDisplayValue());
				} else {
					this._clearValue();
				}
			} else {
				return this.options.value;
			}
		},
		field: function () {
			/* Gets the visual editor element.
			returnType="$" The visual editor element */
			return this._editorInput;
		},
		editorContainer: function () {
			/* Gets reference to jquery object which is used as top/outer element of igEditor.
			returnType="object" The container editor element */
			return this._editorContainer;
		},
		hasFocus: function () {
			/* Checks if editor has focus.
    			returnType="bool" Returns if the editor is focused or not*/
			return this._focused;
		},
		setFocus: function (delay) {
			/* Set focus to editor with delay.
				paramType="number" optional="true" The delay before focusing the editor */
			this._setFocusDelay(delay);
		},
		hide: function () {
			/* Hides editor. */
			this._editorContainer.hide();
		},
		show: function () {
			/* Shows editor. */
			this._editorContainer.show();
		},
		validator: function () {
		    /* Gets reference to igValidator used by the editor.
                returnType="object" Returns reference to igValidator or null.
            */
		    return this._validator;
		},
		isValid: function () {
			/* Checks if value in editor is valid. Note: This function will not trigger automatic notifications.
				paramType="" optional=""
    			returnType="bool" Whether editor value is valid or not */
		    this._skipMessages = true;
		    var valid = this._validateValue(this.value());
		    this._skipMessages = false;
		    return valid;
		},
		validate: function () {
			/* Triggers validation of editor and show potential warning message. */
			this._validateValue(this.value());
		},
        destroy: function () {
        	/* Destructor of the widget */
        	this._destroyValidator();
        	this._detachEvents();
        	this._clearTimeouts();
        	this._clearStyling();
        	this._restoreDOMStructure();
        	this._deleteInternalProperties();
        	
        	delete this.options;
        	$.Widget.prototype.destroy.apply(this, arguments);
        	return this;
        }
    });
    $.extend($.ui.igBaseEditor, { version: '15.2.20152.1033' });
    $.widget('ui.igTextEditor', $.ui.igBaseEditor, {
    	options: {

    		/* type="dropdown|clear|spin" Sets gets visibility of spin and drop-down button. That option can be set only on initialization. Combinations like 'dropdown,spin' or 'spinclear' are supported too.
				dropdown type="string" button to open list is located on the right side of input-field (or left side if base html element has direction:rtl);
				clear type="string" button to clear value is located on the right side of input-field (or left side if base html element has direction:rtl);
				spin type="string" spin buttons are located on the right side of input-field (or left side if base html element has direction:rtl).
			*/
    		buttonType: 'none',
    		/* type="array" Sets gets list of items which are used for drop-down list.
				Items in list can be strings, numbers or objects. The items are directly rendered without casting, or manipulating them.
			 */
    		listItems: null,
    		/* type="number" Sets gets custom width of drop-down list in pixels. If value is equal to 0 or negative, then the width of editor is used. */
    		listWidth: 0,
			/* type="number* Sets the hover/unhover animation duration. */
    		listItemHoverDuration: 0,
    		/* type="bool" Sets gets location of drop-down list.
				Value false will create html element for list as a child of main html element.
				Value true creates list as a child of body.*/
    		dropDownAttachedToBody: false,

    		/* type="number" Gets sets show/hide drop-down list animation duration in milliseconds. */
    		dropDownAnimationDuration: 300,
    		/* type="number" Gets sets how many items should be shown at once. 
			   Notes:
			   That option is overwritten if the number of list items is less than the value. In that case the height of the dropdown is adjusted to the number of items. 
			*/
    		visibleItemsCount: 5,
    		/* type="string" Sets gets ability to enter only specific characters in input-field from keyboard and on paste.
				Notes:
				If "excludeKeys" option contains same characters as this option, then "excludeKeys" has priority.
				Letters should be set in upper case.
				Making difference between upper and lower case is not supported. */
    		includeKeys: null,
    		/* type="string" Sets gets ability to prevent entering specific characters from keyboard or on paste.
				Notes:
				If a character is specified in "includeKeys" option also, then "excludeKeys" has priority.
				Letters should be set in upper case.
				Making difference between upper and lower case is not supported. */
    		excludeKeys: null,
    			/* type="left|right|center" Sets gets horizontal alignment of text in editor. If that option is not set, then 'right' is used for 'numeric', 'currency' and 'percent' editors and the 'left' is used for all other types of editor.
					left type="string"
					right type="string"
					center type="string"
				*/
    		textAlign: "left",
    		/* type="string" Sets gets text which appears in editor when editor has no focus and "value" in editor is null or empty string.  */
    		placeHolder: null,
    		/* type="selectAll|atStart|atEnd|browserDefault Set the action when the editor gets focused. The default value is selectAll.
					selectAll type="string" Setting this option will select all the text into the editor when the edit mode gets enetered.
					atStart type="string" Setting this option will move the cursor at the begining the text into the editor when the edit mode gets enetered.
					atEnd type="string" Setting this option will move the cursor at the end the text into the editor when the edit mode gets enetered.
					browserDefault type="string" Setting this option won't do any extra logic, but proceed with browser default behavior.
				*/
    		selectionOnFocus: "selectAll",
    		/* type="text|password|multiline" Sets gets text mode of editor such as: single-line text editor, password editor or multiline editor. That option has effect only on initialization. If based element (selector) is TEXTAREA, then it is used as input-field.
				text type="string" Single line text editor based on INPUT element is created.
				password type="string" Editor based on INPUT element with type password is created.
				multiline type="string" multiline editor based on TEXTAREA element is created. 
			*/
    		textMode: "text",
    		/* type="bool" Sets gets ability to automatically change the hoverd item into the opened dropdown list to its oposide side. When last item is reached and the spin down is clicked the first item gets hovered and vice versa. 
			*/
    		spinWrapAround: false,
			/* type="bool" Sets the ability to allow values only set into the list items. This validation is done only when the editor is blured, or enter key is pressed*/
    		isLimitedToListValues: false,
    		/* type="bool" Sets the editor to revert value to previous value in case of not valid value on blur, or enter key. If set to false clear is called.*/
    		revertIfNotValid: true,
			/* type="bool" Sets the ability of the editor to prevent form submition on enter key pressed.*/
    		preventSubmitOnEnter: false,
    		/* type="auto|bottom|top" Gets sets drop down opening orientation for the dorp down list when open button is clicked. If auto option is set the component calculates if there is enough space at the bottom, if not checks the space above the component and if in both directions there is not enough space it openes the dropdown down way.
			   'auto' type="string"
			   'bottom' type="string"
			   'top' type="string"
			*/
    		dropDownOrientation: "auto",
    		/* type="number" Sets gets maximum length of text which can be entered by user.
				Negative values or 0 disables that behavior.
			*/
    		maxLength: null,
    		/* type="bool" Sets gets ability to limit editor to be used only from the dropdown list. When set to true the editor input is not editable. 
				Note! In case there are no list items - the editor will reamin readonly */
    		dropDownOnReadOnly: false,
            /* type="bool" Sets gets ability to convert input characters to upper case (true) or keeps characters as they are (false). That option has effect only while keyboard entries and paste. */
            toUpper: false,
            /* type="bool" Sets gets ability to convert input characters to lower case (true) or keeps characters as they are (false). That option has effect only while keyboard entries and paste. */
            toLower: false,
    	    /* type="object" Sets gets strings used for title of buttons. Value of object should contain pairs or key:value members. Note: any sub-option of locale can appear within the main option of igEditor. In this case those values within main options will have highest priority and override corresponding value in locale. */
            locale: null,
    	    /* type="bool" Disables default notifications for basic validation scenarios built in the editors such as required list selection, value wrapping around or spin limits. */
    	    suppressNotifications : false
    	},
    	css: {
    		/* igWidget element classes go here */
    	    /* Class applied to the div which wraps the editable input (in case of multiline textarea). Default value is "ui-igeditor-input-container ui-corner-all" */
    	    editorInputContainer: "ui-igeditor-input-container ui-corner-all",
    		/* Class applied to the div holding the spin up button image. Default value is 'ui-igedit-spinupperimage ui-icon-carat-1-n ui-icon ui-igedit-buttondefault ui-igedit-spinbutton ui-igedit-buttonimage'*/
    		spinButtonUpImage: "ui-igedit-spinupperimage ui-icon-carat-1-n ui-icon ui-igedit-buttondefault ui-igedit-spinbutton ui-igedit-buttonimage",
    		/* Class applied to the div holding the spin down button image. Default value is 'ui-igedit-spinlowerimage ui-icon-carat-1-s ui-icon ui-igedit-buttondefault ui-igedit-spinbutton ui-igedit-buttonimage'*/
    		spinButtonDownImage: "ui-igedit-spinlowerimage ui-icon-carat-1-s ui-icon ui-igedit-buttondefault ui-igedit-spinbutton ui-igedit-buttonimage",
    		/* Class applied to the div holding the drop down button image. Default value is 'ui-icon ui-icon-carat-1-s ui-igedit-buttonimage'*/
    		dropDownImage: "ui-icon ui-icon-triangle-1-s ui-igedit-buttonimage",
    		/* Class applied to the div holding the drop down button. Default value is 'ui-igedit-dropdown-button'*/
    		dropDownButton: "ui-igedit-dropdown-button ",
    		/* Class applied to the div holding the clear button image. Default value is 'ui-igedit-buttonimage ui-icon-circle-close ui-icon ui-igedit-buttondefault'*/
    		clearButtonImage: "ui-igedit-buttonimage ui-icon-circle-close ui-icon ui-igedit-buttondefault",
    		/* Class applied to the div holding the clear button. Default value is 'ui-igedit-cleararea ui-state-default'*/
    		clearButton: "ui-igedit-cleararea ui-state-default",
    		/* Class applied commonly to all the button containers, Default value is 'ui-igedit-button-common ui-unselectable ui-igedit-button-ltr ui-state-default'*/
			buttonCommon: "ui-igedit-button-common ui-unselectable ui-igedit-button-ltr ui-state-default",
    		/* Class applied to the container holding the listitems. Default value is 'ui-igedit-dropdown'*/
			dropDownList: "ui-igedit-dropdown ui-widget",
    		/* Class applied to the SPAN element which represents item in dropdown list. Default value is 'ui-igedit-listitem ui-state-default' */
			listItem: 'ui-igedit-listitem ui-state-default',
    		/* Class applied to the Class applied to the SPAN element which represents item in dropdown list with mouse-over state. Default value is 'ui-igedit-listitemhover ui-state-hover' */
			listItemHover: 'ui-igedit-listitemhover ui-state-hover',
    		/* Class applied to the Class applied to the SPAN element which represents active item in dropdown list. Default value is 'ui-igedit-listitemselected ui-state-highlight' */
			listItemActive: 'ui-state-active ui-igedit-listitemactive',
    		/* Class applied to the Class applied to the SPAN element which represents selected item in dropdown list. Default value is 'ui-igedit-listitemselected ui-state-highlight' */
			listItemSelected: 'ui-igedit-listitemselected ui-state-highlight',
    		/* Classes applied to the SPAN element of button in mouse-over state. Default value is 'ui-igedit-buttonhover ui-state-hover' */
			buttonHover: 'ui-igedit-buttonhover ui-state-hover',
    		/* Classes applied to the SPAN element of button in pressed state. Default value is 'ui-igedit-buttonpressed ui-state-highlight' */
			buttonPressed: 'ui-igedit-buttonpressed ui-state-highlight',
    		/* Class applied to the visible input in case of plaseHolder option set. This class is related only to the placeHolder styling. Default value is 'ui-igedit-placeholder'*/
			placeHolder: 'ui-igedit-placeholder',
			/* Class applied to the visible textarea element in case of textMode set to 'multiline'*/
			textArea: "ui-igedit-textarea"
    	},
    	events: {
    		/* cancel="true" Event which is raised on keydown event.
				Return false in order to cancel key action.
				Function takes arguments evt and ui.
				Use evt.originalEvent to obtain reference to event of browser.
				Use ui.owner to obtain reference to igEditor.
				Use ui.key to obtain value of keyCode. */
    		keydown: "keydown",
    		/* cancel="true" Event which is raised on keypress event.
				Return false in order to cancel key action.
				Function takes arguments evt and ui.
				Use evt.originalEvent to obtain reference to event of browser.
				Use ui.owner to obtain reference to igEditor.
				Use ui.key to obtain value of keyCode.
				Set ui.key to another character which will replace original entry. */
    		keypress: "keypress",
    		/* Event which is raised on keyup event.
				Function takes arguments evt and ui.
				Use evt.originalEvent to obtain reference to event of browser.
				Use ui.owner to obtain reference to igEditor.
				Use ui.key to obtain value of keyCode. */
    		keyup: "keyup",
    		/* cancel="true" Event which is raised when the drop down is opening. 
				Function takes arguments evt and ui.
				Use ui.owner to obtain reference to igEditor.
				Use ui.editorInput to obtain reference to the editable input
				Use ui.list to obtain reference to the list contaier. */
    		dropDownListOpening: "dropDownListOpening",
    		/* Event which is raised when the drop down is already opened. 
				Function takes arguments evt and ui.
				Use ui.owner to obtain reference to igEditor.
				Use ui.editorInput to obtain reference to the editable input
				Use ui.list to obtain reference to the list contaier. */
    		dropDownListOpened: "dropDownListOpened",
    		/* cancel="true" Event which is raised when the drop down is closing. 
				Function takes arguments evt and ui.
				Use ui.owner to obtain reference to igEditor.
				Use ui.editorInput to obtain reference to the editable input
				Use ui.list to obtain reference to the list contaier. */
    		dropDownListClosing: "dropDownListClosing",
    		/* Event which is raised when the drop down is already closed. 
				Function takes arguments evt and ui.
				Use ui.owner to obtain reference to igEditor.
				Use ui.editorInput to obtain reference to the editable input
				Use ui.list to obtain reference to the list contaier. */
    		dropDownListClosed: "dropDownListClosed",
    		/* cancel="true" Event which is raised when the drop down list item is selecting. 
				Function takes arguments evt and ui.
				Use ui.owner to obtain reference to igEditor.
				Use ui.editorInput to obtain reference to the editable input
				Use ui.list to obtain reference to the list contaier. 
				Use ui.item to obtain reference to the list item which is about to be selected. */
    		dropDownItemSelecting: "dropDownItemSelecting",
    		/* cancel="true" Event which is raised when the drop down list item is selected. 
				Function takes arguments evt and ui.
				Use ui.owner to obtain reference to igEditor.
				Use ui.editorInput to obtain reference to the editable input
				Use ui.list to obtain reference to the list contaier. 
				Use ui.item to obtain reference to the list item which is selected. */
    		dropDownItemSelected: "dropDownItemSelected",
    		/* Event which is raised after text in editor was changed. It can be raised when keyUp event occurs, 
				or when the clear button is clicked or when an item from a list is selected.
				Function takes arguments evt and ui.
				Use ui.owner to obtain reference to igEditor.
				Use ui.text to obtain new text
				Use ui.oldTExt to obtain the old text. */
    		textChanged: "textChanged"
    	},
    	_create: function () { //igTextEditor
    		$.ui.igBaseEditor.prototype._create.call(this);
    	},
    	_setOption: function (option, value) { // igTextEditor
    		/* igTextEditor custom setOption goes here */
    		var prevValue = this.options[option];
    		if (prevValue === value) {
    			return;
    		}
    		// The following line applies the option value to the igWidget meaning you don't
    		// have to perform this.options[option] = value;
    		$.Widget.prototype._setOption.apply(this, arguments);
    		switch (option) {
    			case "value":
    				if (this._validateValue(value)) {
    					this._updateValue(value);
    					this._exitEditMode();
    				} else {
    					this._clearValue();
    					this._exitEditMode();
    			}
    				break;
    			case "placeHolder":
    				this._applyPlaceHolder();
    				break;
    		    case "suppressNotifications":
    		        if (value) {
    		            this._clearEditorNotifier();
    		        }
    		        break;
    			case "listItems":
    				this._deleteList();
    				this._createList();
    				break;
				case "dropDownOnReadOnly":
    			case "visibleItemsCount":
    			case "buttonType":
    			case "dropDownAttachedToBody":
    			    throw new Error($.ig.Editor.locale.cannotSetRuntime);
    			default:
					//In case no propery matches, we call the super. Into the base widget default statement breaks
    				
    				this.options[option] = prevValue;
    				this._super(option, value);
    				break;
    		}
    	},
        //This method validates and updates the value input the hidden input
    	_updateValue: function (value) { //TextEditor //WE should detect dataMode, so we can use the options. 
    		if (value !== null && value !== undefined) {
    			value = value.toString();
    		}
    	    this._super(value);
    	},
    	_applyOptions: function () { //TextEditor
    		var initialValue;
    		this._super();
    		if (this.options.includeKeys) {
    			this._includeKeysArray = this.options.includeKeys.toString().split("");
    		}
    		if (this.options.excludeKeys) {
    			this._excludeKeysArray = this.options.excludeKeys.toString().split("");
    		}
    		if (this.options.value !== undefined) {
    			initialValue = this.options.value;
    			if (this.options.maxLength) {
    				if (initialValue && initialValue.toString().length >= this.options.maxLength) {
    					initialValue = initialValue.toString().substring(0, this.options.maxLength);
    					//Raise warning
    					this._sendNotification("warning", $.ig.util.stringFormat($.ig.Editor.locale.maxLengthErrMsg, this.options.maxLength));
    				}
    			}
    			if (this._validateValue(initialValue)) {
    				this._setInitialValue(initialValue);
    			this._editorInput.val(this._getDisplayValue());
    			}
    		} else if (this.element.val() && this._validateValue(this.element.val())) {
    			initialValue = this.element.val();
    			if (this.options.maxLength) {
    				if (initialValue && initialValue.toString().length >= this.options.maxLength) {
    					initialValue = initialValue.toString().substring(0, this.options.maxLength);
    					//Raise warning
    					this._sendNotification("warning", $.ig.util.stringFormat($.ig.Editor.locale.maxLengthErrMsg, this.options.maxLength));
    				}
    			}
    			if (this._validateValue(initialValue)) {
    				this._setInitialValue(initialValue);
    			this._editorInput.val(this._getDisplayValue());
    			} else {
    				this._editorInput.val("");
    		}
    		}
    		this._applyPlaceHolder();
    	},
    	_render: function () {
			//We asume the base renderer has already been invoked
    		var editorElementWrapper, editorElement;
    		this._triggerRendering();
    		if (this.element.is("div") || this.element.is("span")) {
    			if (this.options.textMode === "multiline") {
    				editorElement = $("<textarea rows='4' cols='50'></textarea>");
    				editorElement.addClass(this.css.textArea);
    			} else if (this.options.textMode === "password") {
    				editorElement = $("<input type='password' autocomplete='off'/>");
    			} else {
    				editorElement = $("<input type='text' />");
    			}

    			if (this.element.is("span")) {
    				editorElement = this.element.html(editorElement);
    			}
				editorElementWrapper = editorElement.wrap($("<div></div>")).parent();
    			editorElementWrapper.addClass(this.css.editorInputContainer);
    			this._editorInputWrapper = editorElementWrapper;
    			if (this.element.is("span")) {
    				this._editorInput = editorElement.children(0);
    				this._editorContainer = editorElementWrapper.wrap($("<div></div>")).parent();
    			} else {
    				this._editorInput = editorElement;
    				this._editorContainer = this.element;
    			}
    			this._editorContainer.prepend(editorElementWrapper);
    		} else if (this.element.is("input")) {
    			this._editorContainer = this.element.wrap($("<div></div>")).parent();
    			this._editorInput = this.element;
    			editorElementWrapper = this._editorInput.wrap($("<div></div>")).parent();
    			editorElementWrapper.addClass(this.css.editorInputContainer);
    			this._editorInputWrapper = editorElementWrapper;
    		} else if (this.element.is("textarea")) {
    			if (this.options.textMode !== "multiline") {
    			    throw ($.ig.Editor.locale.multilineErrMsg);
    			} else {
    				this._editorContainer = this.element.wrap($("<div></div>")).parent();
    				this._editorInput = this.element;
    				this._editorInput.addClass(this.css.textArea);
    				editorElementWrapper = this._editorInput.wrap($("<div></div>")).parent();
    				editorElementWrapper.addClass(this.css.editorInputContainer);
    				this._editorInputWrapper = editorElementWrapper;
    			}
    		} else {
    			//TODO Throw target element not supported. 
    		    throw ($.ig.Editor.locale.targetNotSupported);
    		}
    		this._editorContainer.addClass(this.css.container);
    		this._editorInput.addClass(this.css.editor);
    		this._editorInput.css("height", "100%");

    		//Set input type to text
    		if (!$.ig.util.isIE8) {
    			if (this.options.textMode !== "multiline") {
    				if (this.options.textMode === "password") {
    					this._editorInput.attr("type", "password");
    					this._editorInput.attr("autocomplete", "off");
    				} else {
    					this._editorInput.attr("type", "text");
    				}
    			}
    		}

    		if (this.options.buttonType && this.options.buttonType !== "none" && this.options.textMode !== "multiline" && this.options.textMode !== "password") {
    			this._renderButtons();
    		}
    		if (this.options.width) {
    			this._editorContainer.css("width", this.options.width);
    		}
    		if (this.options.height) {
    			this._editorContainer.css("height", this.options.height);
    		}
    			//TODO check for textarea
    		if (this.options.textMode === "multiline") {
    			this._valueInput = $("<textarea style='display:none'></textarea>");
    		} else {
    			this._valueInput = $("<input type='hidden'></input>");
    		}
    		this._editorInput.after(this._valueInput);
    		this._editorInput.css("text-align", this.options.textAlign);
    		this._createList();

    		this._attachEvents();
    		this._applyOptions();
    		this._applyAria();

    		this._triggerRendered();
    	},
    	_sendNotification: function (state, message) {
    	    if (this.options.suppressNotifications || this._skipMessages /* flag on isValid() call */) {
    	        this._currentMessage = message;
    	        return;
    	    }
    	    if (!this._editorContainer.data("igNotifier")) {
    	        this._editorContainer.igNotifier();
    	    }
    	    this._editorContainer.igNotifier("notify", state, message);
    	},
    	_applyPlaceHolder: function() {
    		if (this.options.placeHolder && this.options.placeHolder !== "") {
    			this._editorInput.attr("placeholder", this.options.placeHolder);
    			//If placeholder is not supported
    			this._editorInput.addClass(this.css.placeHolder);
    			if (this._placeHolderNotSupported()) {
    				console.log($.ig.Editor.locale.placeHolderNotSupported);
    			}
    		} else if (this._editorInput.attr("placeholder")) {
    			this._editorInput.removeAttr("placeholder");
    		}
    	},
    	_placeHolderNotSupported: function () {
    		return document.createElement("input").placeholder === undefined;
    	},
		//We use this extra function so we can branch the logic into mask editor.
    	_setInitialValue: function (value) { //igTextEditor
    		this._updateValue(value);
    	},
    	_disableEditor: function () { //TextEditor
    		//In both readOnly and disabled state we have similar logic for making the editor disabled/readonly (detach event and remove classes)
    		if (this.options.dropDownOnReadOnly) {
    			this._editorInput.addClass(this.css.disabled);
    		} else {
    			this._editorContainer.addClass(this.css.disabled);
    			this._detachEvents();
    		}

    		if (this._dropDownList && !this.options.dropDownOnReadOnly) {
    			this._dropDownList.addClass(this.css.disabled);
    			this._detachListEvents();
    		}
    		if (this._dropDownButton && !this.options.dropDownOnReadOnly) {    
    			this._dropDownButton.addClass(this.css.disabled);
    			this._detachButtonsEvents(this._dropDownButton);
    		}
    		
    		if (this._clearButton) {
    			this._clearButton.addClass(this.css.disabled);
    			this._detachButtonsEvents(this._clearButton);
    		}
    		if (this._spinUpButton) {
    			this._spinUpButton.addClass(this.css.disabled);
    			this._detachButtonsEvents(this._spinUpButton);
    		}
    		if (this._spinDownButton) {
    			this._spinDownButton.addClass(this.css.disabled);
    			this._detachButtonsEvents(this._spinDownButton);
    		}
    	},
    	_validateValue: function (val) { //Text Editor
    		var loweredItems, result;
    		if (val === undefined) {
    			result = false;
    		} else if (val === null) {
    			if (this.options.allowNullValue) {
    				result = val === this.options.nullValue ? true : false;
    			} else {
    				result = false;
    			}
    		} else if (this.options.isLimitedToListValues && this._dropDownList) {
    			loweredItems = $.map(this.options.listItems, function (item) {
    				return item.toString().toLowerCase();
    			});
    			if ($.inArray(val.toString().toLowerCase(), loweredItems) !== -1) {
    				result = true;
    			} else {
    			    this._sendNotification("warning", $.ig.Editor.locale.allowedValuesMsg);
    				result = false;
    			}
    		} else if (this.options.maxLength) {
    			 if (val.toString().length <= this.options.maxLength) {
    				result = true;
    			} else {
    			     this._sendNotification("warning", $.ig.util.stringFormat($.ig.Editor.locale.maxLengthErrMsg, this.options.maxLength));
    				result = false;
    			}
    		} else {
    			result = true;
    		}
    		return result;
    	},
    	_setEditableMode: function () {
    		//Default value we don't do anything unless we implement setOption related to that. 
    		this._super("_setEditableMode");
			
    		if (this._dropDownList && !this.options.dropDownOnReadOnly) {
    			this._dropDownList.removeClass(this.css.disabled);
    			this._attachListEvents();
    		}
    		if (this._dropDownButton && !this.options.dropDownOnReadOnly) {
    			this._dropDownButton.removeClass(this.css.disabled);
    			this._attachButtonsEvents("dropdown", this._dropDownButton);    			
    		}
    		if (this._clearButton) {
    			this._clearButton.removeClass(this.css.disabled);
    			this._attachButtonsEvents("clear", this._clearButton);
    		}
    		if (this._spinUpButton) {
    			this._spinUpButton.removeClass(this.css.disabled);
    			this._attachButtonsEvents("spinUp", this._spinUpButton);
    		}
    		if (this._spinDownButton) {
    			this._spinDownButton.removeClass(this.css.disabled);
    			this._attachButtonsEvents("spinDown", this._spinDownButton);
    		}
    	},
    	_calculateDropDownListOrientation: function () {
    		var containerOffset = this._editorContainer.offset(),
    			containerTop = containerOffset.top,
    			containerHeight = parseFloat(this._editorContainer.css("height")),
    			dropDownAndEditorHeight = parseInt(containerTop + containerHeight + this._listInitialHeight),
    			widndowHeight = $(window).height(), 
    			orientation;
    		if (this.options.dropDownOrientation === "auto") {
    			if (dropDownAndEditorHeight < widndowHeight + $(window).scrollTop()) {
    				orientation = "bottom";
    			} else if ((containerTop - this._listInitialHeight) > 0) {
    				orientation = "top";
    			} else {
    				orientation = "bottom";
    			}
    		} else {
    			orientation = this.options.dropDownOrientation;
    		}
    		return orientation;
    	},
    	_positionDropDownList: function () {
    	    var containerOffset = this._editorContainer.offset(),
    		containerTop = containerOffset.top,
    	    containerLeft = containerOffset.left,
    	    containerHeight = parseFloat(this._editorContainer.css("height")),
    		orientation = this._calculateDropDownListOrientation();
    	    if (this.options.dropDownAttachedToBody) {
    	        this._dropDownList.css("left", containerLeft);
    	        if (orientation === "bottom") {
    	            this._dropDownList.css("top", containerTop + containerHeight);
    	            this._dropDownListOrientation = "down";
    	            this._dropDownList.removeClass("ui-igedit-dropdown-orientation-top");
    	            this._dropDownList.addClass("ui-igedit-dropdown-orientation-bottom");
    	        } else {
    	            this._dropDownList.css("top", containerTop - this._listInitialHeight);
    	            this._dropDownListOrientation = "up";
    	            this._dropDownList.removeClass("ui-igedit-dropdown-orientation-bottom");
    	            this._dropDownList.addClass("ui-igedit-dropdown-orientation-top");
    	        }
    	    } else {
    	        this._dropDownList.css("left", "");
    	        if (orientation === "bottom") {
    	            this._dropDownList.css("top", "");
    	            this._dropDownListOrientation = "down";
    	            this._dropDownList.removeClass("ui-igedit-dropdown-orientation-top");
    	            this._dropDownList.addClass("ui-igedit-dropdown-orientation-bottom");
    	        } else {
    	            this._dropDownList.css("top", -this._listInitialHeight);
    	            this._dropDownListOrientation = "up";
    	            this._dropDownList.removeClass("ui-igedit-dropdown-orientation-bottom");
    	            this._dropDownList.addClass("ui-igedit-dropdown-orientation-top");
    	        }
    	    }
    	    //In case we have editor width set into percent, once the window is resized the width of the editor might be changed and we need to set new width for the list
    	    this._setDropDownListWidth();
    	},
    	_createList: function () {
    		if (this.options.textMode !== "multiline" && this.options.textMode !== "password" && this.options.listItems && this.options.listItems.length > 0) {
    			if (this.options.buttonType.toString().indexOf("dropdown") === -1) {
    				this._renderDropDownButton();
    			}
    			this._renderList();
    			this._positionDropDownList();
    			this._attachListEvents();
    		}
    	},
    	_renderList: function () {
    	    var i, list = this.options.listItems, itemValue, currentItem, itemHeight;
    	    var dropdown = $("<div></div>)").addClass(this.css.dropDownList);
    	    for (i = 0; i < list.length; i++) {
    	    	currentItem = $("<span></span>").addClass(this.css.listItem);
    	    	itemValue = this.options.displayFactor ? list[i] * this.options.displayFactor : list[i];
    	    	currentItem.append(itemValue).appendTo(dropdown);
    		}
    		if (this.options.dropDownAttachedToBody) {
    			$(document.body).append(dropdown);
    		} else {
    			this._editorContainer.append(dropdown);
    		}
    		itemHeight = currentItem.css("height");
    		itemHeight = parseFloat(itemHeight);
    		if (itemHeight === 0) {
				// According to Designers, when height is 0, this is better solution, then setting min-height: 23 in CSS.
    			itemHeight = 23;
    		}
    		if (list.length < this.options.visibleItemsCount) {
    			dropdown.css("height", parseFloat(itemHeight * list.length));
    			this._listInitialHeight = parseFloat(itemHeight * list.length);
    			//TODO - hide scroll
    		} else {
    			dropdown.css("height", parseFloat(itemHeight * this.options.visibleItemsCount) + 2);
    			this._listInitialHeight = parseFloat(itemHeight * this.options.visibleItemsCount) + 2;
    		}
    		this._dropDownList = dropdown;
    		this._setDropDownListWidth();
    		dropdown.hide();
    		dropdown.visible = false;
    	},
    	_setDropDownListWidth: function () {
    		if (this.options.listWidth && this.options.listWidth > 0) {
    			this._dropDownList.css("width", this.options.listWidth);
    		} else {
    			this._dropDownList.css("width", this._editorContainer.css("width"));
    		}
    	},
    	_attachListEvents: function () {
    		var self = this;
    		this._dropDownList.on({
    			"mouseenter.editorList": function (event) {
    				var item = event.target;
    				$(item).addClass(self.css.listItemHover, self.options.listItemHoverDuration);
    				$(item).attr("data-hovered", true);
    			},
    			"mouseleave.editorList": function (event) {
    				var item = event.target;
    				$(item).removeClass(self.css.listItemHover, self.options.listItemHoverDuration);
    				$(item).removeAttr("data-hovered");
    			},
    			"click.editorList": function (event) {
    				self._triggerListItemClick(event.target);
    			},
    			"mousedown.editorList": function (event) {
    				event.preventDefault();
    				event.stopPropagation();
    			}
    		}, ".ui-igedit-listitem");

    		this._dropDownList.on("mousedown.editorList", function (event) {
    			if ($.ig.util.isIE) {
    				self._cancelBlurOnInput = true;
    			} else {
    				event.preventDefault();
    				event.stopPropagation();
    			}
    		});

    	},
    	_deleteList: function () {
    		this._detachListEvents();
    		this._detachButtonsEvents();
    		this._dropDownList.remove();
    		this._dropDownButton.remove();
    	},
    	_detachListEvents: function () {
    		if (this._dropDownList) {
    			this._dropDownList.off("mouseenter.editorList mouseleave.editorList click.editorList mousedown.editorList");
    		}
    	},
    	_renderDropDownButton: function () {
    		var dropDownButton = $("<div></div>"), dropDownIcon = $("<div></div>");
    		if (this._dropDownButton) {
    			return;
    		}
    		dropDownButton.addClass(this.css.buttonCommon);
    		dropDownButton.attr("title", this._getLocaleOption("buttonTitle"));    		
    		this._editorContainer.prepend(dropDownButton.addClass(this.css.dropDownButton).append(dropDownIcon.addClass(this.css.dropDownImage)));
    		this._dropDownButton = dropDownButton;
    		this._attachButtonsEvents("dropdown", dropDownButton);
    	},
    	_renderSpinButtons: function () {
    		var spinButtonUp = $("<div></div>"), spinButtonUpImage = $("<div></div>"), spinButtonDown = $("<div></div>"), spinButtonDownImage = $("<div></div>");
    		if (this._spinUpButton) {
    			return;
    		}
    		spinButtonUp.addClass(this.css.buttonCommon).append(spinButtonUpImage.addClass(this.css.spinButtonUpImage));
    		spinButtonDown.addClass(this.css.buttonCommon).append(spinButtonDownImage.addClass(this.css.spinButtonDownImage));
    		spinButtonUp.attr("title", this._getLocaleOption("spinUpperTitle"));    		
    		spinButtonDown.attr("title", this._getLocaleOption("spinLowerTitle"));    		  		
    		this._editorContainer.prepend(spinButtonDown).prepend(spinButtonUp);
    		this._attachButtonsEvents("spinDown", spinButtonDown);
    		this._attachButtonsEvents("spinUp", spinButtonUp);
    		this._spinUpButton = spinButtonUp;
    		this._spinDownButton = spinButtonDown;
    	},
    	_renderClearButton: function () {
    		var clearButton = $("<div></div>"), buttonClearIcon = $("<div></div>");
    		if (this._clearButton) {
    			return;
    		}
    		clearButton.addClass(this.css.buttonCommon);
    		clearButton.append(buttonClearIcon.addClass(this.css.clearButtonImage));
    		clearButton.attr("title", this._getLocaleOption("clearTitle"));
    		this._editorContainer.prepend(clearButton.addClass(this.css.clearButton));
    		this._clearButton = clearButton;
    		this._attachButtonsEvents("clear", clearButton);
    	},
    	_renderButtons: function () {
    	    var buttons = this.options.buttonType.toString().split(/[\s,]+/), buttonsCountRendered = 0;
			//
    		if ($.inArray("clear", buttons) !== -1) {
    			this._renderClearButton();
    			buttonsCountRendered++;
    		}
    		if ($.inArray("spin", buttons) !== -1) {
    			//In that case we need to render spin buttons in case of numeric editors and for all others we need to check if there is listItems. 
    			if (this._numericType || (this.options.listItems && this.options.listItems !== null)) {
    				this._renderSpinButtons();
    				buttonsCountRendered += 2;
    			}
    		}

    		if ($.inArray("dropdown", buttons) !== -1 && this.options.listItems && this.options.listItems !== null) {
    			this._renderDropDownButton();
    			buttonsCountRendered++;
    		}
    		if (buttonsCountRendered === 0) {
    		    console.log($.ig.Editor.locale.btnValueNotSupported);
    		}
    	},
    	_attachButtonsEvents: function (type, target) {
    		var self = this;
    		if (!target) {
    			return;
			}
    		/* jshint -W083*/
    		target.on({
    			"mouseenter.button": function () {
    				target.addClass(self.css.buttonHover);
    			},
    			"mouseleave.button": function () {
    				target.removeClass(self.css.buttonHover);
    				if (target._pressed) {
    					delete target._pressed;
    					target.removeClass(self.css.buttonPressed);
    				}
    				if (target._spinTimeOut) {
    					clearTimeout(target._spinTimeOut);
    					delete target._spinTimeOut;
    				}
    				if (target._spinInterval) {
    					clearInterval(target._spinInterval);
    					delete target._spinInterval;
    				}

    			},
    			"mousedown.button": function (event) {
    				if (event.button === 0 || (event.button === 1 && $.ig.util.isIE8)) {
                        target.addClass(self.css.buttonPressed);
                        target._pressed = true;
                        event.preventDefault();
                        if (type === "spinUp" || type === "spinDown") {
                            self._handleSpinEvent(type, target);
                        }
                    }
                },
    			"mouseup.button": function () {
    				target.removeClass(self.css.buttonPressed);
    				delete target._pressed;
    				if (target._spinTimeOut) {
    					clearTimeout(target._spinTimeOut);
    					delete target._spinTimeOut;
    				}
    				if (target._spinInterval) {
    					clearInterval(target._spinInterval);
    					delete target._spinInterval;
    				}
    			},
    			"click.button": function (event) {
    				self._triggerButtonClick(event, type);
    			}
    		});
    		/* jshint +W083*/
    	},
    	_detachButtonsEvents: function (target) {
    		if (target) {
    			target.off("mouseenter.button mouseleave.button mousedown.button mouseup.button click.button");
			}
    	},
    	_attachEvents: function () { //TextEditor 
    		var self = this;
    		self._super();
    		this._editorInput.on({
    			"focus.editor": function (event) {
    				self._setFocus(event);
    			},
    			"blur.editor": function (event) {
    				self._setBlur(event);
    			},
    			"paste.editor": function (event) {
    				self._pasteHandler(event);
    			},
    			"keydown.editor": function (event) {
    				self._currentInputTextValue = self._editorInput.val();
    				self._triggerKeyDown(event);
    			},
    			"keyup.editor": function (event) {
    			    self._triggerKeyUp(event);
    			  	self._processTextChanged();
    			},
    			"keypress.editor": function (event) {
    				self._triggerKeyPress(event);
    			},
    			"compositionstart.editor": function () {
    				self._compositionStartValue = self._editorInput.val();
    			},
    			"compositionend.editor": function () {
    				setTimeout(function () {
    					var  value = self._editorInput.val(), noCancel = self._triggerValueChanging(value);
    					if (noCancel) {
    						self._insert(value, self._compositionStartValue);
    						self._triggerValueChanged(value);
    					}
					}, 0);
    			}
    		});
    	},
    	_detachEvents: function () {
    		this._super();
    		this._editorInput.off("focus.editor blur.editor paste.editor keydown.editor keyup.editor keypress.editor compositionstart.editor compositionend.editor");
    	},
    	_processValueChanging: function (value) { //TextEditor

    	    if (value !== this.value()) {
    			if (!(this.value() === null && value === "")) {
    	        this._triggerInternalValueChange(value);
    	    }
		    }
    	},
    	_triggerInternalValueChange: function (value) { //TextEditor
    		var noCancel = this._triggerValueChanging(value);
    		if (noCancel) {
    			this._processInternalValueChanging(value);
    			
    			//We pass the new value in order to have the original value into the arguments
    			this._triggerValueChanged(value);

    		}
    	},
    	_processInternalValueChanging: function (value) { //TextEditor
    			if (this._validateValue(value)) {
    				this._updateValue(value);
    			} else {
    				//If the value is not valid, we clear the editor 
    				if (this.options.revertIfNotValid) {
    					value = this._valueInput.val();
    					this._updateValue(value);
    				} else {
    					this._clearValue();
    					value = this._valueInput.val();
    				}
    			}
    	},
    	_triggerKeyDown: function (event) { //TextEditor
    		//cancellable
    		var e = event, noCancel, activeItem, args, currentInputVal, selection;
    		args = {
    			owner: this,
    			element: event.target,
    			key: event.keyCode,
    			editorInput: this._editorInput
    		};
    		noCancel = this._trigger(this.events.keydown, event, args);
    		if (noCancel) {
    			//clear notifier
    			this._clearEditorNotifier();
    			if (e.keyCode === 13) {
    				if (event.altKey && this.options.textMode === "multiline") {
						// This is needed, because of the grid. By default the HTML textarea didn't go to next line on ALT + ENTER, but it should, because in grid updating, this is the used as a keyboard navigation to go the next line.
    					this._editorInput.val(this._editorInput.val() + "\n");
    				} else {
    					currentInputVal = this._editorInput.val();
    					if (this._dropDownList && this._dropDownList.is(":visible")) {
    						activeItem = this._dropDownList.children(".ui-igedit-listitem").filter("[data-active='true']");
    						if (activeItem.length > 0) {
    							//We use the same handler, because it runs the common logic for item selecting and so on. 
    							this._triggerListItemClick(activeItem);
    						} else {
    							this._processValueChanging(currentInputVal);
    						}
    					} else {
    						//We repeat the logic in case we don't have dropdown list. On eneter the value is updated with the current value into editorInput
    						this._processValueChanging(currentInputVal);
    					}
    				}
    			} else if (this._dropDownList) {
    				//Arrow Up
    				if (e.keyCode === 38) {
    					//Close if opened
    					if (e.altKey && this._dropDownList.is(":visible")) {
    						this._toggleDropDown();
    					} else if (this._dropDownList.is(":visible")) {
    						//hover previousItem
    						activeItem = this._dropDownList.children(".ui-igedit-listitem").filter("[data-active='true']");
    						if (activeItem.length > 0 && !activeItem.is(":first-child")) {
    							this._hoverPreviousDropDownListItem();
    						} else {
    							//Close DropDonw
    							this._toggleDropDown();
    						}
    					}
    				} else if (e.keyCode === 40 || (e.keyCode === 38 && e.altKey)) { //Arrow Down
    					if (!this._dropDownList.is(":visible")) {
    						//openDropDown
    						this._toggleDropDown();
    					} else {
    						//hover next element
    						this._hoverNextDropDownListItem();
    					}
    				} else if (e.keyCode === 27 && this._dropDownList.is(":visible")) { //Escape and dropdown is opened
    					//Close dropdown
    					this._toggleDropDown();
    				}
    			} else if (this.options.maxLength) {
    				currentInputVal = this._editorInput.val();
    				if (currentInputVal.length === this.options.maxLength && e.keyCode > 46 && !e.altKey && !e.ctrlKey && !e.shiftKey) {
    					selection = this._getSelection(this._editorInput[0]);
    					if (selection.start === selection.end) {
    						e.preventDefault();
    						e.stopPropagation();
    						this._sendNotification("warning", $.ig.util.stringFormat($.ig.Editor.locale.maxLengthWarningMsg, this.options.maxLength));
    					}

    				
    				}
    			}
    			    }
			//We need this flag into the derived method, because if the key has been canceled by the user, we should not proceed with the execution. 
    		return noCancel;
    	},
    	_triggerKeyUp: function (event) {
    		var args = {
    			originalEvent: event,
    			owner: this,
    			element: event.target,
    			editorInput: this._editorInput
    		};
    		this._trigger(this.events.keyup, event, args);
    	},
    	_validateNonCharacter: function (event) {
    		//we need this method only in firefox, as all other browsers handle nonChar keyboard iteractions and doesn't fire keypress events.
    		if ($.ig.util.isFF) {
    			var e = event;
    			// Allow: backspace, delete, tab, escape, enter and .
    			if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 190]) !== -1 ||
    				// Allow: Ctrl+A
					(e.which === 97 && e.ctrlKey === true) ||
					//Allow Ctrl+C
					(e.which === 99 && e.ctrlKey === true) ||
    				//Allow Ctrl+X
					(e.which === 120 && e.ctrlKey === true) ||
    				//Allow Ctrl+V
					(e.which === 118 && e.ctrlKey === true) ||
    				//Allow Ctrl+Z
					(e.which === 122 && e.ctrlKey === true) ||
    				//Allow Ctrl+Y
					(e.which === 121 && e.ctrlKey === true) ||
    				// Allow: home, end, left, right, down, up
					(e.keyCode >= 35 && e.keyCode <= 40)) {
    				// let it happen, don't do anything
    				return true;
    			}
    		} else {
    			//For all other browsers we rely only on _validateKey method
    			return false;
			}
    	},
    	_triggerKeyPress: function (event) { //TextEditor

    		if (this._validateKey(event) || this._validateNonCharacter(event)) {
    			var args = {
    				owner: this,
    				element: event.target,
    				key: event.keyCode,
    				editorInput: this._editorInput
    			};
    			if (this.options.preventSubmitOnEnter && event.keyCode === 13 && !event.shiftKey && this.options.textMode !== "multiline") {
    				event.preventDefault();
    				event.stopPropagation();
    			}
    			if (this.options.toUpper || this.options.toLower) {
    			    var keyCode = event.which ? event.which : event.keyCode;
    			    if (keyCode) {
    			        var charStr, transformedChar, key, selection, val;
    			        charStr = String.fromCharCode(keyCode);
    			        if (this.options.toUpper) {
    			            transformedChar = charStr.toLocaleUpperCase();
    			        } else {
    			            transformedChar = charStr.toLocaleLowerCase();
                        }
    			        key = transformedChar.charCodeAt(0);
    			        args.key = key;
    			        selection = this._getSelection(this._editorInput[0]);
    			        val = this._editorInput.val();

    			        this._editorInput.val(val.slice(0, selection.start) + transformedChar + val.slice(selection.end));

    			        // Move the caret
    			        this._setCursorPosition(selection.start + 1);
    			        event.preventDefault();
    			    }
    			}
    			return this._trigger(this.events.keypress, event, args);
    		} else {
    			event.preventDefault();
    			event.stopPropagation();
    		}
    	},
    	_triggerValueChanged: function (originalValue) {
    		var args = {
    			owner: this,
    			editorInput: this._editorInput,
    			newValue: this.options.value
    		};
    		if (originalValue) {
    			args.originalValue = originalValue;
    		}
    		this._trigger(this.events.valueChanged, null, args);
    	},
    	_triggerValueChanging: function (newValue) {
    		var args = {
    			owner: this,
    			editorInput: this._editorInput,
    			oldValue: this.value(),
				newValue: newValue
    		};
            return this._trigger(this.events.valueChanging, null, args);
    	},
    	_triggerListItemClick: function (item) {
    		var noCancel;
    		//Trigger itemSelecting (Cancellable)
    		noCancel = this._triggerDropDownItemSelecting(item);
    		if (noCancel) {
    			//TODO select closest parent class
    			$(item).parent().children(".ui-igedit-listitem").removeClass(this.css.listItemSelected);
    			$(item).addClass(this.css.listItemSelected);

    			noCancel = this._triggerDropDownClosing();
    			if (noCancel) {
    				this._hideDropDownList();
    				this._triggerDropDownClosed();
    			}
    			this._triggerDropDownItemSelected(item);

    			if (this.value() !== $(item).text()) {

    				this._currentInputTextValue = this._editorInput.val();
    				this._processValueChanging($(item).text());
    				this._processTextChanged();
    				this._enterEditMode();
    			}
    		}
    	},
    	_triggerButtonClick: function (event, buttonType) {
    		if (buttonType) {
    			switch (buttonType) {
    				case "dropdown": {    				
    					this._toggleDropDown();
    				}
    					break;
    				case "clear": {
    					this._currentInputTextValue = this._editorInput.val();
    					this._clearValue();
    					this._processTextChanged();
    					if (!this._editMode) {
    						this._exitEditMode();
    						this._triggerValueChanged();
    					} else {
    						this._enterEditMode();
    					}

    				}
    					break;
    			}
    		}
    	},
    	_triggerDropDownClosing: function () {
    		var args = {
    			editor: this._editorContainer, owner: this,
    			editorInput: this._editorInput,
    			list: this._dropDownList
    		};
    		return this._trigger(this.events.dropDownListClosing, null, args);
    	},
    	_triggerDropDownClosed: function () {
    		var args = {
    			editor: this._editorContainer, owner: this,
    			editorInput: this._editorInput,
    			list: this._dropDownList
    		};
    		this._trigger(this.events.dropDownListClosed, null, args);
    	},
    	_triggerDropDownOpening: function () {
    		var args = {
    			editor: this._editorContainer, owner: this,
    			editorInput: this._editorInput,
    			list: this._dropDownList
    		};
    		return this._trigger(this.events.dropDownListOpening, null, args);
    	},
    	_triggerDropDownOpened: function () {
    		var args = {
    			owner: this,
    			editorInput: this._editorInput,
    			list: this._dropDownList
    		};
    		return this._trigger(this.events.dropDownListOpened, null, args);
    	},
    	_triggerDropDownItemSelecting: function (item) {
    		var args = {
    			editor: this._editorContainer, owner: this,
    			editorInput: this._editorInput,
    			list: this._dropDownList,
				item: item
    		};
    		return this._trigger(this.events.dropDownItemSelecting, null, args);
    	},
    	_triggerDropDownItemSelected: function (item) {
    		var args = {
    			owner: this,
    			editorInput: this._editorInput,
    			list: this._dropDownList,
    			item: item
    		};
    		this._trigger(this.events.dropDownItemSelected, null, args);
    	},
    	_processTextChanged: function () {
    		var currentVal = this._editorInput.val(),
    			previousVal = this._currentInputTextValue;
    		if (previousVal === undefined) {
    			//In that case we don't have track of previous value, so we trigger the textChanged event
    			this._triggerTextChanged("", currentVal);
    		} else if (currentVal !== previousVal) {
    		    this._triggerTextChanged(previousVal, currentVal);
    		    if (this._validator) {
    		        this._validator._validateInternal(this.element);
			    }
			}
    	},
    	_triggerTextChanged: function (oldValue, newValue) {
    		var args = {
    			owner: this,
    			text: newValue,
    			oldText: oldValue ? oldValue : ""
    		};
    		this._trigger(this.events.textChanged, null, args);
    	},
    	_elementPositionInViewport: function (el) {
    			var areaTop = Math.ceil(el.parent().offset().top),
    				elementoffset = Math.ceil(el.offset().top),
    				elementHeight = Math.ceil(el.outerHeight()),
    				listVisibleHeight = el.parent().outerHeight(), result;
				if (elementoffset - areaTop < 0) {
					result = "top";
				} else if (elementoffset + elementHeight - areaTop < listVisibleHeight) {
					result = "inside";
				} else if (elementoffset + elementHeight - areaTop > listVisibleHeight) {
					result = "bottom";
				}
				return result;
    	},
    	_hoverPreviousDropDownListItem: function () {
    		var items = this._dropDownList.children(".ui-igedit-listitem"), newItem, currentItem;
    		if (items && items.length > 0) {
    			if (items.filter("[data-active='true']").length > 0) {
    				currentItem = items.filter("[data-active='true']");
    				newItem = currentItem.prev();
    				if (currentItem.is(":first-child")) {
    					if (this.options.spinWrapAround) {
    						newItem = items.last();
    						this._dropDownList.scrollTop(this._dropDownList.scrollTop() + newItem.position().top);
    					} else {
    						return;
    					}
    				} else {
    					if (this._elementPositionInViewport(newItem) === "top") {
    						this._dropDownList.scrollTop(this._dropDownList.scrollTop() - newItem.outerHeight());
    					}
    				}
    				currentItem.removeClass(this.css.listItemActive, this.options.listItemHoverDuration);
    				currentItem.removeAttr("data-active");
    				newItem.addClass(this.css.listItemActive, this.options.listItemHoverDuration);
    				newItem.attr("data-active", true);
    			}
    		}
    	},
    	_hoverNextDropDownListItem: function () {
    		var items = this._dropDownList.children(".ui-igedit-listitem"), newItem, currentItem;
    		if (items && items.length > 0) {
    			if (items.filter("[data-active='true']").length > 0) {
    				//we have already hovered item.
    				currentItem = items.filter("[data-active='true']");
    				newItem = currentItem.next();
    				if (currentItem.is(":last-child")) {

    					if (this.options.spinWrapAround) {
    						newItem = items.first();
    						this._dropDownList.scrollTop(this._dropDownList.scrollTop() + newItem.position().top);
    					} else {
    						return;
    					}
    				}
					//Element is below the viewPort and we need to scroll
    				if (this._elementPositionInViewport(newItem) === "bottom") {
							this._dropDownList.scrollTop(this._dropDownList.scrollTop() + newItem.outerHeight());
    				}
    				currentItem.removeClass(this.css.listItemActive, this.options.listItemHoverDuration);
    				currentItem.removeAttr("data-active");
    			} else {
    				newItem = items.filter(":visible").first();
    			}
    			newItem.addClass(this.css.listItemActive, this.options.listItemHoverDuration);
    			newItem.attr("data-active", true);
    		}
    	},
    	_pasteHandler: function (event) {
    		//TextEditor Handler
    	    var self = this, previousValue = $(event.target).val(), newValue;
    	    this._currentInputTextValue = this._editorInput.val();
    		this._timeouts.push(setTimeout(function () {
    			newValue = $(event.target).val();
    			self._insert(newValue, previousValue);
    		}, 10));
    	},
    	_insertHandler: function (string) {
    		var selection = this._getSelection(this.field()[0]),
				previousValue, newValue;
    		if (string) {
    			previousValue = this._editMode ? this._editorInput.val() : this.displayValue();
    			newValue = this._replaceDisplayValue(selection, previousValue, string);
    			this._insert(newValue, previousValue);
    		}
    	},
    	_replaceDisplayValue: function (selection, previousValue, string) {
    		return previousValue.substring(0, selection.start) + string + previousValue.substring(selection.end, previousValue.length);
    	},
    	_insert: function (newValue, previousValue) { // TextEditor
    	    var selection;
    		if (this.options.maxLength) {
    			if (newValue && newValue.toString().length >= this.options.maxLength) {
    				newValue = newValue.toString().substring(0, this.options.maxLength);
    				//Raise warning
    				this._sendNotification("warning", $.ig.util.stringFormat($.ig.Editor.locale.maxLengthErrMsg, this.options.maxLength));
    				}
    			}
    		if (this._validateValue(newValue)) {
                selection = this._getSelection(this._editorInput[0]);
    			if (this.options.toUpper) {
    				if (newValue) { newValue = newValue.toLocaleUpperCase(); }
    			} else if (this.options.toLower) {
    				if (newValue) { newValue = newValue.toLocaleLowerCase(); }
    			}
    			this._processValueChanging(newValue);
    			this._processTextChanged();
    			// Move the caret
    			this._setCursorPosition(selection.start + newValue.length);
    		} else {
    			this._editorInput.val(previousValue);
    		}
    	},
    	_clearDropDownHoverActiveItem: function () {
    		var hoveredItem = this._dropDownList.children(".ui-igedit-listitem").filter("[data-hovered='true']"),
    			activeItem = this._dropDownList.children(".ui-igedit-listitem").filter("[data-active='true']");
    		if (hoveredItem.length > 0) {
    			hoveredItem.removeClass(this.css.listItemHover);
    			hoveredItem.removeAttr("data-hovered");
    		}
    		if (activeItem.length > 0) {
    			activeItem.removeClass(this.css.listItemActive);
    			activeItem.removeAttr("data-active");
    		}
    	},
    	_showDropDownList: function () {
    		//Open Dropdown 
    		var direction;
    		this._positionDropDownList();
    		if (this._dropDownListOrientation === "up") {
				//We need this parameter as part of blind animation we're using
    			direction = "down";
    		} else {
    			direction = "up";
    		}
    	    try {
    	    	$(this._dropDownList).show('blind', { direction: direction }, this.options.dropDownAnimationDuration, $.proxy(this._triggerDropDownOpened, this));
    	    } catch (ex) {
    	    	$(this._dropDownList).show(this.options.dropDownAnimationDuration, $.proxy(this._triggerDropDownOpened, this));
    		}
    	},
    	_hideDropDownList: function () {		
    		var direction;
    		if (this._dropDownListOrientation === "up") {
    			//We need this parameter as part of blind animation we're using
    			direction = "down";
    		} else {
    			direction = "up";
    		}
    		try {
    			$(this._dropDownList).hide('blind', { direction: direction }, this.options.dropDownAnimationDuration,  $.proxy(this._triggerDropDownClosed, this));
    		} catch (ex) {
    			$(this._dropDownList).hide(this.options.dropDownAnimationDuration, $.proxy(this._triggerDropDownClosed, this));
    		}
    		this._clearDropDownHoverActiveItem();
    	},
    	_toggleDropDown: function () {
    		var noCancel;
			//Close dropdown
    		if (this._dropDownList.is(":visible")) {
    			noCancel = this._triggerDropDownClosing();
    			if (noCancel) {
					//Proceed with hiding
    				this._hideDropDownList();

    			}
    		} else {
    			//Open DropDown
    			noCancel = this._triggerDropDownOpening();
    			if (noCancel) {
    				//Proceed with hiding
    				this._editorInput.focus();
    				this._showDropDownList();
    			}

    		}
    	},
    	_validateKey: function (event) {
    		var ch, result;
    		if (this.options.excludeKeys) {
    		    ch = String.fromCharCode(event.charCode || event.which);
    			if ($.inArray(ch, this._excludeKeysArray) !== -1) {
    				result = false;
    			} else {
    				result = true;
    			}
    		} else if (this.options.includeKeys) {
    		    ch = String.fromCharCode(event.charCode || event.which);
    			if ($.inArray(ch, this._includeKeysArray) !== -1) {
    				result = true;
    			} else {
    				result = false;
    			}
    		} else {
    			result = true;
    		}
    		return result;
    	},
    	_enterEditMode: function () { //TextEditor
    		this._editMode = true;
    		var selection = this._getSelection(this._editorInput[0]);
    		this._positionCursor(selection.start, selection.end);
    		this._currentInputTextValue = this._editorInput.val();
    		this._processTextChanged();
    	},
    	_exitEditMode: function () { //TextEditor
    		//Update the editor input with display value
    		if (this.options.textMode === "text" && !$.ig.util.isIE8) {
				this._editorInput.attr("type", "text");
    		}
    		this._currentInputTextValue = this._editorInput.val();
    		this._editorInput.val(this._getDisplayValue());
    		this._editMode = false;
    		this._processTextChanged();
    	},
		//This method is used to get the display value according to masks, displayFactor and all the properties related to the value displayed when editor is blured. 
    	_getDisplayValue: function () { //igTextEditor
    		return this._valueInput.val();
    	},
        _getSelectionRange: function () {
    		var selection;
    		if (window.getSelection) {
    			selection = window.getSelection();
    			if (selection.rangeCount) {
    				return selection.getRangeAt(0);
    			}
    		} else if (document.selection) {
    			return document.selection.createRange();
    		}
    	},
    	_setCursorPosition: function (positionIndex) {
    		this._setSelectionRange(this._editorInput[0], positionIndex, positionIndex);
    	},
    	_setSelectionRange: function (input, selectionStart, selectionEnd) {
    		if (input.setSelectionRange) {
    			input.setSelectionRange(selectionStart, selectionEnd);
    		} else if (input.createTextRange) {
    			var range = input.createTextRange();
    			range.collapse(true);
    			range.moveEnd('character', selectionEnd);
    			range.moveStart('character', selectionStart);
    			range.select();
    		}
    	},
    	_positionCursor: function (startPostion, endPosition) {
    		var currentValue = this._editorInput.val(), self = this;

    		if (currentValue && currentValue.length > 0) {
    			//Proceed acording to the options.
    			switch (this.options.selectionOnFocus) {
    				case "selectAll": {
    					if ($.ig.util.isChrome || $.ig.util.isSafari) {
    						this._timeouts.push(setTimeout(function () {
    							self._editorInput.select();
    						}, 100));
    					} else {
    						this._editorInput.select();
    					}
    				}
    					break;
    				case "atStart": {
    					if ($.ig.util.isChrome || $.ig.util.isSafari) {
    						this._timeouts.push(setTimeout(function () {
    							self._setSelectionRange(self._editorInput[0], 0, 0);
    						}, 100));
    					} else {
    						this._setSelectionRange(this._editorInput[0], 0, 0);
    					}
    				}
    					break;
    				case "atEnd": {
    					if ($.ig.util.isChrome || $.ig.util.isSafari) {
    						this._timeouts.push(setTimeout(function () {
    							self._setSelectionRange(self._editorInput[0], currentValue.length, currentValue.length);
    						}, 100));
    					} else {
    						this._setSelectionRange(this._editorInput[0], currentValue.length, currentValue.length);
    					}    					
    				}
    					break;
    				case "browserDefault": {
    					if (startPostion) {
    						if (endPosition) {
    							if (endPosition > currentValue.length - 1) {
    								endPosition = currentValue.length - 1;
    							}
    						} else {
    							endPosition = startPostion;
    						}
    						if ($.ig.util.isChrome || $.ig.util.isSafari) {
    							this._timeouts.push(setTimeout(function () {
    								self._setSelectionRange(self._editorInput[0], startPostion, endPosition);
    							}, 100));
    						} else {
    							this._setSelectionRange(this._editorInput[0], startPostion, endPosition);
    						}
    					} else {
							//If there is no startSelection we use default behavior selectAll
    						if ($.ig.util.isChrome || $.ig.util.isSafari) {
    							this._timeouts.push(setTimeout(function () {
    								self._editorInput.select();
    							}, 100));
    						} else {
    							this._editorInput.select();
    						}
    					}

    				}
    					break;
    				default:
    			}
    		} else {
    			this._editorInput.select();
    		}
    	},
    	_spinUp: function () {
    		if (this._dropDownList && this._dropDownList.is(":visible")) {
    			this._hoverPreviousDropDownListItem();
    		}
    	},
    	_spinDown: function () {
    		if (this._dropDownList && this._dropDownList.is(":visible")) {
    			this._hoverNextDropDownListItem();
    		}
    	},
    	//We need this level of abstaction because of the numeric editors. 
    	_handleSpinUpEvent: function () {
    		this._spinUp();
    	},
    	//We need this level of abstaction because of the numeric editors. 
    	_handleSpinDownEvent: function () {
    		this._spinDown();
    	},
    	_handleSpinEvent: function (type, target) {
    		var self = this;
    		if (type === "spinUp") {    		  
    		    this._handleSpinUpEvent();
    		    if (!target.attr("disabled")) {
    		        target._spinTimeOut = setTimeout(function () {
    		            target._spinInterval = setInterval(function () {
    		                self._handleSpinUpEvent();
    		            }, 75);
    		        }, 300);
    		    }
    		} else if (type === "spinDown") {    		   
    		    this._handleSpinDownEvent();
    		    if (!target.attr("disabled")) {
    		        target._spinTimeOut = setTimeout(function () {
    		            target._spinInterval = setInterval(function () {
    		                self._handleSpinDownEvent();
    		            }, 75);
    		        }, 300);
    		    }
    		}
    		this._timeouts.push(target._spinTimeOut);
    	},
    	_clearValue: function () {
    		this._super();
    		if (this._dropDownList && this._dropDownList.children(".ui-igedit-listitemselected").length > 0) {
    			this._dropDownList.children(".ui-igedit-listitemselected").removeClass(this.css.listItemSelected);
    		}
    	},
    	_clearEditorNotifier: function () {
    	    var notifier = this._editorContainer.data("igNotifier");
    	    if (notifier && notifier.options.state === "warning" && notifier.isVisible()) {
    	        notifier.hide();
    		}
    	},
    	_getCursorPosition: function () {
    	    var selection = this._getSelection(this._editorInput[0]);
    	    if ((selection.end - selection.start) === this._editorInput.val().length && this._editorInput.val().length > 0) {
    			//whole value is selected. We use flag -1 in case of all text is selected 
    			return -1;
    		} else {
    			//if multiple selection is done we use the beginig of the selection as metric.
    			return selection.start;
    		}
    	},
    	_getSelection: function (editor) {
    	    var startPostion = 0, endPosition = 0;
    	    if (editor.selectionStart !== undefined) {
    	        startPostion = editor.selectionStart;
    	        endPosition = editor.selectionEnd;
    	    } else if (document.selection) {
                // IE8 support, from the current text selection:
    	        var globalSelection = document.selection.createRange(), range, rangeClone;
    	        if (globalSelection !== null) {
    	            range = editor.createTextRange();
					rangeClone = range.duplicate();
                    // editor selection:
					range.moveToBookmark(globalSelection.getBookmark());
					endPosition = range.text.length;
                    // select text up to the selection:
					rangeClone.setEndPoint('EndToStart', range);
					startPostion = rangeClone.text.length;
					// move end index with the start offset
					endPosition += startPostion;
				}
    		}
			return { start: startPostion, end: endPosition};
    	},
    	_getLocaleOption: function (key) {
    		var locale = this.options.locale;
    		if (locale && locale[key]) {
    			return locale[key];
    		} else if ($.ig && $.ig.Editor && $.ig.Editor.locale) {
    			return $.ig.Editor.locale[key];
    		} else {
    			return "";
    		}
    	},
        _listItems: function () {
    		return this._dropDownList.children(".ui-igedit-listitem");
    	},
    	_getListItemByIndex: function (index) {
    		return this._dropDownList.children(".ui-igedit-listitem:nth-child(" + (index + 1) + ")");
    	},
    	_getSelectedItemIndex: function () {
    		var items = this._listItems(), i;
    		for (i = 0; i < items.length; i++) {
    			if ($(items[i]).hasClass(this.css.listItemSelected)) {
    				return i;
    			}
    		}
    		return -1;
    	},
    	_setSelectedItemByIndex: function (index) {
    		var oldSelectedItem, newSelectedItem;
				
    		if (this._getSelectedItemIndex() !== index) {
    			oldSelectedItem = this.getSelectedListItem();
    			oldSelectedItem.removeClass(this.css.listItemSelected);
    			oldSelectedItem.removeAttr("data-active");
    			newSelectedItem = this._getListItemByIndex(index);
    			newSelectedItem.addClass(this.css.listItemSelected);
    			if (this.dropDownVisible()) {
    				newSelectedItem.attr("data-active", true);
    			}
    		}
    	},
    	// igTextEditor public methods
    	displayValue: function () {
    		/* Gets text in editor.
    			returnType="" Value of the editor. */
    		return this._getDisplayValue();
    	},
    	dropDownContainer: function () {
    		/* Gets reference to jquery object which is used as container of drop-down.
    			returnType="$" Returns reference to jquery object. */
    		return this._dropDownList ? this._dropDownList : null;
    	},
    	showDropDown: function () {
    		/* Shows the drop down list. */
    		this._showDropDownList();
    	},
    	hideDropDown: function () {
    		/* Hides the drop down list. */
    		this._hideDropDownList();
    	},
    	clearButton: function () {
    		/* Returns a reference to the clear button UI element of the editor.
    			returnType="$" Returns reference to jquery object.  */
    		return this._clearButton;
    	},
    	dropDownButton: function () {
    		/* Returns a reference to the clear button UI element of the editor.
    			returnType="$" Returns reference to jquery object. */
    		return this._dropDownButton;
    	},
    	spinUpButton: function () {
    		/* Returns a reference to the clear spin up UI element of the editor.
    			returnType="" */
    		return this._spinUpButton;
    	},
    	spinDownButton: function () {
    		/* Returns a reference to the clear spin down UI element of the editor.
    			returnType="" */
    		return this._spinDownButton;
    	},
    	dropDownVisible: function () {
    		/* Returns the visibility state of the drop down listing the items.
    			returnType="bool" The visibility state of the drop down. */
    		return this._dropDownList.is(":visible");
    	},
    	findListItemIndex: function (text, matchType) {
    		/* Finds index of list item by text that matches with the search parameters.
				paramType="string" optional="false" The text to search for in the drop down list
				paramType="startsWith|endsWith|contains|exactMatch " optional="true" The 
    			returnType="number" Returns index of the found . */

    		var list = this.options.listItems,
				matchCase = "i",
				index = -1,
    			regString, regExp, i;

    		if (!list || list.length === 0) {
    			return -1;
    		}
    		switch (matchType) {
    			case "startsWith":
    				regString = "^{pattern}";
    				break;
    			case "endsWith":
    				regString = "{pattern}$";
    				break;
    			case "exact":
    				regString = "^{pattern}$";
    				matchCase = undefined;
    				break;
    			default:
    				regString = "{pattern}";
    				break;
    		}
    		regExp = new RegExp(regString.replace("{pattern}", $.ig.util.escapeRegExp(text)), matchCase);
    		for (i = 0; i < list.length; i++) {
    			if (regExp.test(list[i])) {
    				index = i;
    			}
    		}
    		return index;
    	},
    	selectedListIndex: function (index) {
    		/* Gets sets selected index of list item.
				paramType="number" optional="true" The index of the item that needs to be selected.
    			returnType="number" Returns the selected index */
    		if (index !== undefined) {
    			this._setSelectedItemByIndex(index);
    		} else {
    			return this._getSelectedItemIndex();
    		}
    	},
    	getSelectedListItem: function () {
    		/* Gets calculated value of regional option used by numeric and date editors.
				paramType="" optional=""
    			returnType="" */
    		return this._listItems().filter(".ui-igedit-listitemselected");
    	},
    	getSelectedText: function () {
    		/* Gets selected text in editor.
				paramType="" optional=""
    			returnType="" */
    		var text = this._editMode ? this._editorInput.val() : this.displayValue(),
				startIndex = this.getSelectionStart(), 
				endIndex = this.getSelectionEnd();
    		if (startIndex === undefined || endIndex === undefined || startIndex === null || endIndex === null || startIndex === endIndex) {
    			return "";
    		}
    		return text.substring(startIndex, endIndex);
    	},
    	getSelectionStart: function () {
    		/* Gets start index of the selected text in editor.
    			returnType="number" */
    	    return this._getSelection(this._editorInput[0]).start;
    	},
    	getSelectionEnd: function () {
    		/* Gets selectedGets end index of the selected text in editor.
    			returnType="number" */
    	    return this._getSelection(this._editorInput[0]).end;
    	},
    	insert: function (string) {
    		/* Paste text at location of caret. Note: method raises the "valueChanged" event.
				paramType="string" optional="false" */
    		this._insertHandler(string);
    	},
    	select: function (start, end) {
    		/* Selects text in editor. If parameters are equal, then than method sets location of caret. That method has effect only when editor has focus.
				paramType="number" optional="false" Start of the selection.
				paramType="number" optional="false" End of the selection. */
    		this._setSelectionRange(this._editorInput[0], start, end);
    	},
    	spinUp: function () {
    		/* Increments value in editor according to the parameter. If editor has listItems, then that method increments or decrements selected index in list and sets value in editor to new selected item.
    			returnType="$" Returns reference to jquery object.*/
    		this._spinUp();
    	},
    	spinDown: function () {
    		/* Decrements  value in editor according to the parameter. If editor has listItems, then that method increments or decrements selected index in list and sets value in editor to new selected item.
    			returnType="$" Returns reference to jquery object.*/
    		this._spinDown();
    	}
    });

    $.widget('ui.igNumericEditor', $.ui.igTextEditor, {
    	options: {
    		/* type="object" Sets gets custom regional settings for editor. If it is string, then $.ig.regional[stringValue] is assumed. */
    		regional: null,
    		/* type="string" Sets gets the character, which is used as negative sign.
				Note: This option has priority over possible regional settings. 
				Note: Even if the default value is null - if internationalization file is provided and it contains default values for those properties the values are imlicitly set. */
    		negativeSign: null,
    		/* type="string" Sets gets the string, which is used as negative pattern. The "n" flag represents the value of number. The "-" and "()" flags are static part of pattern.
				Note: This option has priority over possible regional settings. 
				Note: Even if the default value is null - if internationalization file is provided and it contains default values for those properties the values are imlicitly set. */
    		negativePattern: null,
    		/* type="string" Sets gets the character, which is used as decimal separator.
				Note: this option has priority over possible regional settings. 
				Note: Even if the default value is null - if internationalization file is provided and it contains default values for those properties the values are imlicitly set. */
    		decimalSeparator: null,
    		/* type="string" Sets gets the character, which is used as separator for groups (like thousands).
				That option has effect only in display mode(no focus).
				Note: this option has priority over possible regional settings. 
				Note: Even if the default value is null - if internationalization file is provided and it contains default values for those properties the values are imlicitly set. */
    		groupSeparator: null,
    		/* type="array" (array of number objects) Sets gets the number of digits in integer part of number, which are divided into groups.
				The "groupSeparator" is inserted between groups.
				If the sum of all values in array is smaller than the length of integer part, then the last item in array is used for all following groups.
				Count of groups starts from the decimal point (from right to left).
				That option has effect only in display mode(no focus).
				Note: this option has priority over possible regional settings. 
				Note: Even if the default value is null - if internationalization file is provided and it contains default values for those properties the values are imlicitly set. */
    		groups: null,
    		/* type="number" Sets gets the maximum number of decimal places which are used in display mode(no focus).
				Note: this option has priority over possible regional settings. 
				Note: In case of min decimals value higher than max decimals - max decimals are equaled to min decimals property. 
				Note: Even if the default value is null - if internationalization file is provided and it contains default values for those properties the values are imlicitly set. */
    		maxDecimals: null,
    		/* type="number" Sets gets the minimum number of decimal places which are used in display (no focus) state.
				If number of digits in fractional part of number is less than the value of this option, then the "0" characters are used to fill missing digits.
				Note: This option has priority over possible regional settings. 
				Note: In case of min decimals value higher than max decimals - max decimals are equaled to min decimals property. 
				Note: Even if the default value is null - if internationalization file is provided and it contains default values for those properties the values are imlicitly set. */
    		minDecimals: null,
    		/* type="left|right|center" Sets gets horizontal alignment of text in editor. If that option is not set, then 'right' is used for 'numeric', 'currency' and 'percent' editors and the 'left' is used for all other types of editor.
				left type="string"
				right type="string"
				center type="string"
			*/
    		textAlign: "right",
    		/* type="double|float|long|ulong|int|uint|short|ushort|sbyte|byte" Sets gets type of value returned by the get of value() method. That also affects functionality of the set value(val) method and the copy/paste operations of browser.
				double type="string" the Number object is used with limits of double and if value is not set, then the null or Number.NaN is used depending on the option 'nullable'. Note: that is used as default.
				float type="string" the Number object is used with limits of float and if value is not set, then the null or Number.NaN is used depending on the option 'nullable'.
				long type="string" the Number object is used with limits of signed long and if value is not set, then the null or 0 is used depending on the option 'nullable'. 
				ulong type="string" the Number object is used with limits of unsigned long and if value is not set, then the null or 0 is used depending on the option 'nullable'.
				int type="string" the Number object is used with limits of signed int and if value is not set, then the null or 0 is used depending on the option 'nullable'.
				uint type="string" the Number object is used with limits of unsigned int and if value is not set, then the null or 0 is used depending on the option 'nullable'.
				short type="string" the Number object is used with limits of signed short and if value is not set, then the null or 0 is used depending on the option 'nullable'.
				ushort type="string" the Number object is used with limits of unsigned short and if value is not set, then the null or 0 is used depending on the option 'nullable'.
				sbyte type="string" the Number object is used with limits of signed byte and if value is not set, then the null or 0 is used depending on the option 'nullable'.
				byte type="string" the Number object is used with limits of unsigned byte and if value is not set, then the null or 0 is used depending on the option 'nullable'.
			*/
    		dataMode: 'double',
    		/* type="number" Sets gets the minimum value which can be entered in editor by end user. */
    		minValue: null,
    		/* type="number" Sets gets the maximum value which can be entered in editor by end user. */
    		maxValue: null,
    		/* type="bool" Sets gets ability to prevent null value.
				If that option is disabled, and editor has no value, then value is set to 0 (or minValue/maxValue).
			*/
    		allowNullValue: false,
    		/* type="number" Sets gets delta-value which is used to increment or decrement value in editor on spin events. If value is set to negative value an exception is thrown. Non integer value is supported only for dataMode double and float.*/
    		spinDelta: 1,
    		/* type="null|E|e|E+|e+"
				Sets gets support for E-power format in edit mode.
				If that option is set, then numeric value appears as a string with possible E-power flag. In edit mode the "E" or "e" character can be entered as well.
				Notes: The "+" character is not supported in edit mode. 
				null type="object" scientific format is disabled.
				E type="string" scientific format is enabled and the "E" character is used.
				e type="string" scientific format is enabled and the "e" character is used.
				E+ type="string" scientific format is enabled and the "E" character is used. The "E+" is used for positive values in display mode.
				e+ type="string" scientific format is enabled and the "e" character is used. The "e+" is used for positive values in display mode.
			*/
    		scientificFormat: null,
    		/* type="bool" Sets gets ability to automatically set value in editor to opposite limit, when spin action reached minimum or maximum limit. */
    		spinWrapAround: false,
            /* Removed from numeric editor options*/
    		maxLength: null,
    	    /* Removed from numeric editor options*/
    		excludeKeys: null,
    	    /* Removed from numeric editor options*/
    		includeKeys: null
    	},
    	events: {
    		/* igWidget events go here */
    	},
    	css: {

    		/* Class applied to the editing element of numeric editor when value is negative. The class is applied only when the editor is in display mode (no focus). Default value is 'ui-igedit-negative' */
    		negative: 'ui-igedit-negative'
    	},
    	_create: function () { //Numeric Editor
			//We need this option internaly for parsing the value, set this option via method so we can overwrite it. 
    		$.ui.igTextEditor.prototype._create.call(this);
    		//TODO - make this as an option for using native input
    		if (!$.ig.util.isIE8) {
    			this._editorInput.attr("type", "tel");
    		}
    	},
    	_initialize: function () {
    		this._super();
    		this._applyRegionalSettings();
    		this._applyDataModeSettings();
    		this._setNumericType();
    		var numericChars = "0123456789", dataMode = this.options.dataMode;
    		//Allow decimal separator as a char.
    		// When the dataMode is set to int, decimal separator should not be allowed
    		if (dataMode === "double" || dataMode === "float") {
    		    numericChars += this.options.decimalSeparator;
    		    // K.D. September 25th, 2015 The decimal separator key on the keyboard is always the 110 and 190 keycodes, which is '.'
    		    if (this.options.decimalSeparator !== '.') {
    		        numericChars += '.';
    		    }
    		}
    		if (this._getScientificFormat()) {
    			numericChars += this._getScientificFormat();
    		}
    		//Allow negativeSign as a char only where negative values are supported
    		if (dataMode === "double" || dataMode === "float" || dataMode === "long" || dataMode === "int" || dataMode === "short" || dataMode === "sbyte") {
    			numericChars += this.options.negativeSign;
    		}
    		//Setting Exclude keys is not allowed into numeric/percent/currency editor
    		if (this.options.excludeKeys) {
    			this.options.excludeKeys = null;
    		}
    		//This property is only internally used and it's not configurable in this widget.
    		this.options.includeKeys = numericChars;
    	},
    	_setNumericType: function () {
    		this._numericType = "numeric";
    	},
    	_getScientificFormat: function () {
    		var result;
    		if (this.options.scientificFormat) {
    			switch (this.options.scientificFormat) {
    				case "E":
    				case "E+": {
    					result = "E";
    				}
    					break;
    			    case "e":
    			    case "e+": {
    			        result = "e";
    			    }
    					break;
    				default: {
						result = "e";
						throw ($.ig.Editor.locale.scientificFormatErrMsg);
    				}
    			}
    		} else {
    			result = null;
    		}
    		return result;
    	},
    	_applyRegionalSettings: function () { //Numeric
			
    		this.options.negativeSign = this._getRegionalOption("negativeSign");
    		this.options.negativePattern = this.options.negativePattern || this._getRegionalOption("numericNegativePattern");
    		this.options.decimalSeparator = this.options.decimalSeparator || this._getRegionalOption("numericDecimalSeparator");
    		this.options.groupSeparator = this.options.groupSeparator || this._getRegionalOption("numericGroupSeparator");
            this.options.groups = this.options.groups || this._getRegionalOption("numericGroups");
    		this.options.maxDecimals = this.options.maxDecimals === null ? this._getRegionalOption("numericMaxDecimals") : this.options.maxDecimals;
    		this.options.minDecimals = this.options.minDecimals === null ? this._getRegionalOption("numericMinDecimals") : this.options.minDecimals;
    		
    	},
    	_applyOptions: function () { //NumericEditor
    		var delta, fractional;
    		this._super();
    		if (this.options.spinDelta !== 1) {
    			delta = this.options.spinDelta;
				if (typeof delta !== "number") {
					this.options.spinDelta = 1;
					throw new Error($.ig.Editor.locale.spinDeltaIsOfTypeNumber);
				}
    			if (delta < 0) {
					this.options.spinDelta = 1;
					throw new Error($.ig.Editor.locale.spinDeltaCouldntBeNegative);
    			}
    			if (this.options.dataMode === "float" || this.options.dataMode === "double") {
    				//Validate if the fractional part is longer than maxDecimals
    				if (delta % 1 !== 0) {
    					fractional = delta.toString().substring(delta.toString().indexOf(".") + 1);
    					if (fractional.toString().length > this.options.maxDecimals) {
    					    throw ($.ig.util.stringFormat($.ig.Editor.locale.spinDeltaContainsExceedsMaxDecimals, this.options.maxDecimals));
    					}
    				}
    			} else {
					//This means the value is integer, without floating point
    				if (delta % 1 !== 0) {
    				    throw ($.ig.Editor.locale.spinDeltaIncorrectFloatingPoint);
    				}
    			}
    		}
    		if (this.options.scientificFormat) {
    			this.options.spinDelta = Number(this.options.spinDelta.toExponential());
    		}
            if (this.options.maxLength !== null) {
                this.options.maxLength = null;
            }
    	},
    	_setOption: function (option, value) { // igNumericEditor
    		/* igNumericEditor custom setOption goes here */
    		var prevValue = this.options[option];
    		if (prevValue === value) {
    				return;
    			}
    		// The following line applies the option value to the igWidget meaning you don't
    		// have to perform this.options[option] = value;
    		$.Widget.prototype._setOption.apply(this, arguments);
    		switch (option) {
    			case "spinDelta": {
    				if (typeof value !== "number") {
						this.options[option] = prevValue;
						throw new Error($.ig.Editor.locale.spinDeltaIsOfTypeNumber);
    				} else if (value < 0) {
    					this.options[option] = prevValue;
    					throw new Error($.ig.Editor.locale.spinDeltaCouldntBeNegative);
    				} else if ((this.options.dataMode !== "float" && this.options.dataMode !== "double") && value % 1 !== 0) {
    					this.options[option] = prevValue;
    					throw new Error($.ig.Editor.locale.spinDeltaIncorrectFloatingPoint);
    				} else if (this.options.scientificFormat) {
    					this.options[option] = Number(value.toExponential());
    		}
    				break;
    			}
    			case "minDecimals",
    				 "maxDecimals":
    				value = parseFloat(value);
    				if (isNaN(value)) {
    					this.options[option] = prevValue;
    					throw new Error($.ig.Editor.locale.notEditableOptionByInit);
    				}
    				break;
    			default: {
    				//In case no propery matches, we call the super. Into the base widget default statement breaks
    					this.options[option] = prevValue;
    					this._super(option, value);
    				}
    				break;
    		}
    	},
    	_processValueChanging: function (value) { //NumericEditor
    	    if (typeof value === 'string' || value instanceof String) {
    	        value = value.trim();
    	        value = this._parseNumericValueByMode(value, this._numericType, this.options.dataMode);
    	        if (this._numericType === "percent" && this.options.displayFactor) {
    	        	// TODO - any logic related to "percent" should not be in numeric editor.
    	        	value /= this.options.displayFactor;
    	        }
    	    }
    	    this._super(value);
    	},
    	_processInternalValueChanging: function (value) { //NumericEditor
    		if (!this._validateValue(value)) {
    			value = this._parseNumericValueByMode(value, this._numericType, this.options.dataMode);
    			if (value !== "" && !isNaN(value)) {
    				if (this.options.revertIfNotValid) { // TODO VERIFY!!! revertIfNotValid > minValue/maxValue
    					value = this._valueInput.val();
    				} else {
    					if (value <= this.options.minValue) {
    						value = this.options.minValue;
    					} else {
    						value = this.options.maxValue;
    					}
    				}
    			} else {
    				if (this.options.allowNullValue) { // TODO VERIFY!!! allowNullValue > revertIfNotValid
    					value = this.options.nullValue;  
    				} else {
    					if (this.options.revertIfNotValid) {
    						value = this._valueInput.val();
    					} else {
    						value = 0; // TODO VERIFY!!! If value is "" and allowNullValue and revertIfNotValid is false, then becasue it is numeric editor we set it to 0. right?
    						if (this.options.minValue > 0) {
    							value = this.options.minValue;
    						} else if (this.options.maxValue < 0) {
    							value = this.options.maxValue;
    						} else {
    							value = 0;
							}
    					}
    				}
    			}
    		}
    		if (value !== this.value()) {
    		    this._updateValue(value);
    		}    		
    		this._setSpinButtonsState(value);
    	},
    	_triggerKeyDown: function (event) { //NumericEditor
    		var e = event, noCancel, args, currentInputVal;
    		args = {
    			owner: this,
    			element: event.target,
    			key: event.keyCode,
    			editorInput: this._editorInput
    		};
    		noCancel = this._trigger(this.events.keydown, event, args);
    		if (noCancel) {
    		    //clear notifier
    		    this._clearEditorNotifier();
    		    if (e.keyCode === 13) {
    		        currentInputVal = this._editorInput.val();
    		        //We repeat the logic in case we don't have dropdown list. On eneter the value is updated with the current value into editorInput
    		        this._processValueChanging(currentInputVal);

    		    } else if (e.keyCode === 38) {
    		        //Arrow Up
    		        //Close if opened
    		        if (e.altKey && this._dropDownList && this._dropDownList.is(":visible")) {
    		            this._toggleDropDown();
    		        } else if(!this.options.readOnly) {
    		            this._handleSpinUpEvent();
    		        }
    		    } else if (e.keyCode === 40) {//Arrow Down
    		        if (e.altKey && this._dropDownList && !this._dropDownList.is(":visible")) {
    		            //openDropDown
    		            this._toggleDropDown();
    		        } else if (!this.options.readOnly) {
    		            //hover next element
    		            this._handleSpinDownEvent();
    		        }
    		    } else if (e.keyCode === 27 && this._dropDownList && this._dropDownList.is(":visible")) { //Escape and dropdown is opened
    		        //Close dropdown
    		        this._toggleDropDown();
    		    } else if (this.options.maxLength) {
    		        currentInputVal = this._editorInput.val();
    		        if (currentInputVal.length === this.options.maxLength && e.keyCode > 46 && !e.altKey && !e.ctrlKey && !e.shiftKey) {
    		            e.preventDefault();
    		            e.stopPropagation();
    		            ////Process notification
    		            //TODO
    		        }
    		    }
    		}
    	},
    	_applyDataModeSettings: function () {
    		//We need to adjust max decimals, based on the dataMode limits
    		var doubleMaxDecimals = 15;
    		switch (this.options.dataMode) {
    			case "double": {
    				this._setMinMaxValues(-(Number.MAX_VALUE), Number.MAX_VALUE);
    				this._setMinMaxDecimals(doubleMaxDecimals);
    			}
    				break;
    			case "float": {
    				var floatMaxDecimals = 7, floatMinValue = -3.40282347e38, floatMaxValue = 3.40282347e38;
    				this._setMinMaxValues(floatMinValue, floatMaxValue);
    				this._setMinMaxDecimals(floatMaxDecimals);
    			}
    				break;
    			case "long": {
    				var longMinValue = -9223372036854775807, longMaxValue = 9223372036854775807;
    				this._setMinMaxValues(longMinValue, longMaxValue);
    			}
    				break;
    			case "ulong": {
    				var ulongMinValue = 0, ulongMaxValue = 18446744073709551615;
    				this._setMinMaxValues(ulongMinValue, ulongMaxValue);
    			}
    				break;
    			case "int": {
    				var intMinValue = -2147483647, intMaxValue = 2147483647;
    				this._setMinMaxValues(intMinValue, intMaxValue);
    			}
    				break;
    			case "uint": {
    				var uintMinValue = 0, uintMaxValue = 4294967295;
    				this._setMinMaxValues(uintMinValue, uintMaxValue);
    			}
    				break;
    			case "short": {
    				var shortMinValue = -32768, shortMaxValue = 32767;
    				this._setMinMaxValues(shortMinValue, shortMaxValue);
    			}
    				break;
    			case "ushort": {
    				var ushortMinValue = 0, ushortMaxValue = 65535;
    				this._setMinMaxValues(ushortMinValue, ushortMaxValue);
    			}
    				break;
    			case "sbyte": {
    				var sbyteMinValue = -127, sbyteMaxValue = 127;
    				this._setMinMaxValues(sbyteMinValue, sbyteMaxValue);
    			}
    				break;
    			case "byte": {
    				var byteMinValue = 0, byteMaxValue = 256;
    				this._setMinMaxValues(byteMinValue, byteMaxValue);
    			}
    				break;
    			//If dataMode doesn't match the editor fails back to dataMode double
    			default: {
    				this.options.dataMode = "double";
    				this._setMinMaxValues(Number.MIN_VALUE, Number.MAX_VALUE);
    				this._setMinMaxDecimals(doubleMaxDecimals);
    			}
    		}
    	},
    	_setMinMaxDecimals: function (typeMaxDecimals) {
    		if (this.options.maxDecimals === null || this.options.maxDecimals > typeMaxDecimals) {
    			this.options.maxDecimals = typeMaxDecimals;
    		}
    		//this.options.numericMinDecimals = this._getRegionalOption("numericMinDecimals");
    		//In case of conflict between min and max decimals - both values are equaled to the max decimals
    		if (this.options.minDecimals && this.options.minDecimals > this.options.maxDecimals) {
    			this.options.maxDecimals = this.options.minDecimals;
    		}
    	},
    	_setMinMaxValues: function (typeMinValue, typeMaxValue) {
    		//Set bounderies based on the type
    		if (this.options.minValue === null || this.options.minValue < typeMinValue) {
    			this.options.minValue = typeMinValue;
    		}
    		if (this.options.maxValue === null || this.options.maxValue > typeMaxValue) {
    			this.options.maxValue = typeMaxValue;
    		}
    	},
    	_parseNumericValueByMode: function (value, numericEditorType, dataMode) { //NumericEditor
    		var val, stringValue, decimalSeparator, groupSeparator, minDecimals, maxDecimals;
    		decimalSeparator = this.options.decimalSeparator;
    		groupSeparator = this.options.groupSeparator;
    		minDecimals = this.options.minDecimals;
    		maxDecimals = this.options.maxDecimals;

    		if (value === null || value === "") { // TODO VERIFY _validateValue and _updateValue both have cases calling parse with null!
    		    return value;
    		}

    		value = value.toString().replace(new RegExp(groupSeparator, "g"), ""); // TODO VERIFY Remove group separator cause parseInt("1,000") returns 1?
    		if (numericEditorType === "percent") {
    			value = value.replace(this.options.percentSymbol, "").trim();
    		} else if (numericEditorType === "currency") {
    			value = value.replace(this.options.currencySymbol, "").trim();
    		}
    		if (dataMode === "double" || dataMode === "float") {
    			stringValue = value.toString().toLowerCase();
    			if (stringValue.indexOf("e") !== -1) {
    				//In that case leave the value as it is
    				//TODO work on validation method
    				val = value;
    			} else {
    				//In that case we need to validate the value against the constraints. 
    				if (stringValue.indexOf(decimalSeparator) !== -1 || stringValue.indexOf(".") !== -1) {
    					var integerDigits, fractionalDigits;
    					if (stringValue.indexOf(".") !== -1) {
    						decimalSeparator = ".";
						}
    					fractionalDigits = stringValue.substring(stringValue.indexOf(decimalSeparator) + 1);
						//In case of pasted value with multiple decimal points. We can't use parseFloat because we want to keep the number of the fractional digits, but parseFloat cuts to 6th
    					if (fractionalDigits.indexOf(decimalSeparator) > 0) {
    						fractionalDigits = fractionalDigits.substring(0, fractionalDigits.indexOf(decimalSeparator));
    					}
    					if (fractionalDigits.length > maxDecimals) {
    						fractionalDigits = fractionalDigits.substring(0, maxDecimals);
    					}
    					integerDigits = stringValue.substring(0, stringValue.indexOf(decimalSeparator));
    					//We want to evaluate the number without losing fractional digits, as parseFloat cuts six digits after the decimal point.
    					val = (integerDigits + "." + fractionalDigits) / 1;
    				} else {
    					//In that case we don't have fractional digits, so we can use ParseInt for the integer digits.
    					val = parseFloat(parseInt(value).toFixed(minDecimals));
    				}
    			}
    		} else {
    			if (this._numericType === "percent" && this.options.displayFactor === 100 && this.options.dateMode === "int" && parseInt(value) !== parseInt(this._editorInput.val())) {
					// TODO - This is edge case
    				val = value;
    			} else {
    				val = parseInt(value);
    			}
    		}
    		if (this.options.scientificFormat && val.toString().toLowerCase().indexOf("e") === -1) {
    			val = val.toExponential();
    		}
    		return val;
    	},
		//This method validates and updates the value input the hidden input
    	_updateValue: function (value) { //Numeric Editor
    		//WE should detect dataMode, so we can use the options. 
    		var val, dataMode = this.options.dataMode;
    		if (value === "" && this.options.allowNullValue) {
    			val = this.options.nullValue;
    			this._valueInput.val("");
    		} else if (value === this.options.nullValue && value === null) {
    			val = value;
    			this._valueInput.val("");
    		} else {
    			val = this._parseNumericValueByMode(value, this._numericType, dataMode);
    			this._valueInput.val(val);
    		}
    		this.options.value = val;
    	},
    	_validateKey: function (event) { //NumericEditor
    		if (this._super(event)) {
    		    var dataMode = this.options.dataMode, negativeSign = this.options.negativeSign, ch, val, cursorPos = this._getCursorPosition(),
    		        isDecimal = event.which ? event.which === 46 : false;
    		    ch = String.fromCharCode(event.charCode || event.which);
    		    if (ch === negativeSign && cursorPos > 0) {
    		        return false;
                }

				//We need this extra validation in case the user tries to enter decimal separator multiple times
    			if (dataMode === "double" || dataMode === "float") {
    				var decimalSeparator = this.options.decimalSeparator;
    				//val = $(event.target).val();
    				val = this._editorInput.val();
    				if (decimalSeparator !== '.' && isDecimal && (val.indexOf('.') !== -1 || val.indexOf(decimalSeparator) !== -1) && cursorPos !== -1) {
    				    return false;
    				}
    				if (((ch === decimalSeparator || isDecimal) && (val.indexOf(decimalSeparator) !== -1 || val.indexOf('.') !== -1) && cursorPos !== -1) || (ch === negativeSign && val.indexOf(negativeSign) !== -1 && cursorPos !== -1)) {
						//We already have decimal separator so prevent default
    					return false;
    				} else {
    					return true;
    				}
    			} else if (dataMode === "long" || dataMode === "int" || dataMode === "short" || dataMode === "sbyte") {
    				val = $(event.target).val();
    				if (ch === negativeSign && val.indexOf(negativeSign) > 0 && cursorPos !== -1) {
    					//We already have decimal separator so prevent default
    					return false;
    				} else {
    					return true;
    				}
    			} else {
					//If the dataMode differs from double, or float and the super method returns true the cher is valid
    				return true;
    			}
    		} else {
				//If the super method fails, the char is not allowed
    			return false;
    		}
    		//return true;
    	},
    	_disableSpinButton: function (target) {
    	    if (target && !target.attr("disabled") && !this.options.spinWrapAround) {
    	        target.addClass(this.css.disabled);
    	        target.attr("disabled", true);
    	        target.removeClass(this.css.buttonHover);
    	        if (target._pressed) {
    	            delete target._pressed;
    	            target.removeClass(this.css.buttonPressed);
    	        }
    	        if (target._spinTimeOut) {
    	            clearTimeout(target._spinTimeOut);
    	            delete this._spinUpButton._spinTimeOut;
    	        }
    	        if (target._spinInterval) {
    	            clearInterval(target._spinInterval);
    	            delete target._spinInterval;
    	        }
    	        this._detachButtonsEvents(target);
    	    }
    	},
    	_enableSpinButton: function (target, type) {    	   
    	    if (target && target.attr("disabled")) {
    	        target.removeClass(this.css.disabled);
    	        target.attr("disabled", false);
    	        this._attachButtonsEvents(type, target);
    	    }    	    
    	},
    	_setSpinButtonsState: function (val) {
    	    if (typeof val === 'string' || val instanceof String) {
    	        val = val.trim();
    	    }
    	    if (val === null) {
    	    	this._enableSpinButton(this._spinDownButton, "spinDown");
    	    	this._enableSpinButton(this._spinUpButton, "spinUp");
    	    	return;
			}
            if (val !== "" && !this.options.spinWrapAround) {
                if (val >= this.options.maxValue) {
                    this._disableSpinButton(this._spinUpButton);
                    this._enableSpinButton(this._spinDownButton, "spinDown");
                    //Raise Warning level 2
                    this._sendNotification("warning", $.ig.util.stringFormat($.ig.Editor.locale.maxValErrMsg, this.options.maxValue));
                } else if (val <= this.options.minValue) {
                    this._disableSpinButton(this._spinDownButton);
                    this._enableSpinButton(this._spinUpButton, "spinUp");
                    //Raise Warning level 2 
                    this._sendNotification("warning", $.ig.util.stringFormat($.ig.Editor.locale.minValErrMsg, this.options.minValue));
                }
                else {
                    this._enableSpinButton(this._spinDownButton, "spinDown");
                    this._enableSpinButton(this._spinUpButton, "spinUp");
                }
            }
        },          
    	_validateValue: function (val) { //Numeric Editor
    		var result;
    		if (this._super(val) && !isNaN(val = this._parseNumericValueByMode(val, this._numericType, this.options.dataMode))) { // TODO VERIFY it was !isNaN(parseFloat(val), but this is not OK. The case where you press enter then value is updated, and then on TAB the value isNaN "$123.90"
    			if (val > this.options.maxValue) {
    				result = false;
    			    if (this.options.revertIfNotValid) {
    				    //Raise Warning level 2
    			        this._sendNotification("warning", $.ig.util.stringFormat($.ig.Editor.locale.maxValExceedRevertErrMsg, this.options.maxValue));
    			    }
    			} else if (val < this.options.minValue) {
    			    result = false;
    			    if (this.options.revertIfNotValid) {
    				    //Raise Warning level 2
    			        this._sendNotification("warning", $.ig.util.stringFormat($.ig.Editor.locale.minValExceedRevertErrMsg, this.options.minValue));
    			    }
    			} else {
    				result = true;
    			}
    		} else {
    			result = false;
    		}
    		return result;
    	},
        _insert: function (newValue, previousValue) { //NumericEditor            
    		if (!isNaN(newValue = this._parseNumericValueByMode(newValue, this._numericType, this.options.dataMode))) {

    		if (this.options.maxValue && newValue > this.options.maxValue) {
    			newValue = this.options.maxValue;
    		} else if (this.options.minValue && newValue < this.options.minValue) {
    			newValue = this.options.minValue;
    		}

    		if (!this._validateValue(newValue) && this.options.revertIfNotValid) {
                newValue = previousValue;               
    			}
    			
    		} else if (this.options.revertIfNotValid) {
    			newValue = previousValue;
    		} else {
    			newValue = "";
    		}
    		this._editorInput.val(newValue);
            this._setSpinButtonsState(newValue);
            this._processTextChanged();
    	},
    	_clearValue: function () { //Numeric Editor
    		if (this.options.allowNullValue) {
    			this._updateValue(this.options.nullValue);
    			if (this.options.nullValue === null) {
    				this._editorInput.val('');
    			} else {
    				this._editorInput.val(this.options.nullValue);
    			}
    		} else {
				//If the min value is different from zero, we clear the value with the minimum value. 
    			if (this.options.minValue && this.options.minValue > 0) {
    				this._updateValue(this.options.minValue);
    				this._editorInput.val(this.options.minValue);
                } else if (this.options.maxValue && this.options.maxValue < 0) {
    				this._updateValue(this.options.maxValue);
    				this._editorInput.val(this.options.maxValue);
                } else {
                    if (this.value()) {
                        this._updateValue(0);
    				    this._editorInput.val(0);
                    }    				
    			}
    		}
    		if (this.dropDownContainer() && this.dropDownContainer().children(".ui-igedit-listitemselected").length > 0) {
    			this.dropDownContainer().children(".ui-igedit-listitemselected").removeClass(this.css.listItemSelected);
    		}
    	},
    	_getRegionalOption: function (key) {
    		var regional = this.options.regional;
    		if (this.options[key]) {
    			return this.options[key];
    		}
    		if (typeof regional === "string") {
    			regional = $.ig.regional[regional];
    		}
    		if (regional && regional[key]) {
    			return regional[key];
    		} else {
    			//return defaults
    			return $.ig.regional.defaults[key];
    		}
    	},
    	_convertScientificToNumeric: function (num) {
    		var parts = num.toString().split("e+"), first, zeroes, i;
    		first = parts[0].replace('.', "");
    		zeroes = parseInt(parts[1], 10) - (first.length - 1);
    		for (i = 0; i < zeroes; i++) {
    			first += "0";
    		}
    		return first;
    	},
    	_getDisplayValue: function () { //Numeric Editor
    		var value = this._valueInput.val(), decimalSeparator = this.options.decimalSeparator, decimalPoint = ".",
    			minDecimals = this.options.minDecimals, dataMode = this.options.dataMode, stringValue, displayValue, integerDigits, fractionalDigits, scientificPrecision, scientificValue,
				positivePattern, negativePattern, groups, groupSeparator, symbol = "";
    		if (value === this.options.nullValue || value === "" || isNaN(value)) {
    			if (isNaN(value)) {
    				this._valueInput.val("");
    				return "";
    			} else {
    				return value;
    			}
    		}
    		if (this._numericType !== "numeric") {
    			positivePattern = this.options.positivePattern;
    			symbol = this.options[this._numericType + "Symbol"];
    		}
    		negativePattern = this.options.negativePattern;
    		groups = this.options.groups;
    		groupSeparator = this.options.groupSeparator;
    		if (this._numericType === "percent" && this.options.displayFactor) {
    			value *= this.options.displayFactor;
    			value = this._parseNumericValueByMode(value, this._numericType, this.options.dataMode);
            }
    		//Min decimals check.
    		if (dataMode === "double" || dataMode === "float") {
    			stringValue = value.toString().toLowerCase();
    			if (this.options.scientificFormat) {
    				if (stringValue.indexOf("e") !== -1) {
    					displayValue = stringValue.replace("e", this._getScientificFormat());
    				} else {
    					scientificValue = (stringValue / 1).toExponential();
    					displayValue = scientificValue.toString().replace("e", this._getScientificFormat());
    				}
    			} else {
    				if (stringValue.indexOf("e") !== -1) {
    					//In that case leave the value as it is
    					scientificPrecision = stringValue.substring(stringValue.toLowerCase().indexOf("e") + 1);
    					stringValue = stringValue / 1;
    					if (scientificPrecision > 0) {
    						stringValue = this._convertScientificToNumeric(stringValue);
    					} else {
    						stringValue = stringValue.toFixed(Math.abs(scientificPrecision));
    					}

    				}
    				//There are edge cases where the value after convertion still contains scientific format. In that case we just pass that value.
    				if (stringValue.indexOf("e") !== -1) {
    					displayValue = stringValue;
    				} else {
    					//In that case we need to validate the value against the constraints. 
    					//Here decimalPoint is used instead of the decimalSeparator, as we work with the value from the hiddedn input, which is Number, so the decimalSeparator is dot. 
    					if (stringValue.indexOf(decimalPoint) !== -1) {
    						fractionalDigits = stringValue.substring(stringValue.indexOf(decimalPoint) + 1);
    						if (fractionalDigits.length < minDecimals) {
    							var missingDecimals = minDecimals - fractionalDigits.length;
    							while (missingDecimals > 0) {
    								fractionalDigits += "0";
    								missingDecimals--;
    							}
    						}
    						integerDigits = stringValue.substring(0, stringValue.indexOf(decimalPoint));
    					} else {
    						integerDigits = stringValue;
    						if (minDecimals > 0) {
    							stringValue = parseInt(stringValue).toFixed(minDecimals);
    							fractionalDigits = stringValue.substring(stringValue.indexOf(decimalPoint) + 1);
    						}
    					}
    					integerDigits = this._applyGroups(integerDigits, groups, groupSeparator);
    					if (fractionalDigits && fractionalDigits.length > 0) {
    						displayValue = integerDigits + decimalSeparator + fractionalDigits;
    					} else {
    						displayValue = integerDigits;
    					}
    				}
    			}
    		} else {
    			displayValue = this._applyGroups(value.toString(), groups, groupSeparator);

    		}
    		if (value < 0 && (this.options.scientificFormat === null || displayValue.indexOf("e") === -1)) {
    			
    			displayValue = displayValue.replace("-", "");
    			displayValue = negativePattern.replace("n", displayValue).replace("$", symbol);
    			
    		} else if (positivePattern && (this.options.scientificFormat === null || displayValue.indexOf("e") === -1)) {
    			//Apply Positive Pattern
    			displayValue = positivePattern.replace("n", displayValue).replace("$", symbol);
    		}
    		return displayValue;
    	},
    	_applyGroups: function (integerDigits, groups, groupSeparator) {
    		var digitsPosition = integerDigits.length - 1, br = 1, l = groups.length, digitsLimit = 0, group;
    		group = (groups.length > 0) ? groups[0] : 0;
			//The first group is longer than the integer - we can't insert group separator
    		if (group > integerDigits.length || group === 0) {
    			return integerDigits;
    		}
			//If the value is negative we need to skip the minus sign
    		if (parseFloat(integerDigits) < 0) {
    			digitsLimit = 1;
    		}
    		for (digitsPosition; digitsPosition > digitsLimit; digitsPosition--) {
				//group size exceeded - we need to insert group separator
    			if (--group === 0) {
    				integerDigits = integerDigits.substring(0, digitsPosition) + groupSeparator + integerDigits.substring(digitsPosition);
    				if (br === l) {
    					//We are on the last group 
    					group = groups[--br];
    				} else {
    					group = groups[br];
    					br++;
    				}
    			}
    		}
    		return integerDigits;
    	},
    	_enterEditMode: function () { //NumericEditor
    		var val, selection = this._getSelection(this._editorInput[0]);
    	    if (!$.ig.util.isIE8) {
    	    	this._editorInput.attr("type", "tel");
    	    }
    	    this._currentInputTextValue = this._editorInput.val();
    	    val = this._valueInput.val();
    	    if (val < 0) {
    	        //Remove negative css into edit mode
    	        this._editorInput.removeClass(this.css.negative);
    	    }

    	    if (this._numericType === "percent" && this.options.displayFactor) {
    	    	val = this._parseNumericValueByMode(val, this._numericType, this.options.dataMode);
    	    	val *= this.options.displayFactor;
    	    }

    	    if (this.options.decimalSeparator !== ".") {
    	    	val = val.toString().replace(".", this.options.decimalSeparator);
    	    }

    	    this._editorInput.val(val);

    	    this._editMode = true;
    	    this._positionCursor(selection.start, selection.end);
    		this._processTextChanged();
    	},
    	_exitEditMode: function () { //NumericEditor
    		this._super();
    		if (this.value() < 0) {
    			this._editorInput.addClass(this.css.negative);
    		} else {
    			this._editorInput.removeClass(this.css.negative);
    		}    	
    	},
    	_getSpinValue: function (spinType, currentValue, decimalSeparator) {
    		var fractional, scientificPrecision, spinPrecision, spinDelta, toFixedVal, precision;
    		if (currentValue.toString().toLowerCase().indexOf("e") !== -1) {
    			//number is in scientific format
    			currentValue = Number(currentValue);
    			if (this.options.spinDelta.toString().toLowerCase().indexOf("e") === -1) {
    			spinDelta = Number(this.options.spinDelta.toExponential());
    			} else {
    				spinDelta = this.options.spinDelta;
    			}

    			if (spinType === "spinUp") {
    				currentValue += spinDelta;
    			} else {
    				currentValue -= spinDelta;
    			}
            } else if (currentValue.toString().indexOf(decimalSeparator) !== -1) {
				fractional = currentValue.substring(currentValue.toString().indexOf(decimalSeparator) + 1);

    			toFixedVal = fractional.toString().length;

    			if (decimalSeparator !== ".") {
    				//replace the decimal separator with .
    				currentValue.replace(decimalSeparator, ".");
    			}
    			currentValue = currentValue / 1;

    			if ((this.options.displayFactor ? this.options.spinDelta * this.options.displayFactor : this.options.spinDelta) % 1 === 0) {
    				//integer value
    				if (spinType === "spinUp") {
    					currentValue += this.options.spinDelta;
    				} else {
    					currentValue -= this.options.spinDelta;
    				}
    			} else {
    				if (this.options.spinDelta.toString().toLowerCase().indexOf("e") !== -1) {
    					currentValue = Number(currentValue.toExponential());
    					scientificPrecision = this.options.spinDelta.toString().toLowerCase().substring(this.options.spinDelta.toString().toLowerCase().indexOf("e") + 1);
    					spinPrecision = Math.abs(scientificPrecision);
    					precision = Math.pow(10, spinPrecision);
    				} else {
    					precision = Math.pow(10, this.options.spinDelta.toString().toLowerCase().substring(this.options.spinDelta.toString().toLowerCase().indexOf(".") + 1).length);
    				}
    				if (spinType === "spinUp") {
    					if (currentValue === 0 && scientificPrecision) {
    						//We guarantee we have spin delta in scientific format
    						currentValue = this.options.spinDelta.toFixed(spinPrecision);
    					} else {
    						currentValue = (Math.round(currentValue * precision) + Math.round(this.options.spinDelta * precision)) / precision;
    					}
    				} else {
    					if (currentValue === 0 && scientificPrecision) {
    						//We guarantee we have spin delta in scientific format
    						currentValue = (-this.options.spinDelta).toFixed(spinPrecision);
    					} else {
    						currentValue = (Math.round(currentValue * precision) - Math.round(this.options.spinDelta * precision)) / precision;
    					}
    				}
    			}
    			//We need to call to fixed only in case current fractional lenth is less than it originally was.
                if (currentValue.toString().substring(currentValue.toString().indexOf(".") + 1).length < fractional.length) {
    				currentValue = currentValue.toFixed(toFixedVal);
    			}
    			if (decimalSeparator !== ".") {
    				//replace . with decimal separator 
    				currentValue.replace(".", decimalSeparator);
    			}
    		} else {
            	currentValue = currentValue / 1;
            	if ((this.options.displayFactor ? this.options.spinDelta * this.options.displayFactor : this.options.spinDelta) % 1 === 0) {
    				//integer value
    				if (spinType === "spinUp") {
    					currentValue += this.options.spinDelta;
    				} else {
    					currentValue -= this.options.spinDelta;
    				}
    			} else {
    				if (this.options.spinDelta.toString().toLowerCase().indexOf("e") !== -1) {
    					scientificPrecision = this.options.spinDelta.toString().toLowerCase().substring(this.options.spinDelta.toString().toLowerCase().indexOf("e") + 1);
    					spinPrecision = Math.abs(scientificPrecision);
    					precision = Math.pow(10, spinPrecision);
    				} else {
    					precision = Math.pow(10, this.options.spinDelta.toString().toLowerCase().substring(this.options.spinDelta.toString().toLowerCase().indexOf(".") + 1).length);
					}
    				if (spinType === "spinUp") {
    					if (currentValue === 0) {
    						//We guarantee we have spin delta in scientific format
    						currentValue = this.options.spinDelta.toFixed(spinPrecision);
    					} else {
    						currentValue = (Math.round(currentValue * precision) + Math.round(this.options.spinDelta * precision)) / precision;
    					}
    				} else {
    					if (currentValue === 0) {
    						//We guarantee we have spin delta in scientific format
    						currentValue = (-this.options.spinDelta).toFixed(spinPrecision);
    					} else {
    						currentValue = (Math.round(currentValue * precision) - Math.round(this.options.spinDelta * precision)) / precision;
    					}
    				}
    			}
    		}
    		return currentValue;
    	},
    	_spinUp: function () {
    		var currVal, decimalSeparator = this.options.decimalSeparator, noCancel;
    		if (this._focused) {
    			currVal = this._editorInput.val();
    		} else {
    			if (this.value() || this.value() === 0) {
    				currVal = this.value().toString();
    			} else {
    				currVal = "";
				}
    		}
    		this._clearEditorNotifier();
    		this._currentInputTextValue = this._editorInput.val();
    		currVal = this._getSpinValue("spinUp", currVal, decimalSeparator);
    		
            if ((!this._validateValue(currVal) && currVal > this.options.maxValue && this.options.spinWrapAround) || currVal < this.options.minValue) {
    			currVal = this.options.minValue;
    			this._sendNotification("warning", $.ig.util.stringFormat($.ig.Editor.locale.maxValExceededWrappedAroundErrMsg, this.options.maxValue));
            }
            else if (currVal >= this.options.maxValue && !this.options.spinWrapAround) {
                currVal = this.options.maxValue;
                this._sendNotification("warning", $.ig.util.stringFormat($.ig.Editor.locale.maxValErrMsg, this.options.maxValue));
    		}
    		if (this._focused) {
    			if (this.options.scientificFormat) {
    				currVal = Number(currVal).toExponential().replace("e", this._getScientificFormat());
    			}
    			this._editorInput.val(currVal);
    			this._processTextChanged();
    		} else {
    			//trigger value changing
    			noCancel = this._triggerValueChanging(currVal);
    			if (noCancel) {
    				this._updateValue(currVal);
    				this._exitEditMode();
    				//We pass the new value in order to have the original value into the arguments
    				this._triggerValueChanged(currVal);
    			}
    		}
            this._setSpinButtonsState(currVal);
    	},
    	_spinDown: function () {
    		var currVal, decimalSeparator = this.options.decimalSeparator, noCancel;
    		if (this._focused) {
    			currVal = this._editorInput.val();
    		} else {
    			if (this.value() || this.value() === 0) {
    				currVal = this.value().toString();
    			} else {
    				currVal = "";
    			}
    		}
    		this._clearEditorNotifier();
    		this._currentInputTextValue = this._editorInput.val();
    		currVal = this._getSpinValue("spinDown", currVal, decimalSeparator);
            if ((!this._validateValue(currVal) && currVal < this.options.minValue && this.options.spinWrapAround) || currVal > this.options.maxValue) {
                currVal = this.options.maxValue;
                this._sendNotification("warning", $.ig.util.stringFormat($.ig.Editor.locale.minValExceededWrappedAroundErrMsg, this.options.minValue));

            } else if (currVal <= this.options.minValue && !this.options.spinWrapAround) {
                currVal = this.options.minValue;
                this._sendNotification("warning", $.ig.util.stringFormat($.ig.Editor.locale.minValErrMsg, this.options.minValue));
			}
    		if (this._focused) {
    			this._editorInput.val(currVal);
    			this._processTextChanged();
    		} else {
    			//trigger value changing
    			noCancel = this._triggerValueChanging(currVal);
    			if (noCancel) {
    				this._updateValue(currVal);
    				this._exitEditMode();
    				//We pass the new value in order to have the original value into the arguments
    				this._triggerValueChanged(currVal);
    			}
    		}
    		this._setSpinButtonsState(currVal);
    	},
    	_handleSpinUpEvent: function () {
    		var cursorPosition = this._getCursorPosition();
    		if (this.options.dataMode === "double" || this.options.dataMode === "float") {
    			//Get cursor position
    			if (this._focused) {

    				switch (this._fractionalOrIntegerSelected(cursorPosition)) {
    					case "fractional": {
    						this._spinUp(true);//True stands for increase the value only on the fractional part of the number
    						this._setSelectionRange(this._editorInput[0], cursorPosition, cursorPosition);
    					}
    						break;
    					case "integer": {
    						this._spinUp();
    						this._setSelectionRange(this._editorInput[0], cursorPosition, cursorPosition);
    					}
    						break;
    					case "all": {
    						this._spinUp();
    						this._editorInput.select();
    						//Select All 
    					}
    						break;
    					default:
    						this._spinUp();
    						this._editorInput.select();
    				}
    			} else {
    				this._spinUp();
    			}
    		} else {
    			this._spinUp();
    		}
    	},
    	_handleSpinDownEvent: function () {
    		var cursorPosition = this._getCursorPosition();
    		if (this.options.dataMode === "double" || this.options.dataMode === "float") {
    			if (this._focused) {
    				switch (this._fractionalOrIntegerSelected(cursorPosition)) {
    					case "fractional": {
    						this._spinDown(true);//True stands for increase the value only on the fractional part of the number
    						this._setSelectionRange(this._editorInput[0], cursorPosition, cursorPosition);
    					}
    						break;
    					case "integer": {
    						this._spinDown();
    						this._setSelectionRange(this._editorInput[0], cursorPosition, cursorPosition);
    					}
    						break;
    					case "all": {
    						this._spinDown();
    						this._editorInput.select();
    						//Select All 
    					}
    						break;
    					default:
    						this._spinDown();
    						this._editorInput.select();
    				}
    			} else {
    				this._spinDown();
    			}
    		} else {
    			this._spinDown();
			}
    	},
    	_fractionalOrIntegerSelected: function (cursorPosition) {
    		var decimalSeparator, val;
    		if (cursorPosition === -1) {
    			return "all";
    		} else {
    			decimalSeparator = this.options.decimalSeparator;
    			val = this._editorInput.val();
    			if (val.indexOf(decimalSeparator) < 0) {
    				return "all";
    			} else {
    				if (cursorPosition <= val.indexOf(decimalSeparator)) {
    					return "integer";
    				} else {
    					return "fractional";
    				}
    			}
    		}
    	},
		// igNumericEditor public methods
    	value: function (newValue) { // Numeric Editor
    		if (newValue !== undefined) {
    			if (newValue !== null && !isNaN(this._parseNumericValueByMode(newValue, this._numericType, this.options.dataMode))) {
    				if (this._validateValue(newValue)) {
    					this._updateValue(newValue);
    					if (!this._focused) {
    						this._editorInput.val(this._getDisplayValue());
    					}
    				} else {
    					if (newValue < this.options.minValue) {
    						newValue = this.options.minValue;
    					} else if (newValue > this.options.maxValue) {
    						newValue = this.options.maxValue;
    					}
    					this._updateValue(newValue);
    					if (!this._focused) {
    						this._editorInput.val(this._getDisplayValue());
    					}
    				}
    				this._setSpinButtonsState(newValue);
    			} else {
    				if (this.options.revertIfNotValid && !(newValue === null && this.options.allowNullValue)) {
    					newValue = this._valueInput.val();
    				} else {
    					this._clearValue();
    				}
    			}
    			if (newValue < 0) {
    				this._editorInput.addClass(this.css.negative);
    			} else {
    				this._editorInput.removeClass(this.css.negative);
    			}
    	    } else {
    	    	return this.options.value;
    		}
    	},
    	findListItemIndex: function (number) {
    		/* Finds index of list item by text that matches with the search parameters.
				paramType="bool" optional="false" The text to search for.
				paramType="startsWith|endsWith|contains|exactMatch " optional="true" The 
    			returnType="number" Returns index of the found . */
    		var list = this.options.listItems, i;

    		for (i = 0; i < list.length; i++) {
    			if (this._parseNumericValueByMode(list[i], this._numericType, this.options.dataMode) === number) {
    				return i;
    		}
    	}
    		return -1;
    	},
    	getSelectedText: function () {
    	    throw ($.ig.Editor.locale.numericEditorNoSuchMethod);
    	},
    	getSelectionStart: function () {
    	    throw ($.ig.Editor.locale.numericEditorNoSuchMethod);
    	},
    	getSelectionEnd: function () {
    	    throw ($.ig.Editor.locale.numericEditorNoSuchMethod);
    	},
    	spinUp: function () {
    		/* Increments value in editor according to the parameter.
				paramType="" optional=""
    			returnType="" */
    		this._super();
    	},
    	spinDown: function () {
    		/* Decrements  value in editor according to the parameter.
				paramType="" optional=""
    			returnType="" */
    		this._super();
    	},
    	selectListIndexUp: function () {
    		/* Moves the selection index to the item that appears above the current one in the list.
				paramType="" optional=""
    			returnType="" */
    		
    	},
    	selectListIndexDown: function () {
    		/* Moves the selection index to the item that appears above the current one in the list.
				paramType="" optional=""
    			returnType="" */
    		
    	},
    	getRegionalOption: function () {
    		this._getRegionalOption();
    	}
    });
    $.widget('ui.igCurrencyEditor', $.ui.igNumericEditor, {
    	options: {
    		positivePattern: null,
    		currencySymbol: null

    	},
    	events: {
    		/* igWidget events go here */
    	},
    	_create: function () { //Currency editor
    		$.ui.igNumericEditor.prototype._create.call(this);
    	},
    	_setNumericType: function () {
    		this._numericType = "currency";
    	},
    	_applyRegionalSettings: function () { //igCurrencyEditor

    		this.options.negativeSign = this._getRegionalOption("negativeSign");
    		this.options.currencySymbol = this._getRegionalOption("currencySymbol");
    		this.options.positivePattern = this.options.positivePattern || this._getRegionalOption("currencyPositivePattern");
    		this.options.negativePattern = this.options.negativePattern || this._getRegionalOption("currencyNegativePattern");
    		this.options.decimalSeparator = this.options.decimalSeparator || this._getRegionalOption("currencyDecimalSeparator");
    		this.options.groupSeparator = this.options.groupSeparator || this._getRegionalOption("currencyGroupSeparator");
    		this.options.groups = this.options.groups || this._getRegionalOption("currencyGroups");
    		this.options.maxDecimals = this.options.maxDecimals === null ? this._getRegionalOption("currencyMaxDecimals") : this.options.maxDecimals;
    		this.options.minDecimals = this.options.minDecimals === null ? this._getRegionalOption("currencyMinDecimals") : this.options.minDecimals;
    	},
		// igCurrencyEditor public methods
    	currencySymbol: function (symbol) {
    		/* Gets/sets a string that is used as the currency symbol shown with the number in the input. The value provided as a param is propagated to the currencySymbol option and thus has the same priority as the option.
				paramType="sting" optional="true" New currency symbol.
    			returnType="string" Current currency symbol */
    		if (symbol) {
    			this.options.currencySymbol = symbol;
    		} else {
    			return this.options.currencySymbol;
    		}

    	}
    });
    $.widget('ui.igPercentEditor', $.ui.igNumericEditor, {
    	options: {
    		/* type="object" Sets gets custom regional settings for editor. If it is string, then $.ig.regional[stringValue] is assumed. */

    		/* type="string" Sets gets the pattern for positive numeric values, which is used in display (no focus) state.
				The "$" flag represents "numericSymbol" and the "n" flag represents the value of number.
				Note: this option has priority over possible regional settings. */
    		positivePattern: null,
    		/* type="string" Sets gets symbol, which is used in display (no focus) state.
				Note: this option has priority over possible regional settings. */
    		percentSymbol: null,
    		/* type="number" Sets gets the factor which used for the get and set of the "value" method.
				On the get number (string) entered by user is divided by that factor and on the set the number (string) displayed in editor is multiplied by that factor.
				For example, if factor is 100 and the "value" is set to 0.123, then editor will show string "12.3".
				Possible values: 1, or 100.
				Note: this option has priority over possible regional settings. */
    		displayFactor: 100,
    	    /* type="double|float|long|ulong|int|uint|short|ushort|sbyte|byte" Sets gets type of value returned by the get of value() method. That also affects functionality of the set value(val) method and the copy/paste operations of browser.
				double type="string" the Number object is used with limits of double and if value is not set, then the null or Number.NaN is used depending on the option 'nullable'. Note: that is used as default.
				float type="string" the Number object is used with limits of float and if value is not set, then the null or Number.NaN is used depending on the option 'nullable'.
				long type="string" the Number object is used with limits of signed long and if value is not set, then the null or 0 is used depending on the option 'nullable'. 
				ulong type="string" the Number object is used with limits of unsigned long and if value is not set, then the null or 0 is used depending on the option 'nullable'.
				int type="string" the Number object is used with limits of signed int and if value is not set, then the null or 0 is used depending on the option 'nullable'.
				uint type="string" the Number object is used with limits of unsigned int and if value is not set, then the null or 0 is used depending on the option 'nullable'.
				short type="string" the Number object is used with limits of signed short and if value is not set, then the null or 0 is used depending on the option 'nullable'.
				ushort type="string" the Number object is used with limits of unsigned short and if value is not set, then the null or 0 is used depending on the option 'nullable'.
				sbyte type="string" the Number object is used with limits of signed byte and if value is not set, then the null or 0 is used depending on the option 'nullable'.
				byte type="string" the Number object is used with limits of unsigned byte and if value is not set, then the null or 0 is used depending on the option 'nullable'.
			*/
    		dataMode: 'float',
    	    /* type="number" Sets gets delta-value which is used to increment or decrement value in editor on spin events. If value is set to negative value an exception is thrown. Non integer value is supported only for dataMode double and float.*/
    		spinDelta: 0.01,
    	},
    	events: {
    	
    	},
    	_create: function () { //Percent
    		$.ui.igNumericEditor.prototype._create.call(this);
    	},
    	_setNumericType: function () {
    		this._numericType = "percent";
    	},
    	_insert: function (newValue, previousValue) { // Percent Editor            
    	    if (!isNaN(newValue = this._parseNumericValueByMode(newValue, this._numericType, this.options.dataMode))) {
    	        
    	        if (this.options.maxValue && newValue / this.options.displayFactor > this.options.maxValue) {
    	            newValue = this.options.maxValue * this.options.displayFactor;
    	        } else if (this.options.minValue && newValue / this.options.displayFactor < this.options.minValue) {
    	            newValue = this.options.minValue * this.options.displayFactor;
    	        }

    	        if (!this._validateValue(newValue / this.options.displayFactor) && this.options.revertIfNotValid) {
    	            newValue = previousValue;               
    	        }
    			
    	    } else if (this.options.revertIfNotValid) {
    	        newValue = previousValue;
    	    } else {
    	        newValue = "";
    	    }
    	    this._editorInput.val(newValue);
    	    this._setSpinButtonsState(newValue / this.options.displayFactor);
    	    this._processTextChanged();
    	},
    	_applyRegionalSettings: function () { //Percent

    		this.options.negativeSign = this.options.negativeSign || this._getRegionalOption("negativeSign");
    		this.options.percentSymbol = this.options.percentSymbol || this._getRegionalOption("percentSymbol");
			this.options.positivePattern = this.options.positivePattern || this._getRegionalOption("percentPositivePattern");
			this.options.negativePattern = this.options.negativePattern || this._getRegionalOption("percentNegativePattern");
			this.options.decimalSeparator = this.options.decimalSeparator || this._getRegionalOption("percentDecimalSeparator");
			this.options.groupSeparator = this.options.groupSeparator || this._getRegionalOption("percentGroupSeparator");
			this.options.groups = this.options.groups || this._getRegionalOption("percentGroups");
			this.options.maxDecimals = this.options.maxDecimals === null ? this._getRegionalOption("percentMaxDecimals") : this.options.maxDecimals;
			this.options.minDecimals = this.options.minDecimals === null ? this._getRegionalOption("percentMinDecimals") : this.options.minDecimals;
			if (this.options.displayFactor === 100) {
				// TODO - this is needed, cause when value(20.34) is devided by 100, then it becomes 0.2034, and if maxDecimals is 2 then it will be cut to 0.20
				this.options.maxDecimals += 2;
			}
    		this.options.displayFactor = this.options.displayFactor || this._getRegionalOption("displayFactor");
    		if (typeof this.options.displayFactor !== "number") {
    		    throw new Error($.ig.Editor.locale.displayFactorIsOfTypeNumber);
    		} else if (this.options.displayFactor !== 1 && this.options.displayFactor !== 100) {
    		    throw new Error($.ig.Editor.locale.displayFactorAllowedValue);
    		}
    	},
    	_setOption: function (option, value) { // igPercentEditor
    	    /* igPercentEditor custom setOption goes here */
    	    var prevValue = this.options[option];
    	    if (prevValue === value) {
    	        return;
    	    }
    	    // The following line applies the option value to the igWidget meaning you don't
    	    // have to perform this.options[option] = value;
    	    $.Widget.prototype._setOption.apply(this, arguments);
    	    switch (option) {
    	        case "displayFactor": {
    	            if (typeof value !== "number") {
    	                this.options[option] = prevValue;
    	                throw new Error($.ig.Editor.locale.displayFactorIsOfTypeNumber);
    	            } else if (value !== 1 && value !== 100) {
    	                this.options[option] = prevValue;
    	                throw new Error($.ig.Editor.locale.displayFactorAllowedValue);
    	            }
    	        }
    	            break;
    	        default: {
    	            //In case no propery matches, we call the super. Into the base widget default statement breaks
    	            this.options[option] = prevValue;
    	            this._super(option, value);
    	        }
    	            break;
    	    }
    	},
		// igPercentEditor public methods
    	percentSymbol: function (symbol) {
    		/* Gets/sets a string that is used as the percent symbol shown with the number in the input. The value provided as a param is propagated to the percentSymbol option and thus has the same priority as the option.
				paramType="sting" optional="true" New percent symbol.
    			returnType="string" Current percent symbol */
    		if (symbol) {
    			this.options.percentSymbol = symbol;
    		} else {
    			return this.options.percentSymbol;
    		}

    	}
    });
    $.widget('ui.igMaskEditor', $.ui.igTextEditor, {
    	options: {
    		/* type="object" Sets gets custom regional settings for editor. If it is string, then $.ig.regional[stringValue] is assumed. */
    		regional: null,
    		/* type="string" Sets gets input mask. Mask may include filter-flags and literal characters.
				Literal characters are part of mask which cannot be modified by end user. In order to use a filter-flag as a literal character, the escape "\\" character should be used.
				Default is "CCCCCCCCCC"
				Note: optional flags/entries affect the value returned by get of the "value" and "text" methods.
				List of filter-flags:
				C: any keyboard character. Entry is optional.
				&: any keyboard character. Entry is required.
				a: letter or digit character. Entry is optional.
				A: letter or digit character. Entry is required.
				?: letter character. Entry is optional.
				L: letter character. Entry is required.
				9: digit character. Entry is optional.
				0: digit character. Entry is required.
				#: digit character or "+" or "_". Entry is optional with replacement by "emptyPositionChar" or by "padChar".
				>: all letters to the right are converted to the upper case. In order to disable conversion, the ">" flag should be used again.
				<: all letters to the right are converted to the lower case. In order to disable conversion, the "<" flag should be used again.
			*/
    		inputMask: 'CCCCCCCCCC',
    		/* type="rawText|rawTextWithRequiredPrompts|rawTextWithAllPrompts|rawTextWithLiterals|rawTextWithRequiredPromptsAndLiterals|allText" Sets gets type of value returned by the get of value() method. That also affects functionality of the set value(val) method and the copy/paste operations of browser.
				rawText type="string" only entered text. All unfilled prompts (positions) and literals are ignored (removed).
				rawTextWithRequiredPrompts type="string" only entered text and required prompts (positions). All optional unfilled prompts and literals are ignored (removed)
				rawTextWithAllPrompts type="string" only entered text and prompts (positions). All literals are ignored (removed).
				rawTextWithLiterals type="string" only entered text and literals. All unfilled prompts are ignored (removed).
				rawTextWithRequiredPromptsAndLiterals type="string" only entered text, required prompts (positions) and literals. All optional unfilled prompts are ignored (removed).
				allText type="string" entered text, all prompts (positions) and literals. Note: that is used as default.
			*/
    		dataMode: 'allText',
    		/* type="string" Sets gets character which is used as prompt in edit mode for available entry position.  */
    		unfilledCharsPrompt: '_',
    		/* type="string" Sets gets character which is used as replacement of not-filled required position in mask when editor is in display mode (not focused).  */
    		padChar: ' ',
    		/* type="string" Sets gets character which is used as replacement of not-filled required position in mask when application calls get for the "value" or for the "text" methods. */
    		emptyChar: ' '
    	},
    	events: {
    		/* igWidget events go here */

    	},
    	_create: function () {//igMaskEditor

    		$.ui.igTextEditor.prototype._create.call(this);
			
    	},
    	_initialize: function () { //
    		this._super();
    		if (this.options.maxLength) {
    			//In case of explicidly set length as an option, we remove it because that option is controlled by the mask 
    			this.options.maxLength = null;
    		}
    		if (this.options.listItems) {
    			//In case of mask editor we're not supporting listItems. When the listItems are disabled,1890 there are no spin buttons rendered.
    			this.options.listItems = null;
    		}
    		if (this._maskFlagsArray) {
    			this._maskFlagsArray = $.merge(this._maskFlagsArray, ["C", "&", "a", "A", "?", "L", "9", "0", "<", ">"]);
    		} else {
    			this._maskFlagsArray = ["C", "&", "a", "A", "?", "L", "9", "0", "<", ">"];
    		}
    	},
    	_applyOptions: function () {
			//In case value is not set we need to use the setInitialValue method to store mask, required field indeces, prompt indeces etc.
    		this._super();
    		if (this.options.value === null || this.options.value === undefined) {
    			this._setInitialValue();
    		}
    	},
		// replaces characted at a specific position
    	_replaceCharAt: function (stringValue, index, ch) {
    		if (stringValue !== undefined) {
    			return stringValue.substring(0, index) + ch + stringValue.substring(index + 1);
    		}
    	},
    	_getStringRange: function (stringValue, start, end) {
    		if (stringValue !== undefined) {
    			return stringValue.substring(start, end);
    		}
    	},
    	_replaceStringRange:function (stringValue, replacementValue, indexStart, indexEnd) {
    		var i = 0;
    		while (indexStart <= indexEnd) {
    			stringValue = this._replaceCharAt(stringValue, indexStart, replacementValue.charAt(i));
    			i++;
    			indexStart++;
    		}
    		return stringValue;
    	},
    	_enterEditMode: function () { //MaskEditor
    	    var selection = this._getSelection(this._editorInput[0]);
    	    this._editMode = true;
    	    this._currentInputTextValue = this._editorInput.val();
    		if (this._maskedValue === "") {
    			this._editorInput.val(this._maskWithPrompts);
    		} else {
    			this._editorInput.val(this._maskedValue);
    		}    		
    		this._positionCursor(selection.start, selection.end);
    		this._processTextChanged();
    	},
    	_insert: function (newValue) { // MaskEditor
    	    var selection = this._getSelection(this._editorInput[0]);
    			if (this.options.toUpper) {
    				if (newValue) { newValue = newValue.toLocaleUpperCase(); }
    			} else if (this.options.toLower) {
    				if (newValue) { newValue = newValue.toLocaleLowerCase(); }
    			}
    			newValue = this._parseValueByMask(newValue);
    			this._editorInput.val(newValue);
    			this._processTextChanged();
    			// Move the caret
    			this._setCursorPosition(selection.start + newValue.length);

    	},
    	_attachEvents: function () { //MaskEditor 
    		var self = this;
    		self._super();
    		this._editorInput.on({
    			"dragend.editor": function () {
    				self._handleDeleteKey(true);
    			},
    			"cut.editor": function () {
    				self._handleDeleteKey(true);
    			}
    		});
    	},
    	_detachEvents: function () {
    		this._super();
    		this._editorInput.off("cut.editor dragend.editor");
    	},
    	_getMaskLiteralsAndRequiredPositions: function() {
    		//This method returns array of indexes which represent literals into edit mode. 
    		var mask, literalIndeces = [], requiredFieldsIndeces = [], maskFlagsArray = this._maskFlagsArray, output, maskChar, unescapedMask, i, j,
    		isToLower = false, isToUpper = false, toLowerIndeces = [], toUpperIndeces = [];

    		output = unescapedMask = mask = this.options.inputMask;
			//j stands for real index, after we remove escape chars
    		for (i = 0, j = 0; i < mask.length; i++, j++) {
    			maskChar = mask.charAt(i);
    			if ($.inArray(maskChar, maskFlagsArray) !== -1) {
    				//get requred chars
    				if (isToLower) {
    					toLowerIndeces.push(j);
    				} else if (isToUpper) {
    					toUpperIndeces.push(j);
					}
    				if (maskChar === "&" || maskChar === "A" || maskChar === "L" || maskChar === "0") {
    					requiredFieldsIndeces.push(j);
    				} else if (maskChar === ">") {
    					if (!isToUpper) {
    						isToUpper = true;
    						//toUpperIndeces.push(j);
    						if (isToLower) {
    							isToLower = false;
    							toLowerIndeces.pop();
							}
    					} else {
							//if there are two flags < all between characters are converted toUpper
    						isToUpper = false;
    						toUpperIndeces.pop();
    					}
						//We need to remove the symbol < from the unescaped mask
    					unescapedMask = this._replaceCharAt(unescapedMask, j, "");
    					j--;
    				} else if (maskChar === "<") {
    					if (!isToLower) {
    						isToLower = true;
    						//toLowerIndeces.push(j);
    						if (isToUpper) {
    							isToUpper = false;
    							toUpperIndeces.pop();
							}
    					} else {
    						isToLower = false;
    						toLowerIndeces.pop();
    					}
    					unescapedMask = this._replaceCharAt(unescapedMask, j, "");
    					j--;
					}
    			} else if (maskChar === "\\") {
    				if ($.inArray(mask.charAt(i + 1), maskFlagsArray) !== -1) {
    					
    					unescapedMask = this._replaceCharAt(unescapedMask, j, "");
    					i++;
    				}
    				literalIndeces.push(j);
    			} else {
    				//Literal add it.
    				literalIndeces.push(j);
    			}
    		}
    		this._literalIndeces = literalIndeces;
    		this._requiredIndeces = requiredFieldsIndeces;
    		this._toLowerIndeces = toLowerIndeces;
    		this._toUpperIndeces = toUpperIndeces;
			//We need the mask into this format to be sure we have the right index when the key is pressed.
    		this._unescapedMask = unescapedMask;
    	},
    	_validateValue: function (val) { // Mask Editor
    		return this._super(val);
    	},
    	_parseValueByMask: function (value) { //igMaskEditor
    		var mask = this.options.inputMask, outputVal = mask, ch, maskFlagsArray = this._maskFlagsArray,
			length = mask.length, i, j;

    		value = value ? value.toString() : "";
    		if (length && length > 0) {
    			for (i = 0, j = 0; i < length; i++, j++) {
    				ch = value.charAt(j);
    				if (this._validateCharOnPostion(ch, i) === null) {
    					//move to next char on the mask
    					//We need to detect Escaped chars

    					if (mask.charAt(i) === "\\") {
                            i++;
    						j--;
    					} else if (mask.charAt(i) === "<" || mask.charAt(i) === ">") {
    						j--;
						}
						
    				} else if (this._validateCharOnPostion(ch, i) === true) {
    						outputVal = this._replaceCharAt(outputVal, i, ch);
    					} else {
    						//we replace with unfilledCharsPrompt
    						outputVal = this._replaceCharAt(outputVal, i, this.options.unfilledCharsPrompt);
    					}
    			}
    			//We need to loop throught the value and remove escape chars
    			for (i = 0; i < outputVal.length; i++) {
    				ch = outputVal.charAt(i);
    				if (ch === "\\" && $.inArray(outputVal.charAt(i + 1), maskFlagsArray) !== -1) {
    					outputVal = this._replaceCharAt(outputVal, i, "");
    				} else if (ch === "<" || ch === ">") {
    					outputVal = this._replaceCharAt(outputVal, i, "");
    					i--;
    				} else if ($.inArray(i, this._toLowerIndeces) !== -1) {
    					outputVal = this._replaceCharAt(outputVal, i, outputVal.charAt(i).toLocaleLowerCase());
    				} else if ($.inArray(i, this._toUpperIndeces) !== -1) {
    					outputVal = this._replaceCharAt(outputVal, i, outputVal.charAt(i).toLocaleUpperCase());
    				}
    			}
    		}
    		return outputVal;
    	},
    	_getValueByDataMode: function () {
    		var dataModeValue, regExpr, i, ch, maskedVal = this._maskedValue,
				dataMode = this.options.dataMode;
    		switch (dataMode) {
    			case "allText": {
    			    regExpr = new RegExp($.ig.util.escapeRegExp(this.options.unfilledCharsPrompt), 'g');
    			    dataModeValue = maskedVal.replace(regExpr, this.options.emptyChar);
    			}
    				break;
    			case "rawText": {
    				dataModeValue = "";
    				for (i = 0; i < maskedVal.length; i++) {
    					ch = maskedVal.charAt(i);
						//We ensure current char is not literal and it's filled (not unfilledCharsPrompt)
    					if ($.inArray(i, this._literalIndeces) === -1 && ch !== this.options.unfilledCharsPrompt) {
    						dataModeValue += ch;
						}
    				}
    			}
    				break;
    			case "rawTextWithRequiredPrompts": {
    				dataModeValue = "";
    				for (i = 0; i < maskedVal.length; i++) {
    					ch = maskedVal.charAt(i);
    					//We ensure current char is not literal and it's filled (not unfilledCharsPrompt)
    					if ($.inArray(i, this._literalIndeces) === -1) {
    						if (ch === this.options.unfilledCharsPrompt) {
    							if ($.inArray(i, this._requiredIndeces) !== -1) {
    								dataModeValue += this.options.emptyChar;
								}
    						} else {
    							dataModeValue += ch;
    						}
    					}
    				}
    			}
    				break;
    			case "rawTextWithAllPrompts": {
    				dataModeValue = "";
    				for (i = 0; i < maskedVal.length; i++) {
    					ch = maskedVal.charAt(i);
    					if ($.inArray(i, this._literalIndeces) === -1) {
    						if (ch === this.options.unfilledCharsPrompt) {
    							dataModeValue += this.options.emptyChar;
    						} else {
    							dataModeValue += ch;
    						}
    					}
    				}
    			}
    				break;
    			case "rawTextWithLiterals": {
    				dataModeValue = "";
    				for (i = 0; i < maskedVal.length; i++) {
    					ch = maskedVal.charAt(i);
    					//We ensure current char is not literal and it's filled (not unfilledCharsPrompt)
    					if (ch !== this.options.unfilledCharsPrompt) {
    						dataModeValue += ch;
    					}
    				}
    			}
    				break;
    			case "rawTextWithRequiredPromptsAndLiterals": {
    				dataModeValue = "";
    				for (i = 0; i < maskedVal.length; i++) {
    					ch = maskedVal.charAt(i);
    					//We ensure current char is not literal and it's filled (not unfilledCharsPrompt)
    					if ($.inArray(i, this._literalIndeces) === -1) {
    						if (ch === this.options.unfilledCharsPrompt) {
								//Non filled required 
    							if ($.inArray(i, this._requiredIndeces) !== -1) {
    								dataModeValue += this.options.emptyChar;
    							}
    						} else {
								//filled char
    							dataModeValue += ch;
    						}
    					} else {
							//Literal 
    						dataModeValue += ch;
						}
    				}
    			}
    				break;
    			default: {
					//If the option is not valid we default back to the allText
    			    regExpr = new RegExp($.ig.util.escapeRegExp(this.options.unfilledCharsPrompt), 'g');
    				dataModeValue = this._maskedValue.replace(regExpr, this.options.emptyChar);
    			}
    		}
    		return dataModeValue;
    	},
    	_updateValue: function (value) { //igMaskEditor
    		if (value === "") {
    			//In that case we have empty editor. Check for null value; 
    			if (this.options.allowNullValue) {
    				if (this.options.nullValue === null) {
    					this._valueInput.val("");
    				} else {
						this._valueInput.val(this.options.nullValue);
    				}
    				this.options.value = this.options.nullValue;
    			} else {
    				//convert empty value by dataMode
    				this.options.value = "";
    				this._valueInput.val("");
    				this._maskedValue = "";
    			}
    		} else {
    			this._maskedValue = value;
    			this.options.value = this._getValueByDataMode();
    			this._valueInput.val(this.options.value);
    		}
    	},
    	_getDisplayValue: function () { //igMaskEditor
    		var result, maskedVal = this._maskedValue,
				i, j, p, maskChar,
				inputMask = this.options.inputMask, maskFlagsArray = this._maskFlagsArray;

    		result = maskedVal;
    		for (i = 0, j = 0, p = 0; i < maskedVal.length; i++, j++, p++) {
				//We need extra counter for the escaped chars, so we can be sure we check the correct mask flag
    			if (inputMask.charAt(j) === "\\" && $.inArray(inputMask.charAt(j + 1), maskFlagsArray) !== -1) {
    				j++;
    			}
    			if (maskedVal.charAt(i) === this.options.unfilledCharsPrompt) {
    				maskChar = inputMask.charAt(j);
    				if (maskChar === "&" || maskChar === "A" || maskChar === "L" || maskChar === "0") {
						//All the required fields, which are unfilled are replaced with the padChar
    					result = this._replaceCharAt(result, p, this.options.padChar);
    				} else {
    					result = this._replaceCharAt(result, p, "");
    					p--;
    				}
    			}
    		}
    		return result;
    	},
		//Temporary not used
    	_validateValueAgainstMask: function (value) {
    		var i, length = value.length, result = true, ch;
    		if (length && length > 0) {
    			for (i = 0; i < length; i++) {
    				ch = value.charAt(i);
    				if (this._validateCharOnPostion(ch, i) === null) {
    					//if we have left postions on the map and _validateCharOnPostion returns null this means we have literal and we need to move 
    					if (i + 1 <= length) {
    						result = this._validateCharOnPostion(ch, i + 1);
    					}
    				}
    			}
    		} else {
    			result = true;
    		}
    	},
    	_setInitialValue: function (value) { //igMaskEditor
    		this._maskWithPrompts = this._parseValueByMask("");
    		this._getMaskLiteralsAndRequiredPositions();
    		if (value === null || value === "" || typeof value === undefined) {
    			this._maskedValue = "";
    		} else {
    			this._maskedValue = this._parseValueByMask(value);
    			this._updateValue(this._maskedValue);
    		}
    	},
    	_triggerInternalValueChange: function (value) { //MaskEditor
    		if (value === this._maskWithPrompts) {
    			value = "";
    		}
    		var noCancel = this._triggerValueChanging(value);
    		if (noCancel) {
    			this._processInternalValueChanging(value);
    			
    			//We pass the new value in order to have the original value into the arguments
    			this._triggerValueChanged(value);
    			//check if maskedValue contains promptChars
    			if (value !== "" && !this._validateRequiredPrompts(value)) {
    				//Raise warning not all required fields are entered
    				//State - message
    				this._sendNotification("warning", $.ig.Editor.locale.maskMessage);
				}
    		}
    	},
    	_validateRequiredPrompts: function (value) {
    		var i;
    		if (value === "") {
    			return false;
    		}
    		for (i = 0; i < this._requiredIndeces.length; i++) {
    			var ch = value.charAt(this._requiredIndeces[i]);
    			if (ch === this.options.unfilledCharsPrompt) {
    				return false;
    			}
    		}
    		return true;
    	}, 
    	_processInternalValueChanging: function (value) { //MaskEditor
    		if (this._validateValue(value)) {
    			this._updateValue(value);
    		} else {
    			//If the value is not valid, we clear the editor 
    			if (this.options.revertIfNotValid) {
    				value = this._valueInput.val();
    				this._updateValue(value);
    			} else {
    				this._clearValue();
    				value = this._valueInput.val();
    			}
    		}
    	},
    	_triggerKeyDown: function (event) { //MaskEditor
    		var key = !event.charCode ? event.which : event.charCode, ch, transformedChar,
				cursorStartPosition = this._getSelection(this._editorInput[0]).start;
    		this._super(event);
    		if (key === 8) { //Backspace
    			this._handleBackSpaceKey();
    			event.preventDefault();
    		} else if (key === 46) { //Delete 
    			this._handleDeleteKey();
    			event.preventDefault();
    		} else if ($.inArray(cursorStartPosition, this._toUpperIndeces) !== -1) {
    			if (!event.ctrlKey && !event.altKey && ((key > 46 && key < 91) || (key > 145))) {
    				ch = String.fromCharCode(key);
    				transformedChar = ch.toLocaleUpperCase();
    				this._editorInput.val(this._replaceCharAt(this._editorInput.val(), cursorStartPosition, transformedChar));
    				this._setCursorPosition(cursorStartPosition + 1);
    				event.preventDefault();
    			}
    		} else if ($.inArray(cursorStartPosition, this._toLowerIndeces) !== -1) {
    			if (!event.ctrlKey && !event.altKey && ((key > 46 && key < 91) || (key > 145))) {
    				ch = String.fromCharCode(key);
    				transformedChar = ch.toLocaleLowerCase();
    				this._editorInput.val(this._replaceCharAt(this._editorInput.val(), cursorStartPosition, transformedChar));
    				this._setCursorPosition(cursorStartPosition + 1);
    				event.preventDefault();
    			}
    		}
    	},
    	_triggerKeyPress: function (event) { //MaskEditor
    		this._super(event);
    	},
    	_validateKey: function (event) {
    		var result, ch, key, cursorPosition = this._getCursorPosition();
    		if (this._super(event) && this.options.inputMask) {
    			//validate key against the mask
    			key = !event.charCode ? event.which : event.charCode;
    			if (key !== 8 && key !== 46) { //Backspace
    				ch = String.fromCharCode(key);
    		if (cursorPosition === -1) {
    					//In case all the text is selected we set the cursor to 0, so we can continue correctly with the indexes.
    					cursorPosition++;
    		}
    				while ($.inArray(cursorPosition, this._literalIndeces) !== -1 || cursorPosition === this._maskWithPrompts.length) {
    					cursorPosition++;
    				}
    				result = this._validateKeyCharAgainstMask(ch, cursorPosition, this._unescapedMask);
    				if (result === true) {
    					//In firefow when key is held down triggers keypress and on rightArrow we need to manually move the cursor to the left. 
    					if ($.ig.util.isFF && event.keyCode === 37) {
							//Bug 206039
    						this._setSelectionRange(this._editorInput[0], cursorPosition, cursorPosition - 1);
    					} else {
    						//If the key is valid, we selec the next char so we don't extend the value but delete the prompt char. 
    						this._setSelectionRange(this._editorInput[0], cursorPosition, cursorPosition + 1);
    					}
    				}
    			}
    		} else {
    			result = false;
    		}
    		return result;
    	},
		//We use this method both in edit mode and when validte value
    	_validateKeyCharAgainstMask: function (ch, cursorPosition, inputMask) {
    		var mask = inputMask || this.options.inputMask, isValid;//,
    		if (cursorPosition >= this._maskWithPrompts.length) {
				//The cursor position at the end of the possible value
    			isValid = false;
    		} else {

    			if (this._validateCharOnPostion(ch, cursorPosition, mask) === null) {
    				//In that case we need to move to next char on the mask
    				
                    isValid = this._validateKeyCharAgainstMask(ch, cursorPosition + 1);

    			} else {
    				isValid = this._validateCharOnPostion(ch, cursorPosition, mask);
    			}
    		}
    		return isValid;
    	},
        _validateCharOnPostion: function (ch, position, inputMask) {
    		var maskSymbol, mask, isValid,
				regex,
				inputChar = ch,
    			letterOrDigitRegEx = "[\\d\u00C0-\u1FFF\u2C00-\uD7FFa-zA-Z]",
    			letterRegEx = "[\u00C0-\u1FFF\u2C00-\uD7FFa-zA-Z]",
    			digitRegEx = "[\\d]",
    			digitSpecialRegEx = "[\\d_\\+]";
    			mask = inputMask || this.options.inputMask;
    			maskSymbol = mask.charAt(position);
				switch (maskSymbol) {
					case "C":
					case "&": {
    					if (inputChar === "") {
    						isValid = false;
    					} else {
							isValid = true;
						}
					}
						break;
					case "a":
					case "A": {
						regex = new RegExp(letterOrDigitRegEx);
						if (regex.test(inputChar)) {
							isValid = true;
						} else {
							isValid = false;
						}
					}
						break;
					case "?":
					case "L": {
						regex = new RegExp(letterRegEx);
						if (regex.test(inputChar)) {
							isValid = true;
						} else {
							isValid = false;
						}
					}
						break;
					case "0":
					case "9": {
						regex = new RegExp(digitRegEx);
						if (regex.test(inputChar)) {
							isValid = true;
						} else {
							isValid = false;
						}
					}
						break;
					case "#": {
						regex = new RegExp(digitSpecialRegEx);
						if (regex.test(inputChar)) {
							isValid = true;
						} else {
							isValid = false;
						}
					}
						break;
					default: {
						//Move cursor if possible
						//this._setCursorPosition(cursorPosition + 1);
						//this._validateCharAgainstMask(char, cursorPosition + 1);
						isValid = null;
					}
    			}
				return isValid;
        },
        _setOption: function (option, value) { // igMaskEditor
            /* igPercentEditor custom setOption goes here */
            var prevValue = this.options[option];
            if (prevValue === value) {
                return;
            }
            // The following line applies the option value to the igWidget meaning you don't
            // have to perform this.options[option] = value;
            $.Widget.prototype._setOption.apply(this, arguments);
            switch (option) {
                case "inputMask": {                  
                    throw new Error($.ig.Editor.locale.cannotSetRuntime);
                }
                    break;
                default: {
                    //In case no propery matches, we call the super. Into the base widget default statement breaks
                    this.options[option] = prevValue;
                    this._super(option, value);
                }
                    break;
            }
        },
    	_handleBackSpaceKey: function () {
    		//get setlection
    	    var selection = this._getSelection(this._editorInput[0]),
                startPostion = selection.start,
				endPosition = selection.end, index = endPosition;
    		if (startPostion === endPosition) {
    			startPostion--;
			}
    		index--;
    		for (index; index > startPostion - 1; index--) {
    			
    			while ($.inArray(index, this._literalIndeces) !== -1 || index === -1) {
    				index--;
    			}
    			if (index > -1) {
    				this._editorInput.val(this._replaceCharAt(this._editorInput.val(), index, this.options.unfilledCharsPrompt));
    				this._setCursorPosition(index);
    			}
    		}
    	},
    	_handleDeleteKey: function (skipCursorPosition) { //MaskEditor
    		//get setlection
    	    var selection = this._getSelection(this._editorInput[0]),
                startPostion = selection.start,
				endPosition = selection.end, index = startPostion;
    		if (startPostion === endPosition) {
    			//In that case we don't have selection, but cursor set and we increase the endCursor so we can enter the loop. 
    			endPosition++;
			}
    		for (index; index < endPosition; index++) {

    			while ($.inArray(index, this._literalIndeces) !== -1 && index <= this._maskWithPrompts.length) {
    				index++;
    			}
    			if (index !== this._maskWithPrompts.length) {
    				this._editorInput.val(this._replaceCharAt(this._editorInput.val(), index, this.options.unfilledCharsPrompt));
    				if (!skipCursorPosition) {
    					this._setCursorPosition(index + 1);
    				}
    			} else {
    				if (!skipCursorPosition) {
    					this._setCursorPosition(index);
    				}
    			}
    		}
    	},
    	// igMaskEditor public methods
    	value: function (newValue) { // Mask Editor
    		if (newValue !== undefined) {
    			this._setInitialValue(newValue);
    			this._editorInput.val(this._getDisplayValue());
    		} else {
    			return this.options.value;
    		}
    	},
    	dropDownContainer: function () {
    		throw ($.ig.Editor.locale.maskEditorNoSuchMethod);
    	},
    	showDropDown: function () {
    		throw ($.ig.Editor.locale.maskEditorNoSuchMethod);
    	},
    	hideDropDown: function () {
    		throw ($.ig.Editor.locale.maskEditorNoSuchMethod);
    	},
    	dropDownButton: function () {
    		throw ($.ig.Editor.locale.maskEditorNoSuchMethod);
    	},
    	spinUpButton: function () {
    		throw ($.ig.Editor.locale.maskEditorNoSuchMethod);
    	},
    	spinDownButton: function () {
    		throw ($.ig.Editor.locale.maskEditorNoSuchMethod);
    	},
    	dropDownVisible: function () {
    		throw ($.ig.Editor.locale.maskEditorNoSuchMethod);
    	},
    	findListItemIndex: function () {
    		throw ($.ig.Editor.locale.maskEditorNoSuchMethod);
    	},
    	selectedListIndex: function () {
    		throw ($.ig.Editor.locale.maskEditorNoSuchMethod);
    	},
    	getSelectedListItem: function () {
    		throw ($.ig.Editor.locale.maskEditorNoSuchMethod);
    	},
    	spinUp: function () {
    		throw ($.ig.Editor.locale.maskEditorNoSuchMethod);
    	},
    	spinDown: function () {
    		throw ($.ig.Editor.locale.maskEditorNoSuchMethod);
    	},
		isValid: function () {
		/* Checks if value in editor is valid. Note: This function will not trigger automatic notifications.
			paramType="" optional=""
			returnType="bool" Whether editor value is valid or not */
			var value, valid;
			value = this.field().val();
			this._skipMessages = true;
			valid = this._validateValue(value);
			if (value !== "" && !this._validateRequiredPrompts(this._maskedValue)) {
				//Raise warning not all required fields are entered
				//State - message
				valid = false;
				this._sendNotification("warning", $.ig.Editor.locale.maskMessage);
			}
		    this._skipMessages = false;
			return valid;
		}
    });
    $.widget('ui.igDateEditor', $.ui.igMaskEditor, {
        options: {
            /* type="date" Sets gets the minimum value which can be entered in editor by user. String value can be passed and the editor will use the javascript Date object constructor to create date object and will use it for the comparison.*/
            minValue: null,
        	/* type="date" Sets gets the maximum value which can be entered in editor by user. String can be passed and the editor will use the javascript Date object constructor to create date object and will use it for the comparison*/
            maxValue: null,
            /* type="string"
                Sets gets format of date while editor has no focus.
                Value of that option can be set to a specific date pattern or to a flag defined by regional settings.
                If value is not set, then the dateInputFormat is used automatically.
                If value is set to explicit date pattern and pattern besides date-flags has explicit characters which match with date-flags or mask-flags, then the "escape" character should be used in front of them. 
                List of predefined regional flags:
                "date": the datePattern member of regional option is used
                "dateLong": the dateLongPattern member of regional option is used
                "time": the timePattern member of regional option is used
                "timeLong": the timeLongPattern member of regional option is used
                "dateTime": the dateTimePattern member of regional option is used
                List of explicit characters, which should have escape \\ character in front of them:
                    C, &, a, A, ?, L, 9, 0, #, >, <, y, M, d, h, H, m, s, t, f.
                List of date-flags when explicit date pattern is used:
                "y": year field without century and without leading zero
                "yy": year field without century and with leading zero
                "yyyy": year field with leading zeros
                "M": month field as digit without leading zero
                "MM": month field as digit with leading zero
                "MMM": month field as short month name
                "MMMM": month field as long month name
                "d": day of month field without leading zero 
                "dd": day of month field with leading zero
                "ddd": day of the week as short name
                "dddd": day of the week as long name
                "t": first character of string which represents AM/PM field 
                "tt": 2 characters of string which represents AM/PM field
                "h": hours field in 12-hours format without leading zero
                "hh": hours field in 12-hours format with leading zero
                "H": hours field in 24-hours format without leading zero
                "HH": hours field in 24-hours format with leading zero
                "m": minutes field without leading zero
                "mm": minutes field with leading zero
                "s": seconds field without leading zero
                "ss": seconds field with leading zero
                "f": milliseconds field in hundreds
                "ff": milliseconds field in tenths
                "fff": milliseconds field
            */
            dateDisplayFormat: null,
            /* type="string"
                Sets gets format of date while editor has focus.
                Value of that option can be set to explicit date pattern or to a flag defined by regional settings.
                If value is set to explicit date pattern and pattern besides date-flags has explicit characters which match with date-flags or mask-flags, then the "escape" character should be used in front of them.
                If option is not set, then the "date" is used automatically.
                List of predefined regional flags:
                "date": the datePattern member of regional option is used
                "dateLong": the dateLongPattern member of regional option is used
                "time": the timePattern member of regional option is used
                "timeLong": the timeLongPattern member of regional option is used
                "dateTime": the dateTimePattern member of regional option is used
                List of explicit characters, which should have escape \\ character in front of them: C, &, a, A, ?, L, 9, 0, #, >, <, y, M, d, h, H, m, s, t, f.
                List of date-flags when explicit date pattern is used:
                "y": year field without century and without leading zero
                "yy": year field without century and with leading zero
                "yyyy": year field with leading zeros
                "M": month field as digit without leading zero
                "MM": month field as digit with leading zero
                "MMM": month field as short month name. Note: in focused state the MM is used.
                "MMMM": month field as long month name. Note: in focused state the MM is used.
                "d": day of month field without leading zero 
                "dd": day of month field with leading zero
                "ddd": day of the week as short name. Note: in focused state that field is skipped.
                "dddd": day of the week as long name. Note: in focused state that field is skipped.
                "t": first character of string which represents AM/PM field 
                "tt": 2 characters of string which represents AM/PM field
                "h": hours field in 12-hours format without leading zero
                "hh": hours field in 12-hours format with leading zero
                "H": hours field in 24-hours format without leading zero
                "HH": hours field in 24-hours format with leading zero
                "m": minutes field without leading zero
                "mm": minutes field with leading zero
                "s": seconds field without leading zero
                "ss": seconds field with leading zero
                "f": milliseconds field in hundreds
                "ff": milliseconds field in tenths
                "fff": milliseconds field
            */
            dateInputFormat: null,
            /* type="date|editModeText|displayModeText|" Sets gets type of value returned by the get of value() method. That also affects functionality of the set value(val) method and the copy/paste operations of browser.
                date type="string" The Date object is used. Note: that is used as default.
                displayModeText type="string" The String object is used and the "text" in display mode (no focus) format (pattern).
				editModeText type="string" The String object is used and the "text" in edit mode (focus) format (pattern).
            */
            dataMode: 'date',
        	/*type="clear|spin" Sets gets visibility of spin and clear buttons. That option can be set only on initialization. Combinations like 'spin,clear' are supported too.
				clear type="string" button to clear value is located on the right side of input-field (or left side if base html element has direction:rtl);
				spin type="string" spin buttons are located on the right side of input-field (or left side if base html element has direction:rtl).*/
			buttonType: "none",
        	/* type="number" Sets gets delta-value which is used to increment or decrement value in editor on spin events. If value is set to negative value an exception is thrown. Non integer value is supported only for dataMode double and float.*/
            spinDelta: 1,
        	/* type="bool" Sets gets ability to modify only 1 date field on spin events.
                Value false enables changes of other date fields when incremented or decremented date-field reaches its limits.
                Value true modifies only value of one field.
            */
            limitSpinToCurrentField: false,
            /* type="bool" Sets gets formatting of the dates as UTC.
                That option is supported only when dataMode option is 'date' and Date objects are used to get/set value of editor.
                Notes:
                That option affects only functionality of get/set value method and the Date-value, which was set on initialization.
                When application uses the set-value, then internal Date-value and displayed-text is incremented by TimezoneOffset.
                When application uses the get-value, then editor returns internal Date-value decremented by TimezoneOffset.
                When that option is modified after initialization, then displayed text and internal Date-value are not affected.
                It is not recommended to change that option without resetting Date-value.
            */
            enableUTCDates: false,
        	/* type="number" Sets gets year for auto detection of 20th and 21st centuries.
				That option is used to automatically fill century when the user entered only 1 or 2 digits into the year field or when the date pattern contains only 1 or 2 year positions, e.g. "yy" or "y".
				If user entered value larger than value of this option, then 20th century is used, otherwise the 21st. */
            centuryThreshold: 29,
            /* type="number" Sets gets difference between year in Gregorian calendar and displayed year. */
            yearShift: 0
        },
    	events: {
    		/* igWidget events go here */
    	},
    	_create: function () { // igDateEditor

    		$.ui.igMaskEditor.prototype._create.call(this);
    	},
    	_initialize: function () {
    		this._super();
    		this._applyRegionalSettings();
    		this.options.inputMask = this._convertDateMaskToDigitMask(this.options.dateInputFormat);
    		this._setNumericType();
    	    //RegEx for /Date(milisecond)/ 
            this._mvcDateRegex = /^\/Date\((.*?)\)\/$/i;
    	},
    	_setNumericType: function () {
    		this._numericType = "datetime";
    	},
    	_setOption: function (option, value) { // igDateEditor
    	    /* igDateEditor custom setOption goes here */
    	    var prevValue = this.options[option];
    	    if (prevValue === value) {
    	        return;
    	    }
    	    // The following line applies the option value to the igWidget meaning you don't
    	    // have to perform this.options[option] = value;
    	    $.Widget.prototype._setOption.apply(this, arguments);
    	    switch (option) {
    	        case "minValue": {
    	            this.options[option] = prevValue;
    	            throw new Error($.ig.Editor.locale.dateEditorMinValue);
    	        }
    	        case "maxValue": {
    	            this.options[option] = prevValue;
    	            throw new Error($.ig.Editor.locale.dateEditorMaxValue);
    	        }
    	            break;
    	        default: {
    	            //In case no propery matches, we call the super. Into the base widget default statement breaks
    	            this.options[option] = prevValue;
    	            this._super(option, value);
    	        }
    	            break;
    	    }
    	},
    	_applyRegionalSettings: function () { //DateEditor
    		var format;
    		if (this.options.dateInputFormat !== null) {
    			format = this.options.dateInputFormat;
    			if (format === "date" || format === "dateLong" || format === "dateTime" || format === "time" || format === "timeLong") {
    				this.options.dateInputFormat = this._getRegionalOption(format + "Pattern");
    			}
    		} else {
    			this.options.dateInputFormat = this._getRegionalOption("datePattern");
    		}
    		if (this.options.dateDisplayFormat !== null) {
    			format = this.options.dateDisplayFormat;
    			if (format === "date" || format === "dateLong" || format === "dateTime" || format === "time" || format === "timeLong") {
    				this.options.dateDisplayFormat = this._getRegionalOption(format + "Pattern");
    			}
    		} else {
    			this.options.dateDisplayFormat = this.options.dateInputFormat;
    		}
    	},
    	_setInitialValue: function (value) { //igDateEditor
    		this._maskWithPrompts = this._parseValueByMask("");
    		this._getMaskLiteralsAndRequiredPositions();
    		if (value === null || value === "" || typeof value === undefined) {
    			this._maskedValue = "";
    		} else {
				
    			if (this._validateValue(value)) {
    				this._updateValue(this._getDateObjectFromValue(value));
    				//Update maskedValue according to the new value. 
    				this._updateMaskedValue();
    			}
    			this._editorInput.val(this._getDisplayValue());
    		}
    	},
    	_applyOptions: function () { //DateEditor
    		this._super();
    		if (this.options.centuryThreshold > 99 || this.options.centuryThreshold < 0) {
    			this.options.centuryThreshold = 29;
    			console.log($.ig.Editor.locale.centuryThresholdValidValues);
    		}
    		if(this.options.minValue){
    		    if (!this._isValidDate(new Date(this.options.minValue))) {
    		        throw new Error($.ig.Editor.locale.invalidDate);
                }
    		}
    		if (this.options.maxValue) {
    		    if (!this._isValidDate(new Date(this.options.maxValue))) {
    		        throw new Error($.ig.Editor.locale.invalidDate);
    		    }
    		}
    	},
    	_triggerKeyDown: function (event) { //DateEditor
    		var key = !event.charCode ? event.which : event.charCode;
    		this._super(event);
    		// TODO: Optimize this method together with _triggerKeyDown in the igDatePicker.
    		if (key === 38 && !(this instanceof $.ui.igDatePicker)) {
    			this._spinUpEditMode();
    			}
    		if (key === 40 && !(this instanceof $.ui.igDatePicker)) {
    			this._spinDownEditMode();
    		}
    		if (key === 13) {
    			this._enterEditMode();
			}
    	},
    	_handleSpinUpEvent: function () { //DateEditor
			this.spinUp(1);
		},
    	_handleSpinDownEvent: function () { //DateEditor
			this.spinDown(1);
    	},
    	_replaceDisplayValue: function (selection, previousValue, newValue) {
    		var value = previousValue, currentIndex = selection.start, currentChar, charCode, charIndex = 0, newChar;
    		newValue = newValue.toString();
    		while (currentIndex < previousValue.length && charIndex < newValue.length) {
    			currentChar = previousValue.charAt(currentIndex);
    			charCode = previousValue.charCodeAt(currentIndex);
    			newChar = newValue.charAt(charIndex);
    			if (charCode >= 48 && charCode <= 57 || currentChar === "_") {
    				value = value.substring(0, currentIndex) + newChar + value.substring(currentIndex + 1, previousValue.length);
    				charIndex++;
    			}
    			currentIndex++;
    		}
    		return value;
    	},
    	//flag to get/set specific date field (year, month, day, hours, minutes, seconds, milliseconds)
		//date DateObject
    	_getDateField: function (flag, date) {
    		var utc = this.options.enableUTCDates, shift = this.options.yearShift, year;

    			if (!date) {
    				date = this._dateObjectValue;
    			}
    			if (!date) {
    				return null;
    			}
    			//// set into datepicker
    			//	if (f === -1) {
    			//		return (date && utc) ? new Date(date.getTime() + date.getTimezoneOffset() * 60000) : date;
    			//	}
    			//// now
    			//if (!date) {
    			//	date = new Date();
    			//	if (utc) {
    			//		date.setUTCMinutes(date.getUTCMinutes() - date.getTimezoneOffset());
    			//	}
    			//	return date;
    			//}
    		    
    			if (flag === "year") {
    				year = utc ? date.getUTCFullYear() : date.getFullYear();
    				if (shift) {
    					year += shift;
    				}
    				return year;
    			}
    			if (flag === "month") {
    				return utc ? date.getUTCMonth() : date.getMonth();
    			}
    			if (flag === "day") {
    				return utc ? date.getUTCDay() : date.getDay();
    			}
    			if (flag === "date") {
    				return utc ? date.getUTCDate() : date.getDate();
    			}
    			if (flag === "hours") {
    				return utc ? date.getUTCHours() : date.getHours();
    			}
    			if (flag === "minutes") {
    				return utc ? date.getUTCMinutes() : date.getMinutes();
    			}
    			if (flag === "seconds") {
    				return utc ? date.getUTCSeconds() : date.getSeconds();
    			}
    			return utc ? date.getUTCMilliseconds() : date.getMilliseconds();
    	},
		//This method sets specific field and returns the date
		_setDateField: function(flag, date, newValue) {
			var utc = this.options.enableUTCDates, shift = this.options.yearShift;
			
			if (!date) {
				date = this._dateObjectValue;
			}
			
			if (flag === "year") {
				if (shift) {
					newValue -= shift;
				}
				if (utc) {
					date.setUTCFullYear(newValue);
				} else {
					date.setFullYear(newValue);
				}
			}
			if (flag === "month") {
				if (utc) {
					date.setUTCMonth(newValue);
				} else {
					date.setMonth(newValue);
				}
			}
			if (flag === "date") {
				if (utc) {
					date.setUTCDate(newValue);
				} else {
					date.setDate(newValue);
				}
			}
			if (flag === "hours") {
				if (utc) {
					date.setUTCHours(newValue);
				} else {
					date.setHours(newValue);
				}
			}
			if (flag === "minutes") {
				if (utc) {
					date.setUTCMinutes(newValue);
				} else {
					date.setMinutes(newValue);
				}
			}
			if (flag === "seconds") {
				if (utc) {
					date.setUTCSeconds(newValue);
				} else {
					date.setSeconds(newValue);
				}
			}
			if (flag === "miliseconds") {
				if (utc) {
					date.setUTCMilliseconds(newValue);
				} else {
					date.setMilliseconds(newValue);
				}
			}
			return date;
		},		
    	_updateMaskedValue: function () {
			//this method updated maskwith prompts according to te set new date value
    		var currentMaskValue = this._maskWithPrompts ? this._maskWithPrompts : this._parseValueByMask(""), dateObj = this._dateObjectValue, year, month, day, hours, minutes, seconds, miliseconds;
			//TODO update all the fields
    		if (dateObj) {
    			if (this._dateIndices.yy !== undefined) {
    				year = this._getDateField("year", dateObj).toString();
    				if (this._dateIndices.fourDigitYear) {
    					currentMaskValue = this._replaceStringRange(currentMaskValue, year, this._dateIndices.yy, this._dateIndices.yy + 3);
    				} else {
    					year = year.substring(2);
    					currentMaskValue = this._replaceStringRange(currentMaskValue, year, this._dateIndices.yy, this._dateIndices.yy + 1);
    				}
    			}
    			if (this._dateIndices.MM !== undefined) {
    				month = this._getDateField("month", dateObj);
    				month++;
    				if (month < 10) {
    					month = "0" + month.toString();
    				} else {
    					month = month.toString();
    				}
   					currentMaskValue = this._replaceStringRange(currentMaskValue, month, this._dateIndices.MM, this._dateIndices.MM + 1);
    			}
    			if (this._dateIndices.dd !== undefined) {
    				day = this._getDateField("date", dateObj);
    				if (day < 10) {
    					day = "0" + day.toString();
    				} else {
    					day = day.toString();
    				}
    				currentMaskValue = this._replaceStringRange(currentMaskValue, day, this._dateIndices.dd, this._dateIndices.dd + 1);
    			}
    			if (this._dateIndices.hh !== undefined) {
    			    hours = this._getDateField("hours", dateObj);
    			    if (!this._dateIndices.hh24 && hours > 12) {
    			        hours -= 12;
    			    }
    			    if (hours < 10) {
    			        hours = "0" + hours.toString();
    			    } else {
    			        hours = hours.toString();
    			    }
    			    currentMaskValue = this._replaceStringRange(currentMaskValue, hours, this._dateIndices.hh, this._dateIndices.hh + 1);
    			}
    			if (this._dateIndices.mm !== undefined) {
    				minutes = this._getDateField("minutes", dateObj);
    				if (minutes < 10) {
    					minutes = "0" + minutes.toString();
    				} else {
    					minutes = minutes.toString();
    				}
    				currentMaskValue = this._replaceStringRange(currentMaskValue, minutes, this._dateIndices.mm, this._dateIndices.mm + 1);
    			}
    			if (this._dateIndices.ss !== undefined) {
    				seconds = this._getDateField("seconds", dateObj);
    				if (seconds < 10) {
    					seconds = "0" + seconds.toString();
    				} else {
    					seconds = seconds.toString();
    				}
    				currentMaskValue = this._replaceStringRange(currentMaskValue, minutes, this._dateIndices.ss, this._dateIndices.ss + 1);
    			}
    			if (this._dateIndices.tt !== undefined) {
    				hours = this._getDateField("hours", dateObj);
    				if (hours > 12) {
    					// PM
    					if (this._dateIndices._ttLength === 1) {
    						//_replaceCharAt
    						currentMaskValue = this._replaceCharAt(currentMaskValue, this._dateIndices.tt, "P");
    					} else {
    						currentMaskValue = this._replaceStringRange(currentMaskValue, "PM", this._dateIndices.tt, this._dateIndices.tt + 1);
    					}
    				} else {
    					// AM
    					if (this._dateIndices._ttLength === 1) {
    						//_replaceCharAt
    						currentMaskValue = this._replaceCharAt(currentMaskValue, this._dateIndices.tt, "A");
    					} else {
    						currentMaskValue = this._replaceStringRange(currentMaskValue, "AM", this._dateIndices.tt, this._dateIndices.tt + 1);
    					}
    				}
    			}
    			if (this._dateIndices.ff !== undefined) {
    				miliseconds = this._getDateField("miliseconds", dateObj);
    				if (this._dateIndices.ffLength === 1) {
    					currentMaskValue = this._replaceCharAt(currentMaskValue, this._dateIndices.ff, this._getMiliseconds(miliseconds, 100).toString());
    				} else if (this._dateIndices.ffLength === 2) {
    					currentMaskValue = this._replaceStringRange(currentMaskValue, this._getMiliseconds(miliseconds, 10).toString() , this._dateIndices.ff, this._dateIndices.tt + 1);
    				} else {
    					currentMaskValue = this._replaceStringRange(currentMaskValue, miliseconds.toString(), this._dateIndices.ff, this._dateIndices.tt + 2);
    				}
    			}
    		}
    		this._maskedValue = currentMaskValue;
    	}, 
		//This method is used to get indices of the date groups within the mask and to convert the date mask into a mask with digit flags valid for igMaskEditor
    	_convertDateMaskToDigitMask: function (mask) {
    		var x, i, j, flag = -1, txt = '', maskVal = mask;
    		if (!maskVal) {
    			maskVal = '';
    		}
			maskVal = maskVal.replace('dddd', 'ddd').replace('ddd,', '').replace('ddd ', '').replace(' ddd', '').replace('ddd', '');

    		this._dateIndices = {};
    		this._dateIndices.fourDigitYear = false;


    		// temporary replace \\f,d,s,m,etc. by \x01-\x09
    		maskVal = maskVal.replace(/\x08/g, ' ').replace(/\x09/g, ' ');
    		maskVal = maskVal.replace(/\\f/g, '\x01').replace(/\\d/g, '\x02').replace(/\\s/g, '\x03').replace(/\\m/g, '\x04').replace(/\\t/g, '\x05').replace(/\\H/g, '\x06').replace(/\\h/g, '\x07').replace(/\\M/g, '\x08').replace(/\\y/g, '\x09');
    		// 01-y,02-yy,03-yyyy,04-M,05-MM,06-MMM,07-MMMM,08-d,09-dd
    		// 10-h,11-hh,12-H,13-HH,14-t,15-tt,16-m,17-mm,18-s,19-ss
    		// 20-ddd,21-dddd,22-f,23-ff,24-fff
    		//Temporary remove 0 and 9, as they are valid mask flags 

    		maskVal = maskVal.replace(/9/g, "\x11").replace(/0/g, "\x12");
    		maskVal = maskVal.replace('fff', '24').replace('ff', '23').replace('f', '22');
    		maskVal = maskVal.replace('dddd', '').replace('ddd', '').replace('dd', '09').replace('d', '08').replace('ss', '19').replace('s', '18').replace('mm', '17').replace('m', '16');
    		maskVal = maskVal.replace('tt', '15').replace('t', '14').replace('HH', '13').replace('H', '12').replace('hh', '11').replace('h', '10');
    		maskVal = maskVal.replace('MMMM', 'MM').replace('MMM', 'MM').replace('MM', '05').replace('M', '04');
			maskVal = maskVal.replace('yyyy', '03').replace('yy', '02').replace('y', '01');

    		// restore original \\f,d,s,m,etc.
    		maskVal = maskVal.replace(/\x01/g, 'g').replace(/\x02/g, 'd').replace(/\x03/g, 's').replace(/\x04/g, 'm').replace(/\x05/g, 't').replace(/\x06/g, 'H').replace(/\x07/g, 'h').replace(/\x08/g, 'M').replace(/\x09/g, 'y');


    		for (i = 0, j = 0; i < maskVal.length; i++, j++) {
    			x = maskVal.charCodeAt(i);
    			if (x < 48 || x > 57) {
    				flag = maskVal.charAt(i);
    					if (flag === '\\' && i + 1 < maskVal.length &&
							($.inArray(maskVal.charAt(i + 1), this._maskFlagsArray) !== -1) || //Escaped mask flag
							maskVal.charAt(i + 1) === "\x11" || // Temporary removed 9
							maskVal.charAt(i + 1) === "\x12") { // Temporary removed 0
    						j--;
    					}
    					txt += maskVal.charAt(i);
    				continue;
    			}
				//generate flag (Still using VS functionality )
    			flag = (x - 48) * 10 + maskVal.charCodeAt(++i) - 48;
    			if (flag === 14) {
    				txt += 'L';

    			} else if (flag === 15) {
    				txt += 'LL';

    			} else if (flag === 22) {
    				txt += '0';
    			} else {
    				txt += '00';
    				if (flag === 3) {
    					txt += '00';
    				}
    				while (flag >= 23) {
    					txt += '0';
    					flag--;
    				}
    			}
    			// 01-y,02-yy,03-yyyy,04-M,05-MM,06-MMM,07-MMMM,08-d,09-dd
    			// 10-h,11-hh,12-H,13-HH,14-t,15-tt,16-m,17-mm,18-s,19-ss
    			// 20-ddd,21-dddd,22-f,23-ff,24-fff
				//TODO discuss if we want to throw an w
    			switch (flag) {
    				//4, 5, 6, 7
    				//04-M,05-MM,06-MMM,07-MMMM
					case 4:
    				case 5:
    				case 6:
    				case 7: {
    					if (this._dateIndices.MM) {
    						j++;
    						break;
    					} else {
    						this._dateIndices.MM = j;
    						j++;
    					}
    				}
    					break;
					case 8:
    				case 9:
    				case 20:
    				case 21: {
    					if (this._dateIndices.dd) {
    						j++;
    						break;
    					} else {
    						this._dateIndices.dd = j;
    						j++;
    					}
    				}
    					break;
					case 1:
    				case 2: {
    					if (this._dateIndices.yy) {
    						j++;
    						break;
    					} else {
    						this._dateIndices.yy = j;
    						j++;
    						this._dateIndices.fourDigitYear = false;
    					}
    				}
    					break;
    				case 3: {
    					if (this._dateIndices.yy) {
    						j += 3;
    						break;
    					} else {
    						this._dateIndices.yy = j;
    						j += 3;
    						this._dateIndices.fourDigitYear = true;
    					}
    				}
    					break;
    				case 14: { // t
    					if (this._dateIndices.tt) {
    				
    						break;
    					} else {
    						this._dateIndices.tt = j;
    						j++;
							//Flag representing am/pm field 
    						this._dateIndices._ttLength = 1;
    					}
    				}
    					break;
    				case 15: { // tt
    					if (this._dateIndices.tt) {
    						j++;
    						break;
    					} else {
    						this._dateIndices.tt = j;
    						j++;
    						//Flag representing am/pm field 
    						this._dateIndices._ttLength = 2;
    					}
    				}
    					break;
    					// 10-h,11-hh,12-H,13-HH,14-t,15-tt,16-m,17-mm,18-s,19-ss

					case 10: //h
    				case 11: { // hh
    					if (this._dateIndices.hh) {
    						j += 2;
    						break;
    					} else {
    						this._dateIndices.hh = j;
							//this flag is used to distinguish if the hours are in 24 hours format or 12 hours
    						this._dateIndices.hh24 = false;
    						j++;
    					}
    				}
    					break;
					case 12: // H
    				case 13: { // HH
    					if (this._dateIndices.hh) {
    						j += 2;
    						break;
    					} else {
    						this._dateIndices.hh = j;
    						//this flag is used to distinguish if the hours are in 24 hours format or 12 hours
    						this._dateIndices.hh24 = true;
    						j++;
    					}
    				}
    					break;
    				case 16: //m
    				case 17: { //mm
    					if (this._dateIndices.mm) {
    						j ++;
    						break;
    					} else {
    						this._dateIndices.mm = j;
    						j++;
    					}
    				}
    					break;
					case 18: //s 
    				case 19: {//ss
    					if (this._dateIndices.ss) {
    						j++;
    						break;
    					} else {
    						this._dateIndices.ss = j;
    						j++;
    					}
    				}
    					break;
    					//22 - f, 23 - ff, 24 - fff
    				case 22: {
    					if (this._dateIndices.ff) {
    						break;
    					} else {
    						this._dateIndices.ff = j;
    						this._dateIndices.ffLength = 1;
    					}
    				}
    					break;
    				case 23: {
    					if (this._dateIndices.ff) {
    						j++;
    						break;
    					} else {
    						this._dateIndices.ff = j;
    						this._dateIndices.ffLength = 2;
    						j++;
    					}
    				}
    					break;
    				case 22: {
    					if (this._dateIndices.ff) {
    						j += 2;
    						break;
    					} else {
    						this._dateIndices.ff = j;
    						this._dateIndices.ffLength = 3;
    						j += 2;
    					}
    				}
    					break;
    				default:
    			}
				
    		}
			//restore temporary removed 0 and 9 flags.
    		txt = txt.replace(/\x11/g, 9).replace(/\x12/g, 0);
    		return txt;
    	},
    	_getRegionalOption: function (key) { // igDateEditor
    		var regional = this.options.regional;
    		if (this.options[key]) {
    			return this.options[key];
    		}
    		if (typeof regional === "string") {
    			regional = $.ig.regional[regional];
    		}
    		if (regional && regional[key]) {
    			return regional[key];
    		} else {
    			//return defaults
    			return $.ig.regional.defaults[key];
    		}
    	},
    	_validateKey: function (event) {
    		var result = true, ch, key, cursorPosition;
    		if (this._super(event) === true) {
    			cursorPosition = this._getCursorPosition();

				//TODO add all needed checks for indices /left 
				//For every pair we check if the current index is in the array for month fields, or the previous index is in the array. if we have dd, as a mask and we have alredy entered 1, when we type 5 - current cursor position is not in the list so we check if the previous one is in the list and pass the validation to month validateion. 
    			if (cursorPosition === this._dateIndices.MM || (cursorPosition - 1) === this._dateIndices.MM) {
    				//ValidateMonthInput
    				result = this._validateMonthInput(event, cursorPosition);
    			} else if (cursorPosition === this._dateIndices.dd || (cursorPosition - 1) === this._dateIndices.dd) {
    				//ValidateDayInput
    				result = this._validateDayInput(event, cursorPosition);
    			} else if (cursorPosition === this._dateIndices.hh || (cursorPosition - 1) === this._dateIndices.hh) {
    				//ValidateHoursInput
    				result = this._validateHoursInput(event, cursorPosition);
    			} else if (cursorPosition === this._dateIndices.mm || (cursorPosition - 1) === this._dateIndices.mm) {
					//ValidateMinutesInput
    				result = this._validateMinutesInput(event, cursorPosition);
    			} else if (cursorPosition === this._dateIndices.ss || (cursorPosition - 1) === this._dateIndices.ss) {
    				//ValidateSeconsInput
    				result = this._validateSecondsInput(event, cursorPosition);
    			} else if (cursorPosition === this._dateIndices.tt || (cursorPosition - 1) === this._dateIndices.tt) {
    				//ValidateMidDayInput and process
    				result = this._validateMidDayInput(event, cursorPosition);
    				//in case the value is valid and the field contains 2 chars we need to type the m
    				if (result === true) {
    					//We might insert only m after the current position
    					key = !event.charCode ? event.which : event.charCode;
						ch = String.fromCharCode(key);
    					if (ch.toLocaleLowerCase() === "a") {
    						this._editorInput.val(this._replaceCharAt(this._editorInput.val(), cursorPosition, "A"));
    			} else {
    						this._editorInput.val(this._replaceCharAt(this._editorInput.val(), cursorPosition, "P"));
    					}
    					if (this._dateIndices._ttLength === 2) {
    						this._editorInput.val(this._replaceCharAt(this._editorInput.val(), ++cursorPosition, "M"));

    					}
    					this._setCursorPosition(++cursorPosition);
    					event.preventDefault();
    				}
    			} else {
    				result = true;
    			}

    			if (result === null) {
    				cursorPosition++;
    				while ($.inArray(cursorPosition, this._literalIndeces) !== -1 || cursorPosition === this._maskWithPrompts.length) {
    					cursorPosition++;
    				}
    				this._setCursorPosition(cursorPosition);
    				result = this._validateKey(event);
    			}
    			//In case the key is valid according to te parent method the symbol after the cursor position gets selected and if the key is not valid we are setting the cursor position to remain the same without seelection
    			if (result === false) {
    				this._setCursorPosition(cursorPosition);
    			}
    		} else {
    			result = false;
    		}
			
    		return result;
    	},
    	_setBlur: function (event) { //DateEditor
    	    var newValue, oldVal, convertedDate;
    	    if (this._cancelBlurOnInput) {
    	        this._editorInput.focus();
    	        delete this._cancelBlurOnInput;
    	    } else {
    	        this._triggerBlur(event);
    	        newValue = $(event.target).val();
    	        oldVal = this._dateObjectValue;

    	        convertedDate = this._parseDateFromMaskedValue(newValue);
    	    	//#206308 in case newValiue == maskWithPrompts it's either clear value, or just exiting edit mode without entering value. 
    	        if (newValue === this._maskWithPrompts) {
    	        	if (oldVal) {
    	        		this._processValueChanging(newValue);
    	        	}
    	        } else if (!oldVal) {
    	        	this._processValueChanging(newValue);
    	        } else if (convertedDate !== "" && convertedDate - oldVal !== 0) {
    	        	this._processValueChanging(newValue);
    	        }
    	        this._exitEditMode();
    	        
    	        //In case our dropdown is opened we need to close it. 
    	        if (this._dropDownList && this._triggerDropDownClosing()) {
    	            this._hideDropDownList();
    	            this._triggerDropDownClosed();
    	        }
    	        this._focused = false;
    	        this._clearTimeouts();
    	        if (this._validator) { // TODO VERIFY
    	            this._validator._validateInternal(this.element, event, true);
    	        }
    	    }
    	},
    	_validateDayInput: function (event, position) {
    		var /*cursor = position ? position : this._getCursorPosition(), */result = false,
    			key = !event.charCode ? event.which : event.charCode,
				ch = String.fromCharCode(key),
    			num = parseInt(ch),
    			charAtCurrentPosition = parseInt(this._editorInput.val().charAt(position)), 
				charAtPreviousPosition, charAtNextPosition;

    		if (position === this._dateIndices.dd) {
    			if (num < 4) {
    				charAtNextPosition = parseInt(this._editorInput.val().charAt(position + 1));
    				if (!isNaN(charAtNextPosition) && charAtNextPosition > 1 && num === 3) {
    					//In that case we have valid digit ot first position but entering 37 as a day is not valid
    					result = null;
    				} else {
    					result = true;
    				}
    			} else {
    				if (!isNaN(charAtCurrentPosition) && charAtCurrentPosition === 3) {
						//In that case we have, 3 on first position and we know the the entered number is greater than 3, which is not valid and we want to move the index to the next group
    					result = null;
    				} else {
    					this._setSelectionRange(this._editorInput[0], position + 1, position + 2);
    					result = true;
    				}
					
				}
    		} else {
				//We need to check the previous char (digit) and if it's 3 
    			charAtPreviousPosition = parseInt(this._editorInput.val().charAt(position - 1));
    			if (!isNaN(charAtPreviousPosition) && charAtPreviousPosition === 3) {
    				//if the previous digit is 3 the only valid digits are 0 and 1, 
    				if (num === 0 || num === 1) {
    					result = true;
    				} else {
    					//we need to use this flag to move the cursor to the next group
    					result = null;
    				}
    			} else {
    				result = true;
    			}
    		}
    		return result;
    	},
    	_validateMonthInput: function (event, position) {
    		var result = false,
    			key = !event.charCode ? event.which : event.charCode,
				ch = String.fromCharCode(key),
    			num = parseInt(ch),
    			charAtCurrentPosition = parseInt(this._editorInput.val().charAt(position)),
				charAtPreviousPosition, charAtNextPosition;
    		position = position ? position : this._getCursorPosition();
    		if (position === this._dateIndices.MM) { //the cursor is on the first pair 
    			if (num < 2) {
    				charAtNextPosition = parseInt(this._editorInput.val().charAt(position + 1));
    				if (!isNaN(charAtNextPosition) && charAtNextPosition > 2 && num === 1) {
    					//In that case we have valid digit ot first position but entering 17 as a month is not valid
    					result = null;
    				} else {
    					result = true;
    				}
    			} else {

    				if (!isNaN(charAtCurrentPosition) && charAtCurrentPosition === 1) {
    					//In that case we have, 1 on first position and we know the the entered number is greater than 3, which is not valid and we want to move the index to the next group
    					if (num === 2) {
    						result = true;
    					} else {
    						result = null;
    					}
    				} else if (this._editorInput.val().charAt(position) === this.options.unfilledCharsPrompt) {
    					if (num < 2) {
    						result = true;
    					} else {
    						result = null;
    					}
    				} else {
						//first position is either empty, or 0, so all the digits are valid for month. 
    					this._setSelectionRange(this._editorInput[0], position + 1, position + 2);
    					result = true;
    				}
    			}
    		} else {
    			//We need to check the previous char (digit) and if it's 3 
    			charAtPreviousPosition = parseInt(this._editorInput.val().charAt(position - 1));
    			if (!isNaN(charAtPreviousPosition) && charAtPreviousPosition === 1) {
    				//if the previous digit is 1 the only valid digits are 0, 1 and 2; 
    				if (num === 0 || num === 1 || num === 2) {
    					result = true;
    				} else {
    					//we need to use this flag to move the cursor to the next group
    					result = null;
    				}
    			} else {
    				result = true;
    			}
    		}
    		return result;
    	},
    	_validateMidDayInput: function (evnt, position) {
    		var result = false,
				key = !event.charCode ? event.which : event.charCode,
				ch = String.fromCharCode(key);

    		position = position ? position : this._getCursorPosition();
    		if (position === this._dateIndices.tt) { //the cursor is on the first pair
    			if (ch.toString().toLocaleLowerCase() === "a" || ch.toString().toLocaleLowerCase() === "p") {
    				result = true;
    			} else {
    				result = false;
    			}
    		} else {
    			//In that case we are in the second pair and we can't distinguish what the user wants to enter as the second letter is alwayas "m" (am/pm). so the result is null and the cursor will be moved to the next possible position
    			result = null;
    		}
    		return result;
    	},
    	_validateHoursInput: function (event, position) {
    		var result = false,
					key = !event.charCode ? event.which : event.charCode,
					ch = String.fromCharCode(key),
					num = parseInt(ch),
					charAtPreviousPosition, charAtNextPosition;

    		position = position ? position : this._getCursorPosition();
    		if (position === this._dateIndices.hh) {
				//the 24 hours format
    			if (this._dateIndices.hh24) {
    				if (num === 0 || num === 1) {
    					result = true;
    				} else if (num === 2) {
    					charAtNextPosition = parseInt(this._editorInput.val().charAt(position + 1));
    					if (!isNaN(charAtNextPosition) && charAtNextPosition > 4 ) {
    						//In that case we have valid digit ot first position but entering 37 as a day is not valid
    						result = null;
    					} else {
    						result = true;
    					}
    				} else {
    					result = null;
    				}
    			} else {
					//12 hour format
    				if (num === 0) {
    					result = true;
    				} else if (num === 1) {
    					charAtNextPosition = parseInt(this._editorInput.val().charAt(position + 1));
    					if (!isNaN(charAtNextPosition) && charAtNextPosition > 2) {
    						//In that case we have valid digit ot first position but entering 37 as a day is not valid
    						result = null;
    					} else {
    						result = true;
    					}
    				} else {
    					result = null;
    				}
    			}
    		} else {
    			charAtPreviousPosition = parseInt(this._editorInput.val().charAt(position - 1));
    			if (this._dateIndices.hh24) {
    				if (!isNaN(charAtPreviousPosition) && charAtPreviousPosition === 2) {
    					//if the previous digit is 2 the only valid digits are 0 and 1, 2, 3 and 4
    					if (num <= 4) {
    						result = true;
    					} else {
    						//we need to use this flag to move the cursor to the next group
    						result = null;
    					}
    				} else {
    					result = true;
    				}
    			} else {
    				if (!isNaN(charAtPreviousPosition) && charAtPreviousPosition === 1) {
    					//if the previous digit is 1 the only valid digits are 0 and 1 and 2 
    					if (num <= 2) {
    						result = true;
    					} else {
    						//we need to use this flag to move the cursor to the next group
    						result = null;
    					}
    				} else {
    					result = true;
    				}
    			}

    		}
    		return result;
    	},
    	_validateMinutesInput: function (event, position) {
    		var result = false,
					key = !event.charCode ? event.which : event.charCode,
					ch = String.fromCharCode(key),
					num = parseInt(ch);

    		position = position ? position : this._getCursorPosition();
    		if (position === this._dateIndices.mm) {

    			if (num < 6) {
    				result = true;
    			} else {
    				result = null;
    			}
    		} else {
    			result = true;
    		}
    		return result;
    	},
    	_validateSecondsInput: function (event, position) {
    		var result = false,
					key = !event.charCode ? event.which : event.charCode,
					ch = String.fromCharCode(key),
					num = parseInt(ch);

    		position = position ? position : this._getCursorPosition();
    		if (position === this._dateIndices.ss) {
    			if (num < 6) {
    				result = true;
    			} else {
    				result = null;
    			}
    		} else {
    			result = true;
    		}
    		return result;
    	},
    	_fillCentury: function (year) {
    		if (!isNaN(year)) {
    			if (year > 0 && year <= this.options.centuryThreshold) {
    				year = 2000 + year;
    			} else if (year < 100) {
    				year = 1900 + year;
    			}
    		}
    		return year;
    	},
    	_triggerKeyPress: function (event) { //DateEditor
    	    if (event.keyCode === 13) {    	      
    	        this._processInternalValueChanging(this._editorInput.val());
    	    } else {
    	        this._super(event);
    	    }
    	},
    	_triggerInternalValueChange: function (value) { //DateEditor
    		if (value === this._maskWithPrompts) {
    			value = "";
    		}
    		var noCancel = this._triggerValueChanging(value);
    		if (noCancel) {
    			this._processInternalValueChanging(value);
    			//We pass the new value in order to have the original value into the arguments
    			this._triggerValueChanged(value);
    		}
    	},
    	_processInternalValueChanging: function (value) { //DateEditor
    		//value = this._parseDateFromMaskedValue(value);
    		var parsedVal;
    		if (value === "") { //Empty string is passed only when the value from the _triggerInternalValueChange is equal to the empty mask with prompts
    			this._clearValue();
    			return;
    		}
    		if ($.type(value) === "date") {
    			parsedVal = value;
    		} else {
    			parsedVal = this._parseDateFromMaskedValue(value);
    		}
    		if (this._validateValue(parsedVal)) {    		   
    			this._updateValue(parsedVal);
    		} else {
    			//If the value is not valid, we clear the editor 
    			if (this.options.revertIfNotValid) {
    				value = this._valueInput.val();
    				this._updateValue(value);
    			} else {
    				this._clearValue();
    				value = this._valueInput.val();
    			}
    		}
    	},
    	_isValidDate: function (date) {
    	    date = this._getDateObjectFromValue(date);
    	    return date.getTime() === date.getTime();
        },
    	_validateValue: function (val) { //igDateEditor
    	    var result, dateObj, minValue, maxValue;
    	    if (val === null || val === "") {
    	        return true;
    	    }
    	    dateObj = this._getDateObjectFromValue(val);
           
    	    minValue = this._getDateObjectFromValue(this.options.minValue);
    	    maxValue = this._getDateObjectFromValue(this.options.maxValue);

    	    if (this._super(val) && this._isValidDate(dateObj)) {
    	        if (this.options.maxValue && this._isValidDate(maxValue) && dateObj > maxValue) {
    		        result = false;
    		        if (this.options.revertIfNotValid) {
    		            //Raise Warning level 2
    		            this._sendNotification("warning", $.ig.util.stringFormat($.ig.Editor.locale.maxValExceedRevertErrMsg, this.options.maxValue));
    		        }
    	        } else if (this.options.minValue && this._isValidDate(minValue) && dateObj < minValue) {
    		        result = false;
    		        if (this.options.revertIfNotValid) {
    		            //Raise Warning level 2
    		            this._sendNotification("warning", $.ig.util.stringFormat($.ig.Editor.locale.minValExceedRevertErrMsg, this.options.minValue));
    		        }
    		    } else {
    		        result = true;
    		    }
    		} else {
    		    result = false;
    		}
    		return result;
    	},
    	_updateValue: function (value) { //igDateEditor
    		//TODO Review
    		if (value === null) {
    			this._maskedValue = this._maskWithPrompts;
    			this._valueInput.val("");
    			this.options.value = null;
    			this._dateObjectValue = null;
    		} else if (value === "") {
    			//empty string is passed only when clear is called, or when an empty value is created
    			//In that case we have empty editor. 

 				this._maskedValue = this._maskWithPrompts;
 				this._valueInput.val("");
				this.options.value = "";
    			this._dateObjectValue = null;
    		} else {    		  
    		    //convert the value to date object;
    			this._dateObjectValue = this._getDateObjectFromValue(value);
    			this.options.value = this._getValueByDataMode();
    			// TODO here maybe the format of the submit value of the date should be some standart format like 2015-03-25T12:00:00
    			if (this.options.value instanceof Date) {
    				this._valueInput.val(this.options.value.toLocaleString(this.options.regional ? this.options.regional : "en"));
    			} else {
    				this._valueInput.val(this.options.value);
    			}
    		}
    		this._updateMaskedValue();
    	},
    	_clearValue: function () { //DateEditor
			//TODO
    		if (this.options.allowNullValue) {
    			this._updateValue(this.options.nullValue);
    			if (this.options.nullValue === null) {
    				this._editorInput.val(this._maskWithPrompts);
				}
    		} else {
    			this._updateValue("");
    			this._editorInput.val(this._maskWithPrompts);
			}    		
    		if (this._editMode === false) {
    			this._exitEditMode();
			}
    	}, 
    	_getDateObjectFromValue: function (value) { //DateEditor
    		if ($.type(value) === "date") {
    			if (this.options.enableUTCDates) {
    				value = new Date(Date.UTC(value.getFullYear(), value.getMonth(), value.getDate()));
    			}
    			return value;
    		} else if (this._mvcDateRegex.test(value)) {
    		    return new Date(parseInt(value.replace(this._mvcDateRegex, "$1"), 10));
    		} else if (typeof value === "string") {
    		    return this._parseDateFromMaskedValue(value);
    		} else {
    		    return new Date(value);
    		}
    	},
    	_getValueByDataMode: function () {
    		var dataModeValue,
				maskedVal = this._maskedValue ? this._maskedValue : this._maskWithPrompts,
				dataMode = this.options.dataMode;
    		//TODO implement all of the modes
    		switch (dataMode) {
    			case "date": {
    				dataModeValue = this._dateObjectValue;
    			}
    				break;
    			case "displayModeText": {
    				dataModeValue = this._getDisplayValue();
    			}
    				break;
    			case "editModeText": {
    				dataModeValue = maskedVal;
    			}
    				break;
    			default: {
    				//If the option is not valid we default back to the date
    				dataModeValue = this._dateObjectValue;
    			}
    		}
    		return dataModeValue;
    	},
    	_parseDateFromMaskedValue: function (value) {
    		var dateField, monthField, yearField, hourField, minutesField, secondsField, milisecondsField, midDayField,
				dateStartIndex = this._dateIndices.dd, regExpr, ffCount, lastDayOfMonth,
    			monthStartIndex = this._dateIndices.MM,
    			yearStartIndex = this._dateIndices.yy,
                hourStartIndex = this._dateIndices.hh,
                minuteStartIndex = this._dateIndices.mm,
				secondsStartIndex = this._dateIndices.ss,
				midDayStartIndex = this._dateIndices.tt,
				milisecondsStartIndex = this._dateIndices.ff,
				extractedDate = "";
    		if (value === "" || value === null || value instanceof Date) {
				//that case is when in the process value changing the value is equal to the empty mask. We don't have any user input. 
    			return extractedDate;
    		}
			//Extract Day
    		if (dateStartIndex !== undefined && dateStartIndex !== null) {
    			dateField = value.substring(dateStartIndex, dateStartIndex + 2);
    			if (dateField.indexOf(this.options.unfilledCharsPrompt) !== -1) {
    				regExpr = new RegExp($.ig.util.escapeRegExp(this.options.unfilledCharsPrompt), 'g');
    				dateField = dateField.replace(regExpr, "");
    			}
    			if (dateField !== "") {
    				dateField = parseInt(dateField);
    			} else {
    				dateField = null;
				}
    		}
    		//Extract Month
    		if (monthStartIndex !== undefined && monthStartIndex !== null) {
    			monthField = value.substring(monthStartIndex, monthStartIndex + 2);
    			if (monthField.indexOf(this.options.unfilledCharsPrompt) !== -1) {
    				regExpr = new RegExp($.ig.util.escapeRegExp(this.options.unfilledCharsPrompt), 'g');
    				monthField = monthField.replace(regExpr, "");
    			}
    			if (monthField !== "") {
    				monthField = parseInt(monthField);
					//jquery uses zero base months while the user enters real months
    				monthField--;
    			} else {
    				monthField = null;
				}
    		}
    		//Extract Year

    		if (yearStartIndex !== undefined && yearStartIndex !== null) {
    			if (this._dateIndices.fourDigitYear) {
    				yearField = value.substring(yearStartIndex, yearStartIndex + 4);
    			} else {
    				yearField = value.substring(yearStartIndex, yearStartIndex + 2);
    			}
    			if (yearField.indexOf(this.options.unfilledCharsPrompt) !== -1) {
    				regExpr = new RegExp($.ig.util.escapeRegExp(this.options.unfilledCharsPrompt), 'g');
    				yearField = yearField.replace(regExpr, "");
    			}
    			if (yearField !== "") {
    				yearField = parseInt(yearField);
    				yearField = this._fillCentury(yearField);
    			} else {
    				yearField = null;
				}

				//TODO Century
    		
    		}


    		//Extract midday am/pm
    		if (midDayStartIndex !== undefined && midDayStartIndex !== null) {
    			midDayField = value.substring(midDayStartIndex, midDayStartIndex + 1);
    			if (midDayField === this.options.unfilledCharsPrompt) {
    				midDayField = null;
    			} else {
					// possible values "a" and "p"
    				midDayField = midDayField.toLocaleLowerCase();
				}
			}
    	    //Extract Hour

    		if (hourStartIndex !== undefined && hourStartIndex !== null) {
    		    hourField = value.substring(hourStartIndex, hourStartIndex + 2);
    		    if (hourField.indexOf(this.options.unfilledCharsPrompt) !== -1) {
    		        regExpr = new RegExp($.ig.util.escapeRegExp(this.options.unfilledCharsPrompt), 'g');
    		        hourField = hourField.replace(regExpr, "");
    		    }
    		    if (hourField !== "") {
    		        hourField = parseInt(hourField);
    		        if (this._dateIndices.hh24 === false) {
    		        	if (midDayField && midDayField === "p") {
    		        		hourField += 12;
						}
					}
    		        //hourField--;
    		    } else {
    		    	hourField = null;
				}
    		}

    	    //Extract Minute

    		if (minuteStartIndex !== undefined && minuteStartIndex !== null) {
    		    minutesField = value.substring(minuteStartIndex, minuteStartIndex + 2);
    		    if (minutesField.indexOf(this.options.unfilledCharsPrompt) !== -1) {
    		        regExpr = new RegExp($.ig.util.escapeRegExp(this.options.unfilledCharsPrompt), 'g');
    		        minutesField = minutesField.replace(regExpr, "");
    		    }
    		    if (minutesField !== "") {
    		        minutesField = parseInt(minutesField);
    		        
    		    } else {
    		    	minutesField = null;
				}

    		}
    		//Extract Seconds
    		if (secondsStartIndex !== undefined && secondsStartIndex !== null) {
    			secondsField = value.substring(secondsStartIndex, secondsStartIndex + 2);
    			if (secondsField.indexOf(this.options.unfilledCharsPrompt) !== -1) {
    				regExpr = new RegExp($.ig.util.escapeRegExp(this.options.unfilledCharsPrompt), 'g');
    				secondsField = secondsField.replace(regExpr, "");
    			}
    			if (secondsField !== "") {
    				secondsField = parseInt(secondsField);

    			} else {
    				secondsField = null;
    			}

    		}
    		
			//Extract Miliseconds

    		if (milisecondsStartIndex !== undefined && milisecondsStartIndex !== null) {
    			milisecondsField = value.substring(milisecondsStartIndex, milisecondsStartIndex + this._dateIndices.ffLength);
    			if (milisecondsField.indexOf(this.options.unfilledCharsPrompt) !== -1) {
    				regExpr = new RegExp($.ig.util.escapeRegExp(this.options.unfilledCharsPrompt), 'g');
    				milisecondsField = milisecondsField.replace(regExpr, "");
    			}
    			if (milisecondsField !== "") {
    				if (milisecondsField.length < this._dateIndices.ffLength) {
    					ffCount = this._dateIndices.ffLength - milisecondsField.length;
    					//If the user has entered 1 in 3 digit field - the value is converted into 300
    					milisecondsField = parseInt(milisecondsField) * Math.pow(10, ffCount);
    				} 
    				milisecondsField = parseInt(milisecondsField);
    				if (this._dateIndices.ffLength === 2) {
    					milisecondsField *= 10;
    				} else if (this._dateIndices.ffLength === 1) {
    					milisecondsField *= 100;
					}
    			} else {
    				milisecondsField = null;
    			}
			}

    		if (!this._dateObjectValue) {
    			//if we have year, month and day field we create date from them, else we create today date. 
    			if (yearField !== null && yearField !== undefined
					 && monthField !== null && monthField !== undefined
					 && dateField !== null && dateField !== undefined) {
    				if (this.options.enableUTCDates) {
    					extractedDate = new Date(Date.UTC(yearField, monthField, dateField));
    				} else {
    					extractedDate = new Date(yearField, monthField, dateField);
					}
    			} else {
    				if (this.options.enableUTCDates) {
    					extractedDate = new Date(Date.UTC());
    				} else {
						extractedDate = new Date();
    				}
    				if (yearField !== null && yearField !== undefined) {
    					extractedDate = this._setDateField("year", extractedDate, yearField);
    				}
    				if (monthField !== null && monthField !== undefined) {
    					extractedDate = this._setDateField("month", extractedDate, monthField);
    				}
    				if (dateField !== null && dateField !== undefined) {
    					lastDayOfMonth = this._lastDayOfMonth(this._getDateField("year", extractedDate), this._getDateField("month", extractedDate) + 1);
    					if (dateField > lastDayOfMonth) {
    						dateField = lastDayOfMonth;
						}
    					extractedDate = this._setDateField("date", extractedDate, dateField);
					}
				}
    		} else {
    			//extractedDate = this._dateObjectValue;
    			extractedDate = new Date(this._dateObjectValue);
    		}
    		if (yearField !== null && yearField !== undefined) {
    			extractedDate = this._setDateField("year", extractedDate, yearField);
    		}
    		if (monthField !== null && monthField !== undefined) {
    			extractedDate = this._setDateField("month", extractedDate, monthField);
    		}
    		if (dateField !== null && dateField !== undefined) {
    			lastDayOfMonth = this._lastDayOfMonth(this._getDateField("year", extractedDate), this._getDateField("month", extractedDate) + 1);
    			if (dateField > lastDayOfMonth) {
    				dateField = lastDayOfMonth;
    			}
    			extractedDate = this._setDateField("date", extractedDate, dateField);
    		}
    		if (hourField !== null && hourField !== undefined) {
    			extractedDate = this._setDateField("hours", extractedDate, hourField);
    		}
    		if (minutesField !== null && minutesField !== undefined) {
    			extractedDate = this._setDateField("minutes", extractedDate, minutesField);
			}
    		if (secondsField !== null && secondsField !== undefined) {
    			extractedDate = this._setDateField("seconds", extractedDate, secondsField);
    		}
    		if (milisecondsField !== null && milisecondsField !== undefined) {
    			extractedDate = this._setDateField("miliseconds", extractedDate, milisecondsField);
    		}

    		return extractedDate;

    	},
    	_getDisplayValue: function () { //igDateEditor
    		var maskVal, dateObject = this._dateObjectValue;

    	    if (!dateObject) {
    	        return "";
    	    }

    		maskVal = this.options.dateDisplayFormat;
    		maskVal = maskVal.replace(/\x08/g, ' ').replace(/\x09/g, ' ');
    		maskVal = maskVal.replace(/\\f/g, '\x01').replace(/\\d/g, '\x02').replace(/\\s/g, '\x03').replace(/\\m/g, '\x04').replace(/\\t/g, '\x05').replace(/\\H/g, '\x06').replace(/\\h/g, '\x07').replace(/\\M/g, '\x08').replace(/\\y/g, '\x09');
    		// 01-y,02-yy,03-yyyy,04-M,05-MM,06-MMM,07-MMMM,08-d,09-dd
    		// 10-h,11-hh,12-H,13-HH,14-t,15-tt,16-m,17-mm,18-s,19-ss
    		// 20-ddd,21-dddd,22-f,23-ff,24-fff
    		//Temporary remove 0 and 9, as they are valid mask flags 
    		//maskVal = maskVal.replace(/9/g, "\x11").replace(/0/g, "\x12");

    		//Mark all flags as hexadecimal 
    		maskVal = maskVal.replace(/fff/g, '\x10030')
				.replace(/ff/g, '\x10031')
				.replace(/f/g, '\x10032');

    		maskVal = maskVal.replace(/dddd/g, '\x10033')
				.replace(/ddd/g, '\x10034')
				.replace(/dd/g, '\x10035')
				.replace(/d/g, '\x10036')
				.replace(/ss/g, '\x10037')
				.replace(/s/g, '\x10038')
				.replace(/mm/g, '\x10039')
				.replace(/m/g, '\x10040');
    		maskVal = maskVal.replace(/tt/g, '\x10041')
				.replace(/t/g, '\x10042')
				.replace(/HH/g, '\x10043')
				.replace(/H/g, '\x10044')
				.replace(/hh/g, '\x10045')
				.replace(/h/g, '\x10046');
    		maskVal = maskVal.replace(/MMMM/g, '\x10047')
				.replace(/MMM/g, '\x10048')
				.replace(/MM/g, '\x10049')
				.replace(/M/g, '\x10050');
    		maskVal = maskVal.replace(/yyyy/g, '\x10051')
				.replace(/yy/g, '\x10052')
				.replace(/y/g, '\x10053');



    		maskVal = maskVal.replace(/\x10030/g, this._getMiliseconds(this._getDateField("miliseconds", dateObject), 1))
				.replace(/\x10031/g, this._getMiliseconds(this._getDateField("miliseconds", dateObject), 10))
				.replace(/\x10032/g, this._getMiliseconds(this._getDateField("miliseconds", dateObject), 100));

    		maskVal = maskVal.replace(/\x10033/g, this._getDay(this._getDateField("day", dateObject), 'dddd'))
				.replace(/\x10034/g, this._getDay(this._getDateField("day", dateObject), 'ddd'))
				.replace(/\x10035/g, this._getDate(this._getDateField("date", dateObject), 'dd'))
				.replace(/\x10036/g, this._getDate(this._getDateField("date", dateObject), 'd'))
				.replace(/\x10037/g, this._getSeconds(this._getDateField("seconds", dateObject), 'ss'))
				.replace(/\x10038/g, this._getSeconds(this._getDateField("seconds", dateObject), 's'))
				.replace(/\x10039/g, this._getMinutes(this._getDateField("minutes", dateObject), 'mm'))
				.replace(/\x10040/g, this._getMinutes(this._getDateField("minutes", dateObject), 'm'))
				//
				.replace(/\x10041/g, this._getAMorPM(this._getDateField("hours", dateObject), 'tt'))
				.replace(/\x10042/g, this._getAMorPM(this._getDateField("hours", dateObject), 't'))
				.replace(/\x10043/g, this._getHours(this._getDateField("hours", dateObject), 'HH'))
				.replace(/\x10044/g, this._getHours(this._getDateField("hours", dateObject), 'H'))
				.replace(/\x10045/g, this._getHours(this._getDateField("hours", dateObject), 'hh'))
				.replace(/\x10046/g, this._getHours(this._getDateField("hours", dateObject), 'h'));

    		maskVal = maskVal.replace(/\x10047/g, this._getMonth(this._getDateField("month", dateObject), 'MMMM'))
				.replace(/\x10048/g, this._getMonth(this._getDateField("month", dateObject), 'MMM'))
				.replace(/\x10049/g, this._getMonth(this._getDateField("month", dateObject), 'MM'))
				.replace(/\x10050/g, this._getMonth(this._getDateField("month", dateObject), 'M'));

    		maskVal = maskVal.replace(/\x10051/g, this._getYear(this._getDateField("year", dateObject), 'yyyy'))
				.replace(/\x10052/g, this._getYear(this._getDateField("year", dateObject), 'yy'))
				.replace(/\x10053/g, this._getYear(this._getDateField("year", dateObject), 'y'));


    		// restore original \\f,d,s,m,etc.
    		maskVal = maskVal.replace(/\x01/g, 'g').replace(/\x02/g, 'd').replace(/\x03/g, 's').replace(/\x04/g, 'm').replace(/\x05/g, 't').replace(/\x06/g, 'H').replace(/\x07/g, 'h').replace(/\x08/g, 'M').replace(/\x09/g, 'y');

    		return maskVal;
    	},
    	// We use flag for different mask flags f miliseconds field in thousands, ff miliseconds field in tenths, fff miliseconds field in hundreds
    	_getMiliseconds: function(miliseconds, flag) {
			return parseInt(miliseconds / flag);
    	},
		//flag values are dddd, ddd, dd, d - according to the 
    	_getSeconds: function (seconds, flag) {
    		var result;
    		if (flag === "ss" && seconds < 10) {
    			result =  "0" + seconds.toString();
    		} else {
    			result = seconds.toString();
	   		}
	   		return result;
    	},
    	_getMinutes : function (minutes, flag) {
    		var result;
    		if (flag === "mm" && minutes < 10) {
    			result = "0" + minutes.toString();
    		} else {
    			result = minutes.toString();
    		}
    		return result;
    	},
		//Get before midday, or after middday
    	_getAMorPM: function (hours, flag) {
    		var result;
    		if (hours >= 12) {
    			//pm
    			result = this._getRegionalOption("pm");
    		} else {
    			result = this._getRegionalOption("am");
    		}
    		if (flag === "t") {
    			result = result.charAt(0);
    		}
    		return result;
    	},
    	_getHours: function (hours, flag) {
    		var result;
    		switch (flag) {
    			case "h": {
    				if (hours > 12) {
    					hours -= 12;
    				}
    				result = hours.toString();
    			}
    				break;
    			case "hh": {
    				if (hours > 12) {
    					hours -= 12;
    				}
    				if (hours < 10) {
    					result = "0" + hours.toString();
    				} else {
    					result = hours.toString();
    				}
    			}
    				break;
    			case "H": {
    				result = hours.toString();
    			}
    				break;
    			case "HH": {
    				if (hours < 10) {
    					result = "0" + hours.toString();
    				} else {
    					result = hours.toString();
    				}
    			}
    				break;

    		}
    		return result;
    	},
    	_getDate: function (date, flag) {
    		var result;
    		switch (flag) {
    			case "dd": {
    				if (date < 10) {
    					result = "0" + date.toString();
    				} else {
    					result = date;
    				}
    			}
    				break;
    			case "d": {
    				result = date.toString();
    			}
    				break;
    		}
    		return result;
    	},
    	_getDay: function (day, flag) {
    		var result;
    		switch (flag) {
    			case "dddd": {
    				result = this._getRegionalOption("dayNames")[day];
    			}
    				break;
    			case "ddd": {
    				result = this._getRegionalOption("dayNamesShort")[day];
    			}
    				break;
    			
    		}
    		return result;
    	},
    	_getMonth: function (month, flag) {
    		var result;
    		switch (flag) {
    			case "MMMM": {
    				result = this._getRegionalOption("monthNames")[month];
    			}
    				break;
    			case "MMM": {
    				result = this._getRegionalOption("monthNamesShort")[month];
    			}
    				break;
    			case "MM": {
    				month++;
    				if (month < 10) {
    					result = "0" + month.toString();
    				} else {
    					result = month;
    				}
    			}
    				break;
    			case "M": {
    				month++;
    				result = month.toString();
    			}
    				break;
    		}
    		return result;
    	},
    	_getYear: function (year, flag) {
    		var result;
    		if (flag === "yy") {
    			result = year.toString().substring(2);
    		} else if (flag === "y") {
    			result = parseInt(year.toString().substring(2)).toString();
    		} else {
    			result = year.toString();
    		}
    		return result;

    	},
    	_handleBackSpaceKey: function () { //igDateEditor
    		var cursorPosition;
    		this._super();
    		cursorPosition = this._getSelection(this._editorInput[0]).start;
    		if (cursorPosition === this._dateIndices.tt || (cursorPosition - 1) === this._dateIndices.tt) {
    			if (this._dateIndices._ttLength === 2) {
    				if (cursorPosition === this._dateIndices.tt) {
    					this._setCursorPosition(cursorPosition + 1);
    					$.ui.igMaskEditor.prototype._handleDeleteKey.call(this);
    					this._setCursorPosition(cursorPosition);
    				} else {
    					this._super();
    				}
    			}
    		}
    	},
    	_handleDeleteKey: function (skipCursorPosition) { //igDateEditor
    		var cursorPosition;
    		this._super(skipCursorPosition);
    		cursorPosition = this._getSelection(this._editorInput[0]).start;
    		if ((cursorPosition - 2) === this._dateIndices.tt || (cursorPosition - 1) === this._dateIndices.tt) {
    			if (this._dateIndices._ttLength === 2) {
    				if ((cursorPosition - 1) === this._dateIndices.tt) {
    					this._super();
    				} else {
    					if (!skipCursorPosition) {
    						this._setCursorPosition(cursorPosition - 1);
    					}
    					$.ui.igMaskEditor.prototype._handleBackSpaceKey.call(this);
    					if (!skipCursorPosition) {
    						this._setCursorPosition(cursorPosition);
    					}
    				}
    			}
    		}
    	},
    	_setMillisecondsEditMode: function (mask, time, currentMilliseconds, delta) {
    		var isLimited = this.options.limitSpinToCurrentField, newMilliseconds, secondsUpdateDelta = 0, currentSecond, timeSecond;
    		if (currentMilliseconds + delta >= 60) {
    			if (isLimited) {
    				newMilliseconds = currentMilliseconds;
    			} else {
    				newMilliseconds = (currentMilliseconds + delta) - 60;
    				secondsUpdateDelta = 1;
    			}
    		} else if (currentMilliseconds + delta < 1) {
    			if (isLimited) {
    				newMilliseconds = currentMilliseconds;
    			} else {
    				if (currentMilliseconds + delta === 0) {
    					newMilliseconds = 0;
    				} else {
    					newMilliseconds = 60 + (currentMilliseconds + delta);
    					secondsUpdateDelta = -1;
    				}
    			}
    		} else {
    			newMilliseconds = currentMilliseconds + delta;
    		}
    		mask = this._setTimeEditMode(mask, time, currentMilliseconds, newMilliseconds);
    		if (secondsUpdateDelta !== undefined && secondsUpdateDelta !== 0) {
    			timeSecond = this._createSecondsPosition();
    			currentSecond = parseInt(this._getStringRange(mask, timeSecond.startPosition, timeSecond.endPosition), 10);
    			mask = this._setSecondsEditMode(mask, timeSecond, currentSecond, secondsUpdateDelta);
    		}
    		return mask;
    	},
    	_setSecondsEditMode: function (mask, time, currentSecond, delta) {
    		var isLimited = this.options.limitSpinToCurrentField, newSecond, minuteUpdateDelta = 0, currentMinute, timeMinute;
    		if (currentSecond + delta >= 60) {
    			if (isLimited) {
    				newSecond = currentSecond;
    			} else {
    				newSecond = (currentSecond + delta) - 60;
    				minuteUpdateDelta = 1;
    			}
    		} else if (currentSecond + delta < 1) {
    			if (isLimited) {
    				newSecond = currentSecond;
    			} else {
    				if (currentSecond + delta === 0) {
    					newSecond = 0;
    				} else {
    					newSecond = 60 + (currentSecond + delta);
    					minuteUpdateDelta = -1;
    				}
    			}
    		} else {
    			newSecond = currentSecond + delta;
    		}
    		mask = this._setTimeEditMode(mask, time, currentSecond, newSecond);
    		if (minuteUpdateDelta !== undefined && minuteUpdateDelta !== 0) {
    			timeMinute = this._createMinutesPosition();
    			currentMinute = parseInt(this._getStringRange(mask, timeMinute.startPosition, timeMinute.endPosition), 10);
    			mask = this._setMinutesEditMode(mask, timeMinute, currentMinute, minuteUpdateDelta);
    		}
    		return mask;
    	},
    	_setMinutesEditMode: function (mask, time, currentMinute, delta) {
    		var isLimited = this.options.limitSpinToCurrentField, newMinute, hourUpdateDelta = 0, currentHour, timeHour;
    		if (currentMinute + delta >= 60) {
    			if (isLimited) {
    				newMinute = currentMinute;
    			} else {
    				newMinute = (currentMinute + delta) - 60;
    				hourUpdateDelta = 1;
    			}
    		} else if (currentMinute + delta < 1) {
    			if (isLimited) {
    				newMinute = currentMinute;
    			} else {
    				if (currentMinute + delta === 0) {
    					newMinute = 0;
    				} else {
    					newMinute = 60 + (currentMinute + delta);
    					hourUpdateDelta = -1;
    				}
    			}
    		} else {
    			newMinute = currentMinute + delta;
    		}
    		mask = this._setTimeEditMode(mask, time, currentMinute, newMinute);
    		if (hourUpdateDelta !== undefined && hourUpdateDelta !== 0) {
    			timeHour = this._createHoursPosition();
    			currentHour = parseInt(this._getStringRange(mask, timeHour.startPosition, timeHour.endPosition), 10);
    			mask = this._setHoursEditMode(mask, timeHour, currentHour, hourUpdateDelta);
    		}
    		return mask;
    	},
    	_setHoursEditMode: function (mask, time, currentHour, delta) {
    		var isLimited = this.options.limitSpinToCurrentField, newHour, dayUpdateDelta = 0, currentDay, timeDay;
			if (currentHour + delta >= 24) {
				if (isLimited) {
					newHour = currentHour;
				} else {
					newHour = (currentHour + delta) - 24;
					dayUpdateDelta = 1;
				}
			} else if (currentHour + delta < 1) {
				if (isLimited) {
					newHour = currentHour;
				} else {
					if(currentHour + delta === 0) {
						newHour = 0;
					} else {
						newHour = 24 + (currentHour + delta);
						dayUpdateDelta = -1;
					}
				}
			} else {
				newHour = currentHour + delta;
			}
			mask = this._setTimeEditMode(mask, time, currentHour, newHour);
			if (dayUpdateDelta !== undefined && dayUpdateDelta !== 0) {
				timeDay = this._createDayPosition();
				currentDay = parseInt(this._getStringRange(mask, timeDay.startPosition, timeDay.endPosition), 10);
				mask = this._setDayEditMode(mask, timeDay, currentDay, dayUpdateDelta);
			}
			return mask;
    	},
		_setAmOrPmEditMode: function (mask, time, currentAmOrPm) {
			var newAmOrPm;
			if (currentAmOrPm.toLocaleLowerCase() === "am") {
				newAmOrPm = "PM";
			} else {
				newAmOrPm = "AM";
			}
			mask = this._setTimeEditMode(mask, time, currentAmOrPm, newAmOrPm);
			return mask;
    	},
    	_lastDayOfMonth: function (year, month) {
    		var day;

    		if(month === 1 || month === 3 || month === 5 || month === 7 || month === 8 || month === 10 || month === 12) {
    			day = 31;
    		} else if(month === 4 || month === 6 || month === 9 || month === 11) {
    			day = 30;
    		} else if(month === 2 && year % 4 === 0) {
    			day = 29;
    		} else if(month === 2 && year % 4 !== 0) {
    			day = 28;
    		}
    		return day;
    	},
    	_setDayEditMode: function (mask, time, currentDay, delta) {
    		var isLimited = this.options.limitSpinToCurrentField, currentYear, currentMonth, lastDayOfMonth, lastDayOfPreviousMonth, newDay, monthUpdateDelta, timeYear, timeMonth;

    		timeYear = this._createYearPosition();
    		currentYear = parseInt(this._getStringRange(mask, timeYear.startPosition, timeYear.endPosition), 10);
    		timeMonth = this._createMonthPosition();
    		currentMonth = parseInt(this._getStringRange(mask, timeMonth.startPosition, timeMonth.endPosition), 10);
    		lastDayOfMonth = this._lastDayOfMonth(currentYear, currentMonth);
    		lastDayOfPreviousMonth = this._lastDayOfMonth(currentYear, currentMonth - 1 !== 0 ? currentMonth - 1 : 12);

    		if (currentDay + delta > lastDayOfMonth) {
    			if (isLimited) {
    				newDay = currentDay;
    			} else {
    				newDay = (currentDay + delta) - lastDayOfMonth;
    				monthUpdateDelta = 1;
    			}
    		} else if (currentDay + delta < 1) {
    			if (isLimited) {
    				newDay = currentDay;
    			} else {
    				newDay = lastDayOfPreviousMonth + (currentDay + delta);
    				monthUpdateDelta = -1;
    			}
    		} else {
    			newDay = currentDay + delta;
    			}
    		mask = this._setTimeEditMode(mask, time, currentDay, newDay);
    		if (monthUpdateDelta !== undefined && monthUpdateDelta !== 0) {
    			mask = this._setMonthEditMode(mask, timeMonth, currentMonth, monthUpdateDelta);
    		}
			return mask;
    	},
    	_setDayDisplayMode: function(newDay) {
    		var oldDay = parseInt(this._getDateField("date"), 10),
				date = this._dateObjectValue;

    		if (!date) {
    			date = new Date();
    		}
    		if (newDay !== oldDay) {
    			this._setDateField("date", date, newDay);
    			this._triggerInternalValueChange(date);
    			this._editorInput.val(this._getDisplayValue());
    		}
    	},
    	_setMonthEditMode: function (mask, time, currentMonth, delta) {
    		var isLimited = this.options.limitSpinToCurrentField, newMonth, yearUpdateDelta = 0, currentYear, timeYear;
			if (currentMonth + delta > 12) {
				if (isLimited) {
					newMonth = currentMonth;
				} else {
					newMonth = (currentMonth + delta) - 12;
					yearUpdateDelta = 1;
				}
			} else if(currentMonth + delta < 1) {
				if (isLimited) {
					newMonth = currentMonth;
				} else {
					newMonth = 12 + (currentMonth + delta);
					yearUpdateDelta = -1;
				}
			} else {
				newMonth = currentMonth + delta;
			}
			mask = this._setTimeEditMode(mask, time, currentMonth, newMonth);
			if (yearUpdateDelta !== undefined && yearUpdateDelta !== 0) {
				timeYear = this._createYearPosition();
				currentYear = parseInt(this._getStringRange(mask, timeYear.startPosition, timeYear.endPosition), 10);
				mask = this._setYearEditMode(mask, timeYear, currentYear, yearUpdateDelta);
			}
			return mask;
		},
    	_setYearEditMode: function (mask, time, currentYear, delta) {
    		var newYear;
    		if (currentYear + delta < 0) {
    			newYear = currentYear;
    		} else {
    			newYear = currentYear + delta;
    		}
    		mask = this._setTimeEditMode(mask, time, currentYear, newYear);
    		return mask;
    	},
    	_setTimeEditMode: function (mask, time, currentValue, newValue) {
    		var newValueAsString;
    		
    		newValueAsString = newValue.toString();
    		if (newValueAsString.length === 1) {
    			newValueAsString = "0" + newValueAsString;
    		}
    		mask = this._replaceStringRange(mask, newValueAsString, time.startPosition, time.endPosition - 1);
    		
    		return mask;
    	},
    	_createYearPosition: function () {
    		var time = null;
    		if (this._dateIndices.yy !== undefined) {
    			time = {};
    			time.name = "year";
    			time.startPosition = this._dateIndices.yy;
    			time.length = this._dateIndices.fourDigitYear ? 4 : 2;
    			time.endPosition = time.startPosition + time.length;
    		}
    		return time;
    	},
    	_createMonthPosition: function () {
    		var time = null;
    		if (this._dateIndices.MM !== undefined) {
    			time = {};
    			time.name = "month";
    			time.startPosition = this._dateIndices.MM;
    			time.length = 2;
    			time.endPosition = time.startPosition + time.length;
    		}
    		return time;
    	},
    	_createDayPosition: function () {
    		var time = null;
    		if (this._dateIndices.dd !== undefined) {
    			time = {};
    			time.name = "day";
    			time.startPosition = this._dateIndices.dd;
    			time.length = 2;
    			time.endPosition = time.startPosition + time.length;
    		}
    		return time;
    	},
    	_createAmOrPmPosition: function () {
    		var time = null;
    		if (this._dateIndices.tt !== undefined) {
    			time = {};
    			time.name = "amOrPm";
    			time.startPosition = this._dateIndices.tt;
    			time.length = 2;
    			time.endPosition = time.startPosition + time.length;
    		}
    		return time;
    	},
    	_createHoursPosition: function () {
    		var time = null;
    		if (this._dateIndices.hh !== undefined) {
    			time = {};
    			time.name = "hours";
    			time.startPosition = this._dateIndices.hh;
    			time.length = 2;
    			time.endPosition = time.startPosition + time.length;
    		}
    		return time;
    	},
    	_createMinutesPosition: function () {
    		var time = null;
    		if (this._dateIndices.mm !== undefined) {
    			time = {};
    			time.name = "minutes";
    			time.startPosition = this._dateIndices.mm;
    			time.length = 2;
    			time.endPosition = time.startPosition + time.length;
    		}
    		return time;
    	},
    	_createSecondsPosition: function () {
    		var time = null;
    		if (this._dateIndices.ss !== undefined) {
    			time = {};
    			time.name = "seconds";
    			time.startPosition = this._dateIndicess.ss;
    			time.length = 2;
    			time.endPosition = time.startPosition + time.length;
    		}
    		return time;
    	},
    	_createMillisecondsPosition: function () {
    		var time = null;
    		if (this._dateIndices.ff !== undefined) {
    			time = {};
    			time.name = "milliseconds";
    			time.startPosition = this._dateIndices.ff;
    			time.length = 2;
    			time.endPosition = time.startPosition + time.length;
    		}
    		return time;
    	},
    	_getTimePosition: function () {
    		var cursorPosition = this._getCursorPosition(),
    			indices = this._dateIndices, time = null;

    		if (cursorPosition < 0) {
    			cursorPosition = 0;
    		}
    		if (cursorPosition >= indices.yy && (indices.fourDigitYear && cursorPosition <= indices.yy + 4 || indices.fourDigitYear === undefined && indices.yy + 2)) {
    			time = this._createYearPosition();
    		} else if (cursorPosition >= indices.MM && cursorPosition <= indices.MM + 2) {
    			time = this._createMonthPosition();
    		} else if (cursorPosition >= indices.dd && cursorPosition <= indices.dd + 2) {
    			time = this._createDayPosition();
    		} else if (cursorPosition >= indices.tt && cursorPosition <= indices.tt + 2) {
    			time = this._createAmOrPmPosition();
    		} else if (cursorPosition >= indices.hh && cursorPosition <= indices.hh + 2) {
    			time = this._createHoursPosition();
    		} else if (cursorPosition >= indices.mm && cursorPosition <= indices.mm + 2) {
    			time = this._createMinutesPosition();
    		} else if (cursorPosition >= indices.ss && cursorPosition <= indices.ss + 2) {
    			time = this._createSecondsPosition();
    		} else if (cursorPosition >= indices.ff && cursorPosition <= indices.ff + 2) {
    			time = this._createMillisecondsPosition();
    		}
    		return time;
    	},
    	_updateTimeMask: function (mask, time, delta) {
    		var currentValue;

    		currentValue = parseInt(this._getStringRange(mask, time.startPosition, time.endPosition), 10);
    		switch (time.name) {
    			case "year":
    				mask = this._setYearEditMode(mask, time, currentValue, delta);
    				break;
    			case "month":
    				mask = this._setMonthEditMode(mask, time, currentValue, delta);
    				break;
    			case "day":
    				mask = this._setDayEditMode(mask, time, currentValue, delta);
    				break;
    			case "amOrPm":
    				currentValue = this._getStringRange(mask, time.startPosition, time.endPosition);
    				mask = this._setAmOrPmEditMode(mask, time, currentValue);
    				break;
    			case "hours":
    				mask = this._setHoursEditMode(mask, time, currentValue, delta);
    				break;
    			case "minutes":
    				mask = this._setMinutesEditMode(mask, time, currentValue, delta);
    				break;
    			case "seconds":
    				mask = this._setSecondsEditMode(mask, time, currentValue, delta);
    				break;
    			case "milliseconds":
    				mask = this._setMillisecondsEditMode(mask, time, currentValue, delta);
    				break;
    		}
    		return mask;
    	},
    	_initEmptyMask: function () {
    		var mask = this._maskWithPrompts,
    			today = new Date(),
    			timeYear, timeMonth, timeDay, timeHours,
    			timeAmOrPM, timeMinutes, timeSeconds, timeMilliseconds,
    			year, month, day;

    		timeYear = this._createYearPosition();
    		timeMonth = this._createMonthPosition();
    		timeDay = this._createDayPosition();
    		timeHours = this._createHoursPosition();
    		timeAmOrPM = this._createAmOrPmPosition;
    		timeMinutes = this._createMinutesPosition();
    		timeSeconds = this._createSecondsPosition();
    		timeMilliseconds = this._createMillisecondsPosition();

    		year = today.getFullYear();
    		month = today.getMonth() + 1;
    		day = today.getDate();

    		if (timeYear) {
    			mask = this._setYearEditMode(mask, timeYear, year, 0);
    		}
    		if (timeMonth) {
    			mask = this._setMonthEditMode(mask, timeMonth, month, 0);
    		}
    		if (timeDay) {
    			mask = this._setDayEditMode(mask, timeDay, day, 0);
    		}
    		if (timeHours) {
    			mask = this._setHoursEditMode(mask, timeHours, 0, 0);
    		}
    		if (timeAmOrPM) {
    			mask = this._setAmOrPmEditMode(mask, timeAmOrPM, "AM", 0);
    		}
    		if (timeMinutes) {
    			mask = this._setMinutesEditMode(mask, timeMinutes, 0, 0);
    		}
    		if (timeSeconds) {
    			mask = this._setSecondsEditMode(mask, timeSeconds, 0, 0);
    		}
    		if (timeMilliseconds) {
    			mask = this._setMillisecondsEditMode(mask, timeMilliseconds, 0, 0);
    		}
    		return mask;
    	},
    	_spinEditMode: function (delta) {
    		var self = this, cursorPosition = this._getCursorPosition(),
				mask = this._editorInput.val(), time;

    		time = this._getTimePosition();
    		if (!time) {
    			// If the cursor position is not available for some reason, we do not spin.
    			return;
    		}

    		if (mask === undefined) {
    			return;
    		} else if (mask === "" || mask === this._maskWithPrompts) {
    			mask = this._initEmptyMask();
    		} else {
    			mask = this._updateTimeMask(mask, time, delta);
    		}

			this._maskedValue = mask;
			this._editorInput.val(mask);
			if ($.ig.util.isChrome || $.ig.util.isSafari) {
			// In Chrome and Safari there is a bug and the cursor needs to be set with timeout in order to work.
				this._timeouts.push(setTimeout(function () {
					self._setCursorPosition(cursorPosition);
				}, 0));
			} else {
				self._setCursorPosition(cursorPosition);
			}
    	},
    	_spinUpEditMode: function (delta) {
    		this._spinEditMode(delta ? delta : this.options.spinDelta);
    	},
    	_spinDownEditMode: function (delta) {
    		this._spinEditMode(delta ? -delta : -this.options.spinDelta);
    	},
    	_spin: function (delta) {
    		var day;
    		this._currentInputTextValue = this._editorInput.val();
    		if (this._editMode) {
    			this._spinEditMode(delta);
    		} else {
    			day = this._getDateField("date");
    			if (day === null) {
    				// When there is no date we want to set today and should not increase the day.
    				day = this._getDateField("date", new Date());
    				delta = 0;
    			}
    			this._setDayDisplayMode(day + delta);
    		}
    		this._processTextChanged();
    	},
		value: function (newValue) { // Date Editor
			if (newValue !== undefined) {
				if (this._validateValue(newValue)) {
					this._updateValue(newValue);
					//TODO Update maskedValue according to the new value. 
					this._updateMaskedValue();
				}
				this._editorInput.val(this._editMode ? this._maskedValue : this._getDisplayValue());
			} else {
				if (this.options.value instanceof Date) {
					return new Date(this.options.value.getTime());
				} else if (this._maskedValue !== "" && this._maskedValue !== this._parseValueByMask("")) {
					if (this.options.dataMode === "date") {
						return new Date(this._maskedValue);
					} else if (this.options.dataMode === "editModeText") {
						return this._maskedValue;
					} else if (this.options.dataMode === "displayModeText") {
						return this._getDisplayValue();
					}
				} else {
					if (this.options.allowNullValue) {
						return this.options.nullValue;
					} else {
						return "";
					}
				}
    		}
    	},
    	// igDateEditor public methods
    	getSelectedDate: function() {
    		/* Gets selected date.
    			returnType="date" */
    		return this._dateObjectValue;
    	},
    	selectDate: function (date) {
    		/* Sets selected date.
				paramType="date" optional="false" */
    		this._updateValue(date);
    		this._exitEditMode();
    	},
    	spinUp: function (delta) {
    		/* Increase date-time period, depending on the cursor position. */
    		this._spin(delta? delta: this.options.spinDelta);
    	},
    	spinDown: function (delta) {
    		/* Decrease date-time period, depending on the cursor position. */
    		this._spin(delta? -delta:-this.options.spinDelta);
    	},
    	isValid: function () {
    		/* Checks if value in editor is valid. Note: This function will not trigger automatic notifications.
				paramType="" optional=""
				returnType="bool" Whether editor value is valid or not */
    		var value, valid;
    		value = this.field().val();
    		this._skipMessages = true;
    		valid = this._validateValue(this._dateObjectValue);
    		if (value !== "" && !valid) {
    			//Raise warning not all required fields are entered
    			//State - message
    			valid = false;
    			this._sendNotification("warning", $.ig.Editor.locale.dateMessage);
    		}
    		this._skipMessages = false;
    		return valid;
    	}
    });
    $.widget('ui.igDatePicker', $.ui.igDateEditor, {
        options: {
            /* type="object" Sets gets custom regional settings for editor. If it is string, then $.ig.regional[stringValue] is assumed. */
            regional: null,
            /* type="dropdown|clear" Sets gets visibility of clear and drop-down button. That option can be set only on initialization. Combinations like 'dropdown,clear' or 'dropdownclear' are supported too.
                dropdown type="string" button to open list is located on the right side of input-field (or left side if base html element has direction:rtl);
                clear type="string" button to clear value is located on the right side of input-field (or left side if base html element has direction:rtl);
            */
            buttonType: 'dropdown',
            /* type="object" Sets gets options supported by the jquery.ui.datepicker. Only options related to drop-down calendar are supported. */
            datepickerOptions: null
        },
        events: {

        },
        _setDropDownListWidth: function () { // igDatePicker
        },
		_renderList: function () { // igDatePicker
            var self = this, options, regional;
            regional = $.extend(self.options.datepickerOptions, self._dpRegion()) || {};
            options = $.extend(regional, {
                showOn: '',
                duration: self.options.dropDownAnimationDuration ? self.options.dropDownAnimationDuration : "normal",
                onClose: function (val) {
                	var date;
                	self._currentInputTextValue = self._editorInput.val();
                	date = new Date(val);
                	if (self.options.enableUTCDates) {
                		date = new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate()));
                	}
                	self._processValueChanging(date);

                	self._processTextChanged();
                	self._editorInput.focus();
                }
            });
            this._editorInput.datepicker(options);
            this._dropDownList = this._editorInput.datepicker("widget");
            this._dropDownList.hide();
       },
		_renderDropDownButton: function () {
           var dropDownButton = $("<div></div>"), dropDownIcon = $("<div></div>");
           if (this._dropDownButton) {
               return;
           }
           dropDownButton.addClass(this.css.buttonCommon);
           dropDownButton.attr("title", this._getLocaleOption("datePickerButtonTitle"));
           this._editorContainer.prepend(dropDownButton.addClass(this.css.dropDownButton).append(dropDownIcon.addClass(this.css.dropDownImage)));
           this._dropDownButton = dropDownButton;
           this._attachButtonsEvents("dropdown", dropDownButton);
       },
        _dpRegion: function () {
        	var reg = this.options.regional, lastRegional, regional;
        	regional = ($.datepicker && typeof reg === 'string') ? $.datepicker.regional[(reg === 'defaults' || reg === 'en-US') ? '' : reg] : null;
        	if (regional === null && $.datepicker) {
        		for (lastRegional in $.datepicker.regional) { }
        		if($.datepicker.regional[lastRegional]){
        			regional = $.datepicker.regional[lastRegional];
        		}
        	}
        	return regional;
			// TODO refactor that function later
        },
        _create: function () { // igDatePicker
            $.ui.igDateEditor.prototype._create.call(this);
        },
        _initialize: function () { //igDatePicker
        	this._super();

        	//We set this option internally so we can call the _renderList method.
        	this.options.listItems = ["datePicker"];
        },
        _applyOptions: function () { //DatePicker
            this._super();
           
            if (!this.options.minValue && this.options.datepickerOptions && this.options.datepickerOptions.minDate) {
                if (this._isValidDate(this.options.datepickerOptions.minDate)) {
                    this.options.minValue = this.options.datepickerOptions.minDate;
                }
            }
            if (!this.options.maxValue && this.options.datepickerOptions && this.options.datepickerOptions.maxDate) {
                if (this._isValidDate(this.options.datepickerOptions.minDate)) {
                    this.options.maxValue = this.options.datepickerOptions.maxDate;
                }
            }
        },
        _setOption: function (option, value) { // igDatePicker
            /* igPercentEditor custom setOption goes here */
            var prevValue = this.options[option];
            if (prevValue === value) {
                return;
            }
            // The following line applies the option value to the igWidget meaning you don't
            // have to perform this.options[option] = value;
            $.Widget.prototype._setOption.apply(this, arguments);
            switch (option) {
                case "buttonType": {
                    if (value !== "dropdown") {
                        this.options[option] = prevValue;
                        throw new Error($.ig.Editor.locale.buttonTypeIsDropDownOnly);
                    }
                }
                    break;
                default: {
                    //In case no propery matches, we call the super. Into the base widget default statement breaks
                    this.options[option] = prevValue;
                    this._super(option, value);
                }
                    break;
            }
        },
        _triggerKeyDown: function (event) { //igDatePicker
        	// If we press arrow down/up, without alt, we don't want drop down to appear/disappear.
        	// If we press arrow down/up, with ctrl, we want to navigate in the calendar, instead of increasing the time, where the cursor is positioned.
        	if (event.keyCode === 38 && !event.altKey) {
        		if (!event.ctrlKey) {
        			this._spinUpEditMode();
        		}
        	} else if (event.keyCode === 40 && !event.altKey) {
        		if (!event.ctrlKey) {
        			this._spinDownEditMode();
        		}
        	} else {
        		this._super(event);
        	}
        },
        _triggerDropDownOpened: function () {
        	var args = {
        		owner: this,
        		editorInput: this._editorInput,
        		calendar: this._dropDownList
        	};
        	this._trigger(this.events.dropDownListOpened, null, args);
        },
        _triggerDropDownOpeninng: function () {
        	var args = {
        		owner: this,
        		editorInput: this._editorInput,
        		calendar: this._dropDownList
        	};
        	return this._trigger(this.events.dropDownListOpening, null, args);
        },
        _showDropDownList: function () { //DatePicker
            //Open Dropdown 
        	var self = this, direction;
            this._cancelBlurDatePickerOpen = true;
            this._positionDropDownList();
            if (this._dropDownListOrientation === "up") {
                //We need this parameter as part of blind animation we're using
                direction = "up";
            } else {
                direction = "down";
            }
            if (this.value()) {
                $(this._editorInput).datepicker("setDate", this.value());
            }
            try {
                this._editorInput.datepicker("option", "showOptions", { direction: direction });
                //$(this._dropDownList).show('blind', { direction: direction }, this.options.dropDownAnimationDuration);
                this._editorInput.datepicker("show");
            } catch (ex) {
                //$(this._dropDownList).show(this.options.dropDownAnimationDuration);
            	this._editorInput.datepicker("show");
            }
            // We cannot trigger drop down opened callback, using the datepicker widget API.
            // That's why we use promise and wait all the animations applied to the drop down list and then trigger the event.
            this._dropDownList.promise().done(function () {
            	self._triggerDropDownOpened();
            });
        },      
      
    	// igDatePicker public methods
        getCalendar: function () {
        	/* Returns a reference to the jQuery calendar used as a picker selector 
			returnType="$" Returns reference to jquery object. */
			$.ui.igTextEditor.prototype.dropDownContainer.call(this);
        },
    	dropDownContainer: function () {
    		throw ($.ig.Editor.locale.datePickerNoSuchMethodDropDownContainer);
    	},
    	showDropDown: function () {
    		/* Shows the drop down list. */
    		$.ui.igTextEditor.prototype.showDropDown.call(this);
    	},
    	hideDropDown: function () {
    		/* Hides the drop down list. */
    		$.ui.igTextEditor.prototype.hideDropDown.call(this);
    	},
    	dropDownButton: function () {
    		/* Returns a reference to the clear button UI element of the editor.
    			returnType="$" Returns reference to jquery object. */
    		$.ui.igTextEditor.prototype.dropDownButton.call(this);
    	},
    	dropDownVisible: function () {
    		/* Returns the visibility state of the drop down listing the items.
    			returnType="bool" The visibility state of the drop down. */
    		$.ui.igTextEditor.prototype.dropDownVisible.call(this);
    	}
    });
    $.widget('ui.igCheckboxEditor', $.ui.igBaseEditor, {
    	options: {
    		/* type="number" Gets sets either the editor is checked or not. */
    		checked: false,
    		/* type="verysmall|small|normal|large" Gets sets size of the checkbox based on preset styles. 
				For different sizes, define 'width' and 'height' options instead.
				verysmall The size of the Checkbox editor is very small.
				small The size of the Checkbox editor is small.
				normal The size of the Checkbox editor is normal.
				large The size of the Checkbox editor is large.
			*/
    		size: "normal",
    		/* type="string" Applies custom class on the checkbox, so that custom image can be used.
				The following jQuery classes can be used in addition http://api.jqueryui.com/theming/icons/
			*/
    		iconClass: "ui-icon-check",
    		/* type="number" Gets sets value in tabIndex for Checkbox Editor.  */
    		tabIndex: 0
    	},
    	css: {
    		/* Classes applied to the top element when editor is rendered in container. Default value is 'ui-state-default ui-corner-all ui-widget ui-checkbox-container ui-igcheckbox-normal' */
    		container: "ui-state-default ui-corner-all ui-widget ui-checkbox-container ui-igcheckbox-normal",
    		/* Class applied to the top element when editor is checked. Default value is 'ui-state-checkbox-checked' */
    		containerChecked: "ui-state-checkbox-checked",
    		/* Class applied to the checkbox element when that holds the styles for the checkbox icon. Default value is 'ui-icon' */
    		checkboxIcon: "ui-icon",
    		/* Class applied to the checkbox element that there is custom width and height, in order to have the image centered. Default value is 'ui-icon-custom' */
    		iconCentered: "ui-icon-custom",
    		/* Class applied to the checkbox element when it is checked. Default value is 'ui-igcheckbox-normal-on' */
    		checked: "ui-igcheckbox-normal-on",
    		/* Class applied to the checkbox element when it is unchecked. Default value is 'ui-igcheckbox-normal-off' */
    		unchecked: "ui-igcheckbox-normal-off",
    		/* Class applied to the hidden HTML checkbox input when. Default value is 'ui-helper-hidden' */
    		checkboxInput: "ui-helper-hidden"
    	},
    	events: {
    	    /* cancel="true" Event which is raised on keydown event.
				Return false in order to cancel key action.
				Function takes arguments evt and ui.
				Use evt.originalEvent to obtain reference to event of browser.
				Use ui.owner to obtain reference to igEditor.
				Use ui.key to obtain value of keyCode. */
    	    keydown: "keydown",
    	    /* cancel="true" Event which is raised on keypress event.
				Return false in order to cancel key action.
				Function takes arguments evt and ui.
				Use evt.originalEvent to obtain reference to event of browser.
				Use ui.owner to obtain reference to igEditor.
				Use ui.key to obtain value of keyCode.
				Set ui.key to another character which will replace original entry. */
    	    keypress: "keypress",
    	    /* Event which is raised on keyup event.
				Function takes arguments evt and ui.
				Use evt.originalEvent to obtain reference to event of browser.
				Use ui.owner to obtain reference to igEditor.
				Use ui.key to obtain value of keyCode. */
    	    keyup: "keyup"
    	},
    	_triggerKeyUp: function (event) {
    	    var args = {
    	        originalEvent: event,
    	        owner: this,
    	        element: event.target,
    	        editorInput: this._editorInput
    	    };
    	    this._trigger(this.events.keyup, event, args);
    	},
    	_triggerKeyPress: function (event) {
    	    var args = {
    	        originalEvent: event,
    	        owner: this,
    	        element: event.target,
    	        editorInput: this._editorInput
    	    };
    	    this._trigger(this.events.keypress, event, args);
    	},
    	_triggerKeyDown: function (event) {
    	    var args = {
    	        originalEvent: event,
    	        owner: this,
    	        element: event.target,
    	        editorInput: this._editorInput
    	    };
    	    this._trigger(this.events.keydown, event, args);
    	},
    	_create: function () {
    		this._checkedClass = this.css.checked;
    		this._uncheckedClass = this.css.unchecked;
    		$.ui.igBaseEditor.prototype._create.call(this);
    	},
    	_render: function () {
    		this._triggerRendering();

    		if (this.element.is("div")) {
    			this._editorContainer = this.element;
    			this._editorInput = $("<span></span>");
    			this._valueInput = $("<input type='checkbox'></input>");
    			this._editorContainer.prepend(this._editorInput);
    			this._editorInput.after(this._valueInput);
    		} else if (this.element.is("input")) {
    			this._valueInput = this.element;
    			this._editorInput = $("<span></span>");
    			this._editorContainer = this.element.wrap($("<div></div>")).parent();
    			this._valueInput.before(this._editorInput);
    		} else if (this.element.is("span")) {
    			this._editorInput = this.element;
    			this._valueInput = $("<input type='checkbox'></input>");
    			this._editorContainer = this.element.wrap($("<div></div>")).parent();
    			this._editorInput.after(this._valueInput);
    		}
    		else {
    		    throw ($.ig.Editor.locale.instantiateCheckBoxErrMsg);
    		}

    		this._editorContainer
                .addClass(this.css.container)
    	        .attr("role", "checkbox");
    		this._editorInput.
				addClass(this.css.checkboxIcon).
				addClass(this.options.iconClass).
				addClass(this.css.checked);
    		this._valueInput
                .addClass(this.css.checkboxInput)
    	        .attr("aria-hidden", "true");
    		
    		if (!$.ig.util.isIE8 && this._valueInput.attr("type") !== "checkbox") {
    			this._valueInput.attr("type", "checkbox");
    		}

    		this._attachEvents();
    		this._applyOptions();
    		this._applyAria();

    		this._triggerRendered();
    	},
    	_applyAria: function () {
    		var ariaLabeledBy = this.element.attr("aria-labelledby");

    		if (ariaLabeledBy) {
    			this.element.removeAttr("aria-labelledby");
    			this._editorContainer.attr("aria-labelledby", ariaLabeledBy);
    		}
    	},
    	_applyOptions: function () {
    		var checked = this.options.checked;
    		this._super();

    		if (checked) {
    			this._initialState();
    		} else {
    			this.options.checked = false;
    		}
    		if (this.options.value) {
    		    this._inputValue = this.options.value;
    			this.value(this.options.value);
    		}
    		this._size(this.options.size);
    		this._setWidth(this.options.width);
    		this._setHeight(this.options.height);
    		this._updateState(checked && checked !== "false" ? true : false);
    	},
    	_setOption: function (option, value) {
    		var iconClass = this.options.iconClass;
			
    		this._super(option, value);
    		switch (option) {
    			case "checked":
    			    this._updateState(value && value !== "false" ? true : false);
    			    break;
    		    case "value":
    		        this._inputValue = value;
    		        this._updateState(this.options.checked);
    		        break;
    			case "size":
    				this._size(value);
    				break;
    			case "iconClass":
    				this._setIconClass(iconClass, value);
    				break;
    			default:
    				break;
    		}

    	},
    	_readAttributes: function () {
    		var checked = this.element.attr("checked");

    		this._super(this.element);

    		if (checked) {
    			this.element.removeAttr("checked");
    			this.options.checked = true;
    		}
    	},
    	_attachEvents: function () {
    		var self = this;
    		this._super();
    		this._editorContainer.on({
    			"click.editor": function (event) {
    			    self._toggleInternal(event);
    			},
    		    "mousedown.editor": function (event) {
                    /* Prevent multi-click text selection, but keep focus */
    		        this.focus();
    		        event.preventDefault();
    		        return false;
    			},
    			"focus.editor": function (event) {
    				self._setFocus(event, self._cancelFocusTrigger);
    			},
    			"blur.editor": function (event) {
    				self._setBlur(event);
    		    },
    			"keyup.editor": function (event) {
    				var keyCode = event.keyCode || event.which || 0; /*space*/
    			    self._triggerKeyUp(event);
    			    if (keyCode === 32) {
    			        self._toggleInternal(event);
    			        event.preventDefault();
    			    }
    			},
    			"keydown.editor": function (event) {
    				self._triggerKeyDown(event);
    			},
    			"keypress.editor": function (event) {
    				var keyCode = event.keyCode || event.which || 0;
    				self._triggerKeyPress(event);
    				if (keyCode === 32) {
    					event.preventDefault();
    				}
    			}
    		});
    	},
    	_triggerValueChanging: function (event, newState, newValue) {
    		var args = {
    			owner: this,
    			element: event.target,
    			editorInput: this._editorInput,
    			oldState: this.options.checked,
    			newState: newState,
    			oldValue: this.value(),
    			newValue: newValue
    		};
    		return this._trigger(this.events.valueChanging, event, args);
    	},
    	_triggerValueChanged: function (event) {
    		var args = {
    			owner: this,
    			element: event.target,
    			editorInput: this._editorInput,
    			newState: this.options.checked,
    			newValue: this.value()
    		};
    		this._trigger(this.events.valueChanged, event, args);
    		this._trigger(this.options.checked ? this.events.checked : this.events.unchecked, event, args);
    	},
    	_triggerFocus: function (event) {
    	    var args = {
    	        originalEvent: event,
    	        owner: this,
    	        element: event.target,
    	        editorInput: this._editorInput
    	    };
    	    this._trigger(this.events.focus, event, args);
    	},
    	_triggerBlur: function (event) {
    	    var args = {
    	        owner: this,
    	        element: event.target,
    	        editorInput: this._editorInput
    	    };
    	    this._trigger(this.events.blur, event, args);
    	},
    	_updateValue: function (value) {
    		this.options.value = value;
    		this._valueInput.val(value);
    	},
    	_getState: function () {
    		var state;
    		if (this._inputValue !== undefined) {
    			state = this._valueInput[0].checked;
    		} else {
    		    var value = this._tryParseBool(this._valueInput[0].value);
    		    if (value.ret) {
    		        state = value.p1;
    		    } else {
    		        throw ($.ig.Editor.locale.cannotParseNonBoolValue);
    		    }
    		}
    		
    		return state;
    	},
    	_tryParseBool: function (value) {
    	    if (typeof value === "boolean") {
                return { ret: true, p1: value };
    	    } else if (typeof value === "string") {
    	        return $.ig.Boolean.prototype.tryParse(value);
    	    }
    	},
    	_toggleInternal: function (event) {
    	    var noCancel, newState, newVal;
    	    newState = !this._getState();
    	    newVal = this.value();
    	    if (this._inputValue === undefined) {
    	        newVal = newState;
    	    }
    	    noCancel = this._triggerValueChanging(event, newState, newVal);
    	    if (noCancel) {
    	        this._updateState(newState);
    	        this._triggerValueChanged(event);
    	        if (this._validator) {// TODO VERIFY
    	            this._validator._validateInternal(this.element, event);
    	        }
    	    }
    	},
    	_initialState: function () {
    		this._valueInput.attr("checked", "checked");
    	},
    	_updateState: function (value) {
    	    this.options.checked = value;
    	    this._editorContainer.attr("aria-checked", value);

    	    if (value) {
    	    	this._editorInput.removeClass(this._uncheckedClass);
    	    	this._editorContainer.addClass(this.css.containerChecked);

    		} else {
    	    	this._editorInput.addClass(this._uncheckedClass);
    	    	this._editorContainer.removeClass(this.css.containerChecked);
    		}
    		if (this._inputValue !== undefined) {
    			this._valueInput[0].checked = value;
    			this._valueInput[0].value = this._inputValue;
    		} else {
    			this._valueInput[0].checked = true;
    			this._valueInput[0].value = value;
    		}
    	},
    	_removeDOM: function () {
    		if (this.element.is("div")) {
    			this.element.empty();
    		} else if (this.element.is("input")) {
    			this._editorInput.remove();
    			this.element.unwrap();
    		} else if (this.element.is("span")) {
    			this._valueInput.remove();
    			this.element.unwrap();
    		}
    	},
    	_detachEvents: function () {
    		this._editorContainer.off("click.editor mousedown.editor focus.editor blur.editor keydown.editor");
    		this._super();
    	},
    	_clearStyling: function () {
    		this._editorContainer
				.removeClass(this.css.checkboxContainer)
    			.removeClass(this.css.containerChecked)
    			.removeAttr("role");
    		this._editorInput
				.removeClass(this._checkedClass)
    			.removeClass(this._uncheckedClass)
    			.removeClass(this.css.checkboxIcon)
				.removeClass(this.options.iconClass);
    		this._valueInput
                .removeClass(this.css.checkboxInput)
    	        .removeAttr("aria-hidden");
    		this._super();
    	},
    	_deleteInternalProperties: function () {
    		delete this._checkedClass;
    		delete this._uncheckedClass;
    		this._super();
    	},
    	_size: function (size) {
    		if (size) {
    			this._editorContainer.removeClass("ui-igcheckbox-verysmall ui-igcheckbox-small ui-igcheckbox-normal ui-igcheckbox-large");
    			this._editorContainer.addClass("ui-igcheckbox-" + size);
    			this._editorInput.removeClass(this._checkedClass).removeClass(this._uncheckedClass);
    			this._checkedClass = "ui-igcheckbox-" + size + "-on";
    			this._uncheckedClass = "ui-igcheckbox-" + size + "-off";
    			this._editorInput.addClass(this._checkedClass);
    		}
    	},
    	_setTabIndex: function (index) {
    		this._editorContainer.attr("tabIndex", index);
    	},
    	_setWidth: function (width) {
    		this._super(width);
    		if (width) {
    			this._editorInput.addClass(this.css.iconCentered);
    		}
    	},
    	_setHeight: function (height) {
    		this._super(height);
    		if (height) {
    			this._editorInput.addClass(this.css.iconCentered);
    		}
    	},
    	_setIconClass: function (oldIconClass, iconClass) {
    		this._editorInput.removeClass(oldIconClass).addClass(iconClass);
    	},
    	_setFocus: function (event, triggerEvent) {
    		this._editorContainer.addClass(this.css.focus);
    		if (event && !triggerEvent) {
    			this._triggerFocus(event);
    		} else {
    			delete this._cancelFocusTrigger;
    		}
    	},
    	_setFocusDelay: function (delay) {
    		var self = this;
    		if (delay) {
    			this._timeouts.push(setTimeout(function () {
    				self._cancelFocusTrigger = true;
    				self._setFocus();
    			}, delay));
    		} else {
    			this._cancelFocusTrigger = true;
    			this._editorContainer.focus();
    		}
    	},
    	_setBlur: function (event) {
    		this._editorContainer.removeClass(this.css.focus);
    		this._triggerBlur(event);
    		if (this._validator) { // TODO VERIFY
    		    this._validator._validateInternal(this.element, event, true);
    		}
    	},
    	isValid: function () { // Checkbox
    	    /* Checks if value in editor is valid. Note: This function always returns true for the igCheckboxEditor
    			returnType="bool" Whether editor value is valid or not */
    	    // TODO VERIFY
    	    return true;
    	},
		// igCheckboxEditor public methods
    	value: function (newValue) {
    		/* Gets/Sets Current checked state/Value of the igCheckboxEditor that will be submitted by the HTML form.
				1. If the 'value' option IS NOT defined, then 'value' method will match the checked state of the editor.
				This is a good option when the checkbox is intended to operate as a Boolean editor.
				2. If the 'value' option IS defined, then 'value' method will return the 'value' option,
				the one that is going to be submitted by the HTML form to the server.
				To get checked state regardless of the 'value' option, use $("checkBox").igCheckboxEditor("option", "checked");
				returnType="boolean|string" Current checked state or the value of the igCheckboxEditor that will be submitted by the HTML form.
			*/
    		if (newValue !== undefined) {
    			if (this._inputValue === undefined) {
    				/*no explicit value */
    				var result = this._tryParseBool(newValue);
    				if (result.ret) {
    					this._updateState(result.p1);
    				} else {
    				    throw ($.ig.Editor.locale.cannotSetNonBoolValue);
    				}
    			} else {
    				/* update value only */
    				this.options.value = newValue;
    				this._inputValue = newValue;
    				this._updateState(this._getState());
    			}
    		} else {
    			if (this._inputValue === undefined) {
    				return this._getState();
    			}
    			return this.options.value;
    		}
    	},
    	toggle: function () {
    		/* Toggles the state of the checkbox. */
    		if (this._getState()) {
    			this._updateState(false);
    		} else {
    			this._updateState(true);
    		}
    	}
    });

}(jQuery));

/*!@license
 * Infragistics.Web.ClientUI Tree 15.2.20152.1033
 *
 * Copyright (c) 2011-2015 Infragistics Inc.
 *
 * http://www.infragistics.com/
 *
 * Depends on:
 *  jquery-1.4.4.js
 *	jquery.ui.core.js
 *	jquery.ui.widget.js
 *	jquery.ui.mouse.js
 *	jquery.ui.draggable.js
 *	jquery.ui.droppable.js
 *	infragistics.templating.js
 *	infragistics.dataSource.js
 *  infragistics.ui.shared.js
 *	infragistics.util.js
 *	infragistics.ui.tree-en.js
 */

/*global jQuery, MSApp */
if (typeof jQuery !== "function") {
	throw new Error("jQuery is undefined");
}

(function ($) {
    /*
		igTree is a widget based on jQuery UI that loads hierarchical data and visualizes it in the form of a 
		tree and providers the end user with a rich interaction functionality including the ability to expand/collapse 
		child data, node selection, checkboxes, node images, etc. The igTree supports performance optimization for large 
		data sources via load on demand. The igTree can be bound to various types of data such as JSON, XML, Remote data 
		providers, etc.
	*/
	$.widget('ui.igTree', {
		_const: {
			dragCursorAt: {
				top: -10,
				left: -10
			}
		},
		css: {
			/* classes applied to the top container element */
			tree: 'ui-widget ui-igtree',
			/* class applied to the node collection element */
			treeCollection: 'ui-igtree-collection',
			/* class applied to every node element in the tree */
			treeNode: 'ui-igtree-node',
			/* class applied to the root ul element in the tree */
			treeRoot: 'ui-igtree-root ui-widget-content',
			/* class applied to every node element that is a root node in the tree */
			treeRootNode: 'ui-igtree-noderoot',
			/* class applied nodes that have no children and thus no expander image */
			nodeNoChildren: 'ui-igtree-node-nochildren',
			/* class applied to nodes that have children */
			parentNode: 'ui-igtree-parentnode',
			/* classes defining the css sprite icon for collapsed node */
			collapseIcon: 'ui-icon ui-icon-triangle-1-s',
			/* classes defining the css sprite icon for expanded node */
			expandIcon: 'ui-icon ui-icon-triangle-1-e',
			/* classes applied to the node anchor */
			nodeAnchor: 'ui-corner-all',
			/* class applied to the expand/collapse node container */
			nodeExpander: 'ui-igtree-expander',
			/* class defining the default state style of the node */
			nodeNormal: 'ui-state-default',
			/* class defining the highlight state style of the node */
			nodeHightlight: 'ui-state-highlight',
			/* class defining the hover state style of the node */
			nodeHovered: 'ui-state-hover',
			/* class defining the selected state style of the node */
			nodeSelected: 'ui-state-active',
			/* class defining the focus state style of the node */
			nodeActive: 'ui-state-focus',
			/* classes applied to the checkbox container */
			checkbox: 'ui-state-default ui-corner-all ui-igcheckbox-normal',
			/* classes defining the unchecked state of the checkbox */
			checkboxOff: 'ui-icon ui-icon-check ui-igcheckbox-normal-off',
			/* classes defining the checked state of the checkbox */
			checkboxOn: 'ui-icon ui-icon-check ui-igcheckbox-normal-on',
			/* classes defining the partially checked state of the checkbox */
			checkboxPartial: 'ui-icon ui-icon-check ui-state-disabled ui-igcheckbox-normal-on',
			/* classes applied to the invalid drop indicator container */
			invalidDropIndicator: 'ui-widget ui-igtree-dropindicator ui-state-error ui-corner-all',
			/* classes applied to the drop indicator container */
			dropIndicator: 'ui-widget ui-igtree-dropindicator ui-state-highlight ui-corner-all',
			/* classes defining the move to drop indicator icon */
			moveMarkupIcon: 'ui-icon ui-icon-arrowthick-1-e',
			/* classes defining the invalid move to drop indicator icon */
			invalidMoveMarkupIcon: 'ui-icon ui-icon-cancel',
			/* classes defining the copy drop indicator icon */
			copyMarkupIcon: 'ui-icon ui-icon-plus',
			/* classes applied to the insert line container */
			insertLine: 'ui-state-default ui-igtree-insertline'
		},
        options: {
			/* type="string|number|null Gets sets how the width of the control can be set."
                string The widget width can be set in pixels (px) and percentage (%).
                number The widget width can be set as a number in pixels.
                null type="object" will stretch to fit data, if no other widths are defined.
            */
			width: null,
			/* type="string|number|null Gets sets how the height of the control can be set."
                string The height width can be set in pixels (px) and percentage (%).
                number The height width can be set as a number in pixels.
                null type="object" will fit the tree inside its parent container, if no other widths are defined.
            */
			height: null,
			/* type="off|biState|triState" Gets the type of checkboxes rendered before the tree nodes. Can be set only at initialization.
				off type="string" Checkboxes are turned off and not rendered for the tree.
				biState type="string" Checkboxes are rendered and support two states (checked and unchecked). Checkboxes do not cascade down or up in this mode.
				triState type="string" Checkboxes are rendered and support three states (checked, partial and unchecked). Checkboxes cascade up and down in this mode.
            */
			checkboxMode: 'off',
			/* type="bool" If set to true then only one branch at each level of the tree can be expanded at a time. Otherwise multiple branches can be expanded at a time. */
			singleBranchExpand: false,
			/* type="bool" Setting this option to false would make the tree to not apply hover styles on the nodes when they are hovered */
			hotTracking: true,
			/* type="string"
				string Image with the specified URL will be rendered for each node that has children (If you define both image URL and class the URL would be rendered).
				null Option is ignored
            */
			parentNodeImageUrl: null,
			/* type="string"
				string Specified class with a CSS sprite would be rendered for each node that has children (If you define both image URL and class the URL would be rendered).
				null Option is ignored
            */
			parentNodeImageClass: null,
			/* type="string"
				string Specified a tooltip that would be rendered for each node that has children.
				null Option is ignored
            */
			parentNodeImageTooltip: null,
			/* type="string"
				string Image with the specified URL will be rendered for each node that has no children (If you define both image URL and class the URL would be rendered).
				null Option is ignored
            */
			leafNodeImageUrl: null,
			/* type="string"
				string Specified class with a CSS sprite would be rendered for each node that has no children (If you define both image URL and class the URL would be rendered).
				null Option is ignored
            */
			leafNodeImageClass: null,
			/* type="string"
				string Specified a tooltip that would be rendered for each node that has no children.
				null Option is ignored
            */
			leafNodeImageTooltip: null,
			/* type="number" Specifies the duration of each animation such as the expand/collapse. */
			animationDuration: 200,
			/* type="string" Specifies the node data-path separator character. */
			pathSeparator: '_',
			/* type="object" Specifies any valid data source accepted by $.ig.DataSource, or an instance of an $.ig.DataSource itself. */
			dataSource: null,
			/* type="string" Specifies a remote URL accepted by $.ig.DataSource in order to request data from it */
			dataSourceUrl: null,
			/* type="string" Explicitly set data source type (such as "json"). Please refer to the documentation of $.ig.DataSource and its type property. */
			dataSourceType: null,
			/* type="string" see $.ig.DataSource. 
				string Specifies the name of the property in which data records are held if the response is wrapped. 
				null Option is ignored.
			*/
			responseDataKey: null,
			/* type="string" 
				string Explicitly set data source type (such as "json"). Please refer to the documentation of $.ig.DataSource and its type property.
				null Option is ignored.
			*/
			responseDataType: null,
			/* type="string" specifies the HTTP verb to be used to issue the request */
			requestType: "GET",
			/* type="string" content type of the response. See http://api.jquery.com/jQuery.ajax/ => contentType */
			responseContentType: null,
			/* type="number" Specifies the depth down to which the tree would be expanded upon initial render. */
			initialExpandDepth: -1,
			/* type="bool" Specifies all the data would be bound initially or each child collection would be bound upon demand. */
			loadOnDemand: false,
			/* type="object" Specifies the data binding properties and keys. */
			bindings: {
				/* type="string" Specifies the name of the data source property the value of which would be the node text. */
				textKey: 'Text',
				/* type="string" Specifies the XPath to the text attribute/node. Used in client-only binding directly to XML. */
				textXPath: '@Text',
				/* type="string" Specifies the name of the data source property the value of which would be the node value. */
				valueKey: 'Value',
				/* type="string" Specifies the XPath to the value attribute/node. Used in client-only binding directly to XML. */
				valueXPath: '@Value',
				/* type="string" Specifies the name of the data source property the value of which would be used as a URL 
								for the node image. 
				*/
				imageUrlKey: 'ImageUrl',
				/* type="string" Specifies the XPath to the image URL attribute/node. Used in client-only binding directly to XML. */
				imageUrlXPath: '@ImageUrl',
				/* type="string" Specifies the name of the data source property the value of which would be used as an href 
								attribute for the node anchor. 
				*/
				navigateUrlKey: 'NavigateUrl',
				/* type="string" Specifies the XPath to the navigate URL attribute/node. Used in client-only binding directly to XML. */
				navigateUrlXPath: '@NavigateUrl',
				/* type="string" Specifies the name of the data source property the value of which would be used as a target
								attribute for the node anchor. 
				*/
				targetKey: 'Target',
				/* type="string" Specifies the name of the data source property the value of which would indicate that the 
								node is expanded on initial load. 
				*/
				expandedKey: 'Expanded',
				/* type="string" Specifies the name of the data source property the value of which is the primary key attribute
								for the data. This property is used when load on demand is enabled and if specified the node paths
								would be generated using primary keys instead of indices.
				*/
				primaryKey: null,
				/* type="string" Specifies the node content template for the current layer of bindings. The igTree utilizes igTemplating
								for generating node content templates. A good example of how to setup templating can be found here http://www.infragistics.com/community/blogs/marina_stoyanova/archive/2014/06/17/how-to-use-templates-to-style-the-different-nodes-of-the-ignite-ui-tree-control.aspx
				*/
				nodeContentTemplate: null,
				/* type="string" Specifies the name of the data source property that holds the child data of the current layer node. */
				childDataProperty: 'Nodes',
				/* type="string" Specifies the XPath to the child data node. Used in client-only binding directly to XML. */
				childDataXPath: 'Children',
				/* type="string" Specifies the XPath to the root data node. Used in client-only binding directly to XML. */
				searchFieldXPath: 'Nodes',
				/* type="object" Specifies the next layer of bindings in a recursive fashion. */
				bindings: {
					/* Recursively defines next layer fo bindings */
				}
			},
			/* type="string" Specifies the default target of the node anchor. */
			defaultNodeTarget: '_self',
			/* type="boolean" If set to true it would enable drag and drop functionality. */
			dragAndDrop: false,
			/* type="string" URL to which updating requests will be made. */
			updateUrl: null,
			/* type="object" Specific settings for the drag and drop functionality. */
			dragAndDropSettings: {
				/* type="boolean" Specifies whether the widget will accept D&D from other controls. boolean. Default value is false. */
				allowDrop: false,
				/* type="default|copy|move" Specifies the D&D mode. Accepted values "default", "copy", "move". Where "default" is "copy" 
											when Ctrl key is hold, else it means "move". Just like in Windows explorer. 
											None means the tree does not accept this node.  
				*/
				dragAndDropMode: 'default',
				/* type="number" Specifies the opacity of the drag helper: 0 is fully transparent while 1 is fully opaque. 
				*/
				dragOpacity: 0.75,
				/* type="boolean" Specifies whether the helper would revert to its original position upon an invalid drop. 
				*/
				revert: true,
				/* type="number" Specifies the duration of the revert animation. 
				*/
				revertDuration: 500,
				/* type="number" Specifies z-index that would be set for the drag helper. 
				*/
				zIndex: 10,
				/* type="number" Specifies the delay between mousedown and the start of the actual drag. Smaller values make the nodes 
									more sensitive to drag.
				*/
				dragStartDelay: 200,
				/* type="boolean" Specifies whether when dragging over a collapsed node with children the node will expand after
									the timeout specified in the expandDelay option.
				*/
				expandOnDragOver: true,
				/* type="number" Specifies the delay after hovering a parent node before it expands to show its children during drag.
				*/
				expandDelay: 1000,
				/* type="string|function" Specifies the helper for the drag operation. 'default' would render the internal helper,
											while a function returning a jQuery element can build entirely custom helper.
				*/
				helper: 'default',
				/* type="function" Returning true from this function would render the drop point valid, while false would make it invalid.
									The function has one parameter which is the current drop point and the context of the function is the
									drag element.
				*/
				customDropValidation: null,
				/* type="boolean|selector|element|string|array" Specifies the containment for the drag helper. The area inside of which the 
									helper is contained would be scrollable while dragging.
				*/
				containment: false,
				/* type="string" Specifies the HTML markup for the invalid helper.
				*/
				invalidMoveToMarkup: '<div><p><span></span><strong>{0}</strong></p></div>',
				/* type="string" Specifies the HTML markup for the "move to" helper.
				*/
				moveToMarkup: '<div><p><span></span><strong>Move to</strong> {0}</p></div>',
				/* type="string" Specifies the HTML markup for the "move between" helper.
				*/
				moveBetweenMarkup: '<div><p><span></span><strong>Move between</strong> {0} and {1}</p></div>',
				/* type="string" Specifies the HTML markup for the "move after" helper.
				*/
				moveAfterMarkup: '<div><p><span></span><strong>Move after</strong> {0}</p></div>',
				/* type="string" Specifies the HTML markup for the "move before" helper.
				*/
				moveBeforeMarkup: '<div><p><span></span><strong>Move before</strong> {0}</p></div>',
				/* type="string" Specifies the HTML markup for the "copy to" helper.
				*/
				copyToMarkup: '<div><p><span></span><strong>Copy to</strong> {0}</p></div>',
				/* type="string" Specifies the HTML markup for the "copy between" helper.
				*/
				copyBetweenMarkup: '<div><p><span></span><strong>Copy between</strong> {0} and {1}</p></div>',
				/* type="string" Specifies the HTML markup for the "copy after" helper.
				*/
				copyAfterMarkup: '<div><p><span></span><strong>Copy after</strong> {0}</p></div>',
				/* type="string" Specifies the HTML markup for the "copy before" helper.
				*/
				copyBeforeMarkup: '<div><p><span></span><strong>Copy before</strong> {0}</p></div>'
			}
        },
		events: {
			/* cancel="false" fired before databinding is performed 
				Function takes arguments evt and ui.
				Use ui.owner to get a reference to the tree performing databinding.
			*/
			dataBinding: 'dataBinding',
			/* fired after databinding is finished 
				Function takes arguments evt and ui.
				Use ui.owner to get a reference to the tree performing databinding.
				Use ui.dataView to get a reference to the data the tree has been databound to.
			*/
			dataBound: 'dataBound',
			/* cancel="false" fired before rendering of the tree begins 
				Function takes arguments evt and ui.
				Use ui.owner to get a reference to the tree performing rendering.
				Use ui.dataView to get a reference to the data the tree is going to render.
			*/
			rendering: 'rendering',
			/* fired after rendering of the tree has finished 
				Function takes arguments evt and ui.
				Use ui.owner to get a reference to the tree.
			*/
			rendered: 'rendered',
			/* cancel="true" fired before a new node is selected 
				Function takes arguments evt and ui.
				Use ui.owner to get a reference to the tree.
				Use ui.selectedNodes to get a reference to currently selected nodes.
				Use ui.newNodes to get a reference to the new nodes getting selected.
			*/
			selectionChanging: 'selectionChanging',
			/* fired after a new node is selected 
				Function takes arguments evt and ui.
				Use ui.owner to get a reference to the tree.
				Use ui.selectedNodes to get a reference to the selected nodes.
				Use ui.newNodes to get a reference to the newly added nodes to the selection.
			*/
			selectionChanged: 'selectionChanged',
			/* cancel="true" fired before the checkstate of a node is changed 
				Function takes arguments evt and ui.
				Use ui.owner to get a reference to the tree.
				Use ui.node to get a reference to the node object the checkbox of which is being interacted with.
				Use ui.currentState to get the current state of the checkbox.
				Use ui.newState to get the new future state of the checkbox.
				Use ui.currentCheckedNodes to get the collection of all checked nodes before the new state is applied.
			*/
			nodeCheckstateChanging: 'nodeCheckstateChanging',
			/* fired after the checkstate of a node is changed 
				Use ui.owner to get a reference to the tree.
				Use ui.node to get a reference to the node object the checkbox of which is being interacted with.
				Use ui.newState to get the new current state of the checkbox.
				Use ui.newCheckedNodes to get the collection of all checked nodes.
				Use ui.newPartiallyCheckedNodes to get the collection of all partially checked nodes.
			*/
			nodeCheckstateChanged: 'nodeCheckstateChanged',
			/* cancel="true" fired before the children of a node are populated in the case of load on demand 
				Use ui.path to get a reference to the path of the node being populated.
				Use ui.element to get a reference to the jQuery element of the node being populated.
				Use ui.data to get the node data.
				Use ui.binding to get a reference to the bindings object for the level at which the populating node is located.
			*/
			nodePopulating: 'nodePopulating',
			/* fired after the children of a node are populated in the case of load on demand 
				Use ui.path to get a reference to the path of the populated node.
				Use ui.element to get a reference to the jQuery element of the populated node.
				Use ui.data to get the node data.
				Use ui.binding to get a reference to the bindings object for the level at which the populated node is located.
			*/
			nodePopulated: 'nodePopulated',
			/* cancel="true" fired before a node is collapsed 
				Use ui.owner to get a reference to the tree.
				Use ui.node to get a reference to the node object about to collapse.
			*/
			nodeCollapsing: 'nodeCollapsing',
			/* fired after a node is collapsed 
				Use ui.owner to get a reference to the tree.
				Use ui.node to get a reference to the collapsed node object.
			*/
			nodeCollapsed: 'nodeCollapsed',
			/* cancel="true" fired before a node is expanded 
				Use ui.owner to get a reference to the tree.
				Use ui.node to get a reference to the node object about to expand.
			*/
			nodeExpanding: 'nodeExpanding',
			/* fired after a node is expanded 
				Use ui.owner to get a reference to the tree.
				Use ui.node to get a reference to the expanded node object.
			*/
			nodeExpanded: 'nodeExpanded',
			/* fired on node click 
				Use ui.owner to get a reference to the tree.
				Use ui.node to get a reference to the node object being clicked.
			*/
			nodeClick: 'nodeClick',
			/* fired on node double click
				Use ui.path to get a reference to the path of the double clicked node.
				Use ui.element to get a reference to the jQuery element of the double clicked node.
				Use ui.data to get the node data.
				Use ui.binding to get a reference to the bindings object for the level at which the double clicked node is located.
			*/
			nodeDoubleClick: 'nodeDoubleClick',
			/* cancel="true" fired on node drag start
				Use ui.binding to gets a reference to the binding.
				Use ui.data	to get a reference to the data.
				Use ui.element to get a reference to the element.
				Use ui.helper to get a reference to the helper.
				Use ui.offset to get a reference to the offset.
				Use ui.orginalPosition to get a reference to the original position of the draggable element (the node).
				Use ui.path	to get a reference to the node path.
				Use ui.position to get a reference to the current position of the draggable element.
			*/
			dragStart: 'dragStart',
			/* cancel="true" fired on node drag
				Use ui.binding to gets a reference to the binding.
				Use ui.data	to get a reference to the data.
				Use ui.element to get a reference to the element.
				Use ui.helper to get a reference to the helper.
				Use ui.offset to get a reference to the offset.
				Use ui.orginalPosition to get a reference to the original position of the draggable element (the node).
				Use ui.path	to get a reference to the node path.
				Use ui.position to get a reference to the current position of the draggable element.
			*/
			drag: 'drag',
			/* fired after a drag operation has completed
				Use ui.helper to get a reference to the helper.
				Use ui.offset to get a reference to the offset.
				Use ui.orginalPosition to get a reference to the original position of the draggable element (the node).
				Use ui.position to get a reference to the current position of the draggable element.
			*/
			dragStop: 'dragStop',
			/* cancel="true" fired before a node drop
				Use ui.binding to gets a reference to the binding.
				Use ui.data	to get a reference to the data.
				Use ui.draggable to get a reference to the draggable element (the node).
				Use ui.element to get a reference to the element.
				Use ui.helper to get a reference to the helper.
				Use ui.offset to get a reference to the offset.
				Use ui.path	to get a reference to the node path.
				Use ui.position to get a reference to the current position of the draggable element.
			*/
			nodeDropping: 'nodeDropping',
			/* fired after a node drop
				Use ui.binding to gets a reference to the binding.
				Use ui.data	to get a reference to the data.
				Use ui.draggable to get a reference to the draggable element (the node).
				Use ui.element to get a reference to the element.
				Use ui.helper to get a reference to the helper.
				Use ui.offset to get a reference to the offset.
				Use ui.path	to get a reference to the node path.
				Use ui.position to get a reference to the current position of the draggable element.
			*/
			nodeDropped: 'nodeDropped'
		},
		widget: function () {
            /* Returns the element that represents this widget.
				returnType="object" Returns the element that represents this widget.
			*/
			return this.element;
		},
		_createWidget: function () {
			/* !Strip dummy objects from options, because they are defined for documentation purposes only! */
			this.options.bindings = null;
			this.options.dragAndDropSettings.moveToMarkup = '<div><p><span></span>' + $.ig.Tree.locale.moveTo + '</p></div>';
			this.options.dragAndDropSettings.moveBetweenMarkup = '<div><p><span></span>' + $.ig.Tree.locale.moveBetween + '</p></div>';
			this.options.dragAndDropSettings.moveAfterMarkup = '<div><p><span></span>' + $.ig.Tree.locale.moveAfter + '</p></div>';
			this.options.dragAndDropSettings.moveBeforeMarkup = '<div><p><span></span>' + $.ig.Tree.locale.moveBefore + '</p></div>';
			this.options.dragAndDropSettings.copyToMarkup = '<div><p><span></span>' + $.ig.Tree.locale.copyTo + '</p></div>';
			this.options.dragAndDropSettings.copyBetweenMarkup = '<div><p><span></span>' + $.ig.Tree.locale.copyBetween + '</p></div>';
			this.options.dragAndDropSettings.copyAfterMarkup = '<div><p><span></span>' + $.ig.Tree.locale.copyAfter + '</p></div>';
			this.options.dragAndDropSettings.copyBeforeMarkup = '<div><p><span></span>' + $.ig.Tree.locale.copyBefore + '</p></div>';
			$.Widget.prototype._createWidget.apply(this, arguments);
		},
        _create: function () {
			var opt = this.options;
			this.dataBind();
			this.element.addClass(this.css.tree);
			// K.D. February 17th, 2014 Bug #164398 Attaching events only on create as delegate is used instead of bind now.
			this._attachEvents();
			// K.D. October 18th, 2011 Tree goes outside of it's container under IE7 when height is applied and the container
			// is with position static.
			if ($.ig.util.isIE && $.ig.util.browserVersion === 7 && this.element.css('position') === 'static') {
				this.element.css('position', 'relative');
			}
			if (opt.width) {
				this.element.css('width', opt.width);
			}
			if (opt.height) {
				this.element.css('height', opt.height);
			}
        },
        _setOption: function (option, value) {
			var css = this.css, elements, prevValue = this.options[option];
			if (prevValue === value) {
				return;
			}
            $.Widget.prototype._setOption.apply(this, arguments);

            switch (option) {
			case 'width':
				this.element.css('width', value);
				break;
			case 'height':
				this.element.css('height', value);
				break;
			case 'parentNodeImageUrl':
				elements = this.element.find('img[data-role=parent-node-image]');
				if (elements.length > 0) {
					elements.attr('src', value);
				} else {
					throw new Error($.ig.Tree.locale.setOptionError + option);
				}
				break;
			case 'parentNodeImageTooltip':
				elements = this.element.find('img[data-role=parent-node-image]');
				if (elements.length <= 0) {
					elements = this.element.find('span[data-role=parent-node-image]');
				}
				if (elements.length > 0) {
					elements.attr('title', value);
				} else {
					throw new Error($.ig.Tree.locale.setOptionError + option);
				}
				break;
			case 'parentNodeImageClass':
				elements = this.element.find('span[data-role=parent-node-image]');
				if (elements.length > 0) {
					elements.removeClass();
					elements.addClass(value);
				} else {
					throw new Error($.ig.Tree.locale.setOptionError + option);
				}
				break;
			case 'leafNodeImageUrl':
				elements = this.element.find('img[data-role=leaf-node-image]');
				if (elements.length > 0) {
					elements.attr('src', value);
				} else {
					throw new Error($.ig.Tree.locale.setOptionError + option);
				}
				break;
			case 'leafNodeImageTooltip':
				elements = this.element.find('img[data-role=leaf-node-image]');
				if (elements.length <= 0) {
					elements = this.element.find('span[data-role=leaf-node-image]');
				}
				if (elements.length > 0) {
					elements.attr('title', value);
				} else {
					throw new Error($.ig.Tree.locale.setOptionError + option);
				}
				break;
			case 'leafNodeImageClass':
				elements = this.element.find('span[data-role=leaf-node-image]');
				if (elements.length > 0) {
					elements.removeClass();
					elements.addClass(value);
				} else {
					throw new Error($.ig.Tree.locale.setOptionError + option);
				}
				break;
			case 'hotTracking':
			    if (value) {
			        // K.D. August 16th, 2013 Bug #149438 Switching to delegated events
					this.element.delegate('a', {
						'mouseover': function (event) {
							$(event.target).addClass(css.nodeHovered);
						},
						'mouseout': function (event) {
							$(event.target).removeClass(css.nodeHovered);
						}
					});
			    } else {
			        // K.D. August 16th, 2013 Bug #149438 Switching to delegated events
					this.element.undelegate('a', 'mouseover');
					this.element.undelegate('a', 'mouseout');
				}
				break;
			case 'checkboxMode':
				// K.D. February 10th, 2014 Bug #163522 When the igTree is initialized with checkboxMode = off setting its value to biState is not possible
				if (value.toLowerCase() === 'off') {
					this._removeCheckboxes();
				} else if (prevValue === 'off') {
					this._addCheckboxes();
				}
				break;
			case 'dataSource':
				// K.D. January 10th, 2012 Bug #99110 The tree needs to be rebound and rerendered after changing the DS
				this.dataBind();
				break;
			case 'dragAndDrop':
				if (value) {
					this._initDragAndDrop();
				} else {
					this._destroyDragAndDrop();
				}
				break;
			case 'updateUrl':
				this.options.dataSource.root().settings.updateUrl = value;
				break;
			case 'bindings':
			case 'loadOnDemand':
			case 'pathSeparator':
			case 'initialExpandDepth':
			case 'defaultNodeTarget':
                // K.D. April 14th, 2014 Bug #169669 Throwing an error on bindings
				throw new Error($.ig.Tree.locale.setOptionError + option);
            default:
                break;
            }
        },
		_removeCheckboxes: function () {
			this.element.find('span[data-role=checkbox]').remove();
		},
		_addCheckboxes: function () {
			var self = this;
			this.element.find('li[data-role=node]').each(function () {
				var $this = $(this);
				if ($this.children('span[data-role=expander]').length > 0) {
					$this.children('span[data-role=expander]').after(self._renderCheckbox());
				} else {
					$this.prepend(self._renderCheckbox());
				}
			});
		},
		_initDataOptions: function () {
			var dataOptions, ul, s;

			s = this._initDataSourceSchema();
			if (!this.options.dataSource && !this.options.dataSourceUrl) {
				if (!this.element.is('ul')) {
					ul = this.element.children('ul');
					this.options.dataSource = ul[0];
				} else {
					this.options.dataSource = this.element[0];
				}
			} else if (!this.options.dataSource && this.options.dataSourceUrl) {
				this.options.dataSource = this.options.dataSourceUrl;
			} else if ($.type(this.options.dataSource) === 'object' && 
						typeof this.options.dataSource._encodeHierarchicalUrlParams !== "function" && 
						typeof this.options.dataSource._xmlToArray !== "function" && 
						!this.options.dataSourceType) {
				// K.D. October 14th, 2013 Bug #154764 When the igTree is bound to an object and not an array an error is thrown
				this.options.dataSource = [this.options.dataSource];
			}

			dataOptions = {
			    callback: this._constructFromData,
			    callee: this,
				dataSource: this.options.dataSource,
				requestType: this.options.requestType,
				responseContentType: this.options.responseContentType,
				defaultChildrenDataProperty: this.options.bindings.childDataProperty,
				responseDataType: this.options.responseDataType,
				primaryKey: this.options.primaryKey,
				localSchemaTransform: this.options.dataSourceType && this.options.dataSourceType === 'xml' ? true : false,
				schema: s,
				updateUrl: this.options.updateUrl
		    };

			if (this.options.dataSourceType) {
				dataOptions.type = this.options.dataSourceType;
			}
			// K.D. September 20th, 2012 Bug #121861 The responseDataKey needs to be set in the data source
			if (this.options.responseDataKey) {
				dataOptions.responseDataKey = this.options.responseDataKey;
			}

			return dataOptions;
		},
		_initDataSourceSchema: function () {
			var schema = {}, opt = this.options, bindings = opt.bindings;

			if (bindings === null) {
				opt.bindings = {};
				schema.text = { name: 'Text', type: 'string' };
				opt.bindings.textKey = 'Text';
				schema.value = { name: 'Value', type: 'string' };
				opt.bindings.valueKey = 'Value';
				schema.imageUrl = { name: 'ImageUrl', type: 'string' };
				opt.bindings.imageUrlKey = 'ImageUrl';
				schema.navigateUrl = { name: 'NavigateUrl', type: 'string' };
				opt.bindings.navigateUrlKey = 'NavigateUrl';
				schema.childData = { name: 'Nodes', type: 'object' };
				opt.bindings.childDataProperty = 'Nodes';
				schema.target = { name: 'Target', type: 'string' };
				opt.bindings.targetKey = 'Target';
				bindings = opt.bindings;
			} else if (opt.dataSourceType === 'xml') {
				if (bindings.searchFieldXPath) {
					schema.searchField = bindings.searchFieldXPath;
				}
			}

			schema.fields = [];
			if (bindings.textKey) {
				schema.fields.push({ name: bindings.textKey, type: 'string', xpath: bindings.textXPath });
				schema.textKey = bindings.textKey;
			}
			if (bindings.valueKey) {
				schema.fields.push({ name: bindings.valueKey, type: 'string', xpath: bindings.valueXPath });
				schema.valueKey = bindings.valueKey;
			}
			if (bindings.navigateUrlKey) {
				schema.fields.push({ name: bindings.navigateUrlKey, type: 'string', xpath: bindings.navigateUrlXPath });
				schema.navigateUrlKey = bindings.navigateUrlKey;
			}
			if (bindings.imageUrlKey) {
				schema.fields.push({ name: bindings.imageUrlKey, type: 'string', xpath: bindings.imageUrlXPath });
				schema.imageUrlKey = bindings.imageUrlKey;
			}
			if (bindings.targetKey) {
				schema.fields.push({ name: bindings.targetKey, type: 'string' });
				schema.targetKey = bindings.targetKey;
			}
			if (bindings.expandedKey) {
				schema.fields.push({ name: 'Expanded', type: 'boolean' });
				schema.expandedKey = bindings.expandedKey;
			}
			if (bindings.primaryKey) {
				schema.fields.push({ name: bindings.primaryKey, type: 'string' });
				schema.primaryKey = bindings.primaryKey;
			}
			if (bindings.childDataProperty) {
				schema.fields.push({ name: bindings.childDataProperty, type: 'object', xpath: bindings.childDataXPath });
				schema.childDataProperty = bindings.childDataProperty;
			}
			// K.D. March 30th, 2012 Bug #106890 When the data source type is remoteUrl and responseDataKey is set, then searchField in the
			// schema needs to be set to be the responseDataKey
			if (!schema.searchField && opt.responseDataKey) {
				schema.searchField = opt.responseDataKey;
			}
			return schema;
		},
		_initDataSource: function (dataOptions) {
			var opt = this.options;

			if (!opt.dataSource || typeof opt.dataSource._encodeHierarchicalUrlParams !== "function") {
				opt.dataSource = new $.ig.HierarchicalDataSource(dataOptions);
			}
		},
		_helper: null,
		_insertLine: {
			html: null
		},
		_originalHelper: {
			html: null
		},
		_sourceNode: {
			data: null,
			element: null,
			owner: null
		},
		_validationObject: {
			valid: true,
			dropAfter: true,
			expandTimeout: null,
			target: null
		},
		_helperDirty: false,
		_dropAfter: true,
		_initDragOptions: function () {
			var self = this,
				dragAndDropSettings = self.options.dragAndDropSettings,
				helper = dragAndDropSettings.helper === 'default' ? function (event) {
					var target = $(event.target).closest('li[data-role=node]'),
						markup = $(self.options.dragAndDropSettings.invalidMoveToMarkup.replace('{0}', target.children('a').text()));
					markup.addClass(self.css.invalidDropIndicator)
						.find('span')
						.addClass(self.css.invalidMoveMarkupIcon);
					return markup;
				} : dragAndDropSettings.helper,
				opt = {
					revert: dragAndDropSettings.revert ? 'invalid' : false,
					opacity: dragAndDropSettings.dragOpacity,
					zIndex: dragAndDropSettings.zIndex,
					cursorAt: this._const.dragCursorAt,
					helper: helper,
					revertDuration: dragAndDropSettings.revertDuration,
					appendTo: self.element,
					delay: dragAndDropSettings.dragStartDelay,
					containment: dragAndDropSettings.containment,
					start: function (event, ui) {
						var node = self.nodeFromElement($(this)), noCancel;
						noCancel = self._triggerDragStart(event, ui, node.element);
						if (noCancel) {
							self._originalHelper.html = ui.helper.html();
							// K.D. October 17th, 2013 Bug #155067 A shallow copy should be created instead of a deep one
							self._sourceNode.data = $.extend(false, {}, node.data);
							self._sourceNode.owner = self;
							self._sourceNode.element = $(this);
						} else {
							return false;
						}
					},
					drag: function (event, ui) {
						var noCancel = self._triggerDrag(event, ui, self._sourceNode.element);
						if (noCancel) {
							self._performDrag(event, ui);
						} else {
							// K.D. October 29th, 2012 Bug #125545 When the drag event is cancelled all the objects need to be reset.
							self._resetSourceNode();
							self._resetValidationObject();
							return false;
						}
					},
					stop: function (event, ui) {
						self._triggerDragStop(event, ui);
						$(document).find('div[data-role=insert-line]').remove();
						self._helperDirty = false;
						self._resetSourceNode();
						self._resetValidationObject();
					}
				};
			return opt;
		},
		_performDrag: function (event, ui) {
			var target = $(event.originalEvent.target),
				markup,
				copy = (event.ctrlKey && this.options.dragAndDropSettings.dragAndDropMode === 'default') || this.options.dragAndDropSettings.dragAndDropMode === 'copy',
				targetTop,
				dragTop,
				self = this;
			if (target.is('div[data-role=insert-line]')) {
				return;
			}
			this._validationObject.valid = this._accept(this._sourceNode.element, target);
			$(document).find('div[data-role=insert-line]').remove();
			// Expand on hover
			// K.D. July 24th, 2012 Bug #117682 Expand on hover should only activate when hovering the anchor
			// K.D. February 7th, 2013 Bug #132384 Adding an option to disable the expandOnDragOver functionality
			if (this.options.dragAndDropSettings.expandOnDragOver) {
				if ((target.is('a') || target.closest('a').parent().is('li[data-role=node]')) && this._validationObject.target !== target.closest('li[data-role=node]')) {
					clearTimeout(this._validationObject.expandTimeout);
					this._validationObject.target = target.closest('li[data-role=node]');
					// K.D. September 3rd, 2012 Bug #118064 Checking whether the current target has children and not triggering the expand if it does not
					if (this._validationObject.target.hasClass('ui-igtree-parentnode')) {
						this._validationObject.expandTimeout = setTimeout(function () {
							self.expand(self._validationObject.target);
						}, this.options.dragAndDropSettings.expandDelay);
					}
				} else {
					clearTimeout(this._validationObject.expandTimeout);
					this._validationObject.expandTimeout = null;
					this._validationObject.target = null;
				}
			}
			// Show the appropriate drag and drop markup
			if ((target.is('a') || target.closest('a').parent().is('li[data-role=node]')) && this._validationObject.valid) {
				if (copy) {
					markup = $(this.options.dragAndDropSettings.copyToMarkup.replace('{0}', target.text()));
					markup.find('span').addClass(this.css.copyMarkupIcon);
				} else {
					markup = $(this.options.dragAndDropSettings.moveToMarkup.replace('{0}', target.text()));
					markup.find('span').addClass(this.css.moveMarkupIcon);
				}
				this._helper = markup.html();
				ui.helper.removeClass(this.css.invalidDropIndicator).addClass(this.css.dropIndicator).html(this._helper);
				this._helperDirty = true;
			} else if (target.is('li[data-role=node]') && this._validationObject.valid) {
				targetTop = target.offset().top + target.height() / 2;
				dragTop = ui.offset.top + this._const.dragCursorAt.top;
				if (dragTop > targetTop) {
					this._validationObject.dropAfter = true;
					if (copy) {
						if (target.next('li[data-role=node]').length > 0) {
							markup = $(this.options.dragAndDropSettings.copyBetweenMarkup.replace('{0}', target.children('a').text()).replace('{1}', target.next('li[data-role=node]').children('a').text()));
							markup.find('span').addClass(this.css.copyMarkupIcon);
						} else {
							markup = $(this.options.dragAndDropSettings.copyAfterMarkup.replace('{0}', target.children('a').text()));
							markup.find('span').addClass(this.css.copyMarkupIcon);
						}
					} else {
						if (target.next('li[data-role=node]').length > 0) {
							markup = $(this.options.dragAndDropSettings.moveBetweenMarkup.replace('{0}', target.children('a').text()).replace('{1}', target.next('li[data-role=node]').children('a').text()));
							markup.find('span').addClass(this.css.moveMarkupIcon);
						} else {
							markup = $(this.options.dragAndDropSettings.moveAfterMarkup.replace('{0}', target.children('a').text()));
							markup.find('span').addClass(this.css.moveMarkupIcon);
						}
					}
					$(this._insertLine.html).appendTo(target);
					this._helper = markup.html();
					ui.helper.removeClass(this.css.invalidDropIndicator)
						.addClass(this.css.dropIndicator)
						.html(this._helper);
				} else {
					this._validationObject.dropAfter = false;
					if (copy) {
						if (target.prev('li[data-role=node]').length > 0) {
							markup = $(this.options.dragAndDropSettings.copyBetweenMarkup.replace('{0}', target.children('a').text()).replace('{1}', target.prev('li[data-role=node]').children('a').text()));
							markup.find('span').addClass(this.css.copyMarkupIcon);
						} else {
							markup = $(this.options.dragAndDropSettings.copyBeforeMarkup.replace('{0}', target.children('a').text()));
							markup.find('span').addClass(this.css.copyMarkupIcon);
						}
					} else {
						if (target.prev('li[data-role=node]').length > 0) {
							markup = $(this.options.dragAndDropSettings.moveBetweenMarkup.replace('{0}', target.prev('li[data-role=node]')
								.children('a').text())
								.replace('{1}', target.children('a').text()));
							markup.find('span').addClass(this.css.moveMarkupIcon);
						} else {
							markup = $(this.options.dragAndDropSettings.moveBeforeMarkup.replace('{0}', target.children('a').text()));
							markup.find('span').addClass(this.css.moveMarkupIcon);
						}
					}
					if (target.index() === 0) {
						$(this._insertLine.html).prependTo(target).css('padding-bottom', '0.1em');
					} else {
						$(this._insertLine.html).appendTo(target.prev());
					}
					this._helper = markup.html();
					ui.helper.removeClass(this.css.invalidDropIndicator)
						.addClass(this.css.dropIndicator)
						.html(this._helper);
				}
				this._helperDirty = true;
			} else if (target.is(':ui-igTree') && target.data('igTree') !== this) {
				// K.D. December 13th, 2013 Bug #159540 Allowing for dragging and dropping into an empty tree.
				if (copy) {
					markup = $(this.options.dragAndDropSettings.copyToMarkup.replace('{0}', ""));
					markup.find('span').addClass(this.css.copyMarkupIcon);
				} else {
					markup = $(this.options.dragAndDropSettings.moveToMarkup.replace('{0}', ""));
					markup.find('span').addClass(this.css.moveMarkupIcon);
				}
				this._helper = markup.html();
				ui.helper.removeClass(this.css.invalidDropIndicator).addClass(this.css.dropIndicator).html(this._helper);
				this._helperDirty = true;
			} else {
				$(document).find('div[data-role=insert-line]').remove();
				if (this._helperDirty) {
					this._helper = null;
					ui.helper.removeClass(this.css.dropIndicator)
						.addClass(this.css.invalidDropIndicator)
						.html(this._originalHelper.html);
					this._helperDirty = false;
				}
			}
		},
		_resetSourceNode: function () {
			this._originalHelper.html = null;
			this._sourceNode.data = null;
			this._sourceNode.owner = null;
			this._sourceNode.element = null;
		},
		_resetValidationObject: function () {
			this._validationObject.valid = true;
			this._validationObject.dropAfter = true;
			clearTimeout(this._validationObject.expandTimeout);
			this._validationObject.expandTimeout = null;
			this._validationObject.target = null;
		},
		_initDropOptions: function () {
			var self = this,
				opt = {
					tolerance: 'pointer',
					greedy: true,
					drop: function (event, ui) {
						// K.D. October 12th, 2012 Bug #124246 Disallow external element drop inside the tree
						if (self._sourceNode.element === null && self._sourceNode.owner === null) {
							return false;
						}
						return self._performDrop(event, ui);
					},
					accept: function () {
						return self._validationObject.valid;
					}
				};
			return opt;
		},
		_performDrop: function (event, ui) {
			var self = this, parent, target = $(event.originalEvent.target), noCancel;
			if (target.is('div[data-role=insert-line]')) {
				target = target.closest('li[data-role=node]');
			}
			self.element.find('div[data-role=insert-line]').remove();
			noCancel = self._triggerNodeDropping(event, ui, target.closest('li[data-role=node]'), target.next('li[data-role=node]').length > 0 || !self._validationObject.dropAfter ? target.index() + (self._validationObject.dropAfter ? 1 : 0) : target.index());
			if (noCancel) {
				if (target.is('a') || target.closest('a').parent().is('li[data-role=node]')) {
					target = target.closest('li[data-role=node]');
					switch (self.options.dragAndDropSettings.dragAndDropMode) {
					case 'move':
						self.addNode(self._sourceNode.data, target);
						self._sourceNode.owner.removeAt(self._sourceNode.element.attr('data-path'));
						break;
					case 'copy':
						self.addNode(self._sourceNode.data, target);
						break;
					default:
						if (!event.ctrlKey) {
							self.addNode(self._sourceNode.data, target);
							self._sourceNode.owner.removeAt(self._sourceNode.element.attr('data-path'));
						} else {
							self.addNode(self._sourceNode.data, target);
						}
						break;
					}
				} else if (target.is('li')) {
					parent = self.parentNode(target);
					switch (self.options.dragAndDropSettings.dragAndDropMode) {
					case 'move':
						self.addNode(self._sourceNode.data, parent, target.next('li[data-role=node]').length > 0 || !self._validationObject.dropAfter ? target.index() + (self._validationObject.dropAfter ? 1 : 0) : null);
						self._sourceNode.element.attr('data-path', self._sourceNode.element.attr('data-path') + '_remove');
						self._sourceNode.owner.removeAt(self._sourceNode.element.attr('data-path'));
						break;
					case 'copy':
						self.addNode(self._sourceNode.data, parent, target.next('li[data-role=node]').length > 0 || !self._validationObject.dropAfter ? target.index() + (self._validationObject.dropAfter ? 1 : 0) : null);
						break;
					default:
						if (!event.ctrlKey) {
							self.addNode(self._sourceNode.data, parent, target.next('li[data-role=node]').length > 0 || !self._validationObject.dropAfter ? target.index() + (self._validationObject.dropAfter ? 1 : 0) : null);
							self._sourceNode.element.attr('data-path', self._sourceNode.element.attr('data-path') + '_remove');
							self._sourceNode.owner.removeAt(self._sourceNode.element.attr('data-path'));
						} else {
							self.addNode(self._sourceNode.data, parent, target.next('li[data-role=node]').length > 0 || !self._validationObject.dropAfter ? target.index() + (self._validationObject.dropAfter ? 1 : 0) : null);
						}
						break;
					}
				} else if (target.is(':ui-igTree')) {
					// K.D. December 13th, 2013 Bug #159540 Allowing for dragging and dropping into an empty tree.
					switch (self.options.dragAndDropSettings.dragAndDropMode) {
					case 'move':
						self.addNode(self._sourceNode.data);
						self._sourceNode.owner.removeAt(self._sourceNode.element.attr('data-path'));
						break;
					case 'copy':
						self.addNode(self._sourceNode.data);
						break;
					default:
						if (!event.ctrlKey) {
							self.addNode(self._sourceNode.data);
							self._sourceNode.owner.removeAt(self._sourceNode.element.attr('data-path'));
						} else {
							self.addNode(self._sourceNode.data);
						}
						break;
					}
				}
				self._triggerNodeDropped(event, ui, target);
			} else {
				return false;
			}
		},
		_accept: function (dropElem, target) {
			// Validates the drop target
			var valid = true,
				node = target.closest('li[data-role=node]'),
				dropPath = dropElem.attr('data-path'),
				tree = target.closest('.ui-widget.ui-igtree'),
				sourceBinding = this._retrieveCurrentDepthBinding(parseInt(this._sourceNode.element.closest('ul').attr('data-depth'), 10)),
				destinationBinding;
			if ((target.is('a') && target.parent().is('li[data-role=node]')) || target.closest('a').parent().is('li[data-role=node]')) {
				destinationBinding = tree.data('igTree')._retrieveCurrentDepthBinding(parseInt(target.closest('ul').attr('data-depth'), 10) + 1);
			} else {
				if (target.is('li[data-role=node]')) {
					destinationBinding = tree.data('igTree')._retrieveCurrentDepthBinding(parseInt(target.closest('ul').attr('data-depth'), 10));
				} else if (target.is(':ui-igTree')) {
					// K.D. December 13th, 2013 Bug #159540 Allowing for dragging and dropping into an empty tree.
					destinationBinding = tree.data('igTree')._retrieveCurrentDepthBinding(0);
				} else {
					destinationBinding = false;
				}
			}
			if (node.length > 0 && (node.attr('data-path') === dropPath || node.attr('data-path').indexOf(dropPath + this.options.pathSeparator) === 0) && this === tree.data('igTree')) {
				valid = false;
			} else if (this !== tree.data('igTree') && !tree.igTree('option', 'dragAndDropSettings').allowDrop) {
				valid = false;
			} else if (typeof tree.igTree('option', 'dragAndDropSettings').customDropValidation === 'function') {
				valid = tree.igTree('option', 'dragAndDropSettings').customDropValidation.apply(target, [dropElem]);
			}
			if (sourceBinding && destinationBinding && valid) {
				valid = this._validateBindings(sourceBinding, destinationBinding, target);
			}
			return valid;
		},
		_validateBindings: function (sourceBinding, destinationBinding, target) {
			var valid = true;
			if (destinationBinding.hasOwnProperty('primaryKey')) {
				if (!sourceBinding.hasOwnProperty('primaryKey') || sourceBinding.primaryKey !== destinationBinding.primaryKey) {
					valid = false;
				} else if (target.is('a') && this._sourceNode.element.parent().closest('li[data-role=node]').is(target.closest('li[data-role=node]'))) {
					// K.D. November 12th, 2014 Bug #184185 Dropping a node on its parent removes the node when there is a primary key
					valid = false;
				}
			}
			if (destinationBinding.textKey !== sourceBinding.textKey) {
				valid = false;
			}
			if (destinationBinding.hasOwnProperty('valueKey') && sourceBinding.hasOwnProperty('valueKey') && destinationBinding.valueKey !== sourceBinding.valueKey) {
				valid = false;
			}
			if (destinationBinding.hasOwnProperty('childDataProperty') && sourceBinding.hasOwnProperty('childDataProperty') && destinationBinding.childDataProperty !== sourceBinding.childDataProperty) {
				valid = false;
			}
			return valid;
		},
		_initDragAndDrop: function (element) {
			var dragOptions = this._initDragOptions(),
				dropOptions = this._initDropOptions();
			if (!this._insertLine.html) {
				this._insertLine.html = '<div data-role="insert-line" class="' + this.css.insertLine + '"></div>';
			}
			if (!element) {
				this.element.find('li[data-role=node]').draggable(dragOptions);
				this.element.droppable(dropOptions);
			    // K.D. August 16th, 2013 Bug #149438 Switching to delegated events
				this.element.delegate('a', 'mousedown', function () {
					$(this).focus();
				});
			} else {
				element.draggable(dragOptions);
				element.find('li[data-role=node]').draggable(dragOptions);
			}
		},
		_destroyDragAndDrop: function () {
			this.element.find('li[data-role=node]').draggable('destroy');
			this.element.droppable('destroy');
			this.element.undelegate('a', 'mousedown');
		},
		_constructFromData: function () {
			var ul, data = this.options.dataSource._rootds.data(), self = this;
			this._triggerDataBound(data);
			this._triggerRendering(data);
			// K.D. Adding data-scroll attribute for igScroll (custom scrolling under touch environments)
			this.element.attr('data-scroll', true);

			if (this.element.is('ul')) {
				this.element.empty();
				ul = this.element;
				ul.addClass(this.css.treeCollection).addClass(this.css.treeRoot).attr('data-depth', 0);
				// K.D. June 4th, 2014 Bug #162878 WinJS compatibility for the igTree
				MSApp.execUnsafeLocalFunction(function () {
					ul.html(self._initChildrenRecursively('', data));
				});
				this._triggerRendered();
			} else {
				this.element.empty();
				ul = '<ul class="' + this.css.treeCollection + ' ' + this.css.treeRoot + '" data-depth="0">';
				ul += this._initChildrenRecursively('', data);
				ul += '</ul>';
				// K.D. June 4th, 2014 Bug #162878 WinJS compatibility for the igTree
				MSApp.execUnsafeLocalFunction(function () {
					$(ul).appendTo(self.element);
				});
				this._triggerRendered();
			}

			if (this.options.dragAndDrop) {
				this._initDragAndDrop();
				if (typeof this.options.dragAndDropSettings.customDropValidation === 'string') {
					// K.D. November 9th, 2012 Bug #126853 An exception is thrown in old IEs because the global object
					// does not have hasOwnProperty() defined on it.
					if (window[this.options.dragAndDropSettings.customDropValidation] && typeof window[this.options.dragAndDropSettings.customDropValidation] === 'function') {
						this.options.dragAndDropSettings.customDropValidation = window[this.options.dragAndDropSettings.customDropValidation];
					}
				}
			}
		},
		_attachEvents: function () {
			var self = this, css = this.css, noCancel, target;
		    // Bind expander
		    // K.D. August 16th, 2013 Bug #149438 Switching to delegated events
			this.element.delegate('span[data-role=expander]', 'click', function (event) {
				self.toggle($(event.target).closest('li[data-role=node]'), event);
			});
			// Bind anchor
			if (this.options.hotTracking) {
				this.element.delegate('a', {
					'click': function (event) {
						target = $(event.target).closest('a');
						noCancel = self._triggerNodeClick(event, target.parent());

						if (noCancel) {
							self.select(target.parent(), event);
							if ($.ig.util.isWebKit) {
								target.focus();
							}
						} else {
							event.preventDefault();
						}
					},
					'dblclick': function (event) {
						event.preventDefault();
						self._triggerNodeDoubleClick(event, $(event.target.parentNode));
					},
					'keydown': function (event) {
						self._kbNavigation(event);
					},
					'focus': function (event) {
						self._focusNode(event);
					},
					'blur': function (event) {
						self._blurNode(event);
					},
					'mouseover': function (event) {
						target = $(event.target).closest('a');
						target.addClass(css.nodeHovered);
					},
					'mouseout': function (event) {
						target = $(event.target).closest('a');
						target.removeClass(css.nodeHovered);
					}
				});
			} else {
			    // K.D. August 16th, 2013 Bug #149438 Switching to delegated events
				this.element.delegate('a', {
					'click': function (event) {
						target = $(event.target).closest('a');
						noCancel = self._triggerNodeClick(event, target.parent());

						if (noCancel) {
							self.select(target.parent(), event);
							if ($.ig.util.isWebKit) {
								target.focus();
							}
						} else {
							event.preventDefault();
						}
					},
					'dblclick': function (event) {
						event.preventDefault();
						self._triggerNodeDoubleClick(event, $(event.target.parentNode));
					},
					'keydown': function (event) {
						self._kbNavigation(event);
					},
					'focus': function (event) {
						self._focusNode(event);
					},
					'blur': function (event) {
						self._blurNode(event);
					}
				});
			}
		    // Bind checkbox
		    // K.D. August 16th, 2013 Bug #149438 Switching to delegated events
			this.element.delegate('span[data-role=checkbox] > span', {
				'click': function (event) {
					self.toggleCheckstate($(event.target).closest('li[data-role=node]'), event);
				},
				'mouseover': function (event) {
					$(event.target).closest('span[data-role=checkbox]').addClass(css.nodeHovered);
				},
				'mouseout': function (event) {
					$(event.target).closest('span[data-role=checkbox]').removeClass(css.nodeHovered);
				}
			});
		},
		_initChildrenRecursively: function (path, data, depth, checkFlag, indexFeed) {
			var childUl, opt = this.options, childPath, binding, value, display, liStr = [], i = 0, li, children;

			if (!indexFeed) {
				indexFeed = 0;
			}
			// Applying binding according to depth
			if (!depth) {
				depth = 0;
			}
			binding = this._retrieveCurrentDepthBinding(depth);
			if (!data.hasOwnProperty('length') && data.hasOwnProperty(binding.textKey)) {
				data = [data];
			}
			for (i; i < data.length; i++) {
				childUl = '';
				value = '';
				if (path.length <= 0) {
					if (binding.hasOwnProperty('primaryKey') && data[i].hasOwnProperty(binding.primaryKey)) {
						childPath = typeof data[i][binding.primaryKey] === 'function' ? data[i][binding.primaryKey]() : data[i][binding.primaryKey];
					} else {
						childPath =  i + indexFeed;
					}
				} else {
					if (binding.hasOwnProperty('primaryKey') && data[i].hasOwnProperty(binding.primaryKey)) {
						childPath = path + opt.pathSeparator + (typeof data[i][binding.primaryKey] === 'function' ? data[i][binding.primaryKey]() : data[i][binding.primaryKey]);
					} else {
						childPath = path + opt.pathSeparator + (i + indexFeed);
					}
				}
				if (binding.hasOwnProperty('valueKey') && data[i].hasOwnProperty(binding.valueKey)) {
					if (typeof data[i][binding.valueKey] === 'function') {
						value = data[i][binding.valueKey]();
					} else {
						value = data[i][binding.valueKey];
					}
				}
				li = '<li class="' + this._buildNodeCssString(data[i], depth, binding) + '" data-path="' + childPath + '" data-value="' + value + '" data-role="node">';

				children = data[i][binding.childDataProperty];
				if (typeof children === 'function') {
					children = children();
				}
				if ((children && children.length > 0) || (children && opt.loadOnDemand)) {
					if ((depth <= opt.initialExpandDepth && !opt.loadOnDemand) || (binding.hasOwnProperty('expandedKey') && data[i].hasOwnProperty(binding.expandedKey) && data[i][binding.expandedKey])) {
						li += this._renderExpanderImage(true);
						display = 'block';
					} else {
						li += this._renderExpanderImage(false);
						display = 'none';
					}
				}

				if (opt.checkboxMode && opt.checkboxMode.toLowerCase() !== 'off') {
					li += this._renderCheckbox(checkFlag);
				}
				li += this._renderNodeImage(data[i], binding);
				if (!binding.nodeContentTemplate) {
					li += this._renderAnchor(data[i], binding);
				} else {
					li += this._renderNodeTemplate(data[i], binding);
				}

				if ((children && children.length > 0) || (children && opt.loadOnDemand)) {
					childUl = '<ul style="display: ' + display + '" data-depth="' + (depth + 1) + '"';
					if (children.length > 0 && !opt.loadOnDemand) {
						childUl += '>' + this._initChildrenRecursively(childPath, children, depth + 1, checkFlag);
					} else {
						childUl += ' data-populated="false">';
					}
					childUl += '</ul>';
				}
				li += childUl;
				li += '</li>';
				liStr.push(li);
			}
			return liStr.join('');
		},
		_buildNodeCssString: function (data, depth, binding) {
			var css = this.css, str = css.treeNode, children;
			if (depth === 0) {
				str += ' ' + css.treeRootNode;
			}
			children = data[binding.childDataProperty];
			if (typeof children === 'function') {
				children = children();
			}
			if ((children && children.length > 0) || (children && this.options.loadOnDemand)) {
				str += ' ' + css.parentNode;
			} else {
				str += ' ' + css.nodeNoChildren;
			}
			return str;
		},
		_retrieveCurrentDepthBinding: function (depth) {
			var binding = this.options.bindings, i = 0;
			for (i; i < depth; i++) {
				if (binding.hasOwnProperty('bindings')) {
					binding = binding.bindings;
				} else {
					break;
				}
			}
			return binding;
		},
		_renderExpanderImage: function (expanded) {
			var self = this, css = self.css, expander = '';

			if (expanded) {
				expander = '<span data-role="expander" data-exp="true" class="' + css.collapseIcon + ' ' + css.nodeExpander + '"></span>';
			} else {
				expander = '<span data-role="expander" data-exp="false" class="' + css.expandIcon + ' ' + css.nodeExpander + '"></span>';
			}
			return expander;
		},
		_renderAnchor: function (data, binding) {
			var href, target, text;

			if (binding.hasOwnProperty('navigateUrlKey') && data[binding.navigateUrlKey]) {
				if (typeof data[binding.navigateUrlKey] === 'function') {
					href = data[binding.navigateUrlKey]();
				} else if (data[binding.navigateUrlKey].length <= 0) {
					href = '#';
				} else {
					href = data[binding.navigateUrlKey];
				}
			} else {
				href = '#';
			}

			if (binding.targetKey && binding.targetKey.length > 0 && data.hasOwnProperty(binding.targetKey)) {
				target = data[binding.targetKey];
			} else {
				target = this.options.defaultNodeTarget;
			}

			if (typeof data[binding.textKey] === 'function') {
				text = data[binding.textKey]();
			} else {
				text = data[binding.textKey];
			}

			return '<a href="' + href + '" target="' + target + '" class="' + this.css.nodeAnchor + '">' + text + '</a>';
		},
		_renderNodeTemplate: function (data, binding) {
			var div = $('<div></div>'), html, href, target, template = binding.nodeContentTemplate;
			// K.D. July 30th, 2013 Bug #148135 navigateURL non-responsive when nodeContentTemplate is set
			if (binding.hasOwnProperty('navigateUrlKey') && data[binding.navigateUrlKey]) {
				if (typeof data[binding.navigateUrlKey] === 'function') {
					href = data[binding.navigateUrlKey]();
				} else if (data[binding.navigateUrlKey].length <= 0) {
					href = '#';
				} else {
					href = data[binding.navigateUrlKey];
				}
			} else {
				href = '#';
			}
			if (binding.targetKey && binding.targetKey.length > 0 && data.hasOwnProperty(binding.targetKey)) {
				target = data[binding.targetKey];
			} else {
				target = this.options.defaultNodeTarget;
			}
			// K.D. February 14th, 2012 There needs to be a default case in which the html is simply the content of the div
			// without any manipulations
			div.html($.ig.tmpl(template, data));
			if (div.children('a').length <= 0) {
				html = '<a href="' + href + '" target="' + target + '" class="' + this.css.nodeAnchor + '">' + div.html() + '</a>';
			} else if (!div.children('a').attr('href')) {
				div.children('a').addClass(this.css.nodeAnchor).attr({
					href: href,
					target: target
				});
				html = div.html();
			} else {
				div.children('a').addClass(this.css.nodeAnchor);
				html = div.html();
			}
			return html;
		},
		_renderCheckbox: function (checkFlag) {
			var self = this, css = self.css;
			return '<span data-chk="' + (checkFlag ? 'on' : 'off') + '" data-role="checkbox" class="' + css.checkbox + '"><span class="' + (checkFlag ? css.checkboxOn : css.checkboxOff) + '"></span></span>';
		},
		_renderNodeImage: function (data, binding) {
			var opt = this.options, hasChildren, img = '', src;

			hasChildren = (data[binding.childDataProperty] && data[binding.childDataProperty].length > 0) || (data[binding.childDataProperty] && opt.loadOnDemand);

			if (binding.hasOwnProperty('imageUrlKey') && data.hasOwnProperty(binding.imageUrlKey)) {
				if (typeof data[binding.imageUrlKey] === 'function') {
					src = data[binding.imageUrlKey]();
					if (src && src.length > 0) {
						img = '<img src="' + src + '" alt="error" data-role="node-image" />';
					}
				} else if (data[binding.imageUrlKey].length > 0) {
					img = '<img src="' + data[binding.imageUrlKey] + '" alt="error" data-role="node-image" />';
				}
			}
			if (opt.parentNodeImageUrl && hasChildren) {
				img += '<img src="' + opt.parentNodeImageUrl + '" alt="error" title="' + (opt.parentNodeImageTooltip !== null ? opt.parentNodeImageTooltip : '') + '" data-role="parent-node-image" />';
			} else if (opt.parentNodeImageClass && hasChildren) {
				img += '<span title="' + (opt.parentNodeImageTooltip !== null ? opt.parentNodeImageTooltip : '') + '" class="' + opt.parentNodeImageClass + '" data-role="parent-node-image"></span>';
			} else if (!hasChildren && opt.leafNodeImageUrl) {
				img += '<img src="' + opt.leafNodeImageUrl + '" alt="error" title="' + (opt.leafNodeImageTooltip !== null ? opt.leafNodeImageTooltip : '') + '" data-role="leaf-node-image" />';
			} else if (!hasChildren && opt.leafNodeImageClass) {
				img += '<span title="' + (opt.leafNodeImageTooltip !== null ? opt.leafNodeImageTooltip : '') + '" class="' + opt.leafNodeImageClass + '" data-role="leaf-node-image"></span>';
			}
			return img;
		},
		_focusNode: function (event) {
			$(event.target).addClass(this.css.nodeActive);
		},
		_blurNode: function (event) {
			$(event.target).removeClass(this.css.nodeActive);
		},
		_kbNavigation: function (event) {
			var opt = this.options, css = this.css, li = $(event.target.parentNode), nextLi, seq = li.index(), expander;

			if (event.keyCode === $.ui.keyCode.UP) {
				nextLi = this._nextVisibleNodeUp(li);
				if (!nextLi) {
					return;
				}

				if (event.ctrlKey) {
					// K.D. December 14th, 2011 Bug #85068 jQuery 1.4.4 does not trigger blur when 
					// calling focus so I'm calling it manually
					li.children('a').blur();
					nextLi.children('a').focus();
				} else {
					// K.D. December 14th, 2011 Bug #85068 jQuery 1.4.4 does not trigger blur when 
					// calling focus so I'm calling it manually
					li.children('a').blur();
					nextLi.children('a').focus();
					this.select(nextLi, null);
				}
				event.preventDefault();
			} else if (event.keyCode === $.ui.keyCode.DOWN) {
				nextLi = this._nextVisibleNodeDown(li, seq);
				if (!nextLi) {
					return;
				}

				if (event.ctrlKey) {
					// K.D. December 14th, 2011 Bug #85068 jQuery 1.4.4 does not trigger blur when 
					// calling focus so I'm calling it manually
					li.children('a').blur();
					nextLi.children('a').focus();
				} else {
					// K.D. December 14th, 2011 Bug #85068 jQuery 1.4.4 does not trigger blur when 
					// calling focus so I'm calling it manually
					li.children('a').blur();
					nextLi.children('a').focus();
					this.select(nextLi, null);
				}
				event.preventDefault();
			} else if (event.keyCode === $.ui.keyCode.RIGHT) {
				if (li.children('ul').length > 0) {
					expander = li.children('.' + css.nodeExpander);
					if (!expander.attr('data-exp') || expander.attr('data-exp') === 'false') {
						this.toggle(li, null);
					} else {
						nextLi = li.find('ul > li:first');
						if (nextLi.length > 0) {
							if (event.ctrlKey) {
								// K.D. December 14th, 2011 Bug #85068 jQuery 1.4.4 does not trigger blur when 
								// calling focus so I'm calling it manually
								li.children('a').blur();
								nextLi.children('a').focus();
							} else {
								// K.D. December 14th, 2011 Bug #85068 jQuery 1.4.4 does not trigger blur when 
								// calling focus so I'm calling it manually
								li.children('a').blur();
								nextLi.children('a').focus();
								this.select(nextLi, null);
							}
						}
					}
				}
			} else if (event.keyCode === $.ui.keyCode.LEFT) {
				expander = li.children('.' + css.nodeExpander);
				if (expander.attr('data-exp') && expander.attr('data-exp') !== 'false') {
					this.toggle(li, null);
				} else if (li.parent().parent().is('li')) {
					nextLi = li.parent().parent();
					if (event.ctrlKey) {
						// K.D. December 14th, 2011 Bug #85068 jQuery 1.4.4 does not trigger blur when 
						// calling focus so I'm calling it manually
						li.children('a').blur();
						nextLi.children('a').focus();
					} else {
						// K.D. December 14th, 2011 Bug #85068 jQuery 1.4.4 does not trigger blur when 
						// calling focus so I'm calling it manually
						li.children('a').blur();
						nextLi.children('a').focus();
						this.select(nextLi, null);
					}
				}
			} else if (event.keyCode === $.ui.keyCode.NUMPAD_ADD) {
				if (li.children('ul').length > 0) {
					expander = li.children('.' + css.nodeExpander);
					if (!expander.attr('data-exp') || expander.attr('data-exp') === 'false') {
						this.toggle(li, null);
					}
				}
			} else if (event.keyCode === $.ui.keyCode.NUMPAD_SUBTRACT) {
				if (li.children('ul').length > 0) {
					expander = li.children('.' + css.nodeExpander);
					if (expander.attr('data-exp') && expander.attr('data-exp') !== 'false') {
						this.toggle(li, null);
					}
				}
			} else if (event.keyCode === $.ui.keyCode.SPACE) {
				if (opt.checkboxMode && opt.checkboxMode.toLowerCase() !== 'off') {
					this.toggleCheckstate(li, null);
					event.preventDefault();
					event.stopPropagation();
				}
			} else if (event.keyCode === $.ui.keyCode.HOME) {
				// K.D. December 14th, 2011 Bug #85068 jQuery 1.4.4 does not trigger blur when 
				// calling focus so I'm calling it manually
				li.children('a').blur();
				li = this.element.find('li:first');
				if (li.length > 0) {
					li.children('a').focus();
					this.select(li);
				}
				event.preventDefault();
			} else if (event.keyCode === $.ui.keyCode.END) {
				// K.D. December 14th, 2011 Bug #85068 jQuery 1.4.4 does not trigger blur when 
				// calling focus so I'm calling it manually
				li.children('a').blur();
				li = this._lastVisibleNode();
				if (li) {
					li.children('a').focus();
					this.select(li);
				}
				event.preventDefault();
			}
		},
		_nextVisibleNodeDown: function (node, nodeSeq) {
			var expander = node.children('.' + this.css.nodeExpander), parentLi, seq = nodeSeq, result = null;

			if (expander.length > 0 && expander.attr('data-exp') && expander.attr('data-exp') !== 'false' && node.children('ul').children('li:first').length > 0) {
				return node.children('ul').children('li:first');
			}

			if (seq === node.siblings().length) {
				parentLi = node.parent().parent();
				while (parentLi.is('li')) {
					seq = parentLi.index();
					if (seq !== parentLi.siblings().length) {
						result = parentLi.next();
						break;
					}
					parentLi = parentLi.parent().parent();
				}
			} else {
				result = node.next();
			}
			return result;
		},
		_nextVisibleNodeUp: function (node) {
			var li = node.prev(), expander, result = null;

			if (li.length <= 0) {
				if (node.parent().parent().is('li')) {
					result = node.parent().parent();
				}
			} else {
				while (li.length > 0) {
					expander = li.children('.' + this.css.nodeExpander);
					if (li.children('ul').children('li').length <= 0 || !expander.attr('data-exp') || expander.attr('data-exp') === 'false') {
						result = li;
						break;
					}
					li = li.children('ul').children('li:last');
				}
			}
			return result;
		},
		_lastVisibleNode: function () {
			var li = this.element.is('ul') ? this.element.children('li:last') : this.element.children('ul').children('li:last'), expander, result;

			if (li.length <= 0) {
				result = null;
			} else {
				while (li.length > 0) {
					expander = li.children('.' + this.css.nodeExpander);
					if (li.children('ul').children('li').length <= 0 || !expander.attr('data-exp') || expander.attr('data-exp') === 'false') {
						result = li;
						break;
					}
					li = li.children('ul').children('li:last');
				}
			}
			return result;
		},
		_populatingNode: null,
		_populateNodeData: function (success, msg, data) {
			if (!success) {
				throw new Error($.ig.Tree.locale.errorOnRequest + msg);
			}
			var ul = this._populatingNode.ul, node = this._populatingNode.node, originalData = this.nodeDataFor(node.attr('data-path')), depth = ul.attr('data-depth'), binding = this._retrieveCurrentDepthBinding(depth - 1), checked, newData = data.data();

			if (this.options.checkboxMode.toLowerCase() === 'tristate') {
				checked = this.isChecked(node);
			}

		    // Clear the loading indicator space
		    // K.D. August 16th, 2013 Bug #149438 Keeping the already rendered nodes and rendering the loaded ones after
			ul.children('li[data-role="loading"]').remove();
			if (!originalData[binding.childDataProperty] || !originalData[binding.childDataProperty].length) {
				originalData[binding.childDataProperty] = newData;
			} else {
				originalData[binding.childDataProperty] = originalData[binding.childDataProperty].concat(newData);
			}
			this._triggerNodePopulated(null, node);
			// K.D. November 23rd, 2011 Bug #96609 The data should be extracted from the datasource before sent to the event trigger
			this._triggerRendering(newData);
		    // K.D. August 16th, 2013 Bug #149438 Keeping the already rendered nodes and rendering the loaded ones after
			ul.append(this._initChildrenRecursively(node.attr('data-path'), newData, parseInt(ul.attr('data-depth'), 10), checked));
			ul.attr('data-populated', true);
			if (this.options.dragAndDrop) {
				this._initDragAndDrop(ul);
			}
			this._triggerRendered();
			this._populatingNode.indicator.hide();
			this._populatingNode.indicator.destroy();
			this._populatingNode = null;
			this.toggle(node);
			// K.D. December 15th, 2014 Bug #186563 After expand the load queue should be synced for expanding to node with LOD 
			this._loadRequest();
		},
		_prepareRequest: function (node, event) {
			var opt = this.options, pathKeyArr, path, key, data, binding, parentBinding, noCancel;

			if (this._populatingNode !== null) {
				return;
			}

			noCancel = this._triggerNodePopulating(event, node);
			if (noCancel) {
				pathKeyArr = this._buildRequestString(node);
				binding = this._retrieveCurrentDepthBinding(parseInt(node.children('ul').attr('data-depth'), 10));
				if (!pathKeyArr) {
					return;
				}
				path = pathKeyArr[0];
				key = pathKeyArr[1];

				data = this.nodeDataFor(node.attr('data-path'));
				parentBinding = this._retrieveCurrentDepthBinding(parseInt(node.children('ul').attr('data-depth'), 10) - 1);
				if (data.hasOwnProperty(parentBinding.childDataProperty)) {
					data = data[parentBinding.childDataProperty];
				}
				if (data && data.__deferred && data.__deferred.uri) {
					this._executeODataRequest(node, data);
				} else if (data && data.length > 0 && !opt.dataSourceUrl) {
					this._renderOnDemand(node, data);
				} else {
					this._executeUrlRequest(node, binding, path, key);
				}
			}
		},
		_executeODataRequest: function (node, data) {
			var dataSource, ul, indicator, opt = this.options, li;
			dataSource = new $.ig.JSONPDataSource({dataSource: data.__deferred.uri + '?$format=json&$callback=?', responseDataKey: opt.responseDataKey});
			ul = node.children('ul');
			// Create loading indicator space
			li = $('<li style="width: 20px" data-role="loading">&nbsp;</li>').appendTo(ul);
			ul.show();
			// K.D. December 19th, 2011 Bug #98217 Adding flag pointing that the loading indicator is instantiated by the tree
			indicator = li.igLoading({ includeVerticalOffset: false }).data('igLoading').indicator();
			indicator.show();
			this._populatingNode = {
				ul: ul,
				node: node,
				indicator: indicator
			};
			dataSource.dataBind(this._populateNodeData, this);
		},
		_renderOnDemand: function (node, data) {
			var ul, checked;
			ul = node.children('ul');
			if (this.options.checkboxMode.toLowerCase() === 'tristate') {
				checked = this.isChecked(node);
			}
			this._triggerNodePopulated(null, node);
			this._triggerRendering(data);
			// K.D. November 4th, 2013 Bug #156776 When we have render on demand and drag and drop we need to clear the container
			// because we've added the data to the data source and we've rendered an item upon drop and thus we end up with two 
			// items when we pass through this method
			ul.html(this._initChildrenRecursively(node.attr('data-path'), data, parseInt(ul.attr('data-depth'), 10), checked));
			ul.attr('data-populated', true);
			if (this.options.dragAndDrop) {
				this._initDragAndDrop(ul);
			}
			this._triggerRendered();
			this.toggle(node);
			// K.D. December 15th, 2014 Bug #186563 After expand the load queue should be synced for expanding to node with LOD 
			this._loadRequest();
		},
		_executeUrlRequest: function (node, binding, path, key) {
			var opt = this.options, ul, indicator, dataSource, li;
			if (opt.dataSourceUrl && opt.dataSourceUrl.lastIndexOf('?') === -1) {
				opt.dataSourceUrl += '?';
			} else if (!opt.dataSourceUrl) {
				throw new Error($.ig.Tree.locale.noDataSourceUrl);
			}
			dataSource = new $.ig.DataSource({dataSource: opt.dataSourceUrl + '&' + this._encodeUrlPath(path, key) + '&' + this._encodeBinding(binding) + '&depth=' + node.parent().attr('data-depth'), dataSourceType: 'remoteUrl'});
			ul = node.children('ul');
			// Create loading indicator space
			li = $('<li style="width: 20px" data-role="loading">&nbsp;</li>').appendTo(ul);
			ul.show();
			// K.D. December 19th, 2011 Bug #98217 Adding flag pointing that the loading indicator is instantiated by the tree
			indicator = li.igLoading({ includeVerticalOffset: false }).data('igLoading').indicator();
			indicator.show();
			this._populatingNode = {
				ul: ul,
				node: node,
				indicator: indicator
			};
			dataSource.dataBind(this._populateNodeData, this);
		},
		_buildRequestString: function (node) {
			var nodePath, key = '', path = '', binding = this.options.bindings, i, result;

			nodePath = node.attr('data-path').split(this.options.pathSeparator);
			for (i = 0; i < nodePath.length; i++) {
				if (key.length > 0) {
					key += '/';
				}
				key += binding.childDataProperty;
				if (path.length > 0) {
					path += '/';
				}
				path += (binding.primaryKey ? binding.primaryKey + ':' : '') + nodePath[i];
				if (binding.bindings) {
					binding = binding.bindings;
				}
			}
			if (path.length <= 0) {
				result = null;
			} else {
				result = [path, key];
			}
			return result;
		},
		_encodeBinding: function (binding) {
			var temp = 'binding=', item;

			for (item in binding) {
				if (binding.hasOwnProperty(item) && item !== 'bindings' && item !== 'nodeContentTemplate') {
					temp += item.toString() + ':' + binding[item] + ',';
				}
			}
			temp = temp.substr(0, temp.length - 1);
			return temp;
		},
		_encodeUrlPath: function (path, key) {
			var result;
			if (path.lastIndexOf('/') === -1) {
				path += '/@' + key;
				result = 'path=' + path;
			} else {
				result = 'path=' + path.substr(path.lastIndexOf('/') + 1, path.length) + '/@' + key.substr(key.lastIndexOf('/') + 1, key.length);
			}
			return result;
		},
		_updateParentState: function (parent) {
			var expander = parent.children('span[data-role=expander]');
			// Render expander image if this is the first add operation on a leaf node
			if (expander.length <= 0) {
				parent.removeClass(this.css.nodeNoChildren).addClass(this.css.parentNode);
				// K.D. September 24th, 2013 Bug #152109 Expanding the deleted items causes the tree to collapse
				$(this._renderExpanderImage(false)).prependTo(parent);
			} else if (parent.children('ul').children('li').length <= 0) {// Last child has been deleted
				parent.removeClass(this.css.parentNode).addClass(this.css.nodeNoChildren);
				parent.children('ul').remove();
				expander.remove();
			}
			this._updateImage(parent);
		},
		_updateParentCheckbox: function (parent) {
			var checkbox = parent.children('span[data-role=checkbox]'), checkIcon = checkbox.children('span'), checkState = checkbox.attr('data-chk'), shouldBe, checkCount = 0, css = this.css;
			parent.children('ul').children('li').each(function () {
				if ($(this).children('span[data-role=checkbox]').attr('data-chk') === 'on') {
					checkCount++;
				}
			});
			if (checkCount === 0) {
				shouldBe = 'off';
			} else if (checkCount === parent.children('ul').children('li').length) {
				shouldBe = 'on';
			} else {
				shouldBe = 'partial';
			}
			if (checkState !== shouldBe) {
				checkbox.attr('data-chk', shouldBe);
				switch (shouldBe) {
				case 'off':
					checkIcon.removeClass(css.checkboxOn).removeClass(css.checkboxPartial).addClass(css.checkboxOff);
					break;
				case 'partial':
					checkIcon.removeClass(css.checkboxOn).removeClass(css.checkboxOff).addClass(css.checkboxPartial);
					break;
				case 'on':
					checkIcon.removeClass(css.checkboxPartial).removeClass(css.checkboxOff).addClass(css.checkboxOn);
					break;
				default:
					checkIcon.removeClass(css.checkboxOn).removeClass(css.checkboxPartial).addClass(css.checkboxOff);
				}
				parent = this.parentNode(parent);
				if (parent) {
					this._updateParentCheckbox(parent);
				}
			}
		},
		_updateImage: function (parent) {
			var hasChildren = parent.children('ul').children('li').length > 0, opt = this.options, img;
			if (!hasChildren) {
				if (opt.leafNodeImageUrl) {
					img = parent.children('img[data-role=parent-node-image]');
					if (img.length > 0) {
						img.attr('title', (opt.leafNodeImageTooltip !== null ? opt.leafNodeImageTooltip : ''));
						img.attr('src', opt.leafNodeImageUrl);
						img.attr('data-role', 'leaf-node-image');
					}
				} else if (opt.leafNodeImageClass) {
					img = parent.children('span[data-role=parent-node-image]');
					if (img.length > 0) {
						img.attr('title', (opt.leafNodeImageTooltip !== null ? opt.leafNodeImageTooltip : ''));
						img.removeClass(opt.parentNodeImageClass).addClass(opt.leafNodeImageClass);
						img.attr('data-role', 'leaf-node-image');
					}
				}
			} else {
				if (opt.parentNodeImageUrl) {
					img = parent.children('img[data-role=leaf-node-image]');
					if (img.length > 0) {
						img.attr('title', (opt.parentNodeImageTooltip !== null ? opt.parentNodeImageTooltip : ''));
						img.attr('src', opt.parentNodeImageUrl);
						img.attr('data-role', 'parent-node-image');
					}
				} else if (opt.parentNodeImageClass) {
					img = parent.children('span[data-role=leaf-node-image]');
					if (img.length > 0) {
						img.attr('title', (opt.parentNodeImageTooltip !== null ? opt.parentNodeImageTooltip : ''));
						img.removeClass(opt.leafNodeImageClass).addClass(opt.parentNodeImageClass);
						img.attr('data-role', 'parent-node-image');
					}
				}
			}
		},
		_addData: function (data, path, depth, dataIndex) {
			var originalData = this.nodeDataFor(path),
				binding = this._retrieveCurrentDepthBinding(depth),
				temp,
				i;
			if (!binding.hasOwnProperty('primaryKey')) {
				if (!originalData) {
					if (this.options.dataSource._rootds._data.length <= this.element.find('.ui-igtree-noderoot').length || this.element.find('.ui-igtree-noderoot').length <= 0) {
						if (dataIndex === 0) {
							if ($.type(data) === 'array') {
								this.options.dataSource._rootds._data = data.concat(this.options.dataSource._rootds._data);
							} else {
								this.options.dataSource._rootds._data = [data].concat(this.options.dataSource._rootds._data);
							}
						} else if (!dataIndex) {
							if ($.type(data) === 'array') {
								for (i = 0; i < data.length; i++) {
									this.options.dataSource._rootds._data.push(data[i]);
								}
							} else {
								this.options.dataSource._rootds._data.push(data);
							}
						} else {
							this.options.dataSource._rootds._data.splice(dataIndex, 0, data);
						}
					}
				} else {
					if (typeof originalData[binding.childDataProperty] !== 'function') {
						// K.D. November 14th, 2014 Bug #185180 In some cases the child data prop is an empty object and it should be made an array.
						if (!originalData.hasOwnProperty(binding.childDataProperty) || $.type(originalData[binding.childDataProperty]) !== "array") {
							originalData[binding.childDataProperty] = [];
						}
						if (dataIndex === 0) {
							if ($.type(data) === 'array') {
								originalData[binding.childDataProperty] = data.concat(originalData[binding.childDataProperty]);
							} else {
								originalData[binding.childDataProperty] = [data].concat(originalData[binding.childDataProperty]);
							}
						} else if (!dataIndex) {
							originalData[binding.childDataProperty] = originalData[binding.childDataProperty].concat(data);
						} else {
							temp = originalData[binding.childDataProperty].slice(0, dataIndex);
							temp = temp.concat(data);
							originalData[binding.childDataProperty] = temp.concat(originalData[binding.childDataProperty].slice(dataIndex));
						}
					} else {
						if (originalData[binding.childDataProperty]().length <= this.nodeByPath(path).children('ul').children('li').length) {
							if (dataIndex === 0) {
								temp = $('<li></li>').appendTo(this.nodeByPath(path).children('ul'));
								originalData[binding.childDataProperty].unshift(data);
								temp.remove();
							} else if (!dataIndex) {
								temp = $('<li></li>').appendTo(this.nodeByPath(path).children('ul'));
								originalData[binding.childDataProperty].push(data);
								temp.remove();
							} else {
								temp = $('<li></li>').appendTo(this.nodeByPath(path).children('ul'));
								originalData[binding.childDataProperty]().splice(dataIndex, 0, data);
								temp.remove();
							}
						}
					}
				}
			} else {
				if (!originalData) {
					if (this.options.dataSource._rootds._data.length <= this.element.find('.ui-igtree-noderoot').length || this.element.find('.ui-igtree-noderoot').length <= 0) {
						if ($.type(data) === 'array') {
							for (i = 0; i < data.length; i++) {
								this.options.dataSource._rootds._data.push(data[i]);
							}
						} else {
							this.options.dataSource._rootds._data.push(data);
						}
					}
				} else {
					if (typeof originalData[binding.childDataProperty] !== 'function') {
						// K.D. November 14th, 2014 Bug #185180 In some cases the child data prop is an empty object and it should be made an array.
						if (!originalData.hasOwnProperty(binding.childDataProperty) || $.type(originalData[binding.childDataProperty]) !== "array") {
							originalData[binding.childDataProperty] = [];
						}
						originalData[binding.childDataProperty] = originalData[binding.childDataProperty].concat(data);
					} else {
						if (originalData[binding.childDataProperty]().length <= this.nodeByPath(path).children('ul').children('li').length) {
							temp = $('<li></li>').appendTo(this.nodeByPath(path).children('ul'));
							originalData[binding.childDataProperty].push(data);
							temp.remove();
						}
					}
				}
			}
		},
		_removeData: function (path) {
			var splitPath = path.split(this.options.pathSeparator), data = this.options.dataSource._rootds.data(), i, j, binding = this.options.bindings, key;

			if (splitPath.length === 1) {
				if (!binding.hasOwnProperty('primaryKey')) {
					data.splice(parseInt(splitPath[0], 10), 1);
				} else {
					for (j = 0; j < data.length; j++) {
						if (data[j].hasOwnProperty(binding.primaryKey)) {
							key = typeof data[j][binding.primaryKey] === 'function' ? data[j][binding.primaryKey]() : data[j][binding.primaryKey];
							if (key.toString() === splitPath[0].toString()) {
								data.splice(j, 1);
								break;
							}
						}
					}
				}
				return;
			}
			for (i = 0; i < splitPath.length - 1; i++) {
				if (!binding.hasOwnProperty('primaryKey')) {
					data = data[parseInt(splitPath[i], 10)];
				} else {
					for (j = 0; j < data.length; j++) {
						if (data[j].hasOwnProperty(binding.primaryKey)) {
							key = typeof data[j][binding.primaryKey] === 'function' ? data[j][binding.primaryKey]() : data[j][binding.primaryKey];
							if (key.toString() === splitPath[i].toString()) {
								data = data[j];
								break;
							}
						}
					}
				}
				if (i < splitPath.length - 2) {
					if (data[binding.childDataProperty] && typeof data[binding.childDataProperty] === 'function') {
						data = data[binding.childDataProperty]();
					} else {
						data = data[binding.childDataProperty];
					}
				}
				if (binding.hasOwnProperty('bindings') && i < splitPath.length - 2) {
					binding = binding.bindings;
				}
			}
			if (data[binding.childDataProperty] && typeof data[binding.childDataProperty] !== 'function') {
				if (data[binding.childDataProperty] && data[binding.childDataProperty].length <= 1) {
					delete data[binding.childDataProperty];
				} else {
					data = data[binding.childDataProperty];
					if (binding.hasOwnProperty('bindings')) {
						binding = binding.bindings;
					}
					if (!binding.hasOwnProperty('primaryKey') && data.length) {
						data.splice(parseInt(splitPath[splitPath.length - 1], 10), 1);
					} else {
						for (j = 0; j < data.length; j++) {
							if (data[j].hasOwnProperty(binding.primaryKey) && data[j][binding.primaryKey].toString() === splitPath[i].toString()) {
								data.splice(j, 1);
								break;
							}
						}
					}
				}
			} else {
				data = data[binding.childDataProperty]();
				if (binding.hasOwnProperty('bindings')) {
					binding = binding.bindings;
				}
				if (!binding.hasOwnProperty('primaryKey') && data.length) {
					data.splice(parseInt(splitPath[splitPath.length - 1], 10), 1);
				} else {
					for (j = 0; j < data.length; j++) {
						if (data[j].hasOwnProperty(binding.primaryKey)) {
							key = typeof data[j][binding.primaryKey] === 'function' ? data[j][binding.primaryKey]() : data[j][binding.primaryKey];
							if (key.toString() === splitPath[splitPath.length - 1].toString()) {
								data.splice(j, 1);
								break;
							}
						}
					}
				}
			}
		},
		_recalculatePaths: function (path) {
			var splitPath = path.split(this.options.pathSeparator), index = path.length > 0 ? splitPath[splitPath.length - 1] : 0, node, parentPath, newPath, ul, child;
			if (splitPath.length > 1) {
				splitPath.splice(splitPath.length - 1, 1);
				parentPath = splitPath.join(this.options.pathSeparator);
				node = this.nodeByPath(parentPath);
				for (index; index < node.children('ul').children('li').length; index++) {
					newPath = parentPath + this.options.pathSeparator + index;
					child = $(node.children('ul').children('li')[index]);
					child.attr('data-path', newPath);
					if (child.children('ul').length > 0 && child.children('ul').children('li').length > 0) {
						this._recalculatePaths(newPath + this.options.pathSeparator + '0');
					}
				}
			} else {
				ul = this.element.is('ul') ? this.element : this.element.children('ul');
				for (index; index < ul.children('li').length; index++) {
					child = $(ul.children('li')[index]);
					child.attr('data-path', index);
					if (child.children('ul').length > 0 && child.children('ul').children('li').length > 0) {
						this._recalculatePaths(index + this.options.pathSeparator + '0');
					}
				}
			}
		},
		// K.D. November 22nd, 2012 Implementing a request chain for expandToNode with Load on Demand
		_loadQueue: null,
		_toSelect: false,
		_triggerChainRequest: function (path, toSelect) {
			var list = path.split(this.options.pathSeparator), i, newPath = '';
			if (this._loadQueue === null) {
				this._loadQueue = [];
			}
			if (toSelect) {
				this._toSelect = true;
			}
			for (i = 0; i < list.length; i++) {
				newPath += list[i];
				this._loadQueue.push(newPath);
				newPath += this.options.pathSeparator;
			}
			this._loadRequest();
		},
		_loadRequest: function () {
			var node;
			if (this._populatingNode === null) {
				if (this._loadQueue && this._loadQueue.length > 0) {
					node = this.nodeByPath(this._loadQueue.shift());
					if (this._loadQueue.length > 0) {
						if (!this.isExpanded(node)) {
							this.toggle(node);
						} else {
							this._loadRequest();
						}
					} else if (this._toSelect) {
						this.select(node);
						this._toSelect = false;
					}
				}
			}
		},
		_replaceUIValue: function (node, data, item) {
			var element = node.element, binding = this._retrieveCurrentDepthBinding(parseInt(element.parent().attr('data-depth'), 10)), value, isFocused, anchor;
			// K.D. August 15th, 2013 Bug #149367 The member does not necessarily need to be observable
			switch (item) {
			    case binding.textKey:
                // K.D. June 25th, 2014 Bug #173722 Adding handling for templates
				if (!binding.nodeContentTemplate) {
					value = typeof data[item] === 'function' ? data[item]() : data[item];
					element.children('a').text(value);
				} else {
					// K.D. August 4th, 2015 Bug #203489 When nodeContentTemplate is defined, a node at the current level loses selected and focused state after
					// changes have been applied to it.
					anchor = element.children('a');
					if (anchor.hasClass(this.css.nodeActive)) {
						isFocused = true;
					}
					anchor.replaceWith(this._renderNodeTemplate(data, binding));
					if (this.isSelected(element)) {
						element.children('a').addClass(this.css.nodeSelected);
						this._selectedNode[0] = this.nodeFromElement(element);
					}
					if (isFocused) {
						element.children('a').focus();
					}
				}
				break;
			case binding.valueKey:
				value = typeof data[item] === 'function' ? data[item]() : data[item];
				element.attr('data-value', value);
				break;
			case binding.navigateUrlKey:
				value = typeof data[item] === 'function' ? data[item]() : data[item];
				element.children('a').attr('href', value);
				break;
			case binding.imageUrlKey:
				value = typeof data[item] === 'function' ? data[item]() : data[item];
				element.children('img[data-role=node-image]').attr('src', value);
				break;
			}
		},
		dataBind: function () {
			/* Performs databinding on the tree. */
			// K.D. December 9th, 2014 Bug #186240 Moving the databinding event before the data options are created.
			this._triggerDataBinding();
			var dataOpt = this._initDataOptions();
			this._initDataSource(dataOpt);
			this.options.dataSource.dataBind(this._constructFromData, this);
		},
		toggleCheckstate: function (node, event) {
			/* Toggles the checkstate of a node if checkboxMode is not set to off, otherwise does nothing.
				paramType="object" optional="false" Specifies the jQuery object of the node element the checkbox of which would be toggled.
				paramType="object" optional="true" Indicates the browser even which triggered this action (not API).
			*/
			var self = this, opt = self.options, css = self.css, childCheckboxes, childCheckIcons, checkbox, checkIcon, parentLi, noCancel;
			// K.D. November 28th, 2011 Bug #96672 Checking if no argument is provided when doing the API call
			if (!node) {
				throw new Error($.ig.Tree.locale.incorrectNodeObject);
			}
			if (!opt.checkboxMode || opt.checkboxMode.toLowerCase() === 'off') {
				return;
			}

			checkbox = node.children('span[data-role=checkbox]');
			checkIcon = checkbox.children('span');
			noCancel = self._triggerNodeCheckstateChanging(event, node);
			if (noCancel) {
				if (opt.checkboxMode.toLowerCase() === 'tristate') {
					if (checkbox.attr('data-chk') === 'on' || checkbox.attr('data-chk') === 'partial') {
						childCheckboxes = node.find('span[data-role=checkbox]');
						childCheckIcons = childCheckboxes.children('span');
						checkbox.attr('data-chk', 'off');
						checkIcon.removeClass(css.checkboxOn).removeClass(css.checkboxPartial).addClass(css.checkboxOff);
						childCheckboxes.attr('data-chk', 'off');
						childCheckIcons.removeClass(css.checkboxOn).removeClass(css.checkboxPartial).addClass(css.checkboxOff);

						parentLi = checkbox.parent().parent().parent();
						while (parentLi && parentLi.is('li')) {
							// All child checkboxes are unchecked
							if (parentLi.find('ul > li > span[data-chk=on]').length <= 0) {
								checkbox = parentLi.children('span[data-role=checkbox]');
								checkIcon = checkbox.children('span');
								checkbox.attr('data-chk', 'off');
								checkIcon.removeClass(css.checkboxOn).removeClass(css.checkboxPartial).addClass(css.checkboxOff);
								parentLi = this.parentNode(parentLi);
							} else {
								checkbox = parentLi.children('span[data-role=checkbox]');
								checkIcon = checkbox.children('span');
								checkbox.attr('data-chk', 'partial');
								checkIcon.removeClass(css.checkboxOn).removeClass(css.checkboxOff).addClass(css.checkboxPartial);
								parentLi = this.parentNode(parentLi);
							}
						}
					} else {
						childCheckboxes = node.find('span[data-role=checkbox]');
						childCheckIcons = childCheckboxes.children('span');
						checkbox.attr('data-chk', 'on');
						checkIcon.removeClass(css.checkboxOff).removeClass(css.checkboxPartial).addClass(css.checkboxOn);
						childCheckboxes.attr('data-chk', 'on');
						childCheckIcons.removeClass(css.checkboxOff).removeClass(css.checkboxPartial).addClass(css.checkboxOn);

						parentLi = checkbox.parent().parent().parent();
						while (parentLi && parentLi.is('li')) {
							// All childcheckboxes are checked
							if (parentLi.find('ul > li > span[data-chk=on]').length === parentLi.find('ul > li').length) {
								checkbox = parentLi.children('span[data-role=checkbox]');
								checkIcon = checkbox.children('span');
								checkbox.attr('data-chk', 'on');
								checkIcon.removeClass(css.checkboxOff).removeClass(css.checkboxPartial).addClass(css.checkboxOn);
								parentLi = this.parentNode(parentLi);
							} else {
								checkbox = parentLi.children('span[data-role=checkbox]');
								checkIcon = checkbox.children('span');
								checkbox.attr('data-chk', 'partial');
								checkIcon.removeClass(css.checkboxOn).removeClass(css.checkboxOff).addClass(css.checkboxPartial);
								parentLi = this.parentNode(parentLi);
							}
						}
					}
				} else {
					if (checkbox.attr('data-chk') === 'on' || checkbox.attr('data-chk') === 'partial') {
						checkbox.attr('data-chk', 'off');
						checkIcon.removeClass(css.checkboxOn).removeClass(css.checkboxPartial).addClass(css.checkboxOff);
					} else {
						checkbox.attr('data-chk', 'on');
						checkIcon.removeClass(css.checkboxOff).addClass(css.checkboxOn);
					}
				}
				self._triggerNodeCheckstateChanged(event, node);
			}
		},
		toggle: function (node, event) {
			/* Toggles the collapse/expand for the specified node.
				paramType="object" optional="false" Specifies the jQuery object of the node element the checkbox of which would be toggled.
				paramType="object" optional="true" Indicates the browser even which triggered this action if this is not an API call.
			*/
			var self = this, opt = self.options, css = self.css, noCancel, sibling, siblingExpander, i = 0, expander;
			// K.D. November 28th, 2011 Bug #96672 Checking if no argument is provided when doing the API call
			if (!node) {
				throw new Error($.ig.Tree.locale.incorrectNodeObject);
			}
			if (!event) {
				expander = node.children('.' + css.nodeExpander);
			} else {
				expander = $(event.target).closest('span[data-role=expander]');
			}

			if (node.children('ul').attr('data-populated') && node.children('ul').attr('data-populated') === 'false') {
				this._prepareRequest(node, event);
				return;
			}

			if (expander.attr('data-exp') && expander.attr('data-exp') !== 'false') {
				noCancel = self._triggerNodeCollapsing(event, node);

				if (noCancel) {
					$(node).children('ul').hide(opt.animationDuration, function () {
						self._triggerNodeCollapsed(event, node);
					});
					expander.removeClass(css.collapseIcon).addClass(css.expandIcon).attr('data-exp', false);
				}
			} else {
				noCancel = self._triggerNodeExpanding(event, node);

				if (noCancel) {
					// Performing collapse on the same level if single expand is enabled
					if (opt.singleBranchExpand) {
						sibling = node.siblings();

						for (i; i < sibling.length; i++) {
							siblingExpander = $(sibling[i]).children('.' + css.nodeExpander);
							if (siblingExpander.length > 0 && (siblingExpander.attr('data-exp') === 'true' || siblingExpander.attr('data-exp') === true)) {
								noCancel = self._triggerNodeCollapsing(event, $(sibling[i]));

								if (noCancel) {
									$(sibling[i]).children('ul').hide(opt.animationDuration, $.proxy(this._triggerNodeCollapsed(event, $(sibling[i])), this));
									siblingExpander.removeClass(css.collapseIcon).addClass(css.expandIcon).attr('data-exp', false);
								}
							}
						}
					}

					node.children('ul').show(opt.animationDuration, function () {
						self._triggerNodeExpanded(event, node);
					});
					expander.removeClass(css.expandIcon).addClass(css.collapseIcon).attr('data-exp', true);
				}
			}
		},
		expandToNode: function (node, toSelect) {
			/* Expands the tree down to the specified node.
				paramType="object" optional="false" Specifies the jQuery object of the node element down to which the tree would be expanded.
				paramType="bool" optional="true" Specifies the whether to select the node after expanding to it.
			*/
			var parentNode, cachedanimationDuration;
			// K.D. November 28th, 2011 Bug #96672 Checking if no argument is provided when doing the API call
			if (node && node.length > 0) {
				if (typeof node === 'string' && this.nodeByPath(node).length > 0) {
					node = this.nodeByPath(node);
				}
				if (typeof node === 'string' && this.options.loadOnDemand) {
					this._triggerChainRequest(node, toSelect);
					return;
				}
				if (toSelect) {
					this.select(node);
				}
				parentNode = this.parentNode(node);
				cachedanimationDuration = this.options.animationDuration;
				this.options.animationDuration = 0;
				while (parentNode) {
					if (!this.isExpanded(parentNode)) {
						this.toggle(parentNode);
					}
					parentNode = this.parentNode(parentNode);
				}
				this.options.animationDuration = cachedanimationDuration;
			}
		},
		expand: function (node) {
			/* Expands the specified node.
				paramType="object" optional="false" Specifies the jQuery object of the node element to expand.
			*/
			var self = this, opt = self.options, css = self.css, sibling, siblingExpander, i = 0, expander;

			// K.D. November 28th, 2011 Bug #96672 Checking if no argument is provided when doing the API call
			if (!node || node.length <= 0) {
				throw new Error($.ig.Tree.locale.incorrectNodeObject);
			}

			if (node.children('ul').attr('data-populated') && node.children('ul').attr('data-populated') === 'false') {
				this._prepareRequest(node);
				return;
			}

			expander = node.children('.' + css.nodeExpander);

			if (!expander.attr('data-exp') || expander.attr('data-exp') === 'false') {
				// Performing collapse on the same level if single expand is enabled
				if (opt.singleBranchExpand) {
					sibling = node.siblings();

					for (i; i < sibling.length; i++) {
						siblingExpander = $(sibling[i]).children('.' + css.nodeExpander);
						if (siblingExpander.length > 0 && (siblingExpander.attr('data-exp') === 'true' || siblingExpander.attr('data-exp') === true)) {
							$(sibling[i]).children('ul').hide(opt.animationDuration);
							siblingExpander.removeClass(css.collapseIcon).addClass(css.expandIcon).attr('data-exp', false);
						}
					}
				}

				node.children('ul').show(opt.animationDuration);
				expander.removeClass(css.expandIcon).addClass(css.collapseIcon).attr('data-exp', true);
			}
		},
		collapse: function (node) {
			/* Collapses the specified node.
				paramType="object" optional="false" Specifies the jQuery object of the node element to collapse.
			*/
			var self = this, opt = self.options, css = self.css, expander;
			// K.D. November 28th, 2011 Bug #96672 Checking if no argument is provided when doing the API call
			if (!node || node.length <= 0) {
				throw new Error($.ig.Tree.locale.incorrectNodeObject);
			}
			expander = node.children('.' + css.nodeExpander);

			if (expander.attr('data-exp') && expander.attr('data-exp') !== 'false') {
				$(node).children('ul').hide(opt.animationDuration);
				expander.removeClass(css.collapseIcon).addClass(css.expandIcon).attr('data-exp', false);
			}
		},
		parentNode: function (node) {
			/* Retrieves the parent node of the specified node.
				paramType="object" optional="false" Specifies the jQuery selected node element to collapse.
				returnType="object" Returns the jQuery object of the parent node element, null if the node is a root level node. 
			*/
			if (!node) {
				throw new Error($.ig.Tree.locale.incorrectNodeObject);
			}
			var parent = node.parent().closest('li[data-role=node]');
			return parent.length > 0 ? parent : null;
		},
		nodeByPath: function (nodePath) {
			/* Retrieves the jQuery element of the node with the specified path.
				paramType="string" optional="false" Specifies the path to the required node.
				returnType="object" Returns the jQuery selected node element with the specified path. The length property would be 0 if node isn't found. 
			*/
			return this.element.find('li[data-path="' + nodePath + '"]');
		},
		nodesByValue: function (value) {
			/* Retrieves the jQuery element of the node with the specified value.
				paramType="string" optional="false" Specifies the value of the required node.
				returnType="object" Returns the jQuery object of the node element with the specified value. The length property would be 0 if node isn't found. 
			*/
			return this.element.find('li[data-value="' + value + '"]');
		},
		checkedNodes: function () {
			/* Retrieves all the node objects that have their checkboxes checked.
				returnType="array" Returns the jQuery array of all the checked nodes.
			*/
			var elements = this.element.find('span[data-chk=on]').parent(), i = 0, collection = [];
			if (elements.length > 0) {
				for (i; i < elements.length; i++) {
					collection.push(this.nodeFromElement($(elements[i])));
				}
			}
			return collection;
		},
		uncheckedNodes: function () {
			/* Retrieves all the node objects that have their checkboxes unchecked.
				returnType="array" Returns the jQuery array of all the unchecked nodes.
			*/
			var elements = this.element.find('span[data-chk=off]').parent(), i = 0, collection = [];
			if (elements.length > 0) {
				for (i; i < elements.length; i++) {
					collection.push(this.nodeFromElement($(elements[i])));
				}
			}
			return collection;
		},
		partiallyCheckedNodes: function () {
			/* Retrieves all the node objects that have their checkboxes partially checked.
				returnType="array" Returns the jQuery array of all the partially checked nodes.
			*/
			var elements = this.element.find('span[data-chk=partial]').parent(), i = 0, collection = [];
			if (elements.length > 0) {
				for (i; i < elements.length; i++) {
					collection.push(this.nodeFromElement($(elements[i])));
				}
			}
			return collection;
		},
		select: function (node, event) {
			/* Selects a node.
				paramType="object" optional="false" Specifies the jQuery object of the node element to be toggled.
				paramType="object" optional="true" Indicates the browser even which triggered this action (not API).
			*/
			// K.D. November 28th, 2011 Bug #96672 Checking if no argument is provided when doing the API call
			if (!node || node.length <= 0) {
				throw new Error($.ig.Tree.locale.incorrectNodeObject);
			}
			var css = this.css, nodeId = node.attr('data-path'), noCancel, prevent = false;

			if (event && (node.children('a').attr('href') === '#' || node.children('a').attr('href') === document.URLUnencoded + '#')) {
				prevent = true;
			}

			if (!this._selectedNode) {
				this._selectedNode = [{path: null, element: null, data: null, binding: null}];
			}

			// To do: Implement multiple selection logic
			if (this._selectedNode[0].path !== null) {
				if (this._selectedNode[0].path !== nodeId) {
					noCancel = this._triggerSelectionChanging(event, node);

					if (noCancel) {
						this._selectedNode[0].element.children('a').removeClass(css.nodeSelected);
						node.children('a').addClass(css.nodeSelected);
						this._selectedNode[0] = this.nodeFromElement(node);
						this._triggerSelectionChanged(event);
					} else if (event) {
						prevent = true;
					}
				}
			} else {
				noCancel = this._triggerSelectionChanging(event, node);

				if (noCancel) {
					node.children('a').addClass(css.nodeSelected);
					this._selectedNode[0] = this.nodeFromElement(node);
					this._triggerSelectionChanged(event);
				} else if (event) {
					prevent = true;
				}
			}

			if (prevent) {
				event.preventDefault();
			}
		},
		deselect: function (node) {
			/* Deselects the specified node.
				paramType="object" optional="false" Specifies the jQuery object of the node element to be deselected.
			*/
			// K.D. November 28th, 2011 Bug #96672 Checking if no argument is provided when doing the API call
			if (!node) {
				throw new Error($.ig.Tree.locale.incorrectNodeObject);
			}
			var css = this.css, nodeId = node.attr('data-path');

			if (!this._selectedNode) {
				this._selectedNode = [{path: null, element: null, data: null, binding: null}];
			}

			if (this._selectedNode[0].path !== null) {
				if (this._selectedNode[0].path === nodeId) {
					node.children('a').removeClass(css.nodeSelected);
					this._selectedNode[0].path = null;
					this._selectedNode[0].element = null;
					this._selectedNode[0].data = null;
					this._selectedNode[0].binding = null;
				}
			}
		},
		clearSelection: function () {
			/* Deselects all the selected nodes. */
			var css = this.css, i = 0;
			// K.D. August 16th, 2013 Bug #149419 Clearing selection before selecting anything results in an exception
			if (this._selectedNode && this._selectedNode[0].path !== null) {
				for (i; i < this._selectedNode.length; i++) {
					this._selectedNode[i].element.children('a').removeClass(css.nodeSelected);
				}
				this._selectedNode = [{
					path: null,
					element: null,
					data: null,
					binding: null
				}];
			}
		},
		selectedNode: function () {
			/* Retrieves the selected node.
				returnType="object" Object description: { path: "node_path", element: jQuery LI Element, data: data, binding: binding }
			*/
			if (!this._selectedNode) {
				this._selectedNode = [{path: null, element: null, data: null, binding: null}];
			}
			return this._selectedNode[0];
		},
		findNodesByText: function (text, parent) {
			/* Retrieves all node objects with the specified text (case sensitive).
				paramType="string" optional="false" The text to search by.
				paramType="object" optional="true" The jQuery selected node element. If not specified then search would start from the root of the tree.
				returnType="object" Object description: { path: "node_path", element: jQuery LI Element, data: data, binding: binding }
			*/
			var collection = [], nodes, self = this;
			nodes = parent ? parent.find('li > a:contains("' + text + '")') : this.element.find('li > a:contains("' + text + '")');
			nodes.each(function () {
				collection.push(self.nodeFromElement($(this).closest('li[data-role=node]')));
			});
			// if (parent && parent.length > 0) {
				// data = this.nodeDataFor(parent.attr('data-path'));
				// binding = this._retrieveCurrentDepthBinding(parent.parent().attr('data-depth'));
				// if (binding.hasOwnProperty('childDataProperty') && data.hasOwnProperty(binding.childDataProperty)) {
					// data = data[binding.childDataProperty];
					// tempPath = parent.attr('data-path') + this.options.pathSeparator;
					// if (binding.hasOwnProperty('bindings')) {
						// binding = binding.bindings;
					// }
				// } else {
					// return collection;
				// }
			// } else {
				// data = this.options.dataSource.root().data();
				// binding = this.options.bindings;
				// tempPath = '';
			// }

			// if (data) {
				// for (i = 0; i < data.length; i++) {
					// if (data[i][binding.textKey].toString() === text) {
						// if (binding.hasOwnProperty('primaryKey') && data[i].hasOwnProperty(binding.primaryKey)) {
							// tempNode = this.nodeByPath(tempPath + data[i][binding.primaryKey]);
							// collection.push(this.nodeFromElement(tempNode));
							// collection = collection.concat(this.findNodesByText(text, tempNode));
						// } else {
							// tempNode = this.nodeByPath(tempPath + i);
							// collection.push(this.nodeFromElement(tempNode));
							// collection = collection.concat(this.findNodesByText(text, tempNode));
						// }
					// } else {
						// if (binding.hasOwnProperty('primaryKey') && data[i].hasOwnProperty(binding.primaryKey)) {
							// tempNode = this.nodeByPath(tempPath + data[i][binding.primaryKey]);
							// collection = collection.concat(this.findNodesByText(text, tempNode));
						// } else {
							// tempNode = this.nodeByPath(tempPath + i);
							// collection = collection.concat(this.findNodesByText(text, tempNode));
						// }
					// }
				// }
			// }
			return collection;
		},
		findImmediateNodesByText: function (text, parent) {
			/* Retrieves all immediate children of the specified parent with the specified text (case sensitive).
				paramType="string" optional="false" The text to search by.
				paramType="object" optional="true" The jQuery selected node element the children of which would be retrieved.
				returnType="object" Object description: { path: "node_path", element: jQuery LI Element, data: data, binding: binding }
			*/
			var collection = [], nodes, self = this;
			nodes = parent ? parent.children('ul').children('li').children('a:contains("' + text + '")') : 
				this.element.is('ul') ? this.element.children('li').children('a:contains("' + text + '")') : 
					this.element.children('ul').children('li').children('a:contains("' + text + '")');
			nodes.each(function () {
				collection.push(self.nodeFromElement($(this).closest('li[data-role=node]')));
			});
			// if (parent && parent.length > 0) {
				// binding = this._retrieveCurrentDepthBinding(parent.parent().attr('data-depth'));
				// data = this.nodeDataFor(parent.attr('data-path'));
				// if (binding.hasOwnProperty('childDataProperty') && data.hasOwnProperty(binding.childDataProperty)) {
					// data = data[binding.childDataProperty];
					// tempPath = parent.attr('data-path');
					// if (binding.hasOwnProperty('bindings')) {
						// binding = binding.bindings;
					// }
				// } else {
					// return collection;
				// }
				// for (i = 0; i < data.length; i++) {
					// if (data[i][binding.textKey].toString() === text) {
						// if (binding.hasOwnProperty('primaryKey') && data[i].hasOwnProperty(binding.primaryKey)) {
							// tempNode = this.nodeByPath(tempPath + this.options.pathSeparator + data[i][binding.primaryKey]);
							// collection.push(this.nodeFromElement(tempNode));
						// } else {
							// tempNode = this.nodeByPath(tempPath + this.options.pathSeparator + i);
							// collection.push(this.nodeFromElement(tempNode));
						// }
					// }
				// }
			// } else {
				// binding = this.options.bindings;
				// data = this.options.dataSource.root().data();
				// for (i = 0; i < data.length; i++) {
					// if (data[i][binding.textKey].toString() === text) {
						// if (binding.hasOwnProperty('primaryKey') && data[i].hasOwnProperty(binding.primaryKey)) {
							// tempNode = this.nodeByPath(data[i][binding.primaryKey]);
							// collection.push(this.nodeFromElement(tempNode));
						// } else {
							// tempNode = this.nodeByPath(i);
							// collection.push(this.nodeFromElement(tempNode));
						// }
					// }
				// }
			// }
			return collection;
		},
		nodeByIndex: function (index, parent) {
			/* Retrieves the n-th jQuery node element child of the specified parent.
				paramType="number" optional="false" Specifies the index to be retrieved.
				paremType="object" optional="true" The jQuery object of the parent node element.
				returnType="object" The jQuery object of the node element.
			*/
			var node;
			if (!parent) {
				if (this.element.is('ul')) {
					node = this.element.children().eq(index);
				} else {
					node = this.element.children('ul').children().eq(index);
				}
			} else {
				node = parent.children('ul').children().eq(index);
			}
			return node;
		},
		nodeFromElement: function (element) {
			/* Retrieves a node object from provided jQuery node element.
				paramType="object" optional="false" Specifies the jQuery object of the node element.
				returnType="object" Object description: { path: "node_path", element: jQuery LI Element, data: data, binding: binding }
			*/
			if (element.length > 0) {
				var nodeElement = {
					path: element.attr('data-path'),
					element: element,
					data: this.nodeDataFor(element.attr('data-path')),
					binding: this._retrieveCurrentDepthBinding(element.parent().attr('data-depth'))
				};
				return nodeElement;
			}
		},
		children: function (parent) {
			/* Retrieves a node object collection of the immediate children of the provided node.
				paramType="object" optional="false" Specifies the jQuery object of the node element.
				returnType="object" Object description: { path: "node_path", element: jQuery LI Element, data: data, binding: binding }
			*/
			var children = [], self = this, child, ul;
			if (parent && parent.length > 0) {
				ul = parent.children('ul');
				if (ul.length > 0) {
					ul.children('li').each(function () {
						child = $(this);
						children.push(self.nodeFromElement(child));
					});
				}
				return children;
			}
			throw new Error($.ig.Tree.locale.incorrectNodeObject);
		},
		childrenByPath: function (path) {
			/* Retrieves a node object collection of the immediate children of the node with the provided path.
				paramType="string" optional="false" Specifies the path of the node the children of which are being retrieved.
				returnType="object" Object description: { path: "node_path", element: jQuery LI Element, data: data, binding: binding }
			*/
			var node = this.nodeByPath(path), children = [], self = this, child, ul;
			if (node.length > 0) {
				ul = node.children('ul');
				if (ul.length > 0) {
					ul.children('li').each(function () {
						child = $(this);
						children.push(self.nodeFromElement(child));
					});
				}
				return children;
			}
			throw new Error($.ig.Tree.locale.incorrectPath + path);
		},
		isSelected: function (node) {
			/* Returns true if the provided node is selected and false otherwise.
				paramType="object" optional="false" Specifies the jQuery object of the node element.
				returnType="bool"
			*/
			if (!this._selectedNode) {
				this._selectedNode = [{path: null, element: null, data: null, binding: null}];
			}
			if (node && node.length > 0) {
				return this._selectedNode[0].path === node.attr('data-path');
			}
			throw new Error($.ig.Tree.locale.incorrectNodeObject);
		},
		isExpanded: function (node) {
			/* Returns true if the provided node is expanded and false otherwise.
				paramType="object" optional="false" Specifies the jQuery object of the node element.
				returnType="bool"
			*/
			if (node && node.length > 0) {
				var expander = node.children('span[data-role=expander]');
				if (expander.length > 0) {
					return expander.attr('data-exp') === 'true';
				}
			} else {
				throw new Error($.ig.Tree.locale.incorrectNodeObject);
			}
		},
		isChecked: function (node) {
			/* Returns true if the provided node has its checkstate checked and false otherwise.
				paramType="object" optional="false" Specifies the jQuery object of the node element.
				returnType="bool"
			*/
			if (node && node.length > 0) {
				var checkbox = node.children('span[data-role=checkbox]');
				if (checkbox.length > 0) {
					return checkbox.attr('data-chk') === 'on';
				}
			} else {
				throw new Error($.ig.Tree.locale.incorrectNodeObject);
			}
		},
		checkState: function (node) {
			/* Returns true if the provided node has its checkstate checked and false otherwise.
				paramType="object" optional="false" Specifies the jQuery object of the node element.
				returnType="string" The checkbox state of the node.
			*/
			if (node && node.length > 0) {
				var checkbox = node.children('span[data-role=checkbox]');
				if (checkbox.length > 0) {
					return checkbox.attr('data-chk');
				}
			} else {
				throw new Error($.ig.Tree.locale.incorrectNodeObject);
			}
		},
		addNode: function (node, parent, nodeIndex) {
			/* Adds a new array of nodes to the tree. New nodes are appended to the root or to a specified parent node.
				paramType="object" optional="false" Specifies the data used to create the new node.
				paramType="object" optional="true" Specifies the jQuery object of the parent node the nodes are to be appended to.
				paramType="number" optional="true" Specifies the index at which the node to be inserted.
			*/
			// No data is being passed in
			// K.D. July 24th, 2012 Bug #117457 addNode creates an expansion indicator if the node param is an empty array []
			if (!nodeIndex && typeof parent === 'number') {
				nodeIndex = parent;
				parent = null;
			}
			if (!node || node.length <= 0) {
				if (parent && parent.length > 0) {
					this._updateParentState(parent);
				}
				return;
			}
			var ul, path, checked, isLi, li, isEmpty, r, binding, self = this;
			// Root node is to be used
			if (!parent) {
				parent = this.element.is('ul') ? this.element : this.element.children('ul');
				// No children case
				if (parent.children().length <= 0) {
					this._addData(node, '', 0);
					this._triggerRendering(node);
					r = $(this._initChildrenRecursively('', node)).appendTo(parent);
					if (this.options.dragAndDrop) {
						this._initDragAndDrop(r);
					}
					this._triggerRendered();
					// Update transaction log
					this.options.dataSource.root().addNode({
						data: node,
						parentPath: '',
						path: r.attr('data-path')
					});
					return;
				}
			}

			isLi = parent.is('li');
			ul = isLi ? parent.children('ul') : parent;
			if (ul.length <= 0) {
				ul = $('<ul data-depth="' + (parseInt(parent.parent().attr('data-depth'), 10) + 1) + '" style="display: none"></ul>').appendTo(parent);
			}
			path = isLi ? parent.attr('data-path') : '';
			binding = this._retrieveCurrentDepthBinding(parseInt(ul.attr('data-depth'), 10));
			if (this.options.checkboxMode.toLowerCase() === 'tristate') {
				checked = isLi ? this.isChecked(parent) : false;
			}
			// K.D. July 3rd, 2012 Bug #116064 We need the parent UL depth not the current UL. This would be at least 0 because the root insert is
			// handled up top.
			this._addData(node, path, parseInt(ul.attr('data-depth'), 10) - 1, nodeIndex);
			this._triggerRendering(node);
			isEmpty = ul.children('li').length <= 0;
			if (nodeIndex === 0) {
				// K.D. June 4th, 2014 Bug #162878 WinJS compatibility for the igTree
				MSApp.execUnsafeLocalFunction(function () {
					li = $(self._initChildrenRecursively(path, node, parseInt(ul.attr('data-depth'), 10), checked, ul.children('li').length)).prependTo(ul);
				});
				if (!binding.hasOwnProperty('primaryKey')) {
					this._recalculatePaths(path);
				}
			} else if (!nodeIndex) {
				// K.D. June 4th, 2014 Bug #162878 WinJS compatibility for the igTree
				MSApp.execUnsafeLocalFunction(function () {
					li = $(self._initChildrenRecursively(path, node, parseInt(ul.attr('data-depth'), 10), checked, ul.children('li').length)).appendTo(ul);
				});
			} else {
				// K.D. June 4th, 2014 Bug #162878 WinJS compatibility for the igTree
				MSApp.execUnsafeLocalFunction(function () {
					li = $(self._initChildrenRecursively(path, node, parseInt(ul.attr('data-depth'), 10), checked, ul.children('li').length)).insertBefore(ul.children('li:eq(' + nodeIndex + ')'));
				});
				if (!binding.hasOwnProperty('primaryKey')) {
					this._recalculatePaths(path);
				}
			}
			if (isLi && isEmpty) {
				this._updateParentState(parent);
			}
			if (this.options.dragAndDrop) {
				this._initDragAndDrop(li);
			}
            // K.D. August 16th, 2013 Bug #149438 Switching to delegated events
			this._triggerRendered();
			// Update transaction log
			r = [];
			li.each(function () {
				r.push($(this).attr('data-path'));
			});
			this.options.dataSource.root().addNode({
				data: node,
				parentPath: path,
				path: r
			});
			this._trigger("nodeAdded", null, {owner: this, element: li, data: node, index: nodeIndex, binding: binding});
		},
		removeAt: function (path) {
			/* Removes the node with with the specified path and all of its children.
				paramType="string" optional="false" Specifies the path of the node to be removed.
			*/
			var node = this.nodeByPath(path), depth = parseInt(node.parent().attr('data-depth'), 10), binding, parent = this.parentNode(node), data;
			// No such node
			if (node.length <= 0) {
				return;
			}
			if (path.indexOf('_remove') !== -1) {
				path = path.replace('_remove', '');
			}
			binding = this._retrieveCurrentDepthBinding(depth);
			// Update transaction log
			// K.D. October 17th, 2013 Bug #155067 A shallow copy should be created instead of a deep one
			data = {
				data: $.extend(false, {}, this.nodeDataFor(path)),
				path: path
			};
			this._removeData(path, binding);
			node.remove();
			if (!binding.hasOwnProperty('primaryKey')) {
				this._recalculatePaths(path);
			}
			if (parent && parent.children('ul').children('li').length <= 0) {
				this._updateParentState(parent);
			}
			if (this.options.checkboxMode.toLowerCase() === 'tristate' && parent) {
				this._updateParentCheckbox(parent);
			}
			this.options.dataSource.root().removeNode(data);
			this._trigger("nodeDeleted", null, {owner: this, data: data.data, path: path});
		},
		removeNodesByValue: function (value) {
			/* Removing all the nodes with the specified value.
				paramType="string" optional="false" Specifies the value of the nodes to be removed.
			*/
			var nodes = this.nodesByValue(value), self = this;
			nodes.each(function () {
				self.removeAt($(this).attr('data-path'));
			});
		},
		applyChangesToNode: function (element, data) {
		    /* Performs a UI update on the provided node element with the new provided data member.
				paramType="object" optional="false" Specifies the node to be updated.
                paramType="object" optional="false" Specifies the new data item the node would update according to.
			*/
			var node = this.nodeFromElement(element), item;
			for (item in node.data) {
				if (node.data.hasOwnProperty(item)) {
					this._replaceUIValue(node, data, item);
				}
			}
		},
		transactionLog: function () {
			/* Returns the transaction log stack.
				returnType="object" The transaction log stack.
			*/
			return this.options.dataSource.root()._transactionLog;
		},
		_triggerSelectionChanging: function (event, node) {
			var args = {
					owner: this,
					selectedNodes: this._selectedNode,
					newNodes: [this._constructNodeObject(node)]
				};

			return this._trigger(this.events.selectionChanging, event, args);
		},
		_triggerSelectionChanged: function (event) {
			var args = {
					owner: this,
					selectedNodes: this._selectedNode,
					newNodes: this._selectedNode
				};

			this._trigger(this.events.selectionChanged, event, args);
		},
		_triggerNodeCollapsing: function (event, node) {
			var args = {
					owner: this,
					node: this._constructNodeObject(node)
				};

			return this._trigger(this.events.nodeCollapsing, event, args);
		},
		_triggerNodeCollapsed: function (event, node) {
			var args = {
					owner: this,
					node: this._constructNodeObject(node)
				};

			this._trigger(this.events.nodeCollapsed, event, args);
		},
		_triggerNodeExpanding: function (event, node) {
			var args = {
					owner: this,
					node: this._constructNodeObject(node)
				};

			return this._trigger(this.events.nodeExpanding, event, args);
		},
		_triggerNodeExpanded: function (event, node) {
			var args = {
					owner: this,
					node: this._constructNodeObject(node)
				};

			this._trigger(this.events.nodeExpanded, event, args);
		},
		_triggerNodePopulating: function (event, node) {
			var args = this._constructNodeObject(node);
			return this._trigger(this.events.nodePopulating, event, args);
		},
		_triggerNodePopulated: function (event, node) {
			var args = this._constructNodeObject(node);
			this._trigger(this.events.nodePopulated, event, args);
		},
		_triggerNodeCheckstateChanging: function (event, node) {
			var state = node.children('span[data-role=checkbox]').attr('data-chk'), args = {
				owner: this,
				node: this._constructNodeObject(node),
				currentState: state,
				newState: state === 'off' ? 'on' : 'off',
				currentCheckedNodes: this.checkedNodes()
			};

			return this._trigger(this.events.nodeCheckstateChanging, event, args);
		},
		_triggerNodeCheckstateChanged: function (event, node) {
			var state = node.children('span[data-role=checkbox]').attr('data-chk'), args = {
				owner: this,
				node: this._constructNodeObject(node),
				newState: state,
				newCheckedNodes: this.checkedNodes(),
				newPartiallyCheckedNodes: this.partiallyCheckedNodes()
			};

			return this._trigger(this.events.nodeCheckstateChanged, event, args);
		},
		_triggerNodeClick: function (event, node) {
			var args = {
				owner: this,
				node: this._constructNodeObject(node)
			};

			return this._trigger(this.events.nodeClick, event, args);
		},
		_triggerNodeDoubleClick: function (event, node) {
			var args = this._constructNodeObject(node);

			return this._trigger(this.events.nodeDoubleClick, event, args);
		},
		_triggerDataBinding: function () {
			var args = { owner: this };

			this._trigger(this.events.dataBinding, null, args);
		},
		_triggerDataBound: function (dataView) {
			var args = { owner: this, dataView: dataView };

			this._trigger(this.events.dataBound, null, args);
		},
		_triggerRendering: function (dataView) {
			var args = { owner: this, dataView: dataView };

			this._trigger(this.events.rendering, null, args);
		},
		_triggerRendered: function () {
			var args = { owner: this };

			this._trigger(this.events.rendered, null, args);
		},
		_triggerDragStart: function (event, ui, node) {
			var obj = this._constructNodeObject(node),
				args = $.extend(false, obj, ui);

			return this._trigger(this.events.dragStart, event, args);
		},
		_triggerDrag: function (event, ui, node) {
			var obj = this._constructNodeObject(node),
				args = $.extend(false, obj, ui);

			return this._trigger(this.events.drag, event, args);
		},
		_triggerDragStop: function (event, ui) {
			this._trigger(this.events.dragStop, event, ui);
		},
		_triggerNodeDropping: function (event, ui, node, targetIndex) {
			var obj = this._constructNodeObject(node),
				args,
				indexDecrement;
			obj.targetIndex = targetIndex;
			obj.originalIndex = ui.draggable.index();
			// K.D. January 21st, 2013 Bug #129864 The position of the moved column in the moving dialog is not accurate to the one in the grid when dragging in the tree.
			// When moving up the indices in the same level we need to decrement the index.
			indexDecrement = this._sourceNode.element.parent().attr('data-depth') === node.parent().attr('data-depth') && obj.targetIndex > obj.originalIndex ? -1 : 0;
			obj.targetIndex += indexDecrement;
			args = $.extend(false, obj, ui);

			return this._trigger(this.events.nodeDropping, event, args);
		},
		_triggerNodeDropped: function (event, ui, node) {
			var obj = this._constructNodeObject(node),
				args = $.extend(false, obj, ui);

			this._trigger(this.events.nodeDropped, event, args);
		},
		_constructNodeObject: function (node) {
			// Logic for constructing node object that would be used by the developer
			var nodeData = this.nodeDataFor(node !== null ? node.attr('data-path') : null),
				nodeObject = {
					path: node !== null ? node.attr('data-path') : null,
					element: node !== null ? node : null,
					data: nodeData,
					binding: node !== null ? this._retrieveCurrentDepthBinding(parseInt(node.parent().attr('data-depth'), 10)) : null
				};

			return nodeObject;
		},
		nodeDataFor: function (path) {
			/* Returns the data for the node with specified path.
				paramType="string" optional="false" Specifies the node path for which the data is returned.
				returnType="object" The JSON object holding the node data.
			*/
			if (!path) {
				return;
			}

			var splitPath = path.split(this.options.pathSeparator), data = this.options.dataSource._rootds.data(), i, j, binding = this.options.bindings, temp;

			for (i = 0; i < splitPath.length - 1; i++) {
				if (!binding.hasOwnProperty('primaryKey')) {
					if (data[parseInt(splitPath[i], 10)]) {
						if (typeof data[parseInt(splitPath[i], 10)][binding.childDataProperty] === 'function') {
							data = data[parseInt(splitPath[i], 10)][binding.childDataProperty]();
						} else {
							data = data[parseInt(splitPath[i], 10)][binding.childDataProperty];
						}
					}
				} else {
					for (j = 0; j < data.length; j++) {
						if (data[j].hasOwnProperty(binding.primaryKey)) {
							temp = typeof data[j][binding.primaryKey] === 'function' ? data[j][binding.primaryKey]() : data[j][binding.primaryKey];
							if (temp.toString() === splitPath[i].toString()) {
								data = typeof data[j][binding.childDataProperty] === 'function' ? data[j][binding.childDataProperty]() : data[j][binding.childDataProperty];
								break;
							}
						}
					}
				}
				if (binding.hasOwnProperty('bindings')) {
					binding = binding.bindings;
				}
			}
			// K.D. January 18th, 2012 Bug #99681 There are cases where there is only one data item and this is the data item we want as it's not an array
			if (!binding.hasOwnProperty('primaryKey') && data.length) {
				data = data[parseInt(splitPath[splitPath.length - 1], 10)];
			} else {
				for (j = 0; j < data.length; j++) {
					if (data[j].hasOwnProperty(binding.primaryKey)) {
						temp = typeof data[j][binding.primaryKey] === 'function' ? data[j][binding.primaryKey]() : data[j][binding.primaryKey];
						if (temp.toString() === splitPath[i].toString()) {
							data = data[j];
							break;
						}
					}
				}
			}
			if (typeof data === 'function') {
				data = data();
			}
			return data;
		},
        destroy: function () {
            /* Destructor */
            $.Widget.prototype.destroy.apply(this, arguments);
			// K.D. February 17th, 2014 Bug #164398 Attaching events only on create as delegate is used instead of bind now.
			this.element.undelegate();
			this.element.removeClass(this.css.tree);
			this.element.removeClass(this.css.treeCollection);
			this.element.removeClass(this.css.treeRoot);
			if (this.options.width) {
				this.element.css('width', '');
			}
			if (this.options.height) {
				this.element.css('height', '');
			}
			if (this.options.dragAndDrop) {
				this._destroyDragAndDrop();
			}
			this.element.removeAttr('data-depth');
			this.element.removeAttr('data-scroll');
			this.element.empty();
			return this;
        }
    });
    $.extend($.ui.igTree, {version: '15.2.20152.1033'});
}(jQuery));

/*!@license
* Infragistics.Web.ClientUI Grid 15.2.20152.1033
*
* Copyright (c) 2011-2015 Infragistics Inc.
*
* http://www.infragistics.com/
*
* Depends on: 
*	jquery-1.4.4.js
*	jquery.ui.core.js
*	jquery.ui.widget.js
*	modernizr.js (Optional)
*	infragistics.dataSource.js
*	infragistics.ui.shared.js
*	infragistics.templating.js
*	infragistics.util.js
*/
/*global jQuery, Modernizr, MSApp */
/*jshint -W106 */
if (typeof jQuery !== 'function') {
	throw new Error("jQuery is undefined");
}
(function ($) {
	var _hovTR, _aNull = function (val) { return val === null || val === undefined; };
	/*
		igGrid is a widget based on jQuery UI that provides Excel like functionality by rendering data in tabular form
		and includes support for paging, sorting, filtering and selection (both local and remote)
		the widget can be bound to various types of data sources such as JSON, XML, Remote WCF/REST services, etc.
	*/
	$.widget("ui.igGrid", {
		css: {
			/* classes applied to the top container element */
			"baseClass": "ui-widget ui-helper-clearfix ui-corner-all",
			/* Widget content class applied to various content containers in the grid */
			"baseContentClass": "ui-widget-content",
			/* class applied to the top container element */
			"gridClasses": "ui-iggrid",
			/* classes applied to the TBODY, and inherited through css for the records */
			"recordClass": "ui-ig-record ui-iggrid-record",
			/* classes applied on alternate records */
			"recordAltClass": "ui-ig-altrecord ui-iggrid-altrecord",
			/* classes applied to the grid header elements */
			"headerClass": "ui-iggrid-header ui-widget-header",
			/* classes applied to the header text container */
			"headerTextClass": "ui-iggrid-headertext",
			/* classes which will be applied to the grid header cell element when feature icon is rendered */
			"headerCellFeatureEnabledClass": "ui-iggrid-headercell-featureenabled",
			/* jQuery UI class applied to the grid header elements */
			"baseHeaderClass": "ui-widget-header",
			/* classes applied to the TABLE which holds the grid records */
			"gridTableClass": "ui-iggrid-table ui-widget-content",
			/* when fixed headers is enabled, this class is applied to the table that holds the header TH elements */
			"gridHeaderTableClass": "ui-iggrid-headertable",
			/* when fixed footers is enabled, this class is applied to the table that holds the footer TD elements */
			"gridFooterTableClass": "ui-iggrid-footertable ui-widget-footer",
			/* when fixed headers is enabled, this class is applied to the table that holds the footer elements */
			"gridFooterClass": "",
			/* when no headers are shown or fixed headers is false, the caption (if any) needs to be rendered in a separate table */
			"gridCaptionTableClass": "ui-iggrid-captiontable",
			/* classes applied to the element that's on top of the header that has some description */
			"gridHeaderCaptionClass": "ui-iggrid-headercaption ui-widget-header ui-corner-top",
			/* class applied to the TABLE's TBODY holding data records */
			"gridTableBodyClass": "ui-iggrid-tablebody",
			/* classes applied to the scrolling div container when width and height are defined and scrollbars is 'true' */
			"gridScrollDivClass": "ui-iggrid-scrolldiv ui-widget-content",
			/* classes applied to the scrolling div container when virtualization is enabled */
			"gridVirtualScrollDivClass": "ui-iggrid-virtualscrolldiv",
			/* classes applied to the grid footer caption contents */
			"gridFooterCaptionClass": "ui-iggrid-footercaption",
			/* classes applied to the deleted rows of grid before commit */
			deletedRecord: 'ui-iggrid-deletedrecord',
			/* classes applied to the modified rows of grid before commit */
			modifiedRecord: 'ui-iggrid-modifiedrecord',
			/* class appplied to the grid element when RTL is enabled */
			rtl: "ui-iggrid-rtl"
		},
		options: {
			/* type="string|number|null"
				string The widget width can be set in pixels (px) and percentage (%).
				number The widget width can be set as a number
				null type="object" will stretch to fit data, if no other widths are defined
			*/
			width: null,
			/* type="string|number|null" This is the total height of the grid, including all UI elements - scroll container with data rows, header, footer, filter row -  (if any), etc.  
				string The widget height can be set in pixels (px) and percentage (%).
				number The widget height can be set as a number
				null type="object" will stretch vertically to fit data, if no other heights are defined
			*/
			height: null,
			/* type="bool" If autoAdjustHeight is set to false, the options.height will be set only on the scrolling container, and all other UI elements such as paging footer / filter row/ headers will add on top of that, so the total height of the grid will be more than this value - the height of the scroll container (content area) will not be dynamically calculated. Setting this option to false will usually result in a lot better initial rendering performance for large data sets ( > 1000 rows rendered at once, no virtualization enabled), since no reflows will be made by browsers when accessing DOM properties such as offsetHeight. */
			autoAdjustHeight: true,
			/* type="string|number" used for virtualization, this is the average value in pixels (default) that will be used to calculate how many rows and which ones to render as the end user scrolls. Also all rows' height will be automatically equal to this value 
				string The avarage row height can be set in pixels (25px).
				number The avarage row height can be set as a number (25).
			*/
			avgRowHeight: 25,
			/* type="string|number" used for virtualization, this is the average value in pixels for a column width 
				string The avarage column width can be set in pixels (25px).
				number The avarage column width can be set as a number (25).
			*/
			avgColumnWidth: null,
			/* type="string|number" Default column width that will be set for all columns.
				string The default column width can be set in pixels (px).
				number The default column width can be set as a number.
			*/
			defaultColumnWidth: null,
			/* type="bool" if no columns collection is defined, and autoGenerateColumns is set to true, columns will be inferred from the data source. If autoGenerateColumns is not explicitly set and columns has at least one column defined then autoGenerateColumns is automatically set to false */
			autoGenerateColumns: true,
			/* type="bool" Enables/disables virtualization. Virtualization can greatly enhance rendering performance. If enabled, the number of actual rendered rows (DOM elements) will be constant and related to the visible viewport of the grid. As the end user scrolls, those DOM elements will be dynamically reused to render the new data. */
			virtualization: false,
			/* type="fixed|continuous" Determines virtualization mode
				fixed type="string" renders only the visible rows and/or columns in the grid. On scrolling the same rows and/or columns are updated with new data from the data source.
				continuous type="string" renders a pre-defined number of rows in the grid. On scrolling the continuous virtualization loads another portion of rows and disposes the current one.
			*/
			virtualizationMode: 'fixed',
			/* type="bool" this is an internal option and should not be used. */
			requiresDataBinding: true,
			/* type="bool" option to enable virtualization for rows only (vertical) */
			rowVirtualization: false,
			/* type="bool" option to enable virtualization for columns only (horizontal) */
			columnVirtualization: false,
			/* type="number" number of pixels to move the grid when virtualization is enabled, and mouse wheel scrolling is performed over the virtual grid area. The "null" value will assume this is set to avgRowHeight */
			virtualizationMouseWheelStep: null,
			//visibleVirtualRecords: null, // if this is specified, then the height of the grid will be calculated automatically based on the average row height and the visible virtual records. if no average row height is specified, one will be calculated automatically at runtime 
			/* type="bool" If this option is set to true, the height of the grid row will be calculated automatically based on the average row height and the visible virtual records. If no average row height is specified, one will be calculated automatically at runtime.
			*/
			adjustVirtualHeights: false,
			/* type="string" *** IMPORTANT DEPRECATED ***
			This option has been deprecated as of the 14.1 release. The igGrid now uses column templates for individual column templating.
			jQuery templating style template that will be used to render data records */
			rowTemplate: null,
			/* type="bool" *** IMPORTANT DEPRECATED ***
			This option has been deprecated as of the 12.1 release. The igGrid now uses the custom Infragistics templating engine by default.
			custom high-performance rendering will be used for rendering by default. jQuery Templating plugin can be used and enabled by setting this option to true. This will allow usage of column / row templates in jQuery Templating style. If virtualization is enabled, it is advised to keep this option to "false", in order to have better scrolling/rendering performance
			*/
			jQueryTemplating: false,
			/* type="infragistics|jsRender" the templating engine that will be used to render the grid 
				infragistics type="string" the grid will use the Infragistics Templating engine to render its content and specific parts of the UI
				jsRender type="string" the grid will use jsRender to render its content and specific parts of the UI
			*/
			templatingEngine: "infragistics",
			/* type="array" an array of column objects */
			columns: [
				{
					/* type="string" Column header text */
					headerText: null,
					/* type="string" column key (property in the data source to which the column is bound) */
					key: null,
					/* type="string|function" Reference to a function (string or function) which will be used for formatting the cell values. The function should accept a value and return the new formatted value. 
					string type="string" string which will be used for formatting
					function type="function" function which will be used for formatting the cell values. The function should accept a value
					*/
					formatter: null,
					/* type="string" Sets gets format for cells in column. Default value is null.
						If dataType is "date", then supported formats are following: "date", "dateLong", "dateTime", "time", "timeLong", "MM/dd/yyyy", "MMM-d, yy, h:mm:ss tt", "dddd d MMM", etc.
						If dataType is "number", then supported numeric formats are following: "number", "currency", "percent", "int", "double", "0.00", "#.0####", "0", "#.#######", etc.
						The value of "double" will be similar to "number", but with unlimited maximum number of decimal places.
						The format patterns and rules for numbers and dates are defined in $.ig.regional.defaults object.
						If dataType is "string" or not set, then format is rendered as it is with replacement of possible "{0}" flag by value in cell. Example, if format is set to "Name: {0}" and value in cell is "Bob", then value will appear as "Name: Bob"
						If value is set to "checkbox", then checkboxes are used regardless of renderCheckboxes option of igGrid. That has effect only when dataType option of column is set to "bool".
					*/
					format: null,
					/* type="string|number|bool|date|object" data type of the column cell values 
						string
						number
						bool
						date
						object
					*/
					dataType: "string",
					/* type="string|number" Width of the column in pixels or percentage. Can have optional 'px' at the end. If width is not defined and defaultColumnWidth is set, it is assumed for all columns.
						string The column width can be set in pixels (px) and percentage (%).
						number The column width can be set as a number
					*/
					width: null,
					/* type="bool" Initial visibility of the column. A column can be hidden without the Hiding feature being enabled but there will be no UI for unhiding it. Columns can be defined as hidden in the options of the Hiding feature as well and those definitions take precedence.*/
					hidden: false,
					/* type="string" Sets a template for an individual column. the contents of the template should be the HTML markup that goes inside the table cell, without any <td> and </td> tags included in front and at the end. The syntax of the template, when referencing data keys and using conditional expressions is the same as the one for rowTemplate */
					template: null,
					/* type="bool" Sets whether column is bound to the datasource*/
					unbound: false,
					/* type="array" array of other column definitions. If the column has the property group than the grid has multi column headers*/
					group: [],
					/* type="number" used to adjust span of multi column header cell*/
					rowspan: 0,
					/* type="string|function" a reference or name of a javascript function which will calculate the value based on other cell values in the same row when column is unbound 
					string type="string" name of a javascript function 
					function type="function" reference to javascript function 
					*/
					formula: null,
					/* type="array" array of values which could be set for unbound columns at init time */
					unboundValues: null,
					/* type="auto|manual" update mode of the unbound column(this option is applied ONLY when option formula is set). Auto update unbound column value whenever the record/cell is updated*/
					unboundValuesUpdateMode: "auto",
					/* type="string" space-separated list of CSS classes to be applied on the header cell of this column */
					headerCssClass: null,
					/* type="string" space-separated list of CSS classes to be applied on the data cells of this column. */
					columnCssClass: null
				}
			],
			/* type="object" can be any valid data source accepted by $.ig.DataSource, or an instance of an $.ig.DataSource itself */
			dataSource: null,
			/* type="string" specifies a remote URL as a data source, from which data will be retrieved using an AJAX call ($.ajax)*/
			dataSourceUrl: null,
			/* type="string" explicitly set data source type (such as "json"). Please refer to the documentation of $.ig.DataSource and its type property */
			dataSourceType: null,
			/* type="string" see $.ig.DataSource. This is basically the property in the responses where data records are held, if the response is wrapped */
			responseDataKey: null,
			/* type="string" See $.ig.DataSource. Property in the response specifying the total number of records on the server. */
			responseTotalRecCountKey: null,
			/* type="string" specifies the HTTP verb to be used to issue the request */
			requestType: "GET",
			/* type="string" content type of the response. See http://api.jquery.com/jQuery.ajax/ => contentType */
			responseContentType: 'application/json; charset=utf-8',
			/* type="bool" option controlling the visibility of the grid header */
			showHeader: true,
			/* type="bool" option controlling the visibility of the grid footer */
			showFooter: true,
			/* type="bool" headers will be fixed if this option is set to true, and only the grid data will be scrollable. If virtualization is enabled, fixedHeaders will always act as if it's true, no matter which value is set */
			fixedHeaders: true,
			/* type="bool" footers will be fixed if this option is set to true, and only the grid data will be scrollable. If virtualization is enabled, fixedFooters will always act as if it's true, no matter which value is set */
			fixedFooters: true,
			/* type="string" caption text that will be shown above the grid header */
			caption: null,
			/* type="object" a list of grid features definitions: sorting, paging, etc. Each feature goes with its separate options that are documented for the feature accordingly */
			features: [
				{
					/* feature options object */
				}
			],
			/* type="number" initial tabIndex attribute that will be set on the container element */
			tabIndex: 0,
			/* type="bool" *** IMPORTANT DEPRECATED ***
			This option has been deprecated as of the June 2015 service release. Accessibility rendering is always performed by the igGrid as of version 14.2. */
			accessibilityRendering: false,
			/* type="bool" if this option is set to false, the data to which the grid is bound will be used "as is" with no additional transformations based on columns defined */
			localSchemaTransform: true,
			/* type="string" primary key name of the column containing unique identifiers */
			primaryKey: null,
			/* type="bool" if true, the transaction log will always be sent in the request for remote data, by the data source. Also this means that if there are values in the log, a POST will be done instead of GET */
			serializeTransactionLog: true,
			/* type="bool" automatically commits the transactions as rows/cells are being edited */
			autoCommit: false,
			/* type="bool" if set to true, the following behavior will take place:
				if a new row is added, and then deleted, there will be no transaction added to the log 
				if a new row is added, edited, then deleted, there will be no transaction added to the log
				if several edits are made to a row or an individual cell, this should result in a single transaction
				Note: This option takes effect only when autoCommit is set to false.
			*/
			aggregateTransactions: false,
			/* type="date|number|dateandnumber|true|false" Sets gets ability to automatically format text in cells for numeric and date columns. The format patterns and rules for numbers and dates are defined in $.ig.regional.defaults object.
				date formats only Date columns
				number formats only number columns
				dateandnumber type="string"
				true type="bool" formats Date and number columns
				false type="bool" auto formatting is disabled
			*/
			autoFormat: 'date',
			/* type="bool" Gets sets ability to render checkboxes and use checkbox editor when dataType of a column is "bool". That option is not available when jQueryTemplating is used. */
			renderCheckboxes: false,
			/* type="string" URL to which updating requests will be made. If autoCommit is true, updates will be done immediately to the data source, without keeping interim transaction logs */
			updateUrl: null,
			/* Settings related to REST compliant update routine */
			restSettings: {
				/* Settings for create requests */
				create: {
					/* type="string" specifies a remote URL to which create requests will be sent. This will be used for both batch and non-batch, however if template is also set, this URL will only be used for batch requests. */
					url: null,
					/* type="string" specifies a remote URL template. Use ${id} in place of the resource id. */
					template: null,
					/* type="bool" specifies whether create requests will be sent in batches */
					batch: false
				},
				/* Settings for update requests */
				update: {
					/* type="string" specifies a remote URL to which update requests will be sent. This will be used for both batch and non-batch, however if template is also set, this URL will only be used for batch requests. */
					url: null,
					/* type="string" specifies a remote URL template. Use ${id} in place of the resource id. */
					template: null,
					/* type="bool" specifies whether update requests will be sent in batches */
					batch: false
				},
				/* Settings for remove requests */
				remove: {
					/* type="string" specifies a remote URL to which remove requests will be sent. This will be used for both batch and non-batch, however if template is also set, this URL will only be used for batch requests. */
					url: null,
					/* type="string" specifies a remote URL template. Use ${id} in place of the resource id. */
					template: null,
					/* type="bool" specifies whether update requests will be sent in batches */
					batch: false
				},
				/* type="bool" specifies whether the ids of the removed resources are send through the request URI */
				encodeRemoveInRequestUri: true,
				/* type="function" specifies a custom function to serialize content sent to the server. It should accept a single object or an array of objects and return a string. If not specified, JSON.stringify() will be used. */
				contentSerializer: null,
				/* type="string" specifies the content type of the request */
				contentType: 'application/json; charset=utf-8'
			},
			/* type="bool" enables/disables rendering of alternating row styles (odd and even rows receive different styling). Note that if a custom jQuery template is set, this has no effect and CSS for the row should be adjusted manually in the template contents.  */
			alternateRowStyles: true,
			/* type="bool"  If autofitLastColumn is true and all columns' widths are specified and their combined width is less than the grid width then the last column width will be automatically adjusted to fill the entire grid. */
			autofitLastColumn: true,
			/* type="bool"  enables/disables rendering of ui-state-hover classes when the mouse is over a record. this can be useful in templating scenarios, for example, where we don't want to apply hover styling to templated content */
			enableHoverStyles: true,
			/* type="bool" enables formatting of the dates as UTC. Note that this may be desirable when the dates are coming from a backend, encoded as UTC. Otherwise, if dates are created on the client (in the browser), most probably keeping enableUTCDates to false is the desired behavior */
			enableUTCDates: false,
			/* type="bool" Merge unbound columns values inside datasource when data source is remote. If true then the unbound columns are merged to the datasource at runtime - indeed DataSource is expanded with the new data and this could cause performance issues when dataSource is huge, if false then the unbound data is sent to the client */
			mergeUnboundColumns: false,
			/* type="bool" When dataSource is string defines whether to set data source of type JSONP */
			jsonpRequest: false,
			/* type="bool" enables/disables check for resizing grid container */
			enableResizeContainerCheck: true,
			/* type="none|desktopOnly|always" Configures how the feature chooser icon should display on header cells - e.g. to display as gear icon or to not show gear icon but on click/tap the header cell to show the feature chooser
			none type="string" Always hide the feature chooser icon; The feature chooser is shown on tapping/clicking the column header
			desktopOnly type="string" Always show the icon on desktop but hide when touch device detected
			always type="string" Always show it in any environment. Chooser is shown when tapping the gear icon or column header
			*/
			featureChooserIconDisplay: 'desktopOnly'
		},
		events: {
			/* Event fired when a cell is clicked.
			Function takes arguments evt and ui.
			Use ui.cellElement to get reference to cell DOM element.
			Use ui.rowIndex to get row index.
            Use ui.rowKey to get the row key.
			Use ui.colIndex to get column index of the DOM element.
            Use ui.colKey to get the column key.
			Use ui.owner to get reference to igGrid.
			*/
			cellClick: "cellClick",
			/* Event fired when a cell is right clicked.
			Function takes arguments evt and ui.
			Use ui.cellElement to get reference to cell DOM element.
			Use ui.rowIndex to get row index.
            Use ui.rowKey to get the row key.
			Use ui.colIndex to get column index of the DOM element.
            Use ui.colKey to get the column key.
			Use ui.row to get reference to row DOM element.
			Use ui.owner to get reference to igGrid.
			*/
			cellRightClick: "cellRightClick",
			/* cancel="true" Event fired before data binding takes place.
			Return false in order to cancel data binding.
			Function takes arguments evt and ui.
			Use ui.owner to get reference to igGrid.
			Use ui.dataSource to get reference to the igDataSource object.
			*/
			dataBinding: "dataBinding",
			/* Event fired after data binding is complete.
			Function takes arguments evt and ui.
			Use ui.owner to get reference to igGrid.
			Use ui.dataSource to get reference to the igDataSource object.
			*/
			dataBound: "dataBound",
			/* Event fired before the grid starts rendering (all contents).
			This event is fired only when the grid is being initialized. 
			It will not be fired if the grid is rebound to its data 
			(for example, when calling the dataBind() API method 
			or when changing the page size (when paging is enabled)).
			
			Return false in order to cancel grid rendering.
			Function takes arguments evt and ui.
			Use ui.owner to get reference to igGrid.
			*/
			rendering: "rendering",
			/* Event fired after the whole grid widget has been rendered (including headers, footers, etc.).
			This event is fired only when the grid is being initialized. 
			It will not be fired if the grid is rebound to its data 
			(for example, when calling the dataBind() API method 
			or when changing the page size (when paging is enabled)).
			
			Function takes arguments evt and ui.
			Use ui.owner to get reference to igGrid.
			*/
			rendered: "rendered",
			/* cancel="true" Event fired before the TBODY holding the data records starts its rendering.
			Return false in order to cancel data records rendering.
			Function takes arguments evt and ui.
			Use ui.owner to get reference to igGrid.			
			*/
			dataRendering: "dataRendering",
			/* Event fired after all of the data records in the grid table body have been rendered. 
			Function takes arguments evt and ui.
			Use ui.owner to get reference to igGrid.	
			*/
			dataRendered: "dataRendered",
			/* cancel="true" Event fired before the header starts its rendering.
			Return false in order to cancel header rendering.
			Function takes arguments evt and ui.
			Use ui.owner to get reference to igGrid.	
			*/
			headerRendering: "headerRendering",
			/* Event fired after the header has been rendered.
			Function takes arguments evt and ui.
			Use ui.owner to get reference to igGrid.
			Use ui.table to get reference to headers table DOM element.
			*/
			headerRendered: "headerRendered",
			/* cancel="true" Event fired before the footer starts its rendering.
			Return false in order to cancel footer rendering.
			Function takes arguments evt and ui.
			Use ui.owner to get reference to igGrid.
			*/
			footerRendering: "footerRendering",
			/* Event fired after the footer has been rendered.
			Function takes arguments evt and ui.
			Use ui.owner to get reference to igGrid.
			Use ui.table to get reference to footers table DOM element.
			*/
			footerRendered: "footerRendered",
			/* Event fired after every TH in the grid header has been rendered.
			Function takes arguments evt and ui.
			Use ui.owner to get reference to igGrid.
			Use ui.columnKey to get column key.
			Use ui.th to get reference to header cell DOM element.
			*/
			headerCellRendered: "headerCellRendered",
			/* Event fired before actual data rows (TRs) are rendered.
			Return false in order to cancel rows rendering.	
			Function takes arguments evt and ui.
			Use ui.owner to get reference to igGrid.
			Use ui.tbody to get reference to grid's table body.
			*/
			rowsRendering: "rowsRendering",
			/* Event fired after data rows are rendered.
			Function takes arguments evt and ui.
			Use ui.owner to get reference to igGrid.
			Use ui.tbody to get reference to grid's table body.
			*/
			rowsRendered: "rowsRendered",
			/* Event fired after $.ig.DataSource schema has been generated, in case it needs to be modified.
			Function takes arguments evt and ui.
			Use ui.owner to get reference to igGrid.
			Use ui.schema to get reference to data source schema.
			Use ui.dataSource to get reference to data source.
			*/
			schemaGenerated: "schemaGenerated",
			/* Event fired after the columns colection has been modified(e.g. a column is hidden)
			Function takes arguments evt and ui.
			Use ui.owner to get reference to igGrid.
			*/
			columnsCollectionModified: "columnsCollectionModified",
			/*
				event fired if there is an error in the request, when the grid is doing a remote operation,
				such as data binding, paging, sorting, etc. 
				use ui.owner to get a reference to the grid
				use ui.message to get the processed error message sent by the server
				use ui.response to get reference to the whole response object
			*/
			requestError: "requestError",
			/*
				fired when the grid is created and the initial structure is rendered (this doesn't necessarily imply the data will be there if the data source is remote) 
				use ui.owner to get a reference to the grid
			*/
			created: "igcontrolcreated",
			/*
				fired when the grid is destroyed
				use ui.owner to get a reference to the grid
			*/
			destroyed: "igcontroldestroyed"
		},
		resizeTimeout: 300,
		/* type="boolean" setting this global widget property manually to true will always remove the data table's body at once, with the risk of memory leaks in IE and FF. The advantage is much faster operations 
			that need to cleanup existing data rows, such as sorting or filtering */
		speedupDOMCleanup: false,
		/* type="boolean" configure whether to clone child element of grid when element is TABLE(necessary in some cases when destroying grid to revert to initial state) */
		cloneChildElements: false,
		widget: function () {
			/* returns the element holding the data records */
			return this.element;
		},
		/* type="boolean" Sets whether the vertical scroll position should be persisted on databind */
		_persistVirtualScrollTop: false,
		_createWidget: function (options) {
			/* !Strip dummy objects from options, because they are defined for documentation purposes only! */
			/* S.S. May 23, 2014 - Bug #172064. As of jQuery UI 1.9.0 the widget options are not copied straight up
			and the options.columns would end up pointing to the prototype.options.columns, therefore adding anything
			in the array will change igGrid.prototype leading to unexpected behavior. The following is safe as we'll create 
			the array right after we ensure that it won't just end up being a reference to igGrid.prototype.
			*/
			var cols;
			this.options.columns = null;
			this.options.features = null;
			if (options) {
				if (options.dataSource && ($.type(options.dataSource) === "array" || $.type(options.dataSource) === "object")) {
					this.tmpDataSource = options.dataSource;
					options.dataSource = null;
					this._originalOptions = options;
				}
				// M.H. 28 August 2015 Fix for bug 205195: Horizontal scrollbar is not visible when height is set
				// If autoGenerateColumns is not explicitly set and columns has at least one column defined then autoGenerateColumns is automatically set to false
				if (options.autoGenerateColumns === undefined) {
					cols = options.columns;
					if ($.type(cols) === 'array' && cols.length) {
						options.autoGenerateColumns = false;
					}
				}
			}
			$.Widget.prototype._createWidget.apply(this, arguments);
		},
		//_init: function () {
		//},
		_setOption: function (key, value) {
			var header, isScrolling, hasWidthInPercent = this._gridHasWidthInPercent(), caption, width, id;
			// handle new settings and update options hash
			//A.T. fix for bug #118369
			// ensure setting an option with the same value does nothing
			if (value === this.options[key]) {
				return;
			}
			//isScrolling = this.options.scrollbars && (this.options.height !== null || this.options.width !== null);
			//A.T. 7 Feb. 2011 - usability review changes 
			isScrolling = (this.options.height !== null || this.options.width !== null);
			$.Widget.prototype._setOption.apply(this, arguments);
			// options that are supported:
			// width, height, defaultColumnWidth, dataSource, showHeader, showFooter, header caption
			// start by throwing an error for all option changes that aren't supported after the widget has been created
			if (key === 'virtualization' || key === 'autoGenerateColumns' /*|| key === 'accessibilityRendering'*/ ||
					key === 'rowVirtualization' || key === 'columnVirtualization' || key === 'fixedHeaders' || key === 'scrollbars') {
				throw new Error($.ig.Grid.locale.optionChangeNotSupported.replace("{optionName}", key));
			}
			if (key === 'width') {
				if (isScrolling === true) {
					this.container().css('width', value);
					this.element.css('width', value);
					//A.T. 22 Feb. Fix for bug #102486 
					if (this.options.fixedHeaders) {
						this.headersTable().css('width', value);
					}
					// M.H. 21 Mar 2013 Fix for bug #136999: igGrid does not resize properly.
					if (!this._allColumnWidthsInPercentage || !hasWidthInPercent) {
						if (this.options.virtualization === true || this.options.columnVirtualization === true || this.options.rowVirtualization === true) {
							// M.H. 13 May 2014 Fix for bug #171116: Virtualization prevents width from properly being applied
							//containerWidth = this._calculateContainerWidth(false);
							id = this.id();
//							if (value && value.indexOf && value.indexOf('%') !== -1) {
//								// TODO
//							} else {
								width = parseInt(value, 10);
							//}
							this.container().find("#" + id + "_headers_v")
								.css('width', width)
								.css('max-width', width);
							this.element.css('width', width - this._scrollbarWidth());
							this._vdisplaycontainer()
								.css('width', width - this._scrollbarWidth())
								.css('max-width', width - this._scrollbarWidth());
							this._virtualcontainer()
								.css('width', width)
								.css('max-width', width);
							this._virtualcontainer().find("> colgroup > col")
								.first()
								.attr('width', width - this._scrollbarWidth());
							// M.H. 15 Aug 2013 Fix for bug #149242: Misalignment when resizing grid with summaries and virtualization
							this.container().find("#" + id + "_footer_container")
								.css('width', width)
								.css('max-width', width);
							this.container().find("#" + id + "_footers")
								.css('width', width)
								.css('max-width', width);
							// M.H. 18 Aug 2014 Fix for bug #178284: When grid width is changed using the API container isn't resized until subsequent grid resize when virtualization is enabled
							this._vhorizontalcontainer().css('width', width);
							this._gridInnerWidth = this._vdisplaycontainer().width() + this._scrollbarWidth();
						} else {
							this._gridInnerWidth = this.scrollContainer().width();
						}
					}
					// M.H. 1 Apr 2013 Fix for bug #138302: Horizontal scrollbar doesn't appear when resizing the igGrid
					if (this.options.width !== null && this.options.height !== null) {
						// M.H. 20 May 2013 Fix for bug #136999: igGrid does not resize properly.
						this._updateGridContentWidth();
					}
					this._fireInternalEvent("_gridWidthChanged");
				} else {
					throw new Error($.ig.Grid.locale.optionChangeNotScrollingGrid.replace("{optionName}", key));
				}
			} else if (key === 'height') {
				// depends if the grid is scrolling or not
				if (isScrolling === true) {
					this.scrollContainer().css('overflow-y', 'auto');
					if (this.options.autoAdjustHeight) {
						this.container().css('height', value);
						this._virtualHeightReset = true;
						this._initializeHeights();
					} else {
						this.scrollContainer().css('height', value);
					}
					// M.H. 22 Apr 2014 Fix for bug #170404: avgRowHeight is not respected when resizing the igGrid
					if (this.options.virtualization || this.options.rowVirtualization || this.options.columnVirtualization) {
						if (this.options.virtualizationMode === "fixed") {
							//this._avgRowHeight = null;
							this._buildVirtualDom();
							this.virtualScrollTo(this._startRowIndex);
						} else {
							// M.H. 14 Apr 2015 Fix for bug 192458: When virtualization is enabled and grid height is changed on window resize event rows height becomes equal to grid height
							this._updateVirtualScrollContainer();
						}
					}
					/*
					children = this.container().children();
					height = 0;
					for (i = 0; i < children.length; i++) {
						if (!$(children[i]).attr('id').endsWith('_scroll') && $(children[i]).is(':visible')) {
							height += $(children[i]).outerHeight();
						}
					}
					*/
					//$('#' + this.element[0].id + '_scroll').height(this.container().height() - height);
				} else {
					throw new Error($.ig.Grid.locale.optionChangeNotScrollingGrid.replace("{optionName}", key));
				}
			} else if (key === 'dataSource') {
				this.options.dataSource = value;
				this.dataBind();
				// M.H. 18 June 2015 Fix for bug 201338: The columns don't autosize when you change the data source.
				// when type of datasource is remote then rendering is async and autoSizeColumns should not be called here - e.g. customer should call it in dataRendered event handler
				if (this._inferOpType() !== "remote") {
					this.autoSizeColumns();
				}
			} else if (key === 'showHeader') {
				header = this.headersTable();
				// M.H. 18 Nov 2014 Fix for bug #185321: Setting showHeader to false hides the whole child band instead of hiding the header
				if (header.length > 0 && header.is('table') && header.find('tbody').length === 0) {
					if (value === true) {
						header.show();
					} else {
						header.hide();
					}
				} else {
					header = this.element.find('thead tr');
					if (value === true) {
						header.show();
					} else {
						header.hide();
					}
				}
			} else if (key === 'caption') {
				// M.H. 30 Jan 2014 Fix for bug #116158: Caption property cannot be set dynamically at runtime.
				caption = this._caption();
				if (caption.length === 0) {
					this._renderCaption();
					if (this.options.autoAdjustHeight) {
						this._initializeHeights();
					}
				} else {
					// L.A. 06 July 2012 Fixing bug #116158 Unable to change Caption dynamically at runtime
					caption.text(value);
				}
			}
		},
		_initialized: false,
		_headersInitialized: false,
		_footerInitialized: false,
		_mouseClickEventHandler: function (event, eventToTrigger) {
			var $et = $(event.target), row = $et.closest('tr'), key = row.attr("data-id"), colKey, $td, res, currGrid,
				/* L.A. 12 July 2012 - Fixing bug #116993 When cell selection is in use and 
				the user tries to edit a cell, the 3rd and each subsequent clicks on that cell 
				cause the igGrid's cellClick event handler to be fired incorrectly for the 1st 
				cell of the row
				L.A. 22 August 2012 - Fixing bug #119477 wrong cell index is returned when a checkbox
				is clicked
				*/
				colIndex = $et.closest("td").index(),
				rowIndex = row.index(),
				// M.H. 14 May 2014 Fix for bug #171207: igHierarchicalGrid when grouped by column, ui.colKey retutns the next columKey insted of the correct one
				dataColIndex = colIndex - row.children("td.ui-iggrid-expandcolumn,th,td[data-skip]").length,
				grid = this;
			// M.H. 14 May 2014 Fix for bug #171207: igHierarchicalGrid when grouped by column, ui.colKey retutns the next columKey insted of the correct one
			// we should not stop propagation for the click event because of the rowEdit template in updating (which is bound to this click event)
			// So in hierarchical grid we check whether the closest(to the clicked cell) grid has id equal to the grid.id()
			// this check should be done because when user clicks on the child bands the event is bubbled to the parent child grids
			if (grid.element.closest('.ui-iggrid-root').data('igGrid')) {
				currGrid = $et.closest(".ui-iggrid-table").data("igGrid");
				if (currGrid && grid.id() !== currGrid.id()) {
					return;
				}
			}
			if (key === "" || key === null || key === undefined) {
				key = rowIndex;
			}
			// M.H. 6 Jun 2013 Fix for bug #143586: CellClick event doesn't fire for fixed columns.
			$td = $(event.target);
			if (!$td.is('td')) {
				$td = $(event.target).closest('td');
			}
			if (grid.hasFixedColumns()) {
				if ($td.length === 1) {
					res = grid._getColumnByTD($td);
					///{column: visibleColumns[visibleInd], index: visibleInd}
					if (res !== null) {
						colKey = res.column.key;
						colIndex = res.index;
					}
				}
			} else {
				if (dataColIndex >= 0 && dataColIndex < grid._visibleColumns().length) {
					/* L.A. 12 July 2012 - Fixing bug #116909 When there's a hidden column, the igGrid's 
					cellClick event reports the ui.columnKey input arg as if there are no hidden columns*/
					colKey = grid._visibleColumns()[dataColIndex].key;
				}
			}
			// click for the main grid element; 'event' is the browser event 
			// M.H. 30 Jan 2014 Fix for bug #162408: cellClick event raises on filter textbox
			if (!$et.closest('tr').parent().is('thead') && ($et.is('td') || ($et.closest('td').length === 1 &&
					$et.closest('td').parent().attr("data-container") !== "true"))) {
				// M.H. 3 Apr 2014 Fix for bug #165339: type of PrimaryKey is always string in cellClick event
				key = grid._fixPKValue(key);
				if (grid.hasFixedColumns()) {
					row = grid._isFixedElement(row) ? row.add(this.rowAt(rowIndex)) : row.add(this.fixedRowAt(rowIndex));
				}
				// we need to conclude if the element that was clicked is a grid cell or not. As a start this check will be enough.
				grid._trigger(eventToTrigger, event, {
					'rowIndex': rowIndex,
					'rowKey': key,
					'row': row,
					'colIndex': colIndex,
					'colKey': colKey,
					'cellElement': $td[0],
					owner: grid
				});
			}
		},
		_create: function () {
			var grid = this, i, container, attr;

			this._mouseClickEventHandlers = {
				'click': function (event) {
					grid._mouseClickEventHandler(event, grid.events.cellClick);
				},
				'contextmenu': function (event) {
					grid._mouseClickEventHandler(event, grid.events.cellRightClick);
				}
			};
			// M.H. 14 June 2012 Fix for bug #114327
			this._isHierarchicalGrid = false;
			this._hasUnboundColumns = false;
			if (this.options._isHierarchicalGrid === true) {
				this._isHierarchicalGrid = true;
			}
			// M.H. 8 Jan 2014 Fix for bug #159857: Calling igGrid.destroy doesn't remove the COLGROUP, TFOOT and THEAD tags as well as some attributes on the placeholder
			if (this.cloneChildElements && this.element.is("table") && this.element.children().length > 0) {
				// we use clone because we will preserve event binding to the elements(if any) if binging is through javascript
				// if we use innerHtml then it will be faster(better for performance) but will not preserve data binding to the element inside to the table(if any)
				// on the other hand if element is table and it is used huge data content this means that clone and table
				this._initialChildren = this.element.children().clone(true);
			}
			this._initialAttributes = [];
			attr = this.element[0].attributes;
			for (i = 0; i < attr.length; i++) {
				if (attr[i].name !== 'id') {
					this._initialAttributes.push({ name: attr[i].name, value: attr[i].value });
				}
			}
			// check for RTL
			// M.H. 3 Mar 2015 Fix for bug #188215: Memory leak occurs in Sorting feature
			// when grid is instantiated on TABLE element trying to get CSS properties via jQuery.css causes memory leaks
			this._rtl = this.element[0].style.direction === "rtl";
			this._padding = this._rtl ? 'padding-left' : 'padding-right';
			if (this.tmpDataSource !== null && this.tmpDataSource !== undefined) {
				this.options.dataSource = this.tmpDataSource;
				this._originalOptions.dataSource = this.tmpDataSource;
			}
			this._testInnerHtml();
			this._headerInitCallbacks = [];
			this._footerInitCallbacks = [];
			this._cellStyleSubscribers = [];
			this._firstBind = true;
			this._isMultiColumnGrid = false;
			this._unboundValues = {};
			if (!this.options.columns) {
				this.options.columns = [];
			}
			if (!this.options.features) {
				this.options.features = [];
			}
			// analyze multicolumn headers
			if (this._isMultiColumnHeader() === true) {
				// get 2 objects - one flat representation of the columns(e.g. used for databinding and by the framework)
				// the other object is tree representation of the columns with some additional properties like colspan, rowspan
				this._isMultiColumnGrid = true;
				this._generateColumnFlatStructure(this.options.columns);
				this._headerCells = [];
			}
			//I.I. bug fix for 107647
			if (this.options.rowVirtualization === true && this.options.virtualizationMode === 'continuous') {
				this.options.virtualization = true;
			}
			//I.I. bug fix for 108205, this is by design, columnVirtualization requires virtualization to be switched on. columnVirtualization is not relevant for continuous virtualization
			if (this.options.columnVirtualization === true) {
				this.options.virtualization = true;
				if (this.options.virtualizationMode === 'continuous') {
					throw new Error($.ig.Grid.locale.colVirtualizationDenied);
				}
				this.options.virtualizationMode = 'fixed';
			}
			// virtualization always uses fixed headers 
			// S.S. May 11, 2012 #103088, Regardless of what the user sets, all virtualization uses fixed headers and fixed footers 
			// which should properly be recognized by all features
			if (this.options.virtualization === true || this.options.columnVirtualization === true || this.options.rowVirtualization === true) {
				if (this.options.virtualizationMode === undefined || this.options.virtualizationMode === '') {
					this.options.virtualizationMode = 'fixed';
				}
				if (this.options.virtualizationMode === 'fixed') {
					this.options.fixedHeaders = true;
					// M.H. 12 March 2012 Fix for bug #101222
					this.options.fixedFooters = true;
				}
			}
			// check if virtualization is enabled and there are auto-resizable columns
			// M.H. 18 June 2015 Fix for bug 201220: The grid does not throw exception when column is auto sized and virtualization is enabled.
			if (this.options.virtualization === true || this.options.rowVirtualization === true) {
				if (this.options.defaultColumnWidth === '*') {
					throw new Error($.ig.Grid.locale.virtualizationNotSupportedWithAutoSizeCols);
				}
				for (i = 0; i < this.options.columns.length; i++) {
					if (this.options.columns[i].width === '*') {
						throw new Error($.ig.Grid.locale.virtualizationNotSupportedWithAutoSizeCols);
					}
				}
			}
			//I.I. bug fix for 104408
			if (this.options.virtualization === true && this.options.virtualizationMode === 'continuous') {
				this.options.fixedHeaders = true;
			}
			/*
			if (this.options.jQueryTemplating === null && (this.options.virtualization === false && this.options.rowVirtualization === false)) {
				this.options.jQueryTemplating = true;
			} else if (this.options.jQueryTemplating === null && (this.options.virtualization === true || this.options.rowVirtualization === true)) {
				this.options.jQueryTemplating = false;
			}
			*/
			if ((this.options.height === null || parseInt(this.options.height, 10) <= 0) && this.options.fixedHeaders === true) {
				this.options.fixedHeaders = false;
			}
			// M.H. 12 March 2012 Fix for bug #101222
			if ((this.options.height === null || parseInt(this.options.height, 10) <= 0) && this.options.fixedFooters === true) {
				this.options.fixedFooters = false;
			}
			/*
			if (this.options.alternateRowStyles === null && (this.options.virtualization === true || this.options.rowVirtualization === true)) {
				this.options.alternateRowStyles = false;
			} else if (this.options.alternateRowStyles === null) {
				this.options.alternateRowStyles = true;
			}
			*/
			// trigger an internal data bind call
			this.dataBind(true);

			this.element.bind(this._mouseClickEventHandlers);
			// auto adjusting heights when resizing and the grid height is defined with a percentage. In that case we need to either use a timeout
			// or resize (which only works in IE)
			// M.H. 17 Dec 2013 Fix for bug #151256: Performance issues caused by _resizeContainer function
			if (this.options.enableResizeContainerCheck &&
				((this.options.height !== null && this.options.height.indexOf && this.options.height.indexOf('%') !== -1) ||
				(this.options.width !== null && this.options.width.indexOf && this.options.width.indexOf('%') !== -1) ||
				!this.element.is(':visible'))) {
				// M.H. 26 Jul 2013 Fix for bug #146837: Vertical scroll bar does not display when control inside the Jquery UI tab
				if (!this.element.is(':visible')) {
					this._recheckVisibility = true;
				}
				// M.H. 17 Dec 2013 Fix for bug #151256: Performance issues caused by _resizeContainer function
				if ($.ig.util.isIE) {
					container = this.container();
					if (container.length > 0 && container[0].attachEvent) {
						this._resizeContainerHandler = $.proxy(this.resizeContainer, this);
						container[0].attachEvent("onresize", this._resizeContainerHandler);
					}
				}
				if (!this._resizeContainerHandler) {
					this._resId = setInterval($.proxy(this.resizeContainer, this), this.resizeTimeout);
				}
			}
			//set default value for column.hidden
			for (i = 0; i < this.options.columns.length; i++) {
				if (this.options.columns[i].hidden === undefined) {
					this.options.columns[i].hidden = false;
				}
			}
			// listen to soft dispose. If a feature is of local type, but the invoking one is of remote type, the local one must be marked as fully dirty
			// example: sorting a column when sorting is local and then changing the page index when paging is remote
			this._uiSoftDirtyHandler = $.proxy(this._onFeaturesSoftDirty, this);
			this.element.bind('iggriduisoftdirty', this._uiSoftDirtyHandler);
			this._oldScrollTop = 0;
			// trigger created event
			this.element.trigger(this.events.created, {
				owner: this
			});
			// set the rtl class
			if (this._rtl) {
				this.container().addClass(this.css.rtl);
			}
		},
		_fixPKValue: function (val) {
			/* returns parsed to int val when the primary key is of type number(otherwise returns val)
				paramType="string" value of the primary key
				returnType="string|number" value of the primary key
			*/
			var col, data, pk = this.options.primaryKey;
			if (_aNull(val)) {
				return null;
			}
			if (pk) {
				col = this.columnByKey(pk);
				if (col && col.dataType) {
					if (col.dataType === "number" || col.dataType === "numeric") {
						val = parseInt(val, 10);
					}
				} else {
					data = this.dataSource._data;
					if (data && data.length > 0) {
						if (typeof data[0][pk] === 'number') {
							val = parseInt(val, 10);
						}
					}
				}
			} else {
				data = this.dataSource._data;
				if (data && data.length > 0) {
					if (typeof data[0].ig_pk === "number") {
						val = parseInt(val, 10);
			}
				}
			}
			return val;
		},
		hasFixedDataSkippedColumns: function () {
			/* returns whether grid has non-data fixed columns(e.g. row selectors column)
				returnType="bool"
			*/
			return !!this._hasFixedDataSkippedColumns;
		},
		hasFixedColumns: function () {
			/* returns whether grid has fixed columns(even if a non-data column - like row-selectors column- is fixed)
			   returnType="bool" 
			*/
			if (this._hasFixedDataSkippedColumns || (!_aNull(this._fixedColumns) && this._fixedColumns.length > 0)) {
				return true;
			}
			return false;
		},
		fixingDirection: function () {
			/* returns the current fixing direction or null if there are no fixed columns
				returnType="left|right|null"
			*/
			var hasFixedCols = this.hasFixedColumns();
			return hasFixedCols ? this.fixedBodyContainer().attr("data-fixing-direction") : null;
		},
		isFixedColumn: function (colKey) {
			/* returns whether the column with identifier colKey is fixed 
				paramType="number|string" An identifier of the column which should be checked. It can be a key or visible index.
				returnType="bool"
			*/
			var isFixed = false, typeColKey = $.type(colKey), cols;

			if (!this.hasFixedColumns()) {
				return false;
			}
			if (typeColKey === 'string') {
				$.each(this._fixedColumns, function (ind, c) {
					if (c.key === colKey) {
						isFixed = true;
						return false;// break
					}
				});
			} else if (typeColKey === 'number') {
				cols = this._visibleColumns();
				if (colKey < 0 || colKey >= cols.length) {
					return false;
				}
				isFixed = (cols[colKey].fixed === true);
			}
			return isFixed;
		},
		_onColumnFixed: function (colInd, isFixed, colsCount, isInit, visibleIndex, at) {
			var result = {
					colInd: colInd,
					isFixed: isFixed,
					fixedColsCount: colsCount,
					isInit: isInit,
					visibleIndex: visibleIndex,
					at: at
			};
			this._fireInternalEvent("_columnFixed", result);
		},
		_onGroupedColumnsChanging: function (groupedColumns) {
			this._fireInternalEvent("_groupedColumnsChanging", { groupedColumns: groupedColumns });
		},
		_onGroupedColumnsChanged: function (groupedColumns) {
			this._fireInternalEvent("_groupedColumnsChanged", { groupedColumns: groupedColumns });
		},
		_testInnerHtml: function () {
			var t = document.createElement("table");
			try {
				t.innerHTML = "<tr><td> t </td></tr>";
				this._canreplaceinner = true;
			} catch (e) {
				this._canreplaceinner = false;
			}
		},
		resizeContainer: function () {
			/* Called to detect whether grid container is resized. When autoAdjustHeight is true and height of the grid is changed then the height of grid is re-set.
			*/
			var scrollContainerWidth,
				o = this.options, visibilityChanged = false,
				v = o.virtualization === true || o.rowVirtualization === true || o.columnVirtualization === true;
			// M.H. 26 Jul 2013 Fix for bug #146837: Vertical scroll bar does not display when control inside the Jquery UI tab
			// when grid has not been visible on init then we should re-init heights
			if (this._recheckVisibility && this.element.is(':visible')) {
				this._prevContainerHeight = 0;
				visibilityChanged = true;
				this._recheckVisibility = false;
				// M.H. 17 Dec 2013 Fix for bug #151256: Performance issues caused by _resizeContainer function
				if (this._resId &&
					!((this.options.height !== null && this.options.height.indexOf && this.options.height.indexOf('%') !== -1) ||
					(this.options.width !== null && this.options.width.indexOf && this.options.width.indexOf('%') !== -1))) {
					clearInterval(this._resId);
				}
			}
			if (o.autoAdjustHeight && this.container().height() !== this._prevContainerHeight) {
				this._initializeHeights();
				if (v && visibilityChanged) {
					// M.H. 26 Jul 2013 Fix for bug #148282: When continuous virtualization is enabled and grid is initially hidden, on showing scrollbar is not proporly set
					this._avgRowHeight = null;
					// M.H. 1 June 2015 Fix for bug 194189: Data content doesn’t appear if the tab containing the igGrid isn’t selected/displayed when data binding.
					// if virtual records are not rendered
					if (!this.container().find('#' + this.id() + ' > tbody > tr:not([data-container]):visible:first').length) {
						// in case of fixed virtualization this._virtualDom is empty array - we should delete it so to re-build virtual DOM
						delete this._virtualDom;
						this._renderVirtualRecords();
					}
					this._updateVirtualScrollContainer();
					this._onVirtualVerticalScroll();
				}
			}
			if (o.width !== null && o.height !== null) {
				if (v === false) {
					scrollContainerWidth = this.scrollContainer().width();
				} else {
					scrollContainerWidth = this._vdisplaycontainer().width() + this._scrollbarWidth();
				}
				//A.T. 10 May 2012 - Fix for bug #111407 
				// L.A. 31 October 2012 - Fixing bug #125617
				// setting height property on grid causes a horizontal scroll bar placeholder to render
				if (this._gridInnerWidth !== scrollContainerWidth && (this._gridInnerWidth > 0 || scrollContainerWidth > 0)) {
					this._gridInnerWidth = scrollContainerWidth;
					this._updateHScrollbarVisibility();
				}
				if (v === false && (this.scrollContainer().get(0).scrollHeight >
					this.scrollContainer().get(0).clientHeight) !== this._hasVerticalScrollbar) {
					this._adjustLastColumnWidth();
				}
			}
		},
		_isMultiColumnHeader: function () {
			// checks whether the grid has multicolumn headers - checks whether in columns definition some of the columns on the root level has property group
			var cols = this.options.columns, i;
			for (i = 0; i < cols.length; i++) {
				if (cols[i].group !== undefined && cols[i].group !== null) {
					return true;
				}
			}
			return false;
		},
		// cols - current level of cols (the function is recursive),
		// newCols - flat list of columns at level 0
		// level - current level, oldCols - cols(which are passed to the grid.options.columns) with analyzed, colspan and level
		// children - list of children for each multicolumn header
		_analyzeMultiColumnHeaders: function (cols, newCols, level, oldCols, children, isHidden) {
			// analyze multicolumn headers - get colspans for multicolumn headers, set level for each header column and gets flat list of columns on level 0
			// sets identifier for each column - if column does not have key(even if multicolumn header) then it is set auto generated key
			// we need of keys to get easier cells and in some features - like resizing, hiding, column moving
			var i, j, res, colsLength = cols.length, colspan = 0, ind = [], groupChildren = [], identifier, hidden;
			for (i = 0; i < colsLength; i++) {
				if (cols[i].group !== undefined && cols[i].group !== null) {
					if (cols[i].key !== undefined && cols[i].key !== null) {
						// M.H. 4 July 2012 Fix for bug #116254 - column indentifier should be string
						identifier = cols[i].key.toString();
					} else {
						// M.H. 4 July 2012 Fix for bug #116254 - column indentifier should be string
						identifier = (this._multiColumnIdentifier++).toString();
					}
					if (!cols[i].identifier) {
					cols[i].identifier = identifier;
					}
					groupChildren = [];
					hidden = false;
					if (isHidden === true || cols[i].hidden === true) {
						hidden = true;
					}
					res = this._analyzeMultiColumnHeaders(cols[i].group, newCols, level + 1, oldCols[i].group, groupChildren, hidden);

					oldCols[i].colspan = res.colspan;
					oldCols[i].children = groupChildren;
					for (j = 0; j < groupChildren.length; j++) {
						children.push(groupChildren[j]);
					}
					ind.push(i);
					colspan += res.colspan;
				} else {
					colspan++;
					oldCols[i].level = 0;
					oldCols[i].level0 = true;
					if (isHidden === true) {
						cols[i].hidden = true;
					}
					children.push(cols[i]);
					newCols.push(cols[i]);
				}
			}
			for (j = 0; j < ind.length; j++) {
				oldCols[ind[j]].level = this._maxLevel - level;
			}
			return { colspan: colspan };
		},
		_getMultiHeaderColumnById: function (id, level, cols) {
			// get multi column header by id
			// if level specified search for the specified level
			var i, colsLength, res = null;
			if (cols === null || cols === undefined) {
				// M.H. 12 Dec 2012 Fix for bug #129344
				if (this._oldCols === null || this._oldCols === undefined) {
					return null;
				}
				cols = this._oldCols;
			}
			colsLength = cols.length;
			for (i = 0; i < colsLength; i++) {
				if (cols[i].identifier === id && (level === undefined || cols[i].level === level)) {
					return cols[i];
				}
				if (cols[i].group !== null && cols[i].group !== undefined) {
					res = this._getMultiHeaderColumnById(id, level, cols[i].group);

					if (res !== null) {
						return res;
					}
				}
			}
			return null;
		},
		_getMaxLevelRecursive: function (level, cols) {
			// get how deep multicolumn headers are
			var i, colsLength = cols.length, ml = level, l, rowspan;
			for (i = 0; i < colsLength; i++) {
				// M.H. 8 Aug 2012 Fix for bug #118599
				rowspan = 1;
				if (cols[i].rowspan !== null && cols[i].rowspan !== undefined && cols[i].rowspan > 0) {
					rowspan = cols[i].rowspan;
				}
				if (cols[i].group !== undefined && cols[i].group !== null) {
					l = this._getMaxLevelRecursive(level + rowspan, cols[i].group);
					if (l > ml) {
						ml = l;
					}
				} else if (rowspan > 0) {
					// M.H. 8 Aug 2012 Fix for bug #118599
					l = level + rowspan - 1;
					if (l > ml) {
						ml = l;
					}
				}
			}
			return ml;
		},
		// the second argument specifies whether data will be appended or prepended. the default is prepend. 
		_headerInit: function (tr, colgroup, prepend) {
			// different features that require extra cells such as group by, may register callbacks here
			// that will be called whenever a feature like filter row or add new row renders its logic
			var i;
			for (i = 0; i < this._headerInitCallbacks.length; i++) {
				this._headerInitCallbacks[i].func(tr, colgroup, prepend);
			}
		},
		_footerInit: function (tr, colgroup, prepend, cssClass) {
			// different features that require extra cells such as group by, may register callbacks here
			// that will be called whenever a feature like filter row or add new row renders its logic
			var i;
			for (i = 0; i < this._footerInitCallbacks.length; i++) {
				this._footerInitCallbacks[i].func(tr, colgroup, prepend, cssClass);
			}
		},
		id: function () {
			/* returns the ID of the TABLE element where data records are rendered 
				returnType="string" 
			*/
			return this.element[0].id;
		},
		// returns the grid caption element (above the headers table)
		_caption: function () {
			return this.container().find("caption");
		},
		_rootContainer: function () {
			var rootElement;
			if (!this._rContainer || this._rContainer.length === 0) {
				rootElement = this.element.closest(".ui-iggrid-root");
				this._rContainer = rootElement.length === 1 ? rootElement.data("igGrid").container() : this.container();
			}
			return this._rContainer;
		},
		container: function () {
			/* returns the DIV that is the topmost container of the grid widget
				returnType="dom"
			*/
			//if (this._isWrapped === true) {
			//	return this.element;
			//} else {
			//return $('#' + this.element[0].id + '_container');
			if (!this._container || this._container.length === 0) {
				this._container = this.element.closest("div[id=" + this.id() + "_container]");
			}
			return this._container;
			//}
		},
		headersTable: function () {
			/* returns the table that contains the header cells 
				returnType="dom"
			*/
			if (this.options.fixedHeaders === true && this.options.height !== null) {
				//return $('#' + this.element[0].id + '_headers');
				return this.container().find("#" + this.id() + "_headers");
			}
			return this.element;
		},
		footersTable: function () {
			/* returns the table that contains the footer cells 
				returnType="dom"
			*/
			if (this.options.fixedFooters === true && this.options.height !== null) {
				//return $('#' + this.element[0].id + '_footers');
				return this.container().find("#" + this.id() + "_footers");
			}
			return this.element;
		},
		scrollContainer: function () {
			/* returns the DIV that is used as a scroll container for the grid contents
				returnType="dom"
			*/
			//return $('#' + this.element[0].id + '_scroll');
			return this.container().children("#" + this.id() + "_scroll");
		},
		fixedContainer: function () {
			/* returns the DIV that is the topmost container of the fixed grid - contains fixed columns(in ColumnFixing scenario)
				returnType="dom"
			*/
			return this.container().find("#" + this.id() + "_mainFixedContainer");
		},
		fixedBodyContainer: function () {
			/* returns the DIV that is the topmost container of the fixed body grid - contains fixed columns(in ColumnFixing scenario)
				returnType="dom"
			*/
			return this.container().find("#" + this.id() + "_fixedBodyContainer");
		},
		fixedFooterContainer: function () {
			/* returns container(jQuery representation) containing fixed footer - contains fixed columns(in ColumnFixing scenario)
				returnType="object" jQuery representation of fixed table
			*/
			return this.container().find("#" + this.id() + "_fixedFooterContainer");
		},
		fixedHeaderContainer: function () {
			/* returns container(jQuery representation) containing fixed header - contains fixed columns(in ColumnFixing scenario)
				returnType="object" jQuery representation of fixed table
			*/
			return this.container().find("#" + this.id() + "_fixedHeaderContainer");
		},
		fixedHeadersTable: function () {
			/* returns the table that contains the FIXED header cells - contains fixed columns(in ColumnFixing scenario)
				returnType="dom"
			*/
			if (this.options.fixedHeaders === true && this.options.height !== null) {
				return this.container().find("#" + this.id() + "_headers_fixed");
			}
			return this.container().find("#" + this.id() + "_fixed");
		},
		fixedFootersTable: function () {
			/* returns the table that contains the footer cells - contains fixed columns(in ColumnFixing scenario)
				returnType="dom"
			*/
			if (this.options.fixedFooters === true && this.options.height !== null) {
				return this.container().find("#" + this.id() + "_footers_fixed");
			}
			return this.container().find("#" + this.id() + "_fixed");
		},
		_vdisplaycontainer: function () {
			return this.container().find("#" + this.id() + "_displayContainer");
		},
		_virtualcontainer: function () {
			return this.container().find("#" + this.id() + "_virtualContainer");
		},
		_vhorizontalcontainer: function () {
			return this.container().find("#" + this.id() + "_horizontalScrollContainer");
		},
		_fixedfooters: function () {
			return this.container().find("#" + this.id() + "_footer_container");
		},
		// Accepts parameters:
		// x - column index
		// y - row index
		// isFixed - defines whether to get cell from fixed table
		cellAt: function (x, y, isFixed) {
			/* returns the cell TD element at the specified location
				paramType="number" The column index.
				paramType="number" The row index.
				paramType="bool" Optional parameter - if true get cell TD at the specified location from the fixed table
				returnType="dom" The cell at (x, y).
			*/
			var i, row;
			// returns a cell at the specified location in the table. jQuery selectors are not used for performance reasons. 
			if (x === undefined || y === undefined) {
				return null;
			}
			//return this.element.find('tbody tr:nth-child(' + (y + 1) + ') td:nth-child(' + (x + 1) + ')');
			if (this.table === undefined) {
				this.table = this.element[0];
			}
			//A.T. 21 Jan 2011 - We must account for all THEAD and TFOOT rows ! . Calculate that only once, for perf. reasons
			i = this._dataRowIndex(y);
			if (isFixed === true) {
				if (this._fixedTable === undefined) {
					this._fixedTable = this.element;
				}
				return this._fixedTable[0].rows[i].cells[x];
			}
			row = this.table.rows[i];
			if (!row) {
				return null;
			}
			return row.cells[x];
		},
		cellById: function (rowId, columnKey) {
			/* returns the cell TD element by row id and column key
				paramType="number|string" The id of the row.
				paramType="string" The column key.
				returnType="dom" The cell for (rowId, columnKey).
			*/
			var colIndex, i, cols, row, skippedCells, isFixed = this.isFixedColumn(columnKey),
				sci = this._startColIndex || 0;
			if (_aNull(rowId) || _aNull(columnKey)) {
				return null;
			}
			if (this.table === undefined) {
				this.table = this.element[0];
			}
			cols = this._visibleColumns(isFixed);
			for (i = 0; i < cols.length; i++) {
				if (cols[i].key === columnKey) {
					colIndex = i;
					break;
				}
			}
			if (_aNull(colIndex)) {
				return null;
			}
			if (isFixed) {
				row = this.fixedBodyContainer().find("tbody").first().children("[data-id='" + rowId + "']").first();
			} else {
				row = this.element.children("tbody").children("[data-id='" + rowId + "']").first();
			}
			skippedCells = row.children("th,[data-skip=true],[data-parent]").length;
			return row.children("td:nth-child(" + (colIndex + 1 + skippedCells - sci) + ")");
		},
		// Returns fixed table
		fixedTable: function () {
			/* returns the fixed table - contains fixed columns(in ColumnFixing scenario). If there aren't fixed columns returns the grid table
				returnType="object" jQuery representation of fixed table
			*/
			if (this._fixedTable === undefined) {
				this._fixedTable = this.element;
			}
			return this._fixedTable;
		},
		_calculateHeaderFooterRows: function () {
			// A.T. 29 Aug 2011 - this is recursive and needs to be reworked 
			//return this.element.find('thead tr').length + this.element.find('tfoot tr').length;
			var theadCount = 0, tfootCount = 0;
			theadCount = this.element.children("thead").children("tr").length;
			// M.H. 11 Oct. 2011 Fix for bug #90863 - footer  rows count should not be calculated
			// M.H. 27 April 2012 Fix for bug #105427 - Opera counts tfoot rows then tbody tr
			if ($.ig.util.isOpera) {
				tfootCount = this.element.children("tfoot").children("tr").length;
			}
			return theadCount + tfootCount;
		},
		_dataRowIndex: function (i) {
			var extrahr, j;
			if (this.table === undefined) {
				this.table = this.element[0];
			}
			if (this._additionalTrCount === undefined || this._additionalTrCount === null) {
				this._additionalTrCount = this._calculateHeaderFooterRows();
			}
			// get all data-container rows and exclude them
			if (this._hc === true) {
				extrahr = this.element.children("tbody").children("tr[data-container]");
				for (j = 0; j < extrahr.length; j++) {
					if ($(extrahr[j]).index() <= i) {
						i += 1;
					}
				}
			}
			i = i + this._additionalTrCount;
			if (i >= this.table.rows.length) {
				i = this.table.rows.length - 1;
			} else if (i < 0) {
				i = 0;
			}
			return i;
		},
		immediateChildrenWidgets: function () {
			/* gets all immediate igGrid children of the current grid
				returnType="array"
			*/
			return this.element.children("tbody").children("tr").children(".ui-iggrid-childarea").children("div").children("div").map(function () {
				if ($(this).children(".ui-iggrid-scrolldiv").length > 0) {
					return $(this).children(".ui-iggrid-scrolldiv").children(".ui-iggrid-table").data("igGrid");
				}
				return $(this).children(".ui-iggrid-table").data("igGrid");
			});
		},
		childrenWidgets: function () {
			/* gets all igGrid children of the current grid, recursively 
				returnType="array"
			*/
			return this.element.find("tbody > tr > .ui-iggrid-childarea").find(".ui-iggrid-table").map(function () {
				return $(this).data("igGrid");
			});
		},
		children: function () {
			/* gets all igGrid children's elements of the current grid, recursively 
				returnType="array"
			*/
			return this.element.find("tbody > tr > .ui-iggrid-childarea").find(".ui-iggrid-table");
		},
		immediateChildren: function () {
			/* gets all immediate igGrid children's elements of the current grid
				returnType="array"
			*/
			return this.element.children("tbody").children("tr").children(".ui-iggrid-childarea").children("div").children("div").map(function () {
				if ($(this).children(".ui-iggrid-scrolldiv").length > 0) {
					return $(this).children(".ui-iggrid-scrolldiv").children(".ui-iggrid-table");
				}
				return $(this).children(".ui-iggrid-table");
			});
		},
		// Accepts parameters:
		// i - row index 
		rowAt: function (i) {
			/* returns the row (TR element) at the specified index. jQuery selectors aren't used for performance reasons 
				paramType="number" The row index.
				returnType="dom" the row at the specified index
			*/
			//A.T. 21 Jan 2011 - We must account for all THEAD and TFOOT rows ! . Calculate that only once, for perf. reasons
			i = this._dataRowIndex(i);
			return this.table.rows[i];
		},
		rowById: function (rowId, isFixed) {
			/* returns the row TR element by row id
				paramType="number|string" The id of the row.
				paramType="bool" optional="true" Specify search in the fixed container.
				returnType="dom" The row for (rowId).
			*/
			if (_aNull(rowId)) {
				return null;
			}
			if (isFixed) {
				return this.fixedBodyContainer().find("tbody").first().children("[data-id='" + rowId + "']").first();
			}
			return this.element.children("tbody").children("[data-id='" + rowId + "']").first();
		},
		// Accepts parameters:
		// i - row index 
		fixedRowAt: function (i) {
			/* returns the fixed row (TR element) at the specified index. jQuery selectors aren't used for performance reasons(in ColumnFixing scenario - only when there is at least one fixed column)
				paramType="number" The row index.
				returnType="dom" the row at the specified index
			*/
			// M.H. 22 Aug 2013 Fix for bug #145764: The rowAt method returns only the unfixed row when there is fixed columns.
			var rows = this.fixedBodyContainer().find('tbody>tr');
			if (rows.length > 0) {
				return rows[i];
			}
			return null;
		},
		fixedRows: function () {
			/* returns a list of all fixed TR elements holding data in the grid(in ColumnFixing scenario - only when there is at least one fixed column)
				returnType="array"
			*/
			// M.H. 23 Jul 2013 Fix for bug #143616: The row element that is returned by activeRow method is only from the unfixed area.
			return this.fixedBodyContainer().find('tbody>tr');
		},
		rows: function () {
			/* returns a list of all TR elements holding data in the grid(when there is at least one fixed column returns rows only in the UNFIXED table)
				returnType="array"
			*/
			//return this.element.find('tbody tr');
			return this.element.children("tbody").children("tr");
		},
		allFixedRows: function () {
			/* returns all data fixed rows recursively, not only the immediate ones(in ColumnFixing scenario - only when there is at least one fixed column)
				returnType="array"
			*/
			// M.H. 23 Jul 2013 Fix for bug #143616: The row element that is returned by activeRow method is only from the unfixed area.
			return this.fixedBodyContainer().find('tbody tr');
		},
		allRows: function () {
			/* returns all data rows recursively, not only the immediate ones(when there is at least one fixed column returns rows only in the UNFIXED table)
				returnType="array"
			*/
			return this.element.find('tbody tr');
		},
		columnByKey: function (key) {
			/* returns a column object by the specified column key 
				paramType="string" The column key.
				returnType="object" a column definition
			*/
			var cols = this.options.columns, i;
			for (i = 0; i < cols.length; i++) {
				// L.A. 07 December 2012 - Fixing bug #129117 When you use DOM table as a data 
				// source for the grid and redefine the header of a column in columnSettings it 
				// duplicates the column with the new header text.
				// Features like column moving, sorting and etc are passing key as string
				if (String(cols[i].key) === String(key)) {
					return cols[i];
				}
			}
			return null;
		},
		columnByText: function (text) {
			/* Returns a column object by the specified header text. If there are multiple matches, returns the first one.
				paramType="string" The column header text.
				returnType="object" a column definition
			*/
			var cols = this.options.columns, i;
			for (i = 0; i < cols.length; i++) {
				if (cols[i].headerText === text) {
					return cols[i];
				}
			}
			return null;
		},
		selectedCells: function () {
			/* returns an array of selected cells in arbitrary order where every objects has the format { element: , row: , index: , rowIndex: , columnKey: } .
				If multiple selection is disabled the function will return null.
				returnType="array"
			*/
			if (this._selection.settings.owner !== this) {
				return [];
			}
			return this._selection.settings.multipleSelection ? this._selection.selectedCells() : null;
		},
		selectedRows: function () {
			/* returns an array of selected rows in arbitrary order where every object has the format { element: , index: } .
				If multiple selection is disabled the function will return null.
				returnType="array"
			*/
			if (this._selection.settings.owner !== this) {
				return [];
			}
			return this._selection.settings.multipleSelection ? this._selection.selectedRows() : null;
		},
		selectedCell: function () {
			/* returns the currently selected cell that has the format { element: , row: , index: , rowIndex: , columnKey: }, if any.
				If multiple selection is enabled the function will return null.
				returnType="object"
			*/
			var selectedCells;
			if (this._selection.settings.owner !== this) {
				return null;
			}
			selectedCells = this._selection.selectedCells();
			return this._selection.settings.multipleSelection ? null : (selectedCells.length === 1 ? selectedCells[0] : null);
		},
		selectedRow: function () {
			/* returns the currently selected row that has the format { element: , index: }, if any.
				If multiple selection is enabled the function will return null.
				returnType="object"
			*/
			var selectedRows;
			if (this._selection.settings.owner !== this) {
				return null;
			}
			selectedRows = this._selection.selectedRows();
			return this._selection.settings.multipleSelection ? null : (selectedRows.length === 1 ? selectedRows[0] : null);
		},
		activeCell: function () {
			/* returns the currently active (focused) cell that has the format { element: , row: , index: , rowIndex: , columnKey: }, if any.
				returnType="object"
			*/
			if (this._selection instanceof $.ig.SelectedRowsCollection) {
				return null;
			}
			if (this._selection.settings.owner !== this) {
				return null;
			}
			return this._selection.activeCell();
		},
		activeRow: function () {
			/* returns the currently active (focused) row that has the format { element: , index: }, if any.
				returnType="object"
			*/
			if (this._selection instanceof $.ig.SelectedCellsCollection) {
				return null;
			}
			if (this._selection.settings.owner !== this) {
				return null;
			}
			return this._selection.activeRow();
		},
		getCellValue: function (rowId, colKey) {
			/* Retrieves a cell value using the row index and the column key. If a primaryKey is defined, rowId is assumed to be the row Key (not index).
				If primary key is not defined, then rowId is converted to a number and is used as a row index.
				If colKey is a number, the index of the column is used (instead of a column name).
				paramType="object" Row index or row key (primary key).
				paramType="string" The column key.
				returnType="object" The corresponding cell value.
			*/
			var id = parseInt(rowId, 10), i, cols = this.options.columns, colFound = false, rec, primaryKeyCol, tx;
			// check the case where we have a local transaction log, and there is a corresponding entry for that row's cell
			tx = this.dataSource.pendingTransactions();
			if (this.options.autoCommit === false && tx.length > 0) {
				for (i = 0; i < tx.length; i++) {
					if (tx[i].rowId === rowId) {
						if (tx[i].type === "cell" && tx[i].col === colKey) {
							return tx[i].value;
						}
						if (tx[i].type === "row" || tx[i].type === "newrow") {
							return tx[i].row[colKey];
						}
					}
				}
			}
			// M.H. 6 Jan 2014 Fix for bug #160364: noSuchColumnDefined error is not thrown when an undefined column is used in getCellValue method
			if ($.type(colKey) === 'string') {
				for (i = 0; i < cols.length; i++) {
					if (cols[i].key === colKey) {
						colFound = true;
						break;
					}
				}
				if (colFound === false) {
					throw new Error($.ig.Grid.locale.noSuchColumnDefined);
				}
			}
			// check for primary key
			if (this.options.primaryKey !== null) {
				// assume rowId is the primary Key, not the row index
				primaryKeyCol = this.columnByKey(this.options.primaryKey);
				if (primaryKeyCol.dataType === "number" || primaryKeyCol.dataType === "numeric") {
					rec = this.dataSource.findRecordByKey(parseInt(rowId, 10));
				} else {
					rec = this.dataSource.findRecordByKey(rowId);
				}
				if (rec === null || rec === undefined) {
					throw new Error($.ig.Grid.locale.recordNotFound.replace("{id}", rowId));
				}
				return rec[colKey];
			}
			// validate
			if (id >= this.dataSource.dataView().length) {
				throw new Error($.ig.Grid.locale.indexOutOfRange.replace("{max}", this.dataSource.dataView().length));
			}
			if ($.type(colKey) === 'string') {
				return this.dataSource.dataView()[id][colKey];
			}
			if (cols.length <= colKey) {
				throw new Error($.ig.Grid.locale.columnIndexOutOfRange.replace("{max}", cols.length));
			}
			return this.dataSource.dataView()[id][colKey];
		},
		getCellText: function (rowId, colKey) {
			/* Returns the cell text. If colKey is a number, the index of the column is used (instead of a column name)
				This is the actual text (or HTML string) for the contents of the cell.
				paramType="object" Row index or row data key (primary key)
				paramType="string" Column key.
				returnType="string" the cell text for the respective cell 
			*/
			var colIndex;
			if ($.type(colKey) === 'string') {
				colIndex = this._getCellIndexByColumnKey(colKey);
			} else {
				colIndex = colKey;
			}
			if (colIndex === undefined) {
				throw new Error($.ig.Grid.locale.columnNotFound.replace("{key}", colKey));
			}
			// use with care. 
			if (this.options.primaryKey !== null) {
				// find the TR using a selector
				return this.element.find("tr[data-id='" + rowId + "']>td:nth-child(" + (colIndex + 1) + ")").text();
			}
			return $(this.cellAt(colIndex, parseInt(rowId, 10))).text();
		},
		setColumnTemplate: function (col, tmpl, render) {
			/* Sets a new template for a column after initialization and renders the grid if not explicitly disabled. This method will replace any existing explicitly set row template and will build one anew from the column ones.
				paramType="string|number" An identifier of the column to set template for (index or key)
				paramType="string" The column template to set
				paramType="bool" optional="true" default="true" Should the grid rerender after template is set
			*/
			var colIdx = this._getColIdxById(this.options.columns, col);
			if (colIdx === null || colIdx === undefined) {
				return;
			}
			col = this.options.columns[colIdx];
			col.template = tmpl;
			render = render === null || render === undefined ? true : render;
			if (render && !col.hidden) {
				this._renderData();
			}
		},
		commit: function (rowId) {
			/* Commits all pending transactions to the client data source. Note that there won't be anything to commit on the UI, since it is updated instantly. In order to rollback the actual UI, a call to dataBind() is required.
				paramType="string|number" optional="true" If specified, will commit only that transaction corresponding to the specified index/ key.
			*/
			var key;
			key = this._normalizedKey(rowId);
			// commits all changes to the data source (delegates to igDataSource). Note that there won't be anything to commit on the UI, since it is updated instantly ! 
			// in order to rollback the actual UI, a call to dataBind() is required ! 
			this.dataSource.commit(key);
			if (this._fireInternalEvent("_gridCommit")) {
				// if a feature handles the commit call we shouldn't redo the same
				return;
			}
			this._isToSetUnboundColumns = true;
			if (this.options.virtualization || this.options.rowVirtualization || this.options.columnVirtualization) {
				if (this.options.virtualizationMode === "continuous") {
					this._renderVirtualRecords();
				} else {
					this._buildVirtualDom();
					this.virtualScrollTo(this._startRowIndex);
				}
			} else {
				this._renderData();
			}
		},
		rollback: function (rowId, updateUI) {
			/* Clears the transaction log (delegates to igDataSource). Note that this does not update the UI. In case the UI must be updated, set the second parameter "updateUI" to true, which will trigger a call to dataBind() to re-render the contents. 
				paramType="string|number" optional="true" If specified, will only rollback the transactions with that row id.
				paramType="bool" optional="true" Whether to update the UI or not.
			*/
			var key = this._normalizedKey(rowId), transactions = this.dataSource.rollback(key),
				transaction, content, i, tridx, rec, tr, td, index, col;
			if (updateUI === true) {
				if (!_aNull(rowId)) {
					if (transactions.length === 0) {
						// if no transactions are returned by the data source we shouldn't do anything
						return;
					}
					i = transactions.length;
					while (i-- > 0) {
						transaction = transactions[i];
						tr = this.element.find("tr[data-id='" + transaction.rowId + "']");
						switch (transaction.type) {
							case "newrow":
								// the row found needs to be removed
								tridx = this.element.children("tbody").children("tr:not([data-container],[data-grouprow])").index(tr);
								tr.remove();
								this._reapplyZebraStyle(tridx);
								break;
							case "deleterow":
								// the row found should have its deleted style cleared
								tr.removeClass(this.css.deletedRecord);
								break;
							case "cell":
								// all cell transactions for this row will have the same row id and therefore will be removed together
								// so we'll just remove the whole row's modified style
								col = this.columnByKey(transaction.col);
								tr.removeClass(this.css.modifiedRecord);
								td = this.cellById(transaction.rowId, transaction.col);
								rec = this.dataSource.findRecordByKey(transaction.rowId);
								if (col.template && col.template.length) {
									content = this._renderTemplatedCell(rec, col);
									index = content.indexOf(">");
									content = content.substring(index + 1, content.length);
									td.html(content);
								} else {
									td.html(String(this._renderCell(rec[transaction.col], col, rec)));
								}
								break;
							case "row":
								tr.removeClass(this.css.modifiedRecord);
								rec = this.dataSource.findRecordByKey(transaction.rowId);
								this._renderRow(rec, tr[0], rec[this.options.primaryKey]);
								break;
						}
					}
				} else {
					this.dataBind();
				}
			}
		},
		findRecordByKey: function (key) {
			/* returns a record by a specified key (requires that primaryKey is set in the settings).
				That is a wrapper for this.dataSource.findRecordByKey(key).
				paramType="string" Primary key of the record
				returnType="object" a JavaScript object specifying the found record, or null if no record is found
			*/
			return this.dataSource.findRecordByKey(key);
		},
		getDetachedRecord: function (t) {
			/* Returns a standalone object (copy) that represents the committed transactions, but detached from the data source.
				That is a wrapper for this.dataSource.getDetachedRecord(t).
				paramType="object" A transaction object.
				returnType="object" A copy of a record from the data source.
			*/
			return this.dataSource.getDetachedRecord(t);
		},
		pendingTransactions: function () {
			/* Returns a list of all transaction objects that are pending to be committed or rolled back to the data source.
				That is a wrapper for this.dataSource.pendingTransactions().
				returnType="array"
			*/
			return this.dataSource.pendingTransactions();
		},
		allTransactions: function () {
			/* returns a list of all transaction objects that are either pending, or have been committed in the data source. 
				That is a wrapper for this.dataSource.allTransactions().
				returnType="array"
			*/
			return this.dataSource.allTransactions();
		},
		transactionsAsString: function () {
			/* Returns the accumulated transaction log as a string. The purpose of this is to be passed to URLs or used conveniently.
				That is a wrapper for this.dataSource.transactionsAsString().
				returnType="string"
			*/
			return this.dataSource.transactionsAsString();
		},
		_normalizedKey: function (id) {
			// returns a normalized key because id can be both index or a primary key (string / number) 
			var key, primaryKeyCol;
			// A.T. 15 Sept. 2011 - Fix for #88104
			if (id === undefined || id === null) {
				return null;
			}
			key = id;
			if (this.options.primaryKey !== null) {
				primaryKeyCol = this.columnByKey(this.options.primaryKey);
				if (primaryKeyCol.dataType === "number" || primaryKeyCol.dataType === "numeric") {
					key = parseInt(id, 10);
				}
			} else {
				key = parseInt(id, 10);
			}
			return key;
		},
		saveChanges: function (success, error) {
			/* Invokes an AJAX request to the updateUrl option (if specified) and passes the serialized transaction log (a serialized JSON string) as part of the POST request. 
			paramType="function" Specifies a custom function to be called when AJAX request to the updateUrl option succeeds(optional)
			paramType="function" Specifies a custom function to be called when AJAX request to the updateUrl option fails(optional)
			*/
			this.dataSource.saveChanges(success, error);
		},
		// if rowId is not null, then it is a request to fix css (update/add/delete row)
		_renderRow: function (rec, tr) {
			var i, j = 0, tds, cols, col, cs, cl, content,
				cv = this.options.virtualization || this.options.columnVirtualization;
			tr = $(tr);
			// data cells
			tds = tr.children("td:not([data-skip='true'],[data-parent])");
			cols = this._visibleColumns();
			cs = this._startColIndex || 0;
			cl = cv ? this._virtualColumnCount + cs : cols.length;
			for (i = cs; i < cl; i++) {
				col = cols[i];
				// K.D. Bug #102873 Rendering branch is done here
				if (col.template && col.template.length) {
					content = this._renderTemplatedCell(rec, col);
					if (content.indexOf("<td") === 0) {
						tds.eq(j).html($(content).html());
					} else {
						tds.eq(j).html(content);
					}
				} else {
					tds.eq(j).html(String(this._renderCell(rec[col.key], col, rec)));
				}
				j++;
			}
			return tr;
		},
		renderNewRow: function (rec) {
			/* Adds a new row (TR) to the grid, by taking a data row object. Assumes the record will have the primary key.
				paramType="object" The data row JavaScript object.
				paramType="string" optional="true" Identifier/key of row. If missing, then number of rows in grid is used.
			*/
			var tbody = this.element.children("tbody"), index, self = this, virt = this.options.virtualization === true ||
				this.options.rowVirtualization === true, fv = this.options.virtualizationMode === "fixed";
			// S.S. April 25, 2013 Bug #139544 When virtualization is enabled we need to rebuild the dom so that all virtualization
			// related variables are properly set
			if (virt) {
				if (fv) {
					this._buildVirtualDom();
				} else {
					this._renderVirtualRecordsContinuous();
					this._startRowIndex = 0;
				}
				this.virtualScrollTo(this._totalRowCount);
			} else {
				index = tbody.children("[data-container!=\"true\"]").length;
				// K.D. April 5th, 2012 Bug #107910 Render record handles the rendering of regular and templated records.
				MSApp.execUnsafeLocalFunction(function () {
					tbody.append(self._renderRecord(rec, index));
				});
			}
		},
		_findTableRowByKey: function (key) {
			var primaryKeyIndex, cols = this.options.columns, r, i;
			// find the index of the primary key column
			if (this.options.primaryKey !== null) {
				for (i = 0; i < cols.length; i++) {
					if (cols[i].key === this.options.primaryKey) {
						primaryKeyIndex = i;
						break;
					}
				}
				if (primaryKeyIndex === undefined) {
					throw new Error($.ig.Grid.locale.columnNotFound.replace("{key}", this.options.primaryKey));
				}
				r = this.element.find("td:nth-child('" + (primaryKeyIndex + 1) + "'):contains('" + key + "')").parent();
				return r.length === 0 ? null : r[0];
			}
			return this.rowAt(parseInt(key, 10));
		},
		/* A.T. 21 Jan 2010 - Fix for bug #62277 - Data rebinding doesn't work properly. You have to reset all the properties for the binding
		 * widget options are deep cloned !!! Therefore if the data source is LOCAL json array or some object, it must be set through the API, not in the options
		 * alternatively if it is set from options, it will be deep copied !
		 */
		dataSourceObject: function (dataSource) {
			/* if the data source points to a local JSON array of data, and it is necessary to reset it at runtime, it must be done through this API member instead of the options (options.dataSource) 
				paramType="object" New data source object. 
			*/
			if (dataSource !== undefined) {
				this.options.dataSource = dataSource;
			} else {
				return this.options.dataSource;
			}
		},
		totalRecordsCount: function () {
			/* Returns the total number of records in the underlying backend. If paging or filtering is enabled, this may differ from the number of records in the client-side data source.
				In order for this to work, the response JSON/XML must include a property that specifies the total number of records, which name is specified by options.responseTotalRecCountKey.
				This functionality is completely delegated to the data source control.
				returnType="number" total number of records in the backend
			*/
			return this.dataSource.totalRecordsCount();
		},
		_wrapElementDiv: function () {
			this._isWrapped = true;
			this.element = $("<table role='grid'></table>").appendTo(this.element).attr('id', this.id() + "_table");
			this.element.data('igGrid', this);
		},
		dataBind: function (internal) {
			/* causes the grid to data bind to the data source (local or remote) , and re-render all of the data as well 
			excluded="true"
			*/
			var dataOptions, i, noCancel = true, noCancelRendering = true, customFunc, dataSource;
			// M.H. 17 May 2012 Fix for bug #111100: The rendering event has to be fired	before   the (dataBinding and dataBound) pair of events
			// A.T. 9 Jan 2012 - fix for bug #98777
			if (!this._initialized) {
				noCancelRendering = this._trigger(this.events.rendering, null, { owner: this });
			}
			if (noCancelRendering) {
				dataOptions = this._generateDataSourceOptions(this.options);
				//A.T. 18 Jan 2011 - Fix for bug #62277 - Data rebinding doesn't work properly. You have to reset all the properties for the binding
				dataSource = this._createDataSource(dataOptions);
				noCancel = this._trigger(this.events.dataBinding, null, { owner: this, dataSource: dataSource });
				if (internal === undefined) {
					this.options.requiresDataBinding = true;
				}
				if (noCancel) {
					if (this.options.requiresDataBinding) {
						// M.H. 23 Jan 2013 Fix for bug #130586
						if (this._hasUnboundColumns) {
							this._rebindUnboundColumns = true;
						}
						//initialize grid features and attach their event handlers
						this._dataOptions = dataOptions;
						this.dataSource = dataSource;
						//if (this.options.autoGenerateColumns === false) {
						// M.H. Implement task 166872: Remove the tight coupling between igDataSource and igGrid
						if (this.dataSource) {
							// we should cache the original custom convert function(from this.dataSource.settings.sorting.customConvertFunc) if it is set, because we re-set it
							customFunc = this.dataSource.settings.sorting.customConvertFunc;
							this.dataSource.settings.sorting.customConvertFunc = $.proxy(this._convertSortingDataSourceValue, this);
							// if this.dataSource.settings.sorting.customConvertFunc is already re-set - we should ensure that this._oSortingCustomConvertFunc(original value) will not point to the same function
							if (customFunc && (customFunc.guid === undefined ||
								customFunc.guid !== this.dataSource.settings.sorting.customConvertFunc.guid)) {
								// we should cache the original function(if set from the dataSource) and call it from our handler
								this._oSortingCustomConvertFunc = customFunc;
							}
						}
						if (!this._initialized) {
							// check if the element passed on the widget is of type table or div
							if (this.element.is("div")) {
								this._wrapElementDiv();
								//gridElement = this.element[0];
							}
							for (i = 0; i < this.options.features.length; i++) {
								this._initFeature(this.options.features[i], dataOptions);
							}
							//NOTE: this is the only point were we can do the capturing of the 
							//hidden columns as it should be before we render the grid
							//and after all features(including hiding) have been initialized
							//A.Y. bug 98100. In the case of autogenerated columns this will be done later.
							if (this.options.autoGenerateColumns !== true) {
								this._captureInitiallyHiddenColumns();
							}
							this._visibleColumnsArray = undefined;
						} else {
							// M.H. 26 Mar 2013 Fix for bug #126556: DataBound event is fired twice after GroupBy when explicitly invoking "dataBind" method
							this._isDataBoundCalled = true;
							this.element.trigger('iggriduidirty', { owner: this });
							// fire UI State dirty so that features reset their UI (without destroying them)
							for (i = 0; i < this.options.features.length; i++) {
								this._initFeatureSettings(this.options.features[i]);
							}
							// M.H. 9 Nov 2012 Fix for bug #126509
							//this._trigger("headerExtraCellsModified", null, { owner: this });
						}
						//}
						this._renderGrid();
						if (this._loadingIndicator === undefined) {
							this._initLoadingIndicator();
						}
						if (this._loadingIndicator) {
							this._loadingIndicator.show();
						}
						this.dataSource.dataBind();
						this.options.requiresDataBinding = false;
					} else {
						// data source is already bound 
						this._renderGrid();
					}
				}
			// M.H. 17 May 2012 Fix for bug #111100
			} else {
				// cancel render data
				this._cancelRendering = true;
			}
		},
		_mergeUnboundValues: function () {
			// merge unbound values when datasource is remote and merguUnboundColumns is false
			var i, primaryKeyCol, metadataUC, rec, ucLength, primaryKeyColIsNumber, col, schema, type, dataLength, data, key, val, j,
				pk = this.options.primaryKey,
				metadata = this.dataSource.metadata("unboundValues"),
				self = this,
				hasPrimaryKey = (pk !== null && pk !== undefined),
				metaDataMergeFunction;
			if (metadata === undefined || metadata === null || metadata.length === 0 ||
					!this._unboundColumns) {
				return;
			}
			// M.H. 30 Aug 2012 Fix for bug #120134
			if (hasPrimaryKey) {
				metaDataMergeFunction = function (ind, val) {
					if (primaryKeyColIsNumber) {
						rec = self.dataSource.findRecordByKey(parseInt(ind, 10));
					} else {
						rec = self.dataSource.findRecordByKey(ind);
					}
					if (rec === null || rec === undefined) {
						return true;
					}
					// M.H. 10 Sep 2012 Fix for bug #120724
					if (schema !== undefined && schema !== null) {
						// M.H. 11 Sep 2012 Fix for bug #120867
						val = schema._convertType(type, val, rec[pk], key);
					}
					// M.H. 11 Sep 2012 Fix for bug #120668
					self._addUnboundColumnValue(key, val);
					rec[key] = val;
				};
				primaryKeyCol = this.columnByKey(pk);
				primaryKeyColIsNumber = (primaryKeyCol.dataType === "number");
			}
			ucLength = this._unboundColumns.length;
			schema = this.dataSource.schema();
			for (i = 0; i < ucLength; i++) {
				key = this._unboundColumns[i].key;
				metadataUC = metadata[key];
				if (metadataUC === null || metadataUC === undefined) {
					continue;
				}
				col = this.getUnboundColumnByKey(key);
				type = null;
				if (col !== null && col.dataType) {
					type = col.dataType;
				}
				// M.H. 30 Aug 2012 Fix for bug #120134
				if (hasPrimaryKey) {
					// M.H. 10 Sep 2012 Fix for bug #120724
					$.each(metadataUC, metaDataMergeFunction);
				} else {
					self._renderUnboundValues(metadataUC, key);
				}
				// M.H. 11 Sep 2012 Fix for bug #120569
				if (type === "bool" || type === "boolean") {
					data = this.dataSource.data();
					val = schema._convertType(type, undefined);
					dataLength = data.length;
					// just for performance - we do not want to traverse all 
					if (dataLength <= metadataUC.length) {
						continue;
					}
					for (j = 0; j < dataLength; j++) {
						if (data[j][key] === undefined) {
							data[j][key] = val;
						}
					}
				}
			}
		},
		// M.H. Implement task 166872: Remove the tight coupling between igDataSource and igGrid
		_convertSortingDataSourceValue: function (val, key) {
			// Custom data value conversion function. Accepts a value and should return the converted value. It is called from the dataSource when sorting is applied. Check for reference igGridDataSource.settings.sorting.customConvertFunc
			// Apply sorting according to the applied column format(if any) - fix for bugs #130576, #118640 When the grid is bound to UTC dates 
			var o = this.options, enableUTCDates = o.enableUTCDates, format,
				rowTemplate, col, dsFunc = this._oSortingCustomConvertFunc;
			if ($.type(val) === "date") {
				rowTemplate = (!o.rowTemplate || o.rowTemplate.length <= 0);
				col = this.columnByKey(key);
				if (col !== undefined && col !== null) {
					format = col.format;
				}
				if (format) {
					// L.A. 11 January 2013 - Fixing bug #130576 
					// L.A. 09 August 2012 - Fixing bug #118640 When the grid is bound to UTC dates 
					// (remote or local data), grouping a time-formatted date column produces incorrect groups
					if (format === "time" || format === "timeLong" || format === "h:mm:ss tt") {
						// Create date objects with fake year
						// M.H. 23 Oct 2013 Fix for bug #155639: Unable to sort date column when format is "h:mm:ss tt"
						val = new Date("January 01, 2000 " + $.ig.formatter(val, "date", format, rowTemplate, enableUTCDates));
					}
				}
			}
			// if customConvertFunc from the dataSource settings is set explicitly (e.g. on init) then it should be executed
			// ensure that dsFunc will not call the same function this._convertSortingDataSourceValue which will cause infinite loop
			if ($.isFunction(dsFunc)) {
				//_convertSortingDataSourceValue is set to this.dataSource.settings.sorting.customConvertFunc via $.proxy so it has property guid
				if (dsFunc.guid === undefined ||
					dsFunc.guid !== this.dataSource.settings.sorting.customConvertFunc.guid) {
					val = dsFunc(val, key);
				}
			}
			return val;
		},
		_generateDataSourceOptions: function () {
			var schema, dataOptions, t, headers, i, instanceOfDs;
			// if there is neither options.dataSource specified, nor options.dataSourceUrl, we check if we are binding to a table and if there is any existing
			// data in it, and then we set the data source to that table DOM element, so that it can be processed by the data source control
			if (!this.options.dataSource && !this.options.dataSourceUrl && this.element.is('table') && this.element.find('tbody').children().length > 0) {
				this.options.dataSource = this.element[0];
			}
			// we need to look ahead and check if the data source is a HTML Table and has column headers defined. in that case we need to update the headerText in the column definitions
			if (this.options.dataSource) {
				if (this.options.dataSource.tagName && this.options.dataSource.nodeType) {
					t = $(this.options.dataSource);
				} else if ($.type(this.options.dataSource.type) === 'function' &&
							this.options.dataSource.type() === 'htmlTableString' && 
							$.type(this.options.dataSource.dataSource) === 'function') {
					t = $(this.options.dataSource.dataSource());
				}
				if (t && t.is('table') && t.find('thead th').length > 0) {
					// generate column headers 
					headers = t.find('thead tr th');
					this._tb_h = true;
					this._tb_h_arr = [];
					for (i = 0; i < headers.length; i++) {
						this._tb_h_arr.push($(headers[i]).text());
					}
					/*
					if (this.options.columns.length > 0) {
						for (i = 0; i < headers.length && i < this.options.columns.length; i++) {
							this.options.columns[i].headerText = $(headers[i]).text();
						}
					} else {
						for (i = 0; i < headers.length; i++) {
							this.options.columns.push({"headerText": $(headers[i]).text()});
						}
					}
					*/
				}
			}
			dataOptions = {
				callback: $.proxy(this._renderData, this),
				callee: this,
				responseDataKey: this.options.responseDataKey,
				responseTotalRecCountKey: this.options.responseTotalRecCountKey,
				dataSource: this.options.dataSource,
				requestType: this.options.requestType,
				responseContentType: this.options.responseContentType,
				primaryKey: this.options.primaryKey,
				localSchemaTransform: this.options.localSchemaTransform,
				autoCommit: this.options.autoCommit,
				aggregateTransactions: this.options.aggregateTransactions,
				serializeTransactionLog: this.options.serializeTransactionLog,
				updateUrl: this.options.updateUrl,
				restSettings: this.options.restSettings,
				// M.H. 18 August 2015 Fix for bug 204834: Filter by condition: "Today" is not working properly when "enableUTCDates" is set to true
				// if it should be applied filtering(sorting) according to universal time
				enableUTCDates: this.options.enableUTCDates
			};
			if (this.options.dataSourceType !== null) {
				dataOptions.type = this.options.dataSourceType;
			}
			// create a schema based on the columns definition
			// iterate over the columns collection, if such exists. Otherwise bind to everything
			//A.T. 28 March 2011 - fix for bug #68548
			//L.A. 02 August 2012 - Fixing bug #117263 - Grid doesn't render binding to XML string
			// M.H. 15 Sep 2012 Fix for bug #121429
			if (!this.options.dataSource || !this.options.dataSource.schema || !this.options.dataSource.schema() || this.options.dataSource.schema()._type !== "xml") {
				schema = this._generateDataSourceSchema();
			}
			// M.H. 27 Mar 2014 Fix for bug #168313: Grid overrides the data source schema fields and the localSchemaTransform option
			// if DataSource schema is set in the DataSource(taken from options) and is of type DataSchema then we use it otherwise we should generate it
			instanceOfDs = this.options.dataSource &&
				typeof this.options.dataSource._xmlToArray === "function" &&
				typeof this.options.dataSource._encodePkParams === "function";
			if ((instanceOfDs && (this.options.dataSource.settings.schema === null ||
				!this.options.dataSource.settings.schema.fields ||
				(this.options.dataSource.settings.schema.fields && this.options.dataSource.settings.schema.fields.length >= 0))) ||
				!instanceOfDs) {
				dataOptions = $.extend(dataOptions, { schema: schema });
			}
			return dataOptions;
		},
		_insertUnboundColumn: function (column) {
			if (this._unboundColumns === null || this._unboundColumns === undefined) {
				this._unboundColumns = [];
			}
			this._unboundColumns.push(column);
			// M.H. 3 Sep 2012 Fix for bug #120188
			if (column.key && (this._unboundValues[column.key] === null || this._unboundValues[column.key] === undefined)) {
				this._unboundValues[column.key] = [];
			}
			// M.H. 1 Nov 2012 Fix for bug #120553
			if (column.unboundValues && column.unboundValues.length > 0) {
				this._isToSetUnboundColumns = true;
			}
			this._hasUnboundColumns = true;
		},
		// M.H. 10 Sep 2012 Fix for bug #120696 - add index value
		_addUnboundColumnValue: function (key, value, index) {
			// insert in _unboundValues object for the unbound column with the specified key value. If index is specified at position index
			if (this._unboundValues[key] === null || this._unboundValues[key] === undefined) {
				this._unboundValues[key] = [];
			}
			if (index !== undefined && index !== null) {
				this._unboundValues[key][index] = value;
			} else {
				this._unboundValues[key].push(value);
			}
		},
		_generateDataSourceSchema: function () {
			var schema, schemaType, dsSchema, i, rec, prop, count = 0, cols = this.options.columns, ds = this.options.dataSource, cl, counter = 0;
			//A.T. 22 Aug 2011 - make sure this scenario is covered as well 
			if (ds && typeof ds._xmlToArray === "function" && typeof ds._encodePkParams === "function") {
				dsSchema = ds.schema();
				// if the dataSource has the data schema - and type of the data schema is different from the type of the dataSource get type of the dataSchema (in cases like functiondatasource)
				// M.H. 31 Mar 2015 Fix for bug 190451: Cannot bind grid to FunctionDataSource
				if (dsSchema && $.type(dsSchema) === 'object'
					&& typeof dsSchema.schema === 'object'
					&& typeof dsSchema.isObjEmpty === 'function'
					&& dsSchema._type) {
					schemaType = dsSchema._type;
					if (schemaType && schemaType !== ds.settings.type) {
						ds.settings.type = schemaType;
					}
				} else {
					dsSchema = null;
				}
				if ($.type(ds.settings.dataSource) === "array" || $.type(ds.settings.dataSource) === "object") {
					ds = ds.settings.dataSource;
				} else if ($.type(ds.settings.dataSource) !== "string") {
					ds = ds.data();
				} else {
					ds = [];
				}
			}
			// M.H. 16 May 2012 Fix for bug #99426			
			if ($.type(ds) === "object" && this.options.responseDataKey) {
				ds = $.ig.findPath(ds, this.options.responseDataKey);
			}
			schema = {};
			schema.fields = [];
			schema.searchField = this.options.responseDataKey;
			// M.H. 3 Dec 2014 Fix for bug #185336: Databinding a grid with an unbound column holding an input element creates a memory leak
			this._unboundColumns = null;
			//if (this.options.columns.length > 0) {
			if (cols.length > 0 && !this.options.autoGenerateColumns) {
			// if autoGenerateColumns is true, fields for all columns in the data source must be specified
				for (i = 0; i < cols.length; i++) {
					if (cols[i].unbound === true || cols[i].unboundDS === true) {
						this._insertUnboundColumn(cols[i]);
						if (cols[i].unbound === true) {
							continue;
						}
					}
					schema.fields[counter] = {};
					schema.fields[counter].name = cols[i].key;
					schema.fields[counter].type = cols[i].dataType;
					counter++;
				}
			//} else if (this.options.columns.length > 0 && this.options.autoGenerateColumns) {
			} else if (this.options.autoGenerateColumns) {
				// A.T. Fix for #74240. Please note that in this case (if autoGenerateColumns=true, and there are custom cols defined,
				// and they have widths defined, there MUST be defaultColumnWidth specified, otherwise the remaining columns in the data source
				// will be shrinked to zero and they won't be visible ! 
				if (ds && ds.tagName && $(ds).is("table") &&
						$(ds).find("tbody tr").length > 0) {
					rec = $(ds).find("tbody tr")[0];
				//	count = $(rec).find('td').length;
					$(rec).find('td').each(function () {
						if (cols.length > count) {
							schema.fields.push({
								name: cols[count].key || (count + 1),
								type: cols[count].dataType || "string"
							});
						} else {
							schema.fields.push({ name: (count + 1), type: "string" });
						}
						count++;
					});
				} else if (ds && ds.length && ds.length > 0 &&
						$.type(ds) === "array") {
					// we need to iterate through all records, since the first one may not necessarily contain any children
					//rec = this.options.dataSource[0];
					for (i = 0; i < ds.length; i++) {
						rec = ds[i];
						for (prop in rec) {
							if (rec.hasOwnProperty(prop)) {
								// if the column isn't already defined in the columns collection 
								if (this.columnByKey(prop) === null && !this._fieldExists(prop, schema) &&
										$.type(rec[prop]) !== "object" && $.type(rec[prop]) !== "array") {
									schema.fields.push({ name: prop, type: $.ig.getColType(rec[prop]) });
								} else if (this.columnByKey(prop) !== null) {
									schema.fields.push({ name: prop, type: this.columnByKey(prop).dataType });
								}
								count++;
							}
						}
						// performance improvement. The flat grid doesn't need that. Also the hierarchical grid doesn't need that if autoGenerateLayouts is not true.
						if (!this.options._recurseSchema) {
							break;
						}
					}
				} else if (dsSchema && dsSchema.fields().length) {
					// when autogeneratecolumn is TRUE and it could not be taken fields from the dataSource get them from the dataSchema
					// M.H. 31 Mar 2015 Fix for bug 190451: Cannot bind grid to FunctionDataSource
					schema.fields = dsSchema.fields();
				}
				// check for unbound columns
				for (i = 0; i < cols.length; i++) {
					if (cols[i].unbound === true || cols[i].unboundDS === true) {
						this._insertUnboundColumn(cols[i]);
					}
				}
			}
			// used in special cases where the schema needs to be additionally modified ( as it is the case with hGrid, so that all complex objects
			// are also added to the schema whenever autoGenerateColumns === false (only in that case) 
			this._trigger(this.events.schemaGenerated, null, { owner: this, schema: schema, dataSource: ds });
			// generate fields for child layouts if any
			cl = this.options.columnLayouts;
			if (cl && cl.length && cl.length > 0) {
				for (i = 0; i < cl.length; i++) {
					// M.H. 22 Apr 2014 Fix for bug #170463: A JavaScript exception is thrown when igHierarchicalGrid.childrenDataProperty is used instead of igHierarchicalGrid.key
					if (cl[i].key === undefined) {
						continue;
					}
					schema.fields.push({ name: cl[i].key });
				}
			}
			return schema;
		},
		_fieldExists: function (prop, schema) {
			var i;
			for (i = 0; i < schema.fields.length; i++) {
				if (schema.fields[i].name === prop) {
					return true;
				}
			}
			return false;
		},
		_createDataSource: function (dataOptions) {
			var callee, dataSource;
			if (!this.options.dataSource ||
				typeof this.options.dataSource._xmlToArray !== "function" ||
				typeof this.options.dataSource._encodePkParams !== "function") {
				// fix for JSONP
				// we use $.ig.util.isJsonpUrl to automatically detect whether to instantiate JSONP data source from the URL when jsonpRequest is not explicitly set
				if ($.type(dataOptions.dataSource) === "string" &&
						(this.options.jsonpRequest || $.ig.util.isJsonpUrl(dataOptions.dataSource))) {
					dataSource = new $.ig.JSONPDataSource(dataOptions);
				} else if (this.options.restSettings.update.url !== null || this.options.restSettings.update.template !== null ||
						this.options.restSettings.create.url !== null || this.options.restSettings.create.template !== null ||
						this.options.restSettings.remove.url !== null || this.options.restSettings.remove.template !== null) {
					dataSource = new $.ig.RESTDataSource(dataOptions);
				} else {
					dataSource = new $.ig.DataSource(dataOptions);
				}
			} else {
				dataSource = this.options.dataSource;
				//dataOptions.dataSource = this.dataSource.settings.dataSource;
				//A.T. 12 Feb 2011 - Fix for bug #65899
				// M.H. 30 Oct 2012 Fix for bug #122396
				if (dataSource.settings.responseDataKey !== null) {
					delete dataOptions.responseDataKey;
					if (dataOptions.schema) {
						dataOptions.schema.searchField = dataSource.settings.responseDataKey;
					}
				}
				// M.H. 28 Apr 2014 Fix for bug #170712: When grid is bound to oData and paging is enabled a js error is thrown.
				if (dataOptions.responseTotalRecCountKey === null && dataSource.settings.responseTotalRecCountKey !== null) {
					delete dataOptions.responseTotalRecCountKey;
				}
				this._tds = dataSource.settings.dataSource;
				dataSource.settings.dataSource = null;
				// M.H. 30 Oct 2012 Fix for bug #122396
				if ($.ig.util.isIE8 && dataOptions.callee) {
					callee = dataOptions.callee;
					dataOptions.callee = null;
				}
				// M.H. 24 Sep 2012 Fix for bug #122201
				dataSource.settings = $.extend(true, {}, dataSource.settings, dataOptions);
				// M.H. 30 Oct 2012 Fix for bug #122396
				if ($.ig.util.isIE8 && callee) {
					dataSource.settings.callee = callee;
				}
				dataSource.settings.dataSource = this._tds;
				this._tds = null;
				if (dataOptions.schema) {
					dataSource._initSchema();
				}
			}
			return dataSource;
		},
		_generateColumns: function () {
			var r, key, i, hasExplicitCols = this.options.columns.length > 0,
				hasHeaders = false, len, col,
				isTable = false, arr = [],
				ds = this.options.dataSource,
				cdp = this.options.childrenDataProperty,
				newDs, colType, dsHtmlTableString = false;
			//this.options.columns = []; // A.T. 28 Feb  2011 - we shouldn't be clearing the columns !@ 
			// we need to take into account the case where columns are already defined. This means we render them first, and only then proceed
			// with the rest of the columns in the data source 
			if (ds && typeof ds._xmlToArray === "function" && typeof ds._encodePkParams === "function") {
				// M.H. 22 Oct 2014 Fix for bug #130353: When grid's data source is html table string and autoGenerateColumns is true the columns are not correct.
				if (this.options.dataSource.type() === 'htmlTableString' && this.options.autoGenerateColumns) {
					dsHtmlTableString = true;
				}
				ds = ds.data(); // special case where the data source is an instance of an $.ig.DataSource
			} else if (typeof ds === "string") {
				ds = this.dataSource.data();
			}
			// M.H. 16 May 2012 Fix for bug #99426
			if ($.type(ds) === "object" && this.options.responseDataKey) {
				newDs = $.ig.findPath(ds, this.options.responseDataKey);
				if ($.type(newDs) === "array") {
					ds = newDs;
				}
			}
			// special case - having columns defined manually, and autoGenerateColumns = true at the same time
			// A.T. that's basically bug (#74240) - we shouldn't be using the dataView, because it's already bound according to whatever is defined in options.columns
			// and everything else is not bound at all !
			if (ds && ds.tagName && $(ds).is('table')) {
				len = $(ds).find('tbody tr').length;
				isTable = true;
			} else if (ds && ds.length) {
				len = ds.length;
			}
			if (ds && len && len === 0 && this.options.columns.length === 0) {
				throw new Error($.ig.Grid.locale.autoGenerateColumnsNoRecords);
			}
			if (ds && len && len > 0) {
				//r = this.dataSource.dataView()[0];
				if (isTable) {
					r = $(ds).find('tbody tr')[0];
				} else {
					r = ds[0];
				}
				if ($.type(r) === "array" || isTable) {
					// check if we aren't binding to a table that has headers defined already
					/*
					if (hasExplicitCols && this.options.columns[0].headerText) {
						hasHeaders = true;
						for (i = 0; i < this.options.columns.length; i++) {
							headers.push(this.options.columns[i].headerText);
						}
						this.options.columns = [];
					}
					*/
					hasHeaders = this._tb_h;
					if (isTable) {
						$(r).find('td').each(function () { arr.push($(this).text()); });
						r = arr;
					}
					for (i = 0; i < r.length; i++) {
						// detect type
						if (this.columnByKey(i + 1) === null && $.ig.getColType(r[i]) !== "object") {
							col = {
								headerText: hasHeaders ? this._tb_h_arr[i] : $.ig.Grid.locale.colPrefix + (i + 1),
								// M.H. 25 Mar 2014 Fix for bug #159801: When the grid is bound to html table and the columns are autogenerated hiding does not work
								key: String((i + 1)),
								dataType: $.ig.getColType(r[i]),
								hidden: false
							};
							// M.H. 22 Oct 2014 Fix for bug #130353: When grid's data source is html table string and autoGenerateColumns is true the columns are not correct.
							if (dsHtmlTableString) {
								col.key = String(i);
							}
							// L.A. 30 November 2012 - Fixing bug #128507
							col.headerText = (col.headerText || "").toString().trim();
							// M.H. 9 Aug 2012 Fix for bug #118689
							if (this._isMultiColumnGrid) {
								col.level0 = true;
								col.level = 0;
								this._oldCols.push(col);
							}
							this.options.columns.push(col);
							this._visibleColumnsArray = undefined;
						} else if (hasHeaders && !this.columnByKey(i + 1).headerText) {
							this.columnByKey(i + 1).headerText = this._tb_h_arr[i];
						}
					}
				} else {
					for (key in r) {
						// also detect type
						if (r.hasOwnProperty(key) && this.columnByKey(key) === null) {
							// L.A. 04 October 2012 - Fixing bug #123318 
							// If a column has a null value for the first call and autoGenerateColumns is true the column isn't generated.
							colType = $.ig.getColType(r[key]);
							if (((cdp && cdp !== key) || !cdp) && (colType !== "object" || r[key] === null) && key !== "ig_pk") {
								col = { headerText: key, key: key, dataType: $.ig.getColType(r[key]), hidden: false };
								this.options.columns.push(col);
								// M.H. 9 Aug 2012 Fix for bug #118689
								if (this._isMultiColumnGrid) {
									col.level0 = true;
									col.level = 0;
									this._oldCols.push(col);
								}
								this._visibleColumnsArray = undefined;
							}
						}
					}
				}
			}
			this._trigger("_columnsgenerated", null, { owner: this, key: this.options.key });
			// we need to set the data source schema
			if ((this.dataSource.schema() === null || this.dataSource.schema().fields().length === 0) && !hasExplicitCols) {
				this.dataSource.settings.schema = this._generateDataSourceSchema();
				this.dataSource._initSchema();
			}
			if (this.options.width === null) {
				this._setContainerWidth(this.container());
			}
			this._trigger("columnsgenerated", null, { owner: this, key: this.options.key });
		},
		_renderGrid: function () {
			var gridElement = this.element[0],
				containerId,
				containerDiv,
				tbody = this.element.children('tbody'); //gridElement.find('tbody')
				//ar = this.options.accessibilityRendering;

			this._cancelRendering = false;
			if (!this._initialized) {
				// we should have the data now in the data view
				// determine automatically if we want virtualization enabled or not 
				// IMPORTANT: height must also be always set ! 
				//if ($.type(this.options.virtualization) === "number" && this.dataSource.dataView().length > this.options.virtualization && this.options.height !== null) {
				//	this.options.virtualization = true;
				//}
				//if (ar) {
				this.element.attr('role', 'grid');
				//}
				if (this.options.virtualization === true || this.options.rowVirtualization === true || this.options.columnVirtualization === true) {
					if (this.options.height === undefined || this.options.height === null) {
						throw new Error($.ig.Grid.locale.virtualizationRequiresHeight);
					}
					if (this._isColumnVirtualizationEnabled() &&
						(this.options.width.indexOf && this.options.width.indexOf('%') > 0)) {
						//M.K. 1/13/2014 187174: Errors should be thrown when the grid is initialized with unsupported configurations
						//Column virtualization will not work when grid width is defined in percentage units
						throw new Error($.ig.Grid.locale.columnVirtualizationNotSupportedWithPercentageWidth);
					}
					this._createVirtualGrid();
				} else if (this.options.height !== null || this.options.width !== null) {
					this._createScrollingGrid();
				} else {
					// just wrap with a div, if it doesn't exist 
					//if (!this._isWrapped) {
					containerId = gridElement.id + '_container';
					containerDiv = '<div id="' + containerId + '" class="' + this.css.gridClasses + ' ' + this.css.baseClass + '" style="position: relative"> </div>';
					this.element.wrap(containerDiv);
					//} else {
					//	containerId = this.element.parent().addClass(this.css.gridClasses).addClass(this.css.baseClass).attr('id');
					//}
					this.element.addClass(this.css.gridTableClass);
					//if (ar) {
					this.element.attr('aria-describedby', containerId);
					//}
					this._setContainerWidth(this.container());

					this.container().attr('tabIndex', this.options.tabIndex);
					if (this.options.height !== null) {
						this.container().css('overflow-y', 'hidden');
						//this.scrollContainer().css('height', this.options.height);
					}
				}
				// touch support code
				this._touch();
				// render colgroup for column widths
				if (this.options.columns.length > 0 &&
						(this.options.virtualization !== true && this.options.rowVirtualization !== true && this.options.columnVirtualization !== true) &&
						this.options.autogenerateColumns === false && this.options.columns.length > 0
						) {
					this._renderColgroup(this.element[0], false, false, this.options.autofitLastColumn);
				}
				// cellpadding, cellspacing, etc.
				$(gridElement).attr('cellpadding', '0');
				$(gridElement).attr('cellspacing', '0');
				$(gridElement).attr('border', '0');
				$(gridElement).css('table-layout', 'fixed');
				$(gridElement).addClass(this.css.gridTableClass);
				if (this.options.autoGenerateColumns === false && this.options.columns.length > 0 &&
						this._headerRenderCancel !== true) {
					this._renderHeader();
				}
				// render header caption
				this._renderCaption();
				if (this.options.autoAdjustHeight) {
					this._initializeHeights();
				}
			}
			if (tbody.length === 0) {
				tbody = $('<tbody role="rowgroup"></tbody>').appendTo(gridElement).addClass(this.css.baseContentClass).addClass(this.css.gridTableBodyClass).addClass(this.css.recordClass);
			}
			if (this.dataSource.type() !== 'htmlTableDom' && this.dataSource.type() !== 'htmlTableId') {
				tbody.attr("role", "rowgroup").empty();
			}
		},
		_setContainerWidth: function (element, rendered) {
			var cols = this._visibleColumns(), i, w, width = 0, inPerc;
			// calculate based on column widths
			// if no col width is set, use the defaultColumnWidth
			//if (cols.length > 0 && !this.options.autoGenerateColumns) {
			if (cols.length > 0) {
				// M.H. 1 Sep 2015 Fix for bug 205476: Grid width becomes very small after column is resized and hidden
				inPerc = false;
				// if all columns are in percentage OR are not set then do not call _calculateContainerWidth - exit the function
				for (i = 0; i < cols.length; i++) {
					w = cols[i].width;
					if (w !== 0 && w !== '0') {
						w = w || this.options.defaultColumnWidth;
					}
					if (_aNull(w) ||
						(w && w.indexOf && w.indexOf('%') > 0)) {
						inPerc = true;
					} else {
						inPerc = false;
						break;
					}
				}
				// if ALL columns are in percentage or haven't width set - do not call _calculateContainerWidth(the width will not be properly calculated).
				if (inPerc) {
					return;
				}
				width = this._calculateContainerWidth(true);
				if (width > 0) {
					if (rendered) {
						// get outer widths for column headers
						width = 0;
						this.container().find('.ui-iggrid-header').each(function () {
							width += $(this).outerWidth();
						});
						element.width(width);
					} else {
						width += this._calculateSpecialColumnsWidth();
						element.css('width', width);
					}
				}
			} else if (this.options.width !== null) {
				element.css('width', this.options.width);
			}
		},
		_calculateContainerWidth: function (addScrollWidth) {
			var width = 0, cols = this.options.columns, i;
			for (i = 0; i < cols.length; i++) {
				//check if the columns is hidden
				//or will be hidden if we are still in the initialization phase
				if (cols[i].hidden !== true &&
					cols[i].fixed !== true &&
						(this._initialHiddenColumns === undefined ||
						$.inArray(cols[i], this._initialHiddenColumns) === -1)) {
					width += cols[i].width ? parseInt(cols[i].width, 10) : this.options.defaultColumnWidth === null ? 0 : parseInt(this.options.defaultColumnWidth, 10);
				}
			}
			// add the scrollbar width if any 
			//L.A. 30 March 2012 Fixed bug #99024 When in grid fixedHeaders is false, it is not possible to resize last column
			if (this.options.height !== null && width > 0 && addScrollWidth === true) {
				//do not add the scrollbar width in case we have virtualization and no width
				width += this._scrollbarWidth();
			}
			return width;
		},
		// creates a scrolling, non-virtual grid
		_createScrollingGrid: function () {
			var self = this, id = this.id() + '_scroll',dataContainer,
				scrollDiv = '<div id="' + id + '"></div>';
			this.element.wrap(scrollDiv);
			//dataContainer = $('#' + id);
			dataContainer = this.element.parent();
			//if (this.options.accessibilityRendering) {
				this.element.attr('aria-describedby', id);
			//}
			dataContainer.addClass(this.css.gridScrollDivClass).wrap("<div id='" + this.id() + "_container'></div>");
			// L.A. 08 October 2012 - Fixing bug #121790 
			// The horizontall scollbar overlaps the last visible row when using paging
			// Scrollbar height is the same as _scrollbarWidth
			if ($.ig.util.isIE7) {
				dataContainer.css('padding-bottom', this._scrollbarWidth());
			}
			this.container().attr('tabIndex', this.options.tabIndex).addClass(this.css.baseClass).addClass(this.css.gridClasses);
			if (this.options.width !== null) {
				this.container().css('width', this.options.width);
				// A.T. 14 Feb 2011 - Fix for bug #66086
				if (this.options.width.indexOf && this.options.width.indexOf('%') !== -1) {
					//if ((this.options.width.indexOf('%') !== -1 && parseInt(this.options.width, 10) === 100) || this.options.width.indexOf('%') === -1) {
						//this.element.css('width', this.options.width);
					//} else if (this.options.width.indexOf('%') !== -1) {
					//if (this.options.width.indexOf('%') !== -1) {
					this.element.css('width', '100%');
					//}
				}// else {
					//this.element.css('width', this.options.width);
				//}
				if (this.options.height !== null) {
					this._addHorizontalScrollBar(dataContainer);
					this.scrollContainer().css('overflow-x', 'hidden');
				}
			} else {
				this._setContainerWidth(this.container());
				// set overflow-x: hidden on the scrolling container
				this.scrollContainer().css('overflow-x', 'hidden');
			}
			this.container().css("position", "relative");
			if (this.options.height !== null) {
				this.scrollContainer().css('overflow-y', 'auto');
				if (this.options.autoAdjustHeight) {
					this.container().css('height', this.options.height);
				} else {
					this.scrollContainer().css('height', this.options.height);
				}
			}
			//M.K. Preserve scroll position after dataBind
			if (this._persistVirtualScrollTop) {
				this.scrollContainer().bind({
					scroll: function () {
						self._prevFirstVisibleTROffset = self.scrollContainer().scrollTop();
					}
				});
			}

			/*
			// touch scroll support
			if (this.options.height !== null && this.options.width !== null) {
				this.scrollContainer().attr("data-scroll", "true");
			} else if (this.options.height !== null) {
				this.scrollContainer().attr("data-scroll", "y");
			} else if (this.options.width !== null) {
				this.scrollContainer().attr("data-scroll", "x");
			}
			*/
		},
		_touch: function () {
			var id = this.id(), div = this.scrollContainer();
			if (div.length !== 1) {
				div = this._vdisplaycontainer();
			}
			if (div.length) {
				div.attr('data-scroll', 'true').attr('data-oneDirection', 'true');
				if (this._hscrollbarcontent()[0]) {
					div.attr('data-xScroller', '#' + id + '_hscroller');
				} else if (this._vhorizontalcontainer()[0]) {
					div.attr('data-xScroller', '#' + id + '_horizontalScrollContainer');
				}
				if (this._scrollContainer()[0]) {
					div.attr('data-yScroller', '#' + id + '_scrollContainer');
				}
				// M.H. 20 March 2012 Fix for bug #104415
				if (typeof Modernizr === 'object' &&
						Modernizr.touch === true &&
						this.element.igScroll !== undefined) {
					// M.H. 1 Sep 2014 Fix for bug #177790: Column misalignment on touch devices when there is a igGrid.height set
					this._scrollbarWidthResolved = 0;
					div.css('overflow-y', 'hidden');
				}
			}
		},
		// virtual grid implies scrolling grid 
		_createVirtualGrid: function () {
			/* 
			 *  // this is the general structure for virtualization when both column and row virtualization are enabled
			 *	<table border="0" cellspacing="0" cellpadding="0">
			 *		<tr>
			 *			<td><div id="#gridID_headers"></div></td>
			 *			<td></td>
			 *		</tr>
			 *			<tr>
			 *				<td><div id="#gridID_displayContainer"></td>
			 *				<td><div id="#gridID_scrollContainer"></div></td>
			 *			</tr>
			 *			<tr>
			 *			<td><div id="#gridID_horizontalScrollContainer"></div></td>
			 *			<td></td>
			 *			</tr>
			 *	</table>
			 */
			var id = this.id(), $vCont,
				//touchstart,
				//touchend,
				grid,
				newW,
				percWidthStr = $.ig.util.isWebKit ? 'width=100%' : '',
				totalWidth,
				scrollContainerInner,
				scrollbarWidth,
				w = 0,
				virtualGridMarkup = '<div id="' + id + '_container" style="margin:0px; border:0px; padding:0px;"><table border="0" cellspacing="0" cellpadding="0" class="ui-iggrid-layout-helper" style="border-spacing:0px" id="' + id + '_virtualContainer" ><tbody role="rowgroup"><tr><td colspan="2" style="border-width:0px"><div id="' + id + '_headers_v" style="overflow:hidden;"></div></td></tr><tr><td style="border-width:0px;"><div id="' +
					id + '_displayContainer"></td>$verticalMarkup$</tr>$horizontalMarkup$</tbody></table></div>',
				verticalMarkup,
				horizontalMarkup = '<tr><td colspan="2" style="border-width: 0px"><div id="' + id + '_horizontalScrollContainer"></div></td></tr>';
			scrollbarWidth = this._scrollbarWidth();
			if ($.ig.util.isIE) {
				scrollbarWidth += 1;
			}
			if (parseInt(this.options.height, 10) > 0) {
				verticalMarkup = '<td style="border-width: 0px;"><div id="' + id + '_scrollContainer" style="overflow:scroll; overflow-x:hidden; width: ' + scrollbarWidth + 'px; height:' + this.options.height + ';"></div></td>';
			} else {
				verticalMarkup = '<td style="border-width: 0px;"><div id="' + id + '_scrollContainer" style="overflow:scroll; overflow-x:hidden; width: ' + scrollbarWidth + 'px;"></div></td>';
			}
			if (this.options.virtualization === true) {
				virtualGridMarkup = virtualGridMarkup.replace('$verticalMarkup$', verticalMarkup).replace('$horizontalMarkup$', horizontalMarkup);
			} else if (this.options.rowVirtualization === true) {
				virtualGridMarkup = virtualGridMarkup.replace('$verticalMarkup$', verticalMarkup).replace('$horizontalMarkup$', '');
			} else if (this.options.columnVirtualization === true) {
				virtualGridMarkup = virtualGridMarkup.replace('$horizontalMarkup$', horizontalMarkup).replace('$verticalMarkup$', '');
			}
			// if column virtualization is enabled we really need to make sure that we set the width of the data table to 100 % otherwise 
			// the column widths will not be correct and will try to be accomodated in the specified fixed width of the grid.
			if (this.options.virtualization === true || this.options.columnVirtualization === true) {
				this.element.css('width', '100%');
			}
			// now inject our existing grid in the place of the "displayContainer"
			this.element.wrap(virtualGridMarkup);
			// apply the base classes
			// M.H. 23 Apr 2014 Fix for bug #170317: Can't set focus to grid container when row virtualization is enabled
			this.container().attr('tabIndex', this.options.tabIndex).addClass(this.css.baseClass).addClass(this.css.gridClasses);
			if (this.options.width !== null) {
				// M.H. 21 Mar 2014 Fix for bug #159951: When virtualization is enabled in a grid with % width (not 100%), the layout is broken
				//if (this.options.width.indexOf && this.options.width.indexOf("%") === -1) {
					this.container().width(this.options.width);
				//} else {
				//this.container().width('100%');
				//}
			} else {
				this._setContainerWidth(this.container());
			}
			// M.H. 21 Nov 2014 Fix for bug #185538: Row height gets wider to fill the empty space if summarized row is displayed and virtualizationMode is set “continuous”.
			this._vdisplaycontainer()
				.addClass(this.css.gridScrollDivClass)
				.addClass(this.css.gridVirtualScrollDivClass)
				.append(this.element[0]);
			//I.I. bug fix for 105701, 105703. When virtualization is continuous and grid is hierarchical, this line causes header misplacements.
			//I.I. bug fix for 110664
			// M.H. 21 May 2012 Fix for bug #112167 - renderColgroup will call visibleColumns which sets incorrect number of visible columns at init
			/*
			if (this.options.virtualization === true && this.options.virtualizationMode === 'fixed') {
				this._renderColgroup(this.element[0], false, false, this.options.autofitLastColumn);
			}
			*/
			grid = this;
			totalWidth = this._calculateContainerWidth(false);
			if (this.options.width !== null) {
				w = parseInt(this.options.width, 10);
			} else {
				w = totalWidth;
			}
			if (this.options.height !== null && this.options.width !== null) {
				w -= this._scrollbarWidth();
			}
			//A.Y. bug 98976. Make the width undefined if 0 or less so that it is ignored by jquery as the width of the container.
			if (w <= 0) {
				w = undefined;
			}
			// M.H. 11 April 2012 Fix for bug #108438
			if (w > 0 && this.options.expandColWidth && !this.options.width) {
				w += this.options.expandColWidth;
			}
			// set virtual container's width correctly
			$('<colgroup><col ' + (w <= 0 ? percWidthStr : ('width="' + w + '"')) + '></col><col width="' + this._scrollbarWidth() + '"></col></colgroup>').prependTo(this._virtualcontainer());
			newW = this.options.width;
			// M.H. 4 Apr 2014 Fix for bug #159951: When virtualization is enabled in a grid with % width (not 100%), the layout is broken
			if (newW && newW.indexOf && newW.indexOf('%') !== -1) {
				newW = '100%';
			}
			this._virtualcontainer().css('width', newW).css('max-width', newW);
			// now create the inner scrolling containers, that will be placed inside of the scrollContainer/horizonalScrollContainer,
			// and will cause the virtual scrollbars to appear and grow according to the total records in the data source
			scrollContainerInner = '<div style="width:1px; overflow:hidden; height:' + (this._totalRowCount * parseInt(this.options.avgRowHeight, 10)) + 'px;"></div>';
			this._scrollContainer().append(scrollContainerInner);
			// M.H. 9 June 2014 Fix for bug #173336: Horizontal scrollbar does not appear when row virtualization is enabled
			// M.H. 18 Aug 2014 Fix for bug #177656: When virtualization is enabled resizing a column of a grid with 100% width makes the grid expand
			if ((this.options.virtualization === true || this.options.rowVirtualization === true) && this.options.width &&
				this.options.width.indexOf && this.options.width.indexOf('%') > 0) {//totalWidth > $("#" + id + "_container").width()
				this._addHorizontalScrollBar(this._virtualcontainer());
				this._virtualcontainer().css('table-layout', 'fixed');
			} else if ((this.options.virtualization === true || this.options.columnVirtualization === true) && this.options.width && (totalWidth > parseInt(this.options.width, 10))) {
				//we always need to have the horizontal scroll containers if we have width
				//as there may be hidden columns that when visible will show a scrollbar
				//I.I. bug fix for 110369
				// do the same for the horizontal scrolling
				// M.H. 5 Jul 2013 Fix for bug #145572: When Resizing with continuous rowVirtualization no horizontal scrollbar appears when needed
				// we need to render horizontal scroll container when virtualization mode is continuous
				// if we use another solution to show/hide horizontal scroll container then height is not properly calculated
				this._renderHorizontalScrollContainer(totalWidth);
			}
			if (parseInt(this.options.height, 10) > 0) {
				this._vdisplaycontainer().css('height', this.options.height).css('vertical-align', 'top');
			}
			//I.I. bug fix for 104085, tabindex=-1 added
			//L.A. fixed bug #105997 Can't navigate selection with arrow keys when fixed virtualization is enabled
			//Anchor should have some content in order to have get a focus. The content is visible but outside of the visible area.
			//L.A. fixed bug #112519 When continuous virtualization and selection with mode = row are enabled scrolling down the grid and 
			// selecting a row changes records values with wrong ones.
			//L.A. fixed bug #113287 fixed appending to the _virtualContainer
			this._vdisplaycontainer().css('position', 'relative').css('width', w).css('maxWidth', w);
			//L.A. fixed bug #101375 moving the anchor to _headers_v, because it's visible in IE8, IE9
			if (this.options.virtualization === true) {
				this.container().find("#" + id + "_headers_v").append("<a href='#' id='" + id + "_displayContainer_a' tabindex='-1' style='position:absolute;top:-100px;left:-100px'>&nbsp;</a>");
			}
			if (this.options.width && this.options.virtualization === false && this.options.columnVirtualization === false) {
				this._vdisplaycontainer().css({ 'overflow-y': 'hidden', 'overflow-x': 'auto' });
			} else {
				this._vdisplaycontainer().css('overflow', 'hidden');
			}
			// make sure mouse wheel scrolling also works for the table with data, not only the virtual scrollbar
			// it's a smart and little-known technique i am going to use here -:) 
			//I.I. bug fix for 109777, mouseover -> mouseenter, mouseout -> mouseleave
			this._vdisplaycontainer().parent().bind({
				mouseenter: function () {
					grid._isMouseOverVirtualTable = true;
				},
				mouseleave: function () {
					grid._isMouseOverVirtualTable = false;
				}
			});
			/*
			touchstart = function (event) {
				this._oldPageY = event.touches[0].pageY;
				event.stopPropagation();
				event.preventDefault();
			};
			touchend = function (event) {
				// compare pageY and pageX with the old ones
				if (event.changedTouches[0].pageY - this._oldPageY > 0) {
					grid._onVirtualVerticalScroll(event, Math.abs(event.changedTouches[0].pageY - this._oldPageY), 'up');
				} else if (event.changedTouches[0].pageY - this._oldPageY < 0) {
					grid._onVirtualVerticalScroll(event, Math.abs(event.changedTouches[0].pageY - this._oldPageY), 'down');
				}
			};
			$('#' + id + '_displayContainer').parent()[0].addEventListener("touchstart", $.proxy(touchstart, this), false);
			$('#' + id + '_displayContainer').parent()[0].addEventListener("touchend", $.proxy(touchend, this), false);
			*/
			// Refactor to keep in one place
			// M.H. 6 Nov 2013 Fix for bug #156713: Scrolling with the mouse wheel results in looping through a subset of the rows when using continuous virtualization in Chrome, Firefox, and Safari
			this._documentEvents = {
				DOMMouseScroll: function (event) { // Firefox
					var dir = 'down', delta, step;
					step = grid.options.virtualizationMouseWheelStep === null ? parseInt(grid.options.avgRowHeight, 10) : grid.options.virtualizationMouseWheelStep;
					//I.I. bug fix for 104505. The issue is reproducible with jquery 1.7.1 only
					delta = -event.originalEvent.detail / 3; // // determine if we are scrolling up or down
					if (delta > 0) { // scroll up 
						dir = 'up';
					}  // else default => scroll down 
					// determine if mouse over  is true
					if (grid._isMouseOverVirtualTable) {
						grid._onVirtualVerticalScroll(event, step, dir); // define this # of pixels automatically
						event.preventDefault();
					}
				},
				mousewheel: function (event) { // IE, Chrome, Safari, Opera
					var dir = 'down', delta, step;
					step = grid.options.virtualizationMouseWheelStep === null ? parseInt(grid.options.avgRowHeight, 10) : grid.options.virtualizationMouseWheelStep;
					//I.I. bug fix for 104505. The issue is reproducible with jquery 1.7.1 only
					delta = event.originalEvent.wheelDelta / 120; // determine if we are scrolling up or down
					if (delta > 0) {
						dir = 'up';
					}
					if (grid._isMouseOverVirtualTable) {
						grid._onVirtualVerticalScroll(event, step, dir); // define this # of pixels automatically 
						event.preventDefault();
					}
				}
			};
			this._documentEvents["keydown." + this.id()] = function (event) {
					var keyCode = event.keyCode, $sc,
						dir = null, step;
					if (grid._isMouseOverVirtualTable) {
						if (keyCode === $.ui.keyCode.DOWN) {
							dir = 1;

						} else if (keyCode === $.ui.keyCode.UP) {
							dir = -1;
						}
						if (dir && grid._isMouseOverVirtualTable) {
							step = grid.options.virtualizationMouseWheelStep === null ? parseInt(grid.options.avgRowHeight, 10) : grid.options.virtualizationMouseWheelStep;
							$sc = grid._scrollContainer();
							$sc.scrollTop($sc.scrollTop() + step * dir);
						}
					}
			};
			$(document).bind(this._documentEvents);
			// bind scroll event handlers
			if (this.options.virtualization === true || this.options.rowVirtualization === true) {
				this._scrollContainer().bind({
					scroll: function (event) {
						grid._onVirtualVerticalScroll(event);
						//bugs #70681  and bug #72116
						grid._virtualScrollMouseDown = false;
					},
					mousedown: function () {
						// this is necessary because of one special case. When we scroll just once, we want to move by 1 row always (in chrome and FF)
						// but when we scroll continuously, we don't want the scrollbar to jump (Refer to bugs #70681  and bug #72116
						grid._virtualScrollMouseDown = true;
					}
				});
			}
			if (this.options.virtualization === true || this.options.columnVirtualization === true) {
				$vCont = this._vhorizontalcontainer();
				$vCont
					.data('containerName', 'vScrollbar')
					.bind({
						scroll: function (event) {
							grid._onVirtualHorizontalScroll(event);
						}
					});
				if (this.options.virtualizationMode === 'continuous') {
					this._registerScrllCntnrToSync($vCont);
				}
			}
			// S.S. May 11, 2012, #103088 We need to use a normal horizontal scroll container when we use only vertical
			// virtualization and the set grid's width is too narrow
			if (this._vhorizontalcontainer().length === 0 && this.options.width !== null) {
				// add the scrollbar
				// M.H. 4 Apr 2014 Fix for bug #159951: When virtualization is enabled in a grid with % width (not 100%), the layout is broken
				if (!this.options.width.indexOf || this.options.width.indexOf('%') === -1) {
					this._addHorizontalScrollBar(this._virtualcontainer());
				}
				// changes the overlow-x attribute of the main container
				this._vdisplaycontainer().css('overflow-x', 'hidden');
			}
			this.element.height(this._scrollContainer().height());
			//A.T. 16 Oct. Fix for bug #123235
			if (this.options.width && this.options.width.indexOf && this.options.width.indexOf("%") !== -1) {
				this.container().find("#" + id + "_virtualContainer > colgroup > col:first").css("width", "100%");
				this._vhorizontalcontainer().css("width", "100%");
				this._vdisplaycontainer().css("width", "100%").css("max-width", "100%");
			}
		},
		// M.H. 5 Jul 2013 Fix for bug #145572: When Resizing with continuous rowVirtualization no horizontal scrollbar appears when needed
		// render horizontal scroll container when virtualization mode is continuous
		_renderHorizontalScrollContainer: function (totalWidth) {
			var horizontalScrollContainerInner, w = this.options.width;
			// M.H. 4 Apr 2014 Fix for bug #159951: When virtualization is enabled in a grid with % width (not 100%), the layout is broken
			if (w && w.indexOf && w.indexOf('%') !== -1 && (this.options.virtualization === true || this.options.rowVirtualization === true)) {
				return;
			}
			// do the same for the horizontal scrolling
			this._vhorizontalcontainer().css('height', this._scrollbarWidth() + 'px').css('overflow', 'scroll');
			//if (this.options.virtualization === true || this.options.rowVirtualization === true) {
			//	$('#' + id + '_horizontalScrollContainer').css('width', parseInt(this.options.width, 10) - this._scrollbarWidth());
			//} else {
			if ($.ig.util.isIE) {
				// M.H. 3 Sep 2012 Fix for bug #118189: When virtualization is enabled, clicking on the horizontal scrollbar does not scroll the grid in IE9
				// M.H. 12 June 2015 Fix for bug 201174: With column virtualization enabled hiding and then showing a column will result in wrong header text
				// in case of column virtualization when call initializeHeights grid has 0 height because height of vhorizontalContainer isn't properly calculated
				this._vhorizontalcontainer()
					.css('width', parseInt(this.options.width, 10) + 1)
					.css('height', (this._vhorizontalcontainer().outerHeight() + 1) + 'px');
			} else {
				this._vhorizontalcontainer().css('width', this.options.width);
			}
			//}
			horizontalScrollContainerInner = '<div style="width:' + totalWidth + 'px;height:1px;"></div>';
			this._vhorizontalcontainer().append(horizontalScrollContainerInner);
		},
		// if offset is defined, this means there is mouse-wheel scroll which we are manually handling. the offset is the amount of px to move - up or down 
		_onVirtualVerticalScroll: function (event, offset, dir) {
			var newSri;
			this._isHorizontal = false;
		//	originalEvent = event.originalEvent,
			var scrollContainer = this._scrollContainer(), scrollTopDiff,
				isIE = $.ig.util.isIE,
				current = scrollContainer.scrollTop(),
				mode = this.options.virtualizationMode;
			if (offset !== undefined) {
				if (dir === 'down') {
					scrollContainer.scrollTop(current + offset);
				} else {
					scrollContainer.scrollTop(current - offset);
				}
				current = scrollContainer.scrollTop();
			} /*else {
				// A.T. 31 March 2011 - fix for bug #70681 
				// Please revise
				if (Math.abs(current - this._oldScrollTop) < this.options.avgRowHeight && current - this._oldScrollTop !== 0) {
					if (current > this._oldScrollTop) {
						scrollContainer.scrollTop(this._oldScrollTop + this.options.avgRowHeight);
					} else {
						scrollContainer.scrollTop(this._oldScrollTop - this.options.avgRowHeight);
					}
				}
			}
			*/
			//this._startRowIndex = Math.ceil(scrollContainer.scrollTop() * this._totalRowCount / (scrollContainer[0].scrollHeight - scrollContainer[0].offsetHeight));
			scrollTopDiff = scrollContainer.scrollTop() - this._oldScrollTop;
			if (Math.abs(scrollTopDiff) < 5 && $.ig.util.isFF && !isIE) {
				return;
			}
			if (mode === undefined || mode === '') {
				mode = 'continuous';
			}
			if (mode === 'fixed') {
				newSri = Math.ceil(scrollContainer.scrollTop() / parseInt(this.options.avgRowHeight, 10));
				if ((!isIE) && newSri === this._startRowIndex && this._virtualScrollMouseDown) {
					if (scrollTopDiff > 0 && scrollTopDiff < parseInt(this.options.avgRowHeight, 10)) {
						newSri++;
						scrollContainer.scrollTop(scrollContainer.scrollTop() - scrollTopDiff + parseInt(this.options.avgRowHeight, 10));
					} else if (scrollTopDiff < 0 && Math.abs(scrollTopDiff) < parseInt(this.options.avgRowHeight, 10)) {
						newSri--;
						scrollContainer.scrollTop(scrollContainer.scrollTop() - scrollTopDiff - parseInt(this.options.avgRowHeight, 10));
					}
				}
				if (newSri > this._totalRowCount - this._virtualRowCount) {
					newSri = this._totalRowCount - this._virtualRowCount;
				}
				if (newSri < 0) {
					newSri = 0;
				}
				// it's important to throw pre-render before the rendering params are changed
				this._trigger("virtualrendering");
				this._startRowIndex = newSri;
				this._renderVirtualRecords();
			} else if (mode === 'continuous') {
				this._trigger("virtualrendering");
				// M.H. 19 Jun 2013 Fix for bug #142650: igGrid.virtualScrollTo API method is not working
				this._virtualScrollToInternal(current);
			}
			this._oldScrollTop = scrollContainer.scrollTop();
			//M.K. Preserve scroll position after dataBind
			if (this._persistVirtualScrollTop) {
				this._saveFirstVisibleTRIndex();
			}
		},
		_scrollContainer: function () {
			if (!this._scrollContainerObj || this._scrollContainerObj.length === 0) {
				this._scrollContainerObj = this.container().find("#" + this.id() + "_scrollContainer");
			}
			return this._scrollContainerObj;
		},
		_onVirtualHorizontalScroll: function (event) {
			var newSci,
				internallyTriggered = event === undefined, //in the case of hiding or other features that would requred it
				horizontalScrollContainer = this._vhorizontalcontainer(),
				scrollLeft = horizontalScrollContainer.scrollLeft(),
				hiddenContentWidth = horizontalScrollContainer[0].scrollWidth - horizontalScrollContainer[0].offsetWidth;
			//I.I. bug fix for 105932 and 105951
			if (this.options.virtualization === true && this.options.virtualizationMode === 'continuous') {
				this._onScrollContainer(event);
				return;
			}
			this._isHorizontal = true;
			if (hiddenContentWidth > 0) {
				newSci = Math.ceil(scrollLeft * this._totalColumnCount / hiddenContentWidth);
				newSci = Math.min(newSci, this._totalColumnCount - this._virtualColumnCount);
			} else {
				newSci = 0;
			}
			if (internallyTriggered || newSci !== this._startColIndex) {
				this._trigger("virtualrendering");
				this._startColIndex = newSci;
				this._renderVirtualRecords();
				// trigger an event so that features that are header-dependent, such as filtering and sorting , update their UI accordingly
				this._trigger('virtualhorizontalscroll', null, { startColIndex: this._startColIndex, endColIndex: this._startColIndex + this._virtualColumnCount - 1 });
			}
		},
		_initLoadingIndicator: function () {
			var widget;
			// attach loading indicator widget
			if (this.container().data("igLoading")) {
				this._loadingIndicator = this.container().data("igLoading").indicator();
			} else {
				widget = this.container().igLoading().data("igLoading");
				if (widget) {
					this._loadingIndicator = widget.indicator();
				}
			}
		},
		_addHorizontalScrollBar: function (parent) {
			var sb = $("<div id='" + this.id() + "_hscroller_container' ></div>")
				.css('height', this._scrollbarWidth() + 'px')
				.css("position", "relative")
				.css('display', 'none')
				.css('overflow', 'hidden')
				.append(
					$("<div id='" + this.id() + "_hscroller' ></div>")
						.data('containerName', 'hScrollbar')
						.css('width', '100%')
						.css('position', 'absolute')
						.css('bottom', '0px')
						.css('overflow-x', 'scroll')
						.css('overflow-y', 'scroll')
						.append(
							$("<div id='" + this.id() + "_hscroller_inner' ></div>")
								.css('height', '1px')
						)
						.bind("scroll", $.proxy(this._onScrollContainer, this))
				);
			if (parent) {
				sb.insertAfter(parent);
			}
			this._registerScrllCntnrToSync($('#' + this.id() + '_hscroller'));
		},
		_updateVirtualHorizontalScrollbar: function () {
			var horizontalScrollContainerInner, horizontalScrollContainer, isVisible;
			//update horizontalScrollbar by updating horizontalScrollContainer inner div width
			horizontalScrollContainerInner = this.container().find("#" + this.id() + "_horizontalScrollContainer div");
			horizontalScrollContainerInner.css('width', this._calculateContainerWidth(false));
			//hide the horizontalScrollContainer if no scrollbar should be visible
			horizontalScrollContainer = this._vhorizontalcontainer();
			// M.H. 19 Feb 2015 Fix for bug #187756: When row selectors and fixed virtualization are enabled fixing a column moves the horizontal scrollbar downwards.
			isVisible = horizontalScrollContainer.is(':visible');
			if (horizontalScrollContainer.width() > horizontalScrollContainerInner.width()) {
				horizontalScrollContainer.css('display', 'none');
			} else {
				horizontalScrollContainer.css('display', '');
			}
			// M.H. 19 Feb 2015 Fix for bug #187756: When row selectors and fixed virtualization are enabled fixing a column moves the horizontal scrollbar downwards.
			if (isVisible !== horizontalScrollContainer.is(':visible')) {
				this._initializeHeights();
			}
		},
		_generateColumnFlatStructure: function (treeStructure) {
			var cols, oldCols, newCols = [];
			cols = treeStructure.slice(0);
			oldCols = treeStructure.slice(0);
			this._multiColumnIdentifier = 0;
			this._maxLevel = this._getMaxLevelRecursive(0, cols);
			this._hiddenColumns = {};
			this._analyzeMultiColumnHeaders(cols, newCols, 0, oldCols, []);
			this._oldCols = oldCols;
			this.options.columns = newCols;
		},
		moveColumn: function (column, target, after, inDom, callback) {
			/* Moves a visible column at a specified place, in front or behind a target column or at a target index
			Note: This method is asynchronous which means that it returns immediately and any subsequent code will execute in parallel. This may lead to runtime errors. To avoid them put the subsequent code in the callback parameter provided by the method.
			paramType="number|string" An identifier of the column to be moved. It can be a key, a Multi-Column Header identificator, or an index in a number format. The latter is not supported when the grid contains multi-column headers.
			paramType="number|string" An identifier of a column where the moved column should move to or an index at which the moved column should be moved to. In the case of a column identifier the column will be moved after it by default.
			paramType="bool" optional="true" Specifies whether the column moved should be moved after or before the target column. This parameter is disregarded if there is no target column specified but a target index is used. 
			paramType="bool" optional="true" Specifies whether the column moving will be enacted through DOM manipulation or through rerendering of the grid.
			paramType="function" optional="true" Specifies a custom function to be called when the column is moved.
			*/
			var grid = this, found, nColArray, movingParams, hcPreserve, isFixed,
				cCols = this._oldCols ? jQuery.extend(true, [], this._oldCols) : jQuery.extend(true, [], this.options.columns);
			// Assume optional params
			after = after === null || after === undefined ? true : after;
			inDom = inDom === null || inDom === undefined ? true : inDom;
			// The first thing to do is move the columns in their internal collection wrappers. For a flat column layout
			// we'll use this.options.columns and for a multicolumn layout we'll use _oldCols and then force an update
			// on the columns collection.
			// we also need to normalize the column and target params
			movingParams = {
				column: column,
				target: target,
				after: after
			};
			if (this._oldCols) {
				found = this._performInternalMove(movingParams, this._oldCols);
				// and update the column defs while preserving the hidden columns array
				hcPreserve = jQuery.extend(true, {}, this._hiddenColumns);
				this._generateColumnFlatStructure(this._oldCols);
				this._hiddenColumns = hcPreserve;
				this._preserveColspans(this._oldCols);
			} else {
				found = this._performInternalMove(movingParams, this.options.columns);
			}
			// If we couldn't accomplish the move on an internal level there is no point going on 
			// with actual DOM manipulations or grid rendering.
			if (found === false) {
				throw new Error($.ig.Grid.locale.movingNotAllowedOrIncompatible);
			}
			if (movingParams.columnFixed === movingParams.targetFixed) {
				/*	The nColArray is a two dimensional array that consists of column id-s (or multicolumn header ids) and the number -1
					It normalizes the column layout where the ids represent actual columns and -1s represent absent columns due to 
					upper columns covering the space through rowspan > 1
					This array is crucial for column moving as moving needs to be done in depth when we are moving multicolumn headers and
					the lower levels have complex structures involving rowspans and smaller colspans (an MCH inside an MCH)
					By simplifying the structure to this array the actual move can be accomplished via iteration as opposed to a complex
					constructive recursion logic.
					To avoid possible sync issues we are going to build the array on each run (as opposed to using a cached version)
					A cached version would need to get updated everytime this method is called anyway.	*/
				nColArray = this._buildColumnLayoutArray(cCols, movingParams.columnFixed);
			} else {
				// if the column and target are in different grids we'll return the
				// moving params so that the caller can handle the situation
				return movingParams;
			}
			// update params
			column = movingParams.column;
			target = movingParams.target;
			after = movingParams.after;
			isFixed = movingParams.columnFixed;
			if (inDom === true) {
				// proceed with the dom column move, it'll be done through a loading indicator and a seperate thread
				this._loadingIndicator.show();
				setTimeout(function () {
					grid._columnMovingResets();
					grid._performDomColumnMove(column, target, after, nColArray, isFixed);
					grid._loadingIndicator.hide();
					if (callback) {
						$.ig.util.invokeCallback(callback, [grid.options.columns]);
					}
				}, 0);
			} else {
				this._columnMovingResets();
				this._performColumnMove(column, target, after, nColArray, isFixed);
				if (callback) {
					$.ig.util.invokeCallback(callback, [grid.options.columns]);
				}
			}
		},
		_columnMovingResets: function () {
			var i, $th;
			this._updateHeaderColumnIndexes();
			delete this._virtualDom;
			delete this._visibleColumnsArray;
			this._headerCells = [];
			for (i = 0; i < this.options.columns.length; i++) {
				$th = this.container().find('#' + this.id() + '_' + this.options.columns[i].key).data('columnIndex', i);
				$th.data('data-mch-order', i);
				if ($th.is(":visible")) {
					this._headerCells.push($th);
				}
			}
		},
		_preserveColspans: function (cols) {
			var i, cs = 0, col, res;
			for (i = 0; i < cols.length; i++) {
				col = cols[i];
				if (col.group !== undefined && col.group !== null) {
					res = this._preserveColspans(col.group);
					col.colspan = res;
					cs += res;
				} else {
					if (col.hidden !== true) {
						cs++;
					}
				}
			}
			return cs;
		},
		_columnVisible: function (col) {
			return !col.hidden;
		},
		_buildColumnLayoutArray: function (cCols, fixed) {
			// fixed specifies if the nColArray should be built for the unfixed or fixed grid
			var i = 0,
				j = 0,
				col,						// a single col in the cycle
				id,							// the single col's identification
				colrs,						// the single col's rowspan
				l,							// current col's horizontal length (colspan)
				x = 0,						// current horizontal identificator
				nCols,						// the newly built level
				level = 0,					// level number
				colgrp = fixed ? this.fixedBodyContainer().find("colgroup:first") : this.element.find("colgroup:first"),
				width = colgrp.children("col:not([data-skip=true])").length,
				htbl = fixed ? this.fixedHeadersTable() : this.headersTable(),
				height = htbl.find("thead tr").length,
				array = [];					// the array we are going to build
			if (height === 0 && this.options.showHeader === false) {
				height = 1;
			}
			for (i = 0; i < width; i++) {
				array[i] = [];
			}
			i = 0;
			while (level < height) {
				nCols = [];
				while (i < cCols.length) {
					col = cCols[i];
					if (col.hidden === true || this._isSubsetFixed(col) !== fixed) {
						i++;
						continue;
					}
					colrs = col.rowspan || 1;
					id = this._getColMarkForLevel(col);
					l = col.colspan || 1;
					for (j = 0; j < l; j++) {
						array[x + j][level] = id;
					}
					if (col.crs === colrs && col.group) {
						// we'll only preserve places for visible columns from the group
						nCols.push.apply(nCols, $.grep(col.group, this._columnVisible).slice(0));
					} else {
						nCols.push(col);
					}
					x += l;
					i++;
				}
				cCols = nCols;
				level++;
				x = 0;
				i = 0;
			}
			return array;
		},
		_getColMarkForLevel: function (col) {
			if (!col.crs) {
				col.crs = 0;
			}
			col.crs++;
			if (col.crs > 1) {
				return -1;
			}
			return col.key || col.identifier;
		},
		_performInternalMove: function (movingParams, subset) {
			/*	recursively searches for the required column and performs a move on the level the column was found 
				returns true if the move is successful
			*/
			var i = 0, j, success = true;
			i = this._getColIdxById(subset, movingParams.column);
			if (typeof movingParams.column === "number") {
				movingParams.column = subset[i].key || subset[i].identifier;
			}
			if (i || i === 0) {
				// column is found specify if it's fixed
				movingParams.columnFixed = this._isSubsetFixed(subset[i]);
				j = this._getColIdxById(subset, movingParams.target);
				// modify target when using indexes
				if (typeof movingParams.target === "number") {
					movingParams.target = subset[j].key || subset[j].identifier;
					movingParams.after = j >= i;
				}
				//
				if (j || j === 0) {
					// target is found specify if it's fixed
					movingParams.targetFixed = this._isSubsetFixed(subset[j]);
					success = success && this._rearrangeArray(subset, i, 1, movingParams.after === true ? j + 1 : j);
					success = success || (movingParams.targetFixed !== movingParams.columnFixed);
					return success;
				}
				return false;
			}
			for (i = 0; i < subset.length; i++) {
				if (subset[i].group) {
					if (this._performInternalMove(movingParams, subset[i].group) === true) {
						return true;
					}
				}
			}
			return false;
		},
		_getColIdxById: function (array, id) {
			var i, col;
			if (typeof id === "number") {
				return id;
			}
			for (i = 0; i < array.length; i++) {
				col = array[i];
				if (col.key) {
					if (col.key === id) {
						return i;
					}
				} else if (col.identifier) {
					if (col.identifier === id) {
						return i;
					}
				}
			}
		},
		_isSubsetFixed: function (subset) {
			var mchc;
			if (subset.group) {
				mchc = this._getMultiHeaderColumnById(subset.identifier);
				return !!mchc.children[0].fixed;
			}
			return !!subset.fixed;
		},
		_getCellIndexByColumnKey: function (key) {
			// gets the index of the cell corresponding to a specific col key
			var i = this.getVisibleIndexByKey(key);
			return i === -1 ? i : i +
				this.element.find("tbody>tr:not([data-grouprow='true']):first")
				.children("th,td[data-skip='true'],td[data-parent]").length;
		},
		_findColAreaInLayout: function (col, nColArray, depth) {
			// searches for the column in the column layout array at a specified depth
			var i, j, res = {}; // the result is stored in a object with start and length properties
			for (i = 0; i < nColArray.length; i++) {
				if (nColArray[i][depth] === col) {
					res.start = i;
					for (j = i; j < nColArray.length; j++) {
						if (nColArray[j][depth] !== col) {
							break;
						}
					}
					res.length = j - i;
					return res;
				}
			}
			return null;
		},
		_rearrangeArray: function (array, start, length, at) {
			// rearranges an array by first removing the area from a specified start index and with a specified length
			// and then inserting it at a specified index
			var col, targetAfter = start < at, n;
			// targetAfter stores whether the target position for the column is to the right of the current position as
			// we need to modify the target position in this case
			if (start === at || start < 0 || at < 0 || start >= array.length || at > array.length) {
				//dummy check
				return false;
			}
			col = array.splice(start, length);
			for (n = 0; n < col.length; n++) {
				array.splice(targetAfter ? at - length + n : at + n, 0, col[n]);
			}
			return true;
		},
		_moveColumnInHeader: function (column, target, after, nColArray, fixed) {
			var rmil,			// result move in layout (stores the start and length parameters for the moved and target columns)
				movedColumn,	// an object storing the start and length params of the moved column area at the data level
				targetColumn,	// an object storing the start and length params of the target column area at the data level
				targetIndex,	// an index at which the column which will be used as a moving end point resides
				targetObject,	// an object storing more complex information about the moving end point in the cases where it needs to be
								// additonally calculated
				spStart,		// search parameter start (helper var)
				spEnd,			// search parameter end (helper var)
				i,
				j,
				cols,
				n,
				header;
			if (fixed) {
				header = this.fixedHeadersTable().children("thead");
			} else {
				header = this.headersTable().children("thead");
			}
			// find moved and target columns in the column layout array
			for (j = 0; j < nColArray[0].length; j++) {
				movedColumn = this._findColAreaInLayout(column, nColArray, j);
				if (movedColumn) {
					targetColumn = this._findColAreaInLayout(target, nColArray, j);
					if (targetColumn) {
						break;
					}
				}
			}
			// create the rmil array
			rmil = [movedColumn, targetColumn];
			if (this.options.showHeader === false) {
				// if the header is not shown we just need to return this result so the table
				// columns can be moved
				return rmil;
			}
			// then we start moving the actual dom elements, initial target first
			this._moveThs(header, column, target, after);
			// afterwards we'll search each level below and determine how to move other columns so the grid's layout remains intact
			while (++j < nColArray[0].length) {
				cols = [];
				n = null;
				// we will get all real columns (not marked as -1) for the current level which resides under the 
				// area marked by the initial moved column
				for (i = movedColumn.start; i < movedColumn.start + movedColumn.length; i++) {
					if (nColArray[i][j] === -1) {
						continue;
					}
					if (nColArray[i][j] !== n) {
						n = nColArray[i][j];
						cols.push(n);
					}
				}
				// next we find a proper target to use as an end point for the dom manipulation
				// in the best case scenario we can find it simply by getting the columns at the edges of the target area
				targetIndex = after === true ? targetColumn.start + targetColumn.length - 1 : targetColumn.start;
				// if we find a column in this way we proceed with the actual dom manipulation
				if (nColArray[targetIndex][j] !== -1) {
					this._moveThs(header, cols, nColArray[targetIndex][j], after);
					continue;
				}
				// otherwise we need to try and find such a column either outside the target area or further inside it
				if (after === true) {
					// the index of the first element to the right
					spStart = targetColumn.start + targetColumn.length;
					// the index of the last element to be investigated, it depends on the relative position between
					// the moved and the target columns
					spEnd = movedColumn.start > targetColumn.start + targetColumn.length - 1 ? movedColumn.start : nColArray.length;
					// search to the right first
					targetObject = this._findTargetRight(spStart, spEnd, j, nColArray);
					if (!targetObject) {
						// if we couldn't find a good end point to the right we'll search to the left
						// the index of the first element to the left of the target's area end
						spStart = targetColumn.start + targetColumn.length - 2;
						// either the start of the array or the end of the moved column's area
						spEnd = movedColumn.start > targetColumn.start + targetColumn.length - 1 ?
								-1 : movedColumn.start + movedColumn.length;
						targetObject = this._findTargetLeft(spStart, spEnd, j, nColArray);
					}
				} else {
					// here we do just the same as above but since *after* is false the calculations differ
					spStart = targetColumn.start - 1;
					spEnd = movedColumn.start > targetColumn.start + targetColumn.length - 1 ? -1 : movedColumn.start + movedColumn.length;
					targetObject = this._findTargetLeft(spStart, spEnd, j, nColArray);
					if (!targetObject) {
						spStart = targetColumn.start + 1;
						spEnd = movedColumn.start > targetColumn.start + targetColumn.length - 1 ? movedColumn.start : nColArray.length;
						targetObject = this._findTargetRight(spStart, spEnd, j, nColArray);
					}
				}
				/* S.S. December 12, 2012 - The function is iterative and very fast but also filled with somewhat harder to follow logic.
				The best way to understand it is to imagine the column layout broken to a matrix (the nColArray), where we represent the forbidden
				fields with the number -1 and the normal fields with column keys (or mch id-s). At this point we already know the id of the column
				we want to move and the id of the column that it'll be inserted after/before. Therefore we can find the level we make the moving
				operation on and know that we need to do similar operations on each level below that.
				For each level below the initial one we grab all columns that reside under the column that was moved (or skip the level if 
				there are none). And then find where to move them. It's simple process of traversing the array's level horizontally searching 
				for a column id to perform the dom operations with. The only complexity comes from having to do it in a specific way so that
				we always know that the first column that we can use is going to provide us with the expected result. The issue really comes from
				the fact that the target area might be filled with forbidden fields which means the space is covered by a column at a higher level
				with a rowspan attribute. We need to find another column at that level, outside the target area to process the dom operation with.
				*/
				if (targetObject && targetObject.pos && targetObject.left !== undefined && targetObject.left !== null) {
					// if we managed to find a column this way we'll proceed with a dom manipulation, otherwise the column layout is such that
					// this level does not require any operation
					this._moveThs(header, cols, nColArray[targetObject.pos][j], targetObject.left);
				}
			}
			return rmil;
		},
		_moveColumnInBodyFooter: function (area, movedColumn, targetColumn, after) {
			// uses the data level parameters found by moving in the header to move columns in the body and footer
			var i, j, trs, $tr, tds, tar, skip;
			// get all data rows in the target area (TBODY or TFOOT)
			trs = area.find(">tr:not([data-container='true'],[data-grouprow='true'])");
			if (trs.length > 0) {
				// skip equals the amount of special TDs or THs in the row that should not participate in the move operation
				skip = trs.eq(0).find("[data-parent],[data-skip='true'],th").length;
			}
			for (j = 0; j < trs.length; j++) {
				// we'll be filling a jquery collection of TDs to move
				tds = $();
				$tr = trs.eq(j);
				// foreach TD in the moved area add the TD to the collection
				for (i = movedColumn.start; i < movedColumn.start + movedColumn.length; i++) {
					tds = tds.add($tr.children().eq(i + skip));
				}
				// then get an end point TD to perform the dom manipulation
				if (after === true) {
					tar = $tr.children().eq(targetColumn.start + targetColumn.length + skip - 1);
					tds.detach().insertAfter(tar);
				} else {
					tar = $tr.children().eq(targetColumn.start + skip);
					tds.detach().insertBefore(tar);
				}
			}
			// M.H. 4 Sep 2013 Fix for bug #144735: Right aligned last column content hides under scrollbar
			this._updateVerticalScrollbarCellPadding(true);
		},
		_findTargetRight: function (start, end, level, nColArray) {
			// traverses the nColArray from left to right at a specified level searching for a defined column
			var i, colFound = {};
			for (i = start; i >= 0 && i < end && i < nColArray.length; i++) {
				if (nColArray[i][level] !== -1) {
					colFound.pos = i;
					colFound.left = false;
					return colFound;
				}
			}
		},
		_findTargetLeft: function (start, end, level, nColArray) {
			// traverses the nColArray from left to right at a specified level searching for a defined column
			var i, colFound = {};
			for (i = start; i >= 0 && i > end && i < nColArray.length; i--) {
				if (nColArray[i][level] !== -1) {
					colFound.pos = i;
					colFound.left = true;
					return colFound;
				}
			}
		},
		_moveCols: function (area, movedColumn, targetColumn, after) {
			// moves cols in the colgroup of the specified area
			var i, cols = $(), tCol, skip = area.children("[data-skip='true']").length;
			for (i = movedColumn.start; i < movedColumn.start + movedColumn.length; i++) {
				cols = cols.add(area.children().eq(i + skip));
			}
			// get an end point COL to perform the dom manipulation
			if (after === true) {
				tCol = area.children().eq(targetColumn.start + targetColumn.length + skip - 1);
				cols.detach().insertAfter(tCol);
			} else {
				tCol = area.children().eq(targetColumn.start + skip);
				cols.detach().insertBefore(tCol);
			}
		},
		_moveThs: function (header, ids, tar, after) {
			// moves THs in the provided header
			var $tar, $ids = $(), $id, i, $pid; /* holds the TH containing the padding for the vertical scrollbar(last TH) */
			// find the move end point - the following selector always returns a single TH as THs either
			// contain an id attribute (data THs) or an data-mch-id attributed (MCH THs)
			$tar = header.find("th[data-mch-id='" + tar + "'],th[id='" + this.id() + "_" + tar + "']");
			// the ids param is either an array or a simple value
			if (typeof ids === "object") {
				for (i = 0; i < ids.length; i++) {
					$id = header.find("th[data-mch-id='" + ids[i] + "'],th[id='" + this.id() + "_" + ids[i] + "']");
					if ($id.attr('data-vscr-padding-icrement')) {
						$pid = $id;
					}
					$ids = $ids.add($id);
				}
			} else {
				$ids = header.find("th[data-mch-id='" + ids + "'],th[id='" + this.id() + "_" + ids + "']");
				if ($ids.attr('data-vscr-padding-icrement')) {
					$pid = $ids;
				}
			}
			// we detach all the THs we found
			$ids.detach();
			// and attach them after the target
			if (after) {
				$ids.insertAfter($tar);
			} else {
				$ids.insertBefore($tar);
			}
			// afterwards we need to assign the padding of the previously last column to the newly last column (if needed
			if ($tar.attr('data-vscr-padding-icrement') && after === true) {
				$ids
					.last()
					.css(this._padding, $tar.css(this._padding))
					.attr('data-vscr-padding-icrement', $tar.attr('data-vscr-padding-icrement'));
				$tar.css(this._padding, '');
				$tar.removeAttr('data-vscr-padding-icrement');
			} else if ($pid) {
				$pid
					.parent()
					.children(":last")
					.css(this._padding, $pid.css(this._padding))
					.attr('data-vscr-padding-icrement', $pid.attr('data-vscr-padding-icrement'));
				$pid.css(this._padding, '');
				$pid.removeAttr('data-vscr-padding-icrement');
			}
		},
		_moveSpecialThs: function (movedColumn, targetColumn, after, fixed) {
			// moves elements contained in special header rows (such as the Filter row)
			var i, j, spTrs, header, skip, ths, $tr, tar;
			if (fixed) {
				header = this.fixedHeadersTable().children("thead");
			} else {
				header = this.headersTable().children("thead");
			}
			spTrs = header.find(">tr[data-role]");
			if (spTrs.length > 0) {
				skip = spTrs.eq(0).find("[data-parent],[data-skip='true']").length;
			}
			for (j = 0; j < spTrs.length; j++) {
				ths = $();
				$tr = $(spTrs[j]);
				for (i = movedColumn.start; i < movedColumn.start + movedColumn.length; i++) {
					ths = ths.add($tr.children("td,th").eq(i + skip));
				}
				if (after === true) {
					tar = $tr.children().eq(targetColumn.start + targetColumn.length + skip - 1);
					ths.detach().insertAfter(tar);
				} else {
					tar = $tr.children().eq(targetColumn.start + skip);
					ths.detach().insertBefore(tar);
				}
			}
		},
		_performDomColumnMove: function (column, target, after, nColArray, fixed) {
			var rmil = this._moveColumnInHeader(column, target, after, nColArray, fixed), /* moving the header also produces
				information about how to perform the operation on the TBODY/TFOOT	*/
				movedColumn = rmil[0],
				targetColumn = rmil[1],
				body, footer, indexMod = 0;
			// rearrange header cells positionined in special header rows
			this._moveSpecialThs(movedColumn, targetColumn, after, fixed);
			// rearrange the cols for the header if fixedHeaders is enabled
			if (this.options.fixedHeaders === true) {
				this._moveCols(fixed ? this.fixedHeadersTable().children("colgroup") :
					this.headersTable().children("colgroup"), movedColumn, targetColumn, after);
			}
			// and finally rearrange the body
			if (fixed) {
				body = this.fixedBodyContainer().children("table");
			} else {
				body = this.element;
			}
			this._moveColumnInBodyFooter(body.children("tbody"), movedColumn, targetColumn, after);
			// its colgroup
			this._moveCols(body.children("colgroup"), movedColumn, targetColumn, after);
			// the footers
			if (this.options.fixedFooters === true) {
				//footer = $("#" + this.id() + "_footers");
				footer = fixed ? this.fixedFootersTable() : this.footersTable();
				this._moveColumnInBodyFooter(footer.children("tfoot"), movedColumn, targetColumn, after);
				this._moveCols(footer.children("colgroup"), movedColumn, targetColumn, after);
			} else {
				this._moveColumnInBodyFooter(body.children("tfoot"), movedColumn, targetColumn, after);
			}
			// when the dom has changed we need to throw an event to notify other features to update dom related parameters
			if ((!fixed && this.fixingDirection() === "left") ||
				(fixed && this.fixingDirection() === "right")) {
				indexMod = this._fixedColumns ? this._fixedColumns.length : 0;
			}
			this._trigger("_columnsmoved", null, {
				owner: this,
				start: movedColumn.start + indexMod,
				len: movedColumn.length,
				index: after === true ? targetColumn.start + targetColumn.length + indexMod : targetColumn.start + indexMod,
				isFixed: fixed
			});
		},
		_performColumnMove: function (column, target, after, nColArray, fixed) {
			var rmil = this._moveColumnInHeader(column, target, after, nColArray, fixed),
				movedColumn = rmil[0],
				targetColumn = rmil[1];
			// rearrange the cols for the header if needed
			if (this.options.fixedHeaders === true) {
				this._moveCols(fixed ? this.fixedHeadersTable().children("colgroup") :
					this.headersTable().children("colgroup"), movedColumn, targetColumn, after);
			}
			this._renderData();
			this._renderFooter();
			this._rerenderColgroups();
		},
		showColumn: function (column, callback) {
			/* Shows a hidden column. If the column is not hidden the method does nothing.
				Note: This method is asynchronous which means that it returns immediately and any subsequent code will execute in parallel. This may lead to runtime errors. To avoid them put the subsequent code in the callback parameter provided by the method.
				paramType="number|string" An identifier for the column. If a number is provided it will be used as a column index. If a string is provided it will be used as a column key.
				paramType="function" Specifies a custom function to be called when the column is shown(optional)
			*/
			var grid = this;
			this._loadingIndicator.show();
			if (!this._isShowingAllowed([column])) {
				return false;
			}
			setTimeout(function () {
				var col;
				col = grid._setHidden(column, false);
				grid._loadingIndicator.hide();
				if (callback) {
					$.ig.util.invokeCallback(callback, [[col], false]);
				}
			}, 0);
			return true;
		},
		hideColumn: function (column, callback) {
			/* Hides a visible column. If the column is hidden the method does nothing.
				Note: This method is asynchronous which means that it returns immediately and any subsequent code will execute in parallel. This may lead to runtime errors. To avoid them put the subsequent code in the callback parameter provided by the method.
				paramType="number|string" An identifier for the column. If a number is provided it will be used as a column index else if a string is provided it will be used as a column key.
				paramType="function" Specifies a custom function to be called when the column is hidden(optional)
			*/
			var grid = this;
			if (!this._isHidingAllowed([column])) {
				return false;
			}
			// M.H. 6 Nov 2014 Fix for bug #184605: TypeError is thrown if all the columns are hidden from igGridHiding’s columnSettings option.
			if (grid._visibleColumns().length === 1) {
				//hiding the last column through the API should not be allowed
				return false;
			}
			this._loadingIndicator.show();
			setTimeout(function () {
				var col;
				col = grid._setHidden(column, true);
				grid._loadingIndicator.hide();
				if (callback) {
					$.ig.util.invokeCallback(callback, [[col], true]);
				}
			}, 0);
			return true;
		},
		_setHidden: function (column, hidden) {
			var col, applied = false;
			if (typeof column === 'number') {
				col = this.options.columns[column];
			} else {
				col = this.columnByKey(column);
			}
			//perform hiding/showing if the hidden value actually changed
			if (col && col.hidden !== hidden) {
				this._setHiddenColumns([col], hidden, false);
				applied = true;
			}
			if (applied) {
			