import * as wjcCore from 'wijmo/wijmo';
import * as wjcSelf from 'wijmo/wijmo.input';
export declare class DropDown extends wjcCore.Control {
    _tbx: HTMLInputElement;
    _elRef: HTMLElement;
    _btn: HTMLElement;
    _dropDown: HTMLElement;
    _showBtn: boolean;
    _autoExpand: boolean;
    _animate: boolean;
    _cssClass: string;
    _oldText: string;
    _altDown: boolean;
    static controlTemplate: string;
    constructor(element: any, options?: any);
    text: string;
    readonly inputElement: HTMLInputElement;
    isReadOnly: boolean;
    isRequired: boolean;
    placeholder: string;
    isDroppedDown: boolean;
    readonly dropDown: HTMLElement;
    dropDownCssClass: string;
    showDropDownButton: boolean;
    autoExpandSelection: boolean;
    isAnimated: boolean;
    selectAll(): void;
    textChanged: wjcCore.Event;
    onTextChanged(e?: wjcCore.EventArgs): void;
    isDroppedDownChanging: wjcCore.Event;
    onIsDroppedDownChanging(e: wjcCore.CancelEventArgs): boolean;
    isDroppedDownChanged: wjcCore.Event;
    onIsDroppedDownChanged(e?: wjcCore.EventArgs): void;
    onGotFocus(e?: wjcCore.EventArgs): void;
    onLostFocus(e?: wjcCore.EventArgs): void;
    containsFocus(): boolean;
    dispose(): void;
    refresh(fullUpdate?: boolean): void;
    _handleResize(): void;
    private _expandSelection();
    private _getCharType(text, pos);
    protected _keydown(e: KeyboardEvent): void;
    protected _btnclick(e: MouseEvent): void;
    protected _setText(text: string, fullMatch: boolean): void;
    protected _updateBtn(): void;
    protected _createDropDown(): void;
    protected _commitText(): void;
    protected _updateDropDown(): void;
}
export declare enum DateSelectionMode {
    None = 0,
    Day = 1,
    Month = 2,
}
export declare class Calendar extends wjcCore.Control {
    private _tbHdr;
    private _tbMth;
    private _tbYr;
    private _btnMth;
    private _spMth;
    private _btnPrv;
    private _btnTdy;
    private _btnNxt;
    private _value;
    private _currMonth;
    private _firstDay;
    private _min;
    private _max;
    private _fdw;
    private _itemFormatter;
    private _itemValidator;
    private _readOnly;
    private _selMode;
    static controlTemplate: string;
    constructor(element: any, options?: any);
    value: Date;
    min: Date;
    max: Date;
    selectionMode: DateSelectionMode;
    isReadOnly: boolean;
    firstDayOfWeek: number;
    displayMonth: Date;
    showHeader: boolean;
    monthView: boolean;
    itemFormatter: Function;
    itemValidator: Function;
    valueChanged: wjcCore.Event;
    onValueChanged(e?: wjcCore.EventArgs): void;
    displayMonthChanged: wjcCore.Event;
    onDisplayMonthChanged(e?: wjcCore.EventArgs): void;
    formatItem: wjcCore.Event;
    onFormatItem(e: FormatItemEventArgs): void;
    refresh(fullUpdate?: boolean): void;
    private _canChangeValue();
    private _valid(date);
    private _inValidRange(date);
    private _monthInValidRange(month);
    private _yearInValidRange(year);
    private _sameMonth(date, month);
    _clamp(value: Date): Date;
    private _createChildren();
    private _createElement(tag, parent?, className?);
    private _click(e);
    private _getCellIndex(tbl, cell);
    private _keydown(e);
    private _getMonth(date);
    private _monthMode();
    private _navigate(skip);
}
export declare class ColorPicker extends wjcCore.Control {
    _hsb: number[];
    _alpha: number;
    _value: string;
    _palette: string[];
    _eSB: HTMLElement;
    _eHue: HTMLElement;
    _eAlpha: HTMLElement;
    _cSB: HTMLElement;
    _cHue: HTMLElement;
    _cAlpha: HTMLElement;
    _ePal: HTMLElement;
    _ePreview: HTMLElement;
    _eText: HTMLElement;
    _htDown: Element;
    static controlTemplate: string;
    static _tplCursor: string;
    constructor(element: any, options?: any);
    showAlphaChannel: boolean;
    showColorString: boolean;
    value: string;
    palette: string[];
    valueChanged: wjcCore.Event;
    onValueChanged(e?: wjcCore.EventArgs): void;
    protected _mouseDown(e: MouseEvent): void;
    protected _mouseMove(e: MouseEvent): void;
    protected _mouseUp(e: MouseEvent): void;
    private _updateColor();
    private _updatePalette();
    private _makePalEntry(color, margin);
    private _updatePanels();
    private _getTargetPanel(e);
}
export declare class ListBox extends wjcCore.Control {
    private static _AUTOSEARCH_DELAY;
    _items: any;
    _cv: wjcCore.ICollectionView;
    _itemFormatter: Function;
    _pathDisplay: wjcCore.Binding;
    _pathValue: wjcCore.Binding;
    _pathChecked: wjcCore.Binding;
    _html: boolean;
    _checkedItems: any[];
    _checking: boolean;
    _search: string;
    _toSearch: number;
    _bndDisplay: wjcCore.Binding;
    constructor(element: any, options?: any);
    refresh(): void;
    itemsSource: any;
    readonly collectionView: wjcCore.ICollectionView;
    isContentHtml: boolean;
    itemFormatter: Function;
    displayMemberPath: string;
    selectedValuePath: string;
    checkedMemberPath: string;
    getDisplayValue(index: number): string;
    getDisplayText(index: number): string;
    selectedIndex: number;
    selectedItem: any;
    selectedValue: any;
    maxHeight: number;
    showSelection(): void;
    getItemChecked(index: number): boolean;
    setItemChecked(index: number, checked: boolean): void;
    toggleItemChecked(index: number): void;
    checkedItems: any[];
    selectedIndexChanged: wjcCore.Event;
    onSelectedIndexChanged(e?: wjcCore.EventArgs): void;
    itemsChanged: wjcCore.Event;
    onItemsChanged(e?: wjcCore.EventArgs): void;
    loadingItems: wjcCore.Event;
    onLoadingItems(e?: wjcCore.EventArgs): void;
    loadedItems: wjcCore.Event;
    onLoadedItems(e?: wjcCore.EventArgs): void;
    itemChecked: wjcCore.Event;
    onItemChecked(e?: wjcCore.EventArgs): void;
    checkedItemsChanged: wjcCore.Event;
    onCheckedItemsChanged(e?: wjcCore.EventArgs): void;
    formatItem: wjcCore.Event;
    onFormatItem(e: FormatItemEventArgs): void;
    private _setItemChecked(index, checked, notify?);
    private _cvCollectionChanged(sender, e);
    private _cvCurrentChanged(sender, e);
    private _populateList();
    private _click(e);
    private _keydown(e);
    private _keypress(e);
    private _findNext();
    private _getCheckbox(index);
    _populateSelectElement(hostElement: HTMLElement): void;
}
export declare class FormatItemEventArgs extends wjcCore.EventArgs {
    _index: number;
    _data: any;
    _item: HTMLElement;
    constructor(index: number, data: any, item: HTMLElement);
    readonly index: number;
    readonly data: any;
    readonly item: HTMLElement;
}
export declare class ComboBox extends DropDown {
    _lbx: ListBox;
    _editable: boolean;
    _composing: boolean;
    _deleting: boolean;
    _settingText: boolean;
    _cvt: HTMLElement;
    _hdrPath: string;
    constructor(element: any, options?: any);
    itemsSource: any;
    readonly collectionView: wjcCore.ICollectionView;
    displayMemberPath: string;
    headerPath: string;
    selectedValuePath: string;
    isContentHtml: boolean;
    itemFormatter: Function;
    readonly formatItem: wjcCore.Event;
    selectedIndex: number;
    selectedItem: any;
    selectedValue: any;
    isEditable: boolean;
    maxDropDownHeight: number;
    maxDropDownWidth: number;
    getDisplayText(index?: number): string;
    selectedIndexChanged: wjcCore.Event;
    onSelectedIndexChanged(e?: wjcCore.EventArgs): void;
    indexOf(text: string, fullMatch: boolean): number;
    readonly listBox: ListBox;
    refresh(fullUpdate?: boolean): void;
    onLostFocus(e?: wjcCore.EventArgs): void;
    onIsDroppedDownChanging(e: wjcCore.CancelEventArgs): boolean;
    onIsDroppedDownChanged(e?: wjcCore.EventArgs): void;
    protected _updateBtn(): void;
    protected _createDropDown(): void;
    protected _dropDownClick(e: MouseEvent): void;
    protected _setText(text: string, fullMatch: boolean): void;
    protected _findNext(text: string, step: number): number;
    protected _keydown(e: KeyboardEvent): void;
    private _setSelRange(start, end);
    private _getSelStart();
}
export declare class AutoComplete extends ComboBox {
    private _cssMatch;
    private _itemsSourceFn;
    private _itemsSourceFnCallBackBnd;
    private _srchProp;
    private _minLength;
    private _maxItems;
    private _itemCount;
    private _delay;
    private _toSearch;
    private _query;
    private _rxMatch;
    private _rxHighlight;
    private _inCallback;
    private _srchProps;
    constructor(element: any, options?: any);
    minLength: number;
    maxItems: number;
    delay: number;
    searchMemberPath: string;
    itemsSourceFunction: Function;
    cssMatch: string;
    _keydown(e: KeyboardEvent): void;
    _setText(text: string): void;
    _itemSourceFunctionCallback(result: any): void;
    onIsDroppedDownChanged(e?: wjcCore.EventArgs): void;
    protected _updateItems(): void;
    protected _filter(item: any): boolean;
    protected _formatListItem(sender: any, e: FormatItemEventArgs): void;
}
export declare class Menu extends ComboBox {
    _hdr: HTMLElement;
    _closing: boolean;
    _command: any;
    _cmdPath: string;
    _cmdParamPath: string;
    _isButton: boolean;
    _defaultItem: any;
    _owner: HTMLElement;
    constructor(element: any, options?: any);
    header: string;
    command: any;
    commandPath: string;
    commandParameterPath: string;
    isButton: boolean;
    owner: HTMLElement;
    show(position?: any): void;
    hide(): void;
    itemClicked: wjcCore.Event;
    onItemClicked(e?: wjcCore.EventArgs): void;
    onIsDroppedDownChanged(e?: wjcCore.EventArgs): void;
    protected _keydown(e: KeyboardEvent): void;
    protected _dropDownClick(e: MouseEvent): void;
    private _raiseCommand(e?);
    private _getCommand(item);
    private _executeCommand(cmd, parm);
    private _canExecuteCommand(cmd, parm);
    private _enableDisableItems();
}
export declare class MultiSelect extends ComboBox {
    private _maxHdrItems;
    private _readOnly;
    private _hdrFmt;
    private _hdrFormatter;
    static _DEF_CHECKED_PATH: string;
    constructor(element: any, options?: any);
    checkedMemberPath: string;
    maxHeaderItems: number;
    headerFormat: string;
    headerFormatter: Function;
    checkedItems: any[];
    checkedItemsChanged: wjcCore.Event;
    onCheckedItemsChanged(e?: wjcCore.EventArgs): void;
    isReadOnly: boolean;
    refresh(fullUpdate?: boolean): void;
    onIsDroppedDownChanged(e?: wjcCore.EventArgs): void;
    protected _setText(text: string, fullMatch: boolean): void;
    private _updateHeader();
}
export declare class MultiAutoComplete extends AutoComplete {
    private _wjTpl;
    private _wjInput;
    private _helperInput;
    private _selItems;
    private _maxtems;
    private _lastInputValue;
    private _selPath;
    private _notAddItm;
    static _clsActive: string;
    constructor(element: any, options?: any);
    showDropDownButton: boolean;
    maxSelectedItems: number;
    selectedMemberPath: string;
    selectedItems: any[];
    selectedItemsChanged: wjcCore.Event;
    onSelectedItemsChanged(e?: wjcCore.EventArgs): void;
    onIsDroppedDownChanged(e?: wjcCore.EventArgs): void;
    refresh(fullUpdate?: boolean): void;
    _keydown(e: KeyboardEvent): void;
    protected _updateState(): void;
    private _keyup(e);
    private _addHelperInput();
    private _refreshHeader();
    private _updateMaxItems();
    private _updateFocus();
    private _addItem(clearSelected);
    private _delItem(isDelKey);
    private _updateSelItems(itm, isAdd);
    private _createItem(tokenTxt);
    private _itemOn(isPrev);
    private _itemOff();
    private _initSeltems();
    private _getSelItem(index);
    private _setSelItem(item, selected);
    private _clearSelIndex();
    private _hasSelectedMemeberPath();
    private _disableInput(disabled);
    private _adjustInputWidth();
    private _getItemIndex(token);
}
export declare enum PopupTrigger {
    None = 0,
    Click = 1,
    Blur = 2,
    ClickOrBlur = 3,
}
export declare class Popup extends wjcCore.Control {
    _owner: HTMLElement;
    _modal: boolean;
    _showTrigger: wjcSelf.PopupTrigger;
    _hideTrigger: wjcSelf.PopupTrigger;
    _fadeIn: boolean;
    _fadeOut: boolean;
    _click: any;
    _mousedown: any;
    _bkdrop: HTMLDivElement;
    _result: any;
    _resultEnter: any;
    _callback: Function;
    _refreshing: boolean;
    _visible: boolean;
    _wasVisible: boolean;
    constructor(element: any, options?: any);
    owner: HTMLElement;
    content: HTMLElement;
    showTrigger: PopupTrigger;
    hideTrigger: PopupTrigger;
    fadeIn: boolean;
    fadeOut: boolean;
    modal: boolean;
    dialogResult: any;
    dialogResultEnter: any;
    readonly isVisible: boolean;
    show(modal?: boolean, handleResult?: Function): void;
    hide(dialogResult?: any): void;
    showing: wjcCore.Event;
    onShowing(e: wjcCore.CancelEventArgs): boolean;
    shown: wjcCore.Event;
    onShown(e?: wjcCore.EventArgs): void;
    hiding: wjcCore.Event;
    onHiding(e: wjcCore.CancelEventArgs): boolean;
    hidden: wjcCore.Event;
    onHidden(e?: wjcCore.EventArgs): void;
    dispose(): void;
    onLostFocus(e?: wjcCore.EventArgs): void;
    refresh(fullUpdate?: boolean): void;
    protected _handleResize(): void;
    protected _handleClick(e: any): void;
    protected _handleMouseDown(e: any): void;
    private _showBackdrop();
    private _validateAndHide(result);
}
export declare class InputDate extends DropDown {
    _calendar: Calendar;
    _value: Date;
    _format: string;
    _calChanged: boolean;
    _msk: wjcCore._MaskProvider;
    constructor(element: any, options?: any);
    value: Date;
    text: string;
    selectionMode: DateSelectionMode;
    min: Date;
    max: Date;
    format: string;
    mask: string;
    readonly calendar: Calendar;
    readonly inputElement: HTMLInputElement;
    inputType: string;
    itemValidator: Function;
    itemFormatter: Function;
    valueChanged: wjcCore.Event;
    onValueChanged(e?: wjcCore.EventArgs): void;
    refresh(): void;
    onIsDroppedDownChanged(e?: wjcCore.EventArgs): void;
    protected _createDropDown(): void;
    protected _updateDropDown(): void;
    protected _keydown(e: KeyboardEvent): void;
    private _canChangeValue();
    protected _clamp(value: Date): Date;
    protected _commitText(): void;
    private _isValidDate(value);
}
export declare class InputTime extends ComboBox {
    _value: Date;
    _min: Date;
    _max: Date;
    _step: number;
    _format: string;
    _msk: wjcCore._MaskProvider;
    constructor(element: any, options?: any);
    readonly inputElement: HTMLInputElement;
    inputType: string;
    value: Date;
    text: string;
    min: Date;
    max: Date;
    step: number;
    format: string;
    mask: string;
    valueChanged: wjcCore.Event;
    onValueChanged(e?: wjcCore.EventArgs): void;
    refresh(): void;
    onSelectedIndexChanged(e?: wjcCore.EventArgs): void;
    protected _updateItems(): void;
    private _getTime(value);
    protected _keydown(e: KeyboardEvent): void;
    protected _commitText(): void;
}
export declare class InputDateTime extends InputDate {
    _btnTm: HTMLElement;
    _inputTime: InputTime;
    static controlTemplate: string;
    constructor(element: any, options?: any);
    timeMin: Date;
    timeMax: Date;
    timeFormat: string;
    timeStep: number;
    refresh(): void;
    protected _updateBtn(): void;
    protected _clamp(value: Date): Date;
    protected _commitText(): void;
    protected _setDropdown(e: HTMLElement): void;
    protected _updateDropDown(): void;
}
export declare class InputNumber extends wjcCore.Control {
    _tbx: HTMLInputElement;
    _btnUp: HTMLElement;
    _btnDn: HTMLElement;
    _value: number;
    _min: number;
    _max: number;
    _format: string;
    _step: number;
    _showBtn: boolean;
    _readOnly: boolean;
    _oldText: string;
    _composing: boolean;
    _decChar: string;
    _currChar: string;
    _rxSym: RegExp;
    static controlTemplate: string;
    '</div>': any;
    constructor(element: any, options?: any);
    readonly inputElement: HTMLInputElement;
    inputType: string;
    value: number;
    isRequired: boolean;
    isReadOnly: boolean;
    min: number;
    max: number;
    step: number;
    format: string;
    text: string;
    placeholder: string;
    showSpinner: boolean;
    selectAll(): void;
    textChanged: wjcCore.Event;
    onTextChanged(e?: wjcCore.EventArgs): void;
    valueChanged: wjcCore.Event;
    onValueChanged(e?: wjcCore.EventArgs): void;
    onGotFocus(e: wjcCore.EventArgs): void;
    onLostFocus(e?: wjcCore.EventArgs): void;
    refresh(fullUpdate?: boolean): void;
    private _updateSymbols();
    private _clamp(value);
    private _isNumeric(chr, digitsOnly?);
    private _getInputRange(digitsOnly?);
    private _moveToDigit();
    private _increment(step);
    private _getSelStart();
    protected _updateBtn(): void;
    protected _setText(text: string): void;
    protected _keypress(e: KeyboardEvent): void;
    protected _keydown(e: KeyboardEvent): void;
    protected _input(e: any): void;
    protected _clickSpinner(e: MouseEvent): void;
}
export declare class InputMask extends wjcCore.Control {
    _tbx: HTMLInputElement;
    _msk: wjcCore._MaskProvider;
    static controlTemplate: string;
    '</div>': any;
    constructor(element: any, options?: any);
    readonly inputElement: HTMLInputElement;
    value: string;
    rawValue: string;
    mask: string;
    promptChar: string;
    placeholder: string;
    readonly maskFull: boolean;
    isRequired: boolean;
    selectAll(): void;
    valueChanged: wjcCore.Event;
    onValueChanged(e?: wjcCore.EventArgs): void;
    refresh(fullUpdate?: boolean): void;
    onGotFocus(e: any): void;
}
export declare class InputColor extends DropDown {
    _ePreview: HTMLElement;
    _colorPicker: ColorPicker;
    _value: string;
    constructor(element: any, options?: any);
    value: string;
    text: string;
    showAlphaChannel: boolean;
    readonly colorPicker: ColorPicker;
    valueChanged: wjcCore.Event;
    onValueChanged(e?: wjcCore.EventArgs): void;
    protected _createDropDown(): void;
    protected _keydown(e: KeyboardEvent): void;
    protected _commitText(): void;
}
