﻿/*
    *
    * Wijmo Library 5.20171.282
    * http://wijmo.com/
    *
    * Copyright(c) GrapeCity, Inc.  All rights reserved.
    *
    * Licensed under the Wijmo Commercial License.
    * sales@wijmo.com
    * wijmo.com/products/wijmo-5/license/
    *
    */
"use strict";var __extends=this&&this.__extends||function(n,t){function r(){this.constructor=n}for(var i in t)t.hasOwnProperty(i)&&(n[i]=t[i]);n.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)},wjcChart=require('wijmo/wijmo.chart'),wjcCore=require('wijmo/wijmo'),wjcSelf=require('wijmo/wijmo.chart.analytics'),TrendLineBase,MathHelper,TrendLineFitType,TrendLine,FunctionSeries,YFunctionSeries,ParametricFunctionSeries,MovingAverageType,MovingAverage,Waterfall,QuartileCalculation,BoxWhisker,_BoxPlot,ErrorAmount,ErrorBarEndStyle,ErrorBarDirection,ErrorBar;window.wijmo=window.wijmo||{};window.wijmo.chart=window.wijmo.chart||{};window.wijmo.chart.analytics=wjcSelf;TrendLineBase=function(n){function t(t){n.call(this);this._chartType=wjcChart.ChartType.Line;this._initProperties(t||{})}return __extends(t,n),Object.defineProperty(t.prototype,"sampleCount",{get:function(){return this._sampleCount},set:function(n){n!==this._sampleCount&&(this._sampleCount=wjcCore.asNumber(n,!1,!0),this._invalidate())},enumerable:!0,configurable:!0}),t.prototype.approximate=function(){return 0},t.prototype.getValues=function(t){var i=this,r=i.binding,u=i.bindingX;return(r!==i._bind&&(i._bind=r,i.binding=r),u!==i._bindX&&(i._bindX=u,i.bindingX=u),i._originYValues==null&&(i._originYValues=n.prototype.getValues.call(this,0)),i._originXValues==null&&(i._originXValues=n.prototype.getValues.call(this,1)),i._originXValues==null||i._originYValues==null)?null:(n.prototype.getValues.call(this,t),(i._xValues==null||i._yValues==null)&&i._calculateValues(),t===0)?i._yValues||null:t===1?i._xValues||null:void 0},t.prototype._calculateValues=function(){},t.prototype._initProperties=function(n){var i=this,t;i._sampleCount=100;for(t in n)i[t]&&(i[t]=n[t])},t.prototype._invalidate=function(){n.prototype._invalidate.call(this);this._clearCalculatedValues()},t.prototype._clearValues=function(){n.prototype._clearValues.call(this);this._originXValues=null;this._originYValues=null;this._clearCalculatedValues()},t.prototype._clearCalculatedValues=function(){this._xValues=null;this._yValues=null},t}(wjcChart.SeriesBase);exports.TrendLineBase=TrendLineBase;MathHelper=function(){function n(){}return n.round=function(n,t){if(!n)return 0;var i=Math.pow(10,t||2);return Math.round(n*i)/i},n.avg=function(t){var i=n.sum(t);return i/t.length},n.sum=function(n){return n=wjcCore.asArray(n,!1),n.reduce(function(n,t){return n+t},0)},n.sumOfPow=function(n,t){return n=wjcCore.asArray(n,!1),t=wjcCore.asNumber(t,!1),n.reduce(function(n,i){return n+Math.pow(i,t)},0)},n.sumProduct=function(){for(var t=[],i=0;i<arguments.length;i++)t[+i]=arguments[i];var o=t.length,f=0,e=[],r,u;for(t=wjcCore.asArray(t,!1),t.forEach(function(n,t){n=wjcCore.asArray(n,!1);t===0?f=n.length:wjcCore.assert(n.length===f,'The length of the arrays must be equal')}),r=0;r<f;r++)u=1,t.some(function(n){var t=n[r];if(t&&wjcCore.isNumber(t))u*=t;else return u=0,!0}),e.push(u);return n.sum(e)},n.variance=function(t){t=wjcCore.asArray(t,!1);var r=n.avg(t),i;return i=t.map(function(n){return n-r}),n.sumOfSquares(i)/(t.length-1)},n.covariance=function(t,i){t=wjcCore.asArray(t,!1);i=wjcCore.asArray(i,!1);wjcCore.assert(t.length===i.length,'Length of arrays must be equal');for(var e=n.avg(t),o=n.avg(i),u=t.length,f=0,r=0;r<u;r++)f+=(t[r]-e)*(i[r]-o)/u;return f},n.min=function(n){return Math.min.apply(Math,wjcCore.asArray(n,!1))},n.max=function(n){return Math.max.apply(Math,wjcCore.asArray(n,!1))},n.square=function(n){return Math.pow(wjcCore.asNumber(n,!1),2)},n.sumOfSquares=function(t){return n.sumOfPow(t,2)},n.stdDev=function(t){return Math.sqrt(n.variance(t))},n}(),function(n){n[n.Linear=0]="Linear";n[n.Exponential=1]="Exponential";n[n.Logarithmic=2]="Logarithmic";n[n.Power=3]="Power";n[n.Fourier=4]="Fourier";n[n.Polynomial=5]="Polynomial";n[n.MinX=6]="MinX";n[n.MinY=7]="MinY";n[n.MaxX=8]="MaxX";n[n.MaxY=9]="MaxY";n[n.AverageX=10]="AverageX";n[n.AverageY=11]="AverageY"}(exports.TrendLineFitType||(exports.TrendLineFitType={}));TrendLineFitType=exports.TrendLineFitType;TrendLine=function(n){function t(t){n.call(this,t)}return __extends(t,n),Object.defineProperty(t.prototype,"fitType",{get:function(){return this._fitType},set:function(n){n!==this._fitType&&(this._fitType=wjcCore.asEnum(n,TrendLineFitType,!1),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"order",{get:function(){return this._order},set:function(n){n!==this._order&&(this._order=wjcCore.asNumber(n,!1,!0),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"coefficients",{get:function(){return this._helper?this._helper.coefficients:null},enumerable:!0,configurable:!0}),t.prototype._initProperties=function(t){this._fitType=TrendLineFitType.Linear;this._order=2;n.prototype._initProperties.call(this,t)},t.prototype._calculateValues=function(){var n=this,t,i,r;i=TrendLineFitType[n._fitType];TrendLineHelper[i]&&(t=new TrendLineHelper[i](n._originYValues,n._originXValues,n.sampleCount,n.order),r=t.calculateValues(),n._yValues=r[0],n._xValues=r[1],n._helper=t)},t.prototype.approximate=function(n){return this._helper.approximate(n)},t.prototype.getEquation=function(n){var t=this,i=t.coefficients,r=i.length;return t._helper==null?'':t._helper.getEquation(n)},t}(TrendLineBase);exports.TrendLine=TrendLine;var Calculator=function(){function n(n,t){this._x=n;this._y=t}return Object.defineProperty(n.prototype,"x",{get:function(){return this._x},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"y",{get:function(){return this._y},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"minX",{get:function(){var n=this;return n._minX==null&&(n._minX=MathHelper.min(n._x)),n._minX},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"minY",{get:function(){var n=this;return n._minY==null&&(n._minY=MathHelper.min(n._y)),n._minY},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"maxX",{get:function(){var n=this;return n._maxX==null&&(n._maxX=MathHelper.max(n._x)),n._maxX},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"maxY",{get:function(){var n=this;return n._maxY==null&&(n._maxY=MathHelper.max(n._y)),n._maxY},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"averageX",{get:function(){var n=this;return n._averageX==null&&(n._averageX=MathHelper.avg(n._x)),n._averageX},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"averageY",{get:function(){var n=this;return n._averageY==null&&(n._averageY=MathHelper.avg(n._y)),n._averageY},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"sumX",{get:function(){var n=this;return n._sumX==null&&(n._sumX=MathHelper.sum(n._x)),n._sumX},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"sumY",{get:function(){var n=this;return n._sumY==null&&(n._sumY=MathHelper.sum(n._y)),n._sumY},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"LogX",{get:function(){var n=this;return n._logX==null&&(n._logX=n._x.map(function(n){return Math.log(n)})),n._logX},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"LogY",{get:function(){var n=this;return n._logY==null&&(n._logY=n._y.map(function(n){return Math.log(n)})),n._logY},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"sumLogX",{get:function(){var n=this;return n._sumLogX==null&&(n._sumLogX=MathHelper.sum(n.LogX)),n._sumLogX},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"sumLogY",{get:function(){var n=this;return n._sumLogY==null&&(n._sumLogY=MathHelper.sum(n.LogY)),n._sumLogY},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"sumOfSquareX",{get:function(){var n=this;return n._sumOfSquareX==null&&(n._sumOfSquareX=MathHelper.sumOfSquares(n._x)),n._sumOfSquareX},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"sumOfSquareY",{get:function(){var n=this;return n._sumOfSquareY==null&&(n._sumOfSquareY=MathHelper.sumOfSquares(n._y)),n._sumOfSquareY},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"sumOfSquareLogX",{get:function(){var n=this;return n._sumOfSquareLogX==null&&(n._sumOfSquareLogX=MathHelper.sumOfSquares(n.LogX)),n._sumOfSquareLogX},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"sumOfSquareLogY",{get:function(){var n=this;return n._sumOfSquareLogY==null&&(n._sumOfSquareLogY=MathHelper.sumOfSquares(n.LogY)),n._sumOfSquareLogY},enumerable:!0,configurable:!0}),n.prototype.sumProduct=function(n,t){var i=this;return i._sumProduct==null&&(i._sumProduct=MathHelper.sumProduct(n,t)),i._sumProduct},n}(),TrendHelperBase=function(){function n(n,t,i){var r=this;r._coefficients=[];r.y=n;r.x=t;wjcCore.assert(r.y.length===r.x.length,'Length of X and Y arrays are not equal');r.count=i||n.length;r._calculator=new Calculator(t,n);r.xMin=r._calculator.minX;r.xMax=r._calculator.maxX}return Object.defineProperty(n.prototype,"calculator",{get:function(){return this._calculator},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"y",{get:function(){return this._y},set:function(n){n!==this.y&&(this._y=wjcCore.asArray(n,!1))},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"x",{get:function(){return this._x},set:function(n){n!==this.x&&(this._x=wjcCore.asArray(n,!1))},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"count",{get:function(){return this._count},set:function(n){n!==this.count&&(this._count=wjcCore.asInt(n,!1,!0))},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"xMin",{get:function(){return this._xMin},set:function(n){n!==this.xMin&&(this._xMin=wjcCore.asNumber(n,!1))},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"xMax",{get:function(){return this._xMax},set:function(n){n!==this.xMax&&(this._xMax=wjcCore.asNumber(n,!1))},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"coefficients",{get:function(){return this._coefficients},enumerable:!0,configurable:!0}),n.prototype._calculateCoefficients=function(){var n=this,i,t;t=n.calcB();i=n.calcA(t);n._coefficients.push(i,t)},n.prototype.calculateValues=function(){for(var n=this,f=(n.xMax-n.xMin)/(n.count-1),t=[[],[]],i,u,r=0;r<n.count;r++)i=n.xMin+f*r,u=n.calcY(i),t[0].push(u),t[1].push(i);return t},n.prototype.calcA=function(n){var t=this,i=t.y.length,r=t.calculator.sumX,u=t.calculator.sumY,n=n?n:t.calcB();return(u-n*r)/i},n.prototype.calcB=function(){var t=this,i=t.y.length,n=t.calculator,u=n.sumProduct(n.x,n.y),r=n.sumX,f=n.sumY,e=n.sumOfSquareX;return(i*u-r*f)/(i*e-MathHelper.square(r))},n.prototype.calcY=function(n){var t=this.coefficients;return t[0]+t[1]*n},n.prototype.approximate=function(n){return this.calcY(n)},n.prototype.getEquation=function(n){var n=n?n:this._defaultEquationFmt;return this._getEquation(n)},n.prototype._getEquation=function(n){var i=this.coefficients,t=[];return i.forEach(function(i){t.push(n(i))}),this._concatEquation(t)},n.prototype._concatEquation=function(){return''},n.prototype._defaultEquationFmt=function(n){var r,t,i=Math.abs(n),u=0;return i>=1e5?(t=String(Math.round(i)).length-1,r=Math.round(n/Number('1e'+t)),r+'e'+t):i<.0001?(t=String(i).match(/\.0+/)[1].length-1,r=Math.round(n*Number('1e'+t)),r+'e-'+t):(u=n>0?6:7,i>=1e4&&u--,String(+String(n).substring(0,u)))},n}(),LinearHelper=function(n){function t(t,i,r,u){n.call(this,t,i,r);this._calculateCoefficients();this.yOffset=u}return __extends(t,n),Object.defineProperty(t.prototype,"yOffset",{get:function(){return this._yOffset},set:function(n){n!==this.yOffset&&(this._yOffset=wjcCore.asNumber(n,!0))},enumerable:!0,configurable:!0}),t.prototype.calcA=function(t){return this.yOffset!=null?this.yOffset:n.prototype.calcA.call(this,t)},t.prototype.calcB=function(){return this.yOffset!=null?this._calculateBSimple():n.prototype.calcB.call(this)},t.prototype._calculateBSimple=function(){var t=this,n=t.calculator,i=n.sumProduct(n.x,n.y),r=n.sumX,u=n.sumOfSquareX;return(i-t.yOffset*r)/u},t.prototype._calculateCoefficients=function(){var n=this,i,t;t=n.calcB();i=n.calcA(t);n.coefficients.push(t,i)},t.prototype.calcY=function(n){var t=this.coefficients;return t[0]*n+t[1]},t.prototype._concatEquation=function(n){return'y='+n[0]+'x'+(this.coefficients[1]>=0?'+':'')+n[1]},t}(TrendHelperBase),LogHelper=function(n){function t(t,i,r){n.call(this,t,i,r);this._calculateCoefficients()}return __extends(t,n),t.prototype.calcA=function(n){var t=this,r=t.y.length,i=t.calculator,u=i.sumY,f=i.sumLogX,n=n?n:t.calcB();return(u-n*f)/r},t.prototype.calcB=function(){var t=this,i=t.y.length,n=t.calculator,u=n.sumProduct(n.y,n.LogX),f=n.sumY,r=n.sumLogX,e=n.sumOfSquareLogX;return(i*u-f*r)/(i*e-MathHelper.square(r))},t.prototype._calculateCoefficients=function(){var n=this,i,t;t=n.calcB();i=n.calcA(t);n.coefficients.push(t,i)},t.prototype.calcY=function(n){var t=this.coefficients;return Math.log(n)*t[0]+t[1]},t.prototype._concatEquation=function(n){return'y='+n[0]+'ln(x)'+(this.coefficients[1]>=0?'+':'')+n[1]},t}(TrendHelperBase),ExpHelper=function(n){function t(t,i,r){n.call(this,t,i,r);this._calculateCoefficients()}return __extends(t,n),t.prototype.calcA=function(){var t=this,u=t.y.length,n=t.calculator,f=n.sumLogY,i=n.sumOfSquareX,r=n.sumX,e=n.sumProduct(n.x,n.LogY);return Math.exp((f*i-r*e)/(u*i-MathHelper.square(r)))},t.prototype.calcB=function(){var t=this,i=t.y.length,n=t.calculator,u=n.sumLogY,f=n.sumOfSquareX,r=n.sumX,e=n.sumProduct(n.x,n.LogY);return(i*e-r*u)/(i*f-MathHelper.square(r))},t.prototype.calcY=function(n){var t=this.coefficients;return t[0]*Math.exp(t[1]*n)},t.prototype._concatEquation=function(n){return'y='+n[0]+'e<sup>'+n[1]+'x</sup>'},t}(TrendHelperBase),PowerHelper=function(n){function t(t,i,r){n.call(this,t,i,r);this._calculateCoefficients()}return __extends(t,n),t.prototype.calcA=function(n){var t=this,i=t.calculator,r=t.y.length,u=i.sumLogX,f=i.sumLogY,n=n?n:t.calcB();return Math.exp((f-n*u)/r)},t.prototype.calcB=function(){var t=this,i=t.y.length,n=t.calculator,u=n.sumProduct(n.LogX,n.LogY),r=n.sumLogX,f=n.sumLogY,e=n.sumOfSquareLogX;return(i*u-r*f)/(i*e-MathHelper.square(r))},t.prototype.calcY=function(n){var t=this.coefficients;return t[0]*Math.pow(n,t[1])},t.prototype._concatEquation=function(n){return'y='+n[0]+'x<sup>'+n[1]+'</sup>'},t}(TrendHelperBase),LeastSquaresHelper=function(n){function t(t,i,r,u){n.call(this,t,i,r);this._order=u==null?2:u;this._basis=[];this._calculateCoefficients()}return __extends(t,n),Object.defineProperty(t.prototype,"basis",{get:function(){return this._basis},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"order",{get:function(){return this._order},set:function(n){n!==this.order&&(this._order=wjcCore.asNumber(n,!0))},enumerable:!0,configurable:!0}),t.prototype._calculateCoefficients=function(){var n=this;n._coefficients.length=n.order;n._createBasis();n._normalizeAndSolveGauss()},t.prototype._createBasis=function(){var n=this.x.length,t=this.order;if(n<2)throw"Incompatible data: Less than 2 data points.";if(t<1)throw"Incompatible data: Less than 1 coefficient in the fit";if(t>n)throw"Incompatible data: Number of data points less than number of terms";},t.prototype._normalizeAndSolveGauss=function(){var n=[];if(this._computeNormalEquations(n),this._genDefValForArray(n,0),!this._solveGauss(n))throw'Incompatible data: No solution.';},t.prototype._genDefValForArray=function(n,t){var i=n.length+1;n.forEach(function(n){for(var r=0;r<i;r++)n[r]==null&&(n[r]=t)})},t.prototype._computeNormalEquations=function(n){for(var f=this,s=f.y,e=f.basis,o=f.order,h=s.length,i,r,u,t=0;t<o;t++)for(r=0,n[t]==null&&(n[t]=[]),s.forEach(function(n,i){r+=n*e[i][t]}),n[t][o]=r,i=t;i<o;i++){for(r=0,u=0;u<h;u++)r+=e[u][i]*e[u][t];n[i]==null&&(n[i]=[]);n[i][t]=r;n[t][i]=r}},t.prototype._solveGauss=function(n){var r=n.length,e=0,u=this._coefficients,f=!0,i,t;if(u.length<r||n[0].length<r+1)throw'Dimension of matrix is not correct.';if(n.some(function(i,u){var o=u,h=Math.abs(i[u]),c,s;for(t=u+1;t<r;t++)c=Math.abs(n[t][u]),h<c&&(h=c,o=t);if(h>e){for(t=u;t<=r;t++)s=n[u][t],n[u][t]=n[o][t],n[o][t]=s;for(o=u+1;o<r;o++)for(s=n[o][u]/i[u],n[o][u]=0,t=u+1;t<=r;t++)n[o][t]-=s*i[t]}else return f=!1,!0}),f)for(i=r-1;i>=0;i--){for(u[i]=n[i][r],t=i+1;t<r;t++)u[i]-=n[i][t]*u[t];u[i]=u[i]/n[i][i]}return f},t}(TrendHelperBase),PolyHelper=function(n){function t(t,i,r,u){n.call(this,t,i,r,u)}return __extends(t,n),Object.defineProperty(t.prototype,"coefficients",{get:function(){return this._coefficients.slice(0).reverse()},enumerable:!0,configurable:!0}),t.prototype.calcY=function(n){var r=this._coefficients,t=0,i=1;return r.forEach(function(r,u){u>0&&(i*=n);t+=r*i}),t},t.prototype._calculateCoefficients=function(){var i=this._coefficients,t=!1;this.order++;t&&i.pop();n.prototype._calculateCoefficients.call(this);t;this.order--},t.prototype._createBasis=function(){n.prototype._createBasis.call(this);var t=this,r=t.x,i=t.basis,u=t.order;r.forEach(function(n,t){var r;for(i[t]=[1],r=1;r<=u;r++)i[t][r]=n*i[t][r-1]})},t.prototype._concatEquation=function(n){var t='y=',r=n.length,i=this.coefficients;return n.forEach(function(n,u){var e=r-1-u,f;e===0?t+=n:e===1?(f=i[u+1]>=0?'+':'',t+=n+'x'+f):(f=i[u+1]>=0?'+':'',t+=n+'x<sup>'+e+'</sup>'+f)}),t},t}(LeastSquaresHelper),FourierHelper=function(n){function t(t,i,r,u){u=u==null?i.length:u;n.call(this,t,i,r,u)}return __extends(t,n),t.prototype._createBasis=function(){n.prototype._createBasis.call(this);var t=this,r=t.x,i=t.basis,u=t.order;r.forEach(function(n,t){var r,f;for(i[t]=[1],r=1;r<u;r++)f=Math.floor((r+1)/2),r%2==1?i[t].push(Math.cos(f*n)):i[t].push(Math.sin(f*n))})},t.prototype.calcY=function(n){var i=this._coefficients,t;return i.forEach(function(i,r){var f=Math.floor((r+1)/2),u;r===0?t=i:(u=f*n,t+=r%2==1?i*Math.cos(u):i*Math.sin(u))}),t},t.prototype._concatEquation=function(n){var t='y=',i=n.length,r=this.coefficients;return n.forEach(function(n,u){var e=u===i-1?'':r[u+1]>=0?'+':'',f='',o=Math.ceil(u/2);u===0?t+=n+e:(f=u%2==1?'cos':'sin',f+='('+(o===1?'':String(o))+'x)',t+=n+f+e)}),t},t}(LeastSquaresHelper),SimpleTrendHelper=function(n){function t(t,i,r){n.call(this,t,i,r);this._calculateCoefficients()}return __extends(t,n),t.prototype._setVal=function(n){this._val=n},t.prototype.calcY=function(){return this._val},t}(TrendHelperBase),MinXHelper=function(n){function t(t,i,r){n.call(this,t,i,r)}return __extends(t,n),t.prototype.calculateValues=function(){var n=this,t=n.xMin,u=MathHelper.min(n.y),f=MathHelper.max(n.y),i,r;return i=[t,t],r=[u,f],n._setVal(t),[r,i]},t.prototype.getEquation=function(n){var t=this.xMin;return n&&(t=n(t)),'x='+t},t}(SimpleTrendHelper),MinYHelper=function(n){function t(t,i,r){n.call(this,t,i,r)}return __extends(t,n),t.prototype.calculateValues=function(){var n=this,u=n.xMin,f=n.xMax,t=MathHelper.min(n.y),i,r;return i=[u,f],r=[t,t],n._setVal(t),[r,i]},t.prototype.getEquation=function(n){var t=MathHelper.min(this.y);return n&&(t=n(t)),'y='+t},t}(SimpleTrendHelper),MaxXHelper=function(n){function t(t,i,r){n.call(this,t,i,r)}return __extends(t,n),t.prototype.calculateValues=function(){var n=this,t=n.xMax,u=MathHelper.min(n.y),f=MathHelper.max(n.y),i,r;return i=[t,t],r=[u,f],n._setVal(t),[r,i]},t.prototype.getEquation=function(n){var t=this.xMax;return n&&(t=n(t)),'x='+t},t}(SimpleTrendHelper),MaxYHelper=function(n){function t(t,i,r){n.call(this,t,i,r)}return __extends(t,n),t.prototype.calculateValues=function(){var n=this,u=n.xMin,f=n.xMax,t=MathHelper.max(n.y),i,r;return i=[u,f],r=[t,t],n._setVal(t),[r,i]},t.prototype.getEquation=function(n){var t=MathHelper.max(this.y);return n&&(t=n(t)),'y='+t},t}(SimpleTrendHelper),AverageXHelper=function(n){function t(t,i,r){n.call(this,t,i,r)}return __extends(t,n),t.prototype.calculateValues=function(){var n=this,t=MathHelper.avg(n.x),u=MathHelper.min(n.y),f=MathHelper.max(n.y),i,r;return i=[t,t],r=[u,f],n._setVal(t),[r,i]},t.prototype._getEquation=function(n){var t=n(MathHelper.avg(this.x));return'x='+t},t.prototype._defaultEquationFmt=function(t){return Math.abs(t)<1e5?n.prototype._defaultEquationFmt.call(this,t):''+MathHelper.round(t,2)},t}(SimpleTrendHelper),AverageYHelper=function(n){function t(t,i,r){n.call(this,t,i,r)}return __extends(t,n),t.prototype.calculateValues=function(){var n=this,t=MathHelper.avg(n.y),u=n.xMin,f=n.xMax,i,r;return i=[u,f],r=[t,t],n._setVal(t),[r,i]},t.prototype._getEquation=function(n){var t=n(MathHelper.avg(this.y));return'y='+t},t.prototype._defaultEquationFmt=function(t){return Math.abs(t)<1e5?n.prototype._defaultEquationFmt.call(this,t):''+MathHelper.round(t,2)},t}(SimpleTrendHelper),TrendLineHelper={TrendHelperBase:TrendHelperBase,Linear:LinearHelper,Exponential:ExpHelper,Logarithmic:LogHelper,Power:PowerHelper,Polynomial:PolyHelper,Fourier:FourierHelper,MinX:MinXHelper,MinY:MinYHelper,MaxX:MaxXHelper,MaxY:MaxYHelper,AverageX:AverageXHelper,AverageY:AverageYHelper};FunctionSeries=function(n){function t(t){n.call(this,t);this.itemsSource==null&&(this.itemsSource=[new wjcCore.Point(0,0)])}return __extends(t,n),Object.defineProperty(t.prototype,"min",{get:function(){return this._min},set:function(n){this._min!==n&&(this._min=wjcCore.asNumber(n,!1),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"max",{get:function(){return this._max},set:function(n){this._max!==n&&(this._max=wjcCore.asNumber(n,!1),this._invalidate())},enumerable:!0,configurable:!0}),t.prototype.getValues=function(n){var t=this;return((t._xValues==null||t._yValues==null)&&t._calculateValues(),n===0)?t._yValues||null:n===1?t._xValues||null:void 0},t.prototype._initProperties=function(t){this._min=0;this._max=1;n.prototype._initProperties.call(this,t)},t.prototype._calculateValues=function(){for(var n=this,i=n.sampleCount,u=[],f=[],e=(n.max-n.min)/(i-1),r,t=0;t<i;t++)r=t===i-1?this.max:this.min+e*t,u[t]=n._calculateX(r),f[t]=n._calculateY(r);n._yValues=f;n._xValues=u},t.prototype._validateValue=function(n){return isFinite(n)?n:Number.NaN},t.prototype._calculateValue=function(n,t){var i;try{i=n(t)}catch(r){i=Number.NaN}return this._validateValue(i)},t.prototype._calculateX=function(){return 0},t.prototype._calculateY=function(){return 0},t}(TrendLineBase);exports.FunctionSeries=FunctionSeries;YFunctionSeries=function(n){function t(t){n.call(this,t)}return __extends(t,n),Object.defineProperty(t.prototype,"func",{get:function(){return this._func},set:function(n){n&&this._func!==n&&(this._func=wjcCore.asFunction(n,!1),this._invalidate())},enumerable:!0,configurable:!0}),t.prototype._calculateX=function(n){return n},t.prototype._calculateY=function(n){return this._calculateValue(this.func,n)},t.prototype.approximate=function(n){return this._calculateValue(this.func,n)},t}(FunctionSeries);exports.YFunctionSeries=YFunctionSeries;ParametricFunctionSeries=function(n){function t(t){n.call(this,t)}return __extends(t,n),Object.defineProperty(t.prototype,"xFunc",{get:function(){return this._xFunc},set:function(n){n&&this._xFunc!==n&&(this._xFunc=wjcCore.asFunction(n,!1),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"yFunc",{get:function(){return this._yFunc},set:function(n){n&&this._yFunc!==n&&(this._yFunc=wjcCore.asFunction(n,!1),this._invalidate())},enumerable:!0,configurable:!0}),t.prototype._calculateX=function(n){return this._calculateValue(this.xFunc,n)},t.prototype._calculateY=function(n){return this._calculateValue(this.yFunc,n)},t.prototype.approximate=function(n){var r=this,t=this._calculateValue(this.xFunc,n),i=this._calculateValue(this.yFunc,n);return new wjcCore.Point(t,i)},t}(FunctionSeries);exports.ParametricFunctionSeries=ParametricFunctionSeries,function(n){n[n.Simple=0]="Simple";n[n.Weighted=1]="Weighted";n[n.Exponential=2]="Exponential";n[n.Triangular=3]="Triangular"}(exports.MovingAverageType||(exports.MovingAverageType={}));MovingAverageType=exports.MovingAverageType;MovingAverage=function(n){function t(t){n.call(this,t);this._chartType=wjcChart.ChartType.Line}return __extends(t,n),Object.defineProperty(t.prototype,"type",{get:function(){return this._type},set:function(n){n!==this._type&&(this._type=wjcCore.asEnum(n,MovingAverageType,!1),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"period",{get:function(){return this._period},set:function(n){n!==this._period&&(this._period=wjcCore.asNumber(n,!1,!0),this._invalidate())},enumerable:!0,configurable:!0}),t.prototype._initProperties=function(t){this._period=2;this._type=MovingAverageType.Simple;n.prototype._initProperties.call(this,t)},t.prototype._checkPeriod=function(){var t=this.period,n=this._originXValues;t<=1&&wjcCore.assert(!1,"period must be greater than 1.");n&&n.length&&t>=n.length&&wjcCore.assert(!1,"period must be less than itemSource's length.")},t.prototype._calculateValues=function(){var n=this,u=n._type,t="_calculate"+MovingAverageType[n._type],i=[],r=[];n._checkPeriod();n[t]&&n[t].call(n,i,r);n._yValues=r;n._xValues=i},t.prototype._calculateSimple=function(n,t,i){i===void 0&&(i=!1);for(var e=this,o=e._originXValues,s=e._originYValues,h=o.length,u=e._period,f=0,r=0;r<h;r++)f+=s[r],r>=u&&(f-=s[r-u]),r>=u-1?(n.push(o[r]),t.push(f/u)):i&&(n.push(o[r]),t.push(f/(r+1)))},t.prototype._calculateWeighted=function(n,t){for(var e=this,s=e._originXValues,u=e._originYValues,h=s.length,r=e._period,c=r*(r+1)/2,o=0,f=0,i=0;i<h;i++)i>0&&(o+=u[i-1]),i>r&&(o-=u[i-r-1]),i<r-1?f+=u[i]*(i+1):(f+=u[i]*r,i>r-1&&(f-=o),n.push(s[i]),t.push(f/c))},t.prototype._calculateExponential=function(n,t){for(var f=this,e=f._originXValues,o=f._originYValues,s=e.length,u=f._period,r=0,i=0;i<s;i++){if(i<=u-2){r+=o[i];i===u-2&&(r/=u-1);continue}r=r+2/(u+1)*(o[i]-r);n.push(e[i]);t.push(r)}},t.prototype._calculateTriangular=function(n,t){var o=this,r=o._period,u=[],f=[],i,s,e=0;for(o._calculateSimple(u,f,!0),i=0,s=u.length;i<s;i++)e+=f[i],i>=r&&(e-=f[i-r]),i>=r-1&&(n.push(u[i]),t.push(e/r))},t}(TrendLineBase);exports.MovingAverage=MovingAverage;Waterfall=function(n){function t(t){n.call(this);this._startLabel='Start';this._relativeData=!0;this._connectorLines=!1;this._totalLabel='Total';this._getXValues=!1;this._showIntermediateTotal=!1;this._intermediateTotalPos=[];this._chartType=wjcChart.ChartType.Bar;this._initProperties(t||{});this.rendering.addHandler(this._rendering,this)}return __extends(t,n),t.prototype._initProperties=function(n){for(var t in n)this[t]&&(this[t]=n[t])},t.prototype._clearValues=function(){n.prototype._clearValues.call(this);this._xValues=null;this._yValues=null;this._wfstyle=null;this._getXValues=!0;this._intermediateTotalPos=[];this.chart&&this.chart._performBind()},Object.defineProperty(t.prototype,"relativeData",{get:function(){return!!this._relativeData},set:function(n){n!=this._relativeData&&(this._relativeData=wjcCore.asBoolean(n,!0),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"start",{get:function(){return this._start},set:function(n){n!=this._start&&(this._start=wjcCore.asNumber(n,!0),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"startLabel",{get:function(){return this._startLabel},set:function(n){n!=this._startLabel&&(this._startLabel=wjcCore.asString(n,!1),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"showTotal",{get:function(){return!!this._showTotal},set:function(n){n!=this._showTotal&&(this._showTotal=wjcCore.asBoolean(n,!0),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"totalLabel",{get:function(){return this._totalLabel},set:function(n){n!=this._totalLabel&&(this._totalLabel=wjcCore.asString(n,!1),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"showIntermediateTotal",{get:function(){return this._showIntermediateTotal},set:function(n){n!=this._showIntermediateTotal&&(this._showIntermediateTotal=wjcCore.asBoolean(n,!1),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"intermediateTotalPositions",{get:function(){return this._intermediateTotalPositions},set:function(n){n!=this._intermediateTotalPositions&&(this._intermediateTotalPositions=wjcCore.asArray(n,!0),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"intermediateTotalLabels",{get:function(){return this._intermediateTotalLabels},set:function(n){n!=this._intermediateTotalLabels&&(wjcCore.assert(n==null||wjcCore.isArray(n)||wjcCore.isString(n),'intermediateTotalLabels should be an array or a string.'),this._intermediateTotalLabels=n,this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"connectorLines",{get:function(){return!!this._connectorLines},set:function(n){n!=this._connectorLines&&(this._connectorLines=wjcCore.asBoolean(n,!0),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"styles",{get:function(){return this._styles},set:function(n){n!=this._styles&&(this._styles=n,this._invalidate())},enumerable:!0,configurable:!0}),t.prototype.getValues=function(t){var h=this,c=[],r,i,u,f,s,e=0,o;return r=n.prototype.getValues.call(this,t),t===0?(this._yValues||(this.relativeData?(c=[],r&&(r.reduce(function(n,t){return c.push(n+t),n+t},0),this._yValues=c)):this._yValues=r&&r.slice(),i=this._yValues,i&&i.length>0&&(this.showIntermediateTotal&&this.intermediateTotalPositions&&this.intermediateTotalPositions.length>0&&(this._intermediateTotalPos=i.slice(),this.intermediateTotalPositions.reduceRight(function(n,t){var r=t===0?i[0]:i[t-1];return i.length>t?(i.splice(t,0,r),h._intermediateTotalPos.splice(t,0,!0)):i.length===t&&(i.push(r),h._intermediateTotalPos.push(!0)),0},0)),this.start!=null&&(i.splice(0,0,this.start),this._intermediateTotalPos.splice(0,0,!1)),this.showTotal&&i&&i.push(i[i.length-1]))),this._yValues):(!this._xValues&&this._getXValues&&(this._xValues=r&&r.slice(),this._getXValues=!1,this._xValues&&this._xValues.length>1&&(s=this._xValues.length,f=this._xValues[s-1],e=Math.abs(this._xValues[s-1]-this._xValues[s-2])),this.chart&&this.chart._xlabels&&this.chart._xlabels.length&&(u=this.chart._xlabels,this.showIntermediateTotal&&this.intermediateTotalPositions&&this.intermediateTotalPositions.length>0&&(o=this.intermediateTotalLabels,o&&this.intermediateTotalPositions.reduceRight(function(n,t,i){var r='';return r=wjcCore.isString(o)?o:o[i]||'',u.length>t?u.splice(t,0,r):u.length===t&&u.push(r),e&&(f+=e,h._xValues.push(f)),0},0)),this.start!=null&&(u.splice(0,0,this.startLabel),e&&(f+=e,this._xValues.push(f))),this.showTotal&&(u.push(this.totalLabel),e&&(f+=e,this._xValues.push(f))))),this._xValues)},t.prototype._invalidate=function(){n.prototype._invalidate.call(this);this._clearValues()},t.prototype._rendering=function(n,i){var r=this;i.cancel=!0;this._wfstyle=null;var c=this.chart,l=this._getAxisY(),v=this._getAxisX(),y=l.origin||0,e=i.engine,u,o,a,f,s,h;if(this._barPlotter=c._getPlotter(this),a=this._barPlotter.rotated,this._barPlotter._getSymbolOrigin||(this._barPlotter._getSymbolOrigin=function(n,t,i){return t===0?n:r._intermediateTotalPos[t]===!0?n:t===i-1&&r.showTotal?n:r._yValues[t-1]}),this._barPlotter._getSymbolStyles||(this._barPlotter._getSymbolStyles=function(n,t){var i=r._getStyles();return n===0&&r.start!=null?i.start:r._intermediateTotalPos[n]===!0?i.intermediateTotal:n===t-1&&r.showTotal?i.total:r._yValues[n]<r._yValues[n-1]?i.falling:i.rising}),this._barPlotter.plotSeries(e,v,l,n,c,0,1),this.connectorLines){for(e.startGroup(t.CSS_CONNECTOR_LINE_GROUP),f=this._barPlotter.hitTester._map[0],h=this._yValues[0]<y,s=f[0].rect,u=1,o=f.length;u<o;u++)(this._intermediateTotalPos[u]!==!0||u===o-1)&&(this._drawConnectorLine(e,a,s,f[u].rect,h),s=f[u].rect,h=this._yValues[u]<this._yValues[u-1]);e.endGroup()}},t.prototype._getStyles=function(){if(this._wfstyle)return this._wfstyle;var u=this._chart,r=u.series.indexOf(this),t=this._getSymbolFill(r),i=this._getSymbolStroke(r),n=this.styles||{};return this._wfstyle={start:this._getStyleByKey(n,'start',t,i),intermediateTotal:this._getStyleByKey(n,'intermediateTotal',t,i),total:this._getStyleByKey(n,'total',t,i),falling:this._getStyleByKey(n,'falling','red','red'),rising:this._getStyleByKey(n,'rising','green','green')},this._wfstyle},t.prototype._getStyleByKey=function(n,t,i,r){return{fill:n[t]&&n[t].fill?n[t].fill:i,stroke:n[t]&&n[t].stroke?n[t].stroke:r}},t.prototype._drawConnectorLine=function(n,i,r,u,f){var e=new wjcCore.Point,o=new wjcCore.Point;i?f?(e.x=r.left,e.y=r.top+r.height,o.x=r.left,o.y=u.top):(e.x=r.left+r.width,e.y=r.top+r.height,o.x=r.left+r.width,o.y=u.top):f?(e.x=r.left,e.y=r.top+r.height,o.x=u.left+u.width,o.y=r.top+r.height):(e.x=r.left,e.y=r.top,o.x=u.left+u.width,o.y=r.top);n.drawLine(e.x,e.y,o.x,o.y,t.CSS_CONNECTOR_LINE,this.styles&&this.styles.connectorLines||{stroke:'black'})},t.prototype.legendItemLength=function(){return this.showTotal?3:2},t.prototype.measureLegendItem=function(n,t){var r=this._getName(t),i=new wjcCore.Size(0,0);return r&&(i=this._measureLegendItem(n,this._getName(t))),i},t.prototype.drawLegendItem=function(n,t,i){var r=this._getLegendStyles(i),u=this._getName(i);u&&this._drawLegendItem(n,t,wjcChart.ChartType.Bar,this._getName(i),r,this.symbolStyle)},t.prototype._getLegendStyles=function(n){if(n<0||this.styles===null)return null;var t=this._getStyles();return n===0?t.rising:n===1?t.falling:t.total},t.prototype._getName=function(n){var i=undefined,t;return this.name&&(this.name.indexOf(",")?(t=this.name.split(","),t&&t.length-1>=n&&(i=t[n].trim())):i=this.name),i},t.CSS_CONNECTOR_LINE_GROUP='water-fall-connector-lines',t.CSS_CONNECTOR_LINE='water-fall-connector-line',t.CSS_ENDLABEL='water-fall-end-label',t}(wjcChart.SeriesBase);exports.Waterfall=Waterfall,function(n){n[n.InclusiveMedian=0]="InclusiveMedian";n[n.ExclusiveMedian=1]="ExclusiveMedian"}(exports.QuartileCalculation||(exports.QuartileCalculation={}));QuartileCalculation=exports.QuartileCalculation;BoxWhisker=function(n){function t(t){n.call(this);this._groupWidth=.8;this._gapWidth=.1;this._quartileCalculation=QuartileCalculation.InclusiveMedian;this._chartType=wjcChart.ChartType.Bar;this._initProperties(t||{});this.rendering.addHandler(this._rendering,this)}return __extends(t,n),t.prototype._initProperties=function(n){for(var t in n)this[t]&&(this[t]=n[t])},t.prototype._clearValues=function(){n.prototype._clearValues.call(this)},Object.defineProperty(t.prototype,"quartileCalculation",{get:function(){return this._quartileCalculation},set:function(n){n!=this._quartileCalculation&&(this._quartileCalculation=wjcCore.asEnum(n,QuartileCalculation,!0),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"groupWidth",{get:function(){return this._groupWidth},set:function(n){n!=this._groupWidth&&n>=0&&n<=1&&(this._groupWidth=wjcCore.asNumber(n,!0),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"gapWidth",{get:function(){return this._gapWidth},set:function(n){n!=this._gapWidth&&n>=0&&n<=1&&(this._gapWidth=wjcCore.asNumber(n,!0),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"showMeanLine",{get:function(){return!!this._showMeanLine},set:function(n){n!=this._showMeanLine&&(this._showMeanLine=wjcCore.asBoolean(n,!0),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"meanLineStyle",{get:function(){return this._meanLineStyle},set:function(n){n!=this._meanLineStyle&&(this._meanLineStyle=n,this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"showMeanMarker",{get:function(){return!!this._showMeanMarker},set:function(n){n!=this._showMeanMarker&&(this._showMeanMarker=wjcCore.asBoolean(n,!0),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"meanMarkerStyle",{get:function(){return this._meanMarkerStyle},set:function(n){n!=this._meanMarkerStyle&&(this._meanMarkerStyle=n,this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"showInnerPoints",{get:function(){return!!this._showInnerPoints},set:function(n){n!=this._showInnerPoints&&(this._showInnerPoints=wjcCore.asBoolean(n,!0),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"showOutliers",{get:function(){return!!this._showOutliers},set:function(n){n!=this._showOutliers&&(this._showOutliers=wjcCore.asBoolean(n,!0),this._invalidate())},enumerable:!0,configurable:!0}),t.prototype._rendering=function(n,t){var ii=this,bt,s,at,kt,dt,r,b,c,i,ht,ct;t.cancel=!0;var h=this,tt=h.chart,ai=h.chart,e=h._getAxisX(),u=h._getAxisY(),ut=t.index,ti=t.count,l=t.engine,a=this._plotter,d=tt.series.indexOf(h),pt=wjcCore.asType(h,wjcChart.SeriesBase),ri=this.quartileCalculation,ui=this.showOutliers,ft=this.groupWidth,fi=(this.gapWidth==null?.2:this.gapWidth)/2,g,nt;ut=ut||0;ti=ti||1;var lt=ft/ti,wt=h.getValues(0),k=h.getValues(1);if(wt){k||(k=a.dataInfo.getXVals());k&&(bt=a.dataInfo.getDeltaX(),bt>0&&(ft*=bt,lt*=bt));var it=pt._getSymbolFill(d),et=pt._getAltSymbolFill(d)||it,rt=pt._getSymbolStroke(d),ot=pt._getAltSymbolStroke(d)||rt,st=wt.length;if(k!=null&&(st=Math.min(st,k.length)),s=0,at=0,a.rotated){s=e.origin||s;s<e.actualMin?s=e.actualMin:s>e.actualMax&&(s=e.actualMax);var ei=e.convert(s),ci=u.actualMin,li=u.actualMax;for(r=0;r<st;r++)if(b=k?k[r]:r,c=wt[r],a._getSymbolOrigin&&(ei=u.convert(a._getSymbolOrigin(s,r))),a._getSymbolStyles&&(i=a._getSymbolStyles(r),it=i&&i.fill?i.fill:it,et=i&&i.fill?i.fill:et,rt=i&&i.stroke?i.fill:rt,ot=i&&i.stroke?i.fill:ot),kt=c[0]>0?it:et,dt=c[0]>0?rt:ot,l.fill=kt,l.stroke=dt,wjcChart._DataInfo.isValid(b)&&wjcCore.isArray(c)&&c.length>0&&wjcChart._DataInfo.isValid(c[0])){var p=b-.5*ft+ut*lt,w=b-.5*ft+(ut+1)*lt,gt=(w-p)*fi;if(p+=gt,w-=gt,p<ci&&w<ci||p>li&&w>li)continue;p=u.convert(p);w=u.convert(w);var o=new _BoxPlot(c,ri,ui),f={min:e.convert(o.min),max:e.convert(o.max),firstQuartile:e.convert(o.firstQuartile),median:e.convert(o.median),thirdQuartile:e.convert(o.thirdQuartile),mean:e.convert(o.mean),outlierPoints:this._convertPoints(o.outlierPoints,e),innerPoints:this._convertPoints(o.innerPoints,e)},hi=new wjcCore.Rect(Math.min(f.min,f.max),Math.min(p,w),Math.abs(f.max-f.min),Math.abs(w-p)),ni=new wjcChart._RectArea(hi),yt={min:Math.min(p,w),median:(p+w)/2,max:Math.max(w,p)};tt.itemFormatter?(l.startGroup(),ht=new wjcChart.HitTestInfo(tt,new wjcCore.Point((f.min+f.max)/2,yt.median),wjcChart.ChartElement.SeriesSymbol),ht._setData(h,r),tt.itemFormatter(l,ht,function(){ii._drawBoxWhisker(l,f,yt,g,nt,h);g=f;nt=yt}),l.endGroup()):(this._drawBoxWhisker(l,f,yt,g,nt,h),g=f,nt=yt);h._setPointIndex(r,at);at++;ct=new wjcChart._DataPoint(d,r,c,b);ct.item=o;ni.tag=ct;a.hitTester.add(ni,d)}}else{s=u.origin||s;s<u.actualMin?s=u.actualMin:s>u.actualMax&&(s=u.actualMax);var ei=u.convert(s),oi=e.actualMin,si=e.actualMax;for(r=0;r<st;r++)if(b=k?k[r]:r,c=wt[r],a._getSymbolOrigin&&(ei=u.convert(a._getSymbolOrigin(s,r,st))),a._getSymbolStyles&&(i=a._getSymbolStyles(r,st),it=i&&i.fill?i.fill:it,et=i&&i.fill?i.fill:et,rt=i&&i.stroke?i.stroke:rt,ot=i&&i.stroke?i.stroke:ot),kt=c[0]>0?it:et,dt=c[0]>0?rt:ot,l.fill=kt,l.stroke=dt,wjcChart._DataInfo.isValid(b)&&wjcCore.isArray(c)&&c.length>0&&wjcChart._DataInfo.isValid(c[0])){var v=b-.5*ft+ut*lt,y=b-.5*ft+(ut+1)*lt,gt=(y-v)*fi;if(v+=gt,y-=gt,v<oi&&y<oi||v>si&&y>si)continue;if(v=e.convert(v),y=e.convert(y),!wjcChart._DataInfo.isValid(v)||!wjcChart._DataInfo.isValid(y))continue;var o=new _BoxPlot(c,ri,ui),f={min:u.convert(o.min),max:u.convert(o.max),firstQuartile:u.convert(o.firstQuartile),median:u.convert(o.median),thirdQuartile:u.convert(o.thirdQuartile),mean:u.convert(o.mean),outlierPoints:this._convertPoints(o.outlierPoints,u),innerPoints:this._convertPoints(o.innerPoints,u)},hi=new wjcCore.Rect(Math.min(v,y),Math.min(f.min,f.max),Math.abs(y-v),Math.abs(f.max-f.min)),ni=new wjcChart._RectArea(hi),vt={min:Math.min(v,y),median:(v+y)/2,max:Math.max(v,y)};tt.itemFormatter?(l.startGroup(),ht=new wjcChart.HitTestInfo(tt,new wjcCore.Point(vt.median,(f.min+f.max)/2),wjcChart.ChartElement.SeriesSymbol),ht._setData(h,r),tt.itemFormatter(l,ht,function(){ii._drawBoxWhisker(l,vt,f,g,nt,h);g=vt;nt=f}),l.endGroup()):(this._drawBoxWhisker(l,vt,f,g,nt,h),g=vt,nt=f);h._setPointIndex(r,at);at++;ct=new wjcChart._DataPoint(d,r,b,c);ct.item=o;ni.tag=ct;a.hitTester.add(ni,d)}}}},t.prototype._convertPoints=function(n,t){return n.map(function(n){return t.convert(n)})},t.prototype._drawBoxWhisker=function(n,t,i,r,u,f){var e=f.symbolStyle,h=this.showInnerPoints,c=this.showOutliers,l=this.showMeanLine,a=this.meanLineStyle,v=this.showMeanMarker,s=this.meanMarkerStyle,y=this._plotter,o;n.startGroup('box-plot');y.rotated?(n.drawLine(t.min,(i.min+i.median)/2,t.min,(i.max+i.median)/2,null,e),n.drawLine(t.min,i.median,t.firstQuartile,i.median,null,e),n.drawRect(Math.min(t.firstQuartile,t.thirdQuartile),Math.min(i.min,i.max),Math.abs(t.thirdQuartile-t.firstQuartile),Math.abs(i.max-i.min),null,e),n.drawLine(t.median,i.min,t.median,i.max,null,e),n.drawLine(t.max,i.median,t.thirdQuartile,i.median,null,e),n.drawLine(t.max,(i.min+i.median)/2,t.max,(i.max+i.median)/2,null,e),l&&r&&u&&n.drawLine(t.mean,i.median,r.mean,u.median,'box-whisker-mean-line',a||e),v&&(o=Math.abs(i.median-i.min)/2,n.drawLine(t.mean-o,i.median-o,t.mean+o,i.median+o,null,s||e),n.drawLine(t.mean+o,i.median-o,t.mean-o,i.median+o,null,s||e)),c&&t.outlierPoints.forEach(function(t){n.drawPieSegment(t,i.median,2,0,Math.PI*2,null,e)}),h&&t.innerPoints.forEach(function(t){n.drawPieSegment(t,i.median,2,0,Math.PI*2,null,e)})):(n.drawLine((t.min+t.median)/2,i.min,(t.max+t.median)/2,i.min,null,e),n.drawLine(t.median,i.min,t.median,i.firstQuartile,null,e),n.drawRect(Math.min(t.min,t.max),Math.min(i.firstQuartile,i.thirdQuartile),Math.abs(t.max-t.min),Math.abs(i.thirdQuartile-i.firstQuartile),null,e),n.drawLine(t.min,i.median,t.max,i.median,null,e),n.drawLine(t.median,i.max,t.median,i.thirdQuartile,null,e),n.drawLine((t.min+t.median)/2,i.max,(t.max+t.median)/2,i.max,null,e),l&&r&&u&&n.drawLine(t.median,i.mean,r.median,u.mean,'box-whisker-mean-line',a||e),v&&(o=Math.abs(t.median-t.min)/2,n.drawLine(t.median-o,i.mean-o,t.median+o,i.mean+o,null,s||e),n.drawLine(t.median-o,i.mean+o,t.median+o,i.mean-o,null,s||e)),c&&i.outlierPoints.forEach(function(i){n.drawPieSegment(t.median,i,2,0,Math.PI*2,null,e)}),h&&i.innerPoints.forEach(function(i){n.drawPieSegment(t.median,i,2,0,Math.PI*2,null,e)}));n.endGroup()},t.prototype._renderLabels=function(n,t,i,r){var v=this,l=this,y=this._plotter,p=t.length,e=i.dataLabel,w=e.border,o=e.offset,b=e.connectingLine,s='dataY',a,f;for(y.rotated&&(s='dataX'),o===undefined&&(o=b?16:0),w&&(o-=2),a=0;a<p;a++){var h=t[a],u=h.tag,c=wjcCore.asType(u,wjcChart._DataPoint,!0);c&&(f=u.item,u[s]=f.min,u.yfmt=f.min,this._plotter._renderLabel(n,h,c,i,e,l,o,r),u[s]=f.firstQuartile,u.yfmt=f.firstQuartile,this._plotter._renderLabel(n,h,c,i,e,l,o,r),u[s]=f.median,u.yfmt=f.median,this._plotter._renderLabel(n,h,c,i,e,l,o,r),u[s]=f.thirdQuartile,u.yfmt=f.thirdQuartile,this._plotter._renderLabel(n,h,c,i,e,l,o,r),u[s]=f.max,u.yfmt=f.max,this._plotter._renderLabel(n,h,c,i,e,l,o,r),this.showMeanMarker&&(u[s]=f.mean,u.yfmt=f.mean,this._plotter._renderLabel(n,h,c,i,e,l,o,r)),f.showOutliers&&f.outlierPoints&&f.outlierPoints.forEach(function(t){u[s]=t;u.yfmt=t;v._plotter._renderLabel(n,h,c,i,e,l,o,r)}))}},t}(wjcChart.SeriesBase);exports.BoxWhisker=BoxWhisker;_BoxPlot=function(){function n(n,t,i){this._outlierPoints=[];this._innerPoints=[];this._data=n;this._quartileCalculation=t;this._showOutliers=i;this._parse()}return Object.defineProperty(n.prototype,"showOutliers",{get:function(){return this._showOutliers},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"min",{get:function(){return this._min},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"max",{get:function(){return this._max},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"mean",{get:function(){return this._mean},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"firstQuartile",{get:function(){return this._firstQuartile},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"thirdQuartile",{get:function(){return this._thirdQuartile},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"median",{get:function(){return this._median},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"outlierPoints",{get:function(){return this._outlierPoints},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"innerPoints",{get:function(){return this._innerPoints},enumerable:!0,configurable:!0}),n.prototype._parse=function(){var t=this,r=this._data.length,n=this._data,i=0,u,f,e;this._outlierPoints=[];this._innerPoints=[];n.sort(function(n,t){return n-t});this._min=n[0];this._max=n[r-1];this._quartileCalculation===QuartileCalculation.InclusiveMedian?(this._firstQuartile=this._quartileInc(n,.25),this._median=this._quartileInc(n,.5),this._thirdQuartile=this._quartileInc(n,.75)):(this._firstQuartile=this._quartileExc(n,.25),this._median=this._quartileExc(n,.5),this._thirdQuartile=this._quartileExc(n,.75));this._iqr=1.5*Math.abs(this._thirdQuartile-this._firstQuartile);u=this._firstQuartile-this._iqr;f=this._thirdQuartile+this._iqr;this._showOutliers?(e=this._max,this._max=this._min,this._min=e,this._data.forEach(function(n){i+=n;n<u||n>f?t._outlierPoints.push(n):(n<t._min&&(t._min=n),n>t._max&&(t._max=n))})):i=this._data.reduce(function(n,t){return n+t},0);this._innerPoints=this._data.filter(function(n){if(n>t._min&&n<t._max)return!0});this._mean=i/r},n.prototype._quartileInc=function(n,t){var f=n.length,r,i,u,e;return f<2?NaN:(r=(f-1)*t+1,i=Math.floor(r),u=n[i-1],e=r-i,u+(n[i]-u)*e)},n.prototype._quartileExc=function(n,t){var i=n.length,u,r,f,e;return i<3?NaN:(i+1)%4==0?n[(i+1)*t]:(u=(i+1)*t,r=Math.floor(u),f=n[r-1],e=u-r,f+(n[r]-f)*e)},n}();exports._BoxPlot=_BoxPlot,function(n){n[n.FixedValue=0]="FixedValue";n[n.Percentage=1]="Percentage";n[n.StandardDeviation=2]="StandardDeviation";n[n.StandardError=3]="StandardError";n[n.Custom=4]="Custom"}(exports.ErrorAmount||(exports.ErrorAmount={}));ErrorAmount=exports.ErrorAmount,function(n){n[n.Cap=0]="Cap";n[n.NoCap=1]="NoCap"}(exports.ErrorBarEndStyle||(exports.ErrorBarEndStyle={}));ErrorBarEndStyle=exports.ErrorBarEndStyle,function(n){n[n.Both=0]="Both";n[n.Minus=1]="Minus";n[n.Plus=2]="Plus"}(exports.ErrorBarDirection||(exports.ErrorBarDirection={}));ErrorBarDirection=exports.ErrorBarDirection;ErrorBar=function(n){function t(t){n.call(this);this._errorAmount=ErrorAmount.FixedValue;this._endStyle=ErrorBarEndStyle.Cap;this._direction=ErrorBarDirection.Both;this._initProperties(t||{});this.rendering.addHandler(this._rendering,this)}return __extends(t,n),t.prototype._initProperties=function(n){for(var t in n)this[t]&&(this[t]=n[t])},t.prototype.getDataRect=function(n){var c,u,e,h,f,i,t;if(!n)return null;var a=this._chart,r=this.errorAmount,o=0,s=0,l;if(this._paddings=[],this._calculateErrorValue(),c=this.getValues(0),!c)return n;for(h=0,l=c.length;h<l;h++){i={plus:0,minus:0};t=this._value||0;f=c[h];switch(r){case ErrorAmount.Custom:i=this._getCustomValue(h);this._paddings.push(i);break;case ErrorAmount.FixedValue:this._paddings.push({plus:t,minus:t});break;case ErrorAmount.Percentage:this._paddings.push({plus:f*t,minus:f*t});break;case ErrorAmount.StandardDeviation:this._paddings.push({plus:this._errorValue*t,minus:this._errorValue*t});break;case ErrorAmount.StandardError:this._paddings.push({plus:this._errorValue,minus:this._errorValue})}(isNaN(u)||u>f-i.minus)&&(u=r===ErrorAmount.StandardDeviation?this._mean-i.minus:f-i.minus);(isNaN(e)||e<f+i.plus)&&(e=r===ErrorAmount.StandardDeviation?this._mean+i.plus:f+i.plus)}return r===ErrorAmount.FixedValue?(o=t,s=t):r===ErrorAmount.Percentage?(s=e*t,o=u*t):r===ErrorAmount.StandardDeviation?(o=this._errorValue*t,s=this._errorValue*t):r===ErrorAmount.StandardError&&(o=this._errorValue,s=this._errorValue),this._showPlus&&(e+=s),this._showMinus&&(u-=o),new wjcCore.Rect(n.left,u,n.width,e-u)},t.prototype._getCustomValue=function(n){var i=this.value,t={minus:0,plus:0},r;return this._minusBindingValues!=null||this._plusBindingValues!=null?(t.minus=this._minusBindingValues&&this._minusBindingValues[n]||0,t.plus=this._plusBindingValues&&this._plusBindingValues[n]||0,t):i==null?t:(wjcCore.isArray(i)?(r=i[n],r&&r.minus&&(t.minus=r.minus),r&&r.plus&&(t.plus=r.plus)):wjcCore.isNumber(i)?(t.minus=i,t.plus=i):(i.minus&&(t.minus=i.minus),i.plus&&(t.plus=i.plus)),t)},t.prototype._calculateErrorValue=function(){var n=0,t=0,r=0,i;(this._errorAmount===ErrorAmount.StandardDeviation||this._errorAmount===ErrorAmount.StandardError)&&(i=this.getValues(0),i!=null&&(i.forEach(function(i){n+=i;t++}),r=n/t,this._mean=r,n=0,i.forEach(function(t){n+=Math.pow(t-r,2)}),this._errorValue=Math.sqrt(n/(t-1))),this._errorAmount===ErrorAmount.StandardError&&(this._errorValue=this._errorValue/Math.sqrt(t)))},t.prototype._clearValues=function(){this.__errorValue=null;this._mean=null;this._plusBindingValues=null;this._minusBindingValues=null;n.prototype._clearValues.call(this)},t.prototype.getValues=function(t){var i,r,u,f;return t==0&&this.errorAmount===ErrorAmount.Custom&&(i=this._getBinding(1),r=this._getBinding(2),(this._plusBindingValues==null||this._minusBindingValues==null)&&i&&r&&(this._cv!=null?(i&&(u=this._bindValues(this._cv.items,i),this._plusBindingValues=u.values),r&&(f=this._bindValues(this._cv.items,r),this._minusBindingValues=f.values)):this.binding!=null&&this._chart!=null&&this._chart.collectionView!=null&&(i&&(u=this._bindValues(this._chart.collectionView.items,i),this._plusBindingValues=u.values),r&&(f=this._bindValues(this._chart.collectionView.items,r),this._minusBindingValues=f.values)))),n.prototype.getValues.call(this,t)},Object.defineProperty(t.prototype,"_chart",{get:function(){return this.__chart},set:function(n){n!==this.__chart&&(this.__chart=n)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"errorBarStyle",{get:function(){return this._errorBarStyle},set:function(n){n!=this._errorBarStyle&&(this._errorBarStyle=n,this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"value",{get:function(){return this._value},set:function(n){n!=this._value&&(this._value=n,this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"errorAmount",{get:function(){return this._errorAmount},set:function(n){n!=this._errorAmount&&(this._errorAmount=wjcCore.asEnum(n,ErrorAmount,!0),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"endStyle",{get:function(){return this._endStyle},set:function(n){n!=this._endStyle&&(this._endStyle=wjcCore.asEnum(n,ErrorBarEndStyle,!0),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"direction",{get:function(){return this._direction},set:function(n){n!=this._direction&&(this._direction=wjcCore.asEnum(n,ErrorBarDirection,!0),this._invalidate())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_errorValue",{get:function(){return this.__errorValue},set:function(n){n!=this.__errorValue&&(this.__errorValue=n)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_showPlus",{get:function(){return this.direction===ErrorBarDirection.Both||this.direction===ErrorBarDirection.Plus},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_showMinus",{get:function(){return this.direction===ErrorBarDirection.Both||this.direction===ErrorBarDirection.Minus},enumerable:!0,configurable:!0}),t.prototype._rendering=function(n,t){var i=this;t.cancel=!0;var f=this.chart,u=this._getAxisY(),e=this._getAxisX(),o=u.origin||0,r=t.engine;this._plotter.plotSeries(r,e,u,this,f,t.index,t.count,function(n){var y=i._paddings,h=i._showPlus,c=i._showMinus,s=f._isRotated(),t=i.errorBarStyle&&i.errorBarStyle['stroke-width']||2,l,o,a,v;o=s?e:u;l=o.convert(0);a=r.stroke;v=r.strokeWidth;r.stroke='black';r.strokeWidth=1;n&&n.length&&n.forEach(function(n,u){if(n.x!=null&&n.y!=null){var a=y[u],w=a&&a.minus||0,b=a&&a.plus||0,v=Math.abs(o.convert(w)-l),p=Math.abs(o.convert(b)-l),f=new wjcCore.Point(n.x,n.y),e=new wjcCore.Point(n.x,n.y);s?(i.errorAmount===ErrorAmount.StandardDeviation&&(n=new wjcCore.Point(o.convert(i._mean),n.y),f.x=n.x,e.x=n.x),c&&(f.x=f.x-v),h&&(e.x=e.x+p)):(i.errorAmount===ErrorAmount.StandardDeviation&&(n=new wjcCore.Point(n.x,o.convert(i._mean)),f.y=n.y,e.y=n.y),c&&(f.y=f.y+v),h&&(e.y=e.y-p));r.drawLine(f.x,f.y,e.x,e.y,'error-bar',i.errorBarStyle);i.endStyle===ErrorBarEndStyle.Cap&&(h&&(s?r.drawLine(e.x,e.y-t,e.x,e.y+t,'error-bar',i.errorBarStyle):r.drawLine(e.x-t,e.y,e.x+t,e.y,'error-bar',i.errorBarStyle)),c&&(s?r.drawLine(f.x,f.y-t,f.x,f.y+t,'error-bar',i.errorBarStyle):r.drawLine(f.x-t,f.y,f.x+t,f.y,'error-bar',i.errorBarStyle)))}});r.stroke=a;r.strokeWidth=v})},t}(wjcChart.Series);exports.ErrorBar=ErrorBar