/*
 *
 * Wijmo Library 3.20163.110
 * http://wijmo.com/
 *
 * Copyright(c) GrapeCity, Inc.  All rights reserved.
 * 
 * Licensed under the Wijmo Commercial License. Also available under the GNU GPL Version 3 license.
 * licensing@wijmo.com
 * http://wijmo.com/widgets/license/
 *
 */
/// <reference path="../../External/declarations/jquery.d.ts"/>
var wijmo;
(function (wijmo) {
    wijmo.expando = ".wijmo";

    /** @ignore */
    var WijmoError = (function () {
        function WijmoError(message) {
            this.message = message;
            this.stack = "Wijmo" + (new Error()).stack;
            this.name = "WijmoError";
        }
        return WijmoError;
    })();
    wijmo.WijmoError = WijmoError;
    var wijerr = WijmoError;
    wijerr.prototype = new Error();
    wijerr.prototype["constructor"] = wijerr;
})(wijmo || (wijmo = {}));

var wijmo;
(function (wijmo) {
    (function (data) {
        /** @ignore */
        var Expando = (function () {
            function Expando(object) {
                this.object = object;
            }
            Expando.getFrom = function (obj, create) {
                if (typeof create === "undefined") { create = true; }
                var propertyName = wijmo.expando, ext;
                if (Object(obj) !== obj)
                    return null;

                ext = obj[propertyName];
                if (ext && ext.object !== obj) {
                    ext = null;
                }

                if (create && !(ext instanceof Expando && Object.prototype.hasOwnProperty.call(obj, propertyName))) {
                    ext = new Expando(obj);
                    try  {
                        Object.defineProperty(obj, propertyName, {
                            value: ext,
                            configurable: false,
                            enumerable: false,
                            writable: false
                        });
                    } catch (e) {
                        obj[propertyName] = ext;
                    }
                }
                return ext;
            };
            return Expando;
        })();
        data.Expando = Expando;
    })(wijmo.data || (wijmo.data = {}));
    var data = wijmo.data;
})(wijmo || (wijmo = {}));

var wijmo;
(function (wijmo) {
    (function (data) {
        /** @ignore */
        (function (util) {
            function funcClass(ctor) {
                return function () {
                    var result = function () {
                        return ctor.prototype._call.apply(result, arguments);
                    };
                    $.extend(result, ctor.prototype);
                    ctor.apply(result, arguments);
                    return result;
                };
            }
            util.funcClass = funcClass;
        })(data.util || (data.util = {}));
        var util = data.util;
    })(wijmo.data || (wijmo.data = {}));
    var data = wijmo.data;
})(wijmo || (wijmo = {}));
/// <reference path="core.ts"/>
/// <reference path="util.ts"/>
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var wijmo;
(function (wijmo) {
    (function (data) {
        var $ = jQuery;

        /** @ignore */
        var SubscriberEntry = (function () {
            function SubscriberEntry(handler, context) {
                this.handler = handler;
                this.context = context;
            }
            SubscriberEntry.prototype.trigger = function (args) {
                return this.handler.apply(this.context, args);
            };
            return SubscriberEntry;
        })();
        data.SubscriberEntry = SubscriberEntry;

        /** @ignore */
        var Subscribable = (function () {
            function Subscribable(defaultContext) {
                this.defaultContext = defaultContext;
                this._entries = [];
            }
            Subscribable.prototype.subscribe = function (handler, context) {
                var _this = this;
                if (typeof context === "undefined") { context = this.defaultContext; }
                var entry = new SubscriberEntry(handler, context);
                this._entries.push(entry);
                return {
                    dispose: function () {
                        return data.util.remove(_this._entries, entry);
                    }
                };
            };
            Subscribable.prototype.trigger = function () {
                var args = [];
                for (var _i = 0; _i < (arguments.length - 0); _i++) {
                    args[_i] = arguments[_i + 0];
                }
                data.util.each(this._entries, function (_, e) {
                    return e.trigger(args);
                });
            };

            Subscribable.makeSubscribable = function (obj) {
                var subscribable = new Subscribable(obj);
                obj.subscribe = $.proxy(subscribable.subscribe, subscribable);
                return subscribable;
            };
            return Subscribable;
        })();
        data.Subscribable = Subscribable;
        function isSubscriptable(subscribable) {
            return $.isFunction(subscribable.subscribe);
        }
        data.isSubscriptable = isSubscriptable;

        /** @ignore */
        var BaseObservable = (function () {
            function BaseObservable() {
            }
            BaseObservable.prototype.subscribe = function (handler, context) {
                this._subscribable = this._subscribable || new Subscribable(this);
                return this._subscribable.subscribe(handler, context);
            };
            BaseObservable.prototype._trigger = function () {
                var args = [];
                for (var _i = 0; _i < (arguments.length - 0); _i++) {
                    args[_i] = arguments[_i + 0];
                }
                if (this._subscribable) {
                    this._subscribable.trigger.apply(this._subscribable, arguments);
                }
            };
            return BaseObservable;
        })();
        data.BaseObservable = BaseObservable;

        /** @ignore */
        var _ReadOnlyObservable = (function (_super) {
            __extends(_ReadOnlyObservable, _super);
            function _ReadOnlyObservable(mutable) {
                _super.call(this);
                this.mutable = mutable;
            }
            _ReadOnlyObservable.prototype._call = function () {
                return this.mutable.value;
            };
            return _ReadOnlyObservable;
        })(BaseObservable);
        data._ReadOnlyObservable = _ReadOnlyObservable;
        var ReadOnlyObservable = data.util.funcClass(_ReadOnlyObservable);

        /** @ignore */
        var _MutableObservable = (function (_super) {
            __extends(_MutableObservable, _super);
            function _MutableObservable(value, checkNewValue) {
                if (typeof checkNewValue === "undefined") { checkNewValue = false; }
                _super.call(this);
                this.value = value;
                this.checkNewValue = checkNewValue;
            }
            _MutableObservable.prototype._call = function (newValue) {
                if (arguments.length > 0 && (!this.checkNewValue || newValue !== this.value)) {
                    this.value = newValue;
                    this._trigger(newValue);
                    if (this._readOnly) {
                        this._readOnly._trigger(newValue);
                    }
                }
                return this.value;
            };

            _MutableObservable.prototype.read = function () {
                this._readOnly = this._readOnly || new ReadOnlyObservable(this);
                return this._readOnly;
            };
            return _MutableObservable;
        })(BaseObservable);
        data._MutableObservable = _MutableObservable;
        var MutableObservable = data.util.funcClass(_MutableObservable);

        /** @ignore */
        var _NumericMutableObservable = (function (_super) {
            __extends(_NumericMutableObservable, _super);
            function _NumericMutableObservable(value) {
                _super.call(this, value, false);
                this.value = value;
            }
            _NumericMutableObservable.prototype.change = function (delta) {
                return this._call(this._call() + delta);
            };
            _NumericMutableObservable.prototype.inc = function () {
                return this.change(1);
            };
            _NumericMutableObservable.prototype.dec = function () {
                return this.change(-1);
            };
            return _NumericMutableObservable;
        })(_MutableObservable);
        data._NumericMutableObservable = _NumericMutableObservable;
        var NumericMutableObservable = data.util.funcClass(_NumericMutableObservable);

        function observable(value) {
            if (typeof value === "undefined") { value = null; }
            return new MutableObservable(value);
        }
        data.observable = observable;

        /** @ignore */
        function numericObservable(value) {
            if (typeof value === "undefined") { value = 0; }
            return new NumericMutableObservable(value);
        }
        data.numericObservable = numericObservable;

        /** @ignore */
        function observableWithNewValueCheck(value) {
            if (typeof value === "undefined") { value = null; }
            return new MutableObservable(value, true);
        }
        data.observableWithNewValueCheck = observableWithNewValueCheck;
        function isObservable(observable) {
            return $.isFunction(observable) && isSubscriptable(observable);
        }
        data.isObservable = isObservable;
    })(wijmo.data || (wijmo.data = {}));
    var data = wijmo.data;
})(wijmo || (wijmo = {}));
/// <reference path="../../Base/wijmo.d.ts"/>
/// <reference path="core.ts"/>
/// <reference path="observable.ts"/>
var wijmo;
(function (wijmo) {
    (function (data) {
        /** @ignore */
        (function (util) {
            var $ = jQuery;

            function clone(obj, deep) {
                if (typeof deep === "undefined") { deep = false; }
                if ($.isArray(obj)) {
                    obj = obj.slice(0);
                } else if ($.isPlainObject(obj)) {
                    obj = $.extend(!!deep, {}, obj);
                }
                return obj;
            }
            util.clone = clone;

            function isString(str) {
                return typeof str === "string" || str instanceof String;
            }
            util.isString = isString;
            function isNumeric(value) {
                return typeof value === "number";
            }
            util.isNumeric = isNumeric;

            function isInternalProperty(p) {
                return p === wijmo.expando || p === $.expando;
            }
            util.isInternalProperty = isInternalProperty;

            function each(obj, fn) {
                var _this = this;
                $.each(obj, function (key, value) {
                    if (!isInternalProperty(key)) {
                        return fn.call(_this, key, value);
                    }
                });
            }
            util.each = each;
            function map(obj, fn) {
                var result = $.map(obj, fn);
                delete result[wijmo.expando];
                return result;
            }
            util.map = map;

            function toStr(obj) {
                var text;
                if (obj && $.isFunction(obj.toString) && obj.toString !== Object.prototype.toString) {
                    text = obj.toString();
                } else {
                    text = JSON.stringify(obj);
                }
                if (text != null && text.length > 2 && text[0] === '"' && text[text.length - 1] === '"') {
                    text = text.substr(1, text.length - 2);
                }
                return text;
            }
            util.toStr = toStr;
            function format(format) {
                var args = [];
                for (var _i = 0; _i < (arguments.length - 1); _i++) {
                    args[_i] = arguments[_i + 1];
                }
                return format.replace(/{(\d+)}/g, function (m, index) {
                    return toStr(args[parseInt(index, 10)]);
                });
            }
            util.format = format;

            function every(obj, predicate) {
                var res = true;
                each(obj, function (key, value) {
                    res = value;
                    if (predicate) {
                        res = predicate.call(res, res, key);
                    }
                    if (!res) {
                        return false;
                    }
                });
                return res;
            }
            util.every = every;
            function some(obj, predicate) {
                var res = false;
                each(obj, function (key, value) {
                    res = value;
                    if (predicate) {
                        res = predicate.call(res, res, key);
                    }
                    if (res) {
                        return false;
                    }
                });
                return res;
            }
            util.some = some;

            function compare(a, b) {
                var i, len, cmp;

                if (a == null) {
                    return b == null ? 0 : -1;
                } else if (b == null) {
                    return 1;
                }

                if ($.isArray(a) && $.isArray(b)) {
                    len = Math.min(a.length, b.length);
                    for (i = 0; i < len; i++) {
                        cmp = compare(a[i], b[i]);
                        if (cmp !== 0) {
                            return cmp;
                        }
                    }
                    return a.length - b.length;
                } else if (isString(a) && isString(b)) {
                    a = a.toLowerCase();
                    b = b.toLowerCase();
                    return a < b ? -1 : a > b ? 1 : 0;
                }

                cmp = a - b;
                return isNaN(cmp) ? 0 : cmp;
            }
            util.compare = compare;

            function contains(array, elem) {
                return $.inArray(elem, array) >= 0;
            }
            util.contains = contains;
            function remove(array, elem) {
                var removed = 0, i;

                for (i = 0; i < array.length;) {
                    if (array[i] !== elem) {
                        i++;
                    } else {
                        array.splice(i, 1);
                        removed++;
                    }
                }
                return removed;
            }
            util.remove = remove;

            function pageCount(totalCount, pageSize) {
                if (totalCount == -1) {
                    return -1;
                } else if (totalCount == 0) {
                    return 0;
                } else if (!pageSize) {
                    return 1;
                } else {
                    return Math.ceil(totalCount / pageSize);
                }
            }
            util.pageCount = pageCount;
            ;

            function executeDelayed(fn, context) {
                var args = [];
                for (var _i = 0; _i < (arguments.length - 2); _i++) {
                    args[_i] = arguments[_i + 2];
                }
                function callback() {
                    return fn.apply(context, args);
                }

                if (typeof setTimeout === typeof undefined) {
                    return callback();
                } else {
                    setTimeout(callback, 10);
                }
            }
            util.executeDelayed = executeDelayed;

            function logError(message) {
                if (typeof console == "undefined")
                    return;
                if (console.error) {
                    console.error(message);
                } else if (console.log) {
                    console.log(message);
                }
            }
            util.logError = logError;

            function getProperty(obj, property) {
                var start = 0, value = obj, key;
                while (true) {
                    var point = property.indexOf('.', start);
                    if (point >= 0) {
                        key = property.substring(start, point);
                        start = point + 1;
                    } else if (start > 0) {
                        key = property.substring(start);
                    } else {
                        key = property;
                    }

                    value = value[key];
                    if (data.isObservable(value)) {
                        value = value();
                    }

                    if (point < 0) {
                        break;
                    }
                }
                return value;
            }
            util.getProperty = getProperty;
            function setProperty(obj, property, newValue) {
                var start = 0, key;
                while (true) {
                    var point = property.indexOf('.', start);
                    if (point >= 0) {
                        key = property.substring(start, point);
                        start = point + 1;
                    } else if (start > 0) {
                        key = property.substring(start);
                    } else {
                        key = property;
                    }

                    var value = obj[key];

                    if (point >= 0) {
                        if (data.isObservable(value)) {
                            value = value();
                        }
                        obj = value;
                    } else {
                        if (data.isObservable(value)) {
                            value(newValue);
                        } else {
                            obj[key] = newValue;
                        }
                        break;
                    }
                }
            }
            util.setProperty = setProperty;

            function isClassInstance(instance) {
                return typeof instance === "object" && !$.isArray(instance) && !$.isPlainObject(instance) && instance.constructor !== Object.prototype.constructor;
            }
            util.isClassInstance = isClassInstance;

            function convertDateProperties(entities) {
                util.each(entities, function (_, entity) {
                    if (!entity || typeof entity !== "object")
                        return;
                    util.each(entity, function (key, value) {
                        var match;
                        if (!util.isString(value))
                            return;
                        match = /\/Date\((-?\d+)\)\//.exec(value);
                        if (!match)
                            return;
                        entity[key] = new Date(parseInt(match[1], 10));
                    });
                });
            }
            util.convertDateProperties = convertDateProperties;

            var HashMapEntry = (function () {
                function HashMapEntry(key) {
                    this.key = key;
                }
                return HashMapEntry;
            })();
            util.HashMapEntry = HashMapEntry;

            var HashMap = (function () {
                function HashMap() {
                    this.hash = {};
                }
                HashMap.prototype.getEntry = function (key, create) {
                    if (typeof create === "undefined") { create = false; }
                    if (key === null) {
                        if (!this.nullEntry && create) {
                            this.nullEntry = new HashMapEntry(key);
                        }
                        return this.nullEntry;
                    }

                    var strKey = String(key);
                    var list = this.hash[strKey];
                    var entry;
                    if (list == null) {
                        if (!create) {
                            return null;
                        }

                        list = [];
                        this.hash[strKey] = list;
                    }

                    for (var i = 0; i < list.length; i++) {
                        if (list[i].key === key) {
                            return list[i];
                        }
                    }

                    if (create) {
                        entry = new HashMapEntry(key);
                        list.push(entry);
                    }

                    return null;
                };

                HashMap.prototype.containsKey = function (key) {
                    return !!this.getEntry(key);
                };

                HashMap.prototype.get = function (key, defaultValue) {
                    if (typeof defaultValue === "undefined") { defaultValue = null; }
                    var entry = this.getEntry(key);
                    return entry ? entry.value : defaultValue;
                };

                HashMap.prototype.put = function (key, value) {
                    this.getEntry(key, true).value = value;
                };
                return HashMap;
            })();
            util.HashMap = HashMap;
        })(data.util || (data.util = {}));
        var util = data.util;
    })(wijmo.data || (wijmo.data = {}));
    var data = wijmo.data;
})(wijmo || (wijmo = {}));
/// <reference path="util.ts"/>
var wijmo;
(function (wijmo) {
    /** @ignore */
    (function (data) {
        data.errors = {};
        data.errors._register = function (messages) {
            data.util.each(messages, function (name, msg) {
                function create() {
                    var fmtArgs = [];
                    for (var _i = 0; _i < (arguments.length - 0); _i++) {
                        fmtArgs[_i] = arguments[_i + 0];
                    }
                    var lastChar;
                    if ($.isFunction(msg)) {
                        msg = msg.apply(this, arguments);
                    } else if (arguments.length > 0) {
                        fmtArgs.unshift(msg);
                        msg = data.util.format.apply(this, fmtArgs);
                    }

                    msg = $.trim(msg);
                    lastChar = msg[msg.length - 1];
                    if (lastChar !== '.' && lastChar !== '!' && lastChar !== '?') {
                        msg += '.';
                    }

                    return new wijmo.WijmoError(msg);
                }

                data.errors[name] = function () {
                    throw create.apply(this, arguments);
                };
                data.errors[name].create = create;
            });
        };

        data.errors._register({
            indexOutOfBounds: "Index is outside the bounds of the array.",
            notImplemented: "The operation is not implemented",
            unsupportedOperation: "Unsupported operation",
            unsupportedFilterOperator: "Unsupported filter operator: {0}",
            unsupportedDataSource: "Unsupported data source",
            argument: function (paramName) {
                var message = "Unexpected argument value.";
                if (paramName) {
                    message += "\nParameter name: " + paramName;
                }
                return message;
            },
            argumentNull: "Argument '{0}' is null/undefined",
            noParser: "There is no parser for type '{0}'",
            noUrl: "Url is not specified",
            cantConvert: "Value can't be converted to type '{0}': '{1}'",
            noGlobalize: "Globalize is not defined. Make sure you include globalize.js",
            itemNotInView: "Item {0} is not in the data view",
            unsupportedFilterFormat: "The filter format is not supported",
            multiPropertyKeysNotSupported: "Entities with multiple properties in the primary key are not supported. Entity type: {0}",
            keyPropertyNotFound: "Key property not found in {0} entity type"
        });
    })(wijmo.data || (wijmo.data = {}));
    var data = wijmo.data;
})(wijmo || (wijmo = {}));
/// <reference path="dataView.ts"/>
var wijmo;
(function (wijmo) {
    (function (data) {
        /** @ignore */
        (function (filtering) {
            var $ = jQuery;

            filtering.opMap = {
                "==": "equals",
                doesnotcontain: "notcontain",
                "!=": "notequal",
                ">": "greater",
                "<": "less",
                ">=": "greaterorequal",
                "<=": "lessorequal",
                isnotempty: "notisempty",
                isnotnull: "notisnull"
            };

            function findOperator(name, throwIfNotFound) {
                if (typeof throwIfNotFound === "undefined") { throwIfNotFound = false; }
                name = name.toLowerCase();
                var op = filtering.ops[name];
                if (!op) {
                    var mappedName = filtering.opMap[name];
                    if (mappedName) {
                        op = filtering.ops[mappedName];
                    }
                }
                if (!op && throwIfNotFound)
                    data.errors.unsupportedFilterOperator(name);
                return op;
            }

            function normalizeCondition(cond) {
                var filter;
                if (!$.isPlainObject(cond)) {
                    return { operator: "==", op: filtering.ops.equals, value: cond };
                }

                var op = cond.operator || filtering.ops.equals;
                if (data.util.isString(cond.operator)) {
                    if (cond.operator.toLowerCase() === "nofilter")
                        return null;
                    op = findOperator(cond.operator, true);
                } else if (!$.isFunction(op.apply)) {
                    data.errors.unsupportedFilterOperator(op);
                }
                return { operator: cond.operator, op: op, value: cond.value };
            }
            filtering.normalizeCondition = normalizeCondition;

            function compile(filter) {
                var result = {
                    isEmpty: false,
                    original: filter,
                    func: null,
                    normalized: null
                };
                if ($.isFunction(filter)) {
                    result.func = filter;
                } else if ($.isArray(filter)) {
                    data.errors.unsupportedFilterFormat(filter);
                } else if (filter) {
                    result.normalized = {};
                    var hasConditions = false;
                    data.util.each(filter, function (prop, cond) {
                        if ($.isArray(cond)) {
                            data.errors.unsupportedFilterFormat();
                        }

                        cond = normalizeCondition(cond);
                        if (cond) {
                            result.normalized[prop] = cond;
                            hasConditions = true;
                        }
                    });

                    if (!hasConditions) {
                        result.normalized = null;
                    } else {
                        result.func = function (x) {
                            return data.util.every(result.normalized, function (cond, prop) {
                                var propValue = data.util.getProperty(x, prop);
                                return cond.op.apply(propValue, cond.value);
                            });
                        };
                    }
                }

                if (!result.normalized && !result.func) {
                    result.isEmpty = true;
                    result.func = function (x) {
                        return true;
                    };
                }

                return result;
            }
            filtering.compile = compile;

            //#region operators
            filtering.ops = (function () {
                var ops = {}, types = {
                    str: ["string"],
                    prim: ["string", "number", "datetime", "currency", "boolean"],
                    comparable: ["string", "number", "datetime", "currency"]
                };

                function op(name, displayName, arity, types, apply) {
                    return ops[name.toLowerCase()] = {
                        name: name,
                        displayName: displayName,
                        arity: arity,
                        applicableTo: types,
                        apply: apply
                    };
                }

                function preprocessOperand(value) {
                    if (value instanceof Date) {
                        value = value.getTime();
                    }
                    if (data.util.isString(value)) {
                        value = value.toLowerCase();
                    }
                    return value;
                }
                function bin(name, displayName, types, apply) {
                    op(name, displayName, 2, types, function (left, right) {
                        return apply(preprocessOperand(left), preprocessOperand(right));
                    });
                }
                function unary(name, displayName, types, apply) {
                    op(name, displayName, 1, types, apply);
                }
                function binprim(name, displayName, apply) {
                    bin(name, displayName, types.prim, apply);
                }
                function binstr(name, displayName, apply) {
                    bin(name, displayName, types.str, apply);
                }
                function bincomparable(name, displayName, apply) {
                    bin(name, displayName, types.comparable, apply);
                }

                // Primitive binary operators
                binprim("Equals", "Equals", function (l, r) {
                    return l == r;
                });
                binprim("NotEqual", "Not equal", function (l, r) {
                    return l != r;
                });
                bincomparable("Greater", "Greater than", function (l, r) {
                    return l > r;
                });
                bincomparable("Less", "Less than", function (l, r) {
                    return l < r;
                });
                bincomparable("GreaterOrEqual", "Greater or equal", function (l, r) {
                    return l >= r;
                });
                bincomparable("LessOrEqual", "Less or equal", function (l, r) {
                    return l <= r;
                });

                // String operators
                binstr("Contains", "Contains", function (left, right) {
                    return left == right || left && left.indexOf && left.indexOf(right) >= 0;
                });
                binstr("NotContain", "Does not contain", function (left, right) {
                    return left != right && (!left || !left.indexOf || left.indexOf(right) < 0);
                });
                binstr("BeginsWith", "Begins with", function (left, right) {
                    return left == right || left && left.indexOf && left.indexOf(right) == 0;
                });
                binstr("EndsWith", "Ends with", function (left, right) {
                    var idx;
                    if (!data.util.isString(left) || !data.util.isString(right))
                        return false;
                    idx = left.lastIndexOf(right);
                    return idx >= 0 && left.length - idx === right.length;
                });

                // Unary operators
                unary("IsEmpty", "Is empty", types.str, function (x) {
                    return !x && x !== 0 && x !== false;
                }); // null, undefined, or empty string
                unary("NotIsEmpty", "Is not empty", types.str, function (x) {
                    return !!x || x === 0 || x === false;
                });
                unary("IsNull", "Is null", types.prim, function (x) {
                    return x == null;
                });
                unary("NotIsNull", "Is not null", types.prim, function (x) {
                    return x != null;
                });

                return ops;
            })();
        })(data.filtering || (data.filtering = {}));
        var filtering = data.filtering;
    })(wijmo.data || (wijmo.data = {}));
    var data = wijmo.data;
})(wijmo || (wijmo = {}));
/// <reference path="dataView.ts"/>
var wijmo;
(function (wijmo) {
    (function (data) {
        /** @ignore */
        (function (sorting) {
            function normalize(sort) {
                var result = [];
                sort = data.util.isString(sort) ? sort.split(/,\s*/) : !$.isArray(sort) ? [sort] : sort.slice(0);

                sort = $.isArray(sort) ? sort.slice(0) : [sort];
                data.util.each(sort, function (_, prop) {
                    var asc = true, i;
                    if (prop == null)
                        return;
                    if (!data.util.isString(prop)) {
                        if (prop.property != null) {
                            result.push(prop);
                        }
                        return;
                    }

                    if (prop[0] === "-") {
                        asc = false;
                        prop = prop.substr(1);
                    } else {
                        var match = /\s(asc|desc)\s*$/.exec(prop);
                        if (match) {
                            prop = prop.substr(0, match.index);
                            asc = !(match[1] === "desc");
                        }
                    }

                    result.push({ property: prop, asc: asc });
                });

                return result.length > 0 ? result : null;
            }
            function compile(sort, compareTo) {
                if (typeof compareTo === "undefined") { compareTo = data.util.compare; }
                var normalized = normalize(sort);
                var result = {
                    isEmpty: true,
                    original: sort,
                    propertyCompareTo: compareTo,
                    compare: null,
                    normalized: normalized
                };

                if (normalized != null) {
                    result.isEmpty = false;
                    result.compare = function (a, b) {
                        var i = 0, cmp, descr;
                        for (i = 0; i < normalized.length; i++) {
                            descr = normalized[i];
                            cmp = compareTo(data.util.getProperty(a, descr.property), data.util.getProperty(b, descr.property));
                            if (cmp !== 0) {
                                if (!descr.asc) {
                                    cmp = -cmp;
                                }
                                return cmp;
                            }
                        }

                        return 0;
                    };
                }
                return result;
            }
            sorting.compile = compile;
        })(data.sorting || (data.sorting = {}));
        var sorting = data.sorting;
    })(wijmo.data || (wijmo.data = {}));
    var data = wijmo.data;
})(wijmo || (wijmo = {}));
/// <reference path="core.ts"/>
/// <reference path="filtering.ts"/>
/// <reference path="sorting.ts"/>
/// <reference path="arrayDataView.ts"/>
var wijmo;
(function (wijmo) {
    (function (_data) {
        var $ = jQuery;

        

        

        

        

        

        

        

        

        

        

        

        var dataViewFactories = [];

        /** Registers a new IDataView provider.
        * @param {IDataViewFactory} factory A function that creates a IDataView for a data source if possible. Otherwise returns null.
        * @returns An IDisposable that can be used to remove the registration.
        * @remarks
        * Use this method to provide your own IDataView implementation for a specific data source. See wijmo.data.breeze.ts for an example.
        */
        function registerDataViewFactory(factory) {
            if (!$.isFunction(factory)) {
                _data.errors.argument("factory");
            }
            dataViewFactories.push(factory);
            return {
                dispose: function () {
                    _data.util.remove(dataViewFactories, factory);
                }
            };
        }
        _data.registerDataViewFactory = registerDataViewFactory;

        registerDataViewFactory(function (view) {
            return isDataView(view) && view;
        });
        registerDataViewFactory(function (array) {
            return $.isArray(array) && new _data.ArrayDataView(array);
        });

        //#endregion Data view factories
        /** Creates an IDataView for a data source.
        * @param src A data source, can be anything that is supported by the registered IDataView providers
        * @returns An IDataView instance for the data source.
        */
        function asDataView(src) {
            if (isDataView(src))
                return src;
            var view = _data.util.some(dataViewFactories, function (p) {
                return p(src);
            });
            return view || _data.errors.unsupportedDataSource();
        }
        _data.asDataView = asDataView;

        /** Returns true if the view parameter is a IDataView */
        function isDataView(view) {
            return view && $.isFunction(view.count) && $.isFunction(view.item) && $.isFunction(view.getProperty);
        }
        _data.isDataView = isDataView;
    })(wijmo.data || (wijmo.data = {}));
    var data = wijmo.data;
})(wijmo || (wijmo = {}));
/// <reference path="core.ts"/>
/// <reference path="arrayDataView.ts"/>
var wijmo;
(function (wijmo) {
    /** @ignore */
    (function (data) {
        var $ = jQuery;

        var CurrencyManager = (function () {
            function CurrencyManager(array) {
                this.array = array;
                this.currentItem = data.observableWithNewValueCheck(null);
                this.currentPosition = data.observableWithNewValueCheck(-1);
                var syncing = false;
                function synced(fn) {
                    return function () {
                        if (syncing)
                            return;
                        syncing = true;
                        try  {
                            fn.apply(this, arguments);
                        } finally {
                            syncing = false;
                        }
                    };
                }

                this.currentItem.subscribe(synced(function (value) {
                    this.currentPosition(value == null ? -1 : $.inArray(value, this.array));
                }), this);

                this.currentPosition.subscribe(synced(function (value) {
                    if (!data.util.isNumeric(value))
                        data.errors.argument("value");
                    if (value < -1 || value >= this.array.length)
                        data.errors.indexOutOfBounds();
                    this.currentItem(value < 0 ? null : this.array[value]);
                }), this);
            }
            CurrencyManager.prototype.update = function () {
                var item = this.currentItem(), pos = this.currentPosition(), newIndex = $.inArray(item, this.array);

                if (newIndex < 0 && item == null && this._recentlyRemovedItem != null) {
                    newIndex = $.inArray(this._recentlyRemovedItem, this.array);
                }

                if (newIndex >= 0) {
                    if (item) {
                        this._recentlyRemovedItem = item;
                    }
                    this.currentPosition(newIndex);
                } else if (pos >= 0 && pos < this.array.length) {
                    this.currentItem(this.array[pos]);
                } else if (pos >= this.array.length && this.array.length > 0) {
                    pos = this.array.length - 1;
                    this.currentPosition(pos);
                    this.currentItem(this.array[pos]);
                } else {
                    this.currentPosition(-1);
                    this.currentItem(null);
                }
            };
            CurrencyManager.prototype.updateDelayed = function () {
                data.util.executeDelayed(this.update, this);
            };
            return CurrencyManager;
        })();
        data.CurrencyManager = CurrencyManager;
    })(wijmo.data || (wijmo.data = {}));
    var data = wijmo.data;
})(wijmo || (wijmo = {}));
/// <reference path="core.ts"/>
/// <reference path="errors.ts"/>
/// <reference path="dataView.ts"/>
/// <reference path="observable.ts"/>
/// <reference path="currency.ts"/>

var wijmo;
(function (wijmo) {
    (function (data) {
        var $ = jQuery;

        /** @ignore */
        var Shape = (function () {
            function Shape(onChanged) {
                this.onChanged = onChanged;
                this.filter = data.observable();
                this._compiledFilter = data.filtering.compile(null);
                this.sort = data.observable();
                this._compiledSort = data.sorting.compile(null);
                this.pageIndex = data.observable(0);
                this.pageSize = data.observable(0);
                this._skip = 0;
                this._take = -1;
                this.filter.subscribe(function (newValue) {
                    this.onFilterChanged(newValue);
                    onChanged();
                }, this);
                this.sort.subscribe(function () {
                    this._compiledSort = data.sorting.compile(this.sort());
                    onChanged();
                }, this);

                function updatePaging() {
                    if (this.pageSize() > 0 && this.pageIndex() >= 0) {
                        this._skip = this.pageSize() * this.pageIndex();
                        this._take = this.pageSize();
                    } else {
                        this._skip = 0;
                        this._take = -1;
                    }
                    onChanged(true);
                }
                this.pageIndex.subscribe(updatePaging, this);
                this.pageSize.subscribe(updatePaging, this);
            }
            Shape.prototype.onFilterChanged = function (newValue) {
                this._compiledFilter = data.filtering.compile(newValue);
            };
            Shape.prototype.setFilter = function (filter) {
                this.filter(filter);
            };

            Shape.prototype.update = function (shape) {
                if ("filter" in shape) {
                    this.setFilter(shape.filter);
                }
                if ("sort" in shape) {
                    this.sort(shape.sort);
                }
                if ("pageSize" in shape) {
                    this.pageSize(shape.pageSize);
                }
                if ("pageIndex" in shape) {
                    this.pageIndex(shape.pageIndex);
                }
            };

            Shape.prototype.apply = function (array, applyPaging, destination) {
                if (typeof applyPaging === "undefined") { applyPaging = true; }
                if (typeof destination === "undefined") { destination = null; }
                var i;

                // filter
                if (!this._compiledFilter.isEmpty) {
                    if (destination) {
                        destination.length = 0;
                    } else {
                        destination = [];
                    }
                    for (i = 0; i < array.length; i++) {
                        var item = array[i];
                        if (this._compiledFilter.func(item)) {
                            destination.push(item);
                        }
                    }
                } else {
                    // just clone it
                    if (!destination) {
                        destination = array.slice(0);
                    } else {
                        destination.length = array.length;
                        for (i = 0; i < array.length; i++) {
                            destination[i] = array[i];
                        }
                    }
                }

                // sort
                if (!this._compiledSort.isEmpty) {
                    this._stableSort(destination, this._compiledSort.compare);
                }

                // page
                var totalCount = destination.length;
                if (applyPaging && this._take > 0) {
                    if (this._skip > 0) {
                        destination.splice(0, Math.min(this._skip, destination.length));
                    }
                    if (this._take < destination.length) {
                        destination.length = this._take;
                    }
                }

                return { results: destination, totalCount: totalCount };
            };

            Shape.prototype._stableSort = function (arr, fn) {
                var isChrome = /chrom(e|ium)/.test(navigator.userAgent.toLowerCase()) && /Google Inc/.test(navigator.vendor);
                if (fn && isChrome) {
                    arr.forEach(function (ele, index) {
                        arr[index] = { index: index, value: ele };
                    });
                    arr.sort(function (c, d) {
                        var result = fn(c.value, d.value);
                        if (result === 0) {
                            return c.index - d.index;
                        }
                        return result;
                    });
                    arr.forEach(function (ele, index) {
                        arr[index] = ele.value;
                    });
                } else {
                    arr.sort(fn);
                }
            };

            Shape.prototype.toObj = function () {
                return {
                    filter: this._compiledFilter.normalized,
                    sort: this._compiledSort.normalized,
                    pageSize: this.pageSize(),
                    pageIndex: this.pageIndex()
                };
            };
            return Shape;
        })();
        data.Shape = Shape;

        var ArrayDataViewBase = (function () {
            function ArrayDataViewBase(shape) {
                this.isRemote = false;
                this.localPaging = true;
                //#region items
                /**
                * The element array of current view after client-side filtering/sorting/paging have been applied.
                */
                this.local = [];
                this._updatingShape = false;
                this._pageCount = data.observable(1);
                this._totalItemCount = data.numericObservable(0);
                //#endregion shape
                //#region loading
                this._isLoaded = data.observable(false);
                this._isLoading = data.observable(false);
                //#endregionn
                //#region editing
                this._currentEditItem = data.observable();
                this._isCurrentEditItemNew = false;
                this._currentEditItemSnapshot = null;
                this.isLoading = this._isLoading.read();
                this.isLoaded = this._isLoaded.read();
                this._changed = new data.Subscribable(this);

                this.currentEditItem = this._currentEditItem.read();
                this._initCurrency();
                this._initShape(shape);
            }
            /**
            * @ ignore
            */
            ArrayDataViewBase.prototype.dispose = function () {
            };

            /**
            * Returns the number of items in the current view after client-side filtering/sorting/paging have been applied.
            */
            ArrayDataViewBase.prototype.count = function () {
                return this.local.length;
            };

            /**
            * Returns an element in the view by index.
            * @ param {Number} index The zero-based index of the element to get
            * @ remarks Throws an exception if the index is out of range
            */
            ArrayDataViewBase.prototype.item = function (index) {
                if (index < 0 || index >= this.local.length) {
                    data.errors.indexOutOfBounds();
                }
                return this.local[index];
            };

            /**
            * Returns the index of the element in current view
            * @ param {object} item The element in current view.
            */
            ArrayDataViewBase.prototype.indexOf = function (item) {
                return $.inArray(item, this.local);
            };

            /**
            * Returns the element array before applying client-side filtering/sorting/paging.
            * @remarks In the case of a remote data source, usually it is the array returned by a server.
            */
            ArrayDataViewBase.prototype.getSource = function () {
                return this.sourceArray;
            };

            /**
            * Converts the element array of current view after filter, sort and paging have been applied to Obervable Array.
            */
            ArrayDataViewBase.prototype.toObservableArray = function () {
                if (!this._koArray) {
                    this._koArray = ko.observableArray(this.local);
                }
                return this._koArray;
            };

            //#endregion items
            //#region properties
            ArrayDataViewBase._getProps = function (item) {
                var cols = [];
                data.util.each(item, function (key, value) {
                    key = String(key);
                    if (key.match(/^_/))
                        return;
                    if ($.isFunction(value) && !value.subscribe)
                        return;
                    cols.push({ name: key });
                });
                return cols;
            };

            /**
            * Returns properties for elements in the view.
            */
            ArrayDataViewBase.prototype.getProperties = function () {
                return this.count() ? ArrayDataViewBase._getProps(this.item(0)) : [];
            };

            ArrayDataViewBase.prototype._readProperty = function (item, property) {
                return data.util.getProperty(item, property);
            };

            /**
            * Returns the current value of the property in the element at the specified index.
            * @ param {Object} itemOrIndex The element with the property value that is to be read
            * or the zero-based index of the element with the property value that is to be read.
            * @ param {string} property The name of the property to read
            * @ returns The current value of the property in the element
            */
            ArrayDataViewBase.prototype.getProperty = function (itemOrIndex, property) {
                var item = this._getItem(itemOrIndex);
                return this._readProperty(item, property);
            };
            ArrayDataViewBase.prototype._writeProperty = function (item, property, newValue) {
                data.util.setProperty(item, property, newValue);
            };

            /**
            * Sets the value of the property in the element.
            * @ param {Object} itemOrIndex The element with the property value that is to be read
            * or the zero-based index of the element with the property value that is to be read.
            * @ param {string} property The name of the property to set
            * @ param newValue The new value
            * @ remarks
            * If the class implementing IDataView also implements IEditableDataView and the element is being edited,
            * then the property value change is done within the editing transaction.
            */
            ArrayDataViewBase.prototype.setProperty = function (itemOrIndex, property, newValue) {
                var item = this._getItem(itemOrIndex);

                if (item === this.currentEditItem() && this._currentEditItemSnapshot && !(property in this._currentEditItemSnapshot)) {
                    this._currentEditItemSnapshot[property] = this.getProperty(itemOrIndex, property);
                }

                this._writeProperty(item, property, newValue);

                return this;
            };

            /**
            * Registers Subcription of changes for current view.
            * @ param {function} handler Function that will be called when current view is changed.
            * @ param {Object?} context Indicates which calls the handler function.
            */
            ArrayDataViewBase.prototype.subscribe = function (handler, context) {
                return this._changed.subscribe(handler, context);
            };

            /**
            * Triggers the changes for current view.
            */
            ArrayDataViewBase.prototype.trigger = function () {
                this._currencyManager.update();
                this._changed.trigger(this.local);
                if (this._koArray) {
                    this._koArray.notifySubscribers(this.local);
                }
            };

            /**
            * Returns a value that indicates whether the data view supports filtering.
            */
            ArrayDataViewBase.prototype.canFilter = function () {
                return true;
            };

            /**
            * Returns a value that indicates whether the data view supports sorting.
            */
            ArrayDataViewBase.prototype.canSort = function () {
                return true;
            };

            ArrayDataViewBase.prototype._updateShape = function (shape) {
                this._updatingShape = true;
                try  {
                    this._shape.update(shape);
                } finally {
                    this._updatingShape = false;
                }
            };

            /*
            * Goes to previous page of current view if paging has been applied.
            * @ remarks
            * If current page is the first page, it will return false.
            * Otherwise it will return true.
            */
            ArrayDataViewBase.prototype.prevPage = function () {
                if (this.pageIndex() < 1) {
                    return false;
                }
                this.pageIndex(this.pageIndex() - 1);
                return true;
            };

            /*
            * Goes to next page of current view if paging has been applied.
            * @ remarks
            * If current page is the last page, it will return false.
            * Otherwise it will return true.
            */
            ArrayDataViewBase.prototype.nextPage = function () {
                if (this.pageCount() > 0 && this.pageIndex() + 1 >= this.pageCount()) {
                    return false;
                }
                this.pageIndex(this.pageIndex() + 1);
                return true;
            };

            ArrayDataViewBase.prototype._createShape = function (onChanged) {
                return new Shape(onChanged);
            };
            ArrayDataViewBase.prototype._initShape = function (shape) {
                var _this = this;
                var onChanged = function (onlyPaging) {
                    if (typeof onlyPaging === "undefined") { onlyPaging = false; }
                    if (!_this._updatingShape) {
                        _this.refresh(null, onlyPaging && _this.localPaging);
                    }
                };

                this._shape = this._createShape(onChanged);
                if (shape) {
                    this._updateShape(shape);
                }
                this.filter = this._shape.filter;
                this.sort = this._shape.sort;
                this.pageIndex = this._shape.pageIndex;
                this.pageSize = this._shape.pageSize;
                this.pageCount = this._pageCount.read();
                this.totalItemCount = this._totalItemCount.read();
            };

            ArrayDataViewBase.prototype._localRefresh = function (doPaging) {
                if (typeof doPaging === "undefined") { doPaging = this.localPaging; }
                var result = this._shape.apply(this.sourceArray, doPaging, this.local);

                if (doPaging) {
                    this._totalItemCount(result.totalCount);
                }
                this._pageCount(data.util.pageCount(this.totalItemCount(), this.pageSize()));

                // notify
                this.trigger();
                return $.Deferred().resolve().promise();
            };
            ArrayDataViewBase.prototype._remoteRefresh = function () {
                return this._localRefresh();
            };

            /** Reloads the data view.
            *
            * @ param {IShape} shape
            * Settings for filtering, sorting and/or paging to be applied before loading.
            *
            * In contrast to filter/sort properties in IDataView,
            * the format of properties in the shape parameter does not have to follow the specs defined in IDataView.
            * For instance, BreezeDataView accepts a Breeze.Predicate as shape.filter.
            * However the IDataView properties must not violate the IDataView specs. If a custom filter format cannot be aligned to the IDataView specs,
            * then the properties values must be functions or null.
            *
            * @ param {boolean} local Prevents server requests and applies filtering/sorting/paging of the source array on the client-side.
            *
            * @ returns {IRefreshResult} A promise object that can be used to receive notification of asynchronous refresh completion or failure.
            *
            * @ remarks
            * Depending on the implementation, data can be loaded from a local or a remote data source.
            * The implementation transaltes filtering/sorting/paging defined in the IDataView to the data provider specific format.
            * If it is possible, then the data is reshaped on the client-side.
            *
            * The optional shape parameter can be used to change multiple filtering/sorting/paging settings at a time to avoid unnecessary refreshes.
            *
            * During the refresh, the isLoading property value must be true. After a successful refresh, the isLoaded property value must be true.
            *
            * When the method is called, the pending refresh, if any, is canceled.
            */
            ArrayDataViewBase.prototype.refresh = function (shape, local) {
                var _this = this;
                if (typeof local === "undefined") { local = false; }
                this.cancelRefresh();
                if (shape) {
                    this._updateShape(shape);
                }
                this._isLoading(true);
                var promise = local ? this._localRefresh() : this._remoteRefresh();
                return promise.then(function () {
                    _this._isLoaded(true);
                    _this._isLoading(false);
                });
            };

            /**
            * Cancels the ongoing refresh operation
            */
            ArrayDataViewBase.prototype.cancelRefresh = function () {
            };

            ArrayDataViewBase.prototype._initCurrency = function () {
                this._currencyManager = new data.CurrencyManager(this.local);
                this.currentItem = this._currencyManager.currentItem;
                this.currentPosition = this._currencyManager.currentPosition;
            };

            /**
            * Returns a value indicating whether the element being edited is added by the add(item) methods.
            */
            ArrayDataViewBase.prototype.isCurrentEditItemNew = function () {
                return this._isCurrentEditItemNew;
            };

            ArrayDataViewBase.prototype._beginEdit = function (item, isNew) {
                this.commitEdit();
                this._currentEditItemSnapshot = {};
                this._isCurrentEditItemNew = isNew;
                this._currentEditItem(item);
            };

            /**
            * Returns a value that indicates whether the add(item) method is implemented.
            */
            ArrayDataViewBase.prototype.canAdd = function () {
                return true;
            };

            /**
            * Adds a new element and marks it as being edited.
            * @ param {Object} item The item to add.
            * @ remarks
            * Adds a new element to the data view, but not to the underlying data source.
            * Commits the element currently being edited, if any.
            */
            ArrayDataViewBase.prototype.add = function (item) {
                if (!item)
                    data.errors.argument("item");
                this.commitEdit();
                this.local.push(item);
                this._beginEdit(item, true);
                this.trigger();
            };

            /**
            * Returns a value that indicates whether the addNew() method is implemented.
            */
            ArrayDataViewBase.prototype.canAddNew = function () {
                return false;
            };

            /*
            * @ignore
            */
            ArrayDataViewBase.prototype.addNew = function () {
                return data.errors.unsupportedOperation();
            };

            /**
            * Starts editing of an element at the index.
            * @ param {Object} element The element to edit.
            * Defaults to the value of IDataView.currentItem property.
            * @ remarks
            * Commits the element currently being edited, if any.
            */
            ArrayDataViewBase.prototype.editItem = function (item) {
                if (typeof item === "undefined") { item = this.currentItem(); }
                this.commitEdit();

                item = this._getItem(item);
                if (item) {
                    this._beginEdit(item, false);
                }
            };

            /**
            * Returns a value that indicates whether the remove method overloads are implemented.
            */
            ArrayDataViewBase.prototype.canRemove = function () {
                return true;
            };
            ArrayDataViewBase.prototype._remove = function (entry) {
                this.local.splice(entry.index, 1);
                data.util.remove(this.sourceArray, entry.item);
                this._totalItemCount.dec();
                this.trigger();
            };

            /**
            * Removes an element at the specified index.
            * @ param {Object} item The element to remove.
            * Defaults to the value of the IDataView.currentItem property.
            * @ remarks
            * If the element success removing, it will return true.
            * Otherwise it will return false.
            */
            ArrayDataViewBase.prototype.remove = function (item) {
                if (typeof item === "undefined") { item = this.currentItem(); }
                this.commitEdit();

                var entry = this._resolve(item);
                if (!entry)
                    return false;
                this._remove(entry);
                return true;
            };

            /**
            * Returns a value that indicates whether the current changes can be canceled.
            */
            ArrayDataViewBase.prototype.canCancelEdit = function () {
                return true;
            };

            /**
            * Cancels the changes made to the currently editing element since the editing was started.
            * @ remarks After a successful cancelation, the currentEditItem property value must be null.
            */
            ArrayDataViewBase.prototype.cancelEdit = function () {
                var _this = this;
                var key;
                if (!this.currentEditItem())
                    return;
                var item = this.currentEditItem();
                this._currentEditItem(null);

                if (this._isCurrentEditItemNew) {
                    data.util.remove(this.local, item);
                } else if (this._currentEditItemSnapshot) {
                    $.each(this._currentEditItemSnapshot, function (k, v) {
                        return _this._writeProperty(item, k, v);
                    });
                }
                this.trigger();
            };

            /**
            * Returns a value that indicates whether the current changes can be committed
            */
            ArrayDataViewBase.prototype.canCommitEdit = function () {
                return true;
            };

            /**
            * Commits the changes made to the currently editing element
            * @ remarks After a successful commit, the currentEditItem property value must be null.
            * If the item being edited was new, it is added to the underlying data source.
            * If the element does not satisfy the filter, then it is removed from the data view, but not from the data source.
            */
            ArrayDataViewBase.prototype.commitEdit = function () {
                if (!this.currentEditItem())
                    return;
                var item = this.currentEditItem();
                this._currentEditItem(null);

                if (this._isCurrentEditItemNew) {
                    this.sourceArray.push(item);
                    this._totalItemCount.inc();
                }

                var filter = this._shape._compiledFilter;
                if (!filter.isEmpty && !filter.func(item)) {
                    data.util.remove(this.local, item);
                }
                this.trigger();
            };

            //#endregion editing
            ArrayDataViewBase.prototype._getItem = function (itemOrIndex) {
                var index;
                if (data.util.isNumeric(itemOrIndex)) {
                    return this.item(itemOrIndex);
                } else {
                    return itemOrIndex;
                }
            };

            ArrayDataViewBase.prototype._resolve = function (itemOrIndex, raiseIfNotContained) {
                if (typeof raiseIfNotContained === "undefined") { raiseIfNotContained = false; }
                var index;
                if (data.util.isNumeric(itemOrIndex)) {
                    return {
                        index: itemOrIndex,
                        item: this.item(itemOrIndex)
                    };
                } else {
                    index = this.indexOf(itemOrIndex);
                    if (index < 0) {
                        if (raiseIfNotContained)
                            data.errors.itemNotInView(itemOrIndex);
                        return null;
                    }
                    return {
                        index: index,
                        item: itemOrIndex
                    };
                }
            };

            /** @ignore */
            ArrayDataViewBase.prototype.clone = function () {
                throw "Not supported.";
            };
            return ArrayDataViewBase;
        })();
        data.ArrayDataViewBase = ArrayDataViewBase;

        
        var ArrayDataView = (function (_super) {
            __extends(ArrayDataView, _super);
            function ArrayDataView(source, shape) {
                _super.call(this, shape);
                this.sourceArray = source;
                this.refresh();
            }
            /** @ignore */
            ArrayDataView.prototype.clone = function () {
                var shape = this._shape ? this._shape.toObj() : undefined;
                return new ArrayDataView(this.getSource(), shape);
            };
            return ArrayDataView;
        })(ArrayDataViewBase);
        data.ArrayDataView = ArrayDataView;
    })(wijmo.data || (wijmo.data = {}));
    var data = wijmo.data;
})(wijmo || (wijmo = {}));
//interface NavigatorID {
//    vendor: string;
//}
/// <reference path="arrayDataView.ts"/>
var wijmo;
(function (wijmo) {
    (function (data) {
        var $ = jQuery;

        var RemoteDataView = (function (_super) {
            __extends(RemoteDataView, _super);
            function RemoteDataView(options) {
                _super.call(this);
                this.isRemote = true;
                this.sourceArray = [];
                if (options) {
                    this._construct(options);
                }
            }
            RemoteDataView.prototype._construct = function (options) {
                this.options = options = $.extend({
                    localPaging: false
                }, options);
                this.localPaging = options.localPaging;
                this._updateShape(options);
            };
            return RemoteDataView;
        })(data.ArrayDataViewBase);
        data.RemoteDataView = RemoteDataView;
    })(wijmo.data || (wijmo.data = {}));
    var data = wijmo.data;
})(wijmo || (wijmo = {}));
;
/// <reference path="src/arrayDataView.ts"/>
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var wijmo;
(function (wijmo) {
    /*globals jQuery, Globalize, wijmo */
    /*
    * Depends:
    *  wijmo.data.js
    *  globalize.js
    *  jquery.js
    *
    */
    (function (_data) {
        var $ = jQuery;

        var wijdatasourceReader = (function () {
            function wijdatasourceReader(originalReader) {
                this._originalReader = originalReader;
            }
            wijdatasourceReader.prototype.read = function (wijDataSource) {
                wijDataSource.items = null;

                if (this._originalReader && $.isFunction(this._originalReader.read)) {
                    this._originalReader.read(wijDataSource);
                }

                if (!$.isArray(wijDataSource.items)) {
                    if ($.isArray(wijDataSource.data)) {
                        wijDataSource.items = wijDataSource.data;
                    } else if (wijDataSource.data && $.isArray(wijDataSource.data.rows)) {
                        wijDataSource.items = wijDataSource.data.rows; // remoteDynamical
                    } else {
                        wijDataSource.items = [];
                    }
                }

                if (wijDataSource.dynamic) {
                    if (!wijDataSource.data || isNaN(wijDataSource.data.totalRows)) {
                        throw "totalRows value is missing";
                    }
                }
            };
            return wijdatasourceReader;
        })();

        var WijdatasourceView = (function (_super) {
            __extends(WijdatasourceView, _super);
            function WijdatasourceView(dataSource) {
                var _this = this;
                _super.call(this);
                this.dataSource = dataSource;
                this.isRemote = true;
                this.localPaging = true;

                this._origLoaded = dataSource.loaded;
                this._origReader = dataSource.reader;

                dataSource.loaded = function (e, data) {
                    _this._loaded();
                    if ($.isFunction(_this._origLoaded)) {
                        _this._origLoaded.apply(_this, arguments);
                    }
                };

                dataSource.reader = new wijdatasourceReader(dataSource.reader);

                var hasItems = dataSource.items && dataSource.items.length > 0;
                if ($.isArray(dataSource.data) && !hasItems) {
                    dataSource.read();
                }

                if (dataSource.items) {
                    this._loaded();
                }
            }
            WijdatasourceView.prototype.dispose = function () {
                this.dataSource.loaded = this._origLoaded;
                this.dataSource.reader = this._origReader;
                _super.prototype.dispose.call(this);
            };

            WijdatasourceView.prototype.getProperties = function () {
                return this.sourceArray && this.sourceArray.length ? _data.ArrayDataViewBase._getProps(this.sourceArray[0]) : [];
            };
            WijdatasourceView.prototype._loaded = function () {
                this.sourceArray = this.dataSource.items;
                if (this.dataSource.data && _data.util.isNumeric(this.dataSource.data.totalRows)) {
                    this._totalItemCount(this.dataSource.data.totalRows);
                }
                var def = _super.prototype._localRefresh.call(this, !this.dataSource.dynamic);
                if (this._currentDeferred) {
                    def.then(this._currentDeferred.resolve);
                }
            };

            WijdatasourceView.prototype._remoteRefresh = function () {
                if (this._currentDeferred && this._currentDeferred.state() === "pending") {
                    this._currentDeferred.fail();
                }
                this._currentDeferred = $.Deferred();

                var userData = {}, forceReload = false;

                if (this.dataSource.dynamic) {
                    forceReload = true;
                    userData.data = this._prepareRequest();
                    if (this.dataSource.proxy) {
                        if (!this._origDataOption) {
                            this._origDataOption = $.extend({}, this.dataSource.proxy.options.data);
                        }
                        this.dataSource.proxy.options.data = $.extend({}, this._origDataOption, userData.data);
                    }
                }

                this.dataSource.load(userData, forceReload);
                return this._currentDeferred;
            };

            WijdatasourceView.prototype._prepareRequest = function () {
                return {
                    filtering: this._prepareFilterRequest(),
                    paging: this._preparePageRequest(),
                    sorting: this._prepareSortRequest()
                };
            };

            WijdatasourceView.prototype._prepareFilterRequest = function () {
                var result = [];

                if (!this._shape._compiledFilter.isEmpty && this._shape._compiledFilter.normalized) {
                    $.each(this._shape._compiledFilter.normalized, function (prop, cond) {
                        result.push({
                            dataKey: prop,
                            filterOperator: cond.op.Name,
                            filterValue: cond.value
                        });
                    });
                }

                return result;
            };

            WijdatasourceView.prototype._preparePageRequest = function () {
                return {
                    pageIndex: this._shape.pageIndex(),
                    pageSize: this._shape.pageSize()
                };
            };

            WijdatasourceView.prototype._prepareSortRequest = function () {
                if (this._shape._compiledSort.isEmpty || !this._shape._compiledSort.normalized || this._shape._compiledSort.normalized.length == 0) {
                    return [];
                }

                return $.map(this._shape._compiledSort.normalized, function (sd) {
                    return {
                        dataKey: sd.property,
                        sortDirection: sd.asc ? "ascending" : "descending"
                    };
                });
            };
            return WijdatasourceView;
        })(_data.ArrayDataViewBase);

        _data.registerDataViewFactory(function (wds) {
            if (typeof wijdatasource !== "function" || !(wds instanceof wijdatasource))
                return;
            return new WijdatasourceView(wds);
        });
    })(wijmo.data || (wijmo.data = {}));
    var data = wijmo.data;
})(wijmo || (wijmo = {}));
;
/// <reference path="../Base/jquery.wijmo.widget.ts"/>
/*globals jQuery*/
/*jslint white: false */
/*
* Depends:
*  jquery-1.11.1.js
*  jquery.ui.core.js
*  jquery.ui.widget.js
*  jquery.wijmo.widget.js
*/
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var wijmo;
(function (wijmo) {
    (function (pager) {
        var $ = jQuery;

        /** @widget */
        var wijpager = (function (_super) {
            __extends(wijpager, _super);
            function wijpager() {
                _super.apply(this, arguments);
            }
            wijpager.prototype._create = function () {
                var o = this.options;
                if (window.wijmoApplyWijTouchUtilEvents) {
                    $ = window.wijmoApplyWijTouchUtilEvents($);
                }

                this.element.addClass(this.options.wijCSS.widget + " wijmo-wijpager " + this.options.wijCSS.helperClearFix);

                this._refresh();
                _super.prototype._create.call(this);
            };

            wijpager.prototype._destroy = function () {
                this.element.removeClass(this.options.wijCSS.widget + " wijmo-wijpager " + this.options.wijCSS.helperClearFix);
                this.$ul.remove();
            };

            wijpager.prototype._setOption = function (key, value) {
                this._super(key, value);
                this._refresh();
            };

            wijpager.prototype._refresh = function () {
                this._validate();

                if (this.$ul) {
                    this.$ul.remove();
                }

                this.element.append(this.$ul = $("<ul class=\"ui-list " + this.options.wijCSS.cornerAll + " " + this.options.wijCSS.content + " " + this.options.wijCSS.helperClearFix + "\" role=\"tablist\"></ul>"));

                switch ((this.options.mode || "").toLowerCase()) {
                    case "nextprevious":
                        this._createNextPrev(false);
                        break;

                    case "nextpreviousfirstlast":
                        this._createNextPrev(true);
                        break;

                    case "numeric":
                        this._createNumeric(false);
                        break;

                    case "numericfirstlast":
                        this._createNumeric(true);
                        break;
                }
            };

            wijpager.prototype._validate = function () {
                var o = this.options;

                if (isNaN(o.pageCount) || o.pageCount < 1) {
                    o.pageCount = 1;
                }

                if (isNaN(o.pageIndex) || o.pageIndex < 0) {
                    o.pageIndex = 0;
                } else {
                    if (o.pageIndex >= o.pageCount) {
                        o.pageIndex = o.pageCount - 1;
                    }
                }

                if (isNaN(o.pageButtonCount) || o.pageButtonCount < 1) {
                    o.pageButtonCount = 1;
                }
            };

            wijpager.prototype._createNextPrev = function (addFirstLast) {
                var o = this.options, firstPageClass = !!o.firstPageClass ? o.firstPageClass + " " + o.wijCSS.iconSeekFirst : "", previousPageClass = !!o.previousPageClass ? o.previousPageClass + " " + o.wijCSS.iconSeekPrev : "", nextPageClass = !!o.nextPageClass ? o.nextPageClass + " " + o.wijCSS.iconSeekNext : "", lastPageClass = !!o.lastPageClass ? o.lastPageClass + " " + o.wijCSS.iconSeekEnd : "";

                // first button
                if (addFirstLast && o.pageIndex) {
                    this.$ul.append(this._createPagerItem(false, o.firstPageText, 1, firstPageClass));
                }

                // previous button
                if (o.pageIndex) {
                    this.$ul.append(this._createPagerItem(false, o.previousPageText, o.pageIndex, previousPageClass));
                }

                // next button
                if (o.pageIndex + 1 < o.pageCount) {
                    this.$ul.append(this._createPagerItem(false, o.nextPageText, o.pageIndex + 2, nextPageClass));
                }

                // last button
                if (addFirstLast && (o.pageIndex + 1 < o.pageCount)) {
                    this.$ul.append(this._createPagerItem(false, o.lastPageText, o.pageCount, lastPageClass));
                }
            };

            wijpager.prototype._createNumeric = function (addFirstLast) {
                var o = this.options, currentPage = o.pageIndex + 1, startPageNumber = 1, endPageNumber = Math.min(o.pageCount, o.pageButtonCount), i, firstPageClass = !!o.firstPageClass ? o.firstPageClass + " " + o.wijCSS.iconSeekFirst : "", lastPageClass = !!o.lastPageClass ? o.lastPageClass + " " + o.wijCSS.iconSeekEnd : "";

                if (currentPage > endPageNumber) {
                    startPageNumber = (Math.floor(o.pageIndex / o.pageButtonCount)) * o.pageButtonCount + 1;

                    endPageNumber = startPageNumber + o.pageButtonCount - 1;
                    endPageNumber = Math.min(endPageNumber, o.pageCount);

                    if (endPageNumber - startPageNumber + 1 < o.pageButtonCount) {
                        startPageNumber = Math.max(1, endPageNumber - o.pageButtonCount + 1);
                    }
                }

                // first + "..." buttons
                if (startPageNumber !== 1) {
                    // first button
                    if (addFirstLast) {
                        this.$ul.append(this._createPagerItem(false, o.firstPageText, 1, firstPageClass));
                    }

                    // "..." button
                    this.$ul.append(this._createPagerItem(false, "...", startPageNumber - 1, ""));
                }

                for (i = startPageNumber; i <= endPageNumber; i++) {
                    this.$ul.append(this._createPagerItem(i === currentPage, i.toString(), i, ""));
                }

                // "..." + last buttons
                if (o.pageCount > endPageNumber) {
                    this.$ul.append(this._createPagerItem(false, "...", endPageNumber + 1, ""));

                    // last button
                    if (addFirstLast) {
                        this.$ul.append(this._createPagerItem(false, o.lastPageText, o.pageCount, lastPageClass));
                    }
                }
            };

            wijpager.prototype._createPagerItem = function (active, title, pageIndex, btnClass) {
                var btnContent, wijCSS = this.options.wijCSS, self = this, $li = $("<li />").addClass(wijCSS.pagerButton + " " + wijCSS.cornerAll).attr({ "role": "tab", "title": title });

                try  {
                    $li.attr("aria-label", title); // throws "member not found" exception in IE10\11 if IE7 compatibility mode is used.
                } catch (ex) {
                }

                if (active) {
                    $li.addClass(wijCSS.stateActive).attr("aria-selected", "true");
                } else {
                    $li.addClass(wijCSS.stateDefault).hover(function () {
                        if (!self._isDisabled()) {
                            $(this).addClass(wijCSS.stateHover);
                        }
                    }, function () {
                        if (!self._isDisabled()) {
                            $(this).removeClass(wijCSS.stateHover);
                        }
                    }).bind("click." + this.widgetName, { newPageIndex: pageIndex - 1 }, $.proxy(this._onClick, this)); // pageIndex is 1-based.
                }

                if (active) {
                    btnContent = $("<span />");
                } else {
                    btnContent = btnClass ? $("<span />").addClass(wijCSS.icon + " " + btnClass) : $("<a/>").attr("href", "#");
                }

                btnContent.text(title);

                $li.append(btnContent);

                return $li;
            };

            wijpager.prototype._onClick = function (arg) {
                if (this._isDisabled()) {
                    return false;
                }

                var pagingArgs = { newPageIndex: arg.data.newPageIndex, handled: false };

                if (this._trigger("pageIndexChanging", null, pagingArgs) !== false) {
                    if (this.options.pageIndex !== pagingArgs.newPageIndex) {
                        this.options.pageIndex = pagingArgs.newPageIndex;
                        if (!pagingArgs.handled) {
                            this._refresh();
                        }

                        var pagedArgs = { newPageIndex: pagingArgs.newPageIndex };
                        this._trigger("pageIndexChanged", null, pagedArgs);
                    }
                }

                return false;
            };
            return wijpager;
        })(wijmo.wijmoWidget);
        pager.wijpager = wijpager;

        wijpager.prototype.widgetEventPrefix = "wijpager";

        var wijpager_options = (function () {
            function wijpager_options() {
                /** @ignore */
                this.wijCSS = {
                    pagerButton: "wijmo-wijpager-button"
                };
                /** @ignore */
                this.wijMobileCSS = {
                    header: "ui-header ui-bar-a",
                    content: "ui-body-b",
                    stateDefault: "ui-btn ui-btn-b",
                    stateHover: "ui-btn-down-b",
                    stateActive: "ui-btn-down-c"
                };
                /**
                * An option that indicates the class of the first-page button. You can set this option with any of the jQuery UI CSS Framework icons.
                * @default "ui-icon-seek-first"
                * @example
                * // Here's the general way you'll set the option:
                * $("#element").wijpager({
                *    firstPageClass: "ui-icon-seek-first"
                * });
                */
                this.firstPageClass = $.wijmo.widget.prototype.options.wijCSS.iconSeekFirst;
                /**
                * An option that indicates the text to display for the first-page button. The text will display like a tooltip when a user hovers over the first-page button.
                * @example
                * // Here's the general way you'll set the option:
                * $("#element").wijpager({
                *    firstPageText: "Go To First"
                * });
                */
                this.firstPageText = "First";
                /**
                * An option that indicates the class of the last-page button. You can set this option with any of the jQuery UI CSS Framework icons.
                * @default "ui-icon-seek-end"
                * @example
                * // Here's the general way you'll set the option:
                * $("#element").wijpager({
                *    lastPageClass: "ui-icon-seek-end"
                * });
                */
                this.lastPageClass = $.wijmo.widget.prototype.options.wijCSS.iconSeekEnd;
                /**
                * An option that indicates the text to display for the last-page button. The text will display like a tooltip when a user hovers over the last-page button.
                * @example
                * // Here's the general way you'll set the option:
                * $("#element").wijpager({
                *   lastPageText: "Go To Last"
                * });
                */
                this.lastPageText = "Last";
                /**
                * This option determines the pager mode. The possible values for this option are: "nextPrevious", "nextPreviousFirstLast", "numeric", "numericFirstLast".
                * @remarks
                * Possible values are: "nextPrevious", "nextPreviousFirstLast", "numeric", "numericFirstLast".
                * "nextPrevious": a set of pagination controls consisting of Previous and Next buttons.
                * "nextPreviousFirstLast": a set of pagination controls consisting of Previous, Next, First, and Last buttons.
                * "numeric": a set of pagination controls consisting of numbered link buttons to access pages directly.
                * "numericFirstLast": a set of pagination controls consisting of numbered and First and Last link buttons.
                * @example
                * // Here's the general way you'll set the option:
                * $("#element").wijpager({
                *    mode: "nextPrevious"
                * });
                */
                this.mode = "numeric";
                /**
                * An option that indicates the class of the next-page button. You can set this option with any of the jQuery UI CSS Framework Icons.
                * @default "ui-icon-seek-next"
                * @example
                * // Here's the general way you'll set the option:
                * $("#element").wijpager({
                *    nextPageClass: "ui-icon-seek-next"
                * });
                */
                this.nextPageClass = $.wijmo.widget.prototype.options.wijCSS.iconSeekNext;
                /**
                * An option that indicates the text to display for the next-page button. The text appears like a tooltip when a user hovers over the next-page button.
                * @example
                * // Here's the general way you'll set the option:
                * $("#element").wijpager({
                *    nextPageText: "Go To Next"
                * });
                */
                this.nextPageText = "Next";
                /**
                * An option that indicates the number of page buttons to display in the pager. You can customize how many page buttons are available for your users to use to page through content.
                * You can use this option in conjunction with the pageCount to customize the pager display.
                * @example
                * // Here's the general way you'll set the option:
                * $("#element").wijpager({
                *    pageButtonCount: 15
                * });
                */
                this.pageButtonCount = 10;
                /**
                * An option that indicates the class of the previous-page button. You can set this option with any of the jQuery UI CSS Framework Icons.
                * @type {string}
                * @default "ui-icon-seek-prev"
                * @example
                * // Here's the general way you'll set the option:
                * $("#element").wijpager({
                *    previousPageClass: "ui-icon-seek-prev"
                * });
                */
                this.previousPageClass = $.wijmo.widget.prototype.options.wijCSS.iconSeekPrev;
                /**
                * An option that indicates the text to display for the previous-page button. The text appears like a tooltip when a user hovers over the previous-page button.
                * @example
                * // Here's the general way you'll set the option:
                * $("#element").wijpager({
                *    previousPageText: "Go To Previous"
                * });
                */
                this.previousPageText = "Previous";
                /**
                * An option that indicates the total number of pages. This option allows you to customize the total number of pages that your users will be able to page through. You can use this option in conjunction with the pageButtonCount to customize the pager display.
                * @example
                * // Here's the general way you'll set the option:
                * $("#element").wijpager({
                *    pageCount: 10
                * });
                */
                this.pageCount = 1;
                /**
                * An option that indicates the zero-based index of the current page. By default, your pager will display with the first pager button highlighted since its index is 0.
                * @example
                * // Here's the general way you'll set the option. This will allow your pager widget to display with the 3rd page button highlighted:
                * $("#element").wijpager({
                *    pageIndex: 2
                * });
                */
                this.pageIndex = 0;
                /**
                * The pageIndexChanging event handler is a function called when page index is changing. This item is cancellable if you return false.
                * @event
                * @param {object} e The jQuery.Event object.
                * @param {wijmo.grid.IPageIndexChangingEventArgs} args The data associated with this event.
                * @example
                * // Supply a callback function to handle the event:
                * $("#element").wijpager({
                *    pageIndexChanging: function (e, args) {
                *       // Handle the event here.
                *    }
                * });
                
                * // Bind to the event by type:
                * $("#element").bind("wijpagerpageindexchanging", function (e, args) {
                *    // Handle the event here.
                * });
                *
                * // You can cancel this event be returning false:
                * $("#element").wijpager({
                *    pageIndexChanging: function(e, args) {
                *       return false;
                *    }
                * });
                */
                this.pageIndexChanging = null;
                /**
                * The pageIndexChanged event handler is a function called when the page index is changed.
                * @event
                * @param {object} e The jQuery.Event object.
                * @param {wijmo.grid.IPageIndexChangedEventArgs} args The data associated with this event.
                * @example
                * // Supply a callback function to handle the event:
                * $("#element").wijpager({
                *    pageIndexChanged: function (e, args) {
                *       // Handle the event here.
                *    }
                * });
                
                * // Bind to the event by type:
                * $("#element").bind("wijpagerpageindexchanged", function (e, args) {
                *    // Handle the event here.
                * });
                *
                * // You can also use this event to get the selected page by using the args.newPageIndex parameter:
                * $("#element").wijpager({
                *    pageIndexChanged: function(e, args) {
                *       var selectedPageIndex = args.newPageIndex;
                *    }
                * });
                */
                this.pageIndexChanged = null;
            }
            return wijpager_options;
        })();
        ;

        wijpager.prototype.options = $.extend(true, {}, wijmo.wijmoWidget.prototype.options, new wijpager_options());

        $.wijmo.registerWidget("wijpager", wijpager.prototype);

        

        

        

        
        ;
    })(wijmo.pager || (wijmo.pager = {}));
    var pager = wijmo.pager;
})(wijmo || (wijmo = {}));

;
/// <reference path="../External/declarations/jquery.d.ts"/>
/// <reference path="../wijutil/jquery.wijmo.wijutil.ts"/>
/// <reference path="../Base/wijmo.d.ts"/>
var wijmo;
(function (wijmo) {
    /*globals jQuery*/
    /*
    * Depends:
    *  jquery.js
    *  jquery-ui.js
    *
    */
    (function (checkbox) {
        var $ = jQuery, wijdatasource, wijarrayreader, wijhttpproxy;

        wijdatasource = function (options) {
            var self = this;

            /// <summary>
            /// The data to process using the wijdatasource class.
            /// Default: {}.
            /// Type: Object.
            /// </summary>
            self.data = {};

            /// <summary>
            /// The reader to use with wijdatasource. The wijdatasource class will call the
            /// read method of reader to read from rawdata with an array of fields provided.
            /// The field contains a name, mapping and defaultValue properties which define
            /// the rule of the mapping.
            /// If no reader is configured with wijdatasource it will directly return the
            /// raw data.
            /// Default: null.
            /// Type: Object.
            /// </summary>
            self.reader = null;

            /// <summary>
            /// The proxy to use with wijdatasource. The wijdatasource class will call
            /// the proxy object's request method.
            /// In the proxy object, you can send a request to a remote server to
            /// obtain data with the ajaxs options object provided.
            /// Then you can use the wijdatasource reader to process the raw data in the call.
            /// Default: null.
            /// Type: Object.
            /// </summary>
            self.proxy = null;

            /// <summary>
            /// The processed items from the raw data.  This can be obtained after
            /// datasource is loaded.
            /// Default: [].
            /// Type: Array.
            /// </summary>
            self.items = [];

            /// <summary>
            /// Function called before loading process starts
            /// Default: null.
            /// Type: Function.
            /// Code example:
            /// var datasource = new wijdatasource({loading: function(e, data) { }})
            /// </summary>
            /// <param name="datasource" type="wijdatasource">
            /// wijdatasource object that raises this event.
            /// </param>
            /// <param name="data" type="Object">
            /// data passed in by load method.
            /// </param>
            self.loading = null;

            /// <summary>
            /// Function called after loading.
            /// Default: null.
            /// Type: Function.
            /// Code example:
            /// var datasource = new wijdatasource({loaded: function(e, data) { }})
            /// </summary>
            /// <param name="datasource" type="wijdatasource">
            /// wijdatasource object that raises this event.
            /// </param>
            /// <param name="data" type="Object">
            /// data passed in by load method.
            /// </param>
            self.loaded = null;
            self._constructor(options);
        };
        window.wijdatasource = wijdatasource;

        $.extend(wijdatasource.prototype, {
            _constructor: function (options) {
                $.extend(this, options);
            },
            load: function (data, forceLocalReload) {
                /// <summary>
                /// Triggers data loading process of wijdatasource.
                /// </summary>
                /// <param name="data" type="Object">
                /// The data to pass to the loading and loaded event handler.
                /// </param>
                /// <param name="forceLocalReload" type="boolean">
                /// Normally local data is only load for one time,
                /// if needs to reload the data, try to set forceLocalReload to true.
                /// </param>
                var self = this, p = self.proxy;

                //var d = self.data;
                // fire loading event.
                if ($.isFunction(self.loading)) {
                    //self.loading(self, data);
                    //if return false in loading event, cancel this request.
                    if (self.loading(self, data) === false) {
                        return;
                    }
                }

                // if datasource has an proxy object, it will use the request method of
                // proxy to retrive the raw data.
                if (p) {
                    // pass callback function to request method so that proxy could
                    // call the function when request is finished.
                    p.request(self, self.loaded, data);
                } else {
                    // local data is loaded only once, if force loading is needed
                    // forceLocalReload should be true.
                    if (self.items.length === 0 || forceLocalReload) {
                        // no proxy, read raw data
                        this.read();
                    }

                    // callback function is called
                    if ($.isFunction(self.loaded)) {
                        self.loaded(self, data);
                    }
                }
            },
            read: function () {
                /// <summary>
                /// Triggers data reading process of wijdatasource
                /// by using a DataReader if presented.
                /// </summary>
                var self = this, d = self.data;

                // reads using a reader object
                if (d && self.reader) {
                    self.reader.read(self);
                } else {
                    // returns raw data if no reader is configured with datasource.
                    self.items = self.data;
                    //removed by Jeffrey for removing unnecessary return
                    //return self.data;
                    //end by Jeffrey
                }
            }
        });

        /// <summary>
        /// wijdatasource ArrayReader reads from a array and processes items.
        /// </summary>
        wijarrayreader = function (fields) {
            // this.fields to store the fields info
            // Add for parse objectValue options for jUICE. D.H
            if ($.isFunction(window["wijmoASPNetParseOptions"])) {
                wijmoASPNetParseOptions(fields);
            }

            if ($.isArray(fields)) {
                this.fields = fields;
            }
        };
        window.wijarrayreader = wijarrayreader;

        $.extend(wijarrayreader.prototype, {
            read: function (datasource) {
                /// <summary>
                /// Starts reading data.
                /// </summary>
                /// <param name="datasource" type="wijdatasource">
                /// The wijdatasource using this DataReader.
                /// </param>
                // convert the raw data of wijdatasource
                if ($.isArray(datasource.data)) {
                    datasource.items = this._map(datasource.data);
                } else {
                    datasource.items = [];
                }
            },
            _map: function (data) {
                var self = this, arr = [];
                if (self.fields === undefined || self.fields.length === 0) {
                    $.extend(true, arr, data);
                    return arr;
                } else {
                    $.each(data, function (index, value) {
                        var i = {};
                        $.each(self.fields, function (index, field) {
                            // mapping property is a function,
                            // the return value will be used as value.
                            //handle the juice
                            if (field.mapping && typeof field.mapping && window[field.mapping]) {
                                field.mapping = window[field.mapping];
                            }

                            if ($.isFunction(field.mapping)) {
                                i[field.name] = field.mapping(value);
                                return true;
                            }

                            // use string field mapping or number index mapping.
                            var mapping = field.mapping !== undefined ? field.mapping : field.name, v = value[mapping];
                            if (v === undefined) {
                                if (field.defaultValue !== undefined) {
                                    v = field.defaultValue;
                                } else {
                                    v = value;
                                }
                            }
                            i[field.name] = v;
                        });
                        arr.push(i);
                    });
                }
                return arr;
            }
        });

        /// <summary>
        /// wijdatasource HttpProxy fetches data by using Ajax request.
        /// </summary>
        wijhttpproxy = function (options) {
            this.options = options;

            // Add for parse objectValue options for jUICE. D.H
            if ($.isFunction(window["wijmoASPNetParseOptions"])) {
                wijmoASPNetParseOptions(options);
            }
        };
        window.wijhttpproxy = wijhttpproxy;

        $.extend(wijhttpproxy.prototype, {
            request: function (datasource, callBack, userData) {
                /// <summary>
                /// Starts requesting data.
                /// </summary>
                /// <param name="datasource" type="wijdatasource">
                /// The wijdatasource using this DataReader.
                /// </param>
                /// <param name="callback" type="Function">
                /// The function to call after requesting data successfully.
                /// </param>
                var self = this, o, oldSuccess;
                o = $.extend({}, this.options);
                oldSuccess = o.success;

                o.success = function (data) {
                    if ($.isFunction(oldSuccess)) {
                        oldSuccess(data);
                    }
                    self._complete(data, datasource, callBack, o, userData);
                };
                $.ajax(o);
            },
            _complete: function (data, datasource, callback, options, userData) {
                // set raw data
                datasource.data = options.key !== undefined ? data[options.key] : data;

                // read raw data using a data reader in datasource
                datasource.read();

                // fire loaded callback
                if ($.isFunction(callback)) {
                    callback(datasource, userData);
                }
            }
        });
    })(wijmo.checkbox || (wijmo.checkbox = {}));
    var checkbox = wijmo.checkbox;
})(wijmo || (wijmo = {}));

;
/// <reference path="../Base/jquery.wijmo.widget.ts" />
/// <reference path="../wijutil/jquery.wijmo.wijutil.ts" />
/// <reference path="../wijlist/jquery.wijmo.wijlist.ts" />
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var wijmo;
(function (wijmo) {
    /*globals jQuery,window,document*/
    /*
    * Depends:
    *     jquery.ui.core.js
    *     jquery.ui.widget.js
    *     jquery.wijmo.wijtooltip.js
    */
    (function (combobox) {
        var $ = jQuery, widgetName = "wijcombobox";

        /** @widget */
        var wijcombobox = (function (_super) {
            __extends(wijcombobox, _super);
            function wijcombobox() {
                _super.apply(this, arguments);
            }
            wijcombobox.prototype._create = function () {
                var t = this, focusElement;

                // inits selected items
                t.selectedItem = null;
                t.selectedItems = [];

                // enable touch support:
                if (window.wijmoApplyWijTouchUtilEvents) {
                    $ = window.wijmoApplyWijTouchUtilEvents($);
                }

                try  {
                    focusElement = document.activeElement;
                } catch (e) {
                }

                //update for visibility change
                if (t.element.is(":hidden") && t.element.wijAddVisibilityObserver) {
                    t.element.wijAddVisibilityObserver(function () {
                        t.repaint();
                        if (t.element.wijRemoveVisibilityObserver) {
                            t.element.wijRemoveVisibilityObserver();
                        }
                    }, "wijcombobox");
                }

                // inits wijcombobox
                t._initInnerData();
                t._createDOMElements();
                t._bindInputEvents();
                t._initDropDownList();
                t.repaint();
                t._checkSelectIndex();
                t.options.text = t._input.val();

                if (t._usingRemoteData() && t.options.data) {
                    t.originalDataSourceLoaded = t.options.data.loaded;
                }

                //If combo is in an invisible iframe, exception will throw.
                //add this in try block to prevent this exception.
                //focusElement = document.activeElement;
                if (focusElement === t._input[0] && t.options.isEditable) {
                    $(function () {
                        t._input.focus();
                    });
                }
                _super.prototype._create.call(this);
            };

            wijcombobox.prototype._initInnerData = function () {
                var self = this, o = self.options, isBind;
                if (o.dataSource !== null) {
                    isBind = self._isBind();
                    if (isBind) {
                        self.innerData = self._getMappingItems();
                    } else {
                        self.innerData = o.data;
                    }
                } else {
                    self.innerData = o.data;
                }

                self.listHasCreated = false;
            };

            wijcombobox.prototype._checkSelectIndex = function () {
                var self = this, index, o = self.options, data = self.innerData;

                if (o.selectedIndex === -1 && o.selectedValue != null) {
                    $.each(data, function (i, item) {
                        if (data[i].value === o.selectedValue) {
                            o.selectedIndex = i;
                            if (o.selectionMode === "multiple") {
                                o.selectedIndex = [o.selectedIndex];
                            }
                            return false;
                        }
                    });
                }
                index = o.selectedIndex;
                if (!self._usingRemoteData() && (index >= 0 || $.isArray(index))) {
                    self.search(null, "checkindex");
                }

                // if the selecteIndex is -1 and selectedValue is null, the text
                // option will give to combobox
                if (o.selectedIndex === -1 && o.text) {
                    if (!o.forceSelectionText || (o.forceSelectionText && self._checkTextInItems(o.text) !== -1)) {
                        self._input.val(o.text);
                        o.selectedIndex = self._checkTextInItems(o.text);
                        if (o.selectionMode === "multiple") {
                            o.selectedIndex = [o.selectedIndex];
                        }
                        if (o.selectedIndex > -1) {
                            self._checkSelectIndex();
                        }
                    }
                }
            };

            /** Repaints wijcombobox. Returns true if it succeeds;
            *   otherwise, returns false.
            * @returns {boolean} true if it succeeds; otherwise, returns false.
            */
            wijcombobox.prototype.repaint = function () {
                var o = this.options, self = this;
                if (self.element.is(":visible") || self._comboDiv || (self._select !== undefined && self._input.is(":visible"))) {
                    self._showTrigger();
                    self._handleAdjustWidthOptions();
                    if (self._isDisabled()) {
                        self._innerDisable();
                    }
                    return true;
                }
                return false;
            };

            wijcombobox.prototype._bindInputEvents = function () {
                var self = this, wijCSS = this.options.wijCSS, code, keyCode, inputText, input = self._input, o = self.options;

                // self.element is an html input element.
                input.bind("keydown.wijcombobox", function (event) {
                    if (self._isDisabled()) {
                        return;
                    }
                    code = event.keyCode;

                    //keyCode = $.ui.keyCode;
                    keyCode = wijmo.getKeyCodeEnum();
                    switch (code) {
                        case keyCode.UP:
                            self._move("previous", event);

                            // prevent moving cursor to beginning of
                            // text field in some browsers
                            event.preventDefault();
                            break;
                        case keyCode.DOWN:
                            self._move("next", event);

                            // prevent moving cursor to end of text field in some browsers
                            event.preventDefault();
                            break;
                        case keyCode.ENTER:
                            // when menu is open or has focus
                            if (self.menu.active) {
                                event.preventDefault();

                                //update for issue 24045
                                if (o.selectionMode === "multiple" && self.menu && self.menu.items && self.menu.items.length === 1) {
                                    $.each(self.selectedItems, function (index, i) {
                                        if (i !== self.menu.items[0]) {
                                            i.selected = false;
                                        }
                                    });
                                }

                                //end
                                self.menu.select(event);
                            }
                            event.preventDefault(); //update for issue 24134 at 2012/7/19
                            break;

                        case keyCode.TAB:
                            input.trigger("wijcomboblur");
                            if (!self.menu.active || (o.selectionMode === "multiple" && keyCode.TAB === code)) {
                                return;
                            }
                            self.menu.select(event);

                            // remove selection from input.
                            var end = input.val().length;
                            self._selectText(end, end, input);

                            break;
                        case keyCode.ESCAPE:
                            self.close(event, undefined);
                            break;
                        case keyCode.LEFT:
                        case keyCode.RIGHT:
                        case keyCode.SHIFT:
                        case 16:
                        case 17:
                        case keyCode.CTRL:
                        case keyCode.HOME:
                        case keyCode.END:
                        case keyCode.PAGE_UP:
                        case keyCode.PAGE_DOWN:
                            break;
                        case keyCode.DELETE:
                            if (!inputText) {
                                inputText = input.val();
                            }
                            break;
                        case 18:
                            input.trigger("wijcomboblur");
                            break;
                        default:
                            // keypress is triggered before the input value is changed
                            //IE and Chrome the keycode is 229 in IME mode
                            //In Firefox it says 'Characters entered through an IME do not register through keyCode or charCode.' in documetation.  So the keycode is 0 and key of event is 'Unidentified' in IME mode.
                            //Please refer https://developer.mozilla.org/en-US/docs/Web/API/event.keyCode
                            if (code === 229 || ($.browser.mozilla && event.key === "Unidentified" && code === 0)) {
                                return;
                            }

                            self._processingSearch(input, code, event);
                            break;
                    }
                }).bind("keyup.wijcombobox", function (event) {
                    if (self._isDisabled()) {
                        return;
                    }
                    code = event.keyCode;
                    keyCode = wijmo.getKeyCodeEnum();
                    switch (code) {
                        case keyCode.DELETE:
                            if (inputText !== input.val()) {
                                self._processingSearch(input, code, event);
                            }
                            inputText = undefined;
                            break;
                    }
                }).bind("wijcomboblur.wijcombobox", function (event) {
                    window.clearTimeout(self.searching);
                    self._addInputFocus(false, wijCSS.stateFocus);

                    // TODO try to implement this without a timeout,
                    // see clearTimeout in search()
                    self.closing = window.setTimeout(function () {
                        self.close(event, true);
                    }, 150);
                }).bind("focus.wijcombobox", function () {
                    self._addInputFocus(true, wijCSS.stateFocus);
                }).bind("blur.wijcombobox", function () {
                    if (!self.menu.element.is(":visible")) {
                        input.trigger("wijcomboblur");
                    }

                    // 1)if inputed char include in dropdown items,
                    // the dropdown will open
                    // if the inputed char don't include in dropdown items,
                    // the dropdown won't open, it's for issue 42012
                    // 2)Thinking of "forceSelectionText" option, so move the "textChange"
                    // event to _change method
                    // self._setInputText(input.val());
                    if (!self._inputBlurCausedByListItemClick) {
                        self._change();
                    }
                }).bind("compositionend.wijcombobox", function (event) {
                    self._processingSearch(input, code, event);
                });

                //fixed the issue 40441
                if ($.browser.msie && parseInt($.browser.version) > 9) {
                    input.bind("mouseup.wijcombobox", function (event) {
                        // fixed an issue of IE10(browser mode IE9), when runs in this mode,
                        // the input element will show clear button at the right side of the input element.
                        // click the button, the widget's text value will not cleared.
                        if (input.val() === '') {
                            return;
                        }

                        // Wait for it....
                        setTimeout(function () {
                            if (input.val() === '') {
                                self.menu.deactivate();
                            }
                        }, 5);
                    });
                }
            };

            wijcombobox.prototype._processingSearch = function (input, code, event) {
                var self = this, o = self.options;

                window.clearTimeout(self.searching);
                if (o.isEditable === false) {
                    if (self._cacheKey === undefined) {
                        self._cacheKey = "";
                    }
                    self._cacheKey += String.fromCharCode(code);
                }
                self.searching = window.setTimeout(function () {
                    var term;
                    if (o.isEditable === false) {
                        term = self._cacheKey;
                        self._cacheKey = undefined;
                    } else {
                        term = input.val();
                    }
                    self.search(term, event);
                }, o.delay);
            };

            wijcombobox.prototype._addInputFocus = function (add, css) {
                var self = this, wrap, key, arrow;

                wrap = self._input.parent();
                key = add ? "addClass" : "removeClass";
                arrow = self._triggerArrow;
                wrap[key](css);
                if (arrow !== undefined) {
                    arrow[key](css);
                }
            };

            wijcombobox.prototype._renderColumnsHeader = function (header) {
                var self = this, ul = $("<ul class='wijmo-wijcombobox-rowheader'></ul>");
                $.each(this.options.columns, function (index, column) {
                    var li = $("<li class='wijmo-wijcombobox-cell " + self.options.wijCSS.header + "'></li>");
                    li.html(column.name);
                    if (column.width !== undefined) {
                        li.width(column.width);
                    }
                    li.appendTo(ul);
                });
                header.append(ul);
            };

            wijcombobox.prototype._hasSameValueText = function (item1, item2) {
                return item1.label === item2.label && item1.value === item2.value;
            };

            wijcombobox.prototype._initDropDownList = function () {
                var self = this, doc, menuElement, o = self.options, header, listOptions, wijCSS = this.options.wijCSS, zIndex = parseInt(self._input.css("zIndex"), 10), dropDownContainer;

                doc = self.element[0].ownerDocument;
                if (isNaN(zIndex)) {
                    zIndex = 0;
                }
                if (!self._comboDiv) {
                    menuElement = $("<div class='" + wijCSS.comboboxListCss + "'></div>");
                } else {
                    menuElement = self._oriList;
                }
                if (o.columns.length > 0) {
                    menuElement.addClass("wijmo-wijcombobox-multicolumn");
                    header = $("<div class='wijmo-wijsuperpanel-header " + wijCSS.stateDefault + "'></div>");
                    self._renderColumnsHeader(header);
                    menuElement.append(header);
                }

                listOptions = {
                    keepHightlightOnMouseLeave: true,
                    selectionMode: o.selectionMode,
                    addHoverItemClass: o.columns.length === 0,
                    focus: function (e, item) {
                        var i = item;
                        if (o.selectOnItemFocus) {
                            self.menu.select(null, {
                                notCloseAfterSelected: true
                            });
                        }
                        if (o.columns.length > 0) {
                            if (i.element) {
                                i.element.prev().addClass("wijmo-wijcombobox-active-prev");
                                i.element.find(".wijmo-wijcombobox-row>.wijmo-wijcombobox-cell").addClass(wijCSS.stateHover);
                            }
                        }
                    },
                    selected: function (event, ui) {
                        window.clearTimeout(self.closing);
                        var mode = o.selectionMode, item, newIndex, cancelSelect = false, oldText, oldIndex, oldItem;

                        item = ui.item;

                        newIndex = $.inArray(item, self.items);
                        if (newIndex < 0) {
                            return;
                        }

                        if (self._trigger("select", event, item)) {
                            if (mode === "single") {
                                // local data select
                                if (!self._usingRemoteData()) {
                                    if (newIndex !== o.selectedIndex) {
                                        oldIndex = o.selectedIndex;
                                        oldItem = self.selectedItem;
                                        cancelSelect = self._triggerSelectedIndexChanging(oldItem, item, oldIndex, newIndex);
                                        if (cancelSelect) {
                                            return;
                                        }

                                        self._setInputText(item.label);

                                        if (oldItem) {
                                            oldItem.selected = false;
                                        }
                                        self.selectedItem = item;

                                        o.selectedIndex = newIndex;
                                        o.selectedValue = self.selectedItem.value;

                                        o.inputTextInDropDownList = true;

                                        //o.text = self._input.val();for #33666 issue
                                        // fixed the issue 41831
                                        if (oldItem && oldItem.element) {
                                            oldItem.element.removeClass("wijmo-wijcombobox-selecteditem");
                                        }

                                        self._triggerChangeEvents(oldItem, oldIndex);
                                    } else {
                                        // for fixing bug 24133 at 2012/8/6
                                        if (self.selectedItem && self._input.val() !== self.selectedItem.label && (ui.data === undefined || !ui.data.notCloseAfterSelected)) {
                                            self._input.val(item.label);
                                        }
                                    }
                                } else {
                                    // If items have the same text and value,
                                    // they are considered to be same in remote mode.
                                    if (self.selectedItem === null || !self._hasSameValueText(item, self.selectedItem)) {
                                        oldItem = self.selectedItem;
                                        oldIndex = o.selectedIndex;
                                        cancelSelect = self._triggerSelectedIndexChanging(oldItem, item, oldIndex, ui.selectedIndex);
                                        if (cancelSelect) {
                                            return;
                                        }

                                        //self._input.val(item.label);
                                        self._setInputText(item.label);

                                        //o.text = self._input.val();for #33666 issue
                                        self.selectedItem = item;

                                        //update for 29162 issue.
                                        if (newIndex !== o.selectedIndex) {
                                            o.selectedIndex = newIndex;
                                            o.selectedValue = self.selectedItem.value;
                                        }

                                        //end
                                        o.inputTextInDropDownList = true;

                                        self._triggerChangeEvents(oldItem, oldIndex);
                                    }
                                }
                            } else {
                                if (!self._usingRemoteData()) {
                                    cancelSelect = self._triggerSelectedIndexChanging(null, item, oldIndex, ui.selectedIndex);
                                    if (cancelSelect) {
                                        return;
                                    }

                                    self.selectedItems = ui.selectedItems;
                                    self._selectedItemsToInputVal(self.selectedItems);
                                    o.inputTextInDropDownList = true;
                                    o.selectedIndex = ui.selectedIndex;

                                    self._triggerChangeEvents(null, null);
                                    ///TODO: show helper list
                                }
                            }
                        }
                        if ((ui.data === undefined || !ui.data.notCloseAfterSelected) && mode === "single") {
                            self.close(event);
                            self._input.focus();
                        }
                        self._inputBlurCausedByListItemClick = false;
                    },
                    blur: function (e, item) {
                        var d = item.element;
                        if (o.columns.length > 0 && d) {
                            d.find(".wijmo-wijcombobox-row>.wijmo-wijcombobox-cell").removeClass(wijCSS.stateHover);
                            d.prev().removeClass("wijmo-wijcombobox-active-prev");
                        }
                    },
                    mouseDown: function (event) {
                        self._inputBlurCausedByListItemClick = true;
                    },
                    itemRendering: function (event, data) {
                        var item = data, css = "";
                        if (item.isSeparator) {
                            css += " wijmo-wijcombobox-separator";
                        }
                        if (item.selected) {
                            css += " wijmo-wijcombobox-selecteditem";
                        }
                        if (css.length > 0) {
                            item.element.addClass(css);
                        }
                    },
                    itemRendered: function (event, data) {
                        var item = data, li, u;
                        if (self.menu._templates || item.cells == null) {
                            return;
                        }
                        li = item.element;
                        li.empty();
                        u = $("<ul class='wijmo-wijcombobox-row'></ul>");
                        $.each(item.cells, function (index, cell) {
                            var l = $("<li class='wijmo-wijcombobox-cell " + wijCSS.stateDefault + "'></li>");

                            //Fix a bug that columns.width doesn't work.
                            if (o.columns && o.columns.length > index) {
                                if (typeof o.columns[index].width !== "undefined") {
                                    l.width(o.columns[index].width);
                                }
                            }

                            //end comments.
                            l.append($.trim(cell) || "&nbsp;");
                            l.attr("title", cell);
                            u.append(l);
                        });
                        li.append(u);
                    },
                    listRendered: function (event, data) {
                        var selectedItem = self.menu.selectedItem, selectedItems = self.menu.selectedItems, selecedIndex, items;
                        if (o.selectionMode === "single" && selectedItem) {
                            selecedIndex = $.inArray(selectedItem, self.items);
                            if (selecedIndex < 0) {
                                return;
                            }
                            self.selectedItem = self.items[selecedIndex];
                            self._setInputText(self.selectedItem.label, true);
                            if (selecedIndex >= -1) {
                                o.selectedIndex = selecedIndex;
                            }
                        } else if (selectedItems && selectedItems.length > 0) {
                            selecedIndex = [];
                            items = [];
                            $.each(selectedItems, function (i, item) {
                                var index = $.inArray(item, self.items);
                                if (index < 0) {
                                    return true;
                                }
                                selecedIndex.push(index);
                                items.push(self.items[index]);
                            });
                            self._selectedItemsToInputVal(items);
                            if (selecedIndex.length >= 0) {
                                o.selectedIndex = selecedIndex;
                            }
                        }
                    },
                    superPanelOptions: {
                        resized: function (e) {
                            var m = self.menu, ele = m.element;
                            o.dropdownWidth = ele.outerWidth();
                            o.dropdownHeight = ele.outerHeight();
                            self._positionList();
                            self.menu.refreshSuperPanel();
                        }
                    }
                };
                listOptions = $.extend(true, listOptions, o.listOptions);

                dropDownContainer = o.ensureDropDownOnBody ? $("body") : self._comboElement;

                self.menu = menuElement.appendTo(dropDownContainer, doc).wijlist(listOptions).css({
                    zIndex: zIndex + 1,
                    top: 0,
                    left: 0
                }).hide().data("wijmo-wijlist");
                self._createDropDownList();
                self._menuUL = self.menu.ul;
            };

            wijcombobox.prototype._setInputText = function (text, notfiredTextChanged) {
                var self = this, oldText = self.options.text;

                self._input.val(text);
                self.options.text = text;
                if (oldText !== text && !notfiredTextChanged) {
                    self._trigger("textChanged", null, {
                        oldText: oldText,
                        newText: text
                    });
                }
            };

            wijcombobox.prototype._triggerChangeEvents = function (oldSelectedItem, oldSelectedIndex) {
                var o = this.options, mode = o.selectionMode, selectedItem = this.selectedItem, selectedIndex = this.options.selectedIndex, changedData;

                this._triggerSelectElementChange();

                changedData = {
                    oldItem: oldSelectedItem,
                    selectedItem: this.selectedItem,
                    newIndex: selectedIndex,
                    oldIndex: oldSelectedIndex
                };
                if (mode === "multiple") {
                    changedData = $.extend(changedData, { selectedItems: this.selectedItems });
                }

                this._trigger("changed", null, changedData);

                if (selectedIndex != oldSelectedIndex) {
                    this._triggerSelectedIndexChanged(oldSelectedItem, selectedItem, oldSelectedIndex, selectedIndex);
                }
            };

            wijcombobox.prototype._triggerSelectElementChange = function () {
                var o = this.options;

                // fire select change event
                if (this._select !== undefined) {
                    if ($.isArray(o.selectedIndex) && o.selectedIndex.length > 0) {
                        this._select[0].selectedIndex = o.selectedIndex[0];
                    } else {
                        this._select[0].selectedIndex = o.selectedIndex;
                    }
                    this._select.trigger("change");
                }
            };

            wijcombobox.prototype._triggerSelectedIndexChanged = function (oldItem, newItem, oldIndex, newIndex) {
                var o = this.options, curSelectedIdx;

                if (o.selectionMode === "single") {
                    this._trigger("selectedIndexChanged", null, {
                        oldItem: oldItem,
                        selectedItem: newItem,
                        newIndex: newIndex,
                        oldIndex: oldIndex
                    });
                } else {
                    curSelectedIdx = $.inArray(newItem, this.items);
                    this._trigger("selectedIndexChanged", null, {
                        selectedItem: newItem,
                        selectedIndex: curSelectedIdx,
                        selectedItems: this.selectedItems
                    });
                }
            };

            wijcombobox.prototype._triggerSelectedIndexChanging = function (oldItem, newItem, oldIndex, newIndex) {
                var o = this.options, curSelectedIdx, args, isSelect = true;

                if (o.selectionMode === "single") {
                    args = {
                        oldItem: oldItem,
                        selectedItem: newItem,
                        newIndex: newIndex,
                        oldIndex: oldIndex
                    };
                    isSelect = this._trigger("selectedIndexChanging", null, args);
                } else {
                    curSelectedIdx = $.inArray(newItem, this.items);
                    args = {
                        selectedItem: newItem,
                        selectedIndex: curSelectedIdx,
                        selectedItems: this.selectedItems
                    };
                    isSelect = this._trigger("selectedIndexChanging", null, args);
                }
                if (!isSelect) {
                    newItem.selected = false;
                    if (newItem.element) {
                        newItem.element.removeClass("wijmo-wijcombobox-selecteditem");
                    }
                }
                return !isSelect;
            };

            wijcombobox.prototype._createDropDownList = function (datasrc) {
                var self = this, items, o = self.options, datasource = datasrc;

                if (!datasource) {
                    datasource = self.innerData;
                }

                if (datasource === null) {
                    items = null;
                } else {
                    items = $.isArray(datasource) ? datasource : datasource.items;
                }
                if (self._comboDiv) {
                    //update for case 20689 at 2012/4/11
                    if (!self.listHasCreated && items && items.length > 0) {
                        self.menu.setTemplateItems(o.data);
                        if ($.isArray(self.innerData)) {
                            self.innerData = self.menu.items;
                        } else {
                            self.innerData.items = self.menu.items;
                        }
                        self.items = self.menu.items;
                        self.menu.renderList();
                        self.listHasCreated = true;
                    }
                } else {
                    if (!self.listHasCreated && items && items.length > 0) {
                        self.menu.setItems(items);
                        if ($.isArray(self.innerData)) {
                            self.innerData = self.menu.items;
                        } else {
                            self.innerData.items = self.menu.items;
                        }
                        self.items = self.menu.items;
                        self.menu.renderList();
                        self.listHasCreated = true;
                    }
                }
                self._handleAdjustWidthOptions();
            };

            wijcombobox.prototype._getSelectedItemsText = function (items) {
                var s = "", self = this, sep = self.options.multipleSelectionSeparator;
                self.selectedItems = items;

                $.each(items, function (index, item) {
                    //update for bug 24045
                    if (item) {
                        s += item.label + sep;
                    }
                });
                if (s.length > 0) {
                    s = s.substr(0, s.lastIndexOf(sep));
                }

                return s;
            };

            wijcombobox.prototype._selectedItemsToInputVal = function (items) {
                var self = this;

                //self._input.val(self._getSelectedItemsText(items));
                self._setInputText(self._getSelectedItemsText(items));
                //self.options.text = self._input.val();for #33666 issue
            };

            wijcombobox.prototype._createDOMElements = function () {
                var self = this, comboElement, wijCSS = this.options.wijCSS, ele, input, wrapperElement;

                wrapperElement = $("<div class='" + wijCSS.comboboxWrapperCss + " " + wijCSS.stateDefault + " " + wijCSS.cornerAll + "'></div>");

                // check if element is a select element
                ele = self.element;

                // create from a select element
                if (ele.is("select")) {
                    comboElement = $("<div role='combobox' class='" + wijCSS.comboboxCss + " " + wijCSS.widget + " " + wijCSS.helperClearFix + "'></div>");
                    comboElement.append(wrapperElement);
                    self._comboElement = comboElement;
                    self._select = ele;

                    // add class to set font size to get the correct width of select.
                    ele.addClass(wijCSS.widget);
                    input = self._input = $("<input role='textbox' " + "aria-autocomplete='list' aria-haspopup='true' />").insertAfter(ele);
                    if (!self.options.data) {
                        self.options.data = self._convertSelectOptions();
                        self._initInnerData();
                    }
                } else if (ele.is("div") && $(ele.children()[0]).is("input[type='text']") && $(ele.children()[1]).is("div")) {
                    //div tag
                    self._comboElement = self._comboDiv = comboElement = ele;
                    self._oriList = $(ele.children()[1]);
                    input = self._input = $(ele.children()[0]);

                    wrapperElement.prependTo(comboElement).append(input);
                    ele.addClass(wijCSS.comboboxCss + " " + wijCSS.widget + " " + wijCSS.helperClearFix);
                    ele.attr("role", "combobox");
                } else {
                    comboElement = $("<div role='combobox' class='" + wijCSS.comboboxCss + " " + wijCSS.widget + " " + wijCSS.helperClearFix + "'></div>");
                    comboElement.append(wrapperElement);
                    self._comboElement = comboElement;
                    input = self._input = ele;
                }
                if (!self._comboDiv) {
                    comboElement.insertBefore(input);

                    //update for fixing bug 17328 at 2011/10/18 by wuhao
                    //add visible judge for visibility change at 2012/7/24
                    if (self.element.is(":visible")) {
                        input.width(input.width());
                    }

                    //end for fixing bug 17328
                    comboElement.children("." + wijCSS.comboboxWrapperCss).append(input);
                }

                if (ele.attr("title")) {
                    self._comboElement.attr("title", ele.attr("title"));
                }
                input.attr({
                    autocomplete: "off",
                    role: "textbox",
                    "aria-haspopup": "true",
                    "aria-label": "input"
                }).addClass(wijCSS.comoboboxInputCss);
                self._oldWidth = ele.css("width");
                if (self.options.isEditable === false) {
                    input.attr("readonly", "readonly");

                    //update for add issue: when iseditable is false
                    //click the all the combobox, the dropdown list will open
                    wrapperElement.bind("click", function () {
                        if (self._isDisabled()) {
                            return;
                        }
                        self._triggerClick();
                    });
                }
                if (self._isDisabled()) {
                    self._comboElement.addClass("wijmo-wijcombobox-disabled " + wijCSS.stateDisabled);
                    input.attr("disabled", "disabled");
                }
                comboElement.bind("mouseenter.wijcombobox", function () {
                    if (self._isDisabled()) {
                        return;
                    }
                    self._addInputFocus(true, wijCSS.stateHover);
                }).bind("mouseleave.wijcombobox", function () {
                    self._addInputFocus(false, wijCSS.stateHover);
                }).attr({
                    "aria-label": "wijcombobox",
                    "aria-expanded": "false"
                });
            };

            wijcombobox.prototype._convertSelectOptions = function () {
                var items = [], self = this, selectOptions;

                selectOptions = self._select.get(0).options;
                $.each(selectOptions, function (idx, opt) {
                    items.push({ label: opt.text, value: opt.value });
                });

                //update for case 28976
                if (self.options.selectedIndex === -1 && self.options.selectedValue === null && self.options.text === null) {
                    self.options.selectedIndex = self._select[0].selectedIndex;
                }
                return items;
            };

            /** @ignore */
            wijcombobox.prototype.getComboElement = function () {
                return this._comboElement;
            };

            wijcombobox.prototype._updateLabelTextElement = function () {
                var self = this, o = self.options, wijCSS = o.wijCSS, labelHTML = "<label class='wijmo-wijcombobox-label " + wijCSS.content + "'></label>", label = self._input.parent().children(".wijmo-wijcombobox-label");
                if (o.labelText !== null) {
                    if (label.length === 0) {
                        label = $(labelHTML);
                        self._input.parent().append(label);
                    }
                    self._label = label;
                    label.html(o.labelText);
                } else {
                    if (label) {
                        label.remove();
                        self._label = undefined;
                    }
                }
            };

            wijcombobox.prototype._showTrigger = function () {
                var self = this, o = self.options, input = self._input, inputWrapper = input.parent(), comboElement = self._comboElement, wijCSS = this.options.wijCSS, selectClone, selectWidth = 0, trigger = self._triggerArrow, label = self._label, sp, padding, labelPadding, triggerPadding, asideBorder, triggerHTML = "<div class='" + wijCSS.comboboxTriggerCss + " " + wijCSS.stateDefault + " " + wijCSS.cornerRight + "' role='button' aria-label='trigger'>" + "<span class='" + wijCSS.icon + " " + wijCSS.iconArrowDown + "'></span>" + "</div>";

                // set size
                if (self._select !== undefined) {
                    // the hidden _select element indicated the
                    // combobox is repainting; so use the native width
                    // to draw combobox
                    if (!self._select.is(":visible")) {
                        selectWidth = self._nativeWidth;
                    } else {
                        if (!$.browser.msie) {
                            selectWidth = self._select.width();
                        } else {
                            selectClone = self._select.clone();
                            self._select.after(selectClone);
                            selectWidth = selectClone.width();
                            selectClone.remove();
                        }
                        self._nativeWidth = selectWidth;
                    }

                    //update for bind array
                    comboElement.css("width", "");
                    input.width(selectWidth + (o.dropdownHeight < self.menu.element.height() ? o.selectElementWidthFix : 0));
                    self._select.hide();
                }

                //update for fixing bug 15920 by wuhao
                input.css("margin-left", "");
                input.css("margin-right", "");

                //end for bug 15920.
                comboElement.width(inputWrapper[0].offsetWidth);

                //comboElement.height(inputWrapper[0].offsetHeight);
                // show label
                self._updateLabelTextElement();
                label = self._label;

                if (o.showTrigger) {
                    input.removeClass(wijCSS.cornerAll);
                    if (trigger === undefined) {
                        trigger = self._triggerArrow = $(triggerHTML);
                        comboElement.append(trigger);
                        trigger.bind("mouseover.triggerevent", self, function (e) {
                            if (self._isDisabled()) {
                                return;
                            }
                            var ct = $(e.currentTarget);
                            ct.addClass(wijCSS.stateHover);
                        }).bind("mousedown.triggerevent", self, function (e) {
                            if (self._isDisabled()) {
                                return;
                            }
                            var ct = $(e.currentTarget);
                            ct.addClass(wijCSS.stateActive);
                        }).bind("mouseup.triggerevent", self, function (e) {
                            var ct = $(e.currentTarget);
                            ct.removeClass(wijCSS.stateActive);
                        }).bind("click.triggerevent", self, function () {
                            if (self._isDisabled()) {
                                return;
                            }
                            self._triggerClick();
                        });
                    }
                    if (o.triggerPosition === "right") {
                        trigger.css({ left: "", right: "0px" });
                        trigger.removeClass(wijCSS.cornerLeft);
                        trigger.addClass(wijCSS.cornerRight);
                    } else {
                        trigger.css({ "right": "", "left": "0px" });
                        trigger.removeClass(wijCSS.cornerRight);
                        trigger.addClass(wijCSS.cornerLeft);
                    }
                    trigger.setOutHeight(comboElement.innerHeight());
                    sp = trigger.find("span");
                    sp.css("margin-left", (trigger.innerWidth() - sp[0].offsetWidth) / 2);
                    sp.css("margin-top", (trigger.innerHeight() - sp[0].offsetHeight) / 2);
                } else {
                    if (trigger !== undefined) {
                        trigger.unbind(".triggerevent");
                        trigger.remove();
                        trigger = undefined;
                        self._triggerArrow = undefined;
                    }
                    input.removeClass(wijCSS.cornerLeft);
                    input.removeClass(wijCSS.cornerRight);
                    input.addClass(wijCSS.cornerAll);
                }

                // padding
                padding = labelPadding = triggerPadding = 0;
                if (label !== undefined) {
                    labelPadding += label.outerWidth(true);
                }
                asideBorder = o.triggerPosition === "left" ? inputWrapper.leftBorderWidth() : inputWrapper.rightBorderWidth();
                if (trigger !== undefined) {
                    triggerPadding = trigger.outerWidth(true) - asideBorder;
                }
                padding = labelPadding + triggerPadding;
                input.setOutWidth(inputWrapper.width() - padding);

                padding = padding === 0 ? "" : padding;
                if (o.triggerPosition === "right") {
                    input.css("margin-left", "");
                    input.css("margin-right", padding);
                    if (label !== undefined) {
                        label.css("left", "");
                        label.css("right", triggerPadding);
                    }
                } else {
                    input.css("margin-right", "");
                    input.css("margin-left", padding);

                    if (label !== undefined) {
                        label.css("right", "");
                        label.css("left", triggerPadding);
                    }
                }
            };

            wijcombobox.prototype._triggerClick = function () {
                var self = this, term = "";
                window.clearTimeout(self.closing);
                if (self.menu.element.is(":visible")) {
                    self.close();
                } else {
                    // TODO: click open should not render again.
                    if (self._usingRemoteData()) {
                        term = self._input.val();
                    }
                    self.search(term, undefined, false);
                }
            };

            /**
            * Remove the functionality completely. This will return the element back to its pre-init state.
            */
            wijcombobox.prototype.destroy = function () {
                var self = this, wijCSS = this.options.wijCSS, ele = self.element;
                if (self.options.isEditable === false) {
                    ele.removeAttr("readonly");
                }

                if (self._input) {
                    self._input.unbind(".wijcombobox");
                }

                if (self._comboElement) {
                    self._comboElement.unbind(".wijcombobox");
                }

                if (self._triggerArrow) {
                    self._triggerArrow.unbind(".triggerevent");
                }

                if (self._select !== undefined) {
                    self._select.removeClass(wijCSS.widget);
                    self._select.show();
                    self._input.remove();
                } else if (self._comboDiv) {
                    self._comboDiv.removeClass(wijCSS.comboboxCss + " " + wijCSS.widget + " " + wijCSS.helperClearFix);
                    self._comboDiv.removeAttr("role");
                    self._input.insertBefore(self._comboDiv);
                    self._comboDiv.children("." + wijCSS.comboboxWrapperCss).remove();
                } else {
                    ele.css("width", self._oldWidth);
                    ele.removeClass(wijCSS.comoboboxInputCss);
                    ele.removeAttr("autocomplete").removeAttr("role").removeAttr("aria-haspopup");
                    ele.insertBefore(self._comboElement);
                    ele.css("padding", "");
                }

                if (self.options.ensureDropDownOnBody) {
                    $(window).unbind("resize.wijcombobox");
                }

                self._comboElement.remove();
                self.menu.destroy();
                self.menu.element.remove();
                _super.prototype.destroy.call(this);
            };

            wijcombobox.prototype._setOption = function (key, value) {
                var self = this, o = self.options, ele = self._comboElement, input = self.element, items, inputWrapper = input.parent(), cancelSelect, wijCSS = this.options.wijCSS, label = self._label, triggerPadding, oldSelectedIndex = o.selectedIndex, newSelectedItem, oldDisabled = o.disabled, oldSelectedItem = null, triggerWidth = 0;

                if (self._triggerArrow) {
                    triggerWidth = self._triggerArrow.outerWidth();
                }

                _super.prototype._setOption.call(this, key, value);
                if (key === "labelText") {
                    self._updateLabelTextElement();
                    label = self._label;
                    if (label && label.length > 0) {
                        if (self._triggerArrow !== undefined) {
                            triggerPadding = self._triggerArrow[0].offsetWidth;
                        }
                        if (o.triggerPosition === "right") {
                            if (label !== undefined) {
                                label.css("left", "");
                                label.css("right", triggerPadding);
                            }
                        } else {
                            if (label !== undefined) {
                                label.css("right", "");
                                label.css("left", triggerPadding);
                            }
                        }
                        self.repaint();
                    }
                } else if (key === "showTrigger") {
                    self._showTrigger();
                    if (!o.showTrigger && self.element.is("select")) {
                        input.width(input.width() + triggerWidth);
                    }
                } else if (key === "triggerPosition") {
                    input.width(input.width() + triggerWidth);
                    self._showTrigger();
                } else if (key === "selectionMode") {
                    self.menu._setOption("selectionMode", value);
                } else if (key === "isEditable") {
                    if (value) {
                        //update for 27917
                        self._input.removeAttr("readonly");

                        //update for add issue: when iseditable is false
                        //click the all the combobox, the dropdown list will open
                        $("." + wijCSS.comboboxWrapperCss, self._comboElement[0]).bind("click", function () {
                            self._triggerClick();
                        });
                    } else {
                        //update for 27917
                        self._input.attr("readonly", "readonly");
                        $("." + wijCSS.comboboxWrapperCss, self._comboElement[0]).unbind("click");
                    }
                } else if (key === "data" || key === "dataSource") {
                    self._initInnerData();
                    self._setSelectedIndex(o.selectedIndex);
                    if ($.isArray(self.innerData)) {
                        self.listHasCreated = false;
                        self._createDropDownList();
                    } else {
                        try  {
                            self.innerData.loaded = function (e, data) {
                                if (e === null) {
                                    self.items = null;
                                } else {
                                    self.items = $.isArray(e) ? e : e.items;
                                }
                                self.listHasCreated = false;
                                self._createDropDownList();
                            };
                            self.innerData.load(null);
                        } catch (e) {
                        }
                    }

                    if (o.selectedIndex !== -1) {
                        oldSelectedItem = items ? items[oldSelectedIndex] : null;
                        items = self.innerData;

                        self._triggerChangeEvents(oldSelectedItem, oldSelectedIndex);
                    }
                    self._keypress = false;
                } else if (key === "selectedIndex") {
                    if (value === oldSelectedIndex) {
                        return;
                    }
                    if (value === null || value === undefined) {
                        value = -1;
                    }
                    if (self.innerData === null) {
                        items = null;
                    } else {
                        items = $.isArray(self.innerData) ? self.innerData : self.innerData.items;
                    }

                    if (o.selectionMode === "single") {
                        oldSelectedItem = items ? items[oldSelectedIndex] : null;
                        if (value > -1) {
                            if (items && items[value] !== null) {
                                newSelectedItem = items[value];
                            }
                            cancelSelect = self._triggerSelectedIndexChanging(oldSelectedItem, newSelectedItem, oldSelectedIndex, value);
                            if (cancelSelect) {
                                o.selectedIndex = oldSelectedIndex;
                                return;
                            }

                            // if the data option is reset and the self.selectedItem is underfined,
                            // need use oldSelectedIndex to clear selection
                            if (oldSelectedIndex !== null && oldSelectedIndex !== -1 && oldSelectedIndex !== undefined && oldSelectedItem) {
                                oldSelectedItem.selected = false;
                                this.menu.unselectItems(oldSelectedIndex);
                                if (oldSelectedItem.element) {
                                    oldSelectedItem.element.removeClass("wijmo-wijcombobox-selecteditem");
                                }
                            }

                            if (items && items[value] !== null) {
                                self.selectedItem = items[value];
                                if (self.selectedItem) {
                                    self.selectedItem.selected = true;
                                    self._setInputText(self.selectedItem.label);
                                    o.selectedValue = self.selectedItem.value;
                                    o.inputTextInDropDownList = true;
                                    //o.text = self._input.val();for #33666 issue
                                }
                            }
                        } else if (value <= -1 || !value) {
                            cancelSelect = self._triggerSelectedIndexChanging(oldSelectedItem, null, oldSelectedIndex, value);
                            if (cancelSelect) {
                                o.selectedIndex = oldSelectedIndex;
                                return;
                            }
                            o.inputTextInDropDownList = false;
                            self._clearSelection();
                        }

                        self._triggerChangeEvents(oldSelectedItem, oldSelectedIndex);
                    } else {
                        if (!$.isArray(oldSelectedIndex)) {
                            oldSelectedIndex = [oldSelectedIndex];
                        }

                        $.each(oldSelectedIndex, function (i, index) {
                            if (self.menu.items && self.menu.items[index]) {
                                self.menu.items[index].selected = false;
                            }
                        });
                        this.menu.unselectItems(oldSelectedIndex);
                        self.selectedItems = [];
                        self.selectedItem = null;
                        if (!$.isArray(value)) {
                            value = [value];
                            o[key] = value;
                        }
                        self._setSelectedIndex(value);
                        $.each(value, function (i, index) {
                            if (self.menu.items && self.menu.items[index]) {
                                self.menu.items[index].selected = true;
                            }
                        });

                        self._triggerChangeEvents(null, null);
                    }
                } else if (key === "selectedValue") {
                    items = self.items;
                    if (!items) {
                        items = self.innerData;
                    }
                    if (o.selectionMode === "single") {
                        oldSelectedItem = items ? items[oldSelectedIndex] : null;
                    } else {
                        oldSelectedIndex = null;
                    }

                    if (value != null) {
                        if (self.selectedItem && self.selectedItem.selected !== undefined) {
                            self.selectedItem.selected = false;
                        }

                        if (items) {
                            if (this.options.selectedIndex > -1 && items.length > this.options.selectedIndex && items[this.options.selectedIndex]) {
                                items[this.options.selectedIndex].selected = false;
                                this.menu.deactivate();
                                this.menu.unselectItems(this.options.selectedIndex);
                                self.menu.items[this.options.selectedIndex].selected = false;
                            }
                            $.each(items, function (index, item) {
                                if (items[index].value === value) {
                                    self.selectedItem = items[index];
                                    self.selectedItem.selected = true;
                                    self.menu.items[index].selected = true;

                                    //self._input.val(self.selectedItem.label);
                                    self._setInputText(self.selectedItem.label);
                                    if (o.selectionMode === "single") {
                                        o.selectedIndex = index;
                                    } else {
                                        o.selectedIndex = [index];
                                    }
                                    o.inputTextInDropDownList = true;

                                    //o.text = self._input.val();for #33666 issue
                                    return false;
                                }
                            });
                        }
                    } else if (o.selectionMode === "single") {
                        o.inputTextInDropDownList = false;
                        self._clearSelection();
                    }

                    self._triggerChangeEvents(oldSelectedItem, oldSelectedIndex);
                } else if (key === "text") {
                    if (o.forceSelectionText && self._checkTextInItems(value) === -1) {
                        return;
                    }

                    //self._input.val(value);
                    self._setInputText(value);
                } else if (key === "selectElementWidthFix") {
                    self._showTrigger();
                } else if (key === "adjustComboWidth" || key === "dropdownWidth") {
                    self._handleAdjustWidthOptions();
                }
            };

            wijcombobox.prototype._handleAdjustWidthOptions = function () {
                var self = this, o = self.options, width = 0, safeWidth = 25;
                if (o.adjustComboWidth === true) {
                    if (o.dropdownWidth === "auto" || o.dropdownWidth === "fit") {
                        width = self._getMaxListItemWidth() + safeWidth; // add a safe amount to avoid word wrap in case of v-scrollbar appears.
                    } else {
                        width = o.dropdownWidth;
                    }
                    self._setComboWidth(width);
                    self._setDropdownWidth(width);
                } else {
                    if (o.dropdownWidth === "auto") {
                        width = self._getComboWidth();
                    } else if (o.dropdownWidth === "fit") {
                        width = Math.max(self._getComboWidth(), self._getMaxListItemWidth() + safeWidth);
                    } else {
                        width = o.dropdownWidth;
                    }
                    self._setDropdownWidth(width);
                }
                return width;
            };

            wijcombobox.prototype._innerDisable = function () {
                _super.prototype._innerDisable.call(this);
                this._toggleDisableCombobox(true);
            };

            wijcombobox.prototype._innerEnable = function () {
                _super.prototype._innerEnable.call(this);
                this._toggleDisableCombobox(false);
            };

            wijcombobox.prototype._toggleDisableCombobox = function (disabled) {
                var wijCSS = this.options.wijCSS;
                this._input.prop("disabled", disabled);
                this._comboElement.toggleClass("wijmo-wijcombobox-disabled " + wijCSS.stateDisabled, disabled);
                if (this._comboDiv) {
                    this._input.toggleClass("wijmo-wijcombobox-disabled " + wijCSS.stateDisabled, disabled);
                }
                if (disabled) {
                    this.close();
                }
            };

            wijcombobox.prototype._setSelectedIndex = function (value) {
                var self = this, o = self.options, selectedItems = [], data = self.innerData;
                if (value === null || value === undefined) {
                    return;
                }

                if (value === -1) {
                    self.selectedItem = null;
                    o.selectedIndex = -1;
                    o.selectedValue = null;
                    if (o.text) {
                        self._input.val(o.text);
                    } else {
                        self._input.val("");
                    }
                } else {
                    if ($.isArray(value)) {
                        self.selectedItems = [];
                        $.each(value, function (i, val) {
                            if (data && data[val] !== null && data[val] !== undefined) {
                                data[val].selected = true;
                                selectedItems.push(data[val]);
                            }
                        });
                        self.selectedItems = selectedItems;
                        self._selectedItemsToInputVal(selectedItems);
                    } else {
                        if (data && data[value] !== null && data[value] !== undefined) {
                            data[value].selected = true;
                            self._input.val(data[value].label);
                            self.selectedItem = data[value];
                        } else if (data && $.isArray(data) && value > data.length - 1) {
                            o.selectedIndex = -1;
                            self._input.val("");
                        }
                    }
                }
                o.text = self._input.val();
            };

            /** Searches the wijcombobox drop-down list for the specified value.
            * @param {string} value Text to search in the drop-down list.
            * @param {object} eventObj The jquery event object.
            */
            wijcombobox.prototype.search = function (value, eventObj, filtering) {
                if (typeof filtering === "undefined") { filtering = true; }
                var self = this, o = self.options, datasource = self.innerData, d, isBind;

                window.clearTimeout(self.closing);
                d = {
                    value: value,
                    e: eventObj,
                    self: self
                };

                // load data when data is not loaded yet
                // or datasource is using a proxy to obtain data.
                if (datasource !== null || self._comboDiv) {
                    //update 2012/9/14
                    isBind = self._isBind();

                    // check index will skip search event
                    if (eventObj !== "checkindex") {
                        if (self._trigger("search", eventObj, { datasrc: datasource, term: d }) === false) {
                            return;
                        }
                        datasource = self.innerData;
                    }

                    if ($.isArray(datasource) || isBind || self._comboDiv || (!self._usingRemoteData() && datasource.items && $.isArray(datasource.items) && datasource.items.length > 0)) {
                        self._hideShowArrow(false);
                        self._onListLoaded(datasource, d, filtering);
                    } else if (!isBind && $.isArray(o.dataSource)) {
                        return;
                    } else {
                        if (self._usingRemoteData() && eventObj !== undefined && value.length < o.minLength) {
                            return;
                        }
                        self._hideShowArrow(false);

                        // update for: datasource loaded event don't fired
                        // in combobox
                        datasource.loaded = function (e, data) {
                            //need to re initialize the dropdown list
                            //datasource condition the data is get by proxy
                            self.listHasCreated = false;
                            self._createDropDownList(e);

                            //self._onListLoaded(self.items, data);
                            self._onListLoaded(e, data, filtering);
                            if (self.originalDataSourceLoaded) {
                                self.originalDataSourceLoaded(e, data);
                            }
                        };
                        datasource.load(d);
                    }
                }
            };

            /** Get the select item(s) in combobox.
            * @remarks
            *        when using multiple mode, it will return array object.
            *        If no item is selected, it will return null or empty array.
            * @returns {array} array object or empty array.
            */
            wijcombobox.prototype.getSelectedItems = function () {
                var o = this.options;
                if (o.selectionMode === "single") {
                    return this.selectedItem;
                } else {
                    return this.selectedItems;
                }
            };

            //for bind data
            wijcombobox.prototype._isBind = function () {
                var o = this.options, data = o.data;

                if (data !== null && data.label && data.label.bind) {
                    return true;
                }
                return false;
            };

            wijcombobox.prototype._getMappingItems = function () {
                var o = this.options, dataSource = o.dataSource, data = o.data, mappingItems, labelKey, valueKey;
                if (!dataSource || !data) {
                    return null;
                }

                if (!data.label || !data.label.bind || !data.value || !data.value.bind) {
                    return null;
                }

                labelKey = data.label.bind;
                valueKey = data.value.bind;

                //1.Array
                if (dataSource && dataSource.length !== 0) {
                    mappingItems = [];

                    $.each(dataSource, function (i, item) {
                        mappingItems.push({ label: item[labelKey], value: item[valueKey] });
                    });

                    return mappingItems;
                }
                return null;
            };

            //end for bind data
            wijcombobox.prototype._clearSelection = function (notfiredTextChanged) {
                var self = this, o = self.options;

                if (o.selectionMode === "single") {
                    if (self.selectedItem) {
                        self.selectedItem.selected = false;
                        self.selectedItem = null;
                    }
                } else {
                    if (self.selectedItems) {
                        $.each(self.selectedItems, function (index, item) {
                            if (item && item.selected) {
                                item.selected = false;
                            }
                        });
                        self.selectedItem = null;
                        self.selectedItems = [];
                    }
                }
                o.selectedValue = null;

                //self._input.val("");
                self._setInputText("", notfiredTextChanged);
                //o.text = self._input.val();for #33666 issue
            };

            wijcombobox.prototype._usingRemoteData = function () {
                var o = this.options.data, r = false;
                if (!$.isArray(o) && o !== null && o.proxy) {
                    r = true;
                }
                return r;
            };

            wijcombobox.prototype._hideShowArrow = function (show) {
                // hide arrow to show
                var self = this, input = self.element, arrow = self._triggerArrow;

                if (arrow !== undefined) {
                    arrow[show ? "show" : "hide"]();
                }
                input[show ? "removeClass" : "addClass"]("wijmo-wijcombobox-loading");
            };

            wijcombobox.prototype._onListLoaded = function (datasource, data, filtering) {
                var self = data.self, ele = self._input, o = self.options, wijCSS = this.options.wijCSS, searchTerm = data.value, items, idx, itemsToRender, olditem, oldIndex;

                if (!datasource) {
                    items = null;
                } else {
                    items = $.isArray(datasource) ? datasource : datasource.items;
                }

                self.items = items;
                if (data.e === "checkindex") {
                    idx = o.selectedIndex;

                    if (o.selectionMode === "multiple" && $.isArray(idx)) {
                        self.selectedItems = [];
                        $.each(idx, function (i, n) {
                            var itm = items[n];
                            itm.selected = true;
                            self.selectedItems.push(itm);
                        });
                        self._selectedItemsToInputVal(self.selectedItems);
                    } else {
                        items[idx].selected = true;
                        self.selectedItem = items[idx];
                        ele.val(self.selectedItem.label);
                    }
                    self._hideShowArrow(true);
                    return;
                }

                // fixed the issue 42893, if the selected item's label is empty, here should
                // not reset the selection.
                if (filtering && ele.val() === "") {
                    olditem = this.selectedItem;
                    if (olditem && olditem.label !== "") {
                        oldIndex = o.selectedIndex;
                        self._clearSelection();
                        self._setSelectedIndex(-1);
                        self._triggerChangeEvents(olditem, oldIndex);
                        self.menu.deactivate();
                    }
                }

                // only fileter result when using local data.
                if (!self._usingRemoteData() && items) {
                    /*update for improving performance
                    self._filter(items, searchTerm);
                    itemsToRender = $.grep(items, function (item1) {
                    return !o.autoFilter || item1.match;
                    });*/
                    itemsToRender = items;
                } else {
                    self._topHit = null;
                    itemsToRender = items;
                }
                if ((itemsToRender && itemsToRender.length > 0) || self._comboDiv) {
                    // open dropdown list
                    if (self._openlist(itemsToRender, data, searchTerm)) {
                        // move the trigger dropdown open event to openlist.
                        //self._trigger("open");
                        self._addInputFocus(true, wijCSS.stateFocus);
                    }
                } else {
                    self.close(null, true);
                }
                self._hideShowArrow(true);
            };

            /** Closes drop-down list.
            * @param {?EventObj} event The jquery event object.
            * @param {?boolean} skipAnimation A value indicating whehter to skip animation.
            */
            wijcombobox.prototype.close = function (event, skipAnimation) {
                var self = this, menu, wijCSS = this.options.wijCSS, hidingAnimation, hidingStyle;
                menu = self.menu;

                self._dropDownHeight = menu.element.outerHeight();
                self._dropDownWidth = menu.element.outerWidth();

                window.clearTimeout(self.closing);

                // test parent element is need, hidingAnimation
                // because some effect will wrap the target element.
                if (menu.element.is(":visible") && !menu.element.is(":animated") && !menu.element.parent().is(":animated")) {
                    self._trigger("close", event);
                    self._comboElement.attr("aria-expanded", "false");
                    menu.deactivate();
                    hidingAnimation = self.options.hidingAnimation;

                    //add for size animation by wuhao 2011/7/16
                    if (hidingAnimation && (hidingAnimation.effect === "size" || hidingAnimation.animated === "size")) {
                        hidingAnimation.options = $.extend({
                            to: {
                                width: 0,
                                height: 0
                            }
                        }, hidingAnimation.options);
                    }
                    hidingStyle = menu.element.attr("style");

                    //end for size animation
                    if (skipAnimation !== true && hidingAnimation) {
                        menu.element.hide(hidingAnimation.effect || hidingAnimation.animated, hidingAnimation.options, hidingAnimation.speed || hidingAnimation.duration, function () {
                            menu.element.removeAttr("style").attr("style", hidingStyle).hide();
                            if (hidingAnimation.callback) {
                                hidingAnimation.callback.apply(this, arguments);
                            }
                        });
                    } else {
                        menu.element.hide();
                    }

                    self._addInputFocus(false, wijCSS.stateFocus);

                    //$(document).unbind("click", self.closeOnClick);
                    $(document).unbind("mouseup", self.closeOnClick);
                    self._inputBlurCausedByListItemClick = false;
                }
            };

            wijcombobox.prototype._change = function () {
                // TODO: finish _change event.
                var self = this, o = self.options, f = o.forceSelectionText, m = o.selectionMode, ele = self._input, t = ele.val(), itm = self.selectedItem, items = self.selectedItems, oldIndex, innerData = self.innerData, inputIndex = -1;

                oldIndex = (o.selectedIndex || o.selectedIndex > -1) ? o.selectedIndex : -1;

                if (f) {
                    if (m === "single") {
                        if (itm !== null && itm !== undefined) {
                            if (itm.label !== t) {
                                //ele.val(itm.label);
                                self._setInputText(itm.label);
                            }
                        } else {
                            //ele.val("");
                            self._setInputText("");
                        }
                    }
                } else {
                    //update for inputed non-listed value,
                    //update selected index and selected value
                    if (m === "single") {
                        var labelNotEqualsT = false;
                        if (itm !== null && itm !== undefined) {
                            labelNotEqualsT = (itm.label) ? (itm.label.toString() !== t) : ("" !== t);
                        }

                        if ((!itm && t !== "") || labelNotEqualsT) {
                            if (self.selectedItem !== null && self.selectedItem !== undefined) {
                                self.selectedItem.selected = false;

                                self.menu.unselectItems(o.selectedIndex);
                            }
                            inputIndex = self._checkTextInItems(t);
                            if (inputIndex === -1) {
                                self.selectedItem = null;
                                o.selectedIndex = -1;
                                o.selectedValue = null;
                                o.inputTextInDropDownList = false;
                            } else {
                                if (innerData) {
                                    innerData = $.isArray(innerData) ? innerData : innerData.items;
                                    self.selectedItem = innerData[inputIndex];
                                    o.selectedIndex = inputIndex;
                                    o.selectedValue = self.selectedItem.value;
                                    o.inputTextInDropDownList = true;
                                }
                            }

                            //o.text = self._input.val();
                            self._setInputText(self._input.val());

                            self._triggerChangeEvents(itm, oldIndex);
                        } else {
                            self._setInputText(t);
                        }
                    }
                }

                //Todo: when input something to combobox,
                //the text will restore in multiple mode
                //Maybe it need to be adjusted.
                if (m === "multiple") {
                    //update for add issue: when iseditable is false
                    //click the all the combobox, the dropdown list will open
                    //self._selectedItemsToInputVal(self.selectedItems);
                    if (!self.selectedItems || self.selectedItems.length === 0) {
                        items = [itm];
                    }
                    self._selectedItemsToInputVal(items);
                }
            };

            wijcombobox.prototype._checkTextInItems = function (text) {
                var data = this.items, index = -1;

                if (text && !!data && !!data.length) {
                    $.each(data, function (i, item) {
                        if (item && item.label && item.label.toString() === text) {
                            index = i;
                            return false;
                        }
                    });
                }

                return index;
            };

            wijcombobox.prototype._openlist = function (items, data, searchTerm) {
                var self = data.self, o = self.options, eventObj = data.e, keypress, pressDELETEKey, textWidth, menuElement = self.menu.element, verticalBorder = 2, headerHeight = 0, dropDownHeight, origCloseOnClick, h, showingAnimation, showingStyle, showingSize, inputValueLength = $.trim(self._input.val()).length, keyCode = wijmo.getKeyCodeEnum(), zIndex, needHighlightMatching = false, innerData, updatePositionTimer, alreadyOpen = false;

                keypress = self._keypress = !!eventObj;
                pressDELETEKey = (eventObj !== undefined) && (eventObj.keyCode === keyCode.BACKSPACE || eventObj.keyCode === keyCode.DELETE);

                alreadyOpen = menuElement.is(":visible");

                if ($.ui) {
                    menuElement.zIndex(self.element.zIndex() + 100);
                } else {
                    zIndex = parseInt(self.element.css("zIndex"), 10);
                    if (isNaN(zIndex)) {
                        zIndex = 0;
                    }
                    menuElement.css("zIndex", zIndex + 100);
                }

                //update for 32309 issue
                if (!self.listHasCreated) {
                    self._createDropDownList();
                }

                if (self.innerData) {
                    if ($.isArray(self.innerData)) {
                        innerData = self.innerData;
                    } else {
                        innerData = self.innerData.items;
                    }
                }
                if (!innerData || innerData.length === 0) {
                    return false;
                }

                /* for improving performance
                if (self._comboDiv) {
                //update for case 20689 at 2012/4/11
                if (!self.listHasCreated) {
                //update for issue 24130 at 2012/7/20
                //self.menu.setTemplateItems(items);
                self.menu.setTemplateItems(o.data);
                self.menu.renderList();
                self.listHasCreated = true;
                }
                } else {
                if (!self.listHasCreated) {
                self.menu.setItems(items);
                self.menu.renderList();
                self.listHasCreated = true;
                }
                }*/
                //update for issue 24130 at 2012/7/20
                if (!self._usingRemoteData() && searchTerm !== null && searchTerm !== undefined) {
                    needHighlightMatching = self._keypress && o.isEditable && o.columns.length === 0 && o.highlightMatching && inputValueLength > 0;

                    //if down key press condition for 33017 issue at 2013/1/8
                    if (eventObj && eventObj.keyCode === keyCode.DOWN && searchTerm.length === 0 && inputValueLength > 0) {
                        self._topHit = self.menu.filterItems(self._input.val(), false, needHighlightMatching);
                    } else {
                        self._topHit = self.menu.filterItems(searchTerm, o.autoFilter, needHighlightMatching);
                    }

                    //can't find the matched items
                    if (self._topHit === null && self.innerData && $("li[wijhidden]", self.menu.element).length === self.innerData.length) {
                        self.close(null, true);
                        return false;
                    }
                }

                // show dropdown
                menuElement.show();
                textWidth = self._handleAdjustWidthOptions();

                dropDownHeight = o.dropdownHeight;

                if (menuElement.children(".wijmo-wijsuperpanel-header")) {
                    headerHeight = menuElement.children(".wijmo-wijsuperpanel-header").outerHeight() || 0;
                }

                //end for fixing bug 15778
                h = self._menuUL.outerHeight() + verticalBorder + headerHeight;

                if (h < dropDownHeight) {
                    // The exist scrollbar will be removed, width of ul element will increase, it means that the height of ul also will change.
                    // In this case, increase ul width firstly, and get a correct ul height for the wijlist element.
                    self._menuUL.setOutWidth(textWidth);
                    h = self._menuUL.outerHeight() + verticalBorder + headerHeight;
                } else {
                    h = dropDownHeight;
                }

                menuElement.setOutHeight(h);
                self.menu.refreshSuperPanel();
                self._positionList();
                if (!keypress && self.selectedItem !== undefined) {
                    self.menu.activate(null, self.selectedItem, true);
                }
                if (keypress && !pressDELETEKey) {
                    if (o.isEditable) {
                        self._runAutoComplete();
                    } else {
                        self.menu.activate(null, self._topHit, true);
                    }
                } else {
                    showingAnimation = self.options.showingAnimation;
                    if (o.showingAnimation !== null && !pressDELETEKey) {
                        self.menu.element.hide();
                        showingSize = {
                            from: { width: 0, height: 0 },
                            to: {
                                width: self._dropDownWidth || menuElement.outerWidth(),
                                height: self._dropDownHeight || menuElement.outerHeight()
                            }
                        };
                        if (showingAnimation && (showingAnimation.effect === "size" || showingAnimation.animated === "size")) {
                            showingAnimation.options = $.extend(showingSize, showingAnimation.options);
                        }
                        showingStyle = menuElement.attr("style");

                        //end for size animation
                        menuElement.show(showingAnimation.effect || showingAnimation.animated, showingAnimation.options, showingAnimation.speed || showingAnimation.duration, function () {
                            //add for size animation by wuhao 2011/7/16
                            menuElement.removeAttr("style").attr("style", showingStyle).show();

                            //end for size animation
                            if (showingAnimation.callback) {
                                showingAnimation.callback.apply(this, arguments);
                            }

                            if ($.browser.msie) {
                                menuElement.css("filter", "");
                            }
                        });
                    }
                }
                if (!self.hasOwnProperty("closeOnClick")) {
                    origCloseOnClick = self.closeOnClick;
                    self.closeOnClick = function (e) {
                        return origCloseOnClick(e);
                    };
                }

                if (!alreadyOpen) {
                    self._trigger("open");
                    self._comboElement.attr("aria-expanded", "true");
                }

                //update for issue 2012/6/14: place combobox in expander
                //open the dropdown, then collapse the expander
                //the dropdown is still open
                //$(document).bind("click", self, self.closeOnClick);
                $(document).bind("mouseup", self, self.closeOnClick);

                if (o.ensureDropDownOnBody) {
                    $(window).bind("resize.wijcombobox", function () {
                        //maybe need to update the position of dropdown
                        //because combobox may change its position after window resize.
                        if (updatePositionTimer) {
                            clearTimeout(updatePositionTimer);
                        }
                        updatePositionTimer = setTimeout(function () {
                            self._positionList();
                        }, 100);
                    });
                }
                return true;
            };

            /** @ignore */
            wijcombobox.prototype.closeOnClick = function (e) {
                var self = e.data, wijCSS = self.options.wijCSS, offset, t = e.target;

                if (!$.contains(self._comboElement[0], t) && !$.contains(self.menu.element[0], t)) {
                    if ($.support.isTouchEnabled && $.support.isTouchEnabled()) {
                        offset = self.menu.element.offset();
                        if (e.pageX < offset.left || e.pageX > offset.left + self.menu.element.width() || e.pageY < offset.top || e.pageY > offset.top + self.menu.element.height()) {
                            self.close();
                        }
                    } else {
                        self.close();
                    }
                    $("." + wijCSS.comboboxWrapperCss, self._comboElement[0]).removeClass(wijCSS.stateHover).removeClass(wijCSS.stateFocus);
                    $("." + wijCSS.comboboxTriggerCss, self._comboElement[0]).removeClass(wijCSS.stateHover).removeClass(wijCSS.stateFocus);
                }

                if (self.options.ensureDropDownOnBody) {
                    $(window).unbind("resize.wijcombobox");
                }
            };

            wijcombobox.prototype._positionList = function () {
                var self = this, defaultPosition, positionOptions = self.options.dropDownListPosition;
                defaultPosition = {
                    my: "left top",
                    at: "left bottom",
                    of: self._comboElement,
                    collision: "none"
                };
                defaultPosition = $.extend(defaultPosition, positionOptions);
                self.menu.element.position(defaultPosition);
            };

            wijcombobox.prototype._runAutoComplete = function () {
                var self = this, ele = self._input, topHit = self._topHit, oldText, fullText, start, end;
                if (!self.options.autoComplete || topHit === null || topHit === undefined) {
                    return;
                }
                self.menu.activate(null, topHit, true);
                oldText = ele.val();
                fullText = topHit.label;
                ele.val(fullText);
                start = oldText.length;
                end = fullText.length;
                self._selectText(start, end, ele);
            };

            wijcombobox.prototype._selectText = function (start, end, input) {
                var v = input.val(), inputElement = input.get(0), range;
                if (v.length > 0) {
                    if (inputElement.setSelectionRange !== undefined) {
                        inputElement.setSelectionRange(start, end);
                    } else if (inputElement.createTextRange !== undefined) {
                        range = inputElement.createTextRange();
                        range.moveStart("character", start);
                        range.moveEnd("character", end - v.length);
                        range.select();
                    }
                }
            };

            wijcombobox.prototype._move = function (direction, event) {
                if (!this.menu.element.is(":visible")) {
                    this.search("", event);
                    return;
                }
                if (this.menu.first() && /^previous/.test(direction) || this.menu.last() && /^next/.test(direction)) {
                    //update for fixing bug 15964 by wuhao
                    //this.menu.deactivate();
                    //end for bug 15964.
                    return;
                }
                this.menu[direction](event);
            };

            wijcombobox.prototype._escapeRegex = function (value) {
                if (value === undefined) {
                    return value;
                }
                return value.replace(/([\^\$\(\)\[\]\{\}\*\.\+\?\|\\])/gi, "\\$1");
            };

            wijcombobox.prototype._filter = function (array, searchTerm) {
                var term1 = this._escapeRegex(searchTerm), matcher, topHit = null;

                /// TODO : start with or contains and case sensitive.
                if (!array) {
                    return null;
                }
                matcher = new RegExp(term1, "i");
                $.each(array, function (index, item) {
                    if (term1 === undefined || term1.length === 0) {
                        item.match = true;
                        return;
                    }
                    var matchResult = matcher.exec(item.label);
                    if (matchResult === null) {
                        item.match = false;
                    } else {
                        if (topHit === null && matchResult.index === 0) {
                            topHit = item;
                        }
                        item.match = matchResult.index >= 0;
                    }
                });
                this._topHit = topHit;
                return array;
            };

            wijcombobox.prototype._getMaxListItemWidth = function () {
                var $div = $("<div>").addClass("wijmo-wijcombobox-list ui-widget").appendTo(document.body), $ul = this.menu.element.find("ul").clone().css("width", "").appendTo($div), width = $ul.outerWidth();

                $div.remove();
                return width;
            };

            wijcombobox.prototype._setComboWidth = function (width) {
                this._comboElement.width(width);
                if (this._triggerArrow) {
                    width -= this._triggerArrow.outerWidth();
                }
                this._input.width(width);
            };

            wijcombobox.prototype._setDropdownWidth = function (width) {
                var $list = this.menu.element, padding = $list.css("padding");
                $list.css("padding", "0px");
                $list.setOutWidth(width);
                $list.css("padding", padding);
            };

            wijcombobox.prototype._getComboWidth = function () {
                return this._comboElement.outerWidth();
            };

            wijcombobox.prototype._getDropdownWidth = function () {
                return this.menu.element.outerWidth();
            };
            return wijcombobox;
        })(wijmo.wijmoWidget);
        combobox.wijcombobox = wijcombobox;

        var wijcombobox_options = (function () {
            function wijcombobox_options() {
                /** Selector option for auto self initialization. This option is internal.
                * @ignore
                */
                this.initSelector = ":jqmData(role='wijcombobox')";
                /**
                * @ignore
                */
                this.wijCSS = {
                    comboboxCss: "wijmo-wijcombobox",
                    comboboxWrapperCss: "wijmo-wijcombobox-wrapper",
                    comoboboxInputCss: "wijmo-wijcombobox-input",
                    comboboxListCss: "wijmo-wijcombobox-list",
                    comboboxTriggerCss: "wijmo-wijcombobox-trigger"
                };
                /** wijdataview to which this wijcombobox is bound.
                * @type {wijdataview}
                * @remarks
                *   This option is used if this wijcombobox is bound to a wijdataview.
                *   In that case, you can also specify a mapping option to select the properties to bind to,
                *   and the data option returns an array of objects containing
                *   value and label property values determined by that mapping.
                */
                this.dataSource = null;
                /** A value that specifies the underlying data source provider of wijcombobox.
                * @type {wijdatasource|Array}
                * @remarks
                *   This option could either be a wijdatasource object
                *   or an Object Array containing an item such as
                *   {label: "label text", value: "value"}.
                * @example
                *        var testArray = [
                *            {label: 'c++',value: 'c++'},
                *            {label: 'java',value: 'java'},
                *            {label: 'php',value: 'php'}
                *        ];
                *        $("#tags").wijcombobox({
                *            data: testArray
                *        });
                */
                this.data = null;
                /** A value that specifies the text in the wijcombobox label.*/
                this.labelText = null;
                /** A value that determines the minimum length of text
                *   that can be entered in the wijcombobox text box to issue an AJAX request.
                */
                this.minLength = 4;
                /** A value that determines the duration (in milliseconds) of the time
                *   to delay before autocomplete begins after typing stops.
                */
                this.delay = 300;
                /** A value that specifies the animation options for a drop-down list
                *   when it is visible.
                * @example
                *       var animationOptions = {
                *           animated: "Drop",
                *           duration: 1000
                *       };
                *       $("#tags").wijcombobox("option", "showingAnimation", animationOptions)
                });
                */
                this.showingAnimation = null;
                /** A value that specifies the animation options such as the animation effect and
                *   duration for the drop-down list when it is hidden.
                * @example
                *       var animationOptions = {
                *           animated: "Drop",
                *           duration: 1000
                *       };
                *       $("#tags").wijcombobox("option", "hidingAnimation", animationOptions)
                */
                this.hidingAnimation = null;
                /** A value that determines whether to show the trigger of wijcombobox.*/
                this.showTrigger = true;
                /** A value that specifies the position of the drop-down list trigger.
                * @remarks
                *        possible value: right or left
                */
                this.triggerPosition = "right";
                /**  A value that specifies the height of the drop-down list.
                * @remarks
                *       If the total height of all items is less than the value of this option,
                *       it will use the total height of items as the height of the drop-down list.
                */
                this.dropdownHeight = 300;
                /** A value that specifies the width of the drop-down list.
                * @type {number|string}
                * @remarks
                *       When this option is set to "auto", the width of the drop-down
                *       list is equal to the width of wijcombobox.
                *       When this option is set to "fit", the width of the drop-down
                *       list will fit the widest item independently.
                */
                this.dropdownWidth = "auto";
                /** A value that determines whether to select the item when the item gains focus or is activated. */
                this.selectOnItemFocus = false;
                /** A value determines whether to shorten the drop-down list items
                *   by matching the text in the textbox after typing.
                */
                this.autoFilter = true;
                /** A value that determines whether to start the auto-complete
                *   function after typing in the text if a match exists.
                */
                this.autoComplete = true;
                /** A value that determines whether to highlight the keywords in an item.
                * @remarks
                *       If "abc" is typed in the textbox,
                *       all "abc" matches are highlighted in the drop-down list.
                */
                this.highlightMatching = true;
                /** A value that specifies the position options of the drop-down list.
                *   The default value of the "of" options is the input of wijcombobox.
                * @example
                *    var positionOptions = {my:"right", at:"top"};
                *   //specifies the position options of the drop-down list on "right, top" of combobox.
                *   $("#tags").wijcombobox("option", "dropDownListPosition", positionOptions)
                */
                this.dropDownListPosition = {};
                /** An array that specifies the column collections of wijcombobox.
                * @example
                *       $("#tags").wijcombobox("option", "columns", [
                *           {name: 'header1', width: 150},
                *           {name: 'header2', width: 150},
                *           {name: 'header3', width: 150}
                *       ]);
                */
                this.columns = [];
                /** A value that specifies the selection mode of wijcombobox.
                * @remarks
                *       Possible options are: "single" and "multiple".
                */
                this.selectionMode = "single";
                /** A value that specifies the separator for
                *   the multiple selected items text in the textbox.
                */
                this.multipleSelectionSeparator = ",";
                /** A value that determines whether to check the input text against
                *   the text of the selected item when the focus blurs.
                * @remarks
                *       If the text does not match any item, input text will restore
                *       to text the selected item or empty if no item is selected.
                */
                this.forceSelectionText = false;
                /** A function called when any item in list is selected.
                * @event
                * @dataKey {element} element LI element with this item.
                * @dataKey {object} list wijlist instance.
                * @dataKey {string} label Label of item.
                * @dataKey {object} value Value of item.
                * @dataKey {string} text Could be set in handler to override rendered label of item.
                */
                this.select = null;
                /** A value that determines whether input is editable.*/
                this.isEditable = true;
                /** A value that specifies the index of the item to select when using single mode.
                * @type {number|array}
                * @remarks
                *       If the selectionMode is "multiple", then this option could be set
                *       to an array of Number which contains the indices of the items to select.
                *       If no item is selected, it will return -1.
                * @example
                *  //To get the selected item using the selected index:
                *      var selectedIndex = $("# tags ").wijcombobox("option","selectedIndex");
                *      var selectedItem = $("# tags ").wijcombobox("option","data")[selectedIndex];
                *  // To set the selected item using the selected index:
                *      $("#tags").wijcombobox("option"," selectedIndex", 5);
                */
                this.selectedIndex = -1;
                /** A value that specifies the value of the item to select when using single mode.
                * @type {number|string|object}
                * @remarks
                *       If no item is selected, it will return null.
                */
                this.selectedValue = null;
                /** A value that specifies the input text of the combobox is in dropdown list or not.
                * @remarks
                *       It's readonly option, if user typed text is not in dropdown list, it returns false;
                *       if user selects a item form the dropdown list or typed text in dropdown list, it returns true.
                */
                this.inputTextInDropDownList = false;
                /** A value that specifies the input text of the combobox.
                * @type {string}
                * @remarks
                *       When set the text by code, it will not affect the selectedIndex and selectedValue.
                */
                this.text = null;
                /** A value indicating the dropdown element will be append to the body or combobox container.
                * @remarks
                *       If the value is true, the dropdown list will be appended to body element.
                *       else it will append to the combobox container.
                */
                this.ensureDropDownOnBody = true;
                /** This event is triggered when the drop-down list is opened.
                * @event
                */
                this.open = null;
                /** This event is triggered when the drop-down list is closed.
                * @event
                */
                this.close = null;
                /** A value added to the width of the original HTML select element to account
                *   for the scroll bar width of the drop-down list.
                * @remarks
                *       Unit for this value is pixel.
                *       Because the width of the scroll bar may be different between browsers
                *       if wijcombobox is initialized with the width of the HTML select element,
                *       the text may be hidden by the scroll bar of wijcombobox.
                */
                this.selectElementWidthFix = 6;
                /** This event is triggered when a user searches an item in the drop-down list either
                *  by typing in the textbox or by calling the search method of wijcombobox.
                * @event
                * @dataKey {datasource} datasrc The datasource of wijcombobox.
                * @dataKey {string} term The text to search.
                */
                this.search = null;
                /** The event is obsolete event.
                *  A function called when select item is changed.
                * @event
                * @param {Object} e The jQuery.Event object.
                * @param {IselectedEventArgs} data The data with this event.
                */
                this.changed = null;
                /** This event is triggered when the text of the combobox is changed.
                * @event
                * @dataKey {string} oldText The old text of combobox.
                * @dataKey {string} newText The new text of combobox.
                */
                this.textChanged = null;
                /** This event is triggered when the selected index of the combobox is changed.
                * @event
                * @param {Object} e The jQuery.Event object.
                * @param {IselectedEventArgs} data The data with this event.
                */
                this.selectedIndexChanged = null;
                /** A function called when the selected index of the comboBox is about to change.
                *  Cancellable. If return false, the select operation will be canceled.
                * @event
                * @param {Object} e The jQuery.Event object.
                * @param {IselectedEventArgs} data The data with this event.
                */
                this.selectedIndexChanging = null;
                /** A value that determines the object that contains the options of wijlist.*/
                this.listOptions = null;
                /** A value that determines whether to fit the width of combobox to that of the dropdown.
                * @type {boolean}
                */
                this.adjustComboWidth = false;
            }
            return wijcombobox_options;
        })();
        ;
        wijcombobox.prototype.options = $.extend(true, {}, wijmo.wijmoWidget.prototype.options, new wijcombobox_options());
        $.wijmo.registerWidget("wijcombobox", wijcombobox.prototype);

        //prevent jqm's default behavior for <input> markup.
        if ($.mobile && $.mobile.textinput && $.mobile.textinput.initSelector) {
            $.mobile.textinput.initSelector = $.map($.mobile.textinput.initSelector.split(","), function (s) {
                return s + ":not(:jqmData(role='wijcombobox'))";
            }).join(",");
        }

        
    })(wijmo.combobox || (wijmo.combobox = {}));
    var combobox = wijmo.combobox;
})(wijmo || (wijmo = {}));

;
var wijmo;
(function (wijmo) {
    (function (input) {
        /** @ignore */
        var CharType = (function () {
            function CharType() {
                /// <summary>
                ///   Indicates that the character is not of a particular category.
                /// </summary>
                this.OtherChar = 0x0000;
                /// <summary>
                ///   Indicates that the character is a control code.
                /// </summary>
                this.Control = 0x0001;
                /// <summary>
                ///   Indicates that the character is a numeric digit.
                /// </summary>
                this.Numeric = 0x0002;
                /// <summary>
                ///   Indicates that the character is a mathematical symbol.
                /// </summary>
                this.MathSymbol = 0x0003;
                /// <summary>
                ///   Indicates that the character is a symbol.
                /// </summary>
                this.Symbol = 0x0004;
                /// <summary>
                ///   Indicates that the character is a punctuation. ( Open &amp; Close )
                /// </summary>
                this.Punctuation = 0x0005;
                /// <summary>
                ///   Indicates that the character is a space character.
                /// </summary>
                this.Space = 0x0006;
                /// <summary>
                ///   Indicates that the character is an upper case letter.
                /// </summary>
                this.UpperCase = 0x0007;
                /// <summary>
                ///   Indicates that the character is a lower case letter.
                /// </summary>
                this.LowerCase = 0x0008;
                /// <summary>
                ///   Indicates that the character is a Japanese Katakana character.
                /// </summary>
                this.Katakana = 0x0009;
                /// <summary>
                ///   Indicates that the character is a Japanese Hiragana character.
                /// </summary>
                this.Hiragana = 0x000a;
                /// <summary>
                ///   Indicates that the character is a CJK punctuation.
                /// </summary>
                this.FarEastPunctation = 0x000b;
                /// <summary>
                ///   Indicates that the character is a Hangal character.
                /// </summary>
                this.Hangul = 0x000c;
                /// <summary>
                ///   Indicates that the character is of full width.
                /// </summary>
                this.FullWidth = 0x8000;
            }
            return CharType;
        })();
        input.CharType = CharType;

        /** @ignore */
        var CharCategory = (function () {
            function CharCategory() {
                // Min & Max values ----------------------------------
                ///   Represents the smallest possible value of a Char.
                ///   This field is constant.
                this.MinValue = '\u0000';
                ///   Represents the largest possible value of a Char.
                ///   This field is constant.
                this.MaxValue = '\uffff';
                //Full/HalfWidth characters (different cultures)------
                this.ANSISTART = 0x0000;
                this.ANSIEND = 0x00ff;
                this.BOTHWIDTHSTART = 0xff00;
                this.BOTHWIDTHEND = 0xffef;
                this.FULLALPHASTART = 0xff01;
                this.FULLUPPERSTART = 0xff21;
                this.FULLUPPEREND = 0xff3a;
                this.FULLALPHAEND = 0xff5e;
                this.CJKHALFSYMBOLSTART = 0xff61;
                this.CJKHALFSYMBOLEND = 0xff64;
                this.KANAHALFSTART = 0xff65;
                this.KANAHALFEND = 0xff9f;
                this.HANGULHALFSTART = 0xffa0;
                this.HANGULHALFEND = 0xffdc;
                this.FULLSYMBOLSTART = 0xffe0;
                this.FULLSYMBOLEND = 0xffe6;
                this.HALFPUNCTSTART = 0xffe8;
                this.HALFPUNCTEND = 0xffee;
                // Voiced characters (Japanese)------------------------
                this.KATAKANA_VOICED = '\uff9e';
                this.KATAKANA_SEMIVOICED = '\uff9f';
                //Others-----------------------------------------------
                this.Tab = '\u0009';
                this.Space = '\u0020';
                //>>> Static Data (tables) ----------------------------
                // Character Groups...
                ///   Character groups (character codes) based on Unicode 3.1.
                this._charstarts = [
                    '\u0000',
                    '\u0080',
                    '\u0100',
                    '\u0180',
                    '\u0250',
                    '\u02b0',
                    '\u0300',
                    '\u0370',
                    '\u0400',
                    '\u0530',
                    '\u0590',
                    '\u0600',
                    '\u0700',
                    '\u0780',
                    '\u0900',
                    '\u0980',
                    '\u0a00',
                    '\u0a80',
                    '\u0b00',
                    '\u0b80',
                    '\u0c00',
                    '\u0c80',
                    '\u0d00',
                    '\u0d80',
                    '\u0e00',
                    '\u0e80',
                    '\u0f00',
                    '\u1000',
                    '\u10a0',
                    '\u1100',
                    '\u1200',
                    '\u13a0',
                    '\u1400',
                    '\u1680',
                    '\u16a0',
                    '\u1780',
                    '\u1800',
                    '\u1e00',
                    '\u1f00',
                    '\u2000',
                    '\u2070',
                    '\u20a0',
                    '\u20d0',
                    '\u2100',
                    '\u2150',
                    '\u2190',
                    '\u2200',
                    '\u2300',
                    '\u2400',
                    '\u2440',
                    '\u2460',
                    '\u2500',
                    '\u2580',
                    '\u25a0',
                    '\u2600',
                    '\u2700',
                    '\u2800',
                    '\u2e80',
                    '\u2f00',
                    '\u2ff0',
                    '\u3000',
                    '\u3040',
                    '\u30a0',
                    '\u3100',
                    '\u3130',
                    '\u3190',
                    '\u31a0',
                    '\u3200',
                    '\u3300',
                    '\u3400',
                    '\u4e00',
                    '\ua000',
                    '\ua490',
                    '\uac00',
                    '\uf900',
                    '\ufb00',
                    '\ufb50',
                    '\ufe20',
                    '\ufe30',
                    '\ufe50',
                    '\ufe70',
                    '\uff00',
                    '\ufff0'
                ];
                //Character Block Categories...
                ///   Character blocks categorized base on the Unicode standard.
                this.Blocks = [
                    'BASIC_LATIN',
                    'LATIN_1_SUPPLEMENT',
                    'LATIN_EXTENDED_A',
                    'LATIN_EXTENDED_B',
                    'IPA_EXTENSIONS',
                    'SPACING_MODIFIER_LETTERS',
                    'COMBINING_DIACRITICAL_MARKS',
                    'GREEK',
                    'CYRILLIC',
                    'ARMENIAN',
                    'HEBREW',
                    'ARABIC',
                    'SYRIAC',
                    'THAANA',
                    'DEVANAGARI',
                    'BENGALI',
                    'GURMUKHI',
                    'GUJARATI',
                    'ORIYA',
                    'TAMIL',
                    'TELUGU',
                    'KANNADA',
                    'MALAYALAM',
                    'SINHALA',
                    'THAI',
                    'LAO',
                    'TIBETAN',
                    'MYANMAR',
                    'GEORGIAN',
                    'HANGUL_JAMO',
                    'ETHIOPIC',
                    'CHEROKEE',
                    'UNIFIED_CANADIAN_ABORIGINAL_SYLLABIC',
                    'OGHAM',
                    'RUNIC',
                    'KUMER',
                    'MONGOLIAN',
                    'LATIN_EXTENDED_ADDITIONAL',
                    'GREEK_EXTENDED',
                    'GENERAL_PUNCTUATION',
                    'SUPERSCRIPTS_AND_SUBSCRIPTS',
                    'CURRENCY_SYMBOLS',
                    'COMBINING_MARKS_FOR_SYMBOLS',
                    'LETTERLIKE_SYMBOLS',
                    'NUMBER_FORMS',
                    'ARROWS',
                    'MATHEMATICAL_OPERATORS',
                    'MISCELLANEOUS_TECHNICAL',
                    'CONTROL_PICTURES',
                    'OPTICAL_CHARACTER_RECOGNITION',
                    'ENCLOSED_ALPHANUMERICS',
                    'BOX_DRAWING',
                    'BLOCK_ELEMENTS',
                    'GEOMETRIC_SHAPES',
                    'MISCELLANEOUS_SYMBOLS',
                    'DINGBATS',
                    'BRAILLE_PATTERNS',
                    'CJK_RADICALS_SUPPLEMENT',
                    'KANGXI_RADICALS',
                    'IDEOGRAPHIC_DESCRIPTION_CHARACTERS',
                    'CJK_SYMBOLS_AND_PUNCTUATION',
                    'HIRAGANA',
                    'KATAKANA',
                    'BOPOMOFO',
                    'HANGUL_COMPATIBILITY_JAMO',
                    'KANBUN',
                    'BOPOMOFO_EXTENDED',
                    'ENCLOSED_CJK_LETTERS_AND_MONTHS',
                    'CJK_COMPATIBILITY',
                    'CJK_UNIFIED_IDEOGRAPHS_EXTENSION',
                    'CJK_UNIFIED_IDEOGRAPHS',
                    'YI_SYLLABLES',
                    'YI_RADICALS',
                    'HANGUL_SYLLABLES',
                    'CJK_COMPATIBILITY_IDEOGRAPHS',
                    'ALPHABETIC_PRESENTATION_FORMS',
                    'ARABIC_PRESENTATION_FORMS_A',
                    'COMBINING_HALF_MARKS',
                    'CJK_COMPATIBILITY_FORMS',
                    'SMALL_FORM_VARIANTS',
                    'ARABIC_PRESENTATION_FORMS_B',
                    'HALFWIDTH_AND_FULLWIDTH_FORMS',
                    'SPECIALS'
                ];
                // Multi width character block mapping table...
                ///   Table of multi-width character blocks.
                this._fullhalfblocks = [
                    '\uff01',
                    '\uff10',
                    '\uff1a',
                    '\uff21',
                    '\uff3b',
                    '\uff41',
                    '\uff5b',
                    '\uff61',
                    '\uff65',
                    '\uffa0',
                    '\uffe0',
                    '\uffe8'
                ];
                // Half width Katakana map table...
                ///   Mapping table of full width Katakana.
                this._halfkana = [
                    '\u30fb', '\u30f2',
                    '\u30a1', '\u30a3', '\u30a5', '\u30a7', '\u30a9',
                    '\u30e3', '\u30e5', '\u30e7',
                    '\u30c3', '\u30fc',
                    '\u30a2', '\u30a4', '\u30a6', '\u30a8', '\u30aa',
                    '\u30ab', '\u30ad', '\u30af', '\u30b1', '\u30b3',
                    '\u30b5', '\u30b7', '\u30b9', '\u30bb', '\u30bd',
                    '\u30bf', '\u30c1', '\u30c4', '\u30c6', '\u30c8',
                    '\u30ca', '\u30cb', '\u30cc', '\u30cd', '\u30ce',
                    '\u30cf', '\u30d2', '\u30d5', '\u30d8', '\u30db',
                    '\u30de', '\u30df', '\u30e0', '\u30e1', '\u30e2',
                    '\u30e4', '\u30e6', '\u30e8',
                    '\u30e9', '\u30ea', '\u30eb', '\u30ec', '\u30ed',
                    '\u30ef', '\u30f3',
                    '\u3099', '\u309a'
                ];
                // Full width Katakana map table...
                ///   Mapping table of half-width Katakana.
                this._fullkana = [
                    '\uff67', '\uff71', '\uff68', '\uff72', '\uff69', '\uff73',
                    '\uff6a', '\uff74', '\uff6b', '\uff75',
                    '\uff76', '\uff76', '\uff77', '\uff77', '\uff78', '\uff78',
                    '\uff79', '\uff79', '\uff7a', '\uff7a',
                    '\uff7b', '\uff7b', '\uff7c', '\uff7c', '\uff7d', '\uff7d',
                    '\uff7e', '\uff7e', '\uff7f', '\uff7f',
                    '\uff80', '\uff80', '\uff81', '\uff81', '\uff6f', '\uff82',
                    '\uff82', '\uff83', '\uff83', '\uff84', '\uff84',
                    '\uff85', '\uff86', '\uff87', '\uff88', '\uff89',
                    '\uff8a', '\uff8a', '\uff8a', '\uff8b', '\uff8b', '\uff8b',
                    '\uff8c', '\uff8c', '\uff8c', '\uff8d', '\uff8d', '\uff8d',
                    '\uff8e', '\uff8e', '\uff8e',
                    '\uff8f', '\uff90', '\uff91', '\uff92', '\uff93',
                    '\uff6c', '\uff94', '\uff6d', '\uff95', '\uff6e', '\uff96',
                    '\uff97', '\uff98', '\uff99', '\uff9a', '\uff9b',
                    '\uff9c', '\uff9c', '\uff68', '\uff6a', '\uff66', '\uff9d',
                    '\uff73', '\uff76', '\uff79', '\uff9c', '\uff68', '\uff6a',
                    '\uff66',
                    '\uff65', '\uff70'
                ];
                this._fullkanaSmall = [
                    '\uff67', '\uff68', '\uff69', '\uff6a', '\uff6b',
                    '\uff6c', '\uff6d', '\uff6e', '\uff6f'
                ];
                // Voiced (accent) map table (Japanese)...
                ///   Mapping table for accents for the Japanese language.
                this._accentkana = [
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                    -1, 1, -1, 1, -1, 1, -1, 1, -1, 1,
                    -1, 1, -1, 1, -1, 1, -1, 1, -1, 1,
                    -1, 1, -1, 1, 0, -1, 1, -1, 1, -1, 1,
                    0, 0, 0, 0, 0,
                    -3, 1, 2, -3, 1, 2, -3, 1, 2, -3, 1, 2, -3, 1, 2,
                    0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0,
                    0, 0, 0, 0, 0, 0,
                    1, 0, 0, 1, 1, 1,
                    1,
                    0, 0
                ];
                // Special quotations for FarEast...
                this._feQuotes = ['\u2018', '\u2019', '\u201c', '\u201d'];
                // Katakana & Hiragana mixed characters (Japanese)...
                this._jpnMixed = ['\u30fc'];
                // Full / Half width special character map table...
                this._jpnSpecialFull = [
                    '\u3000',
                    '\u3001',
                    '\u3002',
                    '\u300c',
                    '\u300d',
                    '\u201c',
                    '\u201d',
                    '\u2018',
                    '\u2019',
                    '\u309b',
                    '\u309c',
                    '\uffe5'
                ];
                this._jpnSpecialHalf = [
                    '\u0020',
                    '\uff64',
                    '\uff61',
                    '\uff62',
                    '\uff63',
                    '\u0022',
                    '\u0022',
                    '\u0027',
                    '\u0027',
                    '\uff9e',
                    '\uff9f',
                    '\u00a5'
                ];
                var _charType = new CharType();
                this._mwtable = [
                    _charType.Symbol | _charType.FullWidth,
                    _charType.Numeric | _charType.FullWidth,
                    _charType.Symbol | _charType.FullWidth,
                    _charType.UpperCase | _charType.FullWidth,
                    _charType.Symbol | _charType.FullWidth,
                    _charType.LowerCase | _charType.FullWidth,
                    _charType.Symbol | _charType.FullWidth,
                    _charType.FarEastPunctation,
                    _charType.Katakana,
                    _charType.Hangul,
                    _charType.Symbol | _charType.FullWidth,
                    _charType.Symbol
                ];
            }
            return CharCategory;
        })();
        input.CharCategory = CharCategory;

        /** @ignore */
        var CharProcess = (function () {
            function CharProcess() {
                this.CharCategory = new CharCategory();
                this.Ctype = new CharType();
            }
            CharProcess.prototype.ToHalfKatakana = function (c) {
                var result = "";
                if (this.IsFullWidth(c)) {
                    if (this.IsKatakana(c)) {
                        var katakana = c;
                        var n = katakana.charCodeAt(0) - (this.CharCategory._charstarts[62].charCodeAt(0) + 1);
                        if (n < 0 || n > 91) {
                            return katakana;
                        }
                        katakana = this.CharCategory._fullkana[n];

                        var accent = this.CharCategory._accentkana[n];

                        if (accent > 0) {
                            //accent == 1 ? this.CharCategory.KATAKANA_VOICED.charCodeAt(0) : this.CharCategory.KATAKANA_SEMIVOICED.charCodeAt(0) ;
                            katakana = katakana + String.fromCharCode(accent == 1 ? this.CharCategory.KATAKANA_VOICED.charCodeAt(0) : this.CharCategory.KATAKANA_SEMIVOICED.charCodeAt(0));
                        }
                        result = katakana;
                    } else if (this.IsHiragana(c)) {
                        var katakana = String.fromCharCode(c.charCodeAt(0) - this.CharCategory._charstarts[61].charCodeAt(0) + this.CharCategory._charstarts[62].charCodeAt(0));
                        var n = katakana.charCodeAt(0) - (this.CharCategory._charstarts[62].charCodeAt(0) + 1);
                        if (n < 0 || n > 91) {
                            return katakana;
                        }
                        katakana = this.CharCategory._fullkana[n];

                        var accent = this.CharCategory._accentkana[n];

                        if (accent > 0) {
                            //accent == 1 ? this.CharCategory.KATAKANA_VOICED.charCodeAt(0) : this.CharCategory.KATAKANA_SEMIVOICED.charCodeAt(0) ;
                            katakana = katakana + String.fromCharCode(accent == 1 ? this.CharCategory.KATAKANA_VOICED.charCodeAt(0) : this.CharCategory.KATAKANA_SEMIVOICED.charCodeAt(0));
                        }
                        result = katakana;
                    }
                } else {
                    if (this.IsKatakana(c)) {
                        result = c;
                    }
                }

                return result;
            };

            CharProcess.prototype.GetCharType = function (c) {
                var ctype = this.Ctype.OtherChar;
                var block = this.BelongTo(c);

                if (c == '\u007f' || ('\u0000' <= c && c <= '\u001f') || ('\u0080' <= c && c <= '\u009f'))
                    return this.Ctype.Control;

                if ('A' <= c && c <= 'Z')
                    return this.Ctype.UpperCase;

                if ('a' <= c && c <= 'z')
                    return this.Ctype.LowerCase;

                if ('0' <= c && c <= '9')
                    return this.Ctype.Numeric;

                //modified by sj
                //the logic that charex call textfilter is wrong
                //	var tFilter = new TextFilter(true,true,"");
                //	if (tFilter.IsSymbol(c))
                //	{
                //		ctype = this.Ctype.Symbol;
                //	}
                if (this.IsFullWidthSymbol(c) || this.IsHalfWidthSymbol(c)) {
                    ctype = this.Ctype.Symbol;
                }

                //end by sj
                if (c.charCodeAt(0) == 8216 || c.charCodeAt(0) == 8217 || c.charCodeAt(0) == 8220 || c.charCodeAt(0) == 8221)
                    ctype = this.Ctype.Punctuation;

                if (c.charCodeAt(0) == 12288)
                    ctype = this.Ctype.Space;

                switch (this.CharCategory.Blocks[block]) {
                    case 'HALFWIDTH_AND_FULLWIDTH_FORMS':
                        return this.MultiWidthDetails(c);
                    case 'KATAKANA':
                        return this.Ctype.Katakana | this.Ctype.FullWidth;
                    case 'HIRAGANA':
                        return this.Ctype.Hiragana | this.Ctype.FullWidth;
                }

                if (this.IsFarEastBlock(block, c))
                    ctype |= this.Ctype.FullWidth;

                return ctype;
            };

            CharProcess.prototype.IsCharOfType = function (c, type) {
                return this.GetCharType(c) == type;
            };

            CharProcess.prototype.IsMultiWidth = function (c) {
                var block = this.BelongTo(c);
                var category = this.CharCategory.Blocks[block];
                return (category == 'KATAKANA' || category == 'CJK_SYMBOLS_AND_PUNCTUATION' || category == 'HALFWIDTH_AND_FULLWIDTH_FORMS' || (category == 'BASIC_LATIN' && c >= '\u0020'));
            };

            CharProcess.prototype.IsFullWidthSymbol = function (c) {
                for (var i = 0; i < CharProcess.FullWidthSymbolArray.length; i++) {
                    if (c === CharProcess.FullWidthSymbolArray[i]) {
                        return true;
                    }
                }
                return false;
            };

            CharProcess.prototype.IsHalfWidthSymbol = function (c) {
                for (var i = 0; i < CharProcess.HalfWidthSymbolArray.length; i++) {
                    if (c === CharProcess.HalfWidthSymbolArray[i]) {
                        return true;
                    }
                }
                return false;
            };

            CharProcess.prototype.IsFullWidth = function (c) {
                if (this.IsFullWidthSymbol(c)) {
                    return true;
                }

                if (this.IsHalfWidthSymbol(c)) {
                    return false;
                }

                var block = this.BelongTo(c);

                var bFullWidth = this.IsFarEastBlock(block, c);
                if (this.CharCategory.Blocks[block] == 'HALFWIDTH_AND_FULLWIDTH_FORMS')
                    bFullWidth = ((this.MultiWidthDetails(c) & this.Ctype.FullWidth) == this.Ctype.FullWidth);

                return bFullWidth;
            };

            CharProcess.prototype.IsSurrogatePair = function (c) {
                if (c.charCodeAt(0) >= '\uD800'.charCodeAt(0) && c.charCodeAt(0) <= '\uDBFF'.charCodeAt(0) && c.charCodeAt(1) >= '\uDC00'.charCodeAt(0) && c.charCodeAt(1) <= '\uDFFF'.charCodeAt(0)) {
                    return true;
                }

                return false;
            };

            CharProcess.prototype.IsSurrogate = function (c) {
                return c != null && ((c.charCodeAt(0) >= '\uD800'.charCodeAt(0)) && c.charCodeAt(0) <= '\uDFFF'.charCodeAt(0));
            };

            CharProcess.prototype.IsOther = function (c) {
                return ((this.GetCharType(c) & ~this.Ctype.FullWidth) == this.Ctype.OtherChar);
            };

            CharProcess.prototype.IsControl = function (c) {
                return ((this.GetCharType(c) & ~this.Ctype.FullWidth) == this.Ctype.Control);
            };

            CharProcess.prototype.IsKatakana = function (c) {
                return ((this.GetCharType(c) & ~this.Ctype.FullWidth) == this.Ctype.Katakana);
            };

            CharProcess.prototype.IsSmallHalfKatakana = function (c) {
                var _halfkanaSmall = new Array('\u30a1', '\u30a3', '\u30a5', '\u30a7', '\u30a9', '\u30e3', '\u30e5', '\u30e7', '\u30c3', '\u30ee');

                var c1 = c;
                if (c.charCodeAt(0) > this.CharCategory.KANAHALFSTART) {
                    c1 = this.CharCategory._halfkana[c.charCodeAt(0) - this.CharCategory.KANAHALFSTART];
                }
                for (var i = 0; i < _halfkanaSmall.length; i++) {
                    if (c1 == _halfkanaSmall[i]) {
                        return true;
                    }
                }
                return false;
            };

            CharProcess.prototype.IsHiragana = function (c) {
                return (((this.GetCharType(c) & ~this.Ctype.FullWidth) == this.Ctype.Hiragana) || (this.CharCategory._jpnMixed[0] == c));
                //--------------------------------------------------------------------------------------------------
            };

            CharProcess.prototype.IsShiftJIS = function (c) {
                //var unicode = c.charCodeAt(0);
                //var offset = Math.floor(unicode / 8);
                //var mod = unicode % 8;
                //var flagString = CharProcess.ShiftJISCode.substr(offset * 2, 2);
                //var binaryString = parseInt(flagString, 16).toString(2);
                //while (binaryString.length < 8)
                //{
                //    binaryString = "0" + binaryString;
                //}
                //if (binaryString.substr(mod, 1) == "1")
                //{
                //    return true;
                //}
                return false;
            };

            CharProcess.prototype.IsJISX0208 = function (c) {
                //var unicode = c.charCodeAt(0);
                //var offset = Math.floor(unicode / 8);
                //var mod = unicode % 8;
                //var flagString = CharProcess.JISX0208Code.substr(offset * 2, 2);
                //var binaryString = parseInt(flagString, 16).toString(2);
                //while (binaryString.length < 8)
                //{
                //    binaryString = "0" + binaryString;
                //}
                //if (binaryString.substr(mod, 1) == "1")
                //{
                //    return true;
                //}
                return false;
            };

            CharProcess.prototype.IsDigit = function (c) {
                return ((this.GetCharType(c) & ~this.Ctype.FullWidth) == this.Ctype.Numeric);
            };

            CharProcess.prototype.IsPunctuation = function (c) {
                return ((this.GetCharType(c) & ~this.Ctype.FullWidth) == this.Ctype.Punctuation);
            };

            CharProcess.prototype.IsMathSymbol = function (c) {
                return ((this.GetCharType(c) & ~this.Ctype.FullWidth) == this.Ctype.MathSymbol);
            };

            CharProcess.prototype.IsSymbol = function (c) {
                return ((this.GetCharType(c) & ~this.Ctype.FullWidth) == this.Ctype.Symbol);
            };

            CharProcess.prototype.IsLower = function (c) {
                return ((this.GetCharType(c) & ~this.Ctype.FullWidth) == this.Ctype.LowerCase);
            };

            CharProcess.prototype.IsUpper = function (c) {
                return ((this.GetCharType(c) & ~this.Ctype.FullWidth) == this.Ctype.UpperCase);
            };

            CharProcess.prototype.IsDigitOrSymbol = function (c) {
                return (this.IsDigit(c) || this.IsMathSymbol(c));
            };

            CharProcess.prototype.IsAlphabet = function (c) {
                return (this.IsUpper(c) || this.IsLower(c));
            };

            CharProcess.prototype.IsAlphaOrDigit = function (c) {
                return (this.IsUpper(c) || this.IsLower(c) || this.IsDigit(c));
            };

            CharProcess.prototype.IsUpperKana = function (c) {
                return !this.IsLowerKana(c);
            };

            CharProcess.prototype.IsLowerKana = function (c) {
                return (CharProcess.LowerKana.search(c) != -1);
            };

            CharProcess.prototype.HasLowerKana = function (c) {
                return (CharProcess.UpperKana.search(c) != -1 || this.IsLowerKana(c));
            };

            CharProcess.prototype.ToUpperKana = function (c) {
                var index = CharProcess.LowerKana.search(c);
                return (index == -1) ? c : CharProcess.UpperKana.substr(index, 1);
            };

            CharProcess.prototype.ToLowerKana = function (c) {
                var index = CharProcess.UpperKana.search(c);
                if (index >= CharProcess.UpperKana.length - 4 && index < CharProcess.UpperKana.length) {
                    return c;
                }

                return (index == -1) ? c : CharProcess.LowerKana.substr(index, 1);
            };

            CharProcess.prototype.ToLower = function (c) {
                if (this.IsUpper(c))
                    return String.fromCharCode(c.charCodeAt(0) + 32);
                return c;
            };

            CharProcess.prototype.ToUpper = function (c) {
                if (this.IsLower(c))
                    return String.fromCharCode(c.charCodeAt(0) - 32);
                return c;
            };

            CharProcess.prototype.IsSpace = function (c) {
                return c == '\u0020' || c === '\u3000';
            };

            CharProcess.prototype.ToFullWidth = function (c) {
                var retObj = { text: "", processedAll: false };
                retObj.text = c;
                retObj.processedAll = false;

                if (c.length == 0)
                    return retObj;

                var c1 = c.substring(0, 1);

                if (this.IsMultiWidth(c1)) {
                    //
                    // Latin basic characters can be directly converted
                    // by making a few shifts...
                    //
                    if (c1 < this.CharCategory._charstarts[1]) {
                        //
                        // Funny why 'space' was left out of this category.
                        //
                        if (c1 == '\u0020') {
                            retObj.text = '\u3000';
                            return retObj;
                        }
                        var temp = '\u0021';
                        retObj.text = String.fromCharCode(c1.charCodeAt(0) - temp.charCodeAt(0) + (this.CharCategory._charstarts[81].charCodeAt(0) + 1)); //Blocks.HALFWIDTH_AND_FULLWIDTH_FORMS
                        return retObj;
                    }

                    //
                    //- pickup a direct map from the table...
                    //
                    if ((this.MultiWidthDetails(c1) & this.Ctype.Katakana) == this.Ctype.Katakana) {
                        if (c1.charCodeAt(0) < this.CharCategory.KANAHALFSTART) {
                            var c2 = this.GetFullHalfWidthSpecialChar(c1, true);
                            retObj.text = (c2 !== "") ? c2 : c1;
                            return retObj;
                        }
                        c1 = this.CharCategory._halfkana[c1.charCodeAt(0) - this.CharCategory.KANAHALFSTART];

                        //
                        // Handle the soundex here....
                        //
                        if (c.length < 2) {
                            retObj.text = c1;
                            return retObj;
                        }

                        var daku = c.charCodeAt(1) - (this.CharCategory.KATAKANA_VOICED.charCodeAt(0) - 1);
                        if (daku == 1 || daku == 2) {
                            retObj.processedAll = true;

                            var accent = this.CharCategory._accentkana[(c1.charCodeAt(0) - (this.CharCategory._charstarts[62].charCodeAt(0) + 1))];

                            if (accent != 0) {
                                if ((Math.abs(accent) & 2) == daku)
                                    c1 = String.fromCharCode(c1.charCodeAt(0) + 1);
                                c1 = String.fromCharCode(c1.charCodeAt(0) + 1);
                            }
                        }

                        //add by sj for bug 2955
                        if (daku == 1 && c1 == '\u30A6') {
                            c1 = '\u30F4';
                        }
                        //end by sj
                    }
                }
                retObj.text = c1;
                return retObj;
                //return c1;
            };

            CharProcess.prototype.ToHalfWidth = function (c) {
                //
                // Need to return only the first character.
                //
                return this.ToHalfWidthEx(c);
            };

            CharProcess.prototype.ToHalfWidthEx = function (c) {
                var ctype = this.GetCharType(c);

                var multiWidth = this.IsMultiWidth(c);

                //
                // First filter out half width characters and characters that
                // are not of CJK groups.
                if ((ctype & this.Ctype.FullWidth) == this.Ctype.FullWidth) {
                    switch (ctype & ~this.Ctype.FullWidth) {
                        case this.Ctype.Punctuation:
                        case this.Ctype.UpperCase:
                        case this.Ctype.LowerCase:
                        case this.Ctype.Symbol:
                        case this.Ctype.Numeric:
                        case this.Ctype.MathSymbol:
                             {
                                var c1 = this.GetFullHalfWidthSpecialChar(c, false);
                                if (c1 !== "")
                                    c = c1;
                                else {
                                    if (multiWidth) {
                                        var temp = '\u0021';

                                        //c = (char)(( c - (_charstarts[(int)Blocks.HALFWIDTH_AND_FULLWIDTH_FORMS] + 1) ) + '\u0021');
                                        c = String.fromCharCode(c.charCodeAt(0) - (this.CharCategory._charstarts[81].charCodeAt(0) + 1) + temp.charCodeAt(0)); //Blocks.HALFWIDTH_AND_FULLWIDTH_FORMS
                                    }
                                }
                            }
                            break;

                        case this.Ctype.Katakana:
                             {
                                var n = c.charCodeAt(0) - (this.CharCategory._charstarts[62].charCodeAt(0) + 1);
                                if (n < 0 || n > 91) {
                                    return c;
                                }
                                c = this.CharCategory._fullkana[n];

                                var accent = this.CharCategory._accentkana[n];

                                if (accent > 0) {
                                    //accent == 1 ? this.CharCategory.KATAKANA_VOICED.charCodeAt(0) : this.CharCategory.KATAKANA_SEMIVOICED.charCodeAt(0) ;
                                    c = c + String.fromCharCode(accent == 1 ? this.CharCategory.KATAKANA_VOICED.charCodeAt(0) : this.CharCategory.KATAKANA_SEMIVOICED.charCodeAt(0));
                                    return c;
                                }
                                //return new char[] { c, accent == 1 ? KATAKANA_VOICED : KATAKANA_SEMIVOICED };
                            }
                            break;

                        case this.Ctype.Space:
                            c = '\u0020';
                            break;

                        case this.Ctype.Hangul:
                            break;
                    }
                }

                return c;
            };
            CharProcess.prototype.ToKatakana = function (c) {
                //
                // Simply return the character if it isn't a hiragana.
                //
                if (!this.IsCharOfType(c, this.Ctype.Hiragana | this.Ctype.FullWidth))
                    return c;

                //
                // Need to handle special characters here...
                //
                var c1 = this.GetFullHalfWidthSpecialChar(c, false);

                //			if( c == '\u309b' || c == '\u309c' )
                //				return (char)('\uff9e' + (c - '\u309b'));
                if (c1 !== "")
                    return c1;

                //return (char)( c - _charstarts[(int)Blocks.HIRAGANA] + _charstarts[(int)Blocks.KATAKANA] );
                return String.fromCharCode(c.charCodeAt(0) - this.CharCategory._charstarts[61].charCodeAt(0) + this.CharCategory._charstarts[62].charCodeAt(0));
            };

            CharProcess.prototype.ToHiragana = function (c) {
                //
                // Simply return the character if it isn't a hiragana.
                if (!this.IsKatakana(c))
                    return c;

                // Convert to fullwidth Katakana.
                if (!this.IsFullWidth(c))
                    c = this.ToFullWidth(c).text;

                //validate
                if (!this.IsCharOfType(c, this.Ctype.Katakana | this.Ctype.FullWidth))
                    return c;

                //
                // Some fullwidth Katakana characters can't be expressed in Hiragaga
                // so mask it out.
                //
                //modified by sj for NKOI-8C7E84AA2
                //if (c >= '\u30f6' && c <= '\u30ff')
                //	return c;
                if (c >= '\u30f7' && c <= '\u30ff')
                    return c;

                if (c == '\u30f5')
                    return '\u304b';
                if (c == '\u30f6')
                    return '\u3051';

                //end by sj
                //return (char)( c - _charstarts[(int)Blocks.KATAKANA] + _charstarts[(int)Blocks.HIRAGANA] );
                return String.fromCharCode(c.charCodeAt(0) + this.CharCategory._charstarts[61].charCodeAt(0) - this.CharCategory._charstarts[62].charCodeAt(0));
            };

            CharProcess.prototype.ToBigHalfKatakana = function (c) {
                if (!this.IsSmallHalfKatakana(c))
                    return c;

                var c1 = this.CharCategory._halfkana[c.charCodeAt(0) - this.CharCategory.KANAHALFSTART];
                c1 = String.fromCharCode(c1.charCodeAt(0) + 1);
                return c1;
            };

            CharProcess.prototype.BelongTo = function (c) {
                var bottom = 0;
                var top = 83;
                var current = top >> 1;

                while (top - bottom > 1) {
                    if (c >= this.CharCategory._charstarts[current])
                        bottom = current;
                    else
                        top = current;
                    current = (top + bottom) >> 1;
                }

                return current;
            };

            CharProcess.prototype.MultiWidthDetails = function (c) {
                var bottom = 0;
                var top = this.CharCategory._fullhalfblocks.length;
                var current = top >> 1;

                while (top - bottom > 1) {
                    if (c >= this.CharCategory._fullhalfblocks[current])
                        bottom = current;
                    else
                        top = current;
                    current = (top + bottom) >> 1;
                }
                return this.CharCategory._mwtable[current];
            };

            CharProcess.prototype.IsFarEastBlock = function (block, c) {
                switch (this.CharCategory.Blocks[block]) {
                    case 'CJK_COMPATIBILITY':
                    case 'CJK_COMPATIBILITY_FORMS':
                    case 'CJK_COMPATIBILITY_IDEOGRAPHS':
                    case 'CJK_RADICALS_SUPPLEMENT':
                    case 'CJK_SYMBOLS_AND_PUNCTUATION':
                    case 'CJK_UNIFIED_IDEOGRAPHS':
                    case 'CJK_UNIFIED_IDEOGRAPHS_EXTENSION':
                    case 'HALFWIDTH_AND_FULLWIDTH_FORMS':
                    case 'BOPOMOFO':
                    case 'BOPOMOFO_EXTENDED':
                    case 'HIRAGANA':
                    case 'KATAKANA':
                    case 'KANBUN':
                    case 'HANGUL_COMPATIBILITY_JAMO':
                    case 'HANGUL_JAMO':
                    case 'HANGUL_SYLLABLES':
                        return true;

                    default:
                        for (var i = 0; i < this.CharCategory._feQuotes.length; i++) {
                            if (c == this.CharCategory._feQuotes[i]) {
                                return true;
                            }
                        }

                        if (c.charCodeAt(0) > 255) {
                            return true;
                        }

                        if (c.charCodeAt(0) == 8216 || c.charCodeAt(0) == 8217 || c.charCodeAt(0) == 8220 || c.charCodeAt(0) == 8221)
                            return true;

                        break;
                }
                return false;
            };

            CharProcess.prototype.GetFullHalfWidthSpecialChar = function (c, toFull) {
                if (toFull == true) {
                    var srctable = this.CharCategory._jpnSpecialHalf;
                    var desttable = this.CharCategory._jpnSpecialFull;
                } else {
                    var srctable = this.CharCategory._jpnSpecialFull;
                    var desttable = this.CharCategory._jpnSpecialHalf;
                }

                var found = -1;
                var tempIndex = 0;
                while (tempIndex < srctable.length) {
                    if (srctable[tempIndex] == c) {
                        found = tempIndex;
                        break;
                    }
                    tempIndex++;
                }

                if (found != -1) {
                    if (tempIndex < desttable.length) {
                        return desttable[tempIndex];
                    }
                }
                return "";
            };
            CharProcess.LowerKana = "\u3041\u3043\u3045\u3047\u3049\u3063\u3083\u3085\u3087\u308e\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\u30e3\u30e5\u30e7\u30ee\uff67\uff68\uff69\uff6a\uff6b\uff6c\uff6d\uff6e\uff6f\u30F5\u30F6\u3095\u3096";
            CharProcess.UpperKana = "\u3042\u3044\u3046\u3048\u304a\u3064\u3084\u3086\u3088\u308f\u30a2\u30a4\u30a6\u30a8\u30aa\u30c4\u30e4\u30e6\u30e8\u30ef\uff71\uff72\uff73\uff74\uff75\uff94\uff95\uff96\uff82\u30AB\u30B1\u304B\u3051";

            CharProcess.FullWidthSymbolArray = [
                '\u3001',
                '\u3002',
                '\uFF0C',
                '\uFF0E',
                '\u30FB',
                '\uFF1A',
                '\uFF1B',
                '\uFF1F',
                '\uFF01',
                '\u309B',
                '\u309C',
                '\u00B4',
                '\uFF40',
                '\u00A8',
                '\uFF3E',
                '\uFFE3',
                '\uFF3F',
                '\u30FD',
                '\u30FE',
                '\u309D',
                '\u309E',
                '\u3003',
                '\u4EDD',
                '\u3005',
                '\u3006',
                '\u3007',
                '\u30FC',
                '\u2014',
                '\u2010',
                '\uFF0F',
                '\u301C',
                '\u2016',
                '\uFF5C',
                '\u2026',
                '\u2025',
                '\u2018',
                '\u2019',
                '\u201C',
                '\u201D',
                '\uFF08',
                '\uFF09',
                '\u3014',
                '\u3015',
                '\uFF3B',
                '\uFF3D',
                '\uFF5B',
                '\uFF5D',
                '\u3008',
                '\u3009',
                '\u300A',
                '\u300B',
                '\u300C',
                '\u300D',
                '\u300E',
                '\u300F',
                '\u3010',
                '\u3011',
                '\uFF0B',
                '\u2212',
                '\u00B1',
                '\u00D7',
                '\u00F7',
                '\uFF1D',
                '\u2260',
                '\uFF1C',
                '\uFF1E',
                '\u2266',
                '\u2267',
                '\u221E',
                '\u2234',
                '\u2642',
                '\u2640',
                '\u00B0',
                '\u2032',
                '\u2033',
                '\u2103',
                '\uFFE5',
                '\uFF04',
                '\u00A2',
                '\u00A3',
                '\uFF05',
                '\uFF03',
                '\uFF06',
                '\uFF0A',
                '\uFF20',
                '\u00A7',
                '\u2606',
                '\u2605',
                '\u25CB',
                '\u25CF',
                '\u25CE',
                '\u25C7',
                '\u25C6',
                '\u25A1',
                '\u25A0',
                '\u25B3',
                '\u25B2',
                '\u25BD',
                '\u25BC',
                '\u203B',
                '\u3012',
                '\u2192',
                '\u2190',
                '\u2191',
                '\u2193',
                '\u3013',
                '\uFF07',
                '\uFF02',
                '\uFF0D',
                '\u3033',
                '\u3034',
                '\u3035',
                '\u303B',
                '\u303C',
                '\u30FF',
                '\u309F',
                '\u2208',
                '\u220B',
                '\u2286',
                '\u2287',
                '\u2282',
                '\u2283',
                '\u222A',
                '\u2229',
                '\u2284',
                '\u2285',
                '\u228A',
                '\u228B',
                '\u2209',
                '\u2205',
                '\u2305',
                '\u2306',
                '\u2227',
                '\u2228',
                '\u00AC',
                '\u21D2',
                '\u21D4',
                '\u2200',
                '\u2203',
                '\u2295',
                '\u2296',
                '\u2297',
                '\u2225',
                '\u2226',
                '\u2985',
                '\u2986',
                '\u3018',
                '\u3019',
                '\u3016',
                '\u3017',
                '\u2220',
                '\u22A5',
                '\u2312',
                '\u2202',
                '\u2207',
                '\u2261',
                '\u2252',
                '\u226A',
                '\u226B',
                '\u221A',
                '\u223D',
                '\u221D',
                '\u2235',
                '\u222B',
                '\u222C',
                '\u2262',
                '\u2243',
                '\u2245',
                '\u2248',
                '\u2276',
                '\u2277',
                '\u2194',
                '\u212B',
                '\u2030',
                '\u266F',
                '\u266D',
                '\u266A',
                '\u2020',
                '\u2021',
                '\u00B6',
                '\u266E',
                '\u266B',
                '\u266C',
                '\u2669',
                '\u25EF',
                '\uFF3C',
                '\uFF5E',
                '\uFFE0',
                '\uFFE1',
                '\uFFE2',
                '\u2015'
            ];

            CharProcess.HalfWidthSymbolArray = [
                '\u005C',
                '\u007E',
                '\u0021',
                '\u0022',
                '\u0023',
                '\u0024',
                '\u0025',
                '\u0026',
                '\u0027',
                '\u0028',
                '\u0029',
                '\u002A',
                '\u002B',
                '\u002C',
                '\u002D',
                '\u002E',
                '\u002F',
                '\u003A',
                '\u003B',
                '\u003C',
                '\u003D',
                '\u003E',
                '\u003F',
                '\u0040',
                '\u005B',
                '\u005D',
                '\u005E',
                '\u005F',
                '\u0060',
                '\u007B',
                '\u007C',
                '\u007D',
                '\uFF61',
                '\uFF62',
                '\uFF63',
                '\uFF64',
                '\uFF65',
                '\u00A1',
                '\u00A4',
                '\u00A5'
            ];

            CharProcess.CharEx = new CharProcess();
            return CharProcess;
        })();
        input.CharProcess = CharProcess;
    })(wijmo.input || (wijmo.input = {}));
    var input = wijmo.input;
})(wijmo || (wijmo = {}));
;
var wijmo;
(function (wijmo) {
    (function (input) {
        /** @ignore */
        var CharInfo = (function () {
            function CharInfo() {
            }
            CharInfo.Getbyte64 = function (s, i) {
                var idx = CharInfo.ALPHA.indexOf(s.charAt(i));
                if (idx == -1) {
                    throw "Cannot decode base64";
                }
                return idx;
            };
            CharInfo.Decode = function (s) {
                if (window.atob !== undefined) {
                    return window.atob(s);
                }

                // convert to string
                s = "" + s;
                var getbyte64 = CharInfo.Getbyte64;
                var pads, i, b10;
                var imax = s.length;
                if (imax == 0) {
                    return s;
                }

                if (imax % 4 != 0) {
                    throw "Cannot decode base64";
                }

                pads = 0;
                if (s.charAt(imax - 1) == CharInfo.PADCHAR) {
                    pads = 1;
                    if (s.charAt(imax - 2) == CharInfo.PADCHAR) {
                        pads = 2;
                    }

                    // either way, we want to ignore this last block
                    imax -= 4;
                }

                var x = [];
                for (i = 0; i < imax; i += 4) {
                    b10 = (getbyte64(s, i) << 18) | (getbyte64(s, i + 1) << 12) | (getbyte64(s, i + 2) << 6) | getbyte64(s, i + 3);
                    x.push(String.fromCharCode(b10 >> 16, (b10 >> 8) & 0xff, b10 & 0xff));
                }

                switch (pads) {
                    case 1:
                        b10 = (getbyte64(s, i) << 18) | (getbyte64(s, i + 1) << 12) | (getbyte64(s, i + 2) << 6);
                        x.push(String.fromCharCode(b10 >> 16, (b10 >> 8) & 0xff));
                        break;
                    case 2:
                        b10 = (getbyte64(s, i) << 18) | (getbyte64(s, i + 1) << 12);
                        x.push(String.fromCharCode(b10 >> 16));
                        break;
                }
                return x.join('');
            };

            CharInfo.prototype.getbyte = function (s, i) {
                var x = s.charCodeAt(i);
                if (x > 255) {
                    throw "INVALID_CHARACTER_ERR: DOM Exception 5";
                }
                return x;
            };

            CharInfo.DecodeCharInfo = function () {
                var str = CharInfo.Decode(CharInfo._base64CharInfo);
                var numArr = [];
                var i = 0;
                for (i = 0; i < str.length; i += 2) {
                    var num = (str.charCodeAt(i + 1) * 256) + str.charCodeAt(i);
                    numArr.push(num);
                }
                var tempResult = [];
                for (i = 0; i < numArr.length; i++) {
                    if (numArr[i] != 0xfffe) {
                        tempResult.push(numArr[i]);
                    } else {
                        var number = numArr[i + 1];
                        for (var j = 1; j < number; j++) {
                            tempResult.push(numArr[i - 1]);
                        }
                        i++;
                    }
                }
                for (i = 0; i < tempResult.length; i += 2) {
                    var val = (tempResult[i + 1] * 65536) + tempResult[i];
                    CharInfo._charInfo.push(val);
                }
            };

            CharInfo.GetByte = function (index) {
                if (CharInfo._charInfo.length === 0) {
                    CharInfo.DecodeCharInfo();
                }
                var i = Math.floor(index / 4);
                var j = index % 4;
                var value = CharInfo._charInfo[i];
                switch (j) {
                    case 0:
                        return value & 0xff;
                    case 1:
                        return (value >> 8) & 0xff;
                    case 2:
                        return (value >> 16) & 0xff;
                    case 3:
                        return (value >> 24) & 0xff;
                }
            };

            CharInfo.GetShortValue = function (index) {
                var i = CharInfo.GetByte(index);
                var j = CharInfo.GetByte(index + 1);
                return j * 256 + i;
            };

            CharInfo.GetIntValue = function (index) {
                var a = CharInfo.GetByte(index);
                var b = CharInfo.GetByte(index + 1);
                var c = CharInfo.GetByte(index + 2);
                var d = CharInfo.GetByte(index + 3);
                return d * 65535 * 256 + c * 65535 + b * 256 + a;
            };
            CharInfo.PADCHAR = "=";
            CharInfo.ALPHA = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';

            CharInfo._charInfo = [];

            CharInfo._base64CharInfo = "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";
            return CharInfo;
        })();
        input.CharInfo = CharInfo;

        /** @ignore */
        var CharUnicodeInfo = (function () {
            function CharUnicodeInfo() {
            }
            CharUnicodeInfo.InitTable = function () {
                CharUnicodeInfo.globalizationResourceBytePtr = 0;
                CharUnicodeInfo.headerPtr = CharUnicodeInfo.globalizationResourceBytePtr;
                CharUnicodeInfo.s_pCategoryLevel1Index = CharInfo.GetIntValue(CharUnicodeInfo.globalizationResourceBytePtr + 40);
                CharUnicodeInfo.s_pCategoriesValue = CharInfo.GetIntValue(CharUnicodeInfo.globalizationResourceBytePtr + 0x2c);
                CharUnicodeInfo.s_pNumericLevel1Index = CharInfo.GetIntValue(CharUnicodeInfo.globalizationResourceBytePtr + 0x30);
                CharUnicodeInfo.s_pNumericValues = CharInfo.GetIntValue(CharUnicodeInfo.globalizationResourceBytePtr + 0x38);
                CharUnicodeInfo.s_pDigitValues = CharInfo.GetIntValue(CharUnicodeInfo.globalizationResourceBytePtr + 0x34);
            };

            CharUnicodeInfo.InternalConvertToUtf32 = function (s, index, charLength) {
                charLength.length = 1;
                if (index < (s.length - 1)) {
                    var num = s.charCodeAt(index) - 0xd800;
                    if ((num >= 0) && (num <= 0x3ff)) {
                        var num2 = s.charCodeAt(index + 1) - 0xdc00;
                        if ((num2 >= 0) && (num2 <= 0x3ff)) {
                            charLength.length++;
                            return (((num * 0x400) + num2) + 0x10000);
                        }
                    }
                }
                return s.charCodeAt(index);
            };

            CharUnicodeInfo.InternalGeteCategoryValue = function (ch, offset) {
                if (offset === undefined || offset === null) {
                    offset = 0;
                }
                var num = CharInfo.GetShortValue(CharUnicodeInfo.s_pCategoryLevel1Index + 2 * (ch >> 8));
                num = CharInfo.GetShortValue(CharUnicodeInfo.s_pCategoryLevel1Index + 2 * (num + ((ch >> 4) & 15)));
                var numPtr = CharUnicodeInfo.s_pCategoryLevel1Index + 2 * num;
                var num2 = CharInfo.GetByte(numPtr + (ch & 15));
                return CharInfo.GetByte(CharUnicodeInfo.s_pCategoriesValue + (num2 * 2) + offset);
            };

            CharUnicodeInfo.InternalGetUnicodeCategory = function (str, index, charLength) {
                var utf32 = CharUnicodeInfo.InternalConvertToUtf32(str, index, charLength);

                return CharUnicodeInfo.InternalGeteCategoryValue(utf32, 0);
            };

            CharUnicodeInfo.IsCombiningCategory = function (uc) {
                if ((uc !== 5 /* NonSpacingMark */) && (uc !== 6 /* SpacingCombiningMark */)) {
                    return (uc === 7 /* EnclosingMark */);
                }
                return true;
            };
            return CharUnicodeInfo;
        })();
        input.CharUnicodeInfo = CharUnicodeInfo;

        CharUnicodeInfo.InitTable();

        /** @ignore */
        (function (UnicodeCategory) {
            UnicodeCategory[UnicodeCategory["ClosePunctuation"] = 0x15] = "ClosePunctuation";
            UnicodeCategory[UnicodeCategory["ConnectorPunctuation"] = 0x12] = "ConnectorPunctuation";
            UnicodeCategory[UnicodeCategory["Control"] = 14] = "Control";
            UnicodeCategory[UnicodeCategory["CurrencySymbol"] = 0x1a] = "CurrencySymbol";
            UnicodeCategory[UnicodeCategory["DashPunctuation"] = 0x13] = "DashPunctuation";
            UnicodeCategory[UnicodeCategory["DecimalDigitNumber"] = 8] = "DecimalDigitNumber";
            UnicodeCategory[UnicodeCategory["EnclosingMark"] = 7] = "EnclosingMark";
            UnicodeCategory[UnicodeCategory["FinalQuotePunctuation"] = 0x17] = "FinalQuotePunctuation";
            UnicodeCategory[UnicodeCategory["Format"] = 15] = "Format";
            UnicodeCategory[UnicodeCategory["InitialQuotePunctuation"] = 0x16] = "InitialQuotePunctuation";
            UnicodeCategory[UnicodeCategory["LetterNumber"] = 9] = "LetterNumber";
            UnicodeCategory[UnicodeCategory["LineSeparator"] = 12] = "LineSeparator";
            UnicodeCategory[UnicodeCategory["LowercaseLetter"] = 1] = "LowercaseLetter";
            UnicodeCategory[UnicodeCategory["MathSymbol"] = 0x19] = "MathSymbol";
            UnicodeCategory[UnicodeCategory["ModifierLetter"] = 3] = "ModifierLetter";
            UnicodeCategory[UnicodeCategory["ModifierSymbol"] = 0x1b] = "ModifierSymbol";
            UnicodeCategory[UnicodeCategory["NonSpacingMark"] = 5] = "NonSpacingMark";
            UnicodeCategory[UnicodeCategory["OpenPunctuation"] = 20] = "OpenPunctuation";
            UnicodeCategory[UnicodeCategory["OtherLetter"] = 4] = "OtherLetter";
            UnicodeCategory[UnicodeCategory["OtherNotAssigned"] = 0x1d] = "OtherNotAssigned";
            UnicodeCategory[UnicodeCategory["OtherNumber"] = 10] = "OtherNumber";
            UnicodeCategory[UnicodeCategory["OtherPunctuation"] = 0x18] = "OtherPunctuation";
            UnicodeCategory[UnicodeCategory["OtherSymbol"] = 0x1c] = "OtherSymbol";
            UnicodeCategory[UnicodeCategory["ParagraphSeparator"] = 13] = "ParagraphSeparator";
            UnicodeCategory[UnicodeCategory["PrivateUse"] = 0x11] = "PrivateUse";
            UnicodeCategory[UnicodeCategory["SpaceSeparator"] = 11] = "SpaceSeparator";
            UnicodeCategory[UnicodeCategory["SpacingCombiningMark"] = 6] = "SpacingCombiningMark";
            UnicodeCategory[UnicodeCategory["Surrogate"] = 0x10] = "Surrogate";
            UnicodeCategory[UnicodeCategory["TitlecaseLetter"] = 2] = "TitlecaseLetter";
            UnicodeCategory[UnicodeCategory["UppercaseLetter"] = 0] = "UppercaseLetter";
        })(input.UnicodeCategory || (input.UnicodeCategory = {}));
        var UnicodeCategory = input.UnicodeCategory;

        /** @ignore */
        var StringInfo = (function () {
            function StringInfo() {
            }
            StringInfo.GetNextTextElement = function (str, index, ref) {
                var num2;
                if (str == null) {
                    throw "ArgumentNullException";
                }
                var length = str.length;
                if ((index < 0) || (index >= length)) {
                    if (index != length) {
                        throw "ArgumentOutOfRangeException";
                    }
                    return "";
                }
                var charLengh = {};
                var ucCurrent = CharUnicodeInfo.InternalGetUnicodeCategory(str, index, charLengh);
                num2 = charLengh.length;
                var elementLen = StringInfo.GetCurrentTextElementLen(str, index, length, ucCurrent, num2, ref);
                ref.length = elementLen;
                return str.substr(index, elementLen);
            };
            StringInfo.GetCurrentTextElementLen = function (str, index, len, ucCurrent, currentCharCount, ref) {
                var num;
                if ((index + currentCharCount) === len) {
                    return currentCharCount;
                }
                var charLength = {};
                var uc = CharUnicodeInfo.InternalGetUnicodeCategory(str, index + currentCharCount, charLength);
                num = charLength.length;
                if (((!CharUnicodeInfo.IsCombiningCategory(uc) || CharUnicodeInfo.IsCombiningCategory(ucCurrent)) || ((ucCurrent === 15 /* Format */) || (ucCurrent === 14 /* Control */))) || ((ucCurrent === 29 /* OtherNotAssigned */) || (ucCurrent === 16 /* Surrogate */))) {
                    var num3 = currentCharCount;
                    ref.ucCurrent = uc;
                    ref.currentCharCount = num;
                    return num3;
                }
                var num2 = index;
                index += currentCharCount + num;
                while (index < len) {
                    var charLength = {};
                    uc = CharUnicodeInfo.InternalGetUnicodeCategory(str, index, charLength);
                    num = charLength.length;
                    if (!CharUnicodeInfo.IsCombiningCategory(uc)) {
                        ref.ucCurrent = uc;
                        ref.currentCharCount = num;
                        break;
                    }
                    index += num;
                }
                return (index - num2);
            };

            StringInfo.GetTextElement = function (str) {
                var result = [];
                var index = 0;
                while (index < str.length) {
                    var ref = {};
                    var element = StringInfo.GetNextTextElement(str, index, ref);
                    result.push(element);
                    index += ref.length;
                }
                return result;
            };
            return StringInfo;
        })();
        input.StringInfo = StringInfo;

        /** @ignore */
        var StringCache = (function () {
            function StringCache() {
            }
            StringCache.AddElementCache = function (str, element) {
                if (StringCache.TextElementCacheCount > 500) {
                    StringCache.TextElementCache = {};
                    StringCache.TextElementCacheCount = 0;
                }

                StringCache.TextElementCache[str] = element;
                StringCache.TextElementCacheCount++;
            };
            StringCache.TextElementCache = {};
            StringCache.TextElementCacheCount = 0;
            return StringCache;
        })();
        input.StringCache = StringCache;

        /** @ignore */
        String.prototype.GetStandardPosition = function (position, start) {
            this.CreateSurrogateArray();
            var newValue = position;
            if (StringCache.TextElementArray !== null && position > 0) {
                var maxIndex = Math.min(position, StringCache.TextElementArray.length);
                var totalElementSize = 0;
                for (var i = 0; i < maxIndex; i++) {
                    totalElementSize += StringCache.TextElementArray[i].length;
                }
                newValue = totalElementSize;
            }
            return newValue;
        };

        /** @ignore */
        String.prototype.CreateSurrogateArray = function () {
            if (StringCache.TextElementArray === undefined || StringCache._InnerValue.toString() != this.toString()) {
                StringCache._InnerValue = this;

                //save position of surrogate pair
                var elementCol = StringCache.TextElementCache[this];
                if (elementCol === undefined) {
                    elementCol = StringInfo.GetTextElement(this);

                    // Improve performance.
                    StringCache.AddElementCache(this, elementCol);
                }
                if (elementCol.length === this.length) {
                    StringCache.TextElementArray = null;
                } else {
                    StringCache.TextElementArray = elementCol;
                    StringCache.MultiCharExit = false;
                    for (var i = 0; i < elementCol.length; i++) {
                        if (elementCol[i].length > 2) {
                            StringCache.MultiCharExit = true;
                            break;
                        }
                    }
                }
            }
        };

        /** @ignore */
        String.prototype.GetLength = function () {
            this.CreateSurrogateArray();
            var newLength = this.length;
            if (StringCache.TextElementArray !== null) {
                newLength = StringCache.TextElementArray.length;
            }

            return newLength;
        };

        /** @ignore */
        String.prototype.Substring = function (start, end) {
            this.CreateSurrogateArray();

            if (start >= end) {
                return "";
            }
            var newValue = this.substring(start, end);
            if (StringCache.TextElementArray !== null) {
                start = Math.max(0, start);
                end = Math.min(StringCache.TextElementArray.length, end);
                var result = [];
                for (var i = start; i < end; i++) {
                    result.push(StringCache.TextElementArray[i]);
                }
                newValue = result.join("");
            }

            return newValue;
        };

        /** @ignore */
        String.prototype.IndexOf = function (findtext, startindex) {
            this.CreateSurrogateArray();

            var newValue = this.indexOf(findtext, startindex);
            if (StringCache.TextElementArray !== null && newValue > 0) {
                var totalLength = 0;
                for (var i = 0; i < StringCache.TextElementArray.length; i++) {
                    totalLength += StringCache.TextElementArray[i].length;
                    if (totalLength == newValue) {
                        newValue = i + 1;
                        break;
                    }
                }
            }

            if (StringCache.TextElementArray !== null && newValue >= 0) {
                if (this.Substring(newValue, newValue + findtext.GetLength()).length != findtext.length) {
                    newValue = -1;
                }
            }
            return newValue;
        };

        /** @ignore */
        String.prototype.LastIndexOf = function (text) {
            this.CreateSurrogateArray();
            var newValue = this.lastIndexOf(text);
            if (StringCache.TextElementArray !== null && newValue > 0) {
                var totalLength = 0;
                for (var i = 0; i < StringCache.TextElementArray.length; i++) {
                    totalLength += StringCache.TextElementArray[i];
                    if (totalLength == newValue) {
                        newValue = i + 1;
                        break;
                    }
                }
            }

            if (StringCache.TextElementArray !== null && newValue >= 0) {
                if (this.Substring(newValue, newValue + text.GetLength()).length != text.length) {
                    newValue = -1;
                }
            }
            return newValue;
        };

        /** @ignore */
        String.prototype.CharAt = function (position) {
            this.CreateSurrogateArray();
            var newValue = this.charAt(position);
            if (StringCache.TextElementArray !== null) {
                if (position >= 0 && position < StringCache.TextElementArray.length) {
                    newValue = StringCache.TextElementArray[position];
                } else {
                    newValue = "";
                }
            }

            return newValue;
        };

        /** @ignore */
        String.prototype.startWith = function (str) {
            if (str == null || str == "" || this.length == 0 || str.length > this.length)
                return false;
            if (this.substr(0, str.length) == str)
                return true;
            else
                return false;
        };

        /** @ignore */
        String.prototype.IsNulOrEmpty = function (str) {
            return str == null || str == "";
        };
    })(wijmo.input || (wijmo.input = {}));
    var input = wijmo.input;
})(wijmo || (wijmo = {}));

;
;
/// <reference path="../external/declarations/globalize.d.ts"/>
/// <reference path="../Base/jquery.wijmo.widget.ts"/>
/// <reference path="../wijpopup/jquery.wijmo.wijpopup.ts"/>
/// <reference path="../wijlist/jquery.wijmo.wijlist.ts"/>
/// <reference path="../wijsuperpanel/jquery.wijmo.wijsuperpanel.ts"/>
/// <reference path="jquery.wijmo.wijcharex.ts" />
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var wijmo;
(function (wijmo) {
    /*globals Globalize window jQuery wijInputResult document*/
    (function (input) {
        var $ = jQuery, jqKeyCode = wijmo.getKeyCodeEnum();

        /** @widget */
        var wijinputcore = (function (_super) {
            __extends(wijinputcore, _super);
            function wijinputcore() {
                _super.apply(this, arguments);
                this._wasPopupShowing = false;
                this._imeCompostiing = false;
                this._blurTimeout = null;
                this._boundMouseWheel = false;
                this._blockNextTriggerClickedEvent = false;
            }
            wijinputcore.prototype._elemWithClasses = function (elem, classes) {
                if (typeof classes === "undefined") { classes = []; }
                return $(elem).addClass(classes.join(" "));
            };
            wijinputcore.prototype._divWithClasses = function () {
                var classes = [];
                for (var _i = 0; _i < (arguments.length - 0); _i++) {
                    classes[_i] = arguments[_i + 0];
                }
                return this._elemWithClasses("<div/>", classes);
            };
            wijinputcore.prototype._spanWithClasses = function () {
                var classes = [];
                for (var _i = 0; _i < (arguments.length - 0); _i++) {
                    classes[_i] = arguments[_i + 0];
                }
                return this._elemWithClasses("<span/>", classes);
            };

            wijinputcore.prototype._horizontalBorderWidth = function (elem) {
                return elem.leftBorderWidth() + elem.rightBorderWidth();
            };
            wijinputcore.prototype._verticalBorderWidth = function (elem) {
                return elem.topBorderWidth() + elem.bottomBorderWidth();
            };
            wijinputcore.prototype._create = function () {
                var _this = this;
                try  {
                    var focused = document.activeElement == this.element[0];
                } catch (e) {
                }

                var hBorder = this._horizontalBorderWidth(this.element);
                var vBorder = this._verticalBorderWidth(this.element);
                if (this.element[0].tagName.toLowerCase() !== 'input' && this.element[0].tagName.toLowerCase() !== 'textarea') {
                    throw "Target element is not a INPUT";
                }

                this._creationDate = new Date();

                // enable touch support:
                if (window.wijmoApplyWijTouchUtilEvents) {
                    $ = window.wijmoApplyWijTouchUtilEvents($);
                }

                if (this.element.is(":hidden") && this.element.wijAddVisibilityObserver) {
                    this.element.wijAddVisibilityObserver(function () {
                        _this._destroy();
                        _this._create();
                        if (_this.element.wijRemoveVisibilityObserver) {
                            _this.element.wijRemoveVisibilityObserver();
                        }
                    }, "wijinput");
                }

                this.element.data("widgetName", this.widgetName);

                //$.effects.save(this.element, ['width', 'height']);
                if ($.effects && $.effects.save) {
                    $.effects.save(this.element, ['width', 'height']);
                } else if ($.save) {
                    $.save(this.element, ['width', 'height']);
                }

                var wijCSS = this.options.wijCSS;
                this.element.wrap("<div><span/></div");
                this.wrapper = this.element.parent();
                this.outerDiv = this.wrapper.parent();
                this.outerDiv.addClass([wijCSS.wijinput, wijCSS.widget, wijCSS.helperClearFix, wijCSS.stateDefault, wijCSS.cornerAll].join(" "));
                this.wrapper.addClass(wijCSS.wijinputWrapper);

                this.element.addClass(wijCSS.wijinputInput).addClass(wijCSS.cornerAll).attr('role', 'textbox');

                if (this.options.showTrigger != undefined) {
                    this.options.showDropDownButton = this.options.showTrigger;
                }

                this._createDropDownAndSpin();
                this._initialize();

                if (focused) {
                    $(function () {
                        return _this.element.focus().wijtextselection(0, _this.element.val().length);
                    });
                }

                // We need to move width and height from the <input/> to the outer <div/> because the input must span the parent wrapper.
                // It must be done if A dimension is set in the style attribute, hence the "if" statements
                // The a dimension is in pixels, it must be adjusted according to the input's and div's border/margin/padding.
                // The input's total border size must be calcualted before changing the classes, hence variables hBorder and vBorder.
                var style = this.element[0].style;
                if (style.width) {
                    if (this._isInPercents(style.width)) {
                        this.outerDiv.width(style.width);
                    } else {
                        this.outerDiv.width(this.element.width() + hBorder - this._horizontalBorderWidth(this.outerDiv));
                    }
                    this.element.width("");
                }
                if (style.height) {
                    if (this._isInPercents(style.height)) {
                        this.outerDiv.height(style.height);
                    } else {
                        this.outerDiv.height(this.element.height() + vBorder - this._verticalBorderWidth(this.outerDiv));
                    }
                    this.element.height(this.outerDiv.height() - (parseInt(this.wrapper.css('padding-top')) + parseInt(this.wrapper.css('padding-bottom'))));
                    this.wrapper.height(style.height);
                }

                //For implement the task#151923.
                //Input widgets are placed inside a form, so we need create a hidden field
                //for this input control to transfer the input value when do form submit.
                var ele = this.element, form = ele.closest("form");
                if (form && form.length > 0 && ele.attr('name')) {
                    this._hiddenInput = $("<input type='hidden'>").appendTo(form).attr('name', ele.attr('name'));
                    ele.removeAttr('name');
                }

                _super.prototype._create.call(this);
            };

            wijinputcore.prototype._createDropDownAndSpin = function () {
                this._createDropDownAndSpinElement();
                this._createDropDownAndSpinStyle();
                this._createDropDownAndSpinLayout();
            };

            wijinputcore.prototype._createDropDownAndSpinElement = function () {
                var wijCSS = this.options.wijCSS;
                var spinnerAlign = this.options.spinnerAlign;
                var leftSpinnerBtn = spinnerAlign === 'verticalLeft';
                var leftDropDownBtn = this.options.dropDownButtonAlign === 'left';
                var showSpinner = this.options.showSpinner;
                var showDropDownButton = this._isDropDownButtonShown();

                if (this.options.buttonAlign != null) {
                    leftSpinnerBtn = this.options.buttonAlign == 'left';
                    leftDropDownBtn = this.options.buttonAlign == 'left';
                    spinnerAlign = this.options.buttonAlign == 'left' ? "verticalLeft" : "verticalRight";
                }

                this.triggerBtn = null;
                this.spinUpElement = null;
                this.spinDownElement = null;

                this.outerDiv.css("overflow", "hidden");

                if (showDropDownButton) {
                    var cornerCSS = leftDropDownBtn ? wijCSS.cornerLeft : wijCSS.cornerRight;
                    this.triggerBtn = this._divWithClasses(wijCSS.wijinputTrigger, wijCSS.stateDefault, cornerCSS).append(this._spanWithClasses(wijCSS.icon, wijCSS.iconArrowDown)).attr('role', 'button');
                }

                if (showSpinner) {
                    this.spinnerLeft = this._divWithClasses(wijCSS.wijinputSpinnerLeft, wijCSS.wijinputButton);
                    this.spinnerRight = this._divWithClasses(wijCSS.wijinputSpinnerRight, wijCSS.wijinputButton);

                    if (spinnerAlign === "verticalLeft" || spinnerAlign === "verticalRight") {
                        this.spinUpElement = this._divWithClasses(wijCSS.stateDefault, wijCSS.wijinputSpinUp).append(this._spanWithClasses(wijCSS.icon, wijCSS.iconArrowUp)).css({ "padding": "0px" });

                        this.spinDownElement = this._divWithClasses(wijCSS.stateDefault, wijCSS.wijinputSpinDown).append(this._spanWithClasses(wijCSS.icon, wijCSS.iconArrowDown)).css({ "padding": "0px" });
                    } else {
                        this.spinUpElement = this._divWithClasses(wijCSS.stateDefault, wijCSS.wijinputSpin).append(this._spanWithClasses(wijCSS.icon, wijCSS.iconPlus, wijCSS.glyphIcon, wijCSS.glyphIconPlus)).css({ "padding": "0px" });
                        this.spinDownElement = this._divWithClasses(wijCSS.stateDefault, wijCSS.wijinputSpin).append(this._spanWithClasses(wijCSS.icon, wijCSS.iconMinus, wijCSS.glyphIcon, wijCSS.glyphIconMinus)).css({ "padding": "0px" });
                    }

                    this.element.attr('role', 'spinner');
                }
            };

            wijinputcore.prototype._createDropDownAndSpinStyle = function () {
                var wijCSS = this.options.wijCSS;
                var spinnerAlign = this.options.spinnerAlign;
                var leftSpinnerBtn = this.options.spinnerAlign === 'verticalLeft';
                var leftDropDownBtn = this.options.dropDownButtonAlign === 'left';
                var showSpinner = this.options.showSpinner;
                var showDropDownButton = this._isDropDownButtonShown();

                if (this.options.buttonAlign != null) {
                    leftSpinnerBtn = this.options.buttonAlign == 'left';
                    leftDropDownBtn = this.options.buttonAlign == 'left';
                    spinnerAlign = this.options.buttonAlign == 'left' ? "verticalLeft" : "verticalRight";
                }

                //Flag CSS
                if (showDropDownButton && showSpinner) {
                    if (leftDropDownBtn) {
                        switch (spinnerAlign) {
                            case "verticalLeft":
                                this.outerDiv.addClass(wijCSS.inputSpinnerTriggerLeft);
                                break;
                            case "verticalRight":
                                this.outerDiv.addClass(wijCSS.inputTriggerLeft);
                                this.outerDiv.addClass(wijCSS.inputSpinnerRight);
                                break;
                            case "horizontalDownLeft":
                            case "horizontalUpLeft":
                                this.outerDiv.addClass(wijCSS.inputSpinnerTriggerLeft);
                                this.outerDiv.addClass(wijCSS.inputSpinnerRight);
                                break;
                        }
                    } else {
                        switch (spinnerAlign) {
                            case "verticalLeft":
                                this.outerDiv.addClass(wijCSS.inputTriggerRight);
                                this.outerDiv.addClass(wijCSS.inputSpinnerLeft);
                                break;
                            case "verticalRight":
                                this.outerDiv.addClass(wijCSS.inputSpinnerTriggerRight);
                                break;
                            case "horizontalDownLeft":
                            case "horizontalUpLeft":
                                this.outerDiv.addClass(wijCSS.inputSpinnerTriggerRight);
                                this.outerDiv.addClass(wijCSS.inputSpinnerLeft);
                                break;
                        }
                    }
                } else if (showDropDownButton) {
                    if (leftDropDownBtn) {
                        this.outerDiv.addClass(wijCSS.inputTriggerLeft);
                    } else {
                        this.outerDiv.addClass(wijCSS.inputTriggerRight);
                    }
                } else if (showSpinner) {
                    switch (spinnerAlign) {
                        case "verticalLeft":
                            this.outerDiv.addClass(wijCSS.inputSpinnerLeft);
                            break;
                        case "verticalRight":
                            this.outerDiv.addClass(wijCSS.inputSpinnerRight);
                            break;
                        case "horizontalDownLeft":
                        case "horizontalUpLeft":
                            this.outerDiv.addClass(wijCSS.inputSpinnerLeft);
                            this.outerDiv.addClass(wijCSS.inputSpinnerRight);
                            break;
                    }
                }

                //Corner CSS
                if (showDropDownButton && showSpinner) {
                    if (leftDropDownBtn) {
                        switch (spinnerAlign) {
                            case "verticalRight":
                                this.spinUpElement.addClass(wijCSS.cornerTR);
                                this.spinDownElement.addClass(wijCSS.cornerBR);
                                break;
                            case "horizontalDownLeft":
                                this.spinUpElement.addClass(wijCSS.cornerRight);
                                break;
                            case "horizontalUpLeft":
                                this.spinDownElement.addClass(wijCSS.cornerRight);
                                break;
                        }
                    } else {
                        switch (spinnerAlign) {
                            case "verticalLeft":
                                this.spinUpElement.addClass(wijCSS.cornerTL);
                                this.spinDownElement.addClass(wijCSS.cornerBL);
                                break;
                            case "horizontalDownLeft":
                                this.spinDownElement.addClass(wijCSS.cornerLeft);
                                break;
                            case "horizontalUpLeft":
                                this.spinUpElement.addClass(wijCSS.cornerLeft);
                                break;
                        }
                    }
                } else if (showSpinner) {
                    switch (spinnerAlign) {
                        case "verticalLeft":
                            this.spinUpElement.addClass(wijCSS.cornerTL);
                            this.spinDownElement.addClass(wijCSS.cornerBL);
                            break;
                        case "verticalRight":
                            this.spinUpElement.addClass(wijCSS.cornerTR);
                            this.spinDownElement.addClass(wijCSS.cornerBR);
                            break;
                        case "horizontalDownLeft":
                            this.spinDownElement.addClass(wijCSS.cornerLeft);
                            this.spinUpElement.addClass(wijCSS.cornerRight);
                            break;
                        case "horizontalUpLeft":
                            this.spinUpElement.addClass(wijCSS.cornerLeft);
                            this.spinDownElement.addClass(wijCSS.cornerRight);
                            break;
                    }
                }
            };

            wijinputcore.prototype._createDropDownAndSpinLayout = function () {
                var spinnerAlign = this.options.spinnerAlign;
                var showSpinner = this.options.showSpinner;
                var showDropDownButton = this._isDropDownButtonShown();

                if (this.options.buttonAlign != null) {
                    spinnerAlign = this.options.buttonAlign == 'left' ? "verticalLeft" : "verticalRight";
                }

                if (showDropDownButton) {
                    this.triggerBtn.appendTo(this.outerDiv);
                }

                if (showSpinner) {
                    switch (spinnerAlign) {
                        case "verticalLeft":
                            this.spinnerLeft.append(this.spinUpElement).append(this.spinDownElement).appendTo(this.outerDiv);
                            break;
                        case "verticalRight":
                            this.spinnerRight.append(this.spinUpElement).append(this.spinDownElement).appendTo(this.outerDiv);
                            break;
                        case "horizontalDownLeft":
                            this.spinnerLeft.append(this.spinDownElement).appendTo(this.outerDiv);
                            this.spinnerRight.append(this.spinUpElement).appendTo(this.outerDiv);
                            break;
                        case "horizontalUpLeft":
                            this.spinnerLeft.append(this.spinUpElement).appendTo(this.outerDiv);
                            this.spinnerRight.append(this.spinDownElement).appendTo(this.outerDiv);
                            break;
                    }
                }
            };

            wijinputcore.prototype._isDropDownButtonShown = function () {
                var showTrigger = this.options.showTrigger;
                if (showTrigger === undefined) {
                    showTrigger = false;
                }
                return showTrigger || this.options.showDropDownButton;
            };

            wijinputcore.prototype._isInPercents = function (size) {
                return size.match(/%$/);
            };

            wijinputcore.prototype._createTextProvider = function () {
                return undefined;
            };

            wijinputcore.prototype._beginUpdate = function () {
            };

            wijinputcore.prototype._endUpdate = function () {
                var _this = this;
                if (this.element.mousewheel && !this._boundMouseWheel) {
                    this.element.mousewheel(function (e, delta) {
                        if (_this.isFocused() && _this._doSpin(delta > 0, false)) {
                            e.preventDefault();
                        }
                    });
                    this._boundMouseWheel = true;
                }
            };

            wijinputcore.prototype._isPopupShowing = function () {
                return !!this._comboDiv && this._comboDiv.wijpopup("isVisible");
            };

            wijinputcore.prototype._onTriggerMouseDown = function (evt) {
                if (this._wasPopupShowing) {
                    this._blockNextTriggerClickedEvent = true;
                }
            };

            wijinputcore.prototype._onTriggerMouseUp = function (evt) {
            };

            wijinputcore.prototype._onTriggerClicked = function () {
                if (this._blockNextTriggerClickedEvent) {
                    this._blockNextTriggerClickedEvent = false;
                    return;
                }
                if (this._popupVisible()) {
                    this._hidePopup();
                } else {
                    this._showPopup();
                }
            };
            wijinputcore.prototype._showPopup = function () {
                return this._popupComboList();
            };
            wijinputcore.prototype._hidePopup = function () {
                this._comboDiv.wijpopup('hide');
            };

            wijinputcore.prototype._initialize = function () {
                var _this = this;
                this.element.data('initializing', true);
                this._trigger('initializing');

                this.element.data('preText', this.element.val());
                this.element.data('elementValue', this.element.val());
                this.element.data('errorstate', false);
                this.element.data('breakSpinner', true);
                this.element.data('prevSelection', null);
                this.element.data('simulating', false);

                this._createTextProvider();
                this._beginUpdate();

                var options = this.options, isLeftButton = function (e) {
                    return (!e.which ? e.button : e.which) === 1;
                }, spinButtonDown = function (e) {
                    if (_this._isDisabled()) {
                        return;
                    }
                    if (!isLeftButton(e)) {
                        return;
                    }
                    if (_this.options.disableUserInput) {
                        return;
                    }
                    _this._deferClearBlurTimeout();
                    _this._trySetFocus();
                    if (CoreUtility.IsFireFox4OrLater()) {
                        _this._stopEvent(e);
                    }

                    _this.element.data('breakSpinner', false);
                    _this._addState('active', $(_this));
                    _this._doSpin($(e.currentTarget).hasClass(options.wijCSS.wijinputSpinUp) || $('.' + options.wijCSS.iconPlus, e.currentTarget).length > 0, true);
                }, spinButtonUp = function (e) {
                    if (_this._isDisabled()) {
                        return;
                    }
                    if (!isLeftButton(e)) {
                        return;
                    }
                    if (_this.options.disableUserInput) {
                        return;
                    }
                    _this._stopSpin();
                    _this._removeState('active', $(_this));
                };

                if (this.triggerBtn && !options.disabledState) {
                    this.triggerBtn.bind({
                        'mouseover': function () {
                            if (_this._isDisabled()) {
                                return;
                            }
                            _this._addState('hover', $(_this));
                        },
                        'mouseout': function () {
                            if (_this._isDisabled()) {
                                return;
                            }
                            _this._removeState('hover', $(_this));
                        },
                        'mousedown': function (e) {
                            if (_this._isDisabled()) {
                                return;
                            }
                            if (!isLeftButton(e)) {
                                return;
                            }
                            _this._stopEvent(e);
                            _this._addState('active', $(_this));
                            _this._trigger('triggerMouseDown');
                            _this._trigger('dropDownButtonMouseDown');
                            _this._onTriggerMouseDown(e);
                        },
                        'mouseup': function (e) {
                            _this._onTriggerMouseUp(e);
                        },
                        'click': function (e) {
                            if (_this._isDisabled()) {
                                return;
                            }
                            _this._stopEvent(e);
                            _this._stopSpin();
                            _this._removeState('active', $(_this));
                            _this._trigger('triggerMouseUp');
                            _this._trigger('dropDownButtonMouseUp');
                            _this._onTriggerClicked();
                            if (!CoreUtility.IPad) {
                                _this._trySetFocus();
                            }
                        }
                    });
                }

                if (this.spinUpElement && !options.disabledState) {
                    this.spinUpElement.bind({
                        'mouseover': function () {
                            if (_this._isDisabled()) {
                                return;
                            }
                            _this._addState('hover', $(_this));
                        },
                        'mouseout': function () {
                            if (_this._isDisabled()) {
                                return;
                            }
                            _this._removeState('hover', $(_this));
                            _this._removeState('active', $(_this));
                            _this._stopSpin();
                        },
                        'mousedown': spinButtonDown,
                        'mouseup': spinButtonUp
                    });
                }

                if (this.spinDownElement && !options.disabledState) {
                    this.spinDownElement.bind({
                        'mouseover': function () {
                            if (_this._isDisabled()) {
                                return;
                            }
                            _this._addState('hover', $(_this));
                        },
                        'mouseout': function () {
                            if (_this._isDisabled()) {
                                return;
                            }
                            _this._removeState('hover', $(_this));
                            _this._removeState('active', $(_this));
                            _this._stopSpin();
                        },
                        'mousedown': spinButtonDown,
                        'mouseup': spinButtonUp
                    });
                }

                this._attachInputEvent();
                this.element.data('initializing', false);

                this._resetData();
                this._endUpdate();
                this._updateText();

                if (this.options.imeMode) {
                    this.element.css("ime-mode", this.options.imeMode);
                }

                this.element.data('initialized', true);
                this._trigger('initialized');
            };

            wijinputcore.prototype._attachInputEvent = function () {
                this.element.bind({
                    'focus.wijinput': $.proxy(this._onFocus, this),
                    'beforedeactivate.wijinput': $.proxy(this._onBeforeDeactivate, this),
                    'blur.wijinput': $.proxy(this._onBlur, this),
                    'mousedown.wijinput': $.proxy(this._onMouseDown, this),
                    'mouseup.wijinput': $.proxy(this._onMouseUp, this),
                    'keypress.wijinput': $.proxy(this._onKeyPress, this),
                    'keydown.wijinput': $.proxy(this._onKeyDown, this),
                    'keyup.wijinput': $.proxy(this._onKeyUp, this),
                    'compositionstart.wijinput': $.proxy(this._onCompositionStart, this),
                    'compositionend.wijinput': $.proxy(this._onCompositionEnd, this),
                    'change.wijinput': $.proxy(this._onChange, this),
                    'paste.wijinput': $.proxy(this._onPaste, this),
                    'drop.wijinput': $.proxy(this._onDrop, this)
                });

                this.element.bind('propertychange.wijinput input.wijinput', $.proxy(this._onInput, this));
            };

            wijinputcore.prototype._detachInputEvent = function () {
                this.element.unbind('.wijinput');
            };

            wijinputcore.prototype._init = function () {
                if (this.element.attr("readOnly")) {
                    this.options.readonly = true;
                }
                if (this.options.readonly === true) {
                    this.options.disableUserInput = true;
                }
                if (this.options.readonly === true || this.options.disableUserInput === true) {
                    this.element.attr('readOnly', true);
                }

                if (this.options.placeholder != null) {
                    this.options.nullText = this.options.placeholder;
                }
            };

            wijinputcore.prototype._showNullText = function () {
                return !!this.options.nullText || this.options.nullText === "";
            };

            wijinputcore.prototype._setOption = function (key, value) {
                switch (key) {
                    case 'readonly':
                        this._super(key, value);
                        key = "disableUserInput";
                        break;
                    case 'placeholder':
                        this._super(key, value);
                        key = 'nullText';
                        break;
                    case 'showTrigger':
                        this.options.showTrigger = value;
                        this.options.showDropDownButton = value;
                        break;
                }

                this._super(key, value);

                switch (key) {
                    case 'spinnerAlign':
                    case 'dropDownButtonAlign':
                    case 'showDropDownButton':
                    case 'buttonAlign':
                    case 'showTrigger':
                    case 'showSpinner':
                        this._destroy();
                        this._create();
                        break;

                    case 'showNullText':
                    case 'nullText':
                        this._updateText();
                        break;

                    case 'imeMode':
                        this.element.css("ime-mode", this.options.imeMode);
                        break;

                    case 'disableUserInput':
                        this.element.attr('readOnly', value);
                        break;
                    case 'pickers':
                        this._deleteComboDiv();
                        break;
                }
            };

            wijinputcore.prototype._innerDisable = function () {
                _super.prototype._innerDisable.call(this);
                this._toggleDisableInput(true);
            };

            wijinputcore.prototype._innerEnable = function () {
                _super.prototype._innerEnable.call(this);
                this._toggleDisableInput(false);
            };

            wijinputcore.prototype._toggleDisableInput = function (disabled) {
                var stateDisabled = this.options.wijCSS.stateDisabled;
                this.element.attr('disabled', disabled);

                this.element.toggleClass(stateDisabled, disabled);
                if (this.triggerBtn) {
                    this.triggerBtn.toggleClass(stateDisabled, disabled);
                }

                if (this.spinUpElement) {
                    this.spinUpElement.toggleClass(stateDisabled, disabled);
                }

                if (this.spinDownElement) {
                    this.spinDownElement.toggleClass(stateDisabled, disabled);
                }
            };

            /** Destroy the widget.
            */
            wijinputcore.prototype.destroy = function () {
                this._super();
                if (this._comboDiv) {
                    this._comboDiv.remove();
                }

                if (this.outerDiv) {
                    this.outerDiv.remove();
                }

                if (this._hiddenInput) {
                    this._hiddenInput.remove();
                }

                if (this.spinnerLeft) {
                    this.spinnerLeft.remove();
                }
                if (this.spinnerRight) {
                    this.spinnerRight.remove();
                }
                if (this.spinDownElement) {
                    this.spinDownElement.remove();
                }
                if (this.spinUpElement) {
                    this.spinUpElement.remove();
                }
                this._destroy();
            };

            /** Open the dropdown list.
            */
            wijinputcore.prototype.drop = function () {
                this._onTriggerClicked();
            };

            /** Get a boolean value indicates that whether the widget has been destroyed.
            */
            wijinputcore.prototype.isDestroyed = function () {
                return !this.outerDiv;
            };

            wijinputcore.prototype._destroy = function () {
                if (this.isDestroyed())
                    return;
                this.wrapper = undefined;
                this.outerDiv = undefined;

                this._detachInputEvent();

                this.element.removeData('errorstate').removeData('breakSpinner').removeData('prevSelection').removeData('simulating').removeData('isPassword').removeClass(this.options.wijCSS.wijinputInput).removeAttr('role').removeAttr('aria-valuemin').removeAttr('aria-valuemax').removeAttr('aria-valuenow');

                this.element.parent().replaceWith(this.element);
                this.element.parent().replaceWith(this.element);

                //$.effects.restore(this.element, ['width', 'height']);
                if ($.effects && $.effects.restore) {
                    $.effects.restore(this.element, ['width', 'height']);
                } else if ($.restore) {
                    $.restore(this.element, ['width', 'height']);
                }

                // DaryLuo 2014/03/05 fix bug 50664.
                this.triggerBtn = undefined;
                this.spinnerLeft = undefined;
                this.spinnerRight = undefined;
                this.spinDownElement = undefined;
                this.spinUpElement = undefined;
                this._clearBlurTimeout();
            };

            /** Gets element this widget is associated.
            */
            wijinputcore.prototype.widget = function () {
                return this.outerDiv || this._super();
            };

            wijinputcore.prototype._getCulture = function (name) {
                if (!Globalize) {
                    return null;
                }
                var cal = $.extend(true, {}, Globalize.findClosestCulture(name || this.options.culture) || Globalize.findClosestCulture("default"));
                if (this.options.cultureCalendar !== '' && this.options.cultureCalendar !== 'standard') {
                    $.extend(cal.calendar, cal.calendars[this.options.cultureCalendar || 'standard']);
                }
                return cal;
            };

            wijinputcore.prototype._addState = function (state, el) {
                if (el.is(':not(.ui-state-disabled)')) {
                    el.addClass(this.options.wijCSS.getState(state));
                }
            };

            wijinputcore.prototype._removeState = function (state, el) {
                el.removeClass(this.options.wijCSS.getState(state));
            };

            wijinputcore.prototype._isInitialized = function () {
                return !this.element.data('initializing');
            };

            wijinputcore.prototype._setData = function (val) {
                this.setText(val);
            };

            wijinputcore.prototype._resetData = function () {
            };

            wijinputcore.prototype._validateData = function () {
            };

            /** Gets the text displayed in the input box.
            */
            wijinputcore.prototype.getText = function () {
                if (!this._isInitialized()) {
                    return this.element.val();
                }
                return this._textProvider.toString(true, false, false);
            };

            /** Sets the text displayed in the input box.
            * @example
            * // This example sets text of a wijinputcore to "Hello"
            * $(".selector").wijinputcore("setText", "Hello");
            */
            wijinputcore.prototype.setText = function (value) {
                if (!this._isInitialized()) {
                    this.element.val(value);
                } else {
                    this._textProvider.setText(value);
                    if (value !== "" && this.element.val() !== this.options.nullText) {
                        this.element.data('isShowNullText', false);
                    }
                    this._updateText();
                }
            };

            /** Gets the text value when the container form is posted back to server.
            */
            wijinputcore.prototype.getPostValue = function () {
                if (!this._isInitialized()) {
                    return this.element.val();
                }
                return this._textProvider.toString(true, false, true);
            };

            /** Selects a range of text in the widget.
            * @param {Number} start Start of the range.
            * @param {Number} end End of the range.
            * @example
            * // Select first two symbols in a wijinputcore
            * $(".selector").wijinputdate("selectText", 0, 2);
            */
            wijinputcore.prototype.selectText = function (start, end) {
                var _this = this;
                if (typeof start === "undefined") { start = 0; }
                if (typeof end === "undefined") { end = this.getText().length; }
                if (isNaN(start)) {
                    start = 0;
                }
                if (isNaN(end)) {
                    end = 0;
                }
                if (CoreUtility.IsFireFox4OrLater()) {
                    this.focus();
                }
                if (this.element.is(':disabled')) {
                    return;
                }
                this.isSelectingFromAPI = true;
                this.element.wijtextselection(start, end);
                setTimeout(function () {
                    return _this.isSelectingFromAPI = false;
                }, 100);
            };

            /** Set the focus to the widget.
            */
            wijinputcore.prototype.focus = function () {
                if (this.element.is(':disabled')) {
                    return;
                }
                this.element.get(0).focus();
            };

            /** Determines whether the widget has the focus.
            */
            wijinputcore.prototype.isFocused = function () {
                if (!this.outerDiv) {
                    return false;
                }

                return this.outerDiv.hasClass(this.options.wijCSS.stateFocus);
            };

            /** Gets the selected text.
            */
            wijinputcore.prototype.getSelectedText = function () {
                if (this.isFocused()) {
                    return this.element.wijtextselection().text;
                } else {
                    if (this.element.data('prevSelection')) {
                        var start = this.element.data('prevSelection').start, end = this.element.data('prevSelection').end;
                        return this.element.val().substring(start, end);
                    } else {
                        return "";
                    }
                }
            };

            wijinputcore.prototype._raiseTextChanged = function () {
                var txt = this.element.val(), preText = this.element.data('preText');
                if (!!this.element.data('initialized') && preText !== txt) {
                    if (this._hiddenInput) {
                        this._hiddenInput.val(this.getPostValue());
                    }

                    this._trigger('textChanged', null, { text: txt });
                    this.element.data('changed', true);
                }

                this.element.data('preText', txt);
            };

            wijinputcore.prototype._raiseDataChanged = function () {
            };

            wijinputcore.prototype._allowEdit = function () {
                return !this.element.is(':disabled');
            };

            wijinputcore.prototype._updateText = function (keepSelection) {
                if (typeof keepSelection === "undefined") { keepSelection = false; }
                if (!this._isInitialized()) {
                    return;
                }

                // default is false
                keepSelection = !!keepSelection;

                var range;
                if (this.element.data('selectionbeforeblur') !== undefined) {
                    range = this.element.data('selectionbeforeblur');
                    this.element.removeData('selectionbeforeblur');
                } else {
                    try  {
                        range = this.element.wijtextselection();
                    } catch (e) {
                    }
                }
                var opt = this.options;

                if (this.isDeleteAll && this._showNullText()) {
                    this.isDeleteAll = false;
                    opt.date = null;
                    this.element.val(opt.nullText);
                } else {
                    this.element.val(this._textProvider.toString());
                    this.options.text = this._textProvider.toString(true, false, false);
                }

                if (!this.element.is(':disabled')) {
                    if (keepSelection) {
                        this.selectText(range.start, range.end);
                    }
                    this.element.data('prevSelection', range);
                }

                this._raiseTextChanged();
                this._raiseDataChanged();
            };

            wijinputcore.prototype._trySetFocus = function () {
                if (document.activeElement !== this.element[0]) {
                    try  {
                        if (!this.options.disableUserInput) {
                            this.element.focus();
                        }
                    } catch (e) {
                    }
                }
            };

            wijinputcore.prototype._deleteSelText = function (backSpace) {
                if (typeof backSpace === "undefined") { backSpace = false; }
                if (!this._allowEdit()) {
                    return;
                }
                var selRange = this.element.wijtextselection();

                if (backSpace) {
                    if (selRange.end < 1)
                        return;
                    if (selRange.end === selRange.start) {
                        selRange.start--;
                    }
                }
                selRange.end--;
                if (selRange.end < selRange.start) {
                    selRange.end = selRange.start;
                }

                var rh = new input.wijInputResult();
                this._textProvider.removeAt(selRange.start, selRange.end, rh);
                this._updateText();
                this.selectText(rh.testPosition, rh.testPosition);
            };

            wijinputcore.prototype._fireIvalidInputEvent = function (chr) {
                var _this = this;
                var invalidInputResult = this._trigger('invalidInput', null, { widget: this, char: chr });
                if ($.isFunction(this.options.invalidInput) && invalidInputResult === true) {
                    return;
                }
                if (!this.element.data('errorstate')) {
                    var cls = this.options.invalidClass || this.options.wijCSS.stateError;
                    this.element.data('errorstate', true);

                    window.setTimeout(function () {
                        if (_this.outerDiv) {
                            _this.outerDiv.removeClass(cls);
                        }
                        _this.element.data('errorstate', false);
                    }, 200);
                    this.outerDiv.addClass(cls);
                }
            };

            wijinputcore.prototype._onInput = function (e) {
                var isIOS = window.navigator.userAgent.match(/iPhone|iPad|iPod/i);
                if (isIOS) {
                    if (this.element.data("hasInput") === true && !this._imeCompostiing) {
                        this.element.data("hasInput", false);
                        this._simulate();
                    }
                    return;
                }
                if (!this._isSimulating() || !this.element.data('ime') || this.element.data("isComposingIME")) {
                    if (this.element.data("isComposingIME")) {
                        this.element.data("simulationPending", true);
                    }
                    return;
                }
                this._simulate();
            };

            wijinputcore.prototype._keyDownPreview = function (e) {
                var key = e.keyCode || e.which;

                if (e.ctrlKey === true && key === 88) {
                    return true;
                }
                if (e.ctrlKey === true && key === 90) {
                    return true;
                }
                return false;
            };

            wijinputcore.prototype._onDoubleByteCharacter = function () {
                var prev = this.element.data("lastDbsState");
                var curSel = this.element.wijtextselection();
                var curText = this.element.val();

                if (this.element.data("isComposingIME") && prev && prev.selection.start === curSel.start && prev.Text === curText) {
                    // nothing changed. The input must be accepted
                    this.element.removeData("lastDbsState");
                    this._simulateOnCompositionEnd();
                } else {
                    this.element.data("lastDbsState", { selection: curSel, text: curText });
                    this._onCompositionStart();
                }
            };
            wijinputcore.prototype._onCompositionStart = function () {
                var isIOS = window.navigator.userAgent.match(/iPhone|iPad|iPod/i);
                if (isIOS) {
                    this._imeCompostiing = true;
                    this._beforeSimulate(true);
                    return;
                }
                if (this.element.data("isComposingIME"))
                    return;
                this.element.data("isComposingIME", true);
                this._beforeSimulate(true);
            };
            wijinputcore.prototype._onCompositionEnd = function () {
                var isIOS = window.navigator.userAgent.match(/iPhone|iPad|iPod/i);
                if (isIOS) {
                    this._imeCompostiing = false;
                    this.element.data("hasInput", true);
                    return;
                }
                this._simulateOnCompositionEnd();
            };
            wijinputcore.prototype._simulateOnCompositionEnd = function () {
                if (!this.element.data("isComposingIME"))
                    return;

                this.element.data("isComposingIME", false);
                if (this._isInitialized() && (!this._textProvider || !this._textProvider.noMask)) {
                    this._simulateIfPending();
                }
            };

            wijinputcore.prototype._simulateIfPending = function () {
                if (this.element.data("simulationPending") && this.element.data("lastSelection")) {
                    this._simulate();
                }
            };

            wijinputcore.prototype._beforeSimulate = function (ime) {
                if (typeof ime === "undefined") { ime = false; }
                if (!this.element.data('lastSelection')) {
                    this.element.data('lastSelection', this.element.wijtextselection());
                    this.element.data('lastValue', this.element.val());
                }

                this.element.data('ime', ime);
                this.element.data('simulating', true);
            };

            wijinputcore.prototype._isSimulating = function () {
                return this.element.data('simulating');
            };

            wijinputcore.prototype._simulate = function (text) {
                var self = this;
                var str = null;

                this.element.data("simulationPending", false);

                if (typeof text === "string") {
                    str = text;
                } else {
                    var range = this.element.wijtextselection();
                    var start = this.element.data('lastSelection').start;
                    var end = range.end;

                    if (end >= start) {
                        str = this.element.val().substring(start, end);
                    }
                }

                if (str) {
                    window.setTimeout(function () {
                        if (self._isLastValueNull()) {
                            return;
                        }
                        self.element.val(self.element.data('lastValue'));
                        var lastSel = self.element.data('lastSelection');
                        self.element.wijtextselection(lastSel);
                        self._batchKeyPress = true;
                        self.element.data('simulating', false);
                        var e = jQuery.Event('keypress');
                        e.ctrlKey = e.altKey = false;
                        for (var i = 0; i < str.length; i++) {
                            e.which = e.charCode = e.keyCode = str.charCodeAt(i);
                            self._nextChar = i === str.length - 1 ? "" : str.charAt(i + 1);
                            self._onKeyPress(e);
                            self._nextChar = "";

                            var appendChar = self._appendChar;
                            if (appendChar && appendChar.length > 0) {
                                self._appendChar = "";
                                e.which = e.charCode = e.keyCode = appendChar.charCodeAt(i);
                                self._onKeyPress(e);
                            }
                            if (self._skipNextChar) {
                                i++;
                                self._skipNextChar = false;
                            }
                        }

                        self._batchKeyPress = false;
                        self._endSimulate();
                    }, 1);
                }
            };

            wijinputcore.prototype._isLastValueNull = function () {
                return !this.element.data('lastValue');
            };

            wijinputcore.prototype._endSimulate = function () {
                this._simulateIfPending();
                this.element.removeData('ime');
                this.element.removeData('lastSelection');
                this.element.removeData('lastValue');
            };

            wijinputcore.prototype._processKeyForDropDownList = function (e) {
                var k = this._getKeyCode(e);
                if (e.altKey && (k === jqKeyCode.UP || k === jqKeyCode.DOWN)) {
                    this._onTriggerClicked();
                    this._stopEvent(e);
                    return true;
                }
                if (k === jqKeyCode.ESCAPE) {
                    if (this._wasPopupShowing) {
                        this._hidePopup();
                        this._stopEvent(e);
                        return true;
                    }
                }

                if (this._wasPopupShowing && this._comboDiv !== undefined) {
                    if (k === jqKeyCode.DOWN) {
                        try  {
                            this._comboDiv.wijlist('next');
                        } catch (ee) {
                        }
                        this._stopEvent(e);
                        return true;
                    } else if (k === jqKeyCode.UP) {
                        try  {
                            this._comboDiv.wijlist('previous');
                        } catch (ee) {
                        }
                        this._stopEvent(e);
                        return true;
                    } else if (k === jqKeyCode.ENTER) {
                        this._comboDiv.wijlist('select');

                        // DaryLuo 2014/07/07 fix bug 71663.
                        // Here we only prevent default behavior, but still left the event bubble up.
                        e.preventDefault();

                        //this._stopEvent(e);
                        return true;
                    } else if (k === jqKeyCode.PAGE_DOWN) {
                        try  {
                            this._comboDiv.wijlist('nextPage');
                        } catch (ee) {
                        }
                        this._stopEvent(e);
                        return true;
                    } else if (k === jqKeyCode.PAGE_UP) {
                        try  {
                            this._comboDiv.wijlist('previousPage');
                        } catch (ee) {
                        }
                        this._stopEvent(e);
                        return true;
                    }
                }
            };

            wijinputcore.prototype._processKeyOnNoMask = function (e) {
                var k = this._getKeyCode(e);
                if (k === jqKeyCode.ENTER) {
                    this._onEnterDown(e);
                    if (this.options.autoPostBack) {
                        this._stopEvent(e);
                    }
                }
                if (k === jqKeyCode.LEFT || k === jqKeyCode.RIGHT) {
                    if (this._processLeftRightKey(k === jqKeyCode.LEFT)) {
                        this._stopEvent(e);
                        return;
                    }
                }

                this._processKeyForDropDownList(e);
            };

            wijinputcore.prototype._onKeyDown = function (e) {
                var isIOS = window.navigator.userAgent.match(/iPhone|iPad|iPod/i);
                if (isIOS && this._imeCompostiing) {
                    return;
                }
                this.element.data('prevSelection', null);
                this._deleteKeyDown = false;

                if (!this._isInitialized()) {
                    return;
                }

                if (this._textProvider && !!this._textProvider.noMask) {
                    this._processKeyOnNoMask(e);
                    return;
                }
                var k = this._getKeyCode(e);

                if (k === 229) {
                    this._onDoubleByteCharacter();
                    return;
                }
                this._simulateOnCompositionEnd();

                if (this.options.disableUserInput) {
                    if (k === jqKeyCode.TAB) {
                        if (this._processTabKey(e)) {
                            this._stopEvent(e);
                        }
                    } else {
                        this._stopEvent(e);
                    }
                    return;
                }

                if (this._keyDownPreview(e)) {
                    this._stopEvent(e);
                    return;
                }
                if (this._processKeyForDropDownList(e)) {
                    return;
                }

                switch (k) {
                    case jqKeyCode.UP:
                        this._doSpin(true, false);
                        this._stopEvent(e);
                        return;
                    case jqKeyCode.DOWN:
                        this._doSpin(false, false);
                        this._stopEvent(e);
                        return;
                    case jqKeyCode.LEFT:
                    case jqKeyCode.RIGHT:
                        if (this._processLeftRightKey(k === jqKeyCode.LEFT)) {
                            this._trigger('keyExit');
                            this._stopEvent(e);
                        }
                        return;
                    case jqKeyCode.TAB:
                        if (this._processTabKey(e)) {
                            this._stopEvent(e);
                        }
                        return;
                }

                if (e.ctrlKey) {
                    switch (k) {
                        case jqKeyCode.INSERT:
                        case 67:
                            return;
                        default:
                            break;
                    }
                }
                if (e.ctrlKey || e.altKey) {
                    return;
                }

                switch (k) {
                    case 112:
                    case 113:
                    case 114:
                    case 115:
                    case 116:
                    case 117:
                    case jqKeyCode.TAB:
                    case jqKeyCode.CAPSLOCK:
                    case jqKeyCode.END:
                    case jqKeyCode.HOME:
                    case jqKeyCode.CTRL:
                    case jqKeyCode.SHIFT:
                        return;
                    case jqKeyCode.BACKSPACE:
                        this._deleteSelText(true);
                        this._stopEvent(e);
                        return;
                    case jqKeyCode.DELETE:
                        this._deleteSelText(false);
                        this._stopEvent(e);
                        this._deleteKeyDown = true;
                        return;
                    case jqKeyCode.ENTER:
                        this._onEnterDown(e);
                        if (this.options.autoPostBack) {
                            this._stopEvent(e);
                        }
                        break;
                    case jqKeyCode.ESCAPE:
                        this._stopEvent(e);
                        window.setTimeout($.proxy(this._resetData, this), 1);
                        return;
                    case jqKeyCode.PAGE_UP:
                    case jqKeyCode.PAGE_DOWN:
                    case jqKeyCode.ALT:
                        this._stopEvent(e);
                        return;
                }
            };

            wijinputcore.prototype._onEnterDown = function (e) {
                if (this.options.hideEnter) {
                    this._stopEvent(e);
                }
            };

            wijinputcore.prototype._onKeyUp = function (e) {
                var isIOS = window.navigator.userAgent.match(/iPhone|iPad|iPod/i);
                if (isIOS && this._imeCompostiing) {
                    return;
                }
                if (this._textProvider && !!this._textProvider.noMask) {
                    return;
                }

                var key = this._getKeyCode(e);

                if (this._isSimulating()) {
                    if (key === jqKeyCode.ENTER) {
                        this._simulateOnCompositionEnd();
                    }
                    return;
                }

                if (!this._isInitialized()) {
                    return;
                }
                if (key === jqKeyCode.ENTER || key === jqKeyCode.ESCAPE) {
                    return;
                }

                if (this.options.disableUserInput) {
                    this._raiseTextChanged();
                    this._raiseDataChanged();
                    return;
                }

                this._stopEvent(e);
            };

            wijinputcore.prototype._getKeyCode = function (e) {
                var userAgent = window.navigator.userAgent;
                if ((userAgent.indexOf('iPod') !== -1 || userAgent.indexOf('iPhone') !== -1) && e.which === 127) {
                    return 8;
                }
                return e.keyCode || e.which;
            };

            wijinputcore.prototype._keyPressPreview = function (e) {
                return false;
            };

            wijinputcore.prototype._onKeyPress = function (e) {
                if (this._isSimulating() || (this._textProvider && !!this._textProvider.noMask)) {
                    return;
                }
                var isIOS = window.navigator.userAgent.match(/iPhone|iPad|iPod/i);
                if (isIOS && this._imeCompostiing) {
                    return;
                }
                this.element.data('prevSelection', null);

                if (this.options.disableUserInput) {
                    return;
                }
                if (!this._allowEdit()) {
                    return;
                }

                if (e.ctrlKey && e.keyCode === 119) {
                    this._onPaste(e);
                    return;
                }

                var key = e.keyCode || e.which;

                if (CoreUtility.IsFireFox4OrLater()) {
                    switch (e.keyCode) {
                        case jqKeyCode.UP:
                        case jqKeyCode.DOWN:
                        case jqKeyCode.LEFT:
                        case jqKeyCode.RIGHT:
                        case jqKeyCode.HOME:
                        case jqKeyCode.END:
                            return;
                    }
                }

                switch (key) {
                    case 0:
                    case jqKeyCode.TAB:
                        //case jqKeyCode.UP:
                        //case jqKeyCode.DOWN:
                        //case jqKeyCode.LEFT:
                        //case jqKeyCode.RIGHT:
                        return;

                    case jqKeyCode.BACKSPACE:
                        this._stopEvent(e);
                        return;

                    case jqKeyCode.DELETE:
                        if (this._deleteKeyDown) {
                            this._stopEvent(e);
                            return;
                        }
                        break;

                    case jqKeyCode.ENTER:
                        if (this.options.hideEnter) {
                            this._stopEvent(e);
                        }
                        return;
                }

                if (e.ctrlKey || e.altKey) {
                    if (key !== jqKeyCode.SPACE) {
                        return;
                    }
                }

                if (this._keyPressPreview(e)) {
                    return;
                }
                var isIOS = window.navigator.userAgent.match(/iPhone|iPad|iPod/i);

                if (isIOS && !this._batchKeyPress) {
                    this.element.data("hasInput", true);
                    this._beforeSimulate(true);
                    return;
                }

                var ch = String.fromCharCode(key);

                var rh = this._textProvider.replaceWith(this.element.wijtextselection(), ch);
                if (rh) {
                    this._updateText();
                    this.selectText(rh.testPosition + 1, rh.testPosition + 1);
                    this.element.data('prevSelection', { start: rh.testPosition + 1, end: rh.testPosition + 1 });
                } else {
                    this._fireIvalidInputEvent(ch);
                }
                if (!this._batchKeyPress) {
                    this._stopEvent(e);
                }
            };

            wijinputcore.prototype._isNullText = function (val) {
                val = val || this.element.val();
                return this._showNullText() && val === this.options.nullText;
            };

            wijinputcore.prototype._doFocus = function () {
                var selRange = this.element.wijtextselection();
                var sta = selRange.start;
                this._updateText();
                var s = this.element.val();
                if (s.length === sta) {
                    sta = 0;
                }
                if (!$.browser.safari) {
                    this.selectText(sta, sta);
                }
            };

            wijinputcore.prototype._afterFocused = function () {
                if (this._isNullText()) {
                    this._doFocus();
                }
            };

            wijinputcore.prototype._onFocus = function (e) {
                if (this.options.disableUserInput) {
                    return;
                }

                this.outerDiv.addClass(this.options.wijCSS.getState('focus'));

                if (!this.element.data('breakSpinner')) {
                    return;
                }

                if (!this._isInitialized()) {
                    return;
                }
                if (!this._allowEdit()) {
                    return;
                }

                if (this.isSelectingFromAPI) {
                    return;
                }
                if (!this.element.data('focusNotCalledFirstTime')) {
                    this.element.data('focusNotCalledFirstTime', new Date().getTime());
                }
                this._afterFocused();
            };

            wijinputcore.prototype._onBeforeDeactivate = function (e) {
                if (this.options.disableUserInput) {
                    return;
                }
                if (!this.element.data('breakSpinner')) {
                    return;
                }
                if (!this._isInitialized()) {
                    return;
                }
                if (!this._allowEdit()) {
                    return;
                }

                this.element.data('selectionbeforeblur', this.element.wijtextselection());
            };

            wijinputcore.prototype._onBlur = function (e) {
                var _this = this;
                if (this.options.disableUserInput) {
                    return;
                }
                this._simulateOnCompositionEnd();

                if (!this.element.data('breakSpinner')) {
                    this.element.get(0).focus();
                    if (this.element.data('prevSelection')) {
                        var curPos = this.element.data('prevSelection').start;
                        if (curPos !== undefined && curPos !== null) {
                            this.selectText(curPos, curPos);
                        }
                    }
                    return;
                }
                this._clearBlurTimeout();

                this._blurTimeout = setTimeout(function () {
                    _this._blurTimeout = null;

                    //Add comments by Ryanwu@20160520.
                    //For fixing the issue#151957,152107.
                    //if (this._isComboListVisible()) {
                    //return;
                    //}
                    if (_this._popupVisible()) {
                        _this._hidePopup();
                    }

                    //end by RyanWu@20160520.
                    var isFocused = _this.isFocused();
                    _this._removeState('focus', _this.outerDiv);

                    if (!_this._isInitialized() || !isFocused) {
                        return;
                    }

                    _this.element.data('value', _this.element.val());
                    _this._updateTextOnLostFocus();
                }, 100);
            };

            wijinputcore.prototype._updateTextOnLostFocus = function () {
                var _this = this;
                window.setTimeout(function () {
                    _this._onChange();
                    _this._updateText();
                    _this._validateData();

                    if (_this.element.data('changed')) {
                        _this.element.data('changed', false);
                        if (!_this._popupVisible()) {
                            _this._trigger('change');
                            _this.element.data("customRaiseChange", true);
                            try  {
                                _this.element.change();
                            } finally {
                                _this.element.data("customRaiseChange", false);
                            }
                        }
                    }
                }, 100);
            };

            wijinputcore.prototype._popupVisible = function () {
                return this._wasPopupShowing;
            };

            wijinputcore.prototype._onMouseDown = function (e) {
                if (!this._isInitialized()) {
                    return;
                }
                if (this.element.is(':disabled')) {
                    return;
                }

                if (CoreUtility.IsMouseDownOnClearButton(e)) {
                    var isFocused = false;
                    try  {
                        isFocused = document.activeElement === e.target;
                    } catch (ee) {
                    }
                    this.element.data("focusedWhenMouseDown", isFocused);
                    this.element.data('mouseDownOnClearButton', true);
                    return;
                }
            };

            wijinputcore.prototype._onMouseUp = function (e) {
                if (!this._isInitialized()) {
                    return;
                }
                if (this.element.is(':disabled')) {
                    return;
                }

                if (CoreUtility.IsMouseDownOnClearButton(e) && this.element.data('mouseDownOnClearButton') && this.element.data('focusedWhenMouseDown') === true) {
                    if (!this.options.disableUserInput) {
                        var self = this;
                        setTimeout(function () {
                            self._processClearButton();
                        }, 0);
                    }
                    this.element.data('mouseDownOnClearButton', false);
                    return;
                }
                this.element.data('mouseDownOnClearButton', false);
                this.element.data('focusedWhenMouseDown', false);

                var selRange = this.element.wijtextselection();
                this.element.data('prevSelection', selRange);

                // fixed an issue of IE10(browser mode IE9), when runs in this mode,
                // the input element will show clear button at the right side of the input element.
                // click the button, the widget's text value will not cleared.
                if (this.element.val() == '') {
                    return;
                }
                var self = this;

                // Wait for it....
                setTimeout(function () {
                    if (self.element.val() == '') {
                        self.setText("");
                    }
                }, 5);

                if (this.element.data('isFocusSelecting')) {
                    this.element.data('isFocusSelecting', false);
                    e.preventDefault();
                }
            };

            wijinputcore.prototype._onChange = function () {
                if (!this.element) {
                    return;
                }
                var val = this.element.val();
                var txt = this.getText();
                if (txt !== val) {
                    this.setText(val);
                }
            };

            wijinputcore.prototype._onPaste = function (e) {
                if (this._textProvider && !!this._textProvider.noMask) {
                    return;
                }
                this._beforeSimulate();
                var self = this;
                window.setTimeout(function () {
                    self._simulate();
                }, 1);
            };

            wijinputcore.prototype._onDrop = function (e) {
                this._beforeSimulate();
                if (e.originalEvent && e.originalEvent.dataTransfer) {
                    var text = e.originalEvent.dataTransfer.getData('Text');
                    if (text) {
                        this._simulate(text);
                    }
                }
            };

            wijinputcore.prototype._stopEvent = function (e) {
                e.stopPropagation();
                e.preventDefault();
            };

            wijinputcore.prototype._calcSpinInterval = function () {
                this._repeatingCount++;
                if (this._repeatingCount > 10) {
                    return 50;
                } else if (this._repeatingCount > 4) {
                    return 100;
                } else if (this._repeatingCount > 2) {
                    return 200;
                }
                return 400;
            };

            wijinputcore.prototype._doSpin = function (up, repeating) {
                return false;
            };

            wijinputcore.prototype._stopSpin = function () {
                this.element.data('breakSpinner', true);
                this._repeatingCount = 0;

                var spintimer = this.element.data("spintimer");
                if (spintimer) {
                    clearTimeout(spintimer);
                    this.element.data("spintimer", undefined);
                }
            };

            wijinputcore.prototype._hasComboItems = function () {
                return !!this._getcomboItems() && this._getcomboItems().length;
            };

            wijinputcore.prototype._getcomboItems = function () {
                if (!!this.options.comboItems && this.options.comboItems.length > 0) {
                    return this.options.comboItems;
                }

                return this.options.pickers.list;
            };

            wijinputcore.prototype._getcomboWidth = function () {
                return this.options.comboWidth || this.options.pickers.width;
            };

            wijinputcore.prototype._getcomboHeight = function () {
                return this.options.comboHeight || this.options.pickers.height;
            };

            //Add comments by Ryanwu@20160520.
            //For fixing the issue#151957,152107.
            //_isComboListVisible(): boolean {
            //	if (!this._comboDiv) {
            //		return false;
            //	}
            //	return <any>this._comboDiv.wijpopup('isVisible');
            //}
            wijinputcore.prototype._clearBlurTimeout = function () {
                if (this._blurTimeout) {
                    clearTimeout(this._blurTimeout);
                    this._blurTimeout = null;
                }
            };

            wijinputcore.prototype._deferClearBlurTimeout = function () {
                var _this = this;
                setTimeout(function () {
                    _this._clearBlurTimeout();
                }, 50);
            };

            //end by RyanWu@20160520.
            wijinputcore.prototype._deleteComboDiv = function () {
                if (this._comboDiv == undefined) {
                    return;
                }

                this._comboDiv.wijlist("destroy");
                this._comboDiv.remove();
                delete this._comboDiv;
            };

            wijinputcore.prototype._createComboDiv = function () {
                var _this = this;
                if (this._comboDiv !== undefined) {
                    return;
                }

                this._comboDiv = $("<div></div>").appendTo(document.body).css('position', 'absolute');

                var content = this._normalize(this._getcomboItems());
                this._comboDiv.wijlist({
                    maxItemsCount: 5,
                    selected: function (event, ui) {
                        if (!_this.options.disableUserInput) {
                            _this._setData(ui.item.value);
                        }
                        _this._comboDiv.wijpopup('hide');
                        _this._trySetFocus();
                    }
                });

                this._comboDiv.wijlist('setItems', content);
                this._comboDiv.wijlist('renderList');
                this._comboDiv[0].removeAttribute("aria-activedescendant");
                this._comboDiv[0].removeAttribute("role");
                this._comboDiv[0].removeAttribute("aria-multiselectable");
            };

            wijinputcore.prototype._popupComboList = function () {
                var _this = this;
                if (!this._hasComboItems()) {
                    return false;
                }
                if (!this._allowEdit()) {
                    return false;
                }

                var divWidth = this.outerDiv.width();
                var comboWidth = this._getcomboWidth();
                var comboHeight = this._getcomboHeight();

                if (this._comboDiv != undefined) {
                    if (comboWidth && parseInt(comboWidth) !== this._comboDiv.width()) {
                        this._deleteComboDiv();
                    }
                }

                this._createComboDiv();

                // dimensions
                this._comboDiv.width(divWidth);
                this._comboDiv.wijlist("option", "autoSize", !comboHeight);
                if (comboHeight) {
                    this._comboDiv.height(comboHeight);
                }
                if (comboWidth) {
                    this._comboDiv.width(comboWidth);
                }

                this._comboDiv.wijlist("refreshSuperPanel");

                this._comboDiv.wijpopup({
                    autoHide: true,
                    hidden: function () {
                        _this._trigger('dropDownClose');
                        _this._wasPopupShowing = false;
                        _this._comboDiv.wijlist("unselectItems");
                        _this._comboDiv.wijlist("deactivate");
                    },
                    shown: function () {
                        _this._trigger('dropDownOpen');
                        _this._wasPopupShowing = true;
                    }
                });

                this._comboDiv.wijpopup('show', {
                    of: this.outerDiv,
                    offset: '0 4'
                });

                this._comboDiv.unbind("mousedown.combodiv").bind("mousedown.combodiv", function () {
                    _this._deferClearBlurTimeout();
                });
                return true;
            };

            wijinputcore.prototype._normalize = function (items) {
                // assume all items have the right format when the first item is complete
                if (items.length && items[0].label && items[0].value) {
                    return items;
                }
                return $.map(items, function (item) {
                    if (typeof item === "string") {
                        return {
                            label: item,
                            value: item
                        };
                    }
                    return $.extend({
                        label: item.label || item.value,
                        value: item.value || item.label
                    }, item);
                });
            };

            wijinputcore.prototype._processLeftRightKey = function (isLeft) {
                return false;
            };
            wijinputcore.prototype._processTabKey = function (e) {
                return false;
            };

            wijinputcore.prototype._moveControl = function (currentElement, isForward, isUseLeftRightKey) {
                var elements = CoreUtility.GetElements();
                var ret = null;
                var retInfo = {};
                if (elements.length < 2) {
                    return null;
                }

                var nextElement = CoreUtility.GetNextFocusableControl(currentElement, elements, isForward);
                var self = this;
                setTimeout(function () {
                    CoreUtility.SetElementFocus(nextElement);
                    self._trigger("keyExit");
                }, 0);
            };

            wijinputcore.prototype._processClearButton = function () {
            };
            return wijinputcore;
        })(wijmo.wijmoWidget);
        input.wijinputcore = wijinputcore;
        ;

        var wijinputClass = "wijmo-wijinput", classPrefix = wijinputClass + "-";

        var wijinputcore_options = (function () {
            function wijinputcore_options() {
                this.wijCSS = {
                    wijinput: wijinputClass,
                    wijinputInput: classPrefix + "input",
                    wijinputWrapper: classPrefix + "wrapper",
                    wijinputWrapperSpinnerLeft: classPrefix + "wrapper-spinner-left",
                    wijinputWrapperSpinnerRight: classPrefix + "wrapper-spinner-right",
                    wijinputTrigger: classPrefix + "trigger",
                    wijinputSpinnerLeft: classPrefix + "spinner-left",
                    wijinputSpinnerRight: classPrefix + "spinner-right",
                    wijinputButton: classPrefix + "button",
                    wijinputSpin: classPrefix + "spin",
                    wijinputSpinUp: classPrefix + "spinup",
                    wijinputSpinDown: classPrefix + "spindown",
                    glyphIcon: "glyphicon",
                    glyphIconPlus: "glyphicon-plus",
                    glyphIconMinus: "glyphicon-minus",
                    iconPlus: "ui-icon-plus",
                    iconMinus: "ui-icon-minus"
                };
                /** Determines the input method setting of widget.
                * Possible values are: 'auto', 'active', 'inactive', 'disabled'
                * @remarks
                * This property only take effect on IE and firefox browser.
                */
                this.imeMode = "";
                /** Determines the culture used to show values in the wijinput widget.
                */
                this.culture = '';
                /** Assigns the string value of the culture calendar that appears on the calendar.
                *   This option must work with culture option.
                */
                this.cultureCalendar = '';
                /** The CSS class applied to the widget when an invalid value is entered.
                * @remarks
                * For some property of the css, such as the color, because wijmo has set default style,
                * and it may be has a higher priority, so custom need to user a higher priority than the defualt.
                * @example
                * // This example sets the invalidClass option to "invalid".
                * .wijmo-wijinput.invalid {
                * color: red !important;
                * background-color: green !important;
                * font-size: xx-large;
                * }
                * $(".selector").wijinputcore("option", "invalidClass" "invalid");
                */
                this.invalidClass = $.wijmo.wijCSS.stateError;
                /** Determines the text displayed when the widget is blank and contains no initial text.
                * Obsoleted, use placeholder instead.
                * @ignore
                */
                this.nullText = undefined;
                /** Determines the text displayed when the widget is blank and contains no initial text.
                * @remarks
                * when the option's value is empty, the empty value will display, when the value is null, then the placeholder will not show.
                */
                this.placeholder = undefined;
                /** Shows the nullText value if the widget is blank and loses focus.
                * Obsoleted, when placeholder proerty has value, it will show the placeholder value, else not.
                * @ignore
                */
                this.showNullText = false;
                /** If true, then the browser response is disabled when the ENTER key is pressed.
                */
                this.hideEnter = false;
                /** Determines whether a user can enter a value in the wijinputdate widget.
                * Obsoleted, use readonly instead.
                * @ignore
                */
                this.disableUserInput = false;
                /** Determines whether a user can enter a value in the wijinput widget.
                * If readonly is true, user can't input value to the wijinput widget by ui operation, such as spin, pick value from pickers.
                */
                this.readonly = false;
                /** Determines the side, left or right, where the trigger or spinner buttons appear.
                * Possible values are: 'left', 'right'
                * Obsoleted, Use dropdownButtonAlign instead.
                * @ignore
                */
                this.buttonAlign = null;
                /** Determines the side, left or right, where the dropdown button appear.
                * Possible values are: 'left', 'right'
                */
                this.dropDownButtonAlign = 'right';
                /** Determines whether dropdown button is displayed.
                */
                this.showDropDownButton = false;
                /** Determines whether trigger button is displayed.
                * Obsoleted, use showDropDownButton instead.
                * @ignore
                */
                this.showTrigger = undefined;
                /** Determines whether spinner button is displayed.
                */
                this.showSpinner = false;
                /** Array of data items used to populate the drop-down list.
                * Obsoleted, use picker.list instead.
                * @ignore
                */
                this.comboItems = undefined;
                /** Determines the width of the drop-down list.
                * Obsoleted, use picker.width instead.
                * @ignore
                */
                this.comboWidth = undefined;
                /** Determines the height of the drop-down list.
                * Obsoleted, use picker.height instead.
                * @ignore
                */
                this.comboHeight = undefined;
                /** Determines whether the focus automatically moves to the next or previous
                * tab ordering control when pressing the left, right arrow keys.
                * Possible values are "none", "left", "right", "both".
                * The default value is "none".
                */
                this.blurOnLeftRightKey = "none";
                /** Determines the side, left or right, where the spinner button appear.
                * Possible values are: 'vertialLeft', 'verticalRight', 'horizontalDownLeft', 'horizontalUpLeft'.
                * The default value is 'verticalRight'.
                */
                this.spinnerAlign = "verticalRight";
                /** Determines whether the spin behavior can wrap when reaching a maximum or minimum limit.
                */
                this.allowSpinLoop = false;
                /** An object contains the settings for the dropdown list.
                * @example
                *  $(".selector").wijinputmask({
                *      pickers: {
                *          list: [
                *              { label: 'item1', value: 1 },
                *              { label: 'item2', value: 2 }
                *          ],
                *          width: 100,
                *          height: 130
                *      }
                *  });
                */
                this.pickers = {
                    list: undefined,
                    width: undefined,
                    height: undefined
                };
                /** The dropdownOpen event handler.
                * A function called before the widget's dropdown opened.
                * @event
                */
                this.dropDownOpen = null;
                /** The dropdownClose event handler.
                * A function called before the widget's dropdown closed.
                * @event
                */
                this.dropDownClose = null;
                /** The initializing event handler.
                * A function called before the widget is initialized.
                * @event
                */
                this.initializing = null;
                /** The initialized event handler.
                * A function called after the widget is initialized.
                * @event
                */
                this.initialized = null;
                /** The triggerMouseDown event handler. A function called
                * when the mouse is pressed down on the trigger button.
                * Obsoleted, use dropDownButtonMouseDown instead.
                * @ignore
                * @event
                */
                this.triggerMouseDown = null;
                /** The triggerMouseUp event handler. A function called
                * when the mouse is released on the trigger button.
                * Obsoleted, use dropDownButtonMouseUp instead.
                * @ignore
                * @event
                */
                this.triggerMouseUp = null;
                /** The dropdownButtonMouseDown event handler. A function called
                * when the mouse is pressed down on the dropdown button.
                * @event
                */
                this.dropDownButtonMouseDown = null;
                /** The dropdownButtonMouseUp event handler. A function called
                * when the mouse is released on the dropdown button.
                * @event
                */
                this.dropDownButtonMouseUp = null;
                /** Fired when the widget text is changed.
                * @event
                * @dataKey {String} text The new text.
                */
                this.textChanged = null;
                /** The invalidInput event handler. A function called
                * when invalid charactor is typed.
                * @event
                * @dataKey {String} char The newly input character.
                * @dataKey widget The widget object itself.
                */
                this.invalidInput = null;
                /** Fired when the widget lost focus and caused by the keyboard behavior.
                * @event
                */
                this.keyExit = null;
            }
            return wijinputcore_options;
        })();
        wijinputcore.prototype.options = $.extend(true, {}, wijmo.wijmoWidget.prototype.options, new wijinputcore_options());

        (function (MouseButton) {
            MouseButton[MouseButton["Default"] = -1] = "Default";
            MouseButton[MouseButton["Left"] = 0] = "Left";
            MouseButton[MouseButton["Middle"] = 1] = "Middle";
            MouseButton[MouseButton["Right"] = 2] = "Right";
        })(input.MouseButton || (input.MouseButton = {}));
        var MouseButton = input.MouseButton;
        ;

        /** @ignore */
        var CoreUtility = (function () {
            function CoreUtility() {
            }
            CoreUtility.GetBrowserType = function () {
                var ua = navigator.userAgent.toLowerCase();
                if (ua.indexOf("msie") != -1)
                    CoreUtility.ie = ua.match(/msie ([\d.]+)/)[1];
                else if (ua.indexOf("chrome") != -1) {
                    CoreUtility.chrome = ua.match(/chrome\/([\d.]+)/)[1];
                } else if (ua.indexOf("safari") != -1) {
                    var version = ua.match(/version\/([\d.]+)/);
                    if (version) {
                        CoreUtility.safari = version[1];
                    }
                } else if (ua.indexOf("firefox") != -1) {
                    CoreUtility.firefox = ua.match(/firefox\/([\d.]+)/)[1];
                } else if (ua.indexOf("opera") != -1) {
                    CoreUtility.opera = ua.match(/opera.([\d.]+)/)[1];
                }

                if (ua.indexOf("ipad") != -1) {
                    CoreUtility.IPad = true;
                }

                // add by Sean Huang at 2008.11.13, for bug 10445 -->
                CoreUtility.engine = null;
                if (window.navigator.appName == "Microsoft Internet Explorer") {
                    // This is an IE browser. What mode is the engine in?
                    if (document.documentMode)
                        CoreUtility.engine = document.documentMode;
                    else {
                        CoreUtility.engine = 5; // Assume quirks mode unless proven otherwise
                        if (document.compatMode) {
                            if (document.compatMode == "CSS1Compat")
                                CoreUtility.engine = 7; // standards mode
                        }
                        if (CoreUtility.ie && CoreUtility.ie.indexOf("6") == 0) {
                            CoreUtility.engine = 6;
                        }
                    }
                    // the engine variable now contains the document compatibility mode.
                }

                if (ua.indexOf("rv:") !== -1 && ua.indexOf("firefox") === -1) {
                    // Support IE 11.
                    CoreUtility.ie = CoreUtility.engine = ua.match(/rv:([\d.]+)/)[1];
                }
            };

            CoreUtility.IsMouseDownOnClearButton = function (evt) {
                if (!CoreUtility.IsIE10OrLater()) {
                    return false;
                }

                for (var i = 0; i < document.styleSheets.length; i++) {
                    var styleSheets = document.styleSheets[i];
                    for (var j = 0; j < styleSheets.cssRules.length; j++) {
                        if (styleSheets.cssRules[j].selectorText == "::-ms-clear") {
                            if (styleSheets.cssRules[j].style.display == "none") {
                                return false;
                            }
                        }
                    }
                }

                var x = evt.offsetX;
                var y = evt.offsetY;
                var textbox = evt.srcElement || evt.target;
                var width = textbox.clientWidth;
                var height = textbox.clientHeight;
                var paddingLeft = parseInt(textbox.currentStyle.paddingLeft);
                var paddingRight = parseInt(textbox.currentStyle.paddingRight);
                if (textbox.readOnly || evt.button != 0 /* Left */) {
                    return false;
                }

                // DaryLuo 2012/09/06 fix bug 576, include padding.
                if (width - height + paddingLeft + paddingRight < CoreUtility.GetClearButtonShowThreshold(textbox)) {
                    return false;
                }
                var xx = width - height;
                if (x > xx && x <= width && y >= 0 && y < height) {
                    return true;
                } else {
                    return false;
                }
            };

            CoreUtility.CompareTextWithUnifiedNewline = function (text, textToCompare) {
                return text.replace(/(\r\n|\r)/g, "\n") != textToCompare.replace(/(\r\n|\r)/g, "\n");
            };

            CoreUtility.GetClearButtonShowThreshold = function (textinput) {
                // DaryLuo 2012/11/05 fix bug 861 in IM Web 7.0.
                // Previous I return this function to the harded value 66, in fact, it is incorrect.
                // After researched it, this value should be changed with the font.
                // The changed rule is linear.
                // When the font's unit is pixel, I got the following value.
                // The x indicated font's height, use meature method to get it.
                // The y indicated the clear button's show/hidden threshold value.
                // The I use matlab to get the changed rule. input the following script into matlabe, you will get the result.
                //x=[12 17 23  29 35  40 46 52 58 63 69 75 80],
                //y= [50 75 100 125 150 175 200 225 250 275 300 325 350],
                //p=polyfit(x,y,1),
                //xx=0:.1:100,
                //plot(x,y,'o',xx,polyval(p,xx)) ,poly2sym(p,'x')
                //r = poly2sym(p,'x')
                //vpa(r,8)
                // When the font's unit is Point, I got the following value.
                //x=[8 15 23 31 38 46 54 61 69 77 84],
                //y= [33 67 100 133 167 200 233 267 300 333 367],
                //p=polyfit(x,y,1),
                //xx=0:.1:100,
                //plot(x,y,'o',xx,polyval(p,xx)) ,poly2sym(p,'x')
                //r = poly2sym(p,'x')
                //vpa(r,8)
                var height = CoreUtility.MeasureText("ABCDQ", textinput).Height;
                var result = 4.3604432 * height - 0.76207324;
                result = Math.round(result);
                return result;
            };

            CoreUtility.GetClientOS = function () {
                // Add comments by Yang at 11:04 Sep. 6th 2007
                // For Get os information in firefox is different from IE.
                //var appVersion = navigator.appVersion;
                var appVersion;
                if (!CoreUtility.IsIE()) {
                    var osVersion = navigator.userAgent;
                    var start = osVersion.indexOf("(");
                    var end = osVersion.indexOf(")");
                    appVersion = osVersion.substring(start + 1, end);
                } else {
                    appVersion = navigator.appVersion;
                }

                // End by Yang
                if (appVersion.indexOf("NT 6.0") != -1) {
                    return "vista";
                } else if (appVersion.indexOf("NT 5.2") != -1) {
                    return "win2003";
                } else if (appVersion.indexOf("NT 5.1") != -1) {
                    return "winxp";
                } else if (appVersion.indexOf("NT 5.0") != -1) {
                    return "win2000";
                } else if (appVersion.indexOf("NT 6.1") != -1) {
                    return "Win7";
                } else if (appVersion.indexOf("NT 6.2") != -1) {
                    return "Win8";
                } else if (appVersion.indexOf("NT 6.3") != -1) {
                    // Windows 8.1
                    return "Win8";
                } else if (appVersion.indexOf("Android") != -1) {
                    return "Android";
                }
                return "unknow";
            };

            CoreUtility.MeasureText = function (text, domElement) {
                if (CoreUtility.MeasureElement === undefined) {
                    var div = document.createElement("div");
                    div.style.position = "absolute";
                    div.style.border = "solid 0px";
                    div.style.left = "-100000px";
                    div.style.top = "-100000px";
                    var textNode = window.document.createTextNode("");
                    div.appendChild(textNode);
                    document.body.appendChild(div);
                    CoreUtility.MeasureElement = div;
                    CoreUtility.MeasureTextElement = textNode;
                }
                var div = CoreUtility.MeasureElement;
                var textNode = CoreUtility.MeasureTextElement;

                if (document != null) {
                    var containsElement = document.body.contains(domElement);
                    if (!containsElement) {
                        document.body.appendChild(domElement);
                    }

                    var currentStyle = domElement.currentStyle || window.getComputedStyle(domElement, null);
                    div.style.fontFamily = currentStyle.fontFamily;
                    div.style.fontSize = currentStyle.fontSize;
                    div.style.fontStyle = currentStyle.fontStyle;
                    div.style.fontWeight = currentStyle.fontWeight;

                    if (!containsElement) {
                        document.body.removeChild(domElement);
                    }
                }

                var result = null;
                if (typeof (text) == "string") {
                    textNode.nodeValue = text;
                    result = { Width: div.clientWidth, Height: div.clientHeight };
                } else {
                    result = [];
                    for (var i = 0; i < text.length; i++) {
                        textNode.nodeValue = text[i];
                        result.push({ Width: div.clientWidth, Height: div.clientHeight });
                    }
                }

                return result;
            };

            CoreUtility.SetElementFocus = function (element) {
                element.focus();
            };

            CoreUtility.GetAllElements = function () {
                if (document.body.querySelectorAll) {
                    return document.body.querySelectorAll("button, input, object, select, textarea");
                }
                if (document.body.all) {
                    return document.body.all;
                }
                return document.body.getElementsByTagName("*");
            };

            CoreUtility.GetElements = function () {
                var elements = [];
                var obj = CoreUtility.GetAllElements();
                var index = 0;
                var rfocusable = /^(?:button|input|object|select|textarea)$/i;

                for (var i = 0; i < obj.length; i++) {
                    if ((!document.body.querySelectorAll || CoreUtility.IsIE()) && !rfocusable.test(obj[i].tagName.toLowerCase())) {
                        continue;
                    }

                    var c3 = !obj[i].disabled;
                    var c4 = obj[i].style.visibility !== "hidden";
                    var c5 = obj[i].type != "hidden" && obj[i].tabIndex != -1;
                    var c6 = obj[i].tagName.toLowerCase() == "textarea" && obj[i].tabIndex != -1;
                    var c7 = c5 || c6;

                    if (c3 && c4 && c7) {
                        elements[index++] = obj[i];
                    }
                }

                for (var i = 0; i < elements.length - 1; i++) {
                    for (var j = i + 1; j < elements.length; j++) {
                        if (elements[j].tabIndex < elements[i].tabIndex) {
                            var temp = elements[i];

                            elements[i] = elements[j];
                            elements[j] = temp;
                        }
                    }
                }
                return elements;
            };

            CoreUtility.GetNextFocusableControl = function (currentElement, elements, isForward) {
                if (typeof currentElement === "string") {
                    currentElement = document.getElementById(currentElement);
                }
                var index = 0;
                for (var i = 0; i < elements.length; i++) {
                    if (currentElement === elements[i]) {
                        if (isForward) {
                            index = (i + 1) % (elements.length);
                        } else {
                            index = (i - 1 + elements.length) % (elements.length);
                        }

                        break;
                    }
                }

                return elements[index];
            };

            CoreUtility.MoveFocus = function (curID, isForward) {
                var elements = CoreUtility.GetElements();
                var nextID = CoreUtility.GetNextFocusableControl(curID, elements, isForward);

                CoreUtility.SetElementFocus(nextID);
                return nextID;
            };

            CoreUtility.IsPad = function () {
                var result = CoreUtility.IPad || CoreUtility.GetClientOS().toLowerCase() == "android";
                return result;
            };

            CoreUtility.IsIE = function () {
                return CoreUtility.ie !== undefined;
            };

            CoreUtility.IsFireFox4OrLater = function () {
                return CoreUtility.firefox != null && parseFloat(CoreUtility.firefox) >= 4.0;
            };
            CoreUtility.IsIE11OrLater = function () {
                return CoreUtility.IsIE() && CoreUtility.engine >= 11;
            };
            CoreUtility.IsIE10OrLater = function () {
                return CoreUtility.IsIE() && CoreUtility.engine >= 10;
            };
            CoreUtility.IsIE9OrLater = function () {
                return CoreUtility.IsIE() && CoreUtility.engine >= 9;
            };
            CoreUtility.IsIE8OrLater = function () {
                return CoreUtility.IsIE() && CoreUtility.engine >= 8;
            };
            CoreUtility.IsIE8OrBelow = function () {
                return CoreUtility.IsIE() && CoreUtility.engine <= 8;
            };
            CoreUtility.IsIE8 = function () {
                return CoreUtility.IsIE() && CoreUtility.engine == 8;
            };
            CoreUtility.IsIE7 = function () {
                return CoreUtility.IsIE() && CoreUtility.engine == 7;
            };
            CoreUtility.IsIE7OrLater = function () {
                return CoreUtility.IsIE() && CoreUtility.engine >= 7;
            };

            CoreUtility.IsIE9 = function () {
                return CoreUtility.IsIE() && CoreUtility.engine == 9;
            };
            return CoreUtility;
        })();
        input.CoreUtility = CoreUtility;
        CoreUtility.GetBrowserType();
    })(wijmo.input || (wijmo.input = {}));
    var input = wijmo.input;
})(wijmo || (wijmo = {}));
;
/// <reference path="../external/declarations/globalize.d.ts"/>
/// <reference path="jquery.wijmo.wijstringinfo.ts"/>
/// <reference path="../Base/jquery.wijmo.widget.ts"/>
/// <reference path="jquery.wijmo.wijcharex.ts" />
/// <reference path="jquery.wijmo.wijinputcore.ts"/>
var wijmo;
(function (wijmo) {
    (function (input) {
        

        /** @ignore */
        var Utility = (function () {
            function Utility() {
            }
            //static FireEvent(oControl, eventHandler, eArgs: any, eventName: string) {
            //    oControl.owner._trigger(eventName, null, eArgs);
            //}
            Utility.FireEvent = function (oControl, eventHandler, eArgs, eventName) {
                if (!eventHandler) {
                    return false;
                }
                try  {
                    // DaryLuo 2012/10/29 fix bug 837 in IM Web 7.0.
                    eventHandler.call(window, oControl, eArgs);
                } catch (ex) {
                    return false;
                }
                return true;
            };

            Utility.FindIMControl = function (id) {
            };

            Utility.ArrayIndexOf = function (array, obj) {
                if (array.indeOf) {
                    return array.indexOf(obj);
                } else {
                    for (var i = 0; i < array.length; i++) {
                        if (array[i] === obj) {
                            return i;
                        }
                    }
                }
                return -1;
            };

            Utility.AttachEvent = function (element, type, handler, useCapture) {
                if (element !== null && element !== undefined) {
                    if (element.addEventListener) {
                        element.addEventListener(type, handler, useCapture);
                    } else if (element.attachEvent) {
                        element.attachEvent("on" + type, handler);
                    }
                }
            };

            Utility.AttachFocusEventOfDocument = function () {
                if (input.CoreUtility.IsIE8OrBelow()) {
                    Utility.AttachEvent(document, "beforeactivate", function (evt) {
                        Utility.FocusControlUpdate(evt);
                    }, true);
                } else {
                    Utility.AttachEvent(document, "focus", function (evt) {
                        Utility.FocusControlUpdate(evt);
                    }, true);
                }
            };

            Utility.FocusControlUpdate = function (evt) {
                Utility.PreviousFocusControl = Utility.FocusControl;
                Utility.FocusControl = evt.target || evt.srcElement;
            };

            Utility.ToString = function (value, length, ch, position) {
                var val = value + "";

                //It is same as String.PadLeft(int, char) in C#.
                if (ch != null) {
                    while (val.length < length) {
                        if (position) {
                            val = val + ch;
                        } else {
                            val = ch + val;
                        }
                    }

                    return val;
                }

                while (val.length < length) {
                    val += value + "";
                }

                return val;
            };

            //Added by Jeff Wu. For CursorPosition Test
            Utility.GetSelectionEndPosition = function (obj) {
                // Add comments by Yang
                // For test firefox
                if (!input.CoreUtility.IsIE() || input.CoreUtility.IsIE11OrLater()) {
                    //Commented by Kevin, Feb 17, 2009
                    //bug#1890
                    //return obj.selectionEnd;
                    var endS = 0;
                    endS = obj.selectionEnd;
                    if (obj.value) {
                        var text = obj.value.substring(0, endS);
                        endS = text.GetLength();
                    }

                    //Commented by Kevin, Feb 18, 2009
                    //bug#1894
                    var startS = 0;
                    startS = obj.selectionStart;
                    if (obj.value) {
                        var text = obj.value.substring(0, startS);
                        startS = text.GetLength();
                    }

                    if (startS > endS) {
                        endS = startS;
                    }

                    //end by Kevin
                    return endS;
                    //end by Kevin
                }

                // End by Yang
                return Utility.GetSelectionStartPosition(obj) + document.selection.createRange().text.GetLength();
            };

            Utility.GetSelectionStartPosition = function (obj) {
                if (obj.selectionStart != null) {
                    var startS = 0;
                    startS = obj.selectionStart;
                    if (obj.value) {
                        var text = obj.value.substring(0, startS);
                        startS = text.GetLength();
                    }

                    var endS = 0;
                    endS = obj.selectionEnd;
                    if (obj.value) {
                        var text = obj.value.substring(0, endS);
                        endS = text.GetLength();
                    }

                    if (endS < startS) {
                        startS = endS;
                    }

                    return startS;
                }
                try  {
                    var rng = obj.createTextRange();
                    var sng = document.selection.createRange();
                    var length = obj.value.GetLength();
                    var start = 0;
                    var end = length;
                    var i = 0;

                    while (start < end) {
                        i = Math.floor((start + end) / 2);
                        rng = obj.createTextRange();

                        var s = i;
                        var text = obj.value.Substring(0, i);
                        while (1) {
                            var index = text.IndexOf("\r\n");
                            if (index != -1) {
                                s--;
                                text = text.Substring(index + 2, text.GetLength());
                            } else {
                                break;
                            }
                        }

                        var gap = i - s;
                        s = i - gap;

                        rng.moveStart("character", s);

                        if (rng.offsetTop > sng.offsetTop) {
                            end = i;
                        } else if (rng.offsetTop < sng.offsetTop) {
                            if (start == i) {
                                return end;
                            }
                            start = i;
                        } else if (rng.offsetLeft > sng.offsetLeft) {
                            end = i;
                        } else if (rng.offsetLeft < sng.offsetLeft) {
                            if (start == i) {
                                return end;
                            }
                            start = i;
                        } else {
                            if (obj.value.Substring(i - 1, i) == "\r") {
                                i++;
                            }
                            return i;
                        }
                    }
                    return length;
                } catch (e) {
                    return 0;
                }
            };

            Utility.GetCursorPosition = function (obj, isPropertyChange) {
                if (obj == null) {
                    return -1;
                }

                // Add comments by Yang
                // For test firefox
                if (!input.CoreUtility.IsIE() || input.CoreUtility.IsIE11OrLater()) {
                    //Commented by Kevin, Feb 17, 2009
                    //bug#1890
                    //return obj.selectionStart;
                    var startS = 0;
                    startS = obj.selectionStart;
                    if (obj.value) {
                        var text = obj.value.substring(0, startS);
                        startS = text.GetLength();
                    }

                    return startS;
                    //end by Kevin
                }

                // End by Yang
                // Frank Liu fixed bug 629 at 2013/06/20.
                var caretPos = 0;
                if (document.selection) {
                    obj.focus();
                    var sel = document.selection.createRange();
                    sel.moveStart('character', -obj.value.length);
                    caretPos = sel.text.length;
                }
                return (caretPos);
            };

            Utility.GetPasteData = function (useClipboard) {
                // Add comments by Yang
                // For test firefox
                return Utility.GetDataFromClipboard(useClipboard);
            };

            Utility.GetDataFromClipboard = function (useClipboard) {
                if (useClipboard == false) {
                    return Utility.SavedText;
                }

                if (window.clipboardData) {
                    return (window.clipboardData.getData('Text'));
                } else if (Utility.CutCopyPasteEventObject !== null) {
                    if (Utility.CutCopyPasteEventObject.clipboardData !== undefined) {
                        return Utility.CutCopyPasteEventObject.clipboardData.getData("text");
                    }
                }

                //else if (window.netscape) {
                //    try {
                //        netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');
                //        var clip = Components.classes['@mozilla.org/widget/clipboard;1'].createInstance(Components.interfaces.nsIClipboard);
                //        if (!clip) {
                //            return;
                //        }
                //        var trans = Components.classes['@mozilla.org/widget/transferable;1'].createInstance(Components.interfaces.nsITransferable);
                //        if (!trans) {
                //            return;
                //        }
                //        trans.addDataFlavor('text/unicode');
                //        clip.getData(trans, clip.kGlobalClipboard);
                //        var str = new Object();
                //        var len = new Object();
                //        try {
                //            trans.getTransferData('text/unicode', str, len);
                //        }
                //        catch (error) {
                //            return null;
                //        }
                //        if (str) {
                //            if (Components.interfaces.nsISupportsWString) {
                //                str = str.value.QueryInterface(Components.interfaces.nsISupportsWString);
                //            }
                //            else if (Components.interfaces.nsISupportsString) {
                //                str = str.value.QueryInterface(Components.interfaces.nsISupportsString);
                //            }
                //            else {
                //                str = null;
                //            }
                //        }
                //        if (str) {
                //            return (str.data.substring(0, len.value / 2));
                //        }
                //    }
                //    catch (e) {
                //        window.status = "about:config signed.applets.codebase_principal_support true";
                //    }
                //}
                return null;
            };

            Utility.ClearSelection = function (inputElement) {
                if (input.CoreUtility.IsIE() && !input.CoreUtility.IsIE11OrLater()) {
                    if (document.selection.createRange().text != "") {
                        document.selection.empty();
                    }
                } else {
                    if (Utility.GetSelectionText(inputElement) != "") {
                        inputElement.selectionStart = inputElement.value.length;
                        inputElement.selectionEnd = inputElement.selectionStart;
                    }
                }
            };

            Utility.GetSelectionText = function (obj) {
                if (obj.selectionStart != null) {
                    return obj.value.substring(obj.selectionStart, obj.selectionEnd);
                } else if (document.selection != null) {
                    return document.selection.createRange().text;
                } else if (document.activeElement !== null) {
                    var obj = document.activeElement;

                    //var start = Math.Min(document.activeElement.selectionStart,document.activeElement.selectionEnd);
                    //var end = Math.Max(document.activeElement.selectionStart,document.activeElement.selectionEnd);
                    var start = obj.selectionStart;
                    var end = obj.selectionEnd;
                    return obj.value.substring(start, end);
                }

                return "";
            };

            Utility.FireSystemEvent = function (obj, eventName) {
                if (input.CoreUtility.IsIE()) {
                    obj.fireEvent(eventName);
                } else {
                    var evt = document.createEvent('HTMLEvents');

                    //We must remove the eventName's first two characters "on". For example,
                    //we should remove the "onchange" to "change".
                    evt.initEvent(eventName.substring(2, eventName.length), true, true);
                    obj.dispatchEvent(evt);
                }
            };

            Utility.GetTextBoxScrollWidth = function (inputElement, unuse) {
                return input.CoreUtility.MeasureText(inputElement.value, inputElement).Width;
            };

            Utility.CheckInt = function (value, min, max) {
                var intValue = parseInt(value);
                if (isNaN(intValue)) {
                    throw "value is invalid";
                }
                if (intValue < min || intValue > max) {
                    throw value + " is out of range, should between " + min + " and " + max;
                }
                return intValue;
            };

            Utility.CheckFloat = function (value, min, max) {
                var intValue = parseFloat(value);
                if (isNaN(intValue)) {
                    throw "value is invalid";
                }
                if (value < min || value > max) {
                    throw value + " is out of range, should between " + min + " and " + max;
                }
                return intValue;
            };

            Utility.CheckDate = function (value, min, max) {
                if (!(value instanceof Date)) {
                    throw "Type is invalid";
                }
                if (isNaN(value)) {
                    throw "Date is a invalid date";
                }

                if (max != undefined) {
                    if (value < min || value > max) {
                        throw value + " is out of range, should between " + min + " and " + max;
                    }
                }
            };

            Utility.CheckBool = function (boolValue) {
                if (typeof (boolValue) === "string") {
                    if (boolValue.toLowerCase() === "true") {
                        return true;
                    }
                }
                return boolValue == true;
            };

            Utility.CheckFunction = function (fun) {
                if (fun === undefined || fun === null) {
                    return null;
                }

                if (typeof fun == "string") {
                    fun = Utility.Trim(fun);
                    if (fun.length == 0) {
                        return null;
                    }
                    try  {
                        eval("fun =" + fun);
                    } catch (e) {
                    }
                }

                if (typeof fun == "function") {
                    return fun;
                } else {
                    throw "The value is not a valid function";
                }
            };

            Utility.GetCheckElement = function () {
                if (Utility.CheckElement == null) {
                    var div = document.createElement("div");
                    Utility.CheckElement = div;
                    div.style.display = "none";
                }
                return Utility.CheckElement;
            };

            Utility.CheckString = function (str) {
                if (str == null) {
                    str = "";
                }
                if (str === undefined || (typeof (str) != "string" && !(str instanceof String))) {
                    throw str + " type is not a string.";
                }

                return str.toString();
            };

            Utility.GetCSSLength = function (length) {
                var intValue = parseInt(length);
                if (isNaN(intValue)) {
                    return 0;
                }
                return intValue;
            };

            Utility.CheckCSSLength = function (length) {
                length = Utility.CheckInt(length, 0, Math.pow(2, 31));

                if (parseInt(length) == length) {
                    length += "px";
                }
                Utility.GetCheckElement().style.width = "";
                Utility.GetCheckElement().style.width = length;
                return Utility.GetCheckElement().style.width;
            };

            Utility.CheckFontSizeValue = function (length) {
                if (parseInt(length) == length) {
                    length += "px";
                }
                Utility.GetCheckElement().style.fontSize = "";
                Utility.GetCheckElement().style.fontSize = length;
                return Utility.GetCheckElement().style.fontSize;
            };

            Utility.CheckColor = function (color) {
                Utility.GetCheckElement().style.backgroundColor = "";
                Utility.GetCheckElement().style.backgroundColor = color;
                return Utility.GetCheckElement().style.backgroundColor;
            };

            Utility.CheckImageUrl = function (url) {
                return Utility.CheckString(url);
            };

            Utility.GetCssImageUrl = function (url) {
                if (url.startWith("url(\"")) {
                    url = url.substring(5, url.length - 2);
                } else if (url.startWith("url(")) {
                    url = url.substring(4, url.length - 1);
                }
                return url;
            };

            Utility.CheckCssImageUrl = function (url) {
                if (url.length > 0 && !url.startWith("url(")) {
                    url = "url(" + url + ")";
                }
                Utility.GetCheckElement().style.backgroundImage = "";
                Utility.GetCheckElement().style.backgroundImage = url;
                return Utility.GetCheckElement().style.backgroundImage;
            };

            Utility.CheckEnum = function (type, value) {
                for (var item in type) {
                    if (type[item] == value || type[item] == value.toLowerCase()) {
                        return type[item];
                    }
                }
                throw "Enum value is invalid";
            };

            Utility.CheckChar = function (value) {
                value = Utility.CheckString(value);

                // Frank Liu fixed bug 678 at 2013/06/14.
                if (value.length !== 1) {
                    throw "Invalid value";
                    //value = value.Substring(0, 1);
                }
                return value;
            };

            Utility.GetMultipleStringEnum = function (value) {
                var valueList = value.split(" ");
                valueList.sort();
                return valueList.join(",");
            };

            Utility.CheckMultipleStringEnum = function (type, value) {
                var valueList = value.split(",");
                var result = [];
                for (var i = 0; i < valueList.length; i++) {
                    result.push(Utility.CheckEnum(type, Utility.Trim(valueList[i])));
                }
                return result.join(" ");
            };

            Utility.EncodingToHTML = function (text) {
                if (text.IndexOf("&") != -1) {
                    var tempDispText = text;
                    var tempText = "";
                    while (tempDispText.IndexOf("&") != -1) {
                        var findPosition = tempDispText.IndexOf("&");
                        tempDispText = tempDispText.replace("&", "&amp;");
                        tempText += tempDispText.Substring(0, findPosition + 5);
                        tempDispText = tempDispText.Substring(findPosition + 5, tempDispText.GetLength());
                    }
                    if (tempDispText.IndexOf("&") == -1 && tempDispText != "") {
                        tempText += tempDispText;
                    }
                    text = tempText;
                }

                while (text.IndexOf(' ') != -1) {
                    text = text.replace(" ", "&nbsp;");
                }

                while (text.IndexOf("<") != -1) {
                    text = text.replace("<", "&lt;");
                }

                while (text.IndexOf(">") != -1) {
                    text = text.replace(">", "&gt;");
                }
                return text;
            };

            Utility.DecodingFromHTML = function (text) {
                while (text.IndexOf("&nbsp;") != -1) {
                    text = text.replace("&nbsp;", " ");
                }

                while (text.IndexOf("&lt;") != -1) {
                    text = text.replace("&lt;", "<");
                }

                while (text.IndexOf("&gt;") != -1) {
                    text = text.replace("&gt;", ">");
                }

                //Modified by shenyuan at 2006-02-10 for bug #5206.
                if (text.IndexOf("&amp;") != -1) {
                    var tmpText = text;
                    var tmpResult = "";
                    while (tmpText.IndexOf("&amp;") != -1) {
                        var temPos = tmpText.IndexOf("&amp;");
                        tmpText = tmpText.replace("&amp;", "&");
                        tmpResult += tmpText.Substring(0, temPos + 1);
                        tmpText = tmpText.Substring(temPos + 1, tmpText.GetLength());
                    }
                    if (tmpText.IndexOf("&amp;") == -1 && tmpText != "") {
                        tmpResult += tmpText;
                    }
                    text = tmpResult;
                }
                return text;
            };

            Utility.IsStandCompliantModeOn = function () {
                //Commented by Kevin, Nov 11, 2008
                //fix bug#10414
                //return document.compatMode == "CSS1Compat";
                if (!input.CoreUtility.IsIE()) {
                    return document.compatMode == "CSS1Compat" || document.compatMode == "BackCompat";
                }
                return document.compatMode == "CSS1Compat";
                //end by Kevin
            };

            Utility.GetPageZoomRate = function () {
                // add by Sean Huang at 2008.11.13, for bug 10129, 10368 -->
                if (input.CoreUtility.IsIE8()) {
                    return screen.deviceXDPI / screen.logicalXDPI;
                }

                // add by Sean Huang at 2008.11.13, for bug 10129, 10368 -->
                var normalPosition = document.getElementById("gcsh_standard_control_for_get_normal_position");
                if (typeof (normalPosition) != "undefined" && normalPosition != null) {
                    return document.getElementById("gcsh_standard_control_for_get_normal_position").offsetLeft / 100;
                } else {
                    var div = document.createElement("div");
                    document.body.appendChild(div);
                    div.id = "gcsh_standard_control_for_get_normal_position";
                    div.style.visibility = "hidden";
                    div.style.left = "100px";
                    div.style.top = "1px";
                    div.style.width = "1px";
                    div.style.height = "1px";
                    div.style.position = "absolute";

                    return document.getElementById("gcsh_standard_control_for_get_normal_position").offsetLeft / 100;
                    // return 1;
                }
            };

            Utility.GetElementPosition = function (id) {
                // Frank Liu fixed bug 612 at 2013/06/09.
                // HelenLiu 2013/07/02 fix bug 742 in IM HTML5.
                if (input.CoreUtility.IsIE() || input.CoreUtility.chrome || input.CoreUtility.safari) {
                    // change by Sean Huang at 2009.04.10, for bug 2125 -->
                    //return Utility.GetElementPositionForIE(id);
                    //modified by sj for bug 12220
                    //if (Utility.engine == 8)
                    if (input.CoreUtility.IsIE8OrLater()) {
                        var pos1 = Utility.GetElementPositionForIE8(id);

                        // DaryLuo 2012.09/10 fix bug 561 in IMWeb 7.0.
                        if (pos1.Left == 0 && pos1.Top == 0) {
                            var pos2 = Utility.GetElementPositionForFireFox(id);
                            return pos2;
                        } else {
                            return pos1;
                        }
                    } else {
                        var posIE7 = Utility.GetElementPositionForIE(id);

                        //  var posIE8 = Utility.GetElementPositionForIE8(id);
                        //  var posFF = Utility.GetElementPositionForFireFox(id);
                        // DaryLuo 2012.09/10 fix bug 561 in IMWeb 7.0.
                        //  var left = Utility.ChooseMiddle(posIE7.Left, posIE8.Left, posFF.Left);
                        //  var top = Utility.ChooseMiddle(posIE7.Top, posIE8.Top, posFF.Top);
                        return { Left: posIE7.Left, Top: posIE7.Top };
                    }
                    // end of Sean Huang <--
                }

                return Utility.GetElementPositionForFireFox(id);
            };

            Utility.GetElementPositionForIE8 = function (id) {
                var element = id;
                if (typeof id == "string") {
                    element = document.getElementById(id);
                }

                var top = 0;
                var left = 0;

                if (element == null || element.self || element.nodeType === 9) {
                    return { Left: left, Top: top };
                }

                var clientRect = element.getBoundingClientRect();
                if (!clientRect) {
                    return { Left: left, Top: top };
                }
                var documentElement = element.ownerDocument.documentElement;
                left = clientRect.left + documentElement.scrollLeft;
                top = clientRect.top + documentElement.scrollTop;

                try  {
                    var f = element.ownerDocument.parentWindow.frameElement || null;
                    if (f) {
                        var offset = (f.frameBorder === "0" || f.frameBorder === "no") ? 2 : 0;
                        left += offset;
                        top += offset;
                    }
                } catch (ex) {
                }

                return { Left: left, Top: top };
            };

            Utility.GetElementPositionForIE = function (id) {
                var oElement = id;
                if (typeof id == "string") {
                    oElement = document.getElementById(id);
                }

                // For bug 3696.
                var top = 0;
                var left = 0;

                if (oElement == null) {
                    return { Left: left, Top: top };
                }

                if (oElement.offsetParent) {
                    while (oElement.offsetParent != null) {
                        var parent = oElement.offsetParent;
                        var parentTagName = parent.tagName.toLowerCase();

                        if (parentTagName != "table" && parentTagName != "body" && parentTagName != "html" && parent.clientTop && parent.clientLeft) {
                            left += parent.clientLeft;
                            top += parent.clientTop;
                        }

                        // add by Sean Huang at 2008.11.12, for bug 10064
                        // change by Sean Huang at 2008.11.13, for bug 10445 -->
                        //if (Utility.IsIE7() && parent.style.position.toLowerCase() == "relative")
                        if (input.CoreUtility.IsIE7() && parent.style.position.toLowerCase() == "relative") {
                            left += oElement.offsetLeft - oElement.scrollLeft;
                            top += oElement.offsetTop;

                            // add by Sean Huang at 2009.01.07, for bug 856 -->
                            var zoom = Utility.GetPageZoomRate();
                            if (zoom == 1) {
                                var offset = oElement.offsetTop;
                                for (var i = 0; i < parent.children.length; i++) {
                                    var o = parent.children[i];
                                    if (o == oElement) {
                                        break;
                                    } else if (o.offsetTop) {
                                        offset = o.offsetTop;
                                        break;
                                    }
                                }
                                top -= offset;
                            }
                        } else if (Utility.IsStandCompliantModeOn() && input.CoreUtility.IsIE7() && (oElement.style.position.toLowerCase() == "absolute" || oElement.style.position.toLowerCase() == "relative")) {
                            // change by Sean Huang at 2009.01.07, for bug 856 -->
                            // [original] -->
                            //  // change by Sean Huang at 2008.12.18, for bug 896 -->
                            //  //top  += (oElement.offsetTop - oElement.scrollTop) / Utility.GetPageZoomRate();
                            //  //left += (oElement.offsetLeft - oElement.scrollLeft) / Utility.GetPageZoomRate();
                            //  top  += (oElement.offsetTop - oElement.scrollTop);
                            //  left += (oElement.offsetLeft - oElement.scrollLeft);
                            //  // end of Sean Huang <--
                            // <-- [original]
                            var zoom = Utility.GetPageZoomRate();
                            top += (oElement.offsetTop - oElement.scrollTop) / zoom;
                            left += (oElement.offsetLeft - oElement.scrollLeft) / zoom;
                            // end of Sean Huang, for bug 856 <--
                        } else {
                            //Add by Jiang at Dec. 10 2008
                            //For fixed bug773
                            if ((oElement.tagName.toLowerCase() == "input" && oElement.type.toLowerCase() == "text") || oElement.tagName.toLowerCase() == "textarea") {
                                top += oElement.offsetTop;
                                left += oElement.offsetLeft;
                            } else {
                                top += oElement.offsetTop - oElement.scrollTop;
                                left += oElement.offsetLeft - oElement.scrollLeft;
                            }
                            //End by Jiang Changcheng
                        }

                        oElement = parent;
                        //end by Ryan Wu.
                    }
                } else if (oElement.left && oElement.top) {
                    left += oElement.left;
                    top += oElement.top;
                } else {
                    if (oElement.x) {
                        left += oElement.x;
                    }
                    if (oElement.y) {
                        top += oElement.y;
                    }
                }

                //Add by Ryan Wu at 11:13, Nov 2 2005. For in VS2005, body has also an offset value.
                if (oElement.style.position.toLowerCase() != "relative" && oElement.style.position.toLowerCase() != "absolute" && oElement.tagName.toLowerCase() == "body" && Utility.IsStandCompliantModeOn()) {
                    //Add comments by Ryan Wu at 9:54 Nov. 15 2006.
                    //Fix bug#6695.
                    //	    top  += oElement.offsetTop;
                    //		left += oElement.offsetLeft;
                    // change by Sean Huang at 2008.11.13, for bug 10445 -->
                    //if (!Utility.IsIE7())
                    if (!input.CoreUtility.IsIE7()) {
                        top += oElement.offsetTop;
                        left += oElement.offsetLeft;
                    } else {
                        // Add comments by Yang at 13:23 July 16th 2008
                        // For fix the bug 9755
                        //            top  += parseInt(oElement.currentStyle.marginTop);
                        //		    left += parseInt(oElement.currentStyle.marginLeft);
                        var tempTop = parseInt(oElement.currentStyle.marginTop);
                        var tempLeft = parseInt(oElement.currentStyle.marginLeft);
                        if (isNaN(tempTop)) {
                            tempTop = 0;
                        }
                        if (isNaN(tempLeft)) {
                            tempLeft = 0;
                        }
                        top += tempTop;
                        left += tempLeft;
                        // End by Yang
                    }
                    //end by Ryan Wu.
                }

                return { Left: left, Top: top };
            };

            Utility.GetElementPositionForFireFox = function (id) {
                var oElement = id;
                if (typeof id == "string") {
                    oElement = document.getElementById(id);
                }

                // For bug 3696.
                var top = 0;
                var left = 0;
                var scrollLeft = 0;
                var scrollTop = 0;

                if (oElement == null) {
                    return { Left: left, Top: top };
                }

                //Gets the offsetTop and offsetLeft.
                if (oElement.offsetParent) {
                    while (oElement.offsetParent != null) {
                        var parentTagName = oElement.offsetParent.tagName.toLowerCase();

                        if (parentTagName != "table" && parentTagName != "body" && parentTagName != "html" && parentTagName != "div" && oElement.offsetParent.clientTop && oElement.offsetParent.clientLeft) {
                            left += oElement.offsetParent.clientLeft;
                            top += oElement.offsetParent.clientTop;
                        }

                        top += oElement.offsetTop;
                        left += oElement.offsetLeft;

                        oElement = oElement.offsetParent;
                    }
                } else if (oElement.left && oElement.top) {
                    left += oElement.left;
                    top += oElement.top;
                } else {
                    if (oElement.x) {
                        left += oElement.x;
                    }
                    if (oElement.y) {
                        top += oElement.y;
                    }
                }

                //Gets the scrollTop and scrollLeft.
                oElement = id;
                if (typeof id === "string") {
                    oElement = document.getElementById(id);
                }

                if (oElement.parentElement) {
                    while (oElement.parentElement != null && oElement.tagName.toLowerCase() != "html") {
                        scrollTop += oElement.scrollTop;
                        scrollLeft += oElement.scrollLeft;

                        oElement = oElement.parentElement;
                    }
                }

                top -= scrollTop;
                left -= scrollLeft;

                //Add by Ryan Wu at 11:13, Nov 2 2005. For in VS2005, body has also an offset value.
                if (oElement.style.position.toLowerCase() != "relative" && oElement.style.position.toLowerCase() != "absolute" && oElement.tagName.toLowerCase() == "body" && Utility.IsStandCompliantModeOn()) {
                    top += oElement.offsetTop;
                    left += oElement.offsetLeft;
                }

                return { Left: left, Top: top };
            };

            Utility.GetOSDefaultFontFamily = function () {
                switch (input.CoreUtility.GetClientOS().toLowerCase()) {
                    case "winxp":
                        return "MS UI Gothic";
                    case "vista":
                        return "�ᥤ�ꥪ";
                    case "win7":
                        return "�ᥤ�ꥪ";
                    case "win8":
                        return "Meiryo UI";
                    case "win2003":
                        return "MS UI Gothic";
                    case "win2000":
                        return "MS UI Gothic";
                }
                return "MS UI Gothic";
            };

            Utility.IsTouchSupport = function () {
                return window.navigator.userAgent.toLowerCase().indexOf("touch") != -1;
            };

            Utility.DisabledHoldVisual = function (element) {
                if (element !== null && element !== undefined && Utility.IsTouchSupport() && input.CoreUtility.IsIE10OrLater()) {
                    element.addEventListener("MSHoldVisual", function (e) {
                        e.preventDefault();
                    }, false);
                    element.addEventListener("MSGestureHold", function (e) {
                        e.preventDefault();
                    }, false);

                    // Disables visual
                    element.addEventListener("contextmenu", function (e) {
                        e.preventDefault();
                    }, false);
                }
            };

            Utility.IsFocusFromIMControl = function (id, evt) {
                try  {
                    //return event.fromElement.className.IndexOf(Utility.DefaultControlStyle) != -1;
                    var src = evt.fromElement;
                    while (src != null) {
                        // change by Sean Huang at 2008.08.14, for bug 614 and 644 (ttp)-->
                        //if (src.id.Substring(0, id.length) == id)
                        //modified by sj for bug 2149
                        //if (src.id == id ||  src.id == id + this.Hold + "_DropDownObj" || src.id == id + "DropDown_Container" || src.id == id+ "_ContextMenu")
                        if (src.id == id || src.id == id + this.Hold + "_DropDownObj" || src.id == id + "_DropDown_Container" || src.id == id + "_ContextMenu" || src.id == id + "_HistoryList" || src.id == id + "_EditField" || src.id == id + "_BorderContainer" || src.id == id + "_DropDown_EditField") {
                            return true;
                        }

                        //Add comments by Ryan Wu at 11:28 Mar. 15 2007.
                        //For test FireFox.
                        //src = src.parentElement;
                        src = src.parentNode;
                        //end by Ryan Wu.
                    }
                    return false;
                } catch (e) {
                    return false;
                }
            };

            Utility.IsFocusToIMControl = function (id, evt) {
                try  {
                    //	return event.toElement.className.IndexOf(Utility.DefaultControlStyle) != -1;
                    var src = evt.toElement;

                    while (src != null) {
                        //Add comments by Ryan Wu at 17:13 Aug. 22 2007.
                        //For fix the bug8990.
                        //if (src.id && src.id.substring(0, id.length) == id)
                        //add by chris for 12215 (bugzilla) 2010/12/17 16:30
                        //			// change by Sean Huang at 2008.08.14, for bug 614 and 644 (ttp)-->
                        //			//if (src.id && src.id == id)
                        //			//modified by sj for bug 2149
                        //			//if (src.id == id || src.id == id + this.Hold + "_DropDownObj" || src.id == id + "DropDown_Container" || src.id == id+ "_ContextMenu")
                        //			if (src.id == id || src.id == id + this.Hold + "_DropDownObj" || src.id == id + "DropDown_Container" || src.id == id + "_ContextMenu" || src.id == id + "_HistoryList")
                        //			//end by sj
                        //			// end of Sean Huang <--
                        if (src.id == id || src.id == id + this.Hold + "_DropDownObj" || src.id == id + "_DropDown_Container" || src.id == id + "_ContextMenu" || src.id == id + "_HistoryList" || src.id == id + this.Hold + "_DropDownObj_PopupMonth" || src.id == id + "_EditField" || src.id == id + "_BorderContainer" || src.id == id + "_DropDown_EditField") {
                            return true;
                        }

                        //end by Ryan Wu.
                        //Add comments by Ryan Wu at 11:28 Mar. 15 2007.
                        //For test FireFox.
                        //src = src.parentElement;
                        src = src.parentNode;
                        //end by Ryan Wu.
                    }
                    return false;
                } catch (e) {
                    return false;
                }
            };

            Utility.Trim = function (value) {
                if (value == "") {
                    return "";
                }

                var beginIndex = 0;
                var endIndex = 0;
                for (var i = 0; i < value.length; i++) {
                    if (value.CharAt(i) != " " && value.CharAt(i) != "��") {
                        beginIndex = i;
                        break;
                    }
                }

                for (var i = value.length - 1; i >= 0; i--) {
                    if (value.CharAt(i) != " " && value.CharAt(i) != "��") {
                        endIndex = i + 1;
                        break;
                    }
                }

                try  {
                    var s = value.Substring(beginIndex, endIndex);
                    return s;
                } catch (e) {
                    return value;
                }
            };

            Utility.GetTouchPath = function (beginY, endY) {
                if (beginY === -1 || endY === -1) {
                    return "Error";
                }

                if (beginY > endY) {
                    return beginY - endY > 20 ? "ToTop" : "NotMove";
                } else if (beginY < endY) {
                    return endY - beginY > 20 ? "ToBottom" : "NotMove";
                }

                return "NotMove";
            };

            Utility.IsJapan = function () {
                if (navigator.userLanguage) {
                    return navigator.userLanguage.indexOf('ja') != -1;
                } else if (navigator["language"]) {
                    return navigator["language"].indexOf('ja') != -1;
                }

                return false;
            };

            Utility.CreateStyleElement = function (id) {
                var style = document.createElement("style");
                style.id = id;

                //add commnets by Jason.Zhou at 14:23 November 26 2007
                //for style.type="text/css" is used in css file used by linking file type, this sytle is only in dom tree.
                style.type = "text/css";

                //end by Jason.Zhou
                return style;
            };

            Utility.CreateClassStyle = function (className) {
                return Utility.CreateSelectorStyle("." + className);
            };

            Utility.CreateSelectorStyle = function (selectorName) {
                var tableStyle = document.getElementById("tableStyle");
                if (tableStyle == null) {
                    //tableStyle = GrapeCity.IM.Utility.CreateStyleElement("tableStyle");
                    tableStyle = this.CreateStyleElement("tableStyle");
                    document.body.appendChild(tableStyle);
                }

                var sheet = tableStyle.sheet || tableStyle.styleSheet;
                var rules = sheet.cssRules || sheet.rules;
                if (sheet.insertRule) {
                    sheet.insertRule(selectorName + "{ }", rules.length);
                } else {
                    sheet.addRule(selectorName, "{ }", rules.length);
                }

                return rules.item(rules.length - 1);
            };

            Utility.SetSelection = function (element, start, end, multiLine) {
                $(element).wijtextselection(Math.min(start, end), Math.max(start, end));
            };

            Utility.PreventDefault = function (evt) {
                if (evt.preventDefault) {
                    evt.preventDefault();
                } else {
                    evt.returnValue = false;
                }
            };

            Utility.CancelBubble = function (evt) {
                if (evt.cancelBubble !== undefined) {
                    evt.cancelBubble = true;
                } else {
                    evt.stopPropagation();
                }
            };

            Utility.DragDrop = function (obj) {
                try  {
                    obj.dragDrop(true);
                } catch (e) {
                }
            };

            Utility.GetMouseButton = function (evt) {
                var mouseButton = -1 /* Default */;
                var leftKey = input.CoreUtility.IsIE8OrBelow() ? 1 : 0;
                if (evt.button == leftKey) {
                    mouseButton = 0 /* Left */;
                } else if (evt.button == 1) {
                    mouseButton = 1 /* Middle */;
                } else if (evt.button == 2) {
                    mouseButton = 2 /* Right */;
                }
                return mouseButton;
            };

            /**
            * Gets the value after mouse wheel.
            * @param value - the initial value before mousewheel.
            * @returns Returns the value after mouse wheel.
            */
            Utility.GetMouseWheelValue = function (value, evt) {
                //Add comments by Ryan Wu at 9:50 Aug. 13 2007.
                //For Firefox doesn't support the event.wheelDelta to get the mouse wheel value.
                //I don't know why the event.detail is also 3 or -3, so we must divide 3.
                if (input.CoreUtility.IsFireFox4OrLater()) {
                    return -evt.detail / 3;
                }

                //end by Ryan Wu.
                if (evt.wheelDelta >= 120) {
                    value++;
                } else if (evt.wheelDelta <= -120) {
                    value--;
                }

                return value;
            };
            Utility.SetCopy = function (text, useClipboard) {
                // Add comments by Yang
                // For test firefox
                var selText;
                try  {
                    // add by Sean Huang at 2009.04.29, for bug 2209 -->
                    if (text == null || text == "") {
                        if (document.selection) {
                            selText = document.selection.createRange().text;
                        }
                        if (selText == "") {
                            return;
                        }
                    }
                } catch (e) {
                }
                ;

                if (text != null) {
                    selText = text;
                }

                Utility.CopyDataToClipBoard(selText, useClipboard);
            };

            Utility.CopyDataToClipBoard = function (copytext, useClipboard) {
                if (useClipboard == false) {
                    Utility.SavedText = copytext;
                    return;
                }

                if (window.clipboardData) {
                    // change by Sean Huang at 2009.01.13, for bug 1582 -->
                    //window.clipboardData.setData("Text", copytext);
                    // change by Sean Huang at 2009.02.19, for bug 1903 -->
                    //setTimeout('window.clipboardData.setData("Text", "' + copytext + '");', 0);
                    // change by Sean Huang at 2009.05.26, for sometimes throw exception in auto test ==-->
                    //setTimeout(function () {window.clipboardData.setData("Text", copytext);}, 0);
                    setTimeout(function () {
                        try  {
                            window.clipboardData.setData("Text", copytext);
                        } catch (ex) {
                        }
                    }, 0);
                    // end of Sean Huang, for auto test <--==
                    // end of Sean Huang <--
                    // end of Sean Huang <--
                } else if (Utility.CutCopyPasteEventObject !== null) {
                    if (Utility.CutCopyPasteEventObject.clipboardData !== undefined) {
                        Utility.CutCopyPasteEventObject.clipboardData.setData("text", copytext);
                    }
                }
                //else if (window.netscape) {
                //    try {
                //        netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');
                //        var clip = Components.classes['@mozilla.org/widget/clipboard;1'].createInstance(Components.interfaces.nsIClipboard);
                //        if (!clip) {
                //            return;
                //        }
                //        var trans = Components.classes['@mozilla.org/widget/transferable;1'].createInstance(Components.interfaces.nsITransferable);
                //        if (!trans) {
                //            return;
                //        }
                //        trans.addDataFlavor('text/unicode');
                //        var str = new Object();
                //        var len = new Object();
                //        var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
                //        str.data = copytext;
                //        trans.setTransferData("text/unicode", str, copytext.length * 2);
                //        var clipid = Components.interfaces.nsIClipboard;
                //        if (!clip) {
                //            return false;
                //        }
                //        clip.setData(trans, null, clipid.kGlobalClipboard);
                //    } catch (e) {
                //    }
                //}
            };

            Utility.SetZoomStyle = function (element, value, align) {
                if (element === undefined || element === null) {
                    return;
                }

                var zoomOrigin = "top left";
                if (align === 2 /* Right */) {
                    zoomOrigin = "top right";
                }
                if (input.CoreUtility.firefox) {
                    element.style.MozTransformOrigin = value === "" ? "" : zoomOrigin;
                    element.style.MozTransform = value === "" ? "" : "scale(" + value + ")";
                    element.setAttribute("ZoomValue", value);
                } else {
                    if (input.CoreUtility.chrome || input.CoreUtility.safari) {
                        if (value !== "") {
                            element.style.MozTransform = "scale(" + value + ")";
                            element.style.WebkitTransform = "scale(" + value + ")";
                            element.style.webkitTransformOrigin = zoomOrigin;
                        } else {
                            element.style.MozTransform = "";
                            element.style.WebkitTransform = "";
                            element.style.WebkitTransformOrigin = "";
                        }
                    } else if (input.CoreUtility.IsIE9OrLater()) {
                        if (value !== "") {
                            element.style.msTransform = "scale(" + value + ")";
                            element.style.msTransformOrigin = zoomOrigin;
                        } else {
                            element.style.msTransform = "";
                            element.style.msTransformOrigin = "";
                        }
                    } else {
                        element.style.zoom = value;
                    }
                }
            };

            Utility.FilterText = function (includeText, intext) {
                if (intext.GetLength() == 0)
                    return "";
                var filterText = "";
                var j = 0;
                var i = 0;
                for (j = 0; j < intext.GetLength(); j++) {
                    var valid = false;
                    for (i = 0; i < includeText.GetLength(); i++) {
                        if (intext.Substring(j, j + 1) == includeText.Substring(i, i + 1))
                            valid = true;
                    }
                    if (valid == true)
                        filterText += intext.Substring(j, j + 1);
                }
                return filterText;
            };

            Utility.IndexOfAny = function (str, anyOf, startIndex) {
                if (startIndex >= str.length) {
                    return -1;
                }
                for (var i = startIndex; i < str.length; i++) {
                    for (var j = 0; j < anyOf.length; j++) {
                        if (str.charAt(i) == anyOf[j]) {
                            return i;
                        }
                    }
                }
                return -1;
            };
            Utility.IdCounter = 0;
            Utility.EditFieldSuffix = "_EidtField";

            Utility.MaskValChar = "\ufeff";
            Utility.Hold = "g-C2";
            return Utility;
        })();
        input.Utility = Utility;

        (function (FocusType) {
            FocusType[FocusType["None"] = 0] = "None";
            FocusType[FocusType["Click"] = 1] = "Click";
            FocusType[FocusType["ContextMenu"] = 2] = "ContextMenu";
            FocusType[FocusType["ClientEvent"] = 3] = "ClientEvent";
            FocusType[FocusType["KeyExit"] = 4] = "KeyExit";
            FocusType[FocusType["Default"] = 5] = "Default";
            FocusType[FocusType["SpinButton"] = 6] = "SpinButton";
            FocusType[FocusType["DropDown"] = 7] = "DropDown";
            FocusType[FocusType["ImeInput"] = 8] = "ImeInput";
            FocusType[FocusType["Left"] = 9] = "Left";
            FocusType[FocusType["Right"] = 10] = "Right";
            FocusType[FocusType["DragDrop"] = 11] = "DragDrop";
        })(input.FocusType || (input.FocusType = {}));
        var FocusType = input.FocusType;
        ;

        /** @ignore */
        (function (DateCursorPosition) {
            DateCursorPosition[DateCursorPosition["Default"] = 0] = "Default";
            DateCursorPosition[DateCursorPosition["Era"] = 1] = "Era";
            DateCursorPosition[DateCursorPosition["Year"] = 2] = "Year";
            DateCursorPosition[DateCursorPosition["Month"] = 3] = "Month";
            DateCursorPosition[DateCursorPosition["Day"] = 4] = "Day";
            DateCursorPosition[DateCursorPosition["AMPM"] = 5] = "AMPM";
            DateCursorPosition[DateCursorPosition["Hour"] = 6] = "Hour";
            DateCursorPosition[DateCursorPosition["Minute"] = 7] = "Minute";
            DateCursorPosition[DateCursorPosition["Second"] = 8] = "Second";
        })(input.DateCursorPosition || (input.DateCursorPosition = {}));
        var DateCursorPosition = input.DateCursorPosition;
        ;

        /**
        * Defines the CrLf mode which describes how to process the CrLf char.
        * @type {{NoControl: string, Filter: string, Cut: string}}
        */
        (function (CrLfMode) {
            /**
            * Accepts all CrLf characters in copied, cut, or pasted strings.
            */
            CrLfMode[CrLfMode["NoControl"] = 0] = "NoControl";

            /**
            * Removes all CrLf characters in copied, cut, or pasted strings.
            */
            CrLfMode[CrLfMode["Filter"] = 1] = "Filter";

            /**
            * Cuts the following strings from the first CrLf character in copied, cut, and pasted strings.
            */
            CrLfMode[CrLfMode["Cut"] = 2] = "Cut";
        })(input.CrLfMode || (input.CrLfMode = {}));
        var CrLfMode = input.CrLfMode;
        ;

        /**
        * Specifies how the literal in content is held in the clipboard.
        * @type {{IncludeLiterals: string, ExcludeLiterals: string}}
        */
        (function (ClipContent) {
            /**
            * Literals are included.
            */
            ClipContent[ClipContent["IncludeLiterals"] = 0] = "IncludeLiterals";

            /**
            * Literals are excluded.
            */
            ClipContent[ClipContent["ExcludeLiterals"] = 1] = "ExcludeLiterals";
        })(input.ClipContent || (input.ClipContent = {}));
        var ClipContent = input.ClipContent;
        ;

        (function (EditMode) {
            EditMode[EditMode["Insert"] = 0] = "Insert";
            EditMode[EditMode["Overwrite"] = 1] = "Overwrite";
            EditMode[EditMode["FixedInsert"] = 2] = "FixedInsert";
            EditMode[EditMode["FixedOverwrite"] = 3] = "FixedOverwrite";
        })(input.EditMode || (input.EditMode = {}));
        var EditMode = input.EditMode;
        ;

        (function (ShowLiterals) {
            ShowLiterals[ShowLiterals["Always"] = 1] = "Always";
            ShowLiterals[ShowLiterals["PostDisplay"] = 2] = "PostDisplay";
            ShowLiterals[ShowLiterals["PreDisplay"] = 3] = "PreDisplay";
        })(input.ShowLiterals || (input.ShowLiterals = {}));
        var ShowLiterals = input.ShowLiterals;
        ;

        (function (ExitOnLeftRightKey) {
            ExitOnLeftRightKey[ExitOnLeftRightKey["None"] = 0] = "None";
            ExitOnLeftRightKey[ExitOnLeftRightKey["Left"] = 1] = "Left";
            ExitOnLeftRightKey[ExitOnLeftRightKey["Right"] = 2] = "Right";
            ExitOnLeftRightKey[ExitOnLeftRightKey["Both"] = 3] = "Both";
        })(input.ExitOnLeftRightKey || (input.ExitOnLeftRightKey = {}));
        var ExitOnLeftRightKey = input.ExitOnLeftRightKey;
        ;

        /**
        * Specifies the type of selection text in control.
        * @type {{None: string, Field: string, All: string}}
        */
        (function (HighlightText) {
            /**
            * No selection specified.
            */
            HighlightText[HighlightText["None"] = 0] = "None";

            /**
            * Select the specified field.
            */
            HighlightText[HighlightText["Field"] = 1] = "Field";

            /**
            * Select all the text.
            */
            HighlightText[HighlightText["All"] = 2] = "All";
        })(input.HighlightText || (input.HighlightText = {}));
        var HighlightText = input.HighlightText;
        ;

        (function (DropDownAlign) {
            DropDownAlign[DropDownAlign["Left"] = 1] = "Left";
            DropDownAlign[DropDownAlign["Right"] = 2] = "Right";
        })(input.DropDownAlign || (input.DropDownAlign = {}));
        var DropDownAlign = input.DropDownAlign;

        (function (ScrollBarMode) {
            ScrollBarMode[ScrollBarMode["Automatic"] = 0] = "Automatic";
            ScrollBarMode[ScrollBarMode["Fixed"] = 1] = "Fixed";
        })(input.ScrollBarMode || (input.ScrollBarMode = {}));
        var ScrollBarMode = input.ScrollBarMode;

        (function (ScrollBars) {
            ScrollBars[ScrollBars["None"] = 0] = "None";
            ScrollBars[ScrollBars["Horizontal"] = 1] = "Horizontal";
            ScrollBars[ScrollBars["Vertical"] = 2] = "Vertical";
            ScrollBars[ScrollBars["Both"] = 3] = "Both";
        })(input.ScrollBars || (input.ScrollBars = {}));
        var ScrollBars = input.ScrollBars;

        (function (ControlStatus) {
            ControlStatus[ControlStatus["Normal"] = 0] = "Normal";
            ControlStatus[ControlStatus["Hover"] = 1] = "Hover";
            ControlStatus[ControlStatus["Pressed"] = 2] = "Pressed";
            ControlStatus[ControlStatus["Focused"] = 4] = "Focused";
            ControlStatus[ControlStatus["Disabled"] = 8] = "Disabled";
        })(input.ControlStatus || (input.ControlStatus = {}));
        var ControlStatus = input.ControlStatus;

        (function (ExitKeys) {
            ExitKeys[ExitKeys["Tab"] = 1] = "Tab";
            ExitKeys[ExitKeys["ShiftTab"] = 2] = "ShiftTab";
            ExitKeys[ExitKeys["NextControl"] = 3] = "NextControl";
            ExitKeys[ExitKeys["PreviousControl"] = 4] = "PreviousControl";
            ExitKeys[ExitKeys["Right"] = 5] = "Right";
            ExitKeys[ExitKeys["Left"] = 6] = "Left";
            ExitKeys[ExitKeys["CtrlRight"] = 7] = "CtrlRight";
            ExitKeys[ExitKeys["CtrlLeft"] = 8] = "CtrlLeft";
            ExitKeys[ExitKeys["CharInput"] = 9] = "CharInput";
        })(input.ExitKeys || (input.ExitKeys = {}));
        var ExitKeys = input.ExitKeys;
        ;

        (function (TabAction) {
            TabAction[TabAction["Control"] = 0] = "Control";
            TabAction[TabAction["Field"] = 1] = "Field";
        })(input.TabAction || (input.TabAction = {}));
        var TabAction = input.TabAction;
        ;

        (function (Key) {
            Key[Key["BackSpace"] = 8] = "BackSpace";
            Key[Key["Tab"] = 9] = "Tab";
            Key[Key["Clear"] = 12] = "Clear";
            Key[Key["Enter"] = 13] = "Enter";
            Key[Key["Shift"] = 16] = "Shift";
            Key[Key["Control"] = 17] = "Control";
            Key[Key["Alt"] = 18] = "Alt";
            Key[Key["Pause"] = 19] = "Pause";
            Key[Key["Caps_Lock"] = 20] = "Caps_Lock";
            Key[Key["Escape"] = 27] = "Escape";
            Key[Key["Space"] = 32] = "Space";
            Key[Key["PageUp"] = 33] = "PageUp";
            Key[Key["PageDown"] = 34] = "PageDown";
            Key[Key["End"] = 35] = "End";
            Key[Key["Home"] = 36] = "Home";
            Key[Key["Left"] = 37] = "Left";
            Key[Key["Up"] = 38] = "Up";
            Key[Key["Right"] = 39] = "Right";
            Key[Key["Down"] = 40] = "Down";
            Key[Key["Select"] = 41] = "Select";
            Key[Key["Print"] = 42] = "Print";
            Key[Key["Execute"] = 43] = "Execute";
            Key[Key["Insert"] = 45] = "Insert";
            Key[Key["Delete"] = 46] = "Delete";
            Key[Key["Help"] = 47] = "Help";
            Key[Key["equalbraceright"] = 48] = "equalbraceright";
            Key[Key["exclamonesuperior"] = 49] = "exclamonesuperior";
            Key[Key["quotedbltwosuperior"] = 50] = "quotedbltwosuperior";
            Key[Key["sectionthreesuperior"] = 51] = "sectionthreesuperior";
            Key[Key["dollar"] = 52] = "dollar";
            Key[Key["percent"] = 53] = "percent";
            Key[Key["ampersand"] = 54] = "ampersand";
            Key[Key["slashbraceleft"] = 55] = "slashbraceleft";
            Key[Key["parenleftbracketleft"] = 56] = "parenleftbracketleft";
            Key[Key["parenrightbracketright"] = 57] = "parenrightbracketright";
            Key[Key["A"] = 65] = "A";
            Key[Key["B"] = 66] = "B";
            Key[Key["C"] = 67] = "C";
            Key[Key["D"] = 68] = "D";
            Key[Key["E"] = 69] = "E";
            Key[Key["F"] = 70] = "F";
            Key[Key["G"] = 71] = "G";
            Key[Key["H"] = 72] = "H";
            Key[Key["I"] = 73] = "I";
            Key[Key["J"] = 74] = "J";
            Key[Key["K"] = 75] = "K";
            Key[Key["L"] = 76] = "L";
            Key[Key["M"] = 77] = "M";
            Key[Key["N"] = 78] = "N";
            Key[Key["O"] = 79] = "O";
            Key[Key["P"] = 80] = "P";
            Key[Key["Q"] = 81] = "Q";
            Key[Key["R"] = 82] = "R";
            Key[Key["S"] = 83] = "S";
            Key[Key["T"] = 84] = "T";
            Key[Key["U"] = 85] = "U";
            Key[Key["V"] = 86] = "V";
            Key[Key["W"] = 87] = "W";
            Key[Key["X"] = 88] = "X";
            Key[Key["Y"] = 89] = "Y";
            Key[Key["Z"] = 90] = "Z";
            Key[Key["KP_0"] = 96] = "KP_0";
            Key[Key["KP_1"] = 97] = "KP_1";
            Key[Key["KP_2"] = 98] = "KP_2";
            Key[Key["KP_3"] = 99] = "KP_3";
            Key[Key["KP_4"] = 100] = "KP_4";
            Key[Key["KP_5"] = 101] = "KP_5";
            Key[Key["KP_6"] = 102] = "KP_6";
            Key[Key["KP_7"] = 103] = "KP_7";
            Key[Key["KP_8"] = 104] = "KP_8";
            Key[Key["KP_9"] = 105] = "KP_9";
            Key[Key["KP_Multiply"] = 106] = "KP_Multiply";
            Key[Key["KP_Add"] = 107] = "KP_Add";
            Key[Key["KP_Separator"] = 108] = "KP_Separator";
            Key[Key["KP_Subtract"] = 109] = "KP_Subtract";
            Key[Key["KP_Decimal"] = 110] = "KP_Decimal";
            Key[Key["KP_Divide"] = 111] = "KP_Divide";
            Key[Key["F1"] = 112] = "F1";
            Key[Key["F2"] = 113] = "F2";
            Key[Key["F3"] = 114] = "F3";
            Key[Key["F4"] = 115] = "F4";
            Key[Key["F5"] = 116] = "F5";
            Key[Key["F6"] = 117] = "F6";
            Key[Key["F7"] = 118] = "F7";
            Key[Key["F8"] = 119] = "F8";
            Key[Key["F9"] = 120] = "F9";
            Key[Key["F10"] = 121] = "F10";
            Key[Key["F11"] = 122] = "F11";
            Key[Key["F12"] = 123] = "F12";
            Key[Key["F13"] = 124] = "F13";
            Key[Key["F14"] = 125] = "F14";
            Key[Key["F15"] = 126] = "F15";
            Key[Key["F16"] = 127] = "F16";
            Key[Key["F17"] = 128] = "F17";
            Key[Key["F18"] = 129] = "F18";
            Key[Key["F19"] = 130] = "F19";
            Key[Key["F20"] = 131] = "F20";
            Key[Key["F21"] = 132] = "F21";
            Key[Key["F22"] = 133] = "F22";
            Key[Key["F23"] = 134] = "F23";
            Key[Key["F24"] = 135] = "F24";
            Key[Key["Num_Lock"] = 136] = "Num_Lock";
            Key[Key["Scroll_Lock"] = 137] = "Scroll_Lock";
        })(input.Key || (input.Key = {}));
        var Key = input.Key;
        ;

        

        

        

        /** @ignore */
        var BaseUIProcess = (function () {
            function BaseUIProcess() {
                this.isMulSelected = false;
                this.isDblClick = false;
                this.isTriClick = false;
                this.isOverWrite = false;
                this.moveFocusExitOnLastChar = false;
            }
            BaseUIProcess.prototype.GetInputElement = function () {
                return this.Owner.GetInputElement();
            };

            BaseUIProcess.prototype.GetElementId = function () {
                return this.Owner.GetInputElement().id;
            };

            BaseUIProcess.prototype.GetShowLiterals = function () {
                if (this.Owner.GetShowLiterals !== undefined) {
                    return this.Owner.GetShowLiterals();
                }
                return 1 /* Always */;
            };

            /**
            * Get cursor start and end position according to the specified highlighttext and current text.
            */
            BaseUIProcess.prototype.SetCursorPositionAndSelection = function (highlightText, text, cursorPos, startPos) {
                var retInfo = {};

                if (highlightText == true || highlightText == 2 /* All */) {
                    retInfo.SelectionStart = 0;
                    retInfo.SelectionEnd = text.GetLength();
                }

                return retInfo;
            };

            /**
            * Clear the current value of the control.
            */
            BaseUIProcess.prototype.Clear = function () {
                return null;
            };

            /**
            * Handle the onfocus event.
            */
            BaseUIProcess.prototype.Focus = function (data) {
                var text = data.Text;
                var displayText = data.DisplayText;
                var focusType = data.FocusType;
                var oText = data.Element;
                var highlightText = data.HighlightText;
                var cursorPos = data.CursorPosition;
                var retInfo = {};

                //Add comments by Ryan Wu at 19:22 Dec 7, 2005.
                //Maybe this is a bug? for we press tab key to get focus. If the original state is
                //selection then the current state is also state, thus this.isMulSelected is true.????
                this.isMulSelected = false;

                //the focusType is used to distribute the get focus type by Left key
                // or Right key or something else.
                if (focusType == 1 /* Click */) {
                    retInfo.SelectionStart = Utility.GetCursorPosition(oText);
                    retInfo.SelectionEnd = retInfo.SelectionStart;
                }

                //when get the focus, display the format.
                retInfo.Text = text;

                //Press tab key will set cursor start position to less than zero
                if (retInfo.SelectionStart == -1) {
                    retInfo.SelectionStart = 0;
                    retInfo.SelectionEnd = 0;
                } else if (retInfo.SelectionStart > retInfo.Text.GetLength()) {
                    retInfo.SelectionStart = retInfo.Text.GetLength();
                    retInfo.SelectionEnd = retInfo.Text.GetLength();
                } else if (retInfo.SelectionStart == displayText.GetLength()) {
                    retInfo.SelectionStart = retInfo.Text.GetLength();
                    retInfo.SelectionEnd = retInfo.Text.GetLength();
                }

                //the focusType is FocusType.Left it means that the focus is set by press the left key.
                // change by Sean Huang at 2008.12.05, for bug 992 -->
                //if (focusType == FocusType.Left)
                if (focusType == 9 /* Left */ && cursorPos == 0 /* Default */) {
                    retInfo.SelectionStart = 0;
                    retInfo.SelectionEnd = 0;
                    //update by wuhao 2008-1-8 for fix bug 1362
                    //return retInfo;
                    //end by wuhao 2008-1-8 for fix bug 1362
                } else if (focusType == 10 /* Right */ && cursorPos == 0 /* Default */) {
                    retInfo.SelectionStart = retInfo.Text.GetLength();
                    retInfo.SelectionEnd = retInfo.Text.GetLength();
                    //update by wuhao 2008-1-8 for fix bug 1362
                    //return retInfo;
                    //end by wuhao 2008-1-8 for fix bug 1362
                }

                //The selection is not determined by the HighlightText and CursorPosition property.
                if (highlightText == 0 /* None */ && cursorPos == 0 /* Default */) {
                    return retInfo;
                }

                //Add comments by Ryan Wu at 9:23 Oct. 18 2007.
                //For fix the bug#9065.
                if (focusType == 2 /* ContextMenu */) {
                    return retInfo;
                }

                //end by Ryan Wu.
                //Add comments by Ryan Wu at 14:38 Oct. 11 2007.
                //For fix the bug#8998.
                //    //According to the HighlightText property and CursorPosition property to set the
                //	//selection.
                //	var ret = this.SetCursorPositionAndSelection(highlightText, retInfo.Text, cursorPos, retInfo.SelectionStart);
                var startPos = retInfo.SelectionStart == null ? data.SelectionStart : retInfo.SelectionStart;
                var ret = this.SetCursorPositionAndSelection(highlightText, retInfo.Text, cursorPos, startPos);

                //end by Ryan Wu.
                if (ret != null) {
                    retInfo.SelectionStart = ret.SelectionStart;
                    retInfo.SelectionEnd = ret.SelectionEnd;
                    retInfo.IsSelectionDeterminedByHighlightText = true;
                }

                //Add comments by Ryan Wu at 9:13 Oct. 18 2007.
                //For removing the useless code.
                //	//the focusType is FocusType.ClientEvent it means that the focus is set by ourself.
                //	if (focusType == FocusType.ClientEvent)
                //	{
                //		return retInfo;
                //	}
                //end by Ryan Wu.
                return retInfo;
            };

            /**
            * Handle the onblur event.
            */
            BaseUIProcess.prototype.LoseFocus = function (data) {
            };

            /**
            * Handle the onmousedown event.
            */
            BaseUIProcess.prototype.MouseDown = function (mouseButton) {
                var retInfo = {};

                this.isTriClick = false;

                //for triple click
                if (this.isDblClick && !Utility.GrapeCityTimeout && mouseButton == 0 /* Left */) {
                    this.isTriClick = true;
                    retInfo = this.SelectAll();
                }

                this.isDblClick = false;
                return retInfo;
            };

            /**
            * Handle the onmouseup event.
            */
            // Frank Liu added the parameter "ctrlPressed" at 2013/06/27 for bug 881.
            BaseUIProcess.prototype.MouseUp = function (obj, start, end, mouseButton, ctrlPressed) {
                var retInfo = {};

                if (this.isTriClick) {
                    Utility.SetSelection(obj, start, end);

                    return null;
                }

                //Add comments by Ryan Wu at 10:13 Sep. 13 2007.
                //For fix the bug "17. Ctrl+Click(select all text) will take no effects.".
                // Frank Liu fixed bug 881 at 2013/06/27.
                //if (!Utility.IsIE() && Utility.FuncKeysPressed.Ctrl) {
                if (ctrlPressed) {
                    retInfo = this.SelectAll();
                    Utility.SetSelection(obj, retInfo.SelectionStart, retInfo.SelectionEnd);

                    return retInfo;
                }

                //end by Ryan Wu.
                retInfo.SelectionStart = start;
                retInfo.SelectionEnd = end;

                if (mouseButton == 0 /* Left */) {
                    //bug#5675
                    //retInfo = GrapeCity_InputMan_GetCursorEndPos(obj, start);
                    retInfo.SelectionStart = Utility.GetSelectionStartPosition(obj);
                    retInfo.SelectionEnd = Utility.GetSelectionEndPosition(obj);
                }

                if (retInfo.SelectionStart != retInfo.SelectionEnd) {
                    this.isMulSelected = true;
                } else {
                    this.isMulSelected = false;
                }

                return retInfo;
            };

            /**
            * Handle the shortcut key event.
            */
            BaseUIProcess.prototype.ProcessShortcutKey = function (keyAction, readOnly, end, start) {
                var retInfo = {};

                switch (keyAction) {
                    case "Clear":
                        if (readOnly) {
                            retInfo.System = false;
                            return retInfo;
                        }

                        return this.Clear();
                    case "NextControl":
                        var ret = this.MoveControl(this.GetInputElement(), true, false, "NextControl");

                        if (ret != null) {
                            retInfo.EventInfo = ret.EventInfo;
                            retInfo.FocusType = ret.FocusType;
                            retInfo.FocusExit = true;
                        }

                        retInfo.System = false;
                        return retInfo;
                    case "PreviousControl":
                        var ret = this.MoveControl(this.GetInputElement(), false, false, "PreviousControl");
                        if (ret != null) {
                            retInfo.EventInfo = ret.EventInfo;
                            retInfo.FocusType = ret.FocusType;
                            retInfo.FocusExit = true;
                        }

                        retInfo.System = false;
                        return retInfo;
                    case "NextField":
                        retInfo = this.MoveField(end, true);
                        return retInfo;
                    case "PreviousField":
                        retInfo = this.MoveField(end, false);
                        return retInfo;
                    case "NextField/NextControl":
                        var retInfo = this.MoveFieldAndControl(end, true);
                        return retInfo;
                    case "PreviousField/PreviousControl":
                        var retInfo = this.MoveFieldAndControl(end, false);
                        return retInfo;
                }
            };

            /**
            * Process char key input.
            */
            BaseUIProcess.prototype.ProcessCharKeyInput = function (k, start, end, isExitOnLastChar, text) {
                return null;
            };

            /**
            * Prcess navigator key input.
            */
            BaseUIProcess.prototype.ProcessNavigatorKeyInput = function (k, editMode, clipContent, text, start, end, exitOnLeftRightKey, isExitOnLastChar) {
                var retInfo = {};

                switch (k) {
                    case 45:
                        if (editMode == 2 /* FixedInsert */) {
                            this.isOverWrite = false;
                        } else if (editMode == 3 /* FixedOverwrite */) {
                            this.isOverWrite = true;
                        } else {
                            this.isOverWrite = !this.isOverWrite;
                        }

                        retInfo.Overwrite = this.isOverWrite;
                        retInfo.System = false;

                        if (this.Format.Fields.fieldCount == 0) {
                            retInfo.System = true;
                        }

                        return retInfo;

                    case 8:
                        //Add comments by Ryan Wu at 14:23 Jul. 19 2006.
                        //Add text param only for number to judge whether the current text is zero.
                        //retInfo = this.ProcessBackSpace(start, end);
                        retInfo = this.ProcessBackSpace(start, end, text);

                        //end by Ryan Wu.
                        retInfo.System = false;
                        break;

                    case 46:
                        //Add comments by Ryan Wu at 14:23 Jul. 19 2006.
                        //Add text param only for number to judge whether the current text is zero.
                        //retInfo = this.ProcessDelete(start, end);
                        retInfo = this.ProcessDelete(start, end, text);

                        //end by Ryan Wu.
                        retInfo.System = false;
                        break;

                    case 196643:

                    case 196644:

                    case 196645:

                    case 196647:

                    case 65569:

                    case 196641:

                    case 65570:

                    case 196642:
                        if (k == 65569 || k == 196641) {
                            k = 196644;
                        } else if (k == 65570 || k == 196642) {
                            k = 196643;
                        }

                        //perform the Shift+Ctrl+Left,Shift+Ctrl+Right,Shift+Ctrl+Home,Shift+Ctrl+End action
                        retInfo.SelectionEnd = this.GetCaretPosition(end, k);
                        this.isMulSelected = true;
                        retInfo.System = false;
                        break;

                    case 65582:
                    case 65544:
                        if (this.isMulSelected) {
                            if (this.Owner._isSupportClipBoard()) {
                                retInfo = this.Cut(clipContent, start, end);
                            } else {
                                retInfo.System = true;
                                break;
                            }
                        } else {
                            retInfo = this.ProcessBackSpace(start, end);
                        }
                        retInfo.System = false;
                        break;

                    case 65581:

                    case 131158:
                        if (this.Owner._isSupportClipBoard()) {
                            var pasteData = Utility.GetPasteData(this.Owner ? this.Owner.GetUseClipboard() : true);
                            retInfo = this.Paste(start, end, pasteData, isExitOnLastChar);
                            retInfo.System = false;
                        } else {
                            retInfo.System = true;
                        }
                        break;

                    case 65571:

                    case 65572:

                    case 65573:

                    case 65575:

                    case 65574:

                    case 65576:
                        // end by Jiang Changcheng <--
                        this.isMulSelected = true;

                        //perform the Shift+Left,Shift+Right,Shift+Home,Shift+End action
                        retInfo.SelectionEnd = this.GetCaretPosition(end, k);
                        retInfo.System = false;
                        break;

                    case 131139:

                    case 131117:
                        if (this.Owner._isSupportClipBoard()) {
                            this.Copy(clipContent, start, end);
                            retInfo.System = false;
                        } else {
                            retInfo.System = true;
                        }

                        break;

                    case 131118:
                        if (!this.isMulSelected) {
                            end = this.GetCaretPosition(end, k);
                        }

                        retInfo = this.ProcessDelete(start, end);
                        retInfo.System = false;
                        break;

                    case 131080:
                    case 196616:
                        if (!this.isMulSelected) {
                            end = this.GetCaretPosition(end, k);
                        }

                        retInfo = this.ProcessBackSpace(start, end);
                        retInfo.System = false;
                        break;

                    case 131137:
                        retInfo = this.SelectAll();
                        retInfo.System = false;
                        break;

                    case 131160:
                        if (this.Owner._isSupportClipBoard()) {
                            retInfo = this.Cut(clipContent, start, end);
                            retInfo.System = false;
                        } else {
                            retInfo.System = true;
                        }

                        break;

                    case 131162:
                        //Need add undo methods by Ryan wu.
                        retInfo = this.Undo();
                        retInfo.System = false;
                        break;

                    case 131109:

                    case 37:
                        //Move to previous control
                        if (start == 0 && (exitOnLeftRightKey == 3 /* Both */ || exitOnLeftRightKey == 1 /* Left */)) {
                            var exitType = k == 37 ? "Left" : "CtrlLeft";
                            var ret = this.MoveControl(this.GetInputElement(), false, true, exitType);

                            if (ret != null) {
                                retInfo.EventInfo = ret.EventInfo;
                                retInfo.FocusType = ret.FocusType;
                                retInfo.FocusExit = true;
                            }

                            return retInfo;
                        }

                    case 131108:

                    case 131110:

                    case 36:

                    case 33:

                    case 131105:
                        if (k == 33 || k == 131105) {
                            k = 131108;
                        }

                        retInfo = this.ProcessLeftDirection(start, end, k);
                        retInfo.System = false;
                        break;

                    case 131111:

                    case 39:
                        //Move to next control
                        if (start == text.GetLength() && (exitOnLeftRightKey == 3 /* Both */ || exitOnLeftRightKey == 2 /* Right */)) {
                            var exitType = k == 39 ? "Right" : "CtrlRight";
                            var ret = this.MoveControl(this.GetInputElement(), true, true, exitType);
                            if (ret != null) {
                                retInfo.EventInfo = ret.EventInfo;
                                retInfo.FocusType = ret.FocusType;
                                retInfo.FocusExit = true;
                            }
                            return retInfo;
                        }

                    case 131107:

                    case 131112:

                    case 35:

                    case 34:

                    case 131106:
                        if (k == 34 || k == 131106) {
                            k = 131107;
                        }
                        retInfo = this.ProcessRightDirection(start, end, k);
                        retInfo.System = false;
                        break;
                    default:
                        retInfo = null;
                        break;
                }

                return retInfo;
            };
            BaseUIProcess.prototype.ProcessLeftDirection = function (start, end, k) {
            };
            BaseUIProcess.prototype.ProcessRightDirection = function (start, end, k) {
            };

            /**
            * Handle the onkeydown event.
            */
            BaseUIProcess.prototype.KeyDown = function (data) {
                var k = data.KeyCode;
                var start = data.SelectionStart;
                var end = data.SelectionEnd;
                var text = data.Text;
                var editMode = data.EditMode;
                var keyAction = data.KeyAction;
                var readOnly = data.ReadOnly;
                var clipContent = data.ClipContent;

                //var funcKeysPressed	   = data.FuncKeysPressed;
                var isExitOnLastChar = data.ExitOnLastChar;
                var exitOnLeftRightKey = data.ExitOnLeftRightKey;
                var tabAction = data.TabAction;
                var retInfo = {};

                switch (editMode) {
                    case 0 /* Insert */:
                        this.isOverWrite = false;
                        break;
                    case 1 /* Overwrite */:
                        this.isOverWrite = true;
                        break;
                    case 2 /* FixedInsert */:
                        this.isOverWrite = false;
                        break;
                    case 3 /* FixedOverwrite */:
                        this.isOverWrite = true;
                        break;
                }

                if (start != end) {
                    this.isMulSelected = true;
                } else {
                    this.isMulSelected = false;
                }

                switch (k) {
                    case 9:
                        retInfo = this.ProcessTabKey(end, true, tabAction);
                        return retInfo;
                    case 65545:
                        retInfo = this.ProcessTabKey(end, false, tabAction);
                        return retInfo;
                }

                //ShortCuts
                if (keyAction != null) {
                    return this.ProcessShortcutKey(keyAction, readOnly, end, start);
                }

                //The ReadOnly property is set to true
                if (readOnly) {
                    //When readonly is true, Escape, Alt + Up, Alt + Down, Up, Down can also take effect.
                    //If return null, then in BaseInputControl will handle the Escape, Alt + Up and Alt + Down action.
                    if (k == 27 || k == 262182 || k == 262184 || k == 38 || k == 40) {
                        return null;
                    }

                    //we only let the Ctrl+C and Ctrl+Insert and ShortCut to work when we set
                    //ReadOnly property to true.
                    // change by Sean Huang at 2008.08.13, for bug 28 (ttp)-->
                    //if (k != 131117 && k != 131139)
                    if (k != 131117 && k != 131139 && k != 9 && k != 65545 && k != 131081 && k != 196617 && k != 131137 && k != 37 && k != 39 && k != 38 && k != 40) {
                        return retInfo;
                    }
                }

                //the DateFormat has no Pattern property, we use the system's keydown action
                if (this.Format.Fields.fieldCount == 0) {
                    switch (k) {
                        case 45:
                            if (editMode == 2 /* FixedInsert */) {
                                this.isOverWrite = false;
                            } else if (editMode == 3 /* FixedOverwrite */) {
                                this.isOverWrite = true;
                            } else {
                                this.isOverWrite = !this.isOverWrite;
                            }

                            retInfo.Overwrite = this.isOverWrite;

                            if (this.Format.Fields.fieldCount == 0) {
                                retInfo.System = true;
                            }

                            return retInfo;

                        case 37:

                        case 131109:
                            //Move to previous control
                            if (start == 0 && (exitOnLeftRightKey == 3 /* Both */ || exitOnLeftRightKey == 1 /* Left */)) {
                                var exitType = k == 37 ? "Left" : "CtrlLeft";
                                var ret = this.MoveControl(this.GetInputElement(), false, true, exitType);
                                if (ret != null) {
                                    retInfo.EventInfo = ret.EventInfo;
                                    retInfo.FocusType = ret.FocusType;
                                    retInfo.FocusExit = true;
                                }
                                return retInfo;
                            }
                            break;

                        case 39:

                        case 131111:
                            //Move to next control
                            if (start == text.GetLength() && (exitOnLeftRightKey == 3 /* Both */ || exitOnLeftRightKey == 2 /* Right */)) {
                                var exitType = k == 39 ? "Right" : "CtrlRight";
                                var ret = this.MoveControl(this.GetInputElement(), true, true, exitType);
                                if (ret != null) {
                                    retInfo.EventInfo = ret.EventInfo;
                                    retInfo.FocusType = ret.FocusType;
                                    retInfo.FocusExit = true;
                                }
                                return retInfo;
                            }
                            break;
                    }

                    return null;
                }

                //Process char key input.
                var processInfo = this.ProcessCharKeyInput(k, start, end, isExitOnLastChar, text);

                if (processInfo != null) {
                    return processInfo;
                }

                retInfo = this.ProcessNavigatorKeyInput(k, editMode, clipContent, text, start, end, exitOnLeftRightKey, isExitOnLastChar);

                return retInfo;
            };

            /**
            * Handle the onkeypress event.
            */
            BaseUIProcess.prototype.KeyPress = function (e) {
            };

            /**
            * Handle the onkeyup event.
            */
            BaseUIProcess.prototype.KeyUp = function (e) {
            };

            /**
            * Handle the oncontextmenu event.
            */
            BaseUIProcess.prototype.ShowContextMenu = function (oText, selText) {
                var retInfo = {};

                //If there's no text selected
                if (selText == "") {
                    retInfo.SelectionStart = Utility.GetCursorPosition(oText);
                    retInfo.SelectionEnd = retInfo.SelectionStart;
                }

                return retInfo;
            };

            /**
            * Handle the onselectstart event.
            */
            BaseUIProcess.prototype.SelectStart = function (obj, selText, mouseButton) {
                var retInfo = {};

                if (selText == "" && !this.isTriClick && !this.isDblClick && mouseButton != -1 /* Default */) {
                    retInfo.SelectionStart = Utility.GetCursorPosition(obj);
                    retInfo.SetFalse = true;
                }

                return retInfo;
            };

            /**
            * Handle the ondblclick event.
            */
            BaseUIProcess.prototype.DoubleClick = function (pos) {
                var retInfo = {};

                //Get current field range
                var fieldIndex = this.Format.Fields.GetFieldIndexByPos(pos);
                var fieldPos = this.Format.Fields.GetFieldRange(fieldIndex.index);
                retInfo.SelectionStart = fieldPos.start;
                retInfo.SelectionEnd = fieldPos.length + fieldPos.start;

                //set timer for tripple click
                Utility.GrapeCityTimeout = false;
                this.isDblClick = true;
                this.isMulSelect = true;

                setTimeout(function () {
                    Utility.GrapeCityTimeout = true;
                }, 300);

                return retInfo;
            };

            /**
            * Handle the undo actions.
            */
            BaseUIProcess.prototype.Undo = function () {
            };

            /**
            * Handle the cut actions.
            * @param clipContent - The copy mode.
            * @param start - The start cursor position.
            * @param end   - The end cursor position.
            * @returns Returns the cursor position.
            */
            BaseUIProcess.prototype.Cut = function (clipContent, start, end) {
                var retInfo = {};

                if (start == end) {
                    return retInfo;
                }

                this.FireClientEvent("OnBeforeCut");
                this.Copy(clipContent, start, end);
                retInfo = this.ProcessDelete(start, end);

                this.FireClientEvent("OnCut");
                return retInfo;
            };

            /**
            * Handle the oncopy event.
            * @param clipContent - The copy mode.
            * @param start - The start cursor position.
            * @param end   - The end cursor position.
            */
            BaseUIProcess.prototype.Copy = function (clipContent, start, end) {
                var text = null;
                var useClipboard = true;

                if (clipContent == 1 /* ExcludeLiterals */) {
                    var length = Math.abs(start - end);
                    var start = Math.min(start, end);
                    if (length == 0) {
                        return;
                    }

                    text = this.Format.Fields.GetNonLiteralsText(start, length);
                } else if (!input.CoreUtility.IsIE() || input.CoreUtility.IsIE11OrLater()) {
                    text = Utility.GetSelectionText(this.Owner.GetInputElement());
                } else {
                    text = document.selection.createRange().text;
                }

                // end of Sean Huang <--
                //end by Ryan Wu.
                if (this.Owner) {
                    text = BaseUIProcess.UpdateCrLfString(text, this.Owner.GetAcceptsCrlf());
                    useClipboard = this.Owner.GetUseClipboard();
                }

                // change by Sean Huang at 2009.04.29, for bug 2209 -->
                //Utility.SetCopy(text);
                if (input.CoreUtility.IsIE()) {
                    setTimeout(function () {
                        Utility.SetCopy(text, useClipboard);
                    });
                } else {
                    Utility.SetCopy(text, useClipboard);
                }
                // end of Sean Huang <--
            };

            /**
            * Handle the onpaste event.
            */
            BaseUIProcess.prototype.Paste = function (start, end, text, exitonlastChar) {
            };

            /**
            * Select all the content.
            * @returns Returns the cursor position.
            */
            BaseUIProcess.prototype.SelectAll = function () {
                var retInfo = { SelectionStart: 0, SelectionEnd: 0 };
                retInfo.SelectionStart = 0;

                //modified by sj 2008.8.13 for bug 243
                var ShowLiterals;

                if (this.ID) {
                    ShowLiterals = this.GetShowLiterals();
                }

                if (ShowLiterals == 'PostDisplay' || ShowLiterals == 'PreDisplay') {
                    retInfo.SelectionEnd = Utility.FindIMControl(this.ID).GetText().GetLength();
                } else {
                    retInfo.SelectionEnd = this.Format.Fields.GetLength();
                }

                //retInfo.SelectionEnd   = this.Format.Fields.GetLength();
                //end by sj
                this.isMulSelected = true;

                return retInfo;
            };

            //Add comments by Ryan Wu at 9:31 Apr. 5 2007.
            //For support Aspnet Ajax 1.0.
            ///*
            //* This Function should be called when an event needs to be fired.
            //* @param oControl - the javascript object representation of our control.
            //* @param eName    - the name of the function that should handle this event.
            //* @param eArgs    - the argument of the function that should handle this event.
            //*/
            //FireEvent (oControl, eName, eArgs)
            //{
            //	//Because when we fire client event we may be invoke the lose focus event,
            //	//so we must return the current focus type of getting focus.
            //	//No event will be fired
            //	if (eName == null || eName == "")
            //	{
            //		return null;
            //	}
            //
            //	if (Utility.FireEvent(oControl, eName, eArgs))
            //	{
            //		return FocusType.ClientEvent;
            //	}
            //};
            /*
            * This Function should be called when an event needs to be fired.
            * @param oControl - the javascript object representation of our control.
            * @param eName    - the name of the function that should handle this event.
            * @param eArgs    - the argument of the function that should handle this event.
            */
            BaseUIProcess.prototype.FireEvent = function (oControl, eName, eArgs, eType) {
                //Because when we fire client event we may be invoke the lose focus event,
                //so we must return the current focus type of getting focus.
                //No event will be fired
                //if (eName == null || eName == "") {
                //    return null;
                //}
                if (Utility.FireEvent(oControl, eName, eArgs, eType)) {
                    return 3 /* ClientEvent */;
                }
            };

            //end by Ryan Wu.
            /**
            * Process the input char key action.
            * @param start - The specified start cursor position.
            * @param end - The specified end cursor position.
            * @param charInput - The specified char will be input.
            * @returns Returns action result includes cursor position and if succeed after the process and whether we fire a client event.
            */
            BaseUIProcess.prototype.ProcessCharKey = function (start, end, charInput, isExitOnLastChar) {
                var processInfo = {};

                //get the selection information.
                var selectionStart = Math.min(start, end);
                var selectionLength = Math.abs(end - start);
                var retInfo = {};

                processInfo.start = selectionStart;
                processInfo.success = false;

                //none action.
                if (this.Format.Fields.GetFieldIndex(selectionStart).index == -1) {
                    //we input an invalid char, so invoke the InvalidInput Event
                    var eventInfo = {};
                    eventInfo.Name = this.Owner.InvalidInputEvent;
                    eventInfo.Args = null;

                    //Add comments by Ryan Wu at 10:27 Apr. 5 2007.
                    //For support Aspnet Ajax 1.0.
                    eventInfo.Type = "invalidInput";

                    //end by Ryan Wu.
                    processInfo.EventInfo = eventInfo;

                    return processInfo;
                }

                var text = charInput.toString();

                if (selectionLength == 0 && !this.isOverWrite) {
                    retInfo = this.Format.Fields.Insert(selectionStart, text, false);
                } else if (selectionLength == 0) {
                    if (selectionStart == this.Format.Fields.GetLength()) {
                        retInfo = this.Format.Fields.Insert(selectionStart, text, false);
                    } else {
                        var isReplace = false;
                        var posInfo = this.Format.Fields.GetFieldIndexByPos(selectionStart);
                        var fieldIndex = posInfo.index;
                        var fieldOffset = posInfo.offset;

                        //var fieldsLength = selectionStart - fieldOffset;
                        var fieldRange = this.Format.Fields.GetFieldRange(fieldIndex);

                        if (this.Format.Fields.GetFieldByIndex(fieldIndex).fieldLabel == "PromptField") {
                            if (selectionStart - fieldOffset + fieldRange.length == this.Format.Fields.GetLength()) {
                                isReplace = false;
                            } else {
                                isReplace = true;
                                selectionLength = fieldRange.length - fieldOffset + 1;
                            }
                        } else {
                            isReplace = true;

                            // DaryLuo 2013/07/15 fix bug 1014 in IM HTML 5.
                            selectionLength = charInput.GetLength();
                        }

                        //none action.
                        if (this.Format.Fields.GetFieldIndexByPos(selectionStart + selectionLength).index == -1) {
                            //we input an invalid char, so invoke the InvalidInput Event
                            var eventInfo = {};
                            eventInfo.Name = this.Owner.InvalidInputEvent;
                            eventInfo.Args = null;

                            //Add comments by Ryan Wu at 10:27 Apr. 5 2007.
                            //For support Aspnet Ajax 1.0.
                            eventInfo.Type = "invalidInput";

                            //end by Ryan Wu.
                            processInfo.EventInfo = eventInfo;

                            return processInfo;
                        }

                        if (isReplace) {
                            retInfo = this.Format.Fields.Replace(selectionStart, selectionLength, text, false);
                        } else {
                            retInfo = this.Format.Fields.Insert(selectionStart, text, false);
                        }
                    }
                } else {
                    retInfo = this.Format.Fields.Replace(selectionStart, selectionLength, text, false);
                }

                selectionStart = retInfo.cursorPos;

                //we input an invalid char, so invoke the InvalidInput Event
                if (retInfo.text != "") {
                    var eventInfo = {};
                    eventInfo.Name = this.Owner.InvalidInputEvent;
                    eventInfo.Args = null;

                    //Add comments by Ryan Wu at 10:27 Apr. 5 2007.
                    //For support Aspnet Ajax 1.0.
                    eventInfo.Type = "invalidInput";

                    //end by Ryan Wu.
                    processInfo.EventInfo = eventInfo;

                    processInfo.start = selectionStart;
                    processInfo.success = false;

                    return processInfo;
                }

                //judge if the focus should exit on last char.
                if (isExitOnLastChar == true) {
                    if (selectionStart == this.Format.Fields.GetLength()) {
                        this.moveFocusExitOnLastChar = true;
                    } else {
                        var posInfo = this.Format.Fields.GetFieldIndexByPos(selectionStart);
                        var fieldIndex = posInfo.index;
                        var fieldOffset = posInfo.offset;

                        if (fieldIndex == this.Format.Fields.fieldCount - 1 && fieldOffset == 0 && this.Format.Fields.GetFieldByIndex(fieldIndex).fieldLabel == "PromptField") {
                            this.moveFocusExitOnLastChar = true;
                        }
                    }
                }

                processInfo.start = selectionStart;
                processInfo.success = true;

                return processInfo;
            };

            /**
            * Process the Delete key down action.
            * @param start - The specified start cursor position.
            * @param end - The specified end cursor position.
            * @returns Returns the cursor position after the process.
            */
            BaseUIProcess.prototype.ProcessDeleteKey = function (start, end) {
                //get the selection information.
                var selectionStart = Math.min(start, end);
                var selectionLength = Math.abs(start - end);
                var retInfo = {};

                if (selectionStart == this.Format.Fields.GetLength() && selectionLength == 0) {
                    return retInfo;
                }

                //var startFieldOffset;
                var startFieldIndex;
                var fieldPosInfo = this.Format.Fields.GetFieldIndexByPos(selectionStart);
                startFieldIndex = fieldPosInfo.index;

                //startFieldOffset = fieldPosInfo.offset;
                //none action.
                if (startFieldIndex == -1) {
                    return retInfo;
                }

                //if the selectionlength = 0, do the delete action for one post char.
                if (selectionLength == 0) {
                    //none action.
                    if (this.Format.Fields.GetFieldByIndex(startFieldIndex).fieldLabel == "PromptField") {
                        return retInfo;
                    }

                    selectionStart = this.Format.Fields.Delete(selectionStart, 1).cursorPos;

                    retInfo.SelectionStart = selectionStart;
                    retInfo.SelectionEnd = retInfo.SelectionStart;
                } else {
                    var endFieldOffset;
                    var endFieldIndex;
                    fieldPosInfo = this.Format.Fields.GetFieldIndexByPos(selectionStart + selectionLength);
                    endFieldOffset = fieldPosInfo.offset;
                    endFieldIndex = fieldPosInfo.index;

                    //none action.
                    if (endFieldIndex == -1) {
                        return retInfo;
                    }

                    if (endFieldOffset == 0) {
                        endFieldIndex--;
                    }

                    //none action
                    if (startFieldIndex == endFieldIndex && this.Format.Fields.GetFieldByIndex(startFieldIndex).fieldLabel == "PromptField") {
                        return retInfo;
                    }

                    var info = this.Format.Fields.Delete(selectionStart, selectionLength);

                    //The same as BackSpace. ("20005[/)02/24" press delete)
                    if (!info.isSucceed) {
                        return retInfo;
                    }

                    retInfo.SelectionStart = info.cursorPos;

                    if (retInfo.SelectionStart == 0 && this.Format.Fields.GetFieldByIndex(0).fieldLabel == "PromptField") {
                        retInfo.SelectionStart = this.Format.Fields.GetFieldByIndex(0).GetLength();
                    }

                    retInfo.SelectionEnd = retInfo.SelectionStart;

                    //Accordingto the changed information, generate BehaviorInfo and invoke UpdateBehavior to finsihed the correlative action.
                    var currentFieldOffset;
                    var currentFieldIndex;
                    var currentFieldInfo = this.Format.Fields.GetFieldIndexByPos(retInfo.SelectionStart);
                    currentFieldIndex = currentFieldInfo.index;
                    currentFieldOffset = currentFieldInfo.offset;

                    if (currentFieldOffset != 0 && this.Format.Fields.GetFieldByIndex(currentFieldIndex).fieldLabel == "PromptField") {
                        retInfo.SelectionStart = retInfo.SelectionStart - currentFieldOffset + this.Format.Fields.GetFieldByIndex(currentFieldIndex).GetLength();
                        retInfo.SelectionEnd = retInfo.SelectionStart;
                    }
                }

                return retInfo;
            };

            /**
            * Perform the delete keydown event.
            * @param start - The start cursor position.
            * @param end   - The start end position.
            */
            BaseUIProcess.prototype.ProcessBackSpace = function (start, end, text) {
            };

            /**
            * Perform the delete keydown event.
            * @param start - The start cursor position.
            * @param end   - The start end position.
            */
            BaseUIProcess.prototype.ProcessDelete = function (start, end, text) {
            };

            /**
            * Get the next caret position according to the special cursor position and keycode(processType).
            * @param cursorPos - The current cursor position.
            * @param keyCode   - The keyCode indicate the key action.
            * @returns Return the cursor position after the key action.
            */
            BaseUIProcess.prototype.GetCaretPosition = function (cursorPos, keyCode, startPos, endPos, literalFieldLabel) {
                var fields = this.Format.Fields;
                var fieldPosInfo = fields.GetFieldIndexByPos(cursorPos);
                var fieldIndex = fieldPosInfo.index;
                var fieldOffset = fieldPosInfo.offset;
                var fieldRange;

                //var startPos;
                //var endPos;
                var i = 0;

                switch (keyCode) {
                    case 36:

                    case 65572:

                    case 65574:
                        // end by Jiang Changcheng <--
                        if (cursorPos <= startPos) {
                            return 0;
                        } else {
                            return startPos;
                        }

                    case 35:

                    case 65571:

                    case 65576:
                        // end by Jiang Changcheng <--
                        if (cursorPos >= endPos) {
                            return fields.GetLength();
                        } else {
                            return endPos;
                        }

                    case 37:
                        if (cursorPos == 0) {
                            return 0;
                        }

                        if (fields.GetFieldByIndex(fieldIndex).fieldLabel == literalFieldLabel) {
                            if (fieldOffset > 0) {
                                cursorPos -= fieldOffset;
                            } else {
                                cursorPos--;
                            }
                        } else {
                            //aaaggg|eebbbMMccddee
                            if (fieldOffset == 0 && fields.GetFieldByIndex(fieldIndex - 1).fieldLabel == literalFieldLabel) {
                                cursorPos -= fields.GetFieldRange(fieldIndex - 1).length;
                            } else {
                                cursorPos--;
                            }
                        }
                        break;

                    case 39:
                        if (cursorPos == fields.GetLength()) {
                            return cursorPos;
                        }

                        if (fields.GetFieldByIndex(fieldIndex).fieldLabel == literalFieldLabel) {
                            fieldRange = fields.GetFieldRange(fieldIndex);
                            startPos = fieldRange.start;
                            endPos = startPos + fieldRange.length;

                            if (cursorPos < endPos) {
                                return endPos;
                            }
                        } else {
                            cursorPos++;
                        }
                        break;

                    case 131109:
                        if (cursorPos == 0 || fieldIndex == 0) {
                            return 0;
                        }

                        if (fields.GetFieldByIndex(fieldIndex).fieldLabel == literalFieldLabel) {
                            fieldRange = fields.GetFieldRange(fieldIndex - 1);
                            cursorPos = fieldRange.start;
                        } else {
                            if (fieldOffset == 0) {
                                for (i = fieldIndex - 1; i >= 0; i--) {
                                    //find the edit field before the current field
                                    if (fields.GetFieldByIndex(i).fieldLabel != literalFieldLabel) {
                                        fieldRange = fields.GetFieldRange(i);

                                        return fieldRange.start;
                                    }
                                }

                                //if the former field is PromptField, then return 0
                                return 0;
                            } else {
                                cursorPos -= fieldOffset;
                            }
                        }
                        break;

                    case 196645:
                        if (cursorPos == 0 || fieldIndex == 0) {
                            return 0;
                        }

                        if (fieldOffset == 0) {
                            fieldRange = fields.GetFieldRange(fieldIndex - 1);
                            cursorPos = fieldRange.start;
                        } else {
                            cursorPos -= fieldOffset;
                        }
                        break;

                    case 131111:
                        if (cursorPos == fields.GetLength() || fieldIndex == fields.fieldCount - 1) {
                            return fields.GetLength();
                        }

                        if (fields.GetFieldByIndex(fieldIndex).fieldLabel == literalFieldLabel) {
                            fieldRange = fields.GetFieldRange(fieldIndex + 1);
                            cursorPos = fieldRange.start;
                        } else {
                            for (i = fieldIndex + 1; i < fields.fieldCount; i++) {
                                //find the edit field after the current field
                                if (fields.GetFieldByIndex(i).fieldLabel != literalFieldLabel) {
                                    fieldRange = fields.GetFieldRange(i);

                                    return fieldRange.start;
                                }
                            }

                            //if the latter field is PromptField, then return fieldcollection length
                            return fields.GetLength();
                        }
                        break;

                    case 196647:
                        if (cursorPos == fields.GetLength() || fieldIndex == fields.fieldCount - 1) {
                            return fields.GetLength();
                        }

                        //if the current caret is in the last field then return the fields' length
                        fieldRange = fields.GetFieldRange(fieldIndex + 1);
                        cursorPos = fieldRange.start;
                        break;

                    case 131118:
                        if (cursorPos == fields.GetLength() || fields.GetFieldByIndex(fieldIndex).fieldLabel == literalFieldLabel) {
                            return cursorPos;
                        } else {
                            fieldRange = fields.GetFieldRange(fieldIndex);

                            return fieldRange.start + fieldRange.length;
                        }

                    case 131080:
                    case 196616:
                        if (cursorPos == 0 || (fields.GetFieldByIndex(fieldIndex).fieldLabel == literalFieldLabel && fieldIndex == 0)) {
                            return cursorPos;
                        } else if (fields.GetFieldByIndex(fieldIndex).fieldLabel == literalFieldLabel) {
                            return fields.GetFieldRange(fieldIndex - 1).start;
                        } else {
                            if (fieldOffset == 0) {
                                for (i = fieldIndex - 1; i >= 0; i--) {
                                    //find the edit field before the current field
                                    if (fields.GetFieldByIndex(i).fieldLabel != literalFieldLabel) {
                                        fieldRange = fields.GetFieldRange(i);

                                        return fieldRange.start;
                                    }
                                }

                                //if there is no edit field before the current field
                                return cursorPos;
                            } else {
                                cursorPos -= fieldOffset;
                            }
                        }
                        break;

                    case 196643:

                    case 131107:

                    case 131112:
                        // end of Sean Huang <--
                        return fields.GetLength();

                    case 196644:

                    case 131108:

                    case 131110:
                        // end of Sean Huang <--
                        return 0;

                    case 65573:
                        if (cursorPos == 0) {
                            return 0;
                        } else {
                            return --cursorPos;
                        }

                    case 65575:
                        if (cursorPos == fields.GetLength()) {
                            return cursorPos;
                        } else {
                            return ++cursorPos;
                        }
                }

                return cursorPos;
            };

            /**
            * Compare the specified keycode with the shortcut array passed from server side.
            * @param keyCode - The keyCode indicate the key action.
            * @param shortcut - The shortcut text passed from server side.
            * @returns Return true if keycode in the shortcuts array otherwise return false.
            */
            BaseUIProcess.prototype.CompareShortcut = function (keyCode, shortcut) {
                if (shortcut.toString().IndexOf("|") == -1) {
                    if (shortcut == keyCode) {
                        return true;
                    } else {
                        return false;
                    }
                } else {
                    var index = null;
                    while (index != -1) {
                        index = shortcut.toString().IndexOf("|");
                        var length = shortcut.toString().GetLength();
                        if (shortcut.Substring(0, index == -1 ? length : index) == keyCode) {
                            return true;
                        } else {
                            shortcut = shortcut.Substring(index + 1, length);
                        }
                    }
                    return false;
                }
            };

            /**
            * Move the focus from one control to another.
            * @param elementID - The current element id.
            * @param isForward - The boolean value indicate if we move focus to the next control according to the tabindex value.
            * @param isUseLeftRightKey - The boolean value indicate if we move focus to the next control by left or right key.
            * @param exitType - The exit type.
            */
            BaseUIProcess.prototype.MoveControl = function (currentElement, isForward, isUseLeftRightKey, exitType) {
                var elements = input.CoreUtility.GetElements();
                var ret = null;
                var retInfo = {};

                //Add by Ryan Wu at 10:24 Jan. 20 2006.
                //For fix bug#4965.
                if (elements.length < 2) {
                    return null;
                }

                //Add comments by Ryan Wu at 14:08 Aug. 28 2007.
                //For the sequence of the onfocus, onblur, onkeydown event in firefox is not same as IE
                //when we use the focus method in keydown.
                //in IE: onkeydown --> onblur --> onfocus.
                //in Firefox: onblur --> onfocus --> onkeydown.
                //So we must split the MoveFocus into two methods. Firstly, We must get the next control's id.
                //Then if we use the ExitOnLeftRightKey to move focus, we should set the next control's FocusType to FocusType.Left/FocusType.Right.
                //Lastly we can invoke the obj.focus method to set focus to the next control.
                //	var nextID = Utility.MoveFocus(elementID, elements, isForward);
                //
                //	if (isUseLeftRightKey == true)
                //	{
                //		try
                //		{
                //		    var index = nextID.LastIndexOf("_EditField");
                //
                //		    if (index != -1)
                //		    {
                //		        var conID = nextID.Substring(0, index);
                //		        var nextObj = FindIMControl(conID);
                //		        nextObj.FocusType = isForward ? FocusType.Left : FocusType.Right;
                //		    }
                //		}
                //		catch(e)
                //		{}
                //    }
                var nextElement = input.CoreUtility.GetNextFocusableControl(currentElement, elements, isForward);

                // TODO:
                //if (isUseLeftRightKey == true) {
                //    try {
                //        var index = nextID.LastIndexOf("_EditField");
                //        if (index != -1) {
                //            var conID = nextID.Substring(0, index);
                //            var nextObj = FindIMControl(conID);
                //            nextObj.FocusType = isForward ? FocusType.Left : FocusType.Right;
                //        }
                //        else {
                //            var nextObj = FindIMControl(nextID);
                //            if (nextObj) {
                //                if (nextObj.IsjQueryControl == true) {
                //                    nextObj.FocusType = isForward ? FocusType.Left : FocusType.Right;
                //                }
                //            }
                //        }
                //    }
                //    catch (e)
                //    { }
                //}
                // change by Sean Huang at 2008.12.16, for bug 1054 -->
                //Utility.SetElementFocus(nextID);
                // change by Sean Huang at 2009.01.04, for bug 1402 -->
                //if (exitType == "CharInput")
                // change by Sean Huang at 2009.02.16, for bug 1863, 1865 -->
                //if (exitType == "CharInput" || (!isIE && isUseLeftRightKey))
                if (exitType == "CharInput" || (!input.CoreUtility.IsIE())) {
                    Utility.NextID = nextElement;
                    setTimeout(function () {
                        input.CoreUtility.SetElementFocus(nextElement);
                    }, 0);
                } else {
                    input.CoreUtility.SetElementFocus(nextElement);
                }

                // end of Sean Huang <--
                // add by Sean Huang at 2008.12.09, for bug 1057, 1058 -->
                // set the cursor position of the standard text box while it is get focus
                // by using the left right key.
                if (isUseLeftRightKey) {
                    var obj = document.getElementById(nextElement);
                    if (obj != null && (obj.tagName.toLowerCase() == "textarea" || obj.type == "text")) {
                        if (input.CoreUtility.IsIE()) {
                            var range = obj.createTextRange();
                            if (exitType == "Left" || exitType == "CtrlLeft") {
                                // move the cursor position to the end
                                range.moveStart('character', obj.value.length);
                                range.select();
                            }
                            //else if (exitType == "Right" || exitType == "CtrlRight")
                            //{
                            //    // ie will move the cusor position to the begin by default
                            //}
                        }
                        // HelenLiu 2013/06/24 fix bug 743 in IM HTML5.
                        //else {
                        //    if (exitType == "Left" || exitType == "CtrlLeft") {
                        //        // move the cursor to the end
                        //        var len = obj.value.length;
                        //        obj.setSelectionRange(len, len);
                        //    }
                        //else if (exitType == "Right" || exitType == "CtrlRight") {
                        //     //move the cursor to the begin
                        //    obj.setSelectionRange(0, 0);
                        //}
                        //}
                    }
                }

                // end of Sean Huang, for bug 1057, 1058<--
                //end by Ryan Wu.
                //invoke the KeyExit Event if it exit
                var eArgs = { Key: 9 /* CharInput */ };

                switch (exitType) {
                    case "NextControl":
                        eArgs.Key = 3 /* NextControl */;
                        break;
                    case "PreviousControl":
                        eArgs.Key = 4 /* PreviousControl */;
                        break;
                    case "Right":
                        eArgs.Key = 5 /* Right */;
                        break;
                    case "Left":
                        eArgs.Key = 6 /* Left */;
                        break;
                    case "CtrlRight":
                        eArgs.Key = 7 /* CtrlRight */;
                        break;
                    case "CtrlLeft":
                        eArgs.Key = 8 /* CtrlLeft */;
                        break;
                    case "CharInput":
                        eArgs.Key = 9 /* CharInput */;
                        break;
                }

                ret = {};
                ret.Name = this.Owner.KeyExitEvent;
                ret.Args = eArgs;

                //Add comments by Ryan Wu at 10:27 Apr. 5 2007.
                //For support Aspnet Ajax 1.0.
                ret.Type = "KeyExit";

                //end by Ryan Wu.
                if (ret != null) {
                    retInfo.EventInfo = ret;
                }

                return retInfo;
            };

            /**
            * Move the caret from one field to another in the control.
            * @param pos - The current caret position.
            * @param isForward - The boolean value indicate if we move caret to the next field or previous field.
            */
            BaseUIProcess.prototype.MoveField = function (pos, isForward) {
                var nextPos = this.Format.Fields.MoveField(pos, isForward);
                var retInfo = {};

                if (nextPos == -1) {
                    retInfo.NextPos = nextPos;
                    return retInfo;
                }

                retInfo.SelectionStart = nextPos;
                retInfo.SelectionEnd = nextPos;
                return retInfo;
            };

            /**
            * Process Tab key press event.
            * @param isForward - The boolean value indicate if we move caret to the forward or backward.
            */
            BaseUIProcess.prototype.ProcessTabKey = function (pos, isForward, tabAction) {
                //invoke the KeyExit Event if it exit
                var eArgs = { Key: 1 /* Tab */ };
                var retInfo = {};
                if (isForward) {
                    eArgs.Key = 1 /* Tab */;
                } else {
                    eArgs.Key = 2 /* ShiftTab */;
                }

                var eventInfo = {};
                eventInfo.Name = this.Owner.KeyExitEvent;
                eventInfo.Args = eArgs;

                //Add comments by Ryan Wu at 10:27 Apr. 5 2007.
                //For support Aspnet Ajax 1.0.
                eventInfo.Type = "KeyExit";

                //end by Ryan Wu.
                retInfo.EventInfo = eventInfo;

                retInfo.FocusType = 4 /* KeyExit */;
                retInfo.System = true;

                return retInfo;
            };

            /**
            * Move caret between fields then move focus to the next control if caret is in the edge
            * of the control.
            * @param isForward - The boolean value indicate if we move caret to the forward or backward.
            */
            BaseUIProcess.prototype.MoveFieldAndControl = function (pos, isForward) {
                var retInfo = this.MoveField(pos, isForward);

                //retInfo.NextPos == -1 indicate that we have move the caret to the edge of the control.
                if (retInfo.NextPos != -1) {
                    return retInfo;
                }

                var exitType = isForward ? "NextControl" : "PreviousControl";
                var ret = this.MoveControl(this.GetInputElement(), isForward, false, exitType);

                if (ret != null) {
                    retInfo.EventInfo = ret.EventInfo;
                    retInfo.FocusType = ret.FocusType;
                    retInfo.FocusExit = true;
                }

                return retInfo;
            };

            /**
            * Handle the ondragstart event.
            */
            BaseUIProcess.prototype.DragStart = function () {
            };

            /**
            * Handle the ondragend event.
            */
            BaseUIProcess.prototype.DragEnd = function () {
            };

            /**
            * Handle the ondrop event.
            */
            BaseUIProcess.prototype.Drop = function () {
            };

            /**
            * Handle the ondragover event.
            */
            BaseUIProcess.prototype.DragOver = function () {
            };

            /**
            * Parse the shortcutsString and judge whether the key user pressed
            * is a shortcutkey defined by deveploper.
            * not replace indexOf, substring method, because autotest is slow
            * @param keyCode - The specified keyCode will be checked.
            * @param strShortcut - The shortcuts string passed from the server side.
            * @returns Returns the shortcut's keyAction Name if contains the specified
            *          keyCode action; else return null.
            */
            BaseUIProcess.prototype.GetKeyActionName = function (keyCode, strShortcut) {
                if (strShortcut == null) {
                    return null;
                }

                var s = strShortcut;
                var shortcuts = new Array();
                var index = s.IndexOf(",");
                var i = 0;

                if (strShortcut != "") {
                    while (index != -1) {
                        shortcuts[i++] = s.Substring(0, index);
                        s = s.Substring(index + 1, s.GetLength());
                        index = s.IndexOf(",");
                    }
                    shortcuts[i++] = s;

                    for (var j = 0; j < i; j = j + 2) {
                        if (this.IsKeyCodeContained(keyCode, shortcuts[j + 1])) {
                            return shortcuts[j];
                        }
                    }
                }
                return null;
            };

            /**
            * Judge whether the keyCode is contained in the shortcuts's item.
            * @param keyCode - The specified keyCode will be checked.
            * @param shortcut - The shortcuts's item.
            * @returns Returns true if contains the specified keyCode action; else return false.
            */
            BaseUIProcess.prototype.IsKeyCodeContained = function (keyCode, shortcut) {
                var s = shortcut;
                var index = s.IndexOf("|");

                while (index != -1) {
                    if (s.Substring(0, index) == keyCode) {
                        return true;
                    }
                    s = s.Substring(index + 1, s.GetLength());
                    index = s.IndexOf("|");
                }

                if (s == keyCode) {
                    return true;
                }

                return false;
            };

            /**
            *fire event
            */
            BaseUIProcess.prototype.FireClientEvent = function (evenType) {
                // TODO:
            };

            BaseUIProcess.prototype.PerformSpin = function (curpos, increment, wrap) {
            };

            /**
            * update crlf string for AcceptsCrLf property
            */
            BaseUIProcess.UpdateCrLfString = function (text, crlfMode) {
                var ret = text;

                if (text) {
                    if (crlfMode == 1 /* Filter */) {
                        ret = text.replace(new RegExp("[\r\n]", "g"), "");
                    } else if (crlfMode == 2 /* Cut */) {
                        var splits = text.split(new RegExp("[\r\n]", "g"));
                        if (splits.length > 0) {
                            ret = splits[0];
                        } else {
                            ret = "";
                        }
                    }
                }

                return ret;
            };

            BaseUIProcess.FilterReturnChar = function (text) {
                if (text != null) {
                    text = text.replace(new RegExp("[\r]", "g"), "");
                }
                return text;
            };
            return BaseUIProcess;
        })();
        input.BaseUIProcess = BaseUIProcess;

        

        /** @ignore */
        var InputUIUpdate = (function () {
            function InputUIUpdate(owner) {
                this.Owner = owner;
            }
            InputUIUpdate.prototype.SetLastClientValues = function (text) {
                //var obj = document.getElementById(this.ID + Utility.LastClientValuesID);
                //if (obj != null) {
                //    obj.value = text;
                //}
                //this.lastclientvalues = text;
            };

            InputUIUpdate.prototype.GetText = function () {
                if (this.Owner.GetInputElement() != null) {
                    return this.Owner.GetInputElement().value;
                }
            };

            InputUIUpdate.prototype.SetText = function (text) {
                if (this.GetText() == null) {
                    return;
                }

                if (this.GetText().replace(/\r\n/g, "\n") == text.replace(/\r\n/g, "\n")) {
                    return;
                }

                if (this.Owner.GetInputElement() != null) {
                    this.Owner.GetInputElement().value = text;
                }
            };

            InputUIUpdate.prototype.SetFocus = function () {
                try  {
                    if (this.Owner.GetInputElement() != null) {
                        this.Owner.GetInputElement().focus();
                    }
                } catch (e) {
                }
            };

            InputUIUpdate.prototype.GetTextHAlign = function () {
                if (this.Owner.GetInputElement() !== null) {
                    return this.Owner.GetInputElement().style.textAlign;
                }
                return "";
            };

            InputUIUpdate.prototype.SetTextHAlign = function (value) {
                if (this.Owner.GetInputElement() !== null) {
                    this.Owner.GetInputElement().style.textAlign = value;

                    if (input.CoreUtility.IsIE()) {
                        // Change the width to trigger the layout, to make this property take affect immediately.
                        var old = this.Owner.GetInputElement().style.width;
                        var length = parseInt(old);
                        if (isNaN(length)) {
                            length = 120;
                        }
                        this.Owner.GetInputElement().style.width = length + 1 + "px";
                        var self = this;
                        setTimeout(function () {
                            self.InputElement.style.width = old;
                        }, 0);
                    }
                }
            };

            InputUIUpdate.prototype.SetForeColor = function (foreColor) {
                if (this.Owner.GetInputElement() != null) {
                    this.Owner.GetInputElement().style.color = foreColor;
                }
            };

            InputUIUpdate.prototype.WriteCssStyle = function (style) {
                try  {
                    var styleContainer = document.getElementById('gcsh_InputManWeb_Style_Container');

                    if (input.CoreUtility.IsIE()) {
                        styleContainer.styleSheet.cssText = style;
                    } else {
                        var sheet = styleContainer.sheet;

                        for (var i = sheet.cssRules.length - 1; i >= 0; i--) {
                            sheet.deleteRule(i);
                        }

                        var ruleLines = style.split('}');

                        for (var j = 0; j < ruleLines.length; j++) {
                            var rule = ruleLines[j];
                            var index = rule.indexOf('{');

                            if (index == -1) {
                                continue;
                            }

                            var style = rule.substring(index + 1);

                            if (style.length != 0) {
                                var selector = rule.substring(0, index);
                                sheet.insertRule(selector + '{' + style + '}', sheet.cssRules.length);
                            }
                        }
                    }
                } catch (e) {
                }
            };

            InputUIUpdate.prototype.ClearCssStyle = function () {
            };
            return InputUIUpdate;
        })();
        input.InputUIUpdate = InputUIUpdate;

        /** @ignore */
        var GlobalEventHandler = (function () {
            function GlobalEventHandler() {
            }
            GlobalEventHandler.OnKeyDown = function (control, evt, forShortcutExtender) {
                if (control.ImeMode === true && !input.CoreUtility.IsIE8OrBelow()) {
                    return;
                }

                // debugger;
                var k = evt.keyCode;

                //Add comments by Jiang Changcheng at Sep. 9 2008
                //Add the fake key for Shortcut Extender
                if (forShortcutExtender) {
                    k |= 524288;
                }

                //End by Jiang Changcheng
                var funcKeysPressed = {};
                funcKeysPressed.Shift = false;
                funcKeysPressed.Ctrl = false;
                funcKeysPressed.Alt = false;
                if (evt.shiftKey) {
                    funcKeysPressed.Shift = true;
                }

                if (evt.ctrlKey) {
                    funcKeysPressed.Ctrl = true;
                }

                if (evt.altKey) {
                    funcKeysPressed.Alt = true;
                }
                var useSystem = null;

                //Add comments by Ryan Wu at 16:55 Sep. 11 2007.
                //For fix the bug "17. Ctrl+Click(select all text) will take no effects(firefox).".
                Utility.FuncKeysPressed = funcKeysPressed;

                try  {
                    useSystem = control.KeyDown(evt);
                } catch (e) {
                }

                //Added by Jeff for Edit
                if (useSystem != null && useSystem.KeyCode != null) {
                    // Add comments by Yang at 11:44 Sep. 5th 2007
                    // For event.keyCode is readonly in firefox.
                    // Firefox doesn't support some shortcuts.
                    //event.keyCode = useSystem.KeyCode;
                    if (input.CoreUtility.IsIE()) {
                        evt.keyCode = useSystem.KeyCode;
                    }

                    // End by Yang
                    //Add comments by Ryan Wu at 15:35 Aug. 13 2007.
                    //For in firefox, even if we set the event.returnValue = false in keydown event,
                    //the keypress event will also be invoked while in IE will not.
                    if (!input.CoreUtility.IsIE()) {
                        Utility.ShouldInvokeKeyPress = false;
                    }

                    //end by Ryan Wu.
                    return;
                }

                //Add comments by Ryan Wu at 15:35 Aug. 13 2007.
                //For in firefox, even if we set the event.returnValue = false in keydown event,
                //the keypress event will also be invoked while in IE will not.
                //	if (!useSystem)
                //	{
                //		event.returnValue = false;
                //	    //event.cancelBubble = true;
                //	}
                if (!useSystem) {
                    Utility.PreventDefault(evt);

                    //event.cancelBubble = true;
                    if (!input.CoreUtility.IsIE()) {
                        Utility.ShouldInvokeKeyPress = false;
                    }
                } else {
                    if (!input.CoreUtility.IsIE()) {
                        Utility.ShouldInvokeKeyPress = true;
                    } else if (evt != null) {
                        evt.returnValue = true;
                    }
                }
            };

            GlobalEventHandler.OnKeyPress = function (control, evt) {
                // Ctrl + X, Ctrl + V, Ctrl + C.
                if ((evt.charCode === 118 || evt.charCode === 120 || evt.charCode === 99) && evt.ctrlKey) {
                    // Fire fox 's paste behavior will run at here.
                    return;
                }

                if (input.CoreUtility.IPad && evt.charCode > 256) {
                    // DaryLuo 2013/05/22 fix bug 414, on the ipad, when the charCode is greater than 256, the compoistion event will fired, so here we don't process.
                    return;
                }

                if (evt.keyCode == 46 && evt.shiftKey) {
                    // FireFox Shift + Delete will run at here.  Cut operation.
                    return;
                }

                if (control.ImeMode === true) {
                    return;
                }
                var obj = control;

                if (!input.CoreUtility.IsIE() && (evt.charCode == 0 || !Utility.ShouldInvokeKeyPress)) {
                    if (!Utility.ShouldInvokeKeyPress || ((evt.keyCode == 38 || evt.keyCode == 40) && obj.Type != "Edit")) {
                        Utility.ShouldInvokeKeyPress = true;
                        Utility.PreventDefault(evt);

                        // Add comments by Yang at 20:15 October 15th 2007
                        // For fix the bug 9047
                        if (obj != null && obj.Type == "Edit" && obj.DropDownObj != null && obj.DropDownObj.IsKeyFromDropDown) {
                            obj.DropDownObj.IsKeyFromDropDown = false;
                        }

                        // End by Yang
                        return;
                    } else if (!(evt.keyCode == 13 && obj.Type == "Edit")) {
                        return;
                    }
                }

                var keyCode = evt.keyCode || evt.charCode;

                if (keyCode != 13 || obj.Type == "Edit") {
                    var str = String.fromCharCode(keyCode);

                    try  {
                        if (input.CharProcess.CharEx.IsSurrogate(str.charAt(0))) {
                            // DaryLuo 2012/09/17 fix bug 630 in IM Web 7.0, do it in keyup.
                            obj.IsSurrogateKeyPressing = true;
                            return;
                        }
                    } catch (e) {
                    }
                    if (str != null) {
                        var useSystem = null;

                        try  {
                            useSystem = GlobalEventHandler.CallKeyPress(control, str, evt);
                        } catch (e) {
                        }
                    }
                    if (!useSystem) {
                        Utility.PreventDefault(evt);

                        //event.cancelBubble = true;
                        return;
                    }
                }
            };

            GlobalEventHandler.CallKeyPress = function (control, str, evt) {
                if (input.CoreUtility.IsPad()) {
                    control.HasInput = true;
                    return true;
                } else {
                    var useSystem = control.KeyPress(str, evt);
                    return useSystem;
                }
            };

            GlobalEventHandler.OnKeyUp = function (control, evt) {
                if (control.ImeMode === true && !input.CoreUtility.IsIE8OrBelow()) {
                    return;
                }
                try  {
                    var imControl = control;
                    if (imControl.IsSurrogateKeyPressing) {
                        try  {
                            if (imControl.InputElement != null) {
                                var value = imControl.InputElement.value;
                                var selectionStart = imControl.InputElement.selectionStart;
                                var str = value.substr(selectionStart - 2, selectionStart);
                                imControl.KeyPress(str, evt);
                            }
                        } finally {
                            imControl.IsSurrogateKeyPressing = false;
                        }
                    }

                    //Add comments by Ryan Wu at 16:55 Sep. 11 2007.
                    //For fix the bug "17. Ctrl+Click(select all text) will take no effects(firefox).".
                    Utility.FuncKeysPressed = { Shift: evt.shiftKey, Ctrl: evt.ctrlKey, Alt: evt.altKey };

                    //end by Ryan Wu.
                    imControl.KeyUp(evt);
                    //event.cancelBubble = true;
                } catch (e) {
                }
            };

            GlobalEventHandler.OnCompositionStart = function (control, evt) {
                try  {
                    if (input.CoreUtility.IsPad()) {
                        control.ImeMode = true;
                        return;
                    }
                    control.CompositionStart(evt);
                } catch (e) {
                }
            };

            GlobalEventHandler.OnCompositionUpdate = function (control, evt) {
                try  {
                    if (input.CoreUtility.IsPad()) {
                        return;
                    }
                    control.CompositionUpdate(evt);
                } catch (e) {
                }
            };

            GlobalEventHandler.OnCompositionEnd = function (control, evt) {
                try  {
                    if (input.CoreUtility.IsPad()) {
                        control.HasInput = true;
                        control.ImeMode = false;
                        return;
                    }
                    control.CompositionEnd(evt);
                } catch (e) {
                }
            };

            GlobalEventHandler.OnInput = function (control, evt) {
                try  {
                    if (control.ImeMode === true || control.HasInput !== true) {
                        return;
                    }
                    control.ImeMode = true;
                    control.HasInput = false;
                    control.Input(evt);
                } catch (e) {
                }
            };

            GlobalEventHandler.OnMouseOver = function (control, evt) {
                try  {
                    if (control.MouseOver) {
                        control.MouseOver();
                    }
                } catch (e) {
                }
            };

            GlobalEventHandler.OnMouseOut = function (control, evt) {
                try  {
                    control.MouseOut();
                } catch (e) {
                }
            };

            GlobalEventHandler.OnMouseMove = function (control, evt) {
                try  {
                    if (control.MouseMove) {
                        control.MouseMove(evt);
                    }
                } catch (e) {
                }
            };

            GlobalEventHandler.OnMouseDown = function (control, evt) {
                if (control.ImeMode && control.ImeMode === true && !input.CoreUtility.IsIE8OrBelow()) {
                    return;
                }
                try  {
                    control.MouseDown(evt);

                    if (!input.CoreUtility.IsIE()) {
                        Utility.DragStartElementID = control;
                    }
                } catch (e) {
                }
            };

            GlobalEventHandler.OnMouseUp = function (imControl, evt) {
                if (imControl.ImeMode && imControl.ImeMode === true && !input.CoreUtility.IsIE8OrBelow()) {
                    return;
                }
                try  {
                    // DaryLuo 2013/07/12 fix bug 933, 934 in IM HTML 5.
                    if (imControl.MouseUpPointerType != null && imControl.MouseUpPointerType !== 4 && imControl.MouseUpPointerType !== "mouse") {
                        var evtClone = {};
                        for (var item in evt) {
                            evtClone[item] = evt[item];
                        }
                        setTimeout(function (parameters) {
                            imControl.MouseUp(evtClone);
                        }, 300);
                    } else {
                        imControl.MouseUp(evt);
                    }

                    if (!input.CoreUtility.IsIE()) {
                        Utility.DragStartElementID = "";
                    }
                } catch (e) {
                }
            };

            GlobalEventHandler.OnSelectStart = function (control, evt) {
                if (Utility.InnerSelect === true && Utility.ShouldFireOnSelectStart == false) {
                    Utility.CancelBubble(evt);
                }

                var selText = Utility.GetSelectionText(control.GetInputElement());

                if (typeof (selText) == "undefined" || selText == null) {
                    selText = "";
                }
                var useSystem = null;

                try  {
                    useSystem = control.SelectStart(selText);
                } catch (e) {
                }

                if (useSystem == false) {
                    Utility.PreventDefault(evt);
                }
            };

            GlobalEventHandler.OnDblClick = function (control, evt) {
                var useSystem = null;
                try  {
                    useSystem = control.DoubleClick();
                } catch (e) {
                }

                if (!useSystem) {
                    Utility.PreventDefault(evt);
                }
            };

            GlobalEventHandler.OnHTML5BeforeCopy = function (control, evt) {
                try  {
                    Utility.CutCopyPasteEventObject = evt ? evt.originalEvent : evt;
                    control.Copy(evt);
                } catch (e) {
                } finally {
                    Utility.CutCopyPasteEventObject = null;
                }
            };

            GlobalEventHandler.OnHTML5Cut = function (control, evt) {
                try  {
                    var inputElement = control.GetInputElement();
                    var text = inputElement.value;
                    var selStart = inputElement.selectionStart;
                    var selEnd = inputElement.selectionEnd;
                    setTimeout(function () {
                        inputElement.value = text;
                        inputElement.selectionStart = selStart;
                        inputElement.selectionEnd = selEnd;
                        control.Cut(evt);
                    }, 0);
                    // Let browser do it.
                } catch (e) {
                }
            };

            GlobalEventHandler.OnHTML5Paste = function (control, evt) {
                try  {
                    // DaryLuo 2013/05/21, the paste operation doesn't take effect on the android chrome.
                    if (input.CoreUtility.chrome && input.CoreUtility.GetClientOS().toLowerCase() !== "android") {
                        Utility.CutCopyPasteEventObject = evt ? evt.originalEvent : evt;

                        control.Paste(Utility.GetDataFromClipboard(true));
                        Utility.PreventDefault(evt);
                    } else {
                        var selStart = control.SelectionStart;
                        var selEnd = control.SelectionEnd;
                        setTimeout(function () {
                            if (input.CoreUtility.GetClientOS().toLowerCase() === "android") {
                                // DaryLuo 2013/05/27 fix bug 371 in IM HTML5.0.
                                control.SelectionStart = selStart;
                                control.SelectionEnd = selEnd;
                            }

                            control.isPasting = true;

                            // Firefox & android chrome will run at here.
                            control.ImeInput("DirectInput");
                        }, 0);
                    }
                } catch (e) {
                } finally {
                    Utility.CutCopyPasteEventObject = null;
                }
            };

            GlobalEventHandler.OnMouseWheel = function (control, evt) {
                try  {
                    control.MouseWheel(evt);
                    if (control.ShouldCancelMouseWheelDefaultBehavior()) {
                        Utility.PreventDefault(evt);
                    }
                } catch (e) {
                }
            };

            GlobalEventHandler.OnDragStart = function (control, evt) {
                try  {
                    control.DragStart();
                } catch (e) {
                }
            };

            GlobalEventHandler.OnDragEnd = function (control, evt) {
                try  {
                    control.DragEnd(evt);
                } catch (e) {
                }
            };

            GlobalEventHandler.OnDrop = function (control, evt) {
                try  {
                    var text = evt.originalEvent.dataTransfer.getData("Text");
                    control.DragDrop(text, evt);
                } catch (e) {
                }
            };

            GlobalEventHandler.OnTouchStart = function (control, evt) {
                Utility.TouchStartTime = new Date();
                Utility.TouchStartEvt = evt;
            };

            GlobalEventHandler.OnTouchEnd = function (control, evt) {
                if (Utility.TouchStartTime !== undefined) {
                    Utility.TouchEndTime = new Date();
                    var offset = Utility.TouchEndTime.valueOf() - Utility.TouchStartTime.valueOf();
                    if (offset > 1000) {
                        var text = "";
                        try  {
                            text = Utility.GetSelectionText(control.GetInputElement());
                        } catch (e) {
                        }
                        control.ShowContextMenu(text, Utility.TouchStartEvt);
                        if (control.GetEnabled()) {
                            Utility.PreventDefault(evt);
                        }
                    }
                    Utility.TouchStartTime = undefined;
                    Utility.TouchEndTime = undefined;
                }
            };

            GlobalEventHandler.OnDragEnter = function (control, evt) {
                try  {
                    control.DragEnter();
                } catch (e) {
                }
            };

            GlobalEventHandler.OnDragLeave = function (control, evt) {
                try  {
                    control.DragLeave();
                } catch (e) {
                }
            };

            GlobalEventHandler.OnSelect = function (control, evt) {
                try  {
                    if (input.CoreUtility.IsPad() && control.ImeMode) {
                        return;
                    }
                    if (control && control.Focused) {
                        control.Select();
                    }
                } catch (e) {
                }
            };

            GlobalEventHandler.OnPropertyChanged = function (control, evt) {
                try  {
                    control.PropertyChange(evt);
                } catch (e) {
                }
            };

            GlobalEventHandler.OnMSPointerUp = function (control, evt) {
                control.MSPointerUp(evt);
            };

            GlobalEventHandler.OnMSPointerDown = function (control, evt) {
                try  {
                    control.MSPointerDown(evt);
                } catch (e) {
                }
            };

            GlobalEventHandler.OnMSGestureTap = function (control, evt) {
                try  {
                    control.MSGestureTap(evt);
                } catch (e) {
                }
            };

            GlobalEventHandler.OnEditFieldFocus = function (control, evt) {
                if (Utility.IsFocusFromIMControl(control._id, evt)) {
                    if (input.CoreUtility.IsIE() || Utility.HasGetFocus) {
                        return;
                    }
                }

                //if (!Utility.firefox) {
                //    if (Utility.IsOnFocus) {
                //        if (GrapeCity.IM.Utility.IsIE() && Utility.IsOnActivate || Utility.HasGetFocus) {
                //            return;
                //        }
                //    }
                //}
                Utility.IsOnFocus = true;
                if (!input.CoreUtility.IsIE()) {
                    Utility.HasGetFocus = true;
                }
                this.OnFocus(control, evt);
                //onFocus(id);
                //Utility.FireEvent(document.getElementById(id), eventName, null);
                // end of Sean Huang <--
            };

            GlobalEventHandler.OnEditFieldLoseFocus = function (control, evt) {
                try  {
                    //function gcsh_InputManWeb_onLoseFocus(eventName, id) {
                    var obj = control;

                    if (obj != null && obj.Type == "Edit" && obj.IsFocusToDropDownEdit) {
                        obj.IsFocusToDropDownEdit = false;
                        return;
                    }

                    // Temporarily comment at 2013/08/13.
                    //if (!Utility.IsIE() && obj != null && obj.IMControlType == "Date" && obj.DropDownObj != null) {
                    //    if (Utility.IsFireFox4OrLater()) {
                    //        if (obj.DropDownObj.IsNavigateMouseDown) {
                    //            obj.DropDownObj.IsNavigateMouseDown = null;
                    //            return;
                    //        }
                    //        if (obj.DropDownObj.IsZoomButtonMouseDown) {
                    //            obj.DropDownObj.IsZoomButtonMouseDown = null;
                    //            return;
                    //        }
                    //    }
                    //    if (obj.DropDownObj.IsHeaderMouseDown) {
                    //        obj.DropDownObj.IsHeaderMouseDown = null;
                    //        return;
                    //    }
                    //}
                    if (Utility.IsFocusToIMControl(control._id, evt)) {
                        return;
                    }

                    if (input.CoreUtility.firefox) {
                        if (Utility.IsOnFocus && input.CoreUtility.IsIE() && Utility.IsOnActivate && Utility.IsOnActivateControlID == control._id) {
                            if (Utility.FocusToBorder != null && Utility.FocusToBorder == true) {
                                Utility.FocusToBorder = false;
                                obj.SetInnerFocus();
                            }

                            return;
                        }

                        Utility.FocusToBorder = false;

                        if (!input.CoreUtility.IsIE()) {
                            Utility.HasGetFocus = false;
                        } else {
                            Utility.IsOnFocus = false;
                        }
                    }

                    GlobalEventHandler.OnLostFocus(control, evt);

                    Utility.FuncKeysPressed = { Shift: false, Ctrl: false, Alt: false };
                    //Utility.FireEvent(control, "LoseFocus", null);
                } catch (e) {
                }
            };

            GlobalEventHandler.OnFocusOut = function (control, evt) {
                Utility.FocusToBorder = false;

                if (input.CoreUtility.IsIE()) {
                    if (evt.toElement) {
                        var toID = evt.toElement.id;
                        if (toID == control._id + "_Inside_Div_Container") {
                            Utility.FocusToBorder = true;
                        }
                    }
                }

                if (Utility.IsFocusToIMControl(control._id, evt)) {
                    if (input.CoreUtility.IsIE9OrLater()) {
                        Utility.IsOnActivate = true;
                        Utility.IsOnActivateControlID = control._id;
                        Utility.IsOnFocus = true;
                    }
                    return;
                }
                if (input.CoreUtility.IsIE() && Utility.IsOnActivate) {
                    Utility.IsOnActivate = false;
                    Utility.IsOnActivateControlID = "";
                }
                if (Utility.IsOnFocus) {
                    Utility.IsOnFocus = false;
                }
            };

            GlobalEventHandler.OnActivate = function (control, evt) {
                Utility.IsOnActivate = true;
                Utility.IsOnActivateControlID = control._id;

                if (Utility.IsFocusFromIMControl(control._id, evt)) {
                    return;
                }

                Utility.IsOnActivate = true;
                Utility.IsOnActivateControlID = control._id;
            };

            GlobalEventHandler.OnDeActivate = function (control, evt) {
                if (Utility.IsFocusToIMControl(control._id, evt)) {
                    return;
                }

                Utility.IsOnActivate = false;
                Utility.IsOnActivateControlID = "";

                Utility.IsOnFocus = false;
            };

            GlobalEventHandler.OnFocus = function (control, evt) {
                try  {
                    var handler = function () {
                        control.Focus();
                        control.Focused = true;

                        if (input.CoreUtility.IsPad()) {
                            // DaryLuo 2013/05/27 fix bug 412 in IM HTML 5.0.
                            control.IPadSelectionRefreshTimer = setInterval(function (evt) {
                                GlobalEventHandler.OnSelect(control, evt);
                            }, 400);
                        }
                    };
                    if (input.CoreUtility.IsIE()) {
                        handler.call(this);
                    } else {
                        setTimeout(handler, 0);
                    }
                } catch (e) {
                }
            };

            GlobalEventHandler.OnLostFocus = function (control, evt) {
                try  {
                    control.LoseFocus(evt);
                    control.Focused = false;

                    if (input.CoreUtility.IsPad()) {
                        clearInterval(control.IPadSelectionRefreshTimer);
                    }
                } catch (e) {
                }
            };
            return GlobalEventHandler;
        })();
        input.GlobalEventHandler = GlobalEventHandler;
    })(wijmo.input || (wijmo.input = {}));
    var input = wijmo.input;
})(wijmo || (wijmo = {}));

;
/// <reference path="../External/declarations/jquery.d.ts"/>
/// <reference path="../External/declarations/globalize.d.ts"/>
/// <reference path="../wijutil/jquery.wijmo.wijutil.ts"/>
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var wijmo;
(function (wijmo) {
    /*
    * Depends:
    *	jquery-1.11.1.js
    *	globalize.js
    *  jquery.wijmo.wijutil.js
    *
    */
    (function (input) {
        /** @ignore */
        function paddingZero(val, aCount) {
            if (typeof aCount === "undefined") { aCount = 2; }
            var text = '' + val + '';
            if (text.length > aCount) {
                text = text.substr(text.length - aCount);
            } else
                while (text.length < aCount) {
                    text = '0' + text;
                }
            return text;
        }
        input.paddingZero = paddingZero;

        (function (DescriptorType) {
            DescriptorType[DescriptorType["liternal"] = -1] = "liternal";

            DescriptorType[DescriptorType["OneDigitYear"] = 1] = "OneDigitYear";
            DescriptorType[DescriptorType["TwoDigitYear"] = 2] = "TwoDigitYear";
            DescriptorType[DescriptorType["FourDigitYear"] = 10] = "FourDigitYear";

            DescriptorType[DescriptorType["TwoDigitMonth"] = 20] = "TwoDigitMonth";
            DescriptorType[DescriptorType["Month"] = 25] = "Month";
            DescriptorType[DescriptorType["AbbreviatedMonthNames"] = 26] = "AbbreviatedMonthNames";
            DescriptorType[DescriptorType["MonthNames"] = 27] = "MonthNames";

            DescriptorType[DescriptorType["EraYear"] = 70] = "EraYear";
            DescriptorType[DescriptorType["TwoEraYear"] = 71] = "TwoEraYear";
            DescriptorType[DescriptorType["EraName"] = 72] = "EraName";
            DescriptorType[DescriptorType["TwoEraName"] = 73] = "TwoEraName";
            DescriptorType[DescriptorType["ThreeEraName"] = 74] = "ThreeEraName";
            DescriptorType[DescriptorType["EraYearBig"] = 75] = "EraYearBig";

            DescriptorType[DescriptorType["AD"] = 80] = "AD";

            DescriptorType[DescriptorType["TwoDigityDayOfMonth"] = 30] = "TwoDigityDayOfMonth";
            DescriptorType[DescriptorType["DayOfMonth"] = 31] = "DayOfMonth";
            DescriptorType[DescriptorType["AbbreviatedDayNames"] = 100] = "AbbreviatedDayNames";
            DescriptorType[DescriptorType["DayNames"] = 101] = "DayNames";

            DescriptorType[DescriptorType["h"] = 45] = "h";
            DescriptorType[DescriptorType["hh"] = 46] = "hh";
            DescriptorType[DescriptorType["H"] = 47] = "H";
            DescriptorType[DescriptorType["HH"] = 48] = "HH";

            DescriptorType[DescriptorType["ShortAmPm"] = 250] = "ShortAmPm";
            DescriptorType[DescriptorType["AmPm"] = 251] = "AmPm";

            DescriptorType[DescriptorType["mm"] = 50] = "mm";
            DescriptorType[DescriptorType["m"] = 51] = "m";

            DescriptorType[DescriptorType["ss"] = 60] = "ss";
            DescriptorType[DescriptorType["s"] = 61] = "s";
        })(input.DescriptorType || (input.DescriptorType = {}));
        var DescriptorType = input.DescriptorType;

        ////////////////////////////////////////////////////////////////////////////////
        // _iDateDescriptor
        /** @ignore */
        var _iDateDescriptor = (function () {
            function _iDateDescriptor(textProvider, id) {
                this.id = id;
                this.startIndex = 0;
                this.name = null;
                this.type = -1 /* liternal */;
                this.maxLen = 2;
                this.formatString = "";
                this._txtProvider = textProvider;
                this.startIndex = 0;
            }
            _iDateDescriptor.prototype.getText = function () {
                return null;
            };

            _iDateDescriptor.prototype.getRealText = function (text) {
                var opt = this._txtProvider.inputWidget.options;
                if (opt.date == null) {
                    if (opt.promptChar !== '') {
                        var tmp = '';
                        for (var i = 0; i < this.formatString.length; i++) {
                            tmp += opt.promptChar;
                        }
                        return tmp;
                    }
                    return this.formatString;
                }
                return text;
            };

            _iDateDescriptor.prototype.setText = function (value, allowchangeotherpart, result, isSmartInputMode) {
                return false;
            };

            _iDateDescriptor.prototype.inc = function () {
            };
            _iDateDescriptor.prototype.dec = function () {
            };
            _iDateDescriptor.prototype.needAdjustInsertPos = function () {
                return true;
            };
            _iDateDescriptor.prototype.reachMaxLen = function () {
                var t = this.getText();
                do {
                    if (t.charAt(0) === '0') {
                        t = t.slice(1);
                    } else {
                        break;
                    }
                } while(t.length > 0);
                return t.length >= this.maxLen;
            };
            return _iDateDescriptor;
        })();
        input._iDateDescriptor = _iDateDescriptor;

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor
        var _dateDescriptor = (function (_super) {
            __extends(_dateDescriptor, _super);
            function _dateDescriptor(owner, id) {
                _super.call(this, owner, id);
                this.liternal = '';
                this.maxLen = 100;
            }
            _dateDescriptor.prototype.getText = function () {
                return this.liternal;
            };
            return _dateDescriptor;
        })(_iDateDescriptor);

        var EraYearDescriptor = (function (_super) {
            __extends(EraYearDescriptor, _super);
            function EraYearDescriptor(owner, id) {
                _super.call(this, owner, id);
            }
            EraYearDescriptor.prototype.inc = function () {
                var date = this._txtProvider.getDate();
                var minDate = this._txtProvider.inputWidget._getRealEraMinDate();
                var maxDate = this._txtProvider.inputWidget._getRealEraMaxDate();

                if (DateTimeInfo.Equal(date, maxDate)) {
                    if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                        this._txtProvider.setDate(new Date(minDate.valueOf()));
                    }
                } else {
                    var increment = this._txtProvider.inputWidget._getInnerIncrement();
                    this._txtProvider.setYear(this._txtProvider.getYear() + increment, null, true);
                    if (this._txtProvider.getDate() > maxDate) {
                        this._txtProvider.setDate(new Date(maxDate.valueOf()));
                    }
                }
            };

            EraYearDescriptor.prototype.dec = function () {
                var date = this._txtProvider.getDate();
                var minDate = this._txtProvider.inputWidget._getRealEraMinDate();
                var maxDate = this._txtProvider.inputWidget._getRealEraMaxDate();

                if (DateTimeInfo.Equal(date, minDate)) {
                    if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                        this._txtProvider.setDate(new Date(maxDate.valueOf()));
                    }
                } else {
                    var increment = this._txtProvider.inputWidget._getInnerIncrement();
                    this._txtProvider.setYear(this._txtProvider.getYear() - increment, null, true);
                    if (this._txtProvider.getDate() < minDate) {
                        this._txtProvider.setDate(new Date(minDate.valueOf()));
                    }
                }
            };
            return EraYearDescriptor;
        })(_iDateDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor70
        var _dateDescriptor70 = (function (_super) {
            __extends(_dateDescriptor70, _super);
            function _dateDescriptor70(owner, id) {
                _super.call(this, owner, id);
                this.name = 'Era Year';
                this.formatString = "e";
                this.type = 70 /* EraYear */;
            }
            _dateDescriptor70.prototype.getText = function () {
                var eraDate = DateTimeInfo.GetEraDate(this._txtProvider.getDate());
                if (eraDate.eraYear === -1) {
                    return "";
                }
                eraDate.eraYear = eraDate.eraYear > 99 ? 99 : eraDate.eraYear;
                return this.getRealText(String(eraDate.eraYear));
            };

            _dateDescriptor70.prototype.setText = function (value, allowchangeotherpart, result) {
                if (isNaN(parseInt(value))) {
                    return false;
                }

                var date = this._txtProvider.getDate();
                var eraDate = DateTimeInfo.GetEraDate(date);
                if (eraDate.eraYear !== -1) {
                    var eraYear = parseInt(value);
                    if (eraYear >= DateTimeInfo.GetEraYears()[eraDate.era]) {
                        eraYear = DateTimeInfo.GetEraYears()[eraDate.era];
                    }

                    var nullFlag = this._txtProvider.inputWidget.options.date == null;
                    if (nullFlag) {
                        eraYear = parseInt(value);
                    }

                    var newDate = DateTimeInfo.ConvertToGregorianDate(eraDate.era, eraYear, date.getMonth() + 1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), false);

                    if (eraDate.era < DateTimeInfo.GetEraCount() - 1) {
                        var maxEraDate = DateTimeInfo.GetEraDates()[eraDate.era + 1];
                        if (newDate > maxEraDate) {
                            eraYear = DateTimeInfo.GetEraYears()[eraDate.era] - 1;
                            newDate = DateTimeInfo.ConvertToGregorianDate(eraDate.era, eraYear, date.getMonth() + 1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), false);
                        }
                    }

                    this._txtProvider.setDate(newDate);
                    return true;
                }

                return false;
            };
            return _dateDescriptor70;
        })(EraYearDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor71
        var _dateDescriptor71 = (function (_super) {
            __extends(_dateDescriptor71, _super);
            function _dateDescriptor71(owner, id) {
                _super.call(this, owner, id);
                this.name = 'Two Era Year';
                this.formatString = "ee";
                this.type = 71 /* TwoEraYear */;
            }
            _dateDescriptor71.prototype.getText = function () {
                var eraDate = DateTimeInfo.GetEraDate(this._txtProvider.getDate());
                if (eraDate.eraYear === -1) {
                    return "";
                }

                eraDate.eraYear = eraDate.eraYear > 99 ? 99 : eraDate.eraYear;
                return this.getRealText(paddingZero(eraDate.eraYear, 2));
            };

            _dateDescriptor71.prototype.setText = function (value, allowchangeotherpart, result) {
                if (isNaN(parseInt(value))) {
                    return false;
                }

                var date = this._txtProvider.getDate();
                var eraDate = DateTimeInfo.GetEraDate(date);
                if (eraDate.eraYear !== -1) {
                    var newValue = String(eraDate.eraYear) + value;
                    var eraYear = parseInt(newValue.substring(newValue.length - 2, newValue.length));
                    if (eraYear > DateTimeInfo.GetEraYears()[eraDate.era]) {
                        eraYear = DateTimeInfo.GetEraYears()[eraDate.era];
                    }

                    var nullFlag = this._txtProvider.inputWidget.options.date == null;
                    if (nullFlag) {
                        eraYear = parseInt(value);
                    }

                    var newDate = DateTimeInfo.ConvertToGregorianDate(eraDate.era, eraYear, date.getMonth() + 1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), false);
                    if (eraDate.era < DateTimeInfo.GetEraCount() - 1) {
                        var maxEraDate = DateTimeInfo.GetEraDates()[eraDate.era + 1];
                        if (newDate > maxEraDate) {
                            eraYear = DateTimeInfo.GetEraYears()[eraDate.era] - 1;
                            newDate = DateTimeInfo.ConvertToGregorianDate(eraDate.era, eraYear, date.getMonth() + 1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), false);
                        }
                    }

                    this._txtProvider.setDate(newDate);
                    return true;
                }

                return false;
            };
            return _dateDescriptor71;
        })(EraYearDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor75
        var _dateDescriptor75 = (function (_super) {
            __extends(_dateDescriptor75, _super);
            function _dateDescriptor75(owner, id) {
                _super.call(this, owner, id);
                this.name = 'Era Year Big';
                this.formatString = "E";
                this.type = 75 /* EraYearBig */;
            }
            _dateDescriptor75.prototype.getText = function () {
                var result = _super.prototype.getText.call(this);
                return result == 1 ? "\u5143" : result;
            };
            return _dateDescriptor75;
        })(_dateDescriptor70);

        var EraNameDescriptor = (function (_super) {
            __extends(EraNameDescriptor, _super);
            function EraNameDescriptor(owner, id) {
                _super.call(this, owner, id);
            }
            EraNameDescriptor.prototype.inc = function () {
                var date = this._txtProvider.getDate();
                var eraDate = DateTimeInfo.GetEraDate(date);
                if (eraDate.era === -1) {
                    return;
                }

                var minDate = this._txtProvider.inputWidget._getRealEraMinDate();
                var maxDate = this._txtProvider.inputWidget._getRealEraMaxDate();

                if (DateTimeInfo.Equal(date, maxDate)) {
                    if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                        this._txtProvider.setDate(new Date(minDate.valueOf()));
                    }
                } else {
                    if (eraDate.era >= DateTimeInfo.GetEraCount() - 1) {
                        this._txtProvider.setDate(new Date(maxDate.valueOf()));
                    } else {
                        var era = eraDate.era + this._txtProvider.inputWidget._getInnerIncrement();
                        era = era > DateTimeInfo.GetEraCount() - 1 ? DateTimeInfo.GetEraCount() - 1 : era;

                        var eraYear = eraDate.eraYear > DateTimeInfo.GetEraYears()[era] ? DateTimeInfo.GetEraYears()[era] : eraDate.eraYear;
                        var newDate = DateTimeInfo.ConvertToGregorianDate(era, eraYear, date.getMonth() + 1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), true);
                        newDate = newDate == null ? DateTimeInfo.GetEraDates()[era] : newDate;

                        if (newDate > maxDate) {
                            this._txtProvider.setDate(new Date(maxDate.valueOf()));
                        } else {
                            this._txtProvider.setDate(newDate);
                        }
                    }
                }
            };

            EraNameDescriptor.prototype.dec = function () {
                var date = this._txtProvider.getDate();
                var eraDate = DateTimeInfo.GetEraDate(date);
                if (eraDate.era === -1) {
                    return;
                }

                var minDate = this._txtProvider.inputWidget._getRealEraMinDate();
                var maxDate = this._txtProvider.inputWidget._getRealEraMaxDate();

                if (DateTimeInfo.Equal(date, minDate)) {
                    if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                        this._txtProvider.setDate(new Date(maxDate.valueOf()));
                    }
                } else {
                    if (eraDate.era == 0) {
                        this._txtProvider.setDate(new Date(minDate.valueOf()));
                    } else {
                        var era = eraDate.era - this._txtProvider.inputWidget._getInnerIncrement();
                        era = era < 0 ? 0 : era;

                        var eraYear = eraDate.eraYear > DateTimeInfo.GetEraYears()[era] ? DateTimeInfo.GetEraYears()[era] : eraDate.eraYear;
                        var newDate = DateTimeInfo.ConvertToGregorianDate(era, eraYear, date.getMonth() + 1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), true);

                        if (newDate == null) {
                            newDate = new Date(DateTimeInfo.GetEraDates()[era + 1]);
                            ;
                            newDate.setDate(newDate.getDate() - 1);
                        }

                        if (newDate > maxDate) {
                            this._txtProvider.setDate(new Date(minDate.valueOf()));
                        } else {
                            this._txtProvider.setDate(newDate);
                        }
                    }
                }
            };
            return EraNameDescriptor;
        })(_iDateDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor72
        var _dateDescriptor72 = (function (_super) {
            __extends(_dateDescriptor72, _super);
            function _dateDescriptor72(owner, id) {
                _super.call(this, owner, id);
                this.name = 'Era Name';
                this.formatString = "g";
                this.type = 72 /* EraName */;
            }
            _dateDescriptor72.prototype.getText = function () {
                if (DateTimeInfo.GetEraCount() === 1) {
                    return DateTimeInfo.GetEraSymbols()[0];
                }

                var eraDate = DateTimeInfo.GetEraDate(this._txtProvider.getDate());
                if (eraDate.era === -1) {
                    return "";
                }

                return this.getRealText(DateTimeInfo.GetEraSymbols()[eraDate.era]);
            };

            _dateDescriptor72.prototype.setText = function (value, allowchangeotherpart, result) {
                var singleValue = value.substr(value.length - 1, 1);
                var era = 0;
                for (era = 0; era < DateTimeInfo.GetEraCount(); era++) {
                    if ((singleValue.toLowerCase() === DateTimeInfo.GetEraShortcuts()[era].toLowerCase()) || (value.toLowerCase() === DateTimeInfo.GetEraShortNames()[era].toLowerCase())) {
                        break;
                    }
                }

                if (era == DateTimeInfo.GetEraCount()) {
                    return true;
                }

                var date = this._txtProvider.getDate();
                var eraDate = DateTimeInfo.GetEraDate(date);
                if (eraDate.era === -1) {
                    return true;
                }

                var eraYear = eraDate.eraYear > DateTimeInfo.GetEraYears()[era] ? DateTimeInfo.GetEraYears()[era] : eraDate.eraYear;
                var newDate = DateTimeInfo.ConvertToGregorianDate(era, eraYear, date.getMonth() + 1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), true);
                newDate = newDate == null ? DateTimeInfo.GetEraDates()[era] : newDate;

                if (era < DateTimeInfo.GetEraCount() - 1) {
                    var maxEraDate = DateTimeInfo.GetEraDates()[era + 1];
                    newDate = newDate > maxEraDate ? maxEraDate : newDate;
                }

                this._txtProvider.setDate(newDate);
                return true;
            };
            return _dateDescriptor72;
        })(EraNameDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor73
        var _dateDescriptor73 = (function (_super) {
            __extends(_dateDescriptor73, _super);
            function _dateDescriptor73(owner, id) {
                _super.call(this, owner, id);
                this.name = 'Two Era Name';
                this.formatString = "gg";
                this.type = 73 /* TwoEraName */;
            }
            _dateDescriptor73.prototype.getText = function () {
                if (DateTimeInfo.GetEraCount() === 1) {
                    return DateTimeInfo.GetEraAbbreviations()[0];
                }

                var eraDate = DateTimeInfo.GetEraDate(this._txtProvider.getDate());
                if (eraDate.era === -1) {
                    return "";
                }
                return this.getRealText(DateTimeInfo.GetEraAbbreviations()[eraDate.era]);
            };

            _dateDescriptor73.prototype.setText = function (value, allowchangeotherpart, result) {
                var singleValue = value.substr(value.length - 1, 1);
                var era = 0;
                for (era = 0; era < DateTimeInfo.GetEraCount(); era++) {
                    if ((singleValue.toLowerCase() === DateTimeInfo.GetEraShortcuts()[era].toLowerCase()) || (value.toLowerCase() === DateTimeInfo.GetEraShortNames()[era].toLowerCase()) || (value.toLowerCase() === DateTimeInfo.GetEraAbbreviations()[era].toLowerCase())) {
                        break;
                    }
                }

                if (era == DateTimeInfo.GetEraCount()) {
                    return true;
                }

                var date = this._txtProvider.getDate();
                var eraDate = DateTimeInfo.GetEraDate(date);
                if (eraDate.era === -1) {
                    return true;
                }

                var eraYear = eraDate.eraYear > DateTimeInfo.GetEraYears()[era] ? DateTimeInfo.GetEraYears()[era] : eraDate.eraYear;
                var newDate = DateTimeInfo.ConvertToGregorianDate(era, eraYear, date.getMonth() + 1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), true);
                newDate = newDate == null ? DateTimeInfo.GetEraDates()[era] : newDate;

                if (era < DateTimeInfo.GetEraCount() - 1) {
                    var maxEraDate = DateTimeInfo.GetEraDates()[era + 1];
                    newDate = newDate > maxEraDate ? maxEraDate : newDate;
                }

                this._txtProvider.setDate(newDate);
                return true;
            };
            return _dateDescriptor73;
        })(EraNameDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor74
        var _dateDescriptor74 = (function (_super) {
            __extends(_dateDescriptor74, _super);
            function _dateDescriptor74(owner, id) {
                _super.call(this, owner, id);
                this.name = 'Three Era Name';
                this.formatString = "ggg";
                this.type = 74 /* ThreeEraName */;
            }
            _dateDescriptor74.prototype.getText = function () {
                if (DateTimeInfo.GetEraCount() === 1) {
                    return DateTimeInfo.GetEraNames()[0];
                }

                var eraDate = DateTimeInfo.GetEraDate(this._txtProvider.getDate());
                if (eraDate.era === -1) {
                    return "";
                }
                return this.getRealText(DateTimeInfo.GetEraNames()[eraDate.era]);
            };

            _dateDescriptor74.prototype.setText = function (value, allowchangeotherpart, result) {
                var singleValue = value.substr(value.length - 1, 1);
                var era = 0;
                for (era = 0; era < DateTimeInfo.GetEraCount(); era++) {
                    if ((singleValue.toLowerCase() === DateTimeInfo.GetEraShortcuts()[era].toLowerCase()) || (value.toLowerCase() === DateTimeInfo.GetEraShortNames()[era].toLowerCase()) || (value.toLowerCase() === DateTimeInfo.GetEraAbbreviations()[era].toLowerCase()) || (value.toLowerCase() === DateTimeInfo.GetEraNames()[era].toLowerCase())) {
                        break;
                    }
                }

                if (era == DateTimeInfo.GetEraCount()) {
                    return false;
                }

                var date = this._txtProvider.getDate();
                var eraDate = DateTimeInfo.GetEraDate(date);
                if (eraDate.era === -1) {
                    return true;
                }

                var eraYear = eraDate.eraYear > DateTimeInfo.GetEraYears()[era] ? DateTimeInfo.GetEraYears()[era] : eraDate.eraYear;
                var newDate = DateTimeInfo.ConvertToGregorianDate(era, eraYear, date.getMonth() + 1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), true);
                newDate = newDate == null ? DateTimeInfo.GetEraDates()[era] : newDate;

                if (era < DateTimeInfo.GetEraCount() - 1) {
                    var maxEraDate = DateTimeInfo.GetEraDates()[era + 1];
                    newDate = newDate > maxEraDate ? maxEraDate : newDate;
                }

                this._txtProvider.setDate(newDate);
                return true;
            };
            return _dateDescriptor74;
        })(EraNameDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor80
        var _dateDescriptor80 = (function (_super) {
            __extends(_dateDescriptor80, _super);
            function _dateDescriptor80(owner, id) {
                _super.call(this, owner, id);
                this.name = 'AD';
                this.formatString = "A";
                this.type = 80 /* AD */;
            }
            _dateDescriptor80.prototype.getText = function () {
                return "A.D.";
            };
            return _dateDescriptor80;
        })(_iDateDescriptor);

        var MonthDateDescriptor = (function (_super) {
            __extends(MonthDateDescriptor, _super);
            function MonthDateDescriptor(owner, id) {
                _super.call(this, owner, id);
            }
            MonthDateDescriptor.prototype.inc = function () {
                _super.prototype.inc.call(this);

                var date = this._txtProvider.getDate();
                var year = date.getFullYear();
                var month = date.getMonth();
                var day = date.getDate();
                var hour = date.getHours();
                var minute = date.getMinutes();
                var second = date.getSeconds();

                var newMonth = month + this._txtProvider.inputWidget._getInnerIncrement();
                var dayCount = DateTimeInfo.DaysInMonth(year, newMonth + 1);
                if (day > dayCount) {
                    day = dayCount;
                }

                var newDate = new Date(year, newMonth, day, hour, minute, second);

                if (this._txtProvider._isEraFormatExist()) {
                    var minDate = this._txtProvider.inputWidget._getRealEraMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealEraMaxDate();

                    if (newDate >= maxDate) {
                        if (!DateTimeInfo.Equal(this._txtProvider.getDate(), maxDate)) {
                            this._txtProvider.setDate(maxDate);
                        } else if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(minDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                } else {
                    var minDate = this._txtProvider.inputWidget._getRealMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealMaxDate();

                    if (!this._txtProvider.inputWidget._isValidDate(newDate, true)) {
                        if (!DateTimeInfo.Equal(this._txtProvider.getDate(), maxDate)) {
                            this._txtProvider.setDate(maxDate);
                        } else if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(minDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                }
            };

            MonthDateDescriptor.prototype.dec = function () {
                _super.prototype.inc.call(this);
                var date = this._txtProvider.getDate();
                var year = date.getFullYear();
                var month = date.getMonth();
                var day = date.getDate();
                var hour = date.getHours();
                var minute = date.getMinutes();
                var second = date.getSeconds();

                var newMonth = month - this._txtProvider.inputWidget._getInnerIncrement();
                var dayCount = DateTimeInfo.DaysInMonth(year, newMonth + 1);
                if (day > dayCount) {
                    day = dayCount;
                }

                var newDate = new Date(year, newMonth, day, hour, minute, second);
                if (year == 1) {
                    newDate.setFullYear(1);
                    if (newMonth < 0) {
                        newDate.setMonth(newMonth);
                    }
                }

                if (this._txtProvider._isEraFormatExist()) {
                    var minDate = this._txtProvider.inputWidget._getRealEraMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealEraMaxDate();

                    if (newDate < minDate) {
                        if (!DateTimeInfo.Equal(this._txtProvider.getDate(), minDate)) {
                            this._txtProvider.setDate(minDate);
                        } else if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(maxDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                } else {
                    var minDate = this._txtProvider.inputWidget._getRealMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealMaxDate();
                    if (!this._txtProvider.inputWidget._isValidDate(newDate, true)) {
                        if (!DateTimeInfo.Equal(this._txtProvider.getDate(), minDate)) {
                            this._txtProvider.setDate(minDate);
                        } else if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(maxDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                }
            };

            MonthDateDescriptor.prototype.setText = function (value, allowchangeotherpart, result) {
                if (parseInt(value) > 12) {
                    value = value.substr(value.length - 1, 1);
                }
                var returnResult = this._txtProvider.setMonth(value, allowchangeotherpart, result);
                if (returnResult) {
                    if (this._txtProvider._isEraFormatExist()) {
                        var minDate = this._txtProvider.inputWidget._getRealEraMinDate();
                        var maxDate = this._txtProvider.inputWidget._getRealEraMaxDate();
                        var date = this._txtProvider.getDate();

                        if (date > maxDate) {
                            this._txtProvider.setDate(maxDate);
                        } else if (date < minDate) {
                            this._txtProvider.setDate(minDate);
                        }
                    }
                }

                return returnResult;
            };
            return MonthDateDescriptor;
        })(_iDateDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor20
        var _dateDescriptor20 = (function (_super) {
            __extends(_dateDescriptor20, _super);
            function _dateDescriptor20(owner, id) {
                _super.call(this, owner, id);
                this.name = 'Two-digit month';
                this.formatString = "MM";
                this.type = 20 /* TwoDigitMonth */;
            }
            _dateDescriptor20.prototype.getText = function () {
                var m = '' + this._txtProvider.getMonth() + '';
                return this.getRealText(m.length === 1 ? ('0' + m) : m);
            };

            _dateDescriptor20.prototype.setText = function (value, allowchangeotherpart, result) {
                if (value === "0") {
                    return true;
                }

                return _super.prototype.setText.call(this, value, allowchangeotherpart, result);
            };
            return _dateDescriptor20;
        })(MonthDateDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor25
        var _dateDescriptor25 = (function (_super) {
            __extends(_dateDescriptor25, _super);
            function _dateDescriptor25(owner, id) {
                _super.call(this, owner, id);
                this.name = 'month';
                this.formatString = "M";
                this.type = 25 /* Month */;
            }
            _dateDescriptor25.prototype.getText = function () {
                var m = '' + this._txtProvider.getMonth() + '';
                return this.getRealText(m);
            };
            return _dateDescriptor25;
        })(MonthDateDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor26
        var _dateDescriptor26 = (function (_super) {
            __extends(_dateDescriptor26, _super);
            function _dateDescriptor26(owner, id) {
                _super.call(this, owner, id);
                this.name = 'AbbreviatedMonthNames';
                this.formatString = "MMM";
                this.type = 26 /* AbbreviatedMonthNames */;
                this.maxLen = 26 /* AbbreviatedMonthNames */;
            }
            _dateDescriptor26.prototype.getText = function () {
                var m = this._txtProvider.getMonth(), culture = this._txtProvider._getCulture();
                return this.getRealText(culture.calendars.standard.months.namesAbbr[m - 1]);
            };

            _dateDescriptor26.prototype.setText = function (value, allowchangeotherpart, result) {
                var m = -1, cf = this._txtProvider.inputWidget._getCulture().calendars.standard;
                m = this._txtProvider.findAlikeArrayItemIndex(cf.months.namesAbbr, value);
                if (m === -1) {
                    return false;
                }
                return this._txtProvider.setMonth(m + 1, allowchangeotherpart, result);
            };
            return _dateDescriptor26;
        })(MonthDateDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor27
        var _dateDescriptor27 = (function (_super) {
            __extends(_dateDescriptor27, _super);
            function _dateDescriptor27(owner, id) {
                _super.call(this, owner, id);
                this.name = 'MonthNames';
                this.formatString = "MMMM";
                this.type = 27 /* MonthNames */;
                this.maxLen = 100;
            }
            _dateDescriptor27.prototype.getText = function () {
                var m = this._txtProvider.getMonth(), culture = this._txtProvider._getCulture();
                return this.getRealText(culture.calendars.standard.months.names[m - 1]);
            };

            _dateDescriptor27.prototype.setText = function (value, allowchangeotherpart, result) {
                var m = -1, culture;
                if (result && result.isfullreset) {
                    m = 1;
                } else {
                    culture = this._txtProvider._getCulture();
                    m = this._txtProvider.findAlikeArrayItemIndex(culture.calendars.standard.months.names, value);
                    if (m === -1) {
                        return false;
                    }
                }
                return this._txtProvider.setMonth(m + 1, allowchangeotherpart, result);
            };
            return _dateDescriptor27;
        })(MonthDateDescriptor);

        var DayOfMonthDescriptor = (function (_super) {
            __extends(DayOfMonthDescriptor, _super);
            function DayOfMonthDescriptor(owner, id) {
                _super.call(this, owner, id);
            }
            DayOfMonthDescriptor.prototype.inc = function () {
                var newDay = this._txtProvider.getDayOfMonth() + this._txtProvider.inputWidget._getInnerIncrement();
                var newDate = new Date(this._txtProvider.getDate().valueOf());
                newDate.setDate(newDay);
                if (this._txtProvider._isEraFormatExist()) {
                    var minDate = this._txtProvider.inputWidget._getRealEraMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealEraMaxDate();

                    if (newDate > maxDate) {
                        if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(minDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                } else {
                    var minDate = this._txtProvider.inputWidget._getRealMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealMaxDate();

                    if (!this._txtProvider.inputWidget._isValidDate(newDate, true)) {
                        if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(minDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                }
            };

            DayOfMonthDescriptor.prototype.dec = function () {
                var newDay = this._txtProvider.getDayOfMonth() - this._txtProvider.inputWidget._getInnerIncrement();
                var newDate = new Date(this._txtProvider.getDate().valueOf());
                newDate.setDate(newDay);
                if (this._txtProvider._isEraFormatExist()) {
                    var minDate = this._txtProvider.inputWidget._getRealEraMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealEraMaxDate();

                    if (newDate < minDate) {
                        if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(maxDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                } else {
                    var minDate = this._txtProvider.inputWidget._getRealMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealMaxDate();

                    if (!this._txtProvider.inputWidget._isValidDate(newDate, true)) {
                        if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(maxDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                }
            };

            DayOfMonthDescriptor.prototype.setText = function (value, allowchangeotherpart, result) {
                var date = this._txtProvider.getDate();
                var dayCount = DateTimeInfo.DaysInMonth(date.getFullYear(), date.getMonth() + 1);
                if (parseInt(value) > dayCount) {
                    value = dayCount + "";
                }
                var returnResult = this._txtProvider.setDayOfMonth(value, allowchangeotherpart, result);
                if (returnResult) {
                    if (this._txtProvider._isEraFormatExist()) {
                        var minDate = this._txtProvider.inputWidget._getRealEraMinDate();
                        var maxDate = this._txtProvider.inputWidget._getRealEraMaxDate();
                        var date = this._txtProvider.getDate();

                        if (date > maxDate) {
                            this._txtProvider.setDate(maxDate);
                        } else if (date < minDate) {
                            this._txtProvider.setDate(minDate);
                        }
                    }
                }

                return returnResult;
            };
            return DayOfMonthDescriptor;
        })(_iDateDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor30
        var _dateDescriptor30 = (function (_super) {
            __extends(_dateDescriptor30, _super);
            function _dateDescriptor30(owner, id) {
                _super.call(this, owner, id);
                this.name = 'Two-digit day of month';
                this.formatString = "dd";
                this.type = 30 /* TwoDigityDayOfMonth */;
            }
            _dateDescriptor30.prototype.getText = function () {
                return this.getRealText(paddingZero(this._txtProvider.getDayOfMonth()));
            };

            _dateDescriptor30.prototype.setText = function (value, allowchangeotherpart, result) {
                if (value === "0") {
                    return true;
                }

                return _super.prototype.setText.call(this, value, allowchangeotherpart, result);
            };
            return _dateDescriptor30;
        })(DayOfMonthDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor31
        var _dateDescriptor31 = (function (_super) {
            __extends(_dateDescriptor31, _super);
            function _dateDescriptor31(owner, id) {
                _super.call(this, owner, id);
                this.name = 'Day of month';
                this.formatString = "d";
                this.type = 31 /* DayOfMonth */;
            }
            _dateDescriptor31.prototype.getText = function () {
                var dom = this._txtProvider.getDayOfMonth();
                return this.getRealText('' + dom + '');
            };
            return _dateDescriptor31;
        })(DayOfMonthDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor100
        var _dateDescriptor100 = (function (_super) {
            __extends(_dateDescriptor100, _super);
            function _dateDescriptor100(owner, id) {
                _super.call(this, owner, id);
                this.name = 'AbbreviatedDayNames';
                this.formatString = "ddd";
                this.type = 100 /* AbbreviatedDayNames */;
                this.maxLen = 100;
            }
            _dateDescriptor100.prototype.getText = function () {
                var dw = this._txtProvider.getDayOfWeek(), culture = this._txtProvider._getCulture();
                return this.getRealText(culture.calendars.standard.days.namesAbbr[dw - 1]);
            };

            _dateDescriptor100.prototype.setText = function (value, allowchangeotherpart, result) {
                var dw = -1, culture = this._txtProvider._getCulture();
                dw = this._txtProvider.findAlikeArrayItemIndex(culture.calendars.standard.days.namesShort, value);
                if (dw === -1) {
                    return false;
                }
                return this._txtProvider.setDayOfWeek(dw + 1);
            };

            _dateDescriptor100.prototype.needAdjustInsertPos = function () {
                return false;
            };
            return _dateDescriptor100;
        })(DayOfMonthDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor101
        var _dateDescriptor101 = (function (_super) {
            __extends(_dateDescriptor101, _super);
            function _dateDescriptor101(owner, id) {
                _super.call(this, owner, id);
                this.name = 'DayNames';
                this.formatString = "dddd";
                this.type = 101 /* DayNames */;
                this.maxLen = 100;
            }
            _dateDescriptor101.prototype.getText = function () {
                var dw = this._txtProvider.getDayOfWeek(), culture = this._txtProvider._getCulture();
                return this.getRealText(culture.calendars.standard.days.names[dw - 1]);
            };

            _dateDescriptor101.prototype.setText = function (value, allowchangeotherpart, result) {
                var dw = -1, culture = this._txtProvider._getCulture();
                dw = this._txtProvider.findAlikeArrayItemIndex(culture.calendars.standard.days.names, value);
                if (dw === -1) {
                    return false;
                }
                return this._txtProvider.setDayOfWeek(dw + 1);
            };

            _dateDescriptor101.prototype.needAdjustInsertPos = function () {
                return false;
            };
            return _dateDescriptor101;
        })(DayOfMonthDescriptor);

        var YearDateDescriptor = (function (_super) {
            __extends(YearDateDescriptor, _super);
            function YearDateDescriptor(owner, id) {
                _super.call(this, owner, id);
            }
            YearDateDescriptor.prototype.inc = function () {
                var newYear = this._txtProvider.getYear() + this._txtProvider.inputWidget._getInnerIncrement();
                var newDate = new Date(this._txtProvider.getDate().valueOf());
                newDate.setFullYear(newYear);

                if (this._txtProvider._isEraFormatExist()) {
                    var minDate = this._txtProvider.inputWidget._getRealEraMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealEraMaxDate();

                    if (newDate > maxDate) {
                        if (!DateTimeInfo.Equal(this._txtProvider.getDate(), maxDate)) {
                            this._txtProvider.setDate(maxDate);
                        } else if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(minDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                } else {
                    var minDate = this._txtProvider.inputWidget._getRealMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealMaxDate();

                    if (!this._txtProvider.inputWidget._isValidDate(newDate, true)) {
                        if (!DateTimeInfo.Equal(this._txtProvider.getDate(), maxDate)) {
                            this._txtProvider.setDate(maxDate);
                        } else if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(minDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                }
            };

            YearDateDescriptor.prototype.dec = function () {
                var newYear = this._txtProvider.getYear() - +this._txtProvider.inputWidget._getInnerIncrement();
                var newDate = new Date(this._txtProvider.getDate().valueOf());
                newDate.setFullYear(newYear);

                if (this._txtProvider._isEraFormatExist()) {
                    var minDate = this._txtProvider.inputWidget._getRealEraMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealEraMaxDate();

                    if (newDate < minDate) {
                        if (!DateTimeInfo.Equal(this._txtProvider.getDate(), minDate)) {
                            this._txtProvider.setDate(minDate);
                        } else if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(maxDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                } else {
                    var minDate = this._txtProvider.inputWidget._getRealMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealMaxDate();

                    if (!this._txtProvider.inputWidget._isValidDate(newDate, true)) {
                        if (!DateTimeInfo.Equal(this._txtProvider.getDate(), minDate)) {
                            this._txtProvider.setDate(minDate);
                        } else if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(maxDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                }
            };
            return YearDateDescriptor;
        })(_iDateDescriptor);

        var TwoDigitYearDescriptor = (function (_super) {
            __extends(TwoDigitYearDescriptor, _super);
            function TwoDigitYearDescriptor(owner, id) {
                _super.call(this, owner, id);
            }
            TwoDigitYearDescriptor.prototype.setText = function (value, allowchangeotherpart, result) {
                value = paddingZero(value);
                var y = paddingZero(this._txtProvider.getYear(), 4), m, dom, h, min, s;
                if (value === '00') {
                    m = this._txtProvider.getMonth();
                    dom = this._txtProvider.getDayOfMonth();
                    h = this._txtProvider.getHours();
                    min = this._txtProvider.getMinutes();
                    s = this._txtProvider.getSeconds();
                    if (m === 1 && dom === 1 && !h && !min && !s) {
                        y = '0001';
                        value = '01';
                    }
                }
                if (y.length >= 2) {
                    y = y.substr(0, 2) + value.substr(0, 2);
                }

                return this._txtProvider.setYear(parseInt(y), result, false);
            };
            return TwoDigitYearDescriptor;
        })(YearDateDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor10
        var _dateDescriptor10 = (function (_super) {
            __extends(_dateDescriptor10, _super);
            function _dateDescriptor10(owner, id) {
                _super.call(this, owner, id);
                this.name = 'Four-digit year';
                this.formatString = "yyyy";
                this.type = 10 /* FourDigitYear */;
                this.maxLen = 4;
            }
            _dateDescriptor10.prototype.getText = function () {
                return this.getRealText(paddingZero(this._txtProvider.getYear(), 4));
            };

            _dateDescriptor10.prototype.setText = function (value, allowchangeotherpart, result, isSmartInputMode) {
                if (isSmartInputMode && result) {
                    value = value * 1;
                    value = value % 100;

                    var startYear = 1900 + 100;
                    if (this._txtProvider.inputWidget.options.startYear) {
                        startYear = this._txtProvider.inputWidget.options.startYear;
                    }

                    var lastYear = startYear % 100;
                    var firstYear = startYear - lastYear;

                    if (value >= lastYear) {
                        value = firstYear + value;
                    } else {
                        value = firstYear + value + 100;
                    }
                    //    startYearStr: string,
                    //    endYear, curDate, thisYear, inputNum, century, addYear, s;
                    //endYear = startYear + 100 - 1;
                    //startYearStr = this._txtProvider.paddingZero(startYear, 4);
                    //endYear = this._txtProvider.paddingZero(endYear, 4);
                    //if (result.pos === 0 || result.pos === 1) {
                    //    curDate = new Date();
                    //    thisYear = this._txtProvider
                    //        .paddingZero(this._txtProvider.getYear(), 4);
                    //    if (thisYear.charAt(0) === '0' &&
                    //        thisYear.charAt(1) === '0' && result.pos <= 1) {
                    //        inputNum = result.val;
                    //        century = '00';
                    //        if (inputNum >= 5) {
                    //            century = startYearStr.slice(0, 2);
                    //        }
                    //        else {
                    //            century = endYear.slice(0, 2);
                    //        }
                    //        addYear = result.val + thisYear.slice(3, 4);
                    //        s = century + addYear;
                    //        result.offset = 2 - result.pos;
                    //        this._txtProvider.setYear(s, result);
                    //        return true;
                    //    }
                    //}
                }

                return this._txtProvider.setYear(value, result, false);
            };
            return _dateDescriptor10;
        })(YearDateDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor1
        var _dateDescriptor1 = (function (_super) {
            __extends(_dateDescriptor1, _super);
            function _dateDescriptor1(owner, id) {
                _super.call(this, owner, id);
                this.name = 'One-digit year';
                this.formatString = "y";
                this.type = 1 /* OneDigitYear */;
            }
            _dateDescriptor1.prototype.getText = function () {
                var y = paddingZero(this._txtProvider.getYear());
                if (y[0] === '0') {
                    y = y[1];
                }
                return this.getRealText(y);
            };
            return _dateDescriptor1;
        })(TwoDigitYearDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor2
        var _dateDescriptor2 = (function (_super) {
            __extends(_dateDescriptor2, _super);
            function _dateDescriptor2(owner, id) {
                _super.call(this, owner, id);
                this.name = 'Two-digit year';
                this.formatString = "yy";
                this.type = 2 /* TwoDigitYear */;
            }
            _dateDescriptor2.prototype.getText = function () {
                if (this._txtProvider.inputWidget.isFocused() && this._txtProvider.inputWidget.options.date == null) {
                    return "yy";
                }
                return this.getRealText(paddingZero(this._txtProvider.getYear(), 2));
            };
            return _dateDescriptor2;
        })(TwoDigitYearDescriptor);

        var HourDescriptor = (function (_super) {
            __extends(HourDescriptor, _super);
            function HourDescriptor(owner, id) {
                _super.call(this, owner, id);
            }
            HourDescriptor.prototype.inc = function () {
                var newHour = this._txtProvider.getHours() + this._txtProvider.inputWidget._getInnerIncrement();
                var newDate = new Date(this._txtProvider.getDate().valueOf());
                newDate.setHours(newHour);

                if (this._txtProvider._isEraFormatExist()) {
                    var minDate = this._txtProvider.inputWidget._getRealEraMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealEraMaxDate();

                    if (newDate > maxDate) {
                        if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(minDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                } else {
                    var minDate = this._txtProvider.inputWidget._getRealMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealMaxDate();

                    if (!this._txtProvider.inputWidget._isValidDate(newDate, true)) {
                        if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(minDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                }
            };

            HourDescriptor.prototype.dec = function () {
                var newHour = this._txtProvider.getHours() - this._txtProvider.inputWidget._getInnerIncrement();
                var newDate = new Date(this._txtProvider.getDate().valueOf());
                newDate.setHours(newHour);
                if (this._txtProvider._isEraFormatExist()) {
                    var minDate = this._txtProvider.inputWidget._getRealEraMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealEraMaxDate();

                    if (newDate < minDate) {
                        if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(maxDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                } else {
                    var minDate = this._txtProvider.inputWidget._getRealMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealMaxDate();

                    if (!this._txtProvider.inputWidget._isValidDate(newDate, true)) {
                        if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(maxDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                }
            };
            return HourDescriptor;
        })(_iDateDescriptor);

        var TwelveHourDescriptor = (function (_super) {
            __extends(TwelveHourDescriptor, _super);
            function TwelveHourDescriptor(owner, id) {
                _super.call(this, owner, id);
            }
            TwelveHourDescriptor.prototype.setText = function (value, allowchangeotherpart, result) {
                var h = this._txtProvider.getHours();
                if (h >= 12 && value < 12) {
                    value = ((value * 1) + 12);
                } else if (h < 12 && value == 12) {
                    value = 0;
                }
                return this._txtProvider.setHours(value, allowchangeotherpart);
            };
            return TwelveHourDescriptor;
        })(HourDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor45
        var _dateDescriptor45 = (function (_super) {
            __extends(_dateDescriptor45, _super);
            function _dateDescriptor45(owner, id) {
                _super.call(this, owner, id);
                this.name = 'h';
                this.formatString = "h";
                this.type = 45 /* h */;
            }
            _dateDescriptor45.prototype.getText = function () {
                if (this._txtProvider.inputWidget.isFocused() && this._txtProvider.inputWidget.options.date == null) {
                    return "h";
                }

                var h = this._txtProvider.getHours();
                if (h > 12) {
                    h = h - 12;
                } else if (h === 0) {
                    h = 12;
                }

                if (h == 12 && this._txtProvider.inputWidget.options.hour12As0) {
                    h = 0;
                }

                return this.getRealText('' + h + '');
            };
            return _dateDescriptor45;
        })(TwelveHourDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor46
        var _dateDescriptor46 = (function (_super) {
            __extends(_dateDescriptor46, _super);
            function _dateDescriptor46(owner, id) {
                _super.call(this, owner, id);
                this.name = 'hh';
                this.formatString = "hh";
                this.type = 46 /* hh */;
            }
            _dateDescriptor46.prototype.getText = function () {
                var h = this._txtProvider.getHours();
                if (h > 12) {
                    h -= 12;
                } else if (h === 0) {
                    h = 12;
                }

                if (h == 12 && this._txtProvider.inputWidget.options.hour12As0) {
                    h = 0;
                }

                return this.getRealText(paddingZero(h, 2));
            };
            return _dateDescriptor46;
        })(TwelveHourDescriptor);

        var TwentyFourHourDescriptor = (function (_super) {
            __extends(TwentyFourHourDescriptor, _super);
            function TwentyFourHourDescriptor(owner, id) {
                _super.call(this, owner, id);
            }
            TwentyFourHourDescriptor.prototype.setText = function (value, allowchangeotherpart, result) {
                return this._txtProvider.setHours(value, allowchangeotherpart);
            };
            return TwentyFourHourDescriptor;
        })(HourDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor47
        var _dateDescriptor47 = (function (_super) {
            __extends(_dateDescriptor47, _super);
            function _dateDescriptor47(owner, id) {
                _super.call(this, owner, id);
                this.name = 'H';
                this.formatString = "H";
                this.type = 47 /* H */;
            }
            _dateDescriptor47.prototype.getText = function () {
                var h = this._txtProvider.getHours();

                if (h == 0 && !this._txtProvider.inputWidget.options.midnightAs0) {
                    h = 24;
                }

                return this.getRealText('' + h + '');
            };
            return _dateDescriptor47;
        })(TwentyFourHourDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor48
        var _dateDescriptor48 = (function (_super) {
            __extends(_dateDescriptor48, _super);
            function _dateDescriptor48(owner, id) {
                _super.call(this, owner, id);
                this.name = 'HH';
                this.formatString = "HH";
                this.type = 48 /* HH */;
            }
            _dateDescriptor48.prototype.getText = function () {
                var h = this._txtProvider.getHours();
                if (h == 0 && !this._txtProvider.inputWidget.options.midnightAs0) {
                    h = 24;
                }
                return this.getRealText(paddingZero(h, 2));
            };
            return _dateDescriptor48;
        })(TwentyFourHourDescriptor);

        var AmPmDescriptor = (function (_super) {
            __extends(AmPmDescriptor, _super);
            function AmPmDescriptor(owner, id) {
                _super.call(this, owner, id);
            }
            AmPmDescriptor.prototype.inc = function () {
                var h = (this._txtProvider.getHours() + 12) % 24;
                this._txtProvider.setHours(h, true);
            };

            AmPmDescriptor.prototype.dec = function () {
                var h = (this._txtProvider.getHours() + 12) % 24;
                this._txtProvider.setHours(h, true);
            };

            AmPmDescriptor.prototype.setText = function (value, allowchangeotherpart, result) {
                var h;
                if (value.toLowerCase().indexOf('a') >= 0) {
                    h = this._txtProvider.getHours() % 12;
                    this._txtProvider.setHours(h, true);
                } else if (value.toLowerCase().indexOf('p') >= 0) {
                    h = this._txtProvider.getHours() % 12 + 12;
                    this._txtProvider.setHours(h, true);
                }

                return true;
            };
            return AmPmDescriptor;
        })(_iDateDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor250
        var _dateDescriptor250 = (function (_super) {
            __extends(_dateDescriptor250, _super);
            function _dateDescriptor250(owner, id) {
                _super.call(this, owner, id);
                this.name = 't';
                this.formatString = "t";
                this.type = 250 /* ShortAmPm */;
            }
            _dateDescriptor250.prototype.getText = function () {
                var hours = this._txtProvider.getHours();
                var culture = this._txtProvider._getCulture();
                var am = this._txtProvider.inputWidget._getInnerAmDesignator();
                var pm = this._txtProvider.inputWidget._getInnerPmDesignator();
                var designator = hours < 12 ? am : pm;
                return this.getRealText(designator.charAt(0) || " ");
            };
            return _dateDescriptor250;
        })(AmPmDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor251
        var _dateDescriptor251 = (function (_super) {
            __extends(_dateDescriptor251, _super);
            function _dateDescriptor251(owner, id) {
                _super.call(this, owner, id);
                this.name = 'tt';
                this.formatString = "tt";
                this.type = 251 /* AmPm */;
            }
            _dateDescriptor251.prototype.getText = function () {
                var hours = this._txtProvider.getHours();
                var culture = this._txtProvider._getCulture();
                var am = this._txtProvider.inputWidget._getInnerAmDesignator();
                var pm = this._txtProvider.inputWidget._getInnerPmDesignator();
                var designator = hours < 12 ? am : pm;

                if (designator.length <= 0) {
                    designator = ' ';
                }
                return this.getRealText(designator);
            };
            return _dateDescriptor251;
        })(AmPmDescriptor);

        var MinuteDescriptor = (function (_super) {
            __extends(MinuteDescriptor, _super);
            function MinuteDescriptor(owner, id) {
                _super.call(this, owner, id);
            }
            MinuteDescriptor.prototype.inc = function () {
                var newMinute = this._txtProvider.getMinutes() + this._txtProvider.inputWidget._getInnerIncrement();
                var newDate = new Date(this._txtProvider.getDate().valueOf());
                newDate.setMinutes(newMinute);
                if (this._txtProvider._isEraFormatExist()) {
                    var minDate = this._txtProvider.inputWidget._getRealEraMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealEraMaxDate();

                    if (newDate > maxDate) {
                        if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(minDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                } else {
                    var minDate = this._txtProvider.inputWidget._getRealMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealMaxDate();

                    if (!this._txtProvider.inputWidget._isValidDate(newDate, true)) {
                        if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(minDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                }
            };

            MinuteDescriptor.prototype.dec = function () {
                var newMinite = this._txtProvider.getMinutes() - this._txtProvider.inputWidget._getInnerIncrement();
                var newDate = new Date(this._txtProvider.getDate().valueOf());
                newDate.setMinutes(newMinite);

                if (this._txtProvider._isEraFormatExist()) {
                    var minDate = this._txtProvider.inputWidget._getRealEraMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealEraMaxDate();

                    if (newDate < minDate) {
                        if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(maxDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                } else {
                    var minDate = this._txtProvider.inputWidget._getRealMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealMaxDate();

                    if (!this._txtProvider.inputWidget._isValidDate(newDate, true)) {
                        if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(maxDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                }
            };

            MinuteDescriptor.prototype.setText = function (value, allowchangeotherpart, result) {
                if (result && result.isfullreset) {
                    value = '0';
                }

                return this._txtProvider.setMinutes(value, allowchangeotherpart);
            };
            return MinuteDescriptor;
        })(_iDateDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor50
        var _dateDescriptor50 = (function (_super) {
            __extends(_dateDescriptor50, _super);
            function _dateDescriptor50(owner, id) {
                _super.call(this, owner, id);
                this.name = 'mm';
                this.formatString = "mm";
                this.type = 50 /* mm */;
            }
            _dateDescriptor50.prototype.getText = function () {
                return this.getRealText(paddingZero(this._txtProvider.getMinutes()));
            };
            return _dateDescriptor50;
        })(MinuteDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor51
        var _dateDescriptor51 = (function (_super) {
            __extends(_dateDescriptor51, _super);
            function _dateDescriptor51(owner, id) {
                _super.call(this, owner, id);
                this.name = 'm';
                this.formatString = "m";
                this.type = 51 /* m */;
                this.delta = 12;
            }
            _dateDescriptor51.prototype.getText = function () {
                return this.getRealText(this._txtProvider.getMinutes().toString());
            };
            return _dateDescriptor51;
        })(MinuteDescriptor);

        var SecondDescriptor = (function (_super) {
            __extends(SecondDescriptor, _super);
            function SecondDescriptor(owner, id) {
                _super.call(this, owner, id);
            }
            SecondDescriptor.prototype.inc = function () {
                var newSecond = this._txtProvider.getSeconds() + this._txtProvider.inputWidget._getInnerIncrement();
                var newDate = new Date(this._txtProvider.getDate().valueOf());
                newDate.setSeconds(newSecond);

                if (this._txtProvider._isEraFormatExist()) {
                    var minDate = this._txtProvider.inputWidget._getRealEraMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealEraMaxDate();

                    if (newDate > maxDate) {
                        if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(minDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                } else {
                    var minDate = this._txtProvider.inputWidget._getRealMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealMaxDate();

                    if (!this._txtProvider.inputWidget._isValidDate(newDate, true)) {
                        if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(minDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                }
            };

            SecondDescriptor.prototype.dec = function () {
                var newSecond = this._txtProvider.getSeconds() - this._txtProvider.inputWidget._getInnerIncrement();
                var newDate = new Date(this._txtProvider.getDate().valueOf());
                newDate.setSeconds(newSecond);

                if (this._txtProvider._isEraFormatExist()) {
                    var minDate = this._txtProvider.inputWidget._getRealEraMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealEraMaxDate();

                    if (newDate < minDate) {
                        if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(maxDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                } else {
                    var minDate = this._txtProvider.inputWidget._getRealMinDate();
                    var maxDate = this._txtProvider.inputWidget._getRealMaxDate();

                    if (!this._txtProvider.inputWidget._isValidDate(newDate, true)) {
                        if (this._txtProvider.inputWidget._getAllowSpinLoop()) {
                            this._txtProvider.setDate(maxDate);
                        }
                    } else {
                        this._txtProvider.setDate(newDate);
                    }
                }
            };

            SecondDescriptor.prototype.setText = function (value, allowchangeotherpart, result) {
                if (result && result.isfullreset) {
                    value = '0';
                }
                return this._txtProvider.setSeconds(value, allowchangeotherpart);
            };
            return SecondDescriptor;
        })(_iDateDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor60
        var _dateDescriptor60 = (function (_super) {
            __extends(_dateDescriptor60, _super);
            function _dateDescriptor60(owner, id) {
                _super.call(this, owner, id);
                this.name = 'ss';
                this.formatString = "ss";
                this.type = 60 /* ss */;
            }
            _dateDescriptor60.prototype.getText = function () {
                return this.getRealText(paddingZero(this._txtProvider.getSeconds()));
            };
            return _dateDescriptor60;
        })(SecondDescriptor);

        ////////////////////////////////////////////////////////////////////////////////
        // _dateDescriptor61
        var _dateDescriptor61 = (function (_super) {
            __extends(_dateDescriptor61, _super);
            function _dateDescriptor61(owner, id) {
                _super.call(this, owner, id);
                this.name = 's';
                this.formatString = "s";
                this.type = 61 /* s */;
            }
            _dateDescriptor61.prototype.getText = function () {
                return this.getRealText(this._txtProvider.getSeconds().toString());
            };
            return _dateDescriptor61;
        })(SecondDescriptor);

        

        /** @ignore */
        var DateTimeInfo = (function () {
            function DateTimeInfo() {
            }
            DateTimeInfo.IsValidEraDate = function (date) {
                if (date < this.GetEraMin() || date > this.GetEraMax()) {
                    return false;
                }
                return true;
            };
            DateTimeInfo.ConvertToGregorianYear = function (era, eraYear, strict) {
                if (era < 0 || era >= this.GetEraCount() || eraYear < 1 || strict && eraYear > this.GetEraYears()[era]) {
                    return -1;
                }
                return this.GetEraDates()[era].getFullYear() + eraYear - 1;
            };
            DateTimeInfo.GetEraDates = function () {
                if (window.eras != undefined) {
                    var eraDates = new Array();
                    for (var i = 0; i < window.eras.length; i++) {
                        var date = new Date(window.eras[i].startDate.replace(/-/g, "/"));
                        eraDates[i] = date;
                    }
                    return eraDates;
                }
                return this.EraDates;
            };
            DateTimeInfo.GetEraNames = function () {
                var eraNames = new Array();
                if (window.eras != undefined) {
                    for (var i = 0; i < window.eras.length; i++) {
                        eraNames[i] = window.eras[i].name;
                    }
                    return eraNames;
                }

                for (var i = 0; i < this.EraCount; i++) {
                    eraNames[i] = this.EraNames[i + 2 * this.EraCount];
                }
                return eraNames;
            };

            DateTimeInfo.GetEraSymbols = function () {
                var eraSymbol = new Array();
                if (window.eras != undefined) {
                    for (var i = 0; i < window.eras.length; i++) {
                        eraSymbol[i] = window.eras[i].symbol;
                    }
                    return eraSymbol;
                }

                for (var i = 0; i < this.EraCount; i++) {
                    eraSymbol[i] = this.EraNames[i];
                    ;
                }
                return eraSymbol;
            };

            DateTimeInfo.GetEraAbbreviations = function () {
                var eraAbbreviation = new Array();
                if (window.eras != undefined) {
                    for (var i = 0; i < window.eras.length; i++) {
                        eraAbbreviation[i] = window.eras[i].abbreviation;
                    }
                    return eraAbbreviation;
                }

                for (var i = 0; i < this.EraCount; i++) {
                    eraAbbreviation[i] = this.EraNames[i + this.EraCount];
                }
                return eraAbbreviation;
            };

            DateTimeInfo.GetEraShortNames = function () {
                var eraShortName = new Array();
                if (window.eras != undefined) {
                    for (var i = 0; i < window.eras.length; i++) {
                        eraShortName[i] = window.eras[i].shortcuts.split(',')[1];
                    }
                    return eraShortName;
                }

                for (var i = 0; i < this.EraCount; i++) {
                    eraShortName[i] = this.EraNames[i];
                }
                return eraShortName;
            };

            DateTimeInfo.GetEraShortcuts = function () {
                var eraShortcuts = new Array();
                if (window.eras != undefined) {
                    for (var i = 0; i < window.eras.length; i++) {
                        eraShortcuts[i] = window.eras[i].shortcuts.split(',')[0];
                    }
                    return eraShortcuts;
                }

                for (var i = 0; i < this.EraCount; i++) {
                    eraShortcuts[i] = this.EraKeys[i];
                }
                return eraShortcuts;
            };

            DateTimeInfo.GetEraMax = function () {
                if (window.eras != undefined) {
                    if (window.eras.length > 0) {
                        var date = new Date(window.eras[window.eras.length - 1].startDate.replace(/-/g, "/"));
                        date.setFullYear(date.getFullYear() + 99);
                        return date;
                    }
                }
                return this.EraMax;
            };

            DateTimeInfo.GetEraMin = function () {
                if (window.eras != undefined) {
                    if (window.eras.length > 0) {
                        var date = new Date(window.eras[0].startDate.replace(/-/g, "/"));
                        return date;
                    }
                }
                return this.EraMin;
            };

            DateTimeInfo.GetEraCount = function () {
                if (window.eras != undefined) {
                    return window.eras.length;
                }
                return this.EraCount;
            };

            DateTimeInfo.GetEraYears = function () {
                if (window.eras != undefined) {
                    var eraYears = new Array();
                    for (var i = 1; i < window.eras.length; i++) {
                        var date1 = new Date(window.eras[i - 1].startDate.replace(/-/g, "/"));
                        var date2 = new Date(window.eras[i].startDate.replace(/-/g, "/"));
                        eraYears[i - 1] = date2.getFullYear() - date1.getFullYear() + 1;
                    }
                    eraYears[i - 1] = 99;
                    return eraYears;
                }
                return this.EraYears;
            };

            DateTimeInfo.ConvertToGregorianDate = function (era, eraYear, month, day, hour, minute, second, strict) {
                var year = this.ConvertToGregorianYear(era, eraYear, strict);

                if (year < 1 || year > 9999) {
                    return null;
                }

                if (month < 1 || month > 12) {
                    return null;
                }

                var maxdays = this.DaysInMonth(year, month);

                if (day < 1 || day > maxdays) {
                    return null;
                }
                if (hour < 0 || hour > 23) {
                    return null;
                }
                if (minute < 0 || minute > 59) {
                    return null;
                }
                if (second < 0 || second > 59) {
                    return null;
                }
                var dateTime = new Date(year, month - 1, day, hour, minute, second);

                if (strict) {
                    var startDate = this.GetEraDates()[era];
                    var endDate = era + 1 != this.GetEraCount() ? this.AddMilliseconds(this.GetEraDates()[era + 1], -1) : this.GetEraMax();

                    if (dateTime < startDate || dateTime > endDate) {
                        return null;
                    }
                }

                return dateTime;
            };

            DateTimeInfo.String2Date = function (value) {
                if (value == null || value.Length == 0) {
                    return null;
                }

                var date = new Date(Date.parse(value));
                return date;
            };

            DateTimeInfo.ToString = function (value, length, ch, position) {
                var val = value + "";

                //It is same as String.PadLeft(int, char) in C#.
                if (ch != null) {
                    while (val.length < length) {
                        if (position) {
                            val = val + ch;
                        } else {
                            val = ch + val;
                        }
                    }

                    return val;
                }

                while (val.length < length) {
                    val += value + "";
                }

                return val;
            };

            DateTimeInfo.Date2String = function (date, isJapan, IsjqDate, IsjqTime) {
                var strDate = "";

                try  {
                    if (isJapan == true) {
                        if (IsjqDate == true) {
                            strDate = date.getFullYear() + "/" + (date.getMonth() + 1) + "/" + date.getDate();
                        } else if (IsjqTime == true) {
                            strDate = date.getHours() + ":" + DateTimeInfo.ToString(date.getMinutes(), 2, "0") + ":" + DateTimeInfo.ToString(date.getSeconds(), 2, "0");
                        } else {
                            strDate = date.getFullYear() + "/" + (date.getMonth() + 1) + "/" + date.getDate() + " " + date.getHours() + ":" + DateTimeInfo.ToString(date.getMinutes(), 2, "0") + ":" + DateTimeInfo.ToString(date.getSeconds(), 2, "0");
                        }
                    } else {
                        if (IsjqDate == true) {
                            strDate = (date.getMonth() + 1) + "/" + date.getDate() + "/" + date.getFullYear();
                        } else if (IsjqTime == true) {
                            strDate = date.getHours() + ":" + DateTimeInfo.ToString(date.getMinutes(), 2, "0") + ":" + DateTimeInfo.ToString(date.getSeconds(), 2, "0");
                        } else {
                            strDate = (date.getMonth() + 1) + "/" + date.getDate() + "/" + date.getFullYear() + " " + date.getHours() + ":" + DateTimeInfo.ToString(date.getMinutes(), 2, "0") + ":" + DateTimeInfo.ToString(date.getSeconds(), 2, "0");
                        }
                    }
                } catch (ex) {
                    strDate = "";
                }

                return strDate;
            };

            DateTimeInfo.Date2Long = function (date) {
                try  {
                    return (date.getFullYear() * 100 + date.getMonth() + 1) * 100 + date.getDate();
                } catch (ex) {
                    return 0;
                }
            };

            DateTimeInfo.Date2Number = function (date) {
                if (date == null) {
                    return 0;
                }

                return ((((date.getFullYear() * 100 + date.getMonth() + 1) * 100 + date.getDate()) * 100 + date.getHours()) * 100 + date.getMinutes()) * 100 + date.getSeconds();
            };

            DateTimeInfo.Long2Date = function (value) {
                return new Date(Math.floor(value / 10000), Math.floor((value % 10000) / 100) - 1, value % 100);
            };

            DateTimeInfo.GetEraDate = function (date) {
                var eraDate = new Object();
                eraDate.era = -1;
                eraDate.eraYear = -1;

                if (!this.IsValidEraDate(date)) {
                    return eraDate;
                }

                for (var i = 0; i < this.GetEraCount(); i++) {
                    var nextDate = i + 1 != this.GetEraCount() ? this.GetEraDates()[i + 1] : this.AddMilliseconds(this.GetEraMax(), 1);

                    if (date < nextDate) {
                        eraDate.era = i;
                        eraDate.eraYear = date.getFullYear() - this.GetEraDates()[i].getFullYear() + 1;

                        break;
                    }
                }

                return eraDate;
            };

            DateTimeInfo.MakeDate = function (era, erayear, month, day) {
                var date = new Date();

                date = this.ConvertToGregorianDate(era, erayear, month, day, 0, 0, 0, true);

                if (date == null) {
                    return -1;
                }

                return date;
            };

            DateTimeInfo.GetValidMonthRange = function (era, eraYear) {
                var monthRange = {};
                monthRange.min = 1;
                monthRange.max = 12;

                if (era == -1 || eraYear == -1) {
                    return monthRange;
                }

                if (eraYear == 1) {
                    monthRange.min = this.GetEraDates()[era].getMonth() + 1;
                } else if (eraYear == this.EraYears[era] && era < this.EraCount - 1) {
                    monthRange.max = this.AddMilliseconds(this.GetEraDates()[era + 1], -1).getMonth() + 1;
                }

                return monthRange;
            };

            DateTimeInfo.GetValidDayRange = function (era, eraYear, month) {
                var dayRange = new Object();
                dayRange.min = 1;
                dayRange.max = this.DaysInMonth(this.ConvertToGregorianYear(era, eraYear, true), month);
                var eraMin = this.GetEraDates()[era];
                var eraMax = era < this.GetEraCount() - 1 ? this.AddMilliseconds(this.GetEraDates()[era + 1], -1) : this.GetEraMax();

                if (era == -1 || eraYear == -1) {
                    return dayRange;
                }

                if (eraYear == 1 && month == eraMin.getMonth() + 1) {
                    dayRange.min = eraMin.getDate();
                } else if (eraYear == this.EraYears[era] && month == eraMax.getMonth() + 1) {
                    dayRange.max = eraMax.getDate();
                }

                return dayRange;
            };

            DateTimeInfo.IsLeapYear = function (year) {
                if ((year % 400 == 0) || ((year % 4 == 0) && (year % 100 != 0))) {
                    return true;
                } else {
                    return false;
                }
            };

            DateTimeInfo.DayOfYear = function (year, month, day) {
                var sum = 0;
                for (var i = 1; i < month; i++) {
                    sum = sum + this.DaysInMonth(year, i);
                }

                sum = sum + day;
                return sum;
            };

            DateTimeInfo.DaysInMonth = function (year, month) {
                if (month > 12) {
                    year += Math.floor(month / 12);
                    month = month % 12;
                } else if (month < 0) {
                    var zMonth = month * (-1);
                    year -= Math.ceil(zMonth / 12);
                    month = 12 - zMonth % 12;
                }
                switch (month) {
                    case 2:
                        if (this.IsLeapYear(year)) {
                            return 29;
                        } else {
                            return 28;
                        }
                        break;
                    case 4:
                    case 6:
                    case 9:
                    case 11:
                        return 30;
                        break;
                    default:
                        return 31;
                        break;
                }
            };

            DateTimeInfo.Equal = function (date1, date2, strict) {
                if (date1 == null && date2 == null) {
                    return true;
                } else if (date1 == null) {
                    return false;
                } else if (date2 == null) {
                    return false;
                }

                try  {
                    if (!strict) {
                        if (date1.getFullYear() == date2.getFullYear() && date1.getMonth() == date2.getMonth() && date1.getDate() == date2.getDate()) {
                            return true;
                        } else {
                            return false;
                        }
                    }

                    if (date1.getFullYear() == date2.getFullYear() && date1.getMonth() == date2.getMonth() && date1.getDate() == date2.getDate() && date1.getHours() == date2.getHours() && date1.getMinutes() == date2.getMinutes() && date1.getSeconds() == date2.getSeconds()) {
                        return true;
                    } else {
                        return false;
                    }
                } catch (e) {
                    return false;
                }
            };

            DateTimeInfo.YearMonthEqual = function (date1, date2) {
                if (date1 == null && date2 == null) {
                    return true;
                } else if (date1 == null) {
                    return false;
                } else if (date2 == null) {
                    return false;
                }

                try  {
                    if (date1.getFullYear() == date2.getFullYear() && date1.getMonth() == date2.getMonth()) {
                        return true;
                    } else {
                        return false;
                    }
                } catch (e) {
                    return false;
                }
            };

            DateTimeInfo.SetDate = function (year, month, day) {
                var newDate = new Date();
                var maxMonth = 9999 * 12 + 12;

                if (year * 12 + month > maxMonth) {
                    newDate = new Date(9999, 11, 31);
                } else if (year * 12 + month < 100) {
                    newDate = new Date(100, 0, 1);
                } else {
                    var days = this.DaysInMonth(year, month);
                    if (day > days) {
                        day = days;
                    }
                    newDate = new Date(year, month - 1, day);
                }

                return newDate;
            };

            DateTimeInfo.SetFullDate = function (year, month, day) {
                var newDate = new Date();
                newDate.setDate(1);
                var maxMonth = 9999 * 12 + 12;

                var days = this.DaysInMonth(year, month);

                if ((month > 0) && (month < 12) && (day > days)) {
                    day = days;
                }

                newDate.setFullYear(year);
                newDate.setMonth(month - 1);
                newDate.setDate(day);
                return newDate;
            };

            DateTimeInfo.SetFullDateByDate = function (date) {
                var newDate = new Date();
                newDate.setDate(1);
                newDate.setFullYear(date.getFullYear());
                newDate.setMonth(date.getMonth());
                newDate.setDate(date.getDate());
                newDate.setHours(0, 0, 0, 0);
                return newDate;
            };

            DateTimeInfo.LYearDays = function (y) {
                var i, sum = 348;
                for (i = 0x8000; i > 0x8; i >>= 1)
                    sum += (this.LunarInfo[y - 1960] & i) ? 1 : 0;
                return (sum + this.leapDays(y));
            };

            DateTimeInfo.leapDays = function (y) {
                if (this.LeapMonth(y))
                    return ((this.LunarInfo[y - 1960] & 0x10000) ? 30 : 29);
                else
                    return (0);
            };

            DateTimeInfo.LeapDays = function (y) {
                if (this.LeapMonth(y))
                    return ((this.LunarInfo[y - 1960] & 0x10000) ? 30 : 29);
                else
                    return (0);
            };

            DateTimeInfo.LeapMonth = function (y) {
                return (this.LunarInfo[y - 1960] & 0xf);
            };

            DateTimeInfo.MonthDays = function (y, m) {
                return ((this.LunarInfo[y - 1960] & (0x10000 >> m)) ? 30 : 29);
            };

            DateTimeInfo.GetRokuyou = function (date) {
                if ((date - this.RokuyouMin) < 0 || (date - this.RokuyouMax) > 0) {
                    return;
                }
                var i, leap = 0, temp = 0;
                var baseDate = new Date(1960, 0, 28);
                var offset = Math.round((date - baseDate) / 86400000);

                for (i = 1960; i < 2050 && offset > 0; i++) {
                    temp = this.LYearDays(i);
                    offset -= temp;
                }
                if (offset < 0) {
                    offset += temp;
                    i--;
                }

                this.year = i;

                leap = this.LeapMonth(i);
                this.isLeap = false;

                for (i = 1; i < 13 && offset > 0; i++) {
                    if (leap > 0 && i == (leap + 1) && this.isLeap == false) {
                        --i;
                        this.isLeap = true;
                        temp = this.LeapDays(this.year);
                    } else {
                        temp = this.MonthDays(this.year, i);
                    }

                    if (this.isLeap == true && i == (leap + 1))
                        this.isLeap = false;

                    offset -= temp;
                }

                if (offset == 0 && leap > 0 && i == leap + 1)
                    if (this.isLeap) {
                        this.isLeap = false;
                    } else {
                        this.isLeap = true;
                        --i;
                    }

                if (offset < 0) {
                    offset += temp;
                    --i;
                }

                this.month = i;
                this.day = offset + 1;

                var index = (this.month + this.day - 2) % 6;

                var errorRange1Min = new Date(1996, 6, 15);
                var errorRange1Max = new Date(1996, 7, 13);
                if (this.IsDateInRange(date, errorRange1Min, errorRange1Max)) {
                    index = (6 + index - 1) % 6;
                }

                var errorRange2Min = new Date(1996, 8, 12);
                var errorRange2Max = new Date(1996, 9, 11);
                if (this.IsDateInRange(date, errorRange2Min, errorRange2Max)) {
                    index = (6 + index - 1) % 6;
                }

                var errorRange3Min = new Date(2033, 7, 25);
                var errorRange3Max = new Date(2033, 11, 21);
                if (this.IsDateInRange(date, errorRange3Min, errorRange3Max)) {
                    index = (index + 1) % 6;
                }

                if (this.Equal(date, errorRange1Min)) {
                    index = (6 + index - 1) % 6;
                }
                if (this.Equal(date, errorRange2Min)) {
                    index = (6 + index - 1) % 6;
                }

                var rokuyou;

                //switch (index) {
                //    case 0:
                //        rokuyou = GrapeCity.IM.Rokuyou.Senshou;
                //        break;
                //    case 1:
                //        rokuyou = GrapeCity.IM.Rokuyou.Tomobiki;
                //        break;
                //    case 2:
                //        rokuyou = GrapeCity.IM.Rokuyou.Senbu;
                //        break;
                //    case 3:
                //        rokuyou = GrapeCity.IM.Rokuyou.Butsumetsu;
                //        break;
                //    case 4:
                //        rokuyou = GrapeCity.IM.Rokuyou.Taian;
                //        break;
                //    case 5:
                //        rokuyou = GrapeCity.IM.Rokuyou.Shakkou;
                //        break;
                //    default:
                //        break;
                //}
                return rokuyou;
            };

            DateTimeInfo.IsDateInRange = function (dt, min, max) {
                var dtYear = dt.getYear();
                var minYear = min.getYear();
                var maxYear = max.getYear();
                var dtMonth = dt.getMonth();
                var minMonth = min.getMonth();
                var maxMonth = max.getMonth();
                var dtDay = dt.getDate();
                var minDay = min.getDate();
                var maxDay = max.getDate();
                var dtValue = dtYear * 10000 + dtMonth * 100 + dtDay;
                var minValue = minYear * 10000 + minMonth * 100 + minDay;
                var maxValue = maxYear * 10000 + maxMonth * 100 + maxDay;

                return dtValue >= minValue && dtValue <= maxValue;
            };

            DateTimeInfo.GetRokuyouText = function (rokuyou) {
                var rokuyouArray = new Array();

                //if (GrapeCity.IM.Localization.Region == "ja") {
                rokuyouArray = this.RokuyouTextArray.slice(0);

                switch (rokuyou) {
                    default:
                        return "";
                        break;
                }
            };

            DateTimeInfo.DaysInSpecialWeek = function (year, month, weekFlay) {
                var selections = new Array();
                var days = this.DaysInMonth(year, month + 1);
                var date = new Date(year, month, 1);
                var firstDateOfWeekTitle;

                for (var i = 1; i <= days; i++) {
                    date.setDate(i);
                    if (date.getDay() == weekFlay) {
                        var selectedDate = new Date(year, month, i);
                        selections.push(selectedDate);
                        firstDateOfWeekTitle = i;
                        break;
                    }
                }

                firstDateOfWeekTitle += 7;
                while (firstDateOfWeekTitle <= days) {
                    date.setDate(firstDateOfWeekTitle);
                    var followSelectedDate = new Date(year, month, firstDateOfWeekTitle);
                    selections.push(followSelectedDate);
                    firstDateOfWeekTitle += 7;
                }
                return selections;
            };

            DateTimeInfo.GetDaysByFirstWeekday = function (firstWeekday) {
                var days = new Array();
                days.push(firstWeekday);
                var date = new Date(firstWeekday);
                while (date.getDate() + 7 <= this.DaysInMonth(firstWeekday.getFullYear(), firstWeekday.getMonth() + 1)) {
                    date = new Date(date.getFullYear(), date.getMonth(), date.getDate() + 7);
                    days.push(date);
                }
                return days;
            };

            DateTimeInfo.AddMilliseconds = function (date, msec) {
                var newDate = new Date(date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds());
                newDate.setMilliseconds(newDate.getMilliseconds() + msec);
                return new Date(newDate.valueOf());
            };

            DateTimeInfo.GetWeekIndexByDate = function (date) {
                return Math.floor(date.getDate() / 7);
            };
            DateTimeInfo.EraDates = new Array(new Date(1868, 9 - 1, 8), new Date(1912, 7 - 1, 30), new Date(1926, 12 - 1, 25), new Date(1989, 1 - 1, 8));
            DateTimeInfo.EraCount = 4;
            DateTimeInfo.EraYears = new Array(45, 15, 64, 99);
            DateTimeInfo.EraMax = new Date(2087, 12 - 1, 31, 23, 59, 59);
            DateTimeInfo.EraMin = new Date(1868, 9 - 1, 8);
            DateTimeInfo.EraKeys = new Array("1", "2", "3", "4", "m", "t", "s", "h");
            DateTimeInfo.EraIndices = new Array(0, 1, 2, 3, 0, 1, 2, 3);
            DateTimeInfo.DateLongFormat = "yyyyMMddHHmmss";
            DateTimeInfo.EraNames = new Array("M", "T", "S", "H", "\u660E", "\u5927", "\u662D", "\u5E73", "\u660E\u6CBB", "\u5927\u6B63", "\u662D\u548C", "\u5E73\u6210");
            DateTimeInfo.WeekDays = new Array("\u65e5\u66dc\u65e5", "\u6708\u66dc\u65e5", "\u706b\u66dc\u65e5", "\u6c34\u66dc\u65e5", "\u6728\u66dc\u65e5", "\u91d1\u66dc\u65e5", "\u571f\u66dc\u65e5");
            DateTimeInfo.MonthNames = new Array("\u0031\u6708", "\u0032\u6708", "\u0033\u6708", "\u0034\u6708", "\u0035\u6708", "\u0036\u6708", "\u0037\u6708", "\u0038\u6708", "\u0039\u6708", "\u0031\u0030\u6708", "\u0031\u0031\u6708", "\u0031\u0032\u6708");
            DateTimeInfo.ShortWeekDays = new Array("\u65e5", "\u6708", "\u706b", "\u6c34", "\u6728", "\u91d1", "\u571f");
            DateTimeInfo.ShortMonthNames = new Array("\u0031", "\u0032", "\u0033", "\u0034", "\u0035", "\u0036", "\u0037", "\u0038", "\u0039", "\u0031\u0030", "\u0031\u0031", "\u0031\u0032");
            DateTimeInfo.RokuyouTextArray = new Array("\u5148\u52dd", "\u53cb\u5f15", "\u5148\u8ca0", "\u4ecf\u6ec5", "\u5927\u5b89", "\u8d64\u53e3");
            DateTimeInfo.RokuyouTextArrayEn = new Array("Senshou", "Tomobiki", "Senbu", "Butsumetsu", "Taian", "Shakkou");
            DateTimeInfo.DefaultTwoDigitYear = 2029;
            DateTimeInfo.Digits = 2;
            DateTimeInfo.EraYearMax = 99;
            DateTimeInfo.RokuyouMin = new Date(1960, 0, 28);
            DateTimeInfo.RokuyouMax = new Date(2050, 0, 22);
            DateTimeInfo.LunarInfo = new Array(0x0aea6, 0x0ab50, 0x04d60, 0x0aae4, 0x0a570, 0x05270, 0x07263, 0x0d950, 0x06b57, 0x056a0, 0x09ad0, 0x04dd5, 0x04ae0, 0x0a4e0, 0x0d4d4, 0x0d250, 0x0d598, 0x0b540, 0x0d6a0, 0x0195a6, 0x095b0, 0x049b0, 0x0a9b4, 0x0a4b0, 0x0b27a, 0x06a50, 0x06d40, 0x0b756, 0x02b60, 0x095b0, 0x04b75, 0x04970, 0x064b0, 0x074a3, 0x0ea50, 0x06d98, 0x055d0, 0x02b60, 0x096e5, 0x092e0, 0x0c960, 0x0e954, 0x0d4a0, 0x0da50, 0x07552, 0x056c0, 0x0abb7, 0x025d0, 0x092d0, 0x0cab5, 0x0a950, 0x0b4a0, 0x1b4a3, 0x0b550, 0x055d9, 0x04ba0, 0x0a5b0, 0x05575, 0x052b0, 0x0a950, 0x0b954, 0x06aa0, 0x0ad50, 0x06b52, 0x04b60, 0x0a6e6, 0x0a570, 0x05270, 0x06a65, 0x0d930, 0x05aa0, 0x0b6a3, 0x096d0, 0x04bd7, 0x04ae0, 0x0a4d0, 0x01d0d6, 0x0d250, 0x0d520, 0x0dd45, 0x0b6a0, 0x096d0, 0x055b2, 0x049b0, 0x0a577, 0x0a4b0, 0x0b250, 0x01b255, 0x06d40, 0x0ada0);
            return DateTimeInfo;
        })();
        input.DateTimeInfo = DateTimeInfo;

        

        /** @ignore */
        var wijDateTextFormatter = (function () {
            function wijDateTextFormatter(inputWidget, format, isDisplayFormat) {
                this.inputWidget = inputWidget;
                this.maskPartsCount = 0;
                this.isDisplayFormat = true;
                this.pattern = 'M/d/yyyy';
                this.descriptors = new Array(0);
                this.desPostions = new Array(0);
                this.fields = new Array(0);
                this.isDisplayFormat = isDisplayFormat;
                this._setFormat(format);
            }
            wijDateTextFormatter.prototype._parseFormat = function (pattern) {
                var descriptors = [];
                var curPattern = '', prevCh = '', isBegin = false, liternalNext = false, i, ch;
                for (i = 0; i < pattern.length; i++) {
                    ch = pattern.charAt(i);
                    if (liternalNext) {
                        descriptors.push(this.createDescriptor(-1, ch));
                        curPattern = '';
                        liternalNext = false;
                        continue;
                    }
                    if (ch === '\\') {
                        liternalNext = true;
                        if (curPattern.length > 0) {
                            if (!this.handlePattern(curPattern, descriptors)) {
                                descriptors.push(this.createDescriptor(-1, prevCh));
                            }
                            curPattern = '';
                        }
                        continue;
                    }
                    if (ch === '\'') {
                        if (isBegin) {
                            isBegin = false;
                            curPattern = '';
                        } else {
                            isBegin = true;
                            if (curPattern.length > 0) {
                                if (!this.handlePattern(curPattern, descriptors)) {
                                    descriptors.push(this.createDescriptor(-1, prevCh));
                                }
                                curPattern = '';
                            }
                        }
                        continue;
                    }
                    if (isBegin) {
                        descriptors.push(this.createDescriptor(-1, ch));
                        curPattern = '';
                        continue;
                    }
                    if (!i) {
                        prevCh = ch;
                    }
                    if (prevCh !== ch && curPattern.length > 0) {
                        if (!this.handlePattern(curPattern, descriptors)) {
                            descriptors.push(this.createDescriptor(-1, prevCh));
                        }
                        curPattern = '';
                    }
                    curPattern += ch;
                    prevCh = ch;
                }
                if (curPattern.length > 0) {
                    if (!this.handlePattern(curPattern, descriptors)) {
                        descriptors.push(this.createDescriptor(-1, prevCh));
                    }
                }

                return descriptors;
            };

            wijDateTextFormatter.prototype._parseFormatToPattern = function (format) {
                var cf = this.inputWidget._getCulture().calendar, pattern = cf.patterns.d;
                if (format.length <= 1) {
                    switch (format) {
                        case "":
                        case "d":
                            pattern = cf.patterns.d;
                            break;
                        case "D":
                            pattern = cf.patterns.D;
                            break;
                        case "f":
                            pattern = cf.patterns.D + " " + cf.patterns.t;
                            break;
                        case "F":
                            pattern = cf.patterns.D + " " + cf.patterns.T;
                            break;
                        case "g":
                            pattern = cf.patterns.d + " " + cf.patterns.t;
                            break;
                        case "G":
                            pattern = cf.patterns.d + " " + cf.patterns.T;
                            break;
                        case "m":
                            pattern = cf.patterns.M;
                            break;
                        case "M":
                            pattern = cf.patterns.M;
                            break;
                        case "s":
                            pattern = cf.patterns.S;
                            break;
                        case "t":
                            pattern = cf.patterns.t;
                            break;
                        case "T":
                            pattern = cf.patterns.T;
                            break;
                        case "u":
                            pattern = cf.patterns.S;
                            break;
                        case "U":
                            // Full date and time (long date and long time) using universal time
                            pattern = cf.patterns.D + " " + cf.patterns.T;
                            break;
                        case "y":
                            pattern = cf.patterns.Y;
                            break;
                        case "Y":
                            pattern = cf.patterns.Y;
                            break;
                        case "r":
                        case "R":
                            pattern = "ddd, dd MMM yyyy HH:mm:ss G\\M\\T";
                            break;
                        case "E":
                            pattern = "E";
                            break;
                    }
                } else {
                    pattern = format;
                }

                return pattern;
            };

            wijDateTextFormatter.prototype.createDescriptor = function (t, liternal) {
                var desc = null, id = this.maskPartsCount++;
                switch (t) {
                    case -1:
                        desc = new _dateDescriptor(this, id);
                        desc.liternal = liternal;
                        break;
                    case 20:
                        desc = new _dateDescriptor20(this, id);
                        break;
                    case 25:
                        desc = new _dateDescriptor25(this, id);
                        break;
                    case 26:
                        desc = new _dateDescriptor26(this, id);
                        break;
                    case 27:
                        desc = new _dateDescriptor27(this, id);
                        break;
                    case 30:
                        desc = new _dateDescriptor30(this, id);
                        break;
                    case 31:
                        desc = new _dateDescriptor31(this, id);
                        break;
                    case 100:
                        desc = new _dateDescriptor100(this, id);
                        break;
                    case 101:
                        desc = new _dateDescriptor101(this, id);
                        break;
                    case 10:
                        desc = new _dateDescriptor10(this, id);
                        break;
                    case 1:
                        desc = new _dateDescriptor1(this, id);
                        break;
                    case 2:
                        desc = new _dateDescriptor2(this, id);
                        break;
                    case 45:
                        desc = new _dateDescriptor45(this, id);
                        break;
                    case 46:
                        desc = new _dateDescriptor46(this, id);
                        break;
                    case 47:
                        desc = new _dateDescriptor47(this, id);
                        break;
                    case 48:
                        desc = new _dateDescriptor48(this, id);
                        break;
                    case 250:
                        desc = new _dateDescriptor250(this, id);
                        break;
                    case 251:
                        desc = new _dateDescriptor251(this, id);
                        break;
                    case 50:
                        desc = new _dateDescriptor50(this, id);
                        break;
                    case 51:
                        desc = new _dateDescriptor51(this, id);
                        break;
                    case 60:
                        desc = new _dateDescriptor60(this, id);
                        break;
                    case 61:
                        desc = new _dateDescriptor61(this, id);
                        break;
                    case 70:
                        desc = new _dateDescriptor70(this, id);
                        break;
                    case 71:
                        desc = new _dateDescriptor71(this, id);
                        break;
                    case 72:
                        desc = new _dateDescriptor72(this, id);
                        break;
                    case 73:
                        desc = new _dateDescriptor73(this, id);
                        break;
                    case 74:
                        desc = new _dateDescriptor74(this, id);
                        break;
                    case 75:
                        desc = new _dateDescriptor75(this, id);
                        break;
                    case 80:
                        desc = new _dateDescriptor80(this, id);
                        break;
                    default:
                        break;
                }
                return desc;
            };

            wijDateTextFormatter.prototype.handlePattern = function (p, descriptors) {
                var reg = new RegExp('y{3,10}'), suc = reg.test(p);
                if (suc) {
                    if (this.inputWidget) {
                        if (this.inputWidget.options.cultureCalendar === "Japanese") {
                            descriptors.push(this.createDescriptor(71));
                            return true;
                        }
                    }
                    descriptors.push(this.createDescriptor(10));
                    return true;
                }
                reg = new RegExp('y{2,2}');
                suc = reg.test(p);
                if (suc) {
                    if (this.inputWidget) {
                        if (this.inputWidget.options.cultureCalendar === "Japanese") {
                            descriptors.push(this.createDescriptor(71));
                            return true;
                        }
                    }
                    descriptors.push(this.createDescriptor(2));
                    return true;
                }
                reg = new RegExp('y{1,1}');
                suc = reg.test(p);
                if (suc) {
                    if (this.inputWidget) {
                        if (this.inputWidget.options.cultureCalendar === "Japanese") {
                            descriptors.push(this.createDescriptor(70));
                            return true;
                        }
                    }
                    descriptors.push(this.createDescriptor(1));
                    return true;
                }
                reg = new RegExp('d{4,4}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(101));
                    return true;
                }
                reg = new RegExp('d{3,3}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(100));
                    return true;
                }
                reg = new RegExp('d{2,2}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(30));
                    return true;
                }
                reg = new RegExp('d{1,1}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(31));
                    return true;
                }
                reg = new RegExp('M{4,4}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(27));
                    return true;
                }
                reg = new RegExp('M{3,3}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(26));
                    return true;
                }
                reg = new RegExp('M{2,2}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(20));
                    return true;
                }
                reg = new RegExp('M{1,1}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(25));
                    return true;
                }
                reg = new RegExp('h{2,2}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(46));
                    return true;
                }
                reg = new RegExp('h{1,1}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(45));
                    return true;
                }
                reg = new RegExp('H{2,2}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(48));
                    return true;
                }
                reg = new RegExp('H{1,1}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(47));
                    return true;
                }
                reg = new RegExp('m{2,2}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(50));
                    return true;
                }
                reg = new RegExp('m{1,1}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(51));
                    return true;
                }
                reg = new RegExp('s{2,2}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(60));
                    return true;
                }
                reg = new RegExp('s{1,1}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(61));
                    return true;
                }
                reg = new RegExp('t{2,2}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(251));
                    return true;
                }
                reg = new RegExp('t{1,1}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(250));
                    return true;
                }
                reg = new RegExp('e{2,10}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(71));
                    return true;
                }
                reg = new RegExp('e{1,1}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(70));
                    return true;
                }
                reg = new RegExp('g{3,10}');
                suc = reg.test(p);
                if (suc) {
                    descriptors.push(this.createDescriptor(74));
                    return true;
                }
                reg = new RegExp('g{2,2}');
                suc = reg.test(p);
                if (suc) {
                    if (this.inputWidget) {
                        if (this.inputWidget.options.cultureCalendar === "Japanese") {
                            descriptors.push(this.createDescriptor(74));
                            return true;
                        }
                    }
                    descriptors.push(this.createDescriptor(73));
                    return true;
                }
                reg = new RegExp('g{1,1}');
                suc = reg.test(p);
                if (suc) {
                    if (this.inputWidget) {
                        if (this.inputWidget.options.cultureCalendar === "Japanese") {
                            descriptors.push(this.createDescriptor(74));
                            return true;
                        }
                    }
                    descriptors.push(this.createDescriptor(72));
                    return true;
                }

                if (this.isDisplayFormat) {
                    reg = new RegExp('E{1,10}');
                    suc = reg.test(p);
                    if (suc) {
                        descriptors.push(this.createDescriptor(75));
                        return true;
                    }

                    reg = new RegExp('A{1,1}');
                    suc = reg.test(p);
                    if (suc) {
                        descriptors.push(this.createDescriptor(80));
                        return true;
                    }
                }

                return false;
            };

            wijDateTextFormatter.prototype.daysInMonth = function (m, y) {
                m = m - 1;
                var d = new Date(y, ++m, 1, -1).getDate();
                return d;
            };

            wijDateTextFormatter.prototype._isDigitString = function (s) {
                s = $.trim(s);
                if (s.length === 0) {
                    return true;
                }

                var c = s.charAt(0), f, t;
                if (c === '+' || c === '-') {
                    s = s.substr(1);
                    s = $.trim(s);
                }
                if (s.length === 0) {
                    return true;
                }
                try  {
                    f = parseFloat(s);
                    t = f.toString();
                    return t === s;
                } catch (e) {
                    return false;
                }
            };

            wijDateTextFormatter.prototype._internalSetDate = function (date) {
                if (this.inputWidget) {
                    this.inputWidget._internalSetDate(date);
                }
            };

            wijDateTextFormatter.prototype._isValidDate = function (dt) {
                return this.inputWidget._isValidDate(dt);
            };

            wijDateTextFormatter.prototype._setFormat = function (format) {
                var culture = this.inputWidget._getCulture();
                if (culture == null) {
                    return;
                }

                this.pattern = this._parseFormatToPattern(format);
                this.descriptors = this._parseFormat(this.pattern);
                this.fields = $.grep(this.descriptors, function (d) {
                    return d.type !== -1;
                });
            };

            wijDateTextFormatter.prototype._isEraFormatExist = function () {
                for (var i = 0; i < this.descriptors.length; i++) {
                    if (this.descriptors[i].type >= 70 && this.descriptors[i].type <= 75) {
                        return true;
                    }
                }

                return false;
            };

            wijDateTextFormatter.prototype.getDate = function () {
                return (!!this.inputWidget) ? new Date(this.inputWidget._safeGetDate(true).getTime()) : undefined;
            };

            wijDateTextFormatter.prototype.setDate = function (value) {
                if (this.inputWidget) {
                    this.inputWidget._setData(value);
                }
            };

            wijDateTextFormatter.prototype.getYear = function () {
                return this.getDate().getFullYear();
            };

            wijDateTextFormatter.prototype.setYear = function (val, resultObj, chkBounds) {
                try  {
                    if (resultObj && resultObj.isfullreset) {
                        resultObj.offset = 1;
                        val = '1970';
                    }
                    if (typeof val === 'string') {
                        if (!this._isDigitString(val)) {
                            return false;
                        }
                    }
                    val = val * 1;

                    var o = this.inputWidget.options, minYear = 1, maxYear = 9999, currentDate, testDate, mmm;

                    if (chkBounds) {
                        if (o.minDate) {
                            minYear = Math.max(minYear, o.minDate.getFullYear());
                        }

                        if (o.maxDate) {
                            maxYear = Math.min(maxYear, o.maxDate.getFullYear());
                        }
                    }

                    if (resultObj && resultObj.isreset) {
                        val = minYear;
                    }

                    if (val < minYear) {
                        val = minYear;
                    }

                    if (val > maxYear) {
                        val = maxYear;
                    }

                    currentDate = this.getDate();
                    testDate = new Date(currentDate.getTime());
                    testDate.setFullYear(val);
                    if (this._isValidDate(testDate)) {
                        mmm = this.daysInMonth(this.getMonth(), this.getYear());
                        if (mmm === currentDate.getDate()) {
                            testDate = new Date(currentDate.getTime());
                            testDate.setDate(1);
                            testDate.setFullYear(val);

                            //mmm = this.daysInMonth((testDate.getMonth() + 1),
                            //   testDate.getFullYear());
                            testDate.setDate(mmm);
                            if (this._isValidDate(testDate)) {
                                this._internalSetDate(testDate);
                                return true;
                            } else {
                                return false;
                            }
                        }
                        currentDate.setFullYear(val);
                        this._internalSetDate(currentDate);
                        return true;
                    } else {
                        if (resultObj && resultObj.isreset) {
                            currentDate.setFullYear(1);
                            this._internalSetDate(currentDate);
                            return true;
                        }
                        return false;
                    }
                } catch (e) {
                    return false;
                }
            };

            wijDateTextFormatter.prototype.getMonth = function () {
                return (this.getDate().getMonth() + 1);
            };

            wijDateTextFormatter.prototype.setMonth = function (val, allowChangeOtherParts, resultObj) {
                try  {
                    if (resultObj && resultObj.isfullreset) {
                        val = '1';
                    }
                    val = val * 1;
                    var currentDate = this.getDate(), mmm, testDate;
                    if (typeof (allowChangeOtherParts) !== 'undefined' && !allowChangeOtherParts) {
                        if (val > 12 || val < 1) {
                            if (resultObj && resultObj.isreset) {
                                val = 1;
                            } else {
                                return false;
                            }
                        }
                    }
                    mmm = this.daysInMonth(this.getMonth(), this.getYear());
                    if (mmm === this.getDate().getDate()) {
                        testDate = new Date(currentDate.getTime());
                        testDate.setDate(1);
                        testDate.setMonth(val - 1);
                        mmm = this.daysInMonth((testDate.getMonth() + 1), testDate.getFullYear());
                        testDate.setDate(mmm);
                        if (this._isValidDate(testDate)) {
                            this._internalSetDate(testDate);
                            return true;
                        } else {
                            return false;
                        }
                    } else {
                        testDate = new Date(currentDate.getTime());
                        testDate.setMonth(val - 1);
                        if (this._isValidDate(testDate)) {
                            this._internalSetDate(testDate);
                            return true;
                        } else {
                            return false;
                        }
                    }
                } catch (e) {
                    return false;
                }
            };

            wijDateTextFormatter.prototype.getHours = function () {
                return this.getDate().getHours();
            };

            wijDateTextFormatter.prototype.setHours = function (val, allowChangeOtherParts) {
                try  {
                    val = val * 1;
                    if (typeof (allowChangeOtherParts) !== 'undefined' && !allowChangeOtherParts) {
                        if (val > 24) {
                            return false;
                        }
                    }
                    var testDate = new Date(this.getDate().getTime());
                    testDate.setHours(val);
                    if (this._isValidDate(testDate)) {
                        this._internalSetDate(testDate);
                        return true;
                    } else {
                        return false;
                    }
                } catch (e) {
                    return false;
                }
            };

            wijDateTextFormatter.prototype.getMinutes = function () {
                return this.getDate().getMinutes();
            };

            wijDateTextFormatter.prototype.setMinutes = function (val, allowChangeOtherParts) {
                try  {
                    val = val * 1;
                    if (typeof (allowChangeOtherParts) !== 'undefined' && !allowChangeOtherParts) {
                        if (val > 60) {
                            return false;
                        }
                    }
                    var testDate = new Date(this.getDate().getTime());
                    testDate.setMinutes(val);
                    if (this._isValidDate(testDate)) {
                        this._internalSetDate(testDate);
                        return true;
                    } else {
                        return false;
                    }
                } catch (e) {
                    return false;
                }
            };

            wijDateTextFormatter.prototype.getSeconds = function () {
                return this.getDate().getSeconds();
            };

            wijDateTextFormatter.prototype.setSeconds = function (val, allowChangeOtherParts) {
                try  {
                    val = val * 1;
                    if (typeof (allowChangeOtherParts) !== 'undefined' && !allowChangeOtherParts) {
                        if (val > 60) {
                            return false;
                        }
                    }
                    var testDate = new Date(this.getDate().getTime());
                    testDate.setSeconds(val);
                    if (this._isValidDate(testDate)) {
                        this._internalSetDate(testDate);
                        return true;
                    } else {
                        return false;
                    }
                } catch (e) {
                    return false;
                }
            };

            wijDateTextFormatter.prototype.getDayOfMonth = function () {
                return this.getDate().getDate();
            };

            wijDateTextFormatter.prototype.setDayOfMonth = function (val, allowChangeOtherParts, resultObj) {
                try  {
                    if (resultObj && resultObj.isfullreset) {
                        return this.setDayOfMonth(1, allowChangeOtherParts);
                    }
                    var currentDate = this.getDate(), mmm, testDate;
                    val = val * 1;
                    if (typeof (allowChangeOtherParts) !== 'undefined' && !allowChangeOtherParts) {
                        mmm = this.daysInMonth(this.getMonth(), this.getYear());
                        if (val > mmm || val < 1) {
                            if (resultObj && resultObj.isreset) {
                                return this.setDayOfMonth(1, allowChangeOtherParts, resultObj);
                            }
                            return false;
                        }
                    }
                    testDate = new Date(currentDate.getTime());
                    testDate.setDate(val);
                    if (this._isValidDate(testDate)) {
                        this._internalSetDate(testDate);
                        return true;
                    } else {
                        return false;
                    }
                } catch (e) {
                    return false;
                }
            };

            wijDateTextFormatter.prototype.getDayOfWeek = function () {
                return (this.getDate().getDay() + 1);
            };

            wijDateTextFormatter.prototype.setDayOfWeek = function (val) {
                try  {
                    val = val * 1;
                    var aDif = val - this.getDayOfWeek();
                    return this.setDayOfMonth(this.getDayOfMonth() + aDif, true);
                } catch (e) {
                    return false;
                }
            };

            wijDateTextFormatter.prototype._getCulture = function () {
                return this.inputWidget._getCulture();
            };

            wijDateTextFormatter.prototype.findAlikeArrayItemIndex = function (arr, txt) {
                var index = -1, pos = 99999, i, k;
                for (i = 0; i < arr.length; i++) {
                    k = arr[i].toLowerCase().indexOf(txt.toLowerCase());
                    if (k !== -1 && k < pos) {
                        pos = k;
                        index = i;
                    }
                }
                return index;
            };

            wijDateTextFormatter.prototype.toString = function () {
                if (this._isEraFormatExist()) {
                    if (this.inputWidget.options.date != null) {
                        var minDate = this.inputWidget._getRealEraMinDate();
                        var maxDate = this.inputWidget._getRealEraMaxDate();
                        if (this.inputWidget.options.date < minDate || this.inputWidget.options.date > maxDate) {
                            return "";
                        }
                    }
                }

                var s = '', l = 0, i, txt, j;
                this.desPostions = new Array(0);
                for (i = 0; i < this.descriptors.length; i++) {
                    this.descriptors[i].startIndex = s.length;
                    txt = '' || this.descriptors[i].getText();
                    s += txt;
                    for (j = 0; j < txt.length; j++) {
                        this.desPostions.push({
                            desc: this.descriptors[i],
                            pos: j,
                            text: txt,
                            length: txt.length
                        });
                        l++;
                        if (this.desPostions.length !== l) {
                            throw 'Fatal Error !!!!!!!!!!!!!!!';
                        }
                    }
                }
                return s;
            };
            return wijDateTextFormatter;
        })();
        input.wijDateTextFormatter = wijDateTextFormatter;
        ;

        //#region format library
        /** @ignore */
        var wijInputDateImpl = (function () {
            function wijInputDateImpl(options) {
                this.options = options;
                options.format = options.format || "M/d/yyyy";
                options.amDesignator = options.amDesignator || "";
                options.pmDesignator = options.pmDesignator || "";
                if (options.hour12As0 === undefined) {
                    options.hour12As0 = false;
                }
                if (options.midnightAs0 === undefined) {
                    options.midnightAs0 = true;
                }
            }
            wijInputDateImpl.prototype._getInnerIncrement = function () {
                return 1;
            };

            wijInputDateImpl.prototype._getCulture = function () {
                return Globalize.findClosestCulture(this.options.culture);
            };

            wijInputDateImpl.prototype._getRealEraMaxDate = function () {
                if (this.options.maxDate) {
                    return DateTimeInfo.GetEraMax() < this.options.maxDate ? DateTimeInfo.GetEraMax() : this.options.maxDate;
                }

                return DateTimeInfo.GetEraMax();
            };

            wijInputDateImpl.prototype._getRealEraMinDate = function () {
                if (this.options.minDate) {
                    return DateTimeInfo.GetEraMin() > this.options.minDate ? DateTimeInfo.GetEraMin() : this.options.minDate;
                }

                return DateTimeInfo.GetEraMin();
            };

            wijInputDateImpl.prototype._safeGetDate = function (ignoreCheckRange) {
                var date = this.options.date;
                if (date == null) {
                    date = new Date();
                }
                if (!ignoreCheckRange) {
                    date = this._checkRange(date);
                }
                return date;
            };

            wijInputDateImpl.prototype._safeSetDate = function (date, ignoreCheckRange) {
                var cache = date;

                if (!ignoreCheckRange) {
                    date = this._checkRange(date);
                }

                if (isNaN(date)) {
                    date = cache;
                }

                this.options.date = date;
                return true;
            };

            wijInputDateImpl.prototype._getAllowSpinLoop = function () {
                return false;
            };

            wijInputDateImpl.prototype._getRealMinDate = function () {
                if (this.options.minDate) {
                    return this.options.minDate;
                }

                var minDate = new Date(1, 0, 1, 0, 0, 0);
                minDate.setFullYear(1);

                return minDate;
            };

            wijInputDateImpl.prototype._getRealMaxDate = function () {
                return this.options.maxDate ? this.options.maxDate : new Date(9999, 11, 31, 23, 59, 59);
            };

            wijInputDateImpl.prototype._setData = function (val) {
                this.options.date = val;
            };

            wijInputDateImpl.prototype._isValidDate = function (date, chkBounds) {
                if (date === undefined) {
                    return false;
                }

                if (isNaN(date)) {
                    return false;
                }

                if (date.getFullYear() < 1 || date.getFullYear() > 9999) {
                    return false;
                }

                if (chkBounds) {
                    if (this.options.minDate) {
                        if (date < this.options.minDate) {
                            return false;
                        }
                    }

                    if (this.options.maxDate) {
                        if (date > this.options.maxDate) {
                            return false;
                        }
                    }
                }

                return true;
            };

            wijInputDateImpl.prototype._getInnerAmDesignator = function () {
                return this.options.amDesignator == "" ? this._getStandardAMPM("AM") : this.options.amDesignator;
            };

            wijInputDateImpl.prototype._getInnerPmDesignator = function () {
                return this.options.pmDesignator == "" ? this._getStandardAMPM("PM") : this.options.pmDesignator;
            };

            wijInputDateImpl.prototype.isFocused = function () {
                return false;
            };

            wijInputDateImpl.prototype._internalSetDate = function (date) {
            };

            wijInputDateImpl.prototype._checkRange = function (date) {
                if (date) {
                    if (this.options.minDate && date < this.options.minDate) {
                        date = new Date(Math.max(this.options.minDate.valueOf(), date.valueOf()));
                    }

                    if (this.options.maxDate && date > this.options.maxDate) {
                        date = new Date(Math.min(this.options.maxDate.valueOf(), date.valueOf()));
                    }
                }

                return date;
            };

            wijInputDateImpl.prototype._getStandardAMPM = function (value) {
                var culture = this._getCulture();
                if (culture && culture.calendar) {
                    var tmp = culture.calendars.standard[value];
                    if (tmp) {
                        return tmp[0];
                    }
                }
                return value;
            };
            return wijInputDateImpl;
        })();
        input.wijInputDateImpl = wijInputDateImpl;

        function dateFormatter(date, format, options) {
            if (!(date instanceof Date)) {
                return "";
            }
            if (!format) {
                format = 'd';
            }

            if (!options) {
                if (typeof format === "string") {
                    options = {};
                } else {
                    options = format;
                }
            }
            if (typeof format === "string") {
                options.format = format;
            }
            options.date = date;

            var wijInputDate = new wijInputDateImpl(options);

            var _formatter = new wijDateTextFormatter(wijInputDate, options.format, true);

            return _formatter.toString();
        }

        var $ = jQuery;
        $.wijinputcore = $.wijinputcore || {};
        ;
        $.wijinputcore.formatdate = $.wijinputcore.formatdate || dateFormatter;

        //#endregion
        //#region parse library
        function dateParser(value, format, culture) {
            if (Globalize.findClosestCulture(format)) {
                culture = format;
                format = undefined;
            }

            var cf = Globalize.findClosestCulture(culture).calendars.standard, pattern = cf.patterns.d;

            if (format) {
                if (format.length <= 1) {
                    pattern = parseShortPattern(format, cf.patterns);
                } else {
                    pattern = format;
                }
            } else {
                pattern = cf.patterns.d;
            }

            var wijInputDate = new wijInputDateImpl({});
            var _formatter = new wijDateTextFormatter(wijInputDate, pattern, true);

            if (hasEraYear(_formatter.descriptors)) {
                return parseEraDate(value, _formatter, cf);
            } else {
                return Globalize.parseDate(value, pattern, culture);
            }
        }

        function hasEraYear(descriptors) {
            for (var i = 0; i < descriptors.length; i++) {
                if (descriptors[i].type === 70 /* EraYear */ || descriptors[i].type === 71 /* TwoEraYear */ || descriptors[i].type === 72 /* EraName */ || descriptors[i].type === 73 /* TwoEraName */ || descriptors[i].type === 74 /* ThreeEraName */ || descriptors[i].type === 75 /* EraYearBig */) {
                    return true;
                }
            }
            return false;
        }

        function parseEraDate(value, _formatter, cultureFormat) {
            var ch = "", chs = "", charIndex = 0;
            var era = 0, eraYear = 1, month = 1, date = 1, hour = 0, minute = 0, second = 0;

            var isNextReachSeparator = function () {
                return (charIndex < value.length && i + 1 < _formatter.descriptors.length && _formatter.descriptors[i + 1].type === -1 /* liternal */ && value.charAt(charIndex) !== _formatter.descriptors[i + 1].liternal || i === _formatter.descriptors.length - 1 && charIndex + 1 <= value.length);
            };

            for (var i = 0; i < _formatter.descriptors.length; i++) {
                var breakToNextDesc = false;

                for (; charIndex < value.length;) {
                    ch = value.charAt(charIndex++);
                    chs += ch;

                    for (var j = 0; j < DateTimeInfo.GetEraCount(); j++) {
                        var isMatched_g = chs.toLocaleLowerCase() === DateTimeInfo.GetEraShortNames()[j].toLowerCase() && _formatter.descriptors[i].type === 72 /* EraName */;
                        var isMatched_gg = chs.toLocaleLowerCase() === DateTimeInfo.GetEraAbbreviations()[j].toLowerCase() && _formatter.descriptors[i].type === 73 /* TwoEraName */;
                        var isMatched_ggg = chs.toLocaleLowerCase() === DateTimeInfo.GetEraNames()[j].toLowerCase() && _formatter.descriptors[i].type === 74 /* ThreeEraName */;

                        if (isMatched_g || isMatched_gg || isMatched_ggg) {
                            era = j;
                            chs = "";
                            breakToNextDesc = true;
                            break;
                        }
                    }
                    if (breakToNextDesc) {
                        break;
                    }

                    if (_formatter.descriptors[i].type === -1 /* liternal */ && _formatter.descriptors[i].liternal === chs) {
                        chs = "";
                        break;
                    }

                    switch (_formatter.descriptors[i].type) {
                        case 70 /* EraYear */:
                        case 71 /* TwoEraYear */:
                            if (isNextReachSeparator()) {
                                break;
                            }

                            eraYear = parseInt(chs, 10);
                            if (isNaN(eraYear)) {
                                eraYear = 1;
                            }
                            chs = "";
                            breakToNextDesc = true;
                            break;
                        case 75 /* EraYearBig */:
                            if (isNextReachSeparator()) {
                                break;
                            }

                            if (chs === '\u5143') {
                                eraYear = 1;
                            } else {
                                eraYear = parseInt(chs, 10);
                                if (isNaN(eraYear)) {
                                    eraYear = 1;
                                }
                            }
                            chs = "";
                            breakToNextDesc = true;
                            break;
                        case 20 /* TwoDigitMonth */:
                        case 25 /* Month */:
                            if (isNextReachSeparator()) {
                                break;
                            }

                            month = parseInt(chs, 10);
                            if (isNaN(month)) {
                                month = 1;
                            }
                            chs = "";
                            breakToNextDesc = true;
                            break;
                        case 26 /* AbbreviatedMonthNames */:
                            if (isNextReachSeparator()) {
                                break;
                            }
                            for (var m = 0; m < cultureFormat.months.namesAbbr.length; m++) {
                                if (chs.toLocaleLowerCase() === cultureFormat.months.namesAbbr[m]) {
                                    month = m + 1;
                                    chs = "";
                                    break;
                                }
                            }
                            breakToNextDesc = true;
                            break;
                        case 27 /* MonthNames */:
                            if (isNextReachSeparator()) {
                                break;
                            }
                            for (var k = 0; k < cultureFormat.months.names.length; k++) {
                                if (chs.toLocaleLowerCase() === cultureFormat.months.names[k]) {
                                    month = k + 1;
                                    chs = "";
                                    break;
                                }
                            }
                            breakToNextDesc = true;
                            break;
                        case 30 /* TwoDigityDayOfMonth */:
                        case 31 /* DayOfMonth */:
                            if (isNextReachSeparator()) {
                                break;
                            }

                            date = parseInt(chs, 10);
                            if (isNaN(date)) {
                                date = 1;
                            }
                            chs = "";
                            breakToNextDesc = true;
                            break;

                        case 45 /* h */:
                        case 46 /* hh */:
                        case 47 /* H */:
                        case 48 /* HH */:
                            if (isNextReachSeparator()) {
                                break;
                            }

                            hour = parseInt(chs, 10);
                            if (isNaN(hour)) {
                                hour = 1;
                            }
                            chs = "";
                            breakToNextDesc = true;
                            break;

                        case 51 /* m */:
                        case 50 /* mm */:
                            if (isNextReachSeparator()) {
                                break;
                            }

                            minute = parseInt(chs, 10);
                            if (isNaN(minute)) {
                                minute = 1;
                            }
                            chs = "";
                            breakToNextDesc = true;
                            break;
                        case 61 /* s */:
                        case 60 /* ss */:
                            if (isNextReachSeparator()) {
                                break;
                            }

                            second = parseInt(chs, 10);
                            if (isNaN(second)) {
                                second = 1;
                            }
                            chs = "";
                            breakToNextDesc = true;
                            break;

                        case 250 /* ShortAmPm */:
                        case 251 /* AmPm */:
                            if (isNextReachSeparator()) {
                                break;
                            }
                            for (var l = 0; l < cultureFormat.PM.length; l++) {
                                if (chs.toLocaleLowerCase() === cultureFormat.PM[l]) {
                                    hour += 12;
                                    break;
                                }
                            }
                            chs = "";
                            breakToNextDesc = true;
                            break;

                        case 1 /* OneDigitYear */:
                        case 2 /* TwoDigitYear */:
                        case 10 /* FourDigitYear */:

                        case 100 /* AbbreviatedDayNames */:
                        case 101 /* DayNames */:

                        case 80 /* AD */:
                            if (isNextReachSeparator()) {
                                break;
                            }

                            chs = "";
                            breakToNextDesc = true;
                            break;

                        default:
                    }
                    if (breakToNextDesc) {
                        break;
                    }
                }
            }

            return DateTimeInfo.ConvertToGregorianDate(era, eraYear, month, date, hour, minute, second, false);
        }

        function parseShortPattern(shortPattern, culturePatterns) {
            var pattern = shortPattern;
            if (shortPattern && shortPattern.length <= 1) {
                switch (shortPattern) {
                    case "":
                    case "d":
                        pattern = culturePatterns.patterns.d;
                        break;
                    case "D":
                        pattern = culturePatterns.patterns.D;
                        break;
                    case "f":
                        pattern = culturePatterns.patterns.D + " " + culturePatterns.patterns.t;
                        break;
                    case "F":
                        pattern = culturePatterns.patterns.D + " " + culturePatterns.patterns.T;
                        break;
                    case "g":
                        pattern = culturePatterns.patterns.d + " " + culturePatterns.patterns.t;
                        break;
                    case "G":
                        pattern = culturePatterns.patterns.d + " " + culturePatterns.patterns.T;
                        break;
                    case "m":
                        pattern = culturePatterns.patterns.M;
                        break;
                    case "M":
                        pattern = culturePatterns.patterns.M;
                        break;
                    case "s":
                        pattern = culturePatterns.patterns.S;
                        break;
                    case "t":
                        pattern = culturePatterns.patterns.t;
                        break;
                    case "T":
                        pattern = culturePatterns.patterns.T;
                        break;
                    case "u":
                        pattern = culturePatterns.patterns.S;
                        break;
                    case "U":
                        // Full date and time (long date and long time) using universal time
                        pattern = culturePatterns.patterns.D + " " + culturePatterns.patterns.T;
                        break;
                    case "y":
                        pattern = culturePatterns.patterns.Y;
                        break;
                    case "Y":
                        pattern = culturePatterns.patterns.Y;
                        break;
                    case "r":
                    case "R":
                        pattern = "ddd, dd MMM yyyy HH:mm:ss G\\M\\T";
                        break;
                }
            }
            return pattern;
        }

        $.wijinputcore.parseDate = $.wijinputcore.parseDate || dateParser;

        //#endregion
        //#region validate library
        function dateValidator(value, minDate, maxDate, format, culture) {
            var dateValue = dateParser(value, format, culture);
            return dateValue >= minDate && dateValue <= maxDate;
        }

        $.wijinputcore.validateDate = $.wijinputcore.validateDate || dateValidator;
    })(wijmo.input || (wijmo.input = {}));
    var input = wijmo.input;
})(wijmo || (wijmo = {}));
;
/// <reference path="jquery.wijmo.wijinputcore.ts"/>
/// <reference path="jquery.wijmo.wijinputdateformat.ts"/>
var wijmo;
(function (wijmo) {
    (function (input) {
        /** @ignore */
        var wijinputdateroller = (function () {
            function wijinputdateroller(owner) {
                this._owner = owner;
            }
            //#endregion
            //#region DatePicker
            wijinputdateroller.prototype._initDatePicker = function () {
                var datePicker = this._owner.element.data('datePicker');
                if (datePicker != undefined) {
                    return;
                }

                var self = this;
                var minYear = this._owner.element.data('pickerMinYear');
                var maxYear = this._owner.element.data('pickerMaxYear');
                var height = this._owner.element.data('itemHeight') * 5;
                var pickerWidth = this._owner.element.data('pickerWidth');
                var itemHeight = this._owner.element.data('itemHeight') + "px";
                var indicatorHeight = this._owner.element.data('indicatorHeight') + "px";
                var indicatorTranslateTop = this._owner.element.data('indicatorTranslateTop');
                var indicatorTranslateDown = this._owner.element.data('indicatorTranslateDown');
                var indicatorTranslateSelector = this._owner.element.data('indicatorTranslateSelector');
                var indicatorTranslateContent = this._owner.element.data('indicatorTranslateContent');

                var div = this._createDivElement(document.body, pickerWidth + "px");
                var divIndicator = this._createDivIndicatiorElement(div, itemHeight, "", indicatorTranslateSelector);
                var table = this._createTableElement(div, height + "px", "-", indicatorTranslateContent);
                var trDate = $("<tr/>").appendTo(table);

                var tdYearWidth = "33%";
                var tdMonthWidth = "33%";
                var tdDayWidth = "33%";

                if (this._owner.element.data('pickerDateMonthFormat') == "MMMM") {
                    tdYearWidth = "30%";
                    tdMonthWidth = "45%";
                    tdDayWidth = "25%";
                }

                // Year
                var tdYear = $("<td/>").css({ "width": tdYearWidth });
                var divYear = this._createPickerDivElement(tdYear, height);
                var divYearMask = this._createMaskElement(divYear, height);
                var pickerYearArray = new Array();
                for (var i = minYear; i <= maxYear; i++) {
                    var text = this._getRollText(i, this._owner.element.data('pickerDateYearFormat'));
                    var itemDiv = this._createItemElement(i, divYearMask, itemHeight, text);
                    pickerYearArray[i - minYear] = itemDiv;
                }

                // Month
                var tdMonth = $("<td/>").css({ "width": tdMonthWidth });
                var divMonth = this._createPickerDivElement(tdMonth, height);
                var divMonthMask = this._createMaskElement(divMonth, height);
                var pickerMonthArray = {};
                var i;
                for (i = 1; i <= 12; i++) {
                    var text = this._getRollText(i, this._owner.element.data('pickerDateMonthFormat'));
                    var itemDiv = this._createItemElement(i - 1, divMonthMask, itemHeight, text);
                    pickerMonthArray[i - 1] = itemDiv;
                }

                //Day
                var tdDay = $("<td/>").css({ "width": tdDayWidth });
                var divDay = this._createPickerDivElement(tdDay, height);
                var divDayMask = this._createMaskElement(divDay, height);
                var pickerDayArray = {};
                for (i = 1; i <= 31; i++) {
                    var text = this._getRollText(i, this._owner.element.data('pickerDateDayFormat'));
                    var itemDiv = this._createItemElement(i, divDayMask, itemHeight, text);
                    pickerDayArray[i - 1] = itemDiv;
                }

                var pickerDateFormat = this._owner.element.data('pickerDateFormat');
                var yearAdded = false, monthAdded = false, dayAdded = false;
                for (i = 0; i < pickerDateFormat.length; i++) {
                    if ((pickerDateFormat[i] == "yyyy") && !yearAdded) {
                        tdYear.appendTo(trDate);
                        yearAdded = true;
                    }

                    if ((pickerDateFormat[i] == "M" || pickerDateFormat[i] == "MM" || pickerDateFormat[i] == "MMM" || pickerDateFormat[i] == "MMMM") && !monthAdded) {
                        tdMonth.appendTo(trDate);
                        monthAdded = true;
                    }

                    if ((pickerDateFormat[i] == "d" || pickerDateFormat[i] == "dd") && !dayAdded) {
                        tdDay.appendTo(trDate);
                        dayAdded = true;
                    }
                }

                this._owner.element.data('datePicker', div);

                this._owner.element.data('divYear', divYear);
                this._owner.element.data('divMonth', divMonth);
                this._owner.element.data('divDay', divDay);

                this._owner.element.data('divYearMask', divYearMask);
                this._owner.element.data('divMonthMask', divMonthMask);
                this._owner.element.data('divDayMask', divDayMask);

                this._owner.element.data('pickerYearArray', pickerYearArray);
                this._owner.element.data('pickerMonthArray', pickerMonthArray);
                this._owner.element.data('pickerDayArray', pickerDayArray);

                if (!input.CoreUtility.IsIE8OrBelow()) {
                    var divYearIndicatorTop = this._createIndicatiorElement(divYear, indicatorHeight, "-", indicatorTranslateTop);
                    var divYearIndicatorDown = this._createIndicatiorElement(divYear, indicatorHeight, "-", indicatorTranslateDown);
                    var divMonthIndicatorTop = this._createIndicatiorElement(divMonth, indicatorHeight, "-", indicatorTranslateTop);
                    var divMonthIndicatorDown = this._createIndicatiorElement(divMonth, indicatorHeight, "-", indicatorTranslateDown);
                    var divDayIndicatorTop = this._createIndicatiorElement(divDay, indicatorHeight, "-", indicatorTranslateTop);
                    var divDayIndicatorDown = this._createIndicatiorElement(divDay, indicatorHeight, "-", indicatorTranslateDown);
                    this._owner.element.data('divYearIndicatorTop', divYearIndicatorTop);
                    this._owner.element.data('divMonthIndicatorTop', divMonthIndicatorTop);
                    this._owner.element.data('divDayIndicatorTop', divDayIndicatorTop);
                    this._owner.element.data('divYearIndicatorDown', divYearIndicatorDown);
                    this._owner.element.data('divMonthIndicatorDown', divMonthIndicatorDown);
                    this._owner.element.data('divDayIndicatorDown', divDayIndicatorDown);
                }

                this._initDatePickerEvent();
                this._initTouchPickerEvent("Year");
                this._initTouchPickerEvent("Month");
                this._initTouchPickerEvent("Day");
            };

            wijinputdateroller.prototype._initDatePickerEvent = function () {
                var self = this;
                var divYear = this._owner.element.data('divYear');
                var divMonth = this._owner.element.data('divMonth');
                var divDay = this._owner.element.data('divDay');

                divYear.mousewheel(function (e, arg) {
                    self._yearMouseWheel(e, arg);
                });

                divMonth.mousewheel(function (e, arg) {
                    self._monthMouseWheel(e, arg);
                });

                divDay.mousewheel(function (e, arg) {
                    self._dayMouseWheel(e, arg);
                });
            };

            //#endregion
            //#region TimePicker
            wijinputdateroller.prototype._initTimePicker = function () {
                var timePicker = this._owner.element.data('timePicker');
                if (timePicker != undefined) {
                    return;
                }

                var self = this;
                var height = this._owner.element.data('itemHeight') * 5;
                var pickerWidth = this._owner.element.data('pickerWidth');
                var itemHeight = this._owner.element.data('itemHeight') + "px";
                var indicatorHeight = this._owner.element.data('indicatorHeight') + "px";
                var indicatorTranslateTop = this._owner.element.data('indicatorTranslateTop');
                var indicatorTranslateDown = this._owner.element.data('indicatorTranslateDown');
                var indicatorTranslateSelector = this._owner.element.data('indicatorTranslateSelector');
                var indicatorTranslateContent = this._owner.element.data('indicatorTranslateContent');

                var div = this._createDivElement(document.body, pickerWidth + "px");
                var divIndicator = this._createDivIndicatiorElement(div, itemHeight, "", indicatorTranslateSelector);
                var table = this._createTableElement(div, height + "px", "-", indicatorTranslateContent);
                var trTime = $("<tr/>").appendTo(table);

                // Hour
                var tdHour = $("<td/>").css({ "width": "33%" });
                var divHour = this._createPickerDivElement(tdHour, height);
                var divHourMask = this._createMaskElement(divHour, height);
                var pickerHourArray = {};
                for (var i = 1; i <= 12; i++) {
                    var text = this._getRollText(i, this._owner.element.data('pickerTimeHourFormat'));
                    var itemDiv = this._createItemElement(i, divHourMask, itemHeight, text);
                    pickerHourArray[i - 1] = itemDiv;
                }

                //Minute
                var tdMinute = $("<td/>").css({ "width": "33%" });
                var divMinute = this._createPickerDivElement(tdMinute, height);
                var divMinuteMask = this._createMaskElement(divMinute, height);
                var pickerMinuteArray = {};
                for (var i = 0; i < 60; i++) {
                    var text = this._getRollText(i, this._owner.element.data('pickerTimeMinuteFormat'));
                    var itemDiv = this._createItemElement(i, divMinuteMask, itemHeight, text);
                    pickerMinuteArray[i] = itemDiv;
                }

                //AM
                var tdAM = $("<td/>").css({ "width": "34%" });
                var divAM = this._createPickerDivElement(tdAM, height);
                var divAMMask = this._createMaskElement(divAM, height);
                var pickerAMArray = {};
                for (var i = 0; i < 2; i++) {
                    var text = this._getRollText(i, this._owner.element.data('pickerTimeAMFormat'));
                    var itemDiv = this._createItemElement(i, divAMMask, itemHeight, text);
                    pickerAMArray[i] = itemDiv;
                }

                var pickerTimeFormat = this._owner.element.data('pickerTimeFormat');
                var hourAdded = false, minuteAdded = false, amAdded = false;
                for (var i = 0; i < pickerTimeFormat.length; i++) {
                    if ((pickerTimeFormat[i] == "h" || pickerTimeFormat[i] == "hh") && !hourAdded) {
                        tdHour.appendTo(trTime);
                        hourAdded = true;
                    }

                    if ((pickerTimeFormat[i] == "m" || pickerTimeFormat[i] == "mm") && !minuteAdded) {
                        tdMinute.appendTo(trTime);
                        minuteAdded = true;
                    }

                    if ((pickerTimeFormat[i] == "t" || pickerTimeFormat[i] == "tt") && !amAdded) {
                        tdAM.appendTo(trTime);
                        amAdded = true;
                    }
                }

                this._owner.element.data('timePicker', div);

                this._owner.element.data('divHour', divHour);
                this._owner.element.data('divMinute', divMinute);
                this._owner.element.data('divAM', divAM);

                this._owner.element.data('divHourMask', divHourMask);
                this._owner.element.data('divMinuteMask', divMinuteMask);
                this._owner.element.data('divAMMask', divAMMask);

                this._owner.element.data('pickerHourArray', pickerHourArray);
                this._owner.element.data('pickerMinuteArray', pickerMinuteArray);
                this._owner.element.data('pickerAMArray', pickerAMArray);

                if (!input.CoreUtility.IsIE8OrBelow()) {
                    var divHourIndicatorTop = this._createIndicatiorElement(divHour, indicatorHeight, "-", indicatorTranslateTop);
                    var divHourIndicatorDown = this._createIndicatiorElement(divHour, indicatorHeight, "-", indicatorTranslateDown);
                    var divMinuteIndicatorTop = this._createIndicatiorElement(divMinute, indicatorHeight, "-", indicatorTranslateTop);
                    var divMinuteIndicatorDown = this._createIndicatiorElement(divMinute, indicatorHeight, "-", indicatorTranslateDown);
                    var divAMIndicatorTop = this._createIndicatiorElement(divAM, indicatorHeight, "-", indicatorTranslateTop);
                    var divAMIndicatorDown = this._createIndicatiorElement(divAM, indicatorHeight, "-", indicatorTranslateDown);
                    this._owner.element.data('divHourIndicatorTop', divHourIndicatorTop);
                    this._owner.element.data('divMinuteIndicatorTop', divMinuteIndicatorTop);
                    this._owner.element.data('divAMIndicatorTop', divAMIndicatorTop);
                    this._owner.element.data('divHourIndicatorDown', divHourIndicatorDown);
                    this._owner.element.data('divMinuteIndicatorDown', divMinuteIndicatorDown);
                    this._owner.element.data('divAMIndicatorDown', divAMIndicatorDown);
                }

                this._initTimePickerEvent();
                this._initTouchPickerEvent("Hour");
                this._initTouchPickerEvent("Minute");
                this._initTouchPickerEvent("AM");
            };

            wijinputdateroller.prototype._initTimePickerEvent = function () {
                var self = this;
                var divHour = this._owner.element.data('divHour');
                var divMinute = this._owner.element.data('divMinute');
                var divAM = this._owner.element.data('divAM');

                divHour.mousewheel(function (e, arg) {
                    self._hourMouseWheel(e, arg);
                });

                divMinute.mousewheel(function (e, arg) {
                    self._minuteMouseWheel(e, arg);
                });

                divAM.mousewheel(function (e, arg) {
                    self._amMouseWheel(e, arg);
                });
            };

            //#endregion
            //#region Method
            wijinputdateroller.prototype._isValidatePickerFormat = function (format) {
                switch (format) {
                    case "yyyy":
                    case "M":
                    case "MM":
                    case "MMM":
                    case "MMMM":
                    case "d":
                    case "dd":
                    case "h":
                    case "hh":
                    case "m":
                    case "mm":
                    case "t":
                    case "tt":
                        return true;
                }

                return false;
            };

            wijinputdateroller.prototype._getDatePickerMinYear = function () {
                var realMinDate = this._owner._isEraFormatExist() ? this._owner._getRealEraMinDate() : this._owner._getRealMinDate();
                var minYear = realMinDate.getFullYear();
                var pickerValue = this._owner._getPickerValue();
                var year = this._owner._max(pickerValue.getFullYear() - 50, minYear);
                return year;
            };

            wijinputdateroller.prototype._getDatePickerMaxYear = function () {
                var realMaxDate = this._owner._isEraFormatExist() ? this._owner._getRealEraMaxDate() : this._owner._getRealMaxDate();
                var maxYear = realMaxDate.getFullYear();
                var pickerValue = this._owner._getPickerValue();
                var year = this._owner._min(pickerValue.getFullYear() + 50, maxYear);
                return year;
            };

            wijinputdateroller.prototype._getCorrentPickerFormat = function (formats) {
                for (var i = 0; i < formats.length - 1; i++) {
                    for (var j = i + 1; j < formats.length; j++) {
                        if (formats[j].index < formats[i].index) {
                            var tmp = formats[i];
                            formats[i] = formats[j];
                            formats[j] = tmp;
                        }
                    }
                }

                var result = "";
                for (var i = 0; i < formats.length; i++) {
                    result += formats[i].value;
                    if (i < formats.length - 1) {
                        result += ",";
                    }
                }

                return result;
            };

            wijinputdateroller.prototype._getDefaultDatePickerFormat = function () {
                var culture = this._owner._getCulture();

                if (culture == null) {
                    return "yyyy,M,d";
                }

                var cf = culture.calendars.standard;
                var pattern = cf.patterns.d;
                var y = { "index": pattern.indexOf('y'), "value": "yyyy" };
                var M = { "index": pattern.indexOf('M'), "value": "MM" };
                var d = { "index": pattern.indexOf('d'), "value": "dd" };

                if (y.index == -1 || M.index == -1 || d.index == -1) {
                    return "yyyy,M,d";
                }

                var formats = new Array();
                formats[0] = y;
                formats[1] = M;
                formats[2] = d;

                return this._getCorrentPickerFormat(formats);
            };

            wijinputdateroller.prototype._getDefaultTimePickerFormat = function () {
                if (this._owner.options.culture.length >= 2) {
                    var subString = this._owner.options.culture.substr(0, 2);
                    if (subString == 'ja' || subString == 'zh') {
                        return "tt,hh,mm";
                    }
                }

                return "hh,mm,tt";
            };

            wijinputdateroller.prototype._updateTimePicker = function () {
                var hour = this._owner.element.data("pickerHour") - 1;
                var minute = this._owner.element.data("pickerMinute");
                var am = this._owner.element.data("pickerAM");

                var divHourMask = this._owner.element.data('divHourMask');
                var divMinuteMask = this._owner.element.data('divMinuteMask');
                var divAMMask = this._owner.element.data('divAMMask');

                this._updateItemTransform("Hour", hour);
                this._updateItemTransform("Minute", minute);
                this._updateItemTransform("AM", am);

                this._scrollTheView("Hour", hour, hour, true);
                this._scrollTheView("Minute", minute, minute, true);
                this._scrollTheView("AM", am, am, true);

                this._owner.element.data('pickerHourScrollDelay', 5);
                this._owner.element.data('pickerMinuteScrollDelay', 5);
                this._owner.element.data('pickerAMScrollDelay', 5);

                this._owner.element.data('pickerHourScrollRate', 1);
                this._owner.element.data('pickerMinuteScrollRate', 1);
                this._owner.element.data('pickerAMScrollRate', 1);
            };

            wijinputdateroller.prototype._updateDatePicker = function () {
                var minYear = this._owner.element.data('pickerMinYear');
                var year = this._owner.element.data("pickerYear");
                var month = this._owner.element.data("pickerMonth");
                var day = this._owner.element.data("pickerDay");

                var maxDayCount = input.DateTimeInfo.DaysInMonth(year, month);

                this._updateItemTransform("Year", year - minYear);
                this._updateItemTransform("Month", month - 1);
                this._updateItemTransform("Day", day - 1);

                this._scrollTheView("Year", year - minYear, year - minYear, true);
                this._scrollTheView("Month", month - 1, month - 1, true);
                this._scrollTheView("Day", day - 1, day - 1, true);

                this._owner.element.data('pickerYearScrollDelay', 5);
                this._owner.element.data('pickerMonthScrollDelay', 5);
                this._owner.element.data('pickerDayScrollDelay', 5);

                this._owner.element.data('pickerYearScrollRate', 1);
                this._owner.element.data('pickerMonthScrollRate', 1);
                this._owner.element.data('pickerDayScrollRate', 1);

                this._updateDayPickerMaxCount();
            };

            wijinputdateroller.prototype._getRollText = function (index, format) {
                var culture = this._owner._getCulture();
                var text = "";
                switch (format) {
                    case "M":
                    case "h":
                        text = (index).toString();
                        break;
                    case "MM":
                    case "hh":
                        text = index < 10 ? "0" + (index).toString() : (index).toString();
                        break;
                    case "m":
                    case "d":
                    case "yyyy":
                        text = index.toString();
                        break;
                    case "mm":
                    case "dd":
                        text = index < 10 ? "0" + index.toString() : index.toString();
                        break;
                    case "t":
                        text = index == 0 ? this._owner._getStandardAMPM("AM") : this._owner._getStandardAMPM("PM");
                        text = text.substr(0, 1);
                        break;
                    case "tt":
                        text = index == 0 ? this._owner._getStandardAMPM("AM") : this._owner._getStandardAMPM("PM");
                        break;
                    case "MMM":
                        text = culture.calendars.standard.months.namesAbbr[index - 1];
                        break;
                    case "MMMM":
                        text = culture.calendars.standard.months.names[index - 1];
                        break;
                    default:
                }

                return text;
            };

            wijinputdateroller.prototype._initTouchPickerEvent = function (pickerType) {
                var div = this._owner.element.data('div' + pickerType);
                var divMask = this._owner.element.data('div' + pickerType + 'Mask');
                this._addPickerTouchEvent(divMask, pickerType);

                if (!input.CoreUtility.IsIE8OrBelow()) {
                    var divIndicatorTop = this._owner.element.data('div' + pickerType + 'IndicatorTop');
                    var divIndicatorDown = this._owner.element.data('div' + pickerType + 'IndicatorDown');
                    this._addPickerTouchEvent(divIndicatorTop, pickerType);
                    this._addPickerTouchEvent(divIndicatorDown, pickerType);
                }
            };

            wijinputdateroller.prototype._addPickerTouchEvent = function (element, pickerType) {
                var self = this;
                element.bind("touchstart", function (evt) {
                    self._touchStart(evt, pickerType);
                    evt.preventDefault();
                }).bind("touchmove", function (evt) {
                    self._touchMove(evt, pickerType);
                    evt.preventDefault();
                }).bind("touchend", function (evt) {
                    self._touchEnd(evt, pickerType);
                    evt.preventDefault();
                });
            };

            wijinputdateroller.prototype._getRollFormat = function (pickerDateFormat, format) {
                for (var i = 0; i < pickerDateFormat.length; i++) {
                    if (pickerDateFormat[i].indexOf(format) != -1) {
                        return pickerDateFormat[i];
                    }
                }

                return "";
            };

            wijinputdateroller.prototype._adjustTouchPosition = function (pickerType, newY) {
                var touchPositionArray = this._getTouchPositionArray(pickerType);
                var index = this._getItemIndexByPosition(pickerType, newY);
                var value = this._itemIndexToValue(pickerType, index);
                this._owner.element.data("picker" + pickerType, value);
                this._scrollTheViewByTouch(pickerType, touchPositionArray[index]);
            };

            wijinputdateroller.prototype._itemIndexToValue = function (pickerType, index) {
                switch (pickerType) {
                    case "Minute":
                    case "AM":
                        return index;
                    case "Hour":
                    case "Month":
                    case "Day":
                        return index + 1;
                    case "Year":
                        var minYear = this._owner.element.data('pickerMinYear');
                        return minYear + index;
                }

                return -1;
            };

            wijinputdateroller.prototype._getItemLength = function (pickerType) {
                switch (pickerType) {
                    case "Hour":
                    case "Month":
                        return 12;
                    case "Year":
                        var minYear = this._owner.element.data('pickerMinYear');
                        var maxYear = this._owner.element.data('pickerMaxYear');
                        return maxYear - minYear + 1;
                    case "Day":
                        return 31;
                    case "Minute":
                        return 60;
                    case "AM":
                        return 2;
                }

                return -1;
            };

            wijinputdateroller.prototype._updateItemTransform = function (pickerType, itemIndex) {
                if (input.CoreUtility.IsIE8OrBelow()) {
                    return;
                }

                if (itemIndex < 0) {
                    return;
                }

                var itemArray = this._owner.element.data("picker" + pickerType + "Array");
                var length = this._getItemLength(pickerType);
                var transform = "skew(0deg) scale(1.2, 1.2) translate(0px, 0px)";
                var transform1 = "skew(-5deg) scale(0.9, 0.9) translate(0px, 0px)";
                var transform2 = "skew(-10deg) scale(0.7, 0.7) translate(0px, 0px)";
                var transform3 = "skew(-15deg) scale(0.5, 0.5) translate(0px, 0px)";

                for (var i = 0; i < length; i++) {
                    if (i == itemIndex - 3) {
                        this._setCssTransform(itemArray[i], "", transform3, true);
                    } else if (i == itemIndex - 2) {
                        this._setCssTransform(itemArray[i], "", transform2, true);
                    } else if (i == itemIndex - 1) {
                        this._setCssTransform(itemArray[i], "", transform1, true);
                    } else if (i == itemIndex) {
                        this._setCssTransform(itemArray[i], "", transform, true);
                    } else if (i == itemIndex + 1) {
                        this._setCssTransform(itemArray[i], "", transform1, true);
                    } else if (i == itemIndex + 2) {
                        this._setCssTransform(itemArray[i], "", transform2, true);
                    } else if (i == itemIndex + 3) {
                        this._setCssTransform(itemArray[i], "", transform3, true);
                    } else {
                        this._setCssTransform(itemArray[i], "", "", true);
                    }
                }
            };

            wijinputdateroller.prototype._updateDayPickerMaxCount = function () {
                var year = this._owner.element.data("pickerYear");
                var month = this._owner.element.data("pickerMonth");
                var day = this._owner.element.data("pickerDay");

                var maxDayCount = input.DateTimeInfo.DaysInMonth(year, month);
                this._owner.element.data('pickerDayMaxCount', maxDayCount);

                var pickerDayArray = this._owner.element.data('pickerDayArray');

                for (var i = 29; i <= 31; i++) {
                    var display = i > maxDayCount ? "none" : "";
                    pickerDayArray[i - 1].css("display", display);
                }

                if (day > maxDayCount) {
                    var divDayMask = this._owner.element.data('divDayMask');
                    day = maxDayCount;
                    this._updateItemTransform("Day", day - 1);
                    this._scrollTheView("Day", day - 1, null, false);
                    this._owner.element.data("pickerDay", day);
                }
            };

            wijinputdateroller.prototype._getTouchPositionArray = function (pickerType) {
                var positionArray = {};
                var itemHeight = this._owner.element.data('itemHeight');
                var length = this._getItemLength(pickerType);

                for (var i = 0; i < length; i++) {
                    positionArray[i] = (2 - i) * itemHeight;
                }

                return positionArray;
            };

            wijinputdateroller.prototype._getItemIndexByPosition = function (pickerType, newY) {
                var touchPositionArray = this._getTouchPositionArray(pickerType);
                var length = this._getItemLength(pickerType);

                if (pickerType == "Day") {
                    if (length > this._owner.element.data('pickerDayMaxCount')) {
                        length = this._owner.element.data('pickerDayMaxCount');
                    }
                }

                var index = -1;
                for (var i = 0; i < length; i++) {
                    if (i == 0) {
                        if (newY > touchPositionArray[i]) {
                            index = 0;
                            break;
                        }
                    } else {
                        if (newY <= touchPositionArray[i - 1] && newY >= touchPositionArray[i]) {
                            var offsetTop = touchPositionArray[i - 1] - newY;
                            var offsetBottom = newY - touchPositionArray[i];
                            index = offsetTop > offsetBottom ? i : i - 1;
                            break;
                        }
                    }

                    if (i == length - 1) {
                        if (newY < touchPositionArray[i]) {
                            index = i;
                            break;
                        }
                    }
                }

                return index;
            };

            wijinputdateroller.prototype._hideItemInIE7 = function (pickerType, pickerScrollCurrent) {
                if (!input.CoreUtility.IsIE7()) {
                    return;
                }

                var lastItemIndex = this._owner.element.data('picker' + pickerType + 'LastItemIndex');
                var itemIndex = this._getItemIndexByPosition(pickerType, pickerScrollCurrent);
                if (itemIndex == lastItemIndex) {
                    return;
                }

                var minItemIndex = itemIndex - 2;
                var maxItemIndex = itemIndex + 2;
                var itemArray = this._owner.element.data("picker" + pickerType + "Array");
                var length = this._getItemLength(pickerType);

                for (var i = 0; i < length; i++) {
                    if (i >= minItemIndex && i <= maxItemIndex) {
                        itemArray[i].css("visibility", "");
                    } else {
                        itemArray[i].css("visibility", "hidden");
                    }
                }

                this._owner.element.data('picker' + pickerType + 'LastItemIndex', itemIndex);
            };

            wijinputdateroller.prototype._scrollTheView = function (pickerType, newValue, oldValue, ignoreScroll) {
                var itemHeight = this._owner.element.data('itemHeight');
                var newOffset = (2 - newValue) * itemHeight;
                this._owner.element.data('picker' + pickerType + 'ScrollTo', newOffset);
                if (ignoreScroll == true) {
                    var divMask = this._owner.element.data('div' + pickerType + 'Mask');
                    var pickerScrollCurrent = newOffset;
                    this._setCssTransform(divMask, "", pickerScrollCurrent, false);
                    this._hideItemInIE7(pickerType, pickerScrollCurrent);
                    this._owner.element.data('picker' + pickerType + 'ScrollCurrent', pickerScrollCurrent);
                } else {
                    this._scrollPicker(pickerType);
                }
            };

            wijinputdateroller.prototype._scrollPicker = function (pickerType) {
                var divMask = this._owner.element.data('div' + pickerType + 'Mask');
                var pickerScrollTo = this._owner.element.data('picker' + pickerType + 'ScrollTo');
                var pickerScrollCurrent = this._owner.element.data('picker' + pickerType + 'ScrollCurrent');
                var pickerScrollDelay = this._owner.element.data('picker' + pickerType + 'ScrollDelay');

                if (pickerScrollCurrent == undefined) {
                    pickerScrollCurrent = pickerScrollTo;
                    this._setCssTransform(divMask, "", pickerScrollCurrent, false);
                    this._owner.element.data('picker' + pickerType + 'ScrollCurrent', pickerScrollCurrent);
                }

                if (pickerScrollTo == pickerScrollCurrent || pickerScrollCurrent == undefined) {
                    return false;
                }

                pickerScrollCurrent += pickerScrollTo > pickerScrollCurrent ? 1 : -1;
                var transform = "translate(0," + pickerScrollCurrent + "px) ";
                this._setCssTransform(divMask, "", pickerScrollCurrent, false);
                this._hideItemInIE7(pickerType, pickerScrollCurrent);
                this._owner.element.data('picker' + pickerType + 'ScrollCurrent', pickerScrollCurrent);

                var self = this;
                setTimeout(function () {
                    self._scrollPicker(pickerType);
                }, pickerScrollDelay);

                return true;
            };

            wijinputdateroller.prototype._scrollTheViewByTouch = function (pickerType, clientY) {
                var itemHeight = this._owner.element.data('itemHeight');
                var pickerScrollCurrent = this._owner.element.data('picker' + pickerType + 'ScrollCurrent');
                var pickerScrollTo = this._owner.element.data('picker' + pickerType + 'ScrollTo');
                this._owner.element.data('picker' + pickerType + 'ScrollTo', clientY);
                this._scrollPickerByTouch(pickerType);
            };

            wijinputdateroller.prototype._scrollPickerByTouch = function (pickerType) {
                var divMask = this._owner.element.data('div' + pickerType + 'Mask');
                var pickerScrollTo = this._owner.element.data('picker' + pickerType + 'ScrollTo');
                var pickerScrollCurrent = this._owner.element.data('picker' + pickerType + 'ScrollCurrent');

                if (pickerScrollCurrent == undefined) {
                    pickerScrollCurrent = pickerScrollTo;
                    this._setCssTransform(divMask, "", pickerScrollCurrent, false);
                    this._owner.element.data('picker' + pickerType + 'ScrollCurrent', pickerScrollCurrent);
                }

                if (pickerScrollTo == pickerScrollCurrent) {
                    this._owner.element.data('picker' + pickerType + 'ScrollRate', 1);
                    this._owner.element.data('picker' + pickerType + 'ScrollDelay', 5);
                    this._owner.element.data('touchQuickScroll', false);
                    if (pickerType == "Month" || pickerType == "Year") {
                        this._updateDayPickerMaxCount();
                    } else if (pickerType == "Hour") {
                        var itemIndex = this._getItemIndexByPosition(pickerType, pickerScrollCurrent);
                        var am = this._owner.element.data("pickerAM");

                        if (itemIndex == 11) {
                            if (am == 0) {
                                am = 1;
                                this._updateItemTransform("AM", am);
                                this._scrollTheView("AM", am, 0, false);
                                this._owner.element.data("pickerAM", am);
                            }
                        } else {
                            if (am == 1) {
                                am = 0;
                                this._updateItemTransform("AM", am);
                                this._scrollTheView("AM", am, 1, false);
                                this._owner.element.data("pickerAM", am);
                            }
                        }
                    }

                    return false;
                }

                var itemHeight = this._owner.element.data('itemHeight');
                var scrollDelay = this._owner.element.data('picker' + pickerType + 'ScrollDelay');
                var scrollRate = this._owner.element.data('picker' + pickerType + 'ScrollRate');
                var offset = Math.abs(pickerScrollTo - pickerScrollCurrent);
                var rate = offset > scrollRate ? scrollRate : offset;

                if (this._owner.element.data('touchQuickScroll') == true) {
                    if (offset < itemHeight) {
                        scrollDelay = 80;
                    } else if (offset < itemHeight * 2) {
                        scrollDelay = 50;
                    } else if (offset < itemHeight * 5) {
                        scrollDelay = 30;
                    } else if (offset < itemHeight * 8) {
                        scrollDelay = 20;
                    } else if (offset < itemHeight * 10) {
                        scrollDelay = 10;
                    }

                    this._owner.element.data('picker' + pickerType + 'ScrollDelay', scrollDelay);
                }

                pickerScrollCurrent += pickerScrollTo > pickerScrollCurrent ? rate : -1 * rate;
                this._setCssTransform(divMask, "", pickerScrollCurrent, false);
                this._owner.element.data('picker' + pickerType + 'ScrollCurrent', pickerScrollCurrent);

                var itemIndex = this._getItemIndexByPosition(pickerType, pickerScrollCurrent);
                var lastItemIndex = this._owner.element.data('picker' + pickerType + 'LastItemIndex');
                if (itemIndex != lastItemIndex) {
                    this._updateItemTransform(pickerType, itemIndex);
                }
                this._owner.element.data('picker' + pickerType + 'LastItemIndex', lastItemIndex);

                var self = this;
                setTimeout(function () {
                    self._scrollPickerByTouch(pickerType);
                }, scrollDelay);

                return true;
            };

            //#endregion
            //#region Event
            wijinputdateroller.prototype._touchStart = function (evt, pickerType) {
                var touch = evt.originalEvent.touches[0] || evt.originalEvent.changedTouches[0];
                var clientY = touch.clientY;

                this._owner.element.data("touch" + pickerType + "StartY", clientY);
                this._owner.element.data("touch" + pickerType + "BaseY", this._owner.element.data('picker' + pickerType + 'ScrollCurrent'));
                this._owner.element.data("touch" + pickerType + "Started", true);
                this._owner.element.data("touchStartTime", new Date());

                var pickerScrollCurrent = this._owner.element.data('picker' + pickerType + 'ScrollCurrent');
                this._owner.element.data('picker' + pickerType + 'ScrollTo', pickerScrollCurrent);
            };

            wijinputdateroller.prototype._touchMove = function (evt, pickerType) {
                if (!this._owner._allowEdit()) {
                    return;
                }

                if (this._owner.element.data("touch" + pickerType + "Started") != true) {
                    return;
                }

                var touch = evt.originalEvent.touches[0] || evt.originalEvent.changedTouches[0];
                var clientY = touch.clientY;

                var touchStartY = this._owner.element.data("touch" + pickerType + "StartY");
                var touchBaseY = this._owner.element.data("touch" + pickerType + "BaseY");
                var newY = touchBaseY + clientY - touchStartY;

                this._scrollTheViewByTouch(pickerType, newY);
            };

            wijinputdateroller.prototype._touchEnd = function (evt, pickerType) {
                var touch = evt.originalEvent.touches[0] || evt.originalEvent.changedTouches[0];
                var touchStartY = this._owner.element.data("touch" + pickerType + "StartY");
                var touchBaseY = this._owner.element.data("touch" + pickerType + "BaseY");
                var offset = touch.clientY - touchStartY;
                var newY = touchBaseY + offset;

                if (Math.abs(offset) < 10) {
                    var pickerScrollCurrent = this._owner.element.data('picker' + pickerType + 'ScrollCurrent');
                    this._owner.element.data('picker' + pickerType + 'ScrollTo', pickerScrollCurrent);
                    this._adjustTouchPosition(pickerType, pickerScrollCurrent);
                    return;
                }

                this._owner.element.data("touch" + pickerType + "StartY", -1);
                this._owner.element.data("touch" + pickerType + "BaseY", -1);
                this._owner.element.data("touch" + pickerType + "Started", false);

                var now = new Date();
                var offsetTime = now - this._owner.element.data("touchStartTime");
                if (offsetTime < 200) {
                    var itemHeight = this._owner.element.data("itemHeight") * 5;
                    var negative = offset < 0 ? -1 : 1;
                    offset = offset * 4;
                    offset = Math.abs(offset) < itemHeight ? negative * itemHeight : offset;
                    newY += offset;
                    this._owner.element.data("touchQuickScroll", true);
                    this._owner.element.data('picker' + pickerType + 'ScrollRate', 3);
                }

                this._adjustTouchPosition(pickerType, newY);
            };

            wijinputdateroller.prototype._yearMouseWheel = function (e, arg) {
                if (!this._owner._allowEdit()) {
                    return;
                }

                if (isNaN(arg)) {
                    return;
                }

                var minYear = this._owner.element.data("pickerMinYear");
                var maxYear = this._owner.element.data("pickerMaxYear");
                var year = this._owner.element.data("pickerYear");
                var oldYear = this._owner.element.data("pickerYear");

                year -= arg;
                year = year < minYear ? minYear : year;
                year = year > maxYear ? maxYear : year;

                this._updateItemTransform("Year", year - minYear);
                this._scrollTheView("Year", year - minYear, oldYear - minYear, false);
                this._owner.element.data("pickerYear", year);
                this._updateDayPickerMaxCount();
                if (e.preventDefault) {
                    e.preventDefault();
                }
            };

            wijinputdateroller.prototype._monthMouseWheel = function (e, arg) {
                if (!this._owner._allowEdit()) {
                    return;
                }

                if (isNaN(arg)) {
                    return;
                }

                var month = this._owner.element.data("pickerMonth");
                var oldMonth = this._owner.element.data("pickerMonth");

                month -= arg;
                month = month < 1 ? 1 : month;
                month = month > 12 ? 12 : month;

                this._updateItemTransform("Month", month - 1);
                this._scrollTheView("Month", month - 1, oldMonth, false);
                this._owner.element.data("pickerMonth", month);
                this._updateDayPickerMaxCount();
                if (e.preventDefault) {
                    e.preventDefault();
                }
            };

            wijinputdateroller.prototype._dayMouseWheel = function (e, arg) {
                if (!this._owner._allowEdit()) {
                    return;
                }

                if (isNaN(arg)) {
                    return;
                }

                var maxDayCount = this._owner.element.data('pickerDayMaxCount');
                var oldDay = this._owner.element.data("pickerDay");

                var day = this._owner.element.data("pickerDay");
                day -= arg;
                day = day < 1 ? 1 : day;
                day = day > maxDayCount ? maxDayCount : day;

                this._updateItemTransform("Day", day - 1);
                this._scrollTheView("Day", day - 1, oldDay - 1, false);
                this._owner.element.data("pickerDay", day);
                if (e.preventDefault) {
                    e.preventDefault();
                }
            };

            wijinputdateroller.prototype._hourMouseWheel = function (e, arg) {
                if (!this._owner._allowEdit()) {
                    return;
                }

                if (isNaN(arg)) {
                    return;
                }

                var oldHour = this._owner.element.data("pickerHour");
                var hour = this._owner.element.data("pickerHour");
                var lastHour = hour;

                hour -= arg;
                hour = hour < 1 ? 1 : hour;
                hour = hour > 12 ? 12 : hour;

                var am = this._owner.element.data("pickerAM");
                if (hour == 12) {
                    if (am == 0) {
                        am = 1;
                        this._updateItemTransform("AM", am);
                        this._scrollTheView("AM", am, 0, false);
                        this._owner.element.data("pickerAM", am);
                    }
                } else if (lastHour == 12) {
                    if (am == 1) {
                        am = 0;
                        this._updateItemTransform("AM", am);
                        this._scrollTheView("AM", am, 1, false);
                        this._owner.element.data("pickerAM", am);
                    }
                }

                this._updateItemTransform("Hour", hour - 1);
                this._scrollTheView("Hour", hour - 1, oldHour - 1, false);
                this._owner.element.data("pickerHour", hour);
                if (e.preventDefault) {
                    e.preventDefault();
                }
            };

            wijinputdateroller.prototype._minuteMouseWheel = function (e, arg) {
                if (!this._owner._allowEdit()) {
                    return;
                }

                if (isNaN(arg)) {
                    return;
                }

                var oldMinute = this._owner.element.data("pickerMinute");
                var minute = this._owner.element.data("pickerMinute");
                minute -= arg;
                minute = minute < 0 ? 0 : minute;
                minute = minute > 59 ? 59 : minute;

                this._updateItemTransform("Minute", minute);
                this._scrollTheView("Minute", minute, oldMinute, false);
                this._owner.element.data("pickerMinute", minute);
                if (e.preventDefault) {
                    e.preventDefault();
                }
            };

            wijinputdateroller.prototype._amMouseWheel = function (e, arg) {
                if (!this._owner._allowEdit()) {
                    return;
                }

                if (isNaN(arg)) {
                    return;
                }

                var oldAM = $(e.currentTarget).data('pickerAM');
                var am = this._owner.element.data("pickerAM");

                am -= arg;
                am = am < 0 ? 0 : am;
                am = am > 1 ? 1 : am;

                this._updateItemTransform("AM", am);
                this._scrollTheView("AM", am, oldAM, false);
                this._owner.element.data("pickerAM", am);
                if (e.preventDefault) {
                    e.preventDefault();
                }
            };

            //#endregion
            //#region CreateElement
            wijinputdateroller.prototype._createDivElement = function (container, width) {
                var div = $("<div/>").appendTo(container).css({ "width": width + "px", "display": "block", "left": "", "top": "", "position": "" }).bind("touchstart", function (evt) {
                    evt.preventDefault();
                }).bind("touchmove", function (evt) {
                    evt.preventDefault();
                });

                return div;
            };

            wijinputdateroller.prototype._createDivIndicatiorElement = function (div, height, prefix, transform) {
                var indicator = $("<div/>").appendTo(div).css({ "height": height, "opacity": "0.5", "lineHeight": height, "margin": "0px", "cursor": "default" }).attr("class", "ui-state-active");
                this._setCssTransform(indicator, prefix, transform, false);
                return indicator;
            };

            wijinputdateroller.prototype._createIndicatiorElement = function (div, height, prefix, transform) {
                var indicator = $("<div/>").appendTo(div).css({ "height": height, "opacity": "0.5", "lineHeight": height, "border-width": "0px", "cursor": "default" }).attr("class", "ui-widget-content");
                this._setCssTransform(indicator, prefix, transform, false);
                return indicator;
            };

            wijinputdateroller.prototype._setCssTransform = function (element, prefix, transform, setDirect) {
                var newTransform = transform;

                if (!setDirect) {
                    newTransform = "translate(0, " + prefix + transform + "px)";
                }

                element.css("position", "");
                element.css("top", "");

                if (input.CoreUtility.IsIE8OrBelow()) {
                    element.css("position", "relative");
                    element.css("top", prefix + transform + "px");
                } else if (input.CoreUtility.IsIE9()) {
                    element.css("-ms-transform", newTransform);
                } else {
                    element.css("transform", newTransform);
                }
            };

            wijinputdateroller.prototype._createTableElement = function (div, height, prefix, transform) {
                var table = $("<table/>").appendTo(div).css({ "width": "100%", "height": height + "px" }).attr({ "cellspacing": "0px", "cellpadding": "0px" });

                this._setCssTransform(table, prefix, transform, false);

                return table;
            };

            wijinputdateroller.prototype._createItemElement = function (index, div, height, text) {
                var item = $("<div/>").appendTo(div).css({ "height": height, "lineHeight": height, "cursor": "default" }).html(text).data("rollValue", index);

                return item;
            };

            wijinputdateroller.prototype._createPickerDivElement = function (div, height) {
                var pickerDiv = $("<div/>").appendTo(div).css({ "height": height, "border": "0px", "text-align": "center", "overflow": "hidden", "background": "transparent" });

                return pickerDiv;
            };

            wijinputdateroller.prototype._createMaskElement = function (div, height) {
                var mask = $("<div/>").appendTo(div).css({ "height": height });

                return mask;
            };
            return wijinputdateroller;
        })();
        input.wijinputdateroller = wijinputdateroller;
    })(wijmo.input || (wijmo.input = {}));
    var input = wijmo.input;
})(wijmo || (wijmo = {}));
;
/// <reference path="jquery.wijmo.wijstringinfo.ts"/>
/// <reference path="jquery.wijmo.wijinputcore.ts"/>
/// <reference path="../wijcalendar/jquery.wijmo.wijcalendar.ts"/>
/// <reference path="jquery.wijmo.wijinputdateformat.ts"/>
/// <reference path="jquery.wijmo.wijinputdateroller.ts"/>
/// <reference path="../wijtabs/jquery.wijmo.wijtabs.ts"/>
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var wijmo;
(function (wijmo) {
    /*globals  wijDateTextProvider wijinputcore wijInputResult window document Globalize jQuery*/
    /*
    * Depends:
    *	jquery-1.4.2.js
    *	jquery.ui.core.js
    *	jquery.ui.widget.js
    *	jquery.ui.position.js
    *	jquery.effects.core.js
    *	jquery.effects.blind.js
    *	globalize.js
    *	jquery.mousewheel.js
    *	jquery.wijmo.wijpopup.js
    *	jquery.wijmo.wijcalendar.js
    *	jquery.wijmo.wijcharex.js
    *	jquery.wijmo.wijstringinfo.js
    *	jquery.wijmo.wijinputcore.js
    *  jquery.wijmo.wijinputdateformat.js
    *  jquery.wijmo.wijtabs.js
    *
    */
    (function (input) {
        var $ = jQuery, jqKeyCode = wijmo.getKeyCodeEnum();

        //	var wijdigits = {
        //		useDefault: -2,
        //		asIs: -1,
        //		zero: 0,
        //		one: 1,
        //		two: 2,
        //		three: 3,
        //		four: 4,
        //		five: 5,
        //		six: 6,
        //		seven: 7,
        //		eight: 8
        //	}
        /** @widget */
        var wijinputdate = (function (_super) {
            __extends(wijinputdate, _super);
            function wijinputdate() {
                _super.apply(this, arguments);
            }
            wijinputdate.prototype._create = function () {
                if (input.CoreUtility.chrome) {
                    this.element.attr("type", "text");
                }
                this.element.uniqueId();
                this._id = this.element.attr("id");

                this._wijinputdateroller = null;
                if (typeof (input.wijinputdateroller) !== "undefined") {
                    this._wijinputdateroller = new input.wijinputdateroller(this);
                }

                _super.prototype._create.call(this);

                this.element.attr("aria-label", "wijinputdate");
                this.element.attr("role", "spinbutton");
            };

            wijinputdate.prototype._createTextProvider = function () {
                this._textProvider = new wijDateTextProvider(this, this.options.dateFormat, this.options.displayFormat);
            };

            wijinputdate.prototype._strToDate = function (str) {
                return this._textProvider.parseDate(str);
            };

            wijinputdate.prototype._beginUpdate = function () {
                var strDate, date = null;
                _super.prototype._beginUpdate.call(this);

                if (this.options.minDate) {
                    if (typeof this.options.minDate === 'string') {
                        var minDate = new Date(this.options.minDate);
                        if (isNaN(minDate.getTime())) {
                            minDate = this._strToDate(this.options.minDate);
                        }
                        this.options.minDate = minDate;
                    }
                }

                if (this.options.maxDate) {
                    if (typeof this.options.maxDate === 'string') {
                        var maxDate = new Date(this.options.maxDate);
                        if (isNaN(maxDate.getTime())) {
                            maxDate = this._strToDate(this.options.maxDate);
                        }
                        this.options.maxDate = maxDate;
                    }
                }

                if (this.options.date === undefined) {
                    if (!!this.element.data('elementValue')) {
                        strDate = this.element.data('elementValue');
                    }
                } else {
                    if (typeof this.options.date === 'string') {
                        strDate = this.options.date;
                    } else {
                        date = this.options.date;
                    }
                }

                if (this.options.date === undefined) {
                    this.options.date = new Date();
                }

                if (strDate) {
                    date = new Date(strDate);
                    if (isNaN(date.getTime())) {
                        date = this._strToDate(strDate);
                    }
                }

                if (date == null) {
                    date = this.options.date;
                }

                this._safeSetDate(date);

                var culture = this._getCulture();
                if (culture != null) {
                    if (this.options.amDesignator == "") {
                        this.options.amDesignator = this._getStandardAMPM("AM");
                    }
                    if (this.options.pmDesignator == "") {
                        this.options.pmDesignator = this._getStandardAMPM("PM");
                    }
                }

                this.element.data({
                    defaultDate: date === null ? date : new Date(date.getTime()),
                    preDate: date === null ? date : new Date(date.getTime())
                });

                this._resetTimeStamp();
                this._initPicker();

                if (this.options.calendar) {
                    var calendar = this.element.data('calendar');
                    if (calendar) {
                        calendar.wijcalendar("option", this.options.calendar);
                    }
                }

                this.element.addClass(this.options.wijCSS.wijinputdate).attr({
                    'aria-valuemin': new Date(1900, 1, 1).getTime(),
                    'aria-valuemax': new Date(2099, 1, 1).getTime()
                });
                if (this.options.date instanceof Date === true) {
                    this.element.attr('aria-valuenow', this.options.date.getTime());
                }
            };

            wijinputdate.prototype._endUpdate = function () {
                var _this = this;
                _super.prototype._endUpdate.call(this);
                this.element.bind("click.wijinput", function () {
                    if (!_this._allowEdit()) {
                        return;
                    }

                    var oldActiveField = _this.options.activeField;
                    var range = _this.element.wijtextselection();
                    _this._updateText();
                    try  {
                        _this.element.wijtextselection(range);
                    } catch (e) {
                    }

                    if (_this.element.data('ignoreHighLight') != true) {
                        _this._highLightCursor();
                    }

                    if (input.CoreUtility.chrome) {
                        if (_this.element.data('needResoteActiveField') == true) {
                            _this._setOption('activeField', oldActiveField);
                        }
                    }

                    _this.element.data('ignoreHighLight', false);
                });
            };

            wijinputdate.prototype._getInnerNullText = function () {
                if (this.options.placeholder != null) {
                    return this.options.placeholder;
                }

                if (this.options.showNullText) {
                    return this.options.nullText;
                }

                return null;
            };

            wijinputdate.prototype._getInnerAmDesignator = function () {
                return this.options.amDesignator == "" ? this._getStandardAMPM("AM") : this.options.amDesignator;
            };

            wijinputdate.prototype._getInnerPmDesignator = function () {
                return this.options.pmDesignator == "" ? this._getStandardAMPM("PM") : this.options.pmDesignator;
            };

            wijinputdate.prototype._getInnerIncrement = function () {
                var increment = Number(this.options.increment);
                if (isNaN(increment)) {
                    increment = 1;
                }
                return increment;
            };

            wijinputdate.prototype._getAllowSpinLoop = function () {
                return !!this.options.allowSpinLoop;
            };

            wijinputdate.prototype._getRealMaxDate = function () {
                return this.options.maxDate ? this.options.maxDate : new Date(9999, 11, 31, 23, 59, 59);
            };

            wijinputdate.prototype._getRealMinDate = function () {
                if (this.options.minDate) {
                    return this.options.minDate;
                }

                var minDate = new Date(1, 0, 1, 0, 0, 0);
                minDate.setFullYear(1);

                return minDate;
            };

            wijinputdate.prototype._getRealEraMaxDate = function () {
                if (this.options.maxDate) {
                    return input.DateTimeInfo.GetEraMax() < this.options.maxDate ? input.DateTimeInfo.GetEraMax() : this.options.maxDate;
                }

                return input.DateTimeInfo.GetEraMax();
            };

            wijinputdate.prototype._getRealEraMinDate = function () {
                if (this.options.minDate) {
                    return input.DateTimeInfo.GetEraMin() > this.options.minDate ? input.DateTimeInfo.GetEraMin() : this.options.minDate;
                }

                return input.DateTimeInfo.GetEraMin();
            };

            wijinputdate.prototype._isEraFormatExist = function () {
                return this._textProvider._isEraFormatExist();
            };

            wijinputdate.prototype._checkDate = function () {
                var oldDate = this.options.date;
                var newDate = this._checkRange(this.options.date);
                if (!input.DateTimeInfo.Equal(oldDate, newDate)) {
                    this._setOption("date", newDate);
                    this._trigger('valueBoundsExceeded', null);
                }
            };

            wijinputdate.prototype._checkRange = function (date) {
                if (date) {
                    if (this.options.minDate && date < this.options.minDate) {
                        date = new Date(Math.max(this.options.minDate, date));
                    }

                    if (this.options.maxDate && date > this.options.maxDate) {
                        date = new Date(Math.min(this.options.maxDate, date));
                    }
                }

                return date;
            };

            wijinputdate.prototype._safeSetDate = function (date, ignoreCheckRange) {
                var cache = date;

                if (!ignoreCheckRange) {
                    date = this._checkRange(date);
                }

                if (isNaN(date)) {
                    date = cache;
                }

                this.options.date = date;
                return true;
            };

            wijinputdate.prototype._safeGetDate = function (ignoreCheckRange) {
                var date = this.options.date;
                if (date == null) {
                    date = new Date();
                }
                if (!ignoreCheckRange) {
                    date = this._checkRange(date);
                }
                return date;
            };

            wijinputdate.prototype._setOption = function (key, value) {
                _super.prototype._setOption.call(this, key, value);

                switch (key) {
                    case 'calendar':
                        var calendar = this.element.data('calendar');
                        if (calendar) {
                            calendar.wijcalendar("option", value);
                        }
                        break;
                    case 'pickers':
                        this._reInitPicker();
                        break;
                    case 'minDate':
                    case 'maxDate':
                        if (typeof this.options[key] === 'string') {
                            var tmpDate = this._strToDate(value);
                            tmpDate = tmpDate === null ? new Date(value) : tmpDate;
                            this.options[key] = tmpDate;
                        }
                        var date = this.options.date;
                        if (date === null) {
                            date = new Date();
                        }

                        var minDate = this._getRealMinDate();
                        var maxDate = this._getRealMaxDate();

                        if (date < minDate || date > maxDate) {
                            this._safeSetDate(date);
                        }

                        this._updateText();
                        this._highLightField();
                        break;
                    case 'date':
                        if (!!value) {
                            if (typeof value === "string") {
                                var tmpValue = this._strToDate(value);
                                value = tmpValue === null ? new Date(value) : tmpValue;
                            } else if (typeof value === "object") {
                                value = new Date(value.getTime());
                            } else {
                                value = new Date(value);
                            }

                            if (isNaN(value)) {
                                value = new Date();
                            }
                        }
                        this._safeSetDate(value);
                        this._updateText();
                        this._highLightField();
                        break;
                    case 'midnightAs0':
                    case 'hour12As0':
                    case 'amDesignator':
                    case 'pmDesignator':
                    case 'promptChar':
                        this._updateText();
                        this._highLightField();
                        break;
                    case 'culture':
                    case 'cultureCalendar':
                        this._textProvider._setFormat(this.options.dateFormat);
                        var displayFormat = this.options.displayFormat == "" ? this.options.dateFormat : this.options.displayFormat;
                        this._textProvider._setDisplayFormat(displayFormat);

                        this.options.amDesignator = this._getStandardAMPM("AM");
                        this.options.pmDesignator = this._getStandardAMPM("PM");

                        this._updateText();
                        var calendar = this.element.data('calendar');
                        if (calendar) {
                            calendar.wijcalendar("option", key, value);
                        }

                        this._reInitPicker();
                        break;
                    case 'dateFormat':
                        this._textProvider._setFormat(this.options.dateFormat);
                        if (this.options.displayFormat == "") {
                            this._textProvider._setDisplayFormat(this.options.dateFormat);
                        }

                        if (this._isEraFormatExist() && this.options.date != null) {
                            var minYear = this._getRealEraMinDate();
                            var maxYear = this._getRealEraMaxDate();

                            if (this.options.date < minYear) {
                                this._setOption("date", minYear);
                            } else if (this.options.date > maxYear) {
                                this._setOption("date", maxYear);
                            }
                        }

                        this._updateText();

                        // update the calendar 's culture
                        var calendar = this.element.data('calendar');
                        if (calendar) {
                            calendar.wijcalendar("option", key, value);
                        }
                        this._reInitPicker();
                        break;
                    case 'displayFormat':
                        var displayFormat = this.options.displayFormat == "" ? this.options.dateFormat : this.options.displayFormat;
                        this._textProvider._setDisplayFormat(displayFormat);
                        this._updateText();
                        break;
                    case 'activeField':
                        value = Math.min(value, this._textProvider.getFieldCount() - 1);
                        value = Math.max(value, 0);
                        this.options.activeField = value;
                        this._checkDate();
                        if (this.element.data('ignoreHighLight') != true) {
                            this._highLightField();
                        }
                        this._resetTimeStamp();
                        break;

                    case 'nextTooltip':
                    case 'prevTooltip':
                    case 'titleFormat':
                    case 'toolTipFormat':
                        // update the calendar 's tooltip
                        var calendar = this.element.data('calendar', calendar);
                        if (calendar) {
                            calendar.wijcalendar("option", key, value);
                        }
                        break;
                    case "comboItems":
                        this._reInitPicker();
                        break;
                }
            };

            wijinputdate.prototype._setData = function (val) {
                this.option('date', val);
            };

            wijinputdate.prototype._resetData = function () {
                var d = this.element.data('defaultDate');
                if (d === undefined || d === null) {
                    if (this.options.date !== null) {
                        d = this.element.data('elementValue');
                        if (d !== undefined && d !== null && d !== "") {
                            this.setText(d);
                        } else {
                            this._setData(null);
                        }
                    }
                } else {
                    this._setData(d);
                }
            };

            wijinputdate.prototype._resetTimeStamp = function () {
                this.element.data('cursorPos', 0);
                this.element.data('timeStamp', new Date('1900/1/1'));
                this.element.data("lastInputChar", "");
            };

            /** Gets the text value when the container form is posted back to server.
            */
            wijinputdate.prototype.getPostValue = function () {
                if (!this._isInitialized()) {
                    return this.element.val();
                }
                if (_super.prototype._showNullText.call(this) && this.isDateNull()) {
                    return "";
                }

                var val = this._textProvider.toString();
                if (val === this.options.nullText) {
                    return "";
                }

                return val;
            };

            wijinputdate.prototype._highLightAllField = function () {
                if (this.isFocused()) {
                    var range = this._textProvider.getAllRange();
                    if (range) {
                        try  {
                            this.element.wijtextselection(range);
                        } catch (e) {
                        }
                    }
                }
            };

            wijinputdate.prototype._highLightField = function (index) {
                if (typeof index === "undefined") { index = this.options.activeField; }
                if (this.isFocused()) {
                    var range = this._textProvider.getFieldRange(index);
                    if (range) {
                        try  {
                            this.element.wijtextselection(range);
                        } catch (e) {
                        }
                    }
                }
            };

            wijinputdate.prototype._highLightCursor = function (pos) {
                if (this._isNullText()) {
                    return;
                }

                if (pos === undefined) {
                    pos = Math.max(0, this.element.wijtextselection().start);
                }

                var index = this._textProvider.getCursorField(pos);
                if (index < 0) {
                    return;
                }
                this._setOption('activeField', index);
            };

            wijinputdate.prototype._toNextField = function () {
                this._setOption('activeField', this.options.activeField + 1);
            };

            wijinputdate.prototype._toPrevField = function () {
                this._setOption('activeField', this.options.activeField - 1);
            };

            wijinputdate.prototype._toFirstField = function () {
                this._setOption('activeField', 0);
            };

            wijinputdate.prototype._toLastField = function () {
                this._setOption('activeField', this._textProvider.getFieldCount());
            };

            wijinputdate.prototype._clearField = function (index) {
                if (typeof index === "undefined") { index = this.options.activeField; }
                var range = this._textProvider.getFieldRange(index), rh, self = this;
                if (range) {
                    rh = new input.wijInputResult();
                    this._textProvider.removeAt(range.start, range.end, rh);
                    this._updateText();
                    window.setTimeout(function () {
                        self._highLightField();
                    }, 1);
                }
            };

            /** Performs spin up by the active field and increment value.
            */
            wijinputdate.prototype.spinUp = function () {
                this._doSpin(true, false);
            };

            /** Performs spin down by the active field and increment value.
            */
            wijinputdate.prototype.spinDown = function () {
                this._doSpin(false, false);
            };

            /** Open the dropdown window.
            */
            wijinputdate.prototype.drop = function () {
                _super.prototype._onTriggerClicked.call(this);
            };

            /** Set the focus to the widget.
            */
            wijinputdate.prototype.focus = function () {
                _super.prototype.focus.call(this);
                this._addState('focus', this.outerDiv);
                this._updateText();
                if (this.options.highlightText == "all") {
                    this._highLightAllField();
                    this._setOption('activeField', 0);
                } else {
                    this._highLightField();
                }
            };

            /** Determines whether the date is a null value.
            */
            wijinputdate.prototype.isDateNull = function () {
                return this.options.date === null || this.options.date === undefined;
            };

            wijinputdate.prototype._min = function (value1, value2) {
                if (value2 == undefined) {
                    return value1;
                }
                return value1 < value2 ? value1 : value2;
            };

            wijinputdate.prototype._max = function (value1, value2) {
                if (value2 == undefined) {
                    return value1;
                }
                return value1 > value2 ? value1 : value2;
            };

            wijinputdate.prototype._allowEdit = function () {
                return !this.option('disableUserInput');
            };

            wijinputdate.prototype._onFocus = function (e) {
                _super.prototype._onFocus.call(this, e);

                if (!this._allowEdit()) {
                    return;
                }
                this._updateText();

                if (this.element.data('IsInSelectTextMethod') == true) {
                    return;
                }

                if (input.CoreUtility.chrome) {
                    var self = this;
                    self.element.data('needResoteActiveField', true);
                    window.setTimeout(function () {
                        self.element.data('needResoteActiveField', false);
                        if (self.options.highlightText == "all") {
                            self._highLightAllField();
                            this._setOption('activeField', 0);
                        } else {
                            self._highLightField();
                        }
                    }, 200);
                } else {
                    if (this.options.highlightText == "all") {
                        this._highLightAllField();
                        this.element.data('ignoreHighLight', true);
                        this._setOption('activeField', 0);
                    } else {
                        this._highLightField();
                    }
                }
            };

            wijinputdate.prototype._simulate = function (text) {
                var str = null;

                if (typeof text === "string") {
                    str = text;
                } else {
                    var range = this.element.wijtextselection();
                    var start = this.element.data('lastSelection').start;
                    var end = range.end;

                    if (end >= start) {
                        str = this.element.val().substring(start, end);
                    }
                }

                for (var era = 0; era < input.DateTimeInfo.GetEraCount(); era++) {
                    if ((str.toLowerCase() === input.DateTimeInfo.GetEraShortNames()[era].toLowerCase()) || (str.toLowerCase() === input.DateTimeInfo.GetEraAbbreviations()[era].toLowerCase()) || (str.toLowerCase() === input.DateTimeInfo.GetEraSymbols()[era].toLowerCase()) || (str.toLowerCase() === input.DateTimeInfo.GetEraNames()[era].toLowerCase())) {
                        str = input.DateTimeInfo.GetEraShortNames()[era].toLowerCase();
                        break;
                    }
                }

                _super.prototype._simulate.call(this, str);
            };

            wijinputdate.prototype._doSpin = function (up, repeating) {
                var _this = this;
                if (!this._allowEdit()) {
                    return false;
                }
                if (repeating && this.element.data('breakSpinner')) {
                    return false;
                }

                if (up) {
                    this._trigger('spinUp', null);
                } else {
                    this._trigger('spinDown', null);
                }

                if (this.options.date == null) {
                    this._setDefaultDate(up);
                    return;
                }

                var spinResult = false;
                if (up) {
                    spinResult = this._textProvider.incEnumPart();
                } else {
                    spinResult = this._textProvider.decEnumPart();
                }

                if (spinResult) {
                    this._updateText();

                    //#68654
                    if (input.CoreUtility.chrome) {
                        var self = this;
                        setTimeout(function () {
                            self.element.focus();
                            self._highLightField();
                        }, 10);
                    } else {
                        this._highLightField();
                    }
                }

                if (repeating && !this.element.data('breakSpinner')) {
                    var spinTimer = window.setTimeout(function () {
                        return _this._doSpin(up, true);
                    }, this._calcSpinInterval());
                    this.element.data("spintimer", spinTimer);
                }

                return true;
            };

            wijinputdate.prototype._setDefaultDate = function (up) {
                if (up) {
                    this.options.date = this._isEraFormatExist() ? this._getRealEraMinDate() : this._getRealMinDate();
                } else {
                    this.options.date = this._isEraFormatExist() ? this._getRealEraMaxDate() : this._getRealMaxDate();
                }

                this._updateText();
                this._highLightField();
            };

            wijinputdate.prototype._onChange = function () {
            };

            wijinputdate.prototype._afterFocused = function () {
                if (this._isNullText()) {
                    this._doFocus();
                }
                //var hc = () => {
                //	this._highLightCursor();
                //	this._resetTimeStamp();
                //};
                // to fixed the issue 27522. remove this time out. by dail 2012-9-6
                //window.setTimeout(hc, 10);
            };

            wijinputdate.prototype._onBlur = function (e) {
                _super.prototype._onBlur.call(this, e);
                this._checkDate();

                //this._removeState('focus', this.outerDiv);
                this._updateText();
            };

            wijinputdate.prototype._keyDownPreview = function (e) {
                // Fix bug 69276:Time cannot be edited for the second time. The reason is in iOS Safari:
                // No click event fires after tap the text while input element is focus-in status;
                // No click and touch event fire after tap the first cursor position of the text while input element is focus-in status.
                // So we have to correct highlight in keydown.
                if (input.CoreUtility.IPad && this.element.data('ignoreHighLight') != true) {
                    var range = this.element.wijtextselection();
                    if (range != null && range.end == range.start) {
                        this._highLightCursor();
                    }
                }

                if (_super.prototype._keyDownPreview.call(this, e)) {
                    return true;
                }

                var key = e.keyCode || e.which, selRange;
                switch (key) {
                    case jqKeyCode.UP:
                    case jqKeyCode.DOWN:
                        if (e.altKey) {
                            this._onTriggerClicked();
                            return true;
                        } else {
                            if (this.element.data("pickerCurrentTab") != "List") {
                                this._doSpin(key == jqKeyCode.UP, false);
                                this._stopEvent(e);
                                return true;
                            }
                        }
                        break;
                    case jqKeyCode.LEFT:
                        if (this.options.activeField == 0 && (this.options.blurOnLeftRightKey.toLowerCase() == "left" || this.options.blurOnLeftRightKey.toLowerCase() == "both")) {
                            input.CoreUtility.MoveFocus(this.element.get(0), false);
                            this._trigger('keyExit');
                        } else {
                            this._toPrevField();
                        }
                        return true;
                    case jqKeyCode.RIGHT:
                        if (this.options.activeField == this._textProvider.getFieldCount() - 1 && (this.options.blurOnLeftRightKey.toLowerCase() == "right" || this.options.blurOnLeftRightKey.toLowerCase() == "both")) {
                            input.CoreUtility.MoveFocus(this.element.get(0), true);
                            this._trigger('keyExit');
                        } else {
                            this._toNextField();
                        }

                        return true;
                    case jqKeyCode.ENTER:
                        if (this._wasPopupShowing) {
                            if (this.element.data("pickerCurrentTab") == "Calendar") {
                                if (this.options.date == null) {
                                    this._setOption('date', new Date());
                                }
                            } else if (this.element.data("pickerCurrentTab") == "List") {
                                this._processKeyForDropDownList(e);
                            } else {
                                this._okButtonMouseDown(null, null);
                            }
                            this._hidePopup();
                            return true;
                        } else {
                            if (this.options.hideEnter) {
                                _super.prototype._stopEvent.call(this, e);
                            }
                        }
                        break;
                    case jqKeyCode.TAB:
                        if (this.options.tabAction !== "field" || this.options.highlightText !== "field") {
                            this._trigger('keyExit');
                            break;
                        }

                        selRange = this.element.wijtextselection();
                        if (selRange && selRange.end - selRange.start !== this.element.val().length) {
                            if (e.shiftKey) {
                                if (this.options.activeField > 0) {
                                    this._toPrevField();
                                } else {
                                    this._trigger('keyExit');
                                    break;
                                }
                            } else {
                                if (this.options.activeField < this._textProvider.getFieldCount() - 1) {
                                    this._toNextField();
                                } else {
                                    this._trigger('keyExit');
                                    break;
                                }
                            }
                            return true;
                        }
                        break;
                    case jqKeyCode.SPACE:
                    case 188:
                    case 190:
                    case 110:
                    case 191:
                        if (e.shiftKey) {
                            if (this.options.activeField > 0) {
                                this._toPrevField();
                                return true;
                            }
                        } else {
                            if (this.options.activeField < this._textProvider.getFieldCount() - 1) {
                                this._toNextField();
                                return true;
                            }
                        }
                        break;
                    case jqKeyCode.HOME:
                        if (e.ctrlKey) {
                            this._setOption('date', new Date());
                        } else {
                            this._toFirstField();
                        }
                        return true;
                    case jqKeyCode.END:
                        if (e.ctrlKey) {
                            this._processClearButton();
                        } else {
                            this._toLastField();
                        }
                        return true;
                    case jqKeyCode.BACKSPACE:
                    case jqKeyCode.DELETE:
                        if (this._allowEdit()) {
                            this._processDeleteKey();
                            return true;
                        }
                        break;
                }

                return false;
            };

            wijinputdate.prototype._processDeleteKey = function () {
                if (this.options.date == null) {
                    return;
                }

                var selRange = this.element.wijtextselection();
                if (selRange.end - selRange.start === this.element.val().length) {
                    var minDate = this._isEraFormatExist() ? this._getRealEraMinDate() : this._getRealMinDate();
                    if (this.options.date > minDate) {
                        this._setOption('date', minDate);
                        return;
                    }
                } else {
                    var activeField = this.options.activeField;
                    var oldText = this._textProvider.getFiledText(activeField);
                    this._clearField();
                    var newText = this._textProvider.getFiledText(activeField);
                    if (oldText != newText) {
                        return;
                    }
                }

                this._processClearButton();
            };

            wijinputdate.prototype._autoMoveToNextField = function (pos, ch) {
                if (!this.options.autoNextField) {
                    return;
                }

                if (this._textProvider.needToMove(this.options.activeField, pos, ch)) {
                    this._toNextField();
                }
            };

            wijinputdate.prototype._processClearButton = function () {
                if (this._allowEdit()) {
                    this._setOption('date', null);
                } else {
                    this._updateText();
                }
            };

            wijinputdate.prototype._autoMoveToNextControl = function (pos, ch, activeField) {
                if (!this.options.blurOnLastChar || activeField !== this._textProvider.getFieldCount() - 1) {
                    return;
                }

                if (this._textProvider.needToMove(activeField, pos, ch)) {
                    input.CoreUtility.MoveFocus(this.element.get(0), true);
                    this._trigger('keyExit');
                }
            };

            wijinputdate.prototype._keyPressPreview = function (e) {
                var key = e.keyCode || e.which, range, ch, fieldSep, cursor, now, newAction, lastTime, pos, ret, lastInput;

                if (key === jqKeyCode.ENTER) {
                    if (this.isDateNull()) {
                        this._setOption("date", new Date());
                    }
                    return false;
                }

                range = this._textProvider.getFieldRange(this.options.activeField);
                if (range) {
                    if (key === jqKeyCode.TAB) {
                        return true;
                    }

                    if (key === jqKeyCode.SPACE) {
                        this._stopEvent(e);
                        return true;
                    }

                    ch = String.fromCharCode(key);
                    fieldSep = this._textProvider.isFieldSep(ch, this.options.activeField);
                    if (fieldSep) {
                        this._toNextField();
                        this._stopEvent(e);
                        return true;
                    }

                    cursor = this.element.data('cursorPos');
                    now = new Date();
                    lastTime = this.element.data('timeStamp');
                    lastInput = this.element.data('lastInput');
                    newAction = (now.getTime() - lastTime.getTime()) > this.options.keyDelay;
                    var inputChar = ch;
                    if (newAction) {
                        cursor = 0;
                    } else if (lastInput) {
                        inputChar = lastInput + inputChar;
                    }
                    this.element.data({ timeStamp: now, lastInput: inputChar });

                    pos = range.start + cursor;
                    this.element.data('cursorPos', ++cursor);

                    var nullFlag = this.options.date == null;
                    ret = this._textProvider.addToField(inputChar, this.options.activeField, pos);
                    var activeField = this.options.activeField;
                    if (ret) {
                        this._updateText();
                        this._autoMoveToNextField(cursor, ch);
                        this._highLightField();
                        this._autoMoveToNextControl(cursor, ch, activeField);
                    } else {
                        if (nullFlag) {
                            this._setOption("date", null);
                        }
                        this._resetTimeStamp();
                        this._fireIvalidInputEvent();
                    }

                    if (activeField != this.options.activeField) {
                        this.element.data("lastInputChar", "");
                    } else {
                        this.element.data("lastInputChar", ch);
                    }

                    this._stopEvent(e);
                    return true;
                }

                return false;
            };

            wijinputdate.prototype._raiseDataChanged = function () {
                var d = this.options.date, prevDt = this.element.data('preDate');
                this.element.data('preDate', !d ? null : new Date(d.getTime()));

                if ((!prevDt && d) || (prevDt && !d) || (prevDt && d && (prevDt.getTime() !== d.getTime()))) {
                    if (this._popupVisible()) {
                        // DaryLuo 2013/09/04, improve performance on IE7.
                        // Sync calendar will cost a lot of time.
                        this._syncCalendar();
                    }
                    if (d instanceof Date === true) {
                        this.element.attr('aria-valuenow', d.getTime());
                    }
                    this._trigger('dateChanged', null, { date: d });
                }
            };

            wijinputdate.prototype._isMinDate = function (date) {
                return date.getFullYear() === 1 && date.getMonth() === 0 && date.getDate() === 1;
            };

            wijinputdate.prototype._reInitPicker = function () {
                this._destroyPicker();
                this._initPicker();
            };

            wijinputdate.prototype._destroy = function () {
                _super.prototype._destroy.call(this);
                this._destroyPicker();
            };

            wijinputdate.prototype._destroyPicker = function () {
                var tablePicker = this.element.data('pickers');
                if (tablePicker != undefined) {
                    this.element.data('pickers', null);
                    this.element.data('calendar', null);
                    this.element.data('datePicker', null);
                    this.element.data('timePicker', null);
                    this._comboDiv = undefined;
                }
            };

            wijinputdate.prototype._initPicker = function () {
                var _this = this;
                var tablePicker = this.element.data('pickers');
                if (tablePicker != undefined) {
                    return;
                }

                var self = this;
                this._initPickerData();

                var pickerCount = this._getPickerCount();
                var pickerWidth = this.element.data('pickerWidth');
                var pickerHeight = this.element.data('pickerHeight');
                var pickerAreaHeight = this.element.data('pickerAreaHeight');

                if (pickerCount > 1) {
                    pickerHeight += 8;
                    pickerAreaHeight += 8;
                }

                var pickerDivHeight = pickerCount > 1 ? pickerHeight : pickerAreaHeight;

                tablePicker = $("<table/>").appendTo(document.body).attr({ "class": "ui-widget-content ui-corner-all", "borderWidth": "0px", "cellspacing": "0px", "cellpadding": "0px", "cursor": "default" }).css({ "font-size": "12px" }).mouseup(function (e) {
                    e.stopPropagation();
                });

                var trPicker = $("<tr/>").appendTo(tablePicker);

                var trButton = $("<tr/>").appendTo(tablePicker);

                var tdPicker = $("<td/>").appendTo(trPicker).css({ "width": "100%", "height": "100%" });

                var tdButton = $("<td/>").appendTo(trButton).attr("align", "center").css({ "width": "100%", "height": "30px", "display": "none" });

                var divOK = $("<input type='button'/>").appendTo(tdButton).attr({ "class": "ui-state-active ui-widget", "value": "OK" }).css({ "width": "80px", "height": "26px", "margin": "1px", "text-align": "center", "cursor": "pointer", "visibility": "hidden" }).mousedown(function (e) {
                    self._okButtonMouseDown(e);
                });

                var divPickers = $("<div/>").appendTo(tdPicker).css({ "width": "100%", "height": "100%", "padding": "0px", "margin": "0px", "borderWidth": "0px", "overflow": "hidden" });

                var ulPicker = $("<ul/>").css({ "line-height": "1px", "font-size": "12px" });

                if (pickerCount > 1) {
                    ulPicker.appendTo(divPickers);
                }

                var currentTab = "";
                if (this._isCalendarPickerShown()) {
                    if (pickerCount > 1) {
                        this._addPickerTab(ulPicker, "Calendar", "#" + this._id + "_CalendarDiv");
                    } else {
                        if (input.CoreUtility.IsIE9()) {
                            tdPicker.css({ "width": "" });
                            divPickers.css({ "width": "" });
                        }
                    }

                    this._initCalendarPicker();
                    var calendar = this.element.data('calendar');
                    this._addPickerEditor(divPickers, calendar, this._id + "_CalendarDiv");
                    currentTab = "Calendar";
                }

                if (this._isListPickerShown()) {
                    if (pickerCount > 1) {
                        this._addPickerTab(ulPicker, "List", "#" + this._id + "_listDiv");
                    }
                    this._initListPicker();
                    this._addPickerEditor(divPickers, this._comboDiv, this._id + "_listDiv");

                    currentTab = currentTab == "" ? "List" : currentTab;
                }

                if (this._isDatePickerShown()) {
                    if (pickerCount > 1) {
                        this._addPickerTab(ulPicker, "Date", "#" + this._id + "_dateDiv");
                    }
                    this._wijinputdateroller._initDatePicker();
                    var datePicker = this.element.data('datePicker');
                    this._addPickerEditor(divPickers, datePicker, this._id + "_dateDiv");
                    currentTab = currentTab == "" ? "Date" : currentTab;
                }

                if (this._isTimePickerShown()) {
                    if (pickerCount > 1) {
                        this._addPickerTab(ulPicker, "Time", "#" + this._id + "_timeDiv");
                    }
                    this._wijinputdateroller._initTimePicker();
                    var timePicker = this.element.data('timePicker');
                    this._addPickerEditor(divPickers, timePicker, this._id + "_timeDiv");
                    currentTab = currentTab == "" ? "Time" : currentTab;
                }

                if (currentTab == "Calendar") {
                    tablePicker.css({ "width": pickerWidth + "px", "height": "", "font-size": "" });
                } else if (currentTab == "Date" || currentTab == "Time") {
                    tdButton.css({ "display": "" });
                    tablePicker.css({ "width": pickerWidth + "px", "height": pickerHeight + "px", "font-size": "12px" });
                    divPickers.css({ "height": pickerDivHeight + "px" });
                }

                this.element.data("pickerCurrentTab", currentTab);

                var self = this;
                divPickers.wijtabs({
                    select: function (e, arg) {
                        var tabText = arg.tab.outerText || arg.tab.text;
                        tdButton.css({ "display": "none" });
                        self.element.data("pickerCurrentTab", tabText);
                        if (tabText == "Calendar") {
                            if (!input.CoreUtility.IPad) {
                                self.focus();
                            }
                            tablePicker.css({ "width": pickerWidth + "px", "height": "", "font-size": "" });
                            divPickers.css({ "height": "100%" });
                        } else if (tabText == "List") {
                            var listWidth = self._getListPickerWidth();
                            self._comboDiv.wijlist("option", "width", listWidth);
                            tablePicker.css({ "width": listWidth, "height": "", "font-size": "" });
                            divPickers.css({ "height": "100%" });
                            self._comboDiv.wijlist('renderList');
                            if (!input.CoreUtility.IPad) {
                                self._comboDiv.focus();
                            }
                        } else {
                            if (!input.CoreUtility.IPad) {
                                self.focus();
                            }
                            if (tabText == "Time" || tabText == "Date") {
                                tdButton.css({ "display": "" });
                                tablePicker.css({ "width": pickerWidth + "px", "height": pickerHeight + "px", "font-size": "12px" });
                                divPickers.css({ "height": pickerDivHeight + "px" });
                            }
                        }
                    }
                });

                tablePicker.wijpopup({
                    autoHide: true,
                    hidden: function () {
                        _this._trigger('dropDownClose');
                        _this._wasPopupShowing = false;
                    },
                    shown: function () {
                        _this._trigger('dropDownOpen');
                        _this._wasPopupShowing = true;

                        var calOpts = _this.options.calendar, calEle, calendar, calGrid;
                        if (!calOpts || !calOpts.calendarMode) {
                            return;
                        }
                        calEle = _this.element.data('calendar');
                        calendar = calEle.data("wijmo-wijcalendar");
                        if (calendar != null) {
                            setTimeout(function () {
                                calGrid = calendar._getMyGrid();
                                calGrid.gridType = calOpts.calendarMode;
                                calendar._updateMyGrid(1);
                            }, 0);
                        }
                    }
                });

                this.element.data('pickers', tablePicker);
                this.element.data('divPickers', divPickers);
                this.element.data('divOK', divOK);
            };

            wijinputdate.prototype._initPickerData = function () {
                var tabWidth = 70;
                var tabHeight = 32;
                var listItemHeight = 26;
                var buttonHeight = 30;
                var minPickerWidth = 150;
                var minPickerHeight = 100;
                var minCalendarPickerWidth = 235;
                var minCalendarPickerHeight = 242;
                var minDateTimePickerWidth = 220;
                var minDateTimePickerHeight = 220;
                var pickerCount = this._getPickerCount();

                var minWidth = pickerCount * tabWidth;
                var minHeight = minPickerHeight;

                minWidth = minWidth < minPickerWidth ? minPickerWidth : minWidth;
                if (this._isCalendarPickerShown()) {
                    minWidth = minWidth < minCalendarPickerWidth ? minCalendarPickerWidth : minWidth;
                    minHeight = minHeight < minCalendarPickerHeight ? minCalendarPickerHeight : minHeight;
                }

                if (this._isListPickerShown()) {
                    var listItem = this._getcomboItems();
                    if (listItem != undefined) {
                        var minListHeight = listItem.length * listItemHeight;
                        minHeight = minHeight < minListHeight ? minListHeight : minHeight;
                    }
                }

                if (this._isDatePickerShown()) {
                    minWidth = minWidth < minDateTimePickerWidth ? minDateTimePickerWidth : minWidth;
                    minHeight = minHeight < minDateTimePickerWidth ? minDateTimePickerWidth : minHeight;

                    var pickerMinYear = this._wijinputdateroller._getDatePickerMinYear();
                    var pickerMaxYear = this._wijinputdateroller._getDatePickerMaxYear();
                    var defaultDateFormat = this._wijinputdateroller._getDefaultDatePickerFormat();
                    var pickerFormat = this.options.pickers.datePicker.format != undefined ? this.options.pickers.datePicker.format : defaultDateFormat;
                    var pickerDateFormat = pickerFormat.split(',');

                    if (pickerDateFormat.length != 3) {
                        pickerDateFormat = defaultDateFormat.split(',');
                        this.options.pickers.datePicker.format = defaultDateFormat;
                    }

                    var yearFormat = this._wijinputdateroller._getRollFormat(pickerDateFormat, "y");
                    var monthFormat = this._wijinputdateroller._getRollFormat(pickerDateFormat, "M");
                    var dayFormat = this._wijinputdateroller._getRollFormat(pickerDateFormat, "d");

                    if (!this._wijinputdateroller._isValidatePickerFormat(yearFormat) || !this._wijinputdateroller._isValidatePickerFormat(monthFormat) || !this._wijinputdateroller._isValidatePickerFormat(dayFormat)) {
                        pickerDateFormat = defaultDateFormat.split(',');
                        yearFormat = this._wijinputdateroller._getRollFormat(pickerDateFormat, "y");
                        monthFormat = this._wijinputdateroller._getRollFormat(pickerDateFormat, "M");
                        dayFormat = this._wijinputdateroller._getRollFormat(pickerDateFormat, "d");
                        this.options.pickers.datePicker.format = defaultDateFormat;
                    }

                    this.element.data('pickerDateYearFormat', yearFormat);
                    this.element.data('pickerDateMonthFormat', monthFormat);
                    this.element.data('pickerDateDayFormat', dayFormat);
                    this.element.data('pickerMinYear', pickerMinYear);
                    this.element.data('pickerMaxYear', pickerMaxYear);
                    this.element.data('pickerDateFormat', pickerDateFormat);
                }

                if (this._isTimePickerShown()) {
                    minWidth = minWidth < minDateTimePickerWidth ? minDateTimePickerWidth : minWidth;
                    minHeight = minHeight < minDateTimePickerWidth ? minDateTimePickerWidth : minHeight;

                    var defaultTimeFormat = this._wijinputdateroller._getDefaultTimePickerFormat();
                    var format = this.options.pickers.timePicker.format != undefined ? this.options.pickers.timePicker.format : defaultTimeFormat;
                    var pickerTimeFormat = format.split(',');

                    if (pickerTimeFormat.length != 3) {
                        pickerTimeFormat = defaultTimeFormat.split(',');
                        this.options.pickers.timePicker.format = defaultTimeFormat;
                    }

                    var hourFormat = this._wijinputdateroller._getRollFormat(pickerTimeFormat, "h");
                    var minuteFormat = this._wijinputdateroller._getRollFormat(pickerTimeFormat, "m");
                    var amFormat = this._wijinputdateroller._getRollFormat(pickerTimeFormat, "t");

                    if (!this._wijinputdateroller._isValidatePickerFormat(hourFormat) || !this._wijinputdateroller._isValidatePickerFormat(minuteFormat) || !this._wijinputdateroller._isValidatePickerFormat(amFormat)) {
                        pickerTimeFormat = defaultTimeFormat.split(',');
                        hourFormat = this._wijinputdateroller._getRollFormat(pickerTimeFormat, "h");
                        minuteFormat = this._wijinputdateroller._getRollFormat(pickerTimeFormat, "m");
                        amFormat = this._wijinputdateroller._getRollFormat(pickerTimeFormat, "t");
                        this.options.pickers.timePicker.format = defaultTimeFormat;
                    }

                    this.element.data('pickerTimeHourFormat', hourFormat);
                    this.element.data('pickerTimeMinuteFormat', minuteFormat);
                    this.element.data('pickerTimeAMFormat', amFormat);
                    this.element.data('pickerTimeFormat', pickerTimeFormat);
                }

                var pickerWidth = this.options.pickers.width != undefined ? this.options.pickers.width : 0;
                var pickerHeight = this.options.pickers.height != undefined ? this.options.pickers.height : 0;

                pickerWidth = pickerWidth < minWidth ? minWidth : pickerWidth;
                pickerHeight = pickerHeight < minHeight ? minHeight : pickerHeight;
                pickerHeight -= pickerCount > 1 ? tabHeight : 0;

                var pickerAreaHeight = pickerHeight - buttonHeight;
                var itemHeight = Math.floor(pickerAreaHeight / 5) + 1;
                var indicatorHeight = itemHeight * 2;
                var indicatorTranslateTop = itemHeight * 5 + 6;
                var indicatorTranslateDown = itemHeight * 4 - 3;
                var indicatorTranslateSelector = itemHeight * 2 + 2;
                var indicatorTranslateContent = itemHeight;

                this.element.data('itemHeight', itemHeight);
                this.element.data('indicatorHeight', indicatorHeight);
                this.element.data('pickerWidth', pickerWidth);
                this.element.data('pickerHeight', pickerHeight);
                this.element.data('pickerAreaHeight', pickerAreaHeight);
                this.element.data('indicatorTranslateTop', indicatorTranslateTop);
                this.element.data('indicatorTranslateDown', indicatorTranslateDown);
                this.element.data('indicatorTranslateSelector', indicatorTranslateSelector);
                this.element.data('indicatorTranslateContent', indicatorTranslateContent);
            };

            wijinputdate.prototype._initListPicker = function () {
                var _this = this;
                if (this._comboDiv !== undefined) {
                    return;
                }

                this._comboDiv = $("<div/>").css({ "overflow": "hidden", "display": "block", "left": "", "top": "", "position": "" });

                var content = this._normalize(this._getcomboItems());
                this._comboDiv.wijlist({
                    maxItemsCount: 5,
                    autoSize: true,
                    selected: function (event, ui) {
                        if (!_this.options.disableUserInput) {
                            _this._setData(ui.item.value);
                        }

                        var pickers = _this.element.data('pickers');
                        setTimeout(function () {
                            try  {
                                if (pickers != undefined) {
                                    pickers.wijpopup('hide');
                                }
                            } catch (e) {
                            }
                        }, 250);
                        _this._trySetFocus();
                    }
                });

                this._comboDiv.wijlist('setItems', content);
                this._comboDiv.wijlist('renderList');

                if (input.CoreUtility.IsIE7()) {
                    this._comboDiv.attr("align", "left");
                }
            };

            wijinputdate.prototype._initCalendarPicker = function () {
                var _this = this;
                var calendar = this.element.data('calendar');
                if (calendar != undefined) {
                    return;
                }

                //var c = this.options.calendar;
                //if (c === undefined || c === null) {
                //    return;
                //}
                //if (typeof (c) === 'boolean' || c === 'default') {
                //    c = $("<div/>");
                //}
                var c = $("<div/>");
                calendar = $(c);
                if (calendar.length !== 1) {
                    return;
                }

                this.element.data('calendar', calendar);

                // if the localization from the resource files.
                if (this.options.localization) {
                    this.options.nextTooltip = this.options.localization.nextTooltip;
                    this.options.prevTooltip = this.options.localization.prevTooltip;
                    this.options.titleFormat = this.options.localization.titleFormat;
                    this.options.toolTipFormat = this.options.localization.toolTipFormat;
                }

                calendar.wijcalendar({
                    popupMode: true,
                    culture: this.options.culture,
                    cultureCalendar: this.options.cultureCalendar,
                    //add for localization(tooltip)
                    nextTooltip: this.options.nextTooltip || 'Next',
                    prevTooltip: this.options.prevTooltip || 'Previous',
                    titleFormat: this.options.titleFormat || 'MMMM yyyy',
                    toolTipFormat: this.options.toolTipFormat || 'dddd, MMMM dd, yyyy',
                    afterSlide: function () {
                        if (_this.options.afterSlide != null) {
                            _this.options.afterSlide.call(_this, null);
                        }
                    },
                    selectedDatesChanged: function () {
                        var selDate = calendar.wijcalendar("getSelectedDate"), curDate = _this.option('date');
                        _this._wasPopupShowing = false;

                        var pickers = _this.element.data('pickers');
                        setTimeout(function () {
                            try  {
                                if (pickers != undefined) {
                                    pickers.wijpopup('hide');
                                }
                                if (selDate) {
                                    if (curDate) {
                                        selDate.setHours(curDate.getHours());
                                        selDate.setMinutes(curDate.getMinutes());
                                        selDate.setSeconds(curDate.getSeconds());
                                        selDate.setMilliseconds(curDate.getMilliseconds());
                                    }

                                    if (_this._allowEdit()) {
                                        _this.option('date', selDate);
                                        _this.selectText();
                                    }
                                }
                                _this._trySetFocus();
                            } catch (e) {
                            }
                        }, 250);
                    }
                });

                calendar.css({ "display": "block", "left": "", "top": "", "position": "", "margin-bottom": "0px" });

                this._syncCalendar();
                this._updateCalendarPicker();
                // the bind event can't trigger.!!!
                //            calendar.bind('wijcalendarselectedDatesChanged', function () {
                //                var selDate = $(this).wijcalendar("getSelectedDate");
                //                $(this).wijcalendar("close");
                //                if (!!selDate) { self.option('date', selDate); }
                //                self._trySetFocus();
                //               });
            };

            wijinputdate.prototype._updateCalendarPicker = function () {
                var calendar = this.element.data('calendar');
                var pickers = this.options.pickers;
                if (calendar == undefined || pickers == undefined) {
                    return;
                }

                if (pickers.calendar == undefined) {
                    return;
                }

                if (pickers.calendar.allowQuickPick != undefined) {
                    calendar.wijcalendar('option', 'allowQuickPick', pickers.calendar.allowQuickPick);
                }

                if (pickers.calendar.navButtons != undefined) {
                    calendar.wijcalendar('option', 'navButtons', pickers.calendar.navButtons);
                }

                if (pickers.calendar.nextTooltip != undefined) {
                    calendar.wijcalendar('option', 'nextTooltip', pickers.calendar.nextTooltip);
                }

                if (pickers.calendar.prevTooltip != undefined) {
                    calendar.wijcalendar('option', 'prevTooltip', pickers.calendar.prevTooltip);
                }

                if (pickers.calendar.showDayPadding != undefined) {
                    calendar.wijcalendar('option', 'showDayPadding', pickers.calendar.showDayPadding);
                }

                if (pickers.calendar.showOtherMonthDays != undefined) {
                    calendar.wijcalendar('option', 'showOtherMonthDays', pickers.calendar.showOtherMonthDays);
                }

                if (pickers.calendar.showTitle != undefined) {
                    calendar.wijcalendar('option', 'showTitle', pickers.calendar.showTitle);
                }

                if (pickers.calendar.showWeekDays != undefined) {
                    calendar.wijcalendar('option', 'showWeekDays', pickers.calendar.showWeekDays);
                }

                if (pickers.calendar.showWeekNumbers != undefined) {
                    calendar.wijcalendar('option', 'showWeekNumbers', pickers.calendar.showWeekNumbers);
                }

                if (pickers.calendar.titleFormat != undefined) {
                    calendar.wijcalendar('option', 'titleFormat', pickers.calendar.titleFormat);
                }

                if (pickers.calendar.toolTipFormat != undefined) {
                    calendar.wijcalendar('option', 'toolTipFormat', pickers.calendar.toolTipFormat);
                }

                if (pickers.calendar.weekDayFormat != undefined) {
                    calendar.wijcalendar('option', 'weekDayFormat', pickers.calendar.weekDayFormat);
                }
            };

            wijinputdate.prototype._okButtonMouseDown = function (e, arg) {
                var year = this.element.data("pickerYear");
                var month = this.element.data("pickerMonth") - 1;
                var day = this.element.data("pickerDay");
                var hour = this.element.data("pickerHour");
                var minute = this.element.data("pickerMinute");
                var am = this.element.data("pickerAM");

                if (hour == 12) {
                    hour = 0;
                }

                if (am == 1) {
                    hour += 12;
                }

                var date = this._getPickerValue();
                date.setFullYear(year);
                date.setMonth(month);
                date.setDate(day);
                date.setHours(hour);
                date.setMinutes(minute);

                this._wasPopupShowing = false;

                var pickers = this.element.data('pickers');
                setTimeout(function () {
                    if (pickers != undefined) {
                        try  {
                            pickers.wijpopup('hide');
                        } catch (e) {
                        }
                    }
                }, 250);

                if (this._allowEdit()) {
                    this.option('date', date);
                    this.selectText();
                }
                this._trySetFocus();
            };

            wijinputdate.prototype._getListPickerWidth = function () {
                var comboWidth = this._getcomboWidth();
                var pickerWidth = this.element.data("pickerWidth");
                var width = comboWidth != undefined ? comboWidth : this.outerDiv.width();
                return pickerWidth > width ? pickerWidth + "px" : width + "px";
            };

            wijinputdate.prototype._getPickerValue = function () {
                var pickerValue = this.options.date;
                pickerValue = pickerValue == null ? new Date() : pickerValue;
                return pickerValue;
            };

            wijinputdate.prototype._getStandardAMPM = function (value) {
                var culture = this._getCulture();
                if (culture && culture.calendar) {
                    var tmp = culture.calendars.standard[value];
                    if (tmp) {
                        return tmp[0];
                    }
                }
                return value;
            };

            wijinputdate.prototype._syncCalendar = function () {
                var calendar = this.element.data('calendar');
                if (!calendar) {
                    return;
                }

                var date = this._safeGetDate();
                if (date == null || this._isMinDate(date)) {
                    date = new Date();
                }

                //HelenLiu: 2014/12/17 Fix bug 98538.
                //calendar.wijcalendar('option', 'displayDate', date);
                calendar.wijcalendar('option', 'displayDate', new Date(date.getFullYear(), date.getMonth(), 1));

                if (this.options.minDate) {
                    calendar.wijcalendar('option', 'minDate', this.options.minDate);
                }

                if (this.options.maxDate) {
                    calendar.wijcalendar('option', 'maxDate', this.options.maxDate);
                }

                calendar.wijcalendar('unSelectAll');
                calendar.wijcalendar('selectDate', date);
                calendar.wijcalendar('refresh');
            };

            wijinputdate.prototype._showPopup = function () {
                var _this = this;
                if (this._isDatePickerNeedReInit()) {
                    this._reInitPicker();
                }

                var pickers = this.element.data('pickers');
                if (pickers == undefined) {
                    return false;
                }

                pickers.wijpopup('show', $.extend({}, this.options.popupPosition, { of: this.outerDiv })).one("mousedown", function () {
                    _this._deferClearBlurTimeout();
                });

                var pickerValue = this._getPickerValue();
                var hour = pickerValue.getHours();
                if (hour > 12) {
                    hour -= 12;
                } else if (hour == 0) {
                    hour = 12;
                }

                this.element.data("pickerValue", pickerValue);
                this.element.data("pickerYear", pickerValue.getFullYear());
                this.element.data("pickerMonth", pickerValue.getMonth() + 1);
                this.element.data("pickerDay", pickerValue.getDate());
                this.element.data("pickerHour", hour);
                this.element.data("pickerMinute", pickerValue.getMinutes());
                this.element.data("pickerAM", pickerValue.getHours() < 12 ? 0 : 1);
                this.element.data('divOK').css("visibility", "");

                if (this._isTimePickerShown()) {
                    this._wijinputdateroller._updateTimePicker();
                    pickers.attr({ "class": "ui-widget-content ui-corner-all" });
                }

                if (this._isDatePickerShown()) {
                    this._wijinputdateroller._updateDatePicker();
                    pickers.css({ "font-size": "12px" }).attr({ "class": "ui-widget-content ui-corner-all" });
                }

                if (this._isListPickerShown()) {
                    if (this._getPickerCount() == 1) {
                        pickers.attr({ "class": "" });
                        this._comboDiv.focus();
                    }

                    if (this.element.data("pickerCurrentTab") == "List") {
                        var listWidth = this._getListPickerWidth();
                        pickers.css({ "width": listWidth, "height": "" });
                        pickers.css({ "font-size": "" });
                        var parentElement = this._comboDiv[0].parentElement;
                        this._comboDiv.wijlist("destroy");
                        this._comboDiv.remove();
                        delete this._comboDiv;
                        this._initListPicker();
                        this._comboDiv.appendTo(parentElement);
                        this._comboDiv.focus();
                    }

                    this._comboDiv.one("focus", function () {
                        _this._clearBlurTimeout();
                    });
                }

                if (this._isCalendarPickerShown()) {
                    this._syncCalendar();

                    if (this.element.data("pickerCurrentTab") == "Calendar") {
                        if (this._getPickerCount() <= 1) {
                            pickers.css({ "width": "" });
                        }
                        pickers.css({ "font-size": "" });
                    }
                }

                return true;
            };

            wijinputdate.prototype._hidePopup = function () {
                var pickers = this.element.data('pickers');
                if (pickers != undefined) {
                    pickers.wijpopup('hide');
                }

                this.element.data('divOK').css("visibility", "hidden");
            };

            wijinputdate.prototype._popupVisible = function () {
                var pickers = this.element.data('pickers');
                if (pickers != undefined) {
                    return pickers.wijpopup('isVisible');
                }

                return false;
            };

            //Add comments by Ryanwu@20160520.
            //For fixing the issue#151957,152107.
            //_isComboListVisible(): boolean {
            //	return this._popupVisible();
            //}
            //end by RyanWu@20160520.
            wijinputdate.prototype._isValidDate = function (date, chkBounds) {
                if (date === undefined) {
                    return false;
                }

                if (isNaN(date)) {
                    return false;
                }

                if (date.getFullYear() < 1 || date.getFullYear() > 9999) {
                    return false;
                }

                if (chkBounds) {
                    if (this.options.minDate) {
                        if (date < this.options.minDate) {
                            return false;
                        }
                    }

                    if (this.options.maxDate) {
                        if (date > this.options.maxDate) {
                            return false;
                        }
                    }
                }

                return true;
            };

            wijinputdate.prototype._isDatePickerNeedReInit = function () {
                if (!this._isDatePickerShown()) {
                    return false;
                }

                var pickerMinYear = this.element.data("pickerMinYear");
                var pickerMaxYear = this.element.data("pickerMaxYear");
                var year = this._getPickerValue().getFullYear();
                if (year < pickerMinYear || year > pickerMaxYear) {
                    return true;
                }

                var minYear = this._isEraFormatExist() ? this._getRealEraMinDate().getFullYear() : this._getRealMinDate().getFullYear();
                var maxYear = this._isEraFormatExist() ? this._getRealEraMaxDate().getFullYear() : this._getRealMaxDate().getFullYear();

                if (pickerMinYear < minYear || pickerMaxYear > maxYear) {
                    return true;
                }

                return false;
            };

            wijinputdate.prototype._isDropDownButtonShown = function () {
                return this.options.showDropDownButton;
            };

            wijinputdate.prototype._isCalendarPickerShown = function () {
                return (this.options.pickers.calendar != undefined && this.options.pickers.calendar.visible !== false) || this._getPickerCount() == 0;
            };

            wijinputdate.prototype._isListPickerShown = function () {
                var comboItems = this._getcomboItems();
                if (comboItems != undefined && comboItems.length != undefined) {
                    return comboItems.length > 0;
                }

                return false;
            };

            wijinputdate.prototype._isTimePickerShown = function () {
                return this.options.pickers.timePicker != undefined && this.options.pickers.timePicker.visible !== false && this._wijinputdateroller !== null;
            };

            wijinputdate.prototype._isDatePickerShown = function () {
                return this.options.pickers.datePicker != undefined && this.options.pickers.datePicker.visible !== false && this._wijinputdateroller !== null;
            };

            wijinputdate.prototype._getPickerCount = function () {
                var count = 0;
                var calendarVisible = this.options.pickers.calendar != undefined && this.options.pickers.calendar.visible !== false;
                count += calendarVisible ? 1 : 0;
                count += this._isListPickerShown() ? 1 : 0;
                count += this._isTimePickerShown() ? 1 : 0;
                count += this._isDatePickerShown() ? 1 : 0;

                return count;
            };

            wijinputdate.prototype._addPickerEditor = function (pickerDiv, picker, pickerName) {
                var div = $("<div/>").attr({ "id": pickerName, "align": "center" }).css({ "padding": "0px" }).append(picker).appendTo(pickerDiv);
            };

            wijinputdate.prototype._addPickerTab = function (ul, tab, href) {
                var li = $("<li/>").appendTo(ul).css("line-height", "1px");

                var a = $("<a/>").attr("href", href).html(tab).appendTo(li);
            };

            wijinputdate.prototype._internalSetDate = function (date) {
                var self = this, o = this.options, inputElement = this.element, typing = !!inputElement.data('typing'), chkBounds;

                if (typing) {
                    o.date = date;

                    chkBounds = function () {
                        var now = new Date(), lastTime = inputElement.data('timeStamp');
                        if (lastTime) {
                            if ((now.getTime() - lastTime.getTime()) > o.keyDelay) {
                                self._safeSetDate(o.date, true);
                                self._updateText();
                                self._highLightField();
                            } else {
                                window.setTimeout(chkBounds, o.keyDelay);
                            }
                        }
                    };

                    window.setTimeout(chkBounds, o.keyDelay);
                } else {
                    this._safeSetDate(date);
                }
            };

            /** Selects a range of text in the widget.
            * @param {Number} start Start of the range.
            * @param {Number} end End of the range.
            * @example
            * // Select first two symbols in a wijinputdate
            * $(".selector").wijinputdate("selectText", 0, 2);
            */
            wijinputdate.prototype.selectText = function (start, end) {
                if (typeof start === "undefined") { start = 0; }
                if (typeof end === "undefined") { end = this.getText().length; }
                if (this.isFocused()) {
                    _super.prototype.selectText.call(this, start, end);
                } else {
                    this.element.data('IsInSelectTextMethod', true);
                    this.focus();
                    var obj = this;
                    setTimeout(function () {
                        try  {
                            obj.selectText(start, end);
                        } catch (e) {
                        }
                    }, 0);
                    this.element.data('IsInSelectTextMethod', false);
                }
            };
            return wijinputdate;
        })(input.wijinputcore);
        input.wijinputdate = wijinputdate;

        var wijinputdate_options = (function () {
            function wijinputdate_options() {
                this.wijCSS = {
                    wijinputdate: input.wijinputcore.prototype.options.wijCSS.wijinput + "-date"
                };
                /** Determines the initial date value shown for the wijdateinput widget.
                */
                this.date = undefined;
                /** Determines the earliest, or minimum, date that can be entered.
                */
                this.minDate = null;
                /** Determines the latest, or maximum date, that can be entered.
                */
                this.maxDate = null;
                /** The format pattern to display the date value when control got focus.
                *
                * @remarks
                * wijinputdate supports two types of formats:  <br />
                * Standard Format and Custom Format. <br />
                * <br />
                * A standard date and time format string uses a single format specifier  <br />
                * to define the text representation of a date and time value. <br />
                * <br />
                * Possible values for Standard Format are: <br />
                * "d": ShortDatePattern <br />
                * "D": LongDatePattern <br />
                * "f": Full date and time (long date and short time)  <br />
                * "F": FullDateTimePattern  <br />
                * "g": General (short date and short time)  <br />
                * "G": General (short date and long time)  <br />
                * "m": MonthDayPattern  <br />
                * "M": monthDayPattern  <br />
                * "r": RFC1123Pattern   <br />
                * "R": RFC1123Pattern   <br />
                * "s": SortableDateTimePattern   <br />
                * "t": shortTimePattern   <br />
                * "T": LongTimePattern   <br />
                * "u": UniversalSortableDateTimePattern  <br />
                * "U": Full date and time (long date and long time) using universal time  <br />
                * "y": YearMonthPattern   <br />
                * "Y": yearMonthPattern   <br />
                *
                * Any date and time format string that contains more than one character,  <br/>
                * including white space, is interpreted as a custom date and time format
                * string. For example:    <br/>
                * "mmm-dd-yyyy", "mmmm d, yyyy", "mm/dd/yyyy", "d-mmm-yyyy",
                * "ddd, mmmm dd, yyyy" etc.   <br/>
                *
                * Below are the custom date and time format specifiers:  <br/>
                *   <br/>
                * "d": The day of the month, from 1 through 31.   <br />
                * "dd": The day of the month, from 01 through 31.  <br />
                * "ddd": The abbreviated name of the day of the week.  <br />
                * "dddd": The full name of the day of the week.   <br />
                * "m": The minute, from 0 through 59.   <br />
                * "mm": The minute, from 00 through 59.  <br />
                * "M": The month, from 1 through 12.  <br />
                * "MM": The month, from 01 through 12.  <br />
                * "MMM": The abbreviated name of the month.  <br />
                * "MMMM": The full name of the month.  <br />
                * "y": The year, from 0 to 99.   <br />
                * "yy": The year, from 00 to 99   <br />
                * "yyy": The year, with a minimum of three digits.  <br />
                * "yyyy": The year as a four-digit number   <br />
                * "h": The hour, using a 12-hour clock from 1 to 12.   <br />
                * "hh": The hour, using a 12-hour clock from 01 to 12.   <br />
                * "H": The hour, using a 24-hour clock from 0 to 23.   <br />
                * "HH": The hour, using a 24-hour clock from 00 to 23.  <br />
                * "s": The second, from 0 through 59.   <br />
                * "ss": The second, from 00 through 59.   <br />
                * "t": The first character of the AM/PM designator.   <br />
                * "tt": The AM/PM designator.    <br />
                */
                this.dateFormat = 'd';
                /** The format pattern to display the date value when control lost focus.
                *
                * @remarks
                * wijinputdate supports two types of formats:   <br />
                * Standard Format and Custom Format.   <br />
                * <br />
                * A standard date and time format string uses a single format specifier <br />
                * to define the text representation of a date and time value.   <br />
                *
                * Possible values for Standard Format are:  <br />
                * "d": ShortDatePattern  <br />
                * "D": LongDatePattern  <br />
                * "f": Full date and time (long date and short time) <br />
                * "F": FullDateTimePattern  <br />
                * "g": General (short date and short time)  <br />
                * "G": General (short date and long time)  <br />
                * "m": MonthDayPattern   <br />
                * "M": monthDayPattern  <br />
                * "r": RFC1123Pattern   <br />
                * "R": RFC1123Pattern   <br />
                * "s": SortableDateTimePattern  <br />
                * "t": shortTimePattern  <br />
                * "T": LongTimePattern   <br />
                * "u": UniversalSortableDateTimePattern  <br />
                * "U": Full date and time (long date and long time) using universal time   <br />
                * "y": YearMonthPattern  <br />
                * "Y": yearMonthPattern  <br />
                *
                * Any date and time format string that contains more than one character, <br />
                * including white space, is interpreted as a custom date and time format   <br />
                * string. For example: <br />
                * "mmm-dd-yyyy", "mmmm d, yyyy", "mm/dd/yyyy", "d-mmm-yyyy",
                * "ddd, mmmm dd, yyyy" etc.  <br />
                *
                * Below are the custom date and time format specifiers:  <br />
                *
                * "d": The day of the month, from 1 through 31.   <br />
                * "dd": The day of the month, from 01 through 31.   <br />
                * "ddd": The abbreviated name of the day of the week.  <br />
                * "dddd": The full name of the day of the week.  <br />
                * "m": The minute, from 0 through 59.   <br />
                * "mm": The minute, from 00 through 59.  <br />
                * "M": The month, from 1 through 12.  <br />
                * "MM": The month, from 01 through 12.   <br />
                * "MMM": The abbreviated name of the month.  <br />
                * "MMMM": The full name of the month. <br />
                * "y": The year, from 0 to 99.  <br />
                * "yy": The year, from 00 to 99  <br />
                * "yyy": The year, with a minimum of three digits.  <br />
                * "yyyy": The year as a four-digit number  <br />
                * "h": The hour, using a 12-hour clock from 1 to 12.  <br />
                * "hh": The hour, using a 12-hour clock from 01 to 12.  <br />
                * "H": The hour, using a 24-hour clock from 0 to 23.   <br />
                * "HH": The hour, using a 24-hour clock from 00 to 23.  <br />
                * "s": The second, from 0 through 59.   <br />
                * "ss": The second, from 00 through 59.  <br />
                * "t": The first character of the AM/PM designator.  <br />
                * "tt": The AM/PM designator.    <br />
                * "E": Display the nengo year as a single digit number when possible (first year use Japanese name).  <br />
                */
                this.displayFormat = '';
                /** Determines string designator for hours that are "ante meridiem" (before noon).
                * @remarks
                * The Text set in the amDesignator option is displayed in the position occupied by the keywords "tt" and "t"
                * in the dateFormat or dipslayFormat.  <br />
                * If the custom pattern includes the format pattern "tt" and the time is before noon,
                * the value of amDesignator is displayed in place of the "tt" in the dateFormat or displayFormat pattern.   <br />
                * If the custom pattern includes the format pattern "t", only the first character of amDesignator is displayed.   <br />
                * If setting "tt" in format and not setting amDesignator/pmDesignator options,
                * it will show the string getting from the specified culture.    <br />
                * If not set, it will show "午前"/"午後" in Japanese culture and "AM"/"PM" in English culture.   <br />
                * If setting "t" in format and not setting amDesignator/pmDesignator options, it will show the string getting from current culture.  <br />
                * If not set, it will display "午" in Japanese culture and "A"/"P" in English culture.  <br />
                */
                this.amDesignator = "";
                /** Determines the string designator for hours that are "post meridiem" (after noon).
                * @remarks
                * The Text set in the amDesignator option is displayed in the position occupied by the keywords "tt" and "t"
                * in the dateFormat or dipslayFormat.  <br />
                * If the custom pattern includes the format pattern "tt" and the time is after noon,
                * the value of pmDesignator is displayed in place of the "tt" in the dateFormat or displayFormat pattern.   <br />
                * If the custom pattern includes the format pattern "t", only the first character of pmDesignator is displayed.   <br />
                * If setting "tt" in format and not setting amDesignator/pmDesignator options,
                * it will show the string getting from the specified culture.    <br />
                * If not set, it will show "午前"/"午後" in Japanese culture and "AM"/"PM" in English culture.   <br />
                * If setting "t" in format and not setting amDesignator/pmDesignator options, it will show the string getting from current culture.  <br />
                * If not set, it will display "午" in Japanese culture and "A"/"P" in English culture.  <br />
                */
                this.pmDesignator = "";
                /** A boolean value determines whether to express midnight as 24:00.
                */
                this.midnightAs0 = true;
                /** A boolean value determines the range of hours that can be entered in the control.
                * @remarks
                * If set this property to false,
                * the control sets the range for the hour field from 1 - 12.  If set to true
                * the range is set to 0 - 11.
                */
                this.hour12As0 = false;
                /** Determins whether or not the next control in the tab order receives
                * the focus as soon as the control is filled at the last character.
                */
                this.blurOnLastChar = false;
                /** Gets or set whether the focus automatically moves to the next or previous
                * tab ordering control when pressing the left, right arrow keys.
                */
                this.blurOnLeftRightKey = "none";
                /** Gets or sets whether the tab key moves the focus between controls or between
                * fields within the control, possible values is "field", "control".
                * @remarks
                * The caret moves to the next field when this property is "field".
                * If the caret is in the last field, the input focus leaves this control when pressing the TAB key.
                * If the value is "control", the behavior is similar to the standard control.
                */
                this.tabAction = "field";
                /** Determines how the control should interpret 2-digits year inputted in year field.
                * when the "smartInputMode" option is set to true.
                * @remarks
                * For example, if "startYear" is set to 1950 (the default value), and "smartInputMode" is true.   <br />
                * Enter 2-digit year value which is greater than 50 [e.g., 88]  <br />
                * ‘1988’ displays in year part.  <br />
                * Enter 2-digit year value which is less than 50 [e.g., 12]  <br />
                * ‘2012’ displays in year part.  <br />
                */
                this.startYear = 1950;
                /** Determines the character that appears when the widget has focus but no input has been entered.
                */
                this.promptChar = '';
                /** Determines whether the control should interpret 2-digits year inputted in year field.
                * using the value provided in the "startYear" option.
                * @remarks
                * For example, when "smartInputMode" is false (the default value), and "startYear" is 1950. <br />
                * Enter 2-digit year value which is greater than 50 [e.g., 88]  <br />
                * ‘0088’ displays in year part.    <br />
                * Enter 2-digit year value which is less than 50 [e.g., 12]  <br />
                * ‘0012’ displays in year part.  <br />
                * Set "smartInputMode" to true.  <br />
                * Enter 2-digit year value which is greater than 50 [e.g., 88]  <br />
                * ‘1988’ displays in year part when smartInputMode is true.   <br />
                * Enter 2-digit year value which is less than 50 [e.g., 12]  <br />
                * ‘2012’ displays in year part. <br />
                */
                this.smartInputMode = false;
                /** Determines the active field index.
                */
                this.activeField = 0;
                /** Determines the time span, in milliseconds,
                * between two input intentions.
                * @remarks
                * when press a keyboard, and the widget will delay a time and then handle
                * the next keyboard press. Use this option to control the speed of the key press.
                */
                this.keyDelay = 800;
                /** Determines whether to automatically moves to the next field.
                * @remarks
                * For example, if user want input the '2012-9-20' in inputdate widget,
                * if this option's value is true, when user type '2012' in textbox,
                * it will auto focus in next field, user can type '9' in second field,
                * if this option's value is false, user want to type '9' in second field,
                * they should focus the second field by manual.
                */
                this.autoNextField = true;
                /** This option will supply an element to init the calendar widget
                * @ignore
                * @remarks
                * If the value is 'default', the widget will create a div and
                * append it to body element, and using this element to init calendar.
                * User can set this option value to an element,
                * and the widget will init the calendar using this element.
                */
                this.calendar = null;
                /** Detemines the popup position of a calendar.
                * See jQuery.ui.position for position options.
                * @example
                * // In the following example, the Y offset between the popup position and wijinputdate is 10 pixel.
                * $("#textbox1").wijinputdate({
                *     popupPosition: { offset: '0 10' },
                *     comboItems: [{ label: "first Day", value: new Date(2013, 1, 1) },
                *         { label: "second day", value: new Date(2013, 3, 3) },
                *         { label: "third day", value: new Date(2013, 4, 5) }]
                * });
                */
                this.popupPosition = {
                    offset: '0 4'
                };
                /** The afterSlide event handler.
                * A function called after the calendar view slided to another month.
                * Cancellable.
                * @event
                */
                this.afterSlide = null;
                /** Gets or sets whether to highlight the control's Text on receiving input focus.
                * possible values is "field", "all" .
                * @example
                * $("#textbox1").wijinputdate({
                *     highlightText: "field"
                * });
                */
                this.highlightText = "field";
                /** Determines how much to increase/decrease the active field when performing spin on the the active field.
                * @example
                * $("#textbox1").wijinputdate({
                *     increment: 2
                * });
                */
                this.increment = 1;
                /** Determines the input method setting of widget.
                * Possible values are: 'auto', 'active', 'inactive', 'disabled'
                * @remarks
                * This property only take effect on IE and firefox browser.
                */
                this.imeMode = "auto";
                /** Determines whether dropdown button is displayed.
                */
                this.showDropDownButton = true;
                /** Determines whether dropdown button is displayed.
                */
                this.showTrigger = undefined;
                /** An object contains the settings for the dropdown list.
                * @example
                * //  The following code show the dropdown calendar, dropdown list,
                * //  and set the dorpdown window's width to 100px, height to 30px;
                * $(".selector").wijinputdate({
                *     pickers: {
                *         calendar: {},
                *         list: [{ label: 'item1', value: 1 }],
                *         width: 100,
                *         height: 30
                *     }
                * });
                *
                * // The following code show the dropdown date picker and dropdown time picker,
                * // also it sets the time picker's format ot "hh hh:mm".
                * $(".selector").wijinputdate({
                *     pickers: {
                *         datePicker: {},
                *         timePicker: { format: "tt hh:mm" }
                *     }
                * });
                *
                * // The following code shows the drpdown date picker and dropdown time picker.
                * // also it sets the date picker's format to "yyyy/MMMM/dd".
                * $(".selector").wijinputdate({
                *     pickers: {
                *         datePicker: { format: "yyyy/MMMM/dd" },
                *         timePicker: {}
                *     }
                * });
                */
                this.pickers = {
                    list: undefined,
                    width: undefined,
                    height: undefined,
                    calendar: undefined,
                    datePicker: undefined,
                    timePicker: undefined
                };
                /** The dateChanged event handler.
                * A function called when the date of the input is changed.
                * @event
                * @dataKey {Date} date The data with this event.
                */
                this.dateChanged = null;
                /** The spinUp event handler.
                * A function called when spin up event fired.
                * @event
                */
                this.spinUp = null;
                /** The spinDown event handler.
                * A function called when spin down event fired.
                * @event
                */
                this.spinDown = null;
                /** The valueBoundsExceeded event hander.
                * A function called when the valueBoundExceeded event fired.
                * @event
                */
                this.valueBoundsExceeded = null;
            }
            return wijinputdate_options;
        })();
        wijinputdate.prototype.options = $.extend(true, {}, input.wijinputcore.prototype.options, new wijinputdate_options());

        $.wijmo.registerWidget("wijinputdate", wijinputdate.prototype);

        /** @ignore */
        var wijDateTextProvider = (function () {
            function wijDateTextProvider(inputWidget, format, displayFormat) {
                this.inputWidget = inputWidget;
                this._disableSmartInputMode = false;
                this.paddingZero = input.paddingZero;
                this.formatter = new input.wijDateTextFormatter(inputWidget, format, false);
                displayFormat = displayFormat == "" ? format : displayFormat;
                this.displayFormatter = new input.wijDateTextFormatter(inputWidget, displayFormat, true);
            }
            wijDateTextProvider.prototype.initialize = function () {
            };

            wijDateTextProvider.prototype.getFiledText = function (index) {
                var desc = this.formatter.fields[index];
                return desc.getText();
            };

            wijDateTextProvider.prototype.getFieldCount = function () {
                return this.formatter.fields.length;
            };

            wijDateTextProvider.prototype.getFieldRange = function (index) {
                if (index >= this.formatter.fields.length) {
                    index = this.formatter.fields.length - 1;
                }
                var desc = this.formatter.fields[index];
                return {
                    start: desc.startIndex,
                    end: desc.startIndex + desc.getText().length
                };
            };

            wijDateTextProvider.prototype.getAllRange = function () {
                return {
                    start: 0,
                    end: this.formatter.toString().length
                };
            };

            wijDateTextProvider.prototype.getCursorField = function (pos) {
                if (this.formatter.desPostions.length == 0) {
                    return 0;
                }

                pos = Math.min(pos, this.formatter.desPostions.length - 1);
                pos = Math.max(pos, 0);
                var desc = this.formatter.desPostions[pos].desc, i;
                if (desc.type === -1) {
                    i = $.inArray(desc, this.formatter.descriptors);
                    if (i > 0 && this.formatter.descriptors[i - 1].type !== -1) {
                        desc = this.formatter.descriptors[i - 1];
                    } else {
                        return -1;
                    }
                }
                return $.inArray(desc, this.formatter.fields);
            };

            wijDateTextProvider.prototype.needToMove = function (index, pos, ch) {
                if (!this.inputWidget._isValidDate(this.inputWidget._safeGetDate(), true)) {
                    return false;
                }

                var desc = this.formatter.fields[index];
                switch (desc.type) {
                    case 72:
                    case 73:
                    case 74:
                        for (var i = 0; i < input.DateTimeInfo.GetEraCount(); i++) {
                            if ((ch.toLowerCase() === input.DateTimeInfo.GetEraShortcuts()[i].toLowerCase()) || (ch.toLowerCase() === input.DateTimeInfo.GetEraShortNames()[i].toLowerCase()) || (ch.toLowerCase() === input.DateTimeInfo.GetEraAbbreviations()[i].toLowerCase()) || (ch.toLowerCase() === input.DateTimeInfo.GetEraNames()[i].toLowerCase())) {
                                return true;
                            }
                        }
                        return false;
                }

                var val = parseInt(ch, 10);
                if (pos === desc.maxLen) {
                    return true;
                }

                if (isNaN(val)) {
                    return false;
                }

                var lastInputChar = this.inputWidget.element.data("lastInputChar");
                switch (desc.type) {
                    case 10:
                        return (this._isSmartInputMode() && pos === 2);
                    case 20:
                    case 25:
                    case 45:
                    case 46: {
                        if (lastInputChar == "0" && val == 1) {
                            return true;
                        }
                        return val > 1;
                    }
                    case 47:
                    case 48: {
                        if (lastInputChar == "0" && val <= 2) {
                            return true;
                        }
                        return val > 2;
                    }
                    case 30:
                    case 31: {
                        if (lastInputChar == "0" && val <= 3) {
                            return true;
                        }
                        return val > 3;
                    }
                    case 50:
                    case 51:
                    case 60:
                    case 61: {
                        if (lastInputChar == "0" && val <= 6) {
                            return true;
                        }
                        return val > 6;
                    }
                    case 70:
                    case 71:
                        return false;
                }

                return false;
            };

            wijDateTextProvider.prototype._isEraFormatExist = function () {
                return this.formatter._isEraFormatExist();
            };

            wijDateTextProvider.prototype._getCulture = function () {
                return this.inputWidget._getCulture();
            };

            wijDateTextProvider.prototype._isDigitString = function (s) {
                s = $.trim(s);
                if (s.length === 0) {
                    return true;
                }

                var c = s.charAt(0), f, t;
                if (c === '+' || c === '-') {
                    s = s.substr(1);
                    s = $.trim(s);
                }
                if (s.length === 0) {
                    return true;
                }
                try  {
                    f = parseFloat(s);
                    t = f.toString();
                    return t === s;
                } catch (e) {
                    return false;
                }
            };

            wijDateTextProvider.prototype._setFormat = function (format) {
                return this.formatter._setFormat(format);
            };

            wijDateTextProvider.prototype._setDisplayFormat = function (displayFormat) {
                return this.displayFormatter._setFormat(displayFormat);
            };

            wijDateTextProvider.prototype._internalSetDate = function (date) {
                if (this.inputWidget) {
                    this.inputWidget._internalSetDate(date);
                }
            };

            wijDateTextProvider.prototype.toString = function () {
                if (this.inputWidget._isEraFormatExist()) {
                    if (this.inputWidget.options.date != null) {
                        var minDate = this.inputWidget._getRealEraMinDate();
                        var maxDate = this.inputWidget._getRealEraMaxDate();
                        if (this.inputWidget.options.date < minDate || this.inputWidget.options.date > maxDate) {
                            return "";
                        }
                    }
                }

                if (!this.inputWidget.isFocused()) {
                    if (this.inputWidget.isDateNull() && this.inputWidget._getInnerNullText() != null) {
                        return this.inputWidget._getInnerNullText();
                    } else {
                        return this.displayFormatter.toString();
                    }
                }

                return this.formatter.toString();
            };

            wijDateTextProvider.prototype.parseDate = function (str) {
                var date;

                //if (this.formatter.pattern === 'dddd' ||
                //    this.formatter.pattern === 'ddd' ||
                //    typeof str === 'object') {
                //    try {
                //        date = new Date(str);
                //        if (isNaN(date)) {
                //            date = new Date();
                //        }
                //    }
                //    catch (e) {
                //        date = new Date();
                //    }
                //} else {
                //    date = Globalize.parseDate(str, this.formatter.pattern, this._getCulture());
                //    if (!date) {
                //        date = this._tryParseDate(str, this.formatter.pattern);
                //    }
                //    if (!date) {
                //        date = null;
                //    }
                //}
                date = $.wijinputcore.parseDate(str, this.formatter.pattern, this._getCulture());

                return date;
            };

            wijDateTextProvider.prototype.setText = function (value) {
                if (value === "") {
                    this._internalSetDate(null);
                } else {
                    var date = new Date(value);
                    if (isNaN(date.getTime())) {
                        date = this.parseDate(value);
                    }

                    if (date == null) {
                        this._internalSetDate(new Date(value));
                    } else {
                        this._internalSetDate(date);
                    }
                }

                return true;
            };

            wijDateTextProvider.prototype.haveEnumParts = function () {
                return false;
            };

            wijDateTextProvider.prototype.removeLiterals = function (s) {
                s = '' + s + '';
                s = s.replace(new RegExp('[+]', 'g'), '');
                s = s.replace(new RegExp('[.]', 'g'), '');
                s = s.replace(new RegExp('[:]', 'g'), '');
                s = s.replace(new RegExp('[-]', 'g'), '');
                s = s.replace(new RegExp('[()=]', 'g'), '');
                return s;
            };

            wijDateTextProvider.prototype.getFirstDelimiterPos = function (aText, bText) {
                var i = 0, j = 0, ch1, ch2;
                while (i < bText.length && j < aText.length) {
                    ch1 = bText.charAt(i);
                    ch2 = aText.charAt(j);
                    if (ch1 === ch2) {
                        j++;
                    } else {
                        return j - 1;
                    }
                    i++;
                }
                return aText.length - 1;
            };

            wijDateTextProvider.prototype.isFieldSep = function (value, activeField) {
                var nextField = activeField++, desc;
                if (nextField < this.formatter.descriptors.length) {
                    desc = this.formatter.descriptors[nextField];
                    if (desc.type !== -1) {
                        return false;
                    }
                    return (value === desc.text);
                }

                return false;
            };

            wijDateTextProvider.prototype.getPositionType = function (pos) {
                var desPos = this.formatter.desPostions[pos];
                return desPos.desc.type;
            };

            wijDateTextProvider.prototype.addToField = function (value, activeField, pos) {
                var desc = this.formatter.fields[activeField], txt, resultObj, ret;

                txt = value;
                resultObj = { val: value, pos: 0, offset: 0, isreset: false };
                this.inputWidget.element.data('typing', true);
                ret = desc.setText(txt, ((value.length === 1) ? false : true), resultObj, this._isSmartInputMode());
                this.inputWidget.element.data('typing', false);
                return ret;
            };

            wijDateTextProvider.prototype.insertAt = function (strInput, position, rh) {
                if (typeof rh === "undefined") { rh = new input.wijInputResult(); }
                rh.testPosition = -1;
                var desPos, oldTxt, pos, txt, tryToExpandAtRight, result, tryToExpandAtLeft, curInsertTxt, resultObj, prevTextLength, posAdjustValue, altInsertText, newTextLength, diff, s, delimOrEndPos, delta;
                if (strInput.length === 1) {
                    desPos = this.formatter.desPostions[position];
                    if (desPos && desPos.desc.type === -1) {
                        if (desPos.text === strInput) {
                            rh.testPosition = position;
                            rh.hint = rh.characterEscaped;
                            return true;
                        }
                    }
                }

                oldTxt = strInput;
                pos = position;
                strInput = this.removeLiterals(strInput);
                txt = strInput;
                tryToExpandAtRight = false;
                tryToExpandAtLeft = false;
                if (pos > 0 && txt.length === 1) {
                    pos--;
                    position = pos;
                    desPos = this.formatter.desPostions[pos];
                    tryToExpandAtRight = true;
                    if (desPos && (desPos.desc.type === -1 || desPos.desc.getText().length !== 1)) {
                        position++;
                        pos++;
                        tryToExpandAtRight = false;
                    }
                }
                result = false;
                while (txt.length > 0 && pos < this.formatter.desPostions.length) {
                    desPos = this.formatter.desPostions[pos];
                    if (desPos.desc.type === -1) {
                        pos = pos + desPos.length;
                        continue;
                    }
                    if (desPos.desc.needAdjustInsertPos()) {
                        curInsertTxt = txt.substr(0, (desPos.length - desPos.pos));
                        curInsertTxt = desPos.text.slice(0, desPos.pos) + curInsertTxt + desPos.text.slice(desPos.pos + curInsertTxt.length, desPos.length);
                        if (tryToExpandAtRight) {
                            curInsertTxt = desPos.text + curInsertTxt;
                        }
                        if (tryToExpandAtLeft) {
                            curInsertTxt = curInsertTxt + desPos.text;
                        }
                        prevTextLength = desPos.desc.getText().length;
                        altInsertText = '';
                        try  {
                            if (strInput.length === 1) {
                                if (!desPos.pos) {
                                    altInsertText = strInput;
                                } else if (desPos.pos > 0) {
                                    altInsertText = curInsertTxt.substring(0, desPos.pos + 1);
                                }
                            }
                        } catch (e) {
                        }
                        if (prevTextLength === 1 && curInsertTxt.length > 1 && strInput.length === 1) {
                            if (desPos.desc.type === 31 || desPos.desc.type === 25) {
                                this._disableSmartInputMode = true;
                            }
                        }
                        resultObj = {
                            val: strInput, pos: desPos.pos,
                            offset: 0, isreset: false
                        };
                        result = desPos.desc.setText(curInsertTxt, ((strInput.length === 1) ? false : true), resultObj);
                        this._disableSmartInputMode = false;
                        if (!result && typeof (altInsertText) !== 'undefined' && altInsertText.length > 0 && (desPos.desc.type === 26 || desPos.desc.type === 27 || desPos.desc.type === 100 || desPos.desc.type === 101 || desPos.desc.type === 250 || desPos.desc.type === 251)) {
                            result = desPos.desc.setText(altInsertText, ((strInput.length === 1) ? false : true), resultObj);
                        }
                        if (result) {
                            rh.hint = rh.success;
                            rh.testPosition = pos + resultObj.offset;
                            if (strInput.length === 1) {
                                newTextLength = desPos.desc.getText().length;
                                posAdjustValue = desPos.pos;
                                if (desPos.pos > (newTextLength - 1)) {
                                    posAdjustValue = newTextLength;
                                }
                                diff = newTextLength - prevTextLength;
                                if (diff > 0 && desPos.pos === prevTextLength - 1) {
                                    posAdjustValue = newTextLength - 1;
                                }
                                s = this.toString();
                                rh.testPosition = desPos.desc.startIndex + posAdjustValue + resultObj.offset;
                            }
                            txt = txt.slice(desPos.length - desPos.pos, txt.length);
                        } else {
                            rh.hint = rh.invalidInput;
                            if (rh.testPosition !== -1) {
                                rh.testPosition = position;
                            }
                            if (desPos.desc.type !== -1 && strInput.length === 1) {
                                return false;
                            }
                        }
                        pos = pos + desPos.length;
                    } else {
                        delimOrEndPos = this.getFirstDelimiterPos(txt, oldTxt);
                        if (delimOrEndPos < 0) {
                            delimOrEndPos = 0;
                        }
                        curInsertTxt = txt.substring(0, delimOrEndPos + 1);
                        resultObj = {
                            val: strInput, pos: desPos.pos,
                            offset: 0, isreset: false
                        };
                        result = desPos.desc.setText(curInsertTxt, ((strInput.length === 1) ? false : true), resultObj);
                        if (result) {
                            rh.hint = rh.success;
                            rh.testPosition = pos + resultObj.offset;
                            txt = txt.slice(delimOrEndPos + 1, txt.length);
                        } else {
                            rh.hint = rh.invalidInput;
                            if (rh.testPosition !== -1) {
                                rh.testPosition = position;
                            }
                        }
                        if (delimOrEndPos < 0) {
                            delimOrEndPos = 0;
                        }
                        delta = delimOrEndPos + 1;
                        pos = pos + delta;
                    }
                }
                return result;
            };

            wijDateTextProvider.prototype.removeAt = function (start, end, rh, skipCheck) {
                try  {
                    var desPos = this.formatter.desPostions[start], curInsertTxt, pos, resultObj, result, widget = this.inputWidget, element = widget.element, dateLength = element.val().length;

                    if (dateLength === end + 1 && start === 0) {
                        widget.isDeleteAll = true;
                    }
                    if (desPos.desc.needAdjustInsertPos()) {
                        curInsertTxt = '0';
                        pos = start;
                        desPos.text = desPos.desc.getText();
                        curInsertTxt = desPos.text.slice(0, desPos.pos) + curInsertTxt + desPos.text.slice(desPos.pos + curInsertTxt.length, desPos.length);

                        if (desPos.desc.name === 'tt') {
                            curInsertTxt = "AM";
                        } else if (desPos.desc.name === 't') {
                            curInsertTxt = "A";
                        } else if (desPos.desc.formatString === 'ee') {
                            curInsertTxt = "01";
                        } else if (desPos.desc.formatString === 'e') {
                            curInsertTxt = "1";
                        }

                        resultObj = {
                            val: curInsertTxt, pos: desPos.pos, offset: 0,
                            isreset: true, isfullreset: false
                        };
                        if ((end - start + 1) >= desPos.length) {
                            resultObj.isfullreset = true;
                            start = start + desPos.length;
                            pos = start;
                        }
                        result = desPos.desc.setText(curInsertTxt, false, resultObj, this._isSmartInputMode());
                        if (result) {
                            rh.hint = rh.success;
                            rh.testPosition = pos;
                        } else {
                            rh.hint = rh.invalidInput;
                            if (rh.testPosition === -1) {
                                rh.testPosition = start;
                            }
                        }
                    }
                    if (start < end) {
                        this.removeAt(start + 1, end, rh);
                    }
                    return true;
                } catch (e) {
                    return false;
                }
            };

            wijDateTextProvider.prototype.incEnumPart = function () {
                var desc = this.formatter.fields[this.inputWidget.options.activeField];
                if (desc) {
                    desc.inc();
                }
                return true;
            };

            wijDateTextProvider.prototype.decEnumPart = function () {
                var desc = this.formatter.fields[this.inputWidget.options.activeField];
                if (desc) {
                    desc.dec();
                }
                return true;
            };

            wijDateTextProvider.prototype._isSmartInputMode = function () {
                if (this._disableSmartInputMode) {
                    return false;
                }
                if (this.inputWidget) {
                    return this.inputWidget.options.smartInputMode;
                }
                return true;
            };

            wijDateTextProvider.prototype._getInt = function (str, i, minlength, maxlength) {
                var x, token;
                for (x = maxlength; x >= minlength; x--) {
                    token = str.substring(i, i + x);
                    if (token.length < minlength) {
                        return null;
                    }
                    if ($.wij.charValidator.isDigit(token)) {
                        return token;
                    }
                }
                return null;
            };

            wijDateTextProvider.prototype._tryParseDate = function (val, pattern) {
                var ci = this._getCulture().calendars, pattern2, sep, patterns, d;
                pattern = pattern || ci.standard.patterns.d;
                if (pattern) {
                    if (pattern.indexOf('MMM') === -1 && pattern.indexOf('MMMM') === -1) {
                        pattern = pattern.replace('MM', 'M');
                    }
                    pattern = pattern.replace('dd', 'd');
                    pattern = pattern.replace('tt', 'a');
                }

                pattern2 = pattern.replace('yyyy', 'yy');
                sep = ci.standard["/"];
                patterns = [
                    pattern, pattern2, pattern.replace(new RegExp(sep, 'g'), '-'),
                    pattern2.replace(new RegExp(sep, 'g'), '-'),
                    pattern.replace(new RegExp(sep, 'g'), '.'),
                    pattern2.replace(new RegExp(sep, 'g'), '.')];
                d = Globalize.parseDate(val, patterns, this._getCulture());

                if (d) {
                    return d;
                }

                // if the val is datetime string,
                // parse the string to datetime. added by dail 2012-6-25
                d = new Date(val);
                if (d.toString() !== "Invalid Date" && val && val !== "") {
                    return d;
                }

                return 0;
            };

            wijDateTextProvider.prototype._formatDate = function (date, format, culture) {
                var _this = this;
                if (!(date.valueOf())) {
                    return '&nbsp;';
                }

                var cf = this.inputWidget._getCulture().calendars.standard, sRes = format.replace(new RegExp('yyyy|MMMM|MMM|MM|M|mm|m|dddd|ddd|dd|d|hh|h|HH|H|ss|s|tt|t|a/p', 'gi'), function (match) {
                    var h;
                    switch (match) {
                        case 'yyyy':
                            return input.paddingZero(date.getFullYear(), 4);
                        case 'MMMM':
                            return culture.dateTimeFormat.monthNames[date.getMonth()];
                        case 'MMM':
                            return culture.dateTimeFormat.abbreviatedMonthNames[date.getMonth()];
                        case 'MM':
                            return _this.paddingZero((date.getMonth() + 1), 2);
                        case 'M':
                            return _this.paddingZero((date.getMonth() + 1), 1);
                        case 'mm':
                            return _this.paddingZero(date.getMinutes(), 2);
                        case 'm':
                            return _this.paddingZero(date.getMinutes(), 1);
                        case 'dddd':
                            return culture.dateTimeFormat.dayNames[date.getDay()];
                        case 'ddd':
                            return culture.dateTimeFormat.abbreviatedDayNames[date.getDay()];
                        case 'dd':
                            return _this.paddingZero(date.getDate(), 2);
                        case 'd':
                            return _this.paddingZero(date.getDate(), 1);
                        case 'hh':
                            h = date.getHours() % 12;
                            return _this.paddingZero(((h) ? h : 12), 2);
                        case 'h':
                            h = date.getHours() % 12;
                            return _this.paddingZero(((h) ? h : 12), 1);
                        case 'HH':
                            return _this.paddingZero(date.getHours(), 2);
                        case 'H':
                            return _this.paddingZero(date.getHours(), 1);
                        case 'ss':
                            return _this.paddingZero(date.getSeconds(), 2);
                        case 's':
                            return _this.paddingZero(date.getSeconds(), 1);
                        case 'tt':
                            return (date.getHours() < 12) ? cf.AM[0] : cf.PM[0];
                        case 't':
                            return (date.getHours() < 12) ? ((cf.AM[0].length > 0) ? cf.AM[0].charAt(0) : '') : ((cf.PM[0].length > 0) ? cf.PM[0].charAt(0) : '');
                        case 'a/p':
                            return (date.getHours() < 12) ? 'a' : 'p';
                    }
                    return 'N';
                });
                return sRes;
            };

            wijDateTextProvider.prototype.replaceWith = function (range, text) {
                var index = range.start;
                var result = new input.wijInputResult();
                if (range.start < range.end) {
                    this.removeAt(range.start, range.end - 1, result, true);
                    index = result.testPosition;
                }
                return this.insertAt(text, index, result) ? result : null;
            };
            return wijDateTextProvider;
        })();
        input.wijDateTextProvider = wijDateTextProvider;
        ;
    })(wijmo.input || (wijmo.input = {}));
    var input = wijmo.input;
})(wijmo || (wijmo = {}));

;
/// <reference path="jquery.wijmo.wijstringinfo.ts"/>
/// <reference path="jquery.wijmo.wijinpututility.ts"/>
/// <reference path="jquery.wijmo.wijinputcore.ts"/>
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var wijmo;
(function (wijmo) {
    /*
    * Depends:
    *	jquery-1.4.2.js
    *
    */
    (function (input) {
        var $ = jQuery;

        /** @ignore */
        var CharacterFilter = (function () {
            function CharacterFilter(label, owner, include) {
                this.filterLabel = label;
                this._include = include;
                this._owner = owner;
            }
            CharacterFilter.prototype.Check = function (text, index) {
                var retObj = {};
                retObj.success = false;
                retObj.strValue = "";
                retObj.index = index;

                // Check the character type.
                var checkingText = text.Substring(index, index + 1);

                var isValid = this.IsValid(checkingText);

                //	if ((isValid && this._include) || (!isValid && !this._include))
                //	{
                //		text = text.Substring(index, index + 1);
                //		index++;
                //
                //		retObj.strValue = text;
                //    	retObj.index = index;
                //		return retObj;
                //	}
                if (isValid) {
                    text = text.Substring(index, index + 1);
                    index++;

                    retObj.strValue = text;
                    retObj.index = index;
                    return retObj;
                }

                if (this._owner.GetAutoConvert() && (checkingText.length === 1 || checkingText.length === 3)) {
                    retObj = this.Convert(text, index);

                    if (retObj.success) {
                        return retObj;
                    }
                }

                return retObj;
            };

            CharacterFilter.prototype.IsValid = function (c) {
                if (c.length === 2 && (c.charCodeAt(1) === 0xff9e || c.charCodeAt(1) === 0xff9f)) {
                    // DaryLuo 2013/04/24 fix bug 1050 in IM Web 7.1
                    if (!input.CharProcess.CharEx.IsFullWidth(c) && input.CharProcess.CharEx.IsKatakana(c)) {
                        return this.IsValidTwoByte(c);
                    }
                }
                if (c.length > 1) {
                    return this.IsValidMoreByte(c);
                } else {
                    return this.IsValidTwoByte(c);
                }
            };

            CharacterFilter.prototype.IsValidTwoByte = function (c) {
                return false;
            };
            CharacterFilter.prototype.IsValidMoreByte = function (c) {
                return false;
            };

            CharacterFilter.prototype.Convert = function (text, index) {
                var retObj = {};
                retObj.success = true;
                retObj.strValue = "";
                retObj.index = index;

                var c = text.Substring(index, index + 1);

                var isValid;
                var charEx = input.CharProcess.CharEx;

                //if (true) {
                //    var charLength = {};
                //    var result = IVSCharHelper.ConvertedWithIVS(c, 0, charLength);
                //    if (result.length > 0) {
                //        isValid = this.IsValid(result);
                //        if (isValid) {
                //            index++;
                //            retObj.index = index;
                //            retObj.strValue = result;
                //            return retObj;
                //        }
                //    }
                //}
                // Convert between upper and lower alphabet automatically.
                if (charEx.IsAlphabet(c)) {
                    var r = charEx.IsLower(c) ? c.toUpperCase() : c.toLowerCase();
                    isValid = this.IsValid(r);
                    if ((isValid && this._include) || (!isValid && !this._include)) {
                        index++;
                        retObj.index = index;
                        retObj.strValue = r;
                        return retObj;
                        //return new string(r, 1);
                    }

                    c = charEx.IsFullWidth(c) ? charEx.ToHalfWidth(c) : charEx.ToFullWidth(c).text;
                    isValid = this.IsValid(c);
                    if ((isValid && this._include) || (!isValid && !this._include)) {
                        index++;
                        retObj.index = index;
                        retObj.strValue = c;
                        return retObj;
                        //return new string(c, 1);;
                    }
                    r = charEx.IsFullWidth(r) ? charEx.ToHalfWidth(r) : charEx.ToFullWidth(r).text;
                    isValid = this.IsValid(r);

                    if ((isValid && this._include) || (!isValid && !this._include)) {
                        index++;
                        retObj.index = index;
                        retObj.strValue = r;
                        return retObj;
                        //return new string(r, 1);;
                    }
                    retObj.success = false;
                    return retObj;
                }

                // Convert from Hiragana to DBCS/SBCS Katakana automatically.
                if (charEx.IsHiragana(c)) {
                    // Large < - > Small
                    if (charEx.IsLowerKana(c)) {
                        var u = charEx.ToUpperKana(c);
                        isValid = this.IsValid(u);
                        if ((isValid && this._include) || (!isValid && !this._include)) {
                            index++;
                            retObj.index = index;
                            retObj.strValue = u;
                            return retObj;
                        }
                    } else if (charEx.HasLowerKana(c)) {
                        var l = charEx.ToLowerKana(c);
                        isValid = this.IsValid(l);
                        if ((isValid && this._include) || (!isValid && !this._include)) {
                            index++;
                            retObj.index = index;
                            retObj.strValue = l;
                            return retObj;
                        }
                    }

                    c = charEx.ToKatakana(c);

                    // DaryLuo 2012/05/31 fix bug 116 in IM7. Add this.
                    isValid = this.IsValid(c);
                    if ((isValid && this._include) || (!isValid && !this._include)) {
                        index++;
                        retObj.index = index;
                        retObj.strValue = c;
                        return retObj;
                        //return new string(c, 1);
                    }

                    if (charEx.IsLowerKana(c)) {
                        var u = charEx.ToUpperKana(c);

                        // DaryLuo 2012/05/31 fix bug 116 in IM7. Add this.
                        isValid = this.IsValid(u);
                        if ((isValid && this._include) || (!isValid && !this._include)) {
                            index++;
                            retObj.index = index;
                            retObj.strValue = u;
                            return retObj;
                        }
                    } else if (charEx.HasLowerKana(c)) {
                        var l = charEx.ToLowerKana(c);
                        isValid = this.IsValid(l);
                        if ((isValid && this._include) || (!isValid && !this._include)) {
                            index++;
                            retObj.index = index;
                            retObj.strValue = l;
                            return retObj;
                        }
                    }

                    var chars = charEx.ToHalfWidthEx(c);
                    isValid = this.IsValid(chars);
                    if ((isValid && this._include) || (!isValid && !this._include)) {
                        index++;
                        retObj.index = index;
                        retObj.strValue = chars;
                        return retObj;
                        //return new string(chars);
                    }

                    if (charEx.IsLowerKana(chars)) {
                        chars = charEx.ToUpperKana(chars);
                        isValid = this.IsValid(chars);
                        if ((isValid && this._include) || (!isValid && !this._include)) {
                            index++;
                            retObj.index = index;
                            retObj.strValue = chars;
                            return retObj;
                        }
                    } else if (charEx.HasLowerKana(chars)) {
                        chars = charEx.ToLowerKana(chars);
                        isValid = this.IsValid(chars);
                        if ((isValid && this._include) || (!isValid && !this._include)) {
                            index++;
                            retObj.index = index;
                            retObj.strValue = chars;
                            return retObj;
                        }
                    }

                    retObj.success = false;
                    return retObj;
                }

                // Convert from Katakana to Hiragana (or DBCS <-> SBCS)automatically.
                if (charEx.IsKatakana(c)) {
                    // Large < - > Small
                    if (charEx.IsLowerKana(c)) {
                        var u = charEx.ToUpperKana(c);
                        isValid = this.IsValid(u);
                        if ((isValid && this._include) || (!isValid && !this._include)) {
                            index++;
                            retObj.index = index;
                            retObj.strValue = u;
                            return retObj;
                        }
                    } else if (charEx.HasLowerKana(c)) {
                        var l = charEx.ToLowerKana(c);
                        isValid = this.IsValid(l);
                        if ((isValid && this._include) || (!isValid && !this._include)) {
                            index++;
                            retObj.index = index;
                            retObj.strValue = l;
                            return retObj;
                        }
                    }

                    var r = c;
                    var processedAll = false;

                    // Check the soundex character.
                    if (charEx.IsFullWidth(c)) {
                        var newChars = charEx.ToHalfWidthEx(c);

                        if (newChars.GetLength() > 0) {
                            isValid = this.IsValid(newChars);
                            if ((isValid && this._include) || (!isValid && !this._include)) {
                                index++;
                                retObj.index = index;
                                retObj.strValue = newChars;
                                return retObj;
                                //return new string(newChars);
                            }
                        }

                        if (charEx.IsLowerKana(newChars)) {
                            newChars = charEx.ToUpperKana(newChars);
                            isValid = this.IsValid(newChars);
                            if ((isValid && this._include) || (!isValid && !this._include)) {
                                index++;
                                retObj.index = index;
                                retObj.strValue = newChars;
                                return retObj;
                            }
                        } else if (charEx.HasLowerKana(newChars)) {
                            newChars = charEx.ToLowerKana(newChars);
                            isValid = this.IsValid(newChars);
                            if ((isValid && this._include) || (!isValid && !this._include)) {
                                index++;
                                retObj.index = index;
                                retObj.strValue = newChars;
                                return retObj;
                            }
                        }
                    } else {
                        if (index == null) {
                            r = charEx.ToFullWidth(c).text;

                            if (!charEx.IsKatakana(r)) {
                                return retObj;
                            }

                            isValid = this.IsValid(r);
                            if ((isValid && this._include) || (!isValid && !this._include)) {
                                index++;
                                retObj.index = index;
                                retObj.strValue = r;
                                return retObj;
                            }
                        } else {
                            // To process what??? kyle.wang
                            if ((index + 1) < text.GetLength()) {
                                //r = charEx.ToFullWidthEx(out processedAll, new char[] {c, text[index + 1]});
                                var convertObj = charEx.ToFullWidth(text.Substring(index, index + 2));
                                r = convertObj.text;
                                processedAll = convertObj.processedAll;
                            } else {
                                r = charEx.ToFullWidth(c).text;
                            }

                            if (!charEx.IsKatakana(r)) {
                                return retObj;
                            }

                            isValid = this.IsValid(r);
                            if ((isValid && this._include) || (!isValid && !this._include)) {
                                index++;
                                if (processedAll) {
                                    index++;
                                }

                                retObj.index = index;
                                retObj.strValue = r;
                                return retObj;
                                //return new string(r, 1);
                            }
                        }

                        if (charEx.IsLowerKana(r)) {
                            var u = charEx.ToUpperKana(r);
                            isValid = this.IsValid(u);
                            if ((isValid && this._include) || (!isValid && !this._include)) {
                                index++;
                                retObj.index = index;
                                retObj.strValue = u;
                                return retObj;
                            }
                        } else if (charEx.HasLowerKana(r)) {
                            var l = charEx.ToLowerKana(r);
                            isValid = this.IsValid(l);
                            if ((isValid && this._include) || (!isValid && !this._include)) {
                                index++;
                                retObj.index = index;
                                retObj.strValue = l;
                                return retObj;
                            }
                        }
                    }

                    r = charEx.ToHiragana(r);
                    isValid = this.IsValid(r);
                    if ((isValid && this._include) || (!isValid && !this._include)) {
                        index++;
                        if (processedAll) {
                            index++;
                        }

                        retObj.index = index;
                        retObj.strValue = r;

                        //add by sj for bug 2955
                        if (r === '\u3094') {
                            if (processedAll) {
                                retObj.strValue = '\u3046' + '\u309B';
                            } else {
                                index--;
                                retObj.index = index;
                                retObj.strValue = "";
                                retObj.success = false;
                            }
                        }

                        //end by sj
                        return retObj;
                    }

                    if (charEx.IsLowerKana(r)) {
                        var u = charEx.ToUpperKana(r);
                        isValid = this.IsValid(u);
                        if ((isValid && this._include) || (!isValid && !this._include)) {
                            index++;
                            retObj.index = index;
                            retObj.strValue = u;
                            return retObj;
                        }
                    } else if (charEx.HasLowerKana(r)) {
                        var l = charEx.ToLowerKana(r);
                        isValid = this.IsValid(l);
                        if ((isValid && this._include) || (!isValid && !this._include)) {
                            index++;
                            retObj.index = index;
                            retObj.strValue = l;
                            return retObj;
                        }
                    }
                    //return new string(r, 1);;
                }

                // Convert between DBCS and SBCS automatically.
                c = charEx.IsFullWidth(c) ? charEx.ToHalfWidth(c) : charEx.ToFullWidth(c).text;
                isValid = this.IsValid(c);
                if ((isValid && this._include) || (!isValid && !this._include)) {
                    index++;
                    retObj.index = index;
                    retObj.strValue = c;
                    return retObj;
                    //return new string(c, 1);
                }

                retObj.success = false;
                return retObj;
            };
            return CharacterFilter;
        })();
        input.CharacterFilter = CharacterFilter;

        /** @ignore */
        var HalfWidthFilter = (function (_super) {
            __extends(HalfWidthFilter, _super);
            function HalfWidthFilter(owner, include) {
                _super.call(this, "HalfWidthFilter", owner, include);
            }
            HalfWidthFilter.prototype.IsValidTwoByte = function (c) {
                if (!input.CharProcess.CharEx.IsFullWidth(c)) {
                    return true;
                }

                if (c === '\x0D' || c === '\x0A') {
                    return true;
                }

                return false;
            };
            return HalfWidthFilter;
        })(CharacterFilter);

        /** @ignore */
        var FullWidthFilter = (function (_super) {
            __extends(FullWidthFilter, _super);
            function FullWidthFilter(owner, include) {
                _super.call(this, "FullWidthFilter", owner, include);
            }
            FullWidthFilter.prototype.IsValidTwoByte = function (c) {
                if (input.CharProcess.CharEx.IsFullWidth(c)) {
                    return true;
                }

                if (c === '\x0D' || c === '\x0A') {
                    return true;
                }

                return false;
            };
            return FullWidthFilter;
        })(CharacterFilter);

        /** @ignore */
        var HiraganaFilter = (function (_super) {
            __extends(HiraganaFilter, _super);
            function HiraganaFilter(owner, include) {
                _super.call(this, "HiraganaFilter", owner, include);
            }
            HiraganaFilter.prototype.IsValidTwoByte = function (c) {
                if (input.CharProcess.CharEx.IsHiragana(c)) {
                    return true;
                }

                if (c === '\x0D' || c === '\x0A') {
                    return true;
                }

                return false;
            };
            return HiraganaFilter;
        })(CharacterFilter);

        /** @ignore */
        var ShiftJISFilter = (function (_super) {
            __extends(ShiftJISFilter, _super);
            function ShiftJISFilter(owner, include) {
                _super.call(this, "ShiftJISFilter", owner, include);
            }
            ShiftJISFilter.prototype.IsValidTwoByte = function (c) {
                return input.CharProcess.CharEx.IsShiftJIS(c);
            };
            return ShiftJISFilter;
        })(CharacterFilter);

        /** @ignore */
        var JISX0208Filter = (function (_super) {
            __extends(JISX0208Filter, _super);
            function JISX0208Filter(owner, include) {
                _super.call(this, "JISX0208Filter", owner, include);
            }
            JISX0208Filter.prototype.IsValidTwoByte = function (c) {
                return input.CharProcess.CharEx.IsJISX0208(c);
            };
            return JISX0208Filter;
        })(CharacterFilter);

        /** @ignore */
        var DBCSHiraganaFilter = (function (_super) {
            __extends(DBCSHiraganaFilter, _super);
            function DBCSHiraganaFilter(owner, include) {
                _super.call(this, "DBCSHiraganaFilter", owner, include);
            }
            DBCSHiraganaFilter.prototype.IsValidTwoByte = function (c) {
                return input.CharProcess.CharEx.IsUpperKana(c) && input.CharProcess.CharEx.IsHiragana(c);
            };
            return DBCSHiraganaFilter;
        })(CharacterFilter);

        /** @ignore */
        var DBCSKatakanaFilter = (function (_super) {
            __extends(DBCSKatakanaFilter, _super);
            function DBCSKatakanaFilter(owner, include) {
                _super.call(this, "DBCSKatakanaFilter", owner, include);
            }
            DBCSKatakanaFilter.prototype.IsValidTwoByte = function (c) {
                return input.CharProcess.CharEx.IsFullWidth(c) && input.CharProcess.CharEx.IsKatakana(c) && !input.CharProcess.CharEx.IsLowerKana(c);
            };
            return DBCSKatakanaFilter;
        })(CharacterFilter);

        /** @ignore */
        var SBCSKatakanaFilter = (function (_super) {
            __extends(SBCSKatakanaFilter, _super);
            function SBCSKatakanaFilter(owner, include) {
                _super.call(this, "SBCSKatakanaFilter", owner, include);
            }
            SBCSKatakanaFilter.prototype.IsValidTwoByte = function (c) {
                return !input.CharProcess.CharEx.IsFullWidth(c) && input.CharProcess.CharEx.IsKatakana(c) && !input.CharProcess.CharEx.IsLowerKana(c);
            };
            return SBCSKatakanaFilter;
        })(CharacterFilter);

        /** @ignore */
        var SurrogateFilter = (function (_super) {
            __extends(SurrogateFilter, _super);
            function SurrogateFilter(owner, include) {
                _super.call(this, "SurrogateFilter", owner, include);
            }
            SurrogateFilter.prototype.IsValidTwoByte = function (c) {
                if (input.CharProcess.CharEx.IsSurrogatePair(c)) {
                    return true;
                }

                if (c === '\x0D' || c === '\x0A') {
                    return true;
                }

                return false;
            };

            SurrogateFilter.prototype.IsValidMoreByte = function (c) {
                for (var i = 0; i < c.length; i++) {
                    if (input.CharProcess.CharEx.IsSurrogate(c[i])) {
                        return true;
                    }
                }
                return false;
            };
            return SurrogateFilter;
        })(CharacterFilter);

        /** @ignore */
        var HalfWidthKatakanaFilter = (function (_super) {
            __extends(HalfWidthKatakanaFilter, _super);
            function HalfWidthKatakanaFilter(owner, include) {
                _super.call(this, "HalfWidthKatakanaFilter", owner, include);
            }
            HalfWidthKatakanaFilter.prototype.IsValidTwoByte = function (c) {
                if (!input.CharProcess.CharEx.IsFullWidth(c) && input.CharProcess.CharEx.IsKatakana(c)) {
                    return true;
                }

                if (c === '\x0D' || c === '\x0A') {
                    return true;
                }

                return false;
            };
            return HalfWidthKatakanaFilter;
        })(CharacterFilter);

        /** @ignore */
        var FullWidthKatakanaFilter = (function (_super) {
            __extends(FullWidthKatakanaFilter, _super);
            function FullWidthKatakanaFilter(owner, include) {
                _super.call(this, "FullWidthKatakanaFilter", owner, include);
            }
            FullWidthKatakanaFilter.prototype.IsValidTwoByte = function (c) {
                if (input.CharProcess.CharEx.IsFullWidth(c) && input.CharProcess.CharEx.IsKatakana(c)) {
                    return true;
                }

                if (c === '\x0D' || c === '\x0A') {
                    return true;
                }

                return false;
            };
            return FullWidthKatakanaFilter;
        })(CharacterFilter);

        /** @ignore */
        var HalfWidthSymbolsFilter = (function (_super) {
            __extends(HalfWidthSymbolsFilter, _super);
            function HalfWidthSymbolsFilter(owner, include) {
                _super.call(this, "HalfWidthSymbolsFilter", owner, include);
            }
            HalfWidthSymbolsFilter.prototype.IsValidTwoByte = function (c) {
                if (!input.CharProcess.CharEx.IsFullWidth(c) && input.CharProcess.CharEx.IsSymbol(c)) {
                    return true;
                }

                if (c === '\x0D' || c === '\x0A') {
                    return true;
                }

                return false;
            };
            return HalfWidthSymbolsFilter;
        })(CharacterFilter);

        /** @ignore */
        var FullWidthSymbolsFilter = (function (_super) {
            __extends(FullWidthSymbolsFilter, _super);
            function FullWidthSymbolsFilter(owner, include) {
                _super.call(this, "FullWidthSymbolsFilter", owner, include);
            }
            FullWidthSymbolsFilter.prototype.IsValidTwoByte = function (c) {
                if (input.CharProcess.CharEx.IsFullWidth(c) && input.CharProcess.CharEx.IsSymbol(c)) {
                    return true;
                }

                if (c === '\x0D' || c === '\x0A') {
                    return true;
                }

                return false;
            };
            return FullWidthSymbolsFilter;
        })(CharacterFilter);

        /** @ignore */
        var LimitedFilter = (function (_super) {
            __extends(LimitedFilter, _super);
            function LimitedFilter(includeChars, excludeChars, owner, include) {
                _super.call(this, "LimitedFilter", owner, include);
                this._includeChars = includeChars;
                this._excludeChars = excludeChars;
            }
            LimitedFilter.prototype.IsValidTwoByte = function (c) {
                if ((this._includeChars !== "" && this._includeChars.IndexOf(c) > -1) || (this._excludeChars !== "" && this._excludeChars.IndexOf(c) === -1)) {
                    return true;
                }

                if (c === '\x0D' || c === '\x0A') {
                    return true;
                }

                return false;
            };

            LimitedFilter.prototype.IsValidMoreByte = function (c) {
                if ((this._includeChars !== "" && this._includeChars.IndexOf(c) > -1) || (this._excludeChars !== "" && this._excludeChars.IndexOf(c) === -1)) {
                    return true;
                }

                if (c === '\x0D' || c === '\x0A') {
                    return true;
                }

                return false;
            };
            return LimitedFilter;
        })(CharacterFilter);

        /** @ignore */
        var RangeFilter = (function (_super) {
            __extends(RangeFilter, _super);
            function RangeFilter(startChar, endChar, owner, include) {
                _super.call(this, "RangeFilter", owner, include);
                this._startChar = startChar;
                this._endChar = endChar;
            }
            RangeFilter.prototype.IsValidTwoByte = function (c) {
                if (c >= this._startChar && c <= this._endChar) {
                    return true;
                }

                if (c === '\x0D' || c === '\x0A') {
                    return true;
                }

                return false;
            };
            return RangeFilter;
        })(CharacterFilter);

        /** @ignore */
        var UnionFilter = (function (_super) {
            __extends(UnionFilter, _super);
            function UnionFilter(owner, include) {
                _super.call(this, "UnionFilter", owner, include);
                this.filterArray = [];
            }
            UnionFilter.prototype.Add = function (filter) {
                if (filter == null) {
                    return;
                }

                //2012/08/17, Robin Hotfix Bug#37.
                if (filter.filterLabel === "HiraganaFilter") {
                    this.hiranagaFilter = filter;
                } else if (filter.filterLabel === "FullWidthKatakanaFilter") {
                    this.katakanaFilter = filter;
                }

                //End Hotfix Bug#37
                this.filterArray.push(filter);
            };

            UnionFilter.prototype.AddRange = function (filters) {
                for (var i = 0; i < filters.length; i++) {
                    this.Add(filters[i]);
                }
            };

            UnionFilter.prototype.IsValidTwoByte = function (c) {
                if (this.filterArray.length === 0) {
                    if (c === '\x0D' || c === '\x0A') {
                        return true;
                    }

                    return false;
                }
                var includeResult = false;
                var hasInclude = false;

                for (var i = 0; i < this.filterArray.length; i++) {
                    if (this.filterArray[i]._include) {
                        hasInclude = true;
                    }
                }

                //2012/08/17, Robin Hotfix Bug#37.
                // The char '\u30FC' is hiranaga while it is katakana type. See TextFilter for details.
                var isMixedJPChar = (c === '\u30FC');
                if (isMixedJPChar) {
                    if (this.hiranagaFilter && this.katakanaFilter) {
                        if (hasInclude) {
                            return true;
                        }
                    } else if (this.hiranagaFilter) {
                        return true;
                    } else if (this.katakanaFilter) {
                        return true;
                    }
                }

                for (var i = 0; i < this.filterArray.length; i++) {
                    if (this.filterArray[i].IsValid(c)) {
                        if (!this.filterArray[i]._include) {
                            return false;
                        } else {
                            includeResult = true;
                        }
                    } else {
                        if (!hasInclude) {
                            includeResult = true;
                        }
                    }
                }
                if (includeResult) {
                    return true;
                }

                if (c === '\x0D' || c === '\x0A') {
                    return true;
                }

                return false;
            };

            UnionFilter.prototype.IsValidMoreByte = function (c) {
                return this.IsValidTwoByte(c);
            };
            return UnionFilter;
        })(CharacterFilter);

        /** @ignore */
        var Field = (function () {
            function Field(label) {
                this.minLength = -1;
                this.maxLength = -1;
                this.text = "";
                this.oldText = "";
                this.fieldLabel = label;
            }
            Field.prototype.Snap = function () {
                var retObj = {};
                retObj.text = this.text;
                retObj.oldText = this.oldText;
                return retObj;
            };

            Field.prototype.Revert = function (snapPackage) {
                this.text = snapPackage.text;
                this.oldText = snapPackage.oldText;
            };

            Field.prototype.GetFieldText = function () {
                if (this.oldText == null) {
                    return null;
                } else {
                    return this.oldText;
                }
            };

            Field.prototype.GetText = function () {
                return this.text;
            };

            Field.prototype.SetText = function (text) {
                this.text = text;
            };

            Field.prototype.GetFillingString = function (promptChar) {
                if (!promptChar) {
                    return null;
                }

                var b = "";
                for (var a = 0; a < this.minLength; a++) {
                    b = b + promptChar;
                }

                return b;
            };

            Field.prototype.GetFieldStatus = function () {
                return 0;
            };

            Field.prototype.GetTextExcludeLiterals = function (start, sellength) {
                var textLength = this.text.GetLength();

                if (textLength < sellength) {
                    sellength = textLength;
                }

                var ret = this.text.Substring(start, sellength);
                ret = ret.replace(/[^\d]/g, '');

                return ret;
            };

            Field.prototype.SaveOldState = function () {
            };

            Field.prototype.RollBack = function () {
            };

            Field.prototype.PerformSpin = function (position, increment, wrap) {
                return 0;
            };

            Field.prototype.Insert = function (start, text, isLast, isSetText) {
            };

            Field.prototype.Replace = function (start, length, text) {
            };

            Field.prototype.Delete = function (start, length) {
            };

            Field.prototype.SaveUndoState = function () {
            };

            Field.prototype.Clear = function () {
                this.text = null;
            };

            Field.prototype.Undo = function () {
            };

            Field.prototype.SetTextInternal = function (text, start, isLast, validateText) {
            };

            Field.prototype.GetLength = function () {
                return this.text.GetLength() > this.minLength ? this.text.GetLength() : this.minLength;
            };
            return Field;
        })();
        input.Field = Field;

        /** @ignore */
        var PromptField = (function (_super) {
            __extends(PromptField, _super);
            function PromptField(text) {
                _super.call(this, "PromptField");
                this.text = text;
                this.minLength = this.text.GetLength();
                this.maxLength = this.text.GetLength();
            }
            PromptField.prototype.GetFillingString = function () {
                return this.text;
            };

            PromptField.prototype.SetText = function (text) {
                var retInfo = {};

                if (text === this.promptText) {
                    retInfo.existInvalid = false;
                    text = text.Substring(this.text.GetLength());
                } else {
                    retInfo.existInvalid = true;
                }

                retInfo.text = text;

                return retInfo;
            };

            PromptField.prototype.GetLength = function () {
                return this.text.GetLength();
            };
            return PromptField;
        })(Field);

        /** @ignore */
        var FilterField = (function (_super) {
            __extends(FilterField, _super);
            function FilterField(owner) {
                _super.call(this, "FilterField");
                this._minLength = 0;
                this._maxLength = 0;
                this._filter = new CharacterFilter();
                this._bitStates = null;
                this._oldBitState = null;
                this.undoText = "";
                this.undoTempText = "";
                this._undoBitState = null;
                this._trueLength = 0;
                this._bitState = null;
                this._owner = owner;
            }
            FilterField.prototype.GetPromptChar = function () {
                return this._owner.GetPromptChar();
            };

            FilterField.prototype.GetAutoConvert = function () {
                return this._owner.GetAutoConvert();
            };

            FilterField.prototype.FilterField = function (minlength, maxlength, filter, bitState) {
                if (minlength > maxlength) {
                    return false;
                }

                if (!filter) {
                    return false;
                }

                this._minLength = minlength;
                this._maxLength = maxlength;
                this._filter = filter;
                this._bitState = bitState;
                this._oldBitState = bitState;
                this._undoBitState = bitState;
                this._trueLength = 0;

                if (this._bitState != null) {
                    var length = 0;
                    while (this._bitState[length] != null) {
                        length++;
                    }

                    for (var i = length; i >= 0; i--) {
                        if (this._bitState[i] != null) {
                            if (this._bitState[i] === false) {
                                this._trueLength--;
                            }
                        } else if (this._bitState[i] == null) {
                            this._trueLength--;
                        } else {
                            break;
                        }
                    }
                }

                // Clear will init the text value with the prompt char.
                this.Clear();
                return true;
            };

            FilterField.prototype.InitialText = function (text) {
                while (text.IndexOf("@#GCD#@") != -1) {
                    text = text.replace("@#GCD#@", "\'");
                }

                while (text.IndexOf("@#GCM#@") != -1) {
                    text = text.replace("@#GCM#@", "\"");
                }

                this.text = text;
                this.oldText = text;
                this.undoText = text;
                this.undoTempText = text;
            };

            FilterField.prototype.GetFieldStatus = function () {
                if (this._trueLength >= this._minLength && this._trueLength > 0) {
                    return 2;
                }

                if (this._trueLength > 0 && this._trueLength < this._minLength) {
                    return 1;
                }

                return 0;
            };

            FilterField.prototype.GetFieldIsFull = function () {
                if (this._trueLength >= this._minLength && this._trueLength > 0) {
                    for (var i = 0; i < this._trueLength; i++) {
                        if (this._bitState[i] === false) {
                            return false;
                        }
                    }

                    return true;
                }

                return false;
            };

            FilterField.prototype.SetTextInternal = function (text, start, isLast, validateText) {
                var retObj = {};
                retObj.offset = start;
                retObj.text = text;
                retObj.existInvalid = false;
                retObj.exception = false;

                var existInvalid = false;

                if (start > this._maxLength || text === "" || text.GetLength() === 0) {
                    return retObj;
                }

                var newText = "";
                var position = 0;

                var tempBitState = [];
                var bitStartPos = start;
                for (var temp = 0; temp < start; temp++) {
                    tempBitState[temp] = this._bitState[temp];
                }
                while (position < text.GetLength()) {
                    var checkObj = this._filter.Check(text, position);
                    var result = checkObj.strValue;
                    position = checkObj.index;

                    if (result === "" && text.Substring(position, position + 1) !== this.GetPromptChar()) {
                        if (!isLast && start + newText.GetLength() >= this._minLength && start + newText.GetLength() === this._trueLength + newText.GetLength()) {
                            break;
                        }

                        existInvalid = true;
                        position++;
                        break;
                    } else {
                        if (result !== "") {
                            if (validateText && validateText !== "" && validateText.Substring(bitStartPos, bitStartPos + 1) === input.Utility.MaskValChar) {
                                newText += this.GetPromptChar();
                                tempBitState[bitStartPos] = false;
                            } else if (result === "\r" || result === "\n") {
                                newText += this.GetPromptChar();
                                tempBitState[bitStartPos] = false;
                            } else {
                                newText += result;
                                tempBitState[bitStartPos] = true;
                            }

                            bitStartPos++;
                            if (result.GetLength() === 2) {
                                tempBitState[bitStartPos] = true;
                                bitStartPos++;
                            }
                        } else {
                            newText += this.GetPromptChar();
                            position++;
                            tempBitState[bitStartPos] = false;
                            bitStartPos++;
                        }

                        if (start + newText.GetLength() === this._maxLength) {
                            break;
                        } else if (start + newText.GetLength() > this._maxLength) {
                            newText = newText.Substring(0, newText.GetLength() - 1);
                            break;
                        }
                    }
                }

                if (start + newText.GetLength() < this._minLength) {
                    text = text.Substring(position, text.GetLength() - position);
                    retObj.existInvalid = existInvalid;
                    retObj.exception = true;
                }

                var fieldText = this.text.Substring(0, start) + newText + this.text.Substring(start, this.text.GetLength());

                if (fieldText.GetLength() > this._maxLength) {
                    fieldText = fieldText.Substring(0, this._maxLength);
                }

                if (fieldText.GetLength() > start + newText.GetLength()) {
                    for (var i = 1; i <= fieldText.GetLength() - start - newText.GetLength(); i++) {
                        if (this._bitState[start + i] != null) {
                            tempBitState[bitStartPos] = this._bitState[start + i];
                            bitStartPos++;
                        }
                    }
                }

                this._bitState = new Array(bitStartPos);
                this._bitState = tempBitState;
                this._trueLength = bitStartPos;
                for (var i = bitStartPos - 1; i >= 0; i--) {
                    if (this._bitState[i] === false) {
                        this._trueLength--;
                    } else {
                        break;
                    }
                }

                if (fieldText.GetLength() < this._minLength) {
                    for (var i = 0; i < this._minLength - fieldText.GetLength(); i--) {
                        fieldText += this.GetPromptChar();
                    }
                }

                for (var i = fieldText.GetLength(); i > this._minLength; i--) {
                    if (fieldText.Substring(i - 1, i) === this.GetPromptChar() && i > this._trueLength) {
                        fieldText = fieldText.Substring(0, i - 1);
                    } else {
                        break;
                    }
                }

                this.text = fieldText;

                if (position === text.GetLength()) {
                    text = "";
                } else {
                    text = text.Substring(position, text.GetLength());
                }

                start += newText.GetLength();
                retObj.offset = start;
                retObj.text = text;
                return retObj;
            };

            FilterField.prototype.SaveOldState = function () {
                this.oldText = this.text;
                this._oldBitState = this._bitState;
            };

            FilterField.prototype.SaveUndoState = function () {
                this.undoText = this.text;
                this.undoTempText = this.text;
                this._undoBitState = this._bitState;
            };

            FilterField.prototype.GetValue = function () {
            };

            FilterField.prototype.GetText = function () {
                return this._text;
            };

            FilterField.prototype.UpdateState = function (submit) {
            };

            FilterField.prototype.RollBack = function () {
                if (this.oldText === this.text) {
                    return;
                } else {
                    var temp = this.oldText;
                    this.text = temp;
                    this._bitState = this._oldBitState;
                    this._trueLength = temp.GetLength();
                    for (var i = temp.GetLength() - 1; i >= 0; i--) {
                        if (this._bitState[i] == false) {
                            this._trueLength--;
                        } else {
                            break;
                        }
                    }
                }
            };

            FilterField.prototype.Undo = function () {
                if (this.undoTempText === this.text) {
                    return false;
                } else {
                    var temp = this.undoTempText;
                    this.undoTempText = this.text;
                    var tempBitState = this._bitState;
                    this.text = temp;
                    this._bitState = this._undoBitState;
                    this._trueLength = temp.GetLength();
                    if (this._bitState.length === 0) {
                        this._trueLength = 0;
                    } else {
                        for (var i = temp.GetLength() - 1; i >= 0; i--) {
                            if (this._bitState[i] === false) {
                                this._trueLength--;
                            } else {
                                break;
                            }
                        }
                    }
                    this._undoBitState = tempBitState;

                    return true;
                }
            };

            FilterField.prototype.Clear = function () {
                this._trueLength = 0;
                var retText = "";
                var tempBitStates = [];

                if (this._minLength > 0) {
                    for (var i = 0; i < this._minLength; i++) {
                        tempBitStates[i] = false;
                    }

                    this._bitState = new Array(this._minLength);
                    this._bitState = tempBitStates;

                    if (this.GetPromptChar() !== "") {
                        for (var i = 0; i < this._minLength; i++) {
                            retText += this.GetPromptChar();
                        }
                    } else {
                        for (var i = 0; i < this._minLength; i++) {
                            retText += " ";
                        }
                    }

                    this.text = retText;
                } else {
                    this.text = "";
                    this._bitStates = null;
                }
            };

            FilterField.prototype.Insert = function (start, text, isLast, isSetText) {
                if (!isSetText) {
                    isSetText = true;
                }

                var retObj = {};
                retObj.offset = start;
                retObj.text = text;
                retObj.existInvalid = false;
                retObj.exception = false;

                var existInvalid = false;

                if (start > this._maxLength || text === "" || text.GetLength() === 0) {
                    return retObj;
                }

                var tempBitState = [];
                var bitStartPos = start;
                for (var temp = 0; temp < start; temp++) {
                    tempBitState[temp] = this._bitState[temp];
                }

                var newText = "";
                var position = 0;
                while (position < text.GetLength()) {
                    var checkObj = this._filter.Check(text, position);
                    var result = checkObj.strValue;
                    position = checkObj.index;

                    if (result === "" && (isSetText || text.CharAt(position) !== " ")) {
                        if (!isLast && start + newText.GetLength() >= this._minLength && start + newText.GetLength() >= this._trueLength + newText.GetLength()) {
                            break;
                        }

                        existInvalid = true;
                        position++;
                        continue;
                    } else {
                        if (result === "" && !isSetText && text.CharAt(position) === " ") {
                            newText += this.GetPromptChar();
                            tempBitState[bitStartPos] = false;
                            bitStartPos++;
                            position++;
                        } else if (result === "\r" || result === "\n") {
                            newText += this.GetPromptChar();
                            tempBitState[bitStartPos] = false;
                            bitStartPos++;
                        } else {
                            newText += result;
                            tempBitState[bitStartPos] = true;
                            bitStartPos++;

                            if (result.GetLength() === 2) {
                                tempBitState[bitStartPos] = true;
                                bitStartPos++;
                            }
                        }

                        if (start + newText.GetLength() === this._maxLength) {
                            break;
                        } else if (start + newText.GetLength() > this._maxLength) {
                            newText = newText.Substring(0, newText.GetLength() - 1);
                            break;
                        }
                    }
                }

                if (newText.GetLength() === 0) {
                    text = text.Substring(position, text.GetLength() - position);
                    retObj.existInvalid = existInvalid;
                    retObj.exception = true;

                    return retObj;
                }

                var fieldText = this.text.Substring(0, start) + newText + this.text.Substring(start, this.text.GetLength());

                if (fieldText.GetLength() > this._maxLength) {
                    fieldText = fieldText.Substring(0, this._maxLength);
                }

                if (fieldText.GetLength() > start + newText.GetLength()) {
                    for (var i = 0; i < fieldText.GetLength() - start - newText.GetLength(); i++) {
                        if (this._bitState[start + i] != null) {
                            tempBitState[bitStartPos] = this._bitState[start + i];
                        } else {
                            tempBitState[bitStartPos] = false;
                        }
                        bitStartPos++;
                    }
                }

                this._bitState = new Array(bitStartPos);

                this._bitState = tempBitState;
                this._trueLength = bitStartPos;
                for (var i = bitStartPos - 1; i >= 0; i--) {
                    if (this._bitState[i] === false) {
                        this._trueLength--;
                    } else {
                        break;
                    }
                }

                if (fieldText.GetLength() < this._minLength) {
                    for (var i = 0; i < this._minLength - fieldText.GetLength(); i--) {
                        fieldText += this.GetPromptChar();
                    }
                }

                for (var i = fieldText.GetLength(); i > this._minLength; i--) {
                    if (fieldText.Substring(i - 1, i) === this.GetPromptChar() && i > this._trueLength) {
                        fieldText = fieldText.Substring(0, i - 1);
                    } else {
                        break;
                    }
                }

                this.text = fieldText;
                if (position === text.GetLength()) {
                    text = "";
                } else {
                    text = text.Substring(position, text.GetLength());
                }
                start += newText.GetLength();
                retObj.offset = start;
                retObj.text = text;

                return retObj;
            };

            FilterField.prototype.Replace = function (start, length, text, isLast) {
                var retObj = {};
                retObj.offset = start;
                retObj.text = text;
                if (length === 0) {
                    return retObj;
                }

                // DaryLuo 2013/07/09 fix bug 1014 in IM HTML 5.0.
                var charCode = text.charCodeAt(0);
                var excludeCharList = [12364, 12460, 12366, 12462, 12376, 12472];

                if (input.Utility.ArrayIndexOf(excludeCharList, charCode) !== -1 && length === 1) {
                    var checkResult = this._filter.Check(text, 0);
                    if (checkResult.strValue && checkResult.strValue.length === 2) {
                        length = 2;
                    }
                }
                start = this.Delete(start, length);
                retObj = this.Insert(start, text, isLast);

                return retObj;
            };

            FilterField.prototype.Delete = function (start, length) {
                if (length === 0 || start >= this.text.GetLength()) {
                    return start;
                }

                if (start + length > this.text.GetLength()) {
                    length = this.text.GetLength() - start;
                }

                var tempBitState = [];
                var bitStartPos = start;
                for (var temp = 0; temp < start; temp++) {
                    tempBitState[temp] = this._bitState[temp];
                }

                var fieldText = this.text.Substring(0, start) + this.text.Substring(start + length, this.text.GetLength());

                if (start + length < this.text.GetLength()) {
                    for (var i = 0; i < this.text.Substring(start + length, this.text.GetLength()).GetLength(); i++) {
                        if (this._bitState[start + length + i] != null) {
                            tempBitState[bitStartPos] = this._bitState[start + length + i];
                        } else {
                            tempBitState[bitStartPos] = false;
                        }

                        bitStartPos++;
                    }
                }

                if (bitStartPos < this._minLength) {
                    for (var i = bitStartPos; i < this._minLength; i++) {
                        tempBitState[i] = false;
                    }
                }

                this._bitState = new Array(bitStartPos);
                this._bitState = tempBitState;
                this._trueLength = bitStartPos;
                for (var i = bitStartPos - 1; i >= 0; i--) {
                    if (this._bitState[i] === false) {
                        this._trueLength--;
                    } else {
                        break;
                    }
                }

                if (fieldText.GetLength() < this._minLength) {
                    var addTime = this._minLength - fieldText.GetLength();
                    for (var i = 0; i < addTime; i++) {
                        fieldText += this.GetPromptChar();
                    }
                }

                this.text = fieldText;

                return start;
            };
            return FilterField;
        })(Field);

        /** @ignore */
        var EnumField = (function (_super) {
            __extends(EnumField, _super);
            function EnumField(owner) {
                _super.call(this, "EnumField");
                this._activeItem = -1;
                this._trueLength = 0;
                this._lastActiveItem = -1;
                this.undoText = "";
                this.undoTempText = "";
                this._undoItem = -1;
                this._minLength = 0;
                this._maxLength = 0;
                this._itemCount = 0;
                this._owner = owner;
            }
            EnumField.prototype.GetPromptChar = function () {
                return this._owner.GetPromptChar();
            };

            EnumField.prototype.GetText = function () {
                var retText = "";

                if (this._activeItem < 0) {
                    retText = input.Utility.ToString(this.GetPromptChar(), this._minLength);
                } else {
                    retText += this._items[this._activeItem];
                }

                return retText;
            };

            EnumField.prototype.GetFieldStatus = function () {
                return this._activeItem === -1 ? 0 : 2;
            };

            EnumField.prototype.GetFieldIsFull = function () {
                return this._activeItem === -1 ? false : true;
            };

            EnumField.prototype.IsOver = function () {
                return (this._activeItem !== -1);
            };

            EnumField.prototype.Init = function (items) {
                var minLength = Number.MAX_VALUE;
                var maxLength = Number.MIN_VALUE;
                for (var i = 0; i < items.length; i++) {
                    minLength = Math.min(minLength, items[i].length);
                    maxLength = Math.max(maxLength, items[i].length);
                }

                this.EnumField(minLength, maxLength, items, items.length, -1);
            };

            EnumField.prototype.EnumField = function (minlength, maxlength, items, itemCount, activeItem) {
                this._minLength = minlength;
                this._maxLength = maxlength;

                if (!items) {
                    return false;
                }

                this._itemCount = itemCount;
                this._activeItem = activeItem;
                this._lastActiveItem = activeItem;
                this._undoItem = activeItem;
                this.InitialItems(items);

                if (activeItem !== -1) {
                    this._trueLength = items[activeItem].toString().GetLength();
                } else {
                    this._trueLength = 0;
                }
                this.text = this.GetText();
            };

            EnumField.prototype.InitialItems = function (items) {
                this._items = new Array(items.length);

                for (var i = 0; i < items.length; i++) {
                    var tempText = items[i];
                    while (tempText.IndexOf("@#GCD#@") !== -1) {
                        tempText = tempText.replace("@#GCD#@", "\'");
                    }

                    while (tempText.IndexOf("@#GCM#@") !== -1) {
                        tempText = tempText.replace("@#GCM#@", "\"");
                    }

                    if (tempText) {
                        tempText = tempText.replace(/@#GCX0D#@/g, "\r").replace(/@#GCX0A#@/g, "\n");
                    }

                    this._items[i] = tempText;
                }
            };

            EnumField.prototype.InitialText = function (text) {
                while (text.IndexOf("@#GCD#@") !== -1) {
                    text = text.replace("@#GCD#@", "\'");
                }

                while (text.IndexOf("@#GCM#@") !== -1) {
                    text = text.replace("@#GCM#@", "\"");
                }

                if (text) {
                    text = text.replace(/@#GCX0D#@/g, "\r").replace(/@#GCX0A#@/g, "\n");
                }

                this.text = text;
                this.oldText = text;
                this.undoText = text;
                this.undoTempText = text;
            };

            EnumField.prototype.Insert = function (start, text, isLast) {
                var retObj = {};
                retObj.offset = start;
                retObj.text = text;
                retObj.existInvalid = false;
                retObj.exception = false;

                var old = start;
                var prefix = "";

                if (this._activeItem === -1) {
                    old = 0;
                }
                if (old !== 0) {
                    prefix = this._items[this._activeItem].toString().Substring(0, old);
                }

                var sameCharsIndex = new Array(this._itemCount);
                var textIndex = new Array(this._itemCount);
                var firstSamePos = new Array(this._itemCount);
                var invalidInfos = new Array(this._itemCount);
                for (var i = 0; i < this._itemCount; i++) {
                    sameCharsIndex[i] = old;
                    textIndex[i] = 0;
                    firstSamePos[i] = 99999;
                    invalidInfos[i] = new Array();
                }

                for (var i = 0; i < this._itemCount; i++) {
                    var item = this._items[i].toString();

                    if (prefix.GetLength() > 0 && item.Substring(0, prefix.GetLength()) !== prefix) {
                        continue;
                    }

                    while (textIndex[i] < text.GetLength()) {
                        if (sameCharsIndex[i] >= item.length) {
                            break;
                        }

                        var judgeInfo = this.JudgeIfValid(item, sameCharsIndex[i], text, textIndex[i]);

                        sameCharsIndex[i] = judgeInfo.index1;
                        textIndex[i] = judgeInfo.index2;
                        if (!judgeInfo.isValid) {
                            textIndex[i]++;
                        } else {
                            if (firstSamePos[i] === 99999) {
                                firstSamePos[i] = textIndex[i];
                            }
                        }
                    }
                }

                var itemIndex = 0;
                var sameCount = 0;
                var findOut = false;
                var maxPos = sameCharsIndex[itemIndex];
                for (var j = 0; j < this._itemCount; j++) {
                    var item = this._items[j].toString();
                    if (sameCharsIndex[j] === text.GetLength() + old && text.GetLength() === item.length) {
                        itemIndex = j;
                        maxPos = sameCharsIndex[itemIndex];
                        findOut = true;
                        break;
                    }

                    if (firstSamePos[j] === 99999) {
                        continue;
                    }

                    if (firstSamePos[itemIndex] >= firstSamePos[j]) {
                        if (firstSamePos[itemIndex] === firstSamePos[j]) {
                            var pos = sameCharsIndex[j];
                            if (maxPos < pos) {
                                itemIndex = j;
                                maxPos = pos;
                                sameCount = 1;
                            } else if (maxPos === pos)
                                sameCount++;
                        } else {
                            itemIndex = j;
                            maxPos = sameCharsIndex[itemIndex];
                            sameCount = 1;
                        }
                    }
                }
                var existInvalid;
                if (findOut) {
                    if (textIndex[itemIndex] === 0) {
                        existInvalid = true;
                        retObj.existInvalid = true;
                        return retObj;
                    }
                    text = text.Substring(textIndex[itemIndex] + 1, text.GetLength());
                    start = this._items[itemIndex].toString().GetLength();
                    existInvalid = invalidInfos[itemIndex].Count === 0 ? false : true;

                    this._activeItem = itemIndex;
                    this.text = this._items[itemIndex].toString();
                    this._trueLength = this._items[itemIndex].toString().GetLength();

                    retObj.offset = start;
                    retObj.text = text;
                    retObj.existInvalid = existInvalid;
                    return retObj;
                } else {
                    if (maxPos === old) {
                        if (isLast === false && this._activeItem !== -1 && start === this._items[this._activeItem].toString().GetLength()) {
                            text = text.Substring(textIndex[itemIndex], text.GetLength());
                            existInvalid = false;
                            retObj.offset = start;
                            retObj.text = text;
                            return retObj;
                        } else {
                            existInvalid = true;
                            retObj.exception = true;
                            retObj.existInvalid = true;
                            return retObj;
                        }
                    }

                    var source = -1;
                    for (var i = 0; i < invalidInfos[itemIndex].Count; i++) {
                        source = 0;
                    }

                    if (sameCount === 1) {
                        start = this._items[itemIndex].toString().GetLength();
                    } else {
                        start = maxPos;
                    }

                    if (source === -1) {
                        text = text.Substring(textIndex[itemIndex], text.GetLength());
                        existInvalid = false;
                    } else {
                        text = text.Substring(textIndex[itemIndex], text.GetLength());
                        existInvalid = true;
                    }

                    this._activeItem = itemIndex;
                    this.text = this._items[itemIndex].toString();
                    this._trueLength = this._items[itemIndex].toString().GetLength();
                    retObj.offset = start;
                    retObj.text = text;
                    return retObj;
                }
            };

            EnumField.prototype.Replace = function (start, length, text, isLast) {
                return this.Insert(start, text, isLast);
            };

            EnumField.prototype.Delete = function (start, length) {
                if (length === 0 || start >= this.text.GetLength()) {
                    return start;
                }
                start = 0;
                this._activeItem = -1;
                this.text = "";
                if (this._minLength > 0) {
                    for (var i = 0; i < this._minLength; i++) {
                        this.text += this.GetPromptChar();
                    }
                }
                this._trueLength = 0;

                return start;
            };

            EnumField.prototype.SaveOldState = function () {
                this._lastActiveItem = this._activeItem;
                this.oldText = this.text;
            };

            EnumField.prototype.RollBack = function () {
                if (this.oldText === this.text) {
                    return;
                } else {
                    var tempItem = this._lastActiveItem;
                    this._activeItem = tempItem;
                    if (tempItem >= 0 && tempItem < this._itemCount) {
                        this.text = this._items[tempItem].toString();
                    } else {
                        this.text = "";
                        for (var i = 0; i < this._minLength; i++) {
                            this.text += this.GetPromptChar();
                        }
                    }

                    var plength = 0;
                    for (var i = this.text.GetLength(); i > 0; i--) {
                        if (this.text.Substring(i - 1, i) === this.GetPromptChar()) {
                            plength++;
                        } else {
                            break;
                        }
                    }
                    this._trueLength = this.text.GetLength() - plength;
                }
            };

            EnumField.prototype.SaveUndoState = function () {
                this.undoText = this.text;
                this.undoTempText = this.text;
                this._undoItem = this._activeItem;
            };

            EnumField.prototype.Undo = function () {
                if (this.undoTempText === this.text) {
                    return;
                } else {
                    this.undoTempText = this.text;
                    var tempItem = this._activeItem;
                    this._activeItem = this._undoItem;
                    this._undoItem = tempItem;
                    if (this._activeItem >= 0 && this._activeItem < this._itemCount) {
                        this.text = this._items[this._activeItem].toString();
                    } else {
                        this.text = "";
                        for (var i = 0; i < this._minLength; i++) {
                            this.text += this.GetPromptChar();
                        }
                    }

                    var plength = 0;
                    for (var i = this.text.GetLength(); i > 0; i--) {
                        if (this.text.Substring(i - 1, i) === this.GetPromptChar()) {
                            plength++;
                        } else {
                            break;
                        }
                    }
                    this._trueLength = this.text.GetLength() - plength;
                }
            };

            EnumField.prototype.SetTextInternal = function (text, start, isLast, validateText) {
                var i;
                var textIndex = new Array(this._itemCount);
                var itemPoss = new Array(this._itemCount);
                var existInvalids = new Array(this._itemCount);

                for (i = 0; i < this._itemCount; i++) {
                    textIndex[i] = 0;
                    itemPoss[i] = 0;
                    existInvalids[i] = false;
                }

                for (i = 0; i < this._itemCount; i++) {
                    var item = this._items[i].toString();
                    while (textIndex[i] < text.GetLength()) {
                        var judgeInfo = this.JudgeIfValid(item, itemPoss[i], text, textIndex[i]);

                        itemPoss[i] = judgeInfo.index1;
                        textIndex[i] = judgeInfo.index2;
                        if (!judgeInfo.isValid && isLast === true) {
                            existInvalids[i] = true;
                            break;
                        }

                        if (!judgeInfo.isValid && item.GetLength() === textIndex[i]) {
                            break;
                        }

                        if (!judgeInfo.isValid && item.GetLength() > textIndex[i]) {
                            existInvalids[i] = true;
                            break;
                        }

                        if (itemPoss[i].toString().GetLength() === item.GetLength() && textIndex[i].toString().GetLength() < text.GetLength() && isLast === true) {
                            existInvalids[i] = true;
                            break;
                        }

                        if (textIndex[i].toString().GetLength() === text.GetLength() && itemPoss[i].toString().GetLength() < item.GetLength()) {
                            existInvalids[i] = true;
                            break;
                        }
                    }
                }

                var itemIndex = this._itemCount;
                for (i = 0; i < this._itemCount; i++) {
                    if (existInvalids[i] === false) {
                        if (itemIndex === this._itemCount) {
                            itemIndex = i;
                        }
                        var item = this._items[i].toString();
                        if (item.GetLength() === this._maxLength && text.GetLength() >= this._maxLength) {
                            itemIndex = i;
                            break;
                        }
                    }
                }
                var k = itemIndex;

                var retObj = {};
                retObj.existInvalid = false;
                retObj.exception = false;

                if (k >= this._itemCount) {
                    var tempPrompt = "";
                    retObj.exception = true;
                    for (i = 0; i < this._minLength; i++) {
                        tempPrompt += this.GetPromptChar();
                    }
                    if (text.Substring(0, this._minLength) === tempPrompt) {
                        text = text.Substring(this._minLength, text.GetLength());
                        retObj.offset = this._minLength;
                        retObj.text = text;
                        retObj.existInvalid = false;
                        retObj.exception = true;
                        this.Clear();
                        return retObj;
                    } else {
                        retObj.text = text;
                        this.text = tempPrompt;
                        this._activeItem = -1;
                        retObj.existInvalid = true;
                        retObj.exception = true;
                        return retObj;
                    }
                } else {
                    this._activeItem = k;
                    this.text = this._items[k].toString();
                    this._trueLength = this._items[k].toString().GetLength();
                    retObj.offset = this._trueLength;
                    retObj.text = text.Substring(this._trueLength, text.GetLength());
                    return retObj;
                }
            };

            EnumField.prototype.PerformSpin = function (position, increment, wrap) {
                var count = this._itemCount;

                if (count < increment) {
                    if (count > 1) {
                        while (count < increment) {
                            increment -= count;
                        }
                    } else {
                        increment = 1;
                    }
                } else if (count < -increment) {
                    if (count > 1) {
                        while (count < -increment) {
                            increment += count;
                        }
                    } else {
                        increment = -1;
                    }
                }

                if (increment === 0) {
                    return position;
                }

                var currentIndex;
                if (this._activeItem === -1) {
                    currentIndex = increment > 0 ? 0 : count - 1;
                } else {
                    currentIndex = this._activeItem + increment;

                    if (currentIndex < 0 || currentIndex >= count) {
                        if (!wrap) {
                            currentIndex = increment > 0 ? count - 1 : 0;
                        } else {
                            currentIndex = increment > 0 ? currentIndex - count : currentIndex + count;
                            if (increment > 0 && currentIndex < this._activeItem) {
                                if (this._activeItem < count - 1) {
                                    currentIndex = count - 1;
                                } else {
                                    currentIndex = 0;
                                }
                            } else if (increment < 0 && currentIndex > this._activeItem) {
                                if (this._activeItem > 0) {
                                    currentIndex = 0;
                                } else {
                                    currentIndex = count - 1;
                                }
                            }
                        }
                    }
                }

                var newItemLen = this._items[currentIndex].toString().GetLength();
                position = Math.min(position, newItemLen);
                this._activeItem = currentIndex;
                this.text = this._items[currentIndex].toString();
                this._trueLength = this._activeItem === -1 ? 0 : this.text.GetLength();
                return position;
            };

            EnumField.prototype.Clear = function () {
                this._activeItem = -1;
         