/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.VersionID;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;

public class JfxRuntime {
    private final String version;
    private final VersionID versionId;
    private final String path;
    private static final String RT_JAR_DIR = JfxRuntime.useExtensionJFX() ? "lib" + File.separator + "ext" : "lib";
    public static final String RT_JAR = RT_JAR_DIR + File.separator + "jfxrt.jar";

    public static boolean useExtensionJFX() {
        if (!Config.isDeployVersionAtLeast11()) {
            return false;
        }
        String string = Environment.getDeploymentHome() + File.separator + "lib" + File.separator + "ext" + File.separator + "jfxrt.jar";
        File file = new File(string);
        return file.canRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JfxRuntime runtimeForPath(String string) {
        File file = new File(string + File.separator + RT_JAR);
        URLClassLoader uRLClassLoader = null;
        if (file.canRead()) {
            try {
                Field field;
                uRLClassLoader = new URLClassLoader(new URL[]{file.toURL()}, null);
                Class<?> clazz = uRLClassLoader.loadClass("com.sun.javafx.runtime.VersionInfo");
                if (clazz != null && (field = clazz.getDeclaredField("RAW_VERSION")) != null) {
                    field.setAccessible(true);
                    JfxRuntime jfxRuntime = new JfxRuntime((String)field.get(null), string);
                    return jfxRuntime;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                if (Config.isJavaVersionAtLeast17() && uRLClassLoader != null) {
                    try {
                        uRLClassLoader.close();
                    }
                    catch (IOException iOException) {
                        Trace.ignored(iOException);
                    }
                }
            }
        }
        Trace.println("No valid JFX runtime at [" + string + "]", TraceLevel.BASIC);
        return null;
    }

    public JfxRuntime(String string, String string2) {
        this.version = string;
        this.path = string2.endsWith(File.separator) ? string2 : string2 + File.separator;
        this.versionId = new VersionID(string);
    }

    public boolean isValid() {
        File file = new File(this.path + RT_JAR);
        return file.canRead();
    }

    public String toString() {
        return "JavaFX " + this.version + " found at " + this.path;
    }

    public URL[] getURLs() {
        URL[] uRLArray = new URL[1];
        File file = this.getRuntimeJar();
        try {
            uRLArray[0] = file.getCanonicalFile().toURI().toURL();
        }
        catch (IOException iOException) {
            Trace.printException(iOException);
            return null;
        }
        return uRLArray;
    }

    private File getRuntimeJar() {
        return new File(this.path + RT_JAR);
    }

    public File getHome() {
        return new File(this.path);
    }

    public File getSecurityPolicy() {
        File file = new File(this.path, "lib/security/javafx.policy");
        if (file.canRead()) {
            return file;
        }
        return null;
    }

    public VersionID getProductVersion() {
        return this.versionId;
    }
}

