/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.Producer;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;
import java.util.TimeZone;
import oracle.jrockit.jfr.DCmdCheck;
import oracle.jrockit.jfr.DCmdDump;
import oracle.jrockit.jfr.DCmdException;
import oracle.jrockit.jfr.DCmdStart;
import oracle.jrockit.jfr.DCmdStop;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.JFRImpl;
import oracle.jrockit.jfr.JFRStats;
import oracle.jrockit.jfr.NativeJFRStats;
import oracle.jrockit.jfr.NativeProducerDescriptor;
import oracle.jrockit.jfr.Options;
import oracle.jrockit.jfr.Process;
import oracle.jrockit.jfr.ProducerDescriptor;
import oracle.jrockit.jfr.RepositoryChunk;
import oracle.jrockit.jfr.StringConstantPool;
import oracle.jrockit.jfr.Timing;
import oracle.jrockit.jfr.jdkevents.IoTracer;
import oracle.jrockit.jfr.jdkevents.ThrowableTracer;
import sun.misc.IoTrace;

@Deprecated
public final class VMJFR
extends JFRImpl {
    private static final int addressSize;
    private final NativeProducerDescriptor vm;
    private final NativeJFRStats jfrStats;
    static final int PREV = 0;
    static final int NEXT;
    static final int START;
    static final int TOP;
    static final int POS;
    static final int END;
    static final int USED;
    static final int RESERVED;
    static final int DATA;
    private final ThreadLocal<ThreadBuffer> bufferLocal = new ThreadLocal<ThreadBuffer>(){

        @Override
        protected ThreadBuffer initialValue() {
            return new ThreadBuffer(VMJFR.this.buffer());
        }
    };

    VMJFR() throws Exception {
        super(VMJFR.options());
        assert (VMJFR.isEnabled());
        ByteBuffer byteBuffer = this.init(Locale.getDefault().toString(), TimeZone.getDefault().getRawOffset(), this.getRepository().getPath().getPath());
        this.jfrStats = new NativeJFRStats(byteBuffer.order(ByteOrder.nativeOrder()));
        this.vm = new NativeProducerDescriptor(1, this);
        this.addProducer(this.vm, this.vm.controls());
        this.logger.trace("VMJFR created.");
    }

    private static native boolean isEnabled();

    private static native Options options();

    private native ByteBuffer init(String var1, int var2, String var3);

    @Override
    public boolean isNativeImplementation() {
        return true;
    }

    @Override
    public ByteBuffer getThreadBuffer(int n) {
        return this.bufferLocal.get().ensure(n);
    }

    @Override
    public void releaseThreadBuffer(ByteBuffer byteBuffer, boolean bl) {
        this.bufferLocal.get().finish(byteBuffer, bl);
    }

    private native void addConstPool(ByteBuffer var1, int var2, boolean var3);

    private native void removeConstPool(int var1);

    private native boolean storeConstPool(int var1);

    @Override
    protected void addConstpool(StringConstantPool stringConstantPool) {
        this.addConstPool(stringConstantPool.getConstantData(), stringConstantPool.getConstantIndex(), stringConstantPool.emptyOnRotation());
    }

    @Override
    protected void removeConstpool(StringConstantPool stringConstantPool) {
        this.removeConstPool(stringConstantPool.getConstantIndex());
    }

    @Override
    protected boolean storeConstpool(StringConstantPool stringConstantPool) {
        return this.storeConstPool(stringConstantPool.getConstantIndex());
    }

    @Override
    public long classID(Class<?> clazz) {
        if (clazz == null) {
            return 0L;
        }
        return this.classID0(clazz);
    }

    private native long classID0(Class<?> var1);

    @Override
    public long counterTime() {
        return Timing.counterTime();
    }

    @Override
    public long nanoToCounter(long l) {
        return Timing.nanoToCounter(l);
    }

    @Override
    public native long stackTraceID(int var1);

    @Override
    public native int threadID();

    @Override
    public int getpid() {
        return Process.current.pid();
    }

    @Override
    public JFRStats getJFRStats() {
        return this.jfrStats;
    }

    @Override
    protected native void rotate();

    @Override
    protected native void shutdown();

    @Override
    protected native void start(boolean var1);

    @Override
    protected native void stop();

    private native ByteBuffer buffer();

    private native void flush();

    private native void write(byte[] var1, int var2, int var3);

    private native void add(int var1, byte[] var2, int var3, int var4);

    private native void remove(int var1);

    native void setThreshold(int var1, long var2);

    native void setPeriod(int var1, long var2);

    native long getPeriod(int var1);

    native int descriptors(int var1, ByteBuffer[] var2);

    @Override
    protected void add(ProducerDescriptor producerDescriptor) {
        if (producerDescriptor == this.vm) {
            return;
        }
        ByteBuffer byteBuffer = producerDescriptor.getBinaryDescriptor();
        this.add(producerDescriptor.getId(), byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
    }

    @Override
    protected void remove(ProducerDescriptor producerDescriptor) {
        if (producerDescriptor == this.vm) {
            return;
        }
        this.remove(producerDescriptor.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishChunk(String string, long l, long l2, boolean bl) {
        RepositoryChunk repositoryChunk = new RepositoryChunk(this.logger, new File(string));
        try {
            repositoryChunk.finish(l, l2);
            this.addChunk(repositoryChunk);
        }
        catch (Exception exception) {
            this.logger.warn("VMJFR.finishChunk ignored an exception", exception);
        }
        finally {
            repositoryChunk.release();
            repositoryChunk = null;
            this.chunkDone();
        }
    }

    private String dumpRecording(String string, long l, String string2, boolean bl) throws DCmdException {
        DCmdDump dCmdDump = new DCmdDump(this);
        dCmdDump.execute(string, l, string2, bl);
        return dCmdDump.getResult();
    }

    private String stopRecording(String string, long l, boolean bl, String string2, boolean bl2) throws DCmdException {
        DCmdStop dCmdStop = new DCmdStop(this);
        dCmdStop.execute(string, l, bl, string2, bl2);
        return dCmdStop.getResult();
    }

    private String startRecording(String string, String[] stringArray, boolean bl, long l, long l2, String string2, boolean bl2, long l3, long l4) throws DCmdException {
        DCmdStart dCmdStart = new DCmdStart(this);
        dCmdStart.execute(string, stringArray, bl, l, l2, string2, bl2, l3, l4);
        return dCmdStart.getResult();
    }

    private String checkRecording(String string, long l, boolean bl) throws DCmdException {
        DCmdCheck dCmdCheck = new DCmdCheck(this);
        dCmdCheck.execute(string, l, bl);
        return dCmdCheck.getResult();
    }

    static JFR create() throws Exception {
        if (VMJFR.isEnabled()) {
            return new VMJFR();
        }
        return null;
    }

    private static native boolean redefineClass0(Class<?> var0, byte[] var1);

    static void instrument(JFR jFR, Producer producer) throws Exception {
        byte[] byArray = ThrowableTracer.generateThrowableAsm();
        byte[] byArray2 = ThrowableTracer.generateErrorAsm();
        ThrowableTracer.enable(jFR, producer);
        if (!VMJFR.redefineClass0(Throwable.class, byArray)) {
            throw new Exception("Could not instrument Throwable!");
        }
        if (!VMJFR.redefineClass0(Error.class, byArray2)) {
            throw new Exception("Could not instrument Error!");
        }
        byte[] byArray3 = IoTracer.generateClass();
        if (!VMJFR.redefineClass0(IoTrace.class, byArray3)) {
            throw new Exception("Could not instrument IOTrace!");
        }
        IoTracer.enable(jFR, producer);
    }

    static {
        System.loadLibrary("jfr");
        addressSize = Integer.parseInt(System.getProperty("sun.arch.data.model")) / 8;
        NEXT = 1 * addressSize;
        START = 2 * addressSize;
        TOP = 3 * addressSize;
        POS = 4 * addressSize;
        END = 5 * addressSize;
        USED = 6 * addressSize;
        RESERVED = USED + 4;
        DATA = RESERVED + 4;
    }

    private final class ThreadBuffer {
        private final ByteBuffer base;
        private final ByteBuffer buffer;

        public ThreadBuffer(ByteBuffer byteBuffer) {
            this.base = byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer.position(DATA);
            this.buffer = byteBuffer.slice();
        }

        public void acquire() {
            this.base.put(USED, (byte)1);
        }

        public void release() {
            this.base.put(USED, (byte)0);
        }

        public void finish(ByteBuffer byteBuffer, boolean bl) {
            if (byteBuffer != this.buffer && bl) {
                byteBuffer.flip();
                VMJFR.this.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
                return;
            }
            if (bl) {
                int n = this.buffer.position();
                if (addressSize == 8) {
                    long l = this.base.getLong(START);
                    this.base.putLong(POS, l + (long)n);
                }
                if (addressSize == 4) {
                    int n2 = this.base.getInt(START);
                    this.base.putInt(POS, n2 + n);
                }
            }
            this.release();
        }

        public ByteBuffer ensure(int n) {
            int n2;
            assert (n != 0);
            if (this.buffer.capacity() < n) {
                return ByteBuffer.allocate(n + 512);
            }
            while (true) {
                this.acquire();
                if (addressSize == 8) {
                    long l;
                    long l2 = this.base.getLong(END);
                    if (l2 - (l = this.base.getLong(POS)) < (long)n) {
                        this.release();
                        VMJFR.this.flush();
                        continue;
                    }
                    int n3 = (int)(l - this.base.getLong(START));
                    this.buffer.position(n3);
                    return this.buffer;
                }
                if (addressSize != 4) continue;
                int n4 = this.base.getInt(END);
                if (n4 - (n2 = this.base.getInt(POS)) >= n) break;
                this.release();
                VMJFR.this.flush();
            }
            int n5 = n2 - this.base.getInt(START);
            this.buffer.position(n5);
            return this.buffer;
        }
    }
}

