/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import sun.misc.InnocuousThread;
import sun.security.action.GetPropertyAction;

public class ThreadPool {
    private static final String DEFAULT_THREAD_POOL_THREAD_FACTORY = "java.nio.channels.DefaultThreadPool.threadFactory";
    private static final String DEFAULT_THREAD_POOL_INITIAL_SIZE = "java.nio.channels.DefaultThreadPool.initialSize";
    private final ExecutorService executor;
    private final boolean isFixed;
    private final int poolSize;

    private ThreadPool(ExecutorService executorService, boolean bl, int n) {
        this.executor = executorService;
        this.isFixed = bl;
        this.poolSize = n;
    }

    ExecutorService executor() {
        return this.executor;
    }

    boolean isFixedThreadPool() {
        return this.isFixed;
    }

    int poolSize() {
        return this.poolSize;
    }

    static ThreadFactory defaultThreadFactory() {
        if (System.getSecurityManager() == null) {
            return new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setDaemon(true);
                    return thread;
                }
            };
        }
        return new ThreadFactory(){

            @Override
            public Thread newThread(final Runnable runnable) {
                return (Thread)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        InnocuousThread innocuousThread = new InnocuousThread(runnable);
                        innocuousThread.setDaemon(true);
                        return innocuousThread;
                    }
                });
            }
        };
    }

    static ThreadPool getDefault() {
        return DefaultThreadPoolHolder.defaultThreadPool;
    }

    static ThreadPool createDefault() {
        ThreadFactory threadFactory;
        int n = ThreadPool.getDefaultThreadPoolInitialSize();
        if (n < 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        if ((threadFactory = ThreadPool.getDefaultThreadPoolThreadFactory()) == null) {
            threadFactory = ThreadPool.defaultThreadFactory();
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        return new ThreadPool(threadPoolExecutor, false, n);
    }

    static ThreadPool create(int n, ThreadFactory threadFactory) {
        if (n <= 0) {
            throw new IllegalArgumentException("'nThreads' must be > 0");
        }
        ExecutorService executorService = Executors.newFixedThreadPool(n, threadFactory);
        return new ThreadPool(executorService, true, n);
    }

    public static ThreadPool wrap(ExecutorService executorService, int n) {
        if (executorService == null) {
            throw new NullPointerException("'executor' is null");
        }
        if (executorService instanceof ThreadPoolExecutor) {
            int n2 = ((ThreadPoolExecutor)executorService).getMaximumPoolSize();
            if (n2 == Integer.MAX_VALUE) {
                n = n < 0 ? Runtime.getRuntime().availableProcessors() : 0;
            }
        } else if (n < 0) {
            n = 0;
        }
        return new ThreadPool(executorService, false, n);
    }

    private static int getDefaultThreadPoolInitialSize() {
        String string = AccessController.doPrivileged(new GetPropertyAction(DEFAULT_THREAD_POOL_INITIAL_SIZE));
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Error("Value of property 'java.nio.channels.DefaultThreadPool.initialSize' is invalid: " + numberFormatException);
            }
        }
        return -1;
    }

    private static ThreadFactory getDefaultThreadPoolThreadFactory() {
        String string = AccessController.doPrivileged(new GetPropertyAction(DEFAULT_THREAD_POOL_THREAD_FACTORY));
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string, true, ClassLoader.getSystemClassLoader());
                return (ThreadFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Error(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new Error(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error(illegalAccessException);
            }
        }
        return null;
    }

    private static class DefaultThreadPoolHolder {
        static final ThreadPool defaultThreadPool = ThreadPool.createDefault();

        private DefaultThreadPoolHolder() {
        }
    }
}

