/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.sw.sse;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.HeapImage;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.AccessHelper;
import com.sun.scenario.effect.impl.state.LinearConvolveKernel;
import com.sun.scenario.effect.impl.state.LinearConvolvePeer;
import com.sun.scenario.effect.impl.sw.sse.SSEEffectPeer;
import java.nio.FloatBuffer;

public class SSELinearConvolvePeer
extends SSEEffectPeer
implements LinearConvolvePeer {
    public SSELinearConvolvePeer(FilterContext filterContext, Renderer renderer, String string) {
        super(filterContext, renderer, string);
    }

    @Override
    protected final Effect getEffect() {
        return super.getEffect();
    }

    protected LinearConvolveKernel getKernel() {
        return (LinearConvolveKernel)AccessHelper.getState(this.getEffect());
    }

    @Override
    public int getPow2ScaleX(LinearConvolveKernel linearConvolveKernel) {
        return linearConvolveKernel.getPow2ScaleX();
    }

    @Override
    public int getPow2ScaleY(LinearConvolveKernel linearConvolveKernel) {
        return linearConvolveKernel.getPow2ScaleY();
    }

    @Override
    public Rectangle getResultBounds(BaseTransform baseTransform, Rectangle rectangle, ImageData ... imageDataArray) {
        return this.getKernel().getScaledResultBounds(imageDataArray[0].getTransformedBounds(rectangle), this.getPass());
    }

    private int getCount() {
        return this.getKernel().getScaledKernelSize(this.getPass());
    }

    private float[] getOffset() {
        return this.getKernel().getVector(this.getInputNativeBounds(0), this.getInputTransform(0), this.getPass());
    }

    private FloatBuffer getWeights() {
        return this.getKernel().getWeights(this.getPass());
    }

    @Override
    public ImageData filter(Effect effect, BaseTransform baseTransform, Rectangle rectangle, ImageData ... imageDataArray) {
        this.setEffect(effect);
        Rectangle rectangle2 = this.getResultBounds(baseTransform, null, imageDataArray);
        Rectangle rectangle3 = new Rectangle(rectangle2);
        rectangle3.intersectWith(rectangle);
        this.setDestBounds(rectangle3);
        int n = rectangle3.width;
        int n2 = rectangle3.height;
        HeapImage heapImage = (HeapImage)imageDataArray[0].getUntransformedImage();
        int n3 = heapImage.getPhysicalWidth();
        int n4 = heapImage.getPhysicalHeight();
        int n5 = heapImage.getScanlineStride();
        int[] nArray = heapImage.getPixelArray();
        Rectangle rectangle4 = imageDataArray[0].getUntransformedBounds();
        BaseTransform baseTransform2 = imageDataArray[0].getTransform();
        Rectangle rectangle5 = new Rectangle(0, 0, n3, n4);
        this.setInputBounds(0, rectangle4);
        this.setInputTransform(0, baseTransform2);
        this.setInputNativeBounds(0, rectangle5);
        HeapImage heapImage2 = (HeapImage)this.getRenderer().getCompatibleImage(n, n2);
        this.setDestNativeBounds(heapImage2.getPhysicalWidth(), heapImage2.getPhysicalHeight());
        int n6 = heapImage2.getScanlineStride();
        int[] nArray2 = heapImage2.getPixelArray();
        int n7 = this.getCount();
        FloatBuffer floatBuffer = this.getWeights();
        LinearConvolveKernel.PassType passType = this.getKernel().getPassType(this.getPass());
        if (!baseTransform2.isIdentity() || !rectangle3.contains(rectangle2.x, rectangle2.y)) {
            passType = LinearConvolveKernel.PassType.GENERAL_VECTOR;
        }
        if (passType == LinearConvolveKernel.PassType.HORIZONTAL_CENTERED) {
            float[] fArray = new float[n7 * 2];
            floatBuffer.get(fArray, 0, n7);
            floatBuffer.rewind();
            floatBuffer.get(fArray, n7, n7);
            this.filterHV(nArray2, n, n2, 1, n6, nArray, n3, n4, 1, n5, fArray);
        } else if (passType == LinearConvolveKernel.PassType.VERTICAL_CENTERED) {
            float[] fArray = new float[n7 * 2];
            floatBuffer.get(fArray, 0, n7);
            floatBuffer.rewind();
            floatBuffer.get(fArray, n7, n7);
            this.filterHV(nArray2, n2, n, n6, 1, nArray, n4, n3, n5, 1, fArray);
        } else {
            float f;
            float f2;
            float f3;
            float f4;
            float[] fArray = new float[n7];
            floatBuffer.get(fArray, 0, n7);
            float[] fArray2 = new float[8];
            int n8 = this.getTextureCoordinates(0, fArray2, rectangle4.x, rectangle4.y, rectangle5.width, rectangle5.height, rectangle3, baseTransform2);
            float f5 = fArray2[0] * (float)n3;
            float f6 = fArray2[1] * (float)n4;
            if (n8 < 8) {
                f4 = (fArray2[2] - fArray2[0]) * (float)n3 / (float)rectangle3.width;
                f3 = 0.0f;
                f2 = 0.0f;
                f = (fArray2[3] - fArray2[1]) * (float)n4 / (float)rectangle3.height;
            } else {
                f4 = (fArray2[4] - fArray2[0]) * (float)n3 / (float)rectangle3.width;
                f3 = (fArray2[5] - fArray2[1]) * (float)n4 / (float)rectangle3.height;
                f2 = (fArray2[6] - fArray2[0]) * (float)n3 / (float)rectangle3.width;
                f = (fArray2[7] - fArray2[1]) * (float)n4 / (float)rectangle3.height;
            }
            float[] fArray3 = this.getOffset();
            float f7 = fArray3[0] * (float)n3;
            float f8 = fArray3[1] * (float)n4;
            float f9 = fArray3[2] * (float)n3;
            float f10 = fArray3[3] * (float)n4;
            this.filterVector(nArray2, n, n2, n6, nArray, n3, n4, n5, fArray, n7, f5, f6, f9, f10, f7, f8, f4, f3, f2, f);
        }
        return new ImageData(this.getFilterContext(), heapImage2, rectangle3);
    }

    native void filterVector(int[] var1, int var2, int var3, int var4, int[] var5, int var6, int var7, int var8, float[] var9, int var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, float var19, float var20);

    native void filterHV(int[] var1, int var2, int var3, int var4, int var5, int[] var6, int var7, int var8, int var9, int var10, float[] var11);
}

