/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl.platform.gstreamer;

import com.sun.media.jfxmedia.Media;
import com.sun.media.jfxmedia.MediaError;
import com.sun.media.jfxmedia.MediaPlayer;
import com.sun.media.jfxmedia.events.PlayerStateEvent;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmediaimpl.HostUtils;
import com.sun.media.jfxmediaimpl.MediaUtils;
import com.sun.media.jfxmediaimpl.platform.Platform;
import com.sun.media.jfxmediaimpl.platform.gstreamer.GSTMedia;
import com.sun.media.jfxmediaimpl.platform.gstreamer.GSTMediaPlayer;

public final class GSTPlatform
extends Platform {
    private static final String[] CONTENT_TYPES = new String[]{"audio/x-aiff", "audio/mp3", "audio/mpeg", "audio/x-wav", "video/x-javafx", "video/x-flv", "video/x-fxm", "video/mp4", "audio/x-m4a", "video/x-m4v"};
    private static final String[] NON_OSX_CONTENT_TYPES = new String[]{"application/vnd.apple.mpegurl", "audio/mpegurl"};
    private static GSTPlatform globalInstance = null;
    private static final String[] contentTypes;

    public boolean loadPlatform() {
        MediaError mediaError;
        try {
            mediaError = MediaError.getFromCode(GSTPlatform.gstInitPlatform());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            mediaError = MediaError.ERROR_MANAGER_ENGINEINIT_FAIL;
        }
        if (mediaError != MediaError.ERROR_NONE) {
            MediaUtils.nativeError(GSTPlatform.class, mediaError);
        }
        return true;
    }

    public static synchronized Platform getPlatformInstance() {
        if (null == globalInstance) {
            globalInstance = new GSTPlatform();
        }
        return globalInstance;
    }

    private GSTPlatform() {
    }

    public String[] getSupportedContentTypes() {
        return (String[])contentTypes.clone();
    }

    public Media createMedia(Locator locator) {
        return new GSTMedia(locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object prerollMediaPlayer(Locator locator) {
        String string;
        GSTMediaPlayer gSTMediaPlayer = new GSTMediaPlayer(locator);
        if (gSTMediaPlayer != null && HostUtils.isMacOSX() && ("video/mp4".equals(string = locator.getContentType()) || "video/x-m4v".equals(string))) {
            long l = locator.getURI().getScheme().equals("http") ? 60000L : 5000L;
            long l2 = 50L;
            long l3 = 0L;
            Object object = new Object();
            PlayerStateEvent.PlayerState playerState = gSTMediaPlayer.getState();
            while (l3 < l && (playerState == PlayerStateEvent.PlayerState.UNKNOWN || playerState == PlayerStateEvent.PlayerState.STALLED)) {
                try {
                    Object object2 = object;
                    synchronized (object2) {
                        object.wait(50L);
                        l3 += 50L;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                playerState = gSTMediaPlayer.getState();
            }
            if (gSTMediaPlayer.getState() != PlayerStateEvent.PlayerState.READY) {
                gSTMediaPlayer = null;
            }
        }
        return gSTMediaPlayer;
    }

    public MediaPlayer createMediaPlayer(Locator locator, Object object) {
        if (object == null) {
            throw new NullPointerException("null player!");
        }
        if (!(object instanceof GSTMediaPlayer)) {
            throw new IllegalArgumentException("!(cookie instanceof GSTMediaPlayer)");
        }
        return (MediaPlayer)object;
    }

    private static native int gstInitPlatform();

    static {
        if (!HostUtils.isMacOSX()) {
            contentTypes = new String[CONTENT_TYPES.length + NON_OSX_CONTENT_TYPES.length];
            System.arraycopy(CONTENT_TYPES, 0, contentTypes, 0, CONTENT_TYPES.length);
            System.arraycopy(NON_OSX_CONTENT_TYPES, 0, contentTypes, CONTENT_TYPES.length, NON_OSX_CONTENT_TYPES.length);
        } else {
            contentTypes = CONTENT_TYPES;
        }
    }
}

