/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.village;

import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.core.ModVillagers;
import com.github.alexthe666.iceandfire.entity.EntitySnowVillager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class SnowVillagePieces {
    public static void registerVillagePieces() {
        MapGenStructureIO.func_143031_a(House1.class, (String)"ViBH");
        MapGenStructureIO.func_143031_a(Torch.class, (String)"ViL");
        MapGenStructureIO.func_143031_a(Well.class, (String)"ViW");
    }

    public static List<PieceWeight> getStructureVillageWeightedPieceList(Random random, int size) {
        ArrayList list = Lists.newArrayList();
        list.add(new PieceWeight(TorchNew.class, 75, MathHelper.func_76136_a((Random)random, (int)(5 + size), (int)(6 + size))));
        list.add(new PieceWeight(WoodHut.class, 65, MathHelper.func_76136_a((Random)random, (int)(3 + size), (int)(5 + size))));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (((PieceWeight)iterator.next()).villagePiecesLimit != 0) continue;
            iterator.remove();
        }
        return list;
    }

    private static int updatePieceWeight(List<PieceWeight> p_75079_0_) {
        boolean flag = false;
        int i = 0;
        for (PieceWeight SnowVillagePieces$pieceweight : p_75079_0_) {
            if (SnowVillagePieces$pieceweight.villagePiecesLimit > 0 && SnowVillagePieces$pieceweight.villagePiecesSpawned < SnowVillagePieces$pieceweight.villagePiecesLimit) {
                flag = true;
            }
            i += SnowVillagePieces$pieceweight.villagePieceWeight;
        }
        return flag ? i : -1;
    }

    private static Village findAndCreateComponentFactory(Start start, PieceWeight weight, List<StructureComponent> structureComponents, Random rand, int structureMinX, int structureMinY, int structureMinZ, EnumFacing facing, int componentType) {
        Class<? extends Village> oclass = weight.villagePieceClass;
        StructureBoundingBox structureboundingbox = Torch.findPieceBox(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing);
        Village village = rand.nextBoolean() ? WoodHut.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType) : TorchNew.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        return village;
    }

    private static Village generateComponent(Start start, List<StructureComponent> structureComponents, Random rand, int structureMinX, int structureMinY, int structureMinZ, EnumFacing facing, int componentType) {
        int i = SnowVillagePieces.updatePieceWeight(start.structureVillageWeightedPieceList);
        if (i <= 0) {
            return null;
        }
        int j = 0;
        block0: while (j < 5) {
            ++j;
            int k = rand.nextInt(i);
            for (PieceWeight SnowVillagePieces$pieceweight : start.structureVillageWeightedPieceList) {
                if ((k -= SnowVillagePieces$pieceweight.villagePieceWeight) >= 0) continue;
                if (!SnowVillagePieces$pieceweight.canSpawnMoreVillagePiecesOfType(componentType) || SnowVillagePieces$pieceweight == start.structVillagePieceWeight && start.structureVillageWeightedPieceList.size() > 1) continue block0;
                Village SnowVillagePieces$village = SnowVillagePieces.findAndCreateComponentFactory(start, SnowVillagePieces$pieceweight, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
                if (SnowVillagePieces$village == null) continue;
                ++SnowVillagePieces$pieceweight.villagePiecesSpawned;
                start.structVillagePieceWeight = SnowVillagePieces$pieceweight;
                if (!SnowVillagePieces$pieceweight.canSpawnMoreVillagePieces()) {
                    start.structureVillageWeightedPieceList.remove(SnowVillagePieces$pieceweight);
                }
                return SnowVillagePieces$village;
            }
        }
        StructureBoundingBox structureboundingbox = Torch.findPieceBox(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing);
        if (structureboundingbox != null) {
            return new Torch(start, componentType, rand, structureboundingbox, facing);
        }
        return null;
    }

    private static StructureComponent generateAndAddComponent(Start start, List<StructureComponent> structureComponents, Random rand, int structureMinX, int structureMinY, int structureMinZ, EnumFacing facing, int componentType) {
        if (componentType > 50) {
            return null;
        }
        if (Math.abs(structureMinX - start.func_74874_b().field_78897_a) <= 112 && Math.abs(structureMinZ - start.func_74874_b().field_78896_c) <= 112) {
            Village structurecomponent = SnowVillagePieces.generateComponent(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType + 1);
            if (structurecomponent != null) {
                structureComponents.add(structurecomponent);
                start.pendingHouses.add(structurecomponent);
                return structurecomponent;
            }
            return null;
        }
        return null;
    }

    private static StructureComponent generateAndAddRoadPiece(Start start, List<StructureComponent> p_176069_1_, Random rand, int p_176069_3_, int p_176069_4_, int p_176069_5_, EnumFacing facing, int p_176069_7_) {
        if (p_176069_7_ > 3 + start.terrainType) {
            return null;
        }
        if (Math.abs(p_176069_3_ - start.func_74874_b().field_78897_a) <= 112 && Math.abs(p_176069_5_ - start.func_74874_b().field_78896_c) <= 112) {
            StructureBoundingBox structureboundingbox = Path.findPieceBox(start, p_176069_1_, rand, p_176069_3_, p_176069_4_, p_176069_5_, facing);
            if (structureboundingbox != null && structureboundingbox.field_78895_b > 10) {
                Path structurecomponent = new Path(start, p_176069_7_, rand, structureboundingbox, facing);
                p_176069_1_.add(structurecomponent);
                start.pendingRoads.add(structurecomponent);
                return structurecomponent;
            }
            return null;
        }
        return null;
    }

    public static class WoodHut
    extends Village {
        private boolean isTallHouse;
        private int tablePosition;

        public WoodHut() {
        }

        public WoodHut(Start start, int type, Random rand, StructureBoundingBox structurebb, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = structurebb;
            this.isTallHouse = rand.nextBoolean();
            this.tablePosition = rand.nextInt(3);
        }

        public static WoodHut createPiece(Start start, List<StructureComponent> p_175853_1_, Random rand, int p_175853_3_, int p_175853_4_, int p_175853_5_, EnumFacing facing, int p_175853_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175853_3_, (int)p_175853_4_, (int)p_175853_5_, (int)0, (int)0, (int)0, (int)4, (int)6, (int)5, (EnumFacing)facing);
            return WoodHut.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175853_1_, (StructureBoundingBox)structureboundingbox) == null ? new WoodHut(start, p_175853_7_, rand, structureboundingbox, facing) : null;
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("T", this.tablePosition);
            tagCompound.func_74757_a("C", this.isTallHouse);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound tagCompound) {
            super.readStructureFromNBT(tagCompound);
            this.tablePosition = tagCompound.func_74762_e("T");
            this.isTallHouse = tagCompound.func_74767_n("C");
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(ModBlocks.frozenCobblestone.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_150433_aE.func_176223_P());
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.field_150403_cj.func_176223_P());
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 3, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 3, 0, 4, iblockstate, iblockstate, false);
            if (this.isTallHouse) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 2, 4, 3, iblockstate3, iblockstate3, false);
            } else {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 1, 2, 5, 3, iblockstate3, iblockstate3, false);
            }
            this.func_175811_a(worldIn, iblockstate3, 1, 4, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 2, 4, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 1, 4, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 2, 4, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 0, 4, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 0, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 0, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 3, 4, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 3, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 3, 4, 3, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 3, 0, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 0, 3, 3, 0, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 4, 0, 3, 4, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 4, 3, 3, 4, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 3, 3, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 1, 3, 3, 3, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 0, 2, 3, 0, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 4, 2, 3, 4, iblockstate1, iblockstate1, false);
            this.func_175811_a(worldIn, Blocks.field_150397_co.func_176223_P().func_177226_a((IProperty)BlockStainedGlassPane.field_176245_a, (Comparable)EnumDyeColor.LIGHT_BLUE), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150397_co.func_176223_P().func_177226_a((IProperty)BlockStainedGlassPane.field_176245_a, (Comparable)EnumDyeColor.LIGHT_BLUE), 3, 2, 2, structureBoundingBoxIn);
            if (this.tablePosition > 0) {
                this.func_175811_a(worldIn, iblockstate4, this.tablePosition, 1, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150452_aw.func_176223_P(), this.tablePosition, 2, 3, structureBoundingBoxIn);
            }
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 2, 0, structureBoundingBoxIn);
            this.func_189927_a(worldIn, structureBoundingBoxIn, randomIn, 1, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a(worldIn, 1, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 1, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, iblockstate2, 1, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a(worldIn, 1, -1, -1, structureBoundingBoxIn).func_177230_c() == ModBlocks.frozenGrassPath) {
                    this.func_175811_a(worldIn, Blocks.field_150349_c.func_176223_P(), 1, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.func_74871_b(worldIn, j, 6, i, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, j, -1, i, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 1, 1, 2, 1);
            return true;
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.readStructureFromNBT(tagCompound);
        }
    }

    public static class TorchNew
    extends Village {
        public TorchNew() {
        }

        public TorchNew(Start start, int p_i45568_2_, Random rand, StructureBoundingBox p_i45568_4_, EnumFacing facing) {
            super(start, p_i45568_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45568_4_;
        }

        public static TorchNew createPiece(Start start, List<StructureComponent> p_175853_1_, Random rand, int p_175853_3_, int p_175853_4_, int p_175853_5_, EnumFacing facing, int p_175853_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175853_3_, (int)p_175853_4_, (int)p_175853_5_, (int)0, (int)0, (int)0, (int)4, (int)6, (int)5, (EnumFacing)facing);
            return TorchNew.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175853_1_, (StructureBoundingBox)structureboundingbox) == null ? new TorchNew(start, p_175853_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 5, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_180408_aP.func_176223_P());
            this.func_175811_a(worldIn, iblockstate, 1, 0, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 1, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150325_L.func_176203_a(EnumDyeColor.BLACK.func_176767_b()), 1, 3, 0, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.EAST, 2, 3, 0, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.NORTH, 1, 3, 1, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.WEST, 0, 3, 0, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.SOUTH, 1, 3, -1, structureBoundingBoxIn);
            return true;
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.readStructureFromNBT(tagCompound);
        }
    }

    public static class Well
    extends Village {
        public Well() {
        }

        public Well(Start start, int type, Random rand, int x, int z) {
            super(start, type);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
            this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new StructureBoundingBox(x, 64, z, x + 6 - 1, 78, z + 6 - 1) : new StructureBoundingBox(x, 64, z, x + 6 - 1, 78, z + 6 - 1);
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            SnowVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, this.func_74877_c());
            SnowVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, this.func_74877_c());
            SnowVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            SnowVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 3, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_150403_cj.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_150478_aa.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 4, 12, 4, iblockstate, Blocks.field_150358_i.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150358_i.func_176223_P(), 2, 12, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150358_i.func_176223_P(), 3, 12, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150358_i.func_176223_P(), 2, 12, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150358_i.func_176223_P(), 3, 12, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 12, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 12, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 12, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 12, 4, structureBoundingBoxIn);
            return true;
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.readStructureFromNBT(tagCompound);
        }
    }

    public static abstract class Village
    extends StructureComponent {
        protected int averageGroundLvl = -1;
        protected int field_189928_h;
        protected boolean field_189929_i;
        protected Start startPiece;
        private int villagersSpawned;

        public Village() {
        }

        protected Village(Start start, int type) {
            super(type);
            if (start != null) {
                this.field_189928_h = start.field_189928_h;
                this.field_189929_i = start.field_189929_i;
                this.startPiece = start;
            }
        }

        protected static boolean canVillageGoDeeper(StructureBoundingBox structurebb) {
            return structurebb != null && structurebb.field_78895_b > 10;
        }

        protected void func_143012_a(NBTTagCompound tagCompound) {
            tagCompound.func_74768_a("HPos", this.averageGroundLvl);
            tagCompound.func_74768_a("VCount", this.villagersSpawned);
            tagCompound.func_74774_a("Type", (byte)this.field_189928_h);
            tagCompound.func_74757_a("Zombie", this.field_189929_i);
        }

        protected void readStructureFromNBT(NBTTagCompound tagCompound) {
            this.averageGroundLvl = tagCompound.func_74762_e("HPos");
            this.villagersSpawned = tagCompound.func_74762_e("VCount");
            this.field_189928_h = tagCompound.func_74771_c("Type");
            if (tagCompound.func_74767_n("Desert")) {
                this.field_189928_h = 1;
            }
            this.field_189929_i = tagCompound.func_74767_n("Zombie");
        }

        protected StructureComponent getNextComponentNN(Start start, List<StructureComponent> structureComponents, Random rand, int p_74891_4_, int p_74891_5_) {
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        return SnowVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, EnumFacing.WEST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return SnowVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, EnumFacing.WEST, this.func_74877_c());
                    }
                    case WEST: {
                        return SnowVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                    case EAST: 
                }
                return SnowVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            }
            return null;
        }

        protected StructureComponent getNextComponentPP(Start start, List<StructureComponent> structureComponents, Random rand, int p_74894_4_, int p_74894_5_) {
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        return SnowVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, EnumFacing.EAST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return SnowVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, EnumFacing.EAST, this.func_74877_c());
                    }
                    case WEST: {
                        return SnowVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                    case EAST: 
                }
                return SnowVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            }
            return null;
        }

        protected int getAverageGroundLevel(World worldIn, StructureBoundingBox structurebb) {
            int i = 0;
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
                for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                    blockpos$mutableblockpos.func_181079_c(l, 64, k);
                    if (!structurebb.func_175898_b((Vec3i)blockpos$mutableblockpos)) continue;
                    i += Math.max(worldIn.func_175672_r((BlockPos)blockpos$mutableblockpos).func_177956_o(), worldIn.field_73011_w.func_76557_i() - 1);
                    ++j;
                }
            }
            if (j == 0) {
                return -1;
            }
            return i / j;
        }

        protected void spawnVillagers(World worldIn, StructureBoundingBox structurebb, int x, int y, int z, int count) {
            if (this.villagersSpawned < count) {
                int l;
                int k;
                int j;
                for (int i = this.villagersSpawned; i < count && structurebb.func_175898_b((Vec3i)new BlockPos(j = this.func_74865_a(x + i, z), k = this.func_74862_a(y), l = this.func_74873_b(x + i, z))); ++i) {
                    ++this.villagersSpawned;
                    if (this.field_189929_i) {
                        EntityZombieVillager entityzombie = new EntityZombieVillager(worldIn);
                        entityzombie.func_70012_b((double)j + 0.5, (double)k, (double)l + 0.5, 0.0f, 0.0f);
                        entityzombie.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entityzombie)), (IEntityLivingData)null);
                        entityzombie.setForgeProfession(this.chooseForgeProfession(i, (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation("minecraft:farmer"))));
                        entityzombie.func_110163_bv();
                        worldIn.func_72838_d((Entity)entityzombie);
                        continue;
                    }
                    EntitySnowVillager entityvillager = new EntitySnowVillager(worldIn);
                    entityvillager.func_70012_b((double)j + 0.5, k, (double)l + 0.5, 0.0f, 0.0f);
                    entityvillager.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entityvillager)), null);
                    ModVillagers.INSTANCE.setRandomProfession(entityvillager, worldIn.field_73012_v);
                    worldIn.func_72838_d((Entity)entityvillager);
                }
            }
        }

        @Deprecated
        protected int chooseProfession(int villagersSpawnedIn, int currentVillagerProfession) {
            return currentVillagerProfession;
        }

        protected VillagerRegistry.VillagerProfession chooseForgeProfession(int count, VillagerRegistry.VillagerProfession prof) {
            return VillagerRegistry.getById((int)this.chooseProfession(count, VillagerRegistry.getId((VillagerRegistry.VillagerProfession)prof)));
        }

        protected IBlockState getBiomeSpecificBlockState(IBlockState blockstateIn) {
            BiomeEvent.GetVillageBlockID event = new BiomeEvent.GetVillageBlockID(this.startPiece == null ? null : this.startPiece.biome, blockstateIn);
            MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
            if (event.getResult() == Event.Result.DENY) {
                return event.getReplacement();
            }
            if (this.field_189928_h == 1) {
                if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                    return Blocks.field_150322_A.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150347_e) {
                    return Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.DEFAULT.func_176675_a());
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                    return Blocks.field_150322_A.func_176203_a(BlockSandStone.EnumType.SMOOTH.func_176675_a());
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150476_ad) {
                    return Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150446_ar) {
                    return Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150351_n) {
                    return Blocks.field_150322_A.func_176223_P();
                }
            } else if (this.field_189928_h == 3) {
                if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                    return Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockLog.field_176299_a, blockstateIn.func_177229_b((IProperty)BlockLog.field_176299_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                    return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150476_ad) {
                    return Blocks.field_150485_bF.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_180407_aO) {
                    return Blocks.field_180408_aP.func_176223_P();
                }
            } else if (this.field_189928_h == 2) {
                if (blockstateIn.func_177230_c() == Blocks.field_150364_r || blockstateIn.func_177230_c() == Blocks.field_150363_s) {
                    return Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockLog.field_176299_a, blockstateIn.func_177229_b((IProperty)BlockLog.field_176299_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150344_f) {
                    return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.ACACIA);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150476_ad) {
                    return Blocks.field_150400_ck.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150347_e) {
                    return Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
                }
                if (blockstateIn.func_177230_c() == Blocks.field_180407_aO) {
                    return Blocks.field_180405_aT.func_176223_P();
                }
            }
            return blockstateIn;
        }

        protected BlockDoor func_189925_i() {
            return Blocks.field_180414_ap;
        }

        protected void func_189927_a(World p_189927_1_, StructureBoundingBox p_189927_2_, Random p_189927_3_, int p_189927_4_, int p_189927_5_, int p_189927_6_, EnumFacing p_189927_7_) {
            if (!this.field_189929_i) {
                this.func_189915_a(p_189927_1_, p_189927_2_, p_189927_3_, p_189927_4_, p_189927_5_, p_189927_6_, EnumFacing.NORTH, this.func_189925_i());
            }
        }

        protected void func_189926_a(World p_189926_1_, EnumFacing p_189926_2_, int p_189926_3_, int p_189926_4_, int p_189926_5_, StructureBoundingBox p_189926_6_) {
            if (!this.field_189929_i) {
                this.func_175811_a(p_189926_1_, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)p_189926_2_), p_189926_3_, p_189926_4_, p_189926_5_, p_189926_6_);
            }
        }

        protected void func_175808_b(World worldIn, IBlockState blockstateIn, int x, int y, int z, StructureBoundingBox boundingboxIn) {
            IBlockState iblockstate = this.getBiomeSpecificBlockState(blockstateIn);
            super.func_175808_b(worldIn, iblockstate, x, y, z, boundingboxIn);
        }

        protected void func_189924_a(int p_189924_1_) {
            this.field_189928_h = p_189924_1_;
        }
    }

    public static class Torch
    extends Village {
        public Torch() {
        }

        public Torch(Start start, int p_i45568_2_, Random rand, StructureBoundingBox p_i45568_4_, EnumFacing facing) {
            super(start, p_i45568_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45568_4_;
        }

        public static StructureBoundingBox findPieceBox(Start start, List<StructureComponent> p_175856_1_, Random rand, int p_175856_3_, int p_175856_4_, int p_175856_5_, EnumFacing facing) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175856_3_, (int)p_175856_4_, (int)p_175856_5_, (int)0, (int)0, (int)0, (int)3, (int)4, (int)2, (EnumFacing)facing);
            return StructureComponent.func_74883_a(p_175856_1_, (StructureBoundingBox)structureboundingbox) != null ? null : structureboundingbox;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 2, 3, 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate, 1, 0, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 1, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150325_L.func_176203_a(EnumDyeColor.WHITE.func_176767_b()), 1, 3, 0, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.EAST, 2, 3, 0, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.NORTH, 1, 3, 1, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.WEST, 0, 3, 0, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.SOUTH, 1, 3, -1, structureBoundingBoxIn);
            return true;
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.readStructureFromNBT(tagCompound);
        }
    }

    public static class Start
    extends Well {
        public BiomeProvider worldChunkMngr;
        public int terrainType;
        public PieceWeight structVillagePieceWeight;
        public List<PieceWeight> structureVillageWeightedPieceList;
        public List<StructureComponent> pendingHouses = Lists.newArrayList();
        public List<StructureComponent> pendingRoads = Lists.newArrayList();
        public Biome biome;

        public Start() {
        }

        public Start(BiomeProvider chunkManagerIn, int p_i2104_2_, Random rand, int p_i2104_4_, int p_i2104_5_, List<PieceWeight> p_i2104_6_, int p_i2104_7_) {
            super(null, 0, rand, p_i2104_4_, p_i2104_5_);
            Biome biome;
            this.worldChunkMngr = chunkManagerIn;
            this.structureVillageWeightedPieceList = p_i2104_6_;
            this.terrainType = p_i2104_7_;
            this.biome = biome = chunkManagerIn.func_180300_a(new BlockPos(p_i2104_4_, 0, p_i2104_5_), Biomes.field_180279_ad);
            this.startPiece = this;
            this.func_189924_a(this.field_189928_h);
            this.field_189929_i = rand.nextInt(50) == 0;
        }
    }

    public static abstract class Road
    extends Village {
        public Road() {
        }

        protected Road(Start start, int type) {
            super(start, type);
        }
    }

    public static class PieceWeight {
        public final int villagePieceWeight;
        public Class<? extends Village> villagePieceClass;
        public int villagePiecesSpawned;
        public int villagePiecesLimit;

        public PieceWeight(Class<? extends Village> p_i2098_1_, int p_i2098_2_, int p_i2098_3_) {
            this.villagePieceClass = p_i2098_1_;
            this.villagePieceWeight = p_i2098_2_;
            this.villagePiecesLimit = p_i2098_3_;
        }

        public boolean canSpawnMoreVillagePiecesOfType(int componentType) {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }

        public boolean canSpawnMoreVillagePieces() {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }
    }

    public static class Path
    extends Road {
        private int length;

        public Path() {
        }

        public Path(Start start, int p_i45562_2_, Random rand, StructureBoundingBox p_i45562_4_, EnumFacing facing) {
            super(start, p_i45562_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45562_4_;
            this.length = Math.max(p_i45562_4_.func_78883_b(), p_i45562_4_.func_78880_d());
        }

        public static StructureBoundingBox findPieceBox(Start start, List<StructureComponent> p_175848_1_, Random rand, int p_175848_3_, int p_175848_4_, int p_175848_5_, EnumFacing facing) {
            for (int i = 7 * MathHelper.func_76136_a((Random)rand, (int)3, (int)5); i >= 7; i -= 7) {
                StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175848_3_, (int)p_175848_4_, (int)p_175848_5_, (int)0, (int)0, (int)0, (int)3, (int)3, (int)i, (EnumFacing)facing);
                if (StructureComponent.func_74883_a(p_175848_1_, (StructureBoundingBox)structureboundingbox) != null) continue;
                return structureboundingbox;
            }
            return null;
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("Length", this.length);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound tagCompound) {
            super.readStructureFromNBT(tagCompound);
            this.length = tagCompound.func_74762_e("Length");
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            boolean flag = false;
            for (int i = rand.nextInt(5); i < this.length - 8; i += 2 + rand.nextInt(5)) {
                StructureComponent structurecomponent = this.getNextComponentNN((Start)componentIn, listIn, rand, 0, i);
                if (structurecomponent == null) continue;
                i += Math.max(structurecomponent.func_74874_b().func_78883_b(), structurecomponent.func_74874_b().func_78880_d());
                flag = true;
            }
            for (int j = rand.nextInt(5); j < this.length - 8; j += 2 + rand.nextInt(5)) {
                StructureComponent structurecomponent1 = this.getNextComponentPP((Start)componentIn, listIn, rand, 0, j);
                if (structurecomponent1 == null) continue;
                j += Math.max(structurecomponent1.func_74874_b().func_78883_b(), structurecomponent1.func_74874_b().func_78880_d());
                flag = true;
            }
            EnumFacing enumfacing = this.func_186165_e();
            if (flag && rand.nextInt(3) > 0 && enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        SnowVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.func_74874_b().field_78897_a - 1, this.func_74874_b().field_78895_b, this.func_74874_b().field_78896_c, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case SOUTH: {
                        SnowVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case WEST: {
                        SnowVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                        break;
                    }
                    case EAST: {
                        SnowVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                }
            }
            if (flag && rand.nextInt(3) > 0 && enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        SnowVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case SOUTH: {
                        SnowVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case WEST: {
                        SnowVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                        break;
                    }
                    case EAST: {
                        SnowVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                }
            }
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            IBlockState iblockstate = this.getBiomeSpecificBlockState(ModBlocks.frozenGrassPath.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.field_150351_n.func_176223_P());
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P());
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                block1: for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    BlockPos blockpos = new BlockPos(i, 64, j);
                    if (!structureBoundingBoxIn.func_175898_b((Vec3i)blockpos)) continue;
                    if ((blockpos = worldIn.func_175672_r(blockpos).func_177977_b()).func_177956_o() < worldIn.func_181545_F()) {
                        blockpos = new BlockPos(blockpos.func_177958_n(), worldIn.func_181545_F() - 1, blockpos.func_177952_p());
                    }
                    while (blockpos.func_177956_o() >= worldIn.func_181545_F() - 1) {
                        IBlockState iblockstate4 = worldIn.func_180495_p(blockpos);
                        if (iblockstate4.func_177230_c() == Blocks.field_150349_c && worldIn.func_175623_d(blockpos.func_177984_a())) {
                            worldIn.func_180501_a(blockpos, iblockstate, 2);
                            continue block1;
                        }
                        if (iblockstate4.func_185904_a().func_76224_d() || iblockstate4.func_177230_c() == Blocks.field_150432_aD) {
                            worldIn.func_180501_a(blockpos, iblockstate1, 2);
                            continue block1;
                        }
                        if (iblockstate4.func_177230_c() == Blocks.field_150354_m || iblockstate4.func_177230_c() == Blocks.field_150322_A || iblockstate4.func_177230_c() == Blocks.field_180395_cM) {
                            worldIn.func_180501_a(blockpos, iblockstate2, 2);
                            worldIn.func_180501_a(blockpos.func_177977_b(), iblockstate3, 2);
                            continue block1;
                        }
                        blockpos = blockpos.func_177977_b();
                    }
                }
            }
            return true;
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.readStructureFromNBT(tagCompound);
        }
    }

    public static class House3
    extends Village {
        public House3() {
        }

        public House3(Start start, int type, Random rand, StructureBoundingBox p_i45561_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45561_4_;
        }

        public static House3 createPiece(Start start, List<StructureComponent> p_175849_1_, Random rand, int p_175849_3_, int p_175849_4_, int p_175849_5_, EnumFacing facing, int p_175849_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175849_3_, (int)p_175849_4_, (int)p_175849_5_, (int)0, (int)0, (int)0, (int)9, (int)7, (int)12, (EnumFacing)facing);
            return House3.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175849_1_, (StructureBoundingBox)structureboundingbox) == null ? new House3(start, p_175849_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
            IBlockState iblockstate5 = this.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P());
            IBlockState iblockstate6 = this.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 0, 5, 8, 0, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 7, 0, 4, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 3, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 0, 0, 8, 3, 10, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 7, 2, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 5, 2, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 0, 6, 2, 3, 10, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 0, 10, 7, 3, 10, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 0, 7, 3, 0, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 5, 2, 3, 5, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 1, 8, 4, 1, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 4, 3, 4, 4, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 2, 8, 5, 3, iblockstate5, iblockstate5, false);
            this.func_175811_a(worldIn, iblockstate5, 0, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 0, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 4, 4, structureBoundingBoxIn);
            IBlockState iblockstate7 = iblockstate1;
            IBlockState iblockstate8 = iblockstate2;
            IBlockState iblockstate9 = iblockstate4;
            IBlockState iblockstate10 = iblockstate3;
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_175811_a(worldIn, iblockstate7, j, 4 + i, i, structureBoundingBoxIn);
                    if (i <= -1 && j > 1 || i <= 0 && j > 3 || i <= 1 && j > 4 && j < 6) continue;
                    this.func_175811_a(worldIn, iblockstate8, j, 4 + i, 5 - i, structureBoundingBoxIn);
                }
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 4, 5, 3, 4, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 7, 4, 2, 7, 4, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 5, 4, 4, 5, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 5, 4, 6, 5, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 6, 3, 5, 6, 10, iblockstate5, iblockstate5, false);
            for (int k = 4; k >= 1; --k) {
                this.func_175811_a(worldIn, iblockstate5, k, 2 + k, 7 - k, structureBoundingBoxIn);
                for (int k1 = 8 - k; k1 <= 10; ++k1) {
                    this.func_175811_a(worldIn, iblockstate10, k, 2 + k, k1, structureBoundingBoxIn);
                }
            }
            this.func_175811_a(worldIn, iblockstate5, 6, 6, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 7, 5, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 6, 6, 4, structureBoundingBoxIn);
            for (int l = 6; l <= 8; ++l) {
                for (int l1 = 5; l1 <= 10; ++l1) {
                    this.func_175811_a(worldIn, iblockstate9, l, 12 - l, l1, structureBoundingBoxIn);
                }
            }
            this.func_175811_a(worldIn, iblockstate6, 0, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 4, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 6, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 8, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 8, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 8, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 8, 2, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 2, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 2, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 2, 2, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 4, 4, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 4, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 6, 4, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 5, 5, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.NORTH, 2, 3, 1, structureBoundingBoxIn);
            this.func_189927_a(worldIn, structureBoundingBoxIn, randomIn, 2, 1, 0, EnumFacing.NORTH);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, -1, 3, 2, -1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            if (this.func_175807_a(worldIn, 2, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, iblockstate7, 2, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_177230_c() == ModBlocks.frozenGrassPath) {
                    this.func_175811_a(worldIn, Blocks.field_150349_c.func_176223_P(), 2, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int i1 = 0; i1 < 5; ++i1) {
                for (int i2 = 0; i2 < 9; ++i2) {
                    this.func_74871_b(worldIn, i2, 7, i1, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, i2, -1, i1, structureBoundingBoxIn);
                }
            }
            for (int j1 = 5; j1 < 11; ++j1) {
                for (int j2 = 2; j2 < 9; ++j2) {
                    this.func_74871_b(worldIn, j2, 7, j1, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, j2, -1, j1, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 4, 1, 2, 2);
            return true;
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.readStructureFromNBT(tagCompound);
        }
    }

    public static class House2
    extends Village {
        private boolean hasMadeChest;

        public House2() {
        }

        public House2(Start start, int type, Random rand, StructureBoundingBox p_i45563_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45563_4_;
        }

        public static House2 createPiece(Start start, List<StructureComponent> p_175855_1_, Random rand, int p_175855_3_, int p_175855_4_, int p_175855_5_, EnumFacing facing, int p_175855_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175855_3_, (int)p_175855_4_, (int)p_175855_5_, (int)0, (int)0, (int)0, (int)10, (int)6, (int)7, (EnumFacing)facing);
            return House2.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175855_1_, (StructureBoundingBox)structureboundingbox) == null ? new House2(start, p_175855_7_, rand, structureboundingbox, facing) : null;
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("Chest", this.hasMadeChest);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound tagCompound) {
            super.readStructureFromNBT(tagCompound);
            this.hasMadeChest = tagCompound.func_74767_n("Chest");
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            IBlockState iblockstate = Blocks.field_150347_e.func_176223_P();
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P());
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate5 = this.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176223_P());
            IBlockState iblockstate6 = this.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 9, 4, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 9, 0, 6, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 0, 9, 4, 6, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 0, 9, 5, 6, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 1, 8, 5, 5, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 0, 2, 3, 0, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 4, 0, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 0, 3, 4, 0, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 6, 0, 4, 6, iblockstate5, iblockstate5, false);
            this.func_175811_a(worldIn, iblockstate3, 3, 3, 1, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 2, 3, 3, 2, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 3, 5, 3, 3, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 3, 5, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 6, 5, 3, 6, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 1, 0, 5, 3, 0, iblockstate6, iblockstate6, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 1, 0, 9, 3, 0, iblockstate6, iblockstate6, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 1, 4, 9, 4, 6, iblockstate, iblockstate, false);
            this.func_175811_a(worldIn, Blocks.field_150356_k.func_176223_P(), 7, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150356_k.func_176223_P(), 8, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), 9, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), 9, 2, 4, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 7, 2, 4, 8, 2, 5, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate, 6, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150460_al.func_176223_P(), 6, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150460_al.func_176223_P(), 6, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150334_T.func_176223_P(), 8, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 2, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150452_aw.func_176223_P(), 2, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 1, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 2, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate2, 1, 1, 4, structureBoundingBoxIn);
            if (!this.hasMadeChest && structureBoundingBoxIn.func_175898_b((Vec3i)new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(1), this.func_74873_b(5, 5)))) {
                this.hasMadeChest = true;
                this.func_186167_a(worldIn, structureBoundingBoxIn, randomIn, 5, 1, 5, LootTableList.field_186423_e);
            }
            for (int i = 6; i <= 8; ++i) {
                if (this.func_175807_a(worldIn, i, 0, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a || this.func_175807_a(worldIn, i, -1, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a) continue;
                this.func_175811_a(worldIn, iblockstate4, i, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a(worldIn, i, -1, -1, structureBoundingBoxIn).func_177230_c() != ModBlocks.frozenGrassPath) continue;
                this.func_175811_a(worldIn, Blocks.field_150349_c.func_176223_P(), i, -1, -1, structureBoundingBoxIn);
            }
            for (int k = 0; k < 7; ++k) {
                for (int j = 0; j < 10; ++j) {
                    this.func_74871_b(worldIn, j, 6, k, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, j, -1, k, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 7, 1, 1, 1);
            return true;
        }

        @Override
        protected int chooseProfession(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.readStructureFromNBT(tagCompound);
        }
    }

    public static class House1
    extends Village {
        public House1() {
        }

        public House1(Start start, int type, Random rand, StructureBoundingBox p_i45571_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45571_4_;
        }

        public static House1 createPiece(Start start, List<StructureComponent> p_175850_1_, Random rand, int p_175850_3_, int p_175850_4_, int p_175850_5_, EnumFacing facing, int p_175850_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175850_3_, (int)p_175850_4_, (int)p_175850_5_, (int)0, (int)0, (int)0, (int)9, (int)9, (int)6, (EnumFacing)facing);
            return House1.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175850_1_, (StructureBoundingBox)structureboundingbox) == null ? new House1(start, p_175850_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 9 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P());
            IBlockState iblockstate5 = this.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate6 = this.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 7, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 8, 0, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 0, 8, 5, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 6, 1, 8, 6, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 7, 2, 8, 7, 3, iblockstate, iblockstate, false);
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_175811_a(worldIn, iblockstate1, j, 6 + i, i, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, iblockstate2, j, 6 + i, 5 - i, structureBoundingBoxIn);
                }
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 5, 8, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 1, 0, 8, 1, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 0, 7, 1, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 2, 0, 0, 4, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 2, 5, 0, 4, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 2, 5, 8, 4, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 2, 0, 8, 4, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 2, 1, 0, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 5, 7, 4, 5, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 2, 1, 8, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 0, 7, 4, 0, iblockstate4, iblockstate4, false);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 6, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 6, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 3, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 6, 2, 5, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 7, 4, 1, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 4, 7, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 3, 4, 7, 3, 4, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate4, 7, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 7, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 6, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 5, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 3, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 6, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150452_aw.func_176223_P(), 6, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 4, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150452_aw.func_176223_P(), 4, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150462_ai.func_176223_P(), 7, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 2, 0, structureBoundingBoxIn);
            this.func_189927_a(worldIn, structureBoundingBoxIn, randomIn, 1, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a(worldIn, 1, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 1, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, iblockstate5, 1, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a(worldIn, 1, -1, -1, structureBoundingBoxIn).func_177230_c() == ModBlocks.frozenGrassPath) {
                    this.func_175811_a(worldIn, Blocks.field_150349_c.func_176223_P(), 1, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int l = 0; l < 6; ++l) {
                for (int k = 0; k < 9; ++k) {
                    this.func_74871_b(worldIn, k, 9, l, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, k, -1, l, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 2, 1, 2, 1);
            return true;
        }

        @Override
        protected int chooseProfession(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
        }
    }
}

