/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.google.common.base.Predicate;
import fossilsarcheology.api.FoodMappings;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;

public class DragonAITargetItems<T extends EntityItem>
extends EntityAITarget {
    protected final Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super EntityItem> targetEntitySelector;
    private final int targetChance;
    protected EntityItem targetEntity;

    public DragonAITargetItems(EntityCreature creature, boolean checkSight) {
        this(creature, checkSight, false);
    }

    public DragonAITargetItems(EntityCreature creature, boolean checkSight, boolean onlyNearby) {
        this(creature, 20, checkSight, onlyNearby, null);
    }

    public DragonAITargetItems(EntityCreature creature, int chance, boolean checkSight, boolean onlyNearby, @Nullable Predicate<? super T> targetSelector) {
        super(creature, checkSight, onlyNearby);
        this.targetChance = chance;
        this.theNearestAttackableTargetSorter = new Sorter((Entity)creature);
        this.func_75248_a(1);
        this.targetEntitySelector = new Predicate<EntityItem>(){

            public boolean apply(@Nullable EntityItem item) {
                return item instanceof EntityItem && !item.func_92059_d().func_190926_b() && item.func_92059_d().func_77973_b() != null && FoodMappings.INSTANCE.getItemFoodAmount(item.func_92059_d().func_77973_b(), ((EntityDragonBase)((DragonAITargetItems)DragonAITargetItems.this).field_75299_d).diet) > 0;
            }
        };
    }

    public boolean func_75250_a() {
        if (((EntityDragonBase)this.field_75299_d).getHunger() >= 100) {
            return false;
        }
        if (!((EntityDragonBase)this.field_75299_d).canMove()) {
            return false;
        }
        if (this.targetChance > 0 && this.field_75299_d.func_70681_au().nextInt(10) != 0) {
            return false;
        }
        List list = this.field_75299_d.field_70170_p.func_175647_a(EntityItem.class, this.getTargetableArea(this.func_111175_f()), this.targetEntitySelector);
        if (list.isEmpty()) {
            return false;
        }
        Collections.sort(list, this.theNearestAttackableTargetSorter);
        this.targetEntity = (EntityItem)list.get(0);
        return true;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.field_75299_d.func_174813_aQ().func_72321_a(targetDistance, 4.0, targetDistance);
    }

    public void func_75249_e() {
        this.field_75299_d.func_70661_as().func_75492_a(this.targetEntity.field_70165_t, this.targetEntity.field_70163_u, this.targetEntity.field_70161_v, 1.0);
        super.func_75249_e();
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.targetEntity == null || this.targetEntity != null && this.targetEntity.field_70128_L) {
            this.func_75251_c();
        }
        if (this.targetEntity != null && !this.targetEntity.field_70128_L && this.field_75299_d.func_70068_e((Entity)this.targetEntity) < 1.0) {
            this.targetEntity.func_92059_d().func_190918_g(1);
            this.field_75299_d.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
            int hunger = FoodMappings.INSTANCE.getItemFoodAmount(this.targetEntity.func_92059_d().func_77973_b(), ((EntityDragonBase)this.field_75299_d).diet);
            ((EntityDragonBase)this.field_75299_d).setHunger(Math.min(100, ((EntityDragonBase)this.field_75299_d).getHunger() + hunger));
            ((EntityDragonBase)this.field_75299_d).eatFoodBonus(this.targetEntity.func_92059_d());
            this.field_75299_d.func_70606_j(Math.min(this.field_75299_d.func_110138_aP(), (float)((int)(this.field_75299_d.func_110143_aJ() + (float)(FoodMappings.INSTANCE.getItemFoodAmount(this.targetEntity.func_92059_d().func_77973_b(), ((EntityDragonBase)this.field_75299_d).diet) / 10)))));
            if (EntityDragonBase.ANIMATION_EAT != null) {
                ((EntityDragonBase)this.field_75299_d).setAnimation(EntityDragonBase.ANIMATION_EAT);
            }
            for (int i = 0; i < 4; ++i) {
                ((EntityDragonBase)this.field_75299_d).spawnItemCrackParticles(this.targetEntity.func_92059_d().func_77973_b());
            }
            this.func_75251_c();
        }
    }

    public boolean func_75253_b() {
        return !this.field_75299_d.func_70661_as().func_75500_f();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.theEntity.func_70068_e(p_compare_1_);
            return d0 < (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? -1 : (d0 > d1 ? 1 : 0);
        }
    }
}

