/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.core.ModItems;
import com.github.alexthe666.iceandfire.core.ModSounds;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDragonFire;
import com.github.alexthe666.iceandfire.entity.EntityDragonFireCharge;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIAirTarget;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIAttackMelee;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIBreakBlocks;
import com.github.alexthe666.iceandfire.entity.ai.DragonAILookIdle;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIMate;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITarget;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITargetItems;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIWander;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIWatchClosest;
import com.google.common.base.Predicate;
import fossilsarcheology.api.EnumDiet;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityFireDragon
extends EntityDragonBase {
    public static Animation ANIMATION_TAILWHACK;
    public static Animation ANIMATION_FIRECHARGE;
    public static float[] growth_stage_1;
    public static float[] growth_stage_2;
    public static float[] growth_stage_3;
    public static float[] growth_stage_4;
    public static float[] growth_stage_5;

    public EntityFireDragon(World worldIn) {
        super(worldIn, EnumDiet.CARNIVORE, 1.0, 1 + IceAndFire.CONFIG.dragonAttackDamage, (double)IceAndFire.CONFIG.dragonHealth * 0.04, IceAndFire.CONFIG.dragonHealth, 0.2f, 0.5);
        this.func_70105_a(0.78f, 1.2f);
        this.field_70178_ae = true;
        this.field_70158_ak = true;
        ANIMATION_SPEAK = Animation.create((int)45);
        ANIMATION_BITE = Animation.create((int)35);
        ANIMATION_SHAKEPREY = Animation.create((int)65);
        ANIMATION_TAILWHACK = Animation.create((int)40);
        ANIMATION_FIRECHARGE = Animation.create((int)40);
        this.growth_stages = new float[][]{growth_stage_1, growth_stage_2, growth_stage_3, growth_stage_4, growth_stage_5};
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DragonAIAttackMelee(this, 1.5, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DragonAIMate(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, ModItems.fire_stew, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new DragonAIAirTarget(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DragonAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DragonAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DragonAILookIdle(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new DragonAIBreakBlocks(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new DragonAITarget<Entity>(this, EntityLivingBase.class, false, new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity instanceof EntityLivingBase;
            }
        }));
        this.field_70715_bh.func_75776_a(5, new DragonAITargetItems((EntityCreature)this, false));
    }

    @Override
    public String getTexture() {
        if (this.isModelDead()) {
            if (this.getDeathStage() >= this.getAgeInDays() / 5 / 2) {
                return "iceandfire:textures/models/firedragon/skeleton";
            }
            return "iceandfire:textures/models/firedragon/" + this.getVariantName(this.getVariant()) + this.getDragonStage() + "_sleep";
        }
        if (this.isSleeping() || this.isBlinking()) {
            return "iceandfire:textures/models/firedragon/" + this.getVariantName(this.getVariant()) + this.getDragonStage() + "_sleep";
        }
        return "iceandfire:textures/models/firedragon/" + this.getVariantName(this.getVariant()) + this.getDragonStage() + "";
    }

    @Override
    public String getVariantName(int variant) {
        switch (variant) {
            default: {
                return "red_";
            }
            case 1: {
                return "green_";
            }
            case 2: {
                return "bronze_";
            }
            case 3: 
        }
        return "gray_";
    }

    @Override
    public Item getVariantScale(int variant) {
        switch (variant) {
            default: {
                return ModItems.dragonscales_red;
            }
            case 1: {
                return ModItems.dragonscales_green;
            }
            case 2: {
                return ModItems.dragonscales_bronze;
            }
            case 3: 
        }
        return ModItems.dragonscales_gray;
    }

    @Override
    public Item getVariantEgg(int variant) {
        switch (variant) {
            default: {
                return ModItems.dragonegg_red;
            }
            case 1: {
                return ModItems.dragonegg_green;
            }
            case 2: {
                return ModItems.dragonegg_bronze;
            }
            case 3: 
        }
        return ModItems.dragonegg_gray;
    }

    @Override
    public boolean func_82171_bF() {
        return true;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        switch (this.func_70681_au().nextInt(3)) {
            case 0: {
                if (this.getAnimation() != ANIMATION_BITE) {
                    this.setAnimation(ANIMATION_BITE);
                    return false;
                }
                if (this.getAnimationTick() <= 15 || this.getAnimationTick() >= 25) break;
                boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                this.attackDecision = false;
                return flag;
            }
            case 1: {
                if (entityIn.field_70130_N < this.field_70130_N * 0.5f && this.func_184179_bs() == null && this.getDragonStage() > 1) {
                    if (this.getAnimation() == ANIMATION_SHAKEPREY) break;
                    this.setAnimation(ANIMATION_SHAKEPREY);
                    entityIn.func_184220_m((Entity)this);
                    return false;
                }
                if (this.getAnimation() != ANIMATION_BITE) {
                    this.setAnimation(ANIMATION_BITE);
                    return false;
                }
                if (this.getAnimationTick() <= 15 || this.getAnimationTick() >= 25) break;
                boolean flag1 = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                this.attackDecision = false;
                return flag1;
            }
            case 2: {
                if (this.getAnimation() != ANIMATION_TAILWHACK) {
                    this.setAnimation(ANIMATION_TAILWHACK);
                    return false;
                }
                if (this.getAnimationTick() <= 20 || this.getAnimationTick() >= 25) break;
                boolean flag2 = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                if (entityIn instanceof EntityLivingBase) {
                    ((EntityLivingBase)entityIn).func_70653_a(entityIn, 1.0f, 1.0, 1.0);
                }
                this.attackDecision = false;
                return flag2;
            }
        }
        return false;
    }

    public void moveEntityTowards(Entity entity, double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        entity.field_70159_w = x *= (double)velocity;
        entity.field_70181_x = y *= (double)velocity;
        entity.field_70179_y = z *= (double)velocity;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null && !this.isSleeping()) {
            if (!this.attackDecision || this.isFlying()) {
                this.shootFireAtMob(this.func_70638_az());
            } else if (this.func_174813_aQ().func_72321_a((double)(this.getRenderSize() / 3.0f), (double)(this.getRenderSize() / 3.0f), (double)(this.getRenderSize() / 3.0f)).func_72326_a(this.func_70638_az().func_174813_aQ())) {
                this.func_70652_k((Entity)this.func_70638_az());
            }
        } else {
            this.setBreathingFire(false);
        }
    }

    @Override
    public void riderShootFire(Entity controller) {
        if (this.func_70681_au().nextInt(5) == 0 && !this.func_70631_g_()) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 15) {
                this.field_70177_z = this.field_70761_aq;
                float headPosX = (float)(this.field_70165_t + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                float headPosZ = (float)(this.field_70161_v + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                float headPosY = (float)(this.field_70163_u + 0.5 * (double)this.getRenderSize() * (double)0.3f);
                this.field_70170_p.func_180498_a((EntityPlayer)null, 1016, new BlockPos((Entity)this), 0);
                double d2 = controller.func_70040_Z().field_72450_a;
                double d3 = controller.func_70040_Z().field_72448_b;
                double d4 = controller.func_70040_Z().field_72449_c;
                EntityDragonFireCharge entitylargefireball = new EntityDragonFireCharge(this.field_70170_p, this, d2, d3, d4);
                float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                entitylargefireball.setSizes(size, size);
                entitylargefireball.func_70107_b(headPosX, headPosY, headPosZ);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                }
            }
        } else if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire() && this.field_70173_aa % 3 == 0) {
                this.field_70177_z = this.field_70761_aq;
                float headPosX = (float)(this.field_70165_t + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                float headPosZ = (float)(this.field_70161_v + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                float headPosY = (float)(this.field_70163_u + 0.5 * (double)this.getRenderSize() * (double)0.3f);
                double d2 = controller.func_70040_Z().field_72450_a;
                double d3 = controller.func_70040_Z().field_72448_b;
                double d4 = controller.func_70040_Z().field_72449_c;
                EntityDragonFire entitylargefireball = new EntityDragonFire(this.field_70170_p, this, d2, d3, d4);
                this.field_70170_p.func_180498_a((EntityPlayer)null, 1016, new BlockPos((Entity)this), 0);
                float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                entitylargefireball.func_70107_b(headPosX, headPosY, headPosZ);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                }
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    private void shootFireAtMob(EntityLivingBase entity) {
        if (!this.attackDecision) {
            if (this.func_70681_au().nextInt(5) == 0) {
                if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                    this.setAnimation(ANIMATION_FIRECHARGE);
                } else if (this.getAnimationTick() == 15) {
                    this.field_70177_z = this.field_70761_aq;
                    float headPosX = (float)(this.field_70165_t + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                    float headPosZ = (float)(this.field_70161_v + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                    float headPosY = (float)(this.field_70163_u + 0.5 * (double)this.getRenderSize() * (double)0.3f);
                    double d2 = entity.field_70165_t - (double)headPosX;
                    double d3 = entity.field_70163_u - (double)headPosY;
                    double d4 = entity.field_70161_v - (double)headPosZ;
                    this.field_70170_p.func_180498_a(null, 1016, new BlockPos((Entity)this), 0);
                    EntityDragonFireCharge entitylargefireball = new EntityDragonFireCharge(this.field_70170_p, this, d2, d3, d4);
                    float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                    entitylargefireball.setSizes(size, size);
                    entitylargefireball.func_70107_b(headPosX, headPosY, headPosZ);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                    }
                    if (entity.field_70128_L || entity == null) {
                        this.setBreathingFire(false);
                        this.attackDecision = true;
                    }
                }
            } else if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire() && this.field_70173_aa % 3 == 0) {
                    this.field_70177_z = this.field_70761_aq;
                    float headPosX = (float)(this.field_70165_t + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                    float headPosZ = (float)(this.field_70161_v + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                    float headPosY = (float)(this.field_70163_u + 0.5 * (double)this.getRenderSize() * (double)0.3f);
                    double d2 = entity.field_70165_t - (double)headPosX;
                    double d3 = entity.field_70163_u - (double)headPosY;
                    double d4 = entity.field_70161_v - (double)headPosZ;
                    this.field_70170_p.func_180498_a(null, 1016, new BlockPos((Entity)this), 0);
                    EntityDragonFire entitylargefireball = new EntityDragonFire(this.field_70170_p, this, d2, d3, d4);
                    float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                    entitylargefireball.func_70107_b(headPosX, headPosY, headPosZ);
                    if (!this.field_70170_p.field_72995_K && !entity.field_70128_L) {
                        this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                    }
                    entitylargefireball.setSizes(size, size);
                    if (entity.field_70128_L || entity == null) {
                        this.setBreathingFire(false);
                        this.attackDecision = true;
                    }
                }
            } else {
                this.setBreathingFire(true);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return this.isTeen() ? ModSounds.firedragon_teen_idle : (this.isAdult() ? ModSounds.firedragon_adult_idle : ModSounds.firedragon_child_idle);
    }

    protected SoundEvent func_184601_bQ() {
        return this.isTeen() ? ModSounds.firedragon_teen_hurt : (this.isAdult() ? ModSounds.firedragon_adult_hurt : ModSounds.firedragon_child_hurt);
    }

    protected SoundEvent func_184615_bR() {
        return this.isTeen() ? ModSounds.firedragon_teen_death : (this.isAdult() ? ModSounds.firedragon_adult_death : ModSounds.firedragon_child_death);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, EntityDragonBase.ANIMATION_EAT, EntityDragonBase.ANIMATION_SPEAK, EntityDragonBase.ANIMATION_BITE, EntityDragonBase.ANIMATION_SHAKEPREY, ANIMATION_TAILWHACK, ANIMATION_FIRECHARGE};
    }

    @Override
    public String getTextureOverlay() {
        return this.isSleeping() || this.isBlinking() || this.isModelDead() ? null : "iceandfire:textures/models/firedragon/" + this.getVariantName(this.getVariant()) + this.getDragonStage() + "_eyes";
    }

    public boolean func_70877_b(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() == ModItems.fire_stew;
    }

    @Override
    public void onInventoryChanged(IInventory invBasic) {
    }

    static {
        growth_stage_1 = new float[]{1.0f, 3.0f};
        growth_stage_2 = new float[]{3.0f, 7.0f};
        growth_stage_3 = new float[]{7.0f, 12.5f};
        growth_stage_4 = new float[]{12.5f, 20.0f};
        growth_stage_5 = new float[]{20.0f, 30.0f};
    }
}

