/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.core.plugin;

import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.FMLRelaunchLog;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class LLibraryTransformer
implements IClassTransformer {
    private static final String RUNTIME_PATCHER = "RuntimePatcher";

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (!name.startsWith("$") && name.contains(RUNTIME_PATCHER)) {
            FMLRelaunchLog.info((String)("Found runtime patcher " + name), (Object[])new Object[0]);
            ClassReader classReader = new ClassReader(bytes);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            for (MethodNode methodNode : classNode.methods) {
                InsnList insnList = methodNode.instructions;
                for (AbstractInsnNode node = insnList.getFirst(); node != null; node = node.getNext()) {
                    if (node.getOpcode() != 18) continue;
                    LdcInsnNode ldc = (LdcInsnNode)node;
                    if (!(ldc.cst instanceof Type)) continue;
                    ldc.cst = ((Type)ldc.cst).getClassName();
                }
            }
            classNode.visitAnnotation("Lnet/ilexiconn/llibrary/server/asm/Transformed;", true);
            ClassWriter classWriter = new ClassWriter(2);
            classNode.accept((ClassVisitor)classWriter);
            bytes = classWriter.toByteArray();
        }
        return bytes;
    }
}

