/*
http://download.virtualbox.org/virtualbox/5.0.10/VirtualBox-5.0.10-104061-Win.exe
http://download.virtualbox.org/virtualbox/5.0.10/Oracle_VM_VirtualBox_Extension_Pack-5.0.10-104061.vbox-extpack
http://download.virtualbox.org/virtualbox/5.0.8/VirtualBox-5.0.8-103449-Win.exe
http://download.virtualbox.org/virtualbox/5.0.8/Oracle_VM_VirtualBox_Extension_Pack-5.0.8-103449.vbox-extpack

http://dlc-cdn.sun.com/virtualbox/5.0.8/VirtualBox-5.0.8-103449-Win.exe
http://dlc-cdn.sun.com/virtualbox/5.0.8/Oracle_VM_VirtualBox_Extension_Pack-5.0.8-103449.vbox-extpack

*/
!define RELEASURL	"http://dlc-cdn.sun.com/virtualbox"
!define MSI ; Delete if setup not msi
!define APPSIZE	"110000" # kB

!define DLVER	"5.0.x"
; !define DLVER	"5.0.0_RC"
!define APPNAME "VirtualBox"
; !define APPNAME "VirtualBox RC"

!define APPVER 	"0.0.0.0"
!define APP 	"VirtualBox"
!define DLNAME	"VirtualBox"
!define APPLANG	"32-64_Multilingual_Online"
!define FOLDER	"VirtualBoxPortable"
!define FINISHRUN ; Delete if not Finish pages
!define OPTIONS ; Delete if no Components
!define SOURCES ; Delete if no Sources
; !define DESCRIPTION	"Cross-platform virtualization" ; Delete if no AppInfo
!define INPUTBOX ; Delete if no InputBox

SetCompressor /SOLID lzma
SetCompressorDictSize 32

!include "..\_Include\Installer.nsh"
!include "LogicLib.nsh"
!include "x64.nsh"

!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "Bulgarian"
!insertmacro MUI_LANGUAGE "Catalan"
!insertmacro MUI_LANGUAGE "Czech"
!insertmacro MUI_LANGUAGE "Danish"
!insertmacro MUI_LANGUAGE "German"
!insertmacro MUI_LANGUAGE "SpanishInternational"
!insertmacro MUI_LANGUAGE "Farsi"
!insertmacro MUI_LANGUAGE "French"
!insertmacro MUI_LANGUAGE "Hungarian"
!insertmacro MUI_LANGUAGE "Indonesian"
!insertmacro MUI_LANGUAGE "Italian"
!insertmacro MUI_LANGUAGE "Japanese"
!insertmacro MUI_LANGUAGE "Korean"
!insertmacro MUI_LANGUAGE "Dutch"
!insertmacro MUI_LANGUAGE "PortugueseBR"
!insertmacro MUI_LANGUAGE "Russian"
!insertmacro MUI_LANGUAGE "Turkish"
!insertmacro MUI_LANGUAGE "Ukrainian"
!insertmacro MUI_LANGUAGE "SimpChinese"
!insertmacro MUI_LANGUAGE "TradChinese"

Var InputVer
Var VER
Var InputPackVer
Var PACKVER
Var MAINVER
Var SUBVER

Function nsDialogsPage
	nsDialogs::Create 1018
	Pop $0

	${NSD_CreateLabel} 0 0 100% 12u "Enter Version Number:"
	Pop $0
	${NSD_CreateText} 0 13u 100% 12u ""
	Pop $InputVer
	${NSD_CreateLabel} 0 50u 100% 12u "Enter Extension Pack Version Number:"
	Pop $0
	${NSD_CreateText} 0 63u 100% 12u ""
	Pop $InputPackVer

	nsDialogs::Show
FunctionEnd
Function nsDialogsPageLeave
	${NSD_GetText} $InputVer $R0
StrCmp $R0 "" 0 +3
	MessageBox MB_ICONEXCLAMATION `You must enter a version number!`
Abort
	StrCpy $VER "$R0" # 5.0.10-104061

StrCpy $MAINVER "$R0" -7 # 5.0.10
StrCpy $SUBVER "$R0" "" -6 # 104061

	${NSD_GetText} $InputPackVer $R0
	StrCpy $PACKVER "$R0"
FunctionEnd

Section "${APPNAME} Portable x86" main
SectionIn RO
DetailPrint "Installing ${APPNAME} Portable"

${If} ${FileExists} "$EXEDIR\VirtualBox-$VER-Win.exe"
ExecWait `"$EXEDIR\VirtualBox-$VER-Win.exe" -x -s -p "$TEMP\${APP}PortableTemp"`
${Else}

Call CheckConnected
	inetc::get "${RELEASURL}/$MAINVER/VirtualBox-$VER-Win.exe" "$TEMP\${APP}PortableTemp\VirtualBox-$VER-Win.exe" /END
	Pop $0
StrCmp $0 "OK" +3
	MessageBox MB_ICONEXCLAMATION "VirtualBox-$VER-Win.exe not found in $EXEDIR and download: $0"
	Abort
ExecWait `"$TEMP\${APP}PortableTemp\VirtualBox-$VER-Win.exe" -x -s -p "$TEMP\${APP}PortableTemp"`
${EndIf}

	SetOutPath "$INSTDIR"
		File "..\..\..\${FOLDER}\${APP}Portable.exe"
	SetOutPath "$INSTDIR\App\DefaultData\${APP}"
		File "${APP}.xml"

DetailPrint "Installing ${APPNAME} Portable"

	nsExec::Exec `"$SYSDIR\msiexec.exe" /a "$TEMP\${APP}PortableTemp\${APP}-$MAINVER-r$SUBVER-MultiArch_x86.msi" TARGETDIR="$TEMP\${APP}PortableTemp\${APP}Setup_x86" /qn`

	SetOutPath "$INSTDIR\App\${APP}_common"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\License_en_US.rtf" "$INSTDIR\App\${APP}_common"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\VBoxEFI32.fd" "$INSTDIR\App\${APP}_common"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\VBoxEFI64.fd" "$INSTDIR\App\${APP}_common"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\VBoxGuestAdditions.iso" "$INSTDIR\App\${APP}_common"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\VirtualBox.chm" "$INSTDIR\App\${APP}_common"

	Delete "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\License_en_US.rtf"
	Delete "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\VBoxEFI32.fd"
	Delete "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\VBoxEFI64.fd"
	Delete "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\VBoxGuestAdditions.iso"
	Delete "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\VirtualBox.chm"

	SetOutPath "$INSTDIR\App\${APP}_common\doc"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\doc\*.*" "$INSTDIR\App\${APP}_common\doc"
	SetOutPath "$INSTDIR\App\${APP}_common\sdk"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\sdk\*.*" "$INSTDIR\App\${APP}_common\sdk"
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_en.qm" "$INSTDIR\App\${APP}_common\nls"

	SetOutPath "$INSTDIR\App\${APP}_x86"
	CopyFiles /SILENT /FILESONLY "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\*.*" "$INSTDIR\App\${APP}_x86"
	SetOutPath "$INSTDIR\App\${APP}_x86\accessible"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\accessible\*.*" "$INSTDIR\App\${APP}_x86\accessible"
	SetOutPath "$INSTDIR\App\${APP}_x86\drivers"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\drivers\*.*" "$INSTDIR\App\${APP}_x86\drivers"

!ifdef DESCRIPTION
Call AppInfo
!endif
!ifdef SOURCES
Call Sources
	SetOutPath "$INSTDIR\Other\Source"
	File "${APP}.xml"
!endif
!ifdef SOURCES & DESCRIPTION
Call SourceInfo
!endif

SectionEnd

Function .onGUIEnd
	RMDir "/r" "$TEMP\${APP}PortableTemp"
FunctionEnd

Section /o "${APPNAME} Portable amd64" x64

	nsExec::Exec `"$SYSDIR\msiexec.exe" /a "$TEMP\${APP}PortableTemp\${APP}-$MAINVER-r$SUBVER-MultiArch_amd64.msi" TARGETDIR="$TEMP\${APP}PortableTemp\${APP}Setup_amd64" /qn`

	Delete "$TEMP\${APP}PortableTemp\${APP}Setup_amd64\PFiles\Oracle\VirtualBox\License_en_US.rtf"
	Delete "$TEMP\${APP}PortableTemp\${APP}Setup_amd64\PFiles\Oracle\VirtualBox\VBoxEFI32.fd"
	Delete "$TEMP\${APP}PortableTemp\${APP}Setup_amd64\PFiles\Oracle\VirtualBox\VBoxEFI64.fd"
	Delete "$TEMP\${APP}PortableTemp\${APP}Setup_amd64\PFiles\Oracle\VirtualBox\VBoxGuestAdditions.iso"
	Delete "$TEMP\${APP}PortableTemp\${APP}Setup_amd64\PFiles\Oracle\VirtualBox\VirtualBox.chm"

	SetOutPath "$INSTDIR\App\${APP}_amd64"
	CopyFiles /SILENT /FILESONLY "$TEMP\${APP}PortableTemp\${APP}Setup_amd64\PFiles\Oracle\VirtualBox\*.*" "$INSTDIR\App\${APP}_amd64"
	SetOutPath "$INSTDIR\App\${APP}_amd64\accessible"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_amd64\PFiles\Oracle\VirtualBox\accessible\*.*" "$INSTDIR\App\${APP}_amd64\accessible"
	SetOutPath "$INSTDIR\App\${APP}_amd64\drivers"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_amd64\PFiles\Oracle\VirtualBox\drivers\*.*" "$INSTDIR\App\${APP}_amd64\drivers"

SectionEnd

Section /o "${APPNAME} Extension Pack Portable" extpack
	File "/oname=$TEMP\${APP}PortableTemp\7za.exe" "..\_Include\7-Zip\7za.exe"
${If} ${FileExists} "$EXEDIR\Oracle_VM_VirtualBox_Extension_Pack-$PACKVER.vbox-extpack"
	nsExec::Exec `"$TEMP\${APP}PortableTemp\7za.exe" x "$EXEDIR\Oracle_VM_VirtualBox_Extension_Pack-$PACKVER.vbox-extpack" -aoa -o"$TEMP\${APP}PortableTemp\${APP}ExtUnPack"`
${Else}
	inetc::get "${RELEASURL}/$MAINVER/Oracle_VM_VirtualBox_Extension_Pack-$PACKVER.vbox-extpack" "$TEMP\${APP}PortableTemp\Oracle_VM_VirtualBox_Extension_Pack-$PACKVER.vbox-extpack" /END
	Pop $0
StrCmp $0 "OK" +3
	MessageBox MB_USERICON "Download of Oracle_VM_VirtualBox_Extension_Pack-$PACKVER.vbox-extpack: $0"
	Abort
	nsExec::Exec `"$TEMP\${APP}PortableTemp\7za.exe" x "$TEMP\${APP}PortableTemp\Oracle_VM_VirtualBox_Extension_Pack-$PACKVER.vbox-extpack" -aoa -o"$TEMP\${APP}PortableTemp\${APP}ExtUnPack"`
${EndIf}
	SetOutPath "$INSTDIR\App\${APP}_common\ExtensionPacks\Oracle_VM_VirtualBox_Extension_Pack"
	nsExec::Exec `"$TEMP\${APP}PortableTemp\7za.exe" x "$TEMP\${APP}PortableTemp\${APP}ExtUnPack\Oracle_VM_VirtualBox_Extension_Pack-$PACKVER" -aoa -o"$INSTDIR\App\${APP}_common\ExtensionPacks\Oracle_VM_VirtualBox_Extension_Pack"`

SectionEnd

SectionGroup "Language"

Section /o "Bulgarian" bg
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_bg.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

Section /o "Catalan" ca
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_ca.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

Section /o "Catalan Valencian" ca_VA
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_ca_VA.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

Section /o "Czech" cs
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_cs.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

Section /o "Danish" da
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_da.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

Section /o "German" de
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_de.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

; Section /o "English" en
	; SetOutPath "$INSTDIR\App\${APP}_common\nls"
	; CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_en.qm" "$INSTDIR\App\${APP}_common\nls"
; SectionEnd

Section /o "SpanishInternational" es
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_es.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

Section /o "Farsi" fa_IR
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_fa_IR.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

Section /o "French" fr
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_fr.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

Section /o "Hungarian" hu
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_hu.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd
Section /o "Indonesian" id
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_id.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

Section /o "Italian" it
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_it.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

Section /o "Japanese" ja
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_ja.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

Section /o "Korean" ko
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_ko.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

Section /o "Dutch" nl
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_nl.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

Section /o "PortugueseBR" pt_BR
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_pt_BR.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

Section /o "Russian" ru
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_ru.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

Section /o "Turkish" tr
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_tr.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

Section /o "Ukrainian" uk
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_uk.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

Section /o "SimpChinese" zh_CN
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_zh_CN.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

Section /o "TradChinese" zh_TW
	SetOutPath "$INSTDIR\App\${APP}_common\nls"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup_x86\PFiles\Oracle\VirtualBox\nls\*_zh_TW.qm" "$INSTDIR\App\${APP}_common\nls"
SectionEnd

SectionGroupEnd

Function Init
SectionSetSize ${extpack} 29700 # kB
SectionSetSize ${x64} 65000 # kB
SectionSetSize ${bg} 500 # kB
SectionSetSize ${ca} 500 # kB
SectionSetSize ${ca_VA} 500 # kB
SectionSetSize ${cs} 500 # kB
SectionSetSize ${da} 500 # kB
SectionSetSize ${de} 500 # kB
SectionSetSize ${es} 500 # kB
SectionSetSize ${fa_IR} 500 # kB
SectionSetSize ${fr} 500 # kB
SectionSetSize ${hu} 500 # kB
SectionSetSize ${id} 500 # kB
SectionSetSize ${it} 500 # kB
SectionSetSize ${ja} 500 # kB
SectionSetSize ${ko} 500 # kB
SectionSetSize ${nl} 500 # kB
SectionSetSize ${pt_BR} 500 # kB
SectionSetSize ${ru} 500 # kB
SectionSetSize ${tr} 500 # kB
SectionSetSize ${uk} 500 # kB
SectionSetSize ${zh_CN} 500 # kB
SectionSetSize ${zh_TW} 500 # kB

${If} ${RunningX64}
SectionSetFlags ${x64} 1
${Else}
${EndIf}
System::Call 'kernel32::GetUserDefaultLangID() i .r0'
StrCmp $0 "1026" 0 +3
	SectionSetFlags ${bg} 1
Goto langdone
StrCmp $0 "1027" 0 +4
	SectionSetFlags ${ca} 1
	SectionSetFlags ${ca_VA} 1
Goto langdone
StrCmp $0 "1029" 0 +3
	SectionSetFlags ${cs} 1
Goto langdone
StrCmp $0 "1030" 0 +3
	SectionSetFlags ${da} 1
Goto langdone
StrCmp $0 "1031" 0 +3
	SectionSetFlags ${de} 1
Goto langdone
StrCmp $0 "3082" 0 +3
	SectionSetFlags ${es} 1
Goto langdone
StrCmp $0 "1065" 0 +3
	SectionSetFlags ${fa_IR} 1
Goto langdone
StrCmp $0 "1036" 0 +3
	SectionSetFlags ${fr} 1
Goto langdone
StrCmp $0 "1038" 0 +3
	SectionSetFlags ${hu} 1
Goto langdone
StrCmp $0 "1057" 0 +3
	SectionSetFlags ${id} 1
Goto langdone
StrCmp $0 "1040" 0 +3
	SectionSetFlags ${it} 1
Goto langdone
StrCmp $0 "1041" 0 +3
	SectionSetFlags ${ja} 1
Goto langdone
StrCmp $0 "1042" 0 +3
	SectionSetFlags ${ko} 1
Goto langdone
StrCmp $0 "1043" 0 +3
	SectionSetFlags ${nl} 1
Goto langdone
StrCmp $0 "1046" 0 +3
	SectionSetFlags ${pt_BR} 1
Goto langdone
StrCmp $0 "1049" 0 +3
	SectionSetFlags ${ru} 1
Goto langdone
StrCmp $0 "1058" 0 +3
	SectionSetFlags ${uk} 1
Goto langdone
StrCmp $0 "2052" 0 +3
	SectionSetFlags ${zh_CN} 1
Goto langdone
StrCmp $0 "1028" 0 +2
	SectionSetFlags ${zh_TW} 1
langdone:
FunctionEnd
