﻿/**
 * Color settings.
 * 颜色设置.
 */
{

  "def": {
    // 不同人的颜色设置.
    "al": "0x96FF00", 						// ally       / 队友对敌人的伤害
    "sq": "0xFFB964", 						// squadman   / 组队同伴对敌人的伤害
    "tk": "0x00EAFF", 						// teamKiller / TK伤害
    "en": "0xF50800", 						// enemy      / 敌人对我方的伤害
    "pl": "0xFFDD33", 						// player     / 玩家伤害
    // 数据的颜色设置
    "colorRating": {
	  "worst":        "0xb30000", 		  	// normal     / 极差
      "very_bad":     "0xdd3333",   		// very bad   / 很差
      "bad":          "0x4da621",   		// bad        / 差
      "normal":       "0x5ce55c", 		  	// normal     / 普通
      "good":         "0x66b3ff", 		  	// good       / 好
      "very_good":    "0xe14cff",   		// very good  / 很好
      "great":    	  "0xf2df0c",   		// great      / 极好
      "unique":       "0xffaa00"    		// unique     / 顶尖
    },
    // 剩余血量的颜色设置
    "colorHP": {
      "very_low":         "0xFF0000",   	// very low       / 很低
      "low":              "0xDD4444",   	// low            / 低
      "average":          "0xFFCC22",   	// average        / 中
      "above_average":    "0x5ce55c"    	// above-average  / 高
    }
  },
  "colors": {
    "system": {								// 系统颜色
      // 格式: 目标_状态
      // 目标:   ally - 队友, squadman - 组队, teamKiller - TK者, enemy - 敌人
      // 状态:   alive - 存活, dead - 被击毁, blowedup - 弹药架炸毁
      "ally_alive":          ${"def.al"},
      "ally_dead":           "0x009900",
      "ally_blowedup":       "0x007700",
      "squadman_alive":      ${"def.sq"},
      "squadman_dead":       "0xCA7000",
      "squadman_blowedup":   "0xA45A00",
      "teamKiller_alive":    ${"def.tk"},
      "teamKiller_dead":     "0x097783",
      "teamKiller_blowedup": "0x096A75",
      "enemy_alive":         ${"def.en"},
      "enemy_dead":          "0x840500",
      "enemy_blowedup":      "0x5A0401",
      "ally_base":           ${"def.al"},
      "enemy_base":          ${"def.en"}
    },
    // 不同伤害类型的颜色.
    "dmg_kind": {
      "shot": "0xFFAA55",          		// attack / 射击伤害
      "fire": "0xFF6655",            		// fire / 着火伤害
      "ramming": "0x998855",        		// ramming / 撞击伤害
      "world_collision": "0x228855", 		// world collision / 坠落伤害
      "death_zone": "0xCCCCCC",      // TODO: value, description
      "drowning": "0xCCCCCC",        // TODO: value, description
      "other": "0xCCCCCC"            		// other / 其他
    },
    // 车辆类型的颜色
    "vtype": {
      "LT":  "0xA2FF9A",
      "MT":  "0xFFF198",
      "HT":  "0xFFACAC",
      "SPG": "0xEFAEFF",
      "TD":  "0xA0CFFF",
      "premium": "0xFFCC66",				// 金币车
      "usePremiumColor": false				// 是否为金币车显示特别颜色
    },
    // Dynamic color by spotted status
    // Динамический цвет по статусу засвета
    "spotted": {
      "neverSeen":      "0xEEEEEE",
      "lost":           "0xD9D9D9",
      "spotted":        "0xFFBB00",
      "dead":           "0xFFFFFF",
      "neverSeen_arty": "0xEEEEEE",
      "lost_arty":      "0xD9D9D9",
      "spotted_arty":   "0xFFBB00",
      "dead_arty":      "0xFFFFFF"
    },
    // HP color depending on the ratio of ally and enemy teams hp.
    // Цвет ХП в зависимости от отношения хп союзной и вражеской команд.
    "totalHP": {
      "bad":     "0xFF0000",
      "neutral": "0xFFFFFF",
      "good":    "0x00FF00"
    },
    // Color settings for damage.
    // Настройки цвета для урона.
    "damage": {
      // Format: src_dst_type.
      // Src:  ally, squadman, enemy, unknown, player.
      // Dst:  ally, squadman, allytk, enemytk, enemy.
      // Type: hit, kill, blowup.
      // ----
      // Формат: источник_получатель_тип.
      // Источник:   ally - союзник, squadman - взводный, enemy - противник, unknown - неизвестный (не виден игроку), player - игрок.
      // Получатель: ally, squadman, enemy, allytk - союзник тимкиллер, enemytk - противник тимкиллер.
      // Тип:        hit - попадание, kill - убийство, blowup - боеукладка.
      "ally_ally_hit":              ${"def.tk"},
      "ally_ally_kill":             ${"def.tk"},
      "ally_ally_blowup":           ${"def.tk"},
      "ally_squadman_hit":          ${"def.tk"},
      "ally_squadman_kill":         ${"def.tk"},
      "ally_squadman_blowup":       ${"def.tk"},
      "ally_enemy_hit":             ${"def.en"},
      "ally_enemy_kill":            ${"def.en"},
      "ally_enemy_blowup":          ${"def.en"},
      "ally_allytk_hit":            ${"def.tk"},
      "ally_allytk_kill":           ${"def.tk"},
      "ally_allytk_blowup":         ${"def.tk"},
      "ally_enemytk_hit":           ${"def.en"},
      "ally_enemytk_kill":          ${"def.en"},
      "ally_enemytk_blowup":        ${"def.en"},
      "enemy_ally_hit":             ${"def.al"},
      "enemy_ally_kill":            ${"def.al"},
      "enemy_ally_blowup":          ${"def.al"},
      "enemy_squadman_hit":         ${"def.al"},
      "enemy_squadman_kill":        ${"def.al"},
      "enemy_squadman_blowup":      ${"def.al"},
      "enemy_enemy_hit":            ${"def.en"},
      "enemy_enemy_kill":           ${"def.en"},
      "enemy_enemy_blowup":         ${"def.en"},
      "enemy_allytk_hit":           ${"def.al"},
      "enemy_allytk_kill":          ${"def.al"},
      "enemy_allytk_blowup":        ${"def.al"},
      "enemy_enemytk_hit":          ${"def.en"},
      "enemy_enemytk_kill":         ${"def.en"},
      "enemy_enemytk_blowup":       ${"def.en"},
      "unknown_ally_hit":           ${"def.al"},
      "unknown_ally_kill":          ${"def.al"},
      "unknown_ally_blowup":        ${"def.al"},
      "unknown_squadman_hit":       ${"def.al"},
      "unknown_squadman_kill":      ${"def.al"},
      "unknown_squadman_blowup":    ${"def.al"},
      "unknown_enemy_hit":          ${"def.en"},
      "unknown_enemy_kill":         ${"def.en"},
      "unknown_enemy_blowup":       ${"def.en"},
      "unknown_allytk_hit":         ${"def.al"},
      "unknown_allytk_kill":        ${"def.al"},
      "unknown_allytk_blowup":      ${"def.al"},
      "unknown_enemytk_hit":        ${"def.en"},
      "unknown_enemytk_kill":       ${"def.en"},
      "unknown_enemytk_blowup":     ${"def.en"},
      "squadman_ally_hit":          ${"def.sq"},
      "squadman_ally_kill":         ${"def.sq"},
      "squadman_ally_blowup":       ${"def.sq"},
      "squadman_squadman_hit":      ${"def.sq"},
      "squadman_squadman_kill":     ${"def.sq"},
      "squadman_squadman_blowup":   ${"def.sq"},
      "squadman_enemy_hit":         ${"def.sq"},
      "squadman_enemy_kill":        ${"def.sq"},
      "squadman_enemy_blowup":      ${"def.sq"},
      "squadman_allytk_hit":        ${"def.sq"},
      "squadman_allytk_kill":       ${"def.sq"},
      "squadman_allytk_blowup":     ${"def.sq"},
      "squadman_enemytk_hit":       ${"def.sq"},
      "squadman_enemytk_kill":      ${"def.sq"},
      "squadman_enemytk_blowup":    ${"def.sq"},
      "player_ally_hit":            ${"def.pl"},
      "player_ally_kill":           ${"def.pl"},
      "player_ally_blowup":         ${"def.pl"},
      "player_squadman_hit":        ${"def.pl"},
      "player_squadman_kill":       ${"def.pl"},
      "player_squadman_blowup":     ${"def.pl"},
      "player_enemy_hit":           ${"def.pl"},
      "player_enemy_kill":          ${"def.pl"},
      "player_enemy_blowup":        ${"def.pl"},
      "player_allytk_hit":          ${"def.pl"},
      "player_allytk_kill":         ${"def.pl"},
      "player_allytk_blowup":       ${"def.pl"},
      "player_enemytk_hit":         ${"def.pl"},
      "player_enemytk_kill":        ${"def.pl"},
      "player_enemytk_blowup":      ${"def.pl"}
    },
    // 下列值请从小到大排列.
	
    // 剩余血值的颜色.
    "hp": [
      { "value": 201,  "color": ${"def.colorHP.very_low"     } },
      { "value": 401,  "color": ${"def.colorHP.low"          } },
      { "value": 1001, "color": ${"def.colorHP.average"      } },
      { "value": 9999, "color": ${"def.colorHP.above_average"} } 
    ],
    // 剩余血量百分比的颜色.
    "hp_ratio": [
      { "value": 10,  "color": ${"def.colorHP.very_low"     } },
      { "value": 25,  "color": ${"def.colorHP.low"          } },
      { "value": 50,  "color": ${"def.colorHP.average"      } },
      { "value": 101, "color": ${"def.colorHP.above_average"} } 
    ],
    //
    "x": [
      { "value": 40,  "color": ${"def.colorRating.worst"    } },      // 1,2    - worst
      { "value": 80,  "color": ${"def.colorRating.very_bad" } },   // 3,4  	- very bad
      { "value": 100,  "color": ${"def.colorRating.bad"      } },   // 5  	- bad
      { "value": 120,  "color": ${"def.colorRating.normal"   } },   // 6  	- normal
      { "value": 140,  "color": ${"def.colorRating.good"     } },   // 7  	- good
      { "value": 160,  "color": ${"def.colorRating.very_good"} },   // 8  	- very good
      { "value": 180, "color": ${"def.colorRating.great"	   } },      // 9 		- great
      { "value": 999, "color": ${"def.colorRating.unique"   } }    // 10,11 	- unique
    ],
    //
    "eff": [
      { "value": 610,  "color": ${"def.colorRating.very_bad" } },  //    0 - 609  - very bad   (20% of players)
      { "value": 865,  "color": ${"def.colorRating.bad"      } },  //  610 - 864  - bad        (better then 20% of players)
      { "value": 1165, "color": ${"def.colorRating.normal"   } },  //  865 - 1164 - normal     (better then 60% of players)
      { "value": 1515, "color": ${"def.colorRating.good"     } },  // 1165 - 1514 - good       (better then 90% of players)
      { "value": 1835, "color": ${"def.colorRating.very_good"} },  // 1515 - 1834 - very good  (better then 99% of players)
      { "value": 9999, "color": ${"def.colorRating.unique"   } }   // 1835 - *    - unique     (better then 99.9% of players)
    ],
    // 增幅
    "wn6": [
      { "value": 445,  "color": ${"def.colorRating.very_bad" } },  //    0 - 444  - very bad   (20% of players)
      { "value": 835,  "color": ${"def.colorRating.bad"      } },  //  445 - 834  - bad        (better then 20% of players)
      { "value": 1210, "color": ${"def.colorRating.normal"   } },  //  835 - 1209 - normal     (better then 60% of players)
      { "value": 1615, "color": ${"def.colorRating.good"     } },  // 1210 - 1614 - good       (better then 90% of players)
      { "value": 1950, "color": ${"def.colorRating.very_good"} },  // 1615 - 1949 - very good  (better then 99% of players)
      { "value": 9999, "color": ${"def.colorRating.unique"   } }   // 1950 - *    - unique     (better then 99.9% of players)
    ],
    // 效率
    "wn8": [
      { "value": 360,  "color": ${"def.colorRating.very_bad" } },  //    0 - 359  - very bad   (20% of players)
      { "value": 825,  "color": ${"def.colorRating.bad"      } },  //  360 - 824  - bad        (better then 20% of players)
      { "value": 1385, "color": ${"def.colorRating.normal"   } },  //  825 - 1384 - normal     (better then 60% of players)
      { "value": 2055, "color": ${"def.colorRating.good"     } },  // 1385 - 2054 - good       (better then 90% of players)
      { "value": 2675, "color": ${"def.colorRating.very_good"} },  // 2055 - 2674 - very good  (better then 99% of players)
      { "value": 9999, "color": ${"def.colorRating.unique"   } }   // 2675 - *    - unique     (better then 99.9% of players)
    ],
    // 全局效率
    "wgr": [
      { "value": 40,  "color": ${"def.colorRating.worst"     } },	// 1,2		- worst
      { "value": 80,  "color": ${"def.colorRating.very_bad"  } },	// 3,4  	- very bad
      { "value": 100, "color": ${"def.colorRating.bad"       } },	// 5  		- bad
      { "value": 120, "color": ${"def.colorRating.normal"    } },   // 6  		- normal
      { "value": 140, "color": ${"def.colorRating.good"      } },   // 7  		- good
      { "value": 160, "color": ${"def.colorRating.very_good" } },   // 8  		- very good
      { "value": 180, "color": ${"def.colorRating.great"	 } },	// 9 		- great
      { "value": 999, "color": ${"def.colorRating.unique"    } }    // 10,11 	- unique
	],
    // 战力
    "e": [
      { "value": 2,    "color": ${"def.colorRating.very_bad" } },
      { "value": 4,    "color": ${"def.colorRating.bad"      } },
      { "value": 5,    "color": ${"def.colorRating.normal"   } },
      { "value": 7,    "color": ${"def.colorRating.good"     } },
      { "value": 9,    "color": ${"def.colorRating.very_good"} },
      { "value": 20,   "color": ${"def.colorRating.unique"   } }
    ],
    // 预测胜率
    "winChance": [
      { "value": 4.5,   "color": ${"def.colorRating.worst"   } },
      { "value": 24.5, "color": ${"def.colorRating.very_bad" } },
      { "value": 50, "color": ${"def.colorRating.bad"        } },
      { "value": 74.5, "color": ${"def.colorRating.normal"   } },
      { "value": 84.5, "color": ${"def.colorRating.very_good"} },
      { "value": 94.5, "color": ${"def.colorRating.great"    } },
      { "value": 101,  "color": ${"def.colorRating.unique"   } }
    ],
	//胜率
    "winrate": [
      { "value": 45,  "color": ${"def.colorRating.worst" 	} }, 		// 0    - 44.5  - worst
      { "value": 47,  "color": ${"def.colorRating.very_bad" } },   		// 44.5 - 46.5  - very_bad
      { "value": 49,  "color": ${"def.colorRating.bad"   	} },  	 	// 46.5 - 48.5  - bad
      { "value": 52,  "color": ${"def.colorRating.normal"   } },   		// 48.5 - 51.5  - normal
      { "value": 55,  "color": ${"def.colorRating.good"   	} },   		// 51.5 - 54.5  - good
      { "value": 57,  "color": ${"def.colorRating.very_good"} },  		// 51.5 - 56.5  - very_good
      { "value": 64,  "color": ${"def.colorRating.great"	} },   		// 56.5 - 63.5  - great
      { "value": 101, "color": ${"def.colorRating.unique"   } }    		// 63.5 - 100   - unique
    ],
    // 总场次的颜色
    "kb": [
      { "value": 3,   "color": ${"def.colorRating.very_bad" } },   //  0 - 2
      { "value": 5,   "color": "0xaaaaaa" },   //  3 - 4
      { "value": 999, "color": "0xeeeeee" }    //  5 - *
    ],
    // 效率等级
    "avglvl": [
      { "value": 3,  "color": ${"def.colorRating.worst"    } },      // 1,2    - worst
      { "value": 5,  "color": ${"def.colorRating.very_bad" } },   // 3,4  	- very bad
      { "value": 6,  "color": ${"def.colorRating.bad"      } },   // 5  	- bad
      { "value": 7,  "color": ${"def.colorRating.normal"   } },   // 6  	- normal
      { "value": 8,  "color": ${"def.colorRating.good"     } },   // 7  	- good
      { "value": 9,  "color": ${"def.colorRating.very_good"} },   // 8  	- very good
      { "value": 10, "color": ${"def.colorRating.great"	   } },      // 9 		- great
      { "value": 12, "color": ${"def.colorRating.unique"   } }    // 10,11 	- unique
    ],
	// 单车场次
    "t_battles": [
      { "value": 20,    "color": ${"def.colorRating.very_bad" } }, //    0 - 19
      { "value": 50,    "color": ${"def.colorRating.bad"      } }, //   20 - 49
      { "value": 100,   "color": ${"def.colorRating.normal"   } }, //   50 - 99
      { "value": 250,   "color": ${"def.colorRating.good"     } }, //  100 - 249
      { "value": 500,   "color": ${"def.colorRating.very_good"} }, //  251 - 499
      { "value": 1000, 	"color": ${"def.colorRating.great"	  } }, //  500 - 999
      { "value": 99999, "color": ${"def.colorRating.unique"   } }  // 1000 - *
    ],
    // 
    "tdb": [
	  { "value": 3,   "color": ${"def.colorRating.worst" } },      // 0-3    - worst
      { "value": 15,  "color": ${"def.colorRating.very_bad" } },   // 3-15   - very bad
      { "value": 35,  "color": ${"def.colorRating.bad"      } },   // 15-35  - bad
      { "value": 75,  "color": ${"def.colorRating.normal"   } },   // 35-75  - normal
      { "value": 90,  "color": ${"def.colorRating.good"     } },   // 75-90  - good
      { "value": 98,  "color": ${"def.colorRating.very_good"} },   // 90-98  - very good
	  { "value": 100, "color": ${"def.colorRating.great"	} },   // 98-99.5- great
      { "value": 101, "color": ${"def.colorRating.unique"   } }    // 100 	 - unique
    ],
    // 
    "tdv": [
      { "value": 0.6,  "color": ${"def.colorRating.very_bad" } },
      { "value": 0.8,  "color": ${"def.colorRating.bad"      } },
      { "value": 1.0,  "color": ${"def.colorRating.normal"   } },
      { "value": 1.3,  "color": ${"def.colorRating.good"     } },
      { "value": 2.0,  "color": ${"def.colorRating.very_good"} },
      { "value": 15,   "color": ${"def.colorRating.unique"   } }
    ],
    // 
    "tfb": [
      { "value": 0.6,  "color": ${"def.colorRating.very_bad" } },
      { "value": 0.8,  "color": ${"def.colorRating.bad"      } },
      { "value": 1.0,  "color": ${"def.colorRating.normal"   } },
      { "value": 1.3,  "color": ${"def.colorRating.good"     } },
      { "value": 2.0,  "color": ${"def.colorRating.very_good"} },
      { "value": 15,   "color": ${"def.colorRating.unique"   } }
    ],
    // 效率等级标识
    "tsb": [
	  { "value": 1,  "color": "-" },
	  { "value": 5,  "color": "D" },   // 1,2,3,4 - worst
      { "value": 7,  "color": "C" },   // 5,6 	  - very bad
      { "value": 8,  "color": "B" },   // 7  	  - bad
      { "value": 9,  "color": "A" },   // 8  	  - normal
      { "value": 10, "color": "S" },   // 9  	  - good
      { "value": 12, "color": "♂" }    // 10,11	  - very good
    ],
    // 无效
    "wn8effd": [
      { "value": 0.6,  "color": ${"def.colorRating.very_bad" } },
      { "value": 0.8,  "color": ${"def.colorRating.bad"      } },
      { "value": 1.0,  "color": ${"def.colorRating.normal"   } },
      { "value": 1.3,  "color": ${"def.colorRating.good"     } },
      { "value": 2.0,  "color": ${"def.colorRating.very_good"} },
      { "value": 15,   "color": ${"def.colorRating.unique"   } }
    ],
    // 炮管标记
    "damageRating": [
      { "value": 20,    "color": ${"def.colorRating.very_bad" } },  // 20% of players
      { "value": 40,    "color": ${"def.colorRating.bad"      } },  // better then 40% of players
      { "value": 65,    "color": ${"def.colorRating.normal"   } },  // better then 65% of players
      { "value": 85,    "color": ${"def.colorRating.good"     } },  // better then 85% of players
      { "value": 90,  	"color": ${"def.colorRating.very_good"} },  // better then 90% of players
      { "value": 95,  	"color": ${"def.colorRating.great"	  } },  // better then 95% of players
      { "value": 101,   "color": ${"def.colorRating.unique"   } }   // better then 99.9% of players
    ],
    // 命中
    "hitsRatio": [
      { "value": 47.5,  "color": ${"def.colorRating.very_bad" } },
      { "value": 60.5,  "color": ${"def.colorRating.bad"      } },
      { "value": 68.5,  "color": ${"def.colorRating.normal"   } },
      { "value": 74.5,  "color": ${"def.colorRating.good"     } },
      { "value": 78.5,  "color": ${"def.colorRating.very_good"} },
      { "value": 101,   "color": ${"def.colorRating.unique"   } }
    ]
  }
}
