﻿/**
 * Parameters for tank carousel
 * Параметры карусели танков
 */
{
  "carousel": {
    // false - Disable customizable carousel.
    "enabled": true,
    // Type of cells - "default" (depends from window size), "normal" or "small"
    // Вид ячеек - "default" (в зависимости от размера окна), "normal" (обычные), "small" (маленькие)
    "cellType": "default",
    // Normal cells settings
    // Настройки ячеек обычного размера
    "normal": ${"carouselNormal.xc":"normal"},
    // Small cells settings
    // Настройки ячеек маленького размера
    "small": ${"carouselSmall.xc":"small"},
    // Number of rows at carousel.
    "rows": 0,
    // Background transparency (default - 100)
    // Прозрачность подложки (по умолчанию - 100)
    "backgroundAlpha": 100,
    // Mouse wheel scrolling speed multiplier (default - 1)
    "scrollingSpeed": 1,
    // true - hide cell "Buy vehicle".
    "hideBuyTank": false,
    // true - hide cell "Buy slot".
    "hideBuySlot": false,
    // true - show total slots count in the "Buy vehicle" cell.
    "showTotalSlots": false,
    // true - show used slots count in the "Buy slot" cell.
    "showUsedSlots": true,
    // Visibility filters.
    "filters": {
      // false - hide filter.
      // false - скрыть фильтр.
      "params":   { "enabled": true },  // main params        / основные параметры
      "bonus":    { "enabled": true },  // x2 bonus           / x2 бонус
      "favorite": { "enabled": true }   // favorite tanks     / основные танки
    },
    // Spacing between filters cells.
    "filtersPadding": {
      "horizontal": 11,   // по горизонтали
      "vertical": 13      // по вертикали
    },
    // Order of nations.
    //"nations_order": ["ussr", "germany", "usa", "france", "uk", "china", "japan", "czech"],
    "nations_order": [],
    // Order of types of vehicles.
    "types_order":   ["lightTank", "mediumTank", "heavyTank", "AT-SPG", "SPG"],
	
    // "nation", "type", "level", "-level", "maxBattleTier", "-maxBattleTier", "premium", "-premium",
    // "winRate", "-winRate", "markOfMastery", "-markOfMastery", "xtdb", "-xtdb", "xte", "-xte",
    // "damageRating", "-damageRating", "marksOnGun", "-marksOnGun"
    "sorting_criteria": ["nation", "type", "level"],
    // Suppress the tooltips for tanks in carousel
    // Убрать подсказки к танкам в карусели
    "suppressCarouselTooltips": false
  }
}
