/*
 * Copyright (c) 2011 by the original author(s).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.data.mapping;

import java.util.List;

import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Reference;

/**
 * @author Jon Brisbin <jbrisbin@vmware.com>
 */
public class PersonWithChildren extends Person {

	@Id
	String id;

	@Reference
	private List<Child> children;

	public PersonWithChildren(Integer ssn, String firstName, String lastName) {
		super(ssn, firstName, lastName);
	}

	public List<Child> getChildren() {
		return children;
	}

	public void setChildren(List<Child> children) {
		this.children = children;
	}

}
