/*
 * Copyright 2012-2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.boot.context.properties.bind.validation;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.mock;

/**
 * Tests for {@link BindValidationException}.
 *
 * @author Phillip Webb
 * @author Madhura Bhave
 */
public class BindValidationExceptionTests {

	@Rule
	public ExpectedException thrown = ExpectedException.none();

	@Test
	public void createWhenValidationErrorsIsNullShouldThrowException() throws Exception {
		this.thrown.expect(IllegalArgumentException.class);
		this.thrown.expectMessage("ValidationErrors must not be null");
		new BindValidationException(null);
	}

	@Test
	public void getValidationErrorsShouldReturnValidationErrors() throws Exception {
		ValidationErrors errors = mock(ValidationErrors.class);
		BindValidationException exception = new BindValidationException(errors);
		assertThat(exception.getValidationErrors()).isEqualTo(errors);
	}

}
