/*
 * Copyright 2012-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package sample.jndi;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class WebController {

	private final AccountService service;

	private final AccountRepository repository;

	public WebController(AccountService service, AccountRepository repository) {
		this.service = service;
		this.repository = repository;
	}

	@GetMapping("/")
	public String hello() {
		System.out.println("Count is " + this.repository.count());
		this.service.createAccountAndNotify("josh");
		try {
			this.service.createAccountAndNotify("error");
		}
		catch (Exception ex) {
			System.out.println(ex.getMessage());
		}
		long count = this.repository.count();
		System.out.println("Count is " + count);
		return "Count is " + count;
	}

}
