/*
 * Copyright 2012-2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.boot.autoconfigure.jms.activemq;

import java.util.ArrayList;
import java.util.List;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Configuration properties for ActiveMQ.
 *
 * @author Greg Turnquist
 * @author Stephane Nicoll
 * @author Aurélien Leboulanger
 * @author Venil Noronha
 */
@ConfigurationProperties(prefix = "spring.activemq")
public class ActiveMQProperties {

	/**
	 * URL of the ActiveMQ broker. Auto-generated by default.
	 */
	private String brokerUrl;

	/**
	 * Specify if the default broker URL should be in memory. Ignored if an explicit
	 * broker has been specified.
	 */
	private boolean inMemory = true;

	/**
	 * Login user of the broker.
	 */
	private String user;

	/**
	 * Login password of the broker.
	 */
	private String password;

	private Pool pool = new Pool();

	private Packages packages = new Packages();

	public String getBrokerUrl() {
		return this.brokerUrl;
	}

	public void setBrokerUrl(String brokerUrl) {
		this.brokerUrl = brokerUrl;
	}

	public boolean isInMemory() {
		return this.inMemory;
	}

	public void setInMemory(boolean inMemory) {
		this.inMemory = inMemory;
	}

	public String getUser() {
		return this.user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	public String getPassword() {
		return this.password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public Pool getPool() {
		return this.pool;
	}

	public void setPool(Pool pool) {
		this.pool = pool;
	}

	public Packages getPackages() {
		return this.packages;
	}

	public static class Pool {

		/**
		 * Whether a PooledConnectionFactory should be created instead of a regular
		 * ConnectionFactory.
		 */
		private boolean enabled;

		/**
		 * Maximum number of pooled connections.
		 */
		private int maxConnections = 1;

		/**
		 * Connection idle timeout in milliseconds.
		 */
		private int idleTimeout = 30000;

		/**
		 * Connection expiration timeout in milliseconds.
		 */
		private long expiryTimeout = 0;

		public boolean isEnabled() {
			return this.enabled;
		}

		public void setEnabled(boolean enabled) {
			this.enabled = enabled;
		}

		public int getMaxConnections() {
			return this.maxConnections;
		}

		public void setMaxConnections(int maxConnections) {
			this.maxConnections = maxConnections;
		}

		public int getIdleTimeout() {
			return this.idleTimeout;
		}

		public void setIdleTimeout(int idleTimeout) {
			this.idleTimeout = idleTimeout;
		}

		public long getExpiryTimeout() {
			return this.expiryTimeout;
		}

		public void setExpiryTimeout(long expiryTimeout) {
			this.expiryTimeout = expiryTimeout;
		}

	}

	public static class Packages {

		/**
		 * Trust all packages.
		 */
		private Boolean trustAll;

		/**
		 * Comma-separated list of specific packages to trust (when not trusting all
		 * packages).
		 */
		private List<String> trusted = new ArrayList<>();

		public Boolean getTrustAll() {
			return this.trustAll;
		}

		public void setTrustAll(Boolean trustAll) {
			this.trustAll = trustAll;
		}

		public List<String> getTrusted() {
			return this.trusted;
		}

		public void setTrusted(List<String> trusted) {
			this.trusted = trusted;
		}

	}

}
