/*
 * Copyright 2012-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.boot.actuate.endpoint.mvc;

import org.junit.Before;
import org.junit.Test;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.mvc.ServletWrappingController;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.spy;
import static org.mockito.Mockito.verify;

/**
 * Tests for {@link JolokiaMvcEndpoint}.
 *
 * @author Andy Wilkinson
 */
public class JolokiaMvcEndpointTests {

	private final JolokiaMvcEndpoint endpoint = new JolokiaMvcEndpoint();

	private final ServletWrappingController controller = (ServletWrappingController) spy(
			ReflectionTestUtils.getField(this.endpoint, "controller"));

	@Before
	public void before() {
		ReflectionTestUtils.setField(this.endpoint, "controller", this.controller);
	}

	@Test
	public void controllerIsDestroyed() throws Exception {
		this.endpoint.setApplicationContext(mock(WebApplicationContext.class));
		this.endpoint.setServletContext(new MockServletContext());
		this.endpoint.afterPropertiesSet();
		this.endpoint.destroy();
		assertThat(this.endpoint).isInstanceOf(DisposableBean.class);
		verify(this.controller).destroy();
	}

}
