﻿app.controller("admin_add_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    if ($stateParams.id !== "") {
        $scope.action = "编辑";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=admin&action=edit&A_id=" + $stateParams.id+"&lang="+lang, "#/app/admin_list/", $("#form").serialize(), 1, "");
        };
    } else {
        $scope.action = "新增";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=admin&action=add"+"&lang="+lang, "#/app/admin_list/", $("#form").serialize(), 1, "");
        };
    }
    $http.get("data.asp?action=admin_add&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
} ]);

app.controller("admin_list_Ctrl", [ "$scope", "$http", "$state", function($scope, $http, $state) {
    $http.get("data.asp?action=admin_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.admin_list = response.admin_list;
    });
    $scope.del = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=admin&A_id=" + id, "", "", 4, id);
        });
    };
    $scope.delall = function() {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=delall&type=admin", "", $("#form").serialize(), 4, "");
        });
    };
} ]);

app.controller("config_Ctrl", [ "$scope", "$http", "$state", "$stateParams", "$sce", function($scope, $http, $state, $stateParams, $sce) {
    $http.get("data.asp?action=config"+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $scope.save = function(lang) {
        ajaxx("ajax.asp?type=config&action=edit"+"&lang="+lang, "", $("#form").serialize(), 2, "");
    };
    $scope.mark = function(str) {
       $scope.data.C_mark = str;
    };
    $scope.settab = function(id) {
        if (id == $stateParams.id) {
            return true;
        } else {
            return "";
        }
    };
} ]);

app.controller("config2_Ctrl", [ "$scope", "$http", function($scope, $http) {
    $http.get("data.asp?action=config2"+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $scope.save = function(lang) {
        ajaxx("ajax.asp?type=config2&action=edit"+"&lang="+lang, "", $("#form").serialize(), 2, "");
    };
} ]);

app.controller("contact_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    $scope.save = function(lang) {
        ajaxx("ajax.asp?type=contact&action=edit"+"&lang="+lang, "", $("#form").serialize(), 2, "");
    };
    $http.get("data.asp?action=contact"+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
        editor.html(response.C_content);
    });
} ]);

app.controller("content_add_Ctrl", [ "$scope", "$http", "$state", "$stateParams", "$sce", function($scope, $http, $state, $stateParams, $sce) {
    if ($stateParams.id !== "") {
        $scope.action = "编辑";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=content&action=edit&C_id=" + $stateParams.id+"&lang="+lang, "#/app/form_list/", $("#form").serialize(), 1, "");
        };
    } else {
        $scope.action = "新增";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=content&action=add"+"&lang="+lang, "#/app/form_list/", $("#form").serialize(), 1, "");
        };
    }
    $http.get("data.asp?action=content_add&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $http.get("data.asp?action=form_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.form_list = response.form_list;
    });
} ]);

app.controller("file_Ctrl", [ "$scope", "$http", "$state", "$modal", "$stateParams", "$sce", function($scope, $http, $state, $modal, $stateParams, $sce) {
    $http.get("data.asp?action=file"+"&lang="+$scope.lang).success(function(response) {
        $scope.file_list = response.file_list;
    });
    $scope.do = function(str, name, id) {
        if (str == 0) {
            swal({
                title:"",
                text:"确定要删除吗？",
                type:"warning",
                showCancelButton:true
            }, function() {
                ajaxx("ajax.asp?action=del&type=file&name=" + name + "&id=" + id, "", "", 4, "");
            });
        }
    };
    $scope.use = function(str) {
        if (str == 0) {
            return "<i class='fa fa-times-circle'></i> 删除";
        } else {
            return "<i class='fa fa-check-circle'></i> 使用中";
        }
    };
    $scope.delall = function() {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=delall&type=file", "", $("#form").serialize(), 4, "");
        });
    };
    $scope.show = function(str) {
        var modalInstance = $modal.open({
            template:'<div class="modal-header"><span style="font-size:14px;">查看图片</span> <button class="btn btn-info btn-xs pull-right" ng-click="cancel()">×</button></div><div style="text-align:center;padding:10px;"><img src="../media/' + str + '" style="max-width:100%;max-height:500px;"><p>' + str + "</p></div>",
            controller:"ModalInstanceCtrl",
            size:"lg"
        });
    };
} ]);

app.controller("forgot_ctrl", [ "$scope", "$http", "$state", function($scope, $http, $state) {
    $scope.user = {};
    $scope.authError = null;
    $scope.found = function() {
        $scope.authError = null;
        // Try to login
        $http.get("ajax.asp?type=found&email=" + $scope.email+"&lang="+$scope.lang).success(function(response) {
            if (response !== "success") {
                $scope.authError = "邮箱错误！";
            } else {
                $scope.isCollapsed = !$scope.isCollapsed;
            }
        });
    };
} ]);

app.controller("form_add_Ctrl", [ "$scope", "$http", "$state", "$stateParams", "$sce", function($scope, $http, $state, $stateParams, $sce) {
    if ($stateParams.id !== "") {
        $scope.action = "编辑";
        $scope.showx = false;
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=form&action=edit&F_id=" + $stateParams.id+"&lang="+lang, "#/app/form_list/", $("#form").serialize(), 1, "");
        };
    } else {
        $scope.action = "新增";
        $scope.showx = true;
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=form&action=add"+"&lang="+lang, "#/app/form_list/", $("#form").serialize(), 1, "");
        };
    }
    $http.get("data.asp?action=form_add&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $http.get("data.asp?action=menu_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.menu_lists = response.main_menu;
    });
    $http.get("js/tags.txt").success(function(response) {
        window.keylis = response.split(",");
        window.keydrop = "";
        $("input[name='F_title']").keyup(function() {
            $("input[name='F_keywords']").val(lastIndexDemo($("input[name='F_title']").val()));
        });
    });
} ]);

app.controller("form_list_Ctrl", [ "$scope", "$http", "$state", "$stateParams", "$sce", function($scope, $http, $state, $stateParams, $sce) {
    $http.get("data.asp?action=form_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.form_list = response.form_list;
    });
    $scope.delf = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=form&F_id=" + id, "", "", 4, "f" + id);
        });
    };
    $scope.delc = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=content&C_id=" + id, "", "", 4, "c" + id);
        });
    };
    $scope.delall = function() {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=delall&type=content", "", $("#form").serialize(), 4, "");
        });
    };
    $scope.addmenu = function(id) {
        ajaxx("ajax.asp?action=addmenu&type=form&F_id=" + id, "", "", 2, id);
    };
    $scope.save = function(lang) {
        ajaxx("ajax.asp?action=save&type=form"+"&lang="+lang, "", $("#form").serialize(), 2, "");
    };
    $scope.creat = function(id) {
        ajaxx("ajax.asp?action=creat&type=form&F_id=" + id, "excel/" + id + ".xls", $("#form").serialize(), 1, "");
    };
} ]);

app.controller("guestbook_Ctrl", [ "$scope", "$http", "$state", function($scope, $http, $state) {
    $http.get("data.asp?action=guestbook"+"&lang="+$scope.lang).success(function(response) {
        $scope.guestbook = response.guestbook;
    });
    $scope.del = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=guestbook&G_id=" + id, "", "", 4, id);
        });
    };
    $scope.delall = function() {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=delall&type=guestbook", "", $("#form").serialize(), 4, "");
        });
    };
} ]);

app.controller("index_Ctrl", [ "$scope", "$http", function($scope, $http) {
    $http.get("data.asp?action=config"+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $scope.ismobile = function() {
        try {
            var urlhash = window.location.hash;
            if (!urlhash.match("fromapp")) {
                if (navigator.userAgent.match(/(iPhone|iPod|Android|ios|iPad)/i)) {
                    return true;
                }
            }
        } catch (err) {}
    };
    $scope.del = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=guestbook&G_id=" + id, "", "", 4, id);
        });
    };
    $http.get("data.asp?action=index_message"+"&lang="+$scope.lang).success(function(response) {
        $scope.messages = response.message;
    });
    $http.get("data.asp?action=index_orders"+"&lang="+$scope.lang).success(function(response) {
        $scope.orders = response.orders;
    });
    $http.get("data.asp?action=index_member"+"&lang="+$scope.lang).success(function(response) {
        $scope.member = response.member;
    });
    $http.get("data.asp?action=index_file"+"&lang="+$scope.lang).success(function(response) {
        $scope.files = response.files;
    });
} ]);

app.controller("link_add_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    if ($stateParams.id !== "") {
        $scope.action = "编辑";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=link&action=edit&L_id=" + $stateParams.id+"&lang="+lang, "#/app/link_list/", $("#form").serialize(), 1, "");
        };
    } else {
        $scope.action = "新增";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=link&action=add"+"&lang="+lang, "#/app/link_list/", $("#form").serialize(), 1, "");
        };
    }
    $http.get("data.asp?action=link_add&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.datax = response;
    });
} ]);

app.controller("link_list_Ctrl", [ "$scope", "$http", "$state", function($scope, $http, $state) {
    $http.get("data.asp?action=link_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.link_list = response.link_list;
    });
    $scope.del = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=link&L_id=" + id, "", "", 4, id);
        });
    };
    $scope.delall = function() {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=delall&type=link", "", $("#form").serialize(), 4, "");
        });
    };
    $scope.save = function(lang) {
        ajaxx("ajax.asp?action=save&type=link"+"&lang="+lang, "", $("#form").serialize(), 2, "");
    };
} ]);

app.controller("lv_Ctrl", [ "$scope", "$http", "$state", function($scope, $http, $state) {
    $http.get("data.asp?action=lv_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.lv_list = response.lv_list;
    });
    $http.get("data.asp?action=fen_add"+"&lang="+$scope.lang).success(function(response) {
        $scope.data2 = response;
    });
    $http.get("data.asp?action=fen_use"+"&lang="+$scope.lang).success(function(response) {
        $scope.data3 = response;
    });
    $scope.del = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=lv&L_id=" + id, "", "", 4, id);
        });
    };
    $scope.delall = function() {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=delall&type=lv", "", $("#form").serialize(), 4, "");
        });
    };
    $scope.save = function(lang) {
        ajaxx("ajax.asp?action=save&type=lv"+"&lang="+lang, "", $("#form").serialize(), 2, "");
    };
    $scope.save2 = function(lang) {
        ajaxx("ajax.asp?action=save2&type=lv"+"&lang="+lang, "", $("#form2").serialize(), 2, "");
    };
    $scope.save3 = function(lang) {
        ajaxx("ajax.asp?action=save3&type=lv"+"&lang="+lang, "", $("#form3").serialize(), 2, "");
    };
} ]);

app.controller("lv_add_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    if ($stateParams.id !== "") {
        $scope.action = "编辑";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=lv&action=edit&L_id=" + $stateParams.id+"&lang="+lang, "#/app/lv/", $("#form").serialize(), 1, "");
        };
    } else {
        $scope.action = "新增";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=lv&action=add"+"&lang="+lang, "#/app/lv/", $("#form").serialize(), 1, "");
        };
    }
    $http.get("data.asp?action=lv_add&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
} ]);

app.controller("m_config_Ctrl", [ "$scope", "$http", function($scope, $http) {
    $http.get("data.asp?action=m_config"+"&lang="+$scope.lang).success(function(response) {
        $scope.datax = response;
    });
    $scope.save = function(lang) {
        ajaxx("ajax.asp?type=m_config&action=edit"+"&lang="+lang, "", $("#form").serialize(), 2, "");
    };
} ]);

app.controller("m_config2_Ctrl", [ "$scope", "$http", function($scope, $http) {
    $http.get("data.asp?action=m_config2"+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $scope.save = function(lang) {
        ajaxx("ajax.asp?type=m_config2&action=edit"+"&lang="+lang, "", $("#form").serialize(), 2, "");
    };
} ]);

app.controller("m_slide_add_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    if ($stateParams.id !== "") {
        $scope.action = "编辑";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=m_slide&action=edit&S_id=" + $stateParams.id+"&lang="+lang, "#/app/m_slide_list/", $("#form").serialize(), 1, "");
        };
    } else {
        $scope.action = "新增";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=m_slide&action=add"+"&lang="+lang, "#/app/m_slide_list/", $("#form").serialize(), 1, "");
        };
    }
    $http.get("data.asp?action=m_slide_add&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $http.get("data.asp?action=psort_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.psort_lists = response.psort_lists;
    });
} ]);

app.controller("m_slide_list_Ctrl", [ "$scope", "$http", "$state", function($scope, $http, $state) {
    $http.get("data.asp?action=m_slide_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.slide_list = response.slide_list;
    });
    $scope.del = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=m_slide&S_id=" + id, "", "", 4, id);
        });
    };
    $scope.delall = function() {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=delall&type=m_slide", "", $("#form").serialize(), 4, "");
        });
    };
    $scope.save = function(lang) {
        ajaxx("ajax.asp?action=save&type=m_slide"+"&lang="+lang, "", $("#form").serialize(), 2, "");
    };
} ]);

app.controller("member_add_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    if ($stateParams.id !== "") {
        $scope.action = "编辑";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=member&action=edit&M_id=" + $stateParams.id+"&lang="+lang, "#/app/member_list/", $("#form").serialize(), 1, "");
        };
    } else {
        $scope.action = "新增";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=member&action=add"+"&lang="+lang, "#/app/member_list/", $("#form").serialize(), 1, "");
        };
    }
    $http.get("data.asp?action=member_add&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
} ]);

app.controller("member_list_Ctrl", [ "$scope", "$http", "$state", function($scope, $http, $state) {
    $http.get("data.asp?action=member_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.member_list = response.member_list;
    });
    $scope.del = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=member&M_id=" + id, "", "", 4, id);
        });
    };
    $scope.delall = function() {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=delall&type=member", "", $("#form").serialize(), 4, "");
        });
    };
} ]);

app.controller("menu_add_Ctrl", [ "$scope", "$modal","$http", "$state", "$stateParams", function($scope, $modal,$http, $state, $stateParams) {
    if ($stateParams.id !== "") {
        $scope.action = "编辑";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=menu&action=edit&U_id=" + $stateParams.id+"&lang="+lang, "#/app/menu_list/", $("#form").serialize(), 1, "");
        };
    } else {
        $scope.action = "新增";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=menu&action=add"+"&lang="+lang, "#/app/menu_list/", $("#form").serialize(), 1, "");
        };
    }
     $scope.change = function(str) {
        if(str=="link/1"){
            $scope.data.U_link=1;
            $scope.data.t_all="";
        }else{
            $scope.data.U_link=0;
            $scope.data.U_url="";
            $http.get("data.asp?action=menu_html&html="+str+"&lang="+$scope.lang).success(function(response) {
            $scope.data.t_all = response.t_all;
            });
        }
     }
     $scope.showmore = function(template) {
            var modalInstance = $modal.open({
                template:'<div class="modal-header"><span style="font-size:14px;">新建模块</span> <button class="btn btn-info btn-xs pull-right" ng-click="cancel()">×</button></div><div style="padding:20px"><p>没有合适的模块？新建一个</p><p><button class="btn btn-info" ng-click="goto(\'text_add\')">简介（单页图文）</button> <button class="btn btn-info" ng-click="goto(\'nsort_add\')">新闻（列表+多页图文）</button></p><p><button class="btn btn-info" ng-click="goto(\'psort_add\')">产品（列表+多页图文）</button> <button class="btn btn-info" ng-click="goto(\'form_add\')">表单（万能表单 单页）</button></p></div>',
                controller:"ModalInstanceCtrl",
                size:""
            });
    };
    $http.get("data.asp?action=menu_add&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $http.get("data.asp?action=module"+"&lang="+$scope.lang).success(function(response) {
        $scope.modules = response.modules;
    });
} ]);

app.controller("menu_list_Ctrl", [ "$scope", "$http", "$state", function($scope, $http, $state) {
    $http.get("data.asp?action=menu_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.main_menu = response.main_menu;
    });
    $scope.del = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=menu&U_id=" + id, "", "", 4, id);
        });
    };
    $scope.save = function(lang) {
        ajaxx("ajax.asp?action=save&type=menu"+"&lang="+lang, "", $("#form").serialize(), 2, "");
    };
    $scope.delall = function() {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=delall&type=menu", "", $("#form").serialize(), 4, "");
        });
    };
} ]);

app.controller("news_add_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    if ($stateParams.id !== "") {
        $scope.action = "编辑";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=news&action=edit&N_id=" + $stateParams.id+"&lang="+lang, "#/app/news_list///", $("#form").serialize(), 1, "");
        };
    } else {
        $scope.action = "新增";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=news&action=add"+"&lang="+lang, "#/app/news_list///", $("#form").serialize(), 1, "");
        };
    }
    $http.get("data.asp?action=news_add&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
        editor.html(response.N_content);
    });
    $http.get("data.asp?action=nsort_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.nsort_list = response.nsort_list;
    });
    $http.get("data.asp?action=lv_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.lv_list = response.lv_list;
    });
    $http.get("js/tags.txt").success(function(response) {
        window.keylis = response.split(",");
        window.keydrop = "";
        $("input[name='N_title']").keyup(function() {
            $("input[name='N_keywords']").val(lastIndexDemo($("input[name='N_title']").val()));
        });
    });
} ]);

app.controller("news_list_Ctrl", [ "$scope", "$http", "$state", "$stateParams", "$sce", function($scope, $http, $state, $stateParams, $sce) {
    $http.get("data.asp?action=news_list&id=" + $stateParams.id + "&page=" + $stateParams.page+"&lang="+$scope.lang).success(function(response) {
        $scope.news_list = response.news_list;
        $scope.count = response.count;
        $scope.pageSize = 10;
        $scope.pages = Math.ceil($scope.count / $scope.pageSize);
        //分页数
        $scope.newPages = $scope.pages > 10 ? 10 :$scope.pages;
        $scope.pageList = [];
        $scope.selPage = $stateParams.page || 1;
        $scope.isActivePage($stateParams.page || 1);
        if (($scope.selPage - 1) * 10 + 11 > $scope.count) {
            $scope.list2 = $scope.count;
        } else {
            $scope.list2 = ($scope.selPage - 1) * 10 + 11;
        }
        for (var i = 0; i < $scope.newPages; i++) {
            $scope.pageList.push(i + 1);
        }
        $scope.selectPage = function(page) {
            if (page < 1 || page > $scope.pages) return;
            if (page > 2) {
                var newpageList = [];
                for (var i = page - 3; i < (page + 2 > $scope.pages ? $scope.pages :page + 2); i++) {
                    newpageList.push(i + 1);
                }
                $scope.pageList = newpageList;
            }
            window.location = "#/app/news_list/" + $stateParams.id + "/" + page + "/";
        };
    });
    $http.get("data.asp?action=nsort_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.nsort_list = response.nsort_list;
    });
    $scope.isActivePage = function(page) {
        return $scope.selPage == page;
    };
    $scope.Previous = function() {
        $scope.selectPage($scope.selPage - 1);
    };
    $scope.Next = function() {
        $scope.selectPage(parseInt($scope.selPage) + 1);
    };
    $scope.del = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=news&N_id=" + id, "", "", 4, id);
        });
    };
    $scope.delall = function() {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=delall&type=news", "", $("#form").serialize(), 4, "");
        });
    };
    $scope.save = function(lang) {
        ajaxx("ajax.asp?action=save&type=news"+"&lang="+lang, "", $("#form").serialize(), 2, "");
    };
} ]);

app.controller("nsort_add_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    if ($stateParams.id !== "") {
        $scope.action = "编辑";
        $scope.showx = false;
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=nsort&action=edit&S_id=" + $stateParams.id+"&lang="+lang, "#/app/nsort_list/", $("#form").serialize(), 1, "");
        };
    } else {
        $scope.action = "新增";
        $scope.showx = true;
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=nsort&action=add"+"&lang="+lang, "#/app/nsort_list/", $("#form").serialize(), 1, "");
        };
    }
    $http.get("data.asp?action=nsort_add&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $http.get("data.asp?action=menu_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.menu_lists = response.main_menu;
    });
    $http.get("js/tags.txt").success(function(response) {
        window.keylis = response.split(",");
        window.keydrop = "";
        $("input[name='S_title']").keyup(function() {
            $("input[name='S_keywords']").val(lastIndexDemo($("input[name='S_title']").val()));
        });
    });
} ]);

app.controller("nsort_list_Ctrl", [ "$scope", "$http", "$state", function($scope, $http, $state) {
    $http.get("data.asp?action=nsort_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.nsort_list = response.nsort_list;
    });
    $scope.del = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=nsort&S_id=" + id, "", "", 4, id);
        });
    };
    $scope.addmenu = function(id) {
        ajaxx("ajax.asp?action=addmenu&type=nsort&S_id=" + id, "", "", 2, id);
    };
    $scope.delall = function() {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=delall&type=nsort", "", $("#form").serialize(), 4, "");
        });
    };
    $scope.save = function(lang) {
        ajaxx("ajax.asp?action=save&type=nsort"+"&lang="+lang, "", $("#form").serialize(), 2, "");
    };
} ]);

app.controller("order_list_Ctrl", [ "$scope", "$http", "$state", "$sce", function($scope, $http, $state, $sce) {
    $http.get("data.asp?action=order_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.order_list = response.order_list;
    });
    $scope.del = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=order&O_id=" + id, "", "", 4, id);
        });
    };
    $scope.delall = function() {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=delall&type=order", "", $("#form").serialize(), 4, "");
        });
    };
    $scope.save = function(lang) {
        ajaxx("ajax.asp?action=save&type=order"+"&lang="+lang, "#/app/order_list/" + Date.parse(new Date()), $("#form").serialize(), 1, "");
    };
} ]);

app.controller("plug_Ctrl", [ "$scope", "$http", "$state", "$stateParams", "$modal", function($scope, $http, $state, $stateParams, $modal) {
    $http.get("data.asp?action=plug"+"&lang="+$scope.lang).success(function(response) {
        $http.jsonp("http://www.s-cms.cn/scms/p_json.asp?type=pc&domain=" + response.domain + "&url=" + response.url + "&callback=JSON_CALLBACK").success(function(msg) {
            $scope.plug = msg.list;
        });
        $scope.click = function(str, name, T_type) {
            if (str == 0) {
                var modalInstance = $modal.open({
                    template:'<div class="modal-header"><span style="font-size:14px;">购买插件</span> <button class="btn btn-info btn-xs pull-right" ng-click="cancel()">×</button></div><iframe src="http://www.s-cms.cn/payx?domain=' + response.domain + "&product=" + name + "&url=" + response.url + '" type="1" frameborder="0" height="600" width="100%"></iframe>',
                    controller:"ModalInstanceCtrl",
                    size:"lg"
                });
            }
        };
    });
    $scope.button = function(str) {
        if (str == 1) {
            return "<i class='fa fa-check-circle'></i> 已购买";
        }
        if (str == 0) {
            return "<i class='fa fa-shopping-cart'></i> 购买";
        }
    };
} ]);

app.controller("product_add_Ctrl", [ "$scope", "$http", "$state", "$stateParams", "$sce", function($scope, $http, $state, $stateParams, $sce) {
    if ($stateParams.id !== "") {
        $scope.action = "编辑";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=product&action=edit&P_id=" + $stateParams.id+"&lang="+lang, "#/app/product_list///", $("#form").serialize(), 1, "");
        };
    } else {
        $scope.action = "新增";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=product&action=add"+"&lang="+lang, "#/app/product_list///", $("#form").serialize(), 1, "");
        };
    }
    $http.get("data.asp?action=product_add&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
        editor.html(response.P_content);
    });
    $http.get("data.asp?action=psort_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.psort_lists = response.psort_lists;
    });
    $http.get("js/tags.txt").success(function(response) {
        window.keylis = response.split(",");
        window.keydrop = "";
        $("input[name='P_title']").keyup(function() {
            $("input[name='P_keywords']").val(lastIndexDemo($("input[name='P_title']").val()));
        });
    });
} ]);
app.controller("product_excel_Ctrl", [ "$scope", "$http", "$state", "$stateParams", "$sce", function($scope, $http, $state, $stateParams, $sce) {
    $scope.excel = function() {
            ajaxx("ajax.asp?type=product&action=excel", "#/app/product_list///", $("#form").serialize(), 1, "");
        };
} ]);
app.controller("product_add2_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    $http.get("data.asp?action=psort_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.psort_lists = response.psort_lists;
    });
} ]);
app.controller("product_list_Ctrl", [ "$scope", "$http", "$state", "$stateParams", "$sce", function($scope, $http, $state, $stateParams, $sce) {
    $http.get("data.asp?action=product_list&id=" + $stateParams.id + "&page=" + $stateParams.page+"&lang="+$scope.lang).success(function(response) {
        $scope.product_list = response.product_list;
        $scope.count = response.count;
        $scope.pageSize = 10;
        $scope.pages = Math.ceil($scope.count / $scope.pageSize);
        $scope.newPages = $scope.pages > 10 ? 10 :$scope.pages;
        $scope.pageList = [];
        $scope.selPage = $stateParams.page || 1;
        $scope.isActivePage($stateParams.page || 1);
        if (($scope.selPage - 1) * 10 + 11 > $scope.count) {
            $scope.list2 = $scope.count;
        } else {
            $scope.list2 = ($scope.selPage - 1) * 10 + 11;
        }
        for (var i = 0; i < $scope.newPages; i++) {
            $scope.pageList.push(i + 1);
        }
        $scope.selectPage = function(page) {
            if (page < 1 || page > $scope.pages) return;
            if (page > 2) {
                var newpageList = [];
                for (var i = page - 3; i < (page + 2 > $scope.pages ? $scope.pages :page + 2); i++) {
                    newpageList.push(i + 1);
                }
                $scope.pageList = newpageList;
            }
            window.location = "#/app/product_list/" + $stateParams.id + "/" + page + "/";
        };
    });
    $http.get("data.asp?action=psort_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.psort_lists = response.psort_lists;
    });
    $scope.isActivePage = function(page) {
        return $scope.selPage == page;
    };
    $scope.Previous = function() {
        $scope.selectPage($scope.selPage - 1);
    };
    $scope.Next = function() {
        $scope.selectPage(parseInt($scope.selPage) + 1);
    };
    $scope.del = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=product&P_id=" + id, "", "", 4, id);
        });
    };
    $scope.delall = function() {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=delall&type=product", "", $("#form").serialize(), 4, "");
        });
    };
    $scope.save = function(lang) {
        ajaxx("ajax.asp?action=save&type=product"+"&lang="+lang, "", $("#form").serialize(), 2, "");
    };
} ]);

app.controller("psort_add_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    if ($stateParams.id !== "") {
        $scope.action = "编辑";
        $scope.showx = false;
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=psort&action=edit&S_id=" + $stateParams.id+"&lang="+lang, "#/app/psort_list/", $("#form").serialize(), 1, "");
        };
    } else {
        $scope.action = "新增";
        $scope.showx = true;
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=psort&action=add"+"&lang="+lang, "#/app/psort_list/", $("#form").serialize(), 1, "");
        };
    }
    $http.get("data.asp?action=psort_add&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $http.get("data.asp?action=psort_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.psort_lists = response.psort_lists;
    });
    $http.get("data.asp?action=menu_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.menu_lists = response.main_menu;
    });
    $http.get("js/tags.txt").success(function(response) {
        window.keylis = response.split(",");
        window.keydrop = "";
        $("input[name='S_title']").keyup(function() {
            $("input[name='S_keywords']").val(lastIndexDemo($("input[name='S_title']").val()));
        });
    });
} ]);

app.controller("psort_list_Ctrl", [ "$scope", "$http", "$state", function($scope, $http, $state) {
    $http.get("data.asp?action=psort_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.psort_lists = response.psort_lists;
    });
    $scope.del = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=psort&S_id=" + id, "", "", 4, id);
        });
    };
    $scope.addmenu = function(id) {
        ajaxx("ajax.asp?action=addmenu&type=psort&S_id=" + id, "", "", 2, id);
    };
    $scope.delall = function() {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=delall&type=psort", "", $("#form").serialize(), 4, "");
        });
    };
    $scope.save = function(lang) {
        ajaxx("ajax.asp?action=save&type=psort"+"&lang="+lang, "", $("#form").serialize(), 2, "");
    };
} ]);

app.controller("reply_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    $scope.save = function(lang) {
        ajaxx("ajax.asp?type=guestbook&action=reply&G_id=" + $stateParams.id+"&lang="+lang, "#/app/guestbook/", $("#form").serialize(), 1, "");
    };
    $http.get("data.asp?action=reply&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
} ]);

app.controller("response_list_Ctrl", [ "$scope", "$http", "$state", "$stateParams", "$sce", function($scope, $http, $state, $stateParams, $sce) {
    $http.get("data.asp?action=response_list&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $scope.del = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=response&R_rid=" + id, "", "", 4, id);
        });
    };
} ]);

function delx(id) {
    swal({
        title:"",
        text:"确定要删除吗？",
        type:"warning",
        showCancelButton:true
    }, function() {
        ajaxx("ajax.asp?action=del&type=response&R_rid=" + id, "", "", 4, id);
    });
}

function readx(id) {
    ajaxx("ajax.asp?action=read&type=response&R_rid=" + id, "", "", 2, id);
    $("#" + id).html("已审核");
}

app.controller("safe_Ctrl", [ "$scope", "$http", "$state", "$stateParams", "$sce", function($scope, $http, $state, $stateParams, $sce) {
    $http.get("data.asp?action=safe"+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $scope.save = function(lang) {
        ajaxx("ajax.asp?type=safe&action=edit"+"&lang="+lang, "", $("#form").serialize(), 2, "");
    };
} ]);

app.controller("search_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    $http.get("data.asp?action=search&key=" + $stateParams.key+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $scope.hide = function(str) {
        if (str == 0) {
            return false;
        } else {
            return true;
        }
    };
} ]);

app.controller("send_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    $http.get("data.asp?action=send&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $scope.send = function() {
        ajaxx("ajax.asp?action=send&type=order", "#/app/order_list/", $("#form").serialize(), 1, "");
    };
} ]);

app.controller("SigninFormController", [ "$scope", "$http", "$state", function($scope, $http, $state) {
    $scope.user = {};
    $scope.authError = null;
    $scope.login = function() {
        $scope.authError = null;
        // Try to login
        $http.get("ajax.asp?type=login&user=" + $scope.user.email + "&password=" + $scope.user.password).success(function(response) {
            if (response !== "success") {
                $scope.authError = "用户名或密码错误！";
            } else {
                $state.go("app.index");
            }
        });
    };
} ]);

app.controller("sitemap_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    $http.get("data.asp?action=sitemap"+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $scope.save = function(lang) {
        ajaxx("ajax.asp?type=sitemap&action=creat"+"&lang="+lang, "", $("#form").serialize(), 2, "");
        $scope.showsitemap = true;
    };
} ]);

app.controller("slide_add_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    if ($stateParams.id !== "") {
        $scope.action = "编辑";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=slide&action=edit&S_id=" + $stateParams.id+"&lang="+lang, "#/app/slide_list/", $("#form").serialize(), 1, "");
        };
    } else {
        $scope.action = "新增";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=slide&action=add"+"&lang="+lang, "#/app/slide_list/", $("#form").serialize(), 1, "");
        };
    }
    $http.get("data.asp?action=slide_add&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $http.get("data.asp?action=psort_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.psort_lists = response.psort_lists;
    });
} ]);

app.controller("slide_list_Ctrl", [ "$scope", "$http", "$state", function($scope, $http, $state) {
    $http.get("data.asp?action=slide_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.slide_list = response.slide_list;
    });
    $scope.del = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=slide&S_id=" + id, "", "", 4, id);
        });
    };
    $scope.delall = function() {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=delall&type=slide", "", $("#form").serialize(), 4, "");
        });
    };
    $scope.save = function(lang) {
        ajaxx("ajax.asp?action=save&type=slide"+"&lang="+lang, "", $("#form").serialize(), 2, "");
    };
} ]);

app.controller("space_Ctrl", [ "$scope", "$http", "$state", "$stateParams", "$sce", function($scope, $http, $state, $stateParams, $sce) {
    $http.get("data.asp?action=space"+"&lang="+$scope.lang).success(function(response) {
        $scope.file_list = response.file_list;
        $scope.size_all = response.size_all;
    });
} ]);

app.controller("template_all_Ctrl", [ "$scope", "$http", "$state", "$stateParams", "$modal", function($scope, $http, $state, $stateParams, $modal) {
    $http.get("data.asp?action=template_all"+"&lang="+$scope.lang).success(function(response) {
        $http.jsonp("http://www.s-cms.cn/scms/t_json.asp?type=pc&domain=" + response.domain + "&S_id=" + $stateParams.x + "&url=" + response.url + "&folder=" + response.t_folder + "&callback=JSON_CALLBACK").success(function(msg) {
            $scope.pc = msg.list;
        });
        $http.jsonp("http://www.s-cms.cn/scms/t_json.asp?type=wap&domain=" + response.domain + "&url=" + response.url + "&folder=" + response.w_folder + "&callback=JSON_CALLBACK").success(function(msg) {
            $scope.wap = msg.list;
        });
        $http.jsonp("http://www.s-cms.cn/scms/tsort.asp?callback=JSON_CALLBACK").success(function(msg) {
            $scope.tsort = msg.tsort;
        });
        $scope.click = function(str, name, T_type) {
            if (str == 1) {}
            if (str == 2) {
                ajaxx("ajax.asp?type=template&action=down&T_id=" + name, "#/app/template_list/", $("#form").serialize(), 1, "");
            }
            if (str == 3) {
                var modalInstance = $modal.open({
                    template:'<div class="modal-header"><span style="font-size:14px;">购买模板</span> <button class="btn btn-info btn-xs pull-right" ng-click="cancel()">×</button></div><iframe src="http://www.s-cms.cn/payx?domain=' + response.domain + "&product=" + name + "&url=" + response.url + '" type="1" frameborder="0" height="600" width="100%"></iframe>',
                    controller:"ModalInstanceCtrl",
                    size:"lg"
                });
            }
        };
    });
    $scope.isactive = function(str) {
        if(str==$stateParams.x){
            return true;
        }else{
            return false;
        }

    }
    $scope.button = function(str) {
        if (str == 1) {
            return "<i class='fa fa-check-circle'></i> 已安装";
        }
        if (str == 2) {
            return "<i class='fa fa-cloud-download'></i> 下载";
        }
        if (str == 3) {
            return "<i class='fa fa-shopping-cart'></i> 购买";
        }
    };
} ]);

app.controller("template_edit_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    $scope.save = function(lang) {
        ajaxx("ajax.asp?type=template&action=edit"+"&lang="+lang, "", $("#form").serialize(), 2, "");
    };
    $http.get("data.asp?action=template_edit&T_id=" + $stateParams.id + "&name=" + $stateParams.name+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
        $scope.T_html = response.T_html;
    });
} ]);

app.controller("template_html_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    $http.get("data.asp?action=template_html&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
} ]);

app.controller("template_html_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    $http.get("data.asp?action=template_html&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
} ]);

app.controller("template_list_Ctrl", [ "$scope", "$http", "$state", "$stateParams", "$modal", function($scope, $http, $state, $stateParams, $modal) {
    $http.get("data.asp?action=template_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.template_list = response.template_list;
    });
    $http.get("data.asp?action=wap_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.wap_list = response.wap_list;
    });
    $http.get("data.asp?action=config"+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $scope.del = function(id, typex) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=template&T_id=" + id + "&typex=" + typex, "", "", 4, id);
        });
    };
    $scope.sql = function(id) {
        swal({
            title:"",
            text:"导入模板数据将覆盖部分现有数据，是否导入？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=sql&type=template&T_id=" + id, "", "", 2,"");
        });
    };
    $scope.save = function(typex,id) {
        ajaxx("ajax.asp?type=template&action=save&typex=" + typex, "", $("#" + typex).serialize(), 2, "");
        $scope.data.C_template = id;
    };
    $scope.readme = function(template) {
        $http.get("data.asp?action=readme&id=" + template+"&lang="+$scope.lang).success(function(response) {
            var modalInstance = $modal.open({
                template:'<div class="modal-header"><span style="font-size:14px;">模板信息</span> <button class="btn btn-info btn-xs pull-right" ng-click="cancel()">×</button></div><div style="padding:20px">' + response + "</div>",
                controller:"ModalInstanceCtrl",
                size:"lg"
            });
        });
    };
} ]);

app.controller("text_add_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    if ($stateParams.id !== "") {
        $scope.action = "编辑";
        $scope.showx = false;
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=text&action=edit&T_id=" + $stateParams.id+"&lang="+lang, "#/app/text_list/", $("#form").serialize(), 1, "");
        };
    } else {
        $scope.action = "新增";
        $scope.showx = true;
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=text&action=add"+"&lang="+lang, "#/app/text_list/", $("#form").serialize(), 1, "");
        };
    }
    $http.get("data.asp?action=menu_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.menu_lists = response.main_menu;
    });
    $http.get("data.asp?action=text_add&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
        editor.html(response.T_content);
    });
    $http.get("js/tags.txt").success(function(response) {
        window.keylis = response.split(",");
        window.keydrop = "";
        $("input[name='T_title']").keyup(function() {
            $("input[name='T_keywords']").val(lastIndexDemo($("input[name='T_title']").val()));
        });
    });
} ]);

app.controller("text_list_Ctrl", [ "$scope", "$http", "$state", function($scope, $http, $state) {
    $http.get("data.asp?action=text_list"+"&lang="+$scope.lang).success(function(response) {
        $scope.text_list = response.text_list;
    });
    $scope.del = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=text&T_id=" + id, "", "", 4, id);
        });
    };
    $scope.addmenu = function(id) {
        ajaxx("ajax.asp?action=addmenu&type=text&T_id=" + id, "", "", 2, id);
    };
    $scope.delall = function() {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=delall&type=text", "", $("#form").serialize(), 4, "");
        });
    };
    $scope.save = function(lang) {
        ajaxx("ajax.asp?action=save&type=text"+"&lang="+lang, "", $("#form").serialize(), 2, "");
    };
} ]);

app.controller("tk_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    $http.get("data.asp?action=send&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $scope.tk = function(action) {
        ajaxx("ajax.asp?action=" + action + "&type=order&O_id=" + $stateParams.id, "#/app/order_list/", "", 1, "");
    };
} ]);

app.controller("tohtml_Ctrl", [ "$scope", "$http", "$state", function($scope, $http, $state) {
    $scope.creat = function(id) {
        ajaxx("ajax.asp?action=creat&type=tohtml&T_id=" + id, "", "", 2, id);
    };
} ]);

app.controller("w_config_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    $scope.save = function(lang) {
        ajaxx("ajax.asp?type=w_config&action=edit"+"&lang="+lang, "#/app/text_list/", $("#form").serialize(), 2, "");
    };
    $http.get("data.asp?action=w_config"+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
} ]);

app.controller("w_event_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    $http.get("data.asp?action=w_event"+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $scope.del = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=w_event&E_id=" + id, "", "", 4, id);
        });
    };
} ]);

app.controller("w_event_add_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    if ($stateParams.id !== "") {
        $scope.action = "编辑";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=w_event&action=edit&E_id=" + $stateParams.id+"&lang="+lang, "#/app/w_event", $("#form").serialize(), 1, "");
        };
    } else {
        $scope.action = "新增";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=w_event&action=add"+"&lang="+lang, "#/app/w_event", $("#form").serialize(), 1, "");
        };
    }
    $http.get("data.asp?action=w_event_add&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $scope.isSelected3 = function(str1, str2) {
        str1 = "," + str1 + ",";
        str2 = "," + str2 + ",";
        if (str1.indexOf(str2) >= 0) {
            return true;
        } else {
            return false;
        }
    };
} ]);

app.controller("w_member_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    $http.get("data.asp?action=w_msg"+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
} ]);

app.controller("w_menu_Ctrl", [ "$scope", "$http", "$state", function($scope, $http, $state) {
    $http.get("data.asp?action=w_menu"+"&lang="+$scope.lang).success(function(response) {
        $scope.main_menu = response.menu_list;
    });
    $scope.del = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=w_menu&W_id=" + id, "", "", 4, id);
        });
    };
    $scope.save = function(lang) {
        ajaxx("ajax.asp?action=save&type=w_menu"+"&lang="+lang, "", $("#form").serialize(), 2, "");
    };
    $scope.send = function() {
        ajaxx("ajax.asp?action=send&type=w_menu", "", $("#form").serialize(), 2, "");
    };
} ]);

app.controller("w_menu_add_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    if ($stateParams.id !== "") {
        $scope.action = "编辑";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=w_menu&action=edit&W_id=" + $stateParams.id+"&lang="+lang, "#/app/w_menu", $("#form").serialize(), 1, "");
        };
    } else {
        $scope.action = "新增";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=w_menu&action=add"+"&lang="+lang, "#/app/w_menu", $("#form").serialize(), 1, "");
        };
    }
    $http.get("data.asp?action=w_menu_add&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $http.get("data.asp?action=w_menu"+"&lang="+$scope.lang).success(function(response) {
        $scope.menu = response.menu_list;
    });
    $http.get("data.asp?action=w_reply"+"&lang="+$scope.lang).success(function(response) {
        $scope.event = response.event;
    });
} ]);

app.controller("w_msg_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    $http.get("data.asp?action=w_msg"+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $scope.send = function() {
        ajaxx("ajax.asp?action=send&type=w_msg", "", $("#form").serialize(), 2, "");
    };
} ]);

app.controller("w_reply_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    $http.get("data.asp?action=w_reply"+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $scope.del = function(id) {
        swal({
            title:"",
            text:"确定要删除吗？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?action=del&type=w_reply&R_id=" + id, "", "", 4, id);
        });
    };
    $scope.sub = function() {
        ajaxx("ajax.asp?type=w_reply&action=sub", "", $("#form").serialize(), 2, "");
    };
} ]);

app.controller("w_reply_add_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    if ($stateParams.id !== "") {
        $scope.action = "编辑";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=w_reply&action=edit&R_id=" + $stateParams.id+"&lang="+lang, "#/app/w_reply", $("#form").serialize(), 1, "");
        };
    } else {
        $scope.action = "新增";
        $scope.save = function(lang) {
            ajaxx("ajax.asp?type=w_reply&action=add"+"&lang="+lang, "#/app/w_reply", $("#form").serialize(), 1, "");
        };
    }
    $http.get("data.asp?action=w_reply_add&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $http.get("data.asp?action=w_reply"+"&lang="+$scope.lang).success(function(response) {
        $scope.event = response.event;
    });
} ]);

app.controller("wuliu_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    $http.get("data.asp?action=wuliu&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.data = response;
    });
    $http.get("data.asp?action=wl_list&id=" + $stateParams.id+"&lang="+$scope.lang).success(function(response) {
        $scope.wl = response;
    });
} ]);
app.controller("sql_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    $scope.sql = function() {
            ajaxx("ajax.asp?type=sql&action=sql", "", $("#form").serialize(), 2, "");
        };

} ]);
app.controller("data_Ctrl", [ "$scope", "$http", "$state", "$stateParams", function($scope, $http, $state, $stateParams) {
    $scope.dataup = function() {

        swal({
            title:"",
            text:"导入数据将覆盖网站原有数据，是否继续？",
            type:"warning",
            showCancelButton:true
        }, function() {
            ajaxx("ajax.asp?type=data&action=dataup", "", $("#form").serialize(), 2, "");
        });
        };
    $scope.datadown = function() {
            ajaxx("ajax.asp?type=data&action=datadown", "", $("#form2").serialize(), 2, "");
            $scope.showsql=true;
        };
    $scope.download = function(str) {
        $scope.showsql=false;
        window.location="download.asp?DownName=../backup/"+str+".txt";
        };

} ]);