function [] = pslaunch()
%PSLAUNCH    Launch Photoshop or attach to an already running Photoshop.
%   If Photoshop is already running, it will attach, otherwise it will 
%   launch Photoshop. This routine does not need to be called, as the 
%   library will do the above logic when you use any of the other Photoshop
%   routines.
%
%   Example:
%   pslaunch()
%
%   See also PSQUIT, PSJAVASCRIPT, PSCONFIG

%   Thomas Ruark, 12/14/2005
%   Copyright 2005 Adobe Systems Incorporated

% load our worker library
if ~libisloaded('psmatlab')
    if isunix
        loadlibrary('psmatlab.dylib', @psproto);
    else
        loadlibrary('psmatlab', @psproto);
    end
end

try
	calllib('psmatlab', 'pslaunch');
catch
    error('Photoshop appears to be unable to take commands.');
end


