/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.facet.ui.internal;

import com.genuitec.eclipse.core.util.InitException;
import com.genuitec.eclipse.j2eedt.facet.ui.FacetConfigurationCheckBox;
import com.genuitec.eclipse.j2eedt.facet.ui.FacetConfigurationCombo;
import com.genuitec.eclipse.j2eedt.facet.ui.FacetsConfigurationGroup;
import com.genuitec.eclipse.j2eedt.facet.ui.internal.GenericFacetInstallationManagerImpl;
import com.genuitec.eclipse.j2eedt.ui.J2EEUICore;
import com.genuitec.eclipse.runtime.internal.RuntimeManagerImpl;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.project.facet.ProductManager;
import org.osgi.framework.Bundle;

public class FacetConfiguration {
    private static final String ATTR_ID = "id";
    private static final String ATTR_INSTALLABLE = "installable";
    private static final String ATTR_VERSION_SELECTION_LABEL = "version-selection-label";
    private static final String ATTR_FINAL_PERSPECTIVE = "final-perspective";
    private static final String ATTR_WIZARD_PAGE_IMAGE = "wizard-page-image";
    private static final String EL_FACET_VERSION = "facet-version";
    private static final String EL_DEP_FACET = "dep-facet";
    private static final String EL_OR = "or";
    private static final String EL_AND = "and";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_LABEL = "label";
    private static final String ATTR_DEFAULT = "default";
    private final IProjectFacet facet;
    private String finalPerspective;
    private ImageDescriptor descriptor;
    private String selectionLabel;
    private boolean installable;
    private String[] captions;
    private IProjectFacetVersion[] versions;
    private int defaultSelection;
    AndExpr root;

    public FacetConfiguration(IConfigurationElement element) throws InitException {
        String fid = element.getAttribute(ATTR_ID);
        if (fid == null) {
            RuntimeManagerImpl.reportMissingAttribute((IConfigurationElement)element, (String)ATTR_ID);
            throw new InitException();
        }
        if (!ProjectFacetsManager.isProjectFacetDefined((String)fid)) {
            J2EEUICore.getDefault().log(MessageFormat.format("Facet {0} is not defined. Error for <{2}> element defined in plugin {1}", fid, element.getContributor().getName(), element.getName()));
            throw new InitException();
        }
        this.facet = ProjectFacetsManager.getProjectFacet((String)fid);
        this.selectionLabel = element.getAttribute(ATTR_VERSION_SELECTION_LABEL);
        this.installable = Boolean.parseBoolean(element.getAttribute(ATTR_INSTALLABLE));
        if (this.installable) {
            String imagePath = element.getAttribute(ATTR_WIZARD_PAGE_IMAGE);
            if (imagePath == null) {
                RuntimeManagerImpl.reportMissingAttribute((IConfigurationElement)element, (String)ATTR_WIZARD_PAGE_IMAGE);
            } else {
                Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
                this.descriptor = ImageDescriptor.createFromURL((URL)bundle.getEntry(imagePath));
            }
            this.finalPerspective = element.getAttribute(ATTR_FINAL_PERSPECTIVE);
        }
        ArrayList<String> captions = new ArrayList<String>();
        ArrayList<IProjectFacetVersion> versions = new ArrayList<IProjectFacetVersion>();
        IConfigurationElement[] iConfigurationElementArray = element.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if (el.getName().equals(EL_FACET_VERSION)) {
                String caption = el.getAttribute(ATTR_LABEL);
                if (caption == null) {
                    RuntimeManagerImpl.reportMissingAttribute((IConfigurationElement)el, (String)ATTR_LABEL);
                } else {
                    String version = el.getAttribute(ATTR_VERSION);
                    if (version == null) {
                        RuntimeManagerImpl.reportMissingAttribute((IConfigurationElement)el, (String)ATTR_VERSION);
                    } else if (this.facet.hasVersion(version)) {
                        IProjectFacetVersion fv = this.facet.getVersion(version);
                        captions.add(caption);
                        versions.add(fv);
                        if (Boolean.parseBoolean(el.getAttribute(ATTR_DEFAULT))) {
                            this.defaultSelection = captions.size() - 1;
                        }
                    }
                }
            }
            ++n2;
        }
        this.root = new AndExpr(element);
        if (captions.size() > 0) {
            this.captions = captions.toArray(new String[captions.size()]);
            this.versions = versions.toArray(new IProjectFacetVersion[versions.size()]);
        }
        this.fillDefaults();
        if (!this.selectionLabel.trim().endsWith(":")) {
            this.selectionLabel = String.valueOf(this.selectionLabel) + ":";
        }
    }

    private void fillDefaults() {
        if (this.selectionLabel == null) {
            this.selectionLabel = MessageFormat.format("{0} version:", this.facet.getLabel());
        }
        if (this.finalPerspective == null) {
            this.finalPerspective = ProductManager.getProperty((String)"finalPerspectiveWeb");
        }
    }

    public IProjectFacet getFacet() {
        return this.facet;
    }

    public List<IProjectFacet> getRequiredFacets(IFacetedProjectWorkingCopy fpjwc) {
        ArrayList<IProjectFacet> result = new ArrayList<IProjectFacet>();
        HashSet<IProjectFacet> installedFacets = new HashSet<IProjectFacet>();
        for (IProjectFacetVersion fv : fpjwc.getFacetedProject().getProjectFacets()) {
            installedFacets.add(fv.getProjectFacet());
        }
        this.root.fillRequiredFacets(result, installedFacets, fpjwc.getFacetedProject().getProjectFacets());
        return result;
    }

    public boolean isInstallable() {
        return this.installable;
    }

    public String getFinalPerspective() {
        return this.finalPerspective;
    }

    public ImageDescriptor getWizardPageImageDescriptor() {
        return this.descriptor;
    }

    private void internalAddFacetSelectionControls(FacetsConfigurationGroup group) {
        boolean hideVersion;
        Object hideVersionProp = this.facet.getProperty("hide.version");
        boolean bl = hideVersion = hideVersionProp != null && (Boolean)hideVersionProp != false;
        if (this.facet.getVersions().size() == 1 && hideVersion) {
            group.addFacetControl(new FacetConfigurationCheckBox(this.facet.getId(), this.facet.getLabel(), this.facet.getDefaultVersion(), true){

                @Override
                protected void modified() {
                    this.checkBox.setSelection(true);
                    super.modified();
                }

                @Override
                public void updateSelectionEnablement(Set<IProjectFacetVersion> configuredFacets) {
                    super.updateSelectionEnablement(configuredFacets);
                    this.checkBox.setSelection(true);
                }
            });
        } else if (this.captions == null) {
            group.addFacetControl(new FacetConfigurationCombo(this.selectionLabel, this.facet, null, true));
        } else {
            group.addFacetControl(new FacetConfigurationCombo(this.selectionLabel, this.facet.getId(), this.captions, this.versions, this.defaultSelection));
        }
    }

    public void addFacetSelectionControls(FacetsConfigurationGroup group, IFacetedProjectWorkingCopy fpjwc) {
        this.internalAddFacetSelectionControls(group);
        for (IProjectFacet facet : this.getRequiredFacets(fpjwc)) {
            GenericFacetInstallationManagerImpl.getFacetConfiguration(facet).internalAddFacetSelectionControls(group);
        }
    }

    private boolean noConflicts(IProjectFacet pf, Set<IProjectFacetVersion> facets) {
        for (IProjectFacetVersion version : pf.getVersions()) {
            boolean noConflicts = true;
            for (IProjectFacetVersion projectFacet : facets) {
                if (projectFacet.equals(version)) {
                    return true;
                }
                if (!projectFacet.conflictsWith(version)) continue;
                noConflicts = false;
                break;
            }
            if (!noConflicts) continue;
            return true;
        }
        return false;
    }

    public boolean canInstall(Set<IProjectFacetVersion> facets) {
        for (IProjectFacetVersion fv : facets) {
            if (!fv.getProjectFacet().equals(this.facet)) continue;
            return false;
        }
        if (!this.noConflicts(this.facet, facets)) {
            return false;
        }
        return !this.root.hasConflicts(facets);
    }

    public String toString() {
        return String.valueOf(this.facet.getId()) + " " + this.root.toString();
    }

    class AndExpr
    extends ComplexExpr {
        private AndExpr() {
        }

        public AndExpr(IConfigurationElement element) throws InitException {
            super(element);
        }

        public AndExpr(Expr element, List<Expr> children) {
            super(element, children);
        }

        @Override
        public boolean hasConflicts(Set<IProjectFacetVersion> facets) {
            boolean result = false;
            int i = 0;
            while (i < this.children.size() && !result) {
                result |= ((Expr)this.children.get(i)).hasConflicts(facets);
                ++i;
            }
            return result;
        }

        @Override
        public void fillRequiredFacets(ArrayList<IProjectFacet> result, Set<IProjectFacet> installedFacets, Set<IProjectFacetVersion> installedFacetVersions) {
            for (Expr ex : this.children) {
                ex.fillRequiredFacets(result, installedFacets, installedFacetVersions);
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("(");
            int i = 0;
            while (i < this.children.size()) {
                if (i > 0) {
                    buf.append(" && ");
                }
                buf.append(((Expr)this.children.get(i)).toString());
                ++i;
            }
            buf.append(")");
            return buf.toString();
        }
    }

    private abstract class ComplexExpr
    implements Expr {
        List<Expr> children = new ArrayList<Expr>();

        public ComplexExpr(IConfigurationElement element) throws InitException {
            IConfigurationElement[] iConfigurationElementArray = element.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement el = iConfigurationElementArray[n2];
                if (el.getName().equals(FacetConfiguration.EL_DEP_FACET)) {
                    try {
                        this.children.add(new FacetExpr(el));
                    }
                    catch (InitException initException) {}
                } else if (el.getName().equals(FacetConfiguration.EL_AND)) {
                    try {
                        this.children.add(new AndExpr(el));
                    }
                    catch (InitException initException) {}
                } else if (el.getName().equals(FacetConfiguration.EL_OR)) {
                    try {
                        this.children.add(new OrExpr(el));
                    }
                    catch (InitException initException) {}
                }
                ++n2;
            }
        }

        public ComplexExpr(Expr element, List<Expr> children) {
            this.children.add(element);
            this.children.addAll(children);
        }

        private ComplexExpr() {
        }

        @Override
        public FacetConfiguration getUnprocessedDependency(Set<FacetConfiguration> processed) {
            for (Expr e : this.children) {
                FacetConfiguration dep = e.getUnprocessedDependency(processed);
                if (dep == null) continue;
                return dep;
            }
            return null;
        }

        @Override
        public Expr addDependencies() {
            ArrayList<Expr> newChildren = new ArrayList<Expr>();
            int i = 0;
            while (i < this.children.size()) {
                Expr newExpr = this.children.get(i).addDependencies();
                if (newExpr.getClass() == this.getClass()) {
                    newChildren.addAll(((ComplexExpr)newExpr).children);
                } else {
                    newChildren.add(newExpr);
                }
                ++i;
            }
            this.children = newChildren;
            return this;
        }
    }

    static interface Expr {
        public boolean hasConflicts(Set<IProjectFacetVersion> var1);

        public void fillRequiredFacets(ArrayList<IProjectFacet> var1, Set<IProjectFacet> var2, Set<IProjectFacetVersion> var3);

        public FacetConfiguration getUnprocessedDependency(Set<FacetConfiguration> var1);

        public Expr addDependencies();
    }

    private class FacetExpr
    implements Expr {
        private IProjectFacet prjFacet;

        public FacetExpr(IConfigurationElement element) throws InitException {
            String fid = element.getAttribute(FacetConfiguration.ATTR_ID);
            if (fid == null) {
                RuntimeManagerImpl.reportMissingAttribute((IConfigurationElement)element, (String)FacetConfiguration.ATTR_ID);
                throw new InitException();
            }
            if (!ProjectFacetsManager.isProjectFacetDefined((String)fid)) {
                throw new InitException();
            }
            this.prjFacet = ProjectFacetsManager.getProjectFacet((String)fid);
        }

        @Override
        public void fillRequiredFacets(ArrayList<IProjectFacet> result, Set<IProjectFacet> installedFacets, Set<IProjectFacetVersion> installedFacetVersions) {
            if (!installedFacets.contains(this.prjFacet) && !result.contains(this.prjFacet)) {
                result.add(this.prjFacet);
            }
        }

        @Override
        public boolean hasConflicts(Set<IProjectFacetVersion> facets) {
            return !FacetConfiguration.this.noConflicts(this.prjFacet, facets);
        }

        @Override
        public FacetConfiguration getUnprocessedDependency(Set<FacetConfiguration> processed) {
            FacetConfiguration depConfig = GenericFacetInstallationManagerImpl.getFacetConfiguration(this.prjFacet);
            if (!processed.contains(depConfig)) {
                return depConfig;
            }
            return null;
        }

        @Override
        public Expr addDependencies() {
            FacetConfiguration depConfig = GenericFacetInstallationManagerImpl.getFacetConfiguration(this.prjFacet);
            if (depConfig.root.children.isEmpty()) {
                return this;
            }
            return new AndExpr(this, depConfig.root.children);
        }

        public String toString() {
            return this.prjFacet.getId();
        }
    }

    private class OrExpr
    extends ComplexExpr {
        public OrExpr(IConfigurationElement element) throws InitException {
            super(element);
        }

        @Override
        public boolean hasConflicts(Set<IProjectFacetVersion> facets) {
            boolean result = true;
            int i = 0;
            while (i < this.children.size() && result) {
                result &= ((Expr)this.children.get(i)).hasConflicts(facets);
                ++i;
            }
            return result;
        }

        @Override
        public void fillRequiredFacets(ArrayList<IProjectFacet> result, Set<IProjectFacet> installedFacets, Set<IProjectFacetVersion> installedFacetVersions) {
            int i = 0;
            while (i < this.children.size()) {
                Expr e = (Expr)this.children.get(i);
                if (!e.hasConflicts(installedFacetVersions)) {
                    e.fillRequiredFacets(result, installedFacets, installedFacetVersions);
                    return;
                }
                ++i;
            }
            throw new RuntimeException("All possibilities have conflicts");
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("(");
            int i = 0;
            while (i < this.children.size()) {
                if (i > 0) {
                    buf.append(" || ");
                }
                buf.append(((Expr)this.children.get(i)).toString());
                ++i;
            }
            buf.append(")");
            return buf.toString();
        }
    }
}

