/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.legacy.migration.internal.simple;

import com.genuitec.eclipse.core.util.IndexedList;
import com.genuitec.eclipse.core.util.InitException;
import com.genuitec.eclipse.server.core.legacy.migration.internal.simple.SimpleEASIEServer;
import com.genuitec.eclipse.server.core.legacy.migration.internal.simple.SimpleEASIEServerAbstractMigrationSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class SimpleEASIEServerMigrationExtPointManager {
    private static final String EXT_EASIE_MIGRATION = "easieServerMigration";
    private static final String EL_ABSTRACT = "abstract-server-migration";
    private static final String EL_SERVER = "server-migration";
    private static IndexedList<String, SimpleEASIEServerAbstractMigrationSpec> abstractMigrationSpecs = new IndexedList();
    private static List<SimpleEASIEServer> migrationSpecs = new ArrayList<SimpleEASIEServer>();

    static {
        SimpleEASIEServerMigrationExtPointManager.readExtensionPoint();
    }

    private static void readExtensionPoint() {
        IConfigurationElement[] elements;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.genuitec.eclipse.server.core", EXT_EASIE_MIGRATION);
        IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleEASIEServerAbstractMigrationSpec spec;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            if (iConfigurationElement.getName().equals(EL_SERVER)) {
                try {
                    spec = new SimpleEASIEServer(iConfigurationElement);
                    migrationSpecs.add((SimpleEASIEServer)spec);
                }
                catch (InitException initException) {}
            } else if (iConfigurationElement.getName().equals(EL_ABSTRACT)) {
                try {
                    spec = new SimpleEASIEServerAbstractMigrationSpec(iConfigurationElement);
                    abstractMigrationSpecs.addItemWithKey((Object)spec.getId(), (Object)spec);
                }
                catch (InitException initException) {}
            }
            ++n2;
        }
        for (SimpleEASIEServerAbstractMigrationSpec simpleEASIEServerAbstractMigrationSpec : abstractMigrationSpecs.getItemList()) {
            simpleEASIEServerAbstractMigrationSpec.init();
        }
        for (SimpleEASIEServer simpleEASIEServer : migrationSpecs) {
            simpleEASIEServer.init();
        }
        migrationSpecs = Collections.unmodifiableList(migrationSpecs);
    }

    public static List<SimpleEASIEServer> getServerMigrationSpecs() {
        return migrationSpecs;
    }

    protected static SimpleEASIEServerAbstractMigrationSpec getAbstractServerMigrationSpec(String id) {
        return (SimpleEASIEServerAbstractMigrationSpec)abstractMigrationSpecs.getItemByKey((Object)id);
    }
}

