/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.preference;

import com.genuitec.eclipse.core.Messages;
import com.genuitec.eclipse.core.ui.preference.ListButtonDetails;
import com.genuitec.eclipse.core.util.Util;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ListFieldEditor
extends ListEditor {
    public static final char DEFAULT_FIELD_SEPARATOR = ';';
    private Composite parent;
    protected List list;
    private ListButtonDetails buttonDetails;
    protected Composite buttonBox;
    protected Button addButton1;
    protected Button addButton2;
    protected Button removeButton;
    protected Button upButton;
    protected Button downButton;
    protected SelectionListener selectionListener;
    protected boolean isDisabled;
    protected char fieldSeparator = (char)59;

    public ListFieldEditor() {
    }

    public ListFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, new ListButtonDetails(), parent);
    }

    public ListFieldEditor(String name, String labelText, ListButtonDetails theButtonDetails, Composite parent) {
        this.init(name, labelText, theButtonDetails);
        this.createControl(parent);
    }

    protected void init(String theName, String labelText, ListButtonDetails theButtonDetails) {
        this.init(theName, labelText);
        this.buttonDetails = theButtonDetails;
    }

    public ListButtonDetails getButtonDetails() {
        return this.buttonDetails;
    }

    public void disable() {
        if (this.isDisabled) {
            return;
        }
        this.getLabelControl().setEnabled(false);
        if (this.addButton1 != null) {
            this.addButton1.setEnabled(false);
        }
        if (this.addButton2 != null) {
            this.addButton2.setEnabled(false);
        }
        if (this.removeButton != null) {
            this.removeButton.setEnabled(false);
        }
        if (this.upButton != null) {
            this.upButton.setEnabled(false);
        }
        if (this.downButton != null) {
            this.downButton.setEnabled(false);
        }
        this.list.setEnabled(false);
        this.list.deselectAll();
        this.isDisabled = true;
    }

    public void enable() {
        if (!this.isDisabled) {
            return;
        }
        this.getLabelControl().setEnabled(true);
        if (this.addButton1 != null) {
            this.addButton1.setEnabled(true);
        }
        if (this.addButton2 != null) {
            this.addButton2.setEnabled(true);
        }
        if (this.removeButton != null) {
            this.removeButton.setEnabled(true);
        }
        if (this.upButton != null) {
            this.upButton.setEnabled(true);
        }
        if (this.downButton != null) {
            this.downButton.setEnabled(true);
        }
        this.list.setEnabled(true);
        this.list.deselectAll();
        this.isDisabled = false;
    }

    public int getItemCount() {
        return this.list.getItemCount();
    }

    public void updateList(String theItemList) {
        String[] items = this.parseString(theItemList);
        this.updateList(items);
    }

    public void updateList(String[] theListItems) {
        this.list.setItems(theListItems);
    }

    protected void add1Pressed() {
        this.setPresentsDefaultValue(false);
        String input = this.getNewInputObject();
        if (input != null) {
            int index = this.list.getSelectionIndex();
            if (index >= 0) {
                this.list.add(input, index + 1);
            } else {
                this.list.add(input, 0);
            }
            this.selectionChanged();
        }
    }

    protected void add2Pressed() {
        this.setPresentsDefaultValue(false);
        String input = this.getNewInputObject();
        if (input != null) {
            int index = this.list.getSelectionIndex();
            if (index >= 0) {
                this.list.add(input, index + 1);
            } else {
                this.list.add(input, 0);
            }
            this.selectionChanged();
        }
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.list.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void createButtons(Composite buttonBox) {
        if (this.getButtonDetails().hasAddButton1Label()) {
            this.addButton1 = this.createPushButton(buttonBox, this.getButtonDetails().getAddButton1Label());
        }
        if (this.getButtonDetails().hasAddButton2Label()) {
            this.addButton2 = this.createPushButton(buttonBox, this.getButtonDetails().getAddButton2Label());
        }
        if (this.getButtonDetails().hasRemoveButtonLabel()) {
            this.removeButton = this.createPushButton(buttonBox, this.getButtonDetails().getRemoveButtonLabel());
        }
        if (this.getButtonDetails().hasMoveUpButton1Label()) {
            this.upButton = this.createPushButton(buttonBox, this.getButtonDetails().getMoveUpButtonLabel());
        }
        if (this.getButtonDetails().hasMoveDownButton1Label()) {
            this.downButton = this.createPushButton(buttonBox, this.getButtonDetails().getMoveDownButtonLabel());
        }
    }

    protected Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData data = new GridData(768);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == ListFieldEditor.this.addButton1) {
                    ListFieldEditor.this.add1Pressed();
                } else if (widget == ListFieldEditor.this.addButton2) {
                    ListFieldEditor.this.add2Pressed();
                } else if (widget == ListFieldEditor.this.removeButton) {
                    ListFieldEditor.this.removePressed();
                } else if (ListFieldEditor.this.upButton != null && widget == ListFieldEditor.this.upButton) {
                    ListFieldEditor.this.upPressed();
                } else if (ListFieldEditor.this.downButton != null && widget == ListFieldEditor.this.downButton) {
                    ListFieldEditor.this.downPressed();
                } else if (widget == ListFieldEditor.this.list) {
                    ListFieldEditor.this.selectionChanged();
                }
            }
        };
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.list = this.getListControl(parent);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.list.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.list != null) {
            String s = this.getPreferenceStore().getString(this.getPreferenceName());
            String[] array = this.parseString(s);
            int i = 0;
            while (i < array.length) {
                this.list.add(array[i]);
                ++i;
            }
        }
    }

    public void doLoadDefault() {
        if (this.list != null) {
            this.list.removeAll();
            String s = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            String[] array = this.parseString(s);
            int i = 0;
            while (i < array.length) {
                this.list.add(array[i]);
                ++i;
            }
        }
    }

    protected void doStore() {
        String s = this.createList(this.list.getItems());
        if (s != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), s);
        }
    }

    protected void downPressed() {
        this.swap(false);
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 3;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ListFieldEditor.this.addButton1 = null;
                    ListFieldEditor.this.addButton2 = null;
                    ListFieldEditor.this.removeButton = null;
                    ListFieldEditor.this.upButton = null;
                    ListFieldEditor.this.downButton = null;
                    ListFieldEditor.this.buttonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public List getListControl() {
        return this.list;
    }

    public List getListControl(Composite parent) {
        if (this.list == null) {
            this.list = new List(parent, 2818);
            this.list.addSelectionListener(this.getSelectionListener());
            this.list.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ListFieldEditor.this.list = null;
                }
            });
        } else {
            this.checkParent((Control)this.list, parent);
        }
        return this.list;
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton1 == null) {
            return null;
        }
        return this.addButton1.getShell();
    }

    protected void removePressed() {
        this.setPresentsDefaultValue(false);
        int[] selectionIndices = this.list.getSelectionIndices();
        int selected = selectionIndices.length == 1 ? selectionIndices[0] : -1;
        while (selectionIndices.length > 0) {
            this.list.remove(selectionIndices[0]);
            selectionIndices = this.list.getSelectionIndices();
        }
        int itemCount = this.list.getItemCount();
        if (selected >= 0 && itemCount > 0) {
            if (selected == itemCount) {
                selected = itemCount - 1;
            }
            this.list.select(selected);
        }
        this.selectionChanged();
    }

    protected void selectionChanged() {
        int count = this.list.getSelectionCount();
        int index = this.list.getSelectionIndex();
        int size = this.list.getItemCount();
        this.removeButton.setEnabled(index >= 0);
        if (this.upButton != null) {
            this.upButton.setEnabled(size > 1 && index > 0 && count == 1);
        }
        if (this.downButton != null) {
            this.downButton.setEnabled(size > 1 && index >= 0 && index < size - 1 && count == 1);
        }
        this.fireValueChanged(this.getPreferenceName(), null, null);
    }

    public void setFocus() {
        if (this.list != null) {
            this.list.setFocus();
        }
    }

    protected void swap(boolean up) {
        int target;
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        int n = target = up ? index - 1 : index + 1;
        if (index >= 0) {
            String[] selection = this.list.getSelection();
            Assert.isTrue((selection.length == 1 ? 1 : 0) != 0);
            this.list.remove(index);
            this.list.add(selection[0], target);
            this.list.setSelection(target);
        }
        this.selectionChanged();
    }

    protected void upPressed() {
        this.swap(true);
    }

    protected String createList(String[] items) {
        return this.getStringValue();
    }

    protected String getNewInputObject() {
        InputDialog dialog = new InputDialog(this.getShell(), Messages.ListFieldEditor_dialog_parameter_input_title, Messages.ListFieldEditor_dialog_parameter_input_message, "", null);
        String param = null;
        int dialogCode = dialog.open();
        if (dialogCode == 0 && (param = dialog.getValue()) != null && (param = param.trim()).length() == 0) {
            return null;
        }
        return param;
    }

    public char getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(char theSeparator) {
        this.fieldSeparator = theSeparator;
    }

    protected String[] parseString(String stringList) {
        String[] values = Util.parseString((String)stringList, (char)this.getFieldSeparator());
        int i = 0;
        while (i < values.length) {
            values[i] = this.makeDisplayPathString(values[i]);
            ++i;
        }
        return values;
    }

    protected String makeDisplayPathString(String pathString) {
        Path path = new Path(pathString);
        String fileName = path.lastSegment();
        return String.valueOf(fileName != null ? fileName.toString() : path.toString()) + " - " + path;
    }

    public String getStringValue() {
        int i = 0;
        StringBuffer results = new StringBuffer();
        int sz = this.list.getItemCount();
        i = 0;
        while (i < sz) {
            String tmp = this.list.getItem(i);
            int dashIndex = tmp.indexOf(" - ");
            results.append(dashIndex >= 0 ? tmp.substring(dashIndex + 3) : tmp);
            if (i < sz - 1) {
                results.append(this.getFieldSeparator());
            }
            ++i;
        }
        return results.toString();
    }
}

