﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;
using System.IO;
using MikuMikuPlugin;
using DxMath;

namespace SampleSavePlugin
{
    public class SampleSavePlugin : ICommandPlugin, ICanSavePlugin, IHaveUserControl
    {
        /// <summary>
        /// ユーザーコントロール
        /// </summary>
        private MyUserControl myUserControl;

        /// <summary>
        /// 日時
        /// </summary>
        private DateTime date = new DateTime();

        ////////////////////////////////////////////////////////////////////
        // コマンドプラグイン用プロパティ、メソッド
        ////////////////////////////////////////////////////////////////////

        /// <summary>
        /// このプラグインのGUID
        /// </summary>
        public Guid GUID
        {
            get { return new Guid("0420A2A4-6388-49D6-A9FB-A7217F914DEB"); }
        }

        /// <summary>
        /// メインフォーム
        /// MikuMikuMoving側から与えられます。
        /// ダイアログ表示やメッセージ表示に使用してください。
        /// </summary>
        public IWin32Window ApplicationForm { get; set; }

        /// <summary>
        /// シーンオブジェクト
        /// MikuMikuMoving側から与えられます。
        /// MikuMikuMovingのモデルやアクセサリといったオブジェクトにアクセスできます。
        /// </summary>
        public Scene Scene { get; set; }

        /// <summary>
        /// プラグインの名前や作者名、プラグインの説明
        /// </summary>
        public string Description
        {
            get { return "Sample Save Plugin v0.1 by Mogg"; }
        }

        /// <summary>
        /// ボタンに表示するアイコン画像(32x32)
        /// nullだとデフォルト画像が表示されます。
        /// </summary>
        public Image Image
        {
            get { return null; }
        }

        /// <summary>
        /// 中コマンドバーに表示するアイコン画像(20x20)
        /// nullだとデフォルト画像が表示されます。
        /// </summary>
        public Image SmallImage
        {
            get { return null; }
        }

        /// <summary>
        /// ボタンに表示するテキスト
        /// 日本語環境で表示されるテキストです。改行する場合は Environment.NewLineを使用してください。
        /// </summary>
        public string Text
        {
            get { return "サンプル保存" + Environment.NewLine + "プラグイン"; }
        }

        /// <summary>
        /// ボタンに表示する英語テキスト
        /// 日本以外の環境で表示されるテキストです。
        /// </summary>
        public string EnglishText
        {
            get { return "Sample Save" + Environment.NewLine + "Plugin"; }
        }

        /// <summary>
        /// 実行
        /// ここにボタンが押されたときの処理を記述します。
        /// </summary>
        public void Run(CommandArgs e)
        {
            MessageBox.Show(ApplicationForm, "Sample Save Plugin", "Sample");
        }

        /// <summary>
        /// プラグイン破棄処理
        /// もし解放しないといけないオブジェクトがある場合は、ここで解放してください。
        /// </summary>
        public void Dispose()
        {

        }

        ////////////////////////////////////////////////////////////////////
        // 保存用メソッド
        ////////////////////////////////////////////////////////////////////

        /// <summary>
        /// プロジェクトへプラグインデータを保存する。
        /// プロジェクトが保存されたときに呼び出されます。
        /// なお、気持ち悪いかもしれませんがStreamは外でDisposeされます。
        /// </summary>
        /// <returns></returns>
        public Stream OnSaveProject()
        {
            MemoryStream stream = new MemoryStream();

            //テキストをbyte配列にして保存
            byte[] buffer = System.Text.Encoding.Unicode.GetBytes(myUserControl.Text);
            stream.Write(buffer, 0, buffer.Length);

            return stream;
        }

        /// <summary>
        /// プロジェクトからプラグインデータを読み込む。
        /// プロジェクトがロードされたときに呼び出されます。
        /// なお、気持ち悪いかもしれませんがStreamは外でDisposeされます。
        /// </summary>
        /// <param name="stream">データStream</param>
        public void OnLoadProject(Stream stream)
        {
            byte[] buffer;
            
            //やらなくてもいいですが、まあ一応。
            stream.Seek(0, SeekOrigin.Begin);

            //保存されたテキストをStreamから取得
            buffer = new byte[stream.Length];
            int count = stream.Read(buffer, 0, buffer.Length);

            if (count == buffer.Length)
                myUserControl.Text = System.Text.Encoding.Unicode.GetString(buffer);
        }


        ////////////////////////////////////////////////////////////////////
        // ユーザーコントロール用プロパティ
        ////////////////////////////////////////////////////////////////////
        public UserControl CreateControl()
        {
            myUserControl = new MyUserControl();
            return myUserControl;
        }

    }
}
