﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;
using MikuMikuPlugin;
using DxMath;

namespace SampleCommandPlugin
{
    public class SampleCommandPlugin : ICommandPlugin
    {
        /// <summary>
        /// このプラグインのGUID
        /// </summary>
        public Guid GUID
        {
            get { return new Guid("16F29EC5-AFF5-4830-897D-B1128DEC6CE1"); }
        }

        /// <summary>
        /// メインフォーム
        /// MikuMikuMoving側から与えられます。
        /// ダイアログ表示やメッセージ表示に使用してください。
        /// </summary>
        public IWin32Window ApplicationForm { get; set; }

        /// <summary>
        /// シーンオブジェクト
        /// MikuMikuMoving側から与えられます。
        /// MikuMikuMovingのモデルやアクセサリといったオブジェクトにアクセスできます。
        /// </summary>
        public Scene Scene { get; set; }

        /// <summary>
        /// プラグインの名前や作者名、プラグインの説明
        /// </summary>
        public string Description
        {
            get { return "Sample Plugin v0.1 by Mogg"; }
        }

        /// <summary>
        /// ボタンに表示するアイコン画像(32x32)
        /// nullだとデフォルト画像が表示されます。
        /// </summary>
        public Image Image
        {
            get { return null; }
        }

        /// <summary>
        /// 中コマンドバーに表示するアイコン画像(20x20)
        /// nullだとデフォルト画像が表示されます。
        /// </summary>
        public Image SmallImage
        {
            get { return null; }
        }

        /// <summary>
        /// ボタンに表示するテキスト
        /// 日本語環境で表示されるテキストです。改行する場合は Environment.NewLineを使用してください。
        /// </summary>
        public string Text
        {
            get { return "サンプル" + Environment.NewLine + "プラグイン"; }
        }

        /// <summary>
        /// ボタンに表示する英語テキスト
        /// 日本以外の環境で表示されるテキストです。
        /// </summary>
        public string EnglishText
        {
            get { return "Sample" + Environment.NewLine + "Plugin"; }
        }

        /// <summary>
        /// 実行
        /// ここにボタンが押されたときの処理を記述します。
        /// </summary>
        public void Run(CommandArgs e)
        {
            MessageBox.Show(ApplicationForm, Scene.ApplicationVersion, "MikuMikuMoving Version");
            e.Cancel = true;
        }

        /// <summary>
        /// プラグイン破棄処理
        /// もし解放しないといけないオブジェクトがある場合は、ここで解放してください。
        /// </summary>
        public void Dispose()
        {

        }
    }
}
