﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;
using MikuMikuPlugin;
using DxMath;

namespace AngleZeroPlugin
{
    public class AngleZeroPlugin : ICommandPlugin
    {
        /// <summary>
        /// このプラグインのGUID
        /// </summary>
        public Guid GUID
        {
            get { return new Guid("5FE80FEF-6599-4792-B910-39F709121F7F"); }
        }

        /// <summary>
        /// メインフォーム
        /// MikuMikuMoving側から与えられます。
        /// ダイアログ表示やメッセージ表示に使用してください。
        /// </summary>
        public IWin32Window ApplicationForm { get; set; }

        /// <summary>
        /// シーンオブジェクト
        /// MikuMikuMoving側から与えられます。
        /// MikuMikuMovingのモデルやアクセサリといったオブジェクトにアクセスできます。
        /// </summary>
        public Scene Scene { get; set; }

        /// <summary>
        /// プラグインの名前や作者名、プラグインの説明
        /// </summary>
        public string Description
        {
            get { return "Random Blink Plugin v0.2 by Mogg"; }
        }

        /// <summary>
        /// ボタンに表示するアイコン画像(32x32)
        /// nullだとデフォルト画像が表示されます。
        /// </summary>
        public Image Image
        {
            get { return Properties.Resources.AngleZero_L; }
        }

        /// <summary>
        /// 中コマンドバーに表示するアイコン画像(20x20)
        /// nullだとデフォルト画像が表示されます。
        /// </summary>
        public Image SmallImage
        {
            get { return Properties.Resources.AngleZero; }
        }

        /// <summary>
        /// ボタンに表示するテキスト
        /// 日本語環境で表示されるテキストです。改行する場合は Environment.NewLineを使用してください。
        /// </summary>
        public string Text
        {
            get { return "回転" + Environment.NewLine + "ゼロ化"; }
        }

        /// <summary>
        /// ボタンに表示する英語テキスト
        /// 日本以外の環境で表示されるテキストです。
        /// </summary>
        public string EnglishText
        {
            get { return "Angle" + Environment.NewLine + "Zero"; }
        }

        /// <summary>
        /// 実行
        /// </summary>
        public void Run(CommandArgs e)
        {
            //モデルが有効かどうか調べる
            if (Scene.ActiveModel != null)
            {
                //選択されたボーン(レイヤ)で、選択されたキーフレームの回転をゼロにする
                foreach (Bone bone in Scene.ActiveModel.Bones)
                {
                    foreach (MotionLayer layer in bone.SelectedLayers)
                    {
                        foreach (IMotionFrameData frame in layer.SelectedFrames)
                            frame.Quaternion = Quaternion.Identity;
                    }
                }
            }
            else if (Scene.ActiveAccessory != null)
            {
                //アクセサリ
                foreach (MotionLayer layer in Scene.ActiveAccessory.SelectedLayers)
                {
                    foreach (IMotionFrameData frame in layer.SelectedFrames)
                        frame.Quaternion = Quaternion.Identity;
                }
            }
            else if (Scene.ActiveEffect != null)
            {
                //エフェクト
                foreach (IMotionFrameData frame in Scene.ActiveEffect.SelectedFrames)
                    frame.Quaternion = Quaternion.Identity;
            }
            else
            {
                //キャンセルをTrueにすると変更フラグが立ちません。
                e.Cancel = true;
            }
        }

        /// <summary>
        /// プラグイン破棄処理
        /// </summary>
        public void Dispose()
        {

        }
    }
}
