
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/woodop.zip" ),
}
local prefabs = {}

local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "wolfgang"

	-- a minimap icon must be specified
	inst.MiniMapEntity:SetIcon( "wilson.png" )

	-- todo: Add an example special power here.
	inst.components.health:SetMaxHealth(1500)
	inst.components.hunger:SetMax(1500)
	inst.components.combat:SetDefaultDamage(TUNING.LEIF_DAMAGE)
	inst.components.combat:SetAreaDamage(6, 0.8)
	
	inst.Transform:SetScale(1.7, 1.7, 1.7)
end


-- strings! Any "woodop" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.woodop = "WOOD"
STRINGS.CHARACTER_NAMES.woodop = "woodop"
STRINGS.CHARACTER_DESCRIPTIONS.woodop = ".*ridiculous health & hunger , Super easy mode character, hit painful OMG without weapon (has Treeguard damage and deerclops area damage)"
STRINGS.CHARACTER_QUOTES.woodop = "\"Wolfgang is the strongest character ingame? Not Anymore.\""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.WOODOP = {}
STRINGS.CHARACTERS.WOODOP.DESCRIBE = {}
STRINGS.CHARACTERS.WOODOP.DESCRIBE.EVERGREEN = "A template description of a tree."
STRINGS.CHARACTERS.WOODOP.COMBAT_QUIT =
	{
		GENERIC = "Run, Weak, Run!",
	}
STRINGS.CHARACTERS.WOODOP.ANNOUNCE_EAT =
{
		GENERIC = "Taste so piney",
		PAINFUL = "Gurrrhh!!!",
		SPOILED = "Green rooting",
		STALE = "Bleh!",
	}
STRINGS.CHARACTERS.WOODOP.BATTLECRY =
{
		GENERIC = "I shall uproot you!",
		PIGMAN = "DIE!",
		RABBIT = "Outta the way!",
		ROBIN = "Outta the way!",
		BEE = "Sweet!",
		LEIF = "Let see who is the stronger one",
		SPIDER = "You son of a Birch!",
		SPIDER_WARRIOR = "Military style eh? That's cute",
		BUNNYMAN = "HOP! HOP! AND DIE!",
		DEERCLOPS = "At last, decent opponent",
	}



return MakePlayerCharacter("woodop", prefabs, assets, fn)
