local assets =
{
    Asset("ANIM", "anim/zhxing.zip"),
    Asset("ANIM", "anim/swap_zhxing.zip"),
	Asset("IMAGE","images/inventoryimages/zhxing.tex"),
	Asset("ATLAS","images/inventoryimages/zhxing.xml")
}

local function onequip(inst, owner)

    owner.AnimState:OverrideSymbol("swap_object", "swap_zhxing", "swap_zhxing")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")

end

local function onunequip(inst, owner)
--inst:RemoveTag("feng")
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end


local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("zhxing")
    inst.AnimState:SetBuild("zhxing")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(5)
    inst.components.weapon:SetRange(1.3)



    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "zhxing"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/zhxing.xml"
	
inst:AddComponent("tool")
	inst.components.tool:SetAction(ACTIONS.CHOP, 5)
        inst.components.tool:SetAction(ACTIONS.MINE, 3)
		
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)



    MakeHauntableLaunch(inst)

    return inst
end

return Prefab( "common/inventory/zhxing", fn, assets)