local assets=
{
	Asset("ANIM", "anim/jianjie.zip"),
	
	Asset("ATLAS", "images/inventoryimages/jianjie.xml"),
    Asset("IMAGE", "images/inventoryimages/jianjie.tex"),
}

local function fn()
    
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	--inst.entity:AddSoundEmitter()
	--inst.entity:AddPhysics()
	inst.entity:AddNetwork()
	inst.entity:AddLight()
	
    MakeInventoryPhysics(inst)
	RemovePhysicsColliders(inst)

    inst.AnimState:SetBank("jianjie")
    inst.AnimState:SetBuild("jianjie")
    inst.AnimState:PlayAnimation("idle")


	
	
	inst.entity:SetPristine()
    if not TheWorld.ismastersim then
        return inst
    end
	
    inst:AddComponent("edible")
    inst.components.edible.foodtype = FOODTYPE.GEARS
    inst.components.edible.healthvalue = 1
    inst.components.edible.hungervalue = 1
    inst.components.edible.sanityvalue = 1
    --inst:AddComponent("tradable")
    
    inst:AddComponent("inspectable")
	inst:AddComponent("stackable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "jianjie"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/jianjie.xml"
  
    return inst
end

return Prefab( "common/inventory/jianjie", fn, assets) 
