local assets =
{
    Asset("ANIM", "anim/datai.zip"),
    Asset("ANIM", "anim/swap_datai.zip"),
	Asset("IMAGE","images/inventoryimages/datai.tex"),
	Asset("ATLAS","images/inventoryimages/datai.xml")
}



local function ShouldAcceptItem(inst, item)
    if item.prefab == "xinp" then
       return true
    end
    return false
end

local function onfinished(inst)

	inst:Remove()
end



local function onAttackf(inst, attacker, target)

		
		if math.random() < .08 then
		target.components.health:DoDelta(-200)
		inst.components.talker:Say("暴击！")
end
end




local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_datai", "swap_datai")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")

end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")

end

local function OnGetItemFromPlayer(inst, giver, item)
   
	 if item.prefab == "xinp" then
       inst.components.finiteuses.current = inst.components.finiteuses.current + inst.components.finiteuses.total *0.2
    end
    if inst.components.finiteuses.current > inst.components.finiteuses.total then
       inst.components.finiteuses.current = inst.components.finiteuses.total
    end
end


local function OnRefuseItem(inst, giver, item)
	if item.prefab ~= "xinp" then
		inst.components.talker:Say("需要芯片来修复!")
	end
end


local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("datai")
    inst.AnimState:SetBuild("datai")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(47)

    -------
    inst.components.weapon:SetRange(1.9)
    inst.components.weapon:SetOnAttack(onAttackf)
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(350)
    inst.components.finiteuses:SetUses(350)
	if inst.components.finiteuses.current < 0 then
       inst.components.finiteuses.current = 0
    end
	inst.components.finiteuses:SetOnFinished( onfinished )

    inst:AddComponent("inspectable")
	inst:AddComponent("trader")
	inst.components.trader.onaccept = OnGetItemFromPlayer
    inst.components.trader:SetAcceptTest(ShouldAcceptItem)
 inst.components.trader.onrefuse = OnRefuseItem
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "datai"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/datai.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
    inst.components.equippable.walkspeedmult = 0.8

		inst:AddComponent("talker")
    inst.components.talker.fontsize = 36
    inst.components.talker.font = TALKINGFONT
    inst.components.talker.colour = Vector3(.9, .4, .4)
    inst.components.talker.offset = Vector3(0, 0, 0)
    inst.components.talker.symbol = "swap_object"

    MakeHauntableLaunch(inst)

    return inst
end

return Prefab( "common/inventory/datai", fn, assets)