//  Debug Module		Debug Write Methods
//  Copyright 2003-2004 Excellence Foundation		Don@xfnd.org
//
//  This product is free software. You can redistribute it and/or modify it under the
//  terms of the Public Source Distribution License Agreement (PSDLA) as published by
//  Excellence Foundation.
//
//  This product is distributed in the hope it will be instructional and useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//  FITNESS FOR A PARTICULAR PURPOSE. See the PSDLA for more details. You should have
//  received a copy of the PSDLA with this product. If not, browse
//  http://www.xfnd.org/licenses/PSDLA.doc.

using System;
using System.Text;

namespace Emxx
{
	/// <summary>
	/// Summary description for Debug.
	/// </summary>
	public class Debug
	{
		private static int		m_Level = 0;			// show messages above this debug level
		private static int		m_MsgLevel = 0;			// default message level

		/// <summary>
		/// Default message level for debug messages sent without
		/// a message level.
		/// </summary>
		public static int	MsgLevel					// default debug message level property
		{
			get {return m_MsgLevel;}					// get default message level
			set {m_MsgLevel = value;}					// set default message level
		}												// end MsgLevel property

		/// <summary>
		/// Messages with a level greater than this debug level will
		/// be displayed on the console.
		/// </summary>
		public static int	Level						// level for displaying debug messages
		{
			get {return m_Level;}						// get debug level
			set {m_Level = value;}						// set debug level
		}												// end Level property

		/// <summary>
		/// Displays the debug message on the console if the
		/// default message level, MsgLevel, is greater than
		/// the debug level, Level.
		/// </summary>
		/// <param name="msg">Debug message</param>
		public static void	WriteLine(string msg)
		{
			if (m_MsgLevel > m_Level)					// if debugging
				Console.WriteLine(msg);					//   write line
		}												// end method Writeline

		/// <summary>
		/// Displays the debug message on the console if the
		/// specified message level is greater than the
		/// debug level, Level.
		/// </summary>
		/// <param name="lvl">Level of this debug meessage</param>
		/// <param name="msg">Debug message</param>
		public static void	WriteLine(int lvl,string msg)
		{
			if (lvl > m_Level)							// if debugging
				Console.WriteLine(msg);					//   write line
		}												// end method Writeline

	}													// end class Debug
}														// end namespace TestBed
