/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.FontFormatException;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.font.CreatedFontTracker;
import sun.font.FileFontStrike;
import sun.font.FontManager;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.NativeFont;
import sun.font.PhysicalFont;
import sun.font.StrikeMetrics;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;

public abstract class FileFont
extends PhysicalFont {
    protected boolean useJavaRasterizer = true;
    protected int fileSize;
    protected FileFontDisposer disposer;
    protected long pScaler;
    protected boolean checkedNatives;
    protected boolean useNatives;
    protected NativeFont[] nativeFonts;
    protected char[] glyphToCharMap;

    FileFont(String string, Object object) throws FontFormatException {
        super(string, object);
    }

    FontStrike createStrike(FontStrikeDesc fontStrikeDesc) {
        if (!this.checkedNatives) {
            this.checkUseNatives();
        }
        return new FileFontStrike(this, fontStrikeDesc);
    }

    protected boolean checkUseNatives() {
        this.checkedNatives = true;
        return this.useNatives;
    }

    protected abstract void close();

    abstract ByteBuffer readBlock(int var1, int var2);

    public boolean canDoStyle(int n) {
        return true;
    }

    void setFileToRemove(File file, CreatedFontTracker createdFontTracker) {
        Disposer.addObjectRecord(this, new CreatedFontFileDisposerRecord(file, createdFontTracker));
    }

    synchronized void deregisterFontAndClearStrikeCache() {
        FontManager.deRegisterBadFont(this);
        this.pScaler = FileFont.getNullScaler();
        for (Reference reference : this.strikeCache.values()) {
            FileFontStrike fileFontStrike;
            if (reference == null || (fileFontStrike = (FileFontStrike)reference.get()) == null || fileFontStrike.pScalerContext == 0L) continue;
            this.setNullScaler(fileFontStrike.pScalerContext);
        }
    }

    synchronized native void setNullScaler(long var1);

    static native void freeScaler(long var0);

    static synchronized native long getNullScaler();

    synchronized native StrikeMetrics getFontMetrics(long var1);

    synchronized native float getGlyphAdvance(long var1, int var3);

    synchronized native void getGlyphMetrics(long var1, int var3, Point2D.Float var4);

    synchronized native long getGlyphImage(long var1, int var3);

    synchronized native Rectangle2D.Float getGlyphOutlineBounds(long var1, int var3);

    synchronized native GeneralPath getGlyphOutline(long var1, int var3, float var4, float var5);

    synchronized native GeneralPath getGlyphVectorOutline(long var1, int[] var3, int var4, float var5, float var6);

    protected abstract long getScaler();

    protected String getPublicFileName() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return this.platName;
        }
        boolean bl = true;
        try {
            securityManager.checkPropertyAccess("java.io.tmpdir");
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        if (bl) {
            return this.platName;
        }
        final File file = new File(this.platName);
        Boolean bl2 = Boolean.FALSE;
        try {
            bl2 = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() {
                    File file2 = new File(System.getProperty("java.io.tmpdir"));
                    try {
                        String string = file2.getCanonicalPath();
                        String string2 = file.getCanonicalPath();
                        return string2 == null || string2.startsWith(string);
                    }
                    catch (IOException iOException) {
                        return Boolean.TRUE;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            bl2 = Boolean.TRUE;
        }
        return bl2 != false ? "" : this.platName;
    }

    private static class CreatedFontFileDisposerRecord
    implements DisposerRecord {
        File fontFile = null;
        CreatedFontTracker tracker;

        private CreatedFontFileDisposerRecord(File file, CreatedFontTracker createdFontTracker) {
            this.fontFile = file;
            this.tracker = createdFontTracker;
        }

        public void dispose() {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (CreatedFontFileDisposerRecord.this.fontFile != null) {
                        try {
                            if (CreatedFontFileDisposerRecord.this.tracker != null) {
                                CreatedFontFileDisposerRecord.this.tracker.subBytes((int)CreatedFontFileDisposerRecord.this.fontFile.length());
                            }
                            CreatedFontFileDisposerRecord.this.fontFile.delete();
                            FontManager.tmpFontFiles.remove(CreatedFontFileDisposerRecord.this.fontFile);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            });
        }
    }

    protected static class FileFontDisposer
    implements DisposerRecord {
        long pScaler = 0L;
        boolean disposed = false;

        public FileFontDisposer(long l) {
            this.pScaler = l;
        }

        public synchronized void dispose() {
            if (!this.disposed) {
                FileFont.freeScaler(this.pScaler);
                this.pScaler = 0L;
                this.disposed = true;
            }
        }
    }
}

