/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Fixups;
import com.sun.java.util.jar.pack.Instruction;
import com.sun.java.util.jar.pack.Package;
import java.util.Arrays;
import java.util.Collection;

class Code
extends Attribute.Holder
implements Constants {
    Package.Class.Method m;
    private static final ConstantPool.Entry[] noRefs = ConstantPool.noRefs;
    int max_stack;
    int max_locals;
    ConstantPool.Entry[] handler_class = noRefs;
    int[] handler_start = noInts;
    int[] handler_end = noInts;
    int[] handler_catch = noInts;
    byte[] bytes;
    Fixups fixups;
    Object insnMap;
    static final boolean shrinkMaps = true;

    public Code(Package.Class.Method method) {
        this.m = method;
    }

    public Package.Class.Method getMethod() {
        return this.m;
    }

    public Package.Class thisClass() {
        return this.m.thisClass();
    }

    public Package getPackage() {
        return this.m.thisClass().getPackage();
    }

    public ConstantPool.Entry[] getCPMap() {
        return this.m.getCPMap();
    }

    int getLength() {
        return this.bytes.length;
    }

    int getMaxStack() {
        return this.max_stack;
    }

    void setMaxStack(int n) {
        this.max_stack = n;
    }

    int getMaxNALocals() {
        int n = this.m.getArgumentSize();
        return this.max_locals - n;
    }

    void setMaxNALocals(int n) {
        int n2 = this.m.getArgumentSize();
        this.max_locals = n2 + n;
    }

    int getHandlerCount() {
        assert (this.handler_class.length == this.handler_start.length);
        assert (this.handler_class.length == this.handler_end.length);
        assert (this.handler_class.length == this.handler_catch.length);
        return this.handler_class.length;
    }

    void setHandlerCount(int n) {
        if (n > 0) {
            this.handler_class = new ConstantPool.Entry[n];
            this.handler_start = new int[n];
            this.handler_end = new int[n];
            this.handler_catch = new int[n];
        }
    }

    void setBytes(byte[] byArray) {
        this.bytes = byArray;
        if (this.fixups != null) {
            this.fixups.setBytes(byArray);
        }
    }

    void setInstructionMap(int[] nArray, int n) {
        this.insnMap = this.allocateInstructionMap(nArray, n);
    }

    void setInstructionMap(int[] nArray) {
        this.setInstructionMap(nArray, nArray.length);
    }

    int[] getInstructionMap() {
        return this.expandInstructionMap(this.getInsnMap());
    }

    void addFixups(Collection collection) {
        if (this.fixups == null) {
            this.fixups = new Fixups(this.bytes);
        }
        assert (this.fixups.getBytes() == this.bytes);
        this.fixups.addAll(collection);
    }

    public void trimToSize() {
        if (this.fixups != null) {
            this.fixups.trimToSize();
            if (this.fixups.size() == 0) {
                this.fixups = null;
            }
        }
        super.trimToSize();
    }

    protected void visitRefs(int n, Collection collection) {
        int n2 = this.getPackage().verbose;
        if (n2 > 2) {
            System.out.println("Reference scan " + this);
        }
        Package.Class clazz = this.thisClass();
        Package package_ = clazz.getPackage();
        for (int i = 0; i < this.handler_class.length; ++i) {
            collection.add(this.handler_class[i]);
        }
        if (this.fixups != null) {
            this.fixups.visitRefs(collection);
        } else {
            ConstantPool.Entry[] entryArray = this.getCPMap();
            for (Instruction instruction = this.instructionAt(0); instruction != null; instruction = instruction.next()) {
                int n3;
                if (n2 > 4) {
                    System.out.println(instruction);
                }
                if ((n3 = instruction.getCPIndex()) < 0) continue;
                collection.add(entryArray[n3]);
            }
        }
        super.visitRefs(n, collection);
    }

    private Object allocateInstructionMap(int[] nArray, int n) {
        int n2 = this.getLength();
        if (n2 <= 255) {
            byte[] byArray = new byte[n + 1];
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)(nArray[i] + -128);
            }
            byArray[n] = (byte)(n2 + -128);
            return byArray;
        }
        if (n2 < 65535) {
            short[] sArray = new short[n + 1];
            for (int i = 0; i < n; ++i) {
                sArray[i] = (short)(nArray[i] + Short.MIN_VALUE);
            }
            sArray[n] = (short)(n2 + Short.MIN_VALUE);
            return sArray;
        }
        int[] nArray2 = new int[n + 1];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[i];
        }
        nArray2[n] = n2;
        return nArray2;
    }

    private int[] expandInstructionMap(Object object) {
        int[] nArray;
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            nArray = new int[byArray.length - 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = byArray[i] - -128;
            }
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            nArray = new int[sArray.length - 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = sArray[i] - -128;
            }
        } else {
            int[] nArray2 = (int[])object;
            nArray = new int[nArray2.length - 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = nArray2[i];
            }
        }
        return nArray;
    }

    Object getInsnMap() {
        if (this.insnMap != null) {
            return this.insnMap;
        }
        int[] nArray = new int[this.getLength()];
        int n = 0;
        for (Instruction instruction = this.instructionAt(0); instruction != null; instruction = instruction.next()) {
            nArray[n++] = instruction.getPC();
        }
        this.insnMap = this.allocateInstructionMap(nArray, n);
        return this.insnMap;
    }

    public int encodeBCI(int n) {
        int n2;
        int n3;
        if (n <= 0 || n > this.getLength()) {
            return n;
        }
        Object object = this.getInsnMap();
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            n3 = byArray.length;
            n2 = Arrays.binarySearch(byArray, (byte)(n + -128));
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            n3 = sArray.length;
            n2 = Arrays.binarySearch(sArray, (short)(n + Short.MIN_VALUE));
        } else {
            int[] nArray = (int[])object;
            n3 = nArray.length;
            n2 = Arrays.binarySearch(nArray, n);
        }
        assert (n2 != -1);
        assert (n2 != 0);
        assert (n2 != n3);
        assert (n2 != -n3 - 1);
        return n2 >= 0 ? n2 : n3 + n - (-n2 - 1);
    }

    public int decodeBCI(int n) {
        int n2;
        int n3;
        if (n <= 0 || n > this.getLength()) {
            return n;
        }
        Object object = this.getInsnMap();
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            n3 = byArray.length;
            if (n < n3) {
                return byArray[n] - -128;
            }
            n2 = Arrays.binarySearch(byArray, (byte)(n + -128));
            if (n2 < 0) {
                n2 = -n2 - 1;
            }
            int n4 = n - n3 + -128;
            while (byArray[n2 - 1] - (n2 - 1) > n4) {
                --n2;
            }
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            n3 = sArray.length;
            if (n < n3) {
                return sArray[n] - Short.MIN_VALUE;
            }
            n2 = Arrays.binarySearch(sArray, (short)(n + Short.MIN_VALUE));
            if (n2 < 0) {
                n2 = -n2 - 1;
            }
            int n5 = n - n3 + Short.MIN_VALUE;
            while (sArray[n2 - 1] - (n2 - 1) > n5) {
                --n2;
            }
        } else {
            int[] nArray = (int[])object;
            n3 = nArray.length;
            if (n < n3) {
                return nArray[n];
            }
            n2 = Arrays.binarySearch(nArray, n);
            if (n2 < 0) {
                n2 = -n2 - 1;
            }
            int n6 = n - n3;
            while (nArray[n2 - 1] - (n2 - 1) > n6) {
                --n2;
            }
        }
        return n - n3 + n2;
    }

    public void finishRefs(ConstantPool.Index index) {
        if (this.fixups != null) {
            this.fixups.finishRefs(index);
            this.fixups = null;
        }
    }

    Instruction instructionAt(int n) {
        return Instruction.at(this.bytes, n);
    }

    static boolean flagsRequireCode(int n) {
        return (n & 0x500) == 0;
    }

    public String toString() {
        return this.m + ".Code";
    }

    public int getInt(int n) {
        return Instruction.getInt(this.bytes, n);
    }

    public int getShort(int n) {
        return Instruction.getShort(this.bytes, n);
    }

    public int getByte(int n) {
        return Instruction.getByte(this.bytes, n);
    }

    void setInt(int n, int n2) {
        Instruction.setInt(this.bytes, n, n2);
    }

    void setShort(int n, int n2) {
        Instruction.setShort(this.bytes, n, n2);
    }

    void setByte(int n, int n2) {
        Instruction.setByte(this.bytes, n, n2);
    }
}

