/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util.xml;

import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtils {
    public static String getFilename(Node node) {
        URI uri;
        String uriString = node.getOwnerDocument().getBaseURI();
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            return null;
        }
        File file = new File(uri.getPath());
        return file.getName();
    }

    public static Map<String, String> getAttributes(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attNode = attributes.item(i);
            result.put(attNode.getNodeName(), attNode.getNodeValue());
        }
        return result;
    }

    public static String getAttribute(Node node, String name) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return null;
        }
        Node attNode = attributes.getNamedItem(name);
        if (attNode == null) {
            return null;
        }
        return attNode.getNodeValue();
    }

    public static List<Node> getChildElements(Node parent, String elementName) {
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || elementName != null && !childNode.getLocalName().equals(elementName)) continue;
            result.add(childNode);
        }
        return result;
    }

    public static List<String> getChildText(Node parent) {
        ArrayList<String> result = new ArrayList<String>();
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 3) continue;
            result.add(childNode.getNodeValue());
        }
        return result;
    }

    public static Properties childrenAsProperties(Node parent, String keyAttr, String valueAttr) {
        Properties properties = new Properties();
        properties.putAll(XMLUtils.childrenAsMap(parent, keyAttr, valueAttr));
        return properties;
    }

    public static Map<String, String> childrenAsMap(Node parent, String keyAttr, String valueAttr) {
        HashMap<String, String> result = new HashMap<String, String>();
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            Map<String, String> attributes = XMLUtils.getAttributes(childNode);
            String key = attributes.get(keyAttr);
            String value = attributes.get(valueAttr);
            if (key == null || value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public static <T> List<T> decodeChildren(Node parent, DocumentNodeDecoder<T> decoder) {
        ArrayList<T> result = new ArrayList<T>();
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            T decoded;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || (decoded = decoder.decode(childNode)) == null) continue;
            result.add(decoded);
        }
        return result;
    }

    public static <T> List<T> decodeChildren(Node parent, Iterable<DocumentNodeDecoder<? extends T>> decoders) {
        ArrayList<T> result = new ArrayList<T>();
        NodeList childNodes = parent.getChildNodes();
        block0: for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            for (DocumentNodeDecoder<T> decoder : decoders) {
                T decoded = decoder.decode(childNode);
                if (decoded == null) continue;
                result.add(decoded);
                continue block0;
            }
        }
        return result;
    }

    public static Element createElement(Document document, String name, Map<String, String> attributes, boolean writeNulls) {
        Element result = document.createElement(name);
        if (attributes != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String value = entry.getValue();
                if (value == null && !writeNulls) continue;
                result.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public static Document getXMLDocument(File file, boolean validating) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(validating);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(file);
        document.normalize();
        return document;
    }

    public static Document getXMLDocument(InputStream inputStream, boolean validating) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(validating);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(inputStream);
        document.normalize();
        return document;
    }

    public static Document newXMLDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        return docBuilder.newDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXMLDocument(Document document, File file) throws TransformerException, IOException {
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("indent", "yes");
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            StreamResult result = new StreamResult(fw);
            DOMSource source = new DOMSource(document);
            trans.transform(source, result);
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    private XMLUtils() {
    }
}

