/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util.xml;

import com.sodiumarc.patchwork.util.Collection.StringMultiMap;
import com.sodiumarc.patchwork.util.xml.DocumentNodeTranscoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StringMultiMapTranscoder
implements DocumentNodeTranscoder<StringMultiMap> {
    private static final String MAP_ENTRY_ELEMENT_NAME = "mapEntry";
    private static final String ATTR_KEY = "key";
    private static final String LIST_ENTRY_ELEMENT_NAME = "listEntry";
    private static final String ATTR_VALUE = "value";
    private final String elementName;

    public StringMultiMapTranscoder(String elementName) {
        this.elementName = elementName;
    }

    @Override
    public Class<StringMultiMap> getDecodedType() {
        return StringMultiMap.class;
    }

    @Override
    public Node encode(Document document, StringMultiMap object) {
        Element result = XMLUtils.createElement(document, this.elementName, null, false);
        for (String key : object.keySet()) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(ATTR_KEY, key);
            Element mapEntryElement = XMLUtils.createElement(document, MAP_ENTRY_ELEMENT_NAME, attributes, true);
            result.appendChild(mapEntryElement);
            for (String value : object.getAll(key)) {
                attributes.clear();
                attributes.put(ATTR_VALUE, value);
                Element listEntryElement = XMLUtils.createElement(document, LIST_ENTRY_ELEMENT_NAME, attributes, true);
                mapEntryElement.appendChild(listEntryElement);
            }
        }
        return result;
    }

    @Override
    public StringMultiMap decode(Node node) {
        assert (node != null) : "Null node";
        if (node.getNodeType() != 1) {
            return null;
        }
        if (!node.getLocalName().equals(this.elementName)) {
            return null;
        }
        StringMultiMap result = new StringMultiMap();
        for (Node mapEntryNode : XMLUtils.getChildElements(node, MAP_ENTRY_ELEMENT_NAME)) {
            Map<String, String> attributes = XMLUtils.getAttributes(mapEntryNode);
            String key = attributes.get(ATTR_KEY);
            if (key == null) continue;
            for (Node listEntryNode : XMLUtils.getChildElements(mapEntryNode, LIST_ENTRY_ELEMENT_NAME)) {
                attributes = XMLUtils.getAttributes(listEntryNode);
                result.putLast(key, attributes.get(ATTR_VALUE));
            }
        }
        return result;
    }
}

