/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util.xml;

import com.sodiumarc.patchwork.util.Collection.MultiHashMap;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.xml.DocumentNodeTranscoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class SimpleTranscoder<T>
implements DocumentNodeTranscoder<T> {
    private final String elementName;
    private final String decodeElementName;
    private final Class<T> decodedType;
    private final MultiMap<String, DocumentNodeTranscoder<?>> transcoderByFieldName;
    private boolean writeNullAttributeValues;

    public SimpleTranscoder(String elementName, Class<T> decodedType) {
        this(elementName, null, decodedType);
    }

    public SimpleTranscoder(String elementName, String decodeElementName, Class<T> decodedType) {
        this.elementName = elementName;
        this.decodeElementName = decodeElementName;
        this.decodedType = decodedType;
        this.transcoderByFieldName = new MultiHashMap();
    }

    public String getElementName() {
        return this.elementName;
    }

    @Override
    public Class<T> getDecodedType() {
        return this.decodedType;
    }

    @Override
    public final Node encode(Document document, T object) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        this.getAttributes(object, attributes);
        MultiHashMap<String, Object> children = new MultiHashMap<String, Object>();
        this.getChildren(object, children);
        Element element = XMLUtils.createElement(document, this.elementName, attributes, this.writeNullAttributeValues);
        for (String fieldName : children.keySet()) {
            Element fieldElement = XMLUtils.createElement(document, fieldName, null, false);
            element.appendChild(fieldElement);
            List<DocumentNodeTranscoder<?>> transcoders = this.transcoderByFieldName.getAll(fieldName);
            for (Object child : children.getAll(fieldName)) {
                for (DocumentNodeTranscoder<?> transcoder : transcoders) {
                    if (!transcoder.getDecodedType().equals(child.getClass())) continue;
                    fieldElement.appendChild(transcoder.encode(document, child));
                }
            }
        }
        return element;
    }

    @Override
    public final T decode(Node node) {
        assert (node != null) : "Null node";
        if (node.getNodeType() != 1) {
            return null;
        }
        if (!node.getLocalName().equals(this.getDecodeElementName())) {
            return null;
        }
        Map<String, String> attributes = XMLUtils.getAttributes(node);
        MultiHashMap<String, Object> decodedChildren = new MultiHashMap<String, Object>();
        for (Node fieldNode : XMLUtils.getChildElements(node, null)) {
            String fieldName = fieldNode.getLocalName();
            ArrayList transcoders = new ArrayList(this.transcoderByFieldName.getAll(fieldName));
            for (Object decoded : XMLUtils.decodeChildren(fieldNode, transcoders)) {
                decodedChildren.putLast(fieldName, decoded);
            }
        }
        return this.decode(attributes, decodedChildren);
    }

    protected final void setFieldTranscoder(String fieldName, DocumentNodeTranscoder<?> ... fieldTranscoders) {
        for (DocumentNodeTranscoder<?> transcoder : fieldTranscoders) {
            this.transcoderByFieldName.putLast(fieldName, transcoder);
        }
    }

    protected final void setWriteNullAttributeValues(boolean writeNullAttributeValues) {
        this.writeNullAttributeValues = writeNullAttributeValues;
    }

    protected abstract T decode(Map<String, String> var1, MultiMap<String, Object> var2);

    protected void getAttributes(T object, Map<String, String> destination) {
    }

    protected void getChildren(T object, MultiMap<String, Object> destination) {
    }

    private String getDecodeElementName() {
        if (this.decodeElementName != null) {
            return this.decodeElementName;
        }
        return this.elementName;
    }
}

