/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util;

import com.sodiumarc.patchwork.util.GeometricAxis;
import com.sodiumarc.patchwork.util.VectorUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.vecmath.Tuple3d;

public class Tuple3dComparator
implements Comparator<Tuple3d> {
    private final List<GeometricAxis> _sortByAxes;

    public Tuple3dComparator(GeometricAxis primary, GeometricAxis secondary, GeometricAxis tertiary) {
        assert (primary != secondary);
        assert (secondary != tertiary);
        this._sortByAxes = new ArrayList<GeometricAxis>(3);
        this._sortByAxes.add(primary);
        this._sortByAxes.add(secondary);
        this._sortByAxes.add(tertiary);
    }

    @Override
    public int compare(Tuple3d arg0, Tuple3d arg1) {
        for (GeometricAxis axis : this._sortByAxes) {
            int compare = Double.compare(VectorUtils.getComponent(arg0, axis), VectorUtils.getComponent(arg1, axis));
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }
}

