/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util;

import com.sodiumarc.patchwork.util.TargetablePanelListener;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public abstract class TargetablePanel<T>
extends JPanel {
    private T target;
    private final List<TargetablePanelListener> listeners = new ArrayList<TargetablePanelListener>();

    public TargetablePanel() {
        this(null);
    }

    public TargetablePanel(LayoutManager layout) {
        super(layout);
    }

    public final void setTarget(T target) {
        this.target = target;
        this.targetSet();
        this.fireTargetChanged();
    }

    public T getTarget() {
        return this.target;
    }

    public <S> S getTargetByType(Class<S> type) {
        if (type.isInstance(this.target)) {
            return type.cast(this.target);
        }
        return null;
    }

    public void addListener(TargetablePanelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TargetablePanelListener listener) {
        this.listeners.remove(listener);
    }

    protected abstract void targetSet();

    protected final void fireTargetModified() {
        assert (this.target != null) : "Null target";
        for (TargetablePanelListener listener : this.listeners) {
            listener.targetModified(this);
        }
    }

    private final void fireTargetChanged() {
        for (TargetablePanelListener listener : this.listeners) {
            listener.targetChanged(this);
        }
    }
}

