/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;

public class StringUtils {
    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNonEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    public static String toDelimitedList(double[] array, String delimiter) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                builder.append(delimiter);
            }
            builder.append(array[i]);
        }
        return builder.toString();
    }

    public static String toDelimitedList(Iterable<?> iterable, String delimiter) {
        if (iterable == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Object obj : iterable) {
            if (builder.length() > 0) {
                builder.append(delimiter);
            }
            builder.append(obj);
        }
        return builder.toString();
    }

    public static String toQuotedDelimitedList(Iterable<?> iterable, String delimiter, String quote) {
        StringBuilder builder = new StringBuilder();
        for (Object obj : iterable) {
            if (builder.length() > 0) {
                builder.append(delimiter);
            }
            builder.append(quote);
            builder.append(obj);
            builder.append(quote);
        }
        return builder.toString();
    }

    public static Collection<String> split(String str, String regex, boolean trim, Collection<String> result) {
        String[] splitStr;
        if (str == null) {
            return result;
        }
        for (String part : splitStr = str.split(regex)) {
            result.add(trim ? part.trim() : part);
        }
        return result;
    }

    public static String encodeDimension(Dimension dimension) {
        assert (dimension != null) : "dimension is null";
        return dimension.width + "," + dimension.height;
    }

    public static Dimension decodeDimension(String str) {
        if (str == null) {
            return null;
        }
        String[] components = str.split(",");
        if (components.length == 2) {
            return new Dimension(Integer.valueOf(components[0]), Integer.valueOf(components[1]));
        }
        return null;
    }

    public static String encodeRectangle(Rectangle rectangle) {
        assert (rectangle != null) : "rectangle is null";
        return rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height;
    }

    public static Rectangle decodeRectangle(String str) {
        assert (str != null) : "str is null";
        String[] components = str.split(",");
        if (components.length == 4) {
            return new Rectangle(Integer.valueOf(components[0]), Integer.valueOf(components[1]), Integer.valueOf(components[2]), Integer.valueOf(components[3]));
        }
        return null;
    }

    public static String encodePoint(Point point) {
        assert (point != null) : "point is null";
        return point.x + "," + point.y;
    }

    public static Point decodePoint(String str) {
        if (str == null) {
            return null;
        }
        String[] components = str.split(",");
        if (components.length == 2) {
            return new Point(Integer.valueOf(components[0]), Integer.valueOf(components[1]));
        }
        return null;
    }

    public static String[] decodeStringArray(String encoded, String delimiter) {
        if (encoded == null) {
            return null;
        }
        String[] parts = encoded.split(delimiter);
        return parts;
    }

    public static double[] decodeDoubleArray(String encoded, String delimiter) {
        if (encoded == null) {
            return null;
        }
        String[] parts = encoded.split(delimiter);
        double[] result = new double[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            result[i] = Double.valueOf(parts[i]);
        }
        return result;
    }

    public static float[] decodeFloatArray(String encoded, String delimiter) {
        if (encoded == null) {
            return null;
        }
        String[] parts = encoded.split(delimiter);
        float[] result = new float[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            result[i] = Float.valueOf(parts[i]).floatValue();
        }
        return result;
    }

    public static double[] decodeDoubleArray(String str) {
        return StringUtils.decodeDoubleArray(str, ",");
    }

    public static float[] decodeFloatArray(String str) {
        return StringUtils.decodeFloatArray(str, ",");
    }
}

