/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util;

import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SimplePrint {
    private final ExecutorService printThread = Executors.newSingleThreadExecutor();
    private static SimplePrint INSTANCE = new SimplePrint();

    public static SimplePrint getInstance() {
        return INSTANCE;
    }

    public void printWithDialog(Printable printable) {
        final PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(printable);
        boolean ok = job.printDialog();
        if (ok) {
            this.printThread.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        job.print();
                    }
                    catch (PrinterException ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
    }

    public void printWithDialog(Pageable pageable) {
        final PrinterJob job = PrinterJob.getPrinterJob();
        job.setPageable(pageable);
        boolean ok = job.printDialog();
        if (ok) {
            this.printThread.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        job.print();
                    }
                    catch (PrinterException ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
    }

    private SimplePrint() {
    }
}

