/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util;

import com.sodiumarc.patchwork.util.MathUtils;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public class Rectangle4d {
    public static String SEPARATOR = ",";
    public static Rectangle4d UNIT_RECTANGLE = new Rectangle4d(0.0, 0.0, 1.0, 1.0);
    private final double x;
    private final double y;
    private final double width;
    private final double height;

    public static Rectangle4d combine(Rectangle4d ... rectangles) {
        return Rectangle4d.combine(Arrays.asList(rectangles));
    }

    public static Rectangle4d combine(Iterable<Rectangle4d> rectangles) {
        Rectangle4d result = null;
        for (Rectangle4d rectangle : rectangles) {
            if (result == null) {
                result = new Rectangle4d(rectangle);
                continue;
            }
            result = result.combine(rectangle);
        }
        return result;
    }

    public Rectangle4d(Dimension d) {
        this(0.0, 0.0, d.getWidth(), d.getHeight());
    }

    public Rectangle4d(Rectangle rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public Rectangle4d(Rectangle4d r) {
        this(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public Rectangle4d(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle4d(Point2D.Double min, Point2D.Double max) {
        this(min.x, min.y, max.x - min.x, max.y - min.y);
    }

    public Rectangle4d(String encodedForm) {
        String[] components = encodedForm.split(SEPARATOR);
        assert (components.length == 4) : "Wrong number of components: " + components.length;
        this.x = Double.valueOf(components[0]);
        this.y = Double.valueOf(components[1]);
        this.width = Double.valueOf(components[2]);
        this.height = Double.valueOf(components[3]);
    }

    public Rectangle2D asRectangle2D() {
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
    }

    public Rectangle asAWTRectangle() {
        return new Rectangle((int)this.x, (int)this.y, (int)this.getWidth(), (int)this.getHeight());
    }

    public Point2D.Double getMinCorner() {
        return new Point2D.Double(this.x, this.y);
    }

    public Rectangle getBounds() {
        return this.asRectangle2D().getBounds();
    }

    public Dimension getSize() {
        return new Dimension((int)this.getWidth(), (int)this.getHeight());
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getXMin() {
        return this.x;
    }

    public double getYMin() {
        return this.y;
    }

    public double getXMax() {
        return this.x + this.width;
    }

    public double getYMax() {
        return this.y + this.height;
    }

    public double getXCenter() {
        return this.x + this.width / 2.0;
    }

    public double getYCenter() {
        return this.y + this.height / 2.0;
    }

    public boolean contains(Point2D.Double point) {
        return point.x >= this.x && point.x - this.x <= this.width && point.y >= this.y && point.y - this.y <= this.height;
    }

    public String encode() {
        return this.x + "," + this.y + "," + this.width + "," + this.height;
    }

    public Rectangle4d offset(double x, double y) {
        return new Rectangle4d(this.x + x, this.y + y, this.width, this.height);
    }

    public Rectangle4d combine(Rectangle4d other) {
        double xMin = Math.min(this.getXMin(), other.getXMin());
        double xMax = Math.max(this.getXMax(), other.getXMax());
        double yMin = Math.min(this.getYMin(), other.getYMin());
        double yMax = Math.max(this.getYMax(), other.getYMax());
        return new Rectangle4d(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    public Rectangle4d toProportional(Rectangle4d other) {
        double x = MathUtils.rangeFraction(other.getXMin(), this.getXMin(), this.getXMax());
        double y = MathUtils.rangeFraction(other.getYMin(), this.getYMin(), this.getYMax());
        double width = other.getWidth() / this.getWidth();
        double height = other.getHeight() / this.getHeight();
        return new Rectangle4d(x, y, width, height);
    }

    public Rectangle4d fromProportional(Rectangle4d other) {
        double x = MathUtils.interpolate(other.getXMin(), this.getXMin(), this.getXMax());
        double y = MathUtils.interpolate(other.getYMin(), this.getYMin(), this.getYMax());
        double width = other.getWidth() * this.getWidth();
        double height = other.getHeight() * this.getHeight();
        return new Rectangle4d(x, y, width, height);
    }

    public Point2D.Double toProportional(Point2D.Double point) {
        double x = MathUtils.rangeFraction(point.x, this.getXMin(), this.getXMax());
        double y = MathUtils.rangeFraction(point.y, this.getYMin(), this.getYMax());
        return new Point2D.Double(x, y);
    }

    public Point2D.Double fromProportional(Point2D.Double point) {
        double x = MathUtils.interpolate(point.x, this.getXMin(), this.getXMax());
        double y = MathUtils.interpolate(point.y, this.getYMin(), this.getYMax());
        return new Point2D.Double(x, y);
    }

    public Rectangle4d transform(AffineTransform transform) {
        Point2D.Double minCorner = (Point2D.Double)transform.transform(new Point2D.Double(this.getXMin(), this.getYMin()), new Point2D.Double());
        Point2D.Double maxCorner = (Point2D.Double)transform.transform(new Point2D.Double(this.getXMax(), this.getYMax()), new Point2D.Double());
        return new Rectangle4d(minCorner, maxCorner);
    }

    public Rectangle4d interpolate(Rectangle4d other, double interpFraction) {
        double x = MathUtils.interpolate(interpFraction, this.getX(), other.getX());
        double y = MathUtils.interpolate(interpFraction, this.getY(), other.getY());
        double width = MathUtils.interpolate(interpFraction, this.getWidth(), other.getWidth());
        double height = MathUtils.interpolate(interpFraction, this.getHeight(), other.getHeight());
        return new Rectangle4d(x, y, width, height);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.encode() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.height);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.width);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rectangle4d other = (Rectangle4d)obj;
        if (Double.doubleToLongBits(this.height) != Double.doubleToLongBits(other.height)) {
            return false;
        }
        if (Double.doubleToLongBits(this.width) != Double.doubleToLongBits(other.width)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }
}

