/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util;

public class MathUtils {
    public static int clamp(int value, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("min > max");
        }
        return Math.max(Math.min(value, max), min);
    }

    public static float clamp(float value, float min, float max) {
        if (min > max) {
            throw new IllegalArgumentException("min > max");
        }
        return Math.max(Math.min(value, max), min);
    }

    public static double clamp(double value, double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException("min > max");
        }
        return Math.max(Math.min(value, max), min);
    }

    public static int modulus(int a, int modulus) {
        int remainder = a % modulus;
        return remainder < 0 ? remainder + modulus : remainder;
    }

    public static double degreesToRadians(double degrees) {
        return degrees / 360.0 * 6.2831854820251465;
    }

    public static double rangeFraction(double x, double start, double end) {
        if (end == start) {
            return 0.0;
        }
        return (x - start) / (end - start);
    }

    public static double interpolate(double fraction, double start, double end) {
        return start + fraction * (end - start);
    }

    public static boolean epsilonEquals(double a, double b, double epsilon) {
        return Math.abs(a - b) <= epsilon;
    }

    public static double snap(double value, double snapTo, double threshhold) {
        return MathUtils.epsilonEquals(value, snapTo, threshhold) ? snapTo : value;
    }

    public static boolean epsilonEquals(int a, int b, int epsilon) {
        return Math.abs(b - a) <= epsilon;
    }

    public static boolean between(int a, int rangeStart, int rangeEnd) {
        return a >= Math.min(rangeStart, rangeEnd) && a <= Math.max(rangeStart, rangeEnd);
    }
}

