/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class LabeledRowPanel
extends JPanel {
    public LabeledRowPanel() {
        this((String)null);
    }

    public LabeledRowPanel(String title) {
        super(new GridBagLayout());
        if (title != null) {
            TitledBorder titleBorder = BorderFactory.createTitledBorder(title);
            Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
            this.setBorder(BorderFactory.createCompoundBorder(titleBorder, emptyBorder));
        }
    }

    public LabeledRowPanel(String title, List<LabeledRow> rows) {
        this(title);
        this.setRows(rows);
    }

    public LabeledRowPanel(List<LabeledRow> rows) {
        this(null, rows);
    }

    protected final void setRows(List<LabeledRow> rows) {
        this.removeAll();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.gridy = 0;
        for (LabeledRow row : rows) {
            constraints.fill = row.isFill() ? 2 : 0;
            constraints.gridx = 0;
            constraints.weightx = 0.0;
            Component label = row.getLabel();
            if (label != null) {
                this.add(label, constraints);
            }
            constraints.gridx = 1;
            constraints.weightx = 1.0;
            this.add(row.getComponent(), constraints);
            ++constraints.gridy;
        }
    }

    public static class LabeledRow {
        private final Component label;
        private final Component component;
        private final boolean fill;

        public LabeledRow(Component label, Component component, boolean fill) {
            this.label = label;
            this.component = component;
            this.fill = fill;
        }

        public LabeledRow(Component label, Component component) {
            this(label, component, false);
        }

        public LabeledRow(String label, Component component, boolean fill) {
            this(new JLabel(label), component, fill);
        }

        public LabeledRow(String label, Component component) {
            this(new JLabel(label), component, false);
        }

        public Component getLabel() {
            return this.label;
        }

        public Component getComponent() {
            return this.component;
        }

        public boolean isFill() {
            return this.fill;
        }

        public void setEnabled(boolean enabled) {
            if (this.label != null) {
                this.label.setEnabled(enabled);
            }
            if (this.component != null) {
                this.component.setEnabled(enabled);
            }
        }

        public void setLabelText(String text) {
            if (this.label instanceof JLabel) {
                ((JLabel)this.label).setText(text);
            }
        }
    }
}

