/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public abstract class DialogBase
extends JDialog {
    private final Map<Object, JButton> buttons;
    private JButton closeButton;
    private final Dimension size;
    private Component mainComponent;

    public DialogBase(Window owner, String title, Dialog.ModalityType modalityType, Dimension size) {
        super(owner, title, modalityType);
        this.size = size;
        this.buttons = new HashMap<Object, JButton>();
        this.setDefaultCloseOperation(1);
    }

    public void showDialog() {
        this.showDialog(null);
    }

    public void showDialog(Component relativeTo) {
        this.setLocationRelativeTo(relativeTo);
        this.setVisible(true);
    }

    public final Component getMainComponent() {
        return this.mainComponent;
    }

    protected abstract Iterable<?> getButtons();

    protected abstract void updateControlEnabling();

    protected abstract void onButtonPress(Object var1);

    protected final void setButtonEnabled(Object key, boolean enabled) {
        this.buttons.get(key).setEnabled(enabled);
    }

    protected final void setMainComponent(Component mainComponent) {
        this.mainComponent = mainComponent;
        this.setContentPane(this.createContentPane(mainComponent));
        this.updateControlEnabling();
        this.pack();
        if (this.size != null) {
            this.setSize(this.size);
        }
        if (this.closeButton != null) {
            this.getRootPane().setDefaultButton(this.closeButton);
        }
    }

    private Container createContentPane(Component mainArea) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(mainArea, "Center");
        panel.add(this.createButtonPanel(), "South");
        return panel;
    }

    private Component createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout());
        Iterable<?> buttonKeys = this.getButtons();
        if (buttonKeys != null) {
            for (Object buttonKey : buttonKeys) {
                JButton button = new JButton(buttonKey.toString());
                buttonPanel.add(button);
                this.buttons.put(buttonKey, button);
                final Object buttonKeyF = buttonKey;
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        DialogBase.this.onButtonPress(buttonKeyF);
                    }
                });
            }
        } else {
            this.closeButton = new JButton("Close");
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    DialogBase.this.setVisible(false);
                }
            });
            buttonPanel.add(this.closeButton);
        }
        return buttonPanel;
    }
}

