/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util;

import com.sodiumarc.patchwork.util.ColorComponent;
import com.sodiumarc.patchwork.util.MathUtils;
import java.awt.Color;
import java.util.Map;
import javax.vecmath.Color3f;

public class ColorUtils {
    public static final Color CLEAR_COLOR = new Color(0, 0, 0, 0);

    public static Color toColor(int intARGB) {
        return new Color((intARGB & 0xFF0000) >> 16, (intARGB & 0xFF00) >> 8, intARGB & 0xFF, intARGB >>> 24);
    }

    public static Color decodeHexString(String hex) {
        long longARGB = Long.decode(hex);
        return new Color((int)((longARGB & 0xFF0000L) >> 16), (int)((longARGB & 0xFF00L) >> 8), (int)(longARGB & 0xFFL), (int)(longARGB >>> 24));
    }

    public static Color toColor(Map<ColorComponent, Integer> components) {
        return new Color(ColorUtils.clampComponent(components.get((Object)ColorComponent.RED)), ColorUtils.clampComponent(components.get((Object)ColorComponent.GREEN)), ColorUtils.clampComponent(components.get((Object)ColorComponent.BLUE)), ColorUtils.clampComponent(components.get((Object)ColorComponent.ALPHA)));
    }

    public static Color toColor(Color3f color) {
        return new Color(ColorUtils.clampComponent((int)(color.x * 255.0f)), ColorUtils.clampComponent((int)(color.y * 255.0f)), ColorUtils.clampComponent((int)(color.z * 255.0f)), 255);
    }

    public static Color newColor(int red, int green, int blue, int alpha) {
        return new Color(ColorUtils.clampComponent(red), ColorUtils.clampComponent(green), ColorUtils.clampComponent(blue), ColorUtils.clampComponent(alpha));
    }

    public static int toIntARGB(int alpha, int red, int green, int blue) {
        return ColorUtils.clampComponent(alpha) << 24 | ColorUtils.clampComponent(red) << 16 | ColorUtils.clampComponent(green) << 8 | ColorUtils.clampComponent(blue);
    }

    public static int toIntARGB(Color color) {
        return ColorUtils.toIntARGB(color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue());
    }

    public static int toIntARGB(Color3f color) {
        return ColorUtils.toIntARGB(255, ColorUtils.clampComponent((int)(color.x * 255.0f)), ColorUtils.clampComponent((int)(color.y * 255.0f)), ColorUtils.clampComponent((int)(color.z * 255.0f)));
    }

    public static int getComponent(Color color, ColorComponent component) {
        switch (component) {
            case RED: {
                return color.getRed();
            }
            case GREEN: {
                return color.getGreen();
            }
            case BLUE: {
                return color.getBlue();
            }
            case ALPHA: {
                return color.getAlpha();
            }
        }
        throw new RuntimeException("Unrecognized component");
    }

    public static int getComponent(int intARGB, ColorComponent component) {
        switch (component) {
            case ALPHA: {
                return intARGB >>> 24;
            }
            case RED: {
                return (intARGB & 0xFF0000) >> 16;
            }
            case GREEN: {
                return (intARGB & 0xFF00) >> 8;
            }
            case BLUE: {
                return intARGB & 0xFF;
            }
        }
        throw new RuntimeException("Unrecognized component");
    }

    public static int setComponent(int intARGB, ColorComponent component, int value) {
        int maskedComponent = value & 0xFF;
        switch (component) {
            case ALPHA: {
                return intARGB & 0xFFFFFF | maskedComponent << 24;
            }
            case RED: {
                return intARGB & 0xFF00FFFF | maskedComponent << 16;
            }
            case GREEN: {
                return intARGB & 0xFFFF00FF | maskedComponent << 8;
            }
            case BLUE: {
                return intARGB & 0xFFFFFF00 | maskedComponent;
            }
        }
        throw new RuntimeException("Unrecognized component");
    }

    public static Color getErrorColor(Color sourceColor, int maxError) {
        int error = -maxError + (int)(Math.random() * 2.0 * (double)maxError);
        return new Color(ColorUtils.clampComponent(sourceColor.getRed() + error), ColorUtils.clampComponent(sourceColor.getGreen() + error), ColorUtils.clampComponent(sourceColor.getBlue() + error), sourceColor.getAlpha());
    }

    public static int getIntensity(Color color) {
        return (color.getRed() + color.getGreen() + color.getBlue()) / 3;
    }

    public static int getIntensity(int colorARGB) {
        return (ColorUtils.getComponent(colorARGB, ColorComponent.RED) + ColorUtils.getComponent(colorARGB, ColorComponent.GREEN) + ColorUtils.getComponent(colorARGB, ColorComponent.BLUE)) / 3;
    }

    public static int toPremultiplied(int colorARGB) {
        float multiplier = (float)ColorUtils.getComponent(colorARGB, ColorComponent.ALPHA) / 255.0f;
        int result = colorARGB;
        for (ColorComponent component : ColorComponent.RGB_ONLY) {
            int multiplied = (int)(multiplier * (float)ColorUtils.getComponent(colorARGB, component));
            result = ColorUtils.setComponent(result, component, multiplied);
        }
        return result;
    }

    public static int fromPremultplied(int colorARGB) {
        float multiplier = 255.0f / (float)ColorUtils.getComponent(colorARGB, ColorComponent.ALPHA);
        int result = colorARGB;
        for (ColorComponent component : ColorComponent.RGB_ONLY) {
            int multiplied = (int)(multiplier * (float)ColorUtils.getComponent(colorARGB, component));
            result = ColorUtils.setComponent(result, component, multiplied);
        }
        return result;
    }

    public static int blend(int colorARGB0, int colorARGB1, float color1Weight) {
        color1Weight = MathUtils.clamp(color1Weight, 0.0f, 1.0f);
        int result = 0;
        for (ColorComponent component : ColorComponent.values()) {
            int blended = (int)MathUtils.interpolate(color1Weight, ColorUtils.getComponent(colorARGB0, component), ColorUtils.getComponent(colorARGB1, component));
            result = ColorUtils.setComponent(result, component, blended);
            assert (blended == ColorUtils.getComponent(result, component));
        }
        return result;
    }

    public static Color blend(Color color0, Color color1, float color1Weight) {
        return ColorUtils.toColor(ColorUtils.blend(ColorUtils.toIntARGB(color0), ColorUtils.toIntARGB(color1), color1Weight));
    }

    public static int clampComponent(int component) {
        return MathUtils.clamp(component, 0, 255);
    }

    public static Color randomColor() {
        return new Color(ColorUtils.clampComponent((int)(Math.random() * 255.0)), ColorUtils.clampComponent((int)(Math.random() * 255.0)), ColorUtils.clampComponent((int)(Math.random() * 255.0)), 255);
    }

    public static Color randomGreyscaleColor() {
        int value = ColorUtils.clampComponent((int)(Math.random() * 255.0));
        return new Color(value, value, value, 255);
    }

    public static boolean epsilonEqualsColor(Color color0, Color color1, int epsilon) {
        return MathUtils.epsilonEquals(color0.getAlpha(), color1.getAlpha(), epsilon) && MathUtils.epsilonEquals(color0.getRed(), color1.getRed(), epsilon) && MathUtils.epsilonEquals(color0.getGreen(), color1.getGreen(), epsilon) && MathUtils.epsilonEquals(color0.getBlue(), color1.getBlue(), epsilon);
    }

    public static boolean epsilonEqualsColor(int colorARGB0, int colorARGB1, int epsilon) {
        for (ColorComponent component : ColorComponent.values()) {
            if (MathUtils.epsilonEquals(ColorUtils.getComponent(colorARGB0, component), ColorUtils.getComponent(colorARGB1, component), epsilon)) continue;
            return false;
        }
        return true;
    }
}

