/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util.Collection;

public class Range<T extends Comparable<T>> {
    private final T _min;
    private final T _max;

    public static Range<Integer> decodeIntegerRange(String str) {
        if (str == null) {
            return null;
        }
        String[] components = str.split(",");
        if (components.length == 2) {
            return new Range<Integer>(Integer.valueOf(components[0]), Integer.valueOf(components[1]));
        }
        return null;
    }

    public Range(T min, T max) {
        assert (min != null);
        assert (max != null);
        assert (min.compareTo(max) <= 0);
        this._min = min;
        this._max = max;
    }

    public T getMin() {
        return this._min;
    }

    public T getMax() {
        return this._max;
    }

    public boolean contains(T value) {
        return this.getMax().compareTo(value) >= 0 && this.getMin().compareTo(value) <= 0;
    }

    public boolean overlaps(Range<T> other) {
        return this.contains(other.getMin()) || this.contains(other.getMax()) || other.contains(this.getMax());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._min + "," + this._max + "]";
    }
}

